/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.japanese;

import com.google.common.base.Predicate;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.blocks.DoTBBlocks;
import org.dawnoftimebuilder.blocks.IBlockCustomItem;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.items.DoTBItems;
import org.dawnoftimebuilder.items.japanese.ItemTatamiMat;

public class BlockTatamiMat
extends DoTBBlock
implements IBlockCustomItem {
    private static final AxisAlignedBB CARPET_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    public static final PropertyEnum<EnumPartType> PART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockTatamiMat(String name) {
        super(name, Material.field_151580_n);
        this.setBurnable();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(PART, (Comparable)((Object)EnumPartType.FOOT)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CARPET_AABB;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PART});
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151650_B;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (state.func_177229_b(PART) == EnumPartType.FOOT) {
            if (worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                return;
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c() != this) {
            if (!worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
            worldIn.func_175698_g(pos);
            return;
        }
        this.checkForDrop(worldIn, pos, state);
        this.tryMergingWithSprucePlanks(worldIn, pos, state);
    }

    private void tryMergingWithSprucePlanks(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        IBlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
        Block blockDown = stateDown.func_177230_c();
        IBlockState stateDownAdjacent = worldIn.func_180495_p(pos.func_177972_a(facing).func_177977_b());
        Block blockDownAdjacent = stateDownAdjacent.func_177230_c();
        if (blockDownAdjacent == Blocks.field_150344_f && blockDown == Blocks.field_150344_f && stateDown.func_177229_b((IProperty)BlockPlanks.field_176383_a) == BlockPlanks.EnumType.SPRUCE && stateDownAdjacent.func_177229_b((IProperty)BlockPlanks.field_176383_a) == BlockPlanks.EnumType.SPRUCE) {
            worldIn.func_175698_g(pos);
            worldIn.func_175698_g(pos.func_177972_a(facing));
            worldIn.func_175656_a(pos.func_177977_b(), DoTBBlocks.tatami_floor.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a(PART, state.func_177229_b(PART)));
            worldIn.func_175656_a(pos.func_177972_a(facing).func_177977_b(), DoTBBlocks.tatami_floor.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a(PART, state.func_177229_b(PART)));
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
        boolean solidFloor = stateDown.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) != BlockFaceShape.UNDEFINED;
        return solidFloor && stateDown.func_177230_c() != DoTBBlocks.tatami_floor && stateDown.func_177230_c() != DoTBBlocks.small_tatami_floor;
    }

    private void checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(PART) == EnumPartType.FOOT ? Items.field_190931_a : DoTBItems.tatami_mat;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing facing) {
        return facing == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(DoTBItems.tatami_mat);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(PART) == EnumPartType.FOOT && worldIn.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177230_c() == this) {
            worldIn.func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        return (meta & 4) > 0 ? this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.HEAD)).func_177226_a((IProperty)FACING, (Comparable)enumfacing) : this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.FOOT)).func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (state.func_177229_b(PART) == EnumPartType.HEAD) {
            i |= 4;
        }
        return i;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public Item getCustomItemBlock() {
        return ((Item)new ItemTatamiMat().setRegistryName(Objects.requireNonNull(this.getRegistryName()))).func_77655_b(this.func_149739_a());
    }

    public static enum EnumPartType implements IStringSerializable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

