/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.japanese;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.blocks.IBlockCustomItem;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.enums.EnumsBlock;
import org.dawnoftimebuilder.items.japanese.ItemSpruceRoofSupport;

public class BlockSpruceRoofSupport
extends DoTBBlock
implements IBlockCustomItem {
    private static final AxisAlignedBB AABB_HALF = new AxisAlignedBB(0.0, 0.6875, 0.0, 1.0, 1.0, 1.0);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final PropertyEnum<EnumsBlock.EnumStairsShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumsBlock.EnumStairsShape.class);

    public BlockSpruceRoofSupport(String name) {
        super(name, Material.field_151575_d, 1.0f, SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.STRAIGHT)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, SHAPE});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_HALF;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(SHAPE, (Comparable)((Object)this.getShape(state, worldIn, pos)));
    }

    private EnumsBlock.EnumStairsShape getShape(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facingOpposite;
        EnumFacing facingAdjacent;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockSpruceRoofSupport block = (BlockSpruceRoofSupport)state.func_177230_c();
        IBlockState stateAdjacent = worldIn.func_180495_p(pos.func_177972_a(facing));
        if (stateAdjacent.func_177230_c() == this && (facingAdjacent = (EnumFacing)stateAdjacent.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && block.isNotConnectible(state, worldIn, pos, facingAdjacent.func_176734_d())) {
            if (facingAdjacent == facing.func_176735_f()) {
                return EnumsBlock.EnumStairsShape.OUTER_LEFT;
            }
            return EnumsBlock.EnumStairsShape.OUTER_RIGHT;
        }
        IBlockState stateOpposite = worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        if (stateOpposite.func_177230_c() == this && (facingOpposite = (EnumFacing)stateOpposite.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && block.isNotConnectible(state, worldIn, pos, facingOpposite)) {
            if (facingOpposite == facing.func_176735_f()) {
                return EnumsBlock.EnumStairsShape.INNER_LEFT;
            }
            return EnumsBlock.EnumStairsShape.INNER_RIGHT;
        }
        return EnumsBlock.EnumStairsShape.STRAIGHT;
    }

    private boolean isNotConnectible(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing direction) {
        IBlockState stateAdjacent = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (stateAdjacent.func_177230_c() != this) {
            return true;
        }
        return stateAdjacent.func_177229_b((IProperty)FACING) != state.func_177229_b((IProperty)FACING);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public Item getCustomItemBlock() {
        return new ItemSpruceRoofSupport();
    }
}

