/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.japanese;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.blocks.general.DoTBBlockFence;

public class BlockSpruceRailing
extends DoTBBlockFence {
    private static final PropertyEnum<EnumPillar> PILLAR = PropertyEnum.func_177709_a((String)"pillar", EnumPillar.class);

    public BlockSpruceRailing() {
        super("spruce_railing", Material.field_151575_d, 2.0f, SoundType.field_185848_a);
        this.setBurnable();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176525_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176526_a, (Comparable)Boolean.valueOf(false)).func_177226_a(PILLAR, (Comparable)((Object)EnumPillar.NONE)).func_177226_a((IProperty)field_176527_M, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176528_N, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176525_b, field_176526_a, PILLAR, field_176527_M, field_176528_N});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(PILLAR, (Comparable)((Object)(facing.func_176740_k().func_176720_b() ? EnumPillar.PILLAR_BIG : EnumPillar.NONE)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing facing) {
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return BlockFaceShape.UNDEFINED;
        }
        return this.hasNoPillar(state) ? BlockFaceShape.UNDEFINED : BlockFaceShape.CENTER_BIG;
    }

    public boolean func_176524_e(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState state = worldIn.func_180495_p(pos);
        BlockFaceShape shape = state.func_193401_d(worldIn, pos, facing);
        Block block = state.func_177230_c();
        return !BlockSpruceRailing.func_194142_e((Block)block) && shape == BlockFaceShape.SOLID || block instanceof BlockSpruceRailing || shape == BlockFaceShape.MIDDLE_POLE && block instanceof BlockFenceGate;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.hasNoPillar(state = super.func_176221_a(state, worldIn, pos))) {
            return state;
        }
        if ((((Boolean)state.func_177229_b((IProperty)field_176525_b)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)field_176528_N)).booleanValue()) && (((Boolean)state.func_177229_b((IProperty)field_176526_a)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)field_176527_M)).booleanValue())) {
            if (!worldIn.func_175623_d(pos.func_177984_a())) {
                return state.func_177226_a(PILLAR, (Comparable)((Object)EnumPillar.PILLAR_BIG));
            }
            return state.func_177226_a(PILLAR, (Comparable)((Object)EnumPillar.CAP_PILLAR_BIG));
        }
        return state.func_177226_a(PILLAR, (Comparable)((Object)EnumPillar.PILLAR_SMALL));
    }

    public int func_176201_c(IBlockState state) {
        return this.hasNoPillar(state) ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PILLAR, (Comparable)((Object)(meta == 0 ? EnumPillar.NONE : EnumPillar.PILLAR_BIG)));
    }

    private boolean hasNoPillar(IBlockState state) {
        return state.func_177229_b(PILLAR) == EnumPillar.NONE;
    }

    public EnumPillar getShape(IBlockState state) {
        return (EnumPillar)((Object)state.func_177229_b(PILLAR));
    }

    public static enum EnumPillar implements IStringSerializable
    {
        NONE("none"),
        PILLAR_BIG("pillar_big"),
        PILLAR_SMALL("pillar_small"),
        CAP_PILLAR_BIG("cap_pillar_big");

        private final String name;

        private EnumPillar(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

