/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.japanese;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.general.DoTBBlockTileEntity;
import org.dawnoftimebuilder.entities.EntitySeat;

public class BlockSpruceLeglessChair
extends DoTBBlockTileEntity {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 0.1875, 1.0);
    private static final AxisAlignedBB BACK_AABB = new AxisAlignedBB(0.125, 0.25, 0.75, 0.875, 0.6875, 1.0);

    public BlockSpruceLeglessChair() {
        super("spruce_legless_chair", Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : BlockSpruceLeglessChair.getCollisionBoxList(state)) {
            BlockSpruceLeglessChair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DoTBUtils.getMainAABB(BlockSpruceLeglessChair.getCollisionBoxList(this.func_176221_a(state, source, pos)));
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        list.add(DoTBUtils.getRotatedAABB(BOTTOM_AABB, (EnumFacing)state.func_177229_b((IProperty)FACING)));
        list.add(DoTBUtils.getRotatedAABB(BACK_AABB, (EnumFacing)state.func_177229_b((IProperty)FACING)));
        return list;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return BlockSpruceLeglessChair.isSomeoneSitting(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) ? 1 : 0;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!playerIn.func_70093_af() && BlockSpruceLeglessChair.sitOnChair(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.0, (EnumFacing)state.func_177229_b((IProperty)FACING), -0.1)) {
            worldIn.func_175666_e(pos, (Block)this);
            return true;
        }
        return false;
    }

    public static boolean sitOnChair(World world, double x, double y, double z, EntityPlayer player, double yOffset, EnumFacing facing, double rotationOffset) {
        if (!(world.field_72995_K || player.func_70093_af() || BlockSpruceLeglessChair.checkForExistingSeat(world, x, y, z, player))) {
            EntitySeat seat = new EntitySeat(world, x, y, z, yOffset, facing, rotationOffset);
            world.func_72838_d((Entity)seat);
            player.func_184220_m((Entity)seat);
        }
        return true;
    }

    private static boolean checkForExistingSeat(World world, double x, double y, double z, EntityPlayer player) {
        if (!world.field_72995_K) {
            List seats = world.func_72872_a(EntitySeat.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_186662_g(1.0));
            for (EntitySeat seat : seats) {
                if ((double)seat.blockPosX != x || (double)seat.blockPosY != y || (double)seat.blockPosZ != z) continue;
                if (!seat.func_184207_aI()) {
                    player.func_184220_m((Entity)seat);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isSomeoneSitting(World world, double x, double y, double z) {
        if (!world.field_72995_K) {
            List seats = world.func_72872_a(EntitySeat.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_186662_g(1.0));
            for (EntitySeat seat : seats) {
                if ((double)seat.blockPosX != x || (double)seat.blockPosY != y || (double)seat.blockPosZ != z) continue;
                return seat.func_184207_aI();
            }
        }
        return false;
    }
}

