/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.general;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.blocks.general.DoTBBlockBeam;
import org.dawnoftimebuilder.blocks.general.DoTBBlockWall;
import org.dawnoftimebuilder.blocks.japanese.BlockSpruceRailing;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class DoTBBlockSupportSlab
extends DoTBBlock {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_FOUR_PX = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.75, 0.625);
    private static final AxisAlignedBB AABB_EIGHT_PX = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);
    private static final AxisAlignedBB AABB_TEN_PX = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.75, 0.8125);
    private static final PropertyEnum<EnumsBlock.EnumUnderConnection> UNDER = PropertyEnum.func_177709_a((String)"under", EnumsBlock.EnumUnderConnection.class);

    public DoTBBlockSupportSlab(String name, Material materialIn, float hardness, SoundType sound) {
        super(name, materialIn, hardness, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.NOTHING)));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(state)) {
            DoTBBlockSupportSlab.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DoTBUtils.getMainAABB(this.getCollisionBoxList(this.func_176221_a(state, source, pos)));
    }

    public List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        list.add(AABB);
        switch ((EnumsBlock.EnumUnderConnection)((Object)state.func_177229_b(UNDER))) {
            case FOUR_PX: {
                list.add(AABB_FOUR_PX);
                break;
            }
            case EIGHT_PX: {
                list.add(AABB_EIGHT_PX);
                break;
            }
            case TEN_PX: {
                list.add(AABB_TEN_PX);
                break;
            }
        }
        return list;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UNDER});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Block blockUnder = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (blockUnder instanceof BlockSpruceRailing) {
            BlockSpruceRailing block = (BlockSpruceRailing)blockUnder;
            switch (block.getShape(worldIn.func_180495_p(pos.func_177977_b()))) {
                case NONE: {
                    return state.func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.NOTHING));
                }
                case PILLAR_SMALL: {
                    return state.func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.FOUR_PX));
                }
            }
            return state.func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.EIGHT_PX));
        }
        if (blockUnder instanceof BlockFence) {
            return state.func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.FOUR_PX));
        }
        if (blockUnder instanceof BlockWall || blockUnder instanceof DoTBBlockWall) {
            return state.func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.EIGHT_PX));
        }
        if (blockUnder instanceof DoTBBlockBeam && ((EnumFacing.Axis)worldIn.func_180495_p(pos.func_177977_b()).func_177229_b(DoTBBlockBeam.MAIN_AXIS)).func_176720_b()) {
            return state.func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.TEN_PX));
        }
        return state.func_177226_a(UNDER, (Comparable)((Object)EnumsBlock.EnumUnderConnection.NOTHING));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing side) {
        switch (side) {
            case DOWN: {
                state = this.func_176221_a(state, worldIn, pos);
                switch ((EnumsBlock.EnumUnderConnection)((Object)state.func_177229_b(UNDER))) {
                    case FOUR_PX: {
                        return BlockFaceShape.CENTER;
                    }
                    case EIGHT_PX: 
                    case TEN_PX: {
                        return BlockFaceShape.CENTER_BIG;
                    }
                }
                return BlockFaceShape.UNDEFINED;
            }
            case UP: {
                return BlockFaceShape.SOLID;
            }
        }
        return BlockFaceShape.UNDEFINED;
    }
}

