/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.general;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class DoTBBlockPortcullis
extends DoTBBlock {
    private static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    private static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private static final PropertyEnum<EnumsBlock.EnumHorizontalAxis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumsBlock.EnumHorizontalAxis.class);
    private static final PropertyEnum<EnumsBlock.EnumVerticalConnection> VERTICAL_CONNECTION = PropertyEnum.func_177709_a((String)"vertical_connection", EnumsBlock.EnumVerticalConnection.class);
    private static final AxisAlignedBB X_AXIS_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    private static final AxisAlignedBB Z_AXIS_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    private static final AxisAlignedBB VOID_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public DoTBBlockPortcullis(String name, Material materialIn, float hardness, SoundType sound) {
        super(name, materialIn, hardness, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a(AXIS, (Comparable)((Object)EnumsBlock.EnumHorizontalAxis.AXIS_X)).func_177226_a(VERTICAL_CONNECTION, (Comparable)((Object)EnumsBlock.EnumVerticalConnection.NONE)));
    }

    public DoTBBlockPortcullis(String name, Material materialIn) {
        super(name, materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a(AXIS, (Comparable)((Object)EnumsBlock.EnumHorizontalAxis.AXIS_X)).func_177226_a(VERTICAL_CONNECTION, (Comparable)((Object)EnumsBlock.EnumVerticalConnection.NONE)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{OPEN, POWERED, AXIS, VERTICAL_CONNECTION});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)(state = this.func_176221_a(state, source, pos)).func_177229_b((IProperty)OPEN)).booleanValue() && state.func_177229_b(VERTICAL_CONNECTION) != EnumsBlock.EnumVerticalConnection.NONE && state.func_177229_b(VERTICAL_CONNECTION) != EnumsBlock.EnumVerticalConnection.UNDER) {
            return VOID_AABB;
        }
        return state.func_177229_b(AXIS) == EnumsBlock.EnumHorizontalAxis.AXIS_X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)(state = this.func_176221_a(state, source, pos)).func_177229_b((IProperty)OPEN) != false && state.func_177229_b(VERTICAL_CONNECTION) != EnumsBlock.EnumVerticalConnection.NONE && state.func_177229_b(VERTICAL_CONNECTION) != EnumsBlock.EnumVerticalConnection.UNDER ? field_185506_k : (state.func_177229_b(AXIS) == EnumsBlock.EnumHorizontalAxis.AXIS_X ? X_AXIS_AABB : Z_AXIS_AABB);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(VERTICAL_CONNECTION, (Comparable)((Object)this.getShape(worldIn, pos, (EnumsBlock.EnumHorizontalAxis)((Object)state.func_177229_b(AXIS)))));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumsBlock.EnumHorizontalAxis axis;
        if ((state = state.func_185899_b((IBlockAccess)worldIn, pos)).func_177229_b(VERTICAL_CONNECTION) == EnumsBlock.EnumVerticalConnection.UNDER) {
            EnumsBlock.EnumHorizontalAxis axis2 = (EnumsBlock.EnumHorizontalAxis)((Object)state.func_177229_b(AXIS));
            boolean isNowPowered = worldIn.func_175640_z(pos);
            if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                if (this.isInSamePlane(pos, fromPos, axis2) && isNowPowered) {
                    this.setOpenState(worldIn, pos, axis2, true);
                }
            } else if (isNowPowered) {
                this.setOpenState(worldIn, pos, axis2, true);
                state = state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
            }
            if (!isNowPowered && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
                worldIn.func_180501_a(pos, state, 2);
                if (!this.hasAnotherPowerSource(worldIn, pos, axis2)) {
                    this.setOpenState(worldIn, pos, axis2, false);
                }
            }
            if (isNowPowered != (Boolean)state.func_177229_b((IProperty)POWERED)) {
                state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(isNowPowered));
                worldIn.func_180501_a(pos, state, 2);
            }
        } else if (state.func_177229_b(VERTICAL_CONNECTION) == EnumsBlock.EnumVerticalConnection.NONE) {
            if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)), 2);
            }
        } else if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue() && this.isInSamePlane(pos, fromPos, axis = (EnumsBlock.EnumHorizontalAxis)((Object)state.func_177229_b(AXIS)))) {
            pos = this.getTopPortcullisPos(worldIn, pos, axis);
            worldIn.func_180495_p(pos).func_189546_a(worldIn, pos, blockIn, fromPos);
        }
    }

    private boolean hasSameAxis(IBlockState state, EnumsBlock.EnumHorizontalAxis axis) {
        if (state.func_177230_c() instanceof DoTBBlockPortcullis) {
            return state.func_177229_b(AXIS) == axis;
        }
        return false;
    }

    private boolean isInSamePlane(BlockPos pos, BlockPos fromPos, EnumsBlock.EnumHorizontalAxis axis) {
        if (axis == EnumsBlock.EnumHorizontalAxis.AXIS_X) {
            return fromPos.func_177952_p() == pos.func_177952_p();
        }
        return fromPos.func_177958_n() == pos.func_177958_n();
    }

    private BlockPos getTopPortcullisPos(World worldIn, BlockPos pos, EnumsBlock.EnumHorizontalAxis axis) {
        boolean isStillPortcullis = true;
        while (isStillPortcullis) {
            IBlockState state = worldIn.func_180495_p(pos);
            if (state.func_177230_c() instanceof DoTBBlockPortcullis) {
                if (!this.hasSameAxis(state, axis)) {
                    isStillPortcullis = false;
                }
            } else {
                isStillPortcullis = false;
            }
            pos = pos.func_177984_a();
        }
        return pos.func_177977_b();
    }

    private boolean hasAnotherPowerSource(World worldIn, BlockPos pos, EnumsBlock.EnumHorizontalAxis axis) {
        boolean isAxisX = axis == EnumsBlock.EnumHorizontalAxis.AXIS_X;
        EnumFacing direction = isAxisX ? EnumFacing.WEST : EnumFacing.NORTH;
        int widthLeft = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? EnumFacing.EAST : EnumFacing.SOUTH);
        int widthRight = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? EnumFacing.WEST : EnumFacing.NORTH);
        pos = pos.func_177967_a(direction, -widthLeft);
        for (int i = 0; i <= widthLeft + widthRight; ++i) {
            IBlockState state = worldIn.func_180495_p(pos.func_177967_a(direction, i));
            if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void setOpenState(World worldIn, BlockPos pos, EnumsBlock.EnumHorizontalAxis axis, boolean openState) {
        IBlockState state;
        boolean isAxisX = axis == EnumsBlock.EnumHorizontalAxis.AXIS_X;
        EnumFacing direction = isAxisX ? EnumFacing.WEST : EnumFacing.NORTH;
        int height = this.getPortcullisHeight(worldIn, pos, axis);
        int widthLeft = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? EnumFacing.EAST : EnumFacing.SOUTH);
        int widthRight = this.getPortcullisWidth(worldIn, pos, axis, isAxisX ? EnumFacing.WEST : EnumFacing.NORTH);
        if (height > 16 || widthLeft + widthRight + 1 > 16) {
            return;
        }
        if (openState) {
            int vertical;
            int horizontal;
            for (horizontal = 1; horizontal <= widthLeft; ++horizontal) {
                for (vertical = 0; vertical < height; ++vertical) {
                    state = worldIn.func_180495_p(pos.func_177967_a(isAxisX ? EnumFacing.EAST : EnumFacing.SOUTH, horizontal).func_177979_c(vertical));
                    if (state.func_177230_c() instanceof DoTBBlockPortcullis) {
                        if (state.func_177229_b(AXIS) == axis) continue;
                        openState = false;
                        break;
                    }
                    openState = false;
                    break;
                }
                if (!openState) break;
            }
            if (openState) {
                for (horizontal = 1; horizontal <= widthRight; ++horizontal) {
                    for (vertical = 0; vertical < height; ++vertical) {
                        state = worldIn.func_180495_p(pos.func_177967_a(direction, horizontal).func_177979_c(vertical));
                        if (state.func_177230_c() instanceof DoTBBlockPortcullis) {
                            if (state.func_177229_b(AXIS) == axis) continue;
                            openState = false;
                            break;
                        }
                        openState = false;
                        break;
                    }
                    if (!openState) break;
                }
            }
            if (openState) {
                openState = this.isCorrectBorder(worldIn, pos.func_177967_a(direction, -widthLeft).func_177984_a(), axis, isAxisX ? EnumFacing.WEST : EnumFacing.NORTH, widthLeft + widthRight);
                openState = openState && this.isCorrectBorder(worldIn, pos.func_177967_a(direction, -widthLeft).func_177979_c(height), axis, isAxisX ? EnumFacing.WEST : EnumFacing.NORTH, widthLeft + widthRight);
                openState = openState && this.isCorrectBorder(worldIn, pos.func_177967_a(direction, -widthLeft - 1), axis, EnumFacing.DOWN, height - 1);
                openState = openState && this.isCorrectBorder(worldIn, pos.func_177967_a(direction, widthRight + 1), axis, EnumFacing.DOWN, height - 1);
            }
        }
        pos = pos.func_177967_a(direction, -widthLeft);
        for (int horizontal = 0; horizontal < widthLeft + widthRight + 1; ++horizontal) {
            for (int vertical = 0; vertical < height; ++vertical) {
                BlockPos newPos = pos.func_177967_a(direction, horizontal).func_177979_c(vertical);
                state = worldIn.func_180495_p(newPos);
                if (!(state.func_177230_c() instanceof DoTBBlockPortcullis) || state.func_177229_b(AXIS) != axis) continue;
                worldIn.func_180501_a(newPos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(openState)), 10);
                worldIn.func_175704_b(newPos, newPos);
                if (horizontal != widthLeft) continue;
                if (vertical == 0 && openState) {
                    worldIn.func_180498_a(null, this.getOpenSound(), newPos, 0);
                }
                if (vertical != height - 1 || openState) continue;
                worldIn.func_180498_a(null, this.getCloseSound(), newPos, 0);
            }
        }
    }

    private int getPortcullisHeight(World worldIn, BlockPos pos, EnumsBlock.EnumHorizontalAxis axis) {
        int height = 0;
        boolean isSamePortcullis = true;
        while (isSamePortcullis) {
            IBlockState state = worldIn.func_180495_p(pos = pos.func_177977_b());
            if (state.func_177230_c() instanceof DoTBBlockPortcullis) {
                if (state.func_177229_b(AXIS) != axis) {
                    isSamePortcullis = false;
                }
            } else {
                isSamePortcullis = false;
            }
            ++height;
        }
        return height;
    }

    private int getPortcullisWidth(World worldIn, BlockPos pos, EnumsBlock.EnumHorizontalAxis axis, EnumFacing direction) {
        int width = 0;
        boolean isSamePortcullis = true;
        while (isSamePortcullis) {
            IBlockState state = worldIn.func_180495_p(pos = pos.func_177972_a(direction));
            if (state.func_177230_c() instanceof DoTBBlockPortcullis) {
                if (state.func_177229_b(AXIS) != axis) {
                    isSamePortcullis = false;
                }
            } else {
                isSamePortcullis = false;
            }
            ++width;
        }
        return width - 1;
    }

    private boolean isCorrectBorder(World worldIn, BlockPos pos, EnumsBlock.EnumHorizontalAxis axis, EnumFacing direction, int length) {
        for (int i = 0; i <= length; ++i) {
            IBlockState state = worldIn.func_180495_p(pos.func_177967_a(direction, i));
            if (!(state.func_177230_c() instanceof DoTBBlockPortcullis) || state.func_177229_b(AXIS) != axis) continue;
            return false;
        }
        return true;
    }

    private int getCloseSound() {
        return 1011;
    }

    private int getOpenSound() {
        return 1005;
    }

    private EnumsBlock.EnumVerticalConnection getShape(IBlockAccess worldIn, BlockPos pos, EnumsBlock.EnumHorizontalAxis axis) {
        if (this.hasSameAxis(worldIn.func_180495_p(pos.func_177984_a()), axis)) {
            return this.hasSameAxis(worldIn.func_180495_p(pos.func_177977_b()), axis) ? EnumsBlock.EnumVerticalConnection.BOTH : EnumsBlock.EnumVerticalConnection.ABOVE;
        }
        return this.hasSameAxis(worldIn.func_180495_p(pos.func_177977_b()), axis) ? EnumsBlock.EnumVerticalConnection.UNDER : EnumsBlock.EnumVerticalConnection.NONE;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((Object)(placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.Z ? EnumsBlock.EnumHorizontalAxis.AXIS_X : EnumsBlock.EnumHorizontalAxis.AXIS_Z)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.MIDDLE_POLE_THIN;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (state.func_177229_b(AXIS) == EnumsBlock.EnumHorizontalAxis.AXIS_Z) {
            meta += 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            meta += 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            ++meta;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta >= 4) {
            state = state.func_177226_a(AXIS, (Comparable)((Object)EnumsBlock.EnumHorizontalAxis.AXIS_Z));
            meta -= 4;
        }
        if (meta >= 2) {
            state = state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(true));
            meta -= 2;
        }
        if (meta >= 1) {
            state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = this.func_176221_a(worldIn.func_180495_p(pos), worldIn, pos);
        return (Boolean)state.func_177229_b((IProperty)OPEN) != false && state.func_177229_b(VERTICAL_CONNECTION) != EnumsBlock.EnumVerticalConnection.NONE && state.func_177229_b(VERTICAL_CONNECTION) != EnumsBlock.EnumVerticalConnection.UNDER;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

