/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.general;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class DoTBBlockPlate
extends DoTBBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final PropertyEnum<EnumsBlock.EnumStairsShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumsBlock.EnumStairsShape.class);
    private static final AxisAlignedBB AABB_HLF_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
    private static final AxisAlignedBB AABB_QTR_NW = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 0.5);

    public DoTBBlockPlate(String name, Material materialIn, float hardness, SoundType sound) {
        super(name, materialIn, hardness, sound);
        this.field_149783_u = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.STRAIGHT)));
        this.func_149713_g(255);
    }

    public DoTBBlockPlate(String name) {
        this(name, Material.field_151576_e, 1.5f, SoundType.field_185851_d);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, SHAPE});
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : DoTBBlockPlate.getCollisionBoxList(state)) {
            DoTBBlockPlate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DoTBUtils.getMainAABB(DoTBBlockPlate.getCollisionBoxList(this.func_176221_a(state, source, pos)));
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumsBlock.EnumStairsShape shape = (EnumsBlock.EnumStairsShape)((Object)state.func_177229_b(SHAPE));
        switch (shape) {
            default: {
                list.add(DoTBUtils.getRotatedAABB(AABB_HLF_NORTH, facing));
                break;
            }
            case OUTER_LEFT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_QTR_NW, facing));
                break;
            }
            case OUTER_RIGHT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_QTR_NW, facing.func_176746_e()));
                break;
            }
            case INNER_LEFT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_HLF_NORTH, facing));
                list.add(DoTBUtils.getRotatedAABB(AABB_QTR_NW, facing.func_176735_f()));
                break;
            }
            case INNER_RIGHT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_HLF_NORTH, facing));
                list.add(DoTBUtils.getRotatedAABB(AABB_QTR_NW, facing.func_176734_d()));
            }
        }
        return list;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing facing) {
        EnumsBlock.EnumStairsShape shape = (EnumsBlock.EnumStairsShape)((Object)(state = this.func_176221_a(state, worldIn, pos)).func_177229_b(SHAPE));
        if (shape != EnumsBlock.EnumStairsShape.OUTER_LEFT && shape != EnumsBlock.EnumStairsShape.OUTER_RIGHT) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                return BlockFaceShape.UNDEFINED;
            }
            switch (shape) {
                case INNER_RIGHT: {
                    return enumfacing != facing && enumfacing != facing.func_176735_f() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
                }
                case INNER_LEFT: {
                    return enumfacing != facing && enumfacing != facing.func_176746_e() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
                }
                case STRAIGHT: {
                    return enumfacing == facing ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
                }
            }
            return BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(SHAPE, (Comparable)((Object)DoTBBlockPlate.getVerticalSlabShape(state, worldIn, pos)));
    }

    private static EnumsBlock.EnumStairsShape getVerticalSlabShape(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facingOpposite;
        EnumFacing facingAdjacent;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        DoTBBlockPlate block = (DoTBBlockPlate)state.func_177230_c();
        IBlockState stateAdjacent = worldIn.func_180495_p(pos.func_177972_a(facing));
        if (stateAdjacent.func_177230_c() instanceof DoTBBlockPlate && (facingAdjacent = (EnumFacing)stateAdjacent.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && block.isNotConnectible(state, worldIn, pos, facingAdjacent.func_176734_d())) {
            if (facingAdjacent == facing.func_176735_f()) {
                return EnumsBlock.EnumStairsShape.OUTER_LEFT;
            }
            return EnumsBlock.EnumStairsShape.OUTER_RIGHT;
        }
        IBlockState stateOpposite = worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        if (stateOpposite.func_177230_c() instanceof DoTBBlockPlate && (facingOpposite = (EnumFacing)stateOpposite.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && block.isNotConnectible(state, worldIn, pos, facingOpposite)) {
            if (facingOpposite == facing.func_176735_f()) {
                return EnumsBlock.EnumStairsShape.INNER_LEFT;
            }
            return EnumsBlock.EnumStairsShape.INNER_RIGHT;
        }
        return EnumsBlock.EnumStairsShape.STRAIGHT;
    }

    private boolean isNotConnectible(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing direction) {
        IBlockState stateAdjacent = worldIn.func_180495_p(pos.func_177972_a(direction));
        return !DoTBBlockPlate.isConnectibleWithDoTPlate(stateAdjacent) || stateAdjacent.func_177229_b((IProperty)FACING) != state.func_177229_b((IProperty)FACING);
    }

    private static boolean isConnectibleWithDoTPlate(IBlockState state) {
        return state.func_177230_c() instanceof DoTBBlockPlate;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.STRAIGHT));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumsBlock.EnumStairsShape shape = (EnumsBlock.EnumStairsShape)((Object)state.func_177229_b(SHAPE));
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.Z) break;
                switch (shape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_LEFT));
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_LEFT));
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_RIGHT));
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.X) break;
                switch (shape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_LEFT));
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_RIGHT));
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_LEFT));
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return state;
    }
}

