/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.general;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.dawnoftimebuilder.blocks.general.DoTBBlockSoilCrops;
import org.dawnoftimebuilder.enums.EnumsBlock;
import org.dawnoftimebuilder.items.general.DoTBItemDoubleCropsSeed;

public abstract class DoTBBlockDoubleCrops
extends DoTBBlockSoilCrops {
    public static final PropertyEnum<EnumsBlock.EnumHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumsBlock.EnumHalf.class);

    public DoTBBlockDoubleCrops(String name, Block soilBlock, String seedName) {
        super(name, soilBlock, seedName);
        this.func_180632_j(this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.BOTTOM)));
    }

    public DoTBBlockDoubleCrops(String name, Block soilBlock) {
        this(name, soilBlock, name);
    }

    protected void func_176475_e(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            this.destroyPlant(pos, worldIn);
        }
    }

    @Override
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos bottomCrop = this.getBottomCrop((IBlockAccess)worldIn, pos);
        if (bottomCrop.equals((Object)pos)) {
            boolean hasTopCrop;
            boolean bl = hasTopCrop = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
            if (!hasTopCrop && this.func_185527_x(state) >= this.getAgeReachingTopBlock()) {
                return false;
            }
            return super.func_180671_f(worldIn, pos, state);
        }
        return pos.func_177956_o() - bottomCrop.func_177956_o() == 1;
    }

    private void destroyPlant(BlockPos pos, World world) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        float f;
        int i;
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && (i = this.func_185527_x(state)) < this.func_185526_g() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt((int)(25.0f / (f = DoTBBlockDoubleCrops.func_180672_a((Block)this, (World)worldIn, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
            this.tryGrow(worldIn, pos, state, i + 1);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    public void func_176487_g(World worldIn, BlockPos pos, IBlockState state) {
        if (this.isBottomCrop((IBlockAccess)worldIn, pos)) {
            int j;
            int i = this.func_185527_x(state) + this.func_185529_b(worldIn);
            if (i > (j = this.func_185526_g())) {
                i = j;
            }
            this.tryGrow(worldIn, pos, state, i);
        } else {
            BlockPos bottomCrop = this.getBottomCrop((IBlockAccess)worldIn, pos);
            this.func_176487_g(worldIn, bottomCrop, worldIn.func_180495_p(bottomCrop));
        }
    }

    private void tryGrow(World worldIn, BlockPos pos, IBlockState state, int i) {
        if (this.isBottomCrop((IBlockAccess)worldIn, pos)) {
            boolean canGrow = true;
            if (i >= this.getAgeReachingTopBlock()) {
                canGrow = false;
                BlockPos topPos = pos.func_177984_a();
                IBlockState topCrop = worldIn.func_180495_p(topPos);
                if (topCrop.func_177230_c() == this) {
                    worldIn.func_180501_a(topPos, this.setAge(topCrop.func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.TOP)), i), 2);
                    canGrow = true;
                } else if (worldIn.func_175623_d(topPos)) {
                    worldIn.func_180501_a(topPos, this.setAge(this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.TOP)), i), 2);
                    canGrow = true;
                }
            }
            if (canGrow) {
                worldIn.func_180501_a(pos, this.setAge(state.func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.BOTTOM)), i), 2);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean top = state.func_177229_b(HALF) == EnumsBlock.EnumHalf.TOP;
        return new AxisAlignedBB(0.0, top ? -1.0 : 0.0, 0.0, 1.0, this.getCropHeightAtAge((Integer)state.func_177229_b((IProperty)field_176488_a)) + (top ? -1.0 : 0.0), 1.0);
    }

    private double getCropHeightAtAge(int age) {
        return (double)(age + 1) * 0.25;
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.destroyPlant(pos, worldIn);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.destroyPlant(pos, worldIn);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.isBottomCrop(world, pos) && state.func_177229_b(HALF) == EnumsBlock.EnumHalf.BOTTOM) {
            this.getDoubleCropsDrops(drops, world, pos, state, fortune);
        }
    }

    public void getDoubleCropsDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
    }

    public IBlockState setAge(IBlockState state, int age) {
        return state.func_177226_a((IProperty)field_176488_a, (Comparable)Integer.valueOf(age));
    }

    public boolean isBottomCrop(IBlockAccess world, BlockPos pos) {
        return pos.equals((Object)this.getBottomCrop(world, pos));
    }

    private BlockPos getBottomCrop(IBlockAccess world, BlockPos pos) {
        BlockPos bottom = pos;
        while (world.func_180495_p(bottom.func_177972_a(EnumFacing.DOWN)).func_177230_c() == this) {
            bottom = bottom.func_177972_a(EnumFacing.DOWN);
        }
        return bottom;
    }

    public IBlockState func_176203_a(int meta) {
        EnumsBlock.EnumHalf half = EnumsBlock.EnumHalf.BOTTOM;
        if ((meta & 1) > 0) {
            half = EnumsBlock.EnumHalf.TOP;
        }
        return this.func_185528_e(meta >>= 1).func_177226_a(HALF, (Comparable)((Object)half));
    }

    public int func_176201_c(IBlockState state) {
        boolean top = state.func_177229_b(HALF) == EnumsBlock.EnumHalf.TOP;
        int meta = this.func_185527_x(state);
        meta <<= 1;
        if (top) {
            meta |= 1;
        }
        return meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176488_a, HALF});
    }

    @Override
    public Item getCustomItemBlock() {
        return ((Item)new DoTBItemDoubleCropsSeed(this).setRegistryName("dawnoftimebuilder", this.getSeedName())).func_77655_b("dawnoftimebuilder." + this.getSeedName());
    }

    public abstract int getAgeReachingTopBlock();
}

