/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.general;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.blocks.general.DoTBBlockSupportBeam;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class DoTBBlockBeam
extends DoTBBlock {
    private static final AxisAlignedBB AABB_AXIS_X = new AxisAlignedBB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75);
    private static final AxisAlignedBB AABB_AXIS_Y = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
    private static final AxisAlignedBB AABB_AXIS_Z = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0);
    private static final AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);
    private static final PropertyBool BOTTOM = PropertyBool.func_177716_a((String)"bottom");
    static final PropertyEnum<EnumFacing.Axis> MAIN_AXIS = PropertyEnum.func_177709_a((String)"main_axis", EnumFacing.Axis.class);
    private static final PropertyBool SUBAXIS_X = PropertyBool.func_177716_a((String)"subaxis_x");
    private static final PropertyBool SUBAXIS_Z = PropertyBool.func_177716_a((String)"subaxis_z");

    public DoTBBlockBeam(String name, Material materialIn, float hardness, SoundType sound) {
        super(name, materialIn, hardness, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(false)).func_177226_a(MAIN_AXIS, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)SUBAXIS_X, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SUBAXIS_Z, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BOTTOM, MAIN_AXIS, SUBAXIS_X, SUBAXIS_Z});
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : DoTBBlockBeam.getCollisionBoxList(state)) {
            DoTBBlockBeam.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DoTBUtils.getMainAABB(DoTBBlockBeam.getCollisionBoxList(this.func_176221_a(state, source, pos)));
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        switch ((EnumFacing.Axis)state.func_177229_b(MAIN_AXIS)) {
            case X: {
                list.add(AABB_AXIS_X);
                break;
            }
            default: {
                list.add(AABB_AXIS_Y);
                break;
            }
            case Z: {
                list.add(AABB_AXIS_Z);
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            list.add(AABB_BOTTOM);
        }
        if (((Boolean)state.func_177229_b((IProperty)SUBAXIS_X)).booleanValue()) {
            list.add(AABB_AXIS_X);
        }
        if (((Boolean)state.func_177229_b((IProperty)SUBAXIS_Z)).booleanValue()) {
            list.add(AABB_AXIS_Z);
        }
        return list;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(MAIN_AXIS, (Comparable)facing.func_176740_k());
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        if (side.func_176740_k().func_176720_b() && ((EnumFacing.Axis)state.func_177229_b(MAIN_AXIS)).func_176720_b()) {
            return BlockFaceShape.CENTER_BIG;
        }
        if (side.func_176740_k() == EnumFacing.Axis.X && (state.func_177229_b(MAIN_AXIS) == EnumFacing.Axis.X || ((Boolean)state.func_177229_b((IProperty)SUBAXIS_X)).booleanValue())) {
            return BlockFaceShape.CENTER_BIG;
        }
        if (side.func_176740_k() == EnumFacing.Axis.Z && (state.func_177229_b(MAIN_AXIS) == EnumFacing.Axis.Z || ((Boolean)state.func_177229_b((IProperty)SUBAXIS_Z)).booleanValue())) {
            return BlockFaceShape.CENTER_BIG;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((EnumFacing.Axis)state.func_177229_b(MAIN_AXIS)).func_176720_b();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (((EnumFacing.Axis)state.func_177229_b(MAIN_AXIS)).func_176722_c()) {
            return state;
        }
        boolean bottom = false;
        boolean subAxisX = false;
        boolean subAxisZ = false;
        if (this.canConnect(worldIn, pos, EnumFacing.EAST) || this.canConnect(worldIn, pos, EnumFacing.WEST)) {
            subAxisX = true;
        }
        if (this.canConnect(worldIn, pos, EnumFacing.NORTH) || this.canConnect(worldIn, pos, EnumFacing.SOUTH)) {
            subAxisZ = true;
        }
        if (!this.isConnectibleBeam(worldIn.func_180495_p(pos.func_177977_b()), EnumFacing.DOWN)) {
            bottom = true;
        }
        return state.func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(bottom)).func_177226_a((IProperty)SUBAXIS_X, (Comparable)Boolean.valueOf(subAxisX)).func_177226_a((IProperty)SUBAXIS_Z, (Comparable)Boolean.valueOf(subAxisZ));
    }

    private boolean canConnect(IBlockAccess world, BlockPos pos, EnumFacing direction) {
        IBlockState state = world.func_180495_p(pos.func_177972_a(direction));
        return this.isConnectibleBeam(state, direction) || this.isConnectibleSupportBeam(state, direction) || this.isConnectibleBeam(state, direction) || this.isConnectibleSupportBeam(state, direction);
    }

    private boolean isConnectibleBeam(IBlockState state, EnumFacing direction) {
        if (state.func_177230_c() instanceof DoTBBlockBeam) {
            return state.func_177229_b(MAIN_AXIS) == direction.func_176740_k() || state.func_177229_b(MAIN_AXIS) == EnumFacing.Axis.Y;
        }
        return false;
    }

    private boolean isConnectibleSupportBeam(IBlockState state, EnumFacing direction) {
        if (state.func_177230_c() instanceof DoTBBlockSupportBeam) {
            return state.func_177229_b(DoTBBlockSupportBeam.AXIS) == EnumsBlock.EnumHorizontalAxis.getHorizontalAxis(direction);
        }
        return false;
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumFacing.Axis)state.func_177229_b(MAIN_AXIS)) {
            default: {
                return 0;
            }
            case X: {
                return 1;
            }
            case Z: 
        }
        return 2;
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            default: {
                return this.func_176223_P();
            }
            case 1: {
                return this.func_176223_P().func_177226_a(MAIN_AXIS, (Comparable)EnumFacing.Axis.X);
            }
            case 2: 
        }
        return this.func_176223_P().func_177226_a(MAIN_AXIS, (Comparable)EnumFacing.Axis.Z);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

