/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.general;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.blocks.general.DoTBBlockColumn;
import org.dawnoftimebuilder.blocks.japanese.BlockStickBundle;
import org.dawnoftimebuilder.blocks.japanese.BlockStoneLantern;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class BlockIronChain
extends DoTBBlockColumn {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockIronChain() {
        super("iron_chain", Material.field_151573_f, 2.0f, SoundType.field_185852_e);
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        list.add(AABB);
        return list;
    }

    @Override
    public EnumsBlock.EnumVerticalConnection getShape(IBlockAccess worldIn, BlockPos pos) {
        if (this.isSameColumn(worldIn, pos.func_177984_a())) {
            return this.canConnectToBottom(worldIn, pos.func_177977_b()) ? EnumsBlock.EnumVerticalConnection.BOTH : EnumsBlock.EnumVerticalConnection.ABOVE;
        }
        return this.canConnectToBottom(worldIn, pos.func_177977_b()) ? EnumsBlock.EnumVerticalConnection.UNDER : EnumsBlock.EnumVerticalConnection.NONE;
    }

    private boolean canConnectToBottom(IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block instanceof BlockStoneLantern && worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockStoneLantern.FACING) == EnumFacing.DOWN) {
            return true;
        }
        if (block instanceof BlockStickBundle) {
            return true;
        }
        return this.isSameColumn(worldIn, pos);
    }

    @Override
    public boolean isSameColumn(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() instanceof BlockIronChain;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

