/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.general;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class BlockFireplace
extends DoTBBlock {
    private static final PropertyBool AXIS_X = PropertyBool.func_177716_a((String)"axis_x");
    private static final PropertyEnum<EnumsBlock.EnumHorizontalConnection> HORIZONTAL_CONNECTION = PropertyEnum.func_177709_a((String)"horizontal_connection", EnumsBlock.EnumHorizontalConnection.class);
    private static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");
    private static final AxisAlignedBB ON_X_AABB = new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.875, 0.875);
    private static final AxisAlignedBB OFF_X_AABB = new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.3125, 0.875);
    private static final AxisAlignedBB ON_Z_AABB = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 0.875, 1.0);
    private static final AxisAlignedBB OFF_Z_AABB = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 0.3125, 1.0);

    public BlockFireplace() {
        super("fireplace", Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AXIS_X, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)).func_177226_a(HORIZONTAL_CONNECTION, (Comparable)((Object)EnumsBlock.EnumHorizontalConnection.NONE)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS_X, BURNING, HORIZONTAL_CONNECTION});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)this.func_176221_a(state, source, pos).func_177229_b((IProperty)AXIS_X)).booleanValue()) {
            return (Boolean)this.func_176221_a(state, source, pos).func_177229_b((IProperty)BURNING) != false ? ON_X_AABB : OFF_X_AABB;
        }
        return (Boolean)this.func_176221_a(state, source, pos).func_177229_b((IProperty)BURNING) != false ? ON_Z_AABB : OFF_Z_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)this.func_176221_a(state, source, pos).func_177229_b((IProperty)AXIS_X) != false ? OFF_X_AABB : OFF_Z_AABB;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState other = world.func_180495_p(pos);
        if (other.func_177230_c() != this) {
            return other.getLightValue(world, pos);
        }
        return (Boolean)state.func_177229_b((IProperty)BURNING) != false ? 15 : 0;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)AXIS_X, (Comparable)Boolean.valueOf(placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.Z)).func_177226_a(HORIZONTAL_CONNECTION, (Comparable)((Object)this.getHorizontalShape((IBlockAccess)worldIn, pos, placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.Z)));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return state.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    private EnumsBlock.EnumHorizontalConnection getHorizontalShape(IBlockAccess worldIn, BlockPos pos, boolean axisX) {
        boolean blockRight;
        IBlockState left = worldIn.func_180495_p(pos.func_177967_a(axisX ? EnumFacing.EAST : EnumFacing.SOUTH, 1));
        IBlockState right = worldIn.func_180495_p(pos.func_177967_a(axisX ? EnumFacing.EAST : EnumFacing.SOUTH, -1));
        boolean blockLeft = left.func_177230_c() instanceof BlockFireplace;
        if (blockLeft) {
            boolean bl = blockLeft = (Boolean)left.func_177229_b((IProperty)AXIS_X) == axisX;
        }
        if (blockRight = right.func_177230_c() instanceof BlockFireplace) {
            boolean bl = blockRight = (Boolean)right.func_177229_b((IProperty)AXIS_X) == axisX;
        }
        if (blockLeft) {
            return blockRight ? EnumsBlock.EnumHorizontalConnection.BOTH : EnumsBlock.EnumHorizontalConnection.LEFT;
        }
        return blockRight ? EnumsBlock.EnumHorizontalConnection.RIGHT : EnumsBlock.EnumHorizontalConnection.NONE;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            facing = (Boolean)state.func_177229_b((IProperty)AXIS_X) != false ? EnumFacing.EAST : EnumFacing.SOUTH;
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)), 10);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_180495_p(pos.func_177972_a(facing)).func_189546_a(worldIn, pos.func_177972_a(facing), (Block)this, pos);
            worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_189546_a(worldIn, pos.func_177972_a(facing.func_176734_d()), (Block)this, pos);
            return true;
        }
        if (!(itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151033_d && itemstack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150478_aa))) {
            facing = (Boolean)state.func_177229_b((IProperty)AXIS_X) != false ? EnumFacing.EAST : EnumFacing.SOUTH;
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(true)), 10);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_180495_p(pos.func_177972_a(facing)).func_189546_a(worldIn, pos.func_177972_a(facing), (Block)this, pos);
            worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_189546_a(worldIn, pos.func_177972_a(facing.func_176734_d()), (Block)this, pos);
            if (itemstack.func_77973_b() == Items.field_151033_d) {
                itemstack.func_77972_a(1, (EntityLivingBase)playerIn);
            } else if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        } else if (pos.func_177956_o() == fromPos.func_177956_o()) {
            boolean axisX = (Boolean)state.func_177229_b((IProperty)AXIS_X);
            if (axisX ? pos.func_177958_n() == fromPos.func_177958_n() : pos.func_177952_p() == fromPos.func_177952_p()) {
                return;
            }
            state = state.func_177226_a(HORIZONTAL_CONNECTION, (Comparable)((Object)this.getHorizontalShape((IBlockAccess)worldIn, pos, axisX)));
            IBlockState newState = worldIn.func_180495_p(fromPos);
            if (newState.func_177230_c() instanceof BlockFireplace && (Boolean)newState.func_177229_b((IProperty)AXIS_X) == axisX && newState.func_177229_b((IProperty)BURNING) != state.func_177229_b((IProperty)BURNING)) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BURNING, newState.func_177229_b((IProperty)BURNING)), 10);
                BlockPos newPos = axisX ? pos.func_177967_a(EnumFacing.EAST, pos.func_177958_n() - fromPos.func_177958_n()) : pos.func_177967_a(EnumFacing.SOUTH, pos.func_177952_p() - fromPos.func_177952_p());
                worldIn.func_180495_p(newPos).func_189546_a(worldIn, newPos, (Block)this, pos);
                return;
            }
            worldIn.func_180501_a(pos, state, 10);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)BURNING)).booleanValue()) {
            if (rand.nextInt(24) == 0) {
                worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)pos.func_177958_n() + rand.nextDouble() * 0.5 + 0.25;
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.6;
                double d2 = (double)pos.func_177952_p() + rand.nextDouble() * 0.5 + 0.25;
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta > 7) {
            state = state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(true));
            meta -= 8;
        }
        if (meta > 3) {
            state = state.func_177226_a((IProperty)AXIS_X, (Comparable)Boolean.valueOf(false));
            meta -= 4;
        }
        switch (meta) {
            case 3: {
                return state.func_177226_a(HORIZONTAL_CONNECTION, (Comparable)((Object)EnumsBlock.EnumHorizontalConnection.BOTH));
            }
            case 2: {
                return state.func_177226_a(HORIZONTAL_CONNECTION, (Comparable)((Object)EnumsBlock.EnumHorizontalConnection.LEFT));
            }
            case 1: {
                return state.func_177226_a(HORIZONTAL_CONNECTION, (Comparable)((Object)EnumsBlock.EnumHorizontalConnection.RIGHT));
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            meta += 8;
        }
        if (!((Boolean)state.func_177229_b((IProperty)AXIS_X)).booleanValue()) {
            meta += 4;
        }
        switch ((EnumsBlock.EnumHorizontalConnection)((Object)state.func_177229_b(HORIZONTAL_CONNECTION))) {
            case BOTH: {
                return meta + 3;
            }
            case LEFT: {
                return meta + 2;
            }
            case RIGHT: {
                return meta + 1;
            }
        }
        return meta;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue() && !entityIn.func_70045_F() && entityIn instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entityIn))) {
            entityIn.func_70097_a(DamageSource.field_76372_a, 1.0f);
            entityIn.func_70015_d(3);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90 ? state.func_177226_a((IProperty)AXIS_X, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)AXIS_X) == false)) : state;
    }
}

