/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.french;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.IBlockCustomItem;
import org.dawnoftimebuilder.blocks.french.BlockSmallOakShutters;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.items.DoTBItems;
import org.dawnoftimebuilder.items.french.ItemOakShutters;

public class BlockOakShutters
extends DoTBBlock
implements IBlockCustomItem {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<EnumOpenPosition> OPEN = PropertyEnum.func_177709_a((String)"open", EnumOpenPosition.class);
    public static final PropertyEnum<EnumHingePosition> HINGE = PropertyEnum.func_177709_a((String)"hinge", EnumHingePosition.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyEnum<EnumDoorHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumDoorHalf.class);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB NORTH_FULL_RIGHT_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 0.1875, 1.0, 1.0);
    private static final AxisAlignedBB NORTH_FULL_LEFT_AABB = new AxisAlignedBB(0.8125, 0.0, 0.8125, 1.0, 1.0, 1.0);

    public BlockOakShutters() {
        super("oak_shutters", Material.field_151575_d);
        this.field_149783_u = true;
        this.setBurnable();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(OPEN, (Comparable)((Object)EnumOpenPosition.CLOSED)).func_177226_a(HINGE, (Comparable)((Object)EnumHingePosition.LEFT)).func_177226_a(HALF, (Comparable)((Object)EnumDoorHalf.LOWER)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, FACING, OPEN, HINGE, POWERED});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean hinge;
        boolean bl = hinge = (state = state.func_185899_b(source, pos)).func_177229_b(HINGE) == EnumHingePosition.RIGHT;
        if (state.func_177229_b(OPEN) == EnumOpenPosition.FULL) {
            return DoTBUtils.getRotatedAABB(hinge ? NORTH_FULL_RIGHT_AABB : NORTH_FULL_LEFT_AABB, (EnumFacing)state.func_177229_b((IProperty)FACING));
        }
        return DoTBUtils.getRotatedAABB(NORTH_AABB, state.func_177229_b(OPEN) == EnumOpenPosition.CLOSED ? (EnumFacing)state.func_177229_b((IProperty)FACING) : (hinge ? ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e() : ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f()));
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_185899_b(world, pos).func_177229_b(OPEN) == EnumOpenPosition.CLOSED ? 255 : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177229_b(OPEN) != EnumOpenPosition.CLOSED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private int getCloseSound() {
        return 1012;
    }

    private int getOpenSound() {
        return 1006;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return BlockPlanks.EnumType.OAK.func_181070_c();
    }

    public static EnumOpenPosition getOpenPosition(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        pos = pos.func_177972_a(state.func_177229_b(HINGE) == EnumHingePosition.LEFT ? ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e() : ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f());
        boolean bot = !(worldIn.func_180495_p(pos).func_177230_c() instanceof BlockSmallOakShutters) && !(worldIn.func_180495_p(pos).func_177230_c() instanceof BlockOakShutters) && worldIn.func_180495_p(pos).func_185890_d(worldIn, pos) == Block.field_185506_k;
        pos = pos.func_177984_a();
        boolean top = !(worldIn.func_180495_p(pos).func_177230_c() instanceof BlockSmallOakShutters) && !(worldIn.func_180495_p(pos).func_177230_c() instanceof BlockOakShutters) && worldIn.func_180495_p(pos).func_185890_d(worldIn, pos) == Block.field_185506_k;
        return top && bot ? EnumOpenPosition.FULL : EnumOpenPosition.HALF;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        BlockPos blockpos = state.func_177229_b(HALF) == EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate = pos.equals((Object)blockpos) ? state : worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() instanceof BlockOakShutters) {
            state = iblockstate.func_177229_b(OPEN) != EnumOpenPosition.CLOSED ? iblockstate.func_177226_a(OPEN, (Comparable)((Object)EnumOpenPosition.CLOSED)) : iblockstate.func_177226_a(OPEN, (Comparable)((Object)BlockOakShutters.getOpenPosition(iblockstate, (IBlockAccess)worldIn, blockpos)));
            worldIn.func_180501_a(blockpos, state, 10);
            worldIn.func_175704_b(blockpos, pos);
            worldIn.func_180498_a(playerIn, iblockstate.func_177229_b(OPEN) == EnumOpenPosition.CLOSED ? this.getCloseSound() : this.getOpenSound(), pos, 0);
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if ((state = state.func_185899_b((IBlockAccess)worldIn, pos)).func_177229_b(HALF) == EnumDoorHalf.UPPER) {
            BlockPos posUp = pos;
            IBlockState stateUp = state;
            state = worldIn.func_180495_p(pos = pos.func_177977_b()).func_185899_b((IBlockAccess)worldIn, pos);
            if (state.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else {
                if (state != stateUp.func_177226_a(HALF, (Comparable)((Object)EnumDoorHalf.LOWER))) {
                    worldIn.func_180501_a(posUp, state.func_177226_a(HALF, (Comparable)((Object)EnumDoorHalf.UPPER)), 10);
                }
                if (fromPos != pos) {
                    state.func_189546_a(worldIn, pos, blockIn, fromPos);
                }
            }
        } else {
            EnumFacing direction;
            BlockPos posUp = pos.func_177984_a();
            IBlockState stateUp = worldIn.func_180495_p(posUp).func_185899_b((IBlockAccess)worldIn, posUp);
            boolean mustDrop = false;
            if (!(stateUp.func_177230_c() instanceof BlockOakShutters)) {
                worldIn.func_175698_g(pos);
                mustDrop = true;
            }
            if (!BlockOakShutters.canSupportShutters(worldIn, pos.func_177972_a(direction = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()).func_177972_a(state.func_177229_b(HINGE) == EnumHingePosition.LEFT ? direction.func_176735_f() : direction.func_176746_e()), direction, (EnumHingePosition)((Object)state.func_177229_b(HINGE)))) {
                worldIn.func_175698_g(pos);
                mustDrop = true;
                if (stateUp.func_177230_c() instanceof BlockOakShutters) {
                    worldIn.func_175698_g(posUp);
                }
            }
            if (mustDrop) {
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            } else {
                boolean isPowered;
                boolean bl = isPowered = worldIn.func_175640_z(pos) || worldIn.func_175640_z(posUp);
                if (blockIn != this && (isPowered || blockIn.func_176223_P().func_185897_m()) && isPowered != (Boolean)stateUp.func_177229_b((IProperty)POWERED)) {
                    worldIn.func_180501_a(posUp, stateUp.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(isPowered)), 2);
                    if (isPowered != (state.func_177229_b(OPEN) != EnumOpenPosition.CLOSED)) {
                        state = isPowered ? state.func_177226_a(OPEN, (Comparable)((Object)BlockOakShutters.getOpenPosition(stateUp, (IBlockAccess)worldIn, pos))) : state.func_177226_a(OPEN, (Comparable)((Object)EnumOpenPosition.CLOSED));
                        worldIn.func_180501_a(pos, state, 2);
                        worldIn.func_175704_b(pos, pos);
                        worldIn.func_180498_a(null, isPowered ? this.getOpenSound() : this.getCloseSound(), pos, 0);
                    } else if (state.func_177229_b(OPEN) != EnumOpenPosition.CLOSED && state.func_177229_b(OPEN) != BlockOakShutters.getOpenPosition(stateUp, (IBlockAccess)worldIn, pos)) {
                        worldIn.func_180501_a(pos, state.func_177226_a(OPEN, (Comparable)((Object)BlockOakShutters.getOpenPosition(stateUp, (IBlockAccess)worldIn, pos))), 2);
                    }
                } else if (state.func_177229_b(OPEN) != EnumOpenPosition.CLOSED && state.func_177229_b(OPEN) != BlockOakShutters.getOpenPosition(stateUp, (IBlockAccess)worldIn, pos)) {
                    worldIn.func_180501_a(pos, state.func_177226_a(OPEN, (Comparable)((Object)BlockOakShutters.getOpenPosition(stateUp, (IBlockAccess)worldIn, pos))), 2);
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(HALF) == EnumDoorHalf.UPPER ? Items.field_190931_a : this.getItem();
    }

    public static boolean canSupportShutters(World worldIn, BlockPos pos, EnumFacing direction, EnumHingePosition hinge) {
        boolean bot = worldIn.func_180495_p(pos).func_193401_d((IBlockAccess)worldIn, pos, direction) == BlockFaceShape.SOLID || worldIn.func_180495_p(pos).func_193401_d((IBlockAccess)worldIn, pos, hinge == EnumHingePosition.LEFT ? direction.func_176735_f() : direction.func_176746_e()) == BlockFaceShape.SOLID;
        pos = pos.func_177984_a();
        boolean top = worldIn.func_180495_p(pos).func_193401_d((IBlockAccess)worldIn, pos, direction) == BlockFaceShape.SOLID || worldIn.func_180495_p(pos).func_193401_d((IBlockAccess)worldIn, pos, hinge == EnumHingePosition.LEFT ? direction.func_176735_f() : direction.func_176746_e()) == BlockFaceShape.SOLID;
        return bot && top;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getItem());
    }

    private Item getItem() {
        return DoTBItems.oak_shutters;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos = pos.func_177977_b();
        BlockPos blockpos1 = pos.func_177984_a();
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == EnumDoorHalf.UPPER && worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        if (state.func_177229_b(HALF) == EnumDoorHalf.LOWER && worldIn.func_180495_p(blockpos1).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(blockpos1);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) == EnumDoorHalf.LOWER) {
            IBlockState stateUp = worldIn.func_180495_p(pos.func_177984_a());
            if (stateUp.func_177230_c() == this) {
                state = state.func_177226_a(HINGE, stateUp.func_177229_b(HINGE)).func_177226_a((IProperty)POWERED, stateUp.func_177229_b((IProperty)POWERED));
            }
            if (state.func_177229_b(OPEN) != EnumOpenPosition.CLOSED) {
                state = state.func_177226_a(OPEN, (Comparable)((Object)BlockOakShutters.getOpenPosition(state, worldIn, pos)));
            }
        } else {
            IBlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
            if (stateDown.func_177230_c() == this) {
                state = state.func_177226_a((IProperty)FACING, stateDown.func_177229_b((IProperty)FACING)).func_177226_a(OPEN, stateDown.func_177229_b(OPEN));
            }
            if (state.func_177229_b(OPEN) != EnumOpenPosition.CLOSED) {
                state = state.func_177226_a(OPEN, (Comparable)((Object)BlockOakShutters.getOpenPosition(state, worldIn, pos.func_177977_b())));
            }
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177229_b(HALF) != EnumDoorHalf.LOWER ? state : state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177231_a(HINGE);
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumDoorHalf.UPPER)).func_177226_a(HINGE, (Comparable)((Object)((meta & 1) > 0 ? EnumHingePosition.RIGHT : EnumHingePosition.LEFT))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 2) > 0)) : this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumDoorHalf.LOWER)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)).func_176735_f()).func_177226_a(OPEN, (Comparable)((Object)((meta & 4) > 0 ? EnumOpenPosition.HALF : EnumOpenPosition.CLOSED)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(HALF) == EnumDoorHalf.UPPER) {
            i |= 8;
            if (state.func_177229_b(HINGE) == EnumHingePosition.RIGHT) {
                i |= 1;
            }
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                i |= 2;
            }
        } else {
            i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e().func_176736_b();
            if (state.func_177229_b(OPEN) != EnumOpenPosition.CLOSED) {
                i |= 4;
            }
        }
        return i;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public Item getCustomItemBlock() {
        return ((Item)new ItemOakShutters().setRegistryName(this.getRegistryName())).func_77655_b(this.func_149739_a());
    }

    public static enum EnumOpenPosition implements IStringSerializable
    {
        CLOSED,
        HALF,
        FULL;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == CLOSED ? "closed" : (this == HALF ? "half" : "full");
        }
    }

    public static enum EnumHingePosition implements IStringSerializable
    {
        LEFT,
        RIGHT;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == LEFT ? "left" : "right";
        }
    }

    public static enum EnumDoorHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

