/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.french;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class BlockLimestoneFireplace
extends DoTBBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final PropertyEnum<EnumsBlock.EnumVerticalConnection> VERTICAL_CONNECTION = PropertyEnum.func_177709_a((String)"vertical_connection", EnumsBlock.EnumVerticalConnection.class);
    private static final PropertyEnum<EnumsBlock.EnumHorizontalConnection> HORIZONTAL_CONNECTION = PropertyEnum.func_177709_a((String)"horizontal_connection", EnumsBlock.EnumHorizontalConnection.class);
    private static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");
    private static final AxisAlignedBB SMALL_AABB = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB BIG_AABB = new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);

    public BlockLimestoneFireplace() {
        super("limestone_fireplace", Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)).func_177226_a(VERTICAL_CONNECTION, (Comparable)((Object)EnumsBlock.EnumVerticalConnection.NONE)).func_177226_a(HORIZONTAL_CONNECTION, (Comparable)((Object)EnumsBlock.EnumHorizontalConnection.NONE)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, VERTICAL_CONNECTION, HORIZONTAL_CONNECTION, BURNING});
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DoTBUtils.getRotatedAABB(this.func_176221_a(state, source, pos).func_177229_b(VERTICAL_CONNECTION) == EnumsBlock.EnumVerticalConnection.NONE ? SMALL_AABB : BIG_AABB, (EnumFacing)state.func_177229_b((IProperty)FACING));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState other = world.func_180495_p(pos);
        if (other.func_177230_c() != this) {
            return other.getLightValue(world, pos);
        }
        return (Boolean)state.func_177229_b((IProperty)BURNING) != false ? 15 : 0;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return state.func_177226_a(VERTICAL_CONNECTION, (Comparable)((Object)this.getVerticalShape(worldIn, pos, facing))).func_177226_a(HORIZONTAL_CONNECTION, (Comparable)((Object)this.getHorizontalShape(worldIn, pos, facing)));
    }

    private EnumsBlock.EnumVerticalConnection getVerticalShape(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        boolean blockDown;
        IBlockState up = worldIn.func_180495_p(pos.func_177984_a());
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        boolean blockUp = up.func_177230_c() instanceof BlockLimestoneFireplace;
        if (blockUp) {
            boolean bl = blockUp = up.func_177229_b((IProperty)FACING) == facing;
        }
        if (blockDown = down.func_177230_c() instanceof BlockLimestoneFireplace) {
            boolean bl = blockDown = down.func_177229_b((IProperty)FACING) == facing;
        }
        if (blockUp) {
            return blockDown ? EnumsBlock.EnumVerticalConnection.BOTH : EnumsBlock.EnumVerticalConnection.ABOVE;
        }
        return blockDown ? EnumsBlock.EnumVerticalConnection.UNDER : EnumsBlock.EnumVerticalConnection.NONE;
    }

    private EnumsBlock.EnumHorizontalConnection getHorizontalShape(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        boolean blockRight;
        IBlockState left = worldIn.func_180495_p(pos.func_177972_a(facing.func_176735_f()));
        IBlockState right = worldIn.func_180495_p(pos.func_177972_a(facing.func_176746_e()));
        boolean blockLeft = left.func_177230_c() instanceof BlockLimestoneFireplace;
        if (blockLeft) {
            boolean bl = blockLeft = left.func_177229_b((IProperty)FACING) == facing;
        }
        if (blockRight = right.func_177230_c() instanceof BlockLimestoneFireplace) {
            boolean bl = blockRight = right.func_177229_b((IProperty)FACING) == facing;
        }
        if (blockLeft) {
            return blockRight ? EnumsBlock.EnumHorizontalConnection.BOTH : EnumsBlock.EnumHorizontalConnection.LEFT;
        }
        return blockRight ? EnumsBlock.EnumHorizontalConnection.RIGHT : EnumsBlock.EnumHorizontalConnection.NONE;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        if ((state = this.func_176221_a(state, (IBlockAccess)worldIn, pos)).func_177229_b(VERTICAL_CONNECTION) != EnumsBlock.EnumVerticalConnection.BOTH && state.func_177229_b(VERTICAL_CONNECTION) != EnumsBlock.EnumVerticalConnection.UNDER) {
            if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
                facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)), 10);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_180495_p(pos.func_177972_a(facing.func_176735_f())).func_189546_a(worldIn, pos.func_177972_a(facing.func_176735_f()), (Block)this, pos);
                worldIn.func_180495_p(pos.func_177972_a(facing.func_176746_e())).func_189546_a(worldIn, pos.func_177972_a(facing.func_176746_e()), (Block)this, pos);
                return true;
            }
            if (!(itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151033_d && itemstack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150478_aa))) {
                facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(true)), 10);
                worldIn.func_184133_a(null, pos, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldIn.func_180495_p(pos.func_177972_a(facing.func_176735_f())).func_189546_a(worldIn, pos.func_177972_a(facing.func_176735_f()), (Block)this, pos);
                worldIn.func_180495_p(pos.func_177972_a(facing.func_176746_e())).func_189546_a(worldIn, pos.func_177972_a(facing.func_176746_e()), (Block)this, pos);
                if (itemstack.func_77973_b() == Items.field_151033_d) {
                    itemstack.func_77972_a(1, (EntityLivingBase)playerIn);
                } else if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState newState;
        if ((state = state.func_185899_b((IBlockAccess)worldIn, pos)).func_177229_b(VERTICAL_CONNECTION) != EnumsBlock.EnumVerticalConnection.BOTH && state.func_177229_b(VERTICAL_CONNECTION) != EnumsBlock.EnumVerticalConnection.UNDER && (newState = worldIn.func_180495_p(fromPos)).func_177230_c() instanceof BlockLimestoneFireplace) {
            boolean burning;
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (newState.func_177229_b((IProperty)FACING) == facing && (burning = ((Boolean)newState.func_177229_b((IProperty)BURNING)).booleanValue()) != (Boolean)state.func_177229_b((IProperty)BURNING)) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(burning)), 10);
                BlockPos newPos = pos.func_177972_a(facing.func_176746_e()).equals((Object)fromPos) ? pos.func_177972_a(facing.func_176735_f()) : pos.func_177972_a(facing.func_176746_e());
                worldIn.func_180495_p(newPos).func_189546_a(worldIn, newPos, (Block)this, pos);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)BURNING)).booleanValue()) {
            if (rand.nextInt(24) == 0) {
                worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)pos.func_177958_n() + rand.nextDouble() * 0.5 + 0.25;
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.6;
                double d2 = (double)pos.func_177952_p() + rand.nextDouble() * 0.5 + 0.25;
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta > 3) {
            state = state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(true));
            meta -= 4;
        } else {
            state = state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false));
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)BURNING) != false ? 4 : 0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

