/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.french;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.blocks.general.DoTBBlockColumn;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class BlockLimestoneChimney
extends DoTBBlockColumn {
    private static final PropertyEnum<EnumsBlock.EnumHorizontalAxis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumsBlock.EnumHorizontalAxis.class);
    private static final AxisAlignedBB BOT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB BOT_COLUMN_AABB = new AxisAlignedBB(0.125, 0.5, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB MID_COLUMN_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.25, 0.5, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB TOP_COLUMN_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.5, 0.875);

    public BlockLimestoneChimney() {
        super("limestone_chimney", Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)((Object)EnumsBlock.EnumHorizontalAxis.AXIS_X)).func_177226_a((IProperty)VERTICAL_CONNECTION, (Comparable)((Object)EnumsBlock.EnumVerticalConnection.NONE)));
        this.func_149675_a(true);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VERTICAL_CONNECTION, AXIS});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((Object)(placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.X ? EnumsBlock.EnumHorizontalAxis.AXIS_Z : EnumsBlock.EnumHorizontalAxis.AXIS_X)));
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        switch ((EnumsBlock.EnumVerticalConnection)((Object)state.func_177229_b((IProperty)VERTICAL_CONNECTION))) {
            default: {
                list.add(TOP_AABB);
                list.add(TOP_COLUMN_AABB);
                break;
            }
            case NONE: 
            case BOTH: {
                list.add(MID_COLUMN_AABB);
                break;
            }
            case ABOVE: {
                list.add(BOT_AABB);
                list.add(BOT_COLUMN_AABB);
            }
        }
        return list;
    }

    @Override
    public boolean isSameColumn(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() instanceof BlockLimestoneChimney;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumsBlock.EnumVerticalConnection connection = (EnumsBlock.EnumVerticalConnection)((Object)this.func_176221_a(stateIn, (IBlockAccess)worldIn, pos).func_177229_b((IProperty)VERTICAL_CONNECTION));
        if (connection == EnumsBlock.EnumVerticalConnection.UNDER || connection == EnumsBlock.EnumVerticalConnection.NONE) {
            for (int i = 0; i < 5; ++i) {
                double d0 = (double)pos.func_177958_n() + rand.nextDouble() * 0.5 + 0.25;
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.3;
                double d2 = (double)pos.func_177952_p() + rand.nextDouble() * 0.5 + 0.25;
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((Object)(meta < 8 ? EnumsBlock.EnumHorizontalAxis.AXIS_X : EnumsBlock.EnumHorizontalAxis.AXIS_Z)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return state.func_177229_b(AXIS) == EnumsBlock.EnumHorizontalAxis.AXIS_X ? 0 : 8;
    }
}

