/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.french;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;

public class BlockLatticeOakWindow
extends DoTBBlock {
    private static final PropertyBool AXISX = PropertyBool.func_177716_a((String)"axisx");
    private static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    private static final PropertyBool SIDE = PropertyBool.func_177716_a((String)"side");
    private static final AxisAlignedBB X_AXIS_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    private static final AxisAlignedBB Z_AXIS_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);

    public BlockLatticeOakWindow() {
        super("lattice_oak_window", Material.field_151592_s, 0.8f, SoundType.field_185853_f);
        this.setBurnable();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AXISX, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SIDE, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)AXISX) != false ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)AXISX, (Comparable)Boolean.valueOf(placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.X));
        return state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(this.canConnectVertical(worldIn, pos))).func_177226_a((IProperty)SIDE, (Comparable)Boolean.valueOf(this.canConnectHorizontal(state, worldIn, pos)));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean changeTOP = this.canConnectVertical(worldIn, pos);
        boolean changeSIDE = this.canConnectHorizontal(state, worldIn, pos);
        IBlockState newState = state;
        if (changeTOP != (Boolean)state.func_177229_b((IProperty)TOP)) {
            newState = newState.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(changeTOP));
        }
        if (changeSIDE != (Boolean)state.func_177229_b((IProperty)SIDE)) {
            newState = newState.func_177226_a((IProperty)SIDE, (Comparable)Boolean.valueOf(changeSIDE));
        }
        if (changeTOP != (Boolean)state.func_177229_b((IProperty)TOP) || changeSIDE != (Boolean)state.func_177229_b((IProperty)SIDE)) {
            worldIn.func_180501_a(pos, newState, 10);
        }
    }

    private boolean canConnectVertical(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockLatticeOakWindow) {
            return !(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockLatticeOakWindow);
        }
        return false;
    }

    private boolean canConnectHorizontal(IBlockState state, World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos = pos.func_177972_a((Boolean)state.func_177229_b((IProperty)AXISX) != false ? EnumFacing.NORTH : EnumFacing.WEST)).func_177230_c() instanceof BlockLatticeOakWindow) {
            return worldIn.func_180495_p(pos).func_177229_b((IProperty)AXISX) == state.func_177229_b((IProperty)AXISX);
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXISX, TOP, SIDE});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        int i;
        int n = i = (Boolean)state.func_177229_b((IProperty)AXISX) != false ? 1 : 0;
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            i |= 2;
        }
        if (((Boolean)state.func_177229_b((IProperty)SIDE)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AXISX, (Comparable)Boolean.valueOf((meta & 1) > 0)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf((meta & 2) > 0)).func_177226_a((IProperty)SIDE, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        boolean axisX = (Boolean)state.func_177229_b((IProperty)AXISX);
        return state.func_177226_a((IProperty)AXISX, (Comparable)Boolean.valueOf((rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) != axisX));
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState state, BlockPos p_193383_3_, EnumFacing facing) {
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            return BlockFaceShape.UNDEFINED;
        }
        return (Boolean)state.func_177229_b((IProperty)AXISX) == (facing.func_176740_k() == EnumFacing.Axis.X) ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.UNDEFINED;
    }
}

