/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.compatibility;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.blocks.DoTBBlocks;
import org.dawnoftimebuilder.blocks.IBlockCustomItem;
import org.dawnoftimebuilder.blocks.IBlockMeta;
import org.dawnoftimebuilder.enums.IEnumMetaVariants;

public abstract class BlockTilesSlab
extends BlockSlab
implements IBlockMeta,
IBlockCustomItem {
    private static final PropertyBool SEAMLESS = PropertyBool.func_177716_a((String)"seamless");
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockTilesSlab(String name) {
        super(Material.field_151578_c);
        this.setRegistryName("dawnoftimebuilder", name);
        this.func_149663_c("dawnoftimebuilder." + name);
        this.field_149783_u = true;
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.FALSE) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        this.func_180632_j(iblockstate.func_177226_a(VARIANT, (Comparable)((Object)EnumType.SPRUCE_FOUNDATION)));
        this.func_149675_a(true);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        worldIn.func_175656_a(pos, this.getNewState(this.func_176201_c(state)));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175656_a(pos, this.getNewState(this.func_176201_c(state)));
    }

    private IBlockState getNewState(int currentMeta) {
        int newMeta;
        int n = this.func_176552_j() ? 2 : (newMeta = currentMeta >= 8 ? 1 : 0);
        if (currentMeta >= 8) {
            currentMeta -= 8;
        }
        switch (currentMeta) {
            case 0: {
                return DoTBBlocks.spruce_foundation_slab.func_176203_a(newMeta);
            }
            case 1: {
                return DoTBBlocks.grey_roof_tiles_slab.func_176203_a(newMeta);
            }
            case 2: {
                return DoTBBlocks.flat_roof_tiles_slab.func_176203_a(newMeta);
            }
            case 3: {
                return DoTBBlocks.thatch_wheat_slab.func_176203_a(newMeta);
            }
            case 4: {
                return DoTBBlocks.plastered_stone_slab.func_176203_a(newMeta);
            }
            case 5: {
                return DoTBBlocks.limestone_brick_slab.func_176203_a(newMeta);
            }
            case 6: {
                return DoTBBlocks.red_plastered_stone_slab.func_176203_a(newMeta);
            }
            case 7: {
                return DoTBBlocks.thatch_bamboo_slab.func_176203_a(newMeta);
            }
        }
        return Blocks.field_150350_a.func_176203_a(newMeta);
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + EnumType.byMetadata(meta).func_176610_l();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType blockstoneslab$enumtype : EnumType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, blockstoneslab$enumtype.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7)));
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf((meta & 8) != 0)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
        if (this.func_176552_j()) {
            if (((Boolean)state.func_177229_b((IProperty)SEAMLESS)).booleanValue()) {
                i |= 8;
            }
        } else if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{SEAMLESS, VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMapColor();
    }

    @Deprecated
    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ((EnumType)((Object)blockState.func_177229_b(VARIANT))).hardness;
    }

    @Deprecated
    public Material func_149688_o(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).material;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).sound;
    }

    @Override
    public IEnumMetaVariants[] getVariants() {
        return EnumType.values();
    }

    @Override
    public Item getCustomItemBlock() {
        return null;
    }

    public static enum EnumType implements IEnumMetaVariants
    {
        SPRUCE_FOUNDATION(0, Material.field_151575_d, SoundType.field_185848_a, 1.0f, MapColor.field_151663_o, "spruce_foundation"),
        GREY_ROOF_TILES(1, Material.field_151576_e, SoundType.field_185851_d, 2.0f, MapColor.field_151665_m, "grey_roof_tiles"),
        FLAT_ROOF_TILES(2, Material.field_151576_e, SoundType.field_185851_d, 2.0f, MapColor.field_193562_N, "flat_roof_tiles"),
        THATCH_WHEAT(3, Material.field_151580_n, SoundType.field_185854_g, 0.3f, MapColor.field_151658_d, "thatch_wheat"),
        PLASTERED_STONE(4, Material.field_151576_e, SoundType.field_185851_d, 2.0f, MapColor.field_151677_p, "plastered_stone"),
        LIMESTONE_BRICK(5, Material.field_151576_e, SoundType.field_185851_d, 2.0f, MapColor.field_151665_m, "limestone_brick"),
        RED_PLASTERED_STONE(6, Material.field_151576_e, SoundType.field_185851_d, 2.0f, MapColor.field_193559_aa, "red_plastered_stone"),
        THATCH_BAMBOO(7, Material.field_151580_n, SoundType.field_185854_g, 0.3f, MapColor.field_151658_d, "thatch_bamboo");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final MapColor color;
        private final SoundType sound;
        private final Material material;
        private final float hardness;
        private final String name;

        private EnumType(int meta, Material material, SoundType sound, float hardness, MapColor color, String name) {
            this.color = color;
            this.meta = meta;
            this.name = name;
            this.material = material;
            this.sound = sound;
            this.hardness = hardness;
        }

        @Override
        public int getMetadata() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.color;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

