/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.compatibility;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.blocks.DoTBBlocks;
import org.dawnoftimebuilder.blocks.IBlockCustomItem;
import org.dawnoftimebuilder.blocks.IBlockMeta;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.enums.IEnumMetaVariants;

public class BlockThatch
extends DoTBBlock
implements IBlockMeta,
IBlockCustomItem {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockThatch() {
        super("thatch", Material.field_151580_n);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.WHEAT)));
        this.setBurnable();
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149675_a(true);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        this.replaceBlock(worldIn, pos, this.func_176201_c(state));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.replaceBlock(worldIn, pos, this.func_176201_c(state));
    }

    private void replaceBlock(World worldIn, BlockPos pos, int currentMeta) {
        worldIn.func_175656_a(pos, this.getNewState(currentMeta));
    }

    private IBlockState getNewState(int currentMeta) {
        if (currentMeta == 0) {
            return DoTBBlocks.thatch_wheat.func_176223_P();
        }
        return DoTBBlocks.thatch_bamboo.func_176223_P();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151650_B;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public String getTranslationKey(int meta) {
        return this.func_149739_a() + "_" + EnumType.byMetadata(meta).func_176610_l();
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public IEnumMetaVariants[] getVariants() {
        return EnumType.values();
    }

    @Override
    public Item getCustomItemBlock() {
        return null;
    }

    public static enum EnumType implements IEnumMetaVariants
    {
        WHEAT(0, "wheat"),
        BAMBOO(1, "bamboo");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int metaIn, String nameIn) {
            this.meta = metaIn;
            this.name = nameIn;
        }

        @Override
        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockThatch$enumtype;
                EnumType.META_LOOKUP[blockThatch$enumtype.getMetadata()] = blockThatch$enumtype = enumTypeArray[i];
            }
        }
    }
}

