/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.compatibility;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.blocks.DoTBBlocks;
import org.dawnoftimebuilder.blocks.IBlockCustomItem;
import org.dawnoftimebuilder.blocks.IBlockMeta;
import org.dawnoftimebuilder.enums.IEnumMetaVariants;

public abstract class BlockPathSlab
extends BlockSlab
implements IBlockMeta,
IBlockCustomItem {
    private static final PropertyBool SEAMLESS = PropertyBool.func_177716_a((String)"seamless");
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final PropertyBool FULL = PropertyBool.func_177716_a((String)"full");

    BlockPathSlab(String name) {
        super(Material.field_151578_c);
        this.setRegistryName("dawnoftimebuilder", name);
        this.func_149663_c("dawnoftimebuilder." + name);
        this.field_149783_u = true;
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.FALSE) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        this.func_180632_j(iblockstate.func_177226_a(VARIANT, (Comparable)((Object)EnumType.GRAVEL)).func_177226_a((IProperty)FULL, (Comparable)Boolean.FALSE));
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149711_c(0.5f);
        this.func_149675_a(true);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        worldIn.func_175656_a(pos, this.getNewState(this.func_176201_c(state)));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175656_a(pos, this.getNewState(this.func_176201_c(state)));
    }

    private IBlockState getNewState(int currentMeta) {
        int newMeta;
        int n = this.func_176552_j() ? 2 : (newMeta = currentMeta >= 8 ? 1 : 0);
        if (currentMeta >= 8) {
            currentMeta -= 8;
        }
        switch (currentMeta) {
            case 0: {
                return DoTBBlocks.path_gravel_slab.func_176203_a(newMeta);
            }
            case 1: {
                return DoTBBlocks.path_stepping_stones_slab.func_176203_a(newMeta);
            }
            case 2: {
                return DoTBBlocks.path_cobbled_slab.func_176203_a(newMeta);
            }
            case 4: {
                return DoTBBlocks.path_ochre_tiles_slab.func_176203_a(newMeta);
            }
            case 5: {
                return DoTBBlocks.path_dirt_slab.func_176203_a(newMeta);
            }
        }
        return Blocks.field_150350_a.func_176203_a(newMeta);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + EnumType.byMetadata(meta).func_176610_l();
    }

    public IProperty<?> func_176551_l() {
        return VARIANT;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7)));
        iblockstate = this.func_176552_j() ? iblockstate.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf((meta & 8) != 0)) : iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
        if (this.func_176552_j()) {
            if (((Boolean)state.func_177229_b((IProperty)SEAMLESS)).booleanValue()) {
                i |= 8;
            }
        } else if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        if (((BlockSlab)p_193383_2_.func_177230_c()).func_176552_j()) {
            return BlockFaceShape.SOLID;
        }
        if (p_193383_4_ == EnumFacing.UP && p_193383_2_.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            return BlockFaceShape.SOLID;
        }
        return p_193383_4_ == EnumFacing.DOWN && p_193383_2_.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{SEAMLESS, VARIANT, FULL}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT, FULL});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)FULL, (Comparable)Boolean.valueOf(this.isFull(worldIn, pos)));
    }

    private boolean isFull(IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return !(block instanceof BlockAir) && !(block instanceof BlockLeaves) && !(block instanceof BlockBush);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        boolean full = (Boolean)state.func_177229_b((IProperty)FULL);
        boolean isDouble = this.func_176552_j();
        if (isDouble) {
            if (full && face != EnumFacing.UP) {
                return false;
            }
            if (face == EnumFacing.DOWN) {
                return false;
            }
        } else {
            BlockSlab.EnumBlockHalf half = (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)field_176554_a);
            if (half == BlockSlab.EnumBlockHalf.BOTTOM ? face == EnumFacing.DOWN : face == EnumFacing.UP && full) {
                return false;
            }
        }
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    @Override
    public IEnumMetaVariants[] getVariants() {
        return EnumType.values();
    }

    @Override
    public Item getCustomItemBlock() {
        return null;
    }

    public static enum EnumType implements IEnumMetaVariants
    {
        GRAVEL(0, "gravel"),
        STEPPING_STONES(1, "stepping_stones"),
        COBBLED(2, "cobbled"),
        SANDSTONE(3, "sandstone"),
        OCHRE_TILES(4, "ochre_tiles"),
        DIRT(5, "dirt");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        @Override
        public int getMetadata() {
            return this.meta;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

