/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.compatibility;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.blocks.DoTBBlocks;
import org.dawnoftimebuilder.blocks.IBlockCustomItem;
import org.dawnoftimebuilder.blocks.IBlockMeta;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.enums.IEnumMetaVariants;

public class BlockPath
extends DoTBBlock
implements IBlockMeta,
IBlockCustomItem {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final PropertyBool FULL = PropertyBool.func_177716_a((String)"full");
    private static final AxisAlignedBB GRASS_PATH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    public BlockPath() {
        super("path", Material.field_151577_b, 0.5f, SoundType.field_185849_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.GRAVEL)).func_177226_a((IProperty)FULL, (Comparable)Boolean.FALSE));
        this.func_149713_g(255);
        this.func_149675_a(true);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        this.replaceBlock(worldIn, pos, this.func_176201_c(state));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.replaceBlock(worldIn, pos, this.func_176201_c(state));
    }

    private void replaceBlock(World worldIn, BlockPos pos, int currentMeta) {
        worldIn.func_175656_a(pos, this.getNewState(currentMeta));
    }

    private IBlockState getNewState(int currentMeta) {
        switch (currentMeta) {
            case 0: {
                return DoTBBlocks.path_gravel.func_176223_P();
            }
            case 1: {
                return DoTBBlocks.path_stepping_stones.func_176223_P();
            }
            case 2: {
                return DoTBBlocks.path_cobbled.func_176223_P();
            }
            case 4: {
                return DoTBBlocks.path_ochre_tiles.func_176223_P();
            }
            case 5: {
                return DoTBBlocks.path_dirt.func_176223_P();
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)FULL, (Comparable)Boolean.valueOf(this.isFull(worldIn, pos)));
    }

    private boolean isFull(IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return !(block instanceof BlockAir) && !(block instanceof BlockLeaves) && !(block instanceof BlockBush);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return GRASS_PATH_AABB;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151670_w;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && block != Blocks.field_150458_ak && block != Blocks.field_185774_da;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return p_193383_4_ == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)base_state.func_177229_b((IProperty)FULL) != false || side != EnumFacing.UP;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, FULL});
    }

    @Override
    public String getTranslationKey(int meta) {
        return this.func_149739_a() + "_" + EnumType.byMetadata(meta).func_176610_l();
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public IEnumMetaVariants[] getVariants() {
        return EnumType.values();
    }

    @Override
    public Item getCustomItemBlock() {
        return null;
    }

    public static enum EnumType implements IEnumMetaVariants
    {
        GRAVEL(0, "gravel"),
        STEPPING_STONES(1, "stepping_stones"),
        COBBLED(2, "cobbled"),
        SANDSTONE(3, "sandstone"),
        OCHRE_TILES(4, "ochre_tiles"),
        DIRT(5, "dirt");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int metaIn, String nameIn) {
            this.meta = metaIn;
            this.name = nameIn;
        }

        @Override
        public int getMetadata() {
            return this.meta;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

