/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder;

import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.dawnoftimebuilder.crafts.DoTBRecipesRegistry;
import org.dawnoftimebuilder.registries.DoTBBlocksRegistry;
import org.dawnoftimebuilder.registries.DoTBItemsRegistry;

@Mod.EventBusSubscriber(modid="dawnoftimebuilder")
public class DoTBEvents {
    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        DoTBBlocksRegistry.registerBlocks(event);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        DoTBBlocksRegistry.initItemBlocks();
        DoTBItemsRegistry.registerItems(event);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        DoTBItemsRegistry.registerItemsModels();
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        DoTBRecipesRegistry.registerRecipes(event);
    }

    @SubscribeEvent
    public void onMissingBlockMapping(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            Block block;
            ResourceLocation resource = mapping.key;
            if (resource == null || !Objects.equals(resource.func_110624_b(), "dawnoftime")) continue;
            String name = resource.func_110623_a();
            if (Objects.equals(name, "commelina_flower")) {
                name = "commelina";
            }
            if (Objects.equals(name, "tatami_floor")) {
                name = "small_tatami_floor";
            }
            if ((block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("dawnoftimebuilder", name))) == null) continue;
            mapping.remap((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public void onMissingItemMapping(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            String name;
            Item item;
            ResourceLocation resource = mapping.key;
            if (resource == null || !Objects.equals(resource.func_110624_b(), "dawnoftime") || (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dawnoftimebuilder", name = resource.func_110623_a()))) == null) continue;
            mapping.remap((IForgeRegistryEntry)item);
        }
    }
}

