/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder;

import java.io.File;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import org.dawnoftimebuilder.enums.EArmorMaterial;
import org.dawnoftimebuilder.registries.DoTBBlocksRegistry;
import org.dawnoftimebuilder.registries.DoTBItemsRegistry;

public class DoTBConfigs {
    public static Configuration config;
    public static HashMap<String, Boolean> enabledMap;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            DoTBConfigs.loadConfig();
        }
    }

    public static void loadConfig() {
        Boolean enabled;
        String name;
        String configName = "Blocks";
        config.setCategoryComment(configName, "Disable Blocks from this group.");
        for (Block block : DoTBBlocksRegistry.blocks_list) {
            name = block.getRegistryName().func_110623_a();
            enabled = config.get(configName, name, true).getBoolean();
            enabledMap.put(name, enabled);
        }
        configName = "Items";
        config.setCategoryComment(configName, "Disable Items from this group.");
        for (Item item : DoTBItemsRegistry.items_list) {
            name = item.getRegistryName().func_110623_a();
            if (enabledMap.containsKey(name)) continue;
            enabled = config.get(configName, name, true).getBoolean();
            enabledMap.put(name, enabled);
        }
        for (EArmorMaterial armorMaterial : EArmorMaterial.values()) {
            configName = armorMaterial.getName();
            config.setCategoryComment(configName, "Set properties of the " + configName + " armor in this group.");
            int durability = config.get(configName, "durability", armorMaterial.getDurability()).getInt();
            int[] reductionPoints = armorMaterial.getReductionPoints();
            reductionPoints[0] = config.get(configName, "helmet_reduction_points", reductionPoints[0]).getInt();
            reductionPoints[2] = config.get(configName, "chest_reduction_points", reductionPoints[2]).getInt();
            reductionPoints[1] = config.get(configName, "leggings_reduction_points", reductionPoints[1]).getInt();
            reductionPoints[3] = config.get(configName, "feet_reduction_points", reductionPoints[3]).getInt();
            int enchantability = config.get(configName, "enchantability", armorMaterial.getEnchantability()).getInt();
            float toughness = (float)config.get(configName, "toughness", (double)armorMaterial.getToughness()).getDouble();
            armorMaterial.loadConfig(durability, reductionPoints, enchantability, toughness);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        enabledMap = new HashMap();
    }
}

