/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class MobType {
        constructor()
        static readonly ILLAGER: Internal.MobType;
        static readonly WATER: Internal.MobType;
        static readonly UNDEFINED: Internal.MobType;
        static readonly UNDEAD: Internal.MobType;
        static readonly ARTHROPOD: Internal.MobType;
    }
    type MobType_ = MobType;
    interface IGuiHelper {
        abstract drawableBuilder(arg0: ResourceLocation_, arg1: number, arg2: number, arg3: number, arg4: number): Internal.IDrawableBuilder;
        abstract createCraftingGridHelper(): Internal.ICraftingGridHelper;
        abstract createAnimatedDrawable(arg0: Internal.IDrawableStatic_, arg1: number, arg2: Internal.IDrawableAnimated$StartDirection_, arg3: boolean): Internal.IDrawableAnimated;
        createDrawable(arg0: ResourceLocation_, arg1: number, arg2: number, arg3: number, arg4: number): Internal.IDrawableStatic;
        abstract getSlotDrawable(): Internal.IDrawableStatic;
        abstract createTickTimer(arg0: number, arg1: number, arg2: boolean): Internal.ITickTimer;
        createDrawableItemStack(arg0: Internal.ItemStack_): Internal.IDrawable;
        abstract createDrawableIngredient<V>(arg0: Internal.IIngredientType_<V>, arg1: V): Internal.IDrawable;
        abstract createBlankDrawable(arg0: number, arg1: number): Internal.IDrawableStatic;
        get slotDrawable(): Internal.IDrawableStatic
    }
    type IGuiHelper_ = IGuiHelper;
    class InventoryContainerItem extends Internal.ItemCoFH implements Internal.IInventoryContainerItem {
        constructor(arg0: Internal.Item$Properties_, arg1: number)
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        getSlotLimit(arg0: Internal.ItemStack_, arg1: number): number;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): InteractionResult;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        setAttackSpeed(attackSpeed: number): void;
        getContainerInventory(arg0: Internal.ItemStack_): Internal.SimpleItemInv;
        getSpace(arg0: Internal.ItemStack_, arg1: number): number;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        setModId(arg0: string): Internal.ICoFHItem;
        insertItem(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.ItemStack_, arg3: boolean): Internal.ItemStack;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        isActive(arg0: Internal.ItemStack_): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        getContainerSlots(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        hasActiveTag(arg0: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        onContainerInventoryChanged(arg0: Internal.ItemStack_): void;
        getOrCreateInvTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        isItemValid(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.ItemStack_): boolean;
        setActive(arg0: Internal.ItemStack_, arg1: boolean): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        getStackInSlot(arg0: Internal.ItemStack_, arg1: number): Internal.ItemStack;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getScaledItemsStored(arg0: Internal.ItemStack_, arg1: number, arg2: number): number;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        addModeChangeTooltip(arg0: Internal.IMultiModeItem_, arg1: Internal.ItemStack_, arg2: Internal.Level_, arg3: Internal.List_<net.minecraft.network.chat.Component>, arg4: Internal.TooltipFlag_): void;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        setActive(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): void;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        addIncrementModeChangeTooltip(arg0: Internal.IMultiModeItem_, arg1: Internal.ItemStack_, arg2: Internal.Level_, arg3: Internal.List_<net.minecraft.network.chat.Component>, arg4: Internal.TooltipFlag_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        setArmorToughness(armorToughness: number): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        addEnergyTooltip(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.List_<net.minecraft.network.chat.Component>, arg3: Internal.TooltipFlag_, arg4: number, arg5: number, arg6: boolean): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        extractItem(arg0: Internal.ItemStack_, arg1: number, arg2: number, arg3: boolean): Internal.ItemStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getItemAmount(arg0: Internal.ItemStack_, arg1: number): number;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set modId(arg0: string)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type InventoryContainerItem_ = InventoryContainerItem;
    interface ConfigWriter {
        writeToString(arg0: Internal.UnmodifiableConfig_): string;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.File_, arg2: Internal.WritingMode_, arg3: Internal.Charset_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.Path_, arg2: Internal.WritingMode_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.File_, arg2: Internal.WritingMode_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.URL_): void;
        abstract write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.Writer_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.OutputStream_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.OutputStream_, arg2: Internal.Charset_): void;
        write(arg0: Internal.UnmodifiableConfig_, arg1: Internal.Path_, arg2: Internal.WritingMode_, arg3: Internal.Charset_): void;
        (arg0: Internal.UnmodifiableConfig, arg1: Internal.Writer): void;
    }
    type ConfigWriter_ = ConfigWriter;
    abstract class ChunkSource implements Internal.AutoCloseable, Internal.LightChunkGetter {
        constructor()
        abstract gatherStats(): string;
        abstract getLoadedChunksCount(): number;
        updateChunkForced(arg0: Internal.ChunkPos_, arg1: boolean): void;
        abstract getLevel(): Internal.BlockGetter;
        abstract tick(arg0: Internal.BooleanSupplier_, arg1: boolean): void;
        abstract getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_, arg3: boolean): Internal.ChunkAccess;
        hasChunk(arg0: number, arg1: number): boolean;
        setSpawnSettings(arg0: boolean, arg1: boolean): void;
        getChunk(arg0: number, arg1: number, arg2: boolean): Internal.LevelChunk;
        getChunkNow(arg0: number, arg1: number): Internal.LevelChunk;
        onLightUpdate(arg0: Internal.LightLayer_, arg1: Internal.SectionPos_): void;
        getChunkForLighting(arg0: number, arg1: number): Internal.LightChunk;
        close(): void;
        abstract getLightEngine(): Internal.LevelLightEngine;
        get loadedChunksCount(): number
        get level(): Internal.BlockGetter
        get lightEngine(): Internal.LevelLightEngine
    }
    type ChunkSource_ = ChunkSource;
    interface IAugmentType {
        abstract getType(): string;
        get type(): string
        (): string;
    }
    type IAugmentType_ = IAugmentType;
    abstract class AbstractSkeleton extends Internal.Monster implements Internal.RangedAttackMob {
        getDistance(pos: BlockPos_): number;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        getPickedResult(arg0: Internal.HitResult_): Internal.ItemStack;
        isShaking(): boolean;
        runCommandSilent(command: string): number;
        setPosition(x: number, y: number, z: number): void;
        canStartSwimming(): boolean;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        isLiving(): boolean;
        getTotalMovementSpeed(): number;
        rayTrace(): Internal.RayTraceResultJS;
        alwaysAccepts(): boolean;
        moveInFluid(arg0: Internal.FluidState_, arg1: Vec3d_, arg2: number): boolean;
        isInFluidType(arg0: Internal.FluidState_): boolean;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        shouldUpdateFluidWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        canSwimInFluidType(arg0: Internal.FluidType_): boolean;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        canBeRiddenUnderFluidType(arg0: Internal.FluidType_, arg1: Internal.Entity_): boolean;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        shouldRiderSit(): boolean;
        setMainHandItem(item: Internal.ItemStack_): void;
        getLegsArmorItem(): Internal.ItemStack;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isInFluidType(arg0: Internal.FluidType_): boolean;
        getReachDistance(): number;
        getFluidMotionScale(arg0: Internal.FluidType_): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        handler$zde000$finalizeSpawn(level: Internal.ServerLevelAccessor_, difficulty: Internal.DifficultyInstance_, reason: Internal.MobSpawnType_, spawnData: Internal.SpawnGroupData_, dataTag: Internal.CompoundTag_, cir: Internal.CallbackInfoReturnable_<any>): void;
        self(): Internal.LivingEntity;
        getDefaultMovementSpeed(): number;
        swing(hand: Internal.InteractionHand_): void;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        getStepHeight(): number;
        isAmbientCreature(): boolean;
        getSoundFromFluidType(arg0: Internal.FluidType_, arg1: Internal.SoundAction_): Internal.SoundEvent;
        isMonster(): boolean;
        canHydrateInFluidType(arg0: Internal.FluidType_): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        self(): Internal.Entity;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        getFluidFallDistanceModifier(arg0: Internal.FluidType_): number;
        isInFluidType(arg0: Internal.BiPredicate_<Internal.FluidType, number>): boolean;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        canFluidExtinguish(arg0: Internal.FluidType_): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        isPushedByFluid(arg0: Internal.FluidType_): boolean;
        reassessWeaponGoal(): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        sinkInFluid(arg0: Internal.FluidType_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        performRangedAttack(arg0: Internal.LivingEntity_, arg1: number): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        isMultipartEntity(): boolean;
        handler$zde000$consumeQuiverArrow(target: Internal.LivingEntity_, velocity: number, ci: Internal.CallbackInfo_, arrow: Internal.ItemStack_): void;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        getParts(): Internal.PartEntity<any>[];
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        deserializeNBT(arg0: Internal.Tag_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getEyeHeightForge(arg0: Internal.Pose_, arg1: Internal.EntityDimensions_): number;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        serializeNBT(): Internal.CompoundTag;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        isEyeInFluidType(arg0: Internal.FluidType_): boolean;
        getDistanceSq(pos: BlockPos_): number;
        getProfile(): Internal.GameProfile;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getClassification(arg0: boolean): Internal.MobCategory;
        runCommand(command: string): number;
        canDrownInFluidType(arg0: Internal.FluidType_): boolean;
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        get shaking(): boolean
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        set mainHandItem(item: Internal.ItemStack_)
        get legsArmorItem(): Internal.ItemStack
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get stepHeight(): number
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get multipartEntity(): boolean
        get headArmorItem(): Internal.ItemStack
        set feetArmorItem(item: Internal.ItemStack_)
        get parts(): Internal.PartEntity<any>[]
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type AbstractSkeleton_ = AbstractSkeleton;
    interface IJSONGenerator {
        abstract generate(): Internal.JsonObject;
        (): Internal.JsonObject_;
    }
    type IJSONGenerator_ = IJSONGenerator;
    class GlazedTerracottaBlock extends Internal.HorizontalDirectionalBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type GlazedTerracottaBlock_ = GlazedTerracottaBlock;
    interface LongToIntFunction {
        abstract applyAsInt(arg0: number): number;
        (arg0: number): number;
    }
    type LongToIntFunction_ = LongToIntFunction;
    class VoidStartPlatformFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(arg0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type VoidStartPlatformFeature_ = VoidStartPlatformFeature;
    class BiomeGenerationSettings {
        getFlowerFeatures(): Internal.List<Internal.ConfiguredFeature<any, any>>;
        features(): Internal.List<Internal.HolderSet<Internal.PlacedFeature>>;
        getCarvingStages(): Internal.Set<Internal.GenerationStep$Carving>;
        hasFeature(arg0: Internal.PlacedFeature_): boolean;
        getCarvers(arg0: Internal.GenerationStep$Carving_): Internal.Iterable<Internal.Holder<Internal.ConfiguredWorldCarver<any>>>;
        get flowerFeatures(): Internal.List<Internal.ConfiguredFeature<any, any>>
        get carvingStages(): Internal.Set<Internal.GenerationStep$Carving>
        static readonly EMPTY: Internal.BiomeGenerationSettings;
        static readonly CODEC: Internal.MapCodec<Internal.BiomeGenerationSettings>;
    }
    type BiomeGenerationSettings_ = BiomeGenerationSettings;
    interface Spliterator$OfPrimitive <T, T_CONS, T_SPLITR extends Internal.Spliterator$OfPrimitive<T, T_CONS, T_SPLITR>> extends Internal.Spliterator<T> {
        trySplit(): Internal.Spliterator<any>;
        forEachRemaining(arg0: T_CONS): void;
        getExactSizeIfKnown(): number;
        hasCharacteristics(arg0: number): boolean;
        forEachRemaining(arg0: Internal.Consumer_<T>): void;
        abstract tryAdvance(arg0: T_CONS): boolean;
        abstract tryAdvance(arg0: Internal.Consumer_<T>): boolean;
        getComparator(): Internal.Comparator<T>;
        abstract estimateSize(): number;
        abstract characteristics(): number;
        get exactSizeIfKnown(): number
        get comparator(): Internal.Comparator<T>
    }
    type Spliterator$OfPrimitive_<T, T_CONS, T_SPLITR extends Internal.Spliterator$OfPrimitive<T, T_CONS, T_SPLITR>> = Spliterator$OfPrimitive<T, T_CONS, T_SPLITR>;
    class PirateTier2Item$Boots extends Internal.PirateTier2Item {
        constructor()
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        setDigSpeed(speed: number): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): InteractionResult;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        setAttackSpeed(attackSpeed: number): void;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        static get(arg0: Internal.ItemStack_): Internal.Equipable;
        getDamage(arg0: Internal.ItemStack_): number;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        setArmorToughness(armorToughness: number): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        swapWithEquipmentSlot(arg0: Internal.Item_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type PirateTier2Item$Boots_ = PirateTier2Item$Boots;
    class ServerboundSeenAdvancementsPacket$Action extends Internal.Enum<Internal.ServerboundSeenAdvancementsPacket$Action> {
        static values(): Internal.ServerboundSeenAdvancementsPacket$Action[];
        static valueOf(arg0: string): Internal.ServerboundSeenAdvancementsPacket$Action;
        static readonly OPENED_TAB: Internal.ServerboundSeenAdvancementsPacket$Action;
        static readonly CLOSED_SCREEN: Internal.ServerboundSeenAdvancementsPacket$Action;
    }
    type ServerboundSeenAdvancementsPacket$Action_ = "closed_screen" | ServerboundSeenAdvancementsPacket$Action | "opened_tab";
    class ChatTypeDecoration extends Internal.Record {
        constructor(arg0: string, arg1: Internal.List_<Internal.ChatTypeDecoration$Parameter>, arg2: Internal.Style_)
        static outgoingDirectMessage(arg0: string): Internal.ChatTypeDecoration;
        parameters(): Internal.List<Internal.ChatTypeDecoration$Parameter>;
        style(): Internal.Style;
        translationKey(): string;
        static withSender(arg0: string): Internal.ChatTypeDecoration;
        decorate(arg0: net.minecraft.network.chat.Component_, arg1: Internal.ChatType$Bound_): net.minecraft.network.chat.Component;
        static teamMessage(arg0: string): Internal.ChatTypeDecoration;
        static incomingDirectMessage(arg0: string): Internal.ChatTypeDecoration;
        static readonly CODEC: Internal.Codec<Internal.ChatTypeDecoration>;
    }
    type ChatTypeDecoration_ = ChatTypeDecoration;
    class WallSide extends Internal.Enum<Internal.WallSide> implements Internal.StringRepresentable {
        static values(): Internal.WallSide[];
        static keys(arg0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>(arg0: Internal.Supplier_<E[]>, arg1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(arg0: string): Internal.WallSide;
        get serializedName(): string
        static readonly LOW: Internal.WallSide;
        static readonly TALL: Internal.WallSide;
        static readonly NONE: Internal.WallSide;
    }
    type WallSide_ = "low" | WallSide | "tall" | "none";
    interface MessageSenderKJS {
        getDisplayName(): net.minecraft.network.chat.Component;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getName(): net.minecraft.network.chat.Component;
        runCommandSilent(command: string): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        runCommand(command: string): number;
        get displayName(): net.minecraft.network.chat.Component
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get name(): net.minecraft.network.chat.Component
    }
    type MessageSenderKJS_ = MessageSenderKJS;
    interface KeyListener extends Internal.EventListener {
        abstract keyPressed(arg0: Internal.KeyEvent_): void;
        abstract keyReleased(arg0: Internal.KeyEvent_): void;
        abstract keyTyped(arg0: Internal.KeyEvent_): void;
    }
    type KeyListener_ = KeyListener;
    abstract class ArrowEntityBuilder <T extends Internal.AbstractArrow & Internal.IArrowEntityJS> extends Internal.BaseEntityBuilder<T> {
        constructor(arg0: ResourceLocation_)
        /**
         * Sets a function to determine if the arrow entity can hit a specific entity.
         * 
         * @param canHitEntity Function to check if the arrow can hit the entity.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.canHitEntity(entity => {
         *     // Custom logic to determine if the arrow can hit the specified entity
         *     // Return true if the arrow can hit, false otherwise.
         * });
         * ```
        */
        canHitEntity(arg0: Internal.Function_<Internal.Entity, any>): this;
        /**
         * Sets a function to determine the texture resource for the entity.
         * The provided Function accepts a parameter of type T (the entity),
         * allowing changing the texture based on information about the entity.
         * The default behavior returns <namespace>:textures/entity/projectiles/<path>.png.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.textureResource(entity => {
         *     // Define logic to determine the texture resource for the entity
         *     // Use information about the entity provided by the context.
         *     return "kubejs:textures/entity/projectiles/arrow.png" // Some ResourceLocation representing the texture resource;
         * });
         * ```
        */
        textureLocation(arg0: Internal.Function_<T, any>): this;
        /**
         * Sets the knockback value for the arrow entity when a bow has Punch Enchantment.
         * 
         * @param setKnockback The knockback value of the Punch Enchantment to be set.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.setKnockback(2);
         * ```
        */
        setKnockback(arg0: number): this;
        /**
         * Sets a consumer to perform additional effects after the arrow successfully hurts a living entity.
         * 
         * @param doPostHurtEffects The consumer to perform additional effects.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.doPostHurtEffects(context => {
         *     // Custom logic to perform additional effects after the arrow hurts a living entity.
         * });
         * ```
        */
        doPostHurtEffects(arg0: Internal.Consumer_<Internal.ContextUtils$ArrowLivingEntityContext>): this;
        /**
         * Sets a consumer to be called during each tick to handle arrow entity despawn logic.
         * 
         * @param tickDespawn The consumer to handle the arrow entity tick despawn logic.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.tickDespawn(arrow => {
         *     // Custom logic to handle arrow entity despawn during each tick
         * });
         * ```
        */
        tickDespawn(arg0: Internal.Consumer_<Internal.AbstractArrow>): this;
        /**
         * Sets a function to determine if a player can pick up the arrow entity.
         * 
         * @param tryPickup The function to check if a player can pick up the arrow.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.tryPickup(context => {
         *     // Custom logic to determine if the player can pick up the arrow
         *     // Return true if the player can pick up, false otherwise.
         * });
         * ```
        */
        tryPickup(arg0: Internal.Function_<Internal.ContextUtils$ArrowPlayerContext, any>): this;
        /**
         * Sets the base damage value for the arrow entity.
         * 
         * @param baseDamage The base damage value to be set.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.setBaseDamage(8.0);
         * ```
        */
        setBaseDamage(arg0: number): this;
        /**
         * Sets the base damage value with a function for the arrow entity for more control.
         * 
         * @param setDamageFunction Function which returns a double.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.setBaseDamage(entity => {
         *     return 10; //Some double based off entity context.
         * });
         * ```
        */
        setDamageFunction(arg0: Internal.Function_<Internal.Entity, any>): this;
        /**
         * Sets the water inertia value for the arrow entity.
         * 
         * @param setWaterInertia The water inertia value to be set.
         * Defaults to 0.6 for AbstractArrow
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.setWaterInertia(0.5);
         * ```
        */
        setWaterInertia(arg0: number): this;
        /**
         * Sets a consumer to be called when the arrow entity hits a block.
         * 
         * @param onHitBlock The consumer to handle the arrow block hit context.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.onHitBlock(context => {
         *     // Custom logic to handle the arrow hitting a block
         * });
         * ```
        */
        onHitBlock(arg0: Internal.Consumer_<Internal.ContextUtils$ArrowBlockHitContext>): this;
        /**
         * Sets the default sound event played when the arrow hits the ground using a string representation.
         * 
         * @param defaultHitGroundSoundEvent A string representing the ResourceLocation of the sound event.
         * 
         * Example usage:
         * ```javascript
         * // Example to set a custom sound event for the arrow hitting the ground.
         * arrowEntityBuilder.defaultHitGroundSoundEvent("minecraft:entity.arrow.hit");
         * ```
        */
        defaultHitGroundSoundEvent(arg0: any): this;
        /**
         * Sets a consumer to be called when the arrow entity hits another entity.
         * 
         * @param onHitEntity The consumer to handle the arrow entity hit context.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.onHitEntity(context => {
         *     // Custom logic to handle the arrow hitting another entity
         * });
         * ```
        */
        onHitEntity(arg0: Internal.Consumer_<Internal.ContextUtils$ArrowEntityHitContext>): this;
        createObject(): Internal.EntityType<T>;
        /**
         * Sets the knockback value for the arrow entity when a bow has Punch Enchantment.
         * 
         * @param setKnockback The knockback value of the Punch Enchantment to be set.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.setKnockback(2);
         * ```
        */
        set knockback(arg0: number)
        /**
         * Sets the base damage value for the arrow entity.
         * 
         * @param baseDamage The base damage value to be set.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.setBaseDamage(8.0);
         * ```
        */
        set baseDamage(arg0: number)
        /**
         * Sets the base damage value with a function for the arrow entity for more control.
         * 
         * @param setDamageFunction Function which returns a double.
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.setBaseDamage(entity => {
         *     return 10; //Some double based off entity context.
         * });
         * ```
        */
        set damageFunction(arg0: Internal.Function_<Internal.Entity, any>)
        /**
         * Sets the water inertia value for the arrow entity.
         * 
         * @param setWaterInertia The water inertia value to be set.
         * Defaults to 0.6 for AbstractArrow
         * 
         * Example usage:
         * ```javascript
         * arrowEntityBuilder.setWaterInertia(0.5);
         * ```
        */
        set waterInertia(arg0: number)
        static readonly thisList: [];
    }
    type ArrowEntityBuilder_<T extends Internal.AbstractArrow & Internal.IArrowEntityJS> = ArrowEntityBuilder<T>;
    class RoadSignFeature extends Internal.Feature<Internal.RoadSignFeature$Config> {
        constructor(codec: Internal.Codec_<Internal.RoadSignFeature$Config>)
        static applyPostProcess(c: Internal.RoadSignFeature$Config_, level: Internal.ServerLevel_, generatorPos: BlockPos_, foundVillages: Internal.List_<Internal.StructureLocator$LocatedStruct>): void;
        static isNotSolid(world: Internal.LevelAccessor_, pos: BlockPos_): boolean;
    }
    type RoadSignFeature_ = RoadSignFeature;
    class BlockPileFeature extends Internal.Feature<Internal.BlockPileConfiguration> {
        constructor(arg0: Internal.Codec_<Internal.BlockPileConfiguration>)
    }
    type BlockPileFeature_ = BlockPileFeature;
    abstract class ScreenEvent$MouseButtonPressed extends Internal.ScreenEvent$MouseInput {
        constructor()
        constructor(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number)
        getButton(): number;
        get button(): number
    }
    type ScreenEvent$MouseButtonPressed_ = ScreenEvent$MouseButtonPressed;
    class ServerOpList extends Internal.StoredUserList<Internal.GameProfile, any> {
        constructor(arg0: Internal.File_)
        canBypassPlayerLimit(arg0: Internal.GameProfile_): boolean;
    }
    type ServerOpList_ = ServerOpList;
    class ClassInfo {
        getFieldInfo(): Internal.List<Internal.FieldInfo>;
        getClazzRaw(): typeof any;
        getAnnotations(): Internal.List<Internal.Annotation>;
        isAbstract(): boolean;
        static getOrCache(clazz: typeof any): Internal.ClassInfo;
        getInterfaceTypes(): Internal.List<Internal.ITypeInfo>;
        isInterface(): boolean;
        getSuperClassType(): Internal.ITypeInfo;
        getInterfaces(): Internal.List<Internal.ClassInfo>;
        getSuperClass(): this;
        getParameters(): Internal.List<Internal.ITypeInfo>;
        getName(): string;
        isEnum(): boolean;
        getConstructorInfo(): Internal.List<Internal.ConstructorInfo>;
        getMethodInfo(): Internal.List<Internal.MethodInfo>;
        get fieldInfo(): Internal.List<Internal.FieldInfo>
        get clazzRaw(): typeof any
        get annotations(): Internal.List<Internal.Annotation>
        get "abstract"(): boolean
        get interfaceTypes(): Internal.List<Internal.ITypeInfo>
        get "interface"(): boolean
        get superClassType(): Internal.ITypeInfo
        get interfaces(): Internal.List<Internal.ClassInfo>
        get superClass(): Internal.ClassInfo
        get parameters(): Internal.List<Internal.ITypeInfo>
        get name(): string
        get enum(): boolean
        get constructorInfo(): Internal.List<Internal.ConstructorInfo>
        get methodInfo(): Internal.List<Internal.MethodInfo>
        static readonly CLASS_CACHE: {[key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo, [key: typeof any]: Internal.ClassInfo};
        static readonly CLASS_NAME_CACHE: {"net.minecraft.world.level.Level$ExplosionInteraction": Internal.ClassInfo, "com.mojang.serialization.codecs.BaseMapCodec": Internal.ClassInfo, "net.minecraft.network.protocol.status.ServerStatus$Players": Internal.ClassInfo, "net.mehvahdjukaar.suppsquared.common.ColoredSackBlock": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagArgument$Info": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier2Item$Leggings": Internal.ClassInfo, "com.obscuria.aquamirae.common.blocks.OxygeliumBlock": Internal.ClassInfo, "net.minecraft.network.FriendlyByteBuf$Reader": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.SculkPatchFeature": Internal.ClassInfo, "net.blay09.mods.balm.api.entity.BalmEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.properties.RemoveOresProperties": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootContext$VisitedEntry": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2BooleanFunction": Internal.ClassInfo, "net.minecraft.world.level.block.CrossCollisionBlock": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.TransporterBlock$Item": Internal.ClassInfo, "java.lang.CharSequence": Internal.ClassInfo, "net.minecraft.world.level.block.ChainBlock": Internal.ClassInfo, "java.awt.dnd.DropTargetDragEvent": Internal.ClassInfo, "com.electronwill.nightconfig.core.file.FileConfigBuilder": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.black.BlackStandingSignBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.ShipwreckStructure": Internal.ClassInfo, "earth.terrarium.chipped.common.blocks.WorkbenchBlock": Internal.ClassInfo, "net.minecraft.world.level.BaseSpawner": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedEntityTypeExtension": Internal.ClassInfo, "net.minecraft.world.level.block.FrostedIceBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortListIterator": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.Brightable": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$ArrowPlayerContext": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket": Internal.ClassInfo, "com.mojang.blaze3d.shaders.Shader": Internal.ClassInfo, "net.minecraftforge.fml.event.config.ModConfigEvent$Loading": Internal.ClassInfo, "net.minecraftforge.client.gui.overlay.IGuiOverlay": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.HoneyGlazedHamBlock": Internal.ClassInfo, "java.util.Currency": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket": Internal.ClassInfo, "java.util.LinkedHashMap": Internal.ClassInfo, "java.nio.channels.InterruptibleChannel": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.anvil.AnvilUpgradeWrapper": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.world.modifiers.EndProsperityOreModifier": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.MaterialStoneWorkFactoryTile": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier3Item$Leggings": Internal.ClassInfo, "net.minecraft.core.Holder$Kind": Internal.ClassInfo, "net.minecraft.world.level.block.piston.MovingPistonBlock": Internal.ClassInfo, "java.lang.Module": Internal.ClassInfo, "net.minecraft.world.level.block.WallSkullBlock": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.ISoftFluidConsumer": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.SliceMapItem$DepthMapData": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.HorseFeedItem": Internal.ClassInfo, "net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BellBlockEntity": Internal.ClassInfo, "vazkii.patchouli.client.book.BookIcon": Internal.ClassInfo, "net.minecraft.world.item.Item$Properties": Internal.ClassInfo, "net.minecraft.client.InputType": Internal.ClassInfo, "net.mcreator.cozyhome.block.QuartzStorageCounterBlock": Internal.ClassInfo, "mezz.jei.api.recipe.IFocusGroup": Internal.ClassInfo, "java.nio.channels.AsynchronousChannel": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.magenta.MagentaHangingSignBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.TemptingSensor": Internal.ClassInfo, "tech.thatgravyboat.duckling.common.items.DuckEggItem": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.ObjectCompletedEvent$QuestEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.typings.desc.DescriptionContext": Internal.ClassInfo, "cofh.core.common.block.EntityBlockActive6Way": Internal.ClassInfo, "net.minecraft.client.gui.screens.social.PlayerSocialManager": Internal.ClassInfo, "mezz.jei.api.runtime.config.IJeiConfigValueSerializer": Internal.ClassInfo, "dev.latvian.mods.kubejs.net.NetworkEventJS": Internal.ClassInfo, "com.hrznstudio.titanium.block_network.element.NetworkElement": Internal.ClassInfo, "com.mojang.serialization.MapCodec$MapCodecCodec": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedCounterBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.BambooMirrorBlock": Internal.ClassInfo, "net.minecraft.world.item.SnowballItem": Internal.ClassInfo, "net.minecraft.server.ServerScoreboard$Method": Internal.ClassInfo, "net.minecraft.advancements.CriterionTriggerInstance": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.CompostableRecipesEventJS": Internal.ClassInfo, "net.minecraft.client.resources.DownloadedPackSource": Internal.ClassInfo, "net.minecraft.world.level.material.WaterFluid$Source": Internal.ClassInfo, "net.minecraft.world.item.BowItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperUpgradeItem": Internal.ClassInfo, "net.minecraft.world.level.block.JigsawBlock": Internal.ClassInfo, "fonnymunkey.simplehats.common.item.HatItemDyeable": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakDeskBlock": Internal.ClassInfo, "net.minecraft.client.gui.navigation.ScreenRectangle": Internal.ClassInfo, "net.minecraft.world.level.validation.DirectoryValidator": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.markers.SimpleMapBlockMarker": Internal.ClassInfo, "net.mcreator.cozyhome.block.ChimneyCobblestoneBlock": Internal.ClassInfo, "net.minecraft.advancements.DisplayInfo": Internal.ClassInfo, "org.moddingx.libx.base.BlockBase$BaseBlockItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.stages.StageChangeEvent": Internal.ClassInfo, "java.lang.ref.WeakReference": Internal.ClassInfo, "letsforge_pirates.item.DeckhandItem$Helmet": Internal.ClassInfo, "journeymap.client.api.event.forge.FullscreenDisplayEvent$AddonButtonDisplayEvent": Internal.ClassInfo, "net.minecraft.commands.synchronization.ArgumentTypeInfo$Template": Internal.ClassInfo, "net.minecraft.world.item.SwordItem": Internal.ClassInfo, "net.minecraft.data.loot.LootTableSubProvider": Internal.ClassInfo, "net.minecraft.world.level.chunk.UpgradeData": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityLeaveLevelEvent": Internal.ClassInfo, "java.nio.file.attribute.BasicFileAttributes": Internal.ClassInfo, "io.netty.channel.Channel$Unsafe": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.RemoveWorldgenEventJS": Internal.ClassInfo, "com.google.common.collect.HashBiMap": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.client.AccessorFontManager": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.functions.LootItemFunction": Internal.ClassInfo, "de.keksuccino.konkrete.mixin.client.IMixinScreen": Internal.ClassInfo, "net.minecraft.world.level.block.Block": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType": Internal.ClassInfo, "com.hrznstudio.titanium.tab.TitaniumTab": Internal.ClassInfo, "net.minecraft.world.level.pathfinder.Path": Internal.ClassInfo, "net.minecraft.world.level.block.SeagrassBlock": Internal.ClassInfo, "vazkii.patchouli.common.recipe.BookRecipeSerializer": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaStorageCounterBlock": Internal.ClassInfo, "java.nio.file.attribute.FileTime": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.PresentItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.ClientInitEventJS": Internal.ClassInfo, "net.minecraft.network.protocol.PacketFlow": Internal.ClassInfo, "net.minecraft.world.entity.RelativeMovement": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.mixins.forge.SelfEntitySpawnDataMixin": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.yellow.YellowStandingSignBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundRecipePacket": Internal.ClassInfo, "com.mojang.authlib.Agent": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.StringValueFilterItem": Internal.ClassInfo, "net.minecraft.world.item.SpectralArrowItem": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerGamePacketListener": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.FeaturePlaceContext": Internal.ClassInfo, "net.minecraft.server.players.IpBanList": Internal.ClassInfo, "net.minecraft.client.renderer.texture.Stitcher$Entry": Internal.ClassInfo, "net.minecraft.world.level.block.SimpleWaterloggedBlock": Internal.ClassInfo, "io.netty.channel.ChannelPipeline": Internal.ClassInfo, "net.minecraftforge.event.server.ServerStartedEvent": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectCollection": Internal.ClassInfo, "net.minecraft.nbt.NbtAccounter": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier1Item$Chestplate": Internal.ClassInfo, "net.minecraft.world.level.block.KelpPlantBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.VariantBlockStateGenerator$Model": Internal.ClassInfo, "net.minecraft.world.item.context.BlockPlaceContext": Internal.ClassInfo, "cofh.thermal.core.util.recipes.machine.InsolatorRecipe$Serializer": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ShortFunction": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseDragged$Pre": Internal.ClassInfo, "net.minecraftforge.registries.RegistryManager": Internal.ClassInfo, "com.electronwill.nightconfig.core.ConfigSpec$CorrectionListener": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket": Internal.ClassInfo, "java.security.SignatureSpi": Internal.ClassInfo, "net.minecraft.world.level.block.PiglinWallSkullBlock": Internal.ClassInfo, "java.time.format.FormatStyle": Internal.ClassInfo, "com.google.gson.ReflectionAccessFilter$FilterResult": Internal.ClassInfo, "net.minecraft.world.level.block.SupportType": Internal.ClassInfo, "net.minecraft.client.GameNarrator": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockAccessor": Internal.ClassInfo, "com.google.common.collect.ImmutableSetMultimap$Builder": Internal.ClassInfo, "java.util.stream.DoubleStream$Builder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.AtlasSpriteRegistryEventJS": Internal.ClassInfo, "net.minecraft.world.entity.ambient.AmbientCreature": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.EndIslandFeature": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectList": Internal.ClassInfo, "org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout": Internal.ClassInfo, "java.util.concurrent.Executor": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObject2ByteFunction": Internal.ClassInfo, "cofh.core.common.block.LightningAirBlock": Internal.ClassInfo, "com.buuz135.industrial.recipe.FluidExtractorRecipe": Internal.ClassInfo, "com.buuz135.industrial.block.IndustrialBlockItem": Internal.ClassInfo, "net.minecraft.world.level.block.MultifaceSpreader": Internal.ClassInfo, "java.nio.LongBuffer": Internal.ClassInfo, "net.minecraftforge.forgespi.language.ModFileScanData": Internal.ClassInfo, "net.minecraftforge.event.level.ChunkEvent$Unload": Internal.ClassInfo, "net.mcreator.cozyhome.block.QuartzChairBlock": Internal.ClassInfo, "mezz.jei.api.runtime.config.IJeiConfigFile": Internal.ClassInfo, "net.minecraft.core.Direction": Internal.ClassInfo, "net.minecraft.world.level.SpawnData": Internal.ClassInfo, "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.FTBQuestsKubeJSTeamData": Internal.ClassInfo, "com.talhanation.smallships.world.item.ShipItem": Internal.ClassInfo, "com.obscuria.aquamirae.common.effects.CrystallizationMobEffect": Internal.ClassInfo, "cofh.lib.common.block.DetectorRailBlockCoFH": Internal.ClassInfo, "com.buuz135.industrial.block.misc.EnchantmentExtractorBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerContainerEvent$Open": Internal.ClassInfo, "net.minecraft.world.level.block.Rotation": Internal.ClassInfo, "net.minecraftforge.network.PlayMessages$SpawnEntity": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceArgument": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssenceScytheItem": Internal.ClassInfo, "dev.ftb.mods.ftbquests.item.TaskScreenConfiguratorItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.FeaturePoolElement": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.color.Color": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crop.CropType": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractRopeKnotBlock": Internal.ClassInfo, "com.buuz135.industrialforegoingsouls.block_network.SoulNetwork": Internal.ClassInfo, "net.minecraft.world.entity.ai.attributes.AttributeMap": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetHealthPacket": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$RenderContext": Internal.ClassInfo, "java.awt.event.MouseListener": Internal.ClassInfo, "java.util.function.Predicate": Internal.ClassInfo, "java.security.cert.Certificate": Internal.ClassInfo, "fonnymunkey.simplehats.util.HatEntry": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.BasicLootBoxItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem$Wrapper": Internal.ClassInfo, "net.minecraft.world.level.block.CocoaBlock": Internal.ClassInfo, "net.minecraft.world.level.block.PitcherCropBlock": Internal.ClassInfo, "mrthomas20121.thermal_extra.fluid.FluidThermalExtra$1": Internal.ClassInfo, "java.awt.image.ImageProducer": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.PickaxeItemBuilder": Internal.ClassInfo, "net.minecraftforge.event.TickEvent$Type": Internal.ClassInfo, "net.minecraft.world.level.WorldGenLevel": Internal.ClassInfo, "io.netty.buffer.ByteBuf": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.CarverDebugSettings": Internal.ClassInfo, "net.minecraft.world.entity.decoration.PaintingVariant": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.green.GreenWallHangingSignBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveBenchBlock": Internal.ClassInfo, "org.apache.maven.artifact.repository.ArtifactRepository": Internal.ClassInfo, "java.awt.JobAttributes$SidesType": Internal.ClassInfo, "net.minecraft.world.entity.monster.PatrollingMonster": Internal.ClassInfo, "net.minecraftforge.client.event.CustomizeGuiOverlayEvent": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.ChestType": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter.StonecutterUpgradeWrapper": Internal.ClassInfo, "net.minecraft.world.entity.animal.Wolf": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.AttachedData": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.EndCrystal": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonCounterBlock": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BaseCrossbowItem": Internal.ClassInfo, "dev.latvian.mods.rhino.ExternalArrayData": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.EntityTracker": Internal.ClassInfo, "net.minecraft.client.ParticleStatus": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeWrapper": Internal.ClassInfo, "net.minecraftforge.client.model.geometry.IGeometryLoader": Internal.ClassInfo, "net.minecraftforge.client.event.RenderHighlightEvent$Block": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.Passthrough": Internal.ClassInfo, "software.bernie.geckolib.core.animation.Animation$LoopType": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.FireworkRocketEntityKJS": Internal.ClassInfo, "com.mojang.blaze3d.platform.Monitor": Internal.ClassInfo, "com.hrznstudio.titanium.api.filter.IFilter$Type": Internal.ClassInfo, "net.minecraft.world.inventory.StackedContentsCompatible": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SconceWallBlock": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.PresetEditor": Internal.ClassInfo, "net.minecraft.world.item.PlaceOnWaterBlockItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2IntFunction": Internal.ClassInfo, "net.minecraftforge.event.level.SaplingGrowTreeEvent": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.weapon.RemnantsSaberItem": Internal.ClassInfo, "com.electronwill.nightconfig.core.UnmodifiableConfig$Entry": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.PlayerChatDecorateEventJS": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.SaplingGrower": Internal.ClassInfo, "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.FTBQuestsKubeJSTeamDataWrapper": Internal.ClassInfo, "java.awt.datatransfer.FlavorMap": Internal.ClassInfo, "net.minecraft.client.renderer.GpuWarnlistManager": Internal.ClassInfo, "it.unimi.dsi.fastutil.Stack": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.input.Key": Internal.ClassInfo, "javax.swing.text.MutableAttributeSet": Internal.ClassInfo, "net.minecraft.network.chat.Style": Internal.ClassInfo, "java.util.EventListener": Internal.ClassInfo, "net.minecraftforge.event.TagsUpdatedEvent": Internal.ClassInfo, "vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.level.block.TargetBlock": Internal.ClassInfo, "java.awt.PageAttributes$OrientationRequestedType": Internal.ClassInfo, "java.io.FilenameFilter": Internal.ClassInfo, "net.minecraft.commands.arguments.TimeArgument$Info$Template": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.BlockTypeBasedBlockItem": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetExperiencePacket": Internal.ClassInfo, "net.minecraft.world.level.block.LeverBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.NumberComponent": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRedstone": Internal.ClassInfo, "net.minecraftforge.client.event.ModelEvent$ModifyBakingResult": Internal.ClassInfo, "net.minecraft.world.level.block.NetherSproutsBlock": Internal.ClassInfo, "net.minecraft.server.players.UserBanList": Internal.ClassInfo, "com.blakebr0.cucumber.block.BaseGlassBlock": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeBlockAndTintGetter": Internal.ClassInfo, "net.minecraft.world.entity.EntityType$EntityFactory": Internal.ClassInfo, "com.supermartijn642.fusion.api.texture.SpriteCreationContext": Internal.ClassInfo, "net.minecraft.world.entity.npc.VillagerProfession": Internal.ClassInfo, "java.lang.StackTraceElement": Internal.ClassInfo, "net.minecraft.world.level.block.RedstoneLampBlock": Internal.ClassInfo, "journeymap.client.api.model.WrappedEntity": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.FluidCollectorTile": Internal.ClassInfo, "com.obscuria.obscureapi.common.items.FoilItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.LakeFeature": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.SouliumSpawnerRecipe$Serializer": Internal.ClassInfo, "vectorwing.farmersdelight.common.crafting.ingredient.ChanceResult": Internal.ClassInfo, "net.minecraft.world.entity.animal.TropicalFish": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.predicate.BlockPredicate": Internal.ClassInfo, "net.minecraft.world.level.chunk.ChunkGenerator": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ClientLevelKJS": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool$Projection": Internal.ClassInfo, "com.mojang.brigadier.context.ParsedCommandNode": Internal.ClassInfo, "com.talhanation.smallships.world.item.CannonItem": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BaseContainerBlockEntity": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssenceShovelItem": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.FuelItem": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseScrolled": Internal.ClassInfo, "cofh.thermal.innovation.common.item.RFCapacitorItem": Internal.ClassInfo, "net.minecraft.world.level.gameevent.BlockPositionSource": Internal.ClassInfo, "net.minecraft.client.OptionInstance$TooltipSupplier": Internal.ClassInfo, "io.netty.channel.MessageSizeEstimator": Internal.ClassInfo, "com.hrznstudio.titanium.api.IFactory": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier2Item$Chestplate": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.BlockColumnFeature": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundAddPlayerPacket": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeManager": Internal.ClassInfo, "net.minecraft.world.item.crafting.ShulkerBoxColoring": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.api.IInventoryWrapperUpgrade": Internal.ClassInfo, "net.minecraft.world.level.block.SculkSpreader$ChargeCursor": Internal.ClassInfo, "javax.accessibility.AccessibleContext": Internal.ClassInfo, "journeymap.client.api.display.IWaypointDisplay": Internal.ClassInfo, "net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity": Internal.ClassInfo, "net.minecraft.tags.TagEntry": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.CustomFilterItem": Internal.ClassInfo, "org.violetmoon.zeta.client.HumanoidArmorModelGetter": Internal.ClassInfo, "net.minecraftforge.event.level.ExplosionEvent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeCommandSourceStack": Internal.ClassInfo, "net.minecraft.client.sounds.SoundBufferLibrary": Internal.ClassInfo, "mezz.jei.api.runtime.IEditModeConfig": Internal.ClassInfo, "net.minecraft.world.inventory.PlayerEnderChestContainer": Internal.ClassInfo, "mcjty.theoneprobe.items.CreativeProbe": Internal.ClassInfo, "net.minecraft.world.level.block.WoolCarpetBlock": Internal.ClassInfo, "net.minecraft.core.HolderSet": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.TraderLlama": Internal.ClassInfo, "journeymap.client.api.model.IFullscreen": Internal.ClassInfo, "com.google.common.reflect.TypeToken": Internal.ClassInfo, "net.minecraftforge.network.ICustomPacket": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaPlankBlock": Internal.ClassInfo, "letsforge_pirates.item.Merchant2Item$Boots": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.MinecartFurnace": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchMirrorStandBlock": Internal.ClassInfo, "net.minecraft.world.level.block.entity.Hopper": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.item.crafting.AccessorShapedRecipe": Internal.ClassInfo, "net.minecraft.resources.HolderSetCodec": Internal.ClassInfo, "com.mojang.blaze3d.font.GlyphInfo": Internal.ClassInfo, "net.minecraft.util.TaskChainer$DelayedTask": Internal.ClassInfo, "io.netty.util.concurrent.GenericFutureListener": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crop.CropTier": Internal.ClassInfo, "net.minecraft.server.network.ServerGamePacketListenerImpl": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crop.Crop": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntBinaryOperator": Internal.ClassInfo, "com.benbenlaw.roomopolis.item.custom.RoomKeys.TallRoomKey": Internal.ClassInfo, "mezz.jei.api.runtime.IJeiKeyMappings": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.NoiseThresholdProvider": Internal.ClassInfo, "net.minecraft.world.entity.animal.Sheep": Internal.ClassInfo, "net.minecraft.world.item.FishingRodItem": Internal.ClassInfo, "com.hrznstudio.titanium.api.client.IScreenAddon": Internal.ClassInfo, "io.netty.util.AttributeKey": Internal.ClassInfo, "lykrast.glassential.doors.GlassLightDoorBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.predicates.LootItemConditionType": Internal.ClassInfo, "com.supermartijn642.core.data.condition.ResourceConditionSerializer": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.BlueSprayCanItem": Internal.ClassInfo, "net.minecraft.network.chat.LastSeenMessages$Packed": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier3Item$Chestplate": Internal.ClassInfo, "com.google.gson.TypeAdapter": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientGamePacketListener": Internal.ClassInfo, "com.buuz135.industrial.block.generator.tile.MycelialGeneratorTile": Internal.ClassInfo, "fr.iglee42.notenoughchests.chest.CustomChestBlock": Internal.ClassInfo, "cofh.thermal.core.common.item.FertilizerItem": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.MysticalEssenceItem": Internal.ClassInfo, "org.joml.Quaternionfc": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.ThreeBoltArmorItem$Boots": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.FluidSievingMachineBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ObjectMap$FastEntrySet": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.red.RedWallHangingSignBlock": Internal.ClassInfo, "net.minecraft.world.entity.ExperienceOrb": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BlockEntity": Internal.ClassInfo, "net.minecraftforge.event.ServerChatEvent": Internal.ClassInfo, "java.util.RegularEnumSet": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ItemFrameEntityKJS": Internal.ClassInfo, "net.minecraft.world.level.block.MushroomBlock": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEventListener": Internal.ClassInfo, "java.security.Guard": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.WoodType": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2ReferenceFunction": Internal.ClassInfo, "net.minecraft.world.entity.Shearable": Internal.ClassInfo, "net.minecraft.world.level.block.InfestedBlock": Internal.ClassInfo, "net.minecraft.client.renderer.item.ItemPropertyFunction": Internal.ClassInfo, "vazkii.patchouli.mixin.AccessorSmithingTrimRecipe": Internal.ClassInfo, "org.apache.maven.artifact.versioning.Restriction": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedWallClockBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositUpgradeItem": Internal.ClassInfo, "net.minecraft.world.ticks.TickAccess": Internal.ClassInfo, "net.minecraftforge.registries.NewRegistryEvent": Internal.ClassInfo, "dev.architectury.event.Event": Internal.ClassInfo, "org.joml.Quaterniondc": Internal.ClassInfo, "net.minecraft.core.RegistryAccess$ImmutableRegistryAccess": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.MatchingFluidsPredicate": Internal.ClassInfo, "net.minecraft.client.gui.layouts.LayoutElement": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.input.MouseButton": Internal.ClassInfo, "net.blay09.mods.balm.mixin.MouseHandlerAccessor": Internal.ClassInfo, "journeymap.client.api.display.IThemeButton": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.compacting.CompactingUpgradeItem": Internal.ClassInfo, "net.minecraft.client.renderer.texture.TextureManager": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectSet": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$MayInteractContext": Internal.ClassInfo, "net.minecraft.world.item.FireworkStarItem": Internal.ClassInfo, "net.minecraft.world.level.block.GrowingPlantBodyBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.DesertPyramidStructure": Internal.ClassInfo, "com.hrznstudio.titanium.component.sideness.ICapabilityHolder": Internal.ClassInfo, "net.minecraftforge.client.event.ModelEvent$BakingCompleted": Internal.ClassInfo, "java.nio.file.attribute.FileStoreAttributeView": Internal.ClassInfo, "cofh.lib.api.inventory.IItemStackHolder": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$TransparencyStateShard": Internal.ClassInfo, "net.minecraft.world.level.block.NetherrackBlock": Internal.ClassInfo, "com.buuz135.industrialforegoingsouls.block.SoulPipeBlock$PipeState": Internal.ClassInfo, "net.minecraft.world.item.trading.MerchantOffers": Internal.ClassInfo, "dev.latvian.mods.kubejs.registry.RegistryInfo": Internal.ClassInfo, "net.minecraft.world.level.block.MangroveRootsBlock": Internal.ClassInfo, "java.nio.ByteBuffer": Internal.ClassInfo, "net.mcreator.cozyhome.block.QuartzDeskBlock": Internal.ClassInfo, "cofh.thermal.core.common.item.LockItem": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundClientInformationPacket": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier3Item$Helmet": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.SoulExtractorBlock": Internal.ClassInfo, "cofh.thermal.locomotion.common.item.FluidMinecartItem": Internal.ClassInfo, "net.minecraft.world.level.block.DaylightDetectorBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemTooltipEventJS": Internal.ClassInfo, "net.minecraft.client.KeyboardHandler": Internal.ClassInfo, "net.blay09.mods.balm.mixin.SlotAccessor": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2ShortFunction": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.SignPostItem": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.WashingFactoryBlock": Internal.ClassInfo, "net.minecraft.world.phys.shapes.CubeVoxelShape": Internal.ClassInfo, "net.minecraft.world.entity.animal.axolotl.Axolotl$Variant": Internal.ClassInfo, "net.minecraft.world.level.block.entity.DecoratedPotBlockEntity": Internal.ClassInfo, "net.minecraft.core.BlockPos": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityTeleportEvent$EnderPearl": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.declarative.Trigger": Internal.ClassInfo, "net.minecraftforge.event.server.ServerLifecycleEvent": Internal.ClassInfo, "com.benbenlaw.roomopolis.item.custom.WallKeys.ClearWal9x4": Internal.ClassInfo, "com.blakebr0.cucumber.crafting.recipe.ShapelessTagRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.item.HoeItem": Internal.ClassInfo, "net.minecraft.world.level.ServerLevelAccessor": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSetCommandMinecartPacket": Internal.ClassInfo, "java.util.function.DoubleBinaryOperator": Internal.ClassInfo, "net.minecraft.tags.TagManager": Internal.ClassInfo, "net.minecraft.world.level.block.CaveVines": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.WaterCondensatorBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ClientPlayerNetworkEvent$LoggingOut": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.CustomAdaptation": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.type.JsonDecorationType": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2DoubleFunction": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer$MobNBTData": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.predicates.AnyOfCondition$Builder": Internal.ClassInfo, "java.lang.module.ModuleDescriptor$Modifier": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.api.IEntityToolSwapUpgrade": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.minecraft.ShapelessRecipeSchema$ShapelessRecipeJS": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crafting.ISoulExtractionRecipe": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseButtonPressed$Pre": Internal.ClassInfo, "dev.ftb.mods.ftbteams.api.TeamMessage": Internal.ClassInfo, "net.minecraft.core.AxisCycle": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractChestBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaGrayBlock": Internal.ClassInfo, "com.google.common.base.Suppliers$NonSerializableMemoizingSupplier": Internal.ClassInfo, "net.minecraft.world.level.biome.Biome$ClimateSettings": Internal.ClassInfo, "net.minecraft.world.item.enchantment.SoulSpeedEnchantment": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.ShellHornItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.bindings.BlockWrapper": Internal.ClassInfo, "net.minecraftforge.network.ServerStatusPing": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler": Internal.ClassInfo, "java.util.Spliterator$OfLong": Internal.ClassInfo, "net.minecraftforge.event.RegisterCommandsEvent": Internal.ClassInfo, "java.time.zone.ZoneOffsetTransitionRule": Internal.ClassInfo, "letsforge_pirates.item.PirateTier2Item$Helmet": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchBenchBlock": Internal.ClassInfo, "net.minecraft.world.level.biome.AmbientMoodSettings": Internal.ClassInfo, "net.minecraft.advancements.critereon.SerializationContext": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelVersion": Internal.ClassInfo, "com.yungnickyoung.minecraft.betteroceanmonuments.mixin.accessor.StructureProcessorAccessor": Internal.ClassInfo, "net.minecraft.world.entity.animal.Parrot$Variant": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.ContainerEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor": Internal.ClassInfo, "io.netty.buffer.PooledByteBufAllocator": Internal.ClassInfo, "vazkii.patchouli.common.book.Book": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2LongFunction": Internal.ClassInfo, "com.supermartijn642.fusion.api.model.ModelType": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.pink.PinkHangingSignBlock": Internal.ClassInfo, "dev.architectury.registry.menu.MenuRegistry$ScreenFactory": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundMoveEntityPacket": Internal.ClassInfo, "net.minecraft.network.TickablePacketListener": Internal.ClassInfo, "net.minecraft.world.level.chunk.LevelChunk": Internal.ClassInfo, "net.minecraft.client.User$Type": Internal.ClassInfo, "net.minecraftforge.common.util.MutableHashedLinkedMap": Internal.ClassInfo, "de.keksuccino.konkrete.events.ScreenKeyPressedEvent": Internal.ClassInfo, "vectorwing.farmersdelight.common.crafting.CookingPotRecipe$Serializer": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.FlammableBrightLeavesBlock": Internal.ClassInfo, "net.minecraft.world.level.block.RedstoneWallTorchBlock": Internal.ClassInfo, "java.nio.file.attribute.UserPrincipal": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$ArrowEntityHitContext": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseButtonReleased$Post": Internal.ClassInfo, "net.minecraft.world.entity.animal.Turtle": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.ArrayRecipeComponent": Internal.ClassInfo, "net.minecraft.world.ticks.SerializableTickContainer": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.AbstractIntSet": Internal.ClassInfo, "cofh.thermal.core.common.item.BeekeeperArmorItem": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityEvent$EntityConstructing": Internal.ClassInfo, "net.minecraft.client.resources.language.LanguageManager": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortList": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.GiantTrunkPlacer": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeAbstractMinecart": Internal.ClassInfo, "net.minecraft.world.level.dimension.DimensionType$MonsterSettings": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.FeedingUpgradeWrapper": Internal.ClassInfo, "net.minecraft.data.CachedOutput": Internal.ClassInfo, "net.minecraftforge.common.IForgeShearable": Internal.ClassInfo, "net.minecraftforge.event.level.ChunkEvent$Load": Internal.ClassInfo, "com.benbenlaw.opolisutilities.enchantment.WardenSmiteEnchantment": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ServerLevelKJS": Internal.ClassInfo, "java.awt.font.FontRenderContext": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.ByteSpliterator": Internal.ClassInfo, "com.google.gson.JsonNull": Internal.ClassInfo, "net.minecraft.world.item.crafting.RepairItemRecipe": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer$MobNBTData$Entity": Internal.ClassInfo, "net.minecraft.client.sounds.AudioStream": Internal.ClassInfo, "net.minecraft.world.level.block.FungusBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionStructure": Internal.ClassInfo, "net.minecraftforge.event.level.ExplosionEvent$Start": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ThrownExperienceBottle": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaChairBlock": Internal.ClassInfo, "net.minecraft.world.item.ArmorItem": Internal.ClassInfo, "net.minecraft.world.item.ItemDisplayContext": Internal.ClassInfo, "net.minecraft.advancements.AdvancementList$Listener": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.integration.forge.FarmersDelightCompatImpl$TomatoLoggedBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.PointedDripstoneFeature": Internal.ClassInfo, "java.util.concurrent.atomic.AtomicInteger": Internal.ClassInfo, "com.blakebr0.cucumber.item.BaseItem": Internal.ClassInfo, "net.minecraft.world.entity.VariantHolder": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.ObjectStartedEvent$FileEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration$CanyonShapeConfiguration": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.BaitItem": Internal.ClassInfo, "net.minecraft.client.color.block.BlockColor": Internal.ClassInfo, "vazkii.patchouli.client.book.gui.GuiBookEntry": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$CharacterTyped$Post": Internal.ClassInfo, "net.minecraft.server.level.progress.ChunkProgressListener": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructureCheckResult": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightFenceGateBlock": Internal.ClassInfo, "net.minecraft.world.level.block.WitherRoseBlock": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.misc.CaveFilter$Type": Internal.ClassInfo, "net.minecraft.world.item.BoneMealItem": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket": Internal.ClassInfo, "java.security.Key": Internal.ClassInfo, "java.awt.PageAttributes": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveGrandfatherClockBlock": Internal.ClassInfo, "com.google.common.collect.ForwardingSet": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.PlayerStatsJS": Internal.ClassInfo, "net.minecraft.nbt.CollectionTag": Internal.ClassInfo, "com.hrznstudio.titanium.fluid.TitaniumFluid$Source": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2BooleanFunction": Internal.ClassInfo, "com.blakebr0.cucumber.crafting.recipe.ShapedNoMirrorRecipe": Internal.ClassInfo, "net.minecraft.world.item.BrushItem": Internal.ClassInfo, "java.time.temporal.TemporalUnit": Internal.ClassInfo, "net.minecraft.client.gui.components.Button$Builder": Internal.ClassInfo, "cofh.thermal.core.common.block.SignalumBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.mixins.forge.MobBucketItemAccessor": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2DoubleFunction": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakStorageCounterBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.BidirectionalIterator": Internal.ClassInfo, "net.minecraft.world.entity.Display$RenderState": Internal.ClassInfo, "net.minecraft.world.entity.ai.attributes.AttributeModifier": Internal.ClassInfo, "java.util.stream.Stream$Builder": Internal.ClassInfo, "net.minecraft.client.gui.navigation.FocusNavigationEvent$TabNavigation": Internal.ClassInfo, "net.minecraftforge.common.capabilities.CapabilityProvider": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.DogFoodItem": Internal.ClassInfo, "net.minecraft.client.model.HumanoidModel": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakWallClockBlock": Internal.ClassInfo, "net.minecraft.network.chat.SignedMessageBody": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.ShipGraveyardEchoItem": Internal.ClassInfo, "java.time.Period": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonMirrorBlock": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.set.BlockType": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchDrawerBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerInteractEvent$RightClickEmpty": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.EntityArrayList": Internal.ClassInfo, "com.supermartijn642.fusion.api.texture.SpritePreparationContext": Internal.ClassInfo, "net.minecraft.world.phys.Vec2": Internal.ClassInfo, "net.minecraft.world.phys.Vec3": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe": Internal.ClassInfo, "com.eliotlash.mclib.math.IValue": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.LaserDrillTile": Internal.ClassInfo, "net.minecraft.core.HolderGetter$Provider": Internal.ClassInfo, "com.jtorleonstudios.libraryferret.worldgen.structures.AwesomeStructure": Internal.ClassInfo, "dev.latvian.mods.itemfilters.api.IItemFilter": Internal.ClassInfo, "net.minecraft.world.item.Equipable": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.JsonRecipeJS": Internal.ClassInfo, "cofh.thermal.core.common.item.FlorbItem": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryEventType": Internal.ClassInfo, "net.minecraft.data.DataProvider$Factory": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator": Internal.ClassInfo, "java.lang.invoke.TypeDescriptor": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundCommandsPacket": Internal.ClassInfo, "it.unimi.dsi.fastutil.Function": Internal.ClassInfo, "java.time.chrono.ChronoLocalDateTime": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.MelonJuiceItem": Internal.ClassInfo, "net.minecraft.world.item.BowlFoodItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.StairBlockBuilder": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.present.IPresentItemBehavior": Internal.ClassInfo, "net.minecraft.world.level.block.TintedGlassBlock": Internal.ClassInfo, "com.obscuria.aquamirae.common.worldgen.feature.WisteriaFeature": Internal.ClassInfo, "net.minecraft.world.level.lighting.LightEngine": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier3Item": Internal.ClassInfo, "cofh.lib.common.fluid.FluidIngredient$IFluidList": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crop.CropRecipes": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.EventResult": Internal.ClassInfo, "com.mojang.brigadier.SingleRedirectModifier": Internal.ClassInfo, "net.minecraft.world.level.gameevent.PositionSourceType": Internal.ClassInfo, "yalter.mousetweaks.mixin.AbstractContainerScreenAccessor": Internal.ClassInfo, "net.minecraft.world.inventory.BrewingStandMenu": Internal.ClassInfo, "com.mojang.datafixers.types.families.TypeFamily": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ModifiableItemKJS": Internal.ClassInfo, "mcjty.theoneprobe.items.ModItems$1": Internal.ClassInfo, "cofh.thermal.core.common.block.EnderiumBlock": Internal.ClassInfo, "net.minecraft.world.phys.shapes.DiscreteVoxelShape$IntLineConsumer": Internal.ClassInfo, "net.minecraft.util.StringRepresentable$EnumCodec": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.NetherWorldCarver": Internal.ClassInfo, "java.awt.font.GlyphMetrics": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeWrapper$SmeltingUpgradeWrapper": Internal.ClassInfo, "net.minecraft.world.Difficulty": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.ItemInfinity": Internal.ClassInfo, "net.minecraft.client.OptionInstance$Enum": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.ItemTransforms": Internal.ClassInfo, "net.minecraft.client.renderer.RenderType": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BaseShovelItem": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.WrenchItem": Internal.ClassInfo, "java.awt.image.TileObserver": Internal.ClassInfo, "com.hrznstudio.titanium.block.tile.ITickableBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.PlacedFeature": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModInfo$ModVersion": Internal.ClassInfo, "java.lang.invoke.TypeDescriptor$OfMethod": Internal.ClassInfo, "net.minecraft.world.entity.ai.village.poi.PoiManager": Internal.ClassInfo, "journeymap.client.api.event.forge.EntityRadarUpdateEvent": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerInteractEvent$RightClickBlock": Internal.ClassInfo, "net.minecraftforge.client.event.InputEvent$InteractionKeyMappingTriggered": Internal.ClassInfo, "net.blay09.mods.balm.mixin.KeyMappingAccessor": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2FloatFunction": Internal.ClassInfo, "dev.latvian.mods.unit.token.UnitTokenStream": Internal.ClassInfo, "net.minecraft.world.level.block.entity.SmokerBlockEntity": Internal.ClassInfo, "com.buuz135.industrial.block.tile.IndustrialProcessingTile": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.FenceGateBlockBuilder": Internal.ClassInfo, "net.minecraft.client.model.geom.ModelPart": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.DispenserMinecartItem": Internal.ClassInfo, "com.gizmo.luggage.item.EnderLuggageItem": Internal.ClassInfo, "net.minecraft.advancements.AdvancementProgress": Internal.ClassInfo, "net.minecraft.world.level.storage.DataVersion": Internal.ClassInfo, "net.mcreator.cozyhome.block.OrangeLampBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.properties.RemoveSpawnsProperties": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket$Action": Internal.ClassInfo, "java.awt.Font": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.DyeMixerTile": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2ObjectFunction": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.SimplePlayerEventJS": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.RotationAxis": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.SoulJarEmptyRecipe$Serializer": Internal.ClassInfo, "com.obscuria.aquamirae.common.blocks.JarBlock": Internal.ClassInfo, "net.darkhax.bookshelf.impl.data.recipes.crafting.ShapedDurabilityRecipe": Internal.ClassInfo, "net.minecraft.client.gui.components.TabOrderedElement": Internal.ClassInfo, "java.util.AbstractSequentialList": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.PlantGathererTile": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.AlwaysFalseFilterItem": Internal.ClassInfo, "net.minecraftforge.registries.IForgeRegistryInternal": Internal.ClassInfo, "net.minecraftforge.event.LootTableLoadEvent": Internal.ClassInfo, "fonnymunkey.simplehats.common.item.HatItem": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.ComponentRole": Internal.ClassInfo, "net.minecraft.client.multiplayer.ClientAdvancements$Listener": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FlippedBlock": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.color.NoColor": Internal.ClassInfo, "net.minecraft.world.level.block.DetectorRailBlock": Internal.ClassInfo, "com.probejs.jdoc.java.MethodInfo": Internal.ClassInfo, "dev.ftb.mods.ftbultimine.mixin.ShovelItemAccess": Internal.ClassInfo, "tfar.dankstorage.mixin.ItemUsageContextAccessor": Internal.ClassInfo, "net.minecraft.advancements.FrameType": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.entities.BombEntity": Internal.ClassInfo, "java.awt.AWTEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeComponentFactory": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.IEventHandler": Internal.ClassInfo, "net.minecraft.world.item.crafting.ShapelessRecipe": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.ConveyorBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.tiles.CageBlockTile": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.task.CustomTask$Data": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.item.ItemShroudKey": Internal.ClassInfo, "net.minecraft.client.renderer.entity.player.PlayerRenderer": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ItemEntityKJS": Internal.ClassInfo, "com.mojang.authlib.minecraft.BanDetails": Internal.ClassInfo, "net.minecraft.world.level.GameRules$Type": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.mixin.accessor.StructureTemplatePoolAccessor": Internal.ClassInfo, "net.minecraft.client.renderer.debug.BeeDebugRenderer": Internal.ClassInfo, "cofh.core.common.fluid.HoneyFluid$1": Internal.ClassInfo, "net.minecraft.world.phys.HitResult": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2ObjectFunction": Internal.ClassInfo, "de.keksuccino.fancymenu.util.rendering.ui.screen.CustomizableScreen": Internal.ClassInfo, "net.minecraft.world.item.CreativeModeTab$TabVisibility": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket": Internal.ClassInfo, "net.minecraft.network.chat.SignableCommand$Argument": Internal.ClassInfo, "java.time.ZonedDateTime": Internal.ClassInfo, "com.obscuria.obscureapi.api.common.classes.Ability$Builder": Internal.ClassInfo, "java.lang.Record": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.ItemRepairerBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ModelEvent": Internal.ClassInfo, "io.netty.util.concurrent.AbstractEventExecutorGroup": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.LockBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.script.ScriptTypeHolder": Internal.ClassInfo, "cofh.thermal.core.common.fluid.GlowstoneFluid$1": Internal.ClassInfo, "net.minecraft.server.players.BanListEntry": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.ResourcefulFurnaceBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$KeyReleased": Internal.ClassInfo, "journeymap.client.api.display.Waypoint": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.DoubleBlockHalf": Internal.ClassInfo, "com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent": Internal.ClassInfo, "net.minecraft.client.gui.components.PlayerTabOverlay": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.GolemSensor": Internal.ClassInfo, "java.security.Permission": Internal.ClassInfo, "net.minecraftforge.event.entity.player.ItemTooltipEvent": Internal.ClassInfo, "net.minecraft.world.level.entity.EntityInLevelCallback": Internal.ClassInfo, "net.minecraft.network.protocol.Packet": Internal.ClassInfo, "com.hrznstudio.titanium.api.client.IScreenAddonProvider": Internal.ClassInfo, "tax.taknax.taxov.item.PirateSuitItem$Leggings": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier1Item$Helmet": Internal.ClassInfo, "net.minecraftforge.fml.event.config.ModConfigEvent$Reloading": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket": Internal.ClassInfo, "net.minecraft.world.level.BaseCommandBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2IntFunction": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FodderBlock": Internal.ClassInfo, "net.minecraft.nbt.StreamTagVisitor": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.CombiningPredicate": Internal.ClassInfo, "com.mojang.serialization.codecs.SimpleMapCodec": Internal.ClassInfo, "net.minecraft.world.item.CompassItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blending.Blender$DistanceGetter": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier1Item$Helmet": Internal.ClassInfo, "journeymap.client.api.model.WaypointBase": Internal.ClassInfo, "com.mojang.datafixers.types.families.RecursiveTypeFamily": Internal.ClassInfo, "java.lang.constant.DirectMethodHandleDesc": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem": Internal.ClassInfo, "net.minecraftforge.fml.IExtensionPoint$DisplayTest": Internal.ClassInfo, "com.electronwill.nightconfig.core.UnmodifiableCommentedConfig$CommentNode": Internal.ClassInfo, "com.mojang.math.Transformation": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.BoneAnimationQueue": Internal.ClassInfo, "letsforge_pirates.item.PirateTier2Item": Internal.ClassInfo, "com.obscuria.aquamirae.common.effects.StrongArmorMobEffect": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.ObjectStartedEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.WorldCarver": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$CollidingEntityContext": Internal.ClassInfo, "javax.accessibility.AccessibleTable": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.Sensor": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.tile.BlackHoleControllerTile": Internal.ClassInfo, "net.minecraftforge.event.entity.player.ArrowNockEvent": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPongPacket": Internal.ClassInfo, "net.minecraft.client.Options": Internal.ClassInfo, "net.minecraft.client.sounds.Weighted": Internal.ClassInfo, "dev.latvian.mods.kubejs.server.CustomCommandEventJS": Internal.ClassInfo, "net.minecraft.world.level.levelgen.Heightmap": Internal.ClassInfo, "com.mojang.realmsclient.gui.task.RepeatedDelayStrategy": Internal.ClassInfo, "net.minecraft.client.gui.components.AbstractWidget": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityEvent": Internal.ClassInfo, "net.minecraft.resources.ResourceLocation": Internal.ClassInfo, "net.minecraft.client.Realms32BitWarningStatus": Internal.ClassInfo, "net.minecraft.world.InteractionResultHolder": Internal.ClassInfo, "dev.ftb.mods.ftbteams.api.property.PrivacyMode": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaCyanBlock": Internal.ClassInfo, "net.minecraft.server.level.progress.StoringChunkProgressListener": Internal.ClassInfo, "dev.latvian.mods.kubejs.registry.BuilderType": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.BlockContainerJS": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.EnderDragon": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.event.data.KeyFrameData": Internal.ClassInfo, "java.util.concurrent.Delayed": Internal.ClassInfo, "net.liopyu.entityjs.util.implementation.EventBasedSpawnModifier": Internal.ClassInfo, "cofh.thermal.cultivation.common.block.FlaxCrop": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BaseHoeItem": Internal.ClassInfo, "java.security.DomainCombiner": Internal.ClassInfo, "net.minecraft.network.chat.FilterMask": Internal.ClassInfo, "net.minecraft.world.level.material.LavaFluid$Flowing": Internal.ClassInfo, "net.mcreator.cozyhome.block.BrownLampBlock": Internal.ClassInfo, "net.minecraft.world.level.GameRules": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.green.GreenStandingSignBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.CraftingContainerKJS": Internal.ClassInfo, "java.time.Instant": Internal.ClassInfo, "com.mojang.brigadier.ImmutableStringReader": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$PassengerEntityContext": Internal.ClassInfo, "net.minecraft.client.renderer.texture.AbstractTexture": Internal.ClassInfo, "net.minecraft.world.level.block.GrowingPlantHeadBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssenceAxeItem": Internal.ClassInfo, "net.minecraftforge.common.world.ModifiableBiomeInfo$BiomeInfo$Builder": Internal.ClassInfo, "letsforge_pirates.item.PirateTier2Item$Leggings": Internal.ClassInfo, "mezz.jei.api.recipe.transfer.IRecipeTransferError$Type": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsNotification": Internal.ClassInfo, "mezz.jei.api.gui.drawable.IDrawable": Internal.ClassInfo, "net.minecraft.world.level.block.BucketPickup": Internal.ClassInfo, "com.buuz135.industrial.api.transporter.TransporterTypeFactory": Internal.ClassInfo, "com.electronwill.nightconfig.core.EnumGetMethod": Internal.ClassInfo, "net.minecraftforge.eventbus.api.IEventBus": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock": Internal.ClassInfo, "java.net.Proxy$Type": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityAttributeCreationEvent": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.cyan.CyanWallHangingSignBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.HatStandItem": Internal.ClassInfo, "dev.latvian.mods.rhino.BaseFunction": Internal.ClassInfo, "java.awt.event.HierarchyEvent": Internal.ClassInfo, "letsforge_pirates.item.Merchant1Item$Leggings": Internal.ClassInfo, "fr.iglee42.igleelib.common.init.ModItem$1": Internal.ClassInfo, "com.blakebr0.cucumber.crafting.recipe.ShapedTransferNBTRecipe": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SconceBlock": Internal.ClassInfo, "java.lang.Appendable": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$ItemCraftedEvent": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties$RakeDirection": Internal.ClassInfo, "net.minecraft.nbt.StreamTagVisitor$EntryResult": Internal.ClassInfo, "net.minecraft.world.level.block.DispenserBlock": Internal.ClassInfo, "com.mojang.blaze3d.shaders.FogShape": Internal.ClassInfo, "com.buuz135.industrial.item.ItemStraw": Internal.ClassInfo, "letsforge_pirates.item.Skull5Item": Internal.ClassInfo, "net.minecraft.world.level.levelgen.GeodeLayerSettings": Internal.ClassInfo, "java.lang.Object": Internal.ClassInfo, "java.awt.CompositeContext": Internal.ClassInfo, "dev.architectury.registry.registries.RegistrySupplier": Internal.ClassInfo, "net.minecraft.util.profiling.metrics.MetricSampler$MetricSamplerBuilder": Internal.ClassInfo, "com.mojang.brigadier.ResultConsumer": Internal.ClassInfo, "net.minecraft.world.level.block.TripWireBlock": Internal.ClassInfo, "java.awt.ImageCapabilities": Internal.ClassInfo, "net.minecraft.world.item.crafting.DecoratedPotRecipe": Internal.ClassInfo, "javax.accessibility.AccessibleSelection": Internal.ClassInfo, "net.minecraftforge.event.entity.ProjectileImpactEvent": Internal.ClassInfo, "java.lang.module.ModuleDescriptor$Exports$Modifier": Internal.ClassInfo, "net.minecraft.world.item.Item": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.DynamicRecipeComponent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ItemSupplier": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2ObjectFunction": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.HoeItemBuilder": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.task.CustomTask": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightSlabBlock": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampPillarFeature": Internal.ClassInfo, "net.minecraft.world.entity.decoration.HangingEntity": Internal.ClassInfo, "net.minecraft.client.renderer.debug.GoalSelectorDebugRenderer$DebugGoal": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleMirrorBlock": Internal.ClassInfo, "net.minecraft.network.protocol.BundleDelimiterPacket": Internal.ClassInfo, "net.minecraftforge.event.entity.player.ItemFishedEvent": Internal.ClassInfo, "vazkii.patchouli.xplat.XplatModContainer": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.GiftLootEventJS": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.neptunium.NeptuniumArmor": Internal.ClassInfo, "net.minecraft.network.chat.SignedMessageChain$Decoder": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.EnderOreBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.server.ServerEventJS": Internal.ClassInfo, "net.minecraft.world.entity.projectile.FishingHook": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ByteSortedMap$FastSortedEntrySet": Internal.ClassInfo, "com.talhanation.smallships.mixin.container.SimpleContainerAccessor": Internal.ClassInfo, "cofh.thermal.cultivation.common.block.AmaranthCrop": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersStandard": Internal.ClassInfo, "net.mcreator.cozyhome.block.JunglePlankBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.BellowsBlock": Internal.ClassInfo, "net.minecraft.world.item.EmptyMapItem": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.mixin.accessor.SinglePoolElementAccessor": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.LootTableEntry": Internal.ClassInfo, "cofh.core.common.item.BoatItemCoFH": Internal.ClassInfo, "net.minecraft.world.level.block.CherryLeavesBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.predicates.LootItemCondition$Builder": Internal.ClassInfo, "net.minecraft.world.level.block.VineBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaWallClockBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2CharFunction": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack": Internal.ClassInfo, "net.minecraft.world.item.ItemFrameItem": Internal.ClassInfo, "tamaized.melongolem.common.EntityTinyMelonGolem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeItem": Internal.ClassInfo, "net.minecraft.world.level.dimension.LevelStem": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier2Item": Internal.ClassInfo, "vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor": Internal.ClassInfo, "net.minecraft.nbt.ListTag": Internal.ClassInfo, "net.minecraft.world.entity.GlowSquid": Internal.ClassInfo, "net.minecraft.world.level.block.TrappedChestBlock": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.SewerTile": Internal.ClassInfo, "java.net.URL": Internal.ClassInfo, "net.minecraft.world.scores.Score": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.RockGenMapping$Serializer": Internal.ClassInfo, "org.objectweb.asm.Type": Internal.ClassInfo, "com.scouter.oceansdelight.blocks.GuardianSoupBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.AnyOfPredicate": Internal.ClassInfo, "net.minecraft.world.level.block.HayBlock": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.SquidEntityAccessor": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationProcessor": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.BambooFeature": Internal.ClassInfo, "java.nio.file.PathMatcher": Internal.ClassInfo, "net.minecraft.util.BitStorage": Internal.ClassInfo, "java.net.URI": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier2Item$Leggings": Internal.ClassInfo, "net.minecraft.client.resources.metadata.animation.AnimationMetadataSectionSerializer": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.ConveyorBlock$EnumType": Internal.ClassInfo, "com.mojang.datafixers.kinds.Functor$Mu": Internal.ClassInfo, "io.netty.buffer.AbstractByteBuf": Internal.ClassInfo, "net.minecraft.client.renderer.block.ModelBlockRenderer": Internal.ClassInfo, "net.minecraft.world.inventory.InventoryMenu": Internal.ClassInfo, "cofh.thermal.core.common.fluid.HeavyOilFluid$1": Internal.ClassInfo, "java.util.Optional": Internal.ClassInfo, "dev.latvian.mods.rhino.WrappedExecutable": Internal.ClassInfo, "net.minecraft.server.ReloadableServerResources": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.IWashable": Internal.ClassInfo, "net.minecraft.network.chat.ChatDecorator": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.AdvancementJS": Internal.ClassInfo, "vectorwing.farmersdelight.common.registry.ModItems$1": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.misc.StasisEnchantment": Internal.ClassInfo, "net.minecraft.world.level.block.entity.SignBlockEntity": Internal.ClassInfo, "java.util.Hashtable": Internal.ClassInfo, "com.obscuria.obscureapi.registry.ObscureAPIItems$1": Internal.ClassInfo, "net.minecraft.network.chat.ComponentContents": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ByteMap$Entry": Internal.ClassInfo, "com.mojang.blaze3d.platform.VideoMode": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$Builder": Internal.ClassInfo, "net.minecraft.client.CloudStatus": Internal.ClassInfo, "com.jtorleonstudios.awesomedungeonocean.AwsOceanStructure$AwesomeDungeonStructure": Internal.ClassInfo, "net.minecraftforge.common.world.StructureModifier$Phase": Internal.ClassInfo, "com.hrznstudio.titanium.block.tile.BasicTile": Internal.ClassInfo, "net.minecraft.world.item.crafting.FireworkStarRecipe": Internal.ClassInfo, "dev.latvian.mods.kubejs.gui.chest.ChestMenuClickHandler": Internal.ClassInfo, "net.minecraft.client.resources.model.UnbakedModel": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertObeliskFeature": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.AddWorldgenEventJS": Internal.ClassInfo, "net.minecraft.world.entity.monster.Silverfish": Internal.ClassInfo, "net.minecraft.SystemReport": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.PoiTypeBuilder": Internal.ClassInfo, "net.liopyu.entityjs.item.SpawnEggItemBuilder": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeFriendlyByteBuf": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapperAccessor": Internal.ClassInfo, "com.google.gson.JsonDeserializationContext": Internal.ClassInfo, "net.minecraftforge.api.distmarker.Dist": Internal.ClassInfo, "net.liopyu.entityjs.events.AddGoalSelectorsEventJS": Internal.ClassInfo, "java.nio.file.Path": Internal.ClassInfo, "tech.thatgravyboat.duckling.common.items.HolidayFruitCakeBlock": Internal.ClassInfo, "mezz.jei.api.recipe.transfer.IRecipeTransferManager": Internal.ClassInfo, "letsforge_pirates.item.DeckhandItem$Chestplate": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.BlockItemWithoutLevelRenderer": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.MinecartHopper": Internal.ClassInfo, "net.minecraft.world.RandomSequences": Internal.ClassInfo, "net.minecraft.client.resources.sounds.SoundInstance": Internal.ClassInfo, "java.time.temporal.TemporalField": Internal.ClassInfo, "net.minecraft.commands.arguments.EntityArgument$Info": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.Keyframe": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier2Item$Helmet": Internal.ClassInfo, "net.minecraft.commands.arguments.ArgumentSignatures$Signer": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType": Internal.ClassInfo, "java.util.function.ToDoubleFunction": Internal.ClassInfo, "net.minecraft.world.level.block.piston.PistonBaseBlock": Internal.ClassInfo, "mezz.jei.api.recipe.transfer.IRecipeTransferHandler": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.FluidGeneratorRecipe$Serializer": Internal.ClassInfo, "net.minecraftforge.common.capabilities.ICapabilityProvider": Internal.ClassInfo, "com.supermartijn642.fusion.api.util.Serializer": Internal.ClassInfo, "net.minecraft.core.particles.DustParticleOptions": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket": Internal.ClassInfo, "dev.latvian.mods.rhino.Script": Internal.ClassInfo, "java.text.AttributedCharacterIterator$Attribute": Internal.ClassInfo, "java.util.Calendar": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.BlockBuilder": Internal.ClassInfo, "net.minecraft.world.entity.ai.attributes.AttributeInstance": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.RopeItem": Internal.ClassInfo, "org.moddingx.libx.command.EnumArgument2$Info": Internal.ClassInfo, "java.util.concurrent.ScheduledExecutorService": Internal.ClassInfo, "net.minecraft.stats.Stats": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.BlackHoleTankBlock$BlackHoleTankItem": Internal.ClassInfo, "net.minecraft.world.entity.Display$TextDisplay": Internal.ClassInfo, "net.minecraft.world.level.BlockAndTintGetter": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.DrinkableItem": Internal.ClassInfo, "net.minecraftforge.client.IItemDecorator": Internal.ClassInfo, "net.minecraft.world.entity.ai.attributes.AttributeModifier$Operation": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.ObjectStartedEvent$TaskEvent": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.GlowstoneSprayCanItem": Internal.ClassInfo, "net.minecraft.world.item.ComplexItem": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.AbstractMinecart": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.CreativeModeTabKJS": Internal.ClassInfo, "net.minecraft.world.item.enchantment.WaterWorkerEnchantment": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ThornsEnchantment": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.ChatLog": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaDrawerBlock": Internal.ClassInfo, "dev.architectury.hooks.level.biome.EffectsProperties": Internal.ClassInfo, "cofh.core.common.effect.PanaceaMobEffect": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.WorldCreationContext$OptionsModifier": Internal.ClassInfo, "net.minecraft.util.random.Weight": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.AnimalPanic": Internal.ClassInfo, "lykrast.glassential.doors.GlassTrapDoorBlock": Internal.ClassInfo, "net.minecraft.world.WorldlyContainerHolder": Internal.ClassInfo, "java.time.InstantSource": Internal.ClassInfo, "cofh.lib.api.IResourceStorage": Internal.ClassInfo, "net.minecraft.world.level.GameRules$Category": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.StrongNBTFilterItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingUpgradeItem$Wrapper": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.PlacementModifierType": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.fluids.FoodProvider": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.TrappedPresentBlock": Internal.ClassInfo, "net.minecraftforge.fml.config.ConfigFileTypeHandler": Internal.ClassInfo, "java.util.function.LongToDoubleFunction": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2FloatMap$Entry": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties$Rune": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.StringConfig": Internal.ClassInfo, "net.minecraft.core.HolderSet$Direct": Internal.ClassInfo, "net.minecraft.world.inventory.RecipeHolder": Internal.ClassInfo, "com.hrznstudio.titanium.client.screen.asset.IHasAssetProvider": Internal.ClassInfo, "net.minecraft.advancements.AdvancementList": Internal.ClassInfo, "net.minecraft.client.searchtree.RefreshableSearchTree": Internal.ClassInfo, "com.google.common.reflect.Invokable": Internal.ClassInfo, "net.minecraftforge.client.gui.overlay.NamedGuiOverlay": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.tinkering.AugmentType": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.ReplaceSphereConfiguration": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.VariantBlockStateGenerator": Internal.ClassInfo, "com.obscuria.aquamirae.common.blocks.WisteriaNiveisBlock": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.Tristate": Internal.ClassInfo, "net.minecraft.client.renderer.chunk.RenderChunkRegion": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.BlockElementFace": Internal.ClassInfo, "net.minecraft.world.level.block.SoulSandBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterColorHandlersEvent$Block": Internal.ClassInfo, "java.util.Locale$Category": Internal.ClassInfo, "net.minecraft.world.entity.player.PlayerModelPart": Internal.ClassInfo, "net.minecraft.world.level.block.WitherSkullBlock": Internal.ClassInfo, "java.lang.Package": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FeatherBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.WorldDimensions$Complete": Internal.ClassInfo, "net.minecraft.world.phys.EntityHitResult": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.PlayerEventJS": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundAnimatePacket": Internal.ClassInfo, "com.llamalad7.mixinextras.sugar.ref.LocalIntRef": Internal.ClassInfo, "java.util.function.Consumer": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.callbacks.BlockStateModifyCallbackJS": Internal.ClassInfo, "mezz.jei.api.ingredients.IIngredientTypeWithSubtypes": Internal.ClassInfo, "java.util.concurrent.ConcurrentHashMap$CollectionView": Internal.ClassInfo, "java.time.format.DateTimeFormatter": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.DirectionProperty": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.ReplacementMatch": Internal.ClassInfo, "net.minecraft.world.level.block.BonemealableBlock": Internal.ClassInfo, "java.security.KeyPair": Internal.ClassInfo, "net.minecraftforge.client.event.RenderGuiEvent$Post": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterGuiOverlaysEvent": Internal.ClassInfo, "com.buuz135.industrial.block.core.tile.FluidExtractorTile": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.icon.Icon": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagKeyArgument$Info$Template": Internal.ClassInfo, "net.minecraft.world.level.block.FurnaceBlock": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.TagFilterItem": Internal.ClassInfo, "net.minecraft.world.entity.SpawnPlacements$SpawnPredicate": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.BooleanProperty": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer": Internal.ClassInfo, "net.minecraftforge.client.event.RenderHandEvent": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.weapon.TerribleSwordItem": Internal.ClassInfo, "dev.architectury.core.item.ArchitecturyBucketItem": Internal.ClassInfo, "net.minecraft.world.level.biome.Biome$Precipitation": Internal.ClassInfo, "org.apache.logging.log4j.MarkerManager$Log4jMarker": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObject2ByteMap": Internal.ClassInfo, "com.mojang.realmsclient.dto.ValueObject": Internal.ClassInfo, "java.util.EnumMap": Internal.ClassInfo, "net.minecraft.client.gui.navigation.FocusNavigationEvent": Internal.ClassInfo, "java.time.chrono.Chronology": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.HotCocoaItem": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$Action": Internal.ClassInfo, "com.mojang.blaze3d.platform.InputConstants$Type": Internal.ClassInfo, "dev.ftb.mods.ftbteams.api.Team": Internal.ClassInfo, "net.minecraft.world.level.block.BigDripleafBlock": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.entity.AccessorMob": Internal.ClassInfo, "com.google.common.collect.SingletonImmutableSet": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntCollection": Internal.ClassInfo, "net.darkhax.bookshelf.impl.data.recipes.crafting.ShapedDurabilityRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.properties.AddLakeProperties": Internal.ClassInfo, "com.buuz135.industrial.item.ItemTransporterType": Internal.ClassInfo, "net.minecraftforge.client.event.InputEvent$Key": Internal.ClassInfo, "dev.latvian.mods.rhino.util.wrap.TypeWrappers": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.FeastBlock": Internal.ClassInfo, "com.mojang.serialization.DataResult": Internal.ClassInfo, "com.electronwill.nightconfig.core.file.FileConfig": Internal.ClassInfo, "net.liopyu.entityjs.builders.BaseLivingEntityBuilder$ICustomInstructionListenerJS": Internal.ClassInfo, "net.minecraftforge.client.event.EntityRenderersEvent$RegisterLayerDefinitions": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.HeightProviderType": Internal.ClassInfo, "com.blakebr0.cucumber.item.BaseBlockItem": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties$PostType": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer": Internal.ClassInfo, "net.minecraft.world.level.timers.TimerCallback": Internal.ClassInfo, "org.slf4j.Marker": Internal.ClassInfo, "com.talhanation.smallships.duck.CameraZoomAccess": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakFireplaceBlock": Internal.ClassInfo, "java.awt.im.InputMethodHighlight": Internal.ClassInfo, "net.minecraft.client.color.item.ItemColor": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.misc.IExtendedPistonTile": Internal.ClassInfo, "java.util.concurrent.ScheduledFuture": Internal.ClassInfo, "cofh.core.common.item.CoinItem": Internal.ClassInfo, "org.joml.Matrix4x3d": Internal.ClassInfo, "net.minecraft.world.level.block.BeaconBlock": Internal.ClassInfo, "org.joml.Matrix4x3f": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.GenerateClientAssetsEventJS": Internal.ClassInfo, "net.minecraft.world.entity.player.Inventory": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.IMagnetPreventionChecker": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.JarItem": Internal.ClassInfo, "net.minecraft.world.item.ChorusFruitItem": Internal.ClassInfo, "net.minecraft.world.entity.player.Player$BedSleepingProblem": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.soul.MobSoulType": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterClientReloadListenersEvent": Internal.ClassInfo, "dev.latvian.mods.unit.UnitVariables": Internal.ClassInfo, "net.minecraft.world.DifficultyInstance": Internal.ClassInfo, "java.time.OffsetTime": Internal.ClassInfo, "com.mojang.brigadier.suggestion.Suggestions": Internal.ClassInfo, "javax.accessibility.AccessibleState": Internal.ClassInfo, "top.theillusivec4.curios.api.type.capability.ICurio$SoundInfo": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.PlayTagWithOtherKids": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryProperty": Internal.ClassInfo, "com.mojang.serialization.Codec$ResultFunction": Internal.ClassInfo, "lykrast.glassential.blocks.EtherealGlassBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.entries.LootPoolEntryType": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.RandomState": Internal.ClassInfo, "com.hrznstudio.titanium.api.client.IAssetType": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.SoulExtractionRecipe": Internal.ClassInfo, "net.minecraft.world.item.enchantment.LootBonusEnchantment": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.HugeRedMushroomFeature": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder$Helmet": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$WriteMaskStateShard": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.CherryTrunkPlacer": Internal.ClassInfo, "com.mojang.datafixers.util.Unit": Internal.ClassInfo, "java.util.AbstractSet": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.state.CookingPotSupport": Internal.ClassInfo, "net.minecraft.util.valueproviders.ClampedInt": Internal.ClassInfo, "net.minecraft.world.level.block.SculkBlock": Internal.ClassInfo, "net.minecraft.world.level.block.CalibratedSculkSensorBlock": Internal.ClassInfo, "letsforge_pirates.item.Skull4Item$Helmet": Internal.ClassInfo, "net.minecraft.client.model.HumanoidModel$ArmPose": Internal.ClassInfo, "com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.ModifyRecipeCraftingGrid": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.AbstractMinecartContainer": Internal.ClassInfo, "com.probejs.jdoc.document.DocumentMethod": Internal.ClassInfo, "dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity": Internal.ClassInfo, "com.mojang.authlib.minecraft.TelemetryPropertyContainer": Internal.ClassInfo, "net.minecraft.world.level.block.Fallable": Internal.ClassInfo, "vazkii.patchouli.client.book.template.TemplateInclusion": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.PotionBuilder": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder$Chestplate": Internal.ClassInfo, "net.minecraft.world.entity.ai.attributes.Attribute": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.inventory.AccessorCraftingMenu": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ArrowInfiniteEnchantment": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$RenderInventoryMobEffects": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.RakedGravelBlock": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.orange.OrangeWallSignBlock": Internal.ClassInfo, "net.minecraft.world.level.block.MudBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedChairBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.ClockBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.crafting.SmithingBackpackUpgradeRecipe$Serializer": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchDeskBlock": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.AnimationPointQueue": Internal.ClassInfo, "net.minecraft.world.level.block.HangingRootsBlock": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$OverlayStateShard": Internal.ClassInfo, "net.minecraft.world.level.block.EquipableCarvedPumpkinBlock": Internal.ClassInfo, "java.util.jar.Manifest": Internal.ClassInfo, "io.netty.util.AttributeMap": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.BlockPlacerBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.armor.EssenceHelmetItem": Internal.ClassInfo, "io.netty.util.concurrent.ScheduledFuture": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.NumberComponent$IntRange": Internal.ClassInfo, "net.minecraft.core.Holder": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.Swim": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.RoastChickenBlock": Internal.ClassInfo, "com.electronwill.nightconfig.core.UnmodifiableCommentedConfig$Entry": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundJigsawGeneratePacket": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.WitherproofGlassBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedPlankBlock": Internal.ClassInfo, "com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory": Internal.ClassInfo, "java.awt.font.GlyphJustificationInfo": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$RangeChoice": Internal.ClassInfo, "net.minecraft.world.level.block.CakeBlock": Internal.ClassInfo, "java.lang.module.ModuleDescriptor$Version": Internal.ClassInfo, "net.minecraft.world.entity.monster.Ravager": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2ShortFunction": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.BakedQuad": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket$Action": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.ItemTransform": Internal.ClassInfo, "net.minecraftforge.client.event.RenderHighlightEvent": Internal.ClassInfo, "dev.latvian.mods.rhino.UniqueTag": Internal.ClassInfo, "net.minecraft.world.level.block.WallHangingSignBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.SoulJarEmptyRecipe": Internal.ClassInfo, "mcjty.theoneprobe.items.AddProbeTagRecipe": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.ILightable$FireSourceType": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.Half": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.meta.BlockMetaSized": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.SkilletItem": Internal.ClassInfo, "io.netty.channel.ChannelOption": Internal.ClassInfo, "dev.latvian.mods.kubejs.command.CommandRegistryEventJS": Internal.ClassInfo, "java.util.function.DoubleFunction": Internal.ClassInfo, "net.minecraft.world.item.crafting.ArmorDyeRecipe": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration": Internal.ClassInfo, "net.minecraft.world.level.block.TripWireHookBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.BlockKJS": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryMirrorStandBlock": Internal.ClassInfo, "net.minecraft.world.level.block.SnowLayerBlock": Internal.ClassInfo, "com.hrznstudio.titanium.recipe.generator.IJsonFile": Internal.ClassInfo, "tfar.craftingstation.CraftingStationSlabBlock": Internal.ClassInfo, "net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider$Context": Internal.ClassInfo, "net.minecraftforge.server.permission.events.PermissionGatherEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.creativetab.CreativeTabIconSupplier": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunction$Visitor": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundKeepAlivePacket": Internal.ClassInfo, "com.hrznstudio.titanium.network.locator.PlayerInventoryFinder$Target": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket": Internal.ClassInfo, "net.mcreator.cozyhome.block.MagentaLampBlock": Internal.ClassInfo, "net.minecraft.world.entity.player.Abilities": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.WrappedJS": Internal.ClassInfo, "com.mojang.brigadier.context.StringRange": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement": Internal.ClassInfo, "net.minecraft.client.sounds.SoundEventListener": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.Donkey": Internal.ClassInfo, "io.netty.channel.ChannelId": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.client.IScreenProvider": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationController$AnimationStateHandler": Internal.ClassInfo, "com.buuz135.industrial.fluid.OreTitaniumFluidType": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket": Internal.ClassInfo, "net.minecraft.client.resources.SkinManager": Internal.ClassInfo, "net.minecraft.world.entity.animal.FlyingAnimal": Internal.ClassInfo, "net.minecraft.world.level.levelgen.NoiseChunk": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FluidBuilder": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakSinkCounterBlock": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.SculkSensorPhase": Internal.ClassInfo, "mezz.jei.api.gui.builder.IRecipeSlotBuilder": Internal.ClassInfo, "net.minecraft.world.entity.projectile.FishingHook$FishHookState": Internal.ClassInfo, "java.text.AttributedCharacterIterator": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakGrandfatherClockBlock": Internal.ClassInfo, "java.io.ObjectInput": Internal.ClassInfo, "net.minecraft.world.level.block.BeaconBeamBlock": Internal.ClassInfo, "net.minecraftforge.common.ForgeSpawnEggItem": Internal.ClassInfo, "com.buuz135.industrial.utils.apihandlers.plant.TreeCache": Internal.ClassInfo, "cofh.thermal.innovation.common.item.PotionQuiverItem": Internal.ClassInfo, "com.mojang.authlib.minecraft.report.ReportEvidence": Internal.ClassInfo, "net.minecraft.world.entity.monster.Strider": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.LegacySinglePoolElement": Internal.ClassInfo, "net.minecraft.client.renderer.debug.RaidDebugRenderer": Internal.ClassInfo, "net.liopyu.entityjs.item.ArrowItemBuilder": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.WaterCondensatorTile": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.MysticalSeedsItem": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeFluid": Internal.ClassInfo, "net.minecraftforge.event.entity.living.MobSpawnEvent": Internal.ClassInfo, "dev.ftb.mods.ftbquests.item.CustomIconItem": Internal.ClassInfo, "java.util.function.DoubleUnaryOperator": Internal.ClassInfo, "net.minecraft.world.item.enchantment.TridentImpalerEnchantment": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterType": Internal.ClassInfo, "java.lang.Thread$UncaughtExceptionHandler": Internal.ClassInfo, "java.time.chrono.ChronoLocalDate": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.init.ModFluids$1": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagArgument$Info$Template": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundAddEntityPacket": Internal.ClassInfo, "dev.architectury.core.fluid.ArchitecturyFlowingFluid$Source": Internal.ClassInfo, "java.util.stream.IntStream$IntMapMultiConsumer": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.MinecraftRemapper": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.LightUpBlock": Internal.ClassInfo, "net.minecraft.world.entity.decoration.LeashFenceKnotEntity": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.WitherBuilderTile": Internal.ClassInfo, "net.minecraft.commands.arguments.ScoreHolderArgument": Internal.ClassInfo, "java.lang.constant.MethodHandleDesc": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.FloatingBlockItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic": Internal.ClassInfo, "net.minecraft.world.entity.boss.wither.WitherBoss": Internal.ClassInfo, "java.util.function.UnaryOperator": Internal.ClassInfo, "net.minecraft.world.level.chunk.PalettedContainer": Internal.ClassInfo, "cofh.thermal.locomotion.common.item.EnergyMinecartItem": Internal.ClassInfo, "net.minecraft.client.Camera$NearPlane": Internal.ClassInfo, "net.minecraft.stats.StatFormatter": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgePotion": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ArrowFireEnchantment": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration": Internal.ClassInfo, "net.minecraft.world.level.levelgen.WorldgenRandom$Algorithm": Internal.ClassInfo, "java.text.CharacterIterator": Internal.ClassInfo, "net.mcreator.cozyhome.block.GreenLampBlock": Internal.ClassInfo, "java.security.PrivilegedExceptionAction": Internal.ClassInfo, "net.minecraftforge.registries.IForgeRegistry": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.CoralMushroomFeature": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.WouldSurvivePredicate": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.item.ItemQuantifyKey": Internal.ClassInfo, "mcjty.theoneprobe.items.AddProbeTagRecipeSerializer": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerPacketListener": Internal.ClassInfo, "net.minecraft.client.renderer.texture.SpriteContents$AnimatedTexture": Internal.ClassInfo, "com.benbenlaw.strainers.item.custom.ErodingSaltMulchItem": Internal.ClassInfo, "net.minecraft.world.level.block.InfestedRotatedPillarBlock": Internal.ClassInfo, "net.minecraft.world.entity.MoverType": Internal.ClassInfo, "net.minecraft.client.GuiMessageTag$Icon": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2ShortFunction": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FluidWrapper": Internal.ClassInfo, "cofh.core.common.block.GlossedMagmaBlock": Internal.ClassInfo, "net.minecraft.client.gui.font.FontSet": Internal.ClassInfo, "net.minecraft.world.phys.shapes.DiscreteVoxelShape$IntFaceConsumer": Internal.ClassInfo, "java.nio.file.attribute.GroupPrincipal": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer": Internal.ClassInfo, "com.mojang.blaze3d.vertex.BufferBuilder$RenderedBuffer": Internal.ClassInfo, "java.util.RandomAccess": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.EndermanSkullBlock": Internal.ClassInfo, "net.minecraft.world.inventory.ContainerListener": Internal.ClassInfo, "net.minecraft.world.item.crafting.SmithingTransformRecipe$Serializer": Internal.ClassInfo, "javax.swing.text.TabSet": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.weapon.PoisonedChakraItem": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.DeathStoneItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.UpwardsBranchingTrunkPlacer": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.InputItem": Internal.ClassInfo, "io.netty.util.concurrent.Promise": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleWallClockBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongComparator": Internal.ClassInfo, "vectorwing.farmersdelight.common.world.feature.WildRiceFeature": Internal.ClassInfo, "net.minecraft.util.valueproviders.UniformFloat": Internal.ClassInfo, "net.minecraft.world.level.block.WeepingVinesPlantBlock": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier3Item$Helmet": Internal.ClassInfo, "net.minecraft.core.RegistryAccess$Frozen": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterPresetEditorsEvent": Internal.ClassInfo, "net.minecraft.server.players.GameProfileCache": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.OrderedCompoundTag": Internal.ClassInfo, "cofh.thermal.core.common.fluid.SyrupFluid$1": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$OutputStateShard": Internal.ClassInfo, "net.minecraft.server.network.ServerPlayerConnection": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ArrowDamageEnchantment": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.CoralTreeFeature": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryStorageCounterBlock": Internal.ClassInfo, "com.mojang.datafixers.util.Pair$Mu": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.TurnTableBlock": Internal.ClassInfo, "net.minecraft.world.level.block.BaseCoralPlantTypeBlock": Internal.ClassInfo, "net.minecraft.client.HotbarManager": Internal.ClassInfo, "cofh.thermal.cultivation.common.item.JarredItem": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.VillagerBabiesSensor": Internal.ClassInfo, "net.minecraft.client.sounds.MusicManager": Internal.ClassInfo, "net.minecraft.world.level.block.RedStoneOreBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.LootBuilder": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.SafetyNetBlock": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightDoorBlock": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.report.ReportEnvironment": Internal.ClassInfo, "net.minecraft.world.inventory.StonecutterMenu": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.WorldCreationContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.LargeDripstoneFeature": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingKnockBackEvent": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.FanBlock": Internal.ClassInfo, "net.minecraftforge.client.event.InputEvent$MouseButton": Internal.ClassInfo, "io.netty.buffer.CompositeByteBuf": Internal.ClassInfo, "com.buuz135.industrial.block.core.tile.FluidExtractorTile$FluidExtractionProgress": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.OneShot": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag": Internal.ClassInfo, "com.electronwill.nightconfig.core.UnmodifiableConfig": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeWrapper": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.RandomSelectorFeature": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeWrapper$BlastingUpgradeWrapper": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.GoldTrapdoorBlock": Internal.ClassInfo, "net.minecraft.world.level.block.LiquidBlockContainer": Internal.ClassInfo, "com.obscuria.obscureapi.common.effects.Rush": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeWrapper$AutoSmokingUpgradeWrapper": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile": Internal.ClassInfo, "com.mojang.brigadier.Command": Internal.ClassInfo, "com.electronwill.nightconfig.core.io.WritingMode": Internal.ClassInfo, "net.minecraft.world.level.block.RedStoneWireBlock": Internal.ClassInfo, "java.util.HashMap": Internal.ClassInfo, "net.minecraft.world.item.enchantment.QuickChargeEnchantment": Internal.ClassInfo, "com.google.common.collect.Multimap": Internal.ClassInfo, "net.minecraft.client.gui.components.events.ContainerEventHandler": Internal.ClassInfo, "dev.latvian.mods.rhino.EvaluatorException": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier3Item$Chestplate": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.weapon.WhisperOfTheAbyssItem": Internal.ClassInfo, "net.minecraft.world.level.block.TallFlowerBlock": Internal.ClassInfo, "tocraft.walkers.impl.DimensionsRefresher": Internal.ClassInfo, "net.minecraft.world.level.block.entity.ComparatorBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.PlayerKJS": Internal.ClassInfo, "mezz.jei.api.recipe.category.IRecipeCategory": Internal.ClassInfo, "com.probejs.jdoc.property.PropertyParam": Internal.ClassInfo, "net.minecraftforge.registries.DataPackRegistryEvent": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.lime.LimeStandingSignBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.DebugInfoEventJS": Internal.ClassInfo, "com.mojang.authlib.UserType": Internal.ClassInfo, "net.minecraft.world.level.block.WallTorchBlock": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier2Item$Boots": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundContainerClosePacket": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchCounterBlock": Internal.ClassInfo, "cofh.thermal.dynamics.common.item.DuctBlockItem": Internal.ClassInfo, "dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory": Internal.ClassInfo, "net.liopyu.entityjs.events.GoalEventJS": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.FisherBoost$Serializer": Internal.ClassInfo, "net.minecraft.nbt.NumericTag": Internal.ClassInfo, "net.minecraft.server.level.ServerPlayerGameMode": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket": Internal.ClassInfo, "java.awt.image.ColorModel": Internal.ClassInfo, "java.awt.dnd.DragSourceDragEvent": Internal.ClassInfo, "net.minecraftforge.client.event.ClientPlayerNetworkEvent$Clone": Internal.ClassInfo, "net.minecraft.world.effect.MobEffect": Internal.ClassInfo, "org.moddingx.libx.creativetab.CreativeTabItemProvider": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGeometry": Internal.ClassInfo, "net.minecraft.world.item.ArmorStandItem": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.wrapper.ColorWrapper": Internal.ClassInfo, "net.minecraft.world.SimpleContainer": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.BlockGeneratorBlock": Internal.ClassInfo, "net.minecraft.tags.TagManager$LoadResult": Internal.ClassInfo, "java.util.concurrent.Future": Internal.ClassInfo, "net.minecraftforge.client.event.RenderLivingEvent": Internal.ClassInfo, "net.minecraft.world.entity.projectile.Projectile": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.AshLayerBlock": Internal.ClassInfo, "net.minecraftforge.client.event.InputEvent$MouseScrollingEvent": Internal.ClassInfo, "cofh.core.common.item.IAugmentItem": Internal.ClassInfo, "com.supermartijn642.fusion.api.model.ModelInstance": Internal.ClassInfo, "java.awt.event.KeyEvent": Internal.ClassInfo, "dev.ftb.mods.ftbteams.api.property.TeamPropertyArgument$Info$Template": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$Imperium": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.item.EssencePaxelItem": Internal.ClassInfo, "net.minecraft.world.entity.monster.warden.AngerManagement": Internal.ClassInfo, "com.google.gson.LongSerializationPolicy": Internal.ClassInfo, "mezz.jei.api.runtime.IIngredientVisibility": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEventListener$DeliveryMode": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.JsonIO": Internal.ClassInfo, "dev.ftb.mods.ftbteams.api.TeamRank": Internal.ClassInfo, "dev.latvian.mods.rhino.IdEnumerationIterator": Internal.ClassInfo, "tfar.dankstorage.item.UpgradeItem": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.WindVaneBlock": Internal.ClassInfo, "net.minecraft.client.resources.MobEffectTextureManager": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchSinkCounterBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonDeskBlock": Internal.ClassInfo, "java.time.zone.ZoneRules": Internal.ClassInfo, "net.minecraft.world.level.material.LavaFluid$Source": Internal.ClassInfo, "net.minecraft.world.item.SignItem": Internal.ClassInfo, "net.minecraftforge.eventbus.ListenerList": Internal.ClassInfo, "net.minecraft.world.inventory.ClickAction": Internal.ClassInfo, "eutros.framedcompactdrawers.block.BlockControllerCustom": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.lib.LazyIngredient": Internal.ClassInfo, "com.mojang.datafixers.DataFixer": Internal.ClassInfo, "de.melanx.skyblockbuilder.util.CoreUtil$SkyblockPresetCodec": Internal.ClassInfo, "dev.latvian.mods.itemfilters.api.IStringValueFilter": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampDoubleArchFeature": Internal.ClassInfo, "net.minecraftforge.network.IContainerFactory": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.MutableToolTier": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelStorageSource$LevelCandidates": Internal.ClassInfo, "net.minecraftforge.client.event.RenderPlayerEvent$Post": Internal.ClassInfo, "net.minecraftforge.client.ChunkRenderTypeSet": Internal.ClassInfo, "cofh.thermal.core.common.item.EarthChargeItem": Internal.ClassInfo, "net.minecraft.network.chat.RemoteChatSession$Data": Internal.ClassInfo, "letsforge_pirates.item.Merchant2Item": Internal.ClassInfo, "com.google.common.collect.ImmutableCollection": Internal.ClassInfo, "com.mojang.text2speech.Narrator": Internal.ClassInfo, "org.lwjgl.CLongBuffer": Internal.ClassInfo, "io.netty.channel.ChannelProgressiveFuture": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.FlammableBrightStairBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonLandingPhase": Internal.ClassInfo, "com.benbenlaw.strainers.item.custom.PurifyingSaltMulchItem": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.EntityShadowAccessor": Internal.ClassInfo, "net.minecraft.world.level.block.entity.ConduitBlockEntity": Internal.ClassInfo, "net.minecraft.client.resources.sounds.Sound$Type": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.TomatoVineBlock": Internal.ClassInfo, "net.minecraft.world.entity.projectile.SpectralArrow": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.AnimationPoint": Internal.ClassInfo, "com.mojang.serialization.Decoder$Terminal": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.AbyssalArmorItem$Leggings": Internal.ClassInfo, "dev.ftb.mods.ftbultimine.mixin.AxeItemAccess": Internal.ClassInfo, "cpw.mods.jarhandling.SecureJar": Internal.ClassInfo, "net.mcreator.cozyhome.block.QuartzMirrorBlock": Internal.ClassInfo, "net.minecraft.world.entity.monster.piglin.PiglinBrute": Internal.ClassInfo, "net.minecraftforge.registries.IForgeRegistry$BakeCallback": Internal.ClassInfo, "dev.latvian.mods.rhino.Callable": Internal.ClassInfo, "net.minecraft.world.level.Level": Internal.ClassInfo, "net.minecraft.world.scores.Objective": Internal.ClassInfo, "vazkii.patchouli.api.PatchouliConfigAccess$TextOverflowMode": Internal.ClassInfo, "cofh.thermal.core.common.item.HazmatArmorItem": Internal.ClassInfo, "cpw.mods.jarhandling.SecureJar$Provider": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.InfusionAltarBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Init": Internal.ClassInfo, "dev.latvian.mods.kubejs.command.ArgumentTypeWrapper": Internal.ClassInfo, "net.minecraft.world.item.enchantment.BindingCurseEnchantment": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.RepeatingPlacement": Internal.ClassInfo, "net.minecraft.world.entity.Display$BlockDisplay": Internal.ClassInfo, "dev.latvian.mods.kubejs.platform.forge.IngredientForgeHelper": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket": Internal.ClassInfo, "net.minecraftforge.common.capabilities.ICapabilityProviderImpl": Internal.ClassInfo, "mezz.jei.api.gui.drawable.IDrawableBuilder": Internal.ClassInfo, "java.nio.charset.CodingErrorAction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.UniformHeight": Internal.ClassInfo, "mezz.jei.api.gui.drawable.IDrawableAnimated$StartDirection": Internal.ClassInfo, "com.buuz135.industrial.fluid.OreFluid": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongBidirectionalIterator": Internal.ClassInfo, "tocraft.craftedcore.data.PlayerDataProvider": Internal.ClassInfo, "java.nio.DoubleBuffer": Internal.ClassInfo, "net.minecraftforge.common.crafting.conditions.IConditionSerializer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor": Internal.ClassInfo, "cofh.lib.common.block.DirectionalBlock4Way": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceArgument$Info": Internal.ClassInfo, "net.minecraft.world.level.block.SpongeBlock": Internal.ClassInfo, "com.electrolyte.matc.items.TertiumCrystal": Internal.ClassInfo, "net.minecraft.world.entity.animal.Parrot": Internal.ClassInfo, "com.mojang.brigadier.ParseResults": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.weapon.MazeRoseItem": Internal.ClassInfo, "net.minecraft.server.MinecraftServer$ReloadableResources": Internal.ClassInfo, "net.minecraft.world.entity.animal.Salmon": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.enchantment.MysticalEnlightenmentEnchantment": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.SimpleMappingRecipeComponent": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.cyan.CyanWallSignBlock": Internal.ClassInfo, "letsforge_pirates.item.PirateTier2Item$Chestplate": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModInfo$DependencySide": Internal.ClassInfo, "com.llamalad7.mixinextras.sugar.ref.LocalRef": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.world.modifiers.NetherInferiumOreModifier": Internal.ClassInfo, "net.minecraft.core.BlockSourceImpl": Internal.ClassInfo, "com.benbenlaw.strainers.recipe.StrainerRecipe": Internal.ClassInfo, "net.minecraft.world.item.ThrowablePotionItem": Internal.ClassInfo, "com.probejs.jdoc.property.PropertyValue": Internal.ClassInfo, "vazkii.patchouli.client.book.template.BookTemplate": Internal.ClassInfo, "net.minecraft.util.random.WeightedEntry$Wrapper": Internal.ClassInfo, "com.mojang.brigadier.tree.RootCommandNode": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.util.BooleanConsumer": Internal.ClassInfo, "net.minecraft.world.level.block.WaterlilyBlock": Internal.ClassInfo, "net.minecraft.world.level.material.FogType": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.SlaughterFactoryBlock": Internal.ClassInfo, "de.keksuccino.melody.mixin.mixins.common.client.IMixinSoundEngine": Internal.ClassInfo, "net.minecraft.world.item.BottleItem": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.RopeBlock": Internal.ClassInfo, "dev.latvian.mods.rhino.Scriptable": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.AshenBasaltBlock": Internal.ClassInfo, "net.minecraftforge.eventbus.api.IGenericEvent": Internal.ClassInfo, "net.minecraft.client.gui.narration.NarrationThunk": Internal.ClassInfo, "com.google.gson.JsonArray": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.IInfinityDrillScreenAddons": Internal.ClassInfo, "net.minecraft.world.level.block.DeadBushBlock": Internal.ClassInfo, "net.minecraft.world.MenuProvider": Internal.ClassInfo, "net.minecraft.world.item.crafting.ShapedRecipe": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootDataType": Internal.ClassInfo, "net.minecraft.world.level.block.BannerBlock": Internal.ClassInfo, "dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection": Internal.ClassInfo, "java.util.concurrent.Callable": Internal.ClassInfo, "net.minecraft.world.level.block.FenceBlock": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.item.EssenceCoalItem": Internal.ClassInfo, "java.util.ArrayList": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.StoneTorchBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootParams$DynamicDrop": Internal.ClassInfo, "net.mcreator.cozyhome.block.RedLampBlock": Internal.ClassInfo, "com.mojang.authlib.properties.Property": Internal.ClassInfo, "net.minecraft.client.gui.spectator.SpectatorMenuListener": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier1Item$Boots": Internal.ClassInfo, "net.minecraft.world.entity.decoration.Painting": Internal.ClassInfo, "net.minecraftforge.common.data.ExistingFileHelper$IResourceType": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakGrandfatherClockBlock": Internal.ClassInfo, "net.minecraftforge.common.util.BrainBuilder": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.SoulJarItem": Internal.ClassInfo, "net.minecraft.world.level.NoiseColumn": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.SludgeRefinerTile": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2ReferenceFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunction$SimpleFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2ByteFunction": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.QuestLink": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket": Internal.ClassInfo, "net.minecraft.network.chat.SignedMessageLink": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.api.IAntiqueTextProvider": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.CatalogueBook": Internal.ClassInfo, "net.minecraft.world.level.block.entity.HangingSignBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.biome.AmbientAdditionsSettings": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundExplodePacket": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.IntegerArgumentInfo": Internal.ClassInfo, "java.awt.image.ImageObserver": Internal.ClassInfo, "net.minecraft.network.FriendlyByteBuf$Writer": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.FlammableBrightFenceBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade$BatteryRenderInfo": Internal.ClassInfo, "net.minecraftforge.fml.config.IConfigEvent$ConfigConfig": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.entries.AlternativesEntry$Builder": Internal.ClassInfo, "org.apache.maven.repository.Proxy": Internal.ClassInfo, "net.minecraft.world.item.crafting.SmeltingRecipe": Internal.ClassInfo, "net.minecraft.world.phys.BlockHitResult": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.MinecraftClientKJS": Internal.ClassInfo, "net.minecraftforge.common.util.MutableHashedLinkedMap$IdentityStrategy": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagKeyArgument$Result": Internal.ClassInfo, "net.minecraft.world.entity.ai.gossip.GossipContainer": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo$ItemDisplayRenderInfo": Internal.ClassInfo, "java.time.chrono.IsoEra": Internal.ClassInfo, "cofh.thermal.cultivation.common.item.PotionCakeBlockItem": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.ScheduledEvents$Callback": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.CatalogueRecipe$Serializer": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeItem": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeKeyMapping": Internal.ClassInfo, "net.minecraft.world.entity.Display$BillboardConstraints": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.report.ChatReportBuilder$ChatReport": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartitioner$SlotRange": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.HeightmapPlacement": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractPresentBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingLogic": Internal.ClassInfo, "net.minecraftforge.event.AnvilUpdateEvent": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier1Item": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.pink.PinkWallSignBlock": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryProperty$GameMode": Internal.ClassInfo, "cofh.thermal.cultivation.common.block.CheeseWheelBlock": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.light_gray.LightGrayWallHangingSignBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundClearTitlesPacket": Internal.ClassInfo, "net.minecraft.network.chat.OutgoingChatMessage": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest": Internal.ClassInfo, "net.minecraft.resources.ResourceKey": Internal.ClassInfo, "com.obscuria.aquamirae.common.worldgen.feature.OxygeliumFeature": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveDrawerBlock": Internal.ClassInfo, "com.yungnickyoung.minecraft.betteroceanmonuments.mixin.accessor.ProjectileAccessor": Internal.ClassInfo, "net.minecraft.world.level.LevelHeightAccessor": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.EventExit": Internal.ClassInfo, "cofh.lib.api.item.IXpContainerItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ObjectMap": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$Entry": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeConfig": Internal.ClassInfo, "net.minecraft.world.entity.animal.goat.Goat": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.LavaSubmergedBlockProcessor": Internal.ClassInfo, "java.util.function.DoubleConsumer": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.FlammableBrightFenceGateBlock": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.ThreeBoltArmorItem$Leggings": Internal.ClassInfo, "tax.taknax.taxov.item.PirateSuitItem$Boots": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.LongJumpToRandomPos": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration": Internal.ClassInfo, "dev.latvian.mods.kubejs.registry.BuilderBase": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.ReplaceBlockFeature": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeWrapper$AutoBlastingUpgradeWrapper": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeBaseRailBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.frog.Frog": Internal.ClassInfo, "net.minecraftforge.common.SoundAction": Internal.ClassInfo, "com.blakebr0.cucumber.crafting.ISpecialRecipe": Internal.ClassInfo, "cofh.core.client.particle.options.ColorParticleOptions": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedGameEventExtension": Internal.ClassInfo, "net.minecraft.world.level.block.ShulkerBoxBlock": Internal.ClassInfo, "letsforge_pirates.item.DeckhandItem": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.PlantSowerBlock": Internal.ClassInfo, "java.awt.MenuItem": Internal.ClassInfo, "net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner": Internal.ClassInfo, "cofh.thermal.core.common.item.SlotSealItem": Internal.ClassInfo, "java.lang.ClassLoader": Internal.ClassInfo, "software.bernie.geckolib.core.object.DataTicket": Internal.ClassInfo, "cofh.lib.common.inventory.SimpleItemInv": Internal.ClassInfo, "net.minecraft.world.level.block.MangroveLeavesBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherBlock": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.weapon.FinCutterItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.platform.IngredientPlatformHelper": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.YellowSprayCanItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ObjectFunction": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData": Internal.ClassInfo, "net.minecraft.util.profiling.metrics.MetricSampler": Internal.ClassInfo, "com.obscuria.aquamirae.common.blocks.FrozenChestBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.Aquifer$FluidPicker": Internal.ClassInfo, "net.minecraft.world.level.block.IceBlock": Internal.ClassInfo, "net.minecraft.world.inventory.ClickType": Internal.ClassInfo, "com.mojang.brigadier.context.CommandContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService": Internal.ClassInfo, "net.minecraft.commands.arguments.ScoreHolderArgument$Info$Template": Internal.ClassInfo, "net.minecraft.client.resources.TextureAtlasHolder": Internal.ClassInfo, "com.mojang.serialization.Lifecycle": Internal.ClassInfo, "net.minecraftforge.client.event.ModelEvent$RegisterAdditional": Internal.ClassInfo, "net.minecraft.world.entity.HasCustomInventoryScreen": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2ObjectMap": Internal.ClassInfo, "java.security.ProtectionDomain": Internal.ClassInfo, "java.nio.channels.WritableByteChannel": Internal.ClassInfo, "net.minecraft.world.item.EnderEyeItem": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.neptunium.NeptuniumPickaxe": Internal.ClassInfo, "cofh.thermal.core.common.fluid.RedstoneFluid$1": Internal.ClassInfo, "io.netty.buffer.ByteBufAllocatorMetricProvider": Internal.ClassInfo, "java.nio.FloatBuffer": Internal.ClassInfo, "net.minecraft.world.level.block.entity.StructureBlockEntity$UpdateType": Internal.ClassInfo, "org.moddingx.libx.base.BlockBase": Internal.ClassInfo, "net.minecraft.world.entity.schedule.Activity": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.anvil.AnvilUpgradeItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.FermentationStationTile": Internal.ClassInfo, "com.mojang.datafixers.util.Either$Mu": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.UpgradeRecipeUtil$Serializer": Internal.ClassInfo, "org.apache.maven.artifact.Artifact": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.filter.FilterUpgradeWrapper": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.tile.ConveyorTile": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.BlockLootEventJS": Internal.ClassInfo, "cofh.lib.api.item.IColorableItem": Internal.ClassInfo, "net.minecraft.world.level.block.entity.HopperBlockEntity": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ByteMap": Internal.ClassInfo, "net.minecraft.world.entity.ai.attributes.AttributeSupplier": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$StartTracking": Internal.ClassInfo, "org.violetmoon.zeta.world.DeferredFeature": Internal.ClassInfo, "net.minecraftforge.client.settings.KeyModifier": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IContentsFilteredUpgrade": Internal.ClassInfo, "net.minecraft.util.valueproviders.FloatProviderType": Internal.ClassInfo, "net.minecraftforge.client.model.geometry.BlockGeometryBakingContext": Internal.ClassInfo, "com.mojang.authlib.AuthenticationService": Internal.ClassInfo, "net.minecraft.world.level.levelgen.BelowZeroRetrogen": Internal.ClassInfo, "java.time.chrono.ChronoPeriod": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositUpgradeWrapper": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.pickup.PickupUpgradeItem": Internal.ClassInfo, "net.liopyu.entityjs.builders.ProjectileEntityJSBuilder": Internal.ClassInfo, "javax.swing.text.StyleConstants$ColorConstants": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceStorageCounterBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.ItemShelfBlock": Internal.ClassInfo, "com.mojang.blaze3d.platform.IconSet": Internal.ClassInfo, "java.util.PrimitiveIterator$OfDouble": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.VeryBiasedToBottomHeight": Internal.ClassInfo, "java.awt.event.HierarchyBoundsListener": Internal.ClassInfo, "java.util.function.IntSupplier": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile": Internal.ClassInfo, "cofh.core.common.item.MinecartItemCoFH": Internal.ClassInfo, "net.minecraft.world.item.crafting.RecipeSerializer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize": Internal.ClassInfo, "com.buuz135.industrialforegoingsouls.block.tile.SoulLaserBaseBlockEntity": Internal.ClassInfo, "com.teammetallurgy.aquaculture.block.TackleBoxBlock": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.MimicBlock": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$ThunderHitContext": Internal.ClassInfo, "net.minecraft.world.entity.PlayerRideable": Internal.ClassInfo, "net.minecraft.world.item.ItemStack$TooltipPart": Internal.ClassInfo, "net.minecraft.client.gui.narration.NarratableEntry$NarrationPriority": Internal.ClassInfo, "net.minecraft.client.particle.ParticleEngine$MutableSpriteSet": Internal.ClassInfo, "net.minecraft.world.level.block.EndGatewayBlock": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.effect.AccessorMobEffectInstance": Internal.ClassInfo, "com.mojang.blaze3d.platform.InputConstants$Key": Internal.ClassInfo, "com.blakebr0.cucumber.item.BaseArmorItem": Internal.ClassInfo, "net.minecraft.world.level.block.CactusBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket": Internal.ClassInfo, "net.minecraft.commands.arguments.ArgumentSignatures$Entry": Internal.ClassInfo, "net.minecraftforge.event.entity.player.AnvilRepairEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.painter.PainterObjectStorage": Internal.ClassInfo, "net.minecraft.server.MinecraftServer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType": Internal.ClassInfo, "cofh.core.client.particle.types.PointToPointParticleType": Internal.ClassInfo, "com.hrznstudio.titanium.block.redstone.RedstoneAction": Internal.ClassInfo, "net.minecraftforge.items.IItemHandlerModifiable": Internal.ClassInfo, "org.violetmoon.zetaimplforge.world.ZetaBiomeModifier": Internal.ClassInfo, "cofh.thermal.lib.common.item.BlockItemAugmentable": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.EnchantmentBuilder$PostFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.PositionalRandomFactory": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.MaxCountFilterItem": Internal.ClassInfo, "net.minecraft.client.renderer.RenderType$CompositeRenderType": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.LinearPosTest": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot": Internal.ClassInfo, "com.mojang.datafixers.types.Type$TypeError": Internal.ClassInfo, "java.io.Reader": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier2Item$Boots": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.ParrotEntityAccessor": Internal.ClassInfo, "com.hrznstudio.titanium.datagenerator.loot.ILootTableProvider": Internal.ClassInfo, "net.minecraft.world.item.CreativeModeTab$Output": Internal.ClassInfo, "java.security.PrivateKey": Internal.ClassInfo, "net.minecraft.client.renderer.entity.EntityRendererProvider$Context": Internal.ClassInfo, "net.minecraftforge.fml.config.ModConfig": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.tile.BHTile": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositFilterLogic": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.GoldDoorBlock": Internal.ClassInfo, "net.minecraftforge.registries.RegisterEvent": Internal.ClassInfo, "net.minecraftforge.fml.loading.progress.Message": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.FloatArgumentInfo$Template": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterItemDecorationsEvent": Internal.ClassInfo, "net.minecraft.world.level.block.state.BlockBehaviour$OffsetType": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.gray.GrayStandingSignBlock": Internal.ClassInfo, "com.blakebr0.cucumber.crafting.recipe.ShapedTagRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.level.block.entity.ChestBlockEntity": Internal.ClassInfo, "letsforge_pirates.item.PirateTier1Item$Chestplate": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakBenchBlock": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.ResourceGeneratorBlock": Internal.ClassInfo, "java.nio.file.spi.FileSystemProvider": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.EventHandlerContainer": Internal.ClassInfo, "journeymap.client.api.event.forge.PopupMenuEvent$FullscreenPopupMenuEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.bindings.ItemWrapper": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeWrapper": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure": Internal.ClassInfo, "java.lang.Number": Internal.ClassInfo, "net.minecraft.client.resources.sounds.Sound": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundClientCommandPacket$Action": Internal.ClassInfo, "java.util.zip.ZipConstants": Internal.ClassInfo, "net.minecraft.world.level.block.CarrotBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.SpawnPlacementRegisterEvent$Operation": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2ReferenceFunction": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.TagKeyComponent": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.worldgen.RoadSignFeature$Config": Internal.ClassInfo, "javax.sound.sampled.AudioFormat$Encoding": Internal.ClassInfo, "com.electrolyte.matc.items.SupremiumCrystal": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.LevelKJS": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleTableBlock": Internal.ClassInfo, "java.time.chrono.ChronoZonedDateTime": Internal.ClassInfo, "dev.ftb.mods.ftbteams.api.property.TeamPropertyArgument$Info": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeSpecialEffects$GrassColorModifier": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityAttributeModificationEvent": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SafeBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeWrapper": Internal.ClassInfo, "net.minecraft.world.entity.FlyingMob": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer": Internal.ClassInfo, "java.awt.im.InputContext": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.DyeMixerBlock": Internal.ClassInfo, "letsforge_pirates.item.Skull2Item$Helmet": Internal.ClassInfo, "com.mojang.brigadier.context.SuggestionContext": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsServer$WorldType": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.SecondaryPoiSensor": Internal.ClassInfo, "net.minecraft.world.level.block.DragonEggBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.PlacementFilter": Internal.ClassInfo, "net.minecraft.world.damagesource.DamageEffects": Internal.ClassInfo, "com.mojang.serialization.OptionalDynamic": Internal.ClassInfo, "java.math.RoundingMode": Internal.ClassInfo, "java.awt.Shape": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.DarkOakTrunkPlacer": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.RecipeKey": Internal.ClassInfo, "net.minecraft.util.RandomSource": Internal.ClassInfo, "net.minecraft.world.inventory.CraftingContainer": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.report.AbuseReportSender": Internal.ClassInfo, "net.minecraftforge.network.ServerStatusPing$ChannelData": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$TextureStateShard": Internal.ClassInfo, "software.bernie.geckolib.core.animatable.model.CoreGeoBone": Internal.ClassInfo, "net.minecraft.world.inventory.MenuType$MenuSupplier": Internal.ClassInfo, "net.minecraft.core.cauldron.CauldronInteraction": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BlockEntityType$BlockEntitySupplier": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerInteractEvent$LeftClickBlock$Action": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.FenceBlockBuilder": Internal.ClassInfo, "vazkii.patchouli.mixin.AccessorSmithingTransformRecipe": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.StringComponent$1": Internal.ClassInfo, "java.util.Iterator": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemClickedEventJS": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.LoggedChatEvent$Type": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetObjectivePacket": Internal.ClassInfo, "cofh.lib.common.block.AttachedStemBlockCoFH": Internal.ClassInfo, "net.minecraft.world.entity.projectile.AbstractArrow": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.purple.PurpleHangingSignBlock": Internal.ClassInfo, "net.minecraft.world.inventory.SmokerMenu": Internal.ClassInfo, "io.netty.buffer.PoolChunkListMetric": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.HoglinSpecificSensor": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.KeyItem": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.AnimalMakeLove": Internal.ClassInfo, "mezz.jei.api.ingredients.ITypedIngredient": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.ItemOverrides$BakedOverride": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.NameMap$Builder": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider": Internal.ClassInfo, "io.netty.channel.ChannelInboundHandlerAdapter": Internal.ClassInfo, "java.awt.JobAttributes$MultipleDocumentHandlingType": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier2Item$Boots": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexBuffer": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.IngredientKJS": Internal.ClassInfo, "com.mojang.realmsclient.gui.RealmsNewsManager": Internal.ClassInfo, "java.util.Vector": Internal.ClassInfo, "letsforge_pirates.item.BoneCutlassItem": Internal.ClassInfo, "net.minecraft.world.level.block.entity.DaylightDetectorBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.block.TallSeagrassBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.ConstantHeight": Internal.ClassInfo, "net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent": Internal.ClassInfo, "vazkii.patchouli.mixin.client.AccessorScreen": Internal.ClassInfo, "com.supermartijn642.fusion.api.texture.TextureType": Internal.ClassInfo, "com.google.common.collect.RegularImmutableMap": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2ByteFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration$Layer": Internal.ClassInfo, "net.minecraft.server.packs.resources.ResourceManager": Internal.ClassInfo, "io.netty.channel.ChannelOutboundBuffer$MessageProcessor": Internal.ClassInfo, "net.minecraftforge.client.model.data.ModelData$Builder": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.PlayerRespawnedEventJS": Internal.ClassInfo, "net.minecraft.world.entity.monster.piglin.Piglin": Internal.ClassInfo, "dev.latvian.mods.kubejs.gui.chest.ChestMenuData": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.Object2LongEntry": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.FluidGeneratorBlock": Internal.ClassInfo, "org.violetmoon.zetaimplforge.mixin.mixins.WeatheringCopperMixin": Internal.ClassInfo, "net.minecraft.world.entity.animal.Panda$Gene": Internal.ClassInfo, "com.hrznstudio.titanium.block.RotatableBlock": Internal.ClassInfo, "net.minecraft.world.scores.Team$Visibility": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.RedstoneIlluminatorBlock": Internal.ClassInfo, "net.minecraft.world.phys.shapes.VoxelShape": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerContainerEvent": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.functions.LootItemFunctionType": Internal.ClassInfo, "net.minecraft.world.item.crafting.MapCloningRecipe": Internal.ClassInfo, "net.minecraft.world.level.block.LiquidBlock": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeHolderSet": Internal.ClassInfo, "cofh.lib.api.item.IFluidContainerItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleIterable": Internal.ClassInfo, "net.minecraft.client.renderer.FogRenderer$FogMode": Internal.ClassInfo, "com.blakebr0.cucumber.iface.IColored": Internal.ClassInfo, "java.lang.StringBuffer": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2FloatFunction": Internal.ClassInfo, "net.minecraftforge.client.event.RenderArmEvent": Internal.ClassInfo, "net.minecraft.world.level.chunk.BlockColumn": Internal.ClassInfo, "net.minecraft.world.level.gameevent.vibrations.VibrationSystem$User": Internal.ClassInfo, "net.minecraft.world.level.block.WeightedPressurePlateBlock": Internal.ClassInfo, "net.minecraft.world.level.block.DecoratedPotBlock": Internal.ClassInfo, "java.nio.file.attribute.UserPrincipalLookupService": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.NearestItemSensor": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.ChatListener": Internal.ClassInfo, "mezz.jei.api.runtime.IIngredientVisibility$IListener": Internal.ClassInfo, "com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoBlastingUpgradeItem": Internal.ClassInfo, "net.minecraft.world.level.block.WeepingVinesBlock": Internal.ClassInfo, "net.minecraft.advancements.Advancement$Builder": Internal.ClassInfo, "net.minecraft.world.entity.raid.Raider": Internal.ClassInfo, "net.minecraftforge.registries.tags.IReverseTag": Internal.ClassInfo, "net.minecraft.util.TaskChainer": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$KeyReleased$Post": Internal.ClassInfo, "net.minecraftforge.event.level.NoteBlockEvent$Octave": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractGlassBlock": Internal.ClassInfo, "java.awt.image.BufferStrategy": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.FluidCollectorBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.world.modifiers.InferiumOreModifier": Internal.ClassInfo, "com.mojang.serialization.Dynamic": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier3Item$Boots": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$CanTrampleContext": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectIterable": Internal.ClassInfo, "cofh.thermal.innovation.common.item.PotionInfuserItem": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.magenta.MagentaWallSignBlock": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BaseSwordItem": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$ItemPickupEvent": Internal.ClassInfo, "java.util.stream.DoubleStream": Internal.ClassInfo, "net.minecraft.network.protocol.BundlePacket": Internal.ClassInfo, "net.minecraft.world.level.block.TwistingVinesPlantBlock": Internal.ClassInfo, "com.mojang.datafixers.kinds.App2": Internal.ClassInfo, "net.minecraftforge.fml.config.ModConfig$Type": Internal.ClassInfo, "java.time.LocalDate": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.EndGatewayFeature": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration": Internal.ClassInfo, "net.minecraft.client.renderer.texture.DynamicTexture": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceBenchBlock": Internal.ClassInfo, "com.probejs.jdoc.document.AbstractDocument": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.CyanSprayCanItem": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.event.CustomInstructionKeyframeEvent": Internal.ClassInfo, "dev.ftb.mods.ftbquests.block.StageBarrierBlock": Internal.ClassInfo, "net.minecraft.commands.SharedSuggestionProvider": Internal.ClassInfo, "java.util.OptionalDouble": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable": Internal.ClassInfo, "java.nio.channels.AsynchronousFileChannel": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.item.EssenceItem": Internal.ClassInfo, "net.minecraft.network.FriendlyByteBuf": Internal.ClassInfo, "net.minecraft.world.level.block.CoralBlock": Internal.ClassInfo, "net.minecraft.world.level.block.CropBlock": Internal.ClassInfo, "cofh.core.common.block.EntityBlock6Way": Internal.ClassInfo, "net.minecraft.world.entity.animal.Rabbit": Internal.ClassInfo, "net.minecraftforge.entity.IEntityAdditionalSpawnData": Internal.ClassInfo, "java.nio.charset.Charset": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent": Internal.ClassInfo, "net.minecraft.world.entity.animal.camel.Camel": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.predicate.BlockEntityPredicateDataCheck": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.CrystalDisplayBlock": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityFluidStateContext": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.CustomMapData$Type": Internal.ClassInfo, "net.allthemods.alltheores.blocks.BOreBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemStackSet": Internal.ClassInfo, "com.google.common.collect.ForwardingList": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.StewItem": Internal.ClassInfo, "net.minecraft.world.entity.ai.memory.ExpirableValue": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortPredicate": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEventListener$Holder": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssenceFishingRodItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.BlockBrokenEventJS": Internal.ClassInfo, "vazkii.patchouli.common.util.ItemStackUtil$StackWrapper": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryGrandfatherClockBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.stages.Stages": Internal.ClassInfo, "net.minecraft.world.level.block.GlassBlock": Internal.ClassInfo, "com.hrznstudio.titanium.component.fluid.FluidTankComponent$Action": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.world.AccessorStructureTemplatePool": Internal.ClassInfo, "java.lang.Float": Internal.ClassInfo, "net.minecraft.world.entity.monster.Pillager": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData$Builder": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.InstrumentItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.TinyMap": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.OutputReplacement": Internal.ClassInfo, "net.minecraft.world.level.block.FlowerBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ByteSortedMap": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.white.WhiteWallSignBlock": Internal.ClassInfo, "net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptationType": Internal.ClassInfo, "vectorwing.farmersdelight.common.effect.ComfortEffect": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.WardenEntitySensor": Internal.ClassInfo, "net.minecraft.world.entity.ai.memory.MemoryStatus": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonWallClockBlock": Internal.ClassInfo, "net.minecraft.world.level.material.FluidState": Internal.ClassInfo, "net.minecraft.world.level.chunk.ChunkAccess$TicksToSave": Internal.ClassInfo, "net.minecraft.sounds.SoundSource": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.ColoredCavesPortalBlock": Internal.ClassInfo, "net.minecraft.client.renderer.culling.Frustum": Internal.ClassInfo, "net.minecraftforge.event.level.ChunkDataEvent": Internal.ClassInfo, "letsforge_pirates.item.CraftsmanItem$Boots": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleDeskBlock": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.input.KeyModifiers": Internal.ClassInfo, "net.minecraft.world.entity.AgeableMob": Internal.ClassInfo, "net.minecraft.client.multiplayer.ClientLevel": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier2Item$Chestplate": Internal.ClassInfo, "net.minecraftforge.server.permission.nodes.PermissionNode": Internal.ClassInfo, "net.minecraft.advancements.critereon.DeserializationContext": Internal.ClassInfo, "net.minecraftforge.client.event.ClientChatEvent": Internal.ClassInfo, "cpw.mods.jarhandling.JarMetadata": Internal.ClassInfo, "net.minecraft.world.level.validation.ForbiddenSymlinkInfo": Internal.ClassInfo, "net.minecraft.world.item.crafting.SmithingRecipe": Internal.ClassInfo, "net.minecraft.world.entity.animal.sniffer.Sniffer": Internal.ClassInfo, "net.minecraft.world.level.saveddata.maps.MapItemSavedData$HoldingPlayer": Internal.ClassInfo, "net.minecraft.world.level.block.state.BlockBehaviour": Internal.ClassInfo, "net.minecraft.world.entity.OwnableEntity": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimatableManager": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.VillagerProfessionBuilder": Internal.ClassInfo, "net.minecraft.client.gui.font.FontManager$Preparation": Internal.ClassInfo, "java.util.stream.DoubleStream$DoubleMapMultiConsumer": Internal.ClassInfo, "net.minecraft.world.entity.animal.AbstractGolem": Internal.ClassInfo, "net.minecraft.world.entity.animal.frog.Tadpole": Internal.ClassInfo, "net.minecraft.client.model.TridentModel": Internal.ClassInfo, "com.buuz135.industrial.block.misc.tile.EnchantmentSorterTile": Internal.ClassInfo, "net.minecraft.client.quickplay.QuickPlayLog$Type": Internal.ClassInfo, "cofh.thermal.lib.util.recipes.DynamoFuelSerializer": Internal.ClassInfo, "dev.latvian.mods.kubejs.forge.ForgeEventWrapper": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgePackResources": Internal.ClassInfo, "dev.latvian.mods.kubejs.gui.chest.ChestMenuClickCallback": Internal.ClassInfo, "java.util.function.DoubleToLongFunction": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.MobCrusherBlock": Internal.ClassInfo, "org.moddingx.libx.registration.Registerable$EntryCollector": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider$Rule": Internal.ClassInfo, "net.minecraft.world.level.LevelTimeAccess": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.AbstractNbtFeature": Internal.ClassInfo, "java.text.DecimalFormatSymbols": Internal.ClassInfo, "net.minecraft.world.level.entity.EntityTypeTest": Internal.ClassInfo, "net.mehvahdjukaar.sawmill.SawmillBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongPredicate": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightFenceBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonSittingFlamingPhase": Internal.ClassInfo, "net.minecraft.world.level.block.GrindstoneBlock": Internal.ClassInfo, "net.minecraft.world.level.material.WaterFluid$Flowing": Internal.ClassInfo, "com.mojang.datafixers.util.Function10": Internal.ClassInfo, "net.minecraft.world.LockCode": Internal.ClassInfo, "net.minecraft.world.level.block.BaseCoralPlantBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.HorizontalDirectionalBlockBuilder": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.util.random.AccessorWeightedRandomList": Internal.ClassInfo, "com.mojang.realmsclient.dto.PlayerInfo": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket": Internal.ClassInfo, "net.minecraft.client.gui.components.ChatComponent": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceKeyArgument$Info$Template": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.armor.EssenceLeggingsItem": Internal.ClassInfo, "net.minecraft.world.entity.npc.InventoryCarrier": Internal.ClassInfo, "com.mojang.datafixers.util.Function15": Internal.ClassInfo, "com.mojang.datafixers.util.Function16": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundCooldownPacket": Internal.ClassInfo, "com.mojang.datafixers.util.Function13": Internal.ClassInfo, "java.security.PrivilegedAction": Internal.ClassInfo, "com.mojang.datafixers.util.Function14": Internal.ClassInfo, "com.mojang.datafixers.util.Function11": Internal.ClassInfo, "com.mojang.datafixers.util.Function12": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.SoakingTableRecipe": Internal.ClassInfo, "letsforge_pirates.item.PirateTier3Item$Chestplate": Internal.ClassInfo, "net.minecraft.world.entity.ai.goal.Goal": Internal.ClassInfo, "com.google.common.collect.ImmutableList$Builder": Internal.ClassInfo, "net.minecraft.client.renderer.debug.DebugRenderer$SimpleDebugRenderer": Internal.ClassInfo, "org.lwjgl.stb.STBTTFontinfo": Internal.ClassInfo, "net.minecraft.world.item.EnchantedBookItem": Internal.ClassInfo, "java.util.function.LongBinaryOperator": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.ICookingUpgradeItem": Internal.ClassInfo, "net.minecraftforge.client.gui.overlay.ForgeGui": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.ModStairBlock": Internal.ClassInfo, "java.nio.ShortBuffer": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.tinkering.Augment": Internal.ClassInfo, "org.moddingx.libx.registration.SetupContext": Internal.ClassInfo, "net.minecraft.world.item.crafting.Ingredient": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongIterable": Internal.ClassInfo, "net.minecraft.world.level.ItemLike": Internal.ClassInfo, "net.minecraftforge.common.world.BiomeGenerationSettingsBuilder": Internal.ClassInfo, "net.minecraft.world.item.enchantment.TridentLoyaltyEnchantment": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder$Leggings": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsServer$State": Internal.ClassInfo, "net.minecraftforge.client.event.sound.SoundEvent": Internal.ClassInfo, "dev.latvian.mods.itemfilters.core.ItemFiltersStack": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$KeyPressed": Internal.ClassInfo, "java.lang.reflect.AccessibleObject": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.task.CustomTask$Check": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.callbacks.EntityFallenOnBlockCallbackJS": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crafting.ISouliumSpawnerRecipe": Internal.ClassInfo, "net.minecraft.commands.SharedSuggestionProvider$TextCoordinates": Internal.ClassInfo, "net.minecraft.network.chat.contents.DataSource": Internal.ClassInfo, "javax.accessibility.AccessibleComponent": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.LongJumpMidJump": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ItemArmorTierRegistryEventJS": Internal.ClassInfo, "cofh.thermal.dynamics.common.block.DuctBlock": Internal.ClassInfo, "java.awt.event.WindowFocusListener": Internal.ClassInfo, "org.joml.Vector2ic": Internal.ClassInfo, "dev.ftb.mods.ftbxmodcompat.ftbteams.kubejs.KJSTeamWrapper": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket": Internal.ClassInfo, "cofh.thermal.core.common.block.device.EntityBlockComposter": Internal.ClassInfo, "java.nio.channels.ByteChannel": Internal.ClassInfo, "dev.latvian.mods.kubejs.generator.ResourceGenerator": Internal.ClassInfo, "com.obscuria.obscureapi.common.items.VialOfKnowledgeItem": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.entities.BombEntity$BreakingMode": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.blue.BlueStandingSignBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootPool": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeEntity": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade": Internal.ClassInfo, "java.lang.reflect.Member": Internal.ClassInfo, "java.net.NetworkInterface": Internal.ClassInfo, "com.blakebr0.cucumber.block.BaseSlabBlock": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$LineOfSightContext": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.AwakeningRecipe": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2IntMap$Entry": Internal.ClassInfo, "net.minecraft.client.gui.components.AbstractButton": Internal.ClassInfo, "net.minecraftforge.common.world.ModifiableStructureInfo$StructureInfo$Builder": Internal.ClassInfo, "java.awt.JobAttributes$DestinationType": Internal.ClassInfo, "com.mojang.blaze3d.pipeline.RenderTarget": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.LongArgumentInfo$Template": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure": Internal.ClassInfo, "net.minecraft.world.level.block.KelpBlock": Internal.ClassInfo, "net.minecraft.world.level.block.HorizontalDirectionalBlock": Internal.ClassInfo, "net.minecraft.world.level.biome.Biome$TemperatureModifier": Internal.ClassInfo, "io.netty.buffer.AbstractReferenceCountedByteBuf": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructureStart": Internal.ClassInfo, "com.blakebr0.cucumber.iface.ICustomBow": Internal.ClassInfo, "dev.latvian.mods.kubejs.script.ConsoleLine": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.filter.RecipeFilterParseEvent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositFilterType": Internal.ClassInfo, "net.liopyu.entityjs.builders.MobBuilder": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$CalculateFallDamageContext": Internal.ClassInfo, "dev.ftb.mods.ftbquests.item.StageBarrierBlockItem": Internal.ClassInfo, "net.minecraft.world.entity.monster.WitherSkeleton": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2CharFunction": Internal.ClassInfo, "net.minecraft.world.inventory.BlastFurnaceMenu": Internal.ClassInfo, "net.minecraft.world.level.block.RootedDirtBlock": Internal.ClassInfo, "com.mojang.brigadier.suggestion.SuggestionProvider": Internal.ClassInfo, "net.minecraftforge.eventbus.api.IEventBusInvokeDispatcher": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.FlammableBrightFullBlock": Internal.ClassInfo, "earth.terrarium.chipped.common.blocks.WorkbenchBlock$WorkbenchModelType": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.util.FilterItemStackHandler": Internal.ClassInfo, "de.keksuccino.melody.mixin.mixins.common.client.IMixinSoundManager": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterColorHandlersEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.AlterGroundDecorator": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement": Internal.ClassInfo, "java.lang.reflect.Field": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.BooleanConfig": Internal.ClassInfo, "io.netty.util.ReferenceCounted": Internal.ClassInfo, "net.minecraft.client.renderer.entity.ItemRenderer": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.TreeExtractorBoost$Serializer": Internal.ClassInfo, "net.minecraftforge.registries.MissingMappingsEvent$Mapping": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker$IItemHandlerInserter": Internal.ClassInfo, "net.minecraft.world.level.chunk.Palette$Factory": Internal.ClassInfo, "net.minecraft.world.level.block.SignBlock": Internal.ClassInfo, "java.awt.event.AWTEventListener": Internal.ClassInfo, "net.minecraft.world.item.HangingEntityItem": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier2Item$Boots": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.DoubleArgumentInfo": Internal.ClassInfo, "com.hrznstudio.titanium.item.BasicItem": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.lib.AbilityCache": Internal.ClassInfo, "net.minecraft.world.level.block.PressurePlateBlock": Internal.ClassInfo, "java.lang.Runnable": Internal.ClassInfo, "net.minecraft.nbt.IntArrayTag": Internal.ClassInfo, "net.minecraft.world.level.block.MagmaBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.SpikeFeature$EndSpike": Internal.ClassInfo, "net.minecraftforge.common.world.ModifiableBiomeInfo$BiomeInfo": Internal.ClassInfo, "javax.swing.text.AttributeSet$ColorAttribute": Internal.ClassInfo, "net.minecraft.client.renderer.chunk.RenderRegionCache": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier2Item$Chestplate": Internal.ClassInfo, "com.google.common.collect.ImmutableSet": Internal.ClassInfo, "cofh.core.common.block.EntityBlockCoFH": Internal.ClassInfo, "net.minecraftforge.event.PlayLevelSoundEvent": Internal.ClassInfo, "java.lang.module.Configuration": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.OutputReplacementTransformer": Internal.ClassInfo, "dev.latvian.mods.unit.VariableSet": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.PlacementContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructureSpawnOverride$BoundingBoxType": Internal.ClassInfo, "cofh.thermal.dynamics.common.item.AttachmentItem": Internal.ClassInfo, "cofh.thermal.lib.util.recipes.ThermalCatalyst": Internal.ClassInfo, "letsforge_pirates.block.ShipInBottleBlock": Internal.ClassInfo, "journeymap.client.api.event.forge.PopupMenuEvent$WaypointPopupMenuEvent": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.FisherBoost": Internal.ClassInfo, "java.util.HashSet": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.misc.OverencumberedEffect": Internal.ClassInfo, "com.mojang.brigadier.arguments.StringArgumentType": Internal.ClassInfo, "net.minecraft.world.entity.animal.WaterAnimal": Internal.ClassInfo, "dev.ftb.mods.ftbquests.util.ProgressChange": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.CountPlacement": Internal.ClassInfo, "org.slf4j.spi.LoggingEventBuilder": Internal.ClassInfo, "org.violetmoon.zeta.mixin.mixins.AccessorLootTable": Internal.ClassInfo, "com.mojang.blaze3d.platform.NativeImage": Internal.ClassInfo, "net.minecraft.world.level.gameevent.vibrations.VibrationSystem": Internal.ClassInfo, "java.util.concurrent.ExecutorService": Internal.ClassInfo, "net.minecraft.world.entity.TamableAnimal": Internal.ClassInfo, "io.netty.channel.ChannelProgressivePromise": Internal.ClassInfo, "java.awt.EventQueue": Internal.ClassInfo, "net.minecraft.client.gui.font.FontManager": Internal.ClassInfo, "net.minecraftforge.event.TickEvent$LevelTickEvent": Internal.ClassInfo, "net.minecraft.world.item.BlockItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.InputReplacementTransformer": Internal.ClassInfo, "java.awt.event.ActionEvent": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.FossilFeature": Internal.ClassInfo, "net.minecraft.world.entity.Entity": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundRespawnPacket": Internal.ClassInfo, "com.mojang.datafixers.schemas.Schema": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier3Item$Chestplate": Internal.ClassInfo, "net.minecraftforge.client.event.ContainerScreenEvent$Render$Background": Internal.ClassInfo, "java.util.function.LongSupplier": Internal.ClassInfo, "net.minecraftforge.client.event.RenderGuiEvent$Pre": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent": Internal.ClassInfo, "cofh.core.common.item.BlockItemCoFH": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2FloatFunction": Internal.ClassInfo, "java.lang.module.ModuleReference": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$IntValue": Internal.ClassInfo, "de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget$CustomBackgroundResetBehavior": Internal.ClassInfo, "chiefarug.mods.systeams.SteamFluid$Source": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeRecipeSerializer": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.NotificationBuilder": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier3Item": Internal.ClassInfo, "net.minecraft.core.RegistryAccess": Internal.ClassInfo, "javax.swing.text.AttributeSet$ParagraphAttribute": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$Constant": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier3Item$Chestplate": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.callbacks.BlockExplodedCallbackJS": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.QuiverItem": Internal.ClassInfo, "net.minecraftforge.event.entity.living.MobEffectEvent$Applicable": Internal.ClassInfo, "net.minecraft.world.entity.monster.Evoker": Internal.ClassInfo, "com.probejs.jdoc.property.PropertyType": Internal.ClassInfo, "net.minecraft.world.item.PlayerHeadItem": Internal.ClassInfo, "java.util.Dictionary": Internal.ClassInfo, "java.lang.Throwable": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.SmokingUpgradeItem": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaBlueBlock": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.FlammableBrightSlabBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.forge.ForgeEventConsumer": Internal.ClassInfo, "net.minecraft.world.level.lighting.ChunkSkyLightSources": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedRegistryEntryExtension": Internal.ClassInfo, "net.minecraftforge.common.world.ForgeBiomeModifiers$AddFeaturesBiomeModifier": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket": Internal.ClassInfo, "com.mojang.serialization.Encoder": Internal.ClassInfo, "net.minecraft.world.Container": Internal.ClassInfo, "net.minecraft.core.Direction$Axis": Internal.ClassInfo, "net.minecraftforge.client.event.ComputeFovModifierEvent": Internal.ClassInfo, "net.minecraft.world.item.crafting.SimpleCookingSerializer": Internal.ClassInfo, "net.minecraft.world.item.crafting.CookingBookCategory": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.CanvasRugBlock": Internal.ClassInfo, "java.util.ResourceBundle$Control": Internal.ClassInfo, "java.util.function.BiConsumer": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerInteractEvent": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.misc.Triplet": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.SwordItemBuilder": Internal.ClassInfo, "com.mojang.serialization.MapCodec$ResultFunction": Internal.ClassInfo, "net.minecraft.world.level.block.DiodeBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Opening": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.MushroomColonyItem": Internal.ClassInfo, "com.blakebr0.cucumber.crafting.recipe.ShapedTransferDamageRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.entity.animal.Animal": Internal.ClassInfo, "dev.latvian.mods.kubejs.integration.forge.jei.AddJEIEventJS": Internal.ClassInfo, "net.minecraftforge.event.village.WandererTradesEvent": Internal.ClassInfo, "net.minecraft.world.level.block.FletchingTableBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.BlazeRodBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.worldgen.BasaltAshFeature": Internal.ClassInfo, "com.mojang.serialization.Codec": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator": Internal.ClassInfo, "cofh.thermal.core.common.block.SignalumGlassBlock": Internal.ClassInfo, "org.joml.Vector2dc": Internal.ClassInfo, "net.minecraft.world.entity.EntityDimensions": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$LevelAnimalContext": Internal.ClassInfo, "net.minecraft.client.renderer.texture.Dumpable": Internal.ClassInfo, "net.minecraft.world.level.gameevent.EntityPositionSource": Internal.ClassInfo, "net.minecraft.world.entity.SlotAccess": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.LangEventJS": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonTakeoffPhase": Internal.ClassInfo, "net.minecraft.client.telemetry.ClientTelemetryManager": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.BubbleBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleCounterBlock": Internal.ClassInfo, "net.minecraft.world.effect.MobEffectInstance$FactorData": Internal.ClassInfo, "net.minecraftforge.server.permission.events.PermissionGatherEvent$Nodes": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEvent$Context": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier3Item$Helmet": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundChatAckPacket": Internal.ClassInfo, "net.minecraft.client.model.ArmedModel": Internal.ClassInfo, "java.lang.Cloneable": Internal.ClassInfo, "net.minecraft.world.level.block.DoubleBlockCombiner$NeighborCombineResult": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.ConfigGroup": Internal.ClassInfo, "org.joml.Vector2fc": Internal.ClassInfo, "net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity": Internal.ClassInfo, "net.minecraft.client.renderer.MultiBufferSource": Internal.ClassInfo, "net.minecraft.world.entity.SpawnGroupData": Internal.ClassInfo, "java.time.temporal.ChronoField": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FluidLike": Internal.ClassInfo, "dev.latvian.mods.kubejs.typings.desc.PrimitiveDescJS": Internal.ClassInfo, "com.obscuria.aquamirae.common.effects.ArmorDecreaseMobEffect": Internal.ClassInfo, "net.minecraft.client.sounds.SoundEngine": Internal.ClassInfo, "net.minecraft.world.level.block.WeatheringCopper$WeatherState": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.HookItem": Internal.ClassInfo, "letsforge_pirates.item.Merchant1Item$Helmet": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityMountEvent": Internal.ClassInfo, "com.obscuria.obscureapi.common.enchantments.FastSpinEnchantment": Internal.ClassInfo, "com.hrznstudio.titanium.api.redstone.IRedstoneState": Internal.ClassInfo, "net.minecraft.client.renderer.debug.GoalSelectorDebugRenderer": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaGreenBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObject2FloatMap": Internal.ClassInfo, "net.minecraft.world.level.block.AmethystBlock": Internal.ClassInfo, "com.probejs.jdoc.java.FieldInfo": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.HeightProvider": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter.StonecutterUpgradeItem": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.FoxEntityAccessor": Internal.ClassInfo, "net.minecraft.world.level.block.MangrovePropaguleBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Render$Post": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.FuelItem": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.util.TooltipList": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.BlockModificationEventJS": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.MatchingBlocksPredicate": Internal.ClassInfo, "net.minecraft.world.item.SolidBucketItem": Internal.ClassInfo, "java.awt.Dialog$ModalExclusionType": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractCauldronBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.IcebergFeature": Internal.ClassInfo, "net.minecraftforge.client.model.geometry.IUnbakedGeometry": Internal.ClassInfo, "net.minecraft.world.level.block.grower.AbstractTreeGrower": Internal.ClassInfo, "dev.architectury.core.block.ArchitecturyLiquidBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.EndGatewayConfiguration": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingDamageEvent": Internal.ClassInfo, "com.talhanation.smallships.mixin.controlling.BoatAccessor": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.LightGraySprayCanItem": Internal.ClassInfo, "java.awt.dnd.DropTargetEvent": Internal.ClassInfo, "java.util.stream.Collector": Internal.ClassInfo, "net.minecraftforge.event.entity.player.EntityItemPickupEvent": Internal.ClassInfo, "net.minecraft.world.item.CrossbowItem": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeLevel": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.IceSpikeFeature": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.AugmentItem": Internal.ClassInfo, "net.minecraft.world.InteractionResult": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonSittingScanningPhase": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent": Internal.ClassInfo, "net.minecraft.world.entity.monster.AbstractIllager": Internal.ClassInfo, "java.nio.ByteOrder": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2ByteFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$ValueSpec": Internal.ClassInfo, "net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen": Internal.ClassInfo, "com.mojang.brigadier.exceptions.BuiltInExceptionProvider": Internal.ClassInfo, "de.keksuccino.fancymenu.util.resource.resources.audio.IAudio": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.FermentationStationBlock": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ThrowableProjectile": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingEvent$LivingTickEvent": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.PotionDiffuserBoost": Internal.ClassInfo, "net.minecraft.world.level.block.MultifaceSpreader$SpreadPos": Internal.ClassInfo, "net.minecraft.world.level.chunk.ProtoChunk": Internal.ClassInfo, "net.minecraft.client.model.geom.builders.PartDefinition": Internal.ClassInfo, "net.minecraftforge.common.util.LazyOptional": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2DoubleFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.GeodeBlockSettings": Internal.ClassInfo, "net.minecraftforge.server.permission.nodes.PermissionNode$PermissionResolver": Internal.ClassInfo, "net.minecraft.commands.arguments.EntityArgument": Internal.ClassInfo, "net.minecraft.client.resources.model.ModelManager": Internal.ClassInfo, "net.minecraft.world.level.gameevent.vibrations.VibrationSystem$Data": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagKeyArgument": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeHolderSet$SerializationType": Internal.ClassInfo, "javax.accessibility.AccessibleRole": Internal.ClassInfo, "org.apache.logging.log4j.Marker": Internal.ClassInfo, "java.io.Flushable": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.green.GreenHangingSignBlock": Internal.ClassInfo, "net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$RenderChunk": Internal.ClassInfo, "java.nio.file.FileStore": Internal.ClassInfo, "com.blakebr0.cucumber.block.BaseStairsBlock": Internal.ClassInfo, "net.minecraft.world.inventory.LoomMenu": Internal.ClassInfo, "net.minecraft.world.item.TieredItem": Internal.ClassInfo, "net.minecraft.world.entity.WalkAnimationState": Internal.ClassInfo, "net.minecraft.world.level.chunk.LevelChunkSection": Internal.ClassInfo, "net.minecraft.world.entity.monster.RangedAttackMob": Internal.ClassInfo, "net.minecraft.util.InclusiveRange": Internal.ClassInfo, "com.gizmo.luggage.item.LuggageItem": Internal.ClassInfo, "net.minecraft.world.level.block.LeavesBlock": Internal.ClassInfo, "cofh.thermal.core.common.fluid.EnderFluid$FluidBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerChatPacket": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.Tilt": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent": Internal.ClassInfo, "java.util.ImmutableCollections$AbstractImmutableCollection": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemBuilder$NameCallback": Internal.ClassInfo, "java.lang.Readable": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket": Internal.ClassInfo, "net.minecraftforge.event.TickEvent$PlayerTickEvent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.SmeltingUpgradeItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch": Internal.ClassInfo, "cofh.thermal.locomotion.common.item.UnderwaterMinecartItem": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.armor.EssenceChestplateItem": Internal.ClassInfo, "net.minecraft.world.level.block.ConcretePowderBlock": Internal.ClassInfo, "net.minecraft.world.entity.projectile.Fireball": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModInfo": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.client.AccessorMinecraft": Internal.ClassInfo, "java.net.URLStreamHandlerFactory": Internal.ClassInfo, "fonnymunkey.simplehats.util.HatEntry$HatParticleSettings$HatParticleMovement": Internal.ClassInfo, "com.hrznstudio.titanium.component.inventory.MultiInventoryComponent": Internal.ClassInfo, "net.minecraft.world.item.EnchantedGoldenAppleItem": Internal.ClassInfo, "net.minecraft.world.item.HoneycombItem": Internal.ClassInfo, "net.minecraft.network.chat.HoverEvent": Internal.ClassInfo, "com.hrznstudio.titanium.block.tile.MachineTile": Internal.ClassInfo, "java.lang.annotation.Annotation": Internal.ClassInfo, "net.minecraftforge.network.NetworkEvent$ServerCustomPayloadEvent": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.SimpleItem": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.weapon.DaggerOfGreedItem": Internal.ClassInfo, "com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile": Internal.ClassInfo, "net.allthemods.alltheores.blocks.OtherOreBlock": Internal.ClassInfo, "com.google.common.collect.Multiset": Internal.ClassInfo, "net.minecraftforge.common.world.StructureModifier": Internal.ClassInfo, "net.mcreator.cozyhome.block.LargeAcaciaStumpBlock": Internal.ClassInfo, "net.minecraft.world.item.MilkBucketItem": Internal.ClassInfo, "com.mojang.authlib.minecraft.MinecraftSessionService": Internal.ClassInfo, "com.mojang.brigadier.Message": Internal.ClassInfo, "java.awt.Graphics2D": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier2Item$Helmet": Internal.ClassInfo, "eutros.framedcompactdrawers.item.ItemDrawersCustom": Internal.ClassInfo, "io.netty.channel.EventLoopGroup": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.FloatArgumentInfo": Internal.ClassInfo, "cofh.lib.common.block.CropBlockTall": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.task.Task": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.PiglinBruteSpecificSensor": Internal.ClassInfo, "net.minecraft.world.ticks.LevelTicks": Internal.ClassInfo, "net.mcreator.cozyhome.block.BlackLampBlock": Internal.ClassInfo, "net.minecraft.client.renderer.texture.SpriteTicker": Internal.ClassInfo, "com.obscuria.aquamirae.common.effects.SwimSpeedMobEffect": Internal.ClassInfo, "net.minecraft.client.OptionInstance": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.PineFoliagePlacer": Internal.ClassInfo, "net.minecraft.world.level.block.RotatedPillarBlock": Internal.ClassInfo, "net.minecraft.tags.TagNetworkSerialization$NetworkPayload": Internal.ClassInfo, "java.security.AccessControlContext": Internal.ClassInfo, "net.minecraft.world.level.block.FallingBlock": Internal.ClassInfo, "com.mojang.datafixers.types.templates.RecursivePoint$RecursivePointType": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeGroup": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.wrapper.DirectionWrapper": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssenceShearsItem": Internal.ClassInfo, "net.minecraft.world.level.block.RedstoneTorchBlock": Internal.ClassInfo, "javax.swing.text.AttributeSet$CharacterAttribute": Internal.ClassInfo, "net.minecraft.core.HolderLookup$RegistryLookup": Internal.ClassInfo, "top.theillusivec4.curios.api.type.capability.ICurioItem": Internal.ClassInfo, "com.google.gson.FieldNamingStrategy": Internal.ClassInfo, "net.minecraft.world.level.levelgen.SurfaceRules$RuleSource": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.HasSturdyFacePredicate": Internal.ClassInfo, "net.minecraft.commands.arguments.ArgumentSignatures": Internal.ClassInfo, "net.minecraftforge.event.entity.player.BonemealEvent": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.IOwnerProtected": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructurePiece": Internal.ClassInfo, "javax.swing.text.AttributeSet": Internal.ClassInfo, "cofh.core.util.filter.IFilter": Internal.ClassInfo, "com.google.common.reflect.TypeParameter": Internal.ClassInfo, "java.nio.file.DirectoryStream$Filter": Internal.ClassInfo, "org.moddingx.libx.impl.crafting.recipe.EmptyRecipe": Internal.ClassInfo, "net.minecraft.client.gui.screens.Screen": Internal.ClassInfo, "java.security.Signature": Internal.ClassInfo, "io.netty.channel.RecvByteBufAllocator": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$Range": Internal.ClassInfo, "java.awt.geom.AffineTransform": Internal.ClassInfo, "net.minecraft.stats.RecipeBook": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$OnEffectContext": Internal.ClassInfo, "com.hrznstudio.titanium.recipe.serializer.SerializableRecipe": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampCubbyFeature": Internal.ClassInfo, "cofh.lib.common.block.CakeBlockCoFH": Internal.ClassInfo, "net.minecraft.world.entity.player.ChatVisiblity": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeSource": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.worldgen.WaySignStructure$Type": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$CullStateShard": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectArrayList": Internal.ClassInfo, "net.minecraft.network.chat.MutableComponent": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaOrangeBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonChairBlock": Internal.ClassInfo, "net.minecraft.world.level.block.entity.SignText": Internal.ClassInfo, "mezz.jei.api.gui.handlers.IGuiClickableArea": Internal.ClassInfo, "net.minecraft.world.level.block.SculkSensorBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.NearestVisibleLivingEntitySensor": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectIterator": Internal.ClassInfo, "de.keksuccino.konkrete.events.ScreenKeyReleasedEvent": Internal.ClassInfo, "net.minecraft.util.SignatureUpdater$Output": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeEnchantment": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$MobInteractContext": Internal.ClassInfo, "net.minecraft.util.ModCheck$Confidence": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.request.AbuseReportRequest$ThirdPartyServerInfo": Internal.ClassInfo, "cofh.core.init.CoreEntityDataSerializers$1": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.tinkering.IAugmentProvider": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crop.ICropProvider": Internal.ClassInfo, "net.minecraft.world.entity.monster.Ghast": Internal.ClassInfo, "net.minecraft.world.level.levelgen.GenerationStep$Carving": Internal.ClassInfo, "net.minecraft.world.level.block.CarpetBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.Variant": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$DepthTestStateShard": Internal.ClassInfo, "cofh.lib.api.ContainerType": Internal.ClassInfo, "net.minecraft.world.level.chunk.PalettedContainerRO": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.Movable": Internal.ClassInfo, "net.minecraft.world.level.chunk.LevelChunk$EntityCreationType": Internal.ClassInfo, "net.minecraft.world.item.crafting.SingleItemRecipe$Serializer": Internal.ClassInfo, "com.mojang.brigadier.tree.LiteralCommandNode": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaLightBlueBlock": Internal.ClassInfo, "org.moddingx.libx.command.EnumArgument2": Internal.ClassInfo, "mezz.jei.api.runtime.config.IJeiConfigValueSerializer$IDeserializeResult": Internal.ClassInfo, "net.minecraft.world.level.saveddata.maps.MapItemSavedData": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2LongFunction": Internal.ClassInfo, "org.joml.Quaternionf": Internal.ClassInfo, "com.benbenlaw.roomopolis.item.custom.WallKeys.ClearWall3x3": Internal.ClassInfo, "org.joml.Quaterniond": Internal.ClassInfo, "java.awt.RenderingHints": Internal.ClassInfo, "java.awt.Point": Internal.ClassInfo, "org.joml.Matrix2dc": Internal.ClassInfo, "journeymap.client.api.event.forge.EntityRadarUpdateEvent$EntityType": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStorage": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration": Internal.ClassInfo, "com.mojang.blaze3d.vertex.BufferBuilder$DrawState": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseDragged$Post": Internal.ClassInfo, "net.minecraftforge.forgespi.locating.IModProvider": Internal.ClassInfo, "net.mcreator.cozyhome.block.PurpleLampBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.properties.AddSpawnProperties": Internal.ClassInfo, "net.minecraft.world.level.block.AttachedStemBlock": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.FishMountItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult": Internal.ClassInfo, "net.minecraft.world.level.block.EntityBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$MarkerOrMarked": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.ButtonBlockBuilder": Internal.ClassInfo, "net.minecraft.client.particle.ParticleProvider": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.BiasedToBottomHeight": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.StringArgumentSerializer$Template": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.AnimalRancherBlock": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeGenerationSettings$PlainBuilder": Internal.ClassInfo, "java.io.Writer": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.LivingEntityHurtEventJS": Internal.ClassInfo, "net.minecraft.world.level.biome.MobSpawnSettings$MobSpawnCost": Internal.ClassInfo, "net.minecraft.world.ContainerListener": Internal.ClassInfo, "net.minecraft.nbt.Tag": Internal.ClassInfo, "net.minecraft.commands.arguments.TimeArgument$Info": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.IglooStructure": Internal.ClassInfo, "net.minecraft.world.entity.monster.Spider": Internal.ClassInfo, "net.minecraftforge.registries.RegisterEvent$RegisterHelper": Internal.ClassInfo, "net.minecraft.tags.TagLoader$EntryWithSource": Internal.ClassInfo, "net.minecraftforge.registries.IForgeRegistry$AddCallback": Internal.ClassInfo, "net.minecraft.world.item.NameTagItem": Internal.ClassInfo, "dev.latvian.mods.rhino.IdScriptableObject": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.Structure": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.ChapterGroup": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterParticleProvidersEvent": Internal.ClassInfo, "cofh.core.util.crafting.ShapedPotionNBTRecipe$Serializer": Internal.ClassInfo, "java.util.ImmutableCollections$AbstractImmutableList": Internal.ClassInfo, "org.joml.Matrix2fc": Internal.ClassInfo, "net.minecraft.world.entity.animal.Rabbit$Variant": Internal.ClassInfo, "com.google.gson.JsonSerializationContext": Internal.ClassInfo, "dev.architectury.event.EventFactory$EventImpl": Internal.ClassInfo, "net.minecraft.world.entity.monster.Vindicator": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.report.ReportingContext": Internal.ClassInfo, "net.minecraftforge.client.model.geometry.IGeometryBakingContext": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2BooleanFunction": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.IColored": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent": Internal.ClassInfo, "net.minecraftforge.common.util.BlockSnapshot": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.SleepInBed": Internal.ClassInfo, "java.lang.annotation.ElementType": Internal.ClassInfo, "dev.architectury.utils.OptionalSupplier": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingHurtEvent": Internal.ClassInfo, "net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock": Internal.ClassInfo, "java.lang.invoke.MethodType": Internal.ClassInfo, "net.minecraft.client.KeyMapping": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder": Internal.ClassInfo, "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.CustomTaskEventJS": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.BushFoliagePlacer": Internal.ClassInfo, "net.minecraft.world.level.block.CryingObsidianBlock": Internal.ClassInfo, "net.minecraft.world.BossEvent$BossBarColor": Internal.ClassInfo, "net.minecraftforge.client.extensions.common.IClientItemExtensions$FontContext": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedItemExtension": Internal.ClassInfo, "net.minecraft.server.players.StoredUserList": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BeaconBlockEntity": Internal.ClassInfo, "com.teammetallurgy.aquaculture.block.NeptunesBountyBlock": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeBlockGetter": Internal.ClassInfo, "net.minecraft.commands.Commands$ParseFunction": Internal.ClassInfo, "net.minecraft.world.entity.Pose": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.FluidPlacerBlock": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.AlwaysTrueFilterItem": Internal.ClassInfo, "net.minecraft.world.item.enchantment.FrostWalkerEnchantment": Internal.ClassInfo, "com.electronwill.nightconfig.core.Config": Internal.ClassInfo, "chiefarug.mods.systeams.recipe.UpgradeShapelessRecipe": Internal.ClassInfo, "com.mojang.brigadier.builder.RequiredArgumentBuilder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.ReplaceablePredicate": Internal.ClassInfo, "java.util.ImmutableCollections$ListN": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakMirrorBlock": Internal.ClassInfo, "javax.accessibility.Accessible": Internal.ClassInfo, "net.allthemods.alltheores.blocks.AOreBlock": Internal.ClassInfo, "net.minecraft.network.chat.FormattedText": Internal.ClassInfo, "net.minecraft.util.valueproviders.UniformInt": Internal.ClassInfo, "com.mojang.authlib.minecraft.UserApiService$UserProperties": Internal.ClassInfo, "net.minecraft.world.level.saveddata.maps.MapItemSavedData$MapPatch": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier2Item$Helmet": Internal.ClassInfo, "com.teammetallurgy.aquaculture.block.FarmlandMoistBlock": Internal.ClassInfo, "net.minecraft.util.FormattedCharSequence": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.item.ItemDrawerKey": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexConsumer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier3Item$Leggings": Internal.ClassInfo, "com.mojang.serialization.codecs.RecordCodecBuilder$Mu": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryBenchBlock": Internal.ClassInfo, "com.buuz135.industrial.block.misc.tile.InfinityChargerTile": Internal.ClassInfo, "io.netty.channel.epoll.EpollEventLoopGroup": Internal.ClassInfo, "io.netty.channel.ChannelMetadata": Internal.ClassInfo, "net.minecraft.world.level.block.PlayerWallHeadBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$Marker$Type": Internal.ClassInfo, "net.minecraft.client.renderer.EffectInstance": Internal.ClassInfo, "letsforge_pirates.item.HookItem": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.SlabType": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceWallClockBlock": Internal.ClassInfo, "net.minecraft.world.entity.monster.warden.AngerLevel": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructureType": Internal.ClassInfo, "com.google.gson.stream.JsonToken": Internal.ClassInfo, "dev.ftb.mods.ftbquests.item.QuestBarrierBlockItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.LivingEntityEventJS": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket": Internal.ClassInfo, "java.time.chrono.AbstractChronology": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.desert.ChillzoneDesertFeature": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.QuestObjectBase": Internal.ClassInfo, "tocraft.walkers.api.variant.ShapeType": Internal.ClassInfo, "com.mojang.datafixers.FamilyOptic": Internal.ClassInfo, "net.minecraft.world.level.block.entity.TheEndPortalBlockEntity": Internal.ClassInfo, "net.minecraft.world.flag.FeatureElement": Internal.ClassInfo, "net.minecraftforge.items.IItemHandler": Internal.ClassInfo, "cofh.lib.common.block.OreBlockCoFH": Internal.ClassInfo, "dev.architectury.event.CompoundEventResult": Internal.ClassInfo, "net.minecraft.world.item.enchantment.WaterWalkerEnchantment": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.ConditionalFunction": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseInput": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.SwampHutStructure": Internal.ClassInfo, "cofh.thermal.core.common.fluid.CrudeOilFluid$FluidBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.InfusionPedestalBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakCounterBlock": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.MinecartCommandBlock": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.inventory.AccessorInventoryMenu": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBraceBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.Squid": Internal.ClassInfo, "com.google.common.collect.BiMap": Internal.ClassInfo, "io.netty.channel.ChannelHandlerAdapter": Internal.ClassInfo, "de.melanx.skyblockbuilder.item.ItemStructureSaver": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.OutputFluid": Internal.ClassInfo, "com.talhanation.smallships.duck.BoatLeashAccess": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.FeedingUpgradeItem": Internal.ClassInfo, "io.netty.channel.EventLoop": Internal.ClassInfo, "cofh.core.common.block.EnderAirBlock": Internal.ClassInfo, "net.minecraft.client.GraphicsStatus": Internal.ClassInfo, "net.minecraft.world.level.block.entity.SculkCatalystBlockEntity": Internal.ClassInfo, "com.mojang.authlib.ProfileLookupCallback": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEventListenerRegistry": Internal.ClassInfo, "com.google.common.collect.ImmutableMultimap$Builder": Internal.ClassInfo, "journeymap.client.api.display.DisplayType": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.BlockRightClickedEventJS": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionUpgradeWrapper": Internal.ClassInfo, "org.apache.logging.slf4j.Log4jMarker": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingChangeTargetEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.InputReplacement": Internal.ClassInfo, "mcjty.theoneprobe.items.AbstractRecipeAdaptor": Internal.ClassInfo, "net.minecraft.world.level.block.ButtonBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest": Internal.ClassInfo, "com.benbenlaw.caveopolis.recipe.SprayerRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.level.block.LoomBlock": Internal.ClassInfo, "net.minecraft.world.entity.player.ProfilePublicKey": Internal.ClassInfo, "software.bernie.geckolib.core.animation.RawAnimation$Stage": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crafting.IReprocessorRecipe": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntitySlave": Internal.ClassInfo, "dev.latvian.mods.kubejs.stages.StageCreationEvent": Internal.ClassInfo, "net.minecraftforge.registries.ForgeRegistry$Snapshot": Internal.ClassInfo, "net.minecraft.world.item.LingeringPotionItem": Internal.ClassInfo, "cofh.core.common.item.GrenadeItem": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ThrownEgg": Internal.ClassInfo, "net.minecraft.world.entity.projectile.Arrow": Internal.ClassInfo, "java.awt.image.WritableRaster": Internal.ClassInfo, "net.minecraft.world.level.block.CoralFanBlock": Internal.ClassInfo, "mezz.jei.api.runtime.IIngredientListOverlay": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.predicates.CompositeLootItemCondition$Builder": Internal.ClassInfo, "net.minecraft.world.level.block.BubbleColumnBlock": Internal.ClassInfo, "net.minecraft.world.level.block.RootsBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.SensorType": Internal.ClassInfo, "com.mojang.brigadier.suggestion.Suggestion": Internal.ClassInfo, "net.minecraft.world.entity.monster.Monster": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.EntityKJS": Internal.ClassInfo, "net.minecraft.core.IdMap": Internal.ClassInfo, "javax.accessibility.AccessibleBundle": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier1Item$Boots": Internal.ClassInfo, "io.netty.channel.ChannelInboundHandler": Internal.ClassInfo, "java.time.temporal.TemporalQuery": Internal.ClassInfo, "java.awt.dnd.DragGestureEvent": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.providers.number.NumberProvider": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongUnaryOperator": Internal.ClassInfo, "java.lang.Enum$EnumDesc": Internal.ClassInfo, "java.lang.module.ModuleFinder": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundMapItemDataPacket": Internal.ClassInfo, "net.minecraftforge.common.capabilities.CapabilityDispatcher": Internal.ClassInfo, "net.minecraft.world.level.block.MelonBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.ByteCollection": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.WateringCanItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer$FoliageAttachment": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier1Item": Internal.ClassInfo, "net.minecraft.resources.RegistryFileCodec": Internal.ClassInfo, "vectorwing.farmersdelight.common.effect.NourishmentEffect": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightFlammableLogBlock": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.Property": Internal.ClassInfo, "net.minecraft.world.entity.Display$TextDisplay$TextRenderState": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository$ItemRecord": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.WitherBuilderBlock": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.AttachFace": Internal.ClassInfo, "net.minecraft.world.level.block.IronBarsBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ModelEvent$RegisterGeometryLoaders": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.Boat": Internal.ClassInfo, "mezz.jei.api.ingredients.IIngredientType": Internal.ClassInfo, "net.minecraft.client.resources.metadata.animation.FrameSize": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.InfusedFarmlandBlock": Internal.ClassInfo, "fr.iglee42.notenoughchests.NotEnoughChests$1": Internal.ClassInfo, "fr.iglee42.notenoughchests.NotEnoughChests$3": Internal.ClassInfo, "net.minecraft.world.level.pathfinder.Node": Internal.ClassInfo, "mezz.jei.api.gui.handlers.IGhostIngredientHandler$Target": Internal.ClassInfo, "net.minecraft.network.protocol.BundlerInfo": Internal.ClassInfo, "net.minecraft.world.level.entity.EntityAccess": Internal.ClassInfo, "com.blakebr0.cucumber.block.BaseWallBlock": Internal.ClassInfo, "net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeModelBaker": Internal.ClassInfo, "cofh.lib.common.effect.MobEffectCoFH": Internal.ClassInfo, "com.google.gson.stream.JsonReader": Internal.ClassInfo, "com.google.gson.FieldAttributes": Internal.ClassInfo, "net.minecraft.world.level.block.WallSignBlock": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.RopeItem": Internal.ClassInfo, "cofh.lib.api.item.ISecurableItem": Internal.ClassInfo, "com.obscuria.obscureapi.common.effects.Fury": Internal.ClassInfo, "net.minecraftforge.event.server.ServerAboutToStartEvent": Internal.ClassInfo, "net.minecraft.world.entity.monster.ZombifiedPiglin": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsNews": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.StartupEventJS": Internal.ClassInfo, "net.minecraftforge.registries.tags.ITag": Internal.ClassInfo, "de.keksuccino.konkrete.events.ScreenMouseClickedEvent": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.DoubleConfig": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.MultifaceGrowthFeature": Internal.ClassInfo, "net.minecraft.commands.arguments.ScoreHolderArgument$Info": Internal.ClassInfo, "net.minecraft.world.item.TooltipFlag": Internal.ClassInfo, "java.security.CodeSource": Internal.ClassInfo, "net.liopyu.entityjs.entities.IAnimatableJS": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortCollection": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData": Internal.ClassInfo, "net.minecraft.world.entity.AnimationState": Internal.ClassInfo, "net.minecraft.world.item.crafting.ShieldDecorationRecipe": Internal.ClassInfo, "chiefarug.mods.systeams.ConversionKitItem": Internal.ClassInfo, "net.minecraft.server.packs.repository.Pack": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$LayeringStateShard": Internal.ClassInfo, "dev.latvian.mods.rhino.JavaMembers$MethodInfo": Internal.ClassInfo, "net.minecraft.core.particles.DustParticleOptionsBase": Internal.ClassInfo, "dev.latvian.mods.kubejs.typings.desc.GenericDescJS": Internal.ClassInfo, "it.hurts.sskirillss.octolib.particle.BasicColoredParticle$Factory$Type": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.MoveToTargetSink": Internal.ClassInfo, "net.minecraft.world.level.block.WallBannerBlock": Internal.ClassInfo, "net.minecraft.world.entity.monster.ZombieVillager": Internal.ClassInfo, "java.security.spec.AlgorithmParameterSpec": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.BlockStateProperties": Internal.ClassInfo, "dev.ftb.mods.ftbquests.block.TaskScreenBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase": Internal.ClassInfo, "net.minecraft.data.PackOutput$Target": Internal.ClassInfo, "org.apache.maven.artifact.repository.Authentication": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.icon.Color4I": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedBlockExtension": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.ExplosionEventJS$Before": Internal.ClassInfo, "net.minecraft.world.level.block.Block$BlockStatePairKey": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier1Item$Helmet": Internal.ClassInfo, "org.joml.Matrix4x3fc": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.SculkPatchConfiguration": Internal.ClassInfo, "com.buuz135.industrial.block.generator.tile.BioReactorTile": Internal.ClassInfo, "com.hrznstudio.titanium.block_network.graph.NetworkGraphScannerRequest": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.TinkeringTableBlock": Internal.ClassInfo, "mezz.jei.api.runtime.IRecipesGui": Internal.ClassInfo, "net.minecraft.world.level.block.HoneyBlock": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.PiratePouchItem": Internal.ClassInfo, "net.minecraftforge.event.TickEvent$ClientTickEvent": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.ItemOverride$Predicate": Internal.ClassInfo, "de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinSplashRenderer": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider": Internal.ClassInfo, "net.minecraft.data.recipes.RecipeCategory": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.WeepingVinesFeature": Internal.ClassInfo, "net.minecraftforge.client.event.EntityRenderersEvent$CreateSkullModels": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaPinkBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.gui.chest.ChestMenuSlot": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.event.KeyFrameEvent": Internal.ClassInfo, "net.minecraft.client.gui.Font$DisplayMode": Internal.ClassInfo, "io.netty.channel.ChannelInboundInvoker": Internal.ClassInfo, "net.minecraftforge.client.event.RenderTooltipEvent$GatherComponents": Internal.ClassInfo, "net.minecraft.world.entity.raid.Raids": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructureSet": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.gray.GrayWallHangingSignBlock": Internal.ClassInfo, "net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo": Internal.ClassInfo, "cofh.lib.common.block.RailBlockCoFH": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.IKeyLockable": Internal.ClassInfo, "net.minecraft.client.PrioritizeChunkUpdates": Internal.ClassInfo, "io.netty.channel.ChannelHandler": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.SpikeFeature": Internal.ClassInfo, "com.mojang.datafixers.TypeRewriteRule": Internal.ClassInfo, "net.minecraftforge.common.world.ForgeBiomeModifiers$RemoveFeaturesBiomeModifier": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedLiquidBlockExtension": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakWallClockBlock": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.weapon.DividerItem": Internal.ClassInfo, "net.minecraft.world.item.SplashPotionItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FluidBucketItemBuilder": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.ItemOverrides": Internal.ClassInfo, "net.minecraft.world.level.LevelWriter": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceKeyArgument$Info": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.OreLaserBaseBlock": Internal.ClassInfo, "net.minecraft.world.entity.RiderShieldingMount": Internal.ClassInfo, "java.nio.channels.Channel": Internal.ClassInfo, "dev.latvian.mods.rhino.Context": Internal.ClassInfo, "com.buuz135.industrial.fluid.OreFluidInstance$1": Internal.ClassInfo, "net.minecraft.world.level.material.MapColor$Brightness": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.ANDFilterItem": Internal.ClassInfo, "net.minecraft.world.entity.ai.village.poi.PoiType": Internal.ClassInfo, "net.mcreator.cozyhome.block.LargeOakStumpBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.LongJumpToPreferredBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeWrapper": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.SolidPredicate": Internal.ClassInfo, "net.minecraft.world.level.block.SmithingTableBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.GobletBlock": Internal.ClassInfo, "journeymap.client.api.util.UIState": Internal.ClassInfo, "cofh.core.util.crafting.ShapedPotionNBTRecipe": Internal.ClassInfo, "net.minecraft.client.renderer.texture.OverlayTexture": Internal.ClassInfo, "dev.latvian.mods.unit.function.FunctionFactory": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.NBTSerializable": Internal.ClassInfo, "java.awt.font.TextAttribute": Internal.ClassInfo, "org.joml.Matrix3dc": Internal.ClassInfo, "net.minecraftforge.registries.IdMappingEvent": Internal.ClassInfo, "net.minecraft.world.level.block.WebBlock": Internal.ClassInfo, "net.minecraft.world.entity.monster.piglin.AbstractPiglin": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.EnderScramblerBlock": Internal.ClassInfo, "net.minecraft.world.level.block.BuddingAmethystBlock": Internal.ClassInfo, "cofh.lib.common.inventory.ItemStorageCoFH": Internal.ClassInfo, "com.talhanation.smallships.world.item.CogItem": Internal.ClassInfo, "cofh.core.common.effect.WrenchedMobEffect": Internal.ClassInfo, "java.nio.Buffer": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceMirrorBlock": Internal.ClassInfo, "net.minecraft.world.level.block.CoralPlantBlock": Internal.ClassInfo, "net.minecraft.util.LazyLoadedValue": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.item.ItemKey": Internal.ClassInfo, "net.allthemods.alltheores.blocks.ToolTipBlockItem": Internal.ClassInfo, "net.minecraftforge.common.util.NonNullPredicate": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket": Internal.ClassInfo, "net.minecraft.world.entity.PlayerRideableJumping": Internal.ClassInfo, "net.mcreator.cozyhome.block.BambooWallClockBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundGameEventPacket$Type": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.VegetationPatchFeature": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.forge.LivingEntityDropsEventJS": Internal.ClassInfo, "com.mojang.authlib.minecraft.UserApiService": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.LargeDripstoneConfiguration": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceChairBlock": Internal.ClassInfo, "org.joml.Matrix4x3dc": Internal.ClassInfo, "com.mojang.serialization.KeyCompressor": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.WallBlockBuilder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.WorldGenerationContext": Internal.ClassInfo, "de.keksuccino.fancymenu.util.resource.Resource": Internal.ClassInfo, "java.util.SortedSet": Internal.ClassInfo, "com.mojang.serialization.codecs.RecordCodecBuilder$Instance": Internal.ClassInfo, "chiefarug.mods.systeams.block.BoilerBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer": Internal.ClassInfo, "net.minecraftforge.registries.tags.ITagManager": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.LootBuilderPool": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonChargePlayerPhase": Internal.ClassInfo, "journeymap.client.api.display.ModPopupMenu$Action": Internal.ClassInfo, "java.util.function.ToLongFunction": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.EnchanterRecipe$Serializer": Internal.ClassInfo, "com.google.common.collect.ImmutableSetMultimap": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.BlockFaceUV": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup": Internal.ClassInfo, "net.minecraft.world.entity.Entity$RemovalReason": Internal.ClassInfo, "realmayus.aquatictorches.AquaticTorchBlock": Internal.ClassInfo, "net.minecraft.world.item.TridentItem": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSelectTradePacket": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.WindowKJS": Internal.ClassInfo, "net.minecraft.client.resources.SplashManager": Internal.ClassInfo, "net.minecraftforge.items.ItemStackHandler": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.PressurePlateBlockBuilder": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.TimeComponent": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaRedBlock": Internal.ClassInfo, "net.minecraftforge.event.level.LevelEvent$Save": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityDamageContext": Internal.ClassInfo, "net.minecraft.world.item.enchantment.FishingSpeedEnchantment": Internal.ClassInfo, "net.minecraft.world.level.block.entity.SculkSensorBlockEntity": Internal.ClassInfo, "net.minecraft.client.renderer.RenderBuffers": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.PistonType": Internal.ClassInfo, "java.lang.ModuleLayer": Internal.ClassInfo, "net.mcreator.cozyhome.block.GrayLampBlock": Internal.ClassInfo, "net.minecraft.server.level.ServerLevel": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.crafting.BackpackUpgradeRecipe": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties$Winding": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.CustomMapData": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.NoOpFeature": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootDataId": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelStorageSource$LevelStorageAccess": Internal.ClassInfo, "java.lang.reflect.GenericDeclaration": Internal.ClassInfo, "net.minecraftforge.client.model.data.ModelDataManager": Internal.ClassInfo, "net.minecraft.world.level.block.MultifaceBlock": Internal.ClassInfo, "net.minecraftforge.forgespi.language.ModFileScanData$AnnotationData": Internal.ClassInfo, "tfar.dankstorage.item.CDankItem": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$CharacterTyped": Internal.ClassInfo, "net.minecraft.world.level.Explosion": Internal.ClassInfo, "java.util.function.LongConsumer": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonSinkCounterBlock": Internal.ClassInfo, "net.minecraft.client.model.Model": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket": Internal.ClassInfo, "net.minecraft.client.Options$FieldAccess": Internal.ClassInfo, "java.lang.Class": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.item.ItemDrawers": Internal.ClassInfo, "com.blamejared.controlling.mixin.AccessKeyMapping": Internal.ClassInfo, "letsforge_pirates.item.DeckhandItem$Leggings": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.HeightRangePlacement": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket": Internal.ClassInfo, "net.minecraft.world.level.block.StructureVoidBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Closing": Internal.ClassInfo, "com.talhanation.smallships.world.item.GalleyItem": Internal.ClassInfo, "net.minecraft.world.phys.shapes.Shapes$DoubleLineConsumer": Internal.ClassInfo, "dev.latvian.mods.kubejs.platform.forge.ingredient.KubeJSIngredientSerializer": Internal.ClassInfo, "net.minecraft.world.scores.Team": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.DryingTableRecipe": Internal.ClassInfo, "net.minecraft.world.level.levelgen.synth.NormalNoise": Internal.ClassInfo, "com.electronwill.nightconfig.core.file.CommentedFileConfigBuilder": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.entity.AccessorEntity": Internal.ClassInfo, "net.minecraft.network.chat.FormattedText$ContentConsumer": Internal.ClassInfo, "net.minecraft.client.player.AbstractClientPlayer": Internal.ClassInfo, "dev.latvian.mods.kubejs.registry.BuilderFactory": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage": Internal.ClassInfo, "cofh.core.client.particle.types.CylindricalParticleType": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.ChestEventJS": Internal.ClassInfo, "java.time.zone.ZoneOffsetTransition": Internal.ClassInfo, "net.minecraft.world.entity.monster.Giant": Internal.ClassInfo, "cpw.mods.jarhandling.SecureJar$ModuleDataProvider": Internal.ClassInfo, "cofh.lib.common.inventory.SimpleItemHandler": Internal.ClassInfo, "com.electronwill.nightconfig.core.ConfigFormat": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.block.entity.AccessorSignBlockEntity": Internal.ClassInfo, "java.awt.Transparency": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.WidgetType": Internal.ClassInfo, "java.util.function.ObjLongConsumer": Internal.ClassInfo, "dev.latvian.mods.unit.token.CharStream": Internal.ClassInfo, "journeymap.client.api.model.MapImage": Internal.ClassInfo, "net.minecraft.world.item.ItemStack": Internal.ClassInfo, "com.google.gson.TypeAdapterFactory": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.EndCityStructure": Internal.ClassInfo, "net.minecraft.world.level.levelgen.VerticalAnchor$AboveBottom": Internal.ClassInfo, "net.minecraft.world.item.crafting.SingleItemRecipe": Internal.ClassInfo, "com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon": Internal.ClassInfo, "com.mojang.datafixers.functions.PointFree": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.BaseQuestFile": Internal.ClassInfo, "java.net.FileNameMap": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool": Internal.ClassInfo, "javax.accessibility.AccessibleText": Internal.ClassInfo, "top.theillusivec4.curios.api.SlotContext": Internal.ClassInfo, "net.minecraftforge.fluids.capability.IFluidHandler": Internal.ClassInfo, "dev.latvian.mods.kubejs.script.ScriptTypePredicate": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration": Internal.ClassInfo, "net.minecraft.world.ticks.LevelTickAccess": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$LightmapStateShard": Internal.ClassInfo, "org.lwjgl.PointerBuffer": Internal.ClassInfo, "net.minecraft.client.renderer.debug.GameEventListenerRenderer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.DesertWellFeature": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure": Internal.ClassInfo, "net.minecraft.world.level.block.piston.PistonMovingBlockEntity": Internal.ClassInfo, "java.io.BufferedReader": Internal.ClassInfo, "net.minecraft.world.item.BookItem": Internal.ClassInfo, "net.minecraft.core.particles.SimpleParticleType": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier2Item$Helmet": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.UnderwaterMagmaFeature": Internal.ClassInfo, "cofh.thermal.lib.common.item.AugmentItem": Internal.ClassInfo, "net.minecraft.data.DataGenerator$PackGenerator": Internal.ClassInfo, "dev.ftb.mods.ftbteams.api.property.TeamPropertyValue": Internal.ClassInfo, "net.minecraft.world.entity.NeutralMob": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeDispensibleContainerItem": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.magenta.MagentaWallHangingSignBlock": Internal.ClassInfo, "net.minecraft.commands.synchronization.ArgumentTypeInfo": Internal.ClassInfo, "org.joml.Matrix3fc": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonLandingApproachPhase": Internal.ClassInfo, "com.mojang.authlib.properties.PropertyMap": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.TeamData": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.CaveWorldCarver": Internal.ClassInfo, "top.theillusivec4.curios.api.client.ICurioRenderer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.WeightedListHeight": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractFurnaceBlock": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsServerPlayerLists": Internal.ClassInfo, "com.buuz135.industrial.block.IndustrialBlock": Internal.ClassInfo, "letsforge_pirates.block.BarrelBombBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeNoteParticleData": Internal.ClassInfo, "java.lang.Thread$State": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.worldgen.RoadSignFeature$RandomState": Internal.ClassInfo, "com.mojang.datafixers.RewriteResult": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.ThreeBoltArmorItem": Internal.ClassInfo, "com.google.common.collect.Multiset$Entry": Internal.ClassInfo, "java.text.Format$Field": Internal.ClassInfo, "net.minecraft.world.entity.Display$TextDisplay$CachedInfo": Internal.ClassInfo, "net.minecraft.world.entity.Display$IntInterpolator": Internal.ClassInfo, "java.util.List": Internal.ClassInfo, "net.minecraft.world.level.storage.CommandStorage": Internal.ClassInfo, "net.minecraft.world.level.block.DoubleBlockCombiner$Combiner": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier2Item$Boots": Internal.ClassInfo, "net.minecraft.world.entity.ai.control.LookControl": Internal.ClassInfo, "net.minecraft.world.level.block.LayeredCauldronBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.IInventoryPartHandler": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer$FoliageSetter": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$BreedableEntityContext": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.DoubleArgumentInfo$Template": Internal.ClassInfo, "javax.swing.text.StyleConstants": Internal.ClassInfo, "net.minecraft.world.inventory.DispenserMenu": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEvent": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$ShaderStateShard": Internal.ClassInfo, "java.lang.Iterable": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.LongArgumentInfo": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate$StructureBlockInfo": Internal.ClassInfo, "dev.latvian.mods.kubejs.gui.chest.ChestMenuClickEvent": Internal.ClassInfo, "net.minecraft.client.multiplayer.ServerData$ServerPackStatus": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.NetheriteDoorBlock": Internal.ClassInfo, "net.minecraft.world.entity.EquipmentSlot$Type": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.SackItem": Internal.ClassInfo, "net.minecraft.world.level.block.entity.JigsawBlockEntity$JointType": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.AbyssalArmorItem$Boots": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration$TargetBlockState": Internal.ClassInfo, "java.nio.file.OpenOption": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexFormatElement$Usage": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedTableBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.PancakeItem": Internal.ClassInfo, "java.util.Collections$UnmodifiableMap": Internal.ClassInfo, "net.minecraft.world.inventory.AnvilMenu": Internal.ClassInfo, "java.awt.PrintJob": Internal.ClassInfo, "com.blakebr0.cucumber.crafting.recipe.ShapedTransferNBTRecipe$Serializer": Internal.ClassInfo, "com.buuz135.industrial.block.tile.IndustrialMachineTile": Internal.ClassInfo, "net.minecraft.world.level.block.state.pattern.BlockPattern": Internal.ClassInfo, "net.minecraft.world.level.CollisionGetter": Internal.ClassInfo, "net.minecraft.world.entity.npc.AbstractVillager": Internal.ClassInfo, "vazkii.patchouli.client.book.BookContentsBuilder": Internal.ClassInfo, "java.nio.file.WatchEvent$Kind": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier2Item$Leggings": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.PaintingVariantBuilder": Internal.ClassInfo, "dev.ftb.mods.ftbquests.block.LootCrateOpenerBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.ClientEventJS": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.WitherproofBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.server.tag.TagEventJS": Internal.ClassInfo, "net.liopyu.entityjs.events.BuildBrainEventJS": Internal.ClassInfo, "net.minecraft.world.item.Instrument": Internal.ClassInfo, "letsforge_pirates.item.Skull3Item$Helmet": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.BedPart": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockPickResponseUpgrade": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.FluidLaserBaseTile": Internal.ClassInfo, "com.google.common.collect.ImmutableMap$IteratorBasedImmutableMap": Internal.ClassInfo, "net.minecraft.world.entity.monster.Witch": Internal.ClassInfo, "mezz.jei.api.runtime.IIngredientFilter": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ProtectionEnchantment": Internal.ClassInfo, "net.minecraft.world.item.StandingAndWallBlockItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2ShortFunction": Internal.ClassInfo, "com.talhanation.smallships.world.item.SailItem": Internal.ClassInfo, "net.minecraft.world.item.DyeColor": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier3Item$Boots": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeBakedModel": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier1Item$Chestplate": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundUseItemOnPacket": Internal.ClassInfo, "net.minecraft.client.OptionInstance$CycleableValueSet": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveCounterBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartitioner": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractSkullBlock": Internal.ClassInfo, "net.minecraft.core.dispenser.DefaultDispenseItemBehavior": Internal.ClassInfo, "net.minecraft.world.item.context.UseOnContext": Internal.ClassInfo, "com.buuz135.industrial.item.addon.SpeedAddonItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeConfig": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2FloatFunction": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$HurtContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest": Internal.ClassInfo, "net.minecraft.world.item.crafting.Ingredient$Value": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.SlabBlockBuilder": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.LimbAnimatorAccessor": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier1Item$Chestplate": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.TreeExtractorBoost": Internal.ClassInfo, "net.minecraft.world.level.block.SculkSpreader": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.TwistingVinesConfig": Internal.ClassInfo, "net.minecraft.client.gui.spectator.SpectatorMenuCategory": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.magenta.MagentaStandingSignBlock": Internal.ClassInfo, "net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor": Internal.ClassInfo, "dev.latvian.mods.rhino.util.Remapper": Internal.ClassInfo, "net.minecraft.world.level.biome.Climate$Sampler": Internal.ClassInfo, "net.minecraft.server.packs.repository.PackRepository": Internal.ClassInfo, "net.minecraft.world.entity.animal.SnowGolem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$TwoArgumentSimpleFunction$Type": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.DeltaFeature": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.item.ItemInfinityHammer": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2ReferenceFunction": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetTimePacket": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.DetectorBlock$Builder": Internal.ClassInfo, "cofh.lib.common.inventory.FalseIInventory": Internal.ClassInfo, "net.minecraftforge.registries.IdMappingEvent$ModRemapping": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.NameMap": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgePlayer": Internal.ClassInfo, "java.util.Date": Internal.ClassInfo, "com.blakebr0.cucumber.block.BaseBlock": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier3Item$Boots": Internal.ClassInfo, "java.util.Random": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade": Internal.ClassInfo, "mezz.jei.api.ingredients.IIngredientRenderer": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.FloatSpliterator": Internal.ClassInfo, "cofh.thermal.innovation.common.item.RFMagnetItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.SoundEventBuilder": Internal.ClassInfo, "net.minecraft.world.inventory.ContainerData": Internal.ClassInfo, "java.util.zip.ZipEntry": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.ISlotLimitUpgrade": Internal.ClassInfo, "java.awt.datatransfer.Clipboard": Internal.ClassInfo, "net.minecraft.world.level.pathfinder.BlockPathTypes": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.Property$Value": Internal.ClassInfo, "eutros.framedcompactdrawers.block.BlockTrimCustom": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedDrawerBlock": Internal.ClassInfo, "java.lang.ref.Reference": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer": Internal.ClassInfo, "cofh.thermal.cultivation.common.block.FrostMelonBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.ByteConsumer": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.IBeeGrowable": Internal.ClassInfo, "net.minecraftforge.client.event.ClientChatReceivedEvent": Internal.ClassInfo, "net.minecraft.world.level.LevelAccessor": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2DoubleFunction": Internal.ClassInfo, "net.minecraft.commands.CommandSource": Internal.ClassInfo, "net.minecraft.world.level.GameRules$BooleanValue": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.EntityEventJS": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.RootSystemFeature": Internal.ClassInfo, "org.spongepowered.asm.mixin.injection.callback.Cancellable": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.TrueBlockPredicate": Internal.ClassInfo, "org.lwjgl.stb.STBTTFontinfo$Buffer": Internal.ClassInfo, "cofh.lib.common.item.SignItemCoFH": Internal.ClassInfo, "net.minecraft.util.Unit": Internal.ClassInfo, "java.lang.module.ModuleDescriptor": Internal.ClassInfo, "javax.swing.text.AttributeSet$FontAttribute": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.LuminescentBubbleItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.AbstractIntCollection": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.ItemInventory": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.entries.LootPoolEntry": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.FoodEatenEventJS": Internal.ClassInfo, "net.minecraft.client.resources.PaintingTextureManager": Internal.ClassInfo, "net.minecraft.world.level.block.RailBlock": Internal.ClassInfo, "net.minecraftforge.event.server.ServerStoppingEvent": Internal.ClassInfo, "cofh.thermal.core.common.item.IceChargeItem": Internal.ClassInfo, "net.minecraft.world.level.lighting.LayerLightSectionStorage$SectionType": Internal.ClassInfo, "com.buuz135.industrial.block.generator.tile.PitifulGeneratorTile": Internal.ClassInfo, "com.buuz135.industrial.block.misc.MobDetectorBlock": Internal.ClassInfo, "java.awt.MenuComponent": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseScrolled$Pre": Internal.ClassInfo, "com.google.common.cache.Cache": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithParent": Internal.ClassInfo, "com.mojang.serialization.MapLike": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ShearsItemBuilder": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.RedSprayCanItem": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec": Internal.ClassInfo, "java.util.function.IntBinaryOperator": Internal.ClassInfo, "cofh.core.common.fluid.ExperienceFluid$1": Internal.ClassInfo, "mezz.jei.api.helpers.IColorHelper": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.MysticalFertilizerItem": Internal.ClassInfo, "net.minecraft.world.inventory.MenuConstructor": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherHeadBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryPlankBlock": Internal.ClassInfo, "java.io.DataOutputStream": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.AnimalBabySeparatorTile": Internal.ClassInfo, "dev.latvian.mods.rhino.MemberType": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractBannerBlock": Internal.ClassInfo, "net.minecraft.data.PackOutput$PathProvider": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.BlockBlobFeature": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler": Internal.ClassInfo, "net.minecraft.client.ClientRecipeBook": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig": Internal.ClassInfo, "java.awt.datatransfer.ClipboardOwner": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.entity.BlockEntityInfo": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.black.BlackHangingSignBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.living.MobSpawnEvent$FinalizeSpawn": Internal.ClassInfo, "net.minecraftforge.fml.IExtensionPoint": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.RG2SpeedBlocksRecipe$Serializer": Internal.ClassInfo, "fonnymunkey.simplehats.util.HatEntry$HatDyeSettings": Internal.ClassInfo, "org.joml.Vector4fc": Internal.ClassInfo, "net.minecraft.world.item.ArmorMaterials": Internal.ClassInfo, "net.minecraft.world.level.block.HopperBlock": Internal.ClassInfo, "net.minecraft.util.random.WeightedRandomList": Internal.ClassInfo, "net.minecraft.world.item.BucketItem": Internal.ClassInfo, "com.buuz135.industrial.block.core.LatexProcessingUnitBlock": Internal.ClassInfo, "cofh.thermal.innovation.common.item.RFSawItem": Internal.ClassInfo, "net.minecraft.util.valueproviders.IntProviderType": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.AwakeningRecipe$Serializer": Internal.ClassInfo, "java.util.Collections$SynchronizedMap": Internal.ClassInfo, "net.minecraft.client.multiplayer.ClientSuggestionProvider": Internal.ClassInfo, "com.blamejared.controlling.mixin.AccessInputConstantsKey": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.callbacks.AfterEntityFallenOnBlockCallbackJS": Internal.ClassInfo, "java.text.SimpleDateFormat": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.LogType": Internal.ClassInfo, "com.buuz135.industrial.block.misc.StasisChamberBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.NetherFossilStructure": Internal.ClassInfo, "dev.latvian.mods.kubejs.integration.forge.jei.RemoveJEICategoriesEvent": Internal.ClassInfo, "net.minecraftforge.client.event.RenderGuiOverlayEvent$Pre": Internal.ClassInfo, "java.util.Map$Entry": Internal.ClassInfo, "dev.latvian.mods.kubejs.registry.CustomBuilderObject": Internal.ClassInfo, "mezz.jei.api.recipe.IRecipeLookup": Internal.ClassInfo, "com.google.common.hash.HashCode": Internal.ClassInfo, "com.buuz135.industrial.api.IBlockContainer": Internal.ClassInfo, "net.minecraft.world.item.DiggerItem": Internal.ClassInfo, "io.netty.buffer.ByteBufAllocatorMetric": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.MinecraftEnvironmentKJS": Internal.ClassInfo, "net.minecraftforge.event.server.ServerStoppedEvent": Internal.ClassInfo, "com.leobeliik.extremesoundmuffler.utils.Anchor": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.callbacks.EntitySteppedOnBlockCallbackJS": Internal.ClassInfo, "net.minecraft.world.InteractionHand": Internal.ClassInfo, "java.time.temporal.TemporalAdjuster": Internal.ClassInfo, "net.minecraft.client.resources.model.Material": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.pink.PinkWallHangingSignBlock": Internal.ClassInfo, "net.minecraft.world.item.ExperienceBottleItem": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.IsInWaterSensor": Internal.ClassInfo, "net.minecraft.client.gui.components.toasts.ToastComponent": Internal.ClassInfo, "dev.architectury.registry.registries.Registrar": Internal.ClassInfo, "org.spongepowered.asm.mixin.injection.callback.CallbackInfo": Internal.ClassInfo, "org.joml.Vector4ic": Internal.ClassInfo, "cofh.lib.api.item.IEnergyContainerItem": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.MagentaSprayCanItem": Internal.ClassInfo, "net.minecraft.ChatFormatting": Internal.ClassInfo, "com.mojang.datafixers.kinds.Applicative$Mu": Internal.ClassInfo, "com.supermartijn642.core.data.condition.ResourceCondition": Internal.ClassInfo, "net.minecraft.world.level.block.TorchBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.WritableLevelData": Internal.ClassInfo, "net.minecraft.server.level.ServerBossEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType": Internal.ClassInfo, "net.minecraft.world.level.block.TwistingVinesBlock": Internal.ClassInfo, "net.minecraft.world.level.gameevent.DynamicGameEventListener": Internal.ClassInfo, "java.awt.image.BufferedImage": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.HiveExtractorMapping$Serializer": Internal.ClassInfo, "net.minecraft.world.entity.AreaEffectCloud": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType": Internal.ClassInfo, "net.minecraft.world.level.chunk.ChunkAccess": Internal.ClassInfo, "software.bernie.geckolib.core.animation.Animation$Keyframes": Internal.ClassInfo, "java.awt.SecondaryLoop": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.util.ItemBase": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.neptunium.NeptuniumHoe": Internal.ClassInfo, "java.lang.reflect.Type": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunction": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.BlockLeftClickedEventJS": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootContextUser": Internal.ClassInfo, "net.minecraftforge.event.level.LevelEvent$Load": Internal.ClassInfo, "cofh.core.common.item.CountedItem": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityAnimalContext": Internal.ClassInfo, "com.obscuria.aquamirae.common.blocks.ElodeaBlock": Internal.ClassInfo, "cofh.thermal.core.common.block.LumiumGlassBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.EventExceptionHandler": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.lime.LimeWallHangingSignBlock": Internal.ClassInfo, "com.hrznstudio.titanium.block_network.graph.NetworkGraphScannerResult": Internal.ClassInfo, "net.minecraft.core.Vec3i": Internal.ClassInfo, "net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$Preset": Internal.ClassInfo, "net.minecraft.world.inventory.ItemCombinerMenu": Internal.ClassInfo, "net.minecraft.world.entity.monster.CaveSpider": Internal.ClassInfo, "net.minecraft.server.packs.PackResources": Internal.ClassInfo, "dev.latvian.mods.kubejs.integration.forge.jei.InformationJEIEventJS": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.TerribleArmorItem$Helmet": Internal.ClassInfo, "net.minecraft.world.entity.animal.MushroomCow$MushroomType": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$BooleanValue": Internal.ClassInfo, "net.minecraftforge.forgespi.locating.ForgeFeature$Bound": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier2Item$Chestplate": Internal.ClassInfo, "java.time.Clock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeConfig": Internal.ClassInfo, "java.awt.event.InputMethodListener": Internal.ClassInfo, "com.gitlab.srcmc.powered_flashlight.forge.blocks.LightBlock": Internal.ClassInfo, "java.util.Enumeration": Internal.ClassInfo, "lykrast.glassential.blocks.RedstoneGlassBlock": Internal.ClassInfo, "javax.crypto.ExemptionMechanism": Internal.ClassInfo, "org.joml.Matrix4dc": Internal.ClassInfo, "net.minecraft.world.entity.projectile.WitherSkull": Internal.ClassInfo, "org.joml.Matrix3x2d": Internal.ClassInfo, "org.joml.Matrix3x2f": Internal.ClassInfo, "com.electrolyte.matc.items.InferiumCrystal": Internal.ClassInfo, "letsforge_pirates.item.FishermanItem$Boots": Internal.ClassInfo, "net.liopyu.entityjs.builders.BaseLivingEntityBuilder$IParticleListenerJS": Internal.ClassInfo, "dev.latvian.mods.kubejs.server.tag.TagWrapper": Internal.ClassInfo, "com.google.gson.GsonBuilder": Internal.ClassInfo, "journeymap.client.api.event.forge.FullscreenDisplayEvent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper": Internal.ClassInfo, "org.lwjgl.system.Pointer$Default": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundRotateHeadPacket": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaDeskBlock": Internal.ClassInfo, "net.minecraft.server.packs.resources.PreparableReloadListener": Internal.ClassInfo, "mezz.jei.api.runtime.IScreenHelper": Internal.ClassInfo, "net.minecraft.util.thread.ReentrantBlockableEventLoop": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationController": Internal.ClassInfo, "net.minecraftforge.fml.event.IModBusEvent": Internal.ClassInfo, "javax.accessibility.AccessibleEditableText": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleSpliterator": Internal.ClassInfo, "net.minecraftforge.event.entity.living.BabyEntitySpawnEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.FishingLootEventJS": Internal.ClassInfo, "javax.accessibility.AccessibleRelationSet": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightButtonBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.ShoulderRidingEntity": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$DoubleValue": Internal.ClassInfo, "org.joml.Matrix4fc": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsServer": Internal.ClassInfo, "com.mojang.brigadier.RedirectModifier": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance": Internal.ClassInfo, "net.minecraft.world.entity.monster.piglin.PiglinArmPose": Internal.ClassInfo, "net.minecraftforge.event.BuildCreativeModeTabContentsEvent": Internal.ClassInfo, "cofh.thermal.core.common.item.FluidCellBlockItem": Internal.ClassInfo, "vazkii.patchouli.client.book.gui.GuiBook": Internal.ClassInfo, "com.buuz135.industrial.block.tile.IndustrialWorkingTile": Internal.ClassInfo, "net.minecraftforge.event.OnDatapackSyncEvent": Internal.ClassInfo, "net.minecraft.world.item.InstrumentItem": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSoundPacket": Internal.ClassInfo, "net.minecraftforge.client.event.InputEvent$MouseButton$Pre": Internal.ClassInfo, "net.minecraft.world.entity.Display$BlockDisplay$BlockRenderState": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.OxygeliumItem": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeItemStack": Internal.ClassInfo, "cofh.thermal.core.common.fluid.SapFluid$1": Internal.ClassInfo, "java.util.concurrent.ConcurrentHashMap$KeySetView": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.PiglinSpecificSensor": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.StandingCanvasSignBlock": Internal.ClassInfo, "letsforge_pirates.item.FishermanItem$Helmet": Internal.ClassInfo, "net.minecraft.world.level.SpawnData$CustomSpawnRules": Internal.ClassInfo, "net.minecraft.world.level.levelgen.Aquifer$FluidStatus": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.BiomeFilter": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundEntityEventPacket": Internal.ClassInfo, "com.benbenlaw.strainers.item.custom.Mesh": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType": Internal.ClassInfo, "java.util.EventObject": Internal.ClassInfo, "net.minecraft.client.gui.narration.NarratableEntry": Internal.ClassInfo, "com.buuz135.industrial.api.transporter.TransporterType": Internal.ClassInfo, "net.minecraft.world.item.RecordItem": Internal.ClassInfo, "net.minecraft.world.level.block.entity.JigsawBlockEntity": Internal.ClassInfo, "net.minecraft.client.model.HeadedModel": Internal.ClassInfo, "java.awt.geom.Rectangle2D$Double": Internal.ClassInfo, "com.google.common.collect.ImmutableCollection$Builder": Internal.ClassInfo, "mezz.jei.api.ingredients.IIngredientHelper": Internal.ClassInfo, "de.melanx.skyblockbuilder.world.presets.SkyblockPreset": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.SpruceFoliagePlacer": Internal.ClassInfo, "net.minecraft.world.item.SuspiciousStewItem": Internal.ClassInfo, "com.hrznstudio.titanium.api.filter.FilterAction": Internal.ClassInfo, "java.util.jar.Attributes": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket": Internal.ClassInfo, "net.minecraftforge.common.util.NonNullFunction": Internal.ClassInfo, "net.minecraft.client.model.geom.ModelPart$Visitor": Internal.ClassInfo, "net.liopyu.entityjs.util.implementation.EventBasedSpawnModifier$BiomeSpawn": Internal.ClassInfo, "net.minecraft.util.thread.ProcessorHandle": Internal.ClassInfo, "net.minecraft.world.inventory.CartographyTableMenu": Internal.ClassInfo, "squeek.appleskin.api.event.HUDOverlayEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.RecipeKJS": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BlockEntityTicker": Internal.ClassInfo, "com.hrznstudio.titanium.network.locator.PlayerInventoryFinder": Internal.ClassInfo, "cofh.lib.common.block.RubberBlock": Internal.ClassInfo, "java.lang.constant.MethodTypeDesc": Internal.ClassInfo, "com.mojang.datafixers.Typed": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.request.AbuseReportRequest$ClientInfo": Internal.ClassInfo, "net.mcreator.cozyhome.block.LargeMangroveStumpBlock": Internal.ClassInfo, "net.minecraft.world.item.BannerItem": Internal.ClassInfo, "net.minecraft.world.entity.animal.IronGolem$Crackiness": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.ShepherdsPieBlock": Internal.ClassInfo, "com.google.gson.JsonPrimitive": Internal.ClassInfo, "com.mojang.authlib.minecraft.report.AbuseReportLimits": Internal.ClassInfo, "net.minecraft.world.level.DataPackConfig": Internal.ClassInfo, "java.time.Month": Internal.ClassInfo, "org.joml.Vector4dc": Internal.ClassInfo, "net.minecraft.world.level.block.DropExperienceBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket$ChunkBiomeData": Internal.ClassInfo, "java.net.ContentHandler": Internal.ClassInfo, "java.awt.event.ContainerListener": Internal.ClassInfo, "net.minecraft.world.level.chunk.PalettedContainer$Configuration": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SackBlock": Internal.ClassInfo, "net.minecraft.world.level.block.SugarCaneBlock": Internal.ClassInfo, "cofh.core.common.item.IMultiModeItem": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.Button": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blending.BlendingData": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.BlockPlacedEventJS": Internal.ClassInfo, "java.util.function.BooleanSupplier": Internal.ClassInfo, "com.mojang.authlib.minecraft.report.ReportedEntity": Internal.ClassInfo, "java.lang.Character": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$EntityMultiPlaceEvent": Internal.ClassInfo, "net.minecraft.client.gui.ComponentPath": Internal.ClassInfo, "cofh.core.common.fluid.PotionFluid$1": Internal.ClassInfo, "net.minecraft.world.item.UseAnim": Internal.ClassInfo, "net.minecraft.client.model.AgeableListModel": Internal.ClassInfo, "com.google.common.collect.BaseImmutableMultimap": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.callbacks.BlockStateRotateCallbackJS": Internal.ClassInfo, "chiefarug.mods.systeams.SteamFluid$SteamFlowingFluid": Internal.ClassInfo, "net.minecraft.client.renderer.texture.TextureAtlasSprite$Ticker": Internal.ClassInfo, "letsforge_pirates.item.Skull2Item": Internal.ClassInfo, "com.mojang.authlib.BaseAuthenticationService": Internal.ClassInfo, "net.minecraft.world.Nameable": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeConfig": Internal.ClassInfo, "dev.ftb.mods.ftbquests.block.entity.TaskScreenAuxBlockEntity": Internal.ClassInfo, "net.minecraft.world.item.enchantment.UntouchingEnchantment": Internal.ClassInfo, "vazkii.patchouli.client.book.AbstractReadStateHolder": Internal.ClassInfo, "io.netty.util.Constant": Internal.ClassInfo, "com.probejs.jdoc.property.PropertyComment": Internal.ClassInfo, "de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinOptions": Internal.ClassInfo, "net.minecraft.world.level.block.WeatheringCopperSlabBlock": Internal.ClassInfo, "java.lang.invoke.TypeDescriptor$OfField": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.forge.ShulkerShellItem": Internal.ClassInfo, "net.minecraft.world.entity.ai.village.poi.PoiRecord": Internal.ClassInfo, "java.awt.AWTKeyStroke": Internal.ClassInfo, "cofh.lib.api.IDetonatable": Internal.ClassInfo, "net.minecraft.core.BlockPos$MutableBlockPos": Internal.ClassInfo, "com.cazsius.solcarrot.item.FoodBookItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$Marker": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.BasicMobEffect$Builder": Internal.ClassInfo, "dev.latvian.mods.unit.token.UnitToken": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ThrownTrident": Internal.ClassInfo, "net.minecraft.world.item.enchantment.FireAspectEnchantment": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.BlockElementRotation": Internal.ClassInfo, "com.mojang.blaze3d.platform.NativeImage$Format": Internal.ClassInfo, "io.netty.channel.Channel": Internal.ClassInfo, "net.minecraft.world.level.chunk.ChunkStatus": Internal.ClassInfo, "net.minecraft.world.item.enchantment.OxygenEnchantment": Internal.ClassInfo, "cofh.core.common.item.FluidContainerItem": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.ValidationContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.CocoaDecorator": Internal.ClassInfo, "java.net.SocketAddress": Internal.ClassInfo, "org.moddingx.libx.mod.ModX": Internal.ClassInfo, "net.minecraftforge.fluids.capability.templates.FluidTank": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.ComparatorMode": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier1Item$Chestplate": Internal.ClassInfo, "net.minecraft.server.packs.VanillaPackResources": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.AutomationDirection": Internal.ClassInfo, "net.minecraft.world.item.EndCrystalItem": Internal.ClassInfo, "com.mojang.brigadier.arguments.FloatArgumentType": Internal.ClassInfo, "net.mcreator.cozyhome.block.LightGrayLampBlock": Internal.ClassInfo, "net.minecraft.world.effect.AbsoptionMobEffect": Internal.ClassInfo, "net.minecraft.world.level.block.state.StateDefinition": Internal.ClassInfo, "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.QuestObjectStartedEventJS": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundStopSoundPacket": Internal.ClassInfo, "com.buuz135.industrialforegoingsouls.block.SoulPipeBlock": Internal.ClassInfo, "net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$CompiledChunk": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier3Item$Helmet": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.weapon.CoralLanceItem": Internal.ClassInfo, "net.minecraft.world.level.block.PowderSnowCauldronBlock": Internal.ClassInfo, "net.minecraft.util.valueproviders.ClampedNormalInt": Internal.ClassInfo, "java.net.InetSocketAddress": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$BeardifierOrMarker": Internal.ClassInfo, "net.minecraft.world.level.block.Blocks": Internal.ClassInfo, "net.minecraft.world.entity.animal.IronGolem": Internal.ClassInfo, "net.minecraft.server.packs.PackResources$ResourceOutput": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.AbyssalArmorExtraItem$Tiara": Internal.ClassInfo, "java.lang.invoke.VarHandle$AccessMode": Internal.ClassInfo, "net.minecraft.world.level.block.MyceliumBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.AbstractChestedHorse": Internal.ClassInfo, "net.minecraft.server.packs.resources.ResourceMetadata": Internal.ClassInfo, "java.awt.image.DataBuffer": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2ShortFunction": Internal.ClassInfo, "com.mojang.datafixers.View": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.WaterloggedVegetationPatchFeature": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.AnimalFeederBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakMirrorBlock": Internal.ClassInfo, "com.benbenlaw.roomopolis.item.custom.RoomKeys.NormalRoomKey": Internal.ClassInfo, "net.minecraftforge.registries.IForgeRegistry$MissingFactory": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.BlockItemBuilder": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongIterator": Internal.ClassInfo, "com.hrznstudio.titanium.component.progress.ProgressBarComponent$BarDirection": Internal.ClassInfo, "net.minecraftforge.event.entity.living.EnderManAngerEvent": Internal.ClassInfo, "net.minecraftforge.event.level.ChunkWatchEvent": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.SharpBonesItem": Internal.ClassInfo, "net.minecraft.advancements.Advancement": Internal.ClassInfo, "top.theillusivec4.curios.mixin.core.AccessorEntity": Internal.ClassInfo, "net.minecraft.commands.arguments.selector.EntitySelector": Internal.ClassInfo, "java.security.PermissionCollection": Internal.ClassInfo, "com.hrznstudio.titanium.api.filter.FilterSlot": Internal.ClassInfo, "java.util.stream.LongStream$Builder": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonStorageCounterBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.Pufferfish": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo$DisplayItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.DetectorBlockEventJS": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightLeavesBlock": Internal.ClassInfo, "chiefarug.mods.systeams.recipe.UpgradeShapelessRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.level.block.DirtPathBlock": Internal.ClassInfo, "net.minecraft.world.level.biome.Climate$TargetPoint": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2FloatFunction": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.filter.FilterUpgradeItem": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType": Internal.ClassInfo, "net.liopyu.entityjs.builders.BaseLivingEntityBuilder$AnimationEventJS": Internal.ClassInfo, "java.lang.ThreadGroup": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BannerBlockEntity": Internal.ClassInfo, "net.minecraft.client.gui.spectator.SpectatorMenuItem": Internal.ClassInfo, "java.time.temporal.ValueRange": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.RootSystemConfiguration": Internal.ClassInfo, "java.awt.event.MouseWheelEvent": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityTeleportEvent$EnderEntity": Internal.ClassInfo, "com.mojang.datafixers.types.families.Algebra": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeVertexConsumer": Internal.ClassInfo, "com.hrznstudio.titanium.component.IComponentHandler": Internal.ClassInfo, "java.awt.GraphicsConfiguration": Internal.ClassInfo, "net.minecraft.client.model.ShieldModel": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FlowingFluidBuilder": Internal.ClassInfo, "net.minecraft.world.item.FlintAndSteelItem": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland": Internal.ClassInfo, "java.util.function.ObjDoubleConsumer": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaPurpleBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ComponentKJS": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeBoat": Internal.ClassInfo, "java.util.Spliterator$OfInt": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ReferenceFunction": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity": Internal.ClassInfo, "net.minecraft.client.gui.components.BossHealthOverlay": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$CropGrowEvent": Internal.ClassInfo, "net.liopyu.entityjs.builders.BaseLivingEntityBuilder$ParticleKeyFrameEventJS": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.NumberComponent$FloatRange": Internal.ClassInfo, "net.minecraft.world.level.block.NyliumBlock": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.PotionDiffuserBoost$Serializer": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.response.KeyPairResponse": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.tiles.SafeBlockTile": Internal.ClassInfo, "net.minecraft.world.entity.animal.TropicalFish$Variant": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket": Internal.ClassInfo, "net.minecraft.CrashReportCategory": Internal.ClassInfo, "net.minecraft.world.level.biome.Biome": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.events.forge.VillagerBrainEvent": Internal.ClassInfo, "dev.ftb.mods.ftbquests.item.LootCrateItem": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent": Internal.ClassInfo, "tamaized.melongolem.ISignHolder": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeWrapper": Internal.ClassInfo, "net.minecraft.world.scores.ScoreboardSaveData": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockStateMatchTest": Internal.ClassInfo, "com.google.common.collect.ImmutableMultimap": Internal.ClassInfo, "java.util.function.IntFunction": Internal.ClassInfo, "net.minecraft.advancements.AdvancementRewards": Internal.ClassInfo, "com.mojang.serialization.codecs.PrimitiveCodec": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.LootBoxItem": Internal.ClassInfo, "net.minecraft.world.inventory.HopperMenu": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.neptunium.NeptuniumShovel": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor$Factory": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.reward.RewardClaimType": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.PinkSprayCanItem": Internal.ClassInfo, "dev.architectury.event.events.client.ClientCommandRegistrationEvent$ClientCommandSourceStack": Internal.ClassInfo, "com.supermartijn642.core.mixin.BlockPropertiesAccessor": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingDeathEvent": Internal.ClassInfo, "java.awt.GraphicsConfigTemplate": Internal.ClassInfo, "com.supermartijn642.core.data.condition.ResourceConditionContext": Internal.ClassInfo, "net.minecraft.nbt.LongArrayTag": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.CabbageBlock": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.IntegerArgumentInfo$Template": Internal.ClassInfo, "net.liopyu.entityjs.builders.BaseLivingEntityBuilder$IAnimationPredicateJS": Internal.ClassInfo, "com.obscuria.obscureapi.api.common.classes.ObscureType": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryPropertyMap": Internal.ClassInfo, "net.minecraftforge.event.entity.player.AdvancementEvent$AdvancementEarnEvent": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket": Internal.ClassInfo, "net.minecraft.network.protocol.BundlerInfo$Bundler": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.SmithingTemplateItemBuilder": Internal.ClassInfo, "net.minecraft.core.HolderOwner": Internal.ClassInfo, "net.minecraft.world.level.block.state.pattern.BlockInWorld": Internal.ClassInfo, "com.supermartijn642.fusion.api.model.ModelBakingContext": Internal.ClassInfo, "cofh.lib.api.item.IInventoryContainerItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.special.ShapedKubeJSRecipe$SerializerKJS": Internal.ClassInfo, "net.minecraft.world.item.BannerPatternItem": Internal.ClassInfo, "net.minecraft.client.gui.components.SplashRenderer": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.ReprocessorRecipe": Internal.ClassInfo, "net.minecraftforge.client.event.ContainerScreenEvent$Render": Internal.ClassInfo, "net.minecraft.world.entity.animal.Pig": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.WidgetLayout$Horizontal": Internal.ClassInfo, "java.util.TimeZone": Internal.ClassInfo, "java.util.Collection": Internal.ClassInfo, "net.minecraft.network.chat.MessageSignature": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2DoubleFunction": Internal.ClassInfo, "io.netty.channel.nio.NioEventLoopGroup": Internal.ClassInfo, "io.netty.buffer.PoolArenaMetric": Internal.ClassInfo, "net.minecraft.world.entity.player.Player": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.brown.BrownStandingSignBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2DoubleFunction": Internal.ClassInfo, "net.minecraft.commands.Commands$CommandSelection": Internal.ClassInfo, "java.util.Queue": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.BasicBlockJS": Internal.ClassInfo, "net.minecraft.server.RegistryLayer": Internal.ClassInfo, "net.minecraft.world.item.enchantment.TridentRiptideEnchantment": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2IntMap": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.SimpleRandomSelectorFeature": Internal.ClassInfo, "net.minecraft.world.level.EntityGetter": Internal.ClassInfo, "com.electronwill.nightconfig.core.file.CommentedFileConfig": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.TreeFeature": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundResourcePackPacket": Internal.ClassInfo, "net.minecraft.world.item.CreativeModeTab$Builder": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.RecipeSchemaRegistryEventJS": Internal.ClassInfo, "net.minecraft.world.level.material.PushReaction": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crop.CropTextures": Internal.ClassInfo, "software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache": Internal.ClassInfo, "net.minecraft.world.entity.decoration.ArmorStand": Internal.ClassInfo, "net.minecraft.world.entity.npc.VillagerType": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.parameters.LootContextParamSet": Internal.ClassInfo, "cofh.core.common.effect.ChilledMobEffect": Internal.ClassInfo, "net.minecraft.world.entity.animal.FrogVariant": Internal.ClassInfo, "net.minecraft.world.item.crafting.CraftingRecipe": Internal.ClassInfo, "net.minecraft.world.level.block.BaseCoralWallFanBlock": Internal.ClassInfo, "net.minecraft.client.renderer.Rect2i": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterShadersEvent": Internal.ClassInfo, "net.minecraft.client.renderer.DimensionSpecialEffects": Internal.ClassInfo, "journeymap.client.api.event.forge.PopupMenuEvent": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.CandyItem": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.meta.BlockMeta": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$PlayerChangedDimensionEvent": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier1Item$Boots": Internal.ClassInfo, "dev.latvian.mods.rhino.util.ValueUnwrapper": Internal.ClassInfo, "net.minecraft.world.item.MinecartItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2FloatFunction": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.WhiteSprayCanItem": Internal.ClassInfo, "dev.latvian.mods.unit.function.FunctionFactory$Arg3": Internal.ClassInfo, "net.minecraft.client.multiplayer.ClientAdvancements": Internal.ClassInfo, "net.minecraft.network.protocol.status.ServerStatus$Favicon": Internal.ClassInfo, "net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.LaserDrillBlock": Internal.ClassInfo, "java.net.InetAddress": Internal.ClassInfo, "com.google.common.collect.RegularImmutableList": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2BooleanFunction": Internal.ClassInfo, "dev.architectury.event.EventActor": Internal.ClassInfo, "dev.ftb.mods.ftbteams.api.property.TeamProperty": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.AbyssalArmorItem$Brigantine": Internal.ClassInfo, "net.minecraftforge.fml.config.IConfigEvent": Internal.ClassInfo, "org.apache.maven.artifact.metadata.ArtifactMetadata": Internal.ClassInfo, "java.awt.dnd.DropTargetDropEvent": Internal.ClassInfo, "dev.latvian.mods.unit.function.FunctionFactory$Arg1": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.fluids.SoftFluid$Builder": Internal.ClassInfo, "dev.latvian.mods.unit.function.FunctionFactory$Arg2": Internal.ClassInfo, "mezz.jei.api.gui.builder.IIngredientAcceptor": Internal.ClassInfo, "com.buuz135.industrial.block.generator.tile.BiofuelGeneratorTile": Internal.ClassInfo, "net.minecraft.world.level.block.SculkBehaviour": Internal.ClassInfo, "cofh.thermal.lib.util.recipes.ThermalFuel": Internal.ClassInfo, "net.minecraft.world.inventory.BeaconMenu": Internal.ClassInfo, "java.awt.font.LineMetrics": Internal.ClassInfo, "com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.ModFilterItem": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.white.WhiteWallHangingSignBlock": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.TatamiBlock": Internal.ClassInfo, "java.io.FilterOutputStream": Internal.ClassInfo, "org.moddingx.libx.registration.RegistrationContext": Internal.ClassInfo, "net.minecraft.client.gui.spectator.SpectatorMenu": Internal.ClassInfo, "org.joml.Vector3dc": Internal.ClassInfo, "net.minecraft.world.item.crafting.BannerDuplicateRecipe": Internal.ClassInfo, "net.minecraft.world.level.biome.MobSpawnSettings$Builder": Internal.ClassInfo, "eutros.framedcompactdrawers.block.BlockDrawersStandardCustom": Internal.ClassInfo, "net.liopyu.entityjs.item.ProjectileItemBuilder": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.RecipeComponentBuilderMap": Internal.ClassInfo, "com.google.common.collect.ImmutableSet$Builder": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeResolver": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.BlockTypeBasedItem": Internal.ClassInfo, "com.google.common.collect.ImmutableSet$CachingAsList": Internal.ClassInfo, "io.netty.util.concurrent.ProgressiveFuture": Internal.ClassInfo, "com.buuz135.industrial.api.conveyor.ConveyorUpgrade": Internal.ClassInfo, "dev.latvian.mods.kubejs.registry.RegistryCallback": Internal.ClassInfo, "net.minecraftforge.client.event.CustomizeGuiOverlayEvent$DebugText": Internal.ClassInfo, "java.awt.BufferCapabilities": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.BubbleBlockItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.HugeFungusFeature": Internal.ClassInfo, "com.google.common.reflect.TypeToken$TypeSet": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.pink.PinkStandingSignBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.VillagerHostilesSensor": Internal.ClassInfo, "java.io.DataOutput": Internal.ClassInfo, "net.minecraft.world.entity.monster.Illusioner": Internal.ClassInfo, "net.minecraft.world.scores.PlayerTeam": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.ChorusPlantFeature": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.RiceItem": Internal.ClassInfo, "java.awt.PageAttributes$MediaType": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.BlockAgeProcessor": Internal.ClassInfo, "com.mojang.datafixers.util.Pair": Internal.ClassInfo, "net.minecraft.world.entity.ai.village.poi.PoiManager$Occupancy": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.DripstoneClusterFeature": Internal.ClassInfo, "dev.architectury.hooks.level.biome.SpawnProperties": Internal.ClassInfo, "org.joml.Vector3fc": Internal.ClassInfo, "net.minecraft.world.item.enchantment.SweepingEdgeEnchantment": Internal.ClassInfo, "net.minecraftforge.event.entity.living.MobEffectEvent": Internal.ClassInfo, "net.liopyu.entityjs.events.AddGoalTargetsEventJS": Internal.ClassInfo, "net.minecraft.world.level.block.PowderSnowBlock": Internal.ClassInfo, "net.minecraft.commands.synchronization.SingletonArgumentInfo": Internal.ClassInfo, "com.buuz135.industrial.block.misc.tile.StasisChamberTile": Internal.ClassInfo, "net.minecraft.world.level.block.WetSpongeBlock": Internal.ClassInfo, "net.minecraft.world.inventory.CraftingMenu": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.CountConfiguration": Internal.ClassInfo, "net.minecraft.util.random.WeightedEntry$IntrusiveBase": Internal.ClassInfo, "net.minecraft.nbt.StringTag": Internal.ClassInfo, "net.minecraft.client.gui.components.events.AbstractContainerEventHandler": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedBenchBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.allay.Allay": Internal.ClassInfo, "dev.architectury.registry.level.biome.BiomeModifications$BiomeContext": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket": Internal.ClassInfo, "net.minecraftforge.client.event.RenderLevelStageEvent": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.integration.FarmersDelightCompat$PlanterRichBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.FireworkStarFadeRecipe": Internal.ClassInfo, "net.minecraft.client.DebugQueryHandler": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModLanguageProvider$IModLanguageLoader": Internal.ClassInfo, "net.minecraft.world.item.crafting.SuspiciousStewRecipe": Internal.ClassInfo, "net.minecraft.world.inventory.DataSlot": Internal.ClassInfo, "dev.latvian.mods.kubejs.typings.desc.ObjectDescJS$Entry": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.PointedDripstoneConfiguration": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$CropGrowEvent$Pre": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerXpEvent$PickupXp": Internal.ClassInfo, "net.minecraft.world.level.pathfinder.PathComputationType": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.DoormatBlock": Internal.ClassInfo, "net.liopyu.entityjs.util.ai.Behaviors": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.SafeItem": Internal.ClassInfo, "net.minecraft.world.entity.monster.AbstractIllager$IllagerArmPose": Internal.ClassInfo, "io.netty.util.concurrent.MultithreadEventExecutorGroup": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleStorageCounterBlock": Internal.ClassInfo, "mezz.jei.api.runtime.IJeiRuntime": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeItem": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.StairsShape": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$TexturingStateShard": Internal.ClassInfo, "net.minecraft.world.item.ArmorMaterial": Internal.ClassInfo, "org.joml.Vector3ic": Internal.ClassInfo, "net.minecraft.client.Minecraft": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.MultipartShapedBlockBuilder": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryEventType$Builder": Internal.ClassInfo, "cofh.lib.common.fluid.FluidIngredient": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.painter.Painter": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier1Item": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.IOnePlayerGui": Internal.ClassInfo, "mezz.jei.api.helpers.IModIdHelper": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.LivingEntityDeathEventJS": Internal.ClassInfo, "mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback": Internal.ClassInfo, "com.mojang.blaze3d.audio.Channel": Internal.ClassInfo, "com.obscuria.obscureapi.api.common.classes.Bonus$Builder": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$SaveToFile": Internal.ClassInfo, "software.bernie.geckolib.network.SerializableDataTicket": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategory": Internal.ClassInfo, "net.minecraftforge.forgespi.locating.IModFile": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2CharFunction": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.EssenceItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.SurfaceRules$Context": Internal.ClassInfo, "java.util.ImmutableCollections$AbstractImmutableMap": Internal.ClassInfo, "net.minecraft.world.level.chunk.PalettedContainerRO$PackedData": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$Supremium": Internal.ClassInfo, "net.minecraft.world.entity.monster.Zombie": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe": Internal.ClassInfo, "net.minecraft.world.level.block.LadderBlock": Internal.ClassInfo, "com.obscuria.obscureapi.api.common.classes.Ability$Style": Internal.ClassInfo, "com.obscuria.obscureapi.common.effects.Knowledge": Internal.ClassInfo, "dev.latvian.mods.rhino.ConstProperties": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.crafting.UpgradeNextTierRecipe": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgePoseStack": Internal.ClassInfo, "net.minecraft.world.item.enchantment.Enchantment$Rarity": Internal.ClassInfo, "com.hrznstudio.titanium.block.RotationHandler": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.type.CustomDecorationType": Internal.ClassInfo, "com.hrznstudio.titanium.fluid.TitaniumFluidInstance$1": Internal.ClassInfo, "com.hrznstudio.titanium.recipe.serializer.GenericSerializer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.VerticalAnchor$BelowTop": Internal.ClassInfo, "com.google.gson.internal.Excluder": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedMirrorBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.Markings": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey": Internal.ClassInfo, "com.blakebr0.cucumber.block.BaseTileEntityBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.synth.NormalNoise$NoiseParameters": Internal.ClassInfo, "net.minecraft.core.HolderGetter": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoublePredicate": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.ConsumableItem": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.item.ItemInfinityLauncher$PlungerAction": Internal.ClassInfo, "net.minecraftforge.common.crafting.ConditionalRecipe$Serializer": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.purple.PurpleWallSignBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.DummySensor": Internal.ClassInfo, "net.minecraft.client.multiplayer.ServerData": Internal.ClassInfo, "net.minecraft.world.food.FoodProperties": Internal.ClassInfo, "net.minecraft.world.level.block.CauldronBlock": Internal.ClassInfo, "net.minecraft.network.chat.ChatType$Bound": Internal.ClassInfo, "java.util.function.ToIntFunction": Internal.ClassInfo, "com.mojang.blaze3d.shaders.BlendMode": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.loot.RewardTable": Internal.ClassInfo, "net.minecraft.client.gui.components.LerpingBossEvent": Internal.ClassInfo, "com.blamejared.clumps.helper.IClumpedOrb": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.LakeFeature$Configuration": Internal.ClassInfo, "net.minecraft.world.level.block.ConduitBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObject2ByteSortedMap": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.minecraft.ShapedRecipeSchema$ShapedRecipeJS": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$BlockToolModificationEvent": Internal.ClassInfo, "net.minecraft.world.damagesource.DamageSources": Internal.ClassInfo, "com.buuz135.industrial.block.misc.tile.MobDetectorTile": Internal.ClassInfo, "io.netty.buffer.ByteBufAllocator": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.ORFilterItem": Internal.ClassInfo, "net.minecraft.data.recipes.RecipeBuilder": Internal.ClassInfo, "net.liopyu.entityjs.builders.ProjectileEntityBuilder": Internal.ClassInfo, "net.minecraft.world.entity.npc.Villager": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2IntFunction": Internal.ClassInfo, "java.awt.Window$Type": Internal.ClassInfo, "top.theillusivec4.curios.api.type.capability.ICurio$DropRule": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.InfusionCrystalItem": Internal.ClassInfo, "net.minecraft.world.level.block.CandleCakeBlock": Internal.ClassInfo, "com.mojang.datafixers.DSL$TypeReference": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampChurchFeature": Internal.ClassInfo, "com.gitlab.srcmc.powered_flashlight.items.AbstractFlashlightItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade": Internal.ClassInfo, "net.minecraft.commands.CommandBuildContext$MissingTagAccessPolicy": Internal.ClassInfo, "javax.swing.text.StyleConstants$CharacterConstants": Internal.ClassInfo, "net.minecraft.world.entity.animal.Fox$Type": Internal.ClassInfo, "letsforge_pirates.item.PoisonBoneCutlassItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.FloatPredicate": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.gray.GrayWallSignBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.RecipeManager$CachedCheck": Internal.ClassInfo, "java.lang.module.ModuleDescriptor$Exports": Internal.ClassInfo, "java.awt.event.InputEvent": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.platform.RegHelper$1": Internal.ClassInfo, "dev.latvian.mods.unit.UnitContext": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.StringComponent": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.Llama": Internal.ClassInfo, "com.supermartijn642.fusion.api.util.Pair": Internal.ClassInfo, "net.minecraftforge.client.event.RenderTooltipEvent": Internal.ClassInfo, "com.buuz135.industrialforegoingsouls.block.SoulSurgeBlock": Internal.ClassInfo, "net.minecraft.world.level.block.entity.TickingBlockEntity": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.black.BlackWallHangingSignBlock": Internal.ClassInfo, "org.lwjgl.system.Pointer": Internal.ClassInfo, "com.mojang.math.OctahedralGroup": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssenceHoeItem": Internal.ClassInfo, "net.minecraft.nbt.FloatTag": Internal.ClassInfo, "com.mojang.blaze3d.shaders.Program": Internal.ClassInfo, "java.lang.AbstractStringBuilder": Internal.ClassInfo, "com.buuz135.industrial.api.conveyor.gui.IGuiComponent": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$ItemSmeltedEvent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem$StashResult": Internal.ClassInfo, "cofh.lib.common.block.CrossoverRailBlock": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$ArrowLivingEntityContext": Internal.ClassInfo, "com.hrznstudio.titanium.component.sideness.IFacingComponent$FaceMode": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.StructureMode": Internal.ClassInfo, "net.minecraftforge.common.IPlantable": Internal.ClassInfo, "cofh.lib.api.block.IWrenchable": Internal.ClassInfo, "net.minecraft.network.chat.SignedMessageValidator": Internal.ClassInfo, "net.minecraft.world.level.block.CommandBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket": Internal.ClassInfo, "java.util.BitSet": Internal.ClassInfo, "net.minecraft.client.renderer.chunk.ChunkRenderDispatcher": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ThrowableItemProjectile": Internal.ClassInfo, "dev.ftb.mods.ftbteams.data.TeamArgument": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertWellFeature": Internal.ClassInfo, "journeymap.client.api.display.Context$MapType": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.entity.BlockEntityCallback": Internal.ClassInfo, "mezz.jei.api.runtime.IJeiKeyMapping": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundResourcePackPacket$Action": Internal.ClassInfo, "net.minecraft.client.searchtree.SearchRegistry$Key": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeMinecraft": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SoapBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.navigation.PathNavigation": Internal.ClassInfo, "net.minecraftforge.eventbus.api.EventPriority": Internal.ClassInfo, "net.minecraft.world.level.LightLayer": Internal.ClassInfo, "net.minecraft.world.item.crafting.FireworkRocketRecipe": Internal.ClassInfo, "net.minecraft.server.TickTask": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.RG2SpeedBlocksRecipe": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.Horse": Internal.ClassInfo, "net.minecraft.client.renderer.texture.SpriteContents": Internal.ClassInfo, "net.mcreator.cozyhome.block.LargeCrimsonFungusBlock": Internal.ClassInfo, "dev.latvian.mods.rhino.util.CustomJavaToJsWrapper": Internal.ClassInfo, "net.minecraft.world.item.enchantment.SwiftSneakEnchantment": Internal.ClassInfo, "net.minecraft.world.level.levelgen.LegacyRandomSource": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssenceSwordItem": Internal.ClassInfo, "vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab": Internal.ClassInfo, "letsforge_pirates.item.Merchant3Item$Boots": Internal.ClassInfo, "mezz.jei.api.helpers.IJeiHelpers": Internal.ClassInfo, "net.minecraft.world.entity.Display": Internal.ClassInfo, "software.bernie.geckolib.core.state.BoneSnapshot": Internal.ClassInfo, "net.minecraft.world.level.SignalGetter": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.FoodBuilder": Internal.ClassInfo, "com.mojang.brigadier.arguments.IntegerArgumentType": Internal.ClassInfo, "net.minecraft.world.item.Rarity": Internal.ClassInfo, "net.minecraft.world.level.biome.Climate$ParameterList": Internal.ClassInfo, "dev.architectury.event.events.common.ChatEvent$ChatComponent": Internal.ClassInfo, "net.minecraft.util.profiling.ProfileResults": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.CarvingContext": Internal.ClassInfo, "net.minecraft.world.level.block.CandleBlock": Internal.ClassInfo, "com.mojang.serialization.ListBuilder": Internal.ClassInfo, "net.liopyu.entityjs.entities.ProjectileEntityJS": Internal.ClassInfo, "net.minecraft.world.level.block.LightBlock": Internal.ClassInfo, "cofh.thermal.lib.common.block.DynamoBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2ByteFunction": Internal.ClassInfo, "com.mojang.brigadier.tree.ArgumentCommandNode": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2LongFunction": Internal.ClassInfo, "java.util.ResourceBundle": Internal.ClassInfo, "net.minecraft.world.entity.monster.Stray": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.ProgressionMode": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientActionFilter": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.ServicesKeyType": Internal.ClassInfo, "letsforge_pirates.item.Skull1Item$Helmet": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.fluids.SoftFluid$TintMethod": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.SlaughterFactoryTile": Internal.ClassInfo, "java.util.stream.LongStream": Internal.ClassInfo, "java.util.Properties": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonSittingPhase": Internal.ClassInfo, "io.netty.util.ByteProcessor": Internal.ClassInfo, "net.minecraft.world.level.block.SculkCatalystBlock": Internal.ClassInfo, "com.leobeliik.extremesoundmuffler.interfaces.ISoundLists": Internal.ClassInfo, "dev.ftb.mods.ftbquests.block.DetectorBlock": Internal.ClassInfo, "net.minecraft.network.syncher.SynchedEntityData": Internal.ClassInfo, "java.time.temporal.ChronoUnit": Internal.ClassInfo, "net.minecraftforge.event.TickEvent$RenderTickEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.EventJS": Internal.ClassInfo, "com.jtorleonstudios.libraryferret.blocks.UnbreakableBeacon": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.MysticalCropBlock": Internal.ClassInfo, "net.minecraft.world.entity.monster.ElderGuardian": Internal.ClassInfo, "dev.latvian.mods.rhino.util.SpecialEquality": Internal.ClassInfo, "net.darkhax.bookshelf.impl.data.recipes.crafting.ShapelessDurabilityRecipe$Serializer": Internal.ClassInfo, "dev.architectury.core.fluid.ArchitecturyFlowingFluid$Flowing": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemBuilder$ReleaseUsingCallback": Internal.ClassInfo, "java.nio.file.WatchKey": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ServerPlayerKJS": Internal.ClassInfo, "mezz.jei.api.runtime.IIngredientManager": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingAttackEvent": Internal.ClassInfo, "net.minecraft.network.protocol.status.ServerStatus": Internal.ClassInfo, "mezz.jei.api.recipe.IRecipeCategoriesLookup": Internal.ClassInfo, "java.nio.file.attribute.FileAttributeView": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunction$FunctionContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.NopProcessor": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.IThirdPersonSpecialItemRenderer": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.RandomTickCallbackJS": Internal.ClassInfo, "cofh.core.util.filter.IFilterableItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemModificationEventJS": Internal.ClassInfo, "java.awt.Dimension": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.FuelBlockItem": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.purple.PurpleStandingSignBlock": Internal.ClassInfo, "java.util.SortedMap": Internal.ClassInfo, "dev.ftb.mods.ftbquests.api.QuestFile": Internal.ClassInfo, "net.minecraft.world.level.block.StainedGlassPaneBlock": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.events.forge.FireConsumeBlockEvent": Internal.ClassInfo, "java.awt.PageAttributes$PrintQualityType": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongList": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2ObjectFunction": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleBenchBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssenceBowItem": Internal.ClassInfo, "java.util.concurrent.atomic.AtomicReference": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.SerializerType": Internal.ClassInfo, "net.minecraft.client.renderer.block.BlockRenderDispatcher": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.BlueIceFeature": Internal.ClassInfo, "dev.latvian.mods.kubejs.integration.forge.jei.JEISubtypesEventJS": Internal.ClassInfo, "net.minecraft.world.level.ClipContext": Internal.ClassInfo, "net.minecraft.world.level.border.WorldBorder": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.item.ItemInfinityBackpack": Internal.ClassInfo, "net.minecraft.world.level.levelgen.heightproviders.TrapezoidHeight": Internal.ClassInfo, "dev.architectury.utils.Env": Internal.ClassInfo, "net.mcreator.cozyhome.block.BambooGrandfatherClockBlock": Internal.ClassInfo, "net.minecraft.client.gui.screens.recipebook.RecipeCollection": Internal.ClassInfo, "java.io.OutputStream": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.CookingPotBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakTableBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.LargeSpruceStumpBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.RailShape": Internal.ClassInfo, "cofh.thermal.core.common.fluid.LatexFluid$1": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade": Internal.ClassInfo, "net.minecraft.world.entity.Display$ItemDisplay": Internal.ClassInfo, "net.minecraft.server.packs.repository.PackSource": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.api.IIOFilterUpgrade": Internal.ClassInfo, "com.buuz135.industrial.block.misc.InfinityChargerBlock": Internal.ClassInfo, "net.minecraft.world.entity.Display$TextDisplay$Align": Internal.ClassInfo, "net.minecraft.stats.ServerStatsCounter": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.SporesRecreatorBlock": Internal.ClassInfo, "net.minecraft.world.level.block.NetherPortalBlock": Internal.ClassInfo, "net.minecraft.server.players.GameProfileCache$GameProfileInfo": Internal.ClassInfo, "net.liopyu.entityjs.builders.ArrowEntityJSBuilder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.ConfigCallback": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic$ObservableFilterItemStackHandler": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.EndLampBlock": Internal.ClassInfo, "com.mojang.blaze3d.preprocessor.GlslPreprocessor": Internal.ClassInfo, "net.minecraft.network.chat.HoverEvent$ItemStackInfo": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetCameraPacket": Internal.ClassInfo, "java.util.EnumSet": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BeehiveBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ArmorItemBuilder$Boots": Internal.ClassInfo, "com.mojang.datafixers.types.Type$FieldNotFoundException": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingHealEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType": Internal.ClassInfo, "net.minecraft.util.profiling.ProfilerFiller": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleList": Internal.ClassInfo, "cofh.lib.common.block.PoweredRailBlockCoFH": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FlaxBaleBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootTable$Builder": Internal.ClassInfo, "com.buuz135.industrial.block.generator.PitifulGeneratorBlock": Internal.ClassInfo, "cofh.thermal.core.common.item.EnergyCellBlockItem": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.BlockFilterItem": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.AnimalRancherTile": Internal.ClassInfo, "net.minecraft.world.item.crafting.BlastingRecipe": Internal.ClassInfo, "com.mojang.datafixers.types.templates.TypeTemplate": Internal.ClassInfo, "net.minecraft.world.item.crafting.SmithingTrimRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.BlockStateMatchTest": Internal.ClassInfo, "com.mojang.brigadier.builder.ArgumentBuilder": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket": Internal.ClassInfo, "net.minecraft.world.level.block.entity.LecternBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.dimension.end.EndDragonFight": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaGrandfatherClockBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.Dolphin": Internal.ClassInfo, "net.minecraft.client.MouseHandler": Internal.ClassInfo, "com.blakebr0.cucumber.crafting.recipe.ShapedTagRecipe": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.BlockController": Internal.ClassInfo, "net.minecraft.client.gui.components.Button": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2DoubleFunction": Internal.ClassInfo, "net.mehvahdjukaar.suppsquared.common.PlaqueBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.ExperienceDropletItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeItem": Internal.ClassInfo, "net.minecraft.world.effect.MobEffectInstance": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundBlockEventPacket": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.block.InfusedFarmlandBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration": Internal.ClassInfo, "net.minecraftforge.common.world.ModifiableStructureInfo": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.UrnBlock": Internal.ClassInfo, "java.awt.event.MouseEvent": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakSinkCounterBlock": Internal.ClassInfo, "net.minecraftforge.event.RegisterGameTestsEvent": Internal.ClassInfo, "net.minecraft.client.gui.navigation.FocusNavigationEvent$ArrowNavigation": Internal.ClassInfo, "net.minecraft.world.level.block.AmethystClusterBlock": Internal.ClassInfo, "com.buuz135.industrial.block.misc.tile.EnchantmentExtractorTile": Internal.ClassInfo, "net.minecraft.world.entity.animal.Bucketable": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.mixin.accessor.ListPoolElementAccessor": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.FarmlandTillRecipe": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$KeyInput": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.FrogAttackablesSensor": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crop.ICropTierProvider": Internal.ClassInfo, "net.mcreator.cozyhome.block.LargeCherryStumpBlock": Internal.ClassInfo, "org.apache.maven.artifact.repository.ArtifactRepositoryPolicy": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.DeadSeaScrollItem": Internal.ClassInfo, "com.mojang.serialization.DynamicOps": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.TatamiHalfMatBlock": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.ExpandedMapData": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.GrowthAcceleratorBlock": Internal.ClassInfo, "org.lwjgl.system.Struct": Internal.ClassInfo, "dev.latvian.mods.kubejs.integration.forge.jei.RemoveJEIRecipesEvent": Internal.ClassInfo, "net.minecraft.world.inventory.SmithingMenu": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.BasicBlockJS$Builder": Internal.ClassInfo, "java.util.UUID": Internal.ClassInfo, "net.minecraft.world.level.block.entity.CommandBlockEntity$Mode": Internal.ClassInfo, "com.obscuria.aquamirae.registry.AquamiraeItems$1": Internal.ClassInfo, "net.minecraftforge.server.command.EnumArgument": Internal.ClassInfo, "com.jtorleonstudios.libraryferret.effect.StatusEffects$1": Internal.ClassInfo, "java.lang.constant.DynamicConstantDesc": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2LongFunction": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.ThreeBoltArmorItem$Chestplate": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceArgument$Info$Template": Internal.ClassInfo, "com.google.common.collect.Maps$IteratorBasedAbstractMap": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchWallClockBlock": Internal.ClassInfo, "com.hrznstudio.titanium.container.addon.IContainerAddon": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement": Internal.ClassInfo, "net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.IKeyLockable$KeyStatus": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$KeyReleased$Pre": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$LivingEntityContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.lime.LimeWallSignBlock": Internal.ClassInfo, "com.probejs.jdoc.property.AbstractProperty": Internal.ClassInfo, "com.google.common.collect.ForwardingCollection": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.entities.BombEntity$BombType": Internal.ClassInfo, "net.minecraft.world.level.block.SaplingBlock": Internal.ClassInfo, "javax.security.auth.Subject": Internal.ClassInfo, "letsforge_pirates.item.PirateTier1Item$Helmet": Internal.ClassInfo, "net.minecraft.client.telemetry.WorldSessionTelemetryManager": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryTableBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingFallEvent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockClickResponseUpgrade": Internal.ClassInfo, "net.minecraft.world.level.block.entity.CommandBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.RecordItemJS$Builder": Internal.ClassInfo, "net.minecraft.world.entity.monster.SpellcasterIllager": Internal.ClassInfo, "net.minecraft.stats.StatsCounter": Internal.ClassInfo, "net.minecraft.data.DataProvider": Internal.ClassInfo, "net.minecraft.world.entity.monster.Slime": Internal.ClassInfo, "net.minecraft.world.item.crafting.TippedArrowRecipe": Internal.ClassInfo, "net.minecraft.client.OptionInstance$CaptionBasedToString": Internal.ClassInfo, "net.minecraftforge.common.crafting.conditions.ICondition": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.BlockPlacerTile": Internal.ClassInfo, "net.minecraft.util.valueproviders.TrapezoidFloat": Internal.ClassInfo, "com.hrznstudio.titanium.client.screen.addon.StateButtonInfo": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.AxolotlEntityAccessor": Internal.ClassInfo, "net.minecraft.world.item.enchantment.EnchantmentCategory": Internal.ClassInfo, "net.minecraft.world.item.BedItem": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseScrolled$Post": Internal.ClassInfo, "com.electrolyte.matc.items.PrudentiumCrystal": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket": Internal.ClassInfo, "cofh.thermal.core.common.item.LightningChargeItem": Internal.ClassInfo, "java.io.PrintWriter": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.EnumConfig": Internal.ClassInfo, "de.keksuccino.fancymenu.util.rendering.AspectRatio": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingConversionEvent$Post": Internal.ClassInfo, "net.minecraft.world.item.enchantment.DiggingEnchantment": Internal.ClassInfo, "java.awt.Component": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.FireworksJS$Shape": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundInteractPacket": Internal.ClassInfo, "org.violetmoon.zetaimplforge.mixin.mixins.client.AccessorBlockColors": Internal.ClassInfo, "com.talhanation.smallships.world.item.DrakkarItem": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.SkilletBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.integration.forge.jei.HideCustomJEIEventJS": Internal.ClassInfo, "net.mcreator.cozyhome.block.QuartzCounterBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendStatic": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.mixin.accessor.FeaturePoolElementAccessor": Internal.ClassInfo, "net.minecraft.world.level.block.BedBlock": Internal.ClassInfo, "java.lang.module.ModuleReader": Internal.ClassInfo, "cofh.core.common.block.SoilBlock": Internal.ClassInfo, "net.minecraft.world.item.GlowInkSacItem": Internal.ClassInfo, "net.minecraft.world.level.timers.TimerQueue": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.WidgetLayout": Internal.ClassInfo, "net.minecraft.network.syncher.EntityDataSerializer": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaBrownBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.SurfaceRules$SurfaceRule": Internal.ClassInfo, "net.minecraftforge.common.world.BiomeModifier": Internal.ClassInfo, "letsforge_pirates.item.Merchant1Item$Boots": Internal.ClassInfo, "net.minecraft.world.level.block.PumpkinBlock": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryPropertyMap$Builder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$YClampedGradient": Internal.ClassInfo, "fonnymunkey.simplehats.util.HatEntry$HatParticleSettings": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2IntFunction": Internal.ClassInfo, "com.buuz135.industrial.fluid.OreFluid$Source": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.MinecartChest": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.black.BlackWallSignBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FenceMimicBlock": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BasePaxelItem": Internal.ClassInfo, "net.minecraft.network.chat.FormattedText$StyledContentConsumer": Internal.ClassInfo, "java.lang.AutoCloseable": Internal.ClassInfo, "net.minecraft.core.Registry": Internal.ClassInfo, "net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2ByteFunction": Internal.ClassInfo, "com.obscuria.aquamirae.common.blocks.CollectiblePaintingBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.filter.mob.MobFilter": Internal.ClassInfo, "java.util.stream.IntStream$Builder": Internal.ClassInfo, "net.minecraft.world.level.block.entity.SpawnerBlockEntity": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.CookingPotItem": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsServerPlayerList": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.SmallCarvedTopNoBeardAdaptation": Internal.ClassInfo, "net.minecraft.world.level.portal.PortalForcer": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2ObjectFunction": Internal.ClassInfo, "net.minecraft.data.recipes.CraftingRecipeBuilder": Internal.ClassInfo, "net.liopyu.entityjs.builders.AnimalEntityBuilder": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.item.WitheringSoulItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.callbacks.BlockStateMirrorCallbackJS": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket": Internal.ClassInfo, "org.moddingx.libx.event.ConfigLoadedEvent": Internal.ClassInfo, "com.google.common.reflect.TypeCapture": Internal.ClassInfo, "net.minecraft.world.level.lighting.LevelLightEngine": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ItemToolTierRegistryEventJS": Internal.ClassInfo, "cofh.lib.common.block.GunpowderBlock": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.EliteLootBoxItem": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.state.BlockStatePredicate": Internal.ClassInfo, "io.netty.channel.WriteBufferWaterMark": Internal.ClassInfo, "net.minecraft.world.level.block.HugeMushroomBlock": Internal.ClassInfo, "java.awt.GraphicsDevice": Internal.ClassInfo, "net.minecraft.world.level.storage.ServerLevelData": Internal.ClassInfo, "dev.latvian.mods.kubejs.typings.desc.TypeDescJS": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakDeskBlock": Internal.ClassInfo, "net.minecraftforge.network.NetworkDirection": Internal.ClassInfo, "com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.SoulExtractionRecipe$Serializer": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.OnionBlock": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.BlockTrim": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.event.data.SoundKeyframeData": Internal.ClassInfo, "net.minecraft.client.renderer.PostChain": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonHoverPhase": Internal.ClassInfo, "mezz.jei.api.gui.drawable.IDrawableAnimated": Internal.ClassInfo, "net.minecraft.world.level.block.StemBlock": Internal.ClassInfo, "eutros.framedcompactdrawers.recipe.FramingRecipe$Serializer": Internal.ClassInfo, "vazkii.patchouli.common.item.ItemModBook": Internal.ClassInfo, "com.mojang.blaze3d.font.GlyphProvider": Internal.ClassInfo, "javax.accessibility.AccessibleAction": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.NoneAdaptation": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BoundingBoxAccessor": Internal.ClassInfo, "cofh.lib.api.item.IContainerItem": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveStorageCounterBlock": Internal.ClassInfo, "net.minecraft.BlockUtil$FoundRectangle": Internal.ClassInfo, "net.mehvahdjukaar.suppsquared.common.CopperLanternBlock": Internal.ClassInfo, "io.netty.util.concurrent.EventExecutorGroup": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityStruckByLightningEvent": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagArgument$Result": Internal.ClassInfo, "com.mojang.blaze3d.shaders.Program$Type": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.WallHangingCanvasSignBlock": Internal.ClassInfo, "net.minecraft.world.entity.EntitySelector": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightTrapDoorBlock": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.TransporterBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.settings.MainSetting": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier1Item": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.BlackHoleUnitBlock": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.request.AbuseReportRequest": Internal.ClassInfo, "javax.sound.sampled.AudioFormat": Internal.ClassInfo, "net.minecraftforge.fluids.FluidType": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.BlockBreakerBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerInteractEvent$RightClickItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2ByteFunction": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.PotionBrewerBlock": Internal.ClassInfo, "com.hrznstudio.titanium.api.redstone.IRedstoneReader": Internal.ClassInfo, "com.mojang.blaze3d.shaders.EffectProgram": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.WorldOpenFlows": Internal.ClassInfo, "top.theillusivec4.curios.api.type.capability.ICurio": Internal.ClassInfo, "net.minecraft.client.resources.metadata.animation.AnimationMetadataSection": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.ObjectCompletedEvent$FileEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.ByteBinaryOperator": Internal.ClassInfo, "mezz.jei.api.recipe.transfer.IRecipeTransferError": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.HungerLevel": Internal.ClassInfo, "cpw.mods.jarhandling.impl.SimpleJarMetadata": Internal.ClassInfo, "java.util.ImmutableCollections$Set12": Internal.ClassInfo, "com.jtorleonstudios.awesomedungeonocean.AwsOceanBoatStructures$AwsOceanBoatStructure": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ThrownEnderpearl": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.forge.ItemDestroyedEventJS": Internal.ClassInfo, "net.minecraftforge.client.model.ForgeFaceData": Internal.ClassInfo, "net.minecraft.world.level.saveddata.maps.MapDecoration": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundKeepAlivePacket": Internal.ClassInfo, "net.minecraft.world.level.storage.DimensionDataStorage": Internal.ClassInfo, "net.minecraft.world.level.lighting.LayerLightSectionStorage": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.RecipesEventJS": Internal.ClassInfo, "com.google.common.cache.LocalCache$LocalManualCache": Internal.ClassInfo, "com.mojang.brigadier.exceptions.DynamicCommandExceptionType": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.BlockStateKJS": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$BreakEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.Heightmap$Types": Internal.ClassInfo, "net.minecraft.server.ServerFunctionManager$TraceCallbacks": Internal.ClassInfo, "net.mcreator.cozyhome.block.TelescopeBlock": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.TreeExtractorMapping$Serializer": Internal.ClassInfo, "letsforge_pirates.item.Skull1Item": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$PureTransformer": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.SugarCubeItem": Internal.ClassInfo, "net.minecraft.core.Direction$Plane": Internal.ClassInfo, "net.minecraft.client.resources.metadata.animation.AnimationFrame": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier3Item": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.red.RedHangingSignBlock": Internal.ClassInfo, "net.minecraft.world.level.block.entity.EnchantmentTableBlockEntity": Internal.ClassInfo, "net.minecraft.client.gui.Gui": Internal.ClassInfo, "net.minecraft.world.item.enchantment.DigDurabilityEnchantment": Internal.ClassInfo, "net.minecraft.world.level.LevelSimulatedReader": Internal.ClassInfo, "com.blakebr0.cucumber.item.BaseReusableItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FlintBlock": Internal.ClassInfo, "net.minecraft.world.entity.projectile.LargeFireball": Internal.ClassInfo, "dev.ftb.mods.ftbteams.api.property.TeamPropertyType": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.PlayerAdvancementEventJS": Internal.ClassInfo, "java.util.stream.Collector$Characteristics": Internal.ClassInfo, "net.minecraft.world.entity.Display$FloatInterpolator": Internal.ClassInfo, "java.security.Provider$Service": Internal.ClassInfo, "net.minecraft.world.level.levelgen.NoiseSettings": Internal.ClassInfo, "eutros.framedcompactdrawers.item.ItemOtherCustom": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelResource": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakTableBlock": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.UpgradeRecipeUtil": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityBlockPosContext": Internal.ClassInfo, "cofh.core.common.item.ArmorItemCoFH": Internal.ClassInfo, "mezz.jei.api.recipe.IFocusFactory": Internal.ClassInfo, "net.minecraft.world.entity.monster.Shulker": Internal.ClassInfo, "fonnymunkey.simplehats.util.HatEntry$HatSeason": Internal.ClassInfo, "com.hrznstudio.titanium.capability.FluidHandlerScreenProviderItemStack": Internal.ClassInfo, "net.minecraft.client.renderer.texture.Tickable": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket": Internal.ClassInfo, "com.buuz135.industrial.item.FertilizerItem": Internal.ClassInfo, "net.minecraft.world.item.WritableBookItem": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetPassengersPacket": Internal.ClassInfo, "net.minecraft.stats.Stat": Internal.ClassInfo, "dev.latvian.mods.kubejs.script.ConsoleLine$SourceLine": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2ObjectFunction": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObject2ObjectMap": Internal.ClassInfo, "com.benbenlaw.strainers.recipe.StrainerRecipe$Serializer": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundClientCommandPacket": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeConfig": Internal.ClassInfo, "mezz.jei.api.runtime.config.IJeiConfigManager": Internal.ClassInfo, "java.time.chrono.Era": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedMirrorStandBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.ReprocessorRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.level.chunk.Palette": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Stop": Internal.ClassInfo, "mezz.jei.api.gui.builder.IRecipeLayoutBuilder": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSetStructureBlockPacket": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.Boat$Type": Internal.ClassInfo, "java.util.Spliterator$OfDouble": Internal.ClassInfo, "cofh.lib.common.effect.CustomParticleMobEffect": Internal.ClassInfo, "net.minecraft.client.gui.screens.inventory.AbstractContainerScreen": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.RopeArrowItem": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier2Item$Helmet": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2ShortFunction": Internal.ClassInfo, "net.minecraftforge.data.event.GatherDataEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeConstructor": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType": Internal.ClassInfo, "net.minecraft.world.level.levelgen.Aquifer": Internal.ClassInfo, "net.minecraft.client.StringSplitter$LinePosConsumer": Internal.ClassInfo, "java.awt.LayoutManager": Internal.ClassInfo, "net.minecraft.util.SignatureUpdater": Internal.ClassInfo, "net.minecraftforge.forgespi.language.ILifecycleEvent": Internal.ClassInfo, "net.minecraft.world.level.border.WorldBorder$Settings": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchStorageCounterBlock": Internal.ClassInfo, "java.awt.event.FocusEvent$Cause": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.ResourcefulFurnaceTile": Internal.ClassInfo, "net.mcreator.cozyhome.block.YellowLampBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.bindings.KMath": Internal.ClassInfo, "org.moddingx.libx.registration.Registerable$TrackingCollector": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.JsonSerializable": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.QuiverItem$Data": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.AxisAlignedLinearPosTest": Internal.ClassInfo, "net.minecraft.util.valueproviders.ConstantFloat": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.AbyssalArmorExtraItem": Internal.ClassInfo, "com.mojang.serialization.CompressorHolder": Internal.ClassInfo, "net.minecraft.server.packs.metadata.MetadataSectionSerializer": Internal.ClassInfo, "net.minecraftforge.event.AddReloadListenerEvent": Internal.ClassInfo, "com.mojang.datafixers.OpticFinder": Internal.ClassInfo, "net.minecraft.world.entity.ai.attributes.RangedAttribute": Internal.ClassInfo, "net.minecraftforge.event.entity.player.FillBucketEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.SeaPickleFeature": Internal.ClassInfo, "net.minecraftforge.client.model.geometry.BlockGeometryBakingContext$VisibilityData": Internal.ClassInfo, "dev.latvian.mods.kubejs.script.PlatformWrapper$ModInfo": Internal.ClassInfo, "net.minecraft.world.level.block.ChestBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.BehaviorControl": Internal.ClassInfo, "net.minecraft.world.entity.schedule.Schedule": Internal.ClassInfo, "net.minecraft.world.level.saveddata.maps.MapDecoration$Type": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.HiveExtractorMapping": Internal.ClassInfo, "letsforge_pirates.item.Merchant1Item": Internal.ClassInfo, "net.minecraft.world.entity.ai.goal.WrappedGoal": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeMenuType": Internal.ClassInfo, "dev.architectury.fluid.FluidStack": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundDamageEventPacket": Internal.ClassInfo, "net.minecraft.world.level.chunk.PalettedContainer$CountConsumer": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.blue.BlueWallHangingSignBlock": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.RedstoneClockBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.Ocelot": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.ContextMenuItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.KubeJSInventoryListener": Internal.ClassInfo, "net.minecraft.world.entity.player.ProfileKeyPair": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.DyeableItem": Internal.ClassInfo, "net.minecraft.client.Minecraft$ChatStatus": Internal.ClassInfo, "net.minecraft.util.profiling.metrics.MetricCategory": Internal.ClassInfo, "java.util.ImmutableCollections$MapN": Internal.ClassInfo, "net.minecraft.client.model.geom.builders.CubeDeformation": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.EntityLootEventJS": Internal.ClassInfo, "net.minecraftforge.client.textures.ForgeTextureMetadata$Serializer": Internal.ClassInfo, "net.minecraft.core.particles.ParticleType": Internal.ClassInfo, "net.minecraft.client.renderer.ChunkBufferBuilderPack": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexFormat$Mode": Internal.ClassInfo, "net.minecraftforge.fml.ModLoadingStage": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundOpenScreenPacket": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.GlobeBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.PlanterBlock": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.ResourceGenerator2Block": Internal.ClassInfo, "com.benbenlaw.strainers.recipe.SummoningRecipe": Internal.ClassInfo, "net.minecraft.world.scores.criteria.ObjectiveCriteria$RenderType": Internal.ClassInfo, "com.mojang.datafixers.optics.Optic": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.LivingEntityAccessor": Internal.ClassInfo, "net.minecraft.world.level.block.PinkPetalsBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.AdvancementEvent": Internal.ClassInfo, "net.minecraft.world.level.block.SweetBerryBushBlock": Internal.ClassInfo, "mezz.jei.api.runtime.IClickableIngredient": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightStairBlock": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$LineStateShard": Internal.ClassInfo, "software.bernie.geckolib.core.animation.Animation": Internal.ClassInfo, "net.minecraft.util.valueproviders.FloatProvider": Internal.ClassInfo, "net.minecraftforge.client.textures.ForgeTextureMetadata": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.FluidLaserBaseBlock": Internal.ClassInfo, "com.benbenlaw.strainers.block.custom.SummoningBlock": Internal.ClassInfo, "net.liopyu.entityjs.events.ModifyAttributeEventJS": Internal.ClassInfo, "net.liopyu.entityjs.events.ModifyAttributeEventJS$AttributeModificationHelper": Internal.ClassInfo, "net.minecraftforge.eventbus.api.Event": Internal.ClassInfo, "net.minecraft.world.inventory.MerchantMenu": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundEntityTagQuery": Internal.ClassInfo, "net.minecraftforge.energy.EnergyStorage": Internal.ClassInfo, "com.google.common.base.Function": Internal.ClassInfo, "com.google.common.collect.ImmutableMap": Internal.ClassInfo, "net.minecraft.client.renderer.RenderType$OutlineProperty": Internal.ClassInfo, "com.mojang.datafixers.kinds.App": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.LoggedChatEvent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade": Internal.ClassInfo, "com.benbenlaw.roomopolis.item.custom.CorridorKeys.CorridorKey1": Internal.ClassInfo, "com.supermartijn642.fusion.api.model.SpriteIdentifier": Internal.ClassInfo, "com.benbenlaw.roomopolis.item.custom.CorridorKeys.CorridorKey2": Internal.ClassInfo, "com.benbenlaw.roomopolis.item.custom.CorridorKeys.CorridorKey3": Internal.ClassInfo, "net.minecraft.world.entity.animal.Bee": Internal.ClassInfo, "java.awt.JobAttributes$DefaultSelectionType": Internal.ClassInfo, "tfar.dankstorage.block.CDockBlock": Internal.ClassInfo, "com.buuz135.industrial.item.ItemConveyorUpgrade": Internal.ClassInfo, "java.text.ParsePosition": Internal.ClassInfo, "java.util.Deque": Internal.ClassInfo, "net.minecraftforge.event.server.ServerStartingEvent": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryMirrorBlock": Internal.ClassInfo, "net.minecraftforge.client.event.sound.SoundEvent$SoundSourceEvent": Internal.ClassInfo, "com.teammetallurgy.aquaculture.api.fishing.Hook": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.BlackstoneReplaceProcessor": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerInteractEvent$EntityInteractSpecific": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakChairBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.parameters.LootContextParam": Internal.ClassInfo, "net.minecraft.world.level.chunk.PalettedContainer$Strategy": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.StateTestingPredicate": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakPlankBlock": Internal.ClassInfo, "net.minecraftforge.registries.DeferredRegister": Internal.ClassInfo, "io.netty.channel.ChannelFuture": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.SouliumDaggerItem": Internal.ClassInfo, "java.text.DateFormatSymbols": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaMirrorStandBlock": Internal.ClassInfo, "net.minecraft.world.level.block.StonecutterBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks": Internal.ClassInfo, "org.violetmoon.zetaimplforge.client.IZetaForgeItemStuff": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$ArrowBlockHitContext": Internal.ClassInfo, "net.minecraft.world.level.block.DirectionalBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.entries.EntryGroup$Builder": Internal.ClassInfo, "net.minecraft.world.entity.npc.VillagerDataHolder": Internal.ClassInfo, "net.minecraft.world.item.enchantment.MultiShotEnchantment": Internal.ClassInfo, "net.minecraft.network.chat.LastSeenMessages$Update": Internal.ClassInfo, "com.obscuria.aquamirae.common.effects.AbyssBlindnessMobEffect": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2BooleanFunction": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeGuiGraphics": Internal.ClassInfo, "net.minecraft.world.level.block.BeehiveBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedDeskBlock": Internal.ClassInfo, "net.minecraft.world.item.DoubleHighBlockItem": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.MasterInfusionCrystalItem": Internal.ClassInfo, "net.minecraft.world.level.block.SpreadingSnowyDirtBlock": Internal.ClassInfo, "net.minecraft.data.PackOutput": Internal.ClassInfo, "mezz.jei.library.runtime.JeiRuntime": Internal.ClassInfo, "net.minecraft.world.level.block.SuspiciousEffectHolder": Internal.ClassInfo, "dev.latvian.mods.kubejs.registry.RegistryEventJS": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.QuestProgressEventData": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2ShortFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunction$ContextProvider": Internal.ClassInfo, "java.awt.Frame": Internal.ClassInfo, "net.minecraft.world.item.DyeableHorseArmorItem": Internal.ClassInfo, "java.math.MathContext": Internal.ClassInfo, "mezz.jei.api.runtime.config.IJeiConfigValue": Internal.ClassInfo, "net.minecraft.network.syncher.EntityDataAccessor": Internal.ClassInfo, "net.minecraft.world.item.alchemy.Potion": Internal.ClassInfo, "java.time.ZoneId": Internal.ClassInfo, "net.minecraft.world.level.block.BambooStalkBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.RelayerBlock": Internal.ClassInfo, "java.lang.StringBuilder": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.RiceRollMedleyBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.Structure$GenerationStub": Internal.ClassInfo, "com.buuz135.industrial.fluid.OreFluidInstance": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.MutableArmorTier": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier1Item$Helmet": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.WisteriaNiveisItem": Internal.ClassInfo, "net.minecraftforge.event.entity.player.ArrowLooseEvent": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.item.EssenceCoalBlockItem": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.BambooLeaves": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationController$CustomKeyframeHandler": Internal.ClassInfo, "net.minecraft.data.worldgen.BootstapContext": Internal.ClassInfo, "net.minecraft.client.CameraType": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.math.PixelBuffer": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket": Internal.ClassInfo, "com.buuz135.industrialforegoingsouls.block.SoulLaserBaseBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2LongFunction": Internal.ClassInfo, "java.awt.image.Raster": Internal.ClassInfo, "net.minecraft.client.renderer.texture.TextureAtlasSprite": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.VinesFeature": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.pickup.PickupUpgradeWrapper": Internal.ClassInfo, "net.blay09.mods.balm.api.event.BalmEvent": Internal.ClassInfo, "net.minecraft.world.entity.player.StackedContents": Internal.ClassInfo, "net.minecraft.world.level.chunk.StructureAccess": Internal.ClassInfo, "chiefarug.mods.systeams.SysteamsRegistry$Recipes$1": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier2Item": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.BlackHoleTankBlock": Internal.ClassInfo, "java.awt.ComponentOrientation": Internal.ClassInfo, "net.minecraftforge.event.level.ExplosionEvent$Detonate": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.SporesRecreatorTile": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.EndermanSkullWallBlock": Internal.ClassInfo, "com.hrznstudio.titanium.block.tile.GeneratorTile": Internal.ClassInfo, "net.minecraftforge.fluids.capability.IFluidHandlerItem": Internal.ClassInfo, "net.minecraft.network.protocol.game.VecDeltaCodec": Internal.ClassInfo, "net.minecraft.world.item.Items": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.MobCrusherTile": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.CherryFoliagePlacer": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSignUpdatePacket": Internal.ClassInfo, "net.minecraft.world.level.biome.AmbientParticleSettings": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.KnifeItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.NBTIOWrapper": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Render$Pre": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakDrawerBlock": Internal.ClassInfo, "com.hrznstudio.titanium.api.IMachine": Internal.ClassInfo, "java.lang.ThreadLocal": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2FloatFunction": Internal.ClassInfo, "java.awt.Image": Internal.ClassInfo, "java.awt.dnd.DragSource": Internal.ClassInfo, "net.minecraft.client.player.inventory.Hotbar": Internal.ClassInfo, "realmayus.aquatictorches.AquaticWallTorchBlock": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.DryingTableBlock": Internal.ClassInfo, "java.nio.channels.SeekableByteChannel": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortSpliterator": Internal.ClassInfo, "net.minecraftforge.fluids.IFluidTank": Internal.ClassInfo, "com.hrznstudio.titanium.block_network.INetworkDirectionalConnection": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.CountingMap": Internal.ClassInfo, "cofh.thermal.core.common.fluid.CrudeOilFluid$1": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.QuestObject": Internal.ClassInfo, "net.minecraftforge.client.event.EntityRenderersEvent": Internal.ClassInfo, "net.minecraft.util.KeyDispatchDataCodec": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.LivingEntityRendererAccessor": Internal.ClassInfo, "vazkii.patchouli.client.book.BookEntry": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightWallBlock": Internal.ClassInfo, "io.netty.buffer.PooledByteBufAllocatorMetric": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeSpecialEffects$GrassColorModifier$ColorModifier": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap": Internal.ClassInfo, "com.mojang.datafixers.kinds.K2": Internal.ClassInfo, "net.minecraft.world.level.block.CarvedPumpkinBlock": Internal.ClassInfo, "com.mojang.datafixers.kinds.K1": Internal.ClassInfo, "net.minecraft.world.inventory.ShulkerBoxMenu": Internal.ClassInfo, "net.minecraft.world.entity.MobCategory": Internal.ClassInfo, "net.minecraftforge.client.extensions.common.IClientMobEffectExtensions": Internal.ClassInfo, "java.lang.constant.DirectMethodHandleDesc$Kind": Internal.ClassInfo, "net.minecraft.data.DataGenerator": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssenceCrossbowItem": Internal.ClassInfo, "net.minecraftforge.event.entity.living.ShieldBlockEvent": Internal.ClassInfo, "java.lang.module.ModuleDescriptor$Provides": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2ShortFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.BlockPredicateFilter": Internal.ClassInfo, "com.buuz135.industrial.item.addon.RangeAddonItem": Internal.ClassInfo, "letsforge_pirates.item.FishermanItem$Leggings": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.PancakeBlock": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.ChapterImage": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.DataSenderKJS": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerXpEvent$XpChange": Internal.ClassInfo, "net.minecraft.world.level.block.entity.CampfireBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure$Type": Internal.ClassInfo, "net.minecraft.nbt.TagVisitor": Internal.ClassInfo, "java.util.function.DoublePredicate": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.SewageComposterBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$PlayerRespawnEvent": Internal.ClassInfo, "net.minecraft.commands.CommandBuildContext$Configurable": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.WaterBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.ILavaAndWaterLoggable": Internal.ClassInfo, "java.awt.geom.Rectangle2D": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.WidgetLayout$_Simple": Internal.ClassInfo, "mezz.jei.api.recipe.RecipeType": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.Widget": Internal.ClassInfo, "net.minecraft.world.level.saveddata.maps.MapBanner": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.SludgeRefinerBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.AltimeterItem": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.item.ItemInfinityDrill": Internal.ClassInfo, "net.minecraft.server.ServerAdvancementManager": Internal.ClassInfo, "net.minecraft.world.level.block.WitherWallSkullBlock": Internal.ClassInfo, "net.minecraft.network.chat.HoverEvent$Action": Internal.ClassInfo, "net.minecraft.world.item.HangingSignItem": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.InterModProcessEvent": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterable": Internal.ClassInfo, "com.buuz135.industrial.item.RecipelessCustomItem": Internal.ClassInfo, "net.minecraft.world.level.block.SoundType": Internal.ClassInfo, "letsforge_pirates.item.FishermanItem": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList$Category": Internal.ClassInfo, "letsforge_pirates.item.IronCutlassItem": Internal.ClassInfo, "com.probejs.jdoc.java.type.ITypeInfo": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexFormatElement$Type": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.orange.OrangeHangingSignBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.entries.SequentialEntry$Builder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunction$NoiseHolder": Internal.ClassInfo, "net.minecraft.world.entity.LerpingModel": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.IronGolemEntityAccessor": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterClientCommandsEvent": Internal.ClassInfo, "java.time.format.ResolverStyle": Internal.ClassInfo, "java.util.function.ObjIntConsumer": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.BellAttachType": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FluidStackJS": Internal.ClassInfo, "xueluoanping.fluiddrawerslegacy.block.BlockFluidDrawer": Internal.ClassInfo, "com.obscuria.aquamirae.common.blocks.LuminescentLampBlock": Internal.ClassInfo, "net.minecraftforge.client.extensions.common.IClientItemExtensions": Internal.ClassInfo, "net.minecraft.world.level.block.ComposterBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.TentBlock": Internal.ClassInfo, "net.minecraft.client.resources.model.BakedModel": Internal.ClassInfo, "net.minecraft.client.gui.navigation.ScreenAxis": Internal.ClassInfo, "net.minecraftforge.forgespi.locating.IModFile$Type": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.ParticleTypeBuilder": Internal.ClassInfo, "net.minecraft.network.PacketListener": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootParams": Internal.ClassInfo, "io.netty.channel.DefaultEventLoopGroup": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.Llama$Variant": Internal.ClassInfo, "net.minecraft.world.entity.monster.Guardian": Internal.ClassInfo, "net.minecraft.client.resources.sounds.SoundInstance$Attenuation": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonMirrorStandBlock": Internal.ClassInfo, "java.awt.dnd.DragSourceContext": Internal.ClassInfo, "net.minecraft.world.entity.EquipmentSlot": Internal.ClassInfo, "net.minecraft.world.entity.ai.Brain": Internal.ClassInfo, "net.minecraft.world.level.chunk.ChunkGeneratorStructureState": Internal.ClassInfo, "java.io.ObjectOutput": Internal.ClassInfo, "java.util.regex.MatchResult": Internal.ClassInfo, "com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe": Internal.ClassInfo, "net.mehvahdjukaar.sawmill.WoodcuttingRecipe$Serializer": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaMirrorBlock": Internal.ClassInfo, "dev.latvian.mods.rhino.ClassShutter": Internal.ClassInfo, "java.lang.Enum": Internal.ClassInfo, "net.minecraft.world.item.DyeableArmorItem": Internal.ClassInfo, "java.awt.event.WindowListener": Internal.ClassInfo, "net.minecraft.world.level.levelgen.NoiseGeneratorSettings": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.Theme": Internal.ClassInfo, "net.minecraftforge.registries.IdMappingEvent$IdRemapping": Internal.ClassInfo, "net.minecraft.world.entity.Display$TextDisplay$LineSplitter": Internal.ClassInfo, "tfar.craftingstation.CraftingStationBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.NoiseBasedStateProvider": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedItemPropertiesExtension": Internal.ClassInfo, "net.minecraft.world.level.levelgen.BitRandomSource": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangrovePlankBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock": Internal.ClassInfo, "net.minecraft.client.multiplayer.chat.report.ReportEnvironment$Server": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.MegaPineFoliagePlacer": Internal.ClassInfo, "de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinButton": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.NOTFilterItem": Internal.ClassInfo, "java.net.URLStreamHandler": Internal.ClassInfo, "java.awt.event.HierarchyListener": Internal.ClassInfo, "net.minecraft.network.chat.PlayerChatMessage": Internal.ClassInfo, "net.minecraft.world.inventory.ContainerLevelAccess": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.JungleTempleStructure": Internal.ClassInfo, "vazkii.patchouli.mixin.client.AccessorClientAdvancements": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeOptional": Internal.ClassInfo, "java.net.ContentHandlerFactory": Internal.ClassInfo, "net.minecraft.world.level.block.ObserverBlock": Internal.ClassInfo, "com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables": Internal.ClassInfo, "net.minecraft.world.level.block.BlastFurnaceBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterKeyMappingsEvent": Internal.ClassInfo, "dev.architectury.core.fluid.ArchitecturyFluidAttributes": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.BasicItemJS$Builder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.RandomPatchFeature": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingBreatheEvent": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootTable": Internal.ClassInfo, "net.minecraft.world.item.EggItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.ExplosionEventJS": Internal.ClassInfo, "net.minecraft.world.level.block.BaseFireBlock": Internal.ClassInfo, "javax.swing.text.StyleConstants$FontConstants": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.DamageFilterItem": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$LongValue": Internal.ClassInfo, "net.minecraft.world.item.AxeItem": Internal.ClassInfo, "net.minecraftforge.event.entity.living.MobEffectEvent$Added": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.NumberComponent$LongRange": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SugarBlock": Internal.ClassInfo, "com.hrznstudio.titanium.component.energy.EnergyStorageComponent": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.JarBlock": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.RockGenMapping": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.LangEventJS$Key": Internal.ClassInfo, "com.obscuria.obscureapi.api.common.classes.Bonus": Internal.ClassInfo, "java.util.Arrays$ArrayList": Internal.ClassInfo, "com.buuz135.industrial.item.LaserLensItem": Internal.ClassInfo, "java.awt.Color": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryEventSender": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ItemStackKJS": Internal.ClassInfo, "net.minecraft.world.inventory.RecipeBookMenu": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket": Internal.ClassInfo, "net.minecraft.world.entity.monster.Husk": Internal.ClassInfo, "cofh.core.common.item.IAugmentableItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.RarityFilter": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.AwakeningAltarBlock": Internal.ClassInfo, "com.probejs.jdoc.java.MethodInfo$ParamInfo": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.MiniCoalItem": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.reward.Reward": Internal.ClassInfo, "net.minecraft.world.level.LevelSimulatedRW": Internal.ClassInfo, "net.minecraft.world.item.crafting.RecipeType": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.IRopeConnection": Internal.ClassInfo, "tocraft.walkers.impl.SonicBoomUser": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.BlackboardItem": Internal.ClassInfo, "net.minecraft.world.level.block.BarrelBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ThrownPotion": Internal.ClassInfo, "net.minecraft.util.FormattedCharSink": Internal.ClassInfo, "tfar.dankstorage.utils.DankStats": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.FallingBlockBuilder": Internal.ClassInfo, "net.minecraft.client.renderer.debug.StructureRenderer": Internal.ClassInfo, "net.minecraft.world.level.GameType": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer$Builder": Internal.ClassInfo, "net.minecraft.server.packs.resources.CloseableResourceManager": Internal.ClassInfo, "net.minecraft.world.entity.ai.goal.GoalSelector": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityItemEntityContext": Internal.ClassInfo, "cofh.thermal.core.common.fluid.CreosoteFluid$1": Internal.ClassInfo, "com.hrznstudio.titanium.network.IButtonHandler": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.MobEntityAccessor": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagArgument": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket": Internal.ClassInfo, "net.minecraft.world.level.block.Mirror": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.RG2BlocksRecipe": Internal.ClassInfo, "java.awt.Container": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.PlantFertilizerTile": Internal.ClassInfo, "org.lwjgl.system.StructBuffer": Internal.ClassInfo, "net.minecraft.world.entity.LightningBolt": Internal.ClassInfo, "java.time.format.TextStyle": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2ObjectFunction": Internal.ClassInfo, "net.minecraft.world.entity.monster.warden.Warden": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.IAutoCookingUpgradeItem": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.ObjectCompletedEvent$TaskEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.integration.forge.jei.JEISubtypesEventJS$Interpreter": Internal.ClassInfo, "cofh.thermal.core.common.block.HardenedGlassBlock": Internal.ClassInfo, "com.electronwill.nightconfig.core.CommentedConfig": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$EnumValue": Internal.ClassInfo, "dev.ftb.mods.ftbquests.block.TaskScreenBlock$Aux": Internal.ClassInfo, "software.bernie.geckolib.core.animatable.model.CoreGeoModel": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerInteractEvent$EntityInteract": Internal.ClassInfo, "net.minecraft.nbt.TagType": Internal.ClassInfo, "mezz.jei.api.runtime.IBookmarkOverlay": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType": Internal.ClassInfo, "net.minecraft.world.inventory.AbstractFurnaceMenu": Internal.ClassInfo, "io.netty.channel.MultithreadEventLoopGroup": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.ListConfig": Internal.ClassInfo, "net.minecraft.world.entity.projectile.SmallFireball": Internal.ClassInfo, "com.google.common.collect.ImmutableEnumMap": Internal.ClassInfo, "com.buuz135.industrial.block.generator.MycelialGeneratorBlock": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.InventoryFilterItem$FilterSlot": Internal.ClassInfo, "net.minecraft.server.packs.repository.Pack$Info": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.MinecraftServerKJS": Internal.ClassInfo, "com.benbenlaw.caveopolis.recipe.SprayerRecipe": Internal.ClassInfo, "net.minecraft.world.level.ClipBlockStateContext": Internal.ClassInfo, "com.obscuria.obscureapi.api.common.classes.Bonus$Operation": Internal.ClassInfo, "com.mojang.serialization.MapEncoder": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.SoakingTableRecipe$Serializer": Internal.ClassInfo, "com.hrznstudio.titanium.api.client.IAsset": Internal.ClassInfo, "net.minecraft.commands.synchronization.brigadier.StringArgumentSerializer": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.CrankBlock": Internal.ClassInfo, "net.minecraftforge.common.world.ClimateSettingsBuilder": Internal.ClassInfo, "java.awt.JobAttributes$DialogType": Internal.ClassInfo, "net.minecraft.core.Holder$Reference$Type": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.CageBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.UnderwaterMagmaConfiguration": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundBossEventPacket$Handler": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.world.modifiers.ProsperityOreModifier": Internal.ClassInfo, "net.minecraft.world.item.crafting.SmokingRecipe": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakDrawerBlock": Internal.ClassInfo, "java.nio.charset.CharsetEncoder": Internal.ClassInfo, "net.minecraft.world.item.SimpleFoiledItem": Internal.ClassInfo, "javax.swing.text.TabStop": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier3Item$Boots": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.HydroponicBedBlock": Internal.ClassInfo, "journeymap.client.api.display.Displayable": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier3Item$Leggings": Internal.ClassInfo, "com.google.common.base.Supplier": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetScorePacket": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeBlockState": Internal.ClassInfo, "net.minecraft.world.level.ColorResolver": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.TrunkVineDecorator": Internal.ClassInfo, "io.netty.channel.ChannelHandlerContext": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.PositionTracker": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.misc.VillagerBrainEventInternal": Internal.ClassInfo, "net.minecraft.world.level.chunk.storage.SectionStorage": Internal.ClassInfo, "cofh.thermal.core.common.block.LumiumBlock": Internal.ClassInfo, "net.minecraft.network.chat.TextColor": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.reward.CustomReward": Internal.ClassInfo, "net.minecraftforge.client.event.RenderLevelStageEvent$Stage": Internal.ClassInfo, "net.minecraft.server.bossevents.CustomBossEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2LongFunction": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityProjectileWeaponContext": Internal.ClassInfo, "tax.taknax.taxov.item.PirateSuitItem": Internal.ClassInfo, "net.minecraft.world.level.block.entity.DropperBlockEntity": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier2Item$Leggings": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakPlankBlock": Internal.ClassInfo, "java.awt.dnd.DropTarget": Internal.ClassInfo, "cofh.thermal.lib.common.item.FluidContainerItemAugmentable": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemCraftedEventJS": Internal.ClassInfo, "com.blakebr0.cucumber.item.BaseWateringCanItem": Internal.ClassInfo, "dev.ftb.mods.ftbquests.block.entity.ITaskScreen": Internal.ClassInfo, "mezz.jei.api.ingredients.subtypes.UidContext": Internal.ClassInfo, "net.minecraft.world.entity.monster.Vex": Internal.ClassInfo, "dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory$Simple": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.DualNoiseProvider": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.InfinityTier": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityJoinLevelEvent": Internal.ClassInfo, "cofh.thermal.core.common.fluid.EnderFluid$1": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedStorageCounterBlock": Internal.ClassInfo, "java.nio.file.Watchable": Internal.ClassInfo, "mezz.jei.api.gui.IRecipeLayoutDrawable": Internal.ClassInfo, "net.minecraft.world.entity.animal.Cat": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.special.ShapelessKubeJSRecipe$SerializerKJS": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.BlockBuilderProvider": Internal.ClassInfo, "net.minecraft.world.inventory.tooltip.TooltipComponent": Internal.ClassInfo, "net.minecraft.server.level.FullChunkStatus": Internal.ClassInfo, "net.minecraft.world.item.EnderpearlItem": Internal.ClassInfo, "net.minecraftforge.fml.LogicalSide": Internal.ClassInfo, "net.minecraft.world.level.ExplosionDamageCalculator": Internal.ClassInfo, "net.minecraft.client.sounds.WeighedSoundEvents": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.red.RedStandingSignBlock": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampOgreFeature": Internal.ClassInfo, "java.lang.reflect.AnnotatedType": Internal.ClassInfo, "net.minecraft.world.level.block.StainedGlassBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObject2ObjectFunction": Internal.ClassInfo, "java.awt.PageAttributes$OriginType": Internal.ClassInfo, "dev.latvian.mods.rhino.WrapFactory": Internal.ClassInfo, "letsforge_pirates.item.Merchant3Item$Helmet": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.FluteItem": Internal.ClassInfo, "java.awt.geom.RectangularShape": Internal.ClassInfo, "dev.architectury.event.EventResult": Internal.ClassInfo, "net.minecraft.world.entity.npc.VillagerTrades$ItemListing": Internal.ClassInfo, "net.minecraft.world.item.armortrim.TrimPattern": Internal.ClassInfo, "com.hrznstudio.titanium.container.addon.IContainerAddonProvider": Internal.ClassInfo, "net.minecraft.world.level.block.ChorusPlantBlock": Internal.ClassInfo, "tfar.dankstorage.item.RedprintItem": Internal.ClassInfo, "net.minecraft.server.packs.resources.IoSupplier": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer": Internal.ClassInfo, "net.minecraft.tags.TagKey": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$KeyPressed$Pre": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntIterator": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaLightGrayBlock": Internal.ClassInfo, "java.util.function.ToIntBiFunction": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.AxolotlAttackablesSensor": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerDestroyItemEvent": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.EntityAccessor": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongConsumer": Internal.ClassInfo, "com.buuz135.industrial.item.addon.AddonItem": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityPlayerContext": Internal.ClassInfo, "net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity$AnimationStatus": Internal.ClassInfo, "java.util.LinkedHashSet": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.IOpenableScreen": Internal.ClassInfo, "io.netty.util.ByteProcessor$IndexOfProcessor": Internal.ClassInfo, "net.minecraft.network.chat.MessageSignature$Packed": Internal.ClassInfo, "net.minecraft.util.valueproviders.ConstantInt": Internal.ClassInfo, "net.minecraft.world.level.dimension.end.EndDragonFight$Data": Internal.ClassInfo, "mezz.jei.api.gui.drawable.IDrawableStatic": Internal.ClassInfo, "net.minecraft.data.recipes.FinishedRecipe": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.MinecartTNT": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider": Internal.ClassInfo, "com.mojang.brigadier.AmbiguityConsumer": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeWrapper$AutoSmeltingUpgradeWrapper": Internal.ClassInfo, "com.benbenlaw.strainers.recipe.NoInventoryRecipe": Internal.ClassInfo, "java.awt.event.ContainerEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.RuinedPortalStructure": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket": Internal.ClassInfo, "com.mojang.serialization.codecs.ListCodec": Internal.ClassInfo, "net.minecraftforge.network.NetworkEvent$ClientCustomPayloadEvent": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.StructureTempBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.CeilingHangingCanvasSignBlock": Internal.ClassInfo, "com.blakebr0.cucumber.crafting.recipe.ShapedNoMirrorRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.level.block.AbstractCandleBlock": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsWorldOptions": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingConversionEvent$Pre": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.additional_placements.BlockPlacerItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.BendingTrunkPlacer": Internal.ClassInfo, "com.mojang.serialization.codecs.UnboundedMapCodec": Internal.ClassInfo, "net.minecraft.client.User": Internal.ClassInfo, "software.bernie.geckolib.core.animation.RawAnimation": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration": Internal.ClassInfo, "java.nio.CharBuffer": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.icon.ImageIcon": Internal.ClassInfo, "com.supermartijn642.fusion.extensions.BlockModelExtension": Internal.ClassInfo, "java.awt.event.ComponentEvent": Internal.ClassInfo, "com.mojang.blaze3d.shaders.Uniform": Internal.ClassInfo, "net.minecraft.world.item.enchantment.EnchantmentInstance": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundRecipePacket$State": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.ConfigWithVariants": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.white.WhiteStandingSignBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchTableBlock": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightPressurePlateBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedSinkCounterBlock": Internal.ClassInfo, "net.minecraftforge.energy.IEnergyStorage": Internal.ClassInfo, "net.minecraft.world.entity.animal.MushroomCow": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket": Internal.ClassInfo, "net.minecraft.world.level.block.StairBlock": Internal.ClassInfo, "net.minecraft.client.renderer.debug.LightSectionDebugRenderer": Internal.ClassInfo, "com.gitlab.srcmc.powered_flashlight.blocks.AbstractLightBlock": Internal.ClassInfo, "net.minecraft.world.level.block.ChangeOverTimeBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.Hash": Internal.ClassInfo, "net.minecraft.client.gui.components.toasts.Toast$Visibility": Internal.ClassInfo, "net.minecraft.client.multiplayer.ClientPacketListener": Internal.ClassInfo, "com.hrznstudio.titanium.component.button.MultiButtonComponent": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObjectCollection": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier1Item$Boots": Internal.ClassInfo, "letsforge_pirates.item.PirateTier3Item": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2DoubleFunction": Internal.ClassInfo, "com.buuz135.industrial.block.misc.tile.EnchantmentApplicatorTile": Internal.ClassInfo, "net.minecraftforge.client.event.RenderTooltipEvent$Color": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.EnchantmentBuilder$DamageBonusFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.Clear": Internal.ClassInfo, "java.beans.PropertyChangeEvent": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2ObjectFunction": Internal.ClassInfo, "cofh.core.common.block.EntityBlockActive4Way": Internal.ClassInfo, "journeymap.client.api.display.Context$UI": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.CreeperEntityAccessor": Internal.ClassInfo, "cofh.thermal.lib.common.item.IFlexibleEnergyContainerItem": Internal.ClassInfo, "net.minecraft.client.model.geom.ModelLayerLocation": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.MechanicalDirtTile": Internal.ClassInfo, "java.nio.file.WatchService": Internal.ClassInfo, "java.lang.constant.ClassDesc": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey": Internal.ClassInfo, "com.benbenlaw.strainers.block.custom.MulchBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.AbstractSchoolingFish": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakMirrorStandBlock": Internal.ClassInfo, "net.minecraftforge.fml.event.config.ModConfigEvent": Internal.ClassInfo, "net.minecraft.world.level.block.MultifaceSpreader$SpreadPredicate": Internal.ClassInfo, "java.nio.channels.GatheringByteChannel": Internal.ClassInfo, "net.minecraft.commands.synchronization.SingletonArgumentInfo$Template": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData": Internal.ClassInfo, "com.benbenlaw.roomopolis.item.custom.KeyBlockRemover": Internal.ClassInfo, "com.hrznstudio.titanium.api.filter.IFilter": Internal.ClassInfo, "com.mojang.authlib.minecraft.MinecraftProfileTexture$Type": Internal.ClassInfo, "com.benbenlaw.strainers.recipe.SummoningRecipe$Serializer": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundContainerClickPacket": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchGrandfatherClockBlock": Internal.ClassInfo, "org.apache.commons.lang3.tuple.Pair": Internal.ClassInfo, "net.minecraft.world.level.block.TorchflowerCropBlock": Internal.ClassInfo, "java.time.Duration": Internal.ClassInfo, "net.minecraftforge.client.event.RenderGuiOverlayEvent": Internal.ClassInfo, "net.minecraft.core.HolderSet$ListBacked": Internal.ClassInfo, "java.time.ZoneOffset": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.light_blue.LightBlueWallSignBlock": Internal.ClassInfo, "net.liopyu.entityjs.builders.BaseLivingEntityBuilder$ISoundListenerJS": Internal.ClassInfo, "java.awt.dnd.DropTargetContext": Internal.ClassInfo, "net.minecraft.util.random.WeightedEntry": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$PlayerLoggedInEvent": Internal.ClassInfo, "net.mcreator.cozyhome.block.ChimneyNetherbrickBlock": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.WashingFactoryTile": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.crafting.BackpackUpgradeRecipe$Serializer": Internal.ClassInfo, "com.mojang.serialization.MapCodec": Internal.ClassInfo, "net.minecraftforge.common.world.ModifiableStructureInfo$StructureInfo": Internal.ClassInfo, "org.apache.maven.repository.legacy.metadata.ArtifactMetadata": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2CharFunction": Internal.ClassInfo, "com.mojang.brigadier.arguments.DoubleArgumentType": Internal.ClassInfo, "cofh.core.client.particle.options.BiColorParticleOptions": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntSpliterator": Internal.ClassInfo, "cofh.thermal.innovation.common.item.RFDrillItem": Internal.ClassInfo, "io.netty.util.concurrent.EventExecutor": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.CaveSurface": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexFormat$IndexType": Internal.ClassInfo, "net.minecraft.world.entity.EntityType": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonBenchBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.BlastingUpgradeItem": Internal.ClassInfo, "net.minecraft.advancements.Criterion": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundLevelEventPacket": Internal.ClassInfo, "java.util.Locale$IsoCountryCode": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.special.KubeJSCraftingRecipe": Internal.ClassInfo, "net.minecraft.client.searchtree.SearchTree": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.ShovelItemBuilder": Internal.ClassInfo, "com.hrznstudio.titanium.client.screen.asset.IAssetProvider": Internal.ClassInfo, "net.minecraft.world.level.block.ChorusFlowerBlock": Internal.ClassInfo, "com.hrznstudio.titanium.api.IEnumValues": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchMirrorBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.ChimneyBrickBlock": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.WeakNBTFilterItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockToolSwapUpgrade": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.properties.AddOreProperties": Internal.ClassInfo, "cofh.core.common.effect.EnergyChargeMobEffect": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleMirrorStandBlock": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.Quest": Internal.ClassInfo, "java.lang.invoke.VarHandle$VarHandleDesc": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.cyan.CyanHangingSignBlock": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.CatalogueBlock": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.TreasurePouchItem": Internal.ClassInfo, "net.minecraft.client.renderer.entity.layers.RenderLayer": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration": Internal.ClassInfo, "net.minecraft.world.level.chunk.DataLayer": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.light_blue.LightBlueWallHangingSignBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.FloatCollection": Internal.ClassInfo, "net.minecraft.client.server.IntegratedServer": Internal.ClassInfo, "java.util.function.LongUnaryOperator": Internal.ClassInfo, "net.minecraft.world.level.block.SmallDripleafBlock": Internal.ClassInfo, "java.time.DayOfWeek": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.ResourceGeneratorRecipe": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$BlockEntityTagOutput": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.FloatConsumer": Internal.ClassInfo, "net.minecraft.world.level.block.FireBlock": Internal.ClassInfo, "java.util.ListIterator": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.crafting.IEnchanterRecipe": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.event.data.ParticleKeyframeData": Internal.ClassInfo, "net.minecraft.client.gui.navigation.ScreenDirection": Internal.ClassInfo, "net.minecraft.world.item.HoneyBottleItem": Internal.ClassInfo, "javax.accessibility.AccessibleRelation": Internal.ClassInfo, "net.minecraftforge.registries.IForgeRegistryModifiable": Internal.ClassInfo, "com.mojang.realmsclient.gui.task.DataFetcher": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundMovePlayerPacket": Internal.ClassInfo, "com.obscuria.obscureapi.api.common.classes.Ability$Action": Internal.ClassInfo, "com.hrznstudio.titanium.fluid.TitaniumFluid": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer": Internal.ClassInfo, "java.nio.file.FileSystem": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2CharFunction": Internal.ClassInfo, "java.awt.event.WindowEvent": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FaucetBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.RecipeManager": Internal.ClassInfo, "fonnymunkey.simplehats.common.item.HatDisplayItem": Internal.ClassInfo, "java.util.Spliterator": Internal.ClassInfo, "net.minecraft.world.level.block.FlowerPotBlock": Internal.ClassInfo, "net.minecraftforge.fml.InterModComms$IMCMessage": Internal.ClassInfo, "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.CustomRewardEventJS": Internal.ClassInfo, "net.minecraft.client.resources.language.LanguageInfo": Internal.ClassInfo, "net.minecraft.world.entity.MobSpawnType": Internal.ClassInfo, "net.minecraft.world.damagesource.DamageType": Internal.ClassInfo, "net.minecraft.client.particle.TextureSheetParticle": Internal.ClassInfo, "java.util.Stack": Internal.ClassInfo, "net.minecraft.world.level.block.BasePressurePlateBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RenderTooltipEvent$Pre": Internal.ClassInfo, "java.util.concurrent.ConcurrentMap": Internal.ClassInfo, "net.minecraft.client.renderer.entity.LivingEntityRenderer": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.client.BlackboardManager$Key": Internal.ClassInfo, "net.minecraftforge.event.CommandEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.CheckLivingEntitySpawnEventJS": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakStorageCounterBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakCounterBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$Inferium": Internal.ClassInfo, "net.minecraft.world.level.block.PipeBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock": Internal.ClassInfo, "net.minecraftforge.event.TickEvent$ServerTickEvent": Internal.ClassInfo, "tax.taknax.taxov.item.PirateSuitItem$Chestplate": Internal.ClassInfo, "net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities": Internal.ClassInfo, "dev.latvian.mods.rhino.RhinoException": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.ChestLootEventJS": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundChatCommandPacket": Internal.ClassInfo, "javax.accessibility.AccessibleStateSet": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.HomeStoneItem": Internal.ClassInfo, "net.mcreator.cozyhome.block.CyanLampBlock": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.DefaultChapterGroup": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2LongFunction": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.OutputItem": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.blue.BlueHangingSignBlock": Internal.ClassInfo, "net.minecraft.network.chat.ChatType$BoundNetwork": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2IntMap$FastEntrySet": Internal.ClassInfo, "com.teammetallurgy.aquaculture.loot.AquaBiomeModifiers$FishSpawnBiomeModifier": Internal.ClassInfo, "java.util.Comparator": Internal.ClassInfo, "java.awt.BufferCapabilities$FlipContents": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$DamageContext": Internal.ClassInfo, "java.util.DoubleSummaryStatistics": Internal.ClassInfo, "net.minecraft.world.item.PickaxeItem": Internal.ClassInfo, "net.minecraft.world.entity.animal.CatVariant": Internal.ClassInfo, "net.minecraft.server.level.ChunkHolder$ChunkLoadingFailure": Internal.ClassInfo, "net.minecraft.world.level.block.WeatheringCopperFullBlock": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceKeyArgument": Internal.ClassInfo, "java.net.InterfaceAddress": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundBlockEntityTagQuery": Internal.ClassInfo, "net.minecraft.world.level.block.NoteBlock": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$MovementContext": Internal.ClassInfo, "net.minecraftforge.network.HandshakeMessages$LoginIndexedMessage": Internal.ClassInfo, "cofh.lib.common.block.TntBlockCoFH": Internal.ClassInfo, "net.minecraft.world.level.block.PoweredRailBlock": Internal.ClassInfo, "net.minecraft.nbt.StreamTagVisitor$ValueResult": Internal.ClassInfo, "cofh.thermal.core.common.item.WrenchItem": Internal.ClassInfo, "net.minecraftforge.fml.ModContainer": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2ReferenceFunction": Internal.ClassInfo, "net.minecraft.world.item.DispensibleContainerItem": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.item.ItemInfinitySaw": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.MilkBottleItem": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.MarineFisherBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.GameRulesKJS": Internal.ClassInfo, "journeymap.client.api.event.forge.PopupMenuEvent$Layer": Internal.ClassInfo, "net.minecraft.client.gui.components.spectator.SpectatorGui": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleGrandfatherClockBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.PedestalBlock": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.ItemFilletKnife": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceTableBlock": Internal.ClassInfo, "net.minecraft.client.particle.SpriteSet": Internal.ClassInfo, "java.awt.Window": Internal.ClassInfo, "net.minecraft.world.level.block.ChiseledBookShelfBlock": Internal.ClassInfo, "net.minecraft.client.renderer.ItemModelShaper": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.mixins.accessor.BrainAccessor": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelStorageSource$LevelDirectory": Internal.ClassInfo, "java.io.File": Internal.ClassInfo, "net.minecraftforge.event.level.ChunkEvent": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveMirrorBlock": Internal.ClassInfo, "net.minecraft.core.dispenser.DispenseItemBehavior": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundLockDifficultyPacket": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPlayerActionPacket$Action": Internal.ClassInfo, "net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent": Internal.ClassInfo, "net.minecraft.client.gui.components.Renderable": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction": Internal.ClassInfo, "java.time.format.DecimalStyle": Internal.ClassInfo, "net.minecraft.util.OptionEnum": Internal.ClassInfo, "com.mojang.blaze3d.font.SheetGlyphInfo": Internal.ClassInfo, "net.minecraft.world.entity.ambient.Bat": Internal.ClassInfo, "net.minecraft.network.chat.ChatTypeDecoration$Parameter": Internal.ClassInfo, "mezz.jei.api.helpers.IStackHelper": Internal.ClassInfo, "net.minecraftforge.network.NetworkEvent$PacketDispatcher": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.reward.RewardType": Internal.ClassInfo, "earth.terrarium.chipped.common.blocks.SpecialPointedDripstoneBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPlayerInputPacket": Internal.ClassInfo, "net.minecraftforge.client.settings.IKeyConflictContext": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.StatueBlock": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeLivingEntity": Internal.ClassInfo, "net.minecraft.client.GuiMessageTag": Internal.ClassInfo, "com.mojang.authlib.minecraft.UserApiService$UserFlag": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2BooleanFunction": Internal.ClassInfo, "com.jtorleonstudios.awesomedungeonocean.AwsOceanBoatStructures$Brigantine": Internal.ClassInfo, "net.minecraft.client.renderer.debug.GameTestDebugRenderer": Internal.ClassInfo, "com.mojang.serialization.DataResult$Mu": Internal.ClassInfo, "java.lang.Byte": Internal.ClassInfo, "net.minecraft.world.level.GameRules$Key": Internal.ClassInfo, "dev.latvian.mods.kubejs.generator.DataJsonGenerator": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.Behavior": Internal.ClassInfo, "net.minecraft.commands.Commands": Internal.ClassInfo, "net.mcreator.cozyhome.block.SprucePlankBlock": Internal.ClassInfo, "net.minecraft.world.item.InkSacItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.PlayerSelector": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.HourGlassBlock": Internal.ClassInfo, "net.minecraft.world.entity.projectile.AbstractHurtingProjectile": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundDisconnectPacket": Internal.ClassInfo, "dev.latvian.mods.rhino.Symbol": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket": Internal.ClassInfo, "java.time.OffsetDateTime": Internal.ClassInfo, "net.minecraftforge.event.level.NoteBlockEvent$Play": Internal.ClassInfo, "com.gitlab.srcmc.powered_flashlight.blocks.entities.AbstractLightBlockEntity": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.TerribleArmorItem": Internal.ClassInfo, "net.minecraft.world.BossEvent": Internal.ClassInfo, "net.minecraft.world.entity.animal.sniffer.Sniffer$State": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.CarverConfiguration": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.BasaltColumnsFeature": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.KelpRollItem": Internal.ClassInfo, "com.electronwill.nightconfig.core.ConfigSpec$CorrectionAction": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.LookAtTargetSink": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank": Internal.ClassInfo, "java.awt.datatransfer.Transferable": Internal.ClassInfo, "net.minecraft.client.renderer.debug.BeeDebugRenderer$HiveInfo": Internal.ClassInfo, "com.hrznstudio.titanium.component.sideness.IFacingComponent": Internal.ClassInfo, "com.google.gson.JsonElement": Internal.ClassInfo, "net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent": Internal.ClassInfo, "sun.awt.SunHints$Value": Internal.ClassInfo, "net.minecraft.world.damagesource.DamageSource": Internal.ClassInfo, "cofh.thermal.locomotion.common.item.AugmentableMinecartItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.command.ArgumentTypeWrappers": Internal.ClassInfo, "net.mcreator.cozyhome.block.LargeBirchStumpBlock": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier1Item$Leggings": Internal.ClassInfo, "net.minecraftforge.client.event.RenderGuiEvent": Internal.ClassInfo, "net.minecraft.util.valueproviders.BiasedToBottomInt": Internal.ClassInfo, "net.minecraft.world.level.block.BellBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemTooltipEventJS$StaticTooltipHandlerFromJS": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.icon.MutableColor4I": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$BreakSpeed": Internal.ClassInfo, "dev.ftb.mods.ftbquests.item.QuestBookItem": Internal.ClassInfo, "mrthomas20121.thermal_extra.item.CustomAugmentItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.AllOfPredicate": Internal.ClassInfo, "net.minecraft.core.HolderLookup": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeConfig": Internal.ClassInfo, "dev.architectury.registry.registries.options.RegistrarOption": Internal.ClassInfo, "vectorwing.farmersdelight.common.registry.ModRecipeTypes$1": Internal.ClassInfo, "net.minecraft.network.protocol.BundlerInfo$Provider": Internal.ClassInfo, "net.minecraft.world.level.LevelSettings": Internal.ClassInfo, "net.minecraft.world.level.block.PlayerHeadBlock": Internal.ClassInfo, "com.llamalad7.mixinextras.injector.wrapoperation.Operation": Internal.ClassInfo, "net.minecraftforge.common.world.StructureSettingsBuilder$StructureSpawnOverrideBuilder": Internal.ClassInfo, "net.minecraft.commands.CommandFunction": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.LightBlueSprayCanItem": Internal.ClassInfo, "net.minecraft.client.resources.model.ModelState": Internal.ClassInfo, "java.nio.MappedByteBuffer": Internal.ClassInfo, "net.minecraft.client.gui.Font": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityEquipmentContext": Internal.ClassInfo, "cofh.thermal.lib.common.item.EnergyContainerItemAugmentable": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.white.WhiteHangingSignBlock": Internal.ClassInfo, "net.minecraft.client.tutorial.TutorialStepInstance": Internal.ClassInfo, "net.minecraft.util.StringRepresentable": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier3Item": Internal.ClassInfo, "net.minecraftforge.client.extensions.common.IClientBlockExtensions": Internal.ClassInfo, "net.minecraft.server.level.WorldGenRegion": Internal.ClassInfo, "net.minecraftforge.event.village.VillagerTradesEvent": Internal.ClassInfo, "de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget": Internal.ClassInfo, "com.mojang.realmsclient.dto.ReflectionBasedSerialization": Internal.ClassInfo, "net.minecraft.world.entity.Interaction": Internal.ClassInfo, "com.mojang.blaze3d.platform.WindowEventHandler": Internal.ClassInfo, "net.minecraft.world.entity.ai.control.JumpControl": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModLanguageProvider": Internal.ClassInfo, "net.minecraft.world.level.block.entity.SkullBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.Serializer": Internal.ClassInfo, "java.lang.Thread": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemBuilder$UseCallback": Internal.ClassInfo, "net.minecraft.client.renderer.entity.EntityRenderDispatcher": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.ItemOverride": Internal.ClassInfo, "dev.architectury.event.forge.EventHandlerImplCommon$LevelEventAttachment": Internal.ClassInfo, "net.minecraft.world.level.block.CeilingHangingSignBlock": Internal.ClassInfo, "net.minecraft.world.level.block.RodBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.memory.MemoryModuleType": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.ScheduledEvents": Internal.ClassInfo, "net.minecraft.world.level.block.entity.SculkShriekerBlockEntity": Internal.ClassInfo, "java.nio.charset.CharsetDecoder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.RotatedBlockProvider": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortIterable": Internal.ClassInfo, "cofh.lib.common.block.CropBlockMushroom": Internal.ClassInfo, "net.minecraft.CrashReport": Internal.ClassInfo, "com.buuz135.industrial.item.addon.EfficiencyAddonItem": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.tile.TransporterTile": Internal.ClassInfo, "java.util.random.RandomGenerator": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructurePieceAccessor": Internal.ClassInfo, "net.minecraft.world.item.SignApplicator": Internal.ClassInfo, "cofh.thermal.lib.util.recipes.ThermalRecipe": Internal.ClassInfo, "java.lang.invoke.MethodHandle": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityLootContext": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FlaxBlock": Internal.ClassInfo, "net.minecraft.advancements.CriterionProgress": Internal.ClassInfo, "com.hrznstudio.titanium.component.inventory.MultiInventoryComponent$MultiInvCapabilityHandler": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.light_blue.LightBlueStandingSignBlock": Internal.ClassInfo, "java.awt.image.ImageConsumer": Internal.ClassInfo, "com.hrznstudio.titanium.block.tile.PoweredTile": Internal.ClassInfo, "com.buuz135.industrial.block.misc.EnchantmentApplicatorBlock": Internal.ClassInfo, "org.mangorage.mangomultiblock.item.DetectorItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleIterator": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ClientPlayerKJS": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.BlockBreakerTile": Internal.ClassInfo, "net.minecraft.util.ProgressListener": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.RegExFilterItem": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BeehiveBlockEntity$BeeReleaseStatus": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveMirrorStandBlock": Internal.ClassInfo, "net.minecraft.network.chat.SignableCommand": Internal.ClassInfo, "net.minecraftforge.common.world.BiomeSpecialEffectsBuilder": Internal.ClassInfo, "java.util.ImmutableCollections$List12": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.WildRiceBlock": Internal.ClassInfo, "net.minecraft.client.gui.narration.NarratedElementType": Internal.ClassInfo, "io.netty.channel.SimpleChannelInboundHandler": Internal.ClassInfo, "vazkii.patchouli.api.IComponentProcessor": Internal.ClassInfo, "com.benbenlaw.opolisutilities.block.custom.BlockPlacerBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.CustomRecipe": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.Chapter": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$Clamp": Internal.ClassInfo, "cofh.core.common.effect.ShockedMobEffect": Internal.ClassInfo, "net.minecraft.util.valueproviders.IntProvider": Internal.ClassInfo, "net.minecraft.client.renderer.debug.BrainDebugRenderer$PoiInfo": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModFileInfo$LanguageSpec": Internal.ClassInfo, "java.lang.reflect.Method": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaYellowBlock": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.tile.BlackHoleUnitTile": Internal.ClassInfo, "java.util.ImmutableCollections$SetN": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientActionCallback": Internal.ClassInfo, "com.buuz135.industrial.block.generator.BiofuelGeneratorBlock": Internal.ClassInfo, "java.util.Locale$LanguageRange": Internal.ClassInfo, "org.apache.maven.artifact.versioning.ArtifactVersion": Internal.ClassInfo, "com.mojang.brigadier.arguments.ArgumentType": Internal.ClassInfo, "net.minecraftforge.common.capabilities.Capability": Internal.ClassInfo, "net.minecraft.world.item.ItemCooldowns": Internal.ClassInfo, "net.minecraft.world.item.crafting.StonecutterRecipe": Internal.ClassInfo, "dev.latvian.mods.kubejs.script.data.DataPackEventJS": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.FluidGeneratorRecipe": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.integration.forge.FarmersDelightCompatImpl$TomatoRopeBlock": Internal.ClassInfo, "net.minecraft.world.level.block.LanternBlock": Internal.ClassInfo, "net.minecraft.world.item.Tier": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.SlingshotItem": Internal.ClassInfo, "net.minecraft.world.level.block.SporeBlossomBlock": Internal.ClassInfo, "net.minecraft.client.renderer.PostPass": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationController$SoundKeyframeHandler": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundTagQueryPacket": Internal.ClassInfo, "java.awt.image.BufferedImageOp": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityBlockPosLevelContext": Internal.ClassInfo, "net.minecraft.world.phys.HitResult$Type": Internal.ClassInfo, "net.minecraft.network.syncher.SynchedEntityData$DataValue": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.brown.BrownHangingSignBlock": Internal.ClassInfo, "com.google.common.collect.ImmutableList": Internal.ClassInfo, "dev.latvian.mods.kubejs.bindings.JavaWrapper": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.cyan.CyanStandingSignBlock": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.RavagerEntityAccessor": Internal.ClassInfo, "net.minecraft.world.entity.PowerableMob": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.WidgetLayout$Padding": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BaseAxeItem": Internal.ClassInfo, "net.minecraft.client.model.geom.ModelPart$Cube": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.CreateWorldScreen": Internal.ClassInfo, "net.minecraft.server.packs.resources.ResourceManagerReloadListener": Internal.ClassInfo, "java.text.DecimalFormat": Internal.ClassInfo, "net.minecraft.client.resources.model.ModelResourceLocation": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.ConfiguredFeature": Internal.ClassInfo, "com.hrznstudio.titanium.component.IComponentBundle": Internal.ClassInfo, "dev.latvian.mods.rhino.Function": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.GlowstoneFeature": Internal.ClassInfo, "net.liopyu.entityjs.builders.BaseLivingEntityBuilder$CustomInstructionKeyframeEventJS": Internal.ClassInfo, "net.minecraft.world.item.Tiers": Internal.ClassInfo, "net.minecraft.server.packs.repository.RepositorySource": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeSchema": Internal.ClassInfo, "com.mojang.authlib.GameProfileRepository": Internal.ClassInfo, "java.nio.channels.FileChannel$MapMode": Internal.ClassInfo, "cofh.lib.api.item.ICoFHItem": Internal.ClassInfo, "com.hrznstudio.titanium.fluid.TitaniumFluid$Flowing": Internal.ClassInfo, "net.minecraftforge.event.level.LevelEvent": Internal.ClassInfo, "tax.taknax.taxov.block.PirateBlockBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap": Internal.ClassInfo, "java.awt.Event": Internal.ClassInfo, "net.minecraft.world.item.CreativeModeTab$Row": Internal.ClassInfo, "com.google.gson.ExclusionStrategy": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.BombItem": Internal.ClassInfo, "net.minecraft.world.damagesource.DamageScaling": Internal.ClassInfo, "java.text.NumberFormat$Style": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterLogic": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation": Internal.ClassInfo, "com.jtorleonstudios.awesomedungeonocean.AwsOceanBoatStructures$FrigateL": Internal.ClassInfo, "net.minecraft.world.item.crafting.RecipeType$1": Internal.ClassInfo, "net.minecraft.world.item.crafting.RecipeType$2": Internal.ClassInfo, "com.jtorleonstudios.awesomedungeonocean.AwsOceanBoatStructures$FrigateM": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.GenericLootEventJS": Internal.ClassInfo, "net.minecraftforge.client.event.ContainerScreenEvent": Internal.ClassInfo, "com.mojang.serialization.MapDecoder": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.PlantSowerTile": Internal.ClassInfo, "java.lang.Exception": Internal.ClassInfo, "net.minecraft.world.level.levelgen.flat.FlatLayerInfo": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.WandItem": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeAdvancementBuilder": Internal.ClassInfo, "java.beans.PropertyChangeListener": Internal.ClassInfo, "net.minecraft.world.level.block.GravelBlock": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.yellow.YellowWallSignBlock": Internal.ClassInfo, "io.netty.util.concurrent.ProgressivePromise": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler": Internal.ClassInfo, "net.mcreator.cozyhome.block.QuartzDrawerBlock": Internal.ClassInfo, "java.lang.reflect.AnnotatedElement": Internal.ClassInfo, "com.google.common.cache.CacheStats": Internal.ClassInfo, "net.minecraft.world.level.block.CoralWallFanBlock": Internal.ClassInfo, "net.minecraft.commands.arguments.ResourceOrTagKeyArgument$Info": Internal.ClassInfo, "com.mojang.authlib.minecraft.report.ReportChatMessage": Internal.ClassInfo, "net.cursedwarrior.skystructures.world.features.StructureFeature": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.predicate.BlockEntityPredicate": Internal.ClassInfo, "net.minecraft.world.level.block.CartographyTableBlock": Internal.ClassInfo, "net.liopyu.entityjs.events.RegisterSpawnPlacementsEventJS": Internal.ClassInfo, "net.minecraft.world.item.crafting.ShapelessRecipe$Serializer": Internal.ClassInfo, "com.mojang.blaze3d.audio.SoundBuffer": Internal.ClassInfo, "java.lang.module.ResolvedModule": Internal.ClassInfo, "net.minecraft.core.Rotations": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntIterable": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.InputReplacementTransformer$Replacement": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.FluidBlockBuilder": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.loot.EntityWeight": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.BlockStateComponent": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.world.AccessorRecipeManager": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.light_gray.LightGrayHangingSignBlock": Internal.ClassInfo, "net.minecraft.world.ticks.TickContainerAccess": Internal.ClassInfo, "dev.latvian.mods.rhino.GeneratedClassLoader": Internal.ClassInfo, "java.awt.font.GlyphVector": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.ReplaceBlobsFeature": Internal.ClassInfo, "net.minecraft.world.level.ChunkPos": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.BlackHoleControllerBlock": Internal.ClassInfo, "net.minecraft.world.level.block.SkullBlock$Type": Internal.ClassInfo, "net.minecraft.world.level.block.PotatoBlock": Internal.ClassInfo, "net.minecraft.client.searchtree.SearchRegistry": Internal.ClassInfo, "mezz.jei.api.gui.handlers.IGuiProperties": Internal.ClassInfo, "cofh.thermal.cultivation.init.registries.TCulBlocks$3": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2IntMap": Internal.ClassInfo, "cofh.thermal.cultivation.init.registries.TCulBlocks$2": Internal.ClassInfo, "cofh.thermal.cultivation.init.registries.TCulBlocks$1": Internal.ClassInfo, "de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen": Internal.ClassInfo, "net.minecraft.world.entity.monster.CrossbowAttackMob": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.painter.PaintEventJS": Internal.ClassInfo, "net.minecraft.client.particle.ParticleEngine": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexSorting$DistanceFunction": Internal.ClassInfo, "net.minecraft.world.level.block.SpawnerBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingChangeTargetEvent$ILivingTargetType": Internal.ClassInfo, "com.mojang.datafixers.kinds.Kind1": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.StrawBaleBlock": Internal.ClassInfo, "net.minecraft.world.entity.LivingEntity": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchPlankBlock": Internal.ClassInfo, "cofh.thermal.locomotion.init.registries.TLocBlocks$1": Internal.ClassInfo, "cofh.thermal.locomotion.init.registries.TLocBlocks$2": Internal.ClassInfo, "cofh.thermal.locomotion.init.registries.TLocBlocks$3": Internal.ClassInfo, "cofh.thermal.locomotion.init.registries.TLocBlocks$4": Internal.ClassInfo, "net.minecraft.world.item.SaddleItem": Internal.ClassInfo, "cofh.thermal.locomotion.init.registries.TLocBlocks$5": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.ListPoolElement": Internal.ClassInfo, "net.minecraft.world.item.TippedArrowItem": Internal.ClassInfo, "net.liopyu.entityjs.entities.ArrowEntityJS": Internal.ClassInfo, "com.buuz135.industrial.block.generator.BioReactorBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonStrafePlayerPhase": Internal.ClassInfo, "net.minecraft.client.gui.components.CycleButton$ValueListSupplier": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.RichSoilFarmlandBlock": Internal.ClassInfo, "io.netty.channel.ChannelPromise": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.AfterRecipesLoadedEventJS": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModInfo$Ordering": Internal.ClassInfo, "java.lang.invoke.MethodHandleInfo": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.ICookingUpgrade": Internal.ClassInfo, "net.minecraft.client.renderer.LightTexture": Internal.ClassInfo, "com.teammetallurgy.aquaculture.loot.AquaBiomeModifiers$MobSpawnBiomeModifier": Internal.ClassInfo, "java.text.DateFormat": Internal.ClassInfo, "net.minecraft.world.level.storage.PrimaryLevelData$SpecialWorldProperty": Internal.ClassInfo, "java.lang.module.ModuleDescriptor$Opens": Internal.ClassInfo, "net.minecraft.advancements.RequirementsStrategy": Internal.ClassInfo, "net.minecraft.world.item.crafting.CraftingBookCategory": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator": Internal.ClassInfo, "net.minecraftforge.client.event.ContainerScreenEvent$Render$Foreground": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BarrelBlockEntity": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.light_gray.LightGrayStandingSignBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntBidirectionalIterator": Internal.ClassInfo, "cofh.thermal.core.init.registries.TCoreBlocks$5": Internal.ClassInfo, "cofh.thermal.core.init.registries.TCoreBlocks$4": Internal.ClassInfo, "cofh.thermal.core.init.registries.TCoreBlocks$6": Internal.ClassInfo, "net.mcreator.cozyhome.block.LargeDarkOakStumpBlock": Internal.ClassInfo, "cofh.thermal.core.init.registries.TCoreBlocks$1": Internal.ClassInfo, "cofh.thermal.core.init.registries.TCoreBlocks$3": Internal.ClassInfo, "cofh.thermal.core.init.registries.TCoreBlocks$2": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntListIterator": Internal.ClassInfo, "io.netty.buffer.PoolChunkMetric": Internal.ClassInfo, "com.probejs.jdoc.jsgen.DocGenerationEventJS": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.LivingEntityKJS": Internal.ClassInfo, "java.util.regex.Pattern": Internal.ClassInfo, "software.bernie.geckolib.core.animatable.GeoAnimatable": Internal.ClassInfo, "net.minecraft.world.level.StructureManager": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.farmland.IFarmlandConverter": Internal.ClassInfo, "tocraft.walkers.impl.PlayerDataProvider": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.special.ShapedKubeJSRecipe": Internal.ClassInfo, "letsforge_pirates.item.PirateTier1Item$Leggings": Internal.ClassInfo, "java.awt.Rectangle": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.InfinityEnergyStorage": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.RecipeComponent": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.CageItem": Internal.ClassInfo, "mezz.jei.api.gui.ingredient.ICraftingGridHelper": Internal.ClassInfo, "net.minecraft.client.renderer.debug.BrainDebugRenderer$BrainDump": Internal.ClassInfo, "mezz.jei.api.gui.ingredient.IRecipeSlotDrawable": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType": Internal.ClassInfo, "net.minecraftforge.common.world.BiomeModifier$Phase": Internal.ClassInfo, "net.minecraft.client.resources.SkinManager$SkinTextureCallback": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityPoseDimensionsContext": Internal.ClassInfo, "com.buuz135.industrial.recipe.StoneWorkGenerateRecipe": Internal.ClassInfo, "net.minecraft.world.level.material.Fluid": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.misc.IMapDataPacketExtension": Internal.ClassInfo, "java.util.LongSummaryStatistics": Internal.ClassInfo, "dev.latvian.mods.kubejs.script.PlatformWrapper": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.color.SimpleColor": Internal.ClassInfo, "java.awt.geom.Line2D": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedBucketItemExtension": Internal.ClassInfo, "com.hrznstudio.titanium.block.RotatableBlock$RotationType": Internal.ClassInfo, "net.minecraft.world.entity.Targeting": Internal.ClassInfo, "dev.ftb.mods.ftbteams.api.property.TeamPropertyArgument": Internal.ClassInfo, "java.awt.event.InputMethodEvent": Internal.ClassInfo, "net.minecraft.world.item.crafting.Recipe": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.LootTablesKJS": Internal.ClassInfo, "com.mojang.serialization.Keyable": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundInteractPacket$Handler": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BaseShearsItem": Internal.ClassInfo, "net.minecraftforge.event.entity.living.MobEffectEvent$Remove": Internal.ClassInfo, "java.io.InputStream": Internal.ClassInfo, "net.minecraft.world.ticks.ScheduledTick": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.events.IFireConsumeBlockEvent": Internal.ClassInfo, "net.minecraft.world.level.block.FenceGateBlock": Internal.ClassInfo, "net.minecraft.world.phys.AABB": Internal.ClassInfo, "com.hrznstudio.titanium.datagenerator.loot.block.IBlockLootTableProvider": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSwingPacket": Internal.ClassInfo, "cofh.lib.common.block.CropBlockCoFH": Internal.ClassInfo, "de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinMinecraft": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.core.ItemFTBL": Internal.ClassInfo, "net.minecraft.world.item.GameMasterBlockItem": Internal.ClassInfo, "com.hrznstudio.titanium.component.fluid.FluidTankComponent": Internal.ClassInfo, "java.util.Map": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper": Internal.ClassInfo, "com.buuz135.industrial.item.MobImprisonmentToolItem": Internal.ClassInfo, "net.minecraft.client.renderer.entity.EntityRenderer": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction$Builder": Internal.ClassInfo, "net.minecraft.world.inventory.RecipeBookType": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPlayerActionPacket": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator": Internal.ClassInfo, "it.hurts.sskirillss.octolib.particle.BasicColoredParticle$Options": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.IronGateBlock": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier3Item$Boots": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer": Internal.ClassInfo, "java.util.stream.Stream": Internal.ClassInfo, "net.minecraft.world.entity.Marker": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.RichSoilBlock": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.init.ModFluidTypes$1": Internal.ClassInfo, "com.blamejared.controlling.mixin.AccessScreen": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.BlockBreakerBlock": Internal.ClassInfo, "com.mojang.datafixers.util.Function8": Internal.ClassInfo, "net.minecraft.commands.CommandSourceStack": Internal.ClassInfo, "com.mojang.datafixers.util.Function9": Internal.ClassInfo, "com.mojang.datafixers.util.Function4": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier3Item$Leggings": Internal.ClassInfo, "com.mojang.datafixers.util.Function5": Internal.ClassInfo, "com.mojang.datafixers.util.Function6": Internal.ClassInfo, "mcjty.theoneprobe.items.ProbeNote": Internal.ClassInfo, "com.mojang.datafixers.util.Function7": Internal.ClassInfo, "de.keksuccino.fancymenu.util.resource.PlayableResource": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.ShulkerAccessor": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelData": Internal.ClassInfo, "com.mojang.datafixers.util.Function3": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.ComponentValueMap": Internal.ClassInfo, "org.lwjgl.system.NativeResource": Internal.ClassInfo, "net.minecraft.world.entity.Display$TextDisplay$CachedLine": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.CursorType": Internal.ClassInfo, "net.minecraft.data.loot.BlockLootSubProvider": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructureSet$StructureSelectionEntry": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket": Internal.ClassInfo, "net.minecraft.world.level.block.TntBlock": Internal.ClassInfo, "net.minecraft.world.item.CreativeModeTab$Type": Internal.ClassInfo, "letsforge_pirates.item.Skull4Item": Internal.ClassInfo, "letsforge_pirates.item.CraftsmanItem$Chestplate": Internal.ClassInfo, "net.minecraft.world.level.gameevent.vibrations.VibrationInfo": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.CabinetBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.RayTraceResultJS": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$AwakenedSupremium": Internal.ClassInfo, "net.minecraft.world.level.block.DoorBlock": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BrewingStandBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.ShapedBlockBuilder": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.EssenceVesselBlock": Internal.ClassInfo, "com.probejs.jdoc.ISerde": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingDropsEvent": Internal.ClassInfo, "net.minecraft.client.gui.font.glyphs.BakedGlyph$Effect": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleCollection": Internal.ClassInfo, "com.hrznstudio.titanium.api.redstone.IRedstoneAction": Internal.ClassInfo, "io.netty.util.AbstractConstant": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2DoubleFunction": Internal.ClassInfo, "net.minecraftforge.client.IArmPoseTransformer": Internal.ClassInfo, "java.awt.image.WritableRenderedImage": Internal.ClassInfo, "dev.latvian.mods.kubejs.platform.forge.ingredient.KubeJSIngredient": Internal.ClassInfo, "net.minecraft.world.entity.raid.Raid": Internal.ClassInfo, "com.probejs.jdoc.java.ConstructorInfo": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.ExperienceCapsuleItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ByteFunction": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.util.MachineUpgradeTier": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootContext$EntityTarget": Internal.ClassInfo, "java.util.concurrent.ConcurrentHashMap": Internal.ClassInfo, "cofh.thermal.core.common.item.DivingArmorItem": Internal.ClassInfo, "net.minecraft.util.profiling.ResultField": Internal.ClassInfo, "net.minecraft.world.entity.animal.Cow": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.SuperHomeStoneItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeWrapper$TargetSlot": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.creativetab.CreativeTabEvent": Internal.ClassInfo, "net.minecraft.world.inventory.Slot": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$VisualContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blending.Blender": Internal.ClassInfo, "net.minecraft.world.level.levelgen.synth.BlendedNoise": Internal.ClassInfo, "net.minecraft.world.entity.animal.Cod": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.BoundingBox": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.WorldCreationUiState$SelectedGameMode": Internal.ClassInfo, "net.minecraft.world.entity.ai.gossip.GossipType": Internal.ClassInfo, "net.blay09.mods.balm.mixin.ScreenAccessor": Internal.ClassInfo, "cofh.lib.api.block.IHarvestable": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent": Internal.ClassInfo, "vectorwing.farmersdelight.common.crafting.CookingPotRecipe": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntitySqrDistanceContext": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2ObjectMap$Entry": Internal.ClassInfo, "com.mojang.blaze3d.vertex.BufferBuilder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.KelpFeature": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$PlayerEntityContext": Internal.ClassInfo, "java.util.concurrent.CompletableFuture": Internal.ClassInfo, "net.minecraftforge.common.crafting.AbstractIngredient": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier2Item": Internal.ClassInfo, "net.minecraft.world.item.PotionItem": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryChairBlock": Internal.ClassInfo, "javax.crypto.Cipher": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.FillLayerFeature": Internal.ClassInfo, "earth.terrarium.chipped.common.recipes.ChippedRecipe$Serializer": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundServerDataPacket": Internal.ClassInfo, "dev.ftb.mods.ftbquests.integration.RecipeModHelper$Components": Internal.ClassInfo, "net.mcreator.cozyhome.block.LargeWarpedFungusBlock": Internal.ClassInfo, "net.minecraft.world.entity.projectile.EyeOfEnder": Internal.ClassInfo, "net.minecraft.world.level.PathNavigationRegion": Internal.ClassInfo, "org.slf4j.Logger": Internal.ClassInfo, "earth.terrarium.chipped.common.registry.ModRecipeTypes$1": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundUpdateTagsPacket": Internal.ClassInfo, "net.minecraft.world.level.levelgen.WorldgenRandom": Internal.ClassInfo, "net.minecraftforge.entity.PartEntity": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.response.Response": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterColorHandlersEvent$Item": Internal.ClassInfo, "net.minecraft.advancements.AdvancementRewards$Builder": Internal.ClassInfo, "net.minecraft.world.level.block.AnvilBlock": Internal.ClassInfo, "com.google.common.collect.ImmutableMap$Builder": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectListIterator": Internal.ClassInfo, "com.mojang.authlib.minecraft.MinecraftProfileTexture": Internal.ClassInfo, "com.hrznstudio.titanium.component.button.ButtonComponent": Internal.ClassInfo, "software.bernie.geckolib.core.object.PlayState": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.INetworked": Internal.ClassInfo, "net.minecraft.server.Services": Internal.ClassInfo, "dev.latvian.mods.kubejs.thermal.ThermalRecipeJS": Internal.ClassInfo, "net.minecraft.client.renderer.MultiBufferSource$BufferSource": Internal.ClassInfo, "net.minecraft.server.packs.PackType": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.misc.IExtendedItem": Internal.ClassInfo, "net.liopyu.entityjs.builders.BaseLivingEntityBuilder": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.PrepareRamNearestTarget": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseDragged": Internal.ClassInfo, "java.util.regex.Matcher": Internal.ClassInfo, "java.text.FieldPosition": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.WithAttachedData": Internal.ClassInfo, "net.minecraft.world.level.block.TallGrassBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration": Internal.ClassInfo, "net.minecraft.client.renderer.LevelRenderer": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleListIterator": Internal.ClassInfo, "earth.terrarium.chipped.common.recipes.ChippedRecipe": Internal.ClassInfo, "net.minecraftforge.network.NetworkEvent$Context": Internal.ClassInfo, "net.minecraft.network.protocol.status.ServerStatus$Version": Internal.ClassInfo, "net.minecraft.commands.arguments.TimeArgument": Internal.ClassInfo, "net.minecraft.world.entity.projectile.EvokerFangs": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.ZombieHorse": Internal.ClassInfo, "vazkii.patchouli.client.book.EntryDisplayState": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.SpinefishItem": Internal.ClassInfo, "earth.terrarium.chipped.common.blocks.SpecialLanternBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.Hash$Strategy": Internal.ClassInfo, "cofh.thermal.core.common.item.XpCrystalItem": Internal.ClassInfo, "net.minecraftforge.server.command.EnumArgument$Info$Template": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier1Item$Leggings": Internal.ClassInfo, "net.minecraft.server.ServerScoreboard": Internal.ClassInfo, "net.minecraft.world.level.GameRules$Value": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.LayerConfiguration": Internal.ClassInfo, "net.minecraft.world.entity.ReputationEventHandler": Internal.ClassInfo, "it.hurts.sskirillss.octolib.particle.BasicColoredParticle$Constructor$ConstructorBuilder": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2LongFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.placement.StructurePlacement": Internal.ClassInfo, "letsforge_pirates.item.CraftsmanItem": Internal.ClassInfo, "com.hrznstudio.titanium.api.ISpecialCreativeTabItem": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IModFileInfo": Internal.ClassInfo, "net.minecraft.network.chat.Component": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicBase": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.VariantBlockStateGenerator$Variant": Internal.ClassInfo, "dev.latvian.mods.kubejs.generator.AssetJsonGenerator": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerInteractEvent$LeftClickEmpty": Internal.ClassInfo, "java.awt.event.MouseMotionListener": Internal.ClassInfo, "net.liopyu.entityjs.events.BuildBrainProviderEventJS": Internal.ClassInfo, "com.mojang.brigadier.exceptions.CommandSyntaxException": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.InteractWithDoor": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.WidgetLayout$Vertical": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.QuestObjectType": Internal.ClassInfo, "net.minecraft.util.valueproviders.SampledFloat": Internal.ClassInfo, "cofh.core.client.particle.options.CoFHParticleOptions": Internal.ClassInfo, "tfar.dankstorage.item.DankItem": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.PurpleSprayCanItem": Internal.ClassInfo, "net.minecraft.client.OptionInstance$CycleableValueSet$ValueSetter": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.BlackHoleUnitBlock$BlackHoleUnitItem": Internal.ClassInfo, "net.minecraft.world.level.GameRules$IntegerValue": Internal.ClassInfo, "cofh.lib.util.recipes.SerializableRecipeType": Internal.ClassInfo, "net.mcreator.cozyhome.block.WhiteLampBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.MonsterRoomFeature": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.AndRecipeComponent": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveTableBlock": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeSpecialEffects$Builder": Internal.ClassInfo, "com.mojang.blaze3d.shaders.Effect": Internal.ClassInfo, "org.lwjgl.system.CustomBuffer": Internal.ClassInfo, "com.mojang.authlib.UserAuthentication": Internal.ClassInfo, "net.minecraftforge.common.ForgeMod$3": Internal.ClassInfo, "net.minecraftforge.common.ForgeMod$4": Internal.ClassInfo, "net.minecraftforge.common.ForgeMod$1": Internal.ClassInfo, "net.minecraftforge.common.ForgeMod$2": Internal.ClassInfo, "net.darkhax.attributefix.mixin.AccessorRangedAttribute": Internal.ClassInfo, "journeymap.client.api.display.IThemeButton$Action": Internal.ClassInfo, "net.minecraft.world.inventory.GrindstoneMenu": Internal.ClassInfo, "net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions": Internal.ClassInfo, "com.google.common.collect.ForwardingObject": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaCounterBlock": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.PotionBrewerTile": Internal.ClassInfo, "de.keksuccino.fancymenu.util.resource.resources.audio.PlayableResourceWithAudio": Internal.ClassInfo, "letsforge_pirates.item.Merchant3Item$Leggings": Internal.ClassInfo, "net.minecraft.network.chat.ClickEvent$Action": Internal.ClassInfo, "com.google.common.reflect.Parameter": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelSummary": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.functions.CopyNameFunction$NameSource": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.misc.mob_container.IMobContainerProvider": Internal.ClassInfo, "net.minecraft.world.inventory.ContainerSynchronizer": Internal.ClassInfo, "net.minecraft.world.effect.MobEffectCategory": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.ConfigValue": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampArchFeature": Internal.ClassInfo, "net.minecraft.util.valueproviders.ClampedNormalFloat": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.FarmlandTillRecipe$Serializer": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2ObjectFunction": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.painter.screen.PaintScreenEventJS": Internal.ClassInfo, "lykrast.glassential.blocks.TooltipGlassBlock": Internal.ClassInfo, "mezz.jei.api.helpers.IPlatformFluidHelper": Internal.ClassInfo, "net.minecraft.world.entity.ai.village.ReputationEventType": Internal.ClassInfo, "net.minecraft.world.level.block.LightningRodBlock": Internal.ClassInfo, "net.minecraft.world.item.FireworkRocketItem": Internal.ClassInfo, "java.util.function.IntUnaryOperator": Internal.ClassInfo, "vazkii.patchouli.mixin.client.AccessorKeyMapping": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.RecipeSchemaType": Internal.ClassInfo, "net.minecraftforge.common.util.NonNullSupplier": Internal.ClassInfo, "com.electronwill.nightconfig.core.Config$Entry": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SignPostBlock": Internal.ClassInfo, "java.lang.Integer": Internal.ClassInfo, "net.mcreator.cozyhome.block.GlassChairBlock": Internal.ClassInfo, "net.minecraft.client.searchtree.SearchRegistry$TreeBuilderSupplier": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2ByteFunction": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.FlagItem": Internal.ClassInfo, "net.minecraft.world.level.pathfinder.Target": Internal.ClassInfo, "org.joml.Vector3i": Internal.ClassInfo, "org.joml.Vector3f": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.NetherForestVegetationFeature": Internal.ClassInfo, "org.joml.Vector3d": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2IntFunction": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.Panel": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket": Internal.ClassInfo, "java.io.Serializable": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2FloatFunction": Internal.ClassInfo, "org.joml.Vector2i": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortIterator": Internal.ClassInfo, "net.minecraftforge.client.textures.ITextureAtlasSpriteLoader": Internal.ClassInfo, "cofh.core.common.item.EnergyContainerItem": Internal.ClassInfo, "org.joml.Vector2f": Internal.ClassInfo, "org.joml.Vector2d": Internal.ClassInfo, "java.awt.dnd.DropTargetListener": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootParams$Builder": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.JarBoatBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.api.IAttackEntityResponseUpgrade": Internal.ClassInfo, "org.moddingx.libx.mod.ModXRegistration": Internal.ClassInfo, "net.minecraft.world.inventory.AbstractContainerMenu": Internal.ClassInfo, "tfar.dankstorage.recipe.UpgradeRecipe": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.NumberConfig": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.Behavior$Status": Internal.ClassInfo, "java.time.LocalDateTime": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerInteractEvent$LeftClickBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket": Internal.ClassInfo, "java.util.function.Supplier": Internal.ClassInfo, "net.minecraft.core.RegistryAccess$1FrozenAccess": Internal.ClassInfo, "com.buuz135.industrial.block.core.tile.LatexProcessingUnitTile": Internal.ClassInfo, "net.minecraft.server.level.ServerPlayer": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeFluidState": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.LargeCarvedTopNoBeardAdaptation": Internal.ClassInfo, "cofh.core.common.item.ItemCoFH": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.Structure$StructureSettings": Internal.ClassInfo, "net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase": Internal.ClassInfo, "net.minecraft.world.item.crafting.BookCloningRecipe": Internal.ClassInfo, "com.mojang.authlib.minecraft.report.AbuseReport": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.EntityPotionEffectsJS": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.MappingRecipeComponent": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Init$Post": Internal.ClassInfo, "dev.latvian.mods.kubejs.script.ScriptType": Internal.ClassInfo, "net.minecraftforge.server.permission.nodes.PermissionType": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable": Internal.ClassInfo, "org.joml.Vector4i": Internal.ClassInfo, "net.minecraft.server.ServerFunctionLibrary": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.BlockComponent": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntSet": Internal.ClassInfo, "org.joml.Vector4f": Internal.ClassInfo, "org.joml.Vector4d": Internal.ClassInfo, "com.jtorleonstudios.libraryferret.blocks.Blocks$1": Internal.ClassInfo, "com.jtorleonstudios.libraryferret.blocks.Blocks$2": Internal.ClassInfo, "com.jtorleonstudios.libraryferret.blocks.Blocks$3": Internal.ClassInfo, "net.minecraft.client.gui.font.glyphs.BakedGlyph": Internal.ClassInfo, "com.jtorleonstudios.libraryferret.blocks.Blocks$4": Internal.ClassInfo, "com.jtorleonstudios.libraryferret.blocks.Blocks$5": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleDrawerBlock": Internal.ClassInfo, "net.minecraft.nbt.IntTag": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.BaseScreen": Internal.ClassInfo, "dev.architectury.hooks.level.biome.GenerationProperties": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.FluidPlacerTile": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.GreenSprayCanItem": Internal.ClassInfo, "com.mojang.datafixers.types.templates.TaggedChoice$TaggedChoiceType": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.CarvingMaskPlacement": Internal.ClassInfo, "net.minecraft.core.Direction8": Internal.ClassInfo, "vazkii.patchouli.client.book.BookCategory": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.XORFilterItem": Internal.ClassInfo, "cofh.thermal.core.common.block.ChargedSoilBlock": Internal.ClassInfo, "io.netty.buffer.AbstractByteBufAllocator": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.AbstractSwampFeature": Internal.ClassInfo, "java.util.function.DoubleToIntFunction": Internal.ClassInfo, "cofh.thermal.innovation.common.item.FluidReservoirItem": Internal.ClassInfo, "java.awt.image.renderable.RenderContext": Internal.ClassInfo, "net.minecraftforge.client.event.ViewportEvent": Internal.ClassInfo, "java.awt.Paint": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.ScatteredOreFeature": Internal.ClassInfo, "com.electronwill.nightconfig.core.file.FileNotFoundAction": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$Tertium": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.IWaxable": Internal.ClassInfo, "net.minecraft.world.level.levelgen.VerticalAnchor": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationController$State": Internal.ClassInfo, "java.awt.Toolkit": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.MushroomColonyBlock": Internal.ClassInfo, "net.minecraftforge.registries.IForgeRegistry$ValidateCallback": Internal.ClassInfo, "cofh.thermal.lib.common.item.InventoryContainerItemAugmentable": Internal.ClassInfo, "com.hrznstudio.titanium.network.locator.PlayerInventoryFinder$IStackModifier": Internal.ClassInfo, "com.google.gson.FieldNamingPolicy": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityItemStackContext": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemTintFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.SnowAndFreezeFeature": Internal.ClassInfo, "letsforge_pirates.item.PirateTier1Item$Boots": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.IntConfig": Internal.ClassInfo, "java.io.PrintStream": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityFallDamageContext": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.api.IEnergyStorageUpgradeWrapper": Internal.ClassInfo, "xueluoanping.fluiddrawerslegacy.block.ItemFluidDrawer": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemEntityInteractedEventJS": Internal.ClassInfo, "dev.architectury.hooks.level.biome.BiomeProperties": Internal.ClassInfo, "java.lang.module.ModuleDescriptor$Builder": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.CropBlockBuilder": Internal.ClassInfo, "net.minecraft.commands.CommandBuildContext": Internal.ClassInfo, "com.mojang.blaze3d.vertex.Tesselator": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaQuartzBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.LargeJungleStumpBlock": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.AbstractHorse": Internal.ClassInfo, "net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent$Click": Internal.ClassInfo, "net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$RenderChunk$ChunkCompileTask": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.light_gray.LightGrayWallSignBlock": Internal.ClassInfo, "com.mojang.realmsclient.gui.RealmsDataFetcher": Internal.ClassInfo, "net.minecraftforge.registries.MissingMappingsEvent": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.SewerBlock": Internal.ClassInfo, "java.awt.event.FocusListener": Internal.ClassInfo, "net.minecraftforge.event.TagsUpdatedEvent$UpdateCause": Internal.ClassInfo, "net.minecraft.network.chat.MessageSignatureCache": Internal.ClassInfo, "net.minecraft.core.Direction$AxisDirection": Internal.ClassInfo, "com.google.gson.ToNumberStrategy": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.predicates.AllOfCondition$Builder": Internal.ClassInfo, "net.minecraft.world.entity.projectile.ShulkerBullet": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BasePickaxeItem": Internal.ClassInfo, "mezz.jei.api.runtime.IEditModeConfig$HideMode": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade": Internal.ClassInfo, "net.minecraft.world.level.material.EmptyFluid": Internal.ClassInfo, "cofh.thermal.core.common.fluid.RedstoneFluid$FluidBlock": Internal.ClassInfo, "net.minecraft.world.damagesource.CombatTracker": Internal.ClassInfo, "net.minecraftforge.fml.DeferredWorkQueue": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.DoNothing": Internal.ClassInfo, "net.minecraft.world.item.trading.Merchant": Internal.ClassInfo, "net.minecraft.world.entity.TraceableEntity": Internal.ClassInfo, "net.minecraft.core.IdMapper": Internal.ClassInfo, "net.minecraft.world.level.levelgen.WorldOptions": Internal.ClassInfo, "net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent": Internal.ClassInfo, "net.minecraft.world.entity.monster.Creeper": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.neptunium.NeptuniumBow": Internal.ClassInfo, "com.hrznstudio.titanium.component.IComponentHarness": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.RopeKnotBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2CharFunction": Internal.ClassInfo, "net.minecraft.world.item.enchantment.Enchantment": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.OrangeSprayCanItem": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.warden.ForceUnmount": Internal.ClassInfo, "net.minecraft.world.level.block.GrassBlock": Internal.ClassInfo, "net.minecraft.world.level.block.BrewingStandBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Finish": Internal.ClassInfo, "net.minecraft.client.particle.ParticleProvider$Sprite": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.item.AccessorItem": Internal.ClassInfo, "java.util.jar.Attributes$Name": Internal.ClassInfo, "java.lang.String": Internal.ClassInfo, "net.minecraft.world.level.gameevent.PositionSource": Internal.ClassInfo, "java.lang.invoke.VarHandle": Internal.ClassInfo, "net.minecraft.commands.arguments.EntityAnchorArgument$Anchor": Internal.ClassInfo, "java.awt.MenuContainer": Internal.ClassInfo, "letsforge_pirates.item.FishermanItem$Chestplate": Internal.ClassInfo, "net.minecraft.client.gui.components.events.GuiEventListener": Internal.ClassInfo, "net.minecraft.world.level.block.CaveVinesBlock": Internal.ClassInfo, "net.minecraft.world.level.block.SnowyDirtBlock": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier1Item$Leggings": Internal.ClassInfo, "net.minecraft.world.entity.Display$ItemDisplay$ItemRenderState": Internal.ClassInfo, "com.benbenlaw.roomopolis.item.custom.RoomKeys.ShortRoomKey": Internal.ClassInfo, "net.minecraftforge.event.entity.player.AttackEntityEvent": Internal.ClassInfo, "net.minecraft.client.renderer.entity.RenderLayerParent": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.FluidComponents$1": Internal.ClassInfo, "net.minecraft.world.entity.projectile.LlamaSpit": Internal.ClassInfo, "net.mcreator.cozyhome.block.DarkOakMirrorStandBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.InSquarePlacement": Internal.ClassInfo, "io.netty.buffer.PoolSubpageMetric": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2LongFunction": Internal.ClassInfo, "net.minecraft.world.item.ScaffoldingBlockItem": Internal.ClassInfo, "net.minecraft.world.inventory.MenuType": Internal.ClassInfo, "net.minecraft.world.entity.LivingEntity$Fallsounds": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2FloatFunction": Internal.ClassInfo, "net.minecraft.client.renderer.debug.VillageSectionsDebugRenderer": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.VillagerTypeBuilder": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.ByteIterable": Internal.ClassInfo, "java.awt.dnd.DragGestureRecognizer": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.PieBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.SmithingTransformRecipe": Internal.ClassInfo, "com.mojang.serialization.Compressable": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LootingLevelEvent": Internal.ClassInfo, "com.gitlab.srcmc.powered_flashlight.forge.items.FlashlightItem": Internal.ClassInfo, "net.minecraft.client.resources.model.ModelBakery": Internal.ClassInfo, "net.minecraft.world.level.block.entity.DecoratedPotBlockEntity$Decorations": Internal.ClassInfo, "net.minecraftforge.client.event.TextureStitchEvent$Post": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.MechanicalDirtBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RegisterNamedRenderTypesEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.EnchantmentBuilder": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseButtonReleased$Pre": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonPlankBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.FloatIterable": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BaseFishingRodItem": Internal.ClassInfo, "net.minecraftforge.client.event.EntityRenderersEvent$RegisterRenderers": Internal.ClassInfo, "java.awt.image.VolatileImage": Internal.ClassInfo, "java.security.Principal": Internal.ClassInfo, "java.awt.Graphics": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.FluidComponents$2": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeBlockEntity": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.TerrainAdjustment": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.predicate.BlockIDPredicate": Internal.ClassInfo, "net.minecraft.world.level.block.LecternBlock": Internal.ClassInfo, "net.minecraft.world.effect.InstantenousMobEffect": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.OutputReplacementTransformer$Replacement": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.WrenchItem": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.misc.IHoldingPlayerExtension": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.StoveBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceDrawerBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.Sensing": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityTypeEntityContext": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.StructureSpawnOverride": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim": Internal.ClassInfo, "net.minecraft.client.particle.ParticleEngine$SpriteParticleRegistration": Internal.ClassInfo, "net.minecraft.client.resources.metadata.animation.AnimationMetadataSection$FrameOutput": Internal.ClassInfo, "net.minecraft.world.level.chunk.CarvingMask": Internal.ClassInfo, "java.util.concurrent.TimeUnit": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.IngredientSupplierKJS": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent": Internal.ClassInfo, "com.blakebr0.cucumber.block.BaseOreBlock": Internal.ClassInfo, "net.minecraft.client.color.block.BlockColors": Internal.ClassInfo, "net.minecraft.world.item.HorseArmorItem": Internal.ClassInfo, "net.minecraft.core.FrontAndTop": Internal.ClassInfo, "com.mojang.blaze3d.vertex.BufferVertexConsumer": Internal.ClassInfo, "dev.architectury.registry.registries.RegistrarManager": Internal.ClassInfo, "java.awt.dnd.DragSourceEvent": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier1Item$Boots": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.WalletItem": Internal.ClassInfo, "net.minecraft.util.profiling.metrics.ProfilerMeasured": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate$StructureEntityInfo": Internal.ClassInfo, "com.obscuria.obscureapi.api.common.classes.Bonus$Type": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider": Internal.ClassInfo, "net.minecraft.server.players.PlayerList": Internal.ClassInfo, "net.minecraft.world.entity.animal.TropicalFish$Pattern": Internal.ClassInfo, "net.minecraft.world.entity.projectile.FireworkRocketEntity": Internal.ClassInfo, "net.minecraft.world.item.crafting.SmithingTrimRecipe": Internal.ClassInfo, "net.liopyu.entityjs.events.BiomeSpawnsEventJS": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Tick": Internal.ClassInfo, "java.nio.channels.spi.AbstractInterruptibleChannel": Internal.ClassInfo, "com.talhanation.smallships.world.item.CannonBallItem": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.IConvertableHorse": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.WorldCreationContext$DimensionsUpdater": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.ItemKJS": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.SpringFeature": Internal.ClassInfo, "org.apache.logging.log4j.util.StringBuilderFormattable": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.AbstractMinecart$Type": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.BooleanComponent": Internal.ClassInfo, "net.minecraft.world.level.block.CampfireBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.compat.chipped.BlockTransformationUpgradeItem": Internal.ClassInfo, "net.minecraftforge.fluids.FluidStack": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.FlowerBoxBlock": Internal.ClassInfo, "net.minecraft.server.packs.resources.Resource": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundUseItemPacket": Internal.ClassInfo, "net.minecraftforge.common.crafting.IIngredientSerializer": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket": Internal.ClassInfo, "net.minecraftforge.event.entity.player.SleepingLocationCheckEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.AwakeningPedestalBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.HandheldItemBuilder": Internal.ClassInfo, "net.minecraft.world.level.Explosion$BlockInteraction": Internal.ClassInfo, "dev.latvian.mods.kubejs.forge.GenericForgeEventConsumer": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.ObjectStartedEvent$QuestEvent": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightCraftingTableBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceDeskBlock": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BrushableBlockEntity": Internal.ClassInfo, "com.buuz135.industrial.item.MeatFeederItem": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.light_blue.LightBlueHangingSignBlock": Internal.ClassInfo, "net.minecraft.client.renderer.GameRenderer": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.DryingTableRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.functions.CopyNbtFunction$Builder": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoSmeltingUpgradeItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.ModelGenerator$Element": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.SewageComposterTile": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceSinkCounterBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate$Palette": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntList": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2ReferenceFunction": Internal.ClassInfo, "cofh.lib.common.block.FeastBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.EssenceWateringCanItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.BlockTintFunction": Internal.ClassInfo, "fonnymunkey.simplehats.common.item.BagItem": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityTeleportEvent$ChorusFruit": Internal.ClassInfo, "java.awt.geom.Point2D": Internal.ClassInfo, "cofh.core.common.enchantment.HoldingEnchantment": Internal.ClassInfo, "net.minecraft.server.PlayerAdvancements": Internal.ClassInfo, "com.hrznstudio.titanium.component.sideness.IFacingComponentHarness": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundBossEventPacket": Internal.ClassInfo, "net.minecraft.server.packs.resources.SimplePreparableReloadListener": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.WallCanvasSignBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2FloatMap": Internal.ClassInfo, "java.util.Locale": Internal.ClassInfo, "java.lang.Short": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.creativetab.CreativeTabContentSupplier": Internal.ClassInfo, "net.minecraft.world.item.ArrowItem": Internal.ClassInfo, "java.util.PrimitiveIterator$OfInt": Internal.ClassInfo, "dev.latvian.mods.rhino.regexp.RegExp": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.functions.CopyNbtFunction$MergeStrategy": Internal.ClassInfo, "com.mojang.serialization.Decoder$Boxed": Internal.ClassInfo, "net.minecraftforge.common.IMinecartCollisionHandler": Internal.ClassInfo, "java.awt.image.RenderedImage": Internal.ClassInfo, "net.mehvahdjukaar.suppsquared.common.LightableLanternBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.InventoryKJS": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.AdultSensor": Internal.ClassInfo, "net.minecraftforge.event.level.NoteBlockEvent": Internal.ClassInfo, "tax.taknax.taxov.item.PirateSuitItem$Helmet": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeBucketPickup": Internal.ClassInfo, "net.minecraft.world.item.ShearsItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.ExplosionEventJS$After": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.SprayerBlock": Internal.ClassInfo, "com.mojang.datafixers.TypedOptic": Internal.ClassInfo, "net.minecraft.world.entity.item.ItemEntity": Internal.ClassInfo, "net.mcreator.cozyhome.block.QuartzSinkCounterBlock": Internal.ClassInfo, "net.minecraft.world.level.pathfinder.NodeEvaluator": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$EmptyTextureStateShard": Internal.ClassInfo, "net.minecraft.client.renderer.RenderType$CompositeState": Internal.ClassInfo, "com.mojang.serialization.codecs.RecordCodecBuilder": Internal.ClassInfo, "net.minecraft.world.level.levelgen.WorldDimensions": Internal.ClassInfo, "net.minecraft.world.entity.monster.Skeleton": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleComparator": Internal.ClassInfo, "net.minecraft.server.players.UserWhiteList": Internal.ClassInfo, "net.liopyu.entityjs.builders.AnimalEntityJSBuilder": Internal.ClassInfo, "net.minecraft.core.Position": Internal.ClassInfo, "com.hrznstudio.titanium.util.FacingUtil$Sideness": Internal.ClassInfo, "java.util.OptionalInt": Internal.ClassInfo, "net.mcreator.cozyhome.block.BambooChairBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.BambooMirrorStandBlock": Internal.ClassInfo, "mezz.jei.api.gui.ingredient.IRecipeSlotView": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongListIterator": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$Ap2": Internal.ClassInfo, "java.awt.im.InputMethodRequests": Internal.ClassInfo, "net.minecraftforge.event.entity.ProjectileImpactEvent$ImpactResult": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.NoteBlockInstrument": Internal.ClassInfo, "net.minecraftforge.fluids.ForgeFlowingFluid$Flowing": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType": Internal.ClassInfo, "java.time.zone.ZoneOffsetTransitionRule$TimeDefinition": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemModelPropertiesEventJS": Internal.ClassInfo, "net.minecraft.world.level.portal.PortalInfo": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssenceStaffItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.Feature": Internal.ClassInfo, "net.minecraft.world.entity.monster.Enemy": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.BlockElement": Internal.ClassInfo, "net.minecraft.client.gui.components.toasts.Toast": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.NearestBedSensor": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityTeleportEvent": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertGiantTorchFeature": Internal.ClassInfo, "com.google.common.cache.LoadingCache": Internal.ClassInfo, "net.minecraft.client.renderer.debug.BeeDebugRenderer$BeeInfo": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.InventoryChangedEventJS": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BannerPattern": Internal.ClassInfo, "java.security.SecureRandom": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.fluids.SoftFluid": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.entities.goals.ISuppEvoker": Internal.ClassInfo, "com.buuz135.industrial.block.tile.IndustrialGeneratorTile": Internal.ClassInfo, "mezz.jei.api.gui.handlers.IGhostIngredientHandler": Internal.ClassInfo, "net.minecraft.client.resources.sounds.TickableSoundInstance": Internal.ClassInfo, "java.lang.reflect.Executable": Internal.ClassInfo, "lykrast.glassential.blocks.DarkEtherealGlassBlock": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.CustomTaskEvent": Internal.ClassInfo, "com.mojang.realmsclient.gui.task.DataFetcher$Subscription": Internal.ClassInfo, "net.minecraft.world.entity.decoration.GlowItemFrame": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryProperty$Exporter": Internal.ClassInfo, "net.minecraft.world.effect.HealthBoostMobEffect": Internal.ClassInfo, "net.minecraft.world.level.levelgen.DensityFunctions$TwoArgumentSimpleFunction": Internal.ClassInfo, "org.joml.Matrix3x2dc": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration": Internal.ClassInfo, "net.minecraft.world.item.enchantment.DamageEnchantment": Internal.ClassInfo, "org.apache.commons.lang3.function.TriFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.MegaJungleTrunkPlacer": Internal.ClassInfo, "com.hrznstudio.titanium.api.IRecipeProvider": Internal.ClassInfo, "net.minecraft.world.item.FireChargeItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration": Internal.ClassInfo, "net.minecraft.world.entity.monster.SpellcasterIllager$IllagerSpell": Internal.ClassInfo, "net.minecraft.world.item.DyeableLeatherItem": Internal.ClassInfo, "com.mojang.blaze3d.vertex.DefaultedVertexConsumer": Internal.ClassInfo, "java.awt.GraphicsDevice$WindowTranslucency": Internal.ClassInfo, "net.minecraft.client.renderer.entity.EntityRendererProvider": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Start": Internal.ClassInfo, "net.minecraftforge.client.event.InputEvent": Internal.ClassInfo, "java.awt.dnd.DragSourceListener": Internal.ClassInfo, "net.minecraft.world.entity.monster.MagmaCube": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.GeodeFeature": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket": Internal.ClassInfo, "net.minecraft.world.level.block.state.BlockBehaviour$StatePredicate": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundRenameItemPacket": Internal.ClassInfo, "io.netty.channel.MessageSizeEstimator$Handle": Internal.ClassInfo, "com.buuz135.industrial.block.generator.MycelialReactorBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.living.PotionColorCalculationEvent": Internal.ClassInfo, "dev.latvian.mods.rhino.ErrorReporter": Internal.ClassInfo, "com.hrznstudio.titanium.api.client.assets.types.ITankAsset": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.purple.PurpleWallHangingSignBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.MegaJungleFoliagePlacer": Internal.ClassInfo, "net.mcreator.cozyhome.block.BlueLampBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.OrRecipeComponent": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.painter.PainterObject": Internal.ClassInfo, "org.joml.Matrix3x2fc": Internal.ClassInfo, "dev.ftb.mods.ftbxmodcompat.ftbteams.kubejs.PlayerTeamEventJS": Internal.ClassInfo, "java.nio.channels.CompletionHandler": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.EndermanHeadItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.RecipeComponentBuilder": Internal.ClassInfo, "net.minecraft.server.packs.resources.ResourceProvider": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonDrawerBlock": Internal.ClassInfo, "net.minecraft.client.model.geom.builders.CubeDefinition": Internal.ClassInfo, "cofh.core.common.block.SignalAirBlock": Internal.ClassInfo, "java.util.function.IntConsumer": Internal.ClassInfo, "java.util.AbstractList": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier2Item$Leggings": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade$TankRenderInfo": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.parameters.LootContextParamSet$Builder": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties$Topping": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeAccessModifier": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundContainerClosePacket": Internal.ClassInfo, "com.electronwill.nightconfig.core.io.ConfigParser": Internal.ClassInfo, "net.minecraft.world.entity.player.ProfilePublicKey$Data": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObjectList": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.rootplacers.MangroveRootPlacer": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.MobDuplicatorBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeWrapper$SmokingUpgradeWrapper": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.world.modifiers.NetherProsperityOreModifier": Internal.ClassInfo, "it.hurts.sskirillss.octolib.particle.BasicColoredParticle$Constructor": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket": Internal.ClassInfo, "net.minecraftforge.items.wrapper.RecipeWrapper": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeDimensionSpecialEffects": Internal.ClassInfo, "journeymap.client.api.display.Context": Internal.ClassInfo, "java.awt.datatransfer.DataFlavor": Internal.ClassInfo, "com.mojang.brigadier.exceptions.SimpleCommandExceptionType": Internal.ClassInfo, "net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset": Internal.ClassInfo, "java.lang.constant.ConstantDesc": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket": Internal.ClassInfo, "net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$ChunkTaskResult": Internal.ClassInfo, "net.minecraftforge.client.event.TextureStitchEvent": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseButtonReleased": Internal.ClassInfo, "org.moddingx.libx.impl.crafting.recipe.EmptyRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.scores.criteria.ObjectiveCriteria": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer": Internal.ClassInfo, "de.keksuccino.konkrete.events.ScreenTickEvent": Internal.ClassInfo, "com.probejs.jdoc.document.DocumentConstructor": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket": Internal.ClassInfo, "dev.latvian.mods.rhino.IdFunctionCall": Internal.ClassInfo, "com.mojang.datafixers.types.Type$Mu": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeItem": Internal.ClassInfo, "java.nio.file.attribute.AttributeView": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundLoginPacket": Internal.ClassInfo, "net.minecraft.server.packs.repository.PackCompatibility": Internal.ClassInfo, "com.benbenlaw.roomopolis.item.custom.RoomKeys.RoomTopperKey": Internal.ClassInfo, "net.minecraftforge.forgespi.language.ModFileScanData$ClassData": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundUpdateEnabledFeaturesPacket": Internal.ClassInfo, "net.minecraft.client.renderer.ItemInHandRenderer": Internal.ClassInfo, "net.minecraft.client.telemetry.events.GameLoadTimesEvent$Measurement": Internal.ClassInfo, "com.hrznstudio.titanium.block.BasicBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.world.modifiers.SoulstoneModifier": Internal.ClassInfo, "net.minecraft.world.item.LeadItem": Internal.ClassInfo, "net.minecraft.client.renderer.block.BlockModelShaper": Internal.ClassInfo, "letsforge_pirates.item.Merchant3Item": Internal.ClassInfo, "cofh.lib.api.ITNTFactory": Internal.ClassInfo, "net.minecraft.world.level.block.state.BlockBehaviour$Properties": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.wrapper.UUIDWrapper": Internal.ClassInfo, "org.apache.logging.slf4j.Log4jLogger": Internal.ClassInfo, "com.probejs.jdoc.document.AbstractDocumentBase": Internal.ClassInfo, "net.minecraft.world.level.biome.Climate$ParameterPoint": Internal.ClassInfo, "net.minecraft.world.level.block.SculkShriekerBlock": Internal.ClassInfo, "net.minecraft.world.level.CommonLevelAccessor": Internal.ClassInfo, "cpw.mods.jarhandling.SecureJar$Status": Internal.ClassInfo, "net.minecraft.world.entity.Attackable": Internal.ClassInfo, "com.mojang.serialization.DynamicLike": Internal.ClassInfo, "net.minecraft.world.item.ItemNameBlockItem": Internal.ClassInfo, "net.minecraft.world.flag.FeatureFlagSet": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingEvent$LivingVisibilityEvent": Internal.ClassInfo, "com.buuz135.industrial.item.IFCustomItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.CoralClawFeature": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BedBlockEntity": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.WildFlaxBlock": Internal.ClassInfo, "net.minecraftforge.common.world.ModifiableBiomeInfo": Internal.ClassInfo, "net.minecraft.network.chat.HoverEvent$EntityTooltipInfo": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.item.CreativeEssenceItem": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers": Internal.ClassInfo, "net.minecraftforge.registries.ForgeRegistry": Internal.ClassInfo, "net.minecraft.server.network.TextFilter": Internal.ClassInfo, "net.minecraft.world.item.crafting.CampfireCookingRecipe": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.ConveyorBlock$ConveyorItem": Internal.ClassInfo, "com.mojang.datafixers.types.Type": Internal.ClassInfo, "java.time.temporal.TemporalAccessor": Internal.ClassInfo, "net.minecraft.client.model.geom.builders.MeshDefinition": Internal.ClassInfo, "sun.awt.SunHints$Key": Internal.ClassInfo, "com.mojang.datafixers.kinds.Functor": Internal.ClassInfo, "java.util.function.ToLongBiFunction": Internal.ClassInfo, "net.liopyu.entityjs.entities.IProjectileEntityJS": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.BlockPosTracker": Internal.ClassInfo, "org.apache.maven.artifact.resolver.filter.ArtifactFilter": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceCounterBlock": Internal.ClassInfo, "eutros.framedcompactdrawers.block.BlockCompDrawersCustom": Internal.ClassInfo, "net.minecraft.world.level.block.DoubleBlockCombiner$BlockType": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundLightUpdatePacket": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObject2IntMap": Internal.ClassInfo, "net.minecraft.world.level.WorldDataConfiguration": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortComparator": Internal.ClassInfo, "net.minecraft.world.level.block.SmokerBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeWrapper": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoSmokingUpgradeItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.NumberComponent$DoubleRange": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSystemChatPacket": Internal.ClassInfo, "com.blakebr0.cucumber.event.RecipeManagerLoadingEvent": Internal.ClassInfo, "earth.terrarium.chipped.common.blocks.DirectionBlock": Internal.ClassInfo, "net.minecraftforge.event.level.NoteBlockEvent$Note": Internal.ClassInfo, "java.awt.event.MouseWheelListener": Internal.ClassInfo, "net.minecraft.core.particles.ParticleTypes$1": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.EnchanterRecipe": Internal.ClassInfo, "io.netty.util.concurrent.Future": Internal.ClassInfo, "net.minecraft.world.effect.AttackDamageMobEffect": Internal.ClassInfo, "net.minecraft.world.level.chunk.CarvingMask$Mask": Internal.ClassInfo, "net.minecraft.world.entity.item.FallingBlockEntity": Internal.ClassInfo, "com.google.gson.JsonObject": Internal.ClassInfo, "net.minecraft.client.gui.narration.NarrationSupplier": Internal.ClassInfo, "cofh.lib.util.recipes.SerializableRecipe": Internal.ClassInfo, "net.minecraft.client.renderer.debug.PathfindingRenderer": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.SandyShrubBlock": Internal.ClassInfo, "vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssenceSickleItem": Internal.ClassInfo, "net.minecraft.client.renderer.OutlineBufferSource": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock": Internal.ClassInfo, "net.minecraft.world.level.BlockGetter": Internal.ClassInfo, "java.util.AbstractCollection": Internal.ClassInfo, "java.awt.event.ComponentListener": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.BaseFilterItem": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootPool$Builder": Internal.ClassInfo, "letsforge_pirates.item.Merchant2Item$Helmet": Internal.ClassInfo, "net.minecraft.client.RecipeBookCategories": Internal.ClassInfo, "com.yungnickyoung.minecraft.betteroceanmonuments.mixin.accessor.WorldGenRegionAccessor": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.gen.filter.biome.BiomeFilter": Internal.ClassInfo, "java.util.zip.ZipFile": Internal.ClassInfo, "mcjty.theoneprobe.items.Probe": Internal.ClassInfo, "vazkii.patchouli.client.book.BookContents": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.SprayCanRemoverItem": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationProcessor$QueuedAnimation": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.worldgen.WaySignStructure": Internal.ClassInfo, "net.minecraft.world.item.TooltipFlag$Default": Internal.ClassInfo, "mezz.jei.api.recipe.IFocus": Internal.ClassInfo, "com.obscuria.obscureapi.common.enchantments.MirrorEnchantment": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.icon.Drawable": Internal.ClassInfo, "java.io.DataInput": Internal.ClassInfo, "net.minecraft.stats.RecipeBookSettings": Internal.ClassInfo, "net.minecraft.world.entity.animal.AbstractFish": Internal.ClassInfo, "net.minecraft.world.entity.animal.PolarBear": Internal.ClassInfo, "net.minecraft.server.MinecraftServer$ServerResourcePackInfo": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.LimeSprayCanItem": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$TargetChangeContext": Internal.ClassInfo, "net.minecraft.server.bossevents.CustomBossEvents": Internal.ClassInfo, "net.minecraft.client.gui.screens.Overlay": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure": Internal.ClassInfo, "java.util.function.Function": Internal.ClassInfo, "java.util.function.BiPredicate": Internal.ClassInfo, "java.lang.Boolean": Internal.ClassInfo, "com.obscuria.obscureapi.api.common.classes.ObscureClass": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ByteMap$FastEntrySet": Internal.ClassInfo, "net.minecraft.world.level.material.WaterFluid": Internal.ClassInfo, "java.awt.Component$BaselineResizeBehavior": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.red.RedWallSignBlock": Internal.ClassInfo, "java.security.PublicKey": Internal.ClassInfo, "java.security.AlgorithmParameters": Internal.ClassInfo, "cofh.thermal.cultivation.common.block.PotionCakeBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonDeathPhase": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.enchantment.SoulSiphonerEnchant": Internal.ClassInfo, "com.google.common.collect.ForwardingMultimap": Internal.ClassInfo, "net.minecraft.server.packs.repository.Pack$ResourcesSupplier": Internal.ClassInfo, "net.minecraft.world.entity.animal.axolotl.Axolotl": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.NearestLivingEntitySensor": Internal.ClassInfo, "net.minecraft.world.level.chunk.PalettedContainer$Data": Internal.ClassInfo, "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.FTBQuestsKubeJSPlayerData": Internal.ClassInfo, "net.minecraftforge.common.world.MobSpawnSettingsBuilder": Internal.ClassInfo, "net.minecraft.world.item.CreativeModeTab$DisplayItemsGenerator": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.reward.RewardType$GuiProvider": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryEventInstance": Internal.ClassInfo, "cofh.thermal.core.common.item.RedprintItem": Internal.ClassInfo, "net.minecraft.world.entity.MobType": Internal.ClassInfo, "mezz.jei.api.helpers.IGuiHelper": Internal.ClassInfo, "cofh.core.common.item.InventoryContainerItem": Internal.ClassInfo, "com.electronwill.nightconfig.core.io.ConfigWriter": Internal.ClassInfo, "net.minecraft.world.level.chunk.ChunkSource": Internal.ClassInfo, "com.hrznstudio.titanium.api.augment.IAugmentType": Internal.ClassInfo, "net.minecraft.world.entity.monster.AbstractSkeleton": Internal.ClassInfo, "com.hrznstudio.titanium.recipe.generator.IJSONGenerator": Internal.ClassInfo, "net.minecraft.world.level.block.GlazedTerracottaBlock": Internal.ClassInfo, "java.util.function.LongToIntFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.VoidStartPlatformFeature": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeGenerationSettings": Internal.ClassInfo, "java.util.Spliterator$OfPrimitive": Internal.ClassInfo, "letsforge_pirates.item.PirateTier2Item$Boots": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket$Action": Internal.ClassInfo, "net.minecraft.network.chat.ChatTypeDecoration": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.WallSide": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.MessageSenderKJS": Internal.ClassInfo, "java.awt.event.KeyListener": Internal.ClassInfo, "net.liopyu.entityjs.builders.ArrowEntityBuilder": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.worldgen.RoadSignFeature": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.BlockPileFeature": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseButtonPressed": Internal.ClassInfo, "net.minecraft.server.players.ServerOpList": Internal.ClassInfo, "com.probejs.jdoc.java.ClassInfo": Internal.ClassInfo, "net.minecraft.world.level.block.EnderChestBlock": Internal.ClassInfo, "java.net.URLConnection": Internal.ClassInfo, "mezz.jei.api.runtime.config.IJeiConfigCategory": Internal.ClassInfo, "chiefarug.mods.systeams.SteamFluid$Flowing": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ArrowKnockbackEnchantment": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.integration.forge.FarmersDelightCompatImpl$TomatoStickBlock": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$EntityPlaceEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.fluid.InputFluid": Internal.ClassInfo, "java.lang.module.ModuleDescriptor$Opens$Modifier": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.SinglePieceStructure": Internal.ClassInfo, "java.lang.ModuleLayer$Controller": Internal.ClassInfo, "net.minecraft.world.level.block.state.BlockBehaviour$BlockStateBase": Internal.ClassInfo, "net.minecraft.world.phys.shapes.ArrayVoxelShape": Internal.ClassInfo, "java.lang.RuntimeException": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.MultipartBlockStateGenerator": Internal.ClassInfo, "com.probejs.jdoc.document.DocumentField": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.ModelGenerator$Face": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.featuresize.ThreeLayersFeatureSize": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.RecipeJS": Internal.ClassInfo, "dev.ftb.mods.ftbteams.data.TeamArgument$Info": Internal.ClassInfo, "net.minecraft.world.level.block.entity.TrappedChestBlockEntity": Internal.ClassInfo, "net.minecraft.world.item.enchantment.KnockbackEnchantment": Internal.ClassInfo, "java.awt.RenderingHints$Key": Internal.ClassInfo, "dev.latvian.mods.kubejs.bindings.IngredientWrapper": Internal.ClassInfo, "com.obscuria.obscureapi.common.enchantments.DistanceEnchantment": Internal.ClassInfo, "net.minecraft.client.renderer.texture.TextureAtlas": Internal.ClassInfo, "cofh.thermal.core.util.recipes.device.TreeExtractorMapping": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.TimberFrameItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.integration.forge.jei.HideJEIEventJS": Internal.ClassInfo, "net.minecraft.client.gui.navigation.ScreenPosition": Internal.ClassInfo, "net.minecraft.network.PacketSendListener": Internal.ClassInfo, "net.minecraft.world.item.enchantment.MendingEnchantment": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.set.wood.WoodType": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2FloatFunction": Internal.ClassInfo, "dev.architectury.registry.registries.DeferredSupplier": Internal.ClassInfo, "net.minecraftforge.event.entity.SpawnPlacementRegisterEvent": Internal.ClassInfo, "java.lang.Math": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration": Internal.ClassInfo, "com.hrznstudio.titanium.block.BasicTileBlock": Internal.ClassInfo, "net.minecraft.world.item.crafting.AbstractCookingRecipe": Internal.ClassInfo, "net.minecraftforge.fluids.capability.IFluidHandler$FluidAction": Internal.ClassInfo, "com.electronwill.nightconfig.core.utils.WriterSupplier": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.ServicesKeySet": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.MatchingBlockTagPredicate": Internal.ClassInfo, "com.buuz135.industrial.block.core.FluidExtractorBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonTableBlock": Internal.ClassInfo, "net.minecraft.client.gui.GuiGraphics": Internal.ClassInfo, "net.minecraft.commands.SharedSuggestionProvider$ElementSuggestionType": Internal.ClassInfo, "net.minecraft.server.ServerFunctionManager": Internal.ClassInfo, "net.mcreator.cozyhome.block.QuartzWallClockBlock": Internal.ClassInfo, "net.minecraft.client.renderer.blockentity.BlockEntityRenderer": Internal.ClassInfo, "net.minecraft.world.entity.ai.attributes.AttributeSupplier$Builder": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.FloatIterator": Internal.ClassInfo, "com.buuz135.industrial.item.addon.ProcessingAddonItem": Internal.ClassInfo, "io.netty.channel.ChannelOutboundBuffer": Internal.ClassInfo, "net.minecraft.world.entity.boss.EnderDragonPart": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundDeleteChatPacket": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket": Internal.ClassInfo, "cofh.thermal.cultivation.common.item.WateringCanItem": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntPredicate": Internal.ClassInfo, "net.minecraft.client.ResourceLoadStateTracker": Internal.ClassInfo, "java.awt.color.ColorSpace": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.AbyssalArmorItem": Internal.ClassInfo, "com.mojang.blaze3d.vertex.PoseStack": Internal.ClassInfo, "net.minecraft.client.color.item.ItemColors": Internal.ClassInfo, "com.electrolyte.matc.items.ImperiumCrystal": Internal.ClassInfo, "com.hrznstudio.titanium.component.fluid.FluidTankComponent$Type": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherrySinkCounterBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.NetheriteTrapdoorBlock": Internal.ClassInfo, "com.google.common.cache.LocalCache$LocalLoadingCache": Internal.ClassInfo, "com.buuz135.industrial.block.transportstorage.tile.BlackHoleTankTile": Internal.ClassInfo, "net.minecraftforge.client.ExtendedServerListData": Internal.ClassInfo, "java.awt.DisplayMode": Internal.ClassInfo, "cofh.thermal.lib.util.recipes.MachineRecipeSerializer": Internal.ClassInfo, "letsforge_pirates.item.Skull3Item": Internal.ClassInfo, "net.minecraft.world.item.crafting.ShapedRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.item.DebugStickItem": Internal.ClassInfo, "net.minecraft.world.entity.animal.Fox": Internal.ClassInfo, "com.benbenlaw.strainers.block.custom.WoodenStrainerBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider": Internal.ClassInfo, "net.minecraft.world.entity.monster.Blaze": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.painter.screen.AlignMode": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker": Internal.ClassInfo, "com.google.common.collect.SetMultimap": Internal.ClassInfo, "com.mojang.realmsclient.dto.RealmsServerPing": Internal.ClassInfo, "lykrast.glassential.doors.GlassDoorBlock": Internal.ClassInfo, "io.netty.channel.ChannelConfig": Internal.ClassInfo, "net.mcreator.cozyhome.block.TentOpenBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootDataResolver": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$ProjectileBlockHitContext": Internal.ClassInfo, "net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList": Internal.ClassInfo, "journeymap.client.api.display.ModPopupMenu": Internal.ClassInfo, "net.minecraft.core.particles.ParticleOptions$Deserializer": Internal.ClassInfo, "com.mojang.brigadier.context.CommandContextBuilder": Internal.ClassInfo, "java.awt.Cursor": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.crafting.UpgradeNextTierRecipe$Serializer": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.MachineUpgradeItem": Internal.ClassInfo, "net.minecraft.client.model.geom.EntityModelSet": Internal.ClassInfo, "mezz.jei.api.runtime.IIngredientManager$IIngredientListener": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemPickedUpEventJS": Internal.ClassInfo, "net.minecraft.world.item.BundleItem": Internal.ClassInfo, "java.lang.Long": Internal.ClassInfo, "net.minecraft.world.item.enchantment.TridentChannelingEnchantment": Internal.ClassInfo, "com.buuz135.industrial.block.misc.tile.EnchantmentFactoryTile": Internal.ClassInfo, "net.minecraft.server.players.StoredUserEntry": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2CharFunction": Internal.ClassInfo, "java.awt.MenuShortcut": Internal.ClassInfo, "net.minecraft.world.level.block.entity.JukeboxBlockEntity": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.ILaserBase": Internal.ClassInfo, "net.mcreator.cozyhome.block.QuartzBenchBlock": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeMobEffect": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.CropBlockBuilder$SurviveCallback": Internal.ClassInfo, "net.minecraft.client.NarratorStatus": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.AnimalFeederTile": Internal.ClassInfo, "net.minecraft.nbt.EndTag": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.functions.LootItemFunction$Builder": Internal.ClassInfo, "net.minecraftforge.event.entity.item.ItemEvent": Internal.ClassInfo, "net.minecraftforge.common.util.MutableHashedLinkedMap$BasicStrategy": Internal.ClassInfo, "net.liopyu.entityjs.builders.MobEntityJSBuilder": Internal.ClassInfo, "cofh.thermal.core.common.fluid.LightOilFluid$1": Internal.ClassInfo, "java.awt.Polygon": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier": Internal.ClassInfo, "net.minecraft.core.HolderSet$Named": Internal.ClassInfo, "journeymap.client.api.display.WaypointGroup": Internal.ClassInfo, "fr.iglee42.igleelib.common.blocks.GhostBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.SeagrassFeature": Internal.ClassInfo, "net.minecraft.world.level.lighting.LayerLightEventListener": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.event.data.CustomInstructionKeyframeData": Internal.ClassInfo, "letsforge_pirates.item.SailorNordicTier1Item$Leggings": Internal.ClassInfo, "net.minecraft.world.level.lighting.LightEventListener": Internal.ClassInfo, "net.minecraft.world.level.block.RepeaterBlock": Internal.ClassInfo, "net.minecraftforge.eventbus.api.GenericEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver": Internal.ClassInfo, "net.minecraft.world.level.block.entity.DispenserBlockEntity": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier1Item": Internal.ClassInfo, "java.awt.Stroke": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.ContextMenu": Internal.ClassInfo, "mezz.jei.api.recipe.IRecipeManager": Internal.ClassInfo, "java.nio.channels.ScatteringByteChannel": Internal.ClassInfo, "net.mehvahdjukaar.suppsquared.common.CrimsonLanternBlock": Internal.ClassInfo, "java.nio.file.WatchEvent": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.FertilizedEssenceItem": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.predicates.LootItemCondition": Internal.ClassInfo, "net.minecraftforge.client.model.data.ModelData": Internal.ClassInfo, "net.minecraft.world.level.block.SculkVeinBlock": Internal.ClassInfo, "com.buuz135.industrial.block.MachineFrameBlock": Internal.ClassInfo, "net.minecraft.world.ticks.TickPriority": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.NotPredicate": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerContainerEvent$Close": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.RicePaniclesBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2BooleanFunction": Internal.ClassInfo, "net.minecraft.world.entity.Mob": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.task.TaskType": Internal.ClassInfo, "com.hrznstudio.titanium.component.inventory.InventoryComponent": Internal.ClassInfo, "net.minecraft.nbt.DoubleTag": Internal.ClassInfo, "net.minecraft.world.item.ShieldItem": Internal.ClassInfo, "java.util.function.BiFunction": Internal.ClassInfo, "net.minecraft.world.level.block.SoulFireBlock": Internal.ClassInfo, "tfar.dankstorage.recipe.Serializer2": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2IntFunction": Internal.ClassInfo, "dev.architectury.impl.ItemPropertiesExtensionImpl": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.ConsoleJS": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$LerpToContext": Internal.ClassInfo, "com.google.gson.Gson": Internal.ClassInfo, "io.netty.util.concurrent.OrderedEventExecutor": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.GraySprayCanItem": Internal.ClassInfo, "java.util.function.LongPredicate": Internal.ClassInfo, "net.minecraft.world.level.block.StandingSignBlock": Internal.ClassInfo, "letsforge_pirates.item.Skull5Item$Helmet": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart.ILevelEventRedirect": Internal.ClassInfo, "net.minecraft.client.particle.SingleQuadParticle": Internal.ClassInfo, "net.mcreator.cozyhome.block.BambooPlankBlock": Internal.ClassInfo, "javax.security.auth.Destroyable": Internal.ClassInfo, "cofh.core.common.block.GlowAirBlock": Internal.ClassInfo, "com.benbenlaw.strainers.fluid.BaseFluidType": Internal.ClassInfo, "net.minecraft.network.chat.ChatType": Internal.ClassInfo, "net.minecraftforge.common.ForgeConfigSpec$ConfigValue": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.CustomStatBuilder": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BlockEntityType": Internal.ClassInfo, "net.minecraft.core.particles.ParticleGroup": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemBuilder": Internal.ClassInfo, "net.minecraft.server.players.IpBanListEntry": Internal.ClassInfo, "net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack": Internal.ClassInfo, "net.minecraftforge.registries.IForgeRegistry$ClearCallback": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSetJigsawBlockPacket": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.Double2BooleanFunction": Internal.ClassInfo, "com.google.common.collect.AbstractMultimap": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.BlockModel": Internal.ClassInfo, "net.minecraftforge.event.level.ChunkDataEvent$Load": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.orange.OrangeWallHangingSignBlock": Internal.ClassInfo, "mezz.jei.api.recipe.IRecipeCatalystLookup": Internal.ClassInfo, "net.minecraft.world.level.block.MossBlock": Internal.ClassInfo, "net.minecraft.core.LayeredRegistryAccess": Internal.ClassInfo, "java.awt.font.TextHitInfo": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.ModelGenerator": Internal.ClassInfo, "net.darkhax.bookshelf.impl.data.recipes.crafting.ShapelessDurabilityRecipe": Internal.ClassInfo, "java.util.stream.LongStream$LongMapMultiConsumer": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer": Internal.ClassInfo, "eutros.framedcompactdrawers.recipe.FramingRecipe": Internal.ClassInfo, "journeymap.client.api.display.ThemeButtonDisplay": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.ILightable": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaMagentaBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemStackKey": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo": Internal.ClassInfo, "cofh.core.client.particle.types.ColorParticleType": Internal.ClassInfo, "net.minecraft.world.ticks.ContainerSingleItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.compat.chipped.BlockTransformationUpgradeWrapper": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket$AttributeSnapshot": Internal.ClassInfo, "net.minecraft.world.item.KnowledgeBookItem": Internal.ClassInfo, "com.obscuria.obscureapi.api.BossBarsRenderManager$BossBarRenderer": Internal.ClassInfo, "io.netty.util.ByteProcessor$IndexNotOfProcessor": Internal.ClassInfo, "com.google.gson.reflect.TypeToken": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.gray.GrayHangingSignBlock": Internal.ClassInfo, "net.minecraft.client.model.EntityModel": Internal.ClassInfo, "com.teammetallurgy.aquaculture.block.WormFarmBlock": Internal.ClassInfo, "cofh.core.common.item.XpContainerItem": Internal.ClassInfo, "net.minecraftforge.client.event.InputEvent$MouseButton$Post": Internal.ClassInfo, "net.minecraft.world.level.chunk.PaletteResize": Internal.ClassInfo, "com.mojang.datafixers.TypedOptic$Element": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.item.EssenceAppleItem": Internal.ClassInfo, "net.minecraft.client.model.SkullModelBase": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType": Internal.ClassInfo, "com.mojang.authlib.minecraft.TelemetrySession": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelSummary$BackupStatus": Internal.ClassInfo, "software.bernie.geckolib.core.animation.EasingType": Internal.ClassInfo, "net.liopyu.entityjs.builders.BaseLivingEntityJSBuilder": Internal.ClassInfo, "net.minecraft.world.entity.monster.Drowned": Internal.ClassInfo, "net.mcreator.cozyhome.block.LightBlueLampBlock": Internal.ClassInfo, "java.util.Set": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$BooleanStateShard": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSelectAdvancementsTabPacket": Internal.ClassInfo, "net.minecraft.nbt.LongTag": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.RedstoneSide": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.ChestBoat": Internal.ClassInfo, "net.minecraft.world.entity.PathfinderMob": Internal.ClassInfo, "net.minecraft.world.item.FireworkRocketItem$Shape": Internal.ClassInfo, "net.mcreator.cozyhome.block.ChimneyStonebrickBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RenderPlayerEvent": Internal.ClassInfo, "net.minecraft.world.phys.shapes.CollisionContext": Internal.ClassInfo, "vazkii.patchouli.api.IVariable": Internal.ClassInfo, "com.electronwill.nightconfig.core.file.GenericBuilder": Internal.ClassInfo, "net.minecraft.world.entity.HumanoidArm": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.CogBlock": Internal.ClassInfo, "net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent$Release": Internal.ClassInfo, "net.minecraft.world.level.block.HalfTransparentBlock": Internal.ClassInfo, "dev.latvian.mods.itemfilters.api.StringValueFilterVariant": Internal.ClassInfo, "com.obscuria.obscureapi.api.common.classes.Ability": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.world.feature.SoulstoneFeature": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveDeskBlock": Internal.ClassInfo, "net.minecraft.world.effect.MobEffects$1": Internal.ClassInfo, "net.minecraft.client.ResourceLoadStateTracker$ReloadReason": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.AdvancedLootBoxItem": Internal.ClassInfo, "net.minecraftforge.event.TickEvent$Phase": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakBenchBlock": Internal.ClassInfo, "cofh.thermal.core.common.item.DetonatorItem": Internal.ClassInfo, "net.minecraft.util.random.SimpleWeightedRandomList": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.custom.CropBlockBuilder$ShapeBuilder": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.LightUpWaterBlock": Internal.ClassInfo, "com.buuz135.industrial.capability.tile.BigSidedFluidTankComponent": Internal.ClassInfo, "net.minecraftforge.common.capabilities.ICapabilitySerializable": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder": Internal.ClassInfo, "net.minecraft.world.ticks.LevelChunkTicks": Internal.ClassInfo, "com.buuz135.industrial.block.generator.tile.MycelialReactorTile": Internal.ClassInfo, "net.minecraft.world.item.Vanishable": Internal.ClassInfo, "java.lang.Comparable": Internal.ClassInfo, "net.minecraft.world.level.biome.Climate$Parameter": Internal.ClassInfo, "net.mehvahdjukaar.sawmill.WoodcuttingRecipe": Internal.ClassInfo, "net.minecraft.client.OptionInstance$ValueSet": Internal.ClassInfo, "net.minecraft.client.renderer.DimensionSpecialEffects$SkyType": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.crafting.BasicBackpackRecipe": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.armor.EssenceBootsItem": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.MobDuplicatorTile": Internal.ClassInfo, "net.minecraft.world.entity.SpawnPlacements$Type": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature": Internal.ClassInfo, "cofh.lib.common.item.HangingSignItemCoFH": Internal.ClassInfo, "net.minecraft.world.entity.ai.targeting.TargetingConditions": Internal.ClassInfo, "vazkii.patchouli.api.IComponentRenderContext": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.SimpleLevelEventJS": Internal.ClassInfo, "dev.latvian.mods.unit.Unit": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.StringValueData": Internal.ClassInfo, "net.minecraft.core.SectionPos": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.TerribleArmorItem$Chestplate": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.SlimeEntityAccessor": Internal.ClassInfo, "letsforge_pirates.item.CraftsmanItem$Helmet": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$Clone": Internal.ClassInfo, "net.minecraft.world.level.block.SeaPickleBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$NameFormat": Internal.ClassInfo, "mezz.jei.api.gui.ITickTimer": Internal.ClassInfo, "io.netty.buffer.SizeClassesMetric": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.MarineFisherTile": Internal.ClassInfo, "net.minecraft.core.RegistryAccess$RegistryEntry": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.PopsicleItem": Internal.ClassInfo, "net.minecraft.world.level.storage.LevelStorageSource": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$DeathContext": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.ConditionContainer": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.SkeletonHorse": Internal.ClassInfo, "net.minecraft.world.level.block.state.BlockBehaviour$StateArgumentPredicate": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.OreFeature": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.TatamiMatBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Render": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexSorting": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeWrapper": Internal.ClassInfo, "com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.special.ShapelessKubeJSRecipe": Internal.ClassInfo, "java.awt.event.FocusEvent": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortConsumer": Internal.ClassInfo, "net.minecraftforge.network.NetworkEvent": Internal.ClassInfo, "net.minecraft.world.level.block.entity.EnderChestBlockEntity": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectSortedSet": Internal.ClassInfo, "java.awt.image.SampleModel": Internal.ClassInfo, "dev.latvian.mods.unit.function.FunctionFactory$FuncSupplier": Internal.ClassInfo, "net.minecraft.world.level.biome.MobSpawnSettings": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.FluidSievingMachineTile": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.AquaFishingRodItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.LootEventJS": Internal.ClassInfo, "net.minecraft.core.BlockSource": Internal.ClassInfo, "com.buuz135.industrial.block.misc.EnchantmentFactoryBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.client.MultipartBlockStateGenerator$Part": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe$Serializer": Internal.ClassInfo, "net.minecraft.server.level.ThreadedLevelLightEngine": Internal.ClassInfo, "java.security.SecureRandomParameters": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier2Item$Chestplate": Internal.ClassInfo, "net.minecraft.world.entity.monster.Phantom": Internal.ClassInfo, "com.mojang.realmsclient.gui.task.DataFetcher$Task": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.util.client.PositionedIngredient": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.schema.DynamicRecipeComponent$Factory": Internal.ClassInfo, "net.minecraftforge.common.IExtensibleEnum": Internal.ClassInfo, "net.minecraft.world.entity.ai.memory.WalkTarget": Internal.ClassInfo, "java.util.concurrent.CompletionStage": Internal.ClassInfo, "net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.brown.BrownWallHangingSignBlock": Internal.ClassInfo, "net.minecraft.network.ConnectionProtocol": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.predicate.BlockIDPredicate$PropertyObject": Internal.ClassInfo, "java.awt.PaintContext": Internal.ClassInfo, "com.blamejared.clumps.mixin.ExperienceOrbAccess": Internal.ClassInfo, "java.awt.geom.Dimension2D": Internal.ClassInfo, "java.awt.event.ActionListener": Internal.ClassInfo, "cofh.core.common.effect.LoveMobEffect": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier1Item$Helmet": Internal.ClassInfo, "java.awt.dnd.DragSourceMotionListener": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ProtectionEnchantment$Type": Internal.ClassInfo, "dev.latvian.mods.kubejs.event.EventResult$Type": Internal.ClassInfo, "java.lang.reflect.Constructor": Internal.ClassInfo, "java.util.OptionalLong": Internal.ClassInfo, "java.awt.Dialog$ModalityType": Internal.ClassInfo, "net.minecraftforge.common.ToolAction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.GravityProcessor": Internal.ClassInfo, "org.moddingx.libx.registration.Registerable": Internal.ClassInfo, "com.mojang.brigadier.arguments.LongArgumentType": Internal.ClassInfo, "net.minecraft.world.entity.ai.goal.Goal$Flag": Internal.ClassInfo, "net.minecraft.client.gui.narration.NarrationElementOutput": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleChairBlock": Internal.ClassInfo, "dev.ftb.mods.ftbquests.block.QuestBarrierBlock": Internal.ClassInfo, "cofh.lib.api.StorageGroup": Internal.ClassInfo, "net.minecraft.world.BossEvent$BossBarOverlay": Internal.ClassInfo, "net.minecraftforge.event.entity.living.AnimalTameEvent": Internal.ClassInfo, "net.minecraft.client.tutorial.TutorialSteps": Internal.ClassInfo, "net.minecraft.world.level.gameevent.vibrations.VibrationSelector": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.ExplosionJS": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundGameEventPacket": Internal.ClassInfo, "net.minecraft.util.profiling.metrics.MetricSampler$SamplerResult": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.WildCropBlock": Internal.ClassInfo, "com.mojang.brigadier.exceptions.CommandExceptionType": Internal.ClassInfo, "net.minecraft.server.packs.resources.PreparableReloadListener$PreparationBarrier": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceGrandfatherClockBlock": Internal.ClassInfo, "org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.StrongholdStructure": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.WorldCreationUiState": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionUpgradeItem": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockEntityAccessor": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SpeakerBlock": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.MinecartSpawner": Internal.ClassInfo, "dev.ftb.mods.ftbquests.block.entity.LootCrateOpenerBlockEntity": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.AxeItemBuilder": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.ItemStackConfig": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.orange.OrangeStandingSignBlock": Internal.ClassInfo, "net.minecraft.world.flag.FeatureFlag": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.crafting.BasicBackpackRecipe$Serializer": Internal.ClassInfo, "net.mehvahdjukaar.suppsquared.common.HeavyKeyItem": Internal.ClassInfo, "net.minecraft.world.level.GameRules$GameRuleTypeVisitor": Internal.ClassInfo, "java.awt.Composite": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PermissionsChangedEvent": Internal.ClassInfo, "dev.latvian.mods.kubejs.server.CommandEventJS": Internal.ClassInfo, "net.minecraft.world.entity.monster.hoglin.Hoglin": Internal.ClassInfo, "java.security.Provider": Internal.ClassInfo, "dev.latvian.mods.unit.MutableNumberUnit": Internal.ClassInfo, "com.buuz135.industrial.fluid.OreFluid$Flowing": Internal.ClassInfo, "software.bernie.geckolib.animatable.GeoEntity": Internal.ClassInfo, "net.minecraft.client.model.geom.PartPose": Internal.ClassInfo, "net.minecraft.world.level.block.BambooSaplingBlock": Internal.ClassInfo, "cofh.lib.common.entity.PrimedTntCoFH": Internal.ClassInfo, "net.minecraftforge.common.world.ForgeBiomeModifiers$AddSpawnsBiomeModifier": Internal.ClassInfo, "com.mojang.brigadier.context.ParsedArgument": Internal.ClassInfo, "net.minecraft.CrashReportDetail": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration": Internal.ClassInfo, "net.minecraft.world.WorldlyContainer": Internal.ClassInfo, "de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget": Internal.ClassInfo, "net.minecraft.world.item.FoodOnAStickItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.crafting.SmithingBackpackUpgradeRecipe": Internal.ClassInfo, "net.minecraft.world.level.saveddata.SavedData": Internal.ClassInfo, "net.minecraftforge.event.AddPackFindersEvent": Internal.ClassInfo, "net.minecraft.network.chat.RemoteChatSession": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.CatalogueRecipe": Internal.ClassInfo, "dev.ftb.mods.ftbquests.item.ScreenBlockItem": Internal.ClassInfo, "net.minecraftforge.common.util.NonNullConsumer": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.EnchantmentBuilder$DamageProtectionFunction": Internal.ClassInfo, "net.minecraft.world.level.material.LavaFluid": Internal.ClassInfo, "net.minecraft.world.level.levelgen.GenerationStep$Decoration": Internal.ClassInfo, "com.mojang.datafixers.kinds.Applicative": Internal.ClassInfo, "com.hrznstudio.titanium.component.progress.ProgressBarComponent": Internal.ClassInfo, "cofh.thermal.core.init.registries.TCoreItems$1": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$CharacterTyped$Pre": Internal.ClassInfo, "net.minecraft.client.player.LocalPlayer": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$ProjectileEntityHitContext": Internal.ClassInfo, "cofh.thermal.lib.common.block.StorageCellBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeItem": Internal.ClassInfo, "net.minecraft.core.Holder$Reference": Internal.ClassInfo, "eutros.framedcompactdrawers.block.BlockSlaveCustom": Internal.ClassInfo, "net.minecraft.core.GlobalPos": Internal.ClassInfo, "net.minecraft.world.level.block.TurtleEggBlock": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$AutoAttackContext": Internal.ClassInfo, "net.minecraft.client.gui.screens.worldselection.WorldCreationUiState$WorldTypeEntry": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.lime.LimeHangingSignBlock": Internal.ClassInfo, "java.util.IntSummaryStatistics": Internal.ClassInfo, "letsforge_pirates.item.Merchant2Item$Chestplate": Internal.ClassInfo, "net.minecraftforge.registries.RegistryObject": Internal.ClassInfo, "net.minecraft.client.gui.components.Button$CreateNarration": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$MouseButtonPressed$Post": Internal.ClassInfo, "com.mojang.brigadier.CommandDispatcher": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemSmeltedEventJS": Internal.ClassInfo, "de.melanx.skyblockbuilder.blocks.SpawnBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder": Internal.ClassInfo, "sun.awt.SunHints$LCDContrastKey": Internal.ClassInfo, "net.mcreator.cozyhome.block.CrimsonGrandfatherClockBlock": Internal.ClassInfo, "java.util.ImmutableCollections$AbstractImmutableSet": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.SoapItem": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.StoneWallTorchBlock": Internal.ClassInfo, "vazkii.patchouli.mixin.client.AccessorMultiBufferSource": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.FuelBlockItem": Internal.ClassInfo, "net.blay09.mods.balm.forge.world.BalmBiomeModifier": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$Prudentium": Internal.ClassInfo, "net.minecraft.util.profiling.metrics.MetricSampler$ThresholdTest": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.entity.AccessorLivingEntity": Internal.ClassInfo, "net.minecraft.world.level.block.PoweredBlock": Internal.ClassInfo, "com.google.common.collect.RegularImmutableSet": Internal.ClassInfo, "net.minecraft.world.level.block.CraftingTableBlock": Internal.ClassInfo, "net.minecraft.world.level.block.BeetrootBlock": Internal.ClassInfo, "com.mojang.blaze3d.vertex.PoseStack$Pose": Internal.ClassInfo, "dev.latvian.mods.itemfilters.api.FilterInfo": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2DoubleFunction": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.Byte2ByteFunction": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.state.CanvasSign": Internal.ClassInfo, "cofh.lib.api.item.IPlacementItem": Internal.ClassInfo, "net.minecraft.world.item.CreativeModeTab": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.CustomMapData$SimpleDirtyCounter": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapMode": Internal.ClassInfo, "java.text.NumberFormat": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.Structure$GenerationContext": Internal.ClassInfo, "net.minecraft.world.entity.monster.Endermite": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundAddExperienceOrbPacket": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.tile.HydroponicBedTile": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeWrapper": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.DripstoneThickness": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter": Internal.ClassInfo, "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.QuestObjectCompletedEventJS": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.AnimalBabySeparatorBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.ScheduledEvents$ScheduledEvent": Internal.ClassInfo, "com.obscuria.aquamirae.common.blocks.OxygeliumBlock$Type": Internal.ClassInfo, "net.minecraft.world.item.SpyglassItem": Internal.ClassInfo, "io.netty.channel.RecvByteBufAllocator$Handle": Internal.ClassInfo, "java.awt.FontMetrics": Internal.ClassInfo, "java.lang.String$CaseInsensitiveComparator": Internal.ClassInfo, "net.minecraft.world.level.block.BarrierBlock": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonSittingAttackingPhase": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2IntMap$Entry": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemDroppedEventJS": Internal.ClassInfo, "net.minecraft.world.level.block.SkullBlock": Internal.ClassInfo, "java.util.function.IntPredicate": Internal.ClassInfo, "cofh.core.common.block.EntityBlock4Way": Internal.ClassInfo, "net.minecraftforge.common.util.TriPredicate": Internal.ClassInfo, "net.liopyu.entityjs.entities.IArrowEntityJS": Internal.ClassInfo, "net.minecraftforge.common.crafting.IShapedRecipe": Internal.ClassInfo, "com.mojang.serialization.DataResult$Instance": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.TerribleArmorItem$Leggings": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.api.IItemHandlerInteractionUpgrade": Internal.ClassInfo, "dev.latvian.mods.kubejs.gui.KubeJSGUI": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket": Internal.ClassInfo, "java.awt.AttributeValue": Internal.ClassInfo, "net.minecraft.world.level.block.WeatheringCopper": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.DragonHoldingPatternPhase": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket$Parameters": Internal.ClassInfo, "com.talhanation.smallships.world.item.BriggItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.entity.EntitySpawnedEventJS": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundAwardStatsPacket": Internal.ClassInfo, "net.minecraft.world.entity.ai.control.Control": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.ThreeBoltArmorItem$Helmet": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.mixin.forge.RecipeManagerAccessor": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier1Item$Leggings": Internal.ClassInfo, "org.slf4j.spi.LocationAwareLogger": Internal.ClassInfo, "net.minecraft.client.particle.ParticleRenderType": Internal.ClassInfo, "net.minecraftforge.event.level.LevelEvent$Unload": Internal.ClassInfo, "net.mcreator.cozyhome.block.QuartzGrandfatherClockBlock": Internal.ClassInfo, "net.minecraft.world.level.block.FrogspawnBlock": Internal.ClassInfo, "dev.architectury.registry.level.biome.forge.BiomeModificationsImpl$BiomeModifierImpl": Internal.ClassInfo, "vectorwing.farmersdelight.common.world.feature.WildCropFeature": Internal.ClassInfo, "net.minecraft.world.entity.ai.Brain$Provider": Internal.ClassInfo, "net.minecraft.client.gui.components.Tooltip": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.ConfigFromString": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootDataManager": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.entity.BlockEntityEventCallback": Internal.ClassInfo, "net.minecraftforge.event.ItemAttributeModifierEvent": Internal.ClassInfo, "net.minecraft.world.item.BoatItem": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.IntegerProperty": Internal.ClassInfo, "java.io.Closeable": Internal.ClassInfo, "net.minecraftforge.eventbus.api.Event$Result": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.HugeBrownMushroomFeature": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.MobEffectBuilder$EffectTickCallback": Internal.ClassInfo, "net.minecraft.world.entity.animal.horse.Mule": Internal.ClassInfo, "net.minecraft.client.telemetry.TelemetryProperty$ServerType": Internal.ClassInfo, "net.blay09.mods.balm.api.event.client.screen.ScreenDrawEvent": Internal.ClassInfo, "net.minecraft.world.level.block.ScaffoldingBlock": Internal.ClassInfo, "tech.thatgravyboat.duckling.common.items.HolidayFruitCakeItem": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeTransformation": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.BubbleBlowerItem": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.map.CustomMapData$DirtyCounter": Internal.ClassInfo, "dev.latvian.mods.rhino.ScriptableObject": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock": Internal.ClassInfo, "net.minecraft.world.level.block.JukeboxBlock": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.ObjectStartedEvent$ChapterEvent": Internal.ClassInfo, "com.buuz135.industrial.block.tile.IndustrialWorkingTile$WorkAction": Internal.ClassInfo, "java.math.BigInteger": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingUpgradeItem": Internal.ClassInfo, "chiefarug.mods.systeams.SteamFluid$1": Internal.ClassInfo, "com.mojang.datafixers.types.Type$TypeMatcher": Internal.ClassInfo, "net.minecraftforge.client.model.data.ModelProperty": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.GunpowderBlock": Internal.ClassInfo, "cofh.thermal.core.common.block.TilledChargedSoilBlock": Internal.ClassInfo, "com.electronwill.nightconfig.core.CommentedConfig$Entry": Internal.ClassInfo, "net.minecraft.stats.ServerRecipeBook": Internal.ClassInfo, "it.unimi.dsi.fastutil.bytes.BytePredicate": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.DoorHingeSide": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact": Internal.ClassInfo, "net.minecraft.world.entity.animal.TropicalFish$Base": Internal.ClassInfo, "net.minecraft.world.item.CreativeModeTab$ItemDisplayParameters": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute": Internal.ClassInfo, "net.minecraft.util.ExtraCodecs$LazyInitializedCodec": Internal.ClassInfo, "dev.latvian.mods.rhino.IdFunctionObject": Internal.ClassInfo, "letsforge_pirates.item.PirateTier3Item$Leggings": Internal.ClassInfo, "net.minecraft.world.food.FoodData": Internal.ClassInfo, "net.minecraftforge.event.level.ChunkDataEvent$Save": Internal.ClassInfo, "net.minecraftforge.fml.config.IConfigSpec": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaTableBlock": Internal.ClassInfo, "vazkii.patchouli.client.book.template.TemplateComponent": Internal.ClassInfo, "cofh.thermal.core.common.item.SatchelItem": Internal.ClassInfo, "com.obscuria.obscureapi.event.ObscureAPIEnchantmentsEvent": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2ReferenceFunction": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.AbyssalArmorItem$Heaume": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.loot.LootCrate": Internal.ClassInfo, "com.google.gson.stream.JsonWriter": Internal.ClassInfo, "net.minecraft.sounds.Music": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.BonusChestFeature": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2IntFunction": Internal.ClassInfo, "com.hrznstudio.titanium.block.redstone.RedstoneManager": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.CoralFeature": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.restock.RestockUpgradeWrapper": Internal.ClassInfo, "net.minecraft.world.level.material.FlowingFluid": Internal.ClassInfo, "net.minecraft.world.level.block.NetherWartBlock": Internal.ClassInfo, "com.hrznstudio.titanium.recipe.serializer.IRecipeSerializerReversed": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntOpenHashSet": Internal.ClassInfo, "net.minecraft.client.multiplayer.ProfileKeyPairManager": Internal.ClassInfo, "net.minecraft.util.SignatureValidator": Internal.ClassInfo, "net.minecraft.world.entity.npc.Npc": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.BlockTintFunction$Fixed": Internal.ClassInfo, "net.minecraft.world.level.block.state.pattern.BlockPattern$BlockPatternMatch": Internal.ClassInfo, "net.minecraft.world.entity.monster.hoglin.HoglinBase": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.BlockSlave": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.yellow.YellowWallHangingSignBlock": Internal.ClassInfo, "com.mojang.brigadier.arguments.StringArgumentType$StringType": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket": Internal.ClassInfo, "java.nio.channels.FileLock": Internal.ClassInfo, "java.util.Locale$FilteringMode": Internal.ClassInfo, "java.time.chrono.IsoChronology": Internal.ClassInfo, "com.yungnickyoung.minecraft.betteroceanmonuments.mixin.accessor.StructureManagerAccessor": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntConsumer": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.BlockDrawers": Internal.ClassInfo, "net.minecraft.world.item.ArmorItem$Type": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SconceLeverBlock": Internal.ClassInfo, "net.minecraft.util.random.SimpleWeightedRandomList$Builder": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObject2IntFunction": Internal.ClassInfo, "de.keksuccino.fancymenu.util.resource.RenderableResource": Internal.ClassInfo, "java.awt.Menu": Internal.ClassInfo, "net.minecraft.world.level.LevelReader": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.IFrameBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.EnchanterBlock": Internal.ClassInfo, "net.minecraft.nbt.ShortTag": Internal.ClassInfo, "com.obscuria.obscureapi.api.common.classes.Ability$Cost$Type": Internal.ClassInfo, "com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon": Internal.ClassInfo, "net.minecraft.world.level.block.DoublePlantBlock": Internal.ClassInfo, "net.minecraft.world.level.block.ComparatorBlock": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.core.misc.CaveFilter": Internal.ClassInfo, "net.minecraft.world.item.crafting.MapExtendingRecipe": Internal.ClassInfo, "net.minecraft.world.inventory.EnchantmentMenu": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.PlacementModifier": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes": Internal.ClassInfo, "letsforge_pirates.item.DeckhandItem$Boots": Internal.ClassInfo, "com.blakebr0.cucumber.crafting.recipe.ShapelessTagRecipe": Internal.ClassInfo, "net.minecraft.client.StringSplitter": Internal.ClassInfo, "dev.latvian.mods.rhino.util.CustomJavaToJsWrapperProvider": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.ui.IScreenWrapper": Internal.ClassInfo, "net.mcreator.cozyhome.block.BambooBenchBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.WithPersistentData": Internal.ClassInfo, "net.minecraft.world.level.block.EndRodBlock": Internal.ClassInfo, "letsforge_pirates.item.PirateTier3Item$Helmet": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundOpenBookPacket": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.util.NBTUtils": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.ClassWrapper": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2IntFunction": Internal.ClassInfo, "net.minecraft.client.renderer.block.model.BlockModel$GuiLight": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier3Item$Leggings": Internal.ClassInfo, "cofh.thermal.core.common.fluid.ResinFluid$1": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityHealContext": Internal.ClassInfo, "com.hrznstudio.titanium.block.tile.ActiveTile": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.ObjectCompletedEvent": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryWallClockBlock": Internal.ClassInfo, "net.minecraftforge.common.data.ExistingFileHelper": Internal.ClassInfo, "net.minecraft.client.gui.screens.inventory.MenuAccess": Internal.ClassInfo, "java.util.PrimitiveIterator": Internal.ClassInfo, "net.minecraft.world.item.ProjectileWeaponItem": Internal.ClassInfo, "com.mojang.datafixers.functions.PointFreeRule": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2CharFunction": Internal.ClassInfo, "java.util.function.DoubleSupplier": Internal.ClassInfo, "java.awt.datatransfer.FlavorListener": Internal.ClassInfo, "de.keksuccino.konkrete.events.ScreenCharTypedEvent": Internal.ClassInfo, "net.minecraft.client.particle.Particle": Internal.ClassInfo, "net.minecraft.world.inventory.FurnaceMenu": Internal.ClassInfo, "com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension": Internal.ClassInfo, "java.nio.channels.FileChannel": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.BlackSprayCanItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.presets.WorldPreset": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.PlantFertilizerBlock": Internal.ClassInfo, "com.hrznstudio.titanium.component.inventory.SidedInventoryComponent": Internal.ClassInfo, "net.liopyu.entityjs.builders.BaseEntityBuilder": Internal.ClassInfo, "net.minecraft.world.entity.decoration.ItemFrame": Internal.ClassInfo, "net.minecraft.world.entity.ItemSteerable": Internal.ClassInfo, "net.minecraftforge.fml.loading.progress.ProgressMeter": Internal.ClassInfo, "java.nio.file.DirectoryStream": Internal.ClassInfo, "net.minecraft.world.level.material.MapColor": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPickItemPacket": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.restock.RestockUpgradeItem": Internal.ClassInfo, "net.mcreator.cozyhome.block.StumpChairBlock": Internal.ClassInfo, "com.obscuria.aquamirae.common.effects.HealthDecreaseMobEffect": Internal.ClassInfo, "cofh.thermal.core.util.RegistrationHelper$1": Internal.ClassInfo, "letsforge_pirates.item.Merchant2Item$Leggings": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.BlockSetType": Internal.ClassInfo, "net.minecraft.world.level.gameevent.EntityPositionSource$Type": Internal.ClassInfo, "java.lang.Void": Internal.ClassInfo, "java.io.Externalizable": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.tinkering.IElementalItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.configurations.BlockPileConfiguration": Internal.ClassInfo, "net.minecraft.core.HolderLookup$Provider": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaBlackBlock": Internal.ClassInfo, "net.minecraft.commands.CommandSigningContext": Internal.ClassInfo, "net.minecraft.client.gui.screens.Screen$NarratableSearchResult": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction": Internal.ClassInfo, "net.minecraft.world.level.gameevent.GameEventListenerRegistry$ListenerVisitor": Internal.ClassInfo, "com.electronwill.nightconfig.core.io.ParsingMode": Internal.ClassInfo, "net.minecraft.world.level.levelgen.NoiseRouter": Internal.ClassInfo, "net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2ByteFunction": Internal.ClassInfo, "net.minecraft.commands.arguments.NbtPathArgument$NbtPath": Internal.ClassInfo, "net.allthemods.alltheores.items.OreHammer": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2LongFunction": Internal.ClassInfo, "net.minecraft.world.item.SpawnEggItem": Internal.ClassInfo, "dev.architectury.extensions.injected.InjectedFluidExtension": Internal.ClassInfo, "net.minecraft.world.level.block.SlimeBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket": Internal.ClassInfo, "net.minecraftforge.common.util.Lazy$Fast": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.item.ItemInfinityLauncher": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.request.AbuseReportRequest$RealmInfo": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.BuddingBushBlock": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.LootContext": Internal.ClassInfo, "net.minecraft.world.item.enchantment.ArrowPiercingEnchantment": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPingPacket": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerEvent$PlayerLoggedOutEvent": Internal.ClassInfo, "net.minecraft.client.renderer.ShaderInstance": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.SimpleBlockFeature": Internal.ClassInfo, "java.util.function.IntToDoubleFunction": Internal.ClassInfo, "net.minecraft.client.model.geom.builders.CubeListBuilder": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSoundEntityPacket": Internal.ClassInfo, "net.minecraft.world.damagesource.DeathMessageType": Internal.ClassInfo, "net.minecraft.client.renderer.texture.SpriteLoader$Preparations": Internal.ClassInfo, "com.hrznstudio.titanium.block.tile.IScreenInfoProvider": Internal.ClassInfo, "com.mojang.serialization.Decoder$Simple": Internal.ClassInfo, "software.bernie.geckolib.core.keyframe.event.ParticleKeyframeEvent": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.yellow.YellowHangingSignBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherArmBlock": Internal.ClassInfo, "net.minecraft.client.renderer.debug.DebugRenderer": Internal.ClassInfo, "net.minecraftforge.common.world.StructureSettingsBuilder": Internal.ClassInfo, "net.minecraft.util.FrameTimer": Internal.ClassInfo, "net.minecraft.world.entity.Display$GenericInterpolator": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundBundlePacket": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryDeskBlock": Internal.ClassInfo, "net.minecraft.world.level.block.StructureBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.doubles.DoubleConsumer": Internal.ClassInfo, "net.minecraft.world.entity.item.PrimedTnt": Internal.ClassInfo, "vazkii.patchouli.client.book.BookPage": Internal.ClassInfo, "dev.ftb.mods.ftbteams.data.TeamArgument$Info$Template": Internal.ClassInfo, "net.minecraft.world.level.block.DropperBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.custom.BasicItemJS": Internal.ClassInfo, "com.mojang.datafixers.Products$P1": Internal.ClassInfo, "net.minecraft.stats.StatType": Internal.ClassInfo, "com.mojang.datafixers.Products$P3": Internal.ClassInfo, "net.minecraft.client.player.Input": Internal.ClassInfo, "com.mojang.datafixers.Products$P2": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.FollowTemptation": Internal.ClassInfo, "com.mojang.brigadier.suggestion.SuggestionsBuilder": Internal.ClassInfo, "com.mojang.datafixers.Products$P9": Internal.ClassInfo, "com.mojang.datafixers.Products$P8": Internal.ClassInfo, "java.util.IdentityHashMap": Internal.ClassInfo, "com.mojang.datafixers.Products$P5": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityItemLevelContext": Internal.ClassInfo, "com.mojang.datafixers.Products$P4": Internal.ClassInfo, "net.minecraft.client.renderer.RenderStateShard$ColorLogicStateShard": Internal.ClassInfo, "com.mojang.datafixers.Products$P7": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.weapon.PoisonedBladeItem": Internal.ClassInfo, "com.mojang.datafixers.Products$P6": Internal.ClassInfo, "net.minecraftforge.registries.DataPackRegistryEvent$NewRegistry": Internal.ClassInfo, "net.minecraft.world.item.armortrim.TrimMaterial": Internal.ClassInfo, "dev.latvian.mods.itemfilters.item.InventoryFilterItem": Internal.ClassInfo, "net.minecraft.client.resources.model.ModelBaker": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.MaterialStoneWorkFactoryBlock": Internal.ClassInfo, "net.minecraft.sounds.SoundEvent": Internal.ClassInfo, "io.netty.channel.ChannelOutboundInvoker": Internal.ClassInfo, "net.darkhax.bookshelf.mixin.accessors.item.AccessorItemCooldowns": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeItem": Internal.ClassInfo, "com.google.gson.ReflectionAccessFilter": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.callbacks.BlockStateModifyPlacementCallbackJS": Internal.ClassInfo, "net.minecraft.client.multiplayer.PlayerInfo": Internal.ClassInfo, "net.minecraft.world.level.block.PointedDripstoneBlock": Internal.ClassInfo, "com.hrznstudio.titanium.block_network.Network": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket": Internal.ClassInfo, "net.minecraft.network.chat.LastSeenMessages": Internal.ClassInfo, "net.minecraft.world.level.block.SlabBlock": Internal.ClassInfo, "net.minecraft.world.level.dimension.DimensionType": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveChairBlock": Internal.ClassInfo, "net.minecraft.client.AttackIndicatorStatus": Internal.ClassInfo, "java.nio.charset.CoderResult": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.foliageplacers.DarkOakFoliagePlacer": Internal.ClassInfo, "com.mojang.authlib.HttpAuthenticationService": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$Vec3Context": Internal.ClassInfo, "net.minecraft.world.level.block.BaseCoralFanBlock": Internal.ClassInfo, "net.minecraftforge.client.event.RenderPlayerEvent$Pre": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeManager$NoiseBiomeSource": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.FishItem": Internal.ClassInfo, "java.lang.NamedPackage": Internal.ClassInfo, "net.minecraft.world.scores.Scoreboard": Internal.ClassInfo, "net.minecraftforge.network.HandshakeMessages$S2CRegistry": Internal.ClassInfo, "net.minecraft.tags.TagEntry$Lookup": Internal.ClassInfo, "net.minecraft.world.level.block.GrowingPlantBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock": Internal.ClassInfo, "vazkii.patchouli.api.IVariableProvider": Internal.ClassInfo, "java.text.Format": Internal.ClassInfo, "net.minecraft.world.level.block.TrapDoorBlock": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.blue.BlueWallSignBlock": Internal.ClassInfo, "net.minecraft.world.entity.projectile.AbstractArrow$Pickup": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexFormatElement": Internal.ClassInfo, "net.minecraft.world.level.block.SnifferEggBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.carver.CanyonWorldCarver": Internal.ClassInfo, "cofh.lib.common.block.StemBlockCoFH": Internal.ClassInfo, "net.minecraft.world.level.block.RenderShape": Internal.ClassInfo, "net.minecraftforge.event.entity.player.PlayerXpEvent": Internal.ClassInfo, "java.net.Proxy": Internal.ClassInfo, "tamaized.melongolem.common.ItemMelonStick": Internal.ClassInfo, "java.awt.dnd.DragSourceDropEvent": Internal.ClassInfo, "com.mojang.blaze3d.platform.Window": Internal.ClassInfo, "net.minecraft.client.renderer.RenderType$CompositeState$CompositeStateBuilder": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.CrookItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType": Internal.ClassInfo, "com.mojang.authlib.yggdrasil.ServicesKeyInfo": Internal.ClassInfo, "net.minecraft.world.inventory.ChestMenu": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier3Item$Chestplate": Internal.ClassInfo, "com.probejs.jdoc.document.DocumentClass": Internal.ClassInfo, "net.minecraft.world.level.levelgen.GeodeCrackSettings": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.OrganicCompostBlock": Internal.ClassInfo, "net.liopyu.entityjs.builders.BaseLivingEntityBuilder$SoundKeyFrameEventJS": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest": Internal.ClassInfo, "net.minecraft.world.level.levelgen.SurfaceSystem": Internal.ClassInfo, "net.minecraft.data.recipes.ShapedRecipeBuilder": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.FluidAmounts": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.QuestShape": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.green.GreenWallSignBlock": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.BasketBlock": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.loot.WeightedReward": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaWhiteBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.SouliumSpawnerBlock": Internal.ClassInfo, "net.minecraft.world.level.block.state.properties.EnumProperty": Internal.ClassInfo, "net.minecraft.world.item.ShovelItem": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic": Internal.ClassInfo, "com.mojang.datafixers.kinds.Kind1$Mu": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntUnaryOperator": Internal.ClassInfo, "net.minecraft.client.sounds.SoundManager": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.FireworksJS": Internal.ClassInfo, "lykrast.glassential.doors.GlassLightTrapDoorBlock": Internal.ClassInfo, "letsforge_pirates.item.Merchant1Item$Chestplate": Internal.ClassInfo, "net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer": Internal.ClassInfo, "com.buuz135.industrial.block.agriculturehusbandry.PlantGathererBlock": Internal.ClassInfo, "java.util.function.IntToLongFunction": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.RG2BlocksRecipe$Serializer": Internal.ClassInfo, "net.minecraft.world.item.DiscFragmentItem": Internal.ClassInfo, "org.moddingx.libx.event.ConfigLoadedEvent$LoadReason": Internal.ClassInfo, "net.minecraft.server.WorldStem": Internal.ClassInfo, "com.mojang.authlib.minecraft.TelemetryEvent": Internal.ClassInfo, "net.minecraftforge.client.event.RecipesUpdatedEvent": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.Short2ReferenceFunction": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.FloatBinaryOperator": Internal.ClassInfo, "net.minecraft.world.entity.vehicle.Minecart": Internal.ClassInfo, "java.awt.geom.PathIterator": Internal.ClassInfo, "java.awt.PopupMenu": Internal.ClassInfo, "java.nio.IntBuffer": Internal.ClassInfo, "net.minecraft.world.level.chunk.ChunkStatus$ChunkType": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.callbacks.CanBeReplacedCallbackJS": Internal.ClassInfo, "net.minecraft.core.NonNullList": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider": Internal.ClassInfo, "org.joml.Matrix2f": Internal.ClassInfo, "java.awt.image.renderable.RenderableImage": Internal.ClassInfo, "org.joml.Matrix2d": Internal.ClassInfo, "java.awt.event.WindowStateListener": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.config.LongConfig": Internal.ClassInfo, "javax.accessibility.AccessibleValue": Internal.ClassInfo, "net.minecraft.world.level.block.GameMasterBlock": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeItem$Wrapper": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.IBlockHolder": Internal.ClassInfo, "net.minecraft.util.thread.BlockableEventLoop": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.ItemComponents$2": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.ItemComponents$1": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.filter.RecipeFilter": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.ItemComponents$4": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.component.ItemComponents$3": Internal.ClassInfo, "net.minecraft.world.entity.monster.EnderMan": Internal.ClassInfo, "com.benbenlaw.opolisutilities.item.custom.AdvancedHomeStoneItem": Internal.ClassInfo, "letsforge_pirates.item.CorsairTier2Item": Internal.ClassInfo, "net.minecraftforge.registries.IForgeRegistry$CreateCallback": Internal.ClassInfo, "mezz.jei.api.recipe.RecipeIngredientRole": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy": Internal.ClassInfo, "net.minecraft.world.item.DyeItem": Internal.ClassInfo, "org.joml.Matrix3f": Internal.ClassInfo, "org.joml.Matrix3d": Internal.ClassInfo, "net.minecraft.world.level.gameevent.BlockPositionSource$Type": Internal.ClassInfo, "java.util.stream.IntStream": Internal.ClassInfo, "dev.architectury.hooks.level.biome.ClimateProperties": Internal.ClassInfo, "java.awt.Insets": Internal.ClassInfo, "net.minecraftforge.forgespi.language.IConfigurable": Internal.ClassInfo, "com.mojang.blaze3d.shaders.AbstractUniform": Internal.ClassInfo, "com.blakebr0.cucumber.crafting.recipe.ShapedTransferDamageRecipe": Internal.ClassInfo, "net.mcreator.cozyhome.block.SofaLimeBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.platform.forge.ingredient.WildcardIngredient": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator$LocatedStruct": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier2Item": Internal.ClassInfo, "com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertSmallRuinsFeature": Internal.ClassInfo, "net.minecraft.world.level.border.BorderChangeListener": Internal.ClassInfo, "org.joml.Matrix4f": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.HurtBySensor": Internal.ClassInfo, "org.joml.Matrix4d": Internal.ClassInfo, "net.minecraft.world.entity.Saddleable": Internal.ClassInfo, "java.util.function.LongFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor": Internal.ClassInfo, "cofh.core.common.item.SpawnEggItemCoFH": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.RecipeTypeFunction": Internal.ClassInfo, "net.minecraft.client.model.geom.builders.LayerDefinition": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider": Internal.ClassInfo, "net.minecraft.world.level.block.entity.StructureBlockEntity": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.ObjectCompletedEvent$ChapterEvent": Internal.ClassInfo, "net.minecraftforge.client.event.ViewportEvent$ComputeCameraAngles": Internal.ClassInfo, "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.CustomFilterItemEventJS": Internal.ClassInfo, "tocraft.walkers.impl.NearbySongAccessor": Internal.ClassInfo, "tfar.dankstorage.mixin.MinecraftServerAccess": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2CharFunction": Internal.ClassInfo, "com.mojang.authlib.GameProfile": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.client.ICustomItemRendererProvider": Internal.ClassInfo, "net.minecraft.network.Connection": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.item.WoodBasedItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.FireworksJS$Explosion": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundResourcePackPacket": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.AquaFishBucket": Internal.ClassInfo, "letsforge_pirates.item.PirateTier3Item$Boots": Internal.ClassInfo, "java.math.BigDecimal": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.sign.brown.BrownWallSignBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.structures.JigsawStructure": Internal.ClassInfo, "net.minecraft.client.gui.components.Button$OnPress": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongSet": Internal.ClassInfo, "net.minecraft.world.level.block.piston.PistonHeadBlock": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundTabListPacket": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator$Context": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blockpredicates.InsideWorldBoundsPredicate": Internal.ClassInfo, "java.lang.invoke.MethodHandles$Lookup": Internal.ClassInfo, "net.minecraft.server.network.ServerConnectionListener": Internal.ClassInfo, "net.minecraft.nbt.ByteArrayTag": Internal.ClassInfo, "com.teammetallurgy.aquaculture.item.ItemMessageInABottle": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaBenchBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.living.LivingConversionEvent": Internal.ClassInfo, "cofh.thermal.core.common.fluid.TreeOilFluid$1": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent": Internal.ClassInfo, "com.buuz135.industrial.block.core.DissolutionChamberBlock": Internal.ClassInfo, "net.minecraft.world.level.block.LavaCauldronBlock": Internal.ClassInfo, "java.util.function.ToDoubleBiFunction": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.armor.TerribleArmorItem$Boots": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.RottenTomatoItem": Internal.ClassInfo, "net.minecraft.world.level.block.state.BlockBehaviour$OffsetFunction": Internal.ClassInfo, "net.minecraftforge.eventbus.api.IEventListener": Internal.ClassInfo, "vectorwing.farmersdelight.common.world.modifier.AddFeaturesByFilterBiomeModifier": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BaseScytheItem": Internal.ClassInfo, "net.minecraft.world.entity.animal.Panda": Internal.ClassInfo, "net.minecraft.world.level.block.state.BlockState": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket": Internal.ClassInfo, "com.mojang.serialization.RecordBuilder": Internal.ClassInfo, "net.minecraftforge.fluids.ForgeFlowingFluid": Internal.ClassInfo, "net.minecraft.client.gui.spectator.categories.SpectatorPage": Internal.ClassInfo, "net.minecraft.commands.arguments.EntityArgument$Info$Template": Internal.ClassInfo, "net.minecraftforge.registries.RegistryBuilder": Internal.ClassInfo, "net.minecraft.client.renderer.item.ClampedItemPropertyFunction": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate": Internal.ClassInfo, "net.minecraft.world.level.biome.BiomeSpecialEffects": Internal.ClassInfo, "net.minecraft.server.network.FilteredText": Internal.ClassInfo, "net.minecraftforge.client.RenderTypeGroup": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveWallClockBlock": Internal.ClassInfo, "net.minecraft.world.level.block.AzaleaBlock": Internal.ClassInfo, "net.minecraft.world.level.block.BaseEntityBlock": Internal.ClassInfo, "net.minecraft.world.level.border.BorderStatus": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.TwistingVinesFeature": Internal.ClassInfo, "com.obscuria.obscureapi.event.ObscureAPIRegisterBossBarsEvent": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase": Internal.ClassInfo, "java.io.FileFilter": Internal.ClassInfo, "com.mojang.brigadier.tree.CommandNode": Internal.ClassInfo, "net.mcreator.cozyhome.block.AcaciaSinkCounterBlock": Internal.ClassInfo, "com.google.common.collect.UnmodifiableIterator": Internal.ClassInfo, "net.minecraft.network.chat.ClickEvent": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Object2ObjectMap$Entry": Internal.ClassInfo, "net.minecraft.nbt.ByteTag": Internal.ClassInfo, "letsforge_pirates.item.Merchant3Item$Chestplate": Internal.ClassInfo, "net.minecraft.world.level.block.GlowLichenBlock": Internal.ClassInfo, "net.minecraft.util.ModCheck": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.ItemBuilder$FinishUsingCallback": Internal.ClassInfo, "java.awt.JobAttributes": Internal.ClassInfo, "net.minecraft.world.level.storage.PlayerDataStorage": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.Int2IntFunction": Internal.ClassInfo, "net.minecraft.world.level.block.EndPortalBlock": Internal.ClassInfo, "cofh.core.common.item.BlockNamedItemCoFH": Internal.ClassInfo, "org.lwjgl.system.MemoryStack": Internal.ClassInfo, "java.time.LocalTime": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BaseBowItem": Internal.ClassInfo, "net.minecraft.world.level.block.WallBlock": Internal.ClassInfo, "java.lang.module.ModuleDescriptor$Requires$Modifier": Internal.ClassInfo, "net.mcreator.cozyhome.block.ChandelierGoldenBlock": Internal.ClassInfo, "java.awt.FocusTraversalPolicy": Internal.ClassInfo, "cofh.core.common.block.EntityBlockActive": Internal.ClassInfo, "net.mcreator.cozyhome.block.BirchChairBlock": Internal.ClassInfo, "dev.ftb.mods.ftbquests.quest.task.TaskType$GuiProvider": Internal.ClassInfo, "cofh.lib.common.block.CropBlockPerennial": Internal.ClassInfo, "net.mcreator.cozyhome.block.PinkLampBlock": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.InferiumCropBlock": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryCounterBlock": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.weapon.SweetLanceItem": Internal.ClassInfo, "com.blakebr0.mysticalagradditions.world.modifiers.EndInferiumOreModifier": Internal.ClassInfo, "net.mcreator.cozyhome.block.QuartzMirrorStandBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.bindings.TextWrapper": Internal.ClassInfo, "net.minecraftforge.common.util.INBTSerializable": Internal.ClassInfo, "com.buuz135.industrial.api.transporter.TransporterTypeFactory$TransporterAction": Internal.ClassInfo, "org.apache.maven.artifact.handler.ArtifactHandler": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$BackgroundRendered": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor": Internal.ClassInfo, "com.buuz135.industrial.block.core.tile.DissolutionChamberTile": Internal.ClassInfo, "vectorwing.farmersdelight.common.item.enchantment.BackstabbingEnchantment": Internal.ClassInfo, "net.mcreator.cozyhome.block.LimeLampBlock": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.FlammableLogBlock": Internal.ClassInfo, "dev.architectury.registry.registries.RegistrarBuilder": Internal.ClassInfo, "net.minecraft.world.level.block.BigDripleafStemBlock": Internal.ClassInfo, "java.lang.module.ModuleDescriptor$Requires": Internal.ClassInfo, "net.minecraft.commands.BrigadierExceptions": Internal.ClassInfo, "java.awt.dnd.DragGestureListener": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator": Internal.ClassInfo, "net.minecraftforge.event.TickEvent": Internal.ClassInfo, "net.minecraftforge.event.AttachCapabilitiesEvent": Internal.ClassInfo, "it.unimi.dsi.fastutil.chars.Char2BooleanFunction": Internal.ClassInfo, "dev.latvian.mods.kubejs.item.creativetab.CreativeTabBuilder": Internal.ClassInfo, "net.minecraft.client.multiplayer.ClientLevel$ClientLevelData": Internal.ClassInfo, "java.util.stream.BaseStream": Internal.ClassInfo, "net.minecraft.world.Clearable": Internal.ClassInfo, "net.minecraft.world.level.block.EnchantmentTableBlock": Internal.ClassInfo, "net.minecraft.client.Camera": Internal.ClassInfo, "net.minecraft.world.level.gameevent.vibrations.VibrationSystem$Listener": Internal.ClassInfo, "net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonPhaseInstance": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.HarvesterBlock": Internal.ClassInfo, "net.minecraft.world.level.levelgen.blending.Blender$BlendingOutput": Internal.ClassInfo, "net.minecraft.world.item.SmithingTemplateItem": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.entity.BlockEntityJS": Internal.ClassInfo, "letsforge_pirates.item.SailorRedTier3Item$Helmet": Internal.ClassInfo, "dev.ftb.mods.ftbquests.events.ObjectProgressEvent": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.events.SimpleEvent": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$KeyPressed$Post": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.RiceBaleBlock": Internal.ClassInfo, "com.buuz135.industrial.block.resourceproduction.tile.OreLaserBaseTile": Internal.ClassInfo, "net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise": Internal.ClassInfo, "net.minecraft.client.multiplayer.MultiPlayerGameMode": Internal.ClassInfo, "org.slf4j.event.Level": Internal.ClassInfo, "de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.Long2IntFunction": Internal.ClassInfo, "net.minecraft.world.level.block.StemGrownBlock": Internal.ClassInfo, "net.liopyu.entityjs.util.ContextUtils$EntityDistanceToPlayerContext": Internal.ClassInfo, "net.minecraft.world.level.biome.MobSpawnSettings$SpawnerData": Internal.ClassInfo, "net.minecraft.world.level.block.FarmBlock": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationState": Internal.ClassInfo, "net.minecraft.world.level.block.SandBlock": Internal.ClassInfo, "net.minecraft.world.entity.ai.sensing.PlayerSensor": Internal.ClassInfo, "net.minecraft.world.level.block.entity.FurnaceBlockEntity": Internal.ClassInfo, "com.electronwill.nightconfig.core.UnmodifiableCommentedConfig": Internal.ClassInfo, "net.minecraftforge.event.level.BlockEvent$FarmlandTrampleEvent": Internal.ClassInfo, "net.minecraft.world.level.block.AirBlock": Internal.ClassInfo, "org.violetmoon.zetaimplforge.mixin.mixins.client.AccessorItemColors": Internal.ClassInfo, "net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongCollection": Internal.ClassInfo, "dev.latvian.mods.kubejs.bindings.UtilsWrapper": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.item.ItemInfinityNuke": Internal.ClassInfo, "com.buuz135.industrial.item.infinity.item.ItemInfinityTrident": Internal.ClassInfo, "com.obscuria.aquamirae.common.blocks.LuminescentBubbleBlock": Internal.ClassInfo, "net.minecraftforge.event.entity.EntityMobGriefingEvent": Internal.ClassInfo, "net.minecraft.world.level.chunk.LightChunk": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundEditBookPacket": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.BuddingTomatoBlock": Internal.ClassInfo, "java.util.PrimitiveIterator$OfLong": Internal.ClassInfo, "java.time.temporal.TemporalAmount": Internal.ClassInfo, "net.minecraftforge.fml.IModStateTransition$EventGenerator": Internal.ClassInfo, "net.minecraft.client.renderer.debug.BrainDebugRenderer": Internal.ClassInfo, "io.netty.util.Attribute": Internal.ClassInfo, "net.minecraftforge.client.event.RenderGuiOverlayEvent$Post": Internal.ClassInfo, "org.joml.AxisAngle4f": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeMobEffectInstance": Internal.ClassInfo, "com.mojang.serialization.Decoder": Internal.ClassInfo, "net.minecraft.world.level.block.CaveVinesPlantBlock": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.blocks.BookPileHorizontalBlock": Internal.ClassInfo, "org.joml.AxisAngle4d": Internal.ClassInfo, "it.unimi.dsi.fastutil.floats.Float2ShortFunction": Internal.ClassInfo, "net.minecraft.world.item.Items$1": Internal.ClassInfo, "net.minecraft.world.entity.npc.VillagerData": Internal.ClassInfo, "net.mcreator.cozyhome.block.CherryDrawerBlock": Internal.ClassInfo, "it.unimi.dsi.fastutil.shorts.ShortUnaryOperator": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem": Internal.ClassInfo, "net.mcreator.cozyhome.block.WarpedGrandfatherClockBlock": Internal.ClassInfo, "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.FTBQuestsKubeJSWrapper": Internal.ClassInfo, "com.blakebr0.cucumber.item.tool.BaseSickleItem": Internal.ClassInfo, "net.minecraft.world.item.MobBucketItem": Internal.ClassInfo, "net.minecraft.world.phys.shapes.DiscreteVoxelShape": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.api.IQuiverEntity": Internal.ClassInfo, "net.minecraft.resources.FileToIdConverter": Internal.ClassInfo, "it.unimi.dsi.fastutil.longs.LongSpliterator": Internal.ClassInfo, "software.bernie.geckolib.core.animatable.model.CoreBakedGeoModel": Internal.ClassInfo, "com.mojang.datafixers.util.Either": Internal.ClassInfo, "net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings": Internal.ClassInfo, "org.lwjgl.system.Struct$StructValidation": Internal.ClassInfo, "com.benbenlaw.caveopolis.item.custom.BrownSprayCanItem": Internal.ClassInfo, "net.minecraft.world.item.AirItem": Internal.ClassInfo, "net.minecraft.world.level.block.state.StateHolder": Internal.ClassInfo, "net.darkhax.bookshelf.api.commands.args.SingletonArgumentInfo$Template": Internal.ClassInfo, "com.benbenlaw.opolisutilities.recipe.ResourceGeneratorRecipe$Serializer": Internal.ClassInfo, "com.mojang.brigadier.StringReader": Internal.ClassInfo, "it.unimi.dsi.fastutil.ints.IntComparator": Internal.ClassInfo, "dev.latvian.mods.kubejs.block.FarmlandTrampledEventJS": Internal.ClassInfo, "net.minecraft.world.level.storage.WorldData": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.ObjectSpliterator": Internal.ClassInfo, "net.minecraftforge.client.event.EntityRenderersEvent$AddLayers": Internal.ClassInfo, "dev.latvian.mods.kubejs.core.LazyComponentKJS": Internal.ClassInfo, "letsforge_pirates.item.CraftsmanItem$Leggings": Internal.ClassInfo, "net.mcreator.cozyhome.block.BambooTableBlock": Internal.ClassInfo, "java.util.function.BinaryOperator": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.RandomBooleanSelectorFeature": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.Reference2ReferenceFunction": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.api.IFluidHandlerWrapperUpgrade": Internal.ClassInfo, "net.minecraft.world.level.block.RespawnAnchorBlock": Internal.ClassInfo, "java.time.temporal.Temporal": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.block.IRotatable": Internal.ClassInfo, "java.lang.ThreadLocal$SuppliedThreadLocal": Internal.ClassInfo, "net.minecraft.network.chat.SignedMessageBody$Packed": Internal.ClassInfo, "cofh.core.client.particle.options.CylindricalParticleOptions": Internal.ClassInfo, "it.unimi.dsi.fastutil.objects.AbstractObject2FloatFunction": Internal.ClassInfo, "io.netty.buffer.ByteBufConvertible": Internal.ClassInfo, "com.mojang.blaze3d.vertex.BufferBuilder$SortState": Internal.ClassInfo, "net.mcreator.cozyhome.block.OakChairBlock": Internal.ClassInfo, "cofh.thermal.core.common.block.EnderiumGlassBlock": Internal.ClassInfo, "net.minecraft.world.level.block.EndPortalFrameBlock": Internal.ClassInfo, "net.minecraft.world.scores.Team$CollisionRule": Internal.ClassInfo, "letsforge_pirates.item.SailorGrayTier3Item": Internal.ClassInfo, "java.util.LinkedList": Internal.ClassInfo, "dev.latvian.mods.kubejs.level.LevelEventJS": Internal.ClassInfo, "net.minecraftforge.common.PlantType": Internal.ClassInfo, "java.nio.channels.ReadableByteChannel": Internal.ClassInfo, "net.minecraft.world.entity.projectile.DragonFireball": Internal.ClassInfo, "java.util.AbstractMap": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity": Internal.ClassInfo, "java.awt.PageAttributes$ColorType": Internal.ClassInfo, "net.minecraftforge.client.event.ClientPlayerNetworkEvent": Internal.ClassInfo, "letsforge_pirates.item.PirateTier1Item": Internal.ClassInfo, "org.apache.maven.artifact.versioning.VersionRange": Internal.ClassInfo, "net.minecraft.client.gui.MapRenderer": Internal.ClassInfo, "vazkii.patchouli.api.IVariablesAvailableCallback": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimationController$ParticleKeyframeHandler": Internal.ClassInfo, "net.minecraft.core.particles.ParticleOptions": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement": Internal.ClassInfo, "net.minecraft.world.item.enchantment.VanishingCurseEnchantment": Internal.ClassInfo, "net.minecraftforge.fluids.ForgeFlowingFluid$Source": Internal.ClassInfo, "mezz.jei.api.gui.ingredient.IRecipeSlotsView": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket$Action": Internal.ClassInfo, "net.minecraft.world.entity.monster.warden.WardenSpawnTracker": Internal.ClassInfo, "net.minecraft.world.item.trading.MerchantOffer": Internal.ClassInfo, "net.minecraft.client.gui.components.toasts.TutorialToast": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.CuttingBoardBlock": Internal.ClassInfo, "dev.latvian.mods.rhino.mod.wrapper.AABBWrapper": Internal.ClassInfo, "com.buuz135.industrial.block.misc.EnchantmentSorterBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.misc.MobEffectBuilder": Internal.ClassInfo, "dev.latvian.mods.kubejs.typings.desc.ObjectDescJS": Internal.ClassInfo, "com.mojang.brigadier.builder.LiteralArgumentBuilder": Internal.ClassInfo, "java.awt.MenuBar": Internal.ClassInfo, "com.mojang.blaze3d.vertex.VertexFormat": Internal.ClassInfo, "net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement": Internal.ClassInfo, "java.lang.Double": Internal.ClassInfo, "com.hrznstudio.titanium.item.BasicItem$Key": Internal.ClassInfo, "net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer": Internal.ClassInfo, "net.minecraftforge.event.entity.item.ItemTossEvent": Internal.ClassInfo, "net.minecraft.world.inventory.LecternMenu": Internal.ClassInfo, "it.unimi.dsi.fastutil.booleans.Boolean2CharFunction": Internal.ClassInfo, "net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket": Internal.ClassInfo, "letsforge_pirates.item.TannedleatherItem": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.api.storage.BlockType": Internal.ClassInfo, "tocraft.walkers.mixin.accessor.BiomeAccessor": Internal.ClassInfo, "net.minecraftforge.common.util.ITeleporter": Internal.ClassInfo, "cofh.lib.common.enchantment.EnchantmentCoFH": Internal.ClassInfo, "cofh.thermal.lib.util.recipes.MachineCatalystSerializer": Internal.ClassInfo, "net.minecraft.world.item.MapItem": Internal.ClassInfo, "net.minecraftforge.network.NetworkEvent$GatherLoginPayloadsEvent": Internal.ClassInfo, "dev.architectury.core.fluid.ArchitecturyFlowingFluid": Internal.ClassInfo, "net.minecraftforge.server.command.EnumArgument$Info": Internal.ClassInfo, "dev.latvian.mods.kubejs.loot.FunctionContainer": Internal.ClassInfo, "net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$Preset$SourceProvider": Internal.ClassInfo, "net.minecraft.world.item.WrittenBookItem": Internal.ClassInfo, "net.minecraft.world.entity.projectile.Snowball": Internal.ClassInfo, "java.lang.constant.Constable": Internal.ClassInfo, "net.minecraft.world.entity.monster.Zoglin": Internal.ClassInfo, "dev.latvian.mods.rhino.SymbolScriptable": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback": Internal.ClassInfo, "org.moddingx.libx.command.EnumArgument2$Info$Template": Internal.ClassInfo, "net.minecraft.world.entity.ai.behavior.JumpOnBed": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperUpgradeWrapper": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundChatPacket": Internal.ClassInfo, "com.jaquadro.minecraft.storagedrawers.block.EnumKeyType": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties$DisplayStatus": Internal.ClassInfo, "dev.latvian.mods.kubejs.util.Lazy": Internal.ClassInfo, "dev.ftb.mods.ftblibrary.core.DisplayInfoFTBL": Internal.ClassInfo, "net.minecraftforge.client.extensions.IForgeFont": Internal.ClassInfo, "javax.swing.text.StyleConstants$ParagraphConstants": Internal.ClassInfo, "com.benbenlaw.caveopolis.block.custom.brightblock.BrightFullBlock": Internal.ClassInfo, "net.minecraftforge.client.event.ScreenEvent$Init$Pre": Internal.ClassInfo, "software.bernie.geckolib.core.animation.AnimatableManager$ControllerRegistrar": Internal.ClassInfo, "vectorwing.farmersdelight.common.block.RiceBlock": Internal.ClassInfo, "net.minecraftforge.client.event.MovementInputUpdateEvent": Internal.ClassInfo, "com.mojang.datafixers.Products$P13": Internal.ClassInfo, "com.mojang.datafixers.Products$P14": Internal.ClassInfo, "com.mojang.datafixers.Products$P11": Internal.ClassInfo, "com.mojang.datafixers.Products$P12": Internal.ClassInfo, "net.minecraft.world.level.block.entity.LidBlockEntity": Internal.ClassInfo, "net.minecraftforge.client.event.ClientPlayerNetworkEvent$LoggingIn": Internal.ClassInfo, "com.mojang.datafixers.Products$P10": Internal.ClassInfo, "net.minecraft.server.packs.repository.Pack$Position": Internal.ClassInfo, "letsforge_pirates.item.SailorBlueTier1Item$Chestplate": Internal.ClassInfo, "com.obscuria.aquamirae.common.items.RuneOfTheStormItem": Internal.ClassInfo, "net.minecraftforge.common.util.Lazy": Internal.ClassInfo, "com.mojang.datafixers.Products$P15": Internal.ClassInfo, "com.mojang.datafixers.Products$P16": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider": Internal.ClassInfo, "java.awt.datatransfer.FlavorEvent": Internal.ClassInfo, "net.minecraft.world.entity.ai.control.MoveControl": Internal.ClassInfo, "javax.swing.Icon": Internal.ClassInfo, "net.minecraft.world.level.block.BushBlock": Internal.ClassInfo, "com.electronwill.nightconfig.core.utils.UnmodifiableConfigWrapper": Internal.ClassInfo, "net.minecraft.world.entity.animal.Chicken": Internal.ClassInfo, "net.minecraft.nbt.CompoundTag": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.BasaltPillarFeature": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.crafting.recipe.SouliumSpawnerRecipe": Internal.ClassInfo, "net.minecraftforge.common.extensions.IForgeBlock": Internal.ClassInfo, "net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher": Internal.ClassInfo, "net.minecraft.world.entity.npc.WanderingTrader": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.block.ReprocessorBlock": Internal.ClassInfo, "net.minecraft.world.level.block.BaseRailBlock": Internal.ClassInfo, "net.minecraft.client.quickplay.QuickPlayLog": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeWrapper": Internal.ClassInfo, "net.minecraft.world.level.block.entity.BeaconBlockEntity$BeaconBeamSection": Internal.ClassInfo, "dev.ftb.mods.ftbquests.item.MissingItem": Internal.ClassInfo, "net.mcreator.cozyhome.block.MangroveSinkCounterBlock": Internal.ClassInfo, "net.mehvahdjukaar.moonlight.api.client.model.forge.ExtraModelDataImpl": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.api.soul.ISoulSiphoningItem": Internal.ClassInfo, "net.minecraft.world.level.levelgen.feature.DiskFeature": Internal.ClassInfo, "net.minecraft.world.level.block.BrushableBlock": Internal.ClassInfo, "cofh.thermal.core.common.fluid.RefinedFuelFluid$1": Internal.ClassInfo, "net.minecraft.world.level.chunk.LightChunkGetter": Internal.ClassInfo, "dev.latvian.mods.kubejs.recipe.special.SpecialRecipeSerializerManager": Internal.ClassInfo, "net.minecraft.network.protocol.game.ServerboundSetBeaconPacket": Internal.ClassInfo, "net.mcreator.cozyhome.block.JungleSinkCounterBlock": Internal.ClassInfo, "net.minecraft.util.ExtraCodecs$TagOrElementLocation": Internal.ClassInfo, "com.mojang.serialization.DataResult$PartialResult": Internal.ClassInfo, "net.minecraft.world.level.block.WeatheringCopperStairBlock": Internal.ClassInfo, "net.minecraftforge.common.crafting.conditions.ICondition$IContext": Internal.ClassInfo, "net.minecraft.util.valueproviders.WeightedListInt": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.compacting.CompactingUpgradeWrapper": Internal.ClassInfo, "net.minecraft.world.item.ElytraItem": Internal.ClassInfo, "net.minecraft.client.tutorial.Tutorial": Internal.ClassInfo, "com.buuz135.industrial.block.MachineFrameBlock$MachineFrameItem": Internal.ClassInfo, "net.mcreator.cozyhome.block.SpruceMirrorStandBlock": Internal.ClassInfo, "dev.latvian.mods.kubejs.player.InventoryEventJS": Internal.ClassInfo, "net.mehvahdjukaar.supplementaries.common.items.SliceMapItem": Internal.ClassInfo, "cofh.lib.api.block.IDismantleable": Internal.ClassInfo, "net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeItem": Internal.ClassInfo, "com.blakebr0.mysticalagriculture.item.tool.EssencePickaxeItem": Internal.ClassInfo};
    }
    type ClassInfo_ = ClassInfo;
    class EnderChestBlock extends Internal.AbstractChestBlock<Internal.EnderChestBlockEntity> implements Internal.SimpleWaterloggedBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type EnderChestBlock_ = EnderChestBlock;
    abstract class URLConnection {
        setIfModifiedSince(arg0: number): void;
        getHeaderFieldLong(arg0: string, arg1: number): number;
        getContentLengthLong(): number;
        /**
         * @deprecated
        */
        static getDefaultRequestProperty(arg0: string): string;
        getConnectTimeout(): number;
        static setFileNameMap(arg0: Internal.FileNameMap_): void;
        getRequestProperty(arg0: string): string;
        setDoInput(arg0: boolean): void;
        setUseCaches(arg0: boolean): void;
        setDoOutput(arg0: boolean): void;
        getContentLength(): number;
        static setDefaultAllowUserInteraction(arg0: boolean): void;
        getContent(arg0: typeof any[]): any;
        getUseCaches(): boolean;
        getIfModifiedSince(): number;
        getHeaderField(arg0: string): string;
        getContent(): any;
        getURL(): Internal.URL;
        getDoOutput(): boolean;
        static getDefaultUseCaches(arg0: string): boolean;
        setConnectTimeout(arg0: number): void;
        getDoInput(): boolean;
        abstract connect(): void;
        getReadTimeout(): number;
        getRequestProperties(): Internal.Map<string, Internal.List<string>>;
        getHeaderField(arg0: number): string;
        getContentEncoding(): string;
        /**
         * @deprecated
        */
        static setDefaultRequestProperty(arg0: string, arg1: string): void;
        setAllowUserInteraction(arg0: boolean): void;
        getInputStream(): Internal.InputStream;
        getDate(): number;
        static guessContentTypeFromStream(arg0: Internal.InputStream_): string;
        setReadTimeout(arg0: number): void;
        static getDefaultAllowUserInteraction(): boolean;
        getOutputStream(): Internal.OutputStream;
        getPermission(): Internal.Permission;
        getHeaderFieldInt(arg0: string, arg1: number): number;
        getLastModified(): number;
        static getFileNameMap(): Internal.FileNameMap;
        getDefaultUseCaches(): boolean;
        getAllowUserInteraction(): boolean;
        addRequestProperty(arg0: string, arg1: string): void;
        getHeaderFields(): Internal.Map<string, Internal.List<string>>;
        getHeaderFieldKey(arg0: number): string;
        static setContentHandlerFactory(arg0: Internal.ContentHandlerFactory_): void;
        setRequestProperty(arg0: string, arg1: string): void;
        getExpiration(): number;
        setDefaultUseCaches(arg0: boolean): void;
        getHeaderFieldDate(arg0: string, arg1: number): number;
        static setDefaultUseCaches(arg0: string, arg1: boolean): void;
        static guessContentTypeFromName(arg0: string): string;
        getContentType(): string;
        set ifModifiedSince(arg0: number)
        get contentLengthLong(): number
        get connectTimeout(): number
        set fileNameMap(arg0: Internal.FileNameMap_)
        set doInput(arg0: boolean)
        set useCaches(arg0: boolean)
        set doOutput(arg0: boolean)
        get contentLength(): number
        set defaultAllowUserInteraction(arg0: boolean)
        get useCaches(): boolean
        get ifModifiedSince(): number
        get content(): any
        get URL(): Internal.URL
        get doOutput(): boolean
        set connectTimeout(arg0: number)
        get doInput(): boolean
        get readTimeout(): number
        get requestProperties(): Internal.Map<string, Internal.List<string>>
        get contentEncoding(): string
        set allowUserInteraction(arg0: boolean)
        get inputStream(): Internal.InputStream
        get date(): number
        set readTimeout(arg0: number)
        get defaultAllowUserInteraction(): boolean
        get outputStream(): Internal.OutputStream
        get permission(): Internal.Permission
        get lastModified(): number
        get fileNameMap(): Internal.FileNameMap
        get defaultUseCaches(): boolean
        get allowUserInteraction(): boolean
        get headerFields(): Internal.Map<string, Internal.List<string>>
        set contentHandlerFactory(arg0: Internal.ContentHandlerFactory_)
        get expiration(): number
        set defaultUseCaches(arg0: boolean)
        get contentType(): string
    }
    type URLConnection_ = URLConnection;
    interface IJeiConfigCategory {
        abstract getName(): string;
        abstract getConfigValues(): Internal.Collection<Internal.IJeiConfigValue<any>>;
        get name(): string
        get configValues(): Internal.Collection<Internal.IJeiConfigValue<any>>
    }
    type IJeiConfigCategory_ = IJeiConfigCategory;
    class ArrowKnockbackEnchantment extends Internal.Enchantment {
        constructor(arg0: Internal.Enchantment$Rarity_, ...arg1: Internal.EquipmentSlot_[])
        allowedInCreativeTab(arg0: Internal.Item_, arg1: Internal.Set_<Internal.EnchantmentCategory>): boolean;
        getDamageBonus(arg0: number, arg1: Internal.MobType_, arg2: Internal.ItemStack_): number;
    }
    type ArrowKnockbackEnchantment_ = ArrowKnockbackEnchantment;
    class SteamFluid$Flowing extends Internal.SteamFluid$SteamFlowingFluid {
        constructor(arg0: any_, arg1: any_)
        getAdjacentBlockPathType(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        getExplosionResistance(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        canHydrate(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: BlockPos_): boolean;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        getBlockPathType(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: boolean): Internal.BlockPathTypes;
        supportsBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_): boolean;
        arch$registryName(): ResourceLocation;
        canExtinguish(arg0: Internal.FluidState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        shouldUpdateWhileBoating(arg0: Internal.FluidState_, arg1: Internal.Boat_, arg2: Internal.Entity_): boolean;
    }
    type SteamFluid$Flowing_ = SteamFluid$Flowing;
    class FarmersDelightCompatImpl$TomatoStickBlock extends Internal.FarmersDelightCompatImpl$TomatoLoggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        getPlantType(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.PlantType;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly AXIS_Z: Internal.BooleanProperty;
        static readonly AXIS_X: Internal.BooleanProperty;
    }
    type FarmersDelightCompatImpl$TomatoStickBlock_ = FarmersDelightCompatImpl$TomatoStickBlock;
    class ModuleDescriptor$Opens$Modifier extends Internal.Enum<Internal.ModuleDescriptor$Opens$Modifier> {
        static valueOf(arg0: string): Internal.ModuleDescriptor$Opens$Modifier;
        static values(): Internal.ModuleDescriptor$Opens$Modifier[];
        static readonly MANDATED: Internal.ModuleDescriptor$Opens$Modifier;
        static readonly SYNTHETIC: Internal.ModuleDescriptor$Opens$Modifier;
    }
    type ModuleDescriptor$Opens$Modifier_ = "mandated" | ModuleDescriptor$Opens$Modifier | "synthetic";
    class BlockEvent$EntityPlaceEvent extends Internal.BlockEvent {
        constructor()
        constructor(arg0: Internal.BlockSnapshot_, arg1: Internal.BlockState_, arg2: Internal.Entity_)
        getEntity(): Internal.Entity;
        getBlockSnapshot(): Internal.BlockSnapshot;
        getPlacedAgainst(): Internal.BlockState;
        getPlacedBlock(): Internal.BlockState;
        get entity(): Internal.Entity
        get blockSnapshot(): Internal.BlockSnapshot
        get placedAgainst(): Internal.BlockState
        get placedBlock(): Internal.BlockState
    }
    type BlockEvent$EntityPlaceEvent_ = BlockEvent$EntityPlaceEvent;
    interface InputFluid extends Internal.InputReplacement, Internal.FluidLike {
        replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
        abstract getAmount(): number;
        matches(other: Internal.FluidLike_): boolean;
        of(o: any): Internal.InputReplacement;
        transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
        copy(amount: number): Internal.FluidLike;
        isEmpty(): boolean;
        get amount(): number
        get empty(): boolean
        (): number;
    }
    type InputFluid_ = InputFluid | Internal.FluidStackJS_;
    class ModuleLayer$Controller {
        addExports(arg0: Internal.Module_, arg1: string, arg2: Internal.Module_): this;
        layer(): Internal.ModuleLayer;
        addOpens(arg0: Internal.Module_, arg1: string, arg2: Internal.Module_): this;
        addReads(arg0: Internal.Module_, arg1: Internal.Module_): this;
    }
    type ModuleLayer$Controller_ = ModuleLayer$Controller;
    abstract class SinglePieceStructure extends Internal.Structure {
        findGenerationPoint(arg0: Internal.Structure$GenerationContext_): Internal.Optional<Internal.Structure$GenerationStub>;
    }
    type SinglePieceStructure_ = SinglePieceStructure;
    abstract class BlockBehaviour$BlockStateBase extends Internal.StateHolder<Internal.Block, Internal.BlockState> implements Internal.BlockStateKJS {
        randomTick(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: Internal.RandomSource_): void;
        canOcclude(): boolean;
        handler$zfg000$getOffset(level: Internal.BlockGetter_, pos: BlockPos_, offsetFunction: Internal.BlockBehaviour$OffsetFunction_, cir: Internal.CallbackInfoReturnable_<any>): void;
        updateNeighbourShapes(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: number): void;
        getShape(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.CollisionContext_): Internal.VoxelShape;
        getLightBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): number;
        getSignal(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Direction_): number;
        tick(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: Internal.RandomSource_): void;
        /**
         * @deprecated
        */
        getLightEmission(): number;
        updateNeighbourShapes(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: number, arg3: number): void;
        getTicker<T extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getInteractionShape(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.VoxelShape;
        is(arg0: Internal.TagKey_<Internal.Block>): boolean;
        useShapeForLightOcclusion(): boolean;
        initCache(): void;
        setLightEmission(arg0: number): void;
        isRandomlyTicking(): boolean;
        shouldSpawnParticlesOnBreak(): boolean;
        isSolidRender(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        isPathfindable(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.PathComputationType_): boolean;
        getVisualShape(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.CollisionContext_): Internal.VoxelShape;
        ignitedByLava(): boolean;
        canSurvive(arg0: Internal.LevelReader_, arg1: BlockPos_): boolean;
        /**
         * @deprecated
        */
        rotate(arg0: Internal.Rotation_): Internal.BlockState;
        setDestroySpeed(arg0: number): void;
        is(arg0: Internal.HolderSet_<Internal.Block>): boolean;
        isFaceSturdy(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Direction_): boolean;
        onRemove(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: boolean): void;
        getSeed(arg0: BlockPos_): number;
        getMenuProvider(arg0: Internal.Level_, arg1: BlockPos_): Internal.MenuProvider;
        getBlockSupportShape(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.VoxelShape;
        spawnAfterBreak(arg0: Internal.ServerLevel_, arg1: BlockPos_, arg2: Internal.ItemStack_, arg3: boolean): void;
        onPlace(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: boolean): void;
        getBlock(): Internal.Block;
        getCollisionShape(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.CollisionContext_): Internal.VoxelShape;
        /**
         * @deprecated
        */
        liquid(): boolean;
        getOcclusionShape(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.VoxelShape;
        is(arg0: Internal.Block_): boolean;
        isViewBlocking(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getFluidState(): Internal.FluidState;
        getShape(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.VoxelShape;
        emissiveRendering(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        mirror(arg0: Internal.Mirror_): Internal.BlockState;
        getTags(): Internal.Stream<Internal.TagKey<Internal.Block>>;
        instrument(): Internal.NoteBlockInstrument;
        isAir(): boolean;
        getDestroySpeed(arg0: Internal.BlockGetter_, arg1: BlockPos_): number;
        getDirectSignal(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Direction_): number;
        /**
         * @deprecated
        */
        blocksMotion(): boolean;
        hasBlockEntity(): boolean;
        isValidSpawn(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.EntityType_<any>): boolean;
        hasAnalogOutputSignal(): boolean;
        hasOffsetFunction(): boolean;
        setRequiresTool(arg0: boolean): void;
        hasLargeCollisionShape(): boolean;
        getDestroyProgress(arg0: Internal.Player_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        getRenderShape(): Internal.RenderShape;
        updateShape(arg0: Internal.Direction_, arg1: Internal.BlockState_, arg2: Internal.LevelAccessor_, arg3: BlockPos_, arg4: BlockPos_): Internal.BlockState;
        isSuffocating(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getPistonPushReaction(): Internal.PushReaction;
        skipRendering(arg0: Internal.BlockState_, arg1: Internal.Direction_): boolean;
        getDrops(arg0: Internal.LootParams$Builder_): Internal.List<Internal.ItemStack>;
        isFaceSturdy(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Direction_, arg3: Internal.SupportType_): boolean;
        is(arg0: Internal.TagKey_<Internal.Block>, arg1: Internal.Predicate_<Internal.BlockBehaviour$BlockStateBase>): boolean;
        hasPostProcess(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        /**
         * @deprecated
        */
        isSolid(): boolean;
        /**
         * @deprecated
        */
        neighborChanged(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Block_, arg3: BlockPos_, arg4: boolean): void;
        updateIndirectNeighbourShapes(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: number, arg3: number): void;
        getFaceOcclusionShape(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Direction_): Internal.VoxelShape;
        isRedstoneConductor(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getShadeBrightness(arg0: Internal.BlockGetter_, arg1: BlockPos_): number;
        entityInside(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Entity_): void;
        getAnalogOutputSignal(arg0: Internal.Level_, arg1: BlockPos_): number;
        updateIndirectNeighbourShapes(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: number): void;
        use(arg0: Internal.Level_, arg1: Internal.Player_, arg2: Internal.InteractionHand_, arg3: Internal.BlockHitResult_): InteractionResult;
        getMapColor(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.MapColor;
        entityCanStandOn(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Entity_): boolean;
        getBlockHolder(): Internal.Holder<Internal.Block>;
        canBeReplaced(): boolean;
        propagatesSkylightDown(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        onProjectileHit(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockHitResult_, arg3: Internal.Projectile_): void;
        isCollisionShapeFullBlock(arg0: Internal.BlockGetter_, arg1: BlockPos_): boolean;
        getCollisionShape(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.VoxelShape;
        getOffset(arg0: Internal.BlockGetter_, arg1: BlockPos_): Vec3d;
        getSoundType(): SoundType;
        entityCanStandOnFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.Entity_, arg3: Internal.Direction_): boolean;
        triggerEvent(arg0: Internal.Level_, arg1: BlockPos_, arg2: number, arg3: number): boolean;
        requiresCorrectToolForDrops(): boolean;
        canBeReplaced(arg0: Internal.Fluid_): boolean;
        isSignalSource(): boolean;
        canBeReplaced(arg0: Internal.BlockPlaceContext_): boolean;
        attack(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Player_): void;
        /**
         * @deprecated
        */
        get lightEmission(): number
        set lightEmission(arg0: number)
        get randomlyTicking(): boolean
        set destroySpeed(arg0: number)
        get block(): Internal.Block
        get fluidState(): Internal.FluidState
        get tags(): Internal.Stream<Internal.TagKey<Internal.Block>>
        get air(): boolean
        set requiresTool(arg0: boolean)
        get renderShape(): Internal.RenderShape
        get pistonPushReaction(): Internal.PushReaction
        /**
         * @deprecated
        */
        get solid(): boolean
        get blockHolder(): Internal.Holder<Internal.Block>
        get soundType(): SoundType
        get signalSource(): boolean
        destroySpeed: number;
    }
    type BlockBehaviour$BlockStateBase_ = BlockBehaviour$BlockStateBase;
    class ArrayVoxelShape extends Internal.VoxelShape {
    }
    type ArrayVoxelShape_ = ArrayVoxelShape;
    class RuntimeException extends Internal.Exception {
        constructor()
        constructor(arg0: string, arg1: Internal.Throwable_)
        constructor(arg0: Internal.Throwable_)
        constructor(arg0: string)
    }
    type RuntimeException_ = RuntimeException;
    class MultipartBlockStateGenerator {
        constructor()
        part(when: string, model: string): void;
        part(when: string, consumer: Internal.Consumer_<Internal.MultipartBlockStateGenerator$Part>): void;
        toJson(): Internal.JsonObject;
    }
    type MultipartBlockStateGenerator_ = MultipartBlockStateGenerator;
    class DocumentField extends Internal.AbstractDocument<Internal.DocumentField> {
        constructor()
        isFinal(): boolean;
        merge(arg0: Internal.AbstractDocumentBase_<any>): Internal.AbstractDocumentBase<any>;
        static fromJava(info: Internal.FieldInfo_): Internal.DocumentField;
        getType(): Internal.PropertyType<any>;
        applyProperties(): Internal.AbstractDocumentBase<any>;
        setFinal(aFinal: boolean): void;
        setStatic(aStatic: boolean): void;
        isShouldGSON(): boolean;
        merge(other: Internal.DocumentField_): this;
        copy(): this;
        getValue(): Internal.PropertyValue<any, any>;
        setName(name: string): void;
        getName(): string;
        isStatic(): boolean;
        get "final"(): boolean
        get type(): Internal.PropertyType<any>
        set "final"(aFinal: boolean)
        set "static"(aStatic: boolean)
        get shouldGSON(): boolean
        get value(): Internal.PropertyValue<any, any>
        set name(name: string)
        get name(): string
        get "static"(): boolean
    }
    type DocumentField_ = DocumentField;
    class ModelGenerator$Face {
        constructor()
        tintindex(i: number): this;
        uv(u0: number, v0: number, u1: number, v1: number): this;
        cull(d: Internal.Direction_): this;
        cull(): this;
        toJson(): Internal.JsonObject;
        tex(t: string): this;
    }
    type ModelGenerator$Face_ = ModelGenerator$Face;
    class ThreeLayersFeatureSize extends Internal.FeatureSize {
        constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Internal.OptionalInt_)
        static readonly CODEC: Internal.Codec<Internal.ThreeLayersFeatureSize>;
    }
    type ThreeLayersFeatureSize_ = ThreeLayersFeatureSize;
    class RecipeJS implements Internal.CustomJavaToJsWrapper, Internal.RecipeKJS {
        constructor()
        /**
         * @deprecated
        */
        getGroup(): string;
        convertJavaToJs(cx: Internal.Context_, scope: Internal.Scriptable_, staticType: typeof any): Internal.Scriptable;
        getSerializationTypeFunction(): Internal.RecipeTypeFunction;
        inputValues(): Internal.RecipeComponentValue<any>[];
        /**
         * **NOTE**: Only valid via calling `recipes.kubejs.shaped` or `recipes.kubejs.shapeless`
         * 
        */
        replaceIngredient(filter: Internal.IngredientActionFilter_, item: Internal.ItemStack_): this;
        /**
         * **NOTE**: Only valid via calling `recipes.kubejs.shaped` or `recipes.kubejs.shapeless`
         * 
        */
        customIngredientAction(filter: Internal.IngredientActionFilter_, id: string): this;
        remove(): void;
        writeOutputFluid(value: Internal.OutputFluid_): Internal.JsonElement;
        stage(s: string): this;
        readOutputFluid(from: any): Internal.OutputFluid;
        inputItemHasPriority(from: any): boolean;
        getOriginalRecipe(): Internal.Recipe<any>;
        group(g: string): this;
        hasChanged(): boolean;
        initValues(created: boolean): void;
        createRecipe(): Internal.Recipe<any>;
        readInputItem(from: any): InputItem;
        /**
         * **NOTE**: Only valid via calling `recipes.kubejs.shaped` or `recipes.kubejs.shapeless`
         * 
        */
        modifyResult(callback: Internal.ModifyRecipeResultCallback_): this;
        outputItemHasPriority(from: any): boolean;
        get(key: string): any;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        id(_id: ResourceLocation_): this;
        /**
         * @deprecated
        */
        getType(): ResourceLocation;
        getOriginalRecipeResult(): Internal.ItemStack;
        inputFluidHasPriority(from: any): boolean;
        setValue<T>(key: Internal.RecipeKey_<T>, value: T): this;
        readInputFluid(from: any): Internal.InputFluid;
        set(key: string, value: any): this;
        getAllValueMap(): Internal.Map<string, Internal.RecipeComponentValue<any>>;
        getFromToString(): string;
        outputFluidHasPriority(from: any): boolean;
        writeInputItem(value: InputItem_): Internal.JsonElement;
        outputValues(): Internal.RecipeComponentValue<any>[];
        /**
         * @deprecated
        */
        getSchema(): Internal.RecipeSchema;
        deserialize(merge: boolean): void;
        writeOutputItem(value: OutputItem_): Internal.JsonElement;
        ingredientAction(filter: Internal.IngredientActionFilter_, action: Internal.IngredientAction_): this;
        getValue<T>(key: Internal.RecipeKey_<T>): T;
        serialize(): void;
        getPath(): string;
        /**
         * **NOTE**: Only valid via calling `recipes.kubejs.shaped` or `recipes.kubejs.shapeless`
         * 
        */
        keepIngredient(filter: Internal.IngredientActionFilter_): this;
        getMod(): string;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        writeInputFluid(value: Internal.InputFluid_): Internal.JsonElement;
        /**
         * **NOTE**: Only valid via calling `recipes.kubejs.shaped` or `recipes.kubejs.shapeless`
         * 
        */
        damageIngredient(filter: Internal.IngredientActionFilter_): this;
        getId(): string;
        save(): void;
        afterLoaded(): void;
        /**
         * @deprecated
        */
        setGroup(group: string): void;
        /**
         * @deprecated
        */
        getOrCreateId(): ResourceLocation;
        merge(j: Internal.JsonObject_): this;
        damageIngredient(filter: Internal.IngredientActionFilter_, damage: number): this;
        readOutputItem(from: any): OutputItem;
        getOriginalRecipeIngredients(): Internal.List<Internal.Ingredient>;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        /**
         * @deprecated
        */
        get group(): string
        get serializationTypeFunction(): Internal.RecipeTypeFunction
        get originalRecipe(): Internal.Recipe<any>
        /**
         * @deprecated
        */
        get type(): ResourceLocation
        get originalRecipeResult(): Internal.ItemStack
        get allValueMap(): Internal.Map<string, Internal.RecipeComponentValue<any>>
        get fromToString(): string
        /**
         * @deprecated
        */
        get schema(): Internal.RecipeSchema
        get path(): string
        get mod(): string
        get id(): string
        /**
         * @deprecated
        */
        set group(group: string)
        /**
         * @deprecated
        */
        get orCreateId(): ResourceLocation
        get originalRecipeIngredients(): Internal.List<Internal.Ingredient>
        type: Internal.RecipeTypeFunction;
        removed: boolean;
        originalJson: Internal.JsonObject;
        json: Internal.JsonObject;
        newRecipe: boolean;
        changed: boolean;
        static itemErrors: false;
        id: ResourceLocation;
        modifyResult: Internal.ModifyRecipeResultCallback;
    }
    type RecipeJS_ = RecipeJS;
    class TeamArgument$Info implements Internal.ArgumentTypeInfo<Internal.TeamArgument, Internal.TeamArgument$Info$Template> {
        constructor()
        unpack(argumentType: Internal.TeamArgument_): Internal.TeamArgument$Info$Template;
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        serializeToNetwork(template: Internal.TeamArgument$Info$Template_, friendlyByteBuf: Internal.FriendlyByteBuf_): void;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        serializeToJson(template: Internal.TeamArgument$Info$Template_, jsonObject: Internal.JsonObject_): void;
        deserializeFromNetwork(friendlyByteBuf: Internal.FriendlyByteBuf_): Internal.TeamArgument$Info$Template;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
    }
    type TeamArgument$Info_ = TeamArgument$Info;
    class TrappedChestBlockEntity extends Internal.ChestBlockEntity {
        constructor(arg0: BlockPos_, arg1: Internal.BlockState_)
        count(ingredient: Internal.Ingredient_): number;
        static tryClear(arg0: any): void;
        count(): number;
        requestModelDataUpdate(): void;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        countItem(arg0: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        canPlaceItem(arg0: number, arg1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf(arg0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        onLoad(): void;
        serializeNBT(): Internal.Tag;
        static stillValidBlockEntity(arg0: Internal.BlockEntity_, arg1: Internal.Player_, arg2: number): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        hasAnyMatching(arg0: Internal.Predicate_<Internal.ItemStack>): boolean;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        onDataPacket(arg0: Internal.Connection_, arg1: Internal.ClientboundBlockEntityDataPacket_): void;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        deserializeNBT(arg0: Internal.Tag_): void;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        static stillValidBlockEntity(arg0: Internal.BlockEntity_, arg1: Internal.Player_): boolean;
        canTakeItem(arg0: net.minecraft.world.Container_, arg1: number, arg2: Internal.ItemStack_): boolean;
        hasCustomName(): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getModelData(): Internal.ModelData;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        getRenderBoundingBox(): Internal.AABB;
        get empty(): boolean
        get slots(): number
        get height(): number
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get modelData(): Internal.ModelData
        get mutable(): boolean
        get renderBoundingBox(): Internal.AABB
    }
    type TrappedChestBlockEntity_ = TrappedChestBlockEntity;
    class KnockbackEnchantment extends Internal.Enchantment {
        allowedInCreativeTab(arg0: Internal.Item_, arg1: Internal.Set_<Internal.EnchantmentCategory>): boolean;
        getDamageBonus(arg0: number, arg1: Internal.MobType_, arg2: Internal.ItemStack_): number;
    }
    type KnockbackEnchantment_ = KnockbackEnchantment;
    abstract class RenderingHints$Key {
        abstract isCompatibleValue(arg0: any): boolean;
    }
    type RenderingHints$Key_ = RenderingHints$Key;
    class DistanceEnchantment extends Internal.Enchantment {
        constructor(...arg0: Internal.EquipmentSlot_[])
        allowedInCreativeTab(arg0: Internal.Item_, arg1: Internal.Set_<Internal.EnchantmentCategory>): boolean;
        getDamageBonus(arg0: number, arg1: Internal.MobType_, arg2: Internal.ItemStack_): number;
    }
    type DistanceEnchantment_ = DistanceEnchantment;
    class TextureAtlas extends Internal.AbstractTexture implements Internal.Tickable, Internal.Dumpable {
        constructor(arg0: ResourceLocation_)
        upload(arg0: Internal.SpriteLoader$Preparations_): void;
        maxSupportedTextureSize(): number;
        getSprite(arg0: ResourceLocation_): Internal.TextureAtlasSprite;
        dumpContents(arg0: ResourceLocation_, arg1: Internal.Path_): void;
        location(): ResourceLocation;
        getTextureLocations(): Internal.Set<ResourceLocation>;
        updateFilter(arg0: Internal.SpriteLoader$Preparations_): void;
        cycleAnimationFrames(): void;
        clearTextureData(): void;
        tick(): void;
        get textureLocations(): Internal.Set<ResourceLocation>
        /**
         * @deprecated
        */
        static readonly LOCATION_BLOCKS: ResourceLocation;
        texturesByName: Internal.Map<ResourceLocation, Internal.TextureAtlasSprite>;
        /**
         * @deprecated
        */
        static readonly LOCATION_PARTICLES: ResourceLocation;
    }
    type TextureAtlas_ = TextureAtlas;
    class TreeExtractorMapping extends cofh.lib.util.recipes.SerializableRecipe {
        constructor(arg0: ResourceLocation_, arg1: Internal.Block_, arg2: Internal.Block_, arg3: Internal.FluidStack_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getFluid(): Internal.FluidStack;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        getLeaves(): Internal.Block;
        setGroup(group: string): void;
        getTrunk(): Internal.Block;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getRemainingItems(arg0: Internal.FalseIInventory_): Internal.NonNullList<Internal.ItemStack>;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get fluid(): Internal.FluidStack
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        get leaves(): Internal.Block
        set group(group: string)
        get trunk(): Internal.Block
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type TreeExtractorMapping_ = TreeExtractorMapping;
    class TimberFrameItem extends net.mehvahdjukaar.moonlight.api.item.FuelBlockItem {
        constructor(block: Internal.Block_, properties: Internal.Item$Properties_)
        constructor(block: Internal.Block_, properties: Internal.Item$Properties_, burnTicks: number)
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        setDigSpeed(speed: number): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): InteractionResult;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        setAttackSpeed(attackSpeed: number): void;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        canApplyAtEnchantingTable(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): boolean;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        setArmorToughness(armorToughness: number): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type TimberFrameItem_ = TimberFrameItem;
    class HideJEIEventJS <T> extends Internal.EventJS {
        constructor(r: Internal.IJeiRuntime_, t: Internal.IIngredientType_<T>, f: Internal.Function_<any, Internal.Predicate<T>>, i: Internal.Predicate_<T>)
        getAllIngredients(): Internal.Collection<T>;
        hide(o: any): void;
        hideAll(): void;
        get allIngredients(): Internal.Collection<T>
    }
    type HideJEIEventJS_<T> = HideJEIEventJS<T>;
    class ScreenPosition extends Internal.Record {
        constructor(arg0: number, arg1: number)
        step(arg0: Internal.ScreenDirection_): this;
        y(): number;
        x(): number;
        static of(arg0: Internal.ScreenAxis_, arg1: number, arg2: number): Internal.ScreenPosition;
        getCoordinate(arg0: Internal.ScreenAxis_): number;
    }
    type ScreenPosition_ = ScreenPosition;
    interface PacketSendListener {
        onSuccess(): void;
        onFailure(): Internal.Packet<any>;
        thenRun(arg0: Internal.Runnable_): this;
        exceptionallySend(arg0: Internal.Supplier_<Internal.Packet<any>>): this;
    }
    type PacketSendListener_ = PacketSendListener;
    class MendingEnchantment extends Internal.Enchantment {
        constructor(arg0: Internal.Enchantment$Rarity_, ...arg1: Internal.EquipmentSlot_[])
        allowedInCreativeTab(arg0: Internal.Item_, arg1: Internal.Set_<Internal.EnchantmentCategory>): boolean;
        getDamageBonus(arg0: number, arg1: Internal.MobType_, arg2: Internal.ItemStack_): number;
    }
    type MendingEnchantment_ = MendingEnchantment;
    interface DeferredSupplier <T> extends Internal.OptionalSupplier<T> {
        getKey(): Internal.ResourceKey<T>;
        stream(): Internal.Stream<T>;
        ifPresent(action: Internal.Consumer_<T>): void;
        orElseGet(supplier: Internal.Supplier_<T>): T;
        ifPresentOrElse(action: Internal.Consumer_<T>, emptyAction: Internal.Runnable_): void;
        getRegistryKey(): Internal.ResourceKey<Internal.Registry<T>>;
        getOrNull(): T;
        orElse(other: T): T;
        abstract getId(): ResourceLocation;
        abstract isPresent(): boolean;
        abstract getRegistryId(): ResourceLocation;
        abstract get(): T;
        toOptional(): Internal.Optional<T>;
        get key(): Internal.ResourceKey<T>
        get registryKey(): Internal.ResourceKey<Internal.Registry<T>>
        get orNull(): T
        get id(): ResourceLocation
        get present(): boolean
        get registryId(): ResourceLocation
    }
    type DeferredSupplier_<T> = DeferredSupplier<T>;
    interface Object2FloatFunction <K> extends it.unimi.dsi.fastutil.Function<K, number>, Internal.ToDoubleFunction<K> {
        andThenObject<T>(arg0: Internal.Float2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        andThenChar(arg0: Internal.Float2CharFunction_): Internal.Object2CharFunction<K>;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2FloatFunction;
        removeFloat(arg0: any): number;
        defaultReturnValue(arg0: number): void;
        andThenShort(arg0: Internal.Float2ShortFunction_): Internal.Object2ShortFunction<K>;
        andThenReference<T>(arg0: Internal.Float2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        andThenByte(arg0: Internal.Float2ByteFunction_): Internal.Object2ByteFunction<K>;
        getOrDefault(arg0: any, arg1: number): number;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2FloatFunction<T>;
        apply(arg0: K): number;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        containsKey(arg0: any): boolean;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2FloatFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        applyAsDouble(arg0: K): number;
        put(arg0: K, arg1: number): number;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2FloatFunction;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2FloatFunction;
        defaultReturnValue(): number;
        /**
         * @deprecated
        */
        remove(arg0: any): number;
        abstract getFloat(arg0: any): number;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        andThenDouble(arg0: Internal.Float2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2FloatFunction<T>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2FloatFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2FloatFunction;
        size(): number;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2FloatFunction;
        andThenLong(arg0: Internal.Float2LongFunction_): Internal.Object2LongFunction<K>;
        clear(): void;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        identity<T>(): Internal.Function<T, T>;
        andThenFloat(arg0: Internal.Float2FloatFunction_): this;
        andThenInt(arg0: Internal.Float2IntFunction_): Internal.Object2IntFunction<K>;
        (arg0: any): number;
    }
    type Object2FloatFunction_<K> = Object2FloatFunction<K>;
    class SpawnPlacementRegisterEvent extends net.minecraftforge.eventbus.api.Event implements Internal.IModBusEvent {
        constructor()
        constructor(arg0: Internal.Map_<Internal.EntityType<any>, any>)
        register<T extends Internal.Entity>(arg0: Internal.EntityType_<T>, arg1: Internal.SpawnPlacements$Type_, arg2: Internal.Heightmap$Types_, arg3: Internal.SpawnPlacements$SpawnPredicate_<T>, arg4: Internal.SpawnPlacementRegisterEvent$Operation_): void;
        register<T extends Internal.Entity>(arg0: Internal.EntityType_<T>, arg1: Internal.SpawnPlacements$SpawnPredicate_<T>): void;
        register<T extends Internal.Entity>(arg0: Internal.EntityType_<T>, arg1: Internal.SpawnPlacements$SpawnPredicate_<T>, arg2: Internal.SpawnPlacementRegisterEvent$Operation_): void;
    }
    type SpawnPlacementRegisterEvent_ = SpawnPlacementRegisterEvent;
    class MultifaceGrowthConfiguration implements Internal.FeatureConfiguration {
        constructor(arg0: Internal.MultifaceBlock_, arg1: number, arg2: boolean, arg3: boolean, arg4: boolean, arg5: number, arg6: Internal.HolderSet_<Internal.Block>)
        getShuffledDirectionsExcept(arg0: Internal.RandomSource_, arg1: Internal.Direction_): Internal.List<Internal.Direction>;
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        getShuffledDirections(arg0: Internal.RandomSource_): Internal.List<Internal.Direction>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly searchRange: number;
        readonly canBePlacedOn: Internal.HolderSet<Internal.Block>;
        static readonly CODEC: Internal.Codec<Internal.MultifaceGrowthConfiguration>;
        readonly placeBlock: Internal.MultifaceBlock;
        readonly canPlaceOnCeiling: boolean;
        readonly canPlaceOnFloor: boolean;
        readonly canPlaceOnWall: boolean;
        readonly chanceOfSpreading: number;
    }
    type MultifaceGrowthConfiguration_ = MultifaceGrowthConfiguration;
    abstract class AbstractCookingRecipe implements Internal.Recipe<net.minecraft.world.Container> {
        constructor(arg0: Internal.RecipeType_<any>, arg1: ResourceLocation_, arg2: string, arg3: Internal.CookingBookCategory_, arg4: Internal.Ingredient_, arg5: Internal.ItemStack_, arg6: number, arg7: number)
        category(): Internal.CookingBookCategory;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getExperience(): number;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        canCraftInDimensions(arg0: number, arg1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getCookingTime(): number;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get experience(): number
        get special(): boolean
        get cookingTime(): number
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        readonly result: Internal.ItemStack;
    }
    type AbstractCookingRecipe_ = AbstractCookingRecipe;
    abstract class BasicTileBlock <T extends Internal.BasicTile<T>> extends Internal.BasicBlock implements Internal.EntityBlock {
        constructor(arg0: string, arg1: Internal.BlockBehaviour$Properties_, arg2: T)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getTileClass(): T;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        abstract getTileEntityFactory(): Internal.BlockEntityType$BlockEntitySupplier<any>;
        getTile(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.Optional<T>;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        newBlockEntity(arg0: BlockPos_, arg1: Internal.BlockState_): Internal.BlockEntity;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        getTicker<R extends Internal.BlockEntity>(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockEntityType_<R>): Internal.BlockEntityTicker<R>;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        set lightEmission(v: number)
        get tileClass(): T
        set destroySpeed(v: number)
        get tileEntityFactory(): Internal.BlockEntityType$BlockEntitySupplier<any>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type BasicTileBlock_<T extends Internal.BasicTile<T>> = BasicTileBlock<T>;
    class IFluidHandler$FluidAction extends Internal.Enum<Internal.IFluidHandler$FluidAction> {
        simulate(): boolean;
        static valueOf(arg0: string): Internal.IFluidHandler$FluidAction;
        static values(): Internal.IFluidHandler$FluidAction[];
        execute(): boolean;
        static readonly SIMULATE: Internal.IFluidHandler$FluidAction;
        static readonly EXECUTE: Internal.IFluidHandler$FluidAction;
    }
    type IFluidHandler$FluidAction_ = "execute" | "simulate" | IFluidHandler$FluidAction;
    interface WriterSupplier {
        abstract get(): Internal.Writer;
        (): Internal.Writer_;
    }
    type WriterSupplier_ = WriterSupplier;
    interface ServicesKeySet {
        lazy(arg0: Internal.Supplier_<Internal.ServicesKeySet>): this;
        abstract keys(arg0: Internal.ServicesKeyType_): Internal.Collection<Internal.ServicesKeyInfo>;
        (arg0: Internal.ServicesKeyType): Internal.Collection_<Internal.ServicesKeyInfo>;
        readonly EMPTY: Internal.ServicesKeySet;
    }
    type ServicesKeySet_ = ServicesKeySet;
    class MatchingBlockTagPredicate extends Internal.StateTestingPredicate {
        static hasSturdyFace(arg0: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid(arg0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        and(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag(arg0: Vec3i_, arg1: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf(arg0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf(arg0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, arg1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        negate(): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static solid(arg0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static insideWorld(arg0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        or(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag(arg0: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static solid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static alwaysTrue(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks(arg0: Vec3i_, ...arg1: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf(...arg0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks(arg0: Vec3i_, arg1: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static wouldSurvive(arg0: Internal.BlockState_, arg1: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids(arg0: Vec3i_, arg1: Internal.List_<Internal.Fluid>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static not(arg0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids(arg0: Vec3i_, ...arg1: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf(arg0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf(...arg0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf(arg0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, arg1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable(arg0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static hasSturdyFace(arg0: Vec3i_, arg1: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks(arg0: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks(...arg0: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids(...arg0: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static readonly CODEC: Internal.Codec<Internal.MatchingBlockTagPredicate>;
    }
    type MatchingBlockTagPredicate_ = MatchingBlockTagPredicate;
    class CrimsonTableBlock extends Internal.Block {
        constructor()
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
        static readonly BLOCKSTATE: Internal.IntegerProperty;
    }
    type CrimsonTableBlock_ = CrimsonTableBlock;
    class FluidExtractorBlock extends Internal.IndustrialBlock<Internal.FluidExtractorTile> {
        constructor()
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getTileEntityFactory(): Internal.BlockEntityType$BlockEntitySupplier<Internal.FluidExtractorTile>;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        get tileEntityFactory(): Internal.BlockEntityType$BlockEntitySupplier<Internal.FluidExtractorTile>
    }
    type FluidExtractorBlock_ = FluidExtractorBlock;
    class GuiGraphics implements Internal.IForgeGuiGraphics {
        constructor(arg0: Internal.Minecraft_, arg1: Internal.MultiBufferSource$BufferSource_)
        constructor(arg0: Internal.Minecraft_, arg1: Internal.PoseStack_, arg2: Internal.MultiBufferSource$BufferSource_)
        hLine(arg0: Internal.RenderType_, arg1: number, arg2: number, arg3: number, arg4: number): void;
        blitRepeating(arg0: ResourceLocation_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number): void;
        getColorFromFormattingCharacter(arg0: string, arg1: boolean): number;
        blitNineSlicedSized(arg0: ResourceLocation_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number): void;
        renderComponentTooltip(arg0: net.minecraft.client.gui.Font_, arg1: Internal.List_<Internal.FormattedText>, arg2: number, arg3: number, arg4: Internal.ItemStack_): void;
        renderItemDecorations(arg0: net.minecraft.client.gui.Font_, arg1: Internal.ItemStack_, arg2: number, arg3: number): void;
        fillGradient(arg0: Internal.RenderType_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): void;
        renderTooltip(arg0: net.minecraft.client.gui.Font_, arg1: Internal.List_<net.minecraft.network.chat.Component>, arg2: Internal.Optional_<Internal.TooltipComponent>, arg3: number, arg4: number): void;
        vLine(arg0: Internal.RenderType_, arg1: number, arg2: number, arg3: number, arg4: number): void;
        drawString(arg0: net.minecraft.client.gui.Font_, arg1: net.minecraft.network.chat.Component_, arg2: number, arg3: number, arg4: number): number;
        renderItem(arg0: Internal.ItemStack_, arg1: number, arg2: number, arg3: number): void;
        setColor(arg0: number, arg1: number, arg2: number, arg3: number): void;
        enableScissor(arg0: number, arg1: number, arg2: number, arg3: number): void;
        renderItem(arg0: Internal.LivingEntity_, arg1: Internal.ItemStac