/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    abstract class CustomRecipe implements Internal.CraftingRecipe {
        constructor(arg0: ResourceLocation_, arg1: Internal.CraftingBookCategory_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        abstract matches(arg0: Internal.CraftingContainer_, arg1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        abstract canCraftInDimensions(arg0: number, arg1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems(arg0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        abstract assemble(arg0: Internal.CraftingContainer_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        category(): Internal.CraftingBookCategory;
        setGroup(group: string): void;
        abstract getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type CustomRecipe_ = CustomRecipe;
    class DensityFunctions$Clamp extends Internal.Record implements Internal.DensityFunctions$PureTransformer {
        abs(): Internal.DensityFunction;
        halfNegative(): Internal.DensityFunction;
        maxValue(): number;
        codec(): Internal.KeyDispatchDataCodec<Internal.DensityFunction>;
        compute(arg0: Internal.DensityFunction$FunctionContext_): number;
        squeeze(): Internal.DensityFunction;
        transform(arg0: number): number;
        square(): Internal.DensityFunction;
        mapAll(arg0: Internal.DensityFunction$Visitor_): Internal.DensityFunction;
        clamp(arg0: number, arg1: number): Internal.DensityFunction;
        quarterNegative(): Internal.DensityFunction;
        cube(): Internal.DensityFunction;
        fillArray(arg0: number[], arg1: Internal.DensityFunction$ContextProvider_): void;
        minValue(): number;
        input(): Internal.DensityFunction;
        static readonly CODEC: Internal.KeyDispatchDataCodec<Internal.DensityFunctions$Clamp>;
    }
    type DensityFunctions$Clamp_ = DensityFunctions$Clamp;
    class ShockedMobEffect extends Internal.CustomParticleMobEffect {
        constructor(arg0: Internal.MobEffectCategory_, arg1: number)
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        getSortOrder(arg0: Internal.MobEffectInstance_): number;
        get curativeItems(): Internal.List<Internal.ItemStack>
    }
    type ShockedMobEffect_ = ShockedMobEffect;
    abstract class IntProvider {
        constructor()
        abstract getMinValue(): number;
        abstract getType(): Internal.IntProviderType<any>;
        abstract sample(arg0: Internal.RandomSource_): number;
        abstract getMaxValue(): number;
        static codec(arg0: number, arg1: number): Internal.Codec<Internal.IntProvider>;
        static codec<T extends Internal.IntProvider>(arg0: number, arg1: number, arg2: Internal.Codec_<T>): Internal.Codec<T>;
        get minValue(): number
        get type(): Internal.IntProviderType<any>
        get maxValue(): number
        static readonly CODEC: Internal.Codec<Internal.IntProvider>;
        static readonly NON_NEGATIVE_CODEC: Internal.Codec<Internal.IntProvider>;
        static readonly POSITIVE_CODEC: Internal.Codec<Internal.IntProvider>;
    }
    type IntProvider_ = {max_inclusive: number, clamped_normal: Internal.IntProvider_, mean: number, deviation: number, min_inclusive: number} | number | {clamped_normal: Internal.IntProvider_, mean: number, deviation: number, value: number} | {max_inclusive: number, clamped: Internal.IntProvider_, min_inclusive: number} | {clamped_normal: Internal.IntProvider_, mean: number, deviation: number, min: number, max: number} | IntProvider | {clamped: Internal.IntProvider_, bounds: [number, number]} | {clamped: Internal.IntProvider_, min: number, max: number} | {value: number, clamped: Internal.IntProvider_} | [number, number] | {clamped_normal: Internal.IntProvider_, mean: number, deviation: number, bounds: [number, number]};
    class BrainDebugRenderer$PoiInfo {
        constructor(arg0: BlockPos_, arg1: string, arg2: number)
        type: string;
        readonly pos: BlockPos;
        freeTicketCount: number;
    }
    type BrainDebugRenderer$PoiInfo_ = BrainDebugRenderer$PoiInfo;
    class IModFileInfo$LanguageSpec extends Internal.Record {
        constructor(languageName: string, acceptedVersions: Internal.VersionRange_)
        acceptedVersions(): Internal.VersionRange;
        languageName(): string;
    }
    type IModFileInfo$LanguageSpec_ = IModFileInfo$LanguageSpec;
    class Method extends Internal.Executable {
        getReturnType(): typeof any;
        getDefaultValue(): any;
        isBridge(): boolean;
        getGenericReturnType(): Internal.Type;
        getAnnotation<T extends Internal.Annotation>(arg0: T): T;
        getTypeParameters(): any[];
        invoke(arg0: any, ...arg1: any[]): any;
        isDefault(): boolean;
        get returnType(): typeof any
        get defaultValue(): any
        get bridge(): boolean
        get genericReturnType(): Internal.Type
        get typeParameters(): any[]
        get "default"(): boolean
    }
    type Method_ = Method;
    class SofaYellowBlock extends Internal.Block {
        constructor()
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type SofaYellowBlock_ = SofaYellowBlock;
    class ImmutableCollections$SetN <E> extends Internal.ImmutableCollections$AbstractImmutableSet<E> implements Internal.Serializable {
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        forEach(arg0: Internal.Consumer_<E>): void;
        toArray<T>(arg0: T[]): T[];
        parallelStream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        iterator(): Internal.Iterator<E>;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        static of<E>(): Internal.Set<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        stream(): Internal.Stream<E>;
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        spliterator(): Internal.Spliterator<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
    }
    type ImmutableCollections$SetN_<E> = ImmutableCollections$SetN<E>;
    class BlackHoleUnitTile extends Internal.BHTile<Internal.BlackHoleUnitTile> {
        constructor(arg0: Internal.BasicTileBlock_<Internal.BlackHoleUnitTile>, arg1: Internal.BlockEntityType_<any>, arg2: Internal.Rarity_, arg3: BlockPos_, arg4: Internal.BlockState_)
        getTitleColor(): number;
        getCapability<U>(arg0: Internal.Capability_<U>, arg1: Internal.Direction_): Internal.LazyOptional<U>;
        setAmount(arg0: number): void;
        deserializeNBT(arg0: Internal.Tag_): void;
        serverTick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlackHoleUnitTile_): void;
        getTitleYPos(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): number;
        requestModelDataUpdate(): void;
        handleUpdateTag(arg0: Internal.CompoundTag_): void;
        getCapability<T>(arg0: Internal.Capability_<T>): Internal.LazyOptional<T>;
        onClicked(arg0: Internal.Player_): void;
        isVoidItems(): boolean;
        clientTick(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlackHoleUnitTile_): void;
        deserializeNBT(arg0: Internal.CompoundTag_): void;
        getModelData(): Internal.ModelData;
        onLoad(): void;
        serializeNBT(): Internal.Tag;
        setStack(arg0: Internal.ItemStack_): void;
        getTitleXPos(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): number;
        getSelf(): this;
        hasCustomOutlineRendering(arg0: Internal.Player_): boolean;
        getRenderBoundingBox(): Internal.AABB;
        get titleColor(): number
        set amount(arg0: number)
        get voidItems(): boolean
        get modelData(): Internal.ModelData
        set stack(arg0: Internal.ItemStack_)
        get self(): Internal.BlackHoleUnitTile
        get renderBoundingBox(): Internal.AABB
    }
    type BlackHoleUnitTile_ = BlackHoleUnitTile;
    interface CustomIngredientActionCallback {
        abstract transform(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.InventoryKJS_): Internal.ItemStack;
        (arg0: Internal.ItemStack, arg1: number, arg2: Internal.InventoryKJS): Internal.ItemStack_;
    }
    type CustomIngredientActionCallback_ = CustomIngredientActionCallback;
    class BiofuelGeneratorBlock extends Internal.IndustrialBlock<Internal.BiofuelGeneratorTile> {
        constructor()
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getTileEntityFactory(): Internal.BlockEntityType$BlockEntitySupplier<Internal.BiofuelGeneratorTile>;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get tileEntityFactory(): Internal.BlockEntityType$BlockEntitySupplier<Internal.BiofuelGeneratorTile>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type BiofuelGeneratorBlock_ = BiofuelGeneratorBlock;
    class Locale$LanguageRange {
        constructor(arg0: string, arg1: number)
        constructor(arg0: string)
        getWeight(): number;
        static parse(arg0: string): Internal.List<Internal.Locale$LanguageRange>;
        static parse(arg0: string, arg1: Internal.Map_<string, Internal.List<string>>): Internal.List<Internal.Locale$LanguageRange>;
        static mapEquivalents(arg0: Internal.List_<Internal.Locale$LanguageRange>, arg1: Internal.Map_<string, Internal.List<string>>): Internal.List<Internal.Locale$LanguageRange>;
        getRange(): string;
        get weight(): number
        get range(): string
        static readonly MAX_WEIGHT: 1.0;
        static readonly MIN_WEIGHT: 0.0;
    }
    type Locale$LanguageRange_ = Locale$LanguageRange;
    interface ArtifactVersion extends Internal.Comparable<Internal.ArtifactVersion> {
        abstract compareTo(arg0: Internal.ArtifactVersion_): number;
        abstract getBuildNumber(): number;
        abstract parseVersion(arg0: string): void;
        abstract getMinorVersion(): number;
        abstract getMajorVersion(): number;
        abstract getIncrementalVersion(): number;
        abstract getQualifier(): string;
        get buildNumber(): number
        get minorVersion(): number
        get majorVersion(): number
        get incrementalVersion(): number
        get qualifier(): string
    }
    type ArtifactVersion_ = ArtifactVersion;
    interface ArgumentType <T> {
        abstract parse(arg0: Internal.StringReader_): T;
        getExamples(): Internal.Collection<string>;
        listSuggestions<S>(arg0: Internal.CommandContext_<S>, arg1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        get examples(): Internal.Collection<string>
        (arg0: Internal.StringReader): T;
    }
    type ArgumentType_<T> = ArgumentType<T>;
    class Capability <T> {
        addListener(arg0: Internal.Consumer_<Internal.Capability<T>>): this;
        orEmpty<R>(arg0: Internal.Capability_<R>, arg1: Internal.LazyOptional_<T>): Internal.LazyOptional<R>;
        getName(): string;
        isRegistered(): boolean;
        get name(): string
        get registered(): boolean
    }
    type Capability_<T> = Capability<T>;
    class ItemCooldowns implements Internal.AccessorItemCooldowns {
        constructor()
        addCooldown(arg0: Internal.Item_, arg1: number): void;
        bookshelf$getTickCount(): number;
        bookshelf$getCooldowns(): Internal.Map<any, any>;
        getCooldownPercent(arg0: Internal.Item_, arg1: number): number;
        isOnCooldown(arg0: Internal.Item_): boolean;
        removeCooldown(arg0: Internal.Item_): void;
        tick(): void;
    }
    type ItemCooldowns_ = ItemCooldowns;
    class StonecutterRecipe extends Internal.SingleItemRecipe {
        constructor(arg0: ResourceLocation_, arg1: string, arg2: Internal.Ingredient_, arg3: Internal.ItemStack_)
        isSpecial(): boolean;
        getGroup(): string;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        getRemainingItems(arg0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        get special(): boolean
        get group(): string
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type StonecutterRecipe_ = StonecutterRecipe;
    class DataPackEventJS extends Internal.EventJS {
        constructor(d: any_, rm: any_)
        add(id: ResourceLocation_, content: string): void;
        addJson(id: ResourceLocation_, json: Internal.JsonElement_): void;
    }
    type DataPackEventJS_ = DataPackEventJS;
    class FluidGeneratorRecipe implements Internal.Recipe<com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe> {
        constructor(arg0: ResourceLocation_, arg1: string, arg2: number)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(arg0: net.minecraft.world.Container_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        matches(arg0: com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe_, arg1: Internal.Level_): boolean;
        assemble(arg0: com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe_, arg1: Internal.RegistryAccess_): Internal.ItemStack;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getFluid(): string;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(arg0: Internal.RegistryAccess_): Internal.ItemStack;
        canCraftInDimensions(arg0: number, arg1: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getFluidAmount(): number;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getRemainingItems(arg0: com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe_): Internal.NonNullList<Internal.ItemStack>;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get fluid(): string
        get type(): ResourceLocation
        set group(group: string)
        get fluidAmount(): number
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type FluidGeneratorRecipe_ = FluidGeneratorRecipe;
    class FarmersDelightCompatImpl$TomatoRopeBlock extends Internal.FarmersDelightCompatImpl$TomatoLoggedBlock implements Internal.IRopeConnection {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        static canConnectDown(downState: Internal.BlockState_): boolean;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        static isSupportingCeiling(upState: Internal.BlockState_, pos: BlockPos_, world: Internal.LevelReader_): boolean;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSideAcceptConnection(state: Internal.BlockState_, direction: Internal.Direction_): boolean;
        getPlantType(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.PlantType;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        shouldConnectToFace(thisState: Internal.BlockState_, facingState: Internal.BlockState_, facingPos: BlockPos_, dir: Internal.Direction_, world: Internal.LevelReader_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        static isSupportingCeiling(pos: BlockPos_, world: Internal.LevelReader_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly NORTH: Internal.BooleanProperty;
        static readonly SOUTH: Internal.BooleanProperty;
        static readonly WEST: Internal.BooleanProperty;
        static readonly KNOT: Internal.BooleanProperty;
        static readonly EAST: Internal.BooleanProperty;
    }
    type FarmersDelightCompatImpl$TomatoRopeBlock_ = FarmersDelightCompatImpl$TomatoRopeBlock;
    class LanternBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly HANGING: Internal.BooleanProperty;
    }
    type LanternBlock_ = LanternBlock;
    interface Tier {
        /**
         * @deprecated
        */
        abstract getLevel(): number;
        abstract getRepairIngredient(): Internal.Ingredient;
        abstract getAttackDamageBonus(): number;
        abstract getEnchantmentValue(): number;
        abstract getUses(): number;
        abstract getSpeed(): number;
        getTag(): Internal.TagKey<Internal.Block>;
        /**
         * @deprecated
        */
        get level(): number
        get repairIngredient(): Internal.Ingredient
        get attackDamageBonus(): number
        get enchantmentValue(): number
        get uses(): number
        get speed(): number
        get tag(): Internal.TagKey<Internal.Block>
    }
    type Tier_ = string | Tier;
    class SlingshotItem extends Internal.ProjectileWeaponItem implements Internal.IThirdPersonAnimationProvider, Internal.Vanishable, Internal.IFirstPersonAnimationProvider {
        constructor(properties: Internal.Item$Properties_)
        elytraFlightTick(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): boolean;
        getMaxDamage(arg0: Internal.ItemStack_): number;
        getShareTag(arg0: Internal.ItemStack_): Internal.CompoundTag;
        poseRightArm<T extends Internal.LivingEntity>(stack: Internal.ItemStack_, model: Internal.HumanoidModel_<T>, entity: T, mainHand: Internal.HumanoidArm_): boolean;
        isDamageable(arg0: Internal.ItemStack_): boolean;
        isEnderMask(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.EnderMan_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        canGrindstoneRepair(arg0: Internal.ItemStack_): boolean;
        getBurnTime(arg0: Internal.ItemStack_, arg1: Internal.RecipeType_<any>): number;
        setDigSpeed(speed: number): void;
        onItemUseFirst(arg0: Internal.ItemStack_, arg1: Internal.UseOnContext_): InteractionResult;
        isPiglinCurrency(arg0: Internal.ItemStack_): boolean;
        isCorrectToolForDrops(arg0: Internal.ItemStack_, arg1: Internal.BlockState_): boolean;
        getEnchantmentValue(arg0: Internal.ItemStack_): number;
        canDisableShield(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: Internal.LivingEntity_, arg3: Internal.LivingEntity_): boolean;
        static animateCrossbowCharge(offHand: Internal.ModelPart_, mainHand: Internal.ModelPart_, entity: Internal.LivingEntity_, right: boolean): void;
        setAttackSpeed(attackSpeed: number): void;
        canWalkOnPowderedSnow(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        onStopUsing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_, arg2: number): void;
        poseLeftArm<T extends Internal.LivingEntity>(stack: Internal.ItemStack_, model: Internal.HumanoidModel_<T>, entity: T, mainHand: Internal.HumanoidArm_): boolean;
        isNotReplaceableByPickAction(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: number): boolean;
        static get(target: Internal.Item_): Internal.IFirstPersonAnimationProvider;
        getXpRepairRatio(arg0: Internal.ItemStack_): number;
        isBookEnchantable(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getCreativeTab(): string;
        initCapabilities(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): Internal.ICapabilityProvider;
        onDroppedByPlayer(arg0: Internal.ItemStack_, arg1: Internal.Player_): boolean;
        static attachToItem(target: Internal.Item_, object: Internal.IThirdPersonAnimationProvider_): void;
        isDamaged(arg0: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(arg0: Internal.ItemStack_): number;
        getCreatorModId(arg0: Internal.ItemStack_): string;
        canContinueUsing(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        getFoodProperties(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): Internal.FoodProperties;
        getHighlightTip(arg0: Internal.ItemStack_, arg1: net.minecraft.network.chat.Component_): net.minecraft.network.chat.Component;
        animateItemFirstPerson(entity: Internal.Player_, stack: Internal.ItemStack_, hand: Internal.InteractionHand_, arm: Internal.HumanoidArm_, poseStack: Internal.PoseStack_, partialTicks: number, pitch: number, attackAnim: number, handHeight: number): void;
        static attachToItem(target: Internal.Item_, object: Internal.IFirstPersonAnimationProvider_): void;
        onDestroyed(arg0: Internal.ItemEntity_, arg1: DamageSource_): void;
        onLeftClickEntity(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): boolean;
        canEquip(arg0: Internal.ItemStack_, arg1: Internal.EquipmentSlot_, arg2: Internal.Entity_): boolean;
        makesPiglinsNeutral(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        canPerformAction(arg0: Internal.ItemStack_, arg1: Internal.ToolAction_): boolean;
        isTwoHanded(): boolean;
        onInventoryTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_, arg3: number, arg4: number): void;
        hasCustomEntity(arg0: Internal.ItemStack_): boolean;
        onEntityItemUpdate(arg0: Internal.ItemStack_, arg1: Internal.ItemEntity_): boolean;
        getDamage(arg0: Internal.ItemStack_): number;
        getChargeSound(stack: Internal.ItemStack_): Internal.SoundEvent;
        getCraftingRemainingItem(arg0: Internal.ItemStack_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        onArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Player_): void;
        readShareTag(arg0: Internal.ItemStack_, arg1: Internal.CompoundTag_): void;
        getEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        shouldCauseBlockBreakReset(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_): boolean;
        damageItem<T extends Internal.LivingEntity>(arg0: Internal.ItemStack_, arg1: number, arg2: T, arg3: Internal.Consumer_<T>): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(arg0: Internal.EquipmentSlot_, arg1: Internal.ItemStack_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        canElytraFly(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        createEntity(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.ItemStack_): Internal.Entity;
        getArmorTexture(arg0: Internal.ItemStack_, arg1: Internal.Entity_, arg2: Internal.EquipmentSlot_, arg3: string): string;
        static getChargeDuration(stack: Internal.ItemStack_): number;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        onEntitySwing(arg0: Internal.ItemStack_, arg1: Internal.LivingEntity_): boolean;
        getEntityLifespan(arg0: Internal.ItemStack_, arg1: Internal.Level_): number;
        setArmorToughness(armorToughness: number): void;
        setDamage(arg0: Internal.ItemStack_, arg1: number): void;
        getPowerForTime(stack: Internal.ItemStack_, timeLeft: number): number;
        hasCraftingRemainingItem(arg0: Internal.ItemStack_): boolean;
        getMaxStackSize(arg0: Internal.ItemStack_): number;
        animateItemFirstPerson(entity: Internal.LivingEntity_, stack: Internal.ItemStack_, hand: Internal.InteractionHand_, matrixStack: Internal.PoseStack_, partialTicks: number, pitch: number, attackAnim: number, handHeight: number): void;
        doesSneakBypassUse(arg0: Internal.ItemStack_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        getSweepHitBox(arg0: Internal.ItemStack_, arg1: Internal.Player_, arg2: Internal.Entity_): Internal.AABB;
        getEnchantmentLevel(arg0: Internal.ItemStack_, arg1: Internal.Enchantment_): number;
        shouldCauseReequipAnimation(arg0: Internal.ItemStack_, arg1: Internal.ItemStack_, arg2: boolean): boolean;
        getAllEnchantments(arg0: Internal.ItemStack_): Internal.Map<Internal.Enchantment, number>;
        onHorseArmorTick(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.Mob_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(arg0: Internal.ItemStack_, arg1: BlockPos_, arg2: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        get twoHanded(): boolean
        set attackDamage(attackDamage: number)
        get mod(): string
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type SlingshotItem_ = SlingshotItem;
    class SporeBlossomBlock extends Internal.Block {
        constructor(arg0: Internal.BlockBehaviour$Properties_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type SporeBlossomBlock_ = SporeBlossomBlock;
    class PostPass implements Internal.AutoCloseable {
        constructor(arg0: Internal.ResourceManager_, arg1: string, arg2: Internal.RenderTarget_, arg3: Internal.RenderTarget_)
        setOrthoMatrix(arg0: Matrix4f_): void;
        process(arg0: number): void;
        getName(): string;
        close(): void;
        getEffect(): Internal.EffectInstance;
        addAuxAsset(arg0: string, arg1: Internal.IntSupplier_, arg2: number, arg3: number): void;
        set orthoMatrix(arg0: Matrix4f_)
        get name(): string
        get effect(): Internal.EffectInstance
        readonly outTarget: Internal.RenderTarget;
        readonly inTarget: Internal.RenderTarget;
    }
    type PostPass_ = PostPass;
    interface AnimationController$SoundKeyframeHandler <A extends Internal.GeoAnimatable> {
        abstract handle(arg0: Internal.SoundKeyframeEvent_<A>): void;
        (arg0: Internal.SoundKeyframeEvent<A>): void;
    }
    type AnimationController$SoundKeyframeHandler_<A extends Internal.GeoAnimatable> = AnimationController$SoundKeyframeHandler<A>;
    class ClientboundTagQueryPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor(arg0: Internal.FriendlyByteBuf_)
        constructor(arg0: number, arg1: Internal.CompoundTag_)
        handle(arg0: Internal.PacketListener_): void;
        write(arg0: Internal.FriendlyByteBuf_): void;
        handle(arg0: Internal.ClientGamePacketListener_): void;
        getTransactionId(): number;
        getTag(): Internal.CompoundTag;
        isSkippable(): boolean;
        get transactionId(): number
        get tag(): Internal.CompoundTag
        get skippable(): boolean
    }
    type ClientboundTagQueryPacket_ = ClientboundTagQueryPacket;
    interface BufferedImageOp {
        abstract createCompatibleDestImage(arg0: Internal.BufferedImage_, arg1: Internal.ColorModel_): Internal.BufferedImage;
        abstract filter(arg0: Internal.BufferedImage_, arg1: Internal.BufferedImage_): Internal.BufferedImage;
        abstract getBounds2D(arg0: Internal.BufferedImage_): Internal.Rectangle2D;
        abstract getRenderingHints(): Internal.RenderingHints;
        abstract getPoint2D(arg0: Internal.Point2D_, arg1: Internal.Point2D_): Internal.Point2D;
        get renderingHints(): Internal.RenderingHints
    }
    type BufferedImageOp_ = BufferedImageOp;
    class ContextUtils$EntityBlockPosLevelContext {
        constructor(arg0: BlockPos_, arg1: Internal.LevelReader_, arg2: Internal.LivingEntity_)
        /**
         * The block position
        */
        readonly pos: BlockPos;
        /**
         * The living entity
        */
        readonly entity: Internal.LivingEntity;
        /**
         * The level reader
        */
        readonly levelReader: Internal.LevelReader;
    }
    type ContextUtils$EntityBlockPosLevelContext_ = ContextUtils$EntityBlockPosLevelContext;
    class HitResult$Type extends Internal.Enum<Internal.HitResult$Type> {
        static valueOf(arg0: string): Internal.HitResult$Type;
        static values(): Internal.HitResult$Type[];
        static readonly MISS: Internal.HitResult$Type;
        static readonly ENTITY: Internal.HitResult$Type;
        static readonly BLOCK: Internal.HitResult$Type;
    }
    type HitResult$Type_ = "miss" | "block" | HitResult$Type | "entity";
    class SynchedEntityData$DataValue <T> extends Internal.Record {
        constructor(id: number, serializer: Internal.EntityDataSerializer_<T>, value: T)
        write(arg0: Internal.FriendlyByteBuf_): void;
        id(): number;
        serializer(): Internal.EntityDataSerializer<T>;
        static create<T>(arg0: Internal.EntityDataAccessor_<T>, arg1: T): Internal.SynchedEntityData$DataValue<T>;
        static read(arg0: Internal.FriendlyByteBuf_, arg1: number): Internal.SynchedEntityData$DataValue<any>;
        value(): T;
    }
    type SynchedEntityData$DataValue_<T> = SynchedEntityData$DataValue<T>;
    class BrownHangingSignBlock extends Internal.CeilingHangingSignBlock {
        constructor(arg0: Internal.BlockBehaviour$Properties_, arg1: Internal.WoodType_)
        isFlammable(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getRespawnPosition(arg0: Internal.BlockState_, arg1: Internal.EntityType_<any>, arg2: Internal.LevelReader_, arg3: BlockPos_, arg4: number, arg5: Internal.LivingEntity_): Internal.Optional<Vec3d>;
        supportsExternalFaceHiding(arg0: Internal.BlockState_): boolean;
        isEnabled(arg0: Internal.FeatureFlagSet_): boolean;
        isFertile(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        collisionExtendsVertically(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        canBeHydrated(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.FluidState_, arg4: BlockPos_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        onBlockStateChange(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_): void;
        getWeakChanges(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): boolean;
        getFriction(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): number;
        canConnectRedstone(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isFireSource(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        isStickyBlock(arg0: Internal.BlockState_): boolean;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): number[];
        onBlockExploded(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Explosion_): void;
        getPistonPushReaction(arg0: Internal.BlockState_): Internal.PushReaction;
        isSlimeBlock(arg0: Internal.BlockState_): boolean;
        getAppearance(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.BlockState_, arg5: BlockPos_): Internal.BlockState;
        getExpDrop(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.RandomSource_, arg3: BlockPos_, arg4: number, arg5: number): number;
        setDestroySpeed(v: number): void;
        canEntityDestroy(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        shouldDisplayFluidOverlay(arg0: Internal.BlockState_, arg1: Internal.BlockAndTintGetter_, arg2: BlockPos_, arg3: Internal.FluidState_): boolean;
        rotate(arg0: Internal.BlockState_, arg1: Internal.LevelAccessor_, arg2: BlockPos_, arg3: Internal.Rotation_): Internal.BlockState;
        canHarvestBlock(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Player_): boolean;
        isValidSpawn(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.SpawnPlacements$Type_, arg4: Internal.EntityType_<any>): boolean;
        getToolModifiedState(arg0: Internal.BlockState_, arg1: Internal.UseOnContext_, arg2: Internal.ToolAction_, arg3: boolean): Internal.BlockState;
        placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
        shouldCheckWeakPower(arg0: Internal.BlockState_, arg1: Internal.SignalGetter_, arg2: BlockPos_, arg3: Internal.Direction_): boolean;
        getListener<T extends Internal.BlockEntity>(arg0: Internal.ServerLevel_, arg1: T): Internal.GameEventListener;
        getFlammability(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        arch$holder(): Internal.Holder<Internal.Block>;
        isLadder(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        getCloneItemStack(arg0: Internal.BlockState_, arg1: Internal.HitResult_, arg2: Internal.BlockGetter_, arg3: BlockPos_, arg4: Internal.Player_): Internal.ItemStack;
        makesOpenTrapdoorAboveClimbable(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.BlockState_): boolean;
        onDestroyedByPlayer(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: boolean, arg5: Internal.FluidState_): boolean;
        getBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_): Internal.BlockPathTypes;
        onNeighborChange(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): void;
        getMapColor(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.MapColor_): Internal.MapColor;
        getPickupSound(arg0: Internal.BlockState_): Internal.Optional<Internal.SoundEvent>;
        canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        isPortalFrame(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        onCaughtFire(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Direction_, arg4: Internal.LivingEntity_): void;
        isScaffolding(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.LivingEntity_): boolean;
        hidesNeighborFace(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.BlockState_, arg4: Internal.Direction_): boolean;
        onTreeGrow(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: Internal.BiConsumer_<BlockPos, Internal.BlockState>, arg3: Internal.RandomSource_, arg4: BlockPos_, arg5: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Vec3d_): Internal.BlockState;
        pickupBlock(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        isBed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getExplosionResistance(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): number;
        getBedDirection(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): Internal.Direction;
        setRequiresTool(v: boolean): void;
        canStickTo(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        getFireSpreadSpeed(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Direction_): number;
        getLightEmission(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): number;
        setBedOccupied(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.LivingEntity_, arg4: boolean): void;
        arch$registryName(): ResourceLocation;
        getMod(): string;
        getAdjacentBlockPathType(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Mob_, arg4: Internal.BlockPathTypes_): Internal.BlockPathTypes;
        addLandingEffects(arg0: Internal.BlockState_, arg1: Internal.ServerLevel_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.LivingEntity_, arg5: number): boolean;
        canDropFromExplosion(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.Explosion_): boolean;
        isConduitFrame(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: BlockPos_): boolean;
        getEnchantPowerBonus(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_): number;
        addRunningEffects(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Entity_): boolean;
        getSoundType(arg0: Internal.BlockState_, arg1: Internal.LevelReader_, arg2: BlockPos_, arg3: Internal.Entity_): SoundType;
        isBurning(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type BrownHangingSignBlock_ = BrownHangingSignBlock;
    abstract class ImmutableList <E> extends Internal.ImmutableCollection<E> implements Internal.RandomAccess, Internal.List<E> {
        static builder<E>(): Internal.ImmutableList$Builder<E>;
        abstract get(arg0: number): E;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.ImmutableList<E>;
        static copyOf<E>(arg0: E[]): Internal.ImmutableList<E>;
        reverse(): this;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.ImmutableList<E>;
        static sortedCopyOf<E>(arg0: Internal.Comparator_<E>, arg1: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static copyOf<E>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.ImmutableList<E>;
        parallelStream(): Internal.Stream<E>;
        /**
         * @deprecated
        */
        sort(arg0: Internal.Comparator_<E>): void;
        /**
         * @deprecated
        */
        set(arg0: number, arg1: E): E;
        static of<E>(...arg0: E[]): Internal.List<E>;
        listIterator(arg0: number): Internal.ListIterator<any>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E, arg10: E, arg11: E, ...arg12: E[]): Internal.ImmutableList<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        addAll(arg0: number, arg1: Internal.Collection_<E>): boolean;
        static builderWithExpectedSize<E>(arg0: number): Internal.ImmutableList$Builder<E>;
        static of<E>(): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        remove(arg0: number): E;
        static of<E>(arg0: E): Internal.ImmutableList<E>;
        listIterator(): Internal.ListIterator<any>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        replaceAll(arg0: Internal.UnaryOperator_<E>): void;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.ImmutableList<E>;
        indexOf(arg0: any): number;
        /**
         * @deprecated
        */
        add(arg0: number, arg1: E): void;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.ImmutableList<E>;
        static sortedCopyOf<E extends Internal.Comparable<any>>(arg0: Internal.Iterable_<E>): Internal.ImmutableList<E>;
        abstract toArray<T>(arg0: T[]): T[];
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E, arg10: E): Internal.ImmutableList<E>;
        /**
         * @deprecated
        */
        asList(): this;
        subList(arg0: number, arg1: number): Internal.List<any>;
        static toImmutableList<E>(): Internal.Collector<E, any, Internal.ImmutableList<E>>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.ImmutableList<E>;
        stream(): Internal.Stream<E>;
        spliterator(): Internal.Spliterator<E>;
        static copyOf<E>(arg0: Internal.Iterator_<E>): Internal.ImmutableList<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.ImmutableList<E>;
        iterator(): Internal.UnmodifiableIterator<E>;
        lastIndexOf(arg0: any): number;
        static of<E>(arg0: E, arg1: E): Internal.ImmutableList<E>;
    }
    type ImmutableList_<E> = ImmutableList<E>;
    /**
     * Methods for working with Java classes. Reflection my beloved ♥
    */
    class JavaWrapper {
        constructor(manager: any_)
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.quickplay.QuickPlayLog"): typeof Internal.QuickPlayLog;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.impl.data.recipes.crafting.ShapelessDurabilityRecipe$Serializer"): typeof Internal.ShapelessDurabilityRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeItem"): Internal.IForgeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.datatransfer.FlavorMap"): Internal.FlavorMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.DetectorBlockEventJS"): typeof Internal.DetectorBlockEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.MobSpawnSettings"): typeof Internal.MobSpawnSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.Consumer"): Internal.Consumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.BasicItemJS"): typeof Internal.BasicItemJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blockpredicates.InsideWorldBoundsPredicate"): typeof Internal.InsideWorldBoundsPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ClientChatReceivedEvent"): typeof Internal.ClientChatReceivedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.item.RottenTomatoItem"): typeof Internal.RottenTomatoItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.effects.AbyssBlindnessMobEffect"): typeof Internal.AbyssBlindnessMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.navigation.ScreenDirection"): typeof Internal.ScreenDirection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.transportstorage.tile.BlackHoleTankTile"): typeof Internal.BlackHoleTankTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SeagrassBlock"): typeof Internal.SeagrassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.SurfaceRules$RuleSource"): Internal.SurfaceRules$RuleSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.capability.FluidHandlerScreenProviderItemStack"): typeof Internal.FluidHandlerScreenProviderItemStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.drawable.IDrawable"): Internal.IDrawable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.ingredients.IIngredientTypeWithSubtypes"): Internal.IIngredientTypeWithSubtypes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ElytraItem"): typeof Internal.ElytraItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.InputReplacement"): Internal.InputReplacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.GameRules$Category"): typeof Internal.GameRules$Category;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Merchant2Item$Boots"): typeof Internal.Merchant2Item$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.codecs.BaseMapCodec"): Internal.BaseMapCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetTimePacket"): typeof Internal.ClientboundSetTimePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.BufferBuilder$SortState"): typeof Internal.BufferBuilder$SortState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.StructureRenderer"): typeof Internal.StructureRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.shaders.BlendMode"): typeof Internal.BlendMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.suggestion.SuggestionsBuilder"): typeof Internal.SuggestionsBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.Long2FloatFunction"): Internal.Long2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.allthemods.alltheores.blocks.BOreBlock"): typeof Internal.BOreBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RegisterPresetEditorsEvent"): typeof Internal.RegisterPresetEditorsEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Stack"): typeof Internal.Stack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.generator.PitifulGeneratorBlock"): typeof Internal.PitifulGeneratorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.FishingSpeedEnchantment"): typeof Internal.FishingSpeedEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.swing.text.StyleConstants$FontConstants"): typeof Internal.StyleConstants$FontConstants;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tocraft.walkers.mixin.accessor.LivingEntityRendererAccessor"): Internal.LivingEntityRendererAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.BlockBehaviour$OffsetType"): typeof Internal.BlockBehaviour$OffsetType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.Provider"): typeof Internal.Provider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.BiPredicate"): Internal.BiPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.util.NonNullSupplier"): Internal.NonNullSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.cyan.CyanWallSignBlock"): typeof Internal.CyanWallSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SpawnerBlock"): typeof Internal.SpawnerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.AgeableListModel"): typeof Internal.AgeableListModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2LongFunction"): Internal.Double2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blockpredicates.MatchingBlockTagPredicate"): typeof Internal.MatchingBlockTagPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.FillLayerFeature"): typeof Internal.FillLayerFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.util.recipes.device.TreeExtractorBoost$Serializer"): typeof Internal.TreeExtractorBoost$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.server.command.EnumArgument"): typeof Internal.EnumArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.resources.ResourceManagerReloadListener"): Internal.ResourceManagerReloadListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.events.GoalEventJS"): typeof Internal.GoalEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.teammetallurgy.aquaculture.item.BaitItem"): typeof Internal.BaitItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.EndCrystal"): typeof Internal.EndCrystal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket"): typeof Internal.ServerboundSeenAdvancementsPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.EntityRenderersEvent$RegisterRenderers"): typeof Internal.EntityRenderersEvent$RegisterRenderers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BlueLampBlock"): typeof Internal.BlueLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.LeavesBlock"): typeof Internal.LeavesBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WeepingVinesBlock"): typeof Internal.WeepingVinesBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.SafetyNetBlock"): typeof Internal.SafetyNetBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.StructureStart"): typeof Internal.StructureStart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.ByteConsumer"): Internal.ByteConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.swing.text.StyleConstants$CharacterConstants"): typeof Internal.StyleConstants$CharacterConstants;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.MapDecoder"): Internal.MapDecoder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Marker"): typeof Internal.Marker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.MessageSignature$Packed"): typeof Internal.MessageSignature$Packed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeItem"): typeof Internal.BatteryUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.math.MathContext"): typeof Internal.MathContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.api.crafting.IReprocessorRecipe"): Internal.IReprocessorRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.events.ObjectStartedEvent"): typeof Internal.ObjectStartedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.HatStandItem"): typeof Internal.HatStandItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.network.SerializableDataTicket"): typeof Internal.SerializableDataTicket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.supermartijn642.fusion.api.texture.TextureType"): Internal.TextureType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.ServerLevelAccessor"): Internal.ServerLevelAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.document.AbstractDocumentBase"): typeof Internal.AbstractDocumentBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.BellAttachType"): typeof Internal.BellAttachType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.SkullModelBase"): typeof Internal.SkullModelBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.reflect.TypeToken"): typeof com.google.gson.reflect.TypeToken;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2ByteSortedMap$FastSortedEntrySet"): Internal.Object2ByteSortedMap$FastSortedEntrySet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.FrostedIceBlock"): typeof Internal.FrostedIceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$Tertium"): typeof Internal.EssenceFurnaceBlock$Tertium;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.item.custom.SprayCanRemoverItem"): typeof Internal.SprayCanRemoverItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.EnumGetMethod"): typeof Internal.EnumGetMethod;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction$Builder"): typeof Internal.LootItemConditionalFunction$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.FTBQuestsKubeJSWrapper"): typeof Internal.FTBQuestsKubeJSWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.AdvancementRewards$Builder"): typeof Internal.AdvancementRewards$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer"): typeof Internal.AcaciaFoliagePlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundRotateHeadPacket"): typeof Internal.ClientboundRotateHeadPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.synchronization.brigadier.LongArgumentInfo$Template"): typeof Internal.LongArgumentInfo$Template;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SpongeBlock"): typeof Internal.SpongeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DragGestureListener"): Internal.DragGestureListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.Chapter"): typeof Internal.Chapter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration"): typeof Internal.HugeFungusConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.extensions.injected.InjectedBlockExtension"): Internal.InjectedBlockExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zetaimplforge.mixin.mixins.client.AccessorItemColors"): Internal.AccessorItemColors;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.IArmPoseTransformer"): Internal.IArmPoseTransformer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.RealmsServerPlayerList"): typeof Internal.RealmsServerPlayerList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSoundPacket"): typeof Internal.ClientboundSoundPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.AbstractMinecart"): typeof Internal.AbstractMinecart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Skull4Item$Helmet"): typeof Internal.Skull4Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleSelection"): Internal.AccessibleSelection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.ChunkDataEvent$Save"): typeof Internal.ChunkDataEvent$Save;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.api.client.IScreenAddonProvider"): Internal.IScreenAddonProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket"): typeof Internal.ClientboundSetChunkCacheCenterPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.MangroveBenchBlock"): typeof Internal.MangroveBenchBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.event.forge.PopupMenuEvent"): typeof Internal.PopupMenuEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.MouseWheelEvent"): typeof Internal.MouseWheelEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity"): typeof Internal.ChiseledBookShelfBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.EnchantedGoldenAppleItem"): typeof Internal.EnchantedGoldenAppleItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.entity.LivingEntityHurtEventJS"): typeof Internal.LivingEntityHurtEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.GiftLootEventJS"): typeof Internal.GiftLootEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.OptionalDynamic"): typeof Internal.OptionalDynamic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.schema.DynamicRecipeComponent"): typeof Internal.DynamicRecipeComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket"): typeof Internal.ClientboundCommandSuggestionsPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.bindings.BlockWrapper"): typeof Block;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.block_network.graph.NetworkGraphScannerRequest"): typeof Internal.NetworkGraphScannerRequest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.opolisutilities.item.custom.SaplingGrower"): typeof Internal.SaplingGrower;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.EndermanSkullWallBlock"): typeof Internal.EndermanSkullWallBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimatableManager"): typeof Internal.AnimatableManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ticks.TickContainerAccess"): Internal.TickContainerAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.ILavaAndWaterLoggable"): Internal.ILavaAndWaterLoggable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.events.ObjectCompletedEvent"): typeof Internal.ObjectCompletedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.task.CustomTask$Data"): typeof Internal.CustomTask$Data;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Shulker"): typeof Internal.Shulker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.extensions.injected.InjectedGameEventExtension"): Internal.InjectedGameEventExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.settings.KeyModifier"): typeof Internal.KeyModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Targeting"): Internal.Targeting;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.api.client.IAssetType"): Internal.IAssetType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.ClickEvent"): typeof Internal.ClickEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration"): typeof Internal.CustomMapDecoration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.compacting.CompactingUpgradeItem"): typeof Internal.CompactingUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagradditions.item.EssenceCoalItem"): typeof Internal.EssenceCoalItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tfar.dankstorage.item.UpgradeItem"): typeof Internal.UpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.EntityEvent"): typeof Internal.EntityEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.particle.Particle"): typeof Internal.Particle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.BundleDelimiterPacket"): typeof Internal.BundleDelimiterPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.StonecutterBlock"): typeof Internal.StonecutterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.MobBucketItem"): typeof Internal.MobBucketItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.supermartijn642.fusion.api.util.Pair"): typeof com.supermartijn642.fusion.api.util.Pair;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbultimine.mixin.ShovelItemAccess"): Internal.ShovelItemAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.HoneyBottleItem"): typeof Internal.HoneyBottleItem;
        /**
         * Creates a custom ConsoleJS instance for you to use to, well, log stuff
        */
        createConsole(name: string): Internal.ConsoleJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.EnderMan"): typeof Internal.EnderMan;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.Options$FieldAccess"): Internal.Options$FieldAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.locomotion.common.item.FluidMinecartItem"): typeof Internal.FluidMinecartItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BrewingStandBlock"): typeof Internal.BrewingStandBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.RecipeKey"): typeof Internal.RecipeKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList"): typeof Internal.StructureProcessorList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.BlockPos"): typeof BlockPos;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration"): typeof Internal.DripstoneClusterConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.TickEvent$ClientTickEvent"): typeof Internal.TickEvent$ClientTickEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Vindicator"): typeof Internal.Vindicator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.ILightable"): Internal.ILightable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.SoapBlock"): typeof Internal.SoapBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.Short2CharFunction"): Internal.Short2CharFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2FloatFunction"): Internal.Double2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.BufferBuilder"): typeof Internal.BufferBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.PostChain"): typeof Internal.PostChain;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.init.registries.TCoreBlocks$3"): typeof Internal.TCoreBlocks$3;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest"): typeof Internal.TagMatchTest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe"): Internal.IInfusionRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Dialog$ModalityType"): typeof Internal.Dialog$ModalityType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.misc.IExtendedPistonTile"): Internal.IExtendedPistonTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.LiquidBlock"): typeof Internal.LiquidBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.TickTask"): typeof Internal.TickTask;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pools.ListPoolElement"): typeof Internal.ListPoolElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerInteractEvent$LeftClickEmpty"): typeof Internal.PlayerInteractEvent$LeftClickEmpty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.builder.IRecipeLayoutBuilder"): Internal.IRecipeLayoutBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.FungusBlock"): typeof Internal.FungusBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.api.IItemFilter"): Internal.IItemFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.AbstractIntCollection"): typeof Internal.AbstractIntCollection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pools.FeaturePoolElement"): typeof Internal.FeaturePoolElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.PrimitiveIterator$OfDouble"): Internal.PrimitiveIterator$OfDouble;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.MobSpawnSettings$SpawnerData"): typeof Internal.MobSpawnSettings$SpawnerData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tech.thatgravyboat.duckling.common.items.HolidayFruitCakeBlock"): typeof Internal.HolidayFruitCakeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.api.IMachine"): Internal.IMachine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.component.sideness.ICapabilityHolder"): Internal.ICapabilityHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ResourceBundle$Control"): typeof Internal.ResourceBundle$Control;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.WidgetLayout$_Simple"): typeof Internal.WidgetLayout$_Simple;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ViewportEvent$ComputeCameraAngles"): typeof Internal.ViewportEvent$ComputeCameraAngles;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.misc.tile.EnchantmentSorterTile"): typeof Internal.EnchantmentSorterTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.saveddata.maps.MapDecoration$Type"): typeof Internal.MapDecoration$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ChainBlock"): typeof Internal.ChainBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.crafting.AbstractIngredient"): typeof Internal.AbstractIngredient;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.ProtectionEnchantment$Type"): typeof Internal.ProtectionEnchantment$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$TextDisplay"): typeof Internal.Display$TextDisplay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.kinds.K1"): Internal.K1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.village.poi.PoiManager"): typeof Internal.PoiManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.supermartijn642.fusion.api.model.ModelInstance"): Internal.ModelInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2ObjectFunction"): Internal.Char2ObjectFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.RealmsNews"): typeof Internal.RealmsNews;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.Item$Properties"): typeof Internal.Item$Properties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.DoubleToIntFunction"): Internal.DoubleToIntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.StructurePiece"): typeof Internal.StructurePiece;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.HazmatArmorItem"): typeof Internal.HazmatArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.strainers.item.custom.ErodingSaltMulchItem"): typeof Internal.ErodingSaltMulchItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.MegaJungleFoliagePlacer"): typeof Internal.MegaJungleFoliagePlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.network.IContainerFactory"): Internal.IContainerFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.extensions.common.IClientBlockExtensions"): Internal.IClientBlockExtensions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.Camera"): typeof Internal.Camera;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.WithPersistentData"): Internal.WithPersistentData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.melanx.skyblockbuilder.util.CoreUtil$SkyblockPresetCodec"): typeof Internal.CoreUtil$SkyblockPresetCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.IndustrialBlock"): typeof Internal.IndustrialBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.GrowingPlantBodyBlock"): typeof Internal.GrowingPlantBodyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.HoneyGlazedHamBlock"): typeof Internal.HoneyGlazedHamBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fonnymunkey.simplehats.util.HatEntry$HatDyeSettings"): typeof Internal.HatEntry$HatDyeSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.stats.StatsCounter"): typeof Internal.StatsCounter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeBlock"): Internal.IForgeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties$PostType"): typeof Internal.ModBlockProperties$PostType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.BlockPositionSource$Type"): typeof Internal.BlockPositionSource$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer$MobNBTData$Entity"): typeof Internal.MobContainer$MobNBTData$Entity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundClientCommandPacket"): typeof Internal.ServerboundClientCommandPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.green.GreenWallSignBlock"): typeof Internal.GreenWallSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.HangingSignBlockEntity"): typeof Internal.HangingSignBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.events.RegisterSpawnPlacementsEventJS"): typeof Internal.RegisterSpawnPlacementsEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.temporal.ValueRange"): typeof Internal.ValueRange;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.EventQueue"): typeof Internal.EventQueue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.common.block.GunpowderBlock"): typeof Internal.GunpowderBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.task.TaskType$GuiProvider"): Internal.TaskType$GuiProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket"): typeof Internal.ClientboundBlockDestructionPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Optional"): typeof Internal.Optional;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion"): typeof Internal.BombExplosion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.api.IResourceStorage"): Internal.IResourceStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.lighting.LevelLightEngine"): typeof Internal.LevelLightEngine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SpectralArrowItem"): typeof Internal.SpectralArrowItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tech.thatgravyboat.duckling.common.items.HolidayFruitCakeItem"): typeof Internal.HolidayFruitCakeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DropperBlock"): typeof Internal.DropperBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.items.StewItem"): typeof Internal.StewItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.WritableRenderedImage"): Internal.WritableRenderedImage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$Entry"): typeof Internal.ClientboundPlayerInfoUpdatePacket$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.ComponentOrientation"): typeof Internal.ComponentOrientation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.TagsUpdatedEvent"): typeof Internal.TagsUpdatedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.context.ParsedArgument"): typeof Internal.ParsedArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.WindowListener"): Internal.WindowListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.io.Serializable"): Internal.Serializable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.material.PushReaction"): typeof Internal.PushReaction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.item.additional_placements.BlockPlacerItem"): typeof Internal.BlockPlacerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.util.Function16"): Internal.Function16;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.TridentLoyaltyEnchantment"): typeof Internal.TridentLoyaltyEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.GameProfile"): typeof Internal.GameProfile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.TrappedChestBlockEntity"): typeof Internal.TrappedChestBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.PressurePlateBlockBuilder"): typeof Internal.PressurePlateBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.behavior.AnimalMakeLove"): typeof Internal.AnimalMakeLove;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorBlueTier2Item$Helmet"): typeof Internal.SailorBlueTier2Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BrushableBlock"): typeof Internal.BrushableBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "lykrast.glassential.doors.GlassTrapDoorBlock"): typeof Internal.GlassTrapDoorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "chiefarug.mods.systeams.recipe.UpgradeShapelessRecipe"): typeof Internal.UpgradeShapelessRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.api.ContainerType"): typeof Internal.ContainerType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$MouseInput"): typeof Internal.ScreenEvent$MouseInput;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack"): typeof Internal.FluidHandlerItemStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.ProfileResults"): Internal.ProfileResults;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.vibrations.VibrationSelector"): typeof Internal.VibrationSelector;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.codecs.RecordCodecBuilder$Mu"): typeof Internal.RecordCodecBuilder$Mu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket"): typeof Internal.ServerboundCustomPayloadPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.context.UseOnContext"): typeof Internal.UseOnContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.roomopolis.item.custom.CorridorKeys.CorridorKey3"): typeof Internal.CorridorKey3;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.ObjectList"): Internal.ObjectList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.registry.registries.DeferredSupplier"): Internal.DeferredSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.EntityArgument$Info$Template"): typeof Internal.EntityArgument$Info$Template;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.misc.tile.EnchantmentApplicatorTile"): typeof Internal.EnchantmentApplicatorTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.spectator.SpectatorMenuCategory"): Internal.SpectatorMenuCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2DoubleFunction"): Internal.Double2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.white.WhiteHangingSignBlock"): typeof Internal.WhiteHangingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.Symbol"): Internal.Symbol;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.ItemCombinerMenu"): typeof Internal.ItemCombinerMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderBuffers"): typeof Internal.RenderBuffers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap"): typeof Internal.Object2IntOpenHashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket"): typeof Internal.ClientboundTeleportEntityPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.level.progress.StoringChunkProgressListener"): typeof Internal.StoringChunkProgressListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.MenuProvider"): Internal.MenuProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.opolisutilities.recipe.CatalogueRecipe$Serializer"): typeof Internal.CatalogueRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.crafting.ISpecialRecipe"): Internal.ISpecialRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.im.InputContext"): typeof Internal.InputContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.item.tool.BasePaxelItem"): typeof Internal.BasePaxelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.KeyPair"): typeof Internal.KeyPair;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.stats.RecipeBookSettings"): typeof Internal.RecipeBookSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Merchant1Item"): typeof Internal.Merchant1Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.item.infinity.item.ItemInfinityHammer"): typeof Internal.ItemInfinityHammer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.BeekeeperArmorItem"): typeof Internal.BeekeeperArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket"): typeof Internal.ClientboundSetPlayerTeamPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.ILightable$FireSourceType"): typeof Internal.ILightable$FireSourceType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.ShearsItemBuilder"): typeof Internal.ShearsItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.NbtPathArgument$NbtPath"): typeof Internal.NbtPathArgument$NbtPath;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider"): typeof Internal.BlockStateProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Spliterator"): Internal.Spliterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.CommandDispatcher"): typeof Internal.CommandDispatcher;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket"): typeof Internal.ClientboundPlayerInfoRemovePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.bindings.KMath"): typeof KMath;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.report.AbuseReport"): typeof Internal.AbuseReport;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunctions$RangeChoice"): typeof Internal.DensityFunctions$RangeChoice;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.ConditionContainer"): Internal.ConditionContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.goal.Goal$Flag"): typeof Internal.Goal$Flag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.impl.ItemPropertiesExtensionImpl"): Internal.ItemPropertiesExtensionImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.cursedwarrior.skystructures.world.features.StructureFeature"): typeof Internal.StructureFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.blocks.WisteriaNiveisBlock"): typeof Internal.WisteriaNiveisBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.mod.wrapper.AABBWrapper"): AABB;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.fluid.GlowstoneFluid$1"): typeof Internal.GlowstoneFluid$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2DoubleFunction"): Internal.Int2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.EntityType"): typeof Internal.EntityType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.LockItem"): typeof Internal.LockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ClientPlayerNetworkEvent$LoggingIn"): typeof Internal.ClientPlayerNetworkEvent$LoggingIn;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.horse.Horse"): typeof Internal.Horse;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.locomotion.init.registries.TLocBlocks$2"): typeof Internal.TLocBlocks$2;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.CaveSpider"): typeof Internal.CaveSpider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersStandard"): typeof Internal.BlockEntityDrawersStandard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.painter.Painter"): typeof Internal.Painter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.particles.ParticleOptions$Deserializer"): Internal.ParticleOptions$Deserializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.effects.SwimSpeedMobEffect"): typeof Internal.SwimSpeedMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.CarvingMask$Mask"): Internal.CarvingMask$Mask;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SuspiciousStewItem"): typeof Internal.SuspiciousStewItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.SouliumDaggerItem"): typeof Internal.SouliumDaggerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.PirateTier2Item$Chestplate"): typeof Internal.PirateTier2Item$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.ShipwreckStructure"): typeof Internal.ShipwreckStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.Explosion"): typeof Internal.Explosion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.ClientLevelKJS"): Internal.ClientLevelKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.ModCheck$Confidence"): typeof Internal.ModCheck$Confidence;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.SlotAccess"): Internal.SlotAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.item.ItemEntity"): typeof Internal.ItemEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.api.transporter.TransporterTypeFactory$TransporterAction"): typeof Internal.TransporterTypeFactory$TransporterAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorNordicTier1Item"): typeof Internal.SailorNordicTier1Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer"): typeof Internal.ConditionalRecipeSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BlockEntityTicker"): Internal.BlockEntityTicker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset"): typeof Internal.FlatLevelGeneratorPreset;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fluid.FluidStackJS"): typeof Internal.FluidStackJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.IronGolem"): typeof Internal.IronGolem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.state.CanvasSign"): Internal.CanvasSign;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ConcretePowderBlock"): typeof Internal.ConcretePowderBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.painter.PainterObject"): typeof Internal.PainterObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.network.locator.PlayerInventoryFinder"): typeof Internal.PlayerInventoryFinder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.ConditionalFunction"): typeof Internal.ConditionalFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.WrappedJS"): Internal.WrappedJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.WarpedStorageCounterBlock"): typeof Internal.WarpedStorageCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.phys.shapes.DiscreteVoxelShape$IntLineConsumer"): Internal.DiscreteVoxelShape$IntLineConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.ReflectionAccessFilter"): Internal.ReflectionAccessFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.transportstorage.ConveyorBlock$ConveyorItem"): typeof Internal.ConveyorBlock$ConveyorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.BookCloningRecipe"): typeof Internal.BookCloningRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerEvent$ItemCraftedEvent"): typeof Internal.PlayerEvent$ItemCraftedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.map.markers.SimpleMapBlockMarker"): typeof Internal.SimpleMapBlockMarker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.Climate$ParameterList"): typeof Internal.Climate$ParameterList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunctions$YClampedGradient"): typeof Internal.DensityFunctions$YClampedGradient;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.yungnickyoung.minecraft.betteroceanmonuments.mixin.accessor.StructureManagerAccessor"): Internal.StructureManagerAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.NoiseSettings"): typeof Internal.NoiseSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.OrangeLampBlock"): typeof Internal.OrangeLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongPredicate"): it.unimi.dsi.fastutil.longs.LongPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.WarpedWallClockBlock"): typeof Internal.WarpedWallClockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.registry.BuilderBase"): typeof Internal.BuilderBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.JsonNull"): typeof Internal.JsonNull;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker"): typeof Internal.MapBlockMarker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$KeyPressed$Post"): typeof Internal.ScreenEvent$KeyPressed$Post;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.Connection"): typeof Internal.Connection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.SpruceDeskBlock"): typeof Internal.SpruceDeskBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.agriculturehusbandry.tile.PlantSowerTile"): typeof Internal.PlantSowerTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.item.ItemShroudKey"): typeof Internal.ItemShroudKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.SwampHutStructure"): typeof Internal.SwampHutStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.block.ChargedSoilBlock"): typeof Internal.ChargedSoilBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.LongTag"): typeof Internal.LongTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.swing.text.StyleConstants$ParagraphConstants"): typeof Internal.StyleConstants$ParagraphConstants;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.locomotion.init.registries.TLocBlocks$1"): typeof Internal.TLocBlocks$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeWrapper$BlastingUpgradeWrapper"): typeof Internal.CookingUpgradeWrapper$BlastingUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.RecipeBookCategories"): typeof Internal.RecipeBookCategories;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.PoiTypeBuilder"): typeof Internal.PoiTypeBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.PickaxeItem"): typeof Internal.PickaxeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.Theme"): typeof Internal.Theme;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.ITickTimer"): Internal.ITickTimer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.phys.Vec3"): typeof Vec3d;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.api.crop.CropTextures"): typeof Internal.CropTextures;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$TextureStateShard"): typeof Internal.RenderStateShard$TextureStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jtorleonstudios.awesomedungeonocean.AwsOceanBoatStructures$AwsOceanBoatStructure"): typeof Internal.AwsOceanBoatStructures$AwsOceanBoatStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.Boat"): typeof Internal.Boat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.recipes.RecipeBuilder"): Internal.RecipeBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.LivingBreatheEvent"): typeof Internal.LivingBreatheEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix4dc"): Internal.Matrix4dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.keyframe.BoneAnimationQueue"): typeof Internal.BoneAnimationQueue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.WallHangingCanvasSignBlock"): typeof Internal.WallHangingCanvasSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.tile.FluidSievingMachineTile"): typeof Internal.FluidSievingMachineTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.logging.log4j.util.StringBuilderFormattable"): Internal.StringBuilderFormattable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.worldgen.RoadSignFeature$RandomState"): typeof Internal.RoadSignFeature$RandomState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen"): de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$TextDisplay$CachedLine"): typeof Internal.Display$TextDisplay$CachedLine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundJigsawGeneratePacket"): typeof Internal.ServerboundJigsawGeneratePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.item.IFCustomItem"): typeof Internal.IFCustomItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.events.GuiEventListener"): Internal.GuiEventListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator"): Internal.ShortBidirectionalIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.HourGlassBlock"): typeof Internal.HourGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.InventoryChangedEventJS"): typeof Internal.InventoryChangedEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.ToolAction"): typeof Internal.ToolAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$BackgroundRendered"): typeof Internal.ScreenEvent$BackgroundRendered;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.KeyMapping"): typeof Internal.KeyMapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.items.armor.AbyssalArmorItem$Heaume"): typeof Internal.AbyssalArmorItem$Heaume;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator"): it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.EntityItemPickupEvent"): typeof Internal.EntityItemPickupEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorGrayTier2Item$Boots"): typeof Internal.SailorGrayTier2Item$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.math.PixelBuffer"): typeof Internal.PixelBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.brightblock.BrightFullBlock"): typeof Internal.BrightFullBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.DataSenderKJS"): Internal.DataSenderKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PermissionsChangedEvent"): typeof Internal.PermissionsChangedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory"): Internal.ISettingsCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.fluid.OreFluid$Flowing"): typeof Internal.OreFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.Slot"): typeof Internal.Slot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CactusBlock"): typeof Internal.CactusBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.crafting.UpgradeNextTierRecipe$Serializer"): typeof Internal.UpgradeNextTierRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampChurchFeature"): typeof Internal.SwampChurchFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.client.particle.options.CylindricalParticleOptions"): typeof Internal.CylindricalParticleOptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ChorusFruitItem"): typeof Internal.ChorusFruitItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.IMagnetPreventionChecker"): Internal.IMagnetPreventionChecker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendStatic"): typeof Internal.AppendStatic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.ConnectionProtocol"): typeof Internal.ConnectionProtocol;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.BlackboardItem"): typeof Internal.BlackboardItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.MoverType"): typeof Internal.MoverType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderHighlightEvent$Block"): typeof Internal.RenderHighlightEvent$Block;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties$Topping"): typeof Internal.ModBlockProperties$Topping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceKeyArgument"): typeof Internal.ResourceKeyArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.CherryCounterBlock"): typeof Internal.CherryCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.magenta.MagentaStandingSignBlock"): typeof Internal.MagentaStandingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.platform.InputConstants$Key"): typeof Internal.InputConstants$Key;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.TentBlock"): typeof Internal.TentBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider"): Internal.BlockEntityRendererProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket"): typeof Internal.ClientboundSetEntityLinkPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundInteractPacket$Handler"): Internal.ServerboundInteractPacket$Handler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.StructBuffer"): typeof Internal.StructBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.registry.RegistryEventJS"): typeof Internal.RegistryEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.tutorial.TutorialStepInstance"): Internal.TutorialStepInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.capabilities.Capability"): typeof Internal.Capability;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.java.ConstructorInfo"): typeof Internal.ConstructorInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.TickEvent$LevelTickEvent"): typeof Internal.TickEvent$LevelTickEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortPredicate"): Internal.ShortPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.LongToIntFunction"): Internal.LongToIntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$TextDisplay$LineSplitter"): Internal.Display$TextDisplay$LineSplitter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundPlaceGhostRecipePacket"): typeof Internal.ClientboundPlaceGhostRecipePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.CorsairTier3Item$Helmet"): typeof Internal.CorsairTier3Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix4x3dc"): Internal.Matrix4x3dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundContainerSetDataPacket"): typeof Internal.ClientboundContainerSetDataPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ForwardingSet"): typeof Internal.ForwardingSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ticks.TickPriority"): typeof Internal.TickPriority;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.TridentModel"): typeof Internal.TridentModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.sound.SoundEvent$SoundSourceEvent"): typeof Internal.SoundEvent$SoundSourceEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.fluids.FluidStack"): typeof Internal.FluidStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.PlayerTabOverlay"): typeof Internal.PlayerTabOverlay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.ChestEventJS"): typeof Internal.ChestEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.telemetry.TelemetryEventSender"): Internal.TelemetryEventSender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.EndIslandFeature"): typeof Internal.EndIslandFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.CompoundTag"): typeof Internal.CompoundTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.WaterloggedVegetationPatchFeature"): typeof Internal.WaterloggedVegetationPatchFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent"): typeof Internal.SoundKeyframeEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundTabListPacket"): typeof Internal.ClientboundTabListPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.red.RedWallHangingSignBlock"): typeof Internal.RedWallHangingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.trunkplacers.DarkOakTrunkPlacer"): typeof Internal.DarkOakTrunkPlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.spectator.SpectatorMenuListener"): Internal.SpectatorMenuListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.builder.LiteralArgumentBuilder"): typeof Internal.LiteralArgumentBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.DefaultedVertexConsumer"): typeof Internal.DefaultedVertexConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.SmokerMenu"): typeof Internal.SmokerMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.Byte2CharFunction"): Internal.Byte2CharFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.BlockRenderDispatcher"): typeof Internal.BlockRenderDispatcher;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.ServerScoreboard$Method"): typeof Internal.ServerScoreboard$Method;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.yungnickyoung.minecraft.betteroceanmonuments.mixin.accessor.ProjectileAccessor"): Internal.ProjectileAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.slf4j.Marker"): org.slf4j.Marker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.MouseListener"): Internal.MouseListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.FTBQuestsKubeJSTeamDataWrapper"): typeof Internal.FTBQuestsKubeJSTeamDataWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.FluidSievingMachineBlock"): typeof Internal.FluidSievingMachineBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Turtle"): typeof Internal.Turtle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.LootPool"): typeof Internal.LootPool;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$CycleableValueSet"): Internal.OptionInstance$CycleableValueSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.npc.WanderingTrader"): typeof Internal.WanderingTrader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure"): typeof Internal.NetherFortressStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.PrivilegedAction"): Internal.PrivilegedAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.BellowsBlock"): typeof Internal.BellowsBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.RemoteChatSession$Data"): typeof Internal.RemoteChatSession$Data;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix4d"): typeof Internal.Matrix4d;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.common.effect.CustomParticleMobEffect"): typeof Internal.CustomParticleMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent"): typeof Internal.RegisterClientTooltipComponentFactoriesEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.innovation.common.item.PotionQuiverItem"): typeof Internal.PotionQuiverItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tocraft.walkers.mixin.accessor.CreeperEntityAccessor"): Internal.CreeperEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.IBlockHolder"): Internal.IBlockHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.CyanLampBlock"): typeof Internal.CyanLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.events.ContainerEventHandler"): Internal.ContainerEventHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoublePredicate"): it.unimi.dsi.fastutil.doubles.DoublePredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.VillagerProfessionBuilder"): typeof Internal.VillagerProfessionBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.runtime.IEditModeConfig"): Internal.IEditModeConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Shearable"): Internal.Shearable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.runtime.config.IJeiConfigValue"): Internal.IJeiConfigValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.restock.RestockUpgradeWrapper"): typeof Internal.RestockUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeFluid"): Internal.IForgeFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.IBeeGrowable"): Internal.IBeeGrowable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector4dc"): Internal.Vector4dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.scores.Objective"): typeof Internal.Objective;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.chrono.IsoChronology"): typeof Internal.IsoChronology;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.keyframe.event.data.KeyFrameData"): typeof Internal.KeyFrameData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration"): typeof Internal.SimpleRandomFeatureConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Bee"): typeof Internal.Bee;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.SconceBlock"): typeof Internal.SconceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.color.item.ItemColors"): typeof Internal.ItemColors;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.util.UIState"): typeof Internal.UIState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.IceChargeItem"): typeof Internal.IceChargeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.GraphicsConfigTemplate"): typeof Internal.GraphicsConfigTemplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.bindings.ItemWrapper"): Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.block.DetectorBlock"): typeof Internal.DetectorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.ExplosionDamageCalculator"): typeof Internal.ExplosionDamageCalculator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.kinds.K2"): Internal.K2;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.horse.ZombieHorse"): typeof Internal.ZombieHorse;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEventListener$DeliveryMode"): typeof Internal.GameEventListener$DeliveryMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.MysticalEssenceItem"): typeof Internal.MysticalEssenceItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundOpenBookPacket"): typeof Internal.ClientboundOpenBookPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.LockCode"): typeof Internal.LockCode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.AwakeningPedestalBlock"): typeof Internal.AwakeningPedestalBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.sawmill.WoodcuttingRecipe$Serializer"): typeof Internal.WoodcuttingRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.typings.desc.GenericDescJS"): typeof Internal.GenericDescJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.display.Context$MapType"): typeof Internal.Context$MapType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.server.command.EnumArgument$Info"): typeof Internal.EnumArgument$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.WidgetLayout$Padding"): typeof Internal.WidgetLayout$Padding;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.PlanterBlock"): typeof Internal.PlanterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.RaidDebugRenderer"): typeof Internal.RaidDebugRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongIterator"): Internal.LongIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.supermartijn642.fusion.api.model.SpriteIdentifier"): Internal.SpriteIdentifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.TimeArgument$Info"): typeof Internal.TimeArgument$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RegisterClientCommandsEvent"): typeof Internal.RegisterClientCommandsEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.dynamics.common.block.DuctBlock"): typeof Internal.DuctBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$GenericInterpolator"): Internal.Display$GenericInterpolator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.resources.ResourceLocation"): typeof ResourceLocation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P10"): typeof Internal.Products$P10;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.fluid.OreFluidInstance$1"): typeof Internal.OreFluidInstance$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Start"): typeof Internal.LivingEntityUseItemEvent$Start;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.runtime.IJeiKeyMapping"): Internal.IJeiKeyMapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundOpenScreenPacket"): typeof Internal.ClientboundOpenScreenPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.fluids.ForgeFlowingFluid$Flowing"): typeof Internal.ForgeFlowingFluid$Flowing;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.EmptyMapItem"): typeof Internal.EmptyMapItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.BufferBuilder$DrawState"): typeof Internal.BufferBuilder$DrawState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.NopProcessor"): typeof Internal.NopProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.predicates.AllOfCondition$Builder"): typeof Internal.AllOfCondition$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.Codec$ResultFunction"): Internal.Codec$ResultFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.init.registries.TCoreBlocks$6"): typeof Internal.TCoreBlocks$6;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$AwakenedSupremium"): typeof Internal.EssenceFurnaceBlock$AwakenedSupremium;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.opolisutilities.recipe.ResourceGeneratorRecipe$Serializer"): typeof Internal.ResourceGeneratorRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.TrappedChestBlock"): typeof Internal.TrappedChestBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.MangroveDrawerBlock"): typeof Internal.MangroveDrawerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fluid.FluidBuilder"): typeof Internal.FluidBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.stats.RecipeBook"): typeof Internal.RecipeBook;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.item.AccessorItemCooldowns"): Internal.AccessorItemCooldowns;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Locale$Category"): typeof Internal.Locale$Category;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.init.registries.TCoreBlocks$1"): typeof Internal.TCoreBlocks$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.transportstorage.ConveyorBlock"): typeof Internal.ConveyorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.LayeredRegistryAccess"): typeof Internal.LayeredRegistryAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.client.book.BookCategory"): typeof Internal.BookCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.EntityRenderersEvent$CreateSkullModels"): typeof Internal.EntityRenderersEvent$CreateSkullModels;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CommandBlock"): typeof Internal.CommandBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.MysticalSeedsItem"): typeof Internal.MysticalSeedsItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.ThrowableProjectile"): typeof Internal.ThrowableProjectile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerInteractEvent$LeftClickBlock"): typeof Internal.PlayerInteractEvent$LeftClickBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.AbstractList"): typeof Internal.AbstractList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.impl.data.recipes.crafting.ShapedDurabilityRecipe"): typeof Internal.ShapedDurabilityRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.gizmo.luggage.item.LuggageItem"): typeof Internal.LuggageItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ticks.LevelTicks"): typeof Internal.LevelTicks;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.UniqueTag"): typeof Internal.UniqueTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.ProjectileImpactEvent$ImpactResult"): typeof Internal.ProjectileImpactEvent$ImpactResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.worldselection.WorldOpenFlows"): typeof Internal.WorldOpenFlows;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SignItem"): typeof Internal.SignItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.Byte2IntFunction"): Internal.Byte2IntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorNordicTier1Item$Helmet"): typeof Internal.SailorNordicTier1Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.common.item.HangingSignItemCoFH"): typeof Internal.HangingSignItemCoFH;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.IdMappingEvent$ModRemapping"): typeof Internal.IdMappingEvent$ModRemapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Paint"): Internal.Paint;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2BooleanFunction"): Internal.Char2BooleanFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.random.RandomGenerator"): Internal.RandomGenerator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBraceBlock"): typeof Internal.FrameBraceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.block.QuestBarrierBlock"): typeof Internal.QuestBarrierBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetObjectivePacket"): typeof Internal.ClientboundSetObjectivePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.util.filter.IFilter"): Internal.IFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.StonecutterRecipe"): typeof Internal.StonecutterRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimationController$SoundKeyframeHandler"): Internal.AnimationController$SoundKeyframeHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.eventbus.api.IEventListener"): Internal.IEventListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BambooChairBlock"): typeof Internal.BambooChairBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.ChestMenu"): typeof Internal.ChestMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.AWTEvent"): typeof Internal.AWTEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.DiggerItem"): typeof Internal.DiggerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BambooSaplingBlock"): typeof Internal.BambooSaplingBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.event.events.client.ClientCommandRegistrationEvent$ClientCommandSourceStack"): Internal.ClientCommandRegistrationEvent$ClientCommandSourceStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.HalfTransparentBlock"): typeof Internal.HalfTransparentBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.WarpedGrandfatherClockBlock"): typeof Internal.WarpedGrandfatherClockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem$StashResult"): typeof Internal.IStashStorageItem$StashResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.item.XpContainerItem"): typeof Internal.XpContainerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.WalkAnimationState"): typeof Internal.WalkAnimationState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.integration.forge.jei.InformationJEIEventJS"): typeof Internal.InformationJEIEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.AdvancementProgress"): typeof Internal.AdvancementProgress;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.material.WaterFluid$Source"): typeof Internal.WaterFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.BeeDebugRenderer"): typeof Internal.BeeDebugRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ImmutableMap"): typeof Internal.ImmutableMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.fluid.LatexFluid$1"): typeof Internal.LatexFluid$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SolidBucketItem"): typeof Internal.SolidBucketItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.block.EntityBlock4Way"): typeof Internal.EntityBlock4Way;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.api.crafting.ISoulExtractionRecipe"): Internal.ISoulExtractionRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Slime"): typeof Internal.Slime;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.agriculturehusbandry.WitherBuilderBlock"): typeof Internal.WitherBuilderBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.TeamPropertyArgument$Info"): typeof Internal.TeamPropertyArgument$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEventListenerRegistry$ListenerVisitor"): Internal.GameEventListenerRegistry$ListenerVisitor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.VillagerTypeBuilder"): typeof Internal.VillagerTypeBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$BlockDisplay$BlockRenderState"): typeof Internal.Display$BlockDisplay$BlockRenderState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.FireChargeItem"): typeof Internal.FireChargeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.teammetallurgy.aquaculture.item.BlockItemWithoutLevelRenderer"): typeof Internal.BlockItemWithoutLevelRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.forgespi.language.IModInfo"): Internal.IModInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.DoubleSupplier"): Internal.DoubleSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.lib.util.recipes.MachineCatalystSerializer"): typeof Internal.MachineCatalystSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.Struct$StructValidation"): Internal.Struct$StructValidation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.geometry.IGeometryBakingContext"): Internal.IGeometryBakingContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Dialog$ModalExclusionType"): typeof Internal.Dialog$ModalExclusionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.SpectralArrow"): typeof Internal.SpectralArrow;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.supermartijn642.fusion.api.texture.SpriteCreationContext"): Internal.SpriteCreationContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector3i"): typeof Internal.Vector3i;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeLivingEntity"): Internal.IForgeLivingEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.generator.tile.BioReactorTile"): typeof Internal.BioReactorTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.IntSummaryStatistics"): typeof Internal.IntSummaryStatistics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.CorsairTier1Item"): typeof Internal.CorsairTier1Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerEvent$ItemSmeltedEvent"): typeof Internal.PlayerEvent$ItemSmeltedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.predicates.AnyOfCondition$Builder"): typeof Internal.AnyOfCondition$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.WrenchItem"): typeof cofh.thermal.core.common.item.WrenchItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.RedStoneOreBlock"): typeof Internal.RedStoneOreBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.renderable.RenderableImage"): Internal.RenderableImage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure"): typeof Internal.YungJigsawStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.TextureAtlasHolder"): typeof Internal.TextureAtlasHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.util.implementation.EventBasedSpawnModifier$BiomeSpawn"): typeof Internal.EventBasedSpawnModifier$BiomeSpawn;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.world.StructureSettingsBuilder"): typeof Internal.StructureSettingsBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.IronCutlassItem"): typeof Internal.IronCutlassItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.format.TextStyle"): typeof Internal.TextStyle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.client.screen.asset.IAssetProvider"): Internal.IAssetProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.booleans.Boolean2LongFunction"): Internal.Boolean2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.integration.forge.jei.RemoveJEIRecipesEvent"): typeof Internal.RemoveJEIRecipesEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorBlueTier2Item$Boots"): typeof Internal.SailorBlueTier2Item$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.network.NetworkEvent"): typeof Internal.NetworkEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.JungleCounterBlock"): typeof Internal.JungleCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.events.ModifyAttributeEventJS$AttributeModificationHelper"): typeof Internal.ModifyAttributeEventJS$AttributeModificationHelper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jtorleonstudios.libraryferret.effect.StatusEffects$1"): typeof Internal.StatusEffects$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.WarpedSinkCounterBlock"): typeof Internal.WarpedSinkCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.EquipmentSlot$Type"): typeof Internal.EquipmentSlot$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.items.weapon.RemnantsSaberItem"): typeof Internal.RemnantsSaberItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.PositionSourceType"): Internal.PositionSourceType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.WidgetLayout"): Internal.WidgetLayout;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.MenuAccess"): Internal.MenuAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch"): typeof Internal.PrimaryMatch;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.tile.SporesRecreatorTile"): typeof Internal.SporesRecreatorTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.IdMap"): Internal.IdMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.GrassBlock"): typeof Internal.GrassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.flag.FeatureElement"): Internal.FeatureElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.DataLayer"): typeof Internal.DataLayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.TieredItem"): typeof Internal.TieredItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.entries.EntryGroup$Builder"): typeof Internal.EntryGroup$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.Model"): typeof Internal.Model;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.RecipeJS"): typeof Internal.RecipeJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.sawmill.SawmillBlock"): typeof Internal.SawmillBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.PlayerHeadItem"): typeof Internal.PlayerHeadItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner"): Internal.ClientTooltipPositioner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.world.ModifiableStructureInfo"): typeof Internal.ModifiableStructureInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.obscureapi.api.common.classes.Ability$Builder"): typeof Internal.Ability$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.compat.chipped.BlockTransformationUpgradeWrapper"): typeof Internal.BlockTransformationUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.context.SuggestionContext"): typeof Internal.SuggestionContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.families.Algebra"): Internal.Algebra;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.agriculturehusbandry.AnimalBabySeparatorBlock"): typeof Internal.AnimalBabySeparatorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.report.AbuseReportLimits"): typeof Internal.AbuseReportLimits;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.horse.Llama"): typeof Internal.Llama;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.painter.PainterObjectStorage"): typeof Internal.PainterObjectStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType"): typeof Internal.RootPlacerType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.tab.TitaniumTab"): typeof Internal.TitaniumTab;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities"): typeof Internal.NearestVisibleLivingEntities;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent"): typeof Internal.RegisterCapabilitiesEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.tags.TagManager$LoadResult"): typeof Internal.TagManager$LoadResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.server.ServerStartedEvent"): typeof Internal.ServerStartedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.StringSplitter"): typeof Internal.StringSplitter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ForwardingObject"): typeof Internal.ForwardingObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock"): typeof Internal.BlackboardBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature"): typeof Internal.WeightedPlacedFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.ingredient.IRecipeSlotView"): Internal.IRecipeSlotView;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2FloatMap$Entry"): Internal.Object2FloatMap$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.transportstorage.BlackHoleTankBlock$BlackHoleTankItem"): typeof Internal.BlackHoleTankBlock$BlackHoleTankItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrialforegoingsouls.block.tile.SoulLaserBaseBlockEntity"): typeof Internal.SoulLaserBaseBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.ByteBinaryOperator"): Internal.ByteBinaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.io.ConfigParser"): Internal.ConfigParser;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.cache.LocalCache$LocalLoadingCache"): typeof Internal.LocalCache$LocalLoadingCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$ValueSet"): Internal.OptionInstance$ValueSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.crafting.recipe.AwakeningRecipe"): typeof Internal.AwakeningRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeWrapper"): typeof Internal.CraftingUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.DecoratedPotBlockEntity"): typeof Internal.DecoratedPotBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.cazsius.solcarrot.item.FoodBookItem"): typeof Internal.FoodBookItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.item.HorseFeedItem"): typeof Internal.HorseFeedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.particle.ParticleProvider"): Internal.ParticleProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Calendar"): typeof Internal.Calendar;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2FloatFunction"): Internal.Object2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.RandomSelectorFeature"): typeof Internal.RandomSelectorFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.tile.BlockPlacerTile"): typeof Internal.BlockPlacerTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.DivingArmorItem"): typeof Internal.DivingArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.BlockBehaviour$OffsetFunction"): Internal.BlockBehaviour$OffsetFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.PlayerRideable"): Internal.PlayerRideable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ImmutableList"): typeof Internal.ImmutableList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer"): typeof Internal.FancyFoliagePlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.NoiseRouter"): typeof Internal.NoiseRouter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.ISoftFluidConsumer"): Internal.ISoftFluidConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.FoodOnAStickItem"): typeof Internal.FoodOnAStickItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.property.PropertyParam"): typeof Internal.PropertyParam;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.SplashRenderer"): typeof Internal.SplashRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.file.FileConfig"): Internal.FileConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortList"): Internal.ShortList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.RegistryLayer"): typeof Internal.RegistryLayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Shape"): Internal.Shape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity"): typeof Internal.OpeneableContainerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.ShepherdsPieBlock"): typeof Internal.ShepherdsPieBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.FormattedText"): Internal.FormattedText;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.trading.MerchantOffers"): typeof Internal.MerchantOffers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SpikeFeature"): typeof Internal.SpikeFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.resources.HolderSetCodec"): typeof Internal.HolderSetCodec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.particle.ParticleEngine"): typeof Internal.ParticleEngine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.QuickChargeEnchantment"): typeof Internal.QuickChargeEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2ReferenceFunction"): Internal.Reference2ReferenceFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$MouseButtonPressed$Post"): typeof Internal.ScreenEvent$MouseButtonPressed$Post;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ScoreHolderArgument"): typeof Internal.ScoreHolderArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor"): typeof Internal.BlockRotProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.ResultField"): typeof Internal.ResultField;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.item.custom.YellowSprayCanItem"): typeof Internal.YellowSprayCanItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.QuartzBenchBlock"): typeof Internal.QuartzBenchBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor"): typeof Internal.ProtectedBlockProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BirchBenchBlock"): typeof Internal.BirchBenchBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.ContainerEntity"): Internal.ContainerEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.cultivation.common.block.PotionCakeBlock"): typeof Internal.PotionCakeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.ItemTransform"): typeof Internal.ItemTransform;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.EntityLeaveLevelEvent"): typeof Internal.EntityLeaveLevelEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.GlassChairBlock"): typeof Internal.GlassChairBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.SconceLeverBlock"): typeof Internal.SconceLeverBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$AbstractImmutableSet"): typeof Internal.ImmutableCollections$AbstractImmutableSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.arguments.FloatArgumentType"): typeof Internal.FloatArgumentType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.horse.Markings"): typeof Internal.Markings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.ReplaceBlobsFeature"): typeof Internal.ReplaceBlobsFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.presets.WorldPreset"): typeof Internal.WorldPreset;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.ComponentPath"): Internal.ComponentPath;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.FletchingTableBlock"): typeof Internal.FletchingTableBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.Panel"): typeof Internal.Panel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.ServerScoreboard"): typeof Internal.ServerScoreboard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.BufferBuilder$RenderedBuffer"): typeof Internal.BufferBuilder$RenderedBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.trunkplacers.ForkingTrunkPlacer"): typeof Internal.ForkingTrunkPlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.ReloadableServerResources"): typeof Internal.ReloadableServerResources;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display"): typeof Internal.Display;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.PoisonBoneCutlassItem"): typeof Internal.PoisonBoneCutlassItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.TeamRank"): typeof Internal.TeamRank;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$MouseButtonPressed"): typeof Internal.ScreenEvent$MouseButtonPressed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.TooltipFlag"): Internal.TooltipFlag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.items.RuneOfTheStormItem"): typeof Internal.RuneOfTheStormItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2ShortFunction"): Internal.Double2ShortFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.AmbientParticleSettings"): typeof Internal.AmbientParticleSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.WrappedExecutable"): Internal.WrappedExecutable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.AnvilUpdateEvent"): typeof Internal.AnvilUpdateEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2FloatFunction"): Internal.Char2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.schema.minecraft.ShapedRecipeSchema$ShapedRecipeJS"): typeof Internal.ShapedRecipeSchema$ShapedRecipeJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgePackResources"): Internal.IForgePackResources;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeHolderSet$SerializationType"): typeof Internal.IForgeHolderSet$SerializationType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.BedPart"): typeof Internal.BedPart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.PageAttributes$OrientationRequestedType"): typeof Internal.PageAttributes$OrientationRequestedType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tocraft.walkers.mixin.accessor.BiomeAccessor"): Internal.BiomeAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent"): typeof Internal.ScreenInitEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.attributefix.mixin.AccessorRangedAttribute"): Internal.AccessorRangedAttribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.CriterionProgress"): typeof Internal.CriterionProgress;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.ResultConsumer"): Internal.ResultConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderGuiEvent"): typeof Internal.RenderGuiEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.PickaxeItemBuilder"): typeof Internal.PickaxeItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeLevel"): Internal.IForgeLevel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.XpCrystalItem"): typeof Internal.XpCrystalItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2LongFunction"): Internal.Int2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2ObjectFunction"): Internal.Reference2ObjectFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundHorseScreenOpenPacket"): typeof Internal.ClientboundHorseScreenOpenPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.loot.BlockLootSubProvider"): typeof Internal.BlockLootSubProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.server.CommandEventJS"): typeof Internal.CommandEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.EntityAttributeModificationEvent"): typeof Internal.EntityAttributeModificationEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.teammetallurgy.aquaculture.block.WormFarmBlock"): typeof Internal.WormFarmBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.callbacks.BlockStateMirrorCallbackJS"): typeof Internal.BlockStateMirrorCallbackJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.ReplacementMatch"): Internal.ReplacementMatch;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.util.ContextUtils$PassengerEntityContext"): typeof Internal.ContextUtils$PassengerEntityContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.MovementInputUpdateEvent"): typeof Internal.MovementInputUpdateEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.JigsawStructure"): typeof Internal.JigsawStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceOrTagArgument"): typeof Internal.ResourceOrTagArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector3f"): typeof Vec3f;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.builders.ProjectileEntityJSBuilder"): typeof Internal.ProjectileEntityJSBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.WorldlyContainer"): Internal.WorldlyContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.ClientPacketListener"): typeof Internal.ClientPacketListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RegisterColorHandlersEvent$Item"): typeof Internal.RegisterColorHandlersEvent$Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fonnymunkey.simplehats.common.item.HatDisplayItem"): typeof Internal.HatDisplayItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerXpEvent$XpChange"): typeof Internal.PlayerXpEvent$XpChange;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration"): typeof Internal.NoneFeatureConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.util.RegistrationHelper$1"): typeof Internal.RegistrationHelper$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.RichSoilFarmlandBlock"): typeof Internal.RichSoilFarmlandBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.capabilities.ICapabilitySerializable"): Internal.ICapabilitySerializable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.ShoulderRidingEntity"): typeof Internal.ShoulderRidingEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.teammetallurgy.aquaculture.item.FishItem"): typeof Internal.FishItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.WritableRaster"): typeof Internal.WritableRaster;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fluid.FluidWrapper"): typeof Fluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType"): Internal.IMycelialGeneratorType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.misc.tile.MobDetectorTile"): typeof Internal.MobDetectorTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.generator.BioReactorBlock"): typeof Internal.BioReactorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagradditions.world.modifiers.EndInferiumOreModifier"): typeof Internal.EndInferiumOreModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SeagrassFeature"): typeof Internal.SeagrassFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$MouseScrolled"): typeof Internal.ScreenEvent$MouseScrolled;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.fluid.FluidStack"): typeof dev.architectury.fluid.FluidStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.item.tool.BaseShovelItem"): typeof Internal.BaseShovelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.FireworkRocketRecipe"): typeof Internal.FireworkRocketRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.recipes.RecipeCategory"): typeof Internal.RecipeCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fluid.InputFluid"): Internal.InputFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.chars.Char2ShortFunction"): Internal.Char2ShortFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.damagesource.DamageType"): typeof Internal.DamageType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer"): typeof Internal.LootPoolEntryContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.LightUpBlock"): typeof Internal.LightUpBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.TripWireHookBlock"): typeof Internal.TripWireHookBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.GoldDoorBlock"): typeof Internal.GoldDoorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.Style"): typeof Internal.Style;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.particles.ParticleType"): typeof Internal.ParticleType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.item.BaseWateringCanItem"): typeof Internal.BaseWateringCanItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.particles.ParticleOptions"): Internal.ParticleOptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.RarityFilter"): typeof Internal.RarityFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.WritableLevelData"): Internal.WritableLevelData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.Animation$LoopType"): Internal.Animation$LoopType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector2f"): typeof Internal.Vector2f;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.recipe.IFocusFactory"): Internal.IFocusFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorBlueTier1Item$Helmet"): typeof Internal.SailorBlueTier1Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ContainerListener"): net.minecraft.world.ContainerListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.ClientLevel$ClientLevelData"): typeof Internal.ClientLevel$ClientLevelData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.icon.Color4I"): typeof Internal.Color4I;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.SofaLightGrayBlock"): typeof Internal.SofaLightGrayBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.api.soul.MobSoulType"): typeof Internal.MobSoulType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DragSource"): typeof Internal.DragSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.opolisutilities.recipe.UpgradeRecipeUtil"): typeof Internal.UpgradeRecipeUtil;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.SlabBlockBuilder"): typeof Internal.SlabBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.core.fluid.ArchitecturyFlowingFluid"): typeof Internal.ArchitecturyFlowingFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.block.BasicTileBlock"): typeof Internal.BasicTileBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.events.SimpleEvent"): Internal.SimpleEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.StandingAndWallBlockItem"): typeof Internal.StandingAndWallBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.Accessible"): Internal.Accessible;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.GenerateClientAssetsEventJS"): typeof Internal.GenerateClientAssetsEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapperAccessor"): Internal.IUpgradeWrapperAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.material.EmptyFluid"): typeof Internal.EmptyFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.GrindstoneBlock"): typeof Internal.GrindstoneBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.random.WeightedEntry$IntrusiveBase"): typeof Internal.WeightedEntry$IntrusiveBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ModelEvent"): typeof Internal.ModelEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.IntPredicate"): Internal.IntPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.transportstorage.tile.TransporterTile"): typeof Internal.TransporterTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.ResourcefulFurnaceBlock"): typeof Internal.ResourcefulFurnaceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.tool.EssenceBowItem"): typeof Internal.EssenceBowItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SoundType"): typeof SoundType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.Pointer$Default"): typeof Internal.Pointer$Default;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider"): typeof Internal.NoiseProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.Instrument"): typeof Internal.Instrument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2ShortFunction"): Internal.Object2ShortFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.LockBlock"): typeof Internal.LockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.JobAttributes$MultipleDocumentHandlingType"): typeof Internal.JobAttributes$MultipleDocumentHandlingType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.util.recipes.SerializableRecipe"): typeof cofh.lib.util.recipes.SerializableRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ModelEvent$RegisterAdditional"): typeof Internal.ModelEvent$RegisterAdditional;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.JsonDeserializationContext"): Internal.JsonDeserializationContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Spliterator$OfPrimitive"): Internal.Spliterator$OfPrimitive;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.MenuType"): typeof Internal.MenuType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WallSignBlock"): typeof Internal.WallSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.sounds.TickableSoundInstance"): Internal.TickableSoundInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.item.MaxCountFilterItem"): typeof Internal.MaxCountFilterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.floats.Float2LongFunction"): Internal.Float2LongFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.AdvancementJS"): typeof Internal.AdvancementJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.GlassBlock"): typeof Internal.GlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BannerPattern"): typeof Internal.BannerPattern;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BannerItem"): typeof Internal.BannerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.ThornsEnchantment"): typeof Internal.ThornsEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BaseCoralPlantBlock"): typeof Internal.BaseCoralPlantBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.allthemods.alltheores.blocks.OtherOreBlock"): typeof Internal.OtherOreBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.IRotatable"): Internal.IRotatable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.DoubleHighBlockItem"): typeof Internal.DoubleHighBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.DataResult"): typeof Internal.DataResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.Difficulty"): typeof Internal.Difficulty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen"): typeof Internal.EffectRenderingInventoryScreen;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Skull3Item"): typeof Internal.Skull3Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.RecipeKJS"): Internal.RecipeKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.HeightmapPlacement"): typeof Internal.HeightmapPlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.DoubleUnaryOperator"): Internal.DoubleUnaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.TintedGlassBlock"): typeof Internal.TintedGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerEvent$ItemPickupEvent"): typeof Internal.PlayerEvent$ItemPickupEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory"): Internal.TypeWrapperFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.agriculturehusbandry.tile.AnimalFeederTile"): typeof Internal.AnimalFeederTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.event.forge.PopupMenuEvent$Layer"): typeof Internal.PopupMenuEvent$Layer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ArmorMaterial"): Internal.ArmorMaterial;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.SoundAction"): typeof Internal.SoundAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.carver.CarvingContext"): typeof Internal.CarvingContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.control.Control"): Internal.Control;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeAbstractMinecart"): Internal.IForgeAbstractMinecart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "realmayus.aquatictorches.AquaticTorchBlock"): typeof Internal.AquaticTorchBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.Direction"): typeof Internal.Direction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.CommandBuildContext"): Internal.CommandBuildContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.GeodeLayerSettings"): typeof Internal.GeodeLayerSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.DebugRenderer"): typeof Internal.DebugRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.ThrowableItemProjectile"): typeof Internal.ThrowableItemProjectile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.world.StructureModifier$Phase"): typeof Internal.StructureModifier$Phase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.scores.PlayerTeam"): typeof Internal.PlayerTeam;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise"): typeof Internal.PerlinSimplexNoise;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon"): typeof Internal.ProgressBarScreenAddon;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.LootDataType"): typeof Internal.LootDataType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.item.GrenadeItem"): typeof Internal.GrenadeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.MenuItem"): typeof Internal.MenuItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.OakWallClockBlock"): typeof Internal.OakWallClockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BeehiveBlockEntity$BeeReleaseStatus"): typeof Internal.BeehiveBlockEntity$BeeReleaseStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.warden.Warden"): typeof Internal.Warden;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.java.FieldInfo"): typeof Internal.FieldInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SaddleItem"): typeof Internal.SaddleItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.recipe.transfer.IRecipeTransferManager"): Internal.IRecipeTransferManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.OrRecipeComponent"): typeof Internal.OrRecipeComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.raid.Raid"): typeof Internal.Raid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.platform.NativeImage$Format"): typeof Internal.NativeImage$Format;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.chrono.Chronology"): Internal.Chronology;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.ItemKJS"): Internal.ItemKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.item.IAugmentableItem"): Internal.IAugmentableItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.Context"): typeof Internal.Context;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BoneMealItem"): typeof Internal.BoneMealItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.datatransfer.Clipboard"): typeof Internal.Clipboard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache"): typeof Internal.AnimatableInstanceCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.gui.chest.ChestMenuSlot"): typeof Internal.ChestMenuSlot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.common.inventory.SimpleItemInv"): typeof Internal.SimpleItemInv;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.Delayed"): Internal.Delayed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WallBlock"): typeof Internal.WallBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.booleans.Boolean2FloatFunction"): Internal.Boolean2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blamejared.controlling.mixin.AccessKeyMapping"): Internal.AccessKeyMapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.api.item.IEnergyContainerItem"): Internal.IEnergyContainerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration"): typeof Internal.DeltaFeatureConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket"): typeof Internal.ServerboundPlaceRecipePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.ColorModel"): typeof Internal.ColorModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Skeleton"): typeof Internal.Skeleton;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.JsonPrimitive"): typeof Internal.JsonPrimitive;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.texture.SpriteContents$AnimatedTexture"): typeof Internal.SpriteContents$AnimatedTexture;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.IForgeRegistryInternal"): Internal.IForgeRegistryInternal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.LongUnaryOperator"): Internal.LongUnaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.PirateTier1Item$Leggings"): typeof Internal.PirateTier1Item$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.ComponentKJS"): Internal.ComponentKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.BiomeSpecialEffects"): typeof Internal.BiomeSpecialEffects;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BoundingBoxAccessor"): Internal.BoundingBoxAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Saddleable"): Internal.Saddleable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.opolisutilities.recipe.UpgradeRecipeUtil$Serializer"): typeof Internal.UpgradeRecipeUtil$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.registry.RegistryCallback"): Internal.RegistryCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.FormattedCharSink"): Internal.FormattedCharSink;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.Tiers"): typeof Internal.Tiers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.DecoratedPotRecipe"): typeof Internal.DecoratedPotRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.MenuContainer"): Internal.MenuContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.SafeBlock"): typeof Internal.SafeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapMode"): typeof Internal.ToolSwapMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.BooleanComponent"): typeof Internal.BooleanComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeConfig"): typeof Internal.BatteryUpgradeConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer"): typeof Internal.ItemStackRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor"): typeof Internal.JigsawReplacementProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DeadBushBlock"): typeof Internal.DeadBushBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Merchant2Item"): typeof Internal.Merchant2Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.spec.AlgorithmParameterSpec"): Internal.AlgorithmParameterSpec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket"): typeof Internal.ClientboundUpdateAdvancementsPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.UnderwaterMagmaFeature"): typeof Internal.UnderwaterMagmaFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector4d"): typeof Internal.Vector4d;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.schema.DynamicRecipeComponent$Factory"): Internal.DynamicRecipeComponent$Factory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.brightblock.BrightFenceBlock"): typeof Internal.BrightFenceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.RotatedPillarBlock"): typeof Internal.RotatedPillarBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.reward.RewardType"): typeof Internal.RewardType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.generator.ResourceGenerator"): typeof Internal.ResourceGenerator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.CustomRecipe"): typeof Internal.CustomRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.CompressorHolder"): typeof Internal.CompressorHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix3x2dc"): Internal.Matrix3x2dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Merchant3Item$Boots"): typeof Internal.Merchant3Item$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.PostPass"): typeof Internal.PostPass;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.IntBinaryOperator"): it.unimi.dsi.fastutil.ints.IntBinaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.SimpleCookingSerializer"): typeof Internal.SimpleCookingSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.shaders.Program$Type"): typeof Internal.Program$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.compacting.CompactingUpgradeWrapper"): typeof Internal.CompactingUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket"): typeof Internal.ClientboundUpdateAttributesPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.reflect.TypeParameter"): typeof Internal.TypeParameter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.font.glyphs.BakedGlyph$Effect"): typeof Internal.BakedGlyph$Effect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.ConcurrentHashMap"): typeof Internal.ConcurrentHashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade"): Internal.IOverflowResponseUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.misc.CaveFilter$Type"): typeof Internal.CaveFilter$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.CameraType"): typeof Internal.CameraType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleAction"): Internal.AccessibleAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundPlayerInputPacket"): typeof Internal.ServerboundPlayerInputPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorBlueTier2Item"): typeof Internal.SailorBlueTier2Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension"): Internal.TextureAtlasSpriteExtension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.recipe.category.IRecipeCategory"): Internal.IRecipeCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SoulSandBlock"): typeof Internal.SoulSandBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BushBlock"): typeof Internal.BushBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.TeamPropertyArgument"): typeof Internal.TeamPropertyArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.PirateTier3Item$Leggings"): typeof Internal.PirateTier3Item$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType"): typeof Internal.UpgradeType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.RenderShape"): typeof Internal.RenderShape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.lib.common.block.DynamoBlock"): typeof Internal.DynamoBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.brightblock.BrightLeavesBlock"): typeof Internal.BrightLeavesBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.forgespi.language.IModInfo$ModVersion"): Internal.IModInfo$ModVersion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.chat.report.AbuseReportSender"): Internal.AbuseReportSender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.LootContext$VisitedEntry"): typeof Internal.LootContext$VisitedEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.ShortTag"): typeof Internal.ShortTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.stonecutter.StonecutterUpgradeItem"): typeof Internal.StonecutterUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.phases.DragonSittingAttackingPhase"): typeof Internal.DragonSittingAttackingPhase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.block.EntityBlockCoFH"): typeof Internal.EntityBlockCoFH;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BambooWallClockBlock"): typeof Internal.BambooWallClockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Hashtable"): typeof Internal.Hashtable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.entity.EntityEventJS"): typeof Internal.EntityEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.display.IWaypointDisplay"): Internal.IWaypointDisplay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.texture.DynamicTexture"): typeof Internal.DynamicTexture;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.BlockLootEventJS"): typeof Internal.BlockLootEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ScoreHolderArgument$Info"): typeof Internal.ScoreHolderArgument$Info;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.phases.DragonStrafePlayerPhase"): typeof Internal.DragonStrafePlayerPhase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.BiomeManager$NoiseBiomeSource"): Internal.BiomeManager$NoiseBiomeSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.WarpedCounterBlock"): typeof Internal.WarpedCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.SurfaceRules$Context"): typeof Internal.SurfaceRules$Context;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.entities.BombEntity"): typeof Internal.BombEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.item.ItemInventory"): typeof Internal.ItemInventory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket"): typeof Internal.ClientboundSetTitleTextPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.items.armor.AbyssalArmorItem$Boots"): typeof Internal.AbyssalArmorItem$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.HolderLookup$Provider"): Internal.HolderLookup$Provider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.CommandStorage"): typeof Internal.CommandStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.file.FileNotFoundAction"): Internal.FileNotFoundAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.callbacks.CanBeReplacedCallbackJS"): typeof Internal.CanBeReplacedCallbackJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2FloatFunction"): Internal.Reference2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.misc.IExtendedItem"): Internal.IExtendedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.xplat.XplatModContainer"): Internal.XplatModContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.registry.menu.MenuRegistry$ScreenFactory"): Internal.MenuRegistry$ScreenFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.SackBlock"): typeof Internal.SackBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.component.sideness.IFacingComponent"): Internal.IFacingComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Queue"): Internal.Queue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.GrindstoneMenu"): typeof Internal.GrindstoneMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.FishermanItem$Helmet"): typeof Internal.FishermanItem$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.LivingConversionEvent$Post"): typeof Internal.LivingConversionEvent$Post;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.opolisutilities.recipe.DryingTableRecipe"): typeof Internal.DryingTableRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.util.Lazy$Fast"): typeof Internal.Lazy$Fast;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.refill.RefillUpgradeItem"): typeof Internal.RefillUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.misc.EnchantmentExtractorBlock"): typeof Internal.EnchantmentExtractorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.crypto.ExemptionMechanism"): typeof Internal.ExemptionMechanism;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.shaders.Shader"): Internal.Shader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.ConstProperties"): Internal.ConstProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.client.book.gui.GuiBook"): typeof Internal.GuiBook;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.PageAttributes$OriginType"): typeof Internal.PageAttributes$OriginType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.item.BlockTypeBasedItem"): typeof Internal.BlockTypeBasedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BlackLampBlock"): typeof Internal.BlackLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerEvent$BreakSpeed"): typeof Internal.PlayerEvent$BreakSpeed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.datatransfer.DataFlavor"): typeof Internal.DataFlavor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.AxisCycle"): typeof Internal.AxisCycle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleStateSet"): typeof Internal.AccessibleStateSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.ItemShelfBlock"): typeof Internal.ItemShelfBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.ByteIterable"): Internal.ByteIterable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.capabilities.ICapabilityProvider"): Internal.ICapabilityProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "top.theillusivec4.curios.api.type.capability.ICurioItem"): Internal.ICurioItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.village.WandererTradesEvent"): typeof Internal.WandererTradesEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone"): typeof Internal.EnumUpgradeRedstone;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.AttachCapabilitiesEvent"): typeof Internal.AttachCapabilitiesEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.material.Fluid"): typeof Internal.Fluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.spectator.SpectatorMenuItem"): Internal.SpectatorMenuItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.raid.Raider"): typeof Internal.Raider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "eutros.framedcompactdrawers.block.BlockCompDrawersCustom"): typeof Internal.BlockCompDrawersCustom;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.ConcurrentMap"): Internal.ConcurrentMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WeatheringCopper$WeatherState"): typeof Internal.WeatheringCopper$WeatherState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.SpruceStorageCounterBlock"): typeof Internal.SpruceStorageCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.narration.NarratableEntry"): Internal.NarratableEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.MemoryStack"): typeof Internal.MemoryStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.SecondaryPoiSensor"): typeof Internal.SecondaryPoiSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.ContainerEvent"): typeof Internal.ContainerEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.BuildCreativeModeTabContentsEvent"): typeof Internal.BuildCreativeModeTabContentsEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ImmutableCollection$Builder"): typeof Internal.ImmutableCollection$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.DarkOakFoliagePlacer"): typeof Internal.DarkOakFoliagePlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorRedTier2Item"): typeof Internal.SailorRedTier2Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile"): typeof Internal.ItemDisplayTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.players.StoredUserEntry"): typeof Internal.StoredUserEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.RakedGravelBlock"): typeof Internal.RakedGravelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.scouter.oceansdelight.blocks.GuardianSoupBlock"): typeof Internal.GuardianSoupBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundStopSoundPacket"): typeof Internal.ClientboundStopSoundPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.AbstractCookingRecipe"): typeof Internal.AbstractCookingRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.common.fluid.FluidIngredient$IFluidList"): Internal.FluidIngredient$IFluidList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.font.glyphs.BakedGlyph"): typeof Internal.BakedGlyph;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.PalettedContainer$Configuration"): typeof Internal.PalettedContainer$Configuration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.ObjectSortedSet"): Internal.ObjectSortedSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure"): typeof Internal.BuriedTreasureStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BedBlock"): typeof Internal.BedBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.RootsBlock"): typeof Internal.RootsBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate$StructureEntityInfo"): typeof Internal.StructureTemplate$StructureEntityInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electrolyte.matc.items.TertiumCrystal"): typeof Internal.TertiumCrystal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.util.implementation.EventBasedSpawnModifier"): typeof Internal.EventBasedSpawnModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.maven.artifact.versioning.Restriction"): typeof Internal.Restriction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.Services"): typeof Internal.Services;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.QuestObjectType"): typeof Internal.QuestObjectType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity"): typeof Internal.ShulkerBoxBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2ObjectMap$Entry"): Internal.Object2ObjectMap$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.font.TextHitInfo"): typeof Internal.TextHitInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.tile.WaterCondensatorTile"): typeof Internal.WaterCondensatorTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.display.WaypointGroup"): typeof Internal.WaypointGroup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.api.IFluidHandlerWrapperUpgrade"): Internal.IFluidHandlerWrapperUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.item.addon.RangeAddonItem"): typeof Internal.RangeAddonItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.tags.TagNetworkSerialization$NetworkPayload"): typeof Internal.TagNetworkSerialization$NetworkPayload;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement"): typeof Internal.RandomOffsetPlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ClientChatEvent"): typeof Internal.ClientChatEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.forge.ForgeEventWrapper"): typeof Internal.ForgeEventWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemCraftedEventJS"): typeof Internal.ItemCraftedEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.transportstorage.ConveyorBlock$EnumType"): typeof Internal.ConveyorBlock$EnumType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.AttributeValue"): typeof Internal.AttributeValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.ServerChatEvent"): typeof Internal.ServerChatEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.gui.chest.ChestMenuClickCallback"): Internal.ChestMenuClickCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.player.Player"): typeof Internal.Player;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.obscureapi.event.ObscureAPIRegisterBossBarsEvent"): typeof Internal.ObscureAPIRegisterBossBarsEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.SculkPatchConfiguration"): typeof Internal.SculkPatchConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.DamageEnchantment"): typeof Internal.DamageEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.item.infinity.item.ItemInfinitySaw"): typeof Internal.ItemInfinitySaw;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.ShulkerBoxColoring"): typeof Internal.ShulkerBoxColoring;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animatable.model.CoreGeoModel"): Internal.CoreGeoModel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceOrTagKeyArgument$Result"): Internal.ResourceOrTagKeyArgument$Result;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.texture.SpriteContents"): typeof Internal.SpriteContents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.StoveBlock"): typeof Internal.StoveBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.GameRules$Key"): typeof Internal.GameRules$Key;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.behavior.EntityTracker"): typeof Internal.EntityTracker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.server.ServerLifecycleEvent"): typeof Internal.ServerLifecycleEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.IScreenWrapper"): Internal.IScreenWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.SkilletBlock"): typeof Internal.SkilletBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.NumberComponent$LongRange"): typeof Internal.NumberComponent$LongRange;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.network.locator.PlayerInventoryFinder$IStackModifier"): Internal.PlayerInventoryFinder$IStackModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.OutputReplacementTransformer$Replacement"): typeof Internal.OutputReplacementTransformer$Replacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.events.BuildBrainEventJS"): typeof Internal.BuildBrainEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.Codec"): Internal.Codec;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.IntProviderType"): Internal.IntProviderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration"): typeof Internal.BlockStateConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.io.ConfigWriter"): Internal.ConfigWriter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.fluid.HeavyOilFluid$1"): typeof Internal.HeavyOilFluid$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.BundlerInfo$Provider"): Internal.BundlerInfo$Provider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2IntFunction"): Internal.Int2IntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.AbstractObject2FloatMap"): typeof Internal.AbstractObject2FloatMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zetaimplforge.client.IZetaForgeItemStuff"): Internal.IZetaForgeItemStuff;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BubbleColumnBlock"): typeof Internal.BubbleColumnBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.EffectInstance"): typeof Internal.EffectInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.brightblock.FlammableBrightFullBlock"): typeof Internal.FlammableBrightFullBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.CoralFeature"): typeof Internal.CoralFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundCooldownPacket"): typeof Internal.ClientboundCooldownPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.builders.MobEntityJSBuilder"): typeof Internal.MobEntityJSBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.network.NetworkDirection"): typeof Internal.NetworkDirection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.report.ReportEvidence"): typeof Internal.ReportEvidence;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.maven.artifact.versioning.ArtifactVersion"): Internal.ArtifactVersion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fr.iglee42.notenoughchests.chest.CustomChestBlock"): typeof Internal.CustomChestBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier"): Internal.RuleBlockEntityModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEventListener$Holder"): Internal.GameEventListener$Holder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.VertexSorting"): Internal.VertexSorting;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket"): typeof Internal.ClientboundPlayerCombatEndPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.BlackstoneReplaceProcessor"): typeof Internal.BlackstoneReplaceProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.IRecipeLayoutDrawable"): Internal.IRecipeLayoutDrawable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrialforegoingsouls.block.SoulLaserBaseBlock"): typeof Internal.SoulLaserBaseBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.RandomPatchFeature"): typeof Internal.RandomPatchFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerEvent$PlayerRespawnEvent"): typeof Internal.PlayerEvent$PlayerRespawnEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.IsInWaterSensor"): typeof Internal.IsInWaterSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.CriterionTriggerInstance"): Internal.CriterionTriggerInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.NBTIOWrapper"): NBTIO;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.sounds.MusicManager"): typeof Internal.MusicManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.moddingx.libx.command.EnumArgument2"): typeof Internal.EnumArgument2;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.registry.ModRecipeTypes$1"): typeof Internal.ModRecipeTypes$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BeehiveBlockEntity"): typeof Internal.BeehiveBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.crafting.recipe.SoulExtractionRecipe$Serializer"): typeof Internal.SoulExtractionRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.floats.Float2ReferenceFunction"): Internal.Float2ReferenceFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.JungleMirrorStandBlock"): typeof Internal.JungleMirrorStandBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.MinecartChest"): typeof Internal.MinecartChest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket"): typeof Internal.ClientboundChunksBiomesPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.item.BaseArmorItem"): typeof Internal.BaseArmorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.stateproviders.RotatedBlockProvider"): typeof Internal.RotatedBlockProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.java.MethodInfo$ParamInfo"): typeof Internal.MethodInfo$ParamInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.EntitySelector"): typeof net.minecraft.world.entity.EntitySelector;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.fluid.OreFluid$Source"): typeof Internal.OreFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.TomatoVineBlock"): typeof Internal.TomatoVineBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.players.BanListEntry"): typeof Internal.BanListEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.handlers.IGuiClickableArea"): Internal.IGuiClickableArea;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent"): Internal.ClientTooltipComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Parrot"): typeof Internal.Parrot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.FlagItem"): typeof Internal.FlagItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup"): Internal.IDrawerGroup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.MagmaCube"): typeof Internal.MagmaCube;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix3d"): typeof Internal.Matrix3d;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.file.CommentedFileConfigBuilder"): typeof Internal.CommentedFileConfigBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.stb.STBTTFontinfo"): typeof Internal.STBTTFontinfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.block.ShipInBottleBlock"): typeof Internal.ShipInBottleBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoubleListIterator"): Internal.DoubleListIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.predicate.BlockIDPredicate$PropertyObject"): typeof Internal.BlockIDPredicate$PropertyObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Salmon"): typeof Internal.Salmon;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DispenserBlock"): typeof Internal.DispenserBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.JigsawBlock"): typeof Internal.JigsawBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemTooltipEventJS$StaticTooltipHandlerFromJS"): Internal.ItemTooltipEventJS$StaticTooltipHandlerFromJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.item.NOTFilterItem"): typeof Internal.NOTFilterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace"): typeof Internal.RecipeNamespace;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Fox$Type"): typeof Internal.Fox$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.IdentityHashMap"): typeof Internal.IdentityHashMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.entity.AccessorEntity"): Internal.AccessorEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.OakStorageCounterBlock"): typeof Internal.OakStorageCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.CompletionStage"): Internal.CompletionStage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.types.Type$FieldNotFoundException"): typeof Internal.Type$FieldNotFoundException;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BirchSinkCounterBlock"): typeof Internal.BirchSinkCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.init.registries.TCoreBlocks$5"): typeof Internal.TCoreBlocks$5;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.gui.chest.ChestMenuClickHandler"): typeof Internal.ChestMenuClickHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DropTargetEvent"): typeof Internal.DropTargetEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.world.AccessorRecipeManager"): Internal.AccessorRecipeManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundAddEntityPacket"): typeof Internal.ClientboundAddEntityPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.Widget"): typeof Internal.Widget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.JobAttributes$SidesType"): typeof Internal.JobAttributes$SidesType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.events.ObjectStartedEvent$ChapterEvent"): typeof Internal.ObjectStartedEvent$ChapterEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.SortedMap"): Internal.SortedMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.BlockPredicateFilter"): typeof Internal.BlockPredicateFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.Position"): Internal.Position;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.MobEffectEvent"): typeof Internal.MobEffectEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunctions$BeardifierOrMarker"): Internal.DensityFunctions$BeardifierOrMarker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.synchronization.brigadier.StringArgumentSerializer$Template"): typeof Internal.StringArgumentSerializer$Template;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.MultiBufferSource$BufferSource"): typeof Internal.MultiBufferSource$BufferSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.DownloadedPackSource"): typeof Internal.DownloadedPackSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData"): typeof Internal.ControllerData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.CrimsonDeskBlock"): typeof Internal.CrimsonDeskBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.RespawnAnchorBlock"): typeof Internal.RespawnAnchorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.repository.Pack$Position"): typeof Internal.Pack$Position;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.network.ServerGamePacketListenerImpl"): typeof Internal.ServerGamePacketListenerImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.helpers.IStackHelper"): Internal.IStackHelper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.GameType"): typeof Internal.GameType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.temporal.TemporalQuery"): Internal.TemporalQuery;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.creativetab.CreativeTabBuilder"): typeof Internal.CreativeTabBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundPlayerActionPacket$Action"): typeof Internal.ServerboundPlayerActionPacket$Action;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.properties.Property"): typeof com.mojang.authlib.properties.Property;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.lang.Appendable"): Internal.Appendable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.api.conveyor.gui.IGuiComponent"): Internal.IGuiComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BigDripleafBlock"): typeof Internal.BigDripleafBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.HolderSet"): Internal.HolderSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.BoneCutlassItem"): typeof Internal.BoneCutlassItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.model.MapImage"): typeof Internal.MapImage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.datagenerator.loot.block.BasicBlockLootTables"): typeof Internal.BasicBlockLootTables;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer"): Internal.IDrawer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.WrapFactory"): typeof Internal.WrapFactory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket"): typeof Internal.ServerboundPlayerCommandPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe"): typeof Internal.MycelialGeneratorRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.cultivation.common.item.PotionCakeBlockItem"): typeof Internal.PotionCakeBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WeatheringCopperStairBlock"): typeof Internal.WeatheringCopperStairBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.light_gray.LightGrayStandingSignBlock"): typeof Internal.LightGrayStandingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement"): typeof Internal.EnvironmentScanPlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.LiquidBlockContainer"): Internal.LiquidBlockContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Iterator"): Internal.Iterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.FormattedText$ContentConsumer"): Internal.FormattedText$ContentConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BambooPlankBlock"): typeof Internal.BambooPlankBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor"): net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.RuinedPortalStructure"): typeof Internal.RuinedPortalStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.AbstractWidget"): typeof Internal.AbstractWidget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.EnderEyeItem"): typeof Internal.EnderEyeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.LecternMenu"): typeof Internal.LecternMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.tile.IndustrialWorkingTile$WorkAction"): typeof Internal.IndustrialWorkingTile$WorkAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.block_network.Network"): typeof Internal.Network;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.BasaltPillarFeature"): typeof Internal.BasaltPillarFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Skull4Item"): typeof Internal.Skull4Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SpringFeature"): typeof Internal.SpringFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.CommandBlockEntity"): typeof Internal.CommandBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration"): typeof Internal.SimpleBlockConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock"): typeof Internal.PulleyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.GrowingPlantBlock"): typeof Internal.GrowingPlantBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.api.filter.IFilter"): com.hrznstudio.titanium.api.filter.IFilter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tocraft.walkers.mixin.accessor.LivingEntityAccessor"): Internal.LivingEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.LavaSubmergedBlockProcessor"): typeof Internal.LavaSubmergedBlockProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Reference2IntFunction"): Internal.Reference2IntFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.temporal.TemporalAmount"): Internal.TemporalAmount;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.ForgeFaceData"): typeof Internal.ForgeFaceData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.ShapedBlockBuilder"): typeof Internal.ShapedBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.EntityAttributeCreationEvent"): typeof Internal.EntityAttributeCreationEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.SurfaceSystem"): typeof Internal.SurfaceSystem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.AuthenticationService"): Internal.AuthenticationService;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.SculkPatchFeature"): typeof Internal.SculkPatchFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blockpredicates.CombiningPredicate"): typeof Internal.CombiningPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.DateFormat"): typeof Internal.DateFormat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.pump.FluidFilterLogic"): typeof Internal.FluidFilterLogic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.entity.PartEntity"): typeof Internal.PartEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.village.poi.PoiRecord"): typeof Internal.PoiRecord;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.brightblock.BrightSlabBlock"): typeof Internal.BrightSlabBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.CustomFilterItemEventJS"): typeof Internal.CustomFilterItemEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.Scriptable"): Internal.Scriptable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.util.ContextUtils$PlayerEntityContext"): typeof Internal.ContextUtils$PlayerEntityContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.SculkShriekerBlockEntity"): typeof Internal.SculkShriekerBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.client.AccessorFontManager"): Internal.AccessorFontManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.agriculturehusbandry.tile.MobCrusherTile"): typeof Internal.MobCrusherTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundMovePlayerPacket"): typeof Internal.ServerboundMovePlayerPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.LerpingBossEvent"): typeof Internal.LerpingBossEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fonnymunkey.simplehats.util.HatEntry$HatParticleSettings$HatParticleMovement"): typeof Internal.HatEntry$HatParticleSettings$HatParticleMovement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Ravager"): typeof Internal.Ravager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.AdvancementEvent$AdvancementEarnEvent"): typeof Internal.AdvancementEvent$AdvancementEarnEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.integration.forge.jei.HideJEIEventJS"): typeof Internal.HideJEIEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.gray.GrayHangingSignBlock"): typeof Internal.GrayHangingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunctions$MarkerOrMarked"): Internal.DensityFunctions$MarkerOrMarked;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.MinecartItem"): typeof Internal.MinecartItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.CommonLevelAccessor"): Internal.CommonLevelAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.NameMap$Builder"): typeof Internal.NameMap$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer"): typeof Internal.BlockEntityWithoutLevelRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.horse.TraderLlama"): typeof Internal.TraderLlama;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock"): typeof Internal.NoticeBoardBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.DoorHingeSide"): typeof Internal.DoorHingeSide;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.tile.IndustrialProcessingTile"): typeof Internal.IndustrialProcessingTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.sound.sampled.AudioFormat"): typeof Internal.AudioFormat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.RandomAccess"): Internal.RandomAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.Long2ShortFunction"): Internal.Long2ShortFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.model.IFullscreen"): Internal.IFullscreen;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.item.AlwaysTrueFilterItem"): typeof Internal.AlwaysTrueFilterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.agriculturehusbandry.PlantGathererBlock"): typeof Internal.PlantGathererBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$TransparencyStateShard"): typeof Internal.RenderStateShard$TransparencyStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.recipe.SprayerRecipe$Serializer"): typeof Internal.SprayerRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.math.Transformation"): typeof Internal.Transformation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.llamalad7.mixinextras.sugar.ref.LocalRef"): Internal.LocalRef;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.gray.GrayStandingSignBlock"): typeof Internal.GrayStandingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.CollectionTag"): typeof Internal.CollectionTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeNoteParticleData"): typeof Internal.JukeboxUpgradeNoteParticleData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongConsumer"): it.unimi.dsi.fastutil.longs.LongConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.behavior.LookAtTargetSink"): typeof Internal.LookAtTargetSink;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEventListenerRegistry"): Internal.GameEventListenerRegistry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.tags.TagKey"): typeof Internal.TagKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.agriculturehusbandry.tile.MobDuplicatorTile"): typeof Internal.MobDuplicatorTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.maven.artifact.handler.ArtifactHandler"): Internal.ArtifactHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.level.ServerPlayer"): typeof Internal.ServerPlayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tocraft.walkers.mixin.accessor.EntityAccessor"): Internal.EntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.Gson"): typeof Internal.Gson;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.DyeColor"): typeof Internal.DyeColor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity"): typeof Internal.BlastFurnaceBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.client.book.BookEntry"): typeof Internal.BookEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.teammetallurgy.aquaculture.item.neptunium.NeptuniumHoe"): typeof Internal.NeptuniumHoe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$Opening"): typeof Internal.ScreenEvent$Opening;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoubleList"): Internal.DoubleList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.api.StringValueFilterVariant"): typeof Internal.StringValueFilterVariant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.stream.LongStream$Builder"): Internal.LongStream$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorBlueTier2Item$Chestplate"): typeof Internal.SailorBlueTier2Item$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.item.BasicItem"): typeof Internal.BasicItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorGrayTier3Item$Leggings"): typeof Internal.SailorGrayTier3Item$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.SmithingTransformRecipe"): typeof Internal.SmithingTransformRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.misc.InfinityChargerBlock"): typeof Internal.InfinityChargerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.CanvasRugBlock"): typeof Internal.CanvasRugBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CoralFanBlock"): typeof Internal.CoralFanBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunctions$Constant"): typeof Internal.DensityFunctions$Constant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.temporal.TemporalAccessor"): Internal.TemporalAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType"): typeof Internal.TrunkPlacerType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.ImageObserver"): Internal.ImageObserver;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.AdvancementList"): typeof Internal.AdvancementList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.talhanation.smallships.duck.CameraZoomAccess"): Internal.CameraZoomAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.dispenser.DispenseItemBehavior"): Internal.DispenseItemBehavior;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.GeodeBlockSettings"): typeof Internal.GeodeBlockSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "fonnymunkey.simplehats.util.HatEntry"): typeof Internal.HatEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.core.fluid.ArchitecturyFluidAttributes"): Internal.ArchitecturyFluidAttributes;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.Guard"): Internal.Guard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.agriculturehusbandry.tile.AnimalRancherTile"): typeof Internal.AnimalRancherTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade$BatteryRenderInfo"): typeof Internal.IRenderedBatteryUpgrade$BatteryRenderInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.RawAnimation$Stage"): typeof Internal.RawAnimation$Stage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.GeodeFeature"): typeof Internal.GeodeFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.map.ExpandedMapData"): Internal.ExpandedMapData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.SensorType"): typeof Internal.SensorType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.BiomeGenerationSettings$PlainBuilder"): typeof Internal.BiomeGenerationSettings$PlainBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.Enchantment$Rarity"): typeof Internal.Enchantment$Rarity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.item.custom.LightGraySprayCanItem"): typeof Internal.LightGraySprayCanItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance"): typeof Internal.OptionInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.InstrumentItem"): typeof net.mehvahdjukaar.supplementaries.common.items.InstrumentItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.loot.WeightedReward"): typeof Internal.WeightedReward;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorBlueTier1Item$Chestplate"): typeof Internal.SailorBlueTier1Item$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.RedLampBlock"): typeof Internal.RedLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.JavaMembers$MethodInfo"): typeof Internal.JavaMembers$MethodInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.RecipeBookMenu"): typeof Internal.RecipeBookMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.block.device.EntityBlockComposter"): typeof Internal.EntityBlockComposter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.lang.StringBuilder"): typeof Internal.StringBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DetectorRailBlock"): typeof Internal.DetectorRailBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.block.redstone.RedstoneAction"): typeof Internal.RedstoneAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundServerDataPacket"): typeof Internal.ClientboundServerDataPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.AdvancementEvent"): typeof Internal.AdvancementEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.util.recipes.device.PotionDiffuserBoost"): typeof Internal.PotionDiffuserBoost;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.Mirror"): typeof Internal.Mirror;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongIterable"): Internal.LongIterable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.CherryGrandfatherClockBlock"): typeof Internal.CherryGrandfatherClockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.HugeFungusFeature"): typeof Internal.HugeFungusFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.LocalDate"): typeof Internal.LocalDate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.DataResult$PartialResult"): typeof Internal.DataResult$PartialResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.items.DeadSeaScrollItem"): typeof Internal.DeadSeaScrollItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.ISerde"): Internal.ISerde;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.format.DecimalStyle"): typeof Internal.DecimalStyle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.util.Remapper"): Internal.Remapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.AwakeningAltarBlock"): typeof Internal.AwakeningAltarBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Random"): typeof Internal.Random;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.Registry"): Internal.Registry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.BlockStateComponent"): typeof Internal.BlockStateComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.MangroveSinkCounterBlock"): typeof Internal.MangroveSinkCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.settings.MainSetting"): typeof Internal.MainSetting;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.util.ContextUtils$DeathContext"): typeof Internal.ContextUtils$DeathContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BirchTableBlock"): typeof Internal.BirchTableBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.transportstorage.BlackHoleControllerBlock"): typeof Internal.BlackHoleControllerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.LevelSummary"): typeof Internal.LevelSummary;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.GoalSelectorDebugRenderer"): typeof Internal.GoalSelectorDebugRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.InteractionResult"): typeof InteractionResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundGameEventPacket$Type"): typeof Internal.ClientboundGameEventPacket$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker"): Internal.ISlotTracker;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.CodeSource"): typeof Internal.CodeSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemTooltipEventJS"): typeof Internal.ItemTooltipEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.village.ReputationEventType"): Internal.ReputationEventType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Merchant2Item$Chestplate"): typeof Internal.Merchant2Item$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.IForgeRegistry$ClearCallback"): Internal.IForgeRegistry$ClearCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.EventListener"): Internal.EventListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.npc.VillagerType"): typeof Internal.VillagerType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.IAutoCookingUpgradeItem"): Internal.IAutoCookingUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.brightblock.BrightFlammableLogBlock"): typeof Internal.BrightFlammableLogBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.world.StructureModifier"): Internal.StructureModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.ingredients.IIngredientHelper"): Internal.IIngredientHelper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.fluids.ForgeFlowingFluid"): typeof Internal.ForgeFlowingFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderStateShard$OverlayStateShard"): typeof Internal.RenderStateShard$OverlayStateShard;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.util.recipes.device.TreeExtractorMapping"): typeof Internal.TreeExtractorMapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeEnchantment"): Internal.IForgeEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.floats.Float2DoubleFunction"): Internal.Float2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundSelectTradePacket"): typeof Internal.ServerboundSelectTradePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement"): typeof Internal.EmptyPoolElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.texture.TextureAtlasSprite"): typeof Internal.TextureAtlasSprite;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.fluid.CrudeOilFluid$1"): typeof Internal.CrudeOilFluid$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.ISlotLimitUpgrade"): Internal.ISlotLimitUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "chiefarug.mods.systeams.block.BoilerBlock"): typeof Internal.BoilerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.common.block.FeastBlock"): typeof cofh.lib.common.block.FeastBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tfar.dankstorage.mixin.ItemUsageContextAccessor"): Internal.ItemUsageContextAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.event.EventResult$Type"): typeof Internal.EventResult$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.flat.FlatLayerInfo"): typeof Internal.FlatLayerInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorNordicTier3Item$Helmet"): typeof Internal.SailorNordicTier3Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.SpruceWallClockBlock"): typeof Internal.SpruceWallClockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.api.item.IXpContainerItem"): Internal.IXpContainerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.GreenLampBlock"): typeof Internal.GreenLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.collect.ImmutableSet$Builder"): typeof Internal.ImmutableSet$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.api.item.IFluidContainerItem"): Internal.IFluidContainerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.white.WhiteWallHangingSignBlock"): typeof Internal.WhiteWallHangingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.AbstractCollection"): typeof Internal.AbstractCollection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockToolSwapUpgrade"): Internal.IBlockToolSwapUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.keyframe.event.data.ParticleKeyframeData"): typeof Internal.ParticleKeyframeData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.obscureapi.common.effects.Knowledge"): typeof Internal.Knowledge;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.block.BaseBlock"): typeof Internal.BaseBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.Property$Value"): typeof Internal.Property$Value;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.schema.minecraft.ShapelessRecipeSchema$ShapelessRecipeJS"): typeof Internal.ShapelessRecipeSchema$ShapelessRecipeJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.accessibility.AccessibleComponent"): Internal.AccessibleComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.multiplayer.chat.report.ReportEnvironment"): typeof Internal.ReportEnvironment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.entity.LivingEntityEventJS"): typeof Internal.LivingEntityEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.leobeliik.extremesoundmuffler.interfaces.ISoundLists"): Internal.ISoundLists;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.material.WaterFluid"): typeof Internal.WaterFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.format.ResolverStyle"): typeof Internal.ResolverStyle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.MissingMappingsEvent$Mapping"): typeof Internal.MissingMappingsEvent$Mapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.AirBlock"): typeof Internal.AirBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.Rotations"): typeof Internal.Rotations;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.functions.LootItemFunction"): Internal.LootItemFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.capabilities.CapabilityProvider"): typeof Internal.CapabilityProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.item.ModFilterItem"): typeof Internal.ModFilterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.RenderType$CompositeState$CompositeStateBuilder"): typeof Internal.RenderType$CompositeState$CompositeStateBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Husk"): typeof Internal.Husk;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingUpgradeItem$Wrapper"): typeof Internal.EverlastingUpgradeItem$Wrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.block.RotationHandler"): Internal.RotationHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.fluid.FluidBlockBuilder"): typeof Internal.FluidBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.fluid.TreeOilFluid$1"): typeof Internal.TreeOilFluid$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.SimplePlayerEventJS"): typeof Internal.SimplePlayerEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.keksuccino.fancymenu.util.resource.Resource"): de.keksuccino.fancymenu.util.resource.Resource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix3x2d"): typeof Internal.Matrix3x2d;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.HayBlock"): typeof Internal.HayBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.BlockController"): typeof Internal.BlockController;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.GobletBlock"): typeof Internal.GobletBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.BrainDebugRenderer$BrainDump"): typeof Internal.BrainDebugRenderer$BrainDump;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.lime.LimeHangingSignBlock"): typeof Internal.LimeHangingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.network.NetworkEvent$PacketDispatcher"): typeof Internal.NetworkEvent$PacketDispatcher;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.network.locator.PlayerInventoryFinder$Target"): typeof Internal.PlayerInventoryFinder$Target;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.item.XORFilterItem"): typeof Internal.XORFilterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.gui.overlay.IGuiOverlay"): Internal.IGuiOverlay;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.ConcurrentHashMap$KeySetView"): typeof Internal.ConcurrentHashMap$KeySetView;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.entity.EntityRenderDispatcher"): typeof Internal.EntityRenderDispatcher;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.document.DocumentField"): typeof Internal.DocumentField;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.MangrovePropaguleBlock"): typeof Internal.MangrovePropaguleBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Locale"): typeof Internal.Locale;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.piglin.AbstractPiglin"): typeof Internal.AbstractPiglin;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.ReflectionBasedSerialization"): Internal.ReflectionBasedSerialization;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.SignPostItem"): typeof Internal.SignPostItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.DarkOakWallClockBlock"): typeof Internal.DarkOakWallClockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.scores.Team$CollisionRule"): typeof Internal.Team$CollisionRule;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.event.forge.PopupMenuEvent$FullscreenPopupMenuEvent"): typeof Internal.PopupMenuEvent$FullscreenPopupMenuEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.BlockBreakerBlock"): typeof com.buuz135.industrial.block.resourceproduction.BlockBreakerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.util.TriPredicate"): Internal.TriPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.MushroomColonyBlock"): typeof Internal.MushroomColonyBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.opolisutilities.recipe.CatalogueRecipe"): typeof Internal.CatalogueRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.PirateTier3Item$Chestplate"): typeof Internal.PirateTier3Item$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.ThrownEgg"): typeof Internal.ThrownEgg;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.Enchantment"): typeof Internal.Enchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.white.WhiteStandingSignBlock"): typeof Internal.WhiteStandingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList$Preset"): typeof Internal.MultiNoiseBiomeSourceParameterList$Preset;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.sounds.SoundEngine"): typeof Internal.SoundEngine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget"): Internal.IMixinAbstractWidget;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.tree.CommandNode"): typeof Internal.CommandNode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.ChapterGroup"): typeof Internal.ChapterGroup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.blay09.mods.balm.api.event.client.screen.ScreenDrawEvent"): typeof Internal.ScreenDrawEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.screens.recipebook.RecipeCollection"): typeof Internal.RecipeCollection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Merchant2Item$Leggings"): typeof Internal.Merchant2Item$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.ArrowNockEvent"): typeof Internal.ArrowNockEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.forgespi.language.IConfigurable"): Internal.IConfigurable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.item.BaseItem"): typeof Internal.BaseItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundUpdateEnabledFeaturesPacket"): typeof Internal.ClientboundUpdateEnabledFeaturesPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.property.PropertyValue"): typeof Internal.PropertyValue;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.Structure"): typeof Internal.Structure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.entities.IAnimatableJS"): Internal.IAnimatableJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BeetrootBlock"): typeof Internal.BeetrootBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "earth.terrarium.chipped.common.blocks.DirectionBlock"): typeof Internal.DirectionBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.api.FilterInfo"): Internal.FilterInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.builders.ArrowEntityJSBuilder"): typeof Internal.ArrowEntityJSBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.block.EntityBlockActive4Way"): typeof Internal.EntityBlockActive4Way;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.memory.MemoryStatus"): typeof Internal.MemoryStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.treedecorators.AlterGroundDecorator"): typeof Internal.AlterGroundDecorator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.opolisutilities.block.custom.FanBlock"): typeof Internal.FanBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket"): typeof Internal.ServerboundChangeDifficultyPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.EnderDragonPart"): typeof Internal.EnderDragonPart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorRedTier2Item$Chestplate"): typeof Internal.SailorRedTier2Item$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.metrics.MetricSampler$ThresholdTest"): Internal.MetricSampler$ThresholdTest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Guardian"): typeof Internal.Guardian;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.JunglePlankBlock"): typeof Internal.JunglePlankBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.PalettedContainer"): typeof Internal.PalettedContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.decoration.PaintingVariant"): typeof Internal.PaintingVariant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jtorleonstudios.awesomedungeonocean.AwsOceanStructure$AwesomeDungeonStructure"): typeof Internal.AwsOceanStructure$AwesomeDungeonStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundContainerClosePacket"): typeof Internal.ServerboundContainerClosePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.RegisterGameTestsEvent"): typeof Internal.RegisterGameTestsEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix2dc"): Internal.Matrix2dc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.DeckhandItem$Boots"): typeof Internal.DeckhandItem$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.swing.text.AttributeSet$ColorAttribute"): Internal.AttributeSet$ColorAttribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.system.NativeResource"): Internal.NativeResource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.BedBlockEntity"): typeof Internal.BedBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.IntegerProperty"): typeof Internal.IntegerProperty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$List12"): typeof Internal.ImmutableCollections$List12;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.StringComponent$1"): typeof Internal.StringComponent$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DirtPathBlock"): typeof Internal.DirtPathBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.RecordBuilder"): Internal.RecordBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.CrystalDisplayBlock"): typeof Internal.CrystalDisplayBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.eventbus.api.Event$Result"): typeof Internal.Event$Result;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.api.block.IWrenchable"): Internal.IWrenchable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.tile.LaserDrillTile"): typeof Internal.LaserDrillTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.context.CommandContext"): typeof Internal.CommandContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundChatAckPacket"): typeof Internal.ServerboundChatAckPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder"): typeof Internal.StructurePiecesBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SaplingBlock"): typeof Internal.SaplingBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$Prudentium"): typeof Internal.EssenceFurnaceBlock$Prudentium;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.ItemOverrides$BakedOverride"): typeof Internal.ItemOverrides$BakedOverride;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.ParsePosition"): typeof Internal.ParsePosition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.SignedMessageValidator"): Internal.SignedMessageValidator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.QuestShape"): typeof Internal.QuestShape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.ServerAdvancementManager"): typeof Internal.ServerAdvancementManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.agriculturehusbandry.AnimalFeederBlock"): typeof Internal.AnimalFeederBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType"): Internal.RuleTestType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.yungnickyoung.minecraft.betteroceanmonuments.mixin.accessor.StructureProcessorAccessor"): Internal.StructureProcessorAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.MapLike"): Internal.MapLike;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.SoundEventBuilder"): typeof Internal.SoundEventBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.player.ProfilePublicKey$Data"): typeof Internal.ProfilePublicKey$Data;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.item.EnergyContainerItem"): typeof Internal.EnergyContainerItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ambient.AmbientCreature"): typeof Internal.AmbientCreature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blending.Blender$BlendingOutput"): typeof Internal.Blender$BlendingOutput;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.MachineUpgradeItem"): typeof Internal.MachineUpgradeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.LongBidirectionalIterator"): Internal.LongBidirectionalIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$TooltipSupplier"): Internal.OptionInstance$TooltipSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.food.FoodData"): typeof Internal.FoodData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.item.ItemEvent"): typeof Internal.ItemEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.CeilingHangingCanvasSignBlock"): typeof Internal.CeilingHangingCanvasSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.ItemComponents$3"): typeof Internal.ItemComponents$3;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$Init$Pre"): typeof Internal.ScreenEvent$Init$Pre;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.RecipeType"): Internal.RecipeType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.misc.MobDetectorBlock"): typeof Internal.MobDetectorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.tile.IndustrialMachineTile"): typeof Internal.IndustrialMachineTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.dimension.LevelStem"): typeof Internal.LevelStem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.PacketSendListener"): Internal.PacketSendListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorNordicTier3Item"): typeof Internal.SailorNordicTier3Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.effect.ShockedMobEffect"): typeof Internal.ShockedMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.CorsairTier2Item$Leggings"): typeof Internal.CorsairTier2Item$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.ticks.LevelTickAccess"): Internal.LevelTickAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.ExclusionStrategy"): Internal.ExclusionStrategy;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.energy.IEnergyStorage"): Internal.IEnergyStorage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blockpredicates.SolidPredicate"): typeof Internal.SolidPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.CraftsmanItem$Leggings"): typeof Internal.CraftsmanItem$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.api.inventory.IItemStackHolder"): Internal.IItemStackHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.DirectionProperty"): typeof Internal.DirectionProperty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo$DisplayItem"): typeof Internal.RenderInfo$DisplayItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.EntityTeleportEvent$ChorusFruit"): typeof Internal.EntityTeleportEvent$ChorusFruit;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.DarkOakBenchBlock"): typeof Internal.DarkOakBenchBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix4x3f"): typeof Internal.Matrix4x3f;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.keksuccino.fancymenu.util.rendering.ui.screen.CustomizableScreen"): Internal.CustomizableScreen;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.dimension.end.EndDragonFight$Data"): typeof Internal.EndDragonFight$Data;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.mixins.forge.SelfEntitySpawnDataMixin"): Internal.SelfEntitySpawnDataMixin;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.roomopolis.item.custom.RoomKeys.RoomTopperKey"): typeof Internal.RoomTopperKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.Format"): typeof Internal.Format;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tax.taknax.taxov.item.PirateSuitItem"): typeof Internal.PirateSuitItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile"): typeof Internal.IndustrialAreaWorkingTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket"): typeof Internal.ClientboundSetSubtitleTextPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.math.RoundingMode"): typeof Internal.RoundingMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.tool.EssenceHoeItem"): typeof Internal.EssenceHoeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.DoubleSpliterator"): Internal.DoubleSpliterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.util.CustomJavaToJsWrapper"): Internal.CustomJavaToJsWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinSplashRenderer"): Internal.IMixinSplashRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.RedprintItem"): typeof cofh.thermal.core.common.item.RedprintItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.util.FacingUtil$Sideness"): typeof Internal.FacingUtil$Sideness;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.TeamPropertyCollection"): Internal.TeamPropertyCollection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.DigDurabilityEnchantment"): typeof Internal.DigDurabilityEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.keyframe.event.data.CustomInstructionKeyframeData"): typeof Internal.CustomInstructionKeyframeData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.ZoneId"): typeof Internal.ZoneId;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagradditions.item.EssenceCoalBlockItem"): typeof Internal.EssenceCoalBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorRedTier1Item$Leggings"): typeof Internal.SailorRedTier1Item$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.world.BiomeGenerationSettingsBuilder"): typeof Internal.BiomeGenerationSettingsBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "lykrast.glassential.doors.GlassDoorBlock"): typeof Internal.GlassDoorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.DateFormatSymbols"): typeof Internal.DateFormatSymbols;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.synchronization.brigadier.LongArgumentInfo"): typeof Internal.LongArgumentInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.MessageSenderKJS"): Internal.MessageSenderKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Cat"): typeof Internal.Cat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.FireworkRocketEntityKJS"): Internal.FireworkRocketEntityKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorGrayTier2Item$Helmet"): typeof Internal.SailorGrayTier2Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Image"): typeof Internal.Image;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.fluids.ForgeFlowingFluid$Source"): typeof Internal.ForgeFlowingFluid$Source;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.melanx.skyblockbuilder.item.ItemStructureSaver"): typeof Internal.ItemStructureSaver;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.BambooStalkBlock"): typeof Internal.BambooStalkBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.ConfigSpec$CorrectionListener"): Internal.ConfigSpec$CorrectionListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.keksuccino.fancymenu.util.resource.resources.audio.PlayableResourceWithAudio"): Internal.PlayableResourceWithAudio;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$KeyPressed"): typeof Internal.ScreenEvent$KeyPressed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.fluids.capability.IFluidHandler"): Internal.IFluidHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.block.HardenedGlassBlock"): typeof Internal.HardenedGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.PotionBrewerBlock"): typeof Internal.PotionBrewerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.GunpowderBlock"): typeof net.mehvahdjukaar.supplementaries.common.block.blocks.GunpowderBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.component.sideness.IFacingComponent$FaceMode"): typeof Internal.IFacingComponent$FaceMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$FloatInterpolator"): Internal.Display$FloatInterpolator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeWrapper$AutoSmokingUpgradeWrapper"): typeof Internal.AutoCookingUpgradeWrapper$AutoSmokingUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.Block"): typeof Internal.Block;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.temporal.ChronoField"): typeof Internal.ChronoField;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.item.BlockTypeBasedBlockItem"): typeof Internal.BlockTypeBasedBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.registry.level.biome.BiomeModifications$BiomeContext"): Internal.BiomeModifications$BiomeContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.meta.BlockMeta"): typeof Internal.BlockMeta;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.TimeArgument"): typeof Internal.TimeArgument;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.TimeZone"): typeof Internal.TimeZone;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.exceptions.BuiltInExceptionProvider"): Internal.BuiltInExceptionProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.PalettedContainerRO"): Internal.PalettedContainerRO;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.util.MutableHashedLinkedMap"): typeof Internal.MutableHashedLinkedMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerEvent$NameFormat"): typeof Internal.PlayerEvent$NameFormat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.BasketBlock"): typeof Internal.BasketBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.ChestType"): typeof Internal.ChestType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.exceptions.DynamicCommandExceptionType"): typeof Internal.DynamicCommandExceptionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.item.custom.LightBlueSprayCanItem"): typeof Internal.LightBlueSprayCanItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.GuiGraphics"): typeof Internal.GuiGraphics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.icon.ImageIcon"): typeof Internal.ImageIcon;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimationProcessor"): typeof Internal.AnimationProcessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.MinecraftProfileTexture$Type"): typeof Internal.MinecraftProfileTexture$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.ConcurrentHashMap$CollectionView"): typeof Internal.ConcurrentHashMap$CollectionView;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.PalettedContainer$CountConsumer"): Internal.PalettedContainer$CountConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.LongToDoubleFunction"): Internal.LongToDoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.magenta.MagentaWallSignBlock"): typeof Internal.MagentaWallSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo$ItemDisplayRenderInfo"): typeof Internal.RenderInfo$ItemDisplayRenderInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.core.DisplayInfoFTBL"): Internal.DisplayInfoFTBL;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.chunk.RenderChunkRegion"): typeof Internal.RenderChunkRegion;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.tile.FluidCollectorTile"): typeof Internal.FluidCollectorTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.command.CommandRegistryEventJS"): typeof Internal.CommandRegistryEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.cache.LocalCache$LocalManualCache"): typeof Internal.LocalCache$LocalManualCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.supermartijn642.fusion.api.util.Serializer"): com.supermartijn642.fusion.api.util.Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.file.CommentedFileConfig"): Internal.CommentedFileConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.PaintContext"): Internal.PaintContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.phases.DragonSittingScanningPhase"): typeof Internal.DragonSittingScanningPhase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderTooltipEvent$Color"): typeof Internal.RenderTooltipEvent$Color;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.targeting.TargetingConditions"): typeof Internal.TargetingConditions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P14"): typeof Internal.Products$P14;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.Tier"): Internal.Tier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.platform.IconSet"): typeof Internal.IconSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.BiomeSpecialEffects$Builder"): typeof Internal.BiomeSpecialEffects$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.LoomBlock"): typeof Internal.LoomBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.model.geom.builders.PartDefinition"): typeof Internal.PartDefinition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundUseItemOnPacket"): typeof Internal.ServerboundUseItemOnPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Dolphin"): typeof Internal.Dolphin;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.Decoder$Terminal"): Internal.Decoder$Terminal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.light_blue.LightBlueHangingSignBlock"): typeof Internal.LightBlueHangingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.server.permission.nodes.PermissionNode$PermissionResolver"): Internal.PermissionNode$PermissionResolver;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.obscureapi.common.effects.Rush"): typeof Internal.Rush;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PiglinWallSkullBlock"): typeof Internal.PiglinWallSkullBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.worldgen.feature.OxygeliumFeature"): typeof Internal.OxygeliumFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.orange.OrangeStandingSignBlock"): typeof Internal.OrangeStandingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.datatransfer.Transferable"): Internal.Transferable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "lykrast.glassential.blocks.DarkEtherealGlassBlock"): typeof Internal.DarkEtherealGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.PancakeBlock"): typeof Internal.PancakeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.HoeItemBuilder"): typeof Internal.HoeItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.EnchantmentBuilder$DamageBonusFunction"): Internal.EnchantmentBuilder$DamageBonusFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.random.WeightedEntry"): Internal.WeightedEntry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket"): typeof Internal.ClientboundSectionBlocksUpdatePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.LogType"): typeof Internal.LogType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.MachineFrameBlock$MachineFrameItem"): typeof Internal.MachineFrameBlock$MachineFrameItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.handlers.IGhostIngredientHandler$Target"): Internal.IGhostIngredientHandler$Target;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool"): typeof Internal.StructureTemplatePool;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.SignatureUpdater"): Internal.SignatureUpdater;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SignApplicator"): Internal.SignApplicator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.QuiverItem"): typeof Internal.QuiverItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PitcherCropBlock"): typeof Internal.PitcherCropBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.BufferCapabilities$FlipContents"): typeof Internal.BufferCapabilities$FlipContents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.level.FullChunkStatus"): typeof Internal.FullChunkStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.AxisAlignedLinearPosTest"): typeof Internal.AxisAlignedLinearPosTest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.util.ContextUtils$LerpToContext"): typeof Internal.ContextUtils$LerpToContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.OwnableEntity"): Internal.OwnableEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.item.WeakNBTFilterItem"): typeof Internal.WeakNBTFilterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.cache.CacheStats"): typeof Internal.CacheStats;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animatable.model.CoreGeoBone"): Internal.CoreGeoBone;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.helpers.IPlatformFluidHelper"): Internal.IPlatformFluidHelper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerEvent$PlayerChangedDimensionEvent"): typeof Internal.PlayerEvent$PlayerChangedDimensionEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Creeper"): typeof Internal.Creeper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electrolyte.matc.items.PrudentiumCrystal"): typeof Internal.PrudentiumCrystal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.ClientInitEventJS"): typeof Internal.ClientInitEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.PrivacyMode"): typeof Internal.PrivacyMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.StateHolder"): typeof Internal.StateHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.misc.ParticleTypeBuilder"): typeof Internal.ParticleTypeBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.CraftsmanItem$Chestplate"): typeof Internal.CraftsmanItem$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.talhanation.smallships.world.item.CannonItem"): typeof Internal.CannonItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.IdMappingEvent$IdRemapping"): typeof Internal.IdMappingEvent$IdRemapping;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket"): typeof Internal.ClientboundSetCarriedItemPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.CherryChairBlock"): typeof Internal.CherryChairBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.gui.components.toasts.Toast"): Internal.Toast;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.icon.Icon"): typeof Internal.Icon;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket"): typeof Internal.ClientboundPlayerCombatEnterPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.heightproviders.WeightedListHeight"): typeof Internal.WeightedListHeight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.SortedSet"): Internal.SortedSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.OffsetTime"): typeof Internal.OffsetTime;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tfar.craftingstation.CraftingStationSlabBlock"): typeof Internal.CraftingStationSlabBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.MenuShortcut"): typeof Internal.MenuShortcut;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.stateproviders.NoiseThresholdProvider"): typeof Internal.NoiseThresholdProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.cache.LoadingCache"): Internal.LoadingCache;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.block.SignalAirBlock"): typeof Internal.SignalAirBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.attributes.AttributeSupplier"): typeof Internal.AttributeSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.gui.ingredient.IRecipeSlotDrawable"): Internal.IRecipeSlotDrawable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.enchantment.KnockbackEnchantment"): typeof Internal.KnockbackEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.decoration.HangingEntity"): typeof Internal.HangingEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure"): typeof Internal.OceanRuinStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.Blaze"): typeof Internal.Blaze;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.item.AlwaysFalseFilterItem"): typeof Internal.AlwaysFalseFilterItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.chrono.ChronoLocalDate"): Internal.ChronoLocalDate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.entity.CheckLivingEntitySpawnEventJS"): typeof Internal.CheckLivingEntitySpawnEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager"): typeof Internal.StructureTemplateManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerInteractEvent$RightClickItem"): typeof Internal.PlayerInteractEvent$RightClickItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.Half"): typeof Internal.Half;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.item.custom.GraySprayCanItem"): typeof Internal.GraySprayCanItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.obscureapi.api.common.classes.Ability"): typeof Internal.Ability;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.Items$1"): typeof Internal.Items$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.MushroomCow$MushroomType"): typeof Internal.MushroomCow$MushroomType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SlimeBlock"): typeof Internal.SlimeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorNordicTier2Item$Chestplate"): typeof Internal.SailorNordicTier2Item$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.DiskFeature"): typeof Internal.DiskFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.IndustrialBlockItem"): typeof Internal.IndustrialBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.Property"): typeof Internal.Property;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.brightblock.Brightable"): Internal.Brightable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.font.GlyphProvider"): Internal.GlyphProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.RedirectModifier"): Internal.RedirectModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.ChatFormatting"): typeof Internal.ChatFormatting;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$TextDisplay$TextRenderState"): typeof Internal.Display$TextDisplay$TextRenderState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ScaffoldingBlockItem"): typeof Internal.ScaffoldingBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.TagKeyComponent"): typeof Internal.TagKeyComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.obscureapi.api.common.classes.Bonus$Type"): typeof Internal.Bonus$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderTooltipEvent$Pre"): typeof Internal.RenderTooltipEvent$Pre;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.api.lib.LazyIngredient"): typeof Internal.LazyIngredient;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.LazyComponentKJS"): Internal.LazyComponentKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.sounds.Sound"): typeof Internal.Sound;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.generator.MycelialGeneratorBlock"): typeof Internal.MycelialGeneratorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.builders.BaseLivingEntityJSBuilder"): typeof Internal.BaseLivingEntityJSBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.cyan.CyanHangingSignBlock"): typeof Internal.CyanHangingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration"): typeof Internal.SpikeConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.client.ICustomItemRendererProvider"): Internal.ICustomItemRendererProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.builders.BaseEntityBuilder"): typeof Internal.BaseEntityBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.advancements.Advancement$Builder"): typeof Internal.Advancement$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.SharedSuggestionProvider$ElementSuggestionType"): typeof Internal.SharedSuggestionProvider$ElementSuggestionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.EndPortalFrameBlock"): typeof Internal.EndPortalFrameBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.FlorbItem"): typeof Internal.FlorbItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.ChatType$Bound"): typeof Internal.ChatType$Bound;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.opolisutilities.block.custom.CatalogueBlock"): typeof Internal.CatalogueBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.texture.AbstractTexture"): typeof Internal.AbstractTexture;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Component"): typeof Internal.Component;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.IForgeRegistry$AddCallback"): Internal.IForgeRegistry$AddCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jtorleonstudios.awesomedungeonocean.AwsOceanBoatStructures$FrigateL"): typeof Internal.AwsOceanBoatStructures$FrigateL;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.loot.LootBuilder"): typeof Internal.LootBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.MapCodec$ResultFunction"): Internal.MapCodec$ResultFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.yggdrasil.request.AbuseReportRequest"): typeof Internal.AbuseReportRequest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BambooGrandfatherClockBlock"): typeof Internal.BambooGrandfatherClockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.events.forge.VillagerBrainEvent"): typeof Internal.VillagerBrainEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.PlaceOnWaterBlockItem"): typeof Internal.PlaceOnWaterBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.moddingx.libx.creativetab.CreativeTabItemProvider"): Internal.CreativeTabItemProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DragSourceEvent"): typeof Internal.DragSourceEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.network.NetworkEvent$GatherLoginPayloadsEvent"): typeof Internal.NetworkEvent$GatherLoginPayloadsEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.state.BoneSnapshot"): typeof Internal.BoneSnapshot;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer"): typeof Internal.EnumCompDrawer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.violetmoon.zeta.mixin.mixins.AccessorLootTable"): Internal.AccessorLootTable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket"): typeof Internal.ClientboundRemoveEntitiesPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.placement.RepeatingPlacement"): typeof Internal.RepeatingPlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.keksuccino.melody.mixin.mixins.common.client.IMixinSoundEngine"): Internal.IMixinSoundEngine;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.SleepingLocationCheckEvent"): typeof Internal.SleepingLocationCheckEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.FeaturePlaceContext"): typeof Internal.FeaturePlaceContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.Short2FloatFunction"): Internal.Short2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.events.ObjectCompletedEvent$TaskEvent"): typeof Internal.ObjectCompletedEvent$TaskEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DragGestureEvent"): typeof Internal.DragGestureEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Attackable"): Internal.Attackable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize"): typeof Internal.FeatureSize;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.network.HandshakeMessages$S2CRegistry"): typeof Internal.HandshakeMessages$S2CRegistry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.LoomMenu"): typeof Internal.LoomMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.itemfilters.core.ItemFiltersStack"): Internal.ItemFiltersStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.ShortListIterator"): Internal.ShortListIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.strainers.item.custom.Mesh"): typeof Internal.Mesh;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.PackOutput$PathProvider"): typeof Internal.PackOutput$PathProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tax.taknax.taxov.item.PirateSuitItem$Boots"): typeof Internal.PirateSuitItem$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.util.crafting.ShapedPotionNBTRecipe"): typeof Internal.ShapedPotionNBTRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.forgespi.language.IModFileInfo"): Internal.IModFileInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.crafting.recipe.EnchanterRecipe$Serializer"): typeof Internal.EnchanterRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.Object2ByteMap"): Internal.Object2ByteMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers"): typeof Internal.BlockCompDrawers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P16"): typeof Internal.Products$P16;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.world.ModifiableStructureInfo$StructureInfo$Builder"): typeof Internal.ModifiableStructureInfo$StructureInfo$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderTooltipEvent"): typeof Internal.RenderTooltipEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.TurnTableBlock"): typeof Internal.TurnTableBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeItem$Wrapper"): typeof Internal.JukeboxUpgradeItem$Wrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.RecipeType$1"): typeof Internal.RecipeType$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BirchStorageCounterBlock"): typeof Internal.BirchStorageCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.event.forge.FullscreenDisplayEvent$AddonButtonDisplayEvent"): typeof Internal.FullscreenDisplayEvent$AddonButtonDisplayEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P13"): typeof Internal.Products$P13;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorBlueTier3Item"): typeof Internal.SailorBlueTier3Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.display.Context$UI"): typeof Internal.Context$UI;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ArmorItem$Type"): typeof Internal.ArmorItem$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.IForgeRegistry$BakeCallback"): Internal.IForgeRegistry$BakeCallback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2ObjectMap"): Internal.Int2ObjectMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SuspiciousEffectHolder"): Internal.SuspiciousEffectHolder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.FilterMask"): typeof Internal.FilterMask;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType"): typeof Internal.RandomSpreadType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WitherRoseBlock"): typeof Internal.WitherRoseBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.IntSpliterator"): Internal.IntSpliterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeWrapper"): typeof Internal.XpPumpUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.eventbus.api.IEventBusInvokeDispatcher"): Internal.IEventBusInvokeDispatcher;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Date"): typeof Internal.Date;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer"): typeof Internal.RootPlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ShulkerBoxBlock"): typeof Internal.ShulkerBoxBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.allthemods.alltheores.items.OreHammer"): typeof Internal.OreHammer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.heightproviders.TrapezoidHeight"): typeof Internal.TrapezoidHeight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ArgumentSignatures$Signer"): Internal.ArgumentSignatures$Signer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.CraftingMenu"): typeof Internal.CraftingMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.misc.tile.InfinityChargerTile"): typeof Internal.InfinityChargerTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundMerchantOffersPacket"): typeof Internal.ClientboundMerchantOffersPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Skull1Item"): typeof Internal.Skull1Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.forgespi.locating.ForgeFeature$Bound"): typeof Internal.ForgeFeature$Bound;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.util.ContextUtils$EntityItemLevelContext"): typeof Internal.ContextUtils$EntityItemLevelContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.portal.PortalForcer"): typeof Internal.PortalForcer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.NyliumBlock"): typeof Internal.NyliumBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.SignableCommand"): typeof Internal.SignableCommand;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.LevelSimulatedReader"): Internal.LevelSimulatedReader;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.PackResources"): Internal.PackResources;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.util.ContextUtils$EntityDamageContext"): typeof Internal.ContextUtils$EntityDamageContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Skull2Item"): typeof Internal.Skull2Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.item.infinity.IInfinityDrillScreenAddons"): Internal.IInfinityDrillScreenAddons;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.crafting.BackpackUpgradeRecipe"): typeof Internal.BackpackUpgradeRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.IntPredicate"): it.unimi.dsi.fastutil.ints.IntPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Dimension"): typeof Internal.Dimension;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.Holder"): Internal.Holder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.carver.CarverConfiguration"): typeof Internal.CarverConfiguration;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.VertexSorting$DistanceFunction"): Internal.VertexSorting$DistanceFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.lib.common.block.StorageCellBlock"): typeof Internal.StorageCellBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeConfig"): typeof Internal.AutoCookingUpgradeConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.teammetallurgy.aquaculture.loot.AquaBiomeModifiers$FishSpawnBiomeModifier"): typeof Internal.AquaBiomeModifiers$FishSpawnBiomeModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.particle.ParticleEngine$MutableSpriteSet"): typeof Internal.ParticleEngine$MutableSpriteSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.level.gen.properties.AddLakeProperties"): typeof Internal.AddLakeProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType"): Internal.StructureProcessorType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.Holder$Kind"): typeof Internal.Holder$Kind;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.MagentaLampBlock"): typeof Internal.MagentaLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.opolisutilities.item.custom.MiniCoalItem"): typeof Internal.MiniCoalItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.SecureRandomParameters"): Internal.SecureRandomParameters;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.PirateTier2Item$Helmet"): typeof Internal.PirateTier2Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.unit.token.CharStream"): typeof Internal.CharStream;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.FireBlock"): typeof Internal.FireBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.pathfinder.Path"): typeof net.minecraft.world.level.pathfinder.Path;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.light_blue.LightBlueStandingSignBlock"): typeof Internal.LightBlueStandingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$AbstractImmutableCollection"): typeof Internal.ImmutableCollections$AbstractImmutableCollection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.upgrades.deposit.DepositFilterLogic"): typeof Internal.DepositFilterLogic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.IdFunctionObject"): typeof Internal.IdFunctionObject;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Merchant1Item$Leggings"): typeof Internal.Merchant1Item$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.TickingBlockEntity"): Internal.TickingBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.FormattedText$StyledContentConsumer"): Internal.FormattedText$StyledContentConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.warden.AngerLevel"): typeof Internal.AngerLevel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.CommandSourceStack"): typeof Internal.CommandSourceStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement"): typeof Internal.RandomSpreadStructurePlacement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.Brain$Provider"): typeof Internal.Brain$Provider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.lwjgl.stb.STBTTFontinfo$Buffer"): typeof Internal.STBTTFontinfo$Buffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.MutableComponent"): typeof Internal.MutableComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.api.filter.IFilter$Type"): typeof Internal.IFilter$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.ChunkDataEvent$Load"): typeof Internal.ChunkDataEvent$Load;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.DoubleBlockCombiner$NeighborCombineResult"): Internal.DoubleBlockCombiner$NeighborCombineResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.item.EnergyCellBlockItem"): typeof Internal.EnergyCellBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.PlayerChatDecorateEventJS"): typeof Internal.PlayerChatDecorateEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.shorts.Short2DoubleFunction"): Internal.Short2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.texture.Dumpable"): Internal.Dumpable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.forgespi.locating.IModProvider"): Internal.IModProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.BaseSpawner"): typeof Internal.BaseSpawner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.item.RecipelessCustomItem"): typeof Internal.RecipelessCustomItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.tile.ILaserBase"): Internal.ILaserBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.AbstractObject2FloatFunction"): typeof Internal.AbstractObject2FloatFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.GameMasterBlockItem"): typeof Internal.GameMasterBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.ComparatorBlockEntity"): typeof Internal.ComparatorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool$Projection"): typeof Internal.StructureTemplatePool$Projection;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderTooltipEvent$GatherComponents"): typeof Internal.RenderTooltipEvent$GatherComponents;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.RegistryAccess$ImmutableRegistryAccess"): typeof Internal.RegistryAccess$ImmutableRegistryAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockEntityAccessor"): Internal.DispenserBlockEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ContainerScreenEvent$Render$Background"): typeof Internal.ContainerScreenEvent$Render$Background;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.ints.Int2ByteFunction"): Internal.Int2ByteFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.SmithingTrimRecipe$Serializer"): typeof Internal.SmithingTrimRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.api.IEnergyStorageUpgradeWrapper"): Internal.IEnergyStorageUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.BidirectionalIterator"): Internal.BidirectionalIterator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.server.permission.nodes.PermissionNode"): typeof Internal.PermissionNode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.MouseHandler"): typeof Internal.MouseHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BirchWallClockBlock"): typeof Internal.BirchWallClockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.InputEvent$Key"): typeof Internal.InputEvent$Key;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeBucketPickup"): Internal.IForgeBucketPickup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.chunk.ChunkStatus"): typeof Internal.ChunkStatus;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.AbstractHugeMushroomFeature"): typeof Internal.AbstractHugeMushroomFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.HoneycombItem"): typeof Internal.HoneycombItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade"): Internal.ITickableUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.ProgressListener"): Internal.ProgressListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.RecipesEventJS"): typeof Internal.RecipesEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.color.ColorSpace"): typeof Internal.ColorSpace;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.color.block.BlockColors"): typeof Internal.BlockColors;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.PoseStack"): typeof Internal.PoseStack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.ConstantInt"): typeof Internal.ConstantInt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.PrimitiveIterator$OfInt"): Internal.PrimitiveIterator$OfInt;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.IWaxable"): Internal.IWaxable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RecipesUpdatedEvent"): typeof Internal.RecipesUpdatedEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.HangingRootsBlock"): typeof Internal.HangingRootsBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.apache.maven.artifact.metadata.ArtifactMetadata"): Internal.ArtifactMetadata;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.bytes.Byte2ObjectFunction"): Internal.Byte2ObjectFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.opolisutilities.block.custom.ResourceGeneratorBlock"): typeof Internal.ResourceGeneratorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.SignBlockEntity"): typeof Internal.SignBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.integration.forge.jei.HideCustomJEIEventJS"): typeof Internal.HideCustomJEIEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.SouliumSpawnerBlock"): typeof Internal.SouliumSpawnerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.SpruceSinkCounterBlock"): typeof Internal.SpruceSinkCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vazkii.patchouli.api.IComponentRenderContext"): Internal.IComponentRenderContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.events.QuestProgressEventData"): typeof Internal.QuestProgressEventData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimatableManager$ControllerRegistrar"): typeof Internal.AnimatableManager$ControllerRegistrar;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "xueluoanping.fluiddrawerslegacy.block.ItemFluidDrawer"): typeof Internal.ItemFluidDrawer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.EnchanterBlock"): typeof Internal.EnchanterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.AbstractCandleBlock"): typeof Internal.AbstractCandleBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.effects.ArmorDecreaseMobEffect"): typeof Internal.ArmorDecreaseMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance"): Internal.DragonPhaseInstance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.vibrations.VibrationSystem"): Internal.VibrationSystem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Graphics2D"): typeof Internal.Graphics2D;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.common.fluid.FluidIngredient"): typeof Internal.FluidIngredient;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.SaplingGrowTreeEvent"): typeof Internal.SaplingGrowTreeEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.HoverEvent$ItemStackInfo"): typeof Internal.HoverEvent$ItemStackInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.PirateTier1Item$Helmet"): typeof Internal.PirateTier1Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.searchtree.SearchRegistry"): typeof Internal.SearchRegistry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.SimpleContainer"): typeof Internal.SimpleContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.item.MelonJuiceItem"): typeof Internal.MelonJuiceItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.CompositeContext"): Internal.CompositeContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.item.IThirdPersonSpecialItemRenderer"): Internal.IThirdPersonSpecialItemRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix3fc"): Internal.Matrix3fc;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ComplexItem"): typeof Internal.ComplexItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.darkhax.bookshelf.mixin.accessors.inventory.AccessorInventoryMenu"): Internal.AccessorInventoryMenu;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.security.AlgorithmParameters"): typeof Internal.AlgorithmParameters;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.block.BaseWallBlock"): typeof Internal.BaseWallBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.BlockRightClickedEventJS"): typeof Internal.BlockRightClickedEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.longs.Long2DoubleFunction"): Internal.Long2DoubleFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.sounds.SoundBufferLibrary"): typeof Internal.SoundBufferLibrary;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.server.command.EnumArgument$Info$Template"): typeof Internal.EnumArgument$Info$Template;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.JigsawBlockEntity"): typeof Internal.JigsawBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WitherWallSkullBlock"): typeof Internal.WitherWallSkullBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blending.Blender"): typeof Internal.Blender;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.LootDataManager"): typeof Internal.LootDataManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.NetherSproutsBlock"): typeof Internal.NetherSproutsBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.NameTagItem"): typeof Internal.NameTagItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.NearestVisibleLivingEntitySensor"): typeof Internal.NearestVisibleLivingEntitySensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.Display$BillboardConstraints"): typeof Internal.Display$BillboardConstraints;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.function.BinaryOperator"): Internal.BinaryOperator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.FenceMimicBlock"): typeof Internal.FenceMimicBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tfar.dankstorage.utils.DankStats"): typeof Internal.DankStats;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.QuartzChairBlock"): typeof Internal.QuartzChairBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "top.theillusivec4.curios.api.type.capability.ICurio$SoundInfo"): typeof Internal.ICurio$SoundInfo;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electrolyte.matc.items.InferiumCrystal"): typeof Internal.InferiumCrystal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.Arrow"): typeof Internal.Arrow;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.block.EnderiumBlock"): typeof Internal.EnderiumBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.recipe.transfer.IRecipeTransferError"): Internal.IRecipeTransferError;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.exceptions.CommandExceptionType"): Internal.CommandExceptionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.common.reflect.TypeCapture"): typeof Internal.TypeCapture;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.village.poi.PoiType"): typeof Internal.PoiType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.FlaxBlock"): typeof Internal.FlaxBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.block.BasicBlock"): typeof Internal.BasicBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.worldgen.WaySignStructure$Type"): typeof Internal.WaySignStructure$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.obscureapi.common.enchantments.FastSpinEnchantment"): typeof Internal.FastSpinEnchantment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer"): typeof Internal.StraightTrunkPlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.IngredientSupplierKJS"): Internal.IngredientSupplierKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.JsonElement"): typeof Internal.JsonElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.reward.RewardClaimType"): typeof Internal.RewardClaimType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.api.conveyor.ConveyorUpgrade"): typeof Internal.ConveyorUpgrade;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.item.custom.WhiteSprayCanItem"): typeof Internal.WhiteSprayCanItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.ForgeConfigSpec$Range"): typeof Internal.ForgeConfigSpec$Range;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.ItemNameBlockItem"): typeof Internal.ItemNameBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.innovation.common.item.RFMagnetItem"): typeof Internal.RFMagnetItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.MangroveCounterBlock"): typeof Internal.MangroveCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.RandomSequences"): typeof Internal.RandomSequences;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.extensions.IForgeBlockAndTintGetter"): Internal.IForgeBlockAndTintGetter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.NonNullList"): typeof Internal.NonNullList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.MenuComponent"): typeof Internal.MenuComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.suppsquared.common.ColoredSackBlock"): typeof Internal.ColoredSackBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerGamePacketListener"): Internal.ServerGamePacketListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.ReprocessorBlock"): typeof Internal.ReprocessorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.vehicle.MinecartSpawner"): typeof Internal.MinecartSpawner;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.item.ItemTransporterType"): typeof Internal.ItemTransporterType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.goat.Goat"): typeof Internal.Goat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbxmodcompat.ftbquests.kubejs.CustomRewardEventJS"): typeof Internal.CustomRewardEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.heightproviders.HeightProviderType"): Internal.HeightProviderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.items.weapon.WhisperOfTheAbyssItem"): typeof Internal.WhisperOfTheAbyssItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.BlockSourceImpl"): typeof Internal.BlockSourceImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.concurrent.Callable"): Internal.Callable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector4i"): typeof Internal.Vector4i;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.HungerLevel"): typeof Internal.HungerLevel;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.AttributedCharacterIterator$Attribute"): typeof Internal.AttributedCharacterIterator$Attribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.item.CountedItem"): typeof Internal.CountedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.FluidPlacerBlock"): typeof Internal.FluidPlacerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.item.tool.BaseCrossbowItem"): typeof Internal.BaseCrossbowItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ObserverBlock"): typeof Internal.ObserverBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.level.FireworksJS"): typeof Internal.FireworksJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$AbstractImmutableMap"): typeof Internal.ImmutableCollections$AbstractImmutableMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tocraft.walkers.mixin.accessor.FoxEntityAccessor"): Internal.FoxEntityAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.vibrations.VibrationSystem$Data"): typeof Internal.VibrationSystem$Data;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.Clock"): typeof Internal.Clock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.QuartzMirrorBlock"): typeof Internal.QuartzMirrorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.FoodBuilder"): typeof Internal.FoodBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.thread.BlockableEventLoop"): typeof Internal.BlockableEventLoop;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.doubles.Double2ByteFunction"): Internal.Double2ByteFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ScaffoldingBlock"): typeof Internal.ScaffoldingBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "de.keksuccino.fancymenu.util.resource.PlayableResource"): Internal.PlayableResource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PlayerHeadBlock"): typeof Internal.PlayerHeadBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Matrix3f"): typeof Matrix3f;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.blay09.mods.balm.api.event.BalmEvent"): typeof Internal.BalmEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.common.enchantment.EnchantmentCoFH"): typeof Internal.EnchantmentCoFH;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.NumberComponent$DoubleRange"): typeof Internal.NumberComponent$DoubleRange;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.resources.CloseableResourceManager"): Internal.CloseableResourceManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.stream.IntStream$Builder"): Internal.IntStream$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.JarBlock"): typeof net.mehvahdjukaar.supplementaries.common.block.blocks.JarBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.SculkSensorBlockEntity"): typeof Internal.SculkSensorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.ProgressionMode"): typeof Internal.ProgressionMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.HorizontalDirectionalBlockBuilder"): typeof Internal.HorizontalDirectionalBlockBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.CampfireBlockEntity"): typeof Internal.CampfireBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Merchant2Item$Helmet"): typeof Internal.Merchant2Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.FrontAndTop"): typeof Internal.FrontAndTop;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.arguments.ResourceArgument$Info$Template"): typeof Internal.ResourceArgument$Info$Template;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.strainers.recipe.StrainerRecipe$Serializer"): typeof Internal.StrainerRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer"): typeof Internal.FoliagePlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.quest.QuestObjectBase"): typeof Internal.QuestObjectBase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.JungleTableBlock"): typeof Internal.JungleTableBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.recipe.IRecipeLookup"): Internal.IRecipeLookup;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.math.BigDecimal"): typeof Internal.BigDecimal;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.resources.ResourceProvider"): Internal.ResourceProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.world.modifiers.SoulstoneModifier"): typeof Internal.SoulstoneModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.metadata.animation.AnimationFrame"): typeof Internal.AnimationFrame;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.client.screen.asset.IHasAssetProvider"): Internal.IHasAssetProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.moddingx.libx.registration.RegistrationContext"): typeof Internal.RegistrationContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.cultivation.common.item.JarredItem"): typeof Internal.JarredItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.player.PlayerModelPart"): typeof Internal.PlayerModelPart;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.MyceliumBlock"): typeof Internal.MyceliumBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.MapExtendingRecipe"): typeof Internal.MapExtendingRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.item.tool.BaseFishingRodItem"): typeof Internal.BaseFishingRodItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.rhino.mod.util.JsonSerializable"): Internal.JsonSerializable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.MobEffectEvent$Applicable"): typeof Internal.MobEffectEvent$Applicable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SporeBlossomBlock"): typeof Internal.SporeBlossomBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.MenuType$MenuSupplier"): Internal.MenuType$MenuSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.cultivation.init.registries.TCulBlocks$1"): typeof Internal.TCulBlocks$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe"): typeof Internal.CuttingBoardRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.probejs.jdoc.property.AbstractProperty"): typeof Internal.AbstractProperty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.armortrim.TrimPattern"): typeof Internal.TrimPattern;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BannerPatternItem"): typeof Internal.BannerPatternItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.tags.ITag"): Internal.ITag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.Heightmap$Types"): typeof Internal.Heightmap$Types;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.dimension.end.EndDragonFight"): typeof Internal.EndDragonFight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.util.NonNullPredicate"): Internal.NonNullPredicate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.carver.CarverDebugSettings"): typeof Internal.CarverDebugSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.searchtree.RefreshableSearchTree"): Internal.RefreshableSearchTree;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.core.SectionPos"): typeof Internal.SectionPos;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.core.common.block.EnderiumGlassBlock"): typeof Internal.EnderiumGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.InventoryKJS"): Internal.InventoryKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.crafting.conditions.ICondition$IContext"): Internal.ICondition$IContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.Decoder"): Internal.Decoder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.shaders.EffectProgram"): typeof Internal.EffectProgram;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.debug.PathfindingRenderer"): typeof Internal.PathfindingRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeTransformation"): Internal.IForgeTransformation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Merchant1Item$Helmet"): typeof Internal.Merchant1Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.profiling.metrics.MetricSampler$MetricSamplerBuilder"): typeof Internal.MetricSampler$MetricSamplerBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.SpruceMirrorBlock"): typeof Internal.SpruceMirrorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.ContainerListener"): net.minecraft.world.inventory.ContainerListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.google.gson.JsonArray"): typeof Internal.JsonArray;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.AbstractObject2IntMap"): typeof Internal.AbstractObject2IntMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.minecraft.TelemetrySession"): Internal.TelemetrySession;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.core.item.ArchitecturyBucketItem"): typeof Internal.ArchitecturyBucketItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType"): typeof Internal.LootScoreProviderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.SpawnData"): typeof Internal.SpawnData;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.item.tool.BaseShearsItem"): typeof Internal.BaseShearsItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.core.CreativeModeTabKJS"): Internal.CreativeModeTabKJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.FamilyOptic"): Internal.FamilyOptic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.electronwill.nightconfig.core.UnmodifiableConfig$Entry"): Internal.UnmodifiableConfig$Entry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.util.filter.IFilterableItem"): Internal.IFilterableItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartitioner$SlotRange"): typeof Internal.InventoryPartitioner$SlotRange;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.Fallable"): Internal.Fallable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.event.StartupEventJS"): typeof Internal.StartupEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SculkSpreader$ChargeCursor"): typeof Internal.SculkSpreader$ChargeCursor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemDroppedEventJS"): typeof Internal.ItemDroppedEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.realmsclient.dto.RealmsServer$WorldType"): typeof Internal.RealmsServer$WorldType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.TheEndPortalBlockEntity"): typeof Internal.TheEndPortalBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.behavior.Swim"): typeof Internal.Swim;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractPresentBlock"): typeof Internal.AbstractPresentBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ContainerScreenEvent$Render$Foreground"): typeof Internal.ContainerScreenEvent$Render$Foreground;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.llamalad7.mixinextras.sugar.ref.LocalIntRef"): Internal.LocalIntRef;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.cultivation.common.block.CheeseWheelBlock"): typeof Internal.CheeseWheelBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.util.ScheduledEvents$Callback"): Internal.ScheduledEvents$Callback;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.players.PlayerList"): typeof Internal.PlayerList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.event.EventJS"): typeof Internal.EventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.block.tile.BasicTile"): typeof Internal.BasicTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.OutputReplacementTransformer"): Internal.OutputReplacementTransformer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.kinds.Kind1"): Internal.Kind1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.OakFireplaceBlock"): typeof Internal.OakFireplaceBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "chiefarug.mods.systeams.SteamFluid$1"): typeof Internal.SteamFluid$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.projectile.LargeFireball"): typeof Internal.LargeFireball;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.PlayerChatMessage"): typeof Internal.PlayerChatMessage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BowItem"): typeof Internal.BowItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.strainers.fluid.BaseFluidType"): typeof Internal.BaseFluidType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BrownLampBlock"): typeof Internal.BrownLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest"): typeof Internal.BlockMatchTest;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbquests.item.StageBarrierBlockItem"): typeof Internal.StageBarrierBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.navigation.PathNavigation"): typeof Internal.PathNavigation;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRedstone"): typeof Internal.ItemUpgradeRedstone;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.damagesource.DamageScaling"): typeof Internal.DamageScaling;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.text.FieldPosition"): typeof Internal.FieldPosition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent$MouseDragged$Post"): typeof Internal.ScreenEvent$MouseDragged$Post;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "mezz.jei.api.runtime.IJeiKeyMappings"): Internal.IJeiKeyMappings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.BrigadierExceptions"): typeof Internal.BrigadierExceptions;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.PlayerStatsJS"): typeof Internal.PlayerStatsJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.capabilities.ICapabilityProviderImpl"): Internal.ICapabilityProviderImpl;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.extensions.IForgeFluidState"): Internal.IForgeFluidState;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tax.taknax.taxov.block.PirateBlockBlock"): typeof Internal.PirateBlockBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.crafting.BackpackUpgradeRecipe$Serializer"): typeof Internal.BackpackUpgradeRecipe$Serializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.player.PlayerInteractEvent$LeftClickBlock$Action"): typeof Internal.PlayerInteractEvent$LeftClickBlock$Action;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.block.GlowAirBlock"): typeof Internal.GlowAirBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.blocks.OxygeliumBlock"): typeof Internal.OxygeliumBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.AdultSensor"): typeof Internal.AdultSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Insets"): typeof Internal.Insets;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.MushroomCow"): typeof Internal.MushroomCow;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "journeymap.client.api.display.IThemeButton$Action"): Internal.IThemeButton$Action;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.GrowingPlantHeadBlock"): typeof Internal.GrowingPlantHeadBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.registry.registries.options.RegistrarOption"): Internal.RegistrarOption;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P12"): typeof Internal.Products$P12;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.JobAttributes$DefaultSelectionType"): typeof Internal.JobAttributes$DefaultSelectionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.entity.EntitySpawnedEventJS"): typeof Internal.EntitySpawnedEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.WallSkullBlock"): typeof Internal.WallSkullBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.hooks.level.biome.BiomeProperties"): Internal.BiomeProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.architectury.utils.Env"): typeof Internal.Env;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Locale$IsoCountryCode"): typeof Internal.Locale$IsoCountryCode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeConfig"): typeof Internal.TankUpgradeConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorNordicTier2Item$Boots"): typeof Internal.SailorNordicTier2Item$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.core.tile.LatexProcessingUnitTile"): typeof Internal.LatexProcessingUnitTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.thread.ProcessorHandle"): Internal.ProcessorHandle;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.level.BlockEvent$EntityMultiPlaceEvent"): typeof Internal.BlockEvent$EntityMultiPlaceEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.item.FuelItem"): typeof Internal.FuelItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.EntityMobGriefingEvent"): typeof Internal.EntityMobGriefingEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.IntTag"): typeof Internal.IntTag;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.player.PlayerRespawnedEventJS"): typeof Internal.PlayerRespawnedEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.util.NonNullConsumer"): Internal.NonNullConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedbackpacks.crafting.SmithingBackpackUpgradeRecipe"): typeof Internal.SmithingBackpackUpgradeRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.foliageplacers.PineFoliagePlacer"): typeof Internal.PineFoliagePlacer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.sensing.VillagerBabiesSensor"): typeof Internal.VillagerBabiesSensor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer"): typeof Internal.RecipeWrapperSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.stream.DoubleStream$Builder"): Internal.DoubleStream$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.ClickAction"): typeof Internal.ClickAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.food.FoodProperties"): typeof Internal.FoodProperties;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.monster.AbstractIllager"): typeof Internal.AbstractIllager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.ContainerLevelAccess"): Internal.ContainerLevelAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "it.unimi.dsi.fastutil.objects.AbstractObject2ObjectMap"): typeof Internal.AbstractObject2ObjectMap;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.talhanation.smallships.world.item.CannonBallItem"): typeof Internal.CannonBallItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.CorsairTier1Item$Chestplate"): typeof Internal.CorsairTier1Item$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.recipe.serializer.GenericSerializer"): typeof Internal.GenericSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.TippedArrowItem"): typeof Internal.TippedArrowItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.crafting.FireworkStarFadeRecipe"): typeof Internal.FireworkStarFadeRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.api.IBlockContainer"): Internal.IBlockContainer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorRedTier2Item$Leggings"): typeof Internal.SailorRedTier2Item$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.block.BlockDrawers"): typeof Internal.BlockDrawers;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.entity.living.LivingEntityUseItemEvent$Tick"): typeof Internal.LivingEntityUseItemEvent$Tick;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings"): typeof Internal.StructurePlaceSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.fluids.SoftFluid$Builder"): typeof Internal.SoftFluid$Builder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.util.ContextUtils$EntityFluidStateContext"): typeof Internal.ContextUtils$EntityFluidStateContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.worldgen.RoadSignFeature"): typeof Internal.RoadSignFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.LecternBlockEntity"): typeof Internal.LecternBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.MouseWheelListener"): Internal.MouseWheelListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundRecipePacket$State"): typeof Internal.ClientboundRecipePacket$State;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.creativetab.CreativeTabEvent"): typeof Internal.CreativeTabEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.registries.DataPackRegistryEvent$NewRegistry"): typeof Internal.DataPackRegistryEvent$NewRegistry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.gitlab.srcmc.powered_flashlight.forge.items.FlashlightItem"): typeof Internal.FlashlightItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.items.armor.AbyssalArmorExtraItem"): typeof Internal.AbyssalArmorExtraItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.item.tool.BaseSickleItem"): typeof Internal.BaseSickleItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.dimension.DimensionType$MonsterSettings"): typeof Internal.DimensionType$MonsterSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.time.Instant"): typeof Internal.Instant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.RiderShieldingMount"): Internal.RiderShieldingMount;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.common.world.BiomeModifier$Phase"): typeof Internal.BiomeModifier$Phase;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.authlib.yggdrasil.ServicesKeySet"): Internal.ServicesKeySet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.event.ContainerListener"): Internal.ContainerListener;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.storage.loot.ValidationContext"): typeof Internal.ValidationContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.blending.Blender$DistanceGetter"): Internal.Blender$DistanceGetter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart.ILevelEventRedirect"): Internal.ILevelEventRedirect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.SandBlock"): typeof Internal.SandBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.HorizontalDirectionalBlock"): typeof Internal.HorizontalDirectionalBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.blocks.BlockGeneratorBlock"): typeof Internal.BlockGeneratorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundAddPlayerPacket"): typeof Internal.ClientboundAddPlayerPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RegisterNamedRenderTypesEvent"): typeof Internal.RegisterNamedRenderTypesEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$ListN"): typeof Internal.ImmutableCollections$ListN;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.entity.EntityRenderer"): typeof Internal.EntityRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.event.EventExit"): typeof Internal.EventExit;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.Products$P7"): typeof Internal.Products$P7;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.recipe.generator.IJsonFile"): Internal.IJsonFile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.lib.util.recipes.DynamoFuelSerializer"): typeof Internal.DynamoFuelSerializer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.LongSummaryStatistics"): typeof Internal.LongSummaryStatistics;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.light_gray.LightGrayWallSignBlock"): typeof Internal.LightGrayWallSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.effect.MobEffect"): typeof Internal.MobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic"): typeof Internal.ContentsFilterLogic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.EnumConfig"): typeof Internal.EnumConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement"): typeof Internal.SinglePoolElement;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.structures.DesertPyramidStructure"): typeof Internal.DesertPyramidStructure;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.fluid.OreFluid"): typeof Internal.OreFluid;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.gui.overlay.ForgeGui"): typeof Internal.ForgeGui;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.BottleItem"): typeof Internal.BottleItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.supermartijn642.core.data.condition.ResourceCondition"): Internal.ResourceCondition;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SimpleFoiledItem"): typeof Internal.SimpleFoiledItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket$Action"): typeof Internal.ServerboundPlayerCommandPacket$Action;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.event.RecipeManagerLoadingEvent"): typeof Internal.RecipeManagerLoadingEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.FoodEatenEventJS"): typeof Internal.FoodEatenEventJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.phys.shapes.CubeVoxelShape"): typeof Internal.CubeVoxelShape;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.behavior.MoveToTargetSink"): typeof Internal.MoveToTargetSink;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.Rarity"): typeof Internal.Rarity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.TallFlowerBlock"): typeof Internal.TallFlowerBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.MobSpawnSettings$MobSpawnCost"): typeof Internal.MobSpawnSettings$MobSpawnCost;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.dnd.DragSourceDropEvent"): typeof Internal.DragSourceDropEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.chunk.ChunkRenderDispatcher$RenderChunk"): typeof Internal.ChunkRenderDispatcher$RenderChunk;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.WitherproofGlassBlock"): typeof Internal.WitherproofGlassBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.RenderHighlightEvent"): typeof Internal.RenderHighlightEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType"): typeof Internal.BlockStateProviderType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.saveddata.maps.MapItemSavedData$HoldingPlayer"): typeof Internal.MapItemSavedData$HoldingPlayer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket$Action"): typeof Internal.ClientboundSetPlayerTeamPacket$Action;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.tags.TagLoader$EntryWithSource"): typeof Internal.TagLoader$EntryWithSource;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.JarItem"): typeof Internal.JarItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.joml.Vector2ic"): Internal.Vector2ic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.color.item.ItemColor"): Internal.ItemColor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.items.armor.ThreeBoltArmorItem$Chestplate"): typeof Internal.ThreeBoltArmorItem$Chestplate;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.PirateTier3Item$Boots"): typeof Internal.PirateTier3Item$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.InputEvent$MouseScrollingEvent"): typeof Internal.InputEvent$MouseScrollingEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "javax.swing.text.AttributeSet$ParagraphAttribute"): Internal.AttributeSet$ParagraphAttribute;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.datafixers.util.Pair"): typeof Internal.Pair;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.StemGrownBlock"): typeof Internal.StemGrownBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.StringSplitter$LinePosConsumer"): Internal.StringSplitter$LinePosConsumer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.block.EssenceFurnaceBlock$Supremium"): typeof Internal.EssenceFurnaceBlock$Supremium;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.lib.common.item.AugmentItem"): typeof cofh.thermal.lib.common.item.AugmentItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.resources.language.LanguageManager"): typeof Internal.LanguageManager;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.BirchMirrorBlock"): typeof Internal.BirchMirrorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.IntProvider"): typeof Internal.IntProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "chiefarug.mods.systeams.SysteamsRegistry$Recipes$1"): typeof Internal.SysteamsRegistry$Recipes$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.StringRepresentable"): Internal.StringRepresentable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorRedTier3Item"): typeof Internal.SailorRedTier3Item;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.TerrainAdjustment"): typeof Internal.TerrainAdjustment;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.Biome$ClimateSettings"): typeof Internal.Biome$ClimateSettings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.api.filter.FilterAction"): typeof Internal.FilterAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.YellowLampBlock"): typeof Internal.YellowLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.ImmutableCollections$Set12"): typeof Internal.ImmutableCollections$Set12;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.custom.AxeItemBuilder"): typeof Internal.AxeItemBuilder;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.config.ListConfig"): typeof Internal.ListConfig;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.block.model.ItemTransforms"): typeof Internal.ItemTransforms;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.items.weapon.MazeRoseItem"): typeof Internal.MazeRoseItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.CorsairTier1Item$Boots"): typeof Internal.CorsairTier1Item$Boots;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.blue.BlueHangingSignBlock"): typeof Internal.BlueHangingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.eventbus.ListenerList"): typeof Internal.ListenerList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.Feature"): typeof Internal.Feature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "vectorwing.farmersdelight.common.block.WildCropBlock"): typeof Internal.WildCropBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.brigadier.exceptions.SimpleCommandExceptionType"): typeof Internal.SimpleCommandExceptionType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.Rabbit"): typeof Internal.Rabbit;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.BossEvent"): typeof Internal.BossEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.GrayLampBlock"): typeof Internal.GrayLampBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.SlabType"): typeof Internal.SlabType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.api.IDetonatable"): Internal.IDetonatable;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.decoration.LeashFenceKnotEntity"): typeof Internal.LeashFenceKnotEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.thermal.locomotion.common.item.UnderwaterMinecartItem"): typeof Internal.UnderwaterMinecartItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem"): typeof Internal.BambooSpikesTippedItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.DataBuffer"): typeof Internal.DataBuffer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "org.mangorage.mangomultiblock.item.DetectorItem"): typeof Internal.DetectorItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.block.IOwnerProtected"): Internal.IOwnerProtected;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.FluidComponents$1"): typeof Internal.FluidComponents$1;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.recipe.component.ArrayRecipeComponent"): typeof Internal.ArrayRecipeComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.animal.horse.Llama$Variant"): typeof Internal.Llama$Variant;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket"): typeof Internal.ClientboundSetDisplayObjectivePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.ItemTintFunction"): Internal.ItemTintFunction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CandleCakeBlock"): typeof Internal.CandleCakeBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ExperienceOrb"): typeof Internal.ExperienceOrb;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.ModCheck"): typeof Internal.ModCheck;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tfar.dankstorage.mixin.MinecraftServerAccess"): Internal.MinecraftServerAccess;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.tile.SludgeRefinerTile"): typeof Internal.SludgeRefinerTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.MangroveTableBlock"): typeof Internal.MangroveTableBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.inventory.tooltip.TooltipComponent"): Internal.TooltipComponent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList"): typeof Internal.MultiNoiseBiomeSourceParameterList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.liopyu.entityjs.util.ContextUtils$OnEffectContext"): typeof Internal.ContextUtils$OnEffectContext;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.item.creativetab.CreativeTabContentSupplier"): Internal.CreativeTabContentSupplier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.renderer.LevelRenderer"): typeof Internal.LevelRenderer;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker$IItemHandlerInserter"): Internal.ISlotTracker$IItemHandlerInserter;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.commands.SharedSuggestionProvider"): Internal.SharedSuggestionProvider;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.heightproviders.VeryBiasedToBottomHeight"): typeof Internal.VeryBiasedToBottomHeight;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.misc.tile.EnchantmentExtractorTile"): typeof Internal.EnchantmentExtractorTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.PressurePlateBlock"): typeof Internal.PressurePlateBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.entity.ai.behavior.SleepInBed"): typeof Internal.SleepInBed;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.Event"): typeof Internal.Event;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.item.ItemQuantifyKey"): typeof Internal.ItemQuantifyKey;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.object.DataTicket"): typeof Internal.DataTicket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.items.SlingshotItem"): typeof Internal.SlingshotItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.players.ServerOpList"): typeof Internal.ServerOpList;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.blaze3d.vertex.VertexFormat$Mode"): typeof Internal.VertexFormat$Mode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.api.redstone.IRedstoneAction"): Internal.IRedstoneAction;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile"): typeof Internal.BlackboardBlockTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftbteams.api.property.TeamPropertyType"): typeof Internal.TeamPropertyType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.brightblock.BrightWallBlock"): typeof Internal.BrightWallBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket"): typeof Internal.ClientboundSetBorderWarningDelayPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.resourceproduction.tile.DyeMixerTile"): typeof Internal.DyeMixerTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.DensityFunctions$TwoArgumentSimpleFunction$Type"): typeof Internal.DensityFunctions$TwoArgumentSimpleFunction$Type;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "tocraft.walkers.impl.NearbySongAccessor"): Internal.NearbySongAccessor;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic"): typeof Internal.FilterLogic;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.entity.DaylightDetectorBlockEntity"): typeof Internal.DaylightDetectorBlockEntity;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent"): typeof Internal.FurnaceFuelBurnTimeEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.items.PiratePouchItem"): typeof Internal.PiratePouchItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.data.recipes.FinishedRecipe"): Internal.FinishedRecipe;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket"): typeof Internal.ClientboundSetChunkCacheRadiusPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ClientboundExplodePacket"): typeof Internal.ClientboundExplodePacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.ComparatorMode"): typeof Internal.ComparatorMode;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.DeckhandItem$Helmet"): typeof Internal.DeckhandItem$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.gameevent.GameEvent"): typeof Internal.GameEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Deque"): Internal.Deque;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.state.properties.BooleanProperty"): typeof Internal.BooleanProperty;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.item.infinity.item.ItemInfinityNuke"): typeof Internal.ItemInfinityNuke;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.structure.StructureType"): Internal.StructureType;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.ScreenEvent"): typeof Internal.ScreenEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem"): typeof Internal.WoodBasedBlockItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.obscuria.aquamirae.common.effects.HealthDecreaseMobEffect"): typeof Internal.HealthDecreaseMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.nbt.StreamTagVisitor$EntryResult"): typeof Internal.StreamTagVisitor$EntryResult;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.feature.CoralClawFeature"): typeof Internal.CoralClawFeature;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.benbenlaw.caveopolis.block.custom.sign.red.RedHangingSignBlock"): typeof Internal.RedHangingSignBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.EnumSet"): typeof Internal.EnumSet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.OptionInstance$CaptionBasedToString"): Internal.OptionInstance$CaptionBasedToString;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.awt.image.VolatileImage"): typeof Internal.VolatileImage;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.generator.tile.BiofuelGeneratorTile"): typeof Internal.BiofuelGeneratorTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.util.valueproviders.ClampedNormalFloat"): typeof Internal.ClampedNormalFloat;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.server.tag.TagWrapper"): typeof Internal.TagWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.client.ModelGenerator$Face"): typeof Internal.ModelGenerator$Face;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.model.geometry.IUnbakedGeometry"): Internal.IUnbakedGeometry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.effect.MobEffectCategory"): typeof Internal.MobEffectCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagradditions.world.modifiers.NetherProsperityOreModifier"): typeof Internal.NetherProsperityOreModifier;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.latvian.mods.kubejs.block.custom.BasicBlockJS"): typeof Internal.BasicBlockJS;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.server.packs.repository.Pack"): typeof Internal.Pack;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.levelgen.WorldgenRandom$Algorithm"): typeof Internal.WorldgenRandom$Algorithm;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.protocol.game.ServerboundUseItemPacket"): typeof Internal.ServerboundUseItemPacket;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.HoverEvent$Action"): typeof Internal.HoverEvent$Action;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.lib.common.block.CakeBlockCoFH"): typeof Internal.CakeBlockCoFH;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.network.chat.ChatDecorator"): Internal.ChatDecorator;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jtorleonstudios.awesomedungeonocean.AwsOceanBoatStructures$FrigateM"): typeof Internal.AwsOceanBoatStructures$FrigateM;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.mysticalagriculture.item.armor.EssenceChestplateItem"): typeof Internal.EssenceChestplateItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.client.event.TextureStitchEvent$Post"): typeof Internal.TextureStitchEvent$Post;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.Merchant3Item$Helmet"): typeof Internal.Merchant3Item$Helmet;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.QuartzDeskBlock"): typeof Internal.QuartzDeskBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.client.tutorial.TutorialSteps"): typeof Internal.TutorialSteps;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.mcreator.cozyhome.block.OakCounterBlock"): typeof Internal.OakCounterBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.ComparatorBlock"): typeof Internal.ComparatorBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "dev.ftb.mods.ftblibrary.ui.ContextMenuItem"): typeof Internal.ContextMenuItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.blakebr0.cucumber.block.BaseTileEntityBlock"): typeof Internal.BaseTileEntityBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "java.util.Spliterator$OfDouble"): Internal.Spliterator$OfDouble;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.effect.WrenchedMobEffect"): typeof Internal.WrenchedMobEffect;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.buuz135.industrial.block.tile.IndustrialWorkingTile"): typeof Internal.IndustrialWorkingTile;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "cofh.core.common.item.IMultiModeItem"): Internal.IMultiModeItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.hrznstudio.titanium.component.inventory.MultiInventoryComponent$MultiInvCapabilityHandler"): typeof Internal.MultiInventoryComponent$MultiInvCapabilityHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.FeedingUpgradeWrapper"): typeof Internal.FeedingUpgradeWrapper;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.level.block.CryingObsidianBlock"): typeof Internal.CryingObsidianBlock;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraft.world.item.SpawnEggItem"): typeof Internal.SpawnEggItem;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategory"): typeof Internal.MainSettingsCategory;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "net.minecraftforge.event.TickEvent"): typeof Internal.TickEvent;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "letsforge_pirates.item.SailorGrayTier1Item$Leggings"): typeof Internal.SailorGrayTier1Item$Leggings;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.mojang.serialization.codecs.RecordCodecBuilder$Instance"): typeof Internal.RecordCodecBuilder$Instance;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "software.bernie.geckolib.core.animation.AnimationController$AnimationStateHandler"): Internal.AnimationController$AnimationStateHandler;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
        loadClass(className: "com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGeometry"): Internal.IDrawerGeometry;
        /**
         * Loads the specified class, and throws error if class it not found or allowed.
         * The returned object can have public static methods and fields accessed directly from it.
         * Constructors can be used with the new keyword.
        */
      