/// <reference path="./internals/internal_*.d.ts" />
declare class BlockPos extends Vec3i {
    constructor(arg0: Vec3i_)
    constructor(arg0: number, arg1: number, arg2: number)
    mutable(): Internal.BlockPos$MutableBlockPos;
    offset(arg0: number, arg1: number, arg2: number): this;
    offset(arg0: Vec3i_): this;
    east(): this;
    static getX(arg0: number): number;
    static getY(arg0: number): number;
    static betweenClosed(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Iterable<BlockPos>;
    static getZ(arg0: number): number;
    static findClosestMatch(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.Predicate_<BlockPos>): Internal.Optional<BlockPos>;
    static betweenClosedStream(arg0: BlockPos_, arg1: BlockPos_): Internal.Stream<BlockPos>;
    north(arg0: number): this;
    atY(arg0: number): this;
    rotate(arg0: Internal.Rotation_): this;
    relative(arg0: Internal.Direction_, arg1: number): this;
    static offset(arg0: number, arg1: number, arg2: number, arg3: number): number;
    asLong(): number;
    static betweenClosedStream(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Stream<BlockPos>;
    static spiralAround(arg0: BlockPos_, arg1: number, arg2: Internal.Direction_, arg3: Internal.Direction_): Internal.Iterable<Internal.BlockPos$MutableBlockPos>;
    north(): this;
    static randomBetweenClosed(arg0: Internal.RandomSource_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): Internal.Iterable<BlockPos>;
    static withinManhattanStream(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Stream<BlockPos>;
    immutable(): this;
    below(arg0: number): this;
    south(arg0: number): this;
    static asLong(arg0: number, arg1: number, arg2: number): number;
    static betweenClosedStream(arg0: Internal.BoundingBox_): Internal.Stream<BlockPos>;
    static getFlatIndex(arg0: number): number;
    static of(arg0: number): BlockPos;
    /**
     * @deprecated
    */
    static squareOutSouthEast(arg0: BlockPos_): Internal.Stream<BlockPos>;
    static withinManhattan(arg0: BlockPos_, arg1: number, arg2: number, arg3: number): Internal.Iterable<BlockPos>;
    static containing(arg0: number, arg1: number, arg2: number): BlockPos;
    static randomInCube(arg0: Internal.RandomSource_, arg1: number, arg2: BlockPos_, arg3: number): Internal.Iterable<BlockPos>;
    static breadthFirstTraversal(arg0: BlockPos_, arg1: number, arg2: number, arg3: Internal.BiConsumer_<BlockPos, Internal.Consumer<BlockPos>>, arg4: Internal.Predicate_<BlockPos>): number;
    static betweenClosedStream(arg0: Internal.AABB_): Internal.Stream<BlockPos>;
    static betweenClosed(arg0: BlockPos_, arg1: BlockPos_): Internal.Iterable<BlockPos>;
    static offset(arg0: number, arg1: Internal.Direction_): number;
    getCenter(): Vec3d;
    static containing(arg0: Internal.Position_): BlockPos;
    subtract(arg0: Vec3i_): this;
    above(arg0: number): this;
    get center(): Vec3d
    static readonly PACKED_Y_LENGTH: 12;
    static readonly CODEC: Internal.Codec<BlockPos>;
    static readonly ZERO: BlockPos;
}
type BlockPos_ = Vec3d_ | [number, number, number] | BlockPos;
/**
 * Various block related helper functions
*/
declare class Block {
    constructor()
    /**
     * Gets a Block from a block id
    */
    static getBlock(id: ResourceLocation_): Internal.Block;
    static custom(predicate: Internal.BlockPredicate_): Internal.BlockPredicate;
    static id(id: ResourceLocation_): Internal.BlockIDPredicate;
    static entity(id: ResourceLocation_): Internal.BlockEntityPredicate;
    /**
     * Gets a list of the classname of all registered blocks
    */
    static getTypeList(): Internal.List<string>;
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    static getFacing(): Internal.Map<string, Internal.Direction>;
    /**
     * Gets a blocks id from the Block
    */
    static getId(block: Internal.Block_): ResourceLocation;
    static id(id: ResourceLocation_, properties: Internal.Map_<string, any>): Internal.BlockIDPredicate;
    /**
     * Gets a list of all blocks with tags
    */
    static getTaggedIds(tag: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Gets a list of the classname of all registered blocks
    */
    get typeList(): Internal.List<string>
    /**
     * Get a map of direction name to Direction. Functionally identical to Direction.ALL
    */
    get facing(): Internal.Map<string, Internal.Direction>
}
type Block_ = Block;
declare class Vec3d implements Internal.Position {
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Vec3f_)
    normalize(): this;
    get(arg0: Internal.Direction$Axis_): number;
    horizontalDistance(): number;
    lerp(arg0: Vec3d_, arg1: number): this;
    distanceToSqr(arg0: Vec3d_): number;
    lengthSqr(): number;
    relative(arg0: Internal.Direction_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number): this;
    cross(arg0: Vec3d_): this;
    static atCenterOf(arg0: Vec3i_): Vec3d;
    static directionFromRotation(arg0: Internal.Vec2_): Vec3d;
    add(arg0: Vec3d_): this;
    yRot(arg0: number): this;
    z(): number;
    "with"(arg0: Internal.Direction$Axis_, arg1: number): this;
    static atBottomCenterOf(arg0: Vec3i_): Vec3d;
    horizontalDistanceSqr(): number;
    xRot(arg0: number): this;
    dot(arg0: Vec3d_): number;
    multiply(arg0: number, arg1: number, arg2: number): this;
    y(): number;
    x(): number;
    align(arg0: Internal.EnumSet_<Internal.Direction$Axis>): this;
    closerThan(arg0: Internal.Position_, arg1: number): boolean;
    vectorTo(arg0: Vec3d_): this;
    offsetRandom(arg0: Internal.RandomSource_, arg1: number): this;
    static atLowerCornerOf(arg0: Vec3i_): Vec3d;
    static atLowerCornerWithOffset(arg0: Vec3i_, arg1: number, arg2: number, arg3: number): Vec3d;
    subtract(arg0: Vec3d_): this;
    static fromRGB24(arg0: number): Vec3d;
    distanceTo(arg0: Vec3d_): number;
    multiply(arg0: Vec3d_): this;
    static upFromBottomCenterOf(arg0: Vec3i_, arg1: number): Vec3d;
    scale(arg0: number): this;
    reverse(): this;
    toVector3f(): Vec3f;
    length(): number;
    distanceToSqr(arg0: number, arg1: number, arg2: number): number;
    static directionFromRotation(arg0: number, arg1: number): Vec3d;
    zRot(arg0: number): this;
    subtract(arg0: number, arg1: number, arg2: number): this;
    readonly z: number;
    static readonly ZERO: Vec3d;
    static readonly CODEC: Internal.Codec<Vec3d>;
    readonly x: number;
    readonly y: number;
}
type Vec3d_ = [number, number, number] | Vec3d;
declare class RotationAxis extends Internal.Enum<RotationAxis> {
    deg(f: number): Quaternionf;
    static values(): RotationAxis[];
    rad(f: number): Quaternionf;
    static valueOf(name: string): RotationAxis;
    static readonly XN: RotationAxis;
    static readonly ZP: RotationAxis;
    static readonly YN: RotationAxis;
    static readonly XP: RotationAxis;
    static readonly YP: RotationAxis;
    static readonly ZN: RotationAxis;
    readonly vec: Vec3f;
}
type RotationAxis_ = "yp" | "xp" | "yn" | "xn" | "zp" | RotationAxis | "zn";
declare class ResourceLocation implements Internal.SpecialEquality, Internal.Comparable<ResourceLocation> {
    constructor(arg0: string, arg1: string)
    constructor(arg0: string)
    static isValidNamespace(arg0: string): boolean;
    compareTo(arg0: ResourceLocation_): number;
    toLanguageKey(arg0: string): string;
    static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
    static validNamespaceChar(arg0: string): boolean;
    static read(arg0: string): Internal.DataResult<ResourceLocation>;
    static isValidPath(arg0: string): boolean;
    toShortLanguageKey(): string;
    compareTo(arg0: any): number;
    static tryBuild(arg0: string, arg1: string): ResourceLocation;
    static isAllowedInResourceLocation(arg0: string): boolean;
    static tryParse(arg0: string): ResourceLocation;
    withPath(arg0: string): this;
    static validPathChar(arg0: string): boolean;
    toLanguageKey(arg0: string, arg1: string): string;
    toDebugFileName(): string;
    getPath(): string;
    getNamespace(): string;
    static of(arg0: string, arg1: string): ResourceLocation;
    compareNamespaced(arg0: ResourceLocation_): number;
    withSuffix(arg0: string): this;
    specialEquals(o: any, shallow: boolean): boolean;
    static read(arg0: Internal.StringReader_): ResourceLocation;
    toLanguageKey(): string;
    static isValidResourceLocation(arg0: string): boolean;
    withPath(arg0: Internal.UnaryOperator_<string>): this;
    withPrefix(arg0: string): this;
    get path(): string
    get namespace(): string
    static readonly REALMS_NAMESPACE: "realms";
    static readonly CODEC: Internal.Codec<ResourceLocation>;
    static readonly NAMESPACE_SEPARATOR: ":";
    static readonly DEFAULT_NAMESPACE: "minecraft";
}
type ResourceLocation_ = string | ResourceLocation | Special.CustomStat;
declare class Stats {
    constructor()
    static readonly SWIM_ONE_CM: ResourceLocation;
    static readonly FLY_ONE_CM: ResourceLocation;
    static readonly CLEAN_SHULKER_BOX: ResourceLocation;
    static readonly TOTAL_WORLD_TIME: ResourceLocation;
    static readonly TUNE_NOTEBLOCK: ResourceLocation;
    static readonly DAMAGE_RESISTED: ResourceLocation;
    static readonly ITEM_DROPPED: Internal.StatType<Internal.Item>;
    static readonly PLAYER_KILLS: ResourceLocation;
    static readonly INTERACT_WITH_BREWINGSTAND: ResourceLocation;
    static readonly INTERACT_WITH_CAMPFIRE: ResourceLocation;
    static readonly INSPECT_DISPENSER: ResourceLocation;
    static readonly INTERACT_WITH_FURNACE: ResourceLocation;
    static readonly OPEN_ENDERCHEST: ResourceLocation;
    static readonly ANIMALS_BRED: ResourceLocation;
    static readonly POT_FLOWER: ResourceLocation;
    static readonly INTERACT_WITH_STONECUTTER: ResourceLocation;
    static readonly ITEM_PICKED_UP: Internal.StatType<Internal.Item>;
    static readonly FALL_ONE_CM: ResourceLocation;
    static readonly DAMAGE_ABSORBED: ResourceLocation;
    static readonly FISH_CAUGHT: ResourceLocation;
    static readonly INTERACT_WITH_ANVIL: ResourceLocation;
    static readonly BOAT_ONE_CM: ResourceLocation;
    static readonly PLAY_RECORD: ResourceLocation;
    static readonly DAMAGE_DEALT_RESISTED: ResourceLocation;
    static readonly RAID_WIN: ResourceLocation;
    static readonly DAMAGE_DEALT: ResourceLocation;
    static readonly DEATHS: ResourceLocation;
    static readonly INTERACT_WITH_SMOKER: ResourceLocation;
    static readonly ITEM_USED: Internal.StatType<Internal.Item>;
    static readonly BELL_RING: ResourceLocation;
    static readonly INTERACT_WITH_SMITHING_TABLE: ResourceLocation;
    static readonly INSPECT_DROPPER: ResourceLocation;
    static readonly DROP: ResourceLocation;
    static readonly INTERACT_WITH_LECTERN: ResourceLocation;
    static readonly PLAY_TIME: ResourceLocation;
    static readonly WALK_ONE_CM: ResourceLocation;
    static readonly CLIMB_ONE_CM: ResourceLocation;
    static readonly TRADED_WITH_VILLAGER: ResourceLocation;
    static readonly RAID_TRIGGER: ResourceLocation;
    static readonly STRIDER_ONE_CM: ResourceLocation;
    static readonly ITEM_BROKEN: Internal.StatType<Internal.Item>;
    static readonly BLOCK_MINED: Internal.StatType<Internal.Block>;
    static readonly TIME_SINCE_REST: ResourceLocation;
    static readonly INTERACT_WITH_BEACON: ResourceLocation;
    static readonly INSPECT_HOPPER: ResourceLocation;
    static readonly PLAY_NOTEBLOCK: ResourceLocation;
    static readonly CUSTOM: Internal.StatType<ResourceLocation>;
    static readonly CROUCH_TIME: ResourceLocation;
    static readonly JUMP: ResourceLocation;
    static readonly ENTITY_KILLED: Internal.StatType<Internal.EntityType<any>>;
    static readonly ENTITY_KILLED_BY: Internal.StatType<Internal.EntityType<any>>;
    static readonly INTERACT_WITH_CARTOGRAPHY_TABLE: ResourceLocation;
    static readonly MOB_KILLS: ResourceLocation;
    static readonly OPEN_CHEST: ResourceLocation;
    static readonly SLEEP_IN_BED: ResourceLocation;
    static readonly CLEAN_ARMOR: ResourceLocation;
    static readonly CROUCH_ONE_CM: ResourceLocation;
    static readonly TALKED_TO_VILLAGER: ResourceLocation;
    static readonly DAMAGE_DEALT_ABSORBED: ResourceLocation;
    static readonly INTERACT_WITH_LOOM: ResourceLocation;
    static readonly LEAVE_GAME: ResourceLocation;
    static readonly HORSE_ONE_CM: ResourceLocation;
    static readonly WALK_ON_WATER_ONE_CM: ResourceLocation;
    static readonly MINECART_ONE_CM: ResourceLocation;
    static readonly ENCHANT_ITEM: ResourceLocation;
    static readonly TIME_SINCE_DEATH: ResourceLocation;
    static readonly DAMAGE_TAKEN: ResourceLocation;
    static readonly INTERACT_WITH_BLAST_FURNACE: ResourceLocation;
    static readonly TRIGGER_TRAPPED_CHEST: ResourceLocation;
    static readonly INTERACT_WITH_GRINDSTONE: ResourceLocation;
    static readonly OPEN_BARREL: ResourceLocation;
    static readonly SPRINT_ONE_CM: ResourceLocation;
    static readonly DAMAGE_BLOCKED_BY_SHIELD: ResourceLocation;
    static readonly EAT_CAKE_SLICE: ResourceLocation;
    static readonly INTERACT_WITH_CRAFTING_TABLE: ResourceLocation;
    static readonly CLEAN_BANNER: ResourceLocation;
    static readonly TARGET_HIT: ResourceLocation;
    static readonly ITEM_CRAFTED: Internal.StatType<Internal.Item>;
    static readonly WALK_UNDER_WATER_ONE_CM: ResourceLocation;
    static readonly PIG_ONE_CM: ResourceLocation;
    static readonly OPEN_SHULKER_BOX: ResourceLocation;
    static readonly USE_CAULDRON: ResourceLocation;
    static readonly AVIATE_ONE_CM: ResourceLocation;
    static readonly FILL_CAULDRON: ResourceLocation;
}
type Stats_ = Stats;
declare class Fluid {
    constructor()
    static of(o: Internal.FluidStackJS_): Internal.FluidStackJS;
    static getEmpty(): Internal.FluidStackJS;
    static getType(id: ResourceLocation_): Internal.Fluid;
    static of(o: Internal.FluidStackJS_, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, amount: number, nbt: Internal.CompoundTag_): Internal.FluidStackJS;
    static lava(amount: number): Internal.FluidStackJS;
    static of(o: Internal.FluidStackJS_, amount: number): Internal.FluidStackJS;
    static lava(): Internal.FluidStackJS;
    static getTypes(): Internal.List<string>;
    static getId(fluid: Internal.Fluid_): ResourceLocation;
    static water(amount: number): Internal.FluidStackJS;
    static exists(id: ResourceLocation_): boolean;
    static water(): Internal.FluidStackJS;
    get empty(): Internal.FluidStackJS
    get types(): Internal.List<string>
    static readonly LAVA_ID: ResourceLocation;
    static readonly WATER_ID: ResourceLocation;
}
type Fluid_ = Fluid;
declare class InputItem implements Internal.InputReplacement, Internal.IngredientSupplierKJS, Internal.JsonSerializable {
    replaceInput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.InputReplacement_): any;
    static of(o: InputItem_): InputItem;
    validForMatching(): boolean;
    toJson(alwaysNest: boolean): Internal.JsonElement;
    static of(ingredient: Internal.Ingredient_, count: number): InputItem;
    unwrap(): Internal.List<InputItem>;
    transform(transformer: Internal.InputReplacementTransformer_): Internal.InputReplacementTransformer$Replacement;
    isEmpty(): boolean;
    withCount(count: number): this;
    toJson(): Internal.JsonElement;
    kjs$asIngredient(): Internal.Ingredient;
    get empty(): boolean
    readonly ingredient: Internal.Ingredient;
    readonly count: number;
    static readonly EMPTY: InputItem;
    static readonly PARSE_CACHE: {};
}
type InputItem_ = Internal.Ingredient_ | InputItem;
declare interface Color {
    of(o: any): dev.latvian.mods.rhino.mod.util.color.Color;
    rgba(r: number, g: number, b: number, a: number): dev.latvian.mods.rhino.mod.util.color.Color;
    createMapped(o: any, ...names: string[]): dev.latvian.mods.rhino.mod.util.color.Color;
    readonly DARK_PURPLE: Internal.ChatFormatting;
    readonly YELLOW: Internal.ChatFormatting;
    readonly CYAN_DYE: Internal.DyeColor;
    readonly GRAY: Internal.ChatFormatting;
    readonly BROWN_DYE: Internal.DyeColor;
    readonly LIGHT_PURPLE: Internal.ChatFormatting;
    readonly PURPLE_DYE: Internal.DyeColor;
    readonly DARK_AQUA: Internal.ChatFormatting;
    readonly GREEN: Internal.ChatFormatting;
    readonly LIGHT_GRAY_DYE: Internal.DyeColor;
    readonly WHITE: Internal.ChatFormatting;
    readonly MAGENTA_DYE: Internal.DyeColor;
    readonly RED: Internal.ChatFormatting;
    readonly BLACK_DYE: Internal.DyeColor;
    readonly TEXT: {"dark_red": Internal.ChatFormatting, "green": Internal.ChatFormatting, "underline": Internal.ChatFormatting, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "bold": Internal.ChatFormatting, "italic": Internal.ChatFormatting, "dark_blue": Internal.ChatFormatting, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "red": Internal.ChatFormatting, "aqua": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "blue": Internal.ChatFormatting, "white": Internal.ChatFormatting, "dark_aqua": Internal.ChatFormatting, "dark_gray": Internal.ChatFormatting, "reset": Internal.ChatFormatting, "strikethrough": Internal.ChatFormatting, "obfuscated": Internal.ChatFormatting};
    readonly RED_DYE: Internal.DyeColor;
    readonly GRAY_DYE: Internal.DyeColor;
    readonly DARK_GRAY: Internal.ChatFormatting;
    readonly NONE: Internal.NoColor;
    readonly ORANGE_DYE: Internal.DyeColor;
    readonly WHITE_DYE: Internal.DyeColor;
    readonly DYE: {"magenta": Internal.DyeColor, "pink": Internal.DyeColor, "green": Internal.DyeColor, "lime": Internal.DyeColor, "light_gray": Internal.DyeColor, "yellow": Internal.DyeColor, "black": Internal.DyeColor, "light_blue": Internal.DyeColor, "brown": Internal.DyeColor, "cyan": Internal.DyeColor, "orange": Internal.DyeColor, "red": Internal.DyeColor, "gray": Internal.DyeColor, "white": Internal.DyeColor, "blue": Internal.DyeColor, "purple": Internal.DyeColor};
    readonly BLACK: Internal.ChatFormatting;
    readonly BLUE: Internal.ChatFormatting;
    readonly DARK_GREEN: Internal.ChatFormatting;
    readonly DARK_RED: Internal.ChatFormatting;
    readonly GOLD: Internal.ChatFormatting;
    readonly MAP: {"": Internal.NoColor, "light_blue_dye": Internal.DyeColor, "BLUE_DYE": Internal.DyeColor, "purple_dye": Internal.DyeColor, "dark_red": Internal.ChatFormatting, "lightGrayDye": Internal.DyeColor, "DARK_AQUA": Internal.ChatFormatting, "none": Internal.NoColor, "green_dye": Internal.DyeColor, "blackDye": Internal.DyeColor, "dark_blue": Internal.ChatFormatting, "red": Internal.ChatFormatting, "pink_dye": Internal.DyeColor, "aqua": Internal.ChatFormatting, "white": Internal.ChatFormatting, "WHITE_DYE": Internal.DyeColor, "dark_gray": Internal.ChatFormatting, "LIGHT_PURPLE": Internal.ChatFormatting, "BROWN_DYE": Internal.DyeColor, "BLACK": Internal.ChatFormatting, "darkPurple": Internal.ChatFormatting, "NONE": Internal.NoColor, "LIGHT_BLUE_DYE": Internal.DyeColor, "AQUA": Internal.ChatFormatting, "lightBlueDye": Internal.DyeColor, "limeDye": Internal.DyeColor, "PURPLE_DYE": Internal.DyeColor, "GREEN_DYE": Internal.DyeColor, "magenta_dye": Internal.DyeColor, "-": Internal.NoColor, "lime_dye": Internal.DyeColor, "yellowDye": Internal.DyeColor, "grayDye": Internal.DyeColor, "purpleDye": Internal.DyeColor, "DARK_PURPLE": Internal.ChatFormatting, "ORANGE_DYE": Internal.DyeColor, "darkGray": Internal.ChatFormatting, "brownDye": Internal.DyeColor, "YELLOW": Internal.ChatFormatting, "LIME_DYE": Internal.DyeColor, "blueDye": Internal.DyeColor, "white_dye": Internal.DyeColor, "pinkDye": Internal.DyeColor, "blue_dye": Internal.DyeColor, "cyanDye": Internal.DyeColor, "GOLD": Internal.ChatFormatting, "GRAY": Internal.ChatFormatting, "MAGENTA_DYE": Internal.DyeColor, "BLUE": Internal.ChatFormatting, "yellow": Internal.ChatFormatting, "darkBlue": Internal.ChatFormatting, "transparent": Internal.NoColor, "orange_dye": Internal.DyeColor, "red_dye": Internal.DyeColor, "dark_purple": Internal.ChatFormatting, "gold": Internal.ChatFormatting, "gray": Internal.ChatFormatting, "light_purple": Internal.ChatFormatting, "darkRed": Internal.ChatFormatting, "greenDye": Internal.DyeColor, "DARK_RED": Internal.ChatFormatting, "redDye": Internal.DyeColor, "GRAY_DYE": Internal.DyeColor, "orangeDye": Internal.DyeColor, "yellow_dye": Internal.DyeColor, "black_dye": Internal.DyeColor, "magentaDye": Internal.DyeColor, "WHITE": Internal.ChatFormatting, "green": Internal.ChatFormatting, "LIGHT_GRAY_DYE": Internal.DyeColor, "BLACK_DYE": Internal.DyeColor, "darkGreen": Internal.ChatFormatting, "RED_DYE": Internal.DyeColor, "dark_green": Internal.ChatFormatting, "black": Internal.ChatFormatting, "lightPurple": Internal.ChatFormatting, "PINK_DYE": Internal.DyeColor, "DARK_BLUE": Internal.ChatFormatting, "GREEN": Internal.ChatFormatting, "darkAqua": Internal.ChatFormatting, "gray_dye": Internal.DyeColor, "CYAN_DYE": Internal.DyeColor, "RED": Internal.ChatFormatting, "brown_dye": Internal.DyeColor, "cyan_dye": Internal.DyeColor, "blue": Internal.ChatFormatting, "whiteDye": Internal.DyeColor, "dark_aqua": Internal.ChatFormatting, "YELLOW_DYE": Internal.DyeColor, "DARK_GREEN": Internal.ChatFormatting, "DARK_GRAY": Internal.ChatFormatting};
    readonly GREEN_DYE: Internal.DyeColor;
    readonly LIGHT_BLUE_DYE: Internal.DyeColor;
    readonly AQUA: Internal.ChatFormatting;
    readonly DARK_BLUE: Internal.ChatFormatting;
    readonly PINK_DYE: Internal.DyeColor;
    readonly BLUE_DYE: Internal.DyeColor;
    readonly YELLOW_DYE: Internal.DyeColor;
    readonly LIME_DYE: Internal.DyeColor;
}
type Color_ = Color;
declare const Color: Color;
declare class JsonIO {
    constructor()
    static readJson(path: Internal.Path_): Internal.JsonElement;
    static toPrettyString(json: Internal.JsonElement_): string;
    static read(path: Internal.Path_): Internal.Map<any, any>;
    static toArray(element: Internal.JsonElement_): Internal.JsonArray;
    static getJsonHashString(json: Internal.JsonElement_): string;
    static parse(string: string): any;
    static toObject(json: Internal.JsonElement_): any;
    static primitiveOf(o: any): Internal.JsonPrimitive;
    static readString(path: Internal.Path_): string;
    static toPrimitive(element: Internal.JsonElement_): any;
    static copy(element: Internal.JsonElement_): Internal.JsonElement;
    static writeJsonHash(stream: Internal.DataOutputStream_, element: Internal.JsonElement_): void;
    static parseRaw(string: string): Internal.JsonElement;
    static getJsonHashBytes(json: Internal.JsonElement_): number[];
    static toString(json: Internal.JsonElement_): string;
    static of(o: any): Internal.JsonElement;
    static write(path: Internal.Path_, json: Internal.JsonObject_): void;
}
type JsonIO_ = JsonIO;
/**
 * Various item related helper methods
*/
declare interface Item {
    /**
     * Returns an ItemStack of the input
    */
    of(in_: Internal.ItemStack_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count
    */
    of(in_: Internal.ItemStack_, count: number): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified count and NBT data
    */
    of(in_: Internal.ItemStack_, count: number, nbt: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    withNBT(in_: Internal.ItemStack_, nbt: Internal.CompoundTag_): Internal.ItemStack;
    getTypeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>;
    playerHeadFromSkinHash(hash: string): Internal.ItemStack;
    /**
     * Get the item that represents air/an empty slot
    */
    getEmpty(): Internal.ItemStack;
    /**
     * Gets an Item from an item id
    */
    getItem(id: ResourceLocation_): Internal.Item;
    getVariants(item: Internal.ItemStack_): Internal.Collection<Internal.ItemStack>;
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    getList(): Internal.List<Internal.ItemStack>;
    /**
     * Returns a Firework with the input properties
    */
    fireworks(properties: Internal.Map_<string, any>): Internal.FireworksJS;
    playerHead(name: string): Internal.ItemStack;
    playerHeadFromUrl(url: string): Internal.ItemStack;
    /**
     * Get a list of all the item ids in the game
    */
    getTypeList(): Internal.List<string>;
    /**
     * Returns an ItemStack of the input, with the specified NBT data
    */
    of(in_: Internal.ItemStack_, tag: Internal.CompoundTag_): Internal.ItemStack;
    /**
     * Checks if the provided item id exists in the registry
    */
    exists(id: ResourceLocation_): boolean;
    playerHead(uuid: Internal.UUID_, textureBase64: string): Internal.ItemStack;
    /**
     * Checks if the passed in object is an ItemStack.
     * Note that this does not mean it will not function as an ItemStack if passed to something that requests one.
    */
    isItem(o: any): boolean;
    /**
     * Gets an items id from the Item
    */
    getId(item: Internal.Item_): ResourceLocation;
    get typeToStackMap(): Internal.Map<ResourceLocation, Internal.Collection<Internal.ItemStack>>
    /**
     * Get the item that represents air/an empty slot
    */
    get empty(): Internal.ItemStack
    /**
     * Get a list of most items in the game. Items not in a creative tab are ignored
    */
    get list(): Internal.List<Internal.ItemStack>
    /**
     * Get a list of all the item ids in the game
    */
    get typeList(): Internal.List<string>
    readonly KJS_ARMOR_MODIFIER_UUID_PER_SLOT: Internal.UUID[];
    readonly KJS_BASE_ATTACK_SPEED_UUID: Internal.UUID;
    readonly KJS_BASE_ATTACK_DAMAGE_UUID: Internal.UUID;
}
type Item_ = Item;
declare const Item: Item;
declare abstract class number implements Internal.Serializable {
    constructor()
    abstract longValue(): number;
    shortValue(): number;
    abstract doubleValue(): number;
    abstract intValue(): number;
    abstract floatValue(): number;
    byteValue(): number;
}
type number_ = number;
declare class Notification {
    constructor()
    constructor(buf: Internal.FriendlyByteBuf_)
    write(buf: Internal.FriendlyByteBuf_): void;
    setAtlasIcon(icon: string): void;
    static make(consumer: Internal.Consumer_<Notification>): Notification;
    setIcon(icon: string): void;
    static of(cx: Internal.Context_, object: any): Notification;
    show(): void;
    setItemIcon(stack: Internal.ItemStack_): void;
    set atlasIcon(icon: string)
    set icon(icon: string)
    set itemIcon(stack: Internal.ItemStack_)
    duration: Duration;
    static readonly DEFAULT_DURATION: Duration;
    backgroundColor: dev.latvian.mods.rhino.mod.util.color.Color;
    iconSize: number;
    static readonly DEFAULT_BACKGROUND_COLOR: Internal.SimpleColor;
    static readonly DEFAULT_BORDER_COLOR: Internal.SimpleColor;
    borderColor: dev.latvian.mods.rhino.mod.util.color.Color;
    text: net.minecraft.network.chat.Component;
    outlineColor: dev.latvian.mods.rhino.mod.util.color.Color;
    textShadow: boolean;
    static readonly NO_TEXT: net.minecraft.network.chat.Component[];
}
type Notification_ = Notification;
declare class InteractionResult extends Internal.Enum<InteractionResult> {
    static values(): InteractionResult[];
    shouldSwing(): boolean;
    static sidedSuccess(arg0: boolean): InteractionResult;
    shouldAwardStats(): boolean;
    consumesAction(): boolean;
    static valueOf(arg0: string): InteractionResult;
    static readonly PASS: InteractionResult;
    static readonly CONSUME_PARTIAL: InteractionResult;
    static readonly FAIL: InteractionResult;
    static readonly CONSUME: InteractionResult;
    static readonly SUCCESS: InteractionResult;
}
type InteractionResult_ = InteractionResult | "pass" | "consume" | "success" | "consume_partial" | "fail";
declare interface Facing {
    readonly south: Internal.Direction;
    readonly up: Internal.Direction;
    readonly UP: Internal.Direction;
    readonly NORTH: Internal.Direction;
    readonly east: Internal.Direction;
    readonly DOWN: Internal.Direction;
    readonly EAST: Internal.Direction;
    readonly west: Internal.Direction;
    readonly north: Internal.Direction;
    readonly down: Internal.Direction;
    readonly ALL: {"east": Internal.Direction, "south": Internal.Direction, "north": Internal.Direction, "west": Internal.Direction, "up": Internal.Direction, "down": Internal.Direction};
    readonly WEST: Internal.Direction;
    readonly SOUTH: Internal.Direction;
}
type Facing_ = Facing;
declare const Facing: Facing;
declare class Quaternionf implements Internal.Cloneable, Internal.Externalizable, Internal.Quaternionfc {
    constructor()
    constructor(arg0: Internal.AxisAngle4d_)
    constructor(arg0: Internal.Quaternionfc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.AxisAngle4f_)
    constructor(arg0: Internal.Quaterniondc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    slerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    transformInverse(arg0: Internal.Vector4d_): Internal.Vector4d;
    invert(): this;
    transformPositiveY(arg0: Vec3f_): Vec3f;
    transformPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    mul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    setFromUnnormalized(arg0: Internal.Matrix3fc_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    conjugate(arg0: Quaternionf_): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    transform(arg0: Internal.Vector4d_): Internal.Vector4d;
    fromAxisAngleDeg(arg0: Internal.Vector3fc_, arg1: number): this;
    rotateLocalZ(arg0: number): this;
    premul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    scale(arg0: number): this;
    rotationZ(arg0: number): this;
    transformInverse(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveY(arg0: Vec4f_): Vec4f;
    transformPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    premul(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    invert(arg0: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3d_): Internal.Vector3d;
    positiveZ(arg0: Vec3f_): Vec3f;
    div(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    difference(arg0: Quaternionf_): this;
    setFromNormalized(arg0: Internal.Matrix3dc_): this;
    normalize(): this;
    transformPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotateZ(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformPositiveZ(arg0: Vec3f_): Vec3f;
    transformUnit(arg0: Vec4f_): Vec4f;
    scale(arg0: number, arg1: Quaternionf_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number, arg2: Quaternionf_): this;
    mul(arg0: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    static slerp(arg0: Quaternionf_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    get(arg0: Matrix4f_): Matrix4f;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transform(arg0: Vec4f_): Vec4f;
    transformUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setFromNormalized(arg0: Internal.Matrix4fc_): this;
    getAsMatrix3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotationAxis(arg0: Internal.AxisAngle4f_): this;
    transformInverseUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    normalize(arg0: Quaternionf_): this;
    mul(arg0: number, arg1: Quaternionf_): this;
    w(): number;
    transformPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    transform(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPositiveZ(arg0: Vec4f_): Vec4f;
    conjugateBy(arg0: Internal.Quaternionfc_): this;
    transformInverse(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    get(arg0: Internal.Matrix3d_): Internal.Matrix3d;
    transform(arg0: Vec3f_): Vec3f;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    slerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    get(arg0: Internal.Matrix4x3d_): Internal.Matrix4x3d;
    fromAxisAngleRad(arg0: number, arg1: number, arg2: number, arg3: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocalY(arg0: number, arg1: Quaternionf_): this;
    div(arg0: Internal.Quaternionfc_): this;
    transformInverseUnit(arg0: Internal.Vector4d_): Internal.Vector4d;
    setFromUnnormalized(arg0: Internal.Matrix3dc_): this;
    isFinite(): boolean;
    transformUnitPositiveX(arg0: Vec3f_): Vec3f;
    rotateLocalX(arg0: number): this;
    get(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    x(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnit(arg0: Vec3f_): Vec3f;
    transformInverseUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    fromAxisAngleRad(arg0: Internal.Vector3fc_, arg1: number): this;
    setFromUnnormalized(arg0: Internal.Matrix4fc_): this;
    setFromNormalized(arg0: Internal.Matrix3fc_): this;
    premul(arg0: Internal.Quaternionfc_): this;
    nlerp(arg0: Internal.Quaternionfc_, arg1: number): this;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    get(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    transformInverse(arg0: Vec4f_): Vec4f;
    getEulerAnglesZXY(arg0: Vec3f_): Vec3f;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: Quaternionf_): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    add(arg0: Internal.Quaternionfc_): this;
    rotateLocalZ(arg0: number, arg1: Quaternionf_): this;
    getAsMatrix4f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    add(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    dot(arg0: Quaternionf_): number;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateAxis(arg0: number, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    rotateLocalY(arg0: number): this;
    y(): number;
    transformInverse(arg0: Vec3f_): Vec3f;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setFromNormalized(arg0: Internal.Matrix4x3fc_): this;
    static nlerp(arg0: Internal.Quaternionfc_[], arg1: number[], arg2: Quaternionf_): Internal.Quaternionfc;
    getAsMatrix4x3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3dc_): this;
    conjugate(): this;
    transformInverse(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    fromAxisAngleDeg(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveZ(arg0: Vec3f_): Vec3f;
    transformUnitPositiveY(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    z(): number;
    rotationAxis(arg0: number, arg1: Internal.Vector3fc_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    getAsMatrix3f(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    toString(arg0: Internal.NumberFormat_): string;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformInverseUnit(arg0: Vec3f_): Vec3f;
    lengthSquared(): number;
    transformInverseUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    getEulerAnglesYXZ(arg0: Vec3f_): Vec3f;
    setFromUnnormalized(arg0: Internal.Matrix4dc_): this;
    get(arg0: Quaternionf_): this;
    rotateX(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveX(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformUnitPositiveY(arg0: Vec4f_): Vec4f;
    identity(): this;
    clone(): any;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateLocalX(arg0: number, arg1: Quaternionf_): this;
    transformUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformInverseUnit(arg0: Vec4f_): Vec4f;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set(arg0: Internal.Quaternionfc_): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    setFromNormalized(arg0: Internal.Matrix4x3dc_): this;
    transformInverseUnit(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveX(arg0: Internal.Vector3d_): Internal.Vector3d;
    transformUnitPositiveY(arg0: Vec3f_): Vec3f;
    rotationAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    get(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    equals(arg0: Internal.Quaternionfc_, arg1: number): boolean;
    scaling(arg0: number): this;
    transformInverse(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    setFromUnnormalized(arg0: Internal.Matrix4x3fc_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    transformUnitPositiveX(arg0: Vec4f_): Vec4f;
    premul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    getAsMatrix4x3f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Quaternionfc_): this;
    rotateY(arg0: number): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Quaternionf_): this;
    rotationX(arg0: number): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    integrate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.AxisAngle4f_): this;
    conjugateBy(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    angle(): number;
    transformInverseUnit(arg0: Internal.Vector4dc_, arg1: Internal.Vector4d_): Internal.Vector4d;
    get(arg0: Matrix3f_): Matrix3f;
    rotateZ(arg0: number, arg1: Quaternionf_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec4f_): Vec4f;
    transformUnitPositiveZ(arg0: Internal.Vector4d_): Internal.Vector4d;
    getAsMatrix4f(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector3d_): Internal.Vector3d;
    rotateX(arg0: number): this;
    difference(arg0: Internal.Quaternionfc_, arg1: Quaternionf_): this;
    transformPositiveX(arg0: Vec3f_): Vec3f;
    set(arg0: Internal.Quaterniondc_): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Quaternionf_): this;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Internal.Vector4d_): Internal.Vector4d;
    nlerpIterative(arg0: Internal.Quaternionfc_, arg1: number, arg2: number): this;
    transform(arg0: Internal.Vector3dc_, arg1: Internal.Vector3d_): Internal.Vector3d;
    transformUnit(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    transformUnitPositiveZ(arg0: Internal.Vector3d_): Internal.Vector3d;
    setFromNormalized(arg0: Internal.Matrix4dc_): this;
    static nlerpIterative(arg0: Quaternionf_[], arg1: number[], arg2: number, arg3: Quaternionf_): Internal.Quaternionfc;
    rotationY(arg0: number): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    transformInverse(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    rotateTo(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Quaternionf_): this;
    transformPositiveX(arg0: Vec4f_): Vec4f;
    set(arg0: Internal.AxisAngle4d_): this;
    setAngleAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    rotateTo(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transformUnitPositiveZ(arg0: Vec4f_): Vec4f;
    get(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotateY(arg0: number, arg1: Quaternionf_): this;
    transformUnitPositiveY(arg0: Internal.Vector4d_): Internal.Vector4d;
    transformInverse(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    set fromUnnormalized(arg0: Internal.Matrix3fc_)
    set fromNormalized(arg0: Internal.Matrix3dc_)
    set fromNormalized(arg0: Internal.Matrix4fc_)
    set fromUnnormalized(arg0: Internal.Matrix3dc_)
    get finite(): boolean
    set fromUnnormalized(arg0: Internal.Matrix4fc_)
    set fromNormalized(arg0: Internal.Matrix3fc_)
    set fromNormalized(arg0: Internal.Matrix4x3fc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3dc_)
    set fromUnnormalized(arg0: Internal.Matrix4dc_)
    set fromNormalized(arg0: Internal.Matrix4x3dc_)
    set fromUnnormalized(arg0: Internal.Matrix4x3fc_)
    set fromNormalized(arg0: Internal.Matrix4dc_)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Quaternionf_ = Quaternionf;
declare class BlockProperties {
    constructor()
    static readonly LEVEL_FLOWING: Internal.IntegerProperty;
    static readonly PERSISTENT: Internal.BooleanProperty;
    static readonly HORIZONTAL_FACING: Internal.DirectionProperty;
    static readonly WEST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CHISELED_BOOKSHELF_SLOT_5_OCCUPIED: Internal.BooleanProperty;
    static readonly NOTE: Internal.IntegerProperty;
    static readonly AGE_5: Internal.IntegerProperty;
    static readonly EGGS: Internal.IntegerProperty;
    static readonly NORTH: Internal.BooleanProperty;
    static readonly HAS_RECORD: Internal.BooleanProperty;
    static readonly SCULK_SENSOR_PHASE: Internal.EnumProperty<Internal.SculkSensorPhase>;
    static readonly EAST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly HALF: Internal.EnumProperty<Internal.Half>;
    static readonly RESPAWN_ANCHOR_CHARGES: Internal.IntegerProperty;
    static readonly HANGING: Internal.BooleanProperty;
    static readonly TILT: Internal.EnumProperty<Internal.Tilt>;
    static readonly STABILITY_DISTANCE: Internal.IntegerProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_4_OCCUPIED: Internal.BooleanProperty;
    static readonly HAS_BOTTLE_2: Internal.BooleanProperty;
    static readonly LAYERS: Internal.IntegerProperty;
    static readonly SOUTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly CRACKED: Internal.BooleanProperty;
    static readonly CONDITIONAL: Internal.BooleanProperty;
    static readonly LOCKED: Internal.BooleanProperty;
    static readonly POWER: Internal.IntegerProperty;
    static readonly EYE: Internal.BooleanProperty;
    static readonly SOUTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly MAX_AGE_1: 1;
    static readonly ATTACHED: Internal.BooleanProperty;
    static readonly MAX_LEVEL_15: 15;
    static readonly BELL_ATTACHMENT: Internal.EnumProperty<Internal.BellAttachType>;
    static readonly MAX_DISTANCE: 7;
    static readonly FLOWER_AMOUNT: Internal.IntegerProperty;
    static readonly EXTENDED: Internal.BooleanProperty;
    static readonly INVERTED: Internal.BooleanProperty;
    static readonly MODE_COMPARATOR: Internal.EnumProperty<Internal.ComparatorMode>;
    static readonly MOISTURE: Internal.IntegerProperty;
    static readonly LIT: Internal.BooleanProperty;
    static readonly DISTANCE: Internal.IntegerProperty;
    static readonly NORTH_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly AGE_3: Internal.IntegerProperty;
    static readonly STAIRS_SHAPE: Internal.EnumProperty<Internal.StairsShape>;
    static readonly MAX_LEVEL_8: 8;
    static readonly MIN_RESPAWN_ANCHOR_CHARGES: 0;
    static readonly BAMBOO_LEAVES: Internal.EnumProperty<Internal.BambooLeaves>;
    static readonly HORIZONTAL_AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly FALLING: Internal.BooleanProperty;
    static readonly ENABLED: Internal.BooleanProperty;
    static readonly ATTACH_FACE: Internal.EnumProperty<Internal.AttachFace>;
    static readonly OPEN: Internal.BooleanProperty;
    static readonly UNSTABLE: Internal.BooleanProperty;
    static readonly AGE_4: Internal.IntegerProperty;
    static readonly EAST: Internal.BooleanProperty;
    static readonly ORIENTATION: Internal.EnumProperty<Internal.FrontAndTop>;
    static readonly DOUBLE_BLOCK_HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    static readonly MAX_RESPAWN_ANCHOR_CHARGES: 4;
    static readonly CHEST_TYPE: Internal.EnumProperty<Internal.ChestType>;
    static readonly MAX_AGE_7: 7;
    static readonly DOWN: Internal.BooleanProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_2_OCCUPIED: Internal.BooleanProperty;
    static readonly AGE_15: Internal.IntegerProperty;
    static readonly STRUCTUREBLOCK_MODE: Internal.EnumProperty<Internal.StructureMode>;
    static readonly SLAB_TYPE: Internal.EnumProperty<Internal.SlabType>;
    static readonly EAST_REDSTONE: Internal.EnumProperty<Internal.RedstoneSide>;
    static readonly WATERLOGGED: Internal.BooleanProperty;
    static readonly BLOOM: Internal.BooleanProperty;
    static readonly SHRIEKING: Internal.BooleanProperty;
    static readonly AGE_1: Internal.IntegerProperty;
    static readonly FACING_HOPPER: Internal.DirectionProperty;
    static readonly VERTICAL_DIRECTION: Internal.DirectionProperty;
    static readonly PICKLES: Internal.IntegerProperty;
    static readonly MAX_AGE_25: 25;
    static readonly LEVEL_HONEY: Internal.IntegerProperty;
    static readonly DUSTED: Internal.IntegerProperty;
    static readonly MAX_AGE_4: 4;
    static readonly PISTON_TYPE: Internal.EnumProperty<Internal.PistonType>;
    static readonly HATCH: Internal.IntegerProperty;
    static readonly SNOWY: Internal.BooleanProperty;
    static readonly TRIGGERED: Internal.BooleanProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_1_OCCUPIED: Internal.BooleanProperty;
    static readonly SIGNAL_FIRE: Internal.BooleanProperty;
    static readonly LEVEL_CAULDRON: Internal.IntegerProperty;
    static readonly AXIS: Internal.EnumProperty<Internal.Direction$Axis>;
    static readonly AGE_2: Internal.IntegerProperty;
    static readonly DRAG: Internal.BooleanProperty;
    static readonly CAN_SUMMON: Internal.BooleanProperty;
    static readonly LEVEL: Internal.IntegerProperty;
    static readonly STAGE: Internal.IntegerProperty;
    static readonly MAX_AGE_5: 5;
    static readonly NORTH_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly UP: Internal.BooleanProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_0_OCCUPIED: Internal.BooleanProperty;
    static readonly BITES: Internal.IntegerProperty;
    static readonly IN_WALL: Internal.BooleanProperty;
    static readonly AGE_25: Internal.IntegerProperty;
    static readonly STABILITY_MAX_DISTANCE: 7;
    static readonly HAS_BOTTLE_1: Internal.BooleanProperty;
    static readonly AGE_7: Internal.IntegerProperty;
    static readonly CHISELED_BOOKSHELF_SLOT_3_OCCUPIED: Internal.BooleanProperty;
    static readonly SOUTH: Internal.BooleanProperty;
    static readonly MAX_AGE_15: 15;
    static readonly DISARMED: Internal.BooleanProperty;
    static readonly RAIL_SHAPE: Internal.EnumProperty<Internal.RailShape>;
    static readonly DOOR_HINGE: Internal.EnumProperty<Internal.DoorHingeSide>;
    static readonly LEVEL_COMPOSTER: Internal.IntegerProperty;
    static readonly DELAY: Internal.IntegerProperty;
    static readonly MIN_LEVEL: 0;
    static readonly RAIL_SHAPE_STRAIGHT: Internal.EnumProperty<Internal.RailShape>;
    static readonly MIN_LEVEL_CAULDRON: 1;
    static readonly BOTTOM: Internal.BooleanProperty;
    static readonly HAS_BOOK: Internal.BooleanProperty;
    static readonly CANDLES: Internal.IntegerProperty;
    static readonly NOTEBLOCK_INSTRUMENT: Internal.EnumProperty<Internal.NoteBlockInstrument>;
    static readonly WEST: Internal.BooleanProperty;
    static readonly SHORT: Internal.BooleanProperty;
    static readonly BERRIES: Internal.BooleanProperty;
    static readonly MAX_AGE_2: 2;
    static readonly HAS_BOTTLE_0: Internal.BooleanProperty;
    static readonly WEST_WALL: Internal.EnumProperty<Internal.WallSide>;
    static readonly ROTATION_16: Internal.IntegerProperty;
    static readonly MAX_LEVEL_3: 3;
    static readonly BED_PART: Internal.EnumProperty<Internal.BedPart>;
    static readonly POWERED: Internal.BooleanProperty;
    static readonly MAX_AGE_3: 3;
    static readonly OCCUPIED: Internal.BooleanProperty;
    static readonly DRIPSTONE_THICKNESS: Internal.EnumProperty<Internal.DripstoneThickness>;
    static readonly FACING: Internal.DirectionProperty;
}
type BlockProperties_ = BlockProperties;
declare class Vec3i implements Internal.Comparable<Vec3i> {
    constructor(arg0: number, arg1: number, arg2: number)
    north(): this;
    distToCenterSqr(arg0: Internal.Position_): number;
    getX(): number;
    getY(): number;
    static offsetCodec(arg0: number): Internal.Codec<Vec3i>;
    south(arg0: number): this;
    toShortString(): string;
    above(arg0: number): this;
    west(arg0: number): this;
    compareTo(arg0: any): number;
    east(arg0: number): this;
    distToLowCornerSqr(arg0: number, arg1: number, arg2: number): number;
    relative(arg0: Internal.Direction_): this;
    multiply(arg0: number): this;
    getZ(): number;
    closerThan(arg0: Vec3i_, arg1: number): boolean;
    below(arg0: number): this;
    offset(arg0: number, arg1: number, arg2: number): this;
    above(): this;
    east(): this;
    north(arg0: number): this;
    below(): this;
    west(): this;
    distManhattan(arg0: Vec3i_): number;
    relative(arg0: Internal.Direction$Axis_, arg1: number): this;
    get(arg0: Internal.Direction$Axis_): number;
    offset(arg0: Vec3i_): this;
    cross(arg0: Vec3i_): this;
    south(): this;
    distSqr(arg0: Vec3i_): number;
    subtract(arg0: Vec3i_): this;
    relative(arg0: Internal.Direction_, arg1: number): this;
    compareTo(arg0: Vec3i_): number;
    closerToCenterThan(arg0: Internal.Position_, arg1: number): boolean;
    distToCenterSqr(arg0: number, arg1: number, arg2: number): number;
    get x(): number
    get y(): number
    get z(): number
    static readonly ZERO: Vec3i;
    static readonly CODEC: Internal.Codec<Vec3i>;
}
type Vec3i_ = Vec3i;
declare class Blocks {
    constructor()
    static lambda$static$4(arg0: Internal.BlockState_): number;
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static log(arg0: Internal.MapColor_, arg1: Internal.MapColor_, arg2: SoundType_): Internal.RotatedPillarBlock;
    static m_187432_(arg0: Internal.BlockState_): number;
    static always(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static rebuildCache(): void;
    static log(arg0: Internal.MapColor_, arg1: Internal.MapColor_): Internal.RotatedPillarBlock;
    static m_181165_(arg0: Internal.BlockState_): number;
    static m_50803_(arg0: Internal.BlockState_): number;
    static m_152681_(arg0: Internal.BlockState_): number;
    static pistonBase(arg0: boolean): Internal.PistonBaseBlock;
    static m_50859_(arg0: Internal.BlockState_): number;
    static lambda$static$0(arg0: Internal.BlockState_): number;
    static stainedGlass(arg0: Internal.DyeColor_): Internal.StainedGlassBlock;
    static lambda$static$2(arg0: Internal.BlockState_): number;
    static lambda$static$14(): Internal.Item;
    static lambda$bed$50(arg0: Internal.DyeColor_, arg1: Internal.BlockState_): Internal.MapColor;
    static m_152691_(arg0: Internal.BlockState_): number;
    static lambda$static$16(): Internal.Item;
    static m_50846_(arg0: Internal.BlockState_): number;
    static m_152662_(arg0: Internal.BlockState_): number;
    static lambda$netherStem$53(arg0: Internal.MapColor_, arg1: Internal.BlockState_): Internal.MapColor;
    static stoneButton(): Internal.ButtonBlock;
    static woodenButton(arg0: Internal.BlockSetType_, ...arg1: Internal.FeatureFlag_[]): Internal.ButtonBlock;
    static lambda$static$22(arg0: Internal.BlockState_): number;
    static m_152631_(arg0: Internal.BlockState_): number;
    static lambda$shulkerBox$54(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static lambda$log$51(arg0: Internal.MapColor_, arg1: Internal.MapColor_, arg2: Internal.BlockState_): Internal.MapColor;
    static lambda$static$24(arg0: Internal.BlockState_): number;
    static litBlockEmission(arg0: number): Internal.ToIntFunction<Internal.BlockState>;
    static netherStem(arg0: Internal.MapColor_): Internal.Block;
    static m_187434_(arg0: Internal.BlockState_): number;
    static m_50873_(arg0: Internal.BlockState_): number;
    static m_50839_(arg0: Internal.BlockState_): number;
    static ocelotOrParrot(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static flowerPot(arg0: Internal.Block_, ...arg1: Internal.FeatureFlag_[]): Internal.FlowerPotBlock;
    static lambda$static$3(arg0: Internal.BlockState_): number;
    static lambda$static$5(arg0: Internal.BlockState_): number;
    static m_187430_(arg0: Internal.BlockState_): number;
    static m_152638_(arg0: Internal.BlockState_): number;
    static m_152650_(arg0: Internal.BlockState_): number;
    static lambda$static$31(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static m_50885_(arg0: Internal.BlockState_): number;
    static lambda$static$13(arg0: Internal.BlockState_): number;
    static lambda$static$36(arg0: Internal.BlockState_): number;
    static m_50857_(arg0: Internal.BlockState_): number;
    static register(arg0: string, arg1: Internal.Block_): Internal.Block;
    static lambda$static$44(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static m_50853_(arg0: Internal.BlockState_): number;
    static m_181167_(arg0: Internal.BlockState_): number;
    static m_152683_(arg0: Internal.BlockState_): number;
    static lambda$static$38(arg0: Internal.BlockState_): number;
    static lambda$static$1(arg0: Internal.BlockState_): number;
    static lambda$static$15(): Internal.Item;
    static never(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static lambda$static$29(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static m_50871_(arg0: Internal.BlockState_): number;
    static lambda$litBlockEmission$49(arg0: number, arg1: Internal.BlockState_): number;
    static lambda$static$17(): Internal.Item;
    static bed(arg0: Internal.DyeColor_): Internal.BedBlock;
    static m_152685_(arg0: Internal.BlockState_): number;
    static m_50827_(arg0: Internal.BlockState_): number;
    static shulkerBox(arg0: Internal.DyeColor_, arg1: Internal.BlockBehaviour$Properties_): Internal.ShulkerBoxBlock;
    static lambda$static$21(arg0: Internal.BlockState_): number;
    static m_152606_(arg0: Internal.BlockState_): number;
    static lambda$static$6(): Internal.BlockEntityType<any>;
    static candle(arg0: Internal.MapColor_): Internal.CandleBlock;
    static lambda$static$8(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static lambda$log$52(arg0: Internal.MapColor_, arg1: Internal.MapColor_, arg2: Internal.BlockState_): Internal.MapColor;
    static lambda$static$23(arg0: Internal.BlockState_): number;
    static leaves(arg0: SoundType_): Internal.LeavesBlock;
    static m_187436_(arg0: Internal.BlockState_): number;
    static lambda$static$7(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static m_50875_(arg0: Internal.BlockState_): number;
    static always(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.EntityType_<any>): boolean;
    static lambda$pistonBase$55(arg0: Internal.BlockState_, arg1: Internal.BlockGetter_, arg2: BlockPos_): boolean;
    static MANGROVE_PROPAGULE: Internal.MangrovePropaguleBlock;
    static STONE_SLAB: Internal.SlabBlock;
    static POTTED_CRIMSON_FUNGUS: Internal.FlowerPotBlock;
    static DEEPSLATE_BRICK_STAIRS: Internal.StairBlock;
    static CHERRY_SAPLING: Internal.SaplingBlock;
    static POLISHED_ANDESITE: Internal.Block;
    static RED_NETHER_BRICKS: Internal.Block;
    static TORCH: Internal.TorchBlock;
    static COAL_BLOCK: Internal.Block;
    static STRIPPED_CRIMSON_STEM: Internal.RotatedPillarBlock;
    static FIRE_CORAL_BLOCK: Internal.CoralBlock;
    static WEEPING_VINES_PLANT: Internal.WeepingVinesPlantBlock;
    static PEONY: Internal.TallFlowerBlock;
    static CARROTS: Internal.CarrotBlock;
    static YELLOW_CANDLE: Internal.CandleBlock;
    static CYAN_STAINED_GLASS: Internal.StainedGlassBlock;
    static BLUE_STAINED_GLASS: Internal.StainedGlassBlock;
    static TUBE_CORAL_BLOCK: Internal.CoralBlock;
    static SMITHING_TABLE: Internal.SmithingTableBlock;
    static ACACIA_TRAPDOOR: Internal.TrapDoorBlock;
    static MAGENTA_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static POTTED_CHERRY_SAPLING: Internal.FlowerPotBlock;
    static PLAYER_WALL_HEAD: Internal.PlayerWallHeadBlock;
    static DEAD_HORN_CORAL_FAN: Internal.BaseCoralFanBlock;
    static MANGROVE_LOG: Internal.RotatedPillarBlock;
    static SPRUCE_BUTTON: Internal.ButtonBlock;
    static IRON_ORE: Internal.DropExperienceBlock;
    static TRIPWIRE: Internal.TripWireBlock;
    static BLACK_CANDLE_CAKE: Internal.CandleCakeBlock;
    static LIGHT_BLUE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static ACACIA_STAIRS: Internal.StairBlock;
    static CRIMSON_FUNGUS: Internal.FungusBlock;
    static BUBBLE_CORAL_BLOCK: Internal.CoralBlock;
    static LIGHT_BLUE_STAINED_GLASS: Internal.StainedGlassBlock;
    static PRISMARINE_SLAB: Internal.SlabBlock;
    static DEAD_TUBE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static PURPLE_BANNER: Internal.BannerBlock;
    static RED_NETHER_BRICK_SLAB: Internal.SlabBlock;
    static SCULK_SENSOR: Internal.SculkSensorBlock;
    static YELLOW_WOOL: Internal.Block;
    static MAGENTA_CANDLE_CAKE: Internal.CandleCakeBlock;
    static SAND: Internal.SandBlock;
    static MYCELIUM: Internal.MyceliumBlock;
    static LIGHT_GRAY_BANNER: Internal.BannerBlock;
    static ORANGE_CANDLE: Internal.CandleBlock;
    static CORNFLOWER: Internal.FlowerBlock;
    static DARK_OAK_DOOR: Internal.DoorBlock;
    static GRANITE_SLAB: Internal.SlabBlock;
    static REDSTONE_LAMP: Internal.RedstoneLampBlock;
    static LIGHT: Internal.LightBlock;
    static TUBE_CORAL_FAN: Internal.CoralFanBlock;
    static WARPED_FENCE_GATE: Internal.FenceGateBlock;
    static DANDELION: Internal.FlowerBlock;
    static PINK_TERRACOTTA: Internal.Block;
    static WARPED_BUTTON: Internal.ButtonBlock;
    static RED_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static SOUL_SOIL: Internal.Block;
    static ACACIA_FENCE: Internal.FenceBlock;
    static CRIMSON_SIGN: Internal.StandingSignBlock;
    static HEAVY_WEIGHTED_PRESSURE_PLATE: Internal.WeightedPressurePlateBlock;
    static PRISMARINE_STAIRS: Internal.StairBlock;
    static TWISTING_VINES_PLANT: Internal.TwistingVinesPlantBlock;
    static DEEPSLATE_BRICK_SLAB: Internal.SlabBlock;
    static WARPED_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static OAK_WOOD: Internal.RotatedPillarBlock;
    static PINK_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static RED_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static WARPED_WART_BLOCK: Internal.Block;
    static EXPOSED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static COARSE_DIRT: Internal.Block;
    static DEEPSLATE_REDSTONE_ORE: Internal.RedStoneOreBlock;
    static TUFF: Internal.Block;
    static CHISELED_BOOKSHELF: Internal.ChiseledBookShelfBlock;
    static ACACIA_LOG: Internal.RotatedPillarBlock;
    static DEEPSLATE_IRON_ORE: Internal.DropExperienceBlock;
    static PURPLE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static LIGHTNING_ROD: Internal.LightningRodBlock;
    static COBBLED_DEEPSLATE_SLAB: Internal.SlabBlock;
    static RED_CARPET: Internal.WoolCarpetBlock;
    static CHERRY_LOG: Internal.RotatedPillarBlock;
    static LILY_PAD: Internal.WaterlilyBlock;
    static GREEN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static BARRIER: Internal.BarrierBlock;
    static PINK_CARPET: Internal.WoolCarpetBlock;
    static DRAGON_HEAD: Internal.SkullBlock;
    static YELLOW_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static DEAD_BUBBLE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static STRIPPED_BIRCH_WOOD: Internal.RotatedPillarBlock;
    static SEAGRASS: Internal.SeagrassBlock;
    static CHERRY_WALL_SIGN: Internal.WallSignBlock;
    static HORN_CORAL: Internal.CoralPlantBlock;
    static MOSSY_STONE_BRICKS: Internal.Block;
    static SPRUCE_SIGN: Internal.StandingSignBlock;
    static WAXED_COPPER_BLOCK: Internal.Block;
    static STONE_BRICK_STAIRS: Internal.StairBlock;
    static GRANITE_WALL: Internal.WallBlock;
    static NETHER_BRICK_FENCE: Internal.FenceBlock;
    static MOSS_CARPET: Internal.CarpetBlock;
    static DARK_OAK_PLANKS: Internal.Block;
    static MAGENTA_WALL_BANNER: Internal.WallBannerBlock;
    static ANDESITE_SLAB: Internal.SlabBlock;
    static RED_NETHER_BRICK_WALL: Internal.WallBlock;
    static BIRCH_DOOR: Internal.DoorBlock;
    static BAMBOO_DOOR: Internal.DoorBlock;
    static BROWN_CONCRETE: Internal.Block;
    static DEEPSLATE_DIAMOND_ORE: Internal.DropExperienceBlock;
    static BEETROOTS: Internal.BeetrootBlock;
    static POTTED_BAMBOO: Internal.FlowerPotBlock;
    static FERN: Internal.TallGrassBlock;
    static CRIMSON_HYPHAE: Internal.RotatedPillarBlock;
    static WAXED_CUT_COPPER: Internal.Block;
    static ACACIA_DOOR: Internal.DoorBlock;
    static BLACK_WOOL: Internal.Block;
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static BRAIN_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static VINE: Internal.VineBlock;
    static CHERRY_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static ANDESITE_STAIRS: Internal.StairBlock;
    static INFESTED_DEEPSLATE: Internal.InfestedRotatedPillarBlock;
    static ACACIA_WALL_SIGN: Internal.WallSignBlock;
    static SPONGE: Internal.SpongeBlock;
    static REDSTONE_ORE: Internal.RedStoneOreBlock;
    static STRIPPED_ACACIA_WOOD: Internal.RotatedPillarBlock;
    static REDSTONE_WALL_TORCH: Internal.RedstoneWallTorchBlock;
    static CYAN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static BLACK_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static CAMPFIRE: Internal.CampfireBlock;
    static OCHRE_FROGLIGHT: Internal.RotatedPillarBlock;
    static COBBLESTONE_STAIRS: Internal.StairBlock;
    static DRAGON_WALL_HEAD: Internal.WallSkullBlock;
    static POTTED_WITHER_ROSE: Internal.FlowerPotBlock;
    static BLACKSTONE_STAIRS: Internal.StairBlock;
    static GRAY_CANDLE: Internal.CandleBlock;
    static CYAN_TERRACOTTA: Internal.Block;
    static BAMBOO_SIGN: Internal.StandingSignBlock;
    static BIRCH_WALL_SIGN: Internal.WallSignBlock;
    static POTTED_CORNFLOWER: Internal.FlowerPotBlock;
    static STICKY_PISTON: Internal.PistonBaseBlock;
    static LIGHT_BLUE_TERRACOTTA: Internal.Block;
    static WEATHERED_COPPER: Internal.WeatheringCopperFullBlock;
    static CYAN_WALL_BANNER: Internal.WallBannerBlock;
    static RAW_GOLD_BLOCK: Internal.Block;
    static STRIPPED_BIRCH_LOG: Internal.RotatedPillarBlock;
    static LARGE_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static POLISHED_ANDESITE_SLAB: Internal.SlabBlock;
    static NETHER_PORTAL: Internal.NetherPortalBlock;
    static JUNGLE_PLANKS: Internal.Block;
    static PINK_TULIP: Internal.FlowerBlock;
    static OAK_SLAB: Internal.SlabBlock;
    static STRIPPED_WARPED_HYPHAE: Internal.RotatedPillarBlock;
    static POTTED_OAK_SAPLING: Internal.FlowerPotBlock;
    static MANGROVE_SLAB: Internal.SlabBlock;
    static DARK_OAK_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static EXPOSED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static ORANGE_CONCRETE: Internal.Block;
    static BLUE_ORCHID: Internal.FlowerBlock;
    static STRIPPED_BAMBOO_BLOCK: Internal.RotatedPillarBlock;
    static BIRCH_LOG: Internal.RotatedPillarBlock;
    static GRAY_STAINED_GLASS: Internal.StainedGlassBlock;
    static DEEPSLATE_TILES: Internal.Block;
    static CRIMSON_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static WHITE_BANNER: Internal.BannerBlock;
    static KELP: Internal.KelpBlock;
    static BROWN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static INFESTED_CRACKED_STONE_BRICKS: Internal.InfestedBlock;
    static JUNGLE_FENCE: Internal.FenceBlock;
    static LIGHT_GRAY_CONCRETE: Internal.Block;
    static RED_MUSHROOM_BLOCK: Internal.HugeMushroomBlock;
    static GRAY_TERRACOTTA: Internal.Block;
    static MOSS_BLOCK: Internal.MossBlock;
    static LIME_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static CRIMSON_STAIRS: Internal.StairBlock;
    static CARVED_PUMPKIN: Internal.EquipableCarvedPumpkinBlock;
    static POTATOES: Internal.PotatoBlock;
    static PURPUR_PILLAR: Internal.RotatedPillarBlock;
    static MUD_BRICKS: Internal.Block;
    static DEAD_FIRE_CORAL_BLOCK: Internal.Block;
    static MANGROVE_WOOD: Internal.RotatedPillarBlock;
    static CHERRY_TRAPDOOR: Internal.TrapDoorBlock;
    static NOTE_BLOCK: Internal.NoteBlock;
    static ENDER_CHEST: Internal.EnderChestBlock;
    static CYAN_BED: Internal.BedBlock;
    static DEAD_TUBE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static BIRCH_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static YELLOW_CONCRETE: Internal.Block;
    static DEAD_TUBE_CORAL_BLOCK: Internal.Block;
    static STRIPPED_WARPED_STEM: Internal.RotatedPillarBlock;
    static LEVER: Internal.LeverBlock;
    static POLISHED_BLACKSTONE: Internal.Block;
    static LIGHT_BLUE_CONCRETE: Internal.Block;
    static POTTED_MANGROVE_PROPAGULE: Internal.FlowerPotBlock;
    static DROPPER: Internal.DropperBlock;
    static SPRUCE_FENCE: Internal.FenceBlock;
    static RED_SANDSTONE_STAIRS: Internal.StairBlock;
    static CRAFTING_TABLE: Internal.CraftingTableBlock;
    static SHULKER_BOX: Internal.ShulkerBoxBlock;
    static GRASS: Internal.TallGrassBlock;
    static CHERRY_SLAB: Internal.SlabBlock;
    static MEDIUM_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static CRIMSON_ROOTS: Internal.RootsBlock;
    static WITHER_ROSE: Internal.WitherRoseBlock;
    static OXEYE_DAISY: Internal.FlowerBlock;
    static OAK_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static EMERALD_BLOCK: Internal.Block;
    static BUDDING_AMETHYST: Internal.BuddingAmethystBlock;
    static RAIL: Internal.RailBlock;
    static JUNGLE_WALL_SIGN: Internal.WallSignBlock;
    static BROWN_MUSHROOM_BLOCK: Internal.HugeMushroomBlock;
    static DARK_OAK_SAPLING: Internal.SaplingBlock;
    static DIAMOND_ORE: Internal.DropExperienceBlock;
    static LADDER: Internal.LadderBlock;
    static OAK_SAPLING: Internal.SaplingBlock;
    static MELON: Internal.MelonBlock;
    static CRIMSON_PLANKS: Internal.Block;
    static GLOW_LICHEN: Internal.GlowLichenBlock;
    static REDSTONE_WIRE: Internal.RedStoneWireBlock;
    static HORN_CORAL_FAN: Internal.CoralFanBlock;
    static DARK_PRISMARINE_SLAB: Internal.SlabBlock;
    static CAVE_VINES_PLANT: Internal.CaveVinesPlantBlock;
    static ACACIA_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static YELLOW_STAINED_GLASS: Internal.StainedGlassBlock;
    static SMOOTH_SANDSTONE_SLAB: Internal.SlabBlock;
    static COBBLED_DEEPSLATE_WALL: Internal.WallBlock;
    static CRIMSON_NYLIUM: Internal.NyliumBlock;
    static POTTED_BLUE_ORCHID: Internal.FlowerPotBlock;
    static CYAN_BANNER: Internal.BannerBlock;
    static SCULK_CATALYST: Internal.SculkCatalystBlock;
    static STRIPPED_MANGROVE_LOG: Internal.RotatedPillarBlock;
    static DISPENSER: Internal.DispenserBlock;
    static PRISMARINE_WALL: Internal.WallBlock;
    static ORANGE_TULIP: Internal.FlowerBlock;
    static COMMAND_BLOCK: Internal.CommandBlock;
    static BLACK_WALL_BANNER: Internal.WallBannerBlock;
    static SPORE_BLOSSOM: Internal.SporeBlossomBlock;
    static OXIDIZED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static DEEPSLATE_TILE_STAIRS: Internal.StairBlock;
    static JUNGLE_STAIRS: Internal.StairBlock;
    static DIRT_PATH: Internal.DirtPathBlock;
    static BLUE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static GREEN_CARPET: Internal.WoolCarpetBlock;
    static HONEYCOMB_BLOCK: Internal.Block;
    static ICE: Internal.IceBlock;
    static BAMBOO_MOSAIC_STAIRS: Internal.StairBlock;
    static POTTED_BIRCH_SAPLING: Internal.FlowerPotBlock;
    static WHITE_CARPET: Internal.WoolCarpetBlock;
    static WATER: Internal.LiquidBlock;
    static CRACKED_NETHER_BRICKS: Internal.Block;
    static WATER_CAULDRON: Internal.LayeredCauldronBlock;
    static MUD_BRICK_SLAB: Internal.SlabBlock;
    static WAXED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static POLISHED_DEEPSLATE_WALL: Internal.WallBlock;
    static OAK_FENCE_GATE: Internal.FenceGateBlock;
    static OAK_LEAVES: Internal.LeavesBlock;
    static POTTED_BROWN_MUSHROOM: Internal.FlowerPotBlock;
    static WARPED_DOOR: Internal.DoorBlock;
    static JUKEBOX: Internal.JukeboxBlock;
    static MANGROVE_FENCE: Internal.FenceBlock;
    static NETHER_BRICKS: Internal.Block;
    static PLAYER_HEAD: Internal.PlayerHeadBlock;
    static PURPLE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static DEAD_TUBE_CORAL: Internal.BaseCoralPlantBlock;
    static BIRCH_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static POWDER_SNOW_CAULDRON: Internal.PowderSnowCauldronBlock;
    static BROWN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static BREWING_STAND: Internal.BrewingStandBlock;
    static POLISHED_BLACKSTONE_BRICK_STAIRS: Internal.StairBlock;
    static REDSTONE_TORCH: Internal.RedstoneTorchBlock;
    static BAMBOO_FENCE_GATE: Internal.FenceGateBlock;
    static BLACK_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static POLISHED_GRANITE_STAIRS: Internal.StairBlock;
    static MAGENTA_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static DEAD_BRAIN_CORAL: Internal.BaseCoralPlantBlock;
    static BLACK_STAINED_GLASS: Internal.StainedGlassBlock;
    static NETHER_SPROUTS: Internal.NetherSproutsBlock;
    static GREEN_CANDLE: Internal.CandleBlock;
    static SPRUCE_LOG: Internal.RotatedPillarBlock;
    static PURPLE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static CONDUIT: Internal.ConduitBlock;
    static ORANGE_WOOL: Internal.Block;
    static POTTED_WHITE_TULIP: Internal.FlowerPotBlock;
    static PRISMARINE_BRICKS: Internal.Block;
    static POLISHED_BLACKSTONE_WALL: Internal.WallBlock;
    static SEA_LANTERN: Internal.Block;
    static MAGENTA_BED: Internal.BedBlock;
    static POLISHED_DEEPSLATE_SLAB: Internal.SlabBlock;
    static STONE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static SCAFFOLDING: Internal.ScaffoldingBlock;
    static NETHER_BRICK_STAIRS: Internal.StairBlock;
    static DIORITE_SLAB: Internal.SlabBlock;
    static PISTON_HEAD: Internal.PistonHeadBlock;
    static BLACK_TERRACOTTA: Internal.Block;
    static PURPLE_WALL_BANNER: Internal.WallBannerBlock;
    static LIME_CANDLE: Internal.CandleBlock;
    static OAK_WALL_SIGN: Internal.WallSignBlock;
    static CUT_RED_SANDSTONE: Internal.Block;
    static DEAD_FIRE_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static LIME_BED: Internal.BedBlock;
    static SPAWNER: Internal.SpawnerBlock;
    static FROSTED_ICE: Internal.FrostedIceBlock;
    static IRON_TRAPDOOR: Internal.TrapDoorBlock;
    static WARPED_ROOTS: Internal.RootsBlock;
    static STONE: Internal.Block;
    static MUD_BRICK_WALL: Internal.WallBlock;
    static SOUL_LANTERN: Internal.LanternBlock;
    static COPPER_BLOCK: Internal.WeatheringCopperFullBlock;
    static WAXED_OXIDIZED_COPPER: Internal.Block;
    static WARPED_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static POLISHED_BASALT: Internal.RotatedPillarBlock;
    static DAYLIGHT_DETECTOR: Internal.DaylightDetectorBlock;
    static CRIMSON_SLAB: Internal.SlabBlock;
    static CHERRY_WOOD: Internal.RotatedPillarBlock;
    static GOLD_BLOCK: Internal.Block;
    static POTTED_LILY_OF_THE_VALLEY: Internal.FlowerPotBlock;
    static LIGHT_BLUE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static LIGHT_GRAY_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static DRIPSTONE_BLOCK: Internal.Block;
    static COBBLED_DEEPSLATE: Internal.Block;
    static BIG_DRIPLEAF: Internal.BigDripleafBlock;
    static MANGROVE_LEAVES: Internal.MangroveLeavesBlock;
    static GRAY_WOOL: Internal.Block;
    static INFESTED_CHISELED_STONE_BRICKS: Internal.InfestedBlock;
    static GRAY_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static CHERRY_SIGN: Internal.StandingSignBlock;
    static REPEATING_COMMAND_BLOCK: Internal.CommandBlock;
    static WARPED_FENCE: Internal.FenceBlock;
    static RED_BED: Internal.BedBlock;
    static CHERRY_DOOR: Internal.DoorBlock;
    static POTTED_DANDELION: Internal.FlowerPotBlock;
    static POTTED_CACTUS: Internal.FlowerPotBlock;
    static DIORITE_WALL: Internal.WallBlock;
    static HOPPER: Internal.HopperBlock;
    static SPRUCE_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static BARREL: Internal.BarrelBlock;
    static MELON_STEM: Internal.StemBlock;
    static ROOTED_DIRT: Internal.RootedDirtBlock;
    static LIGHT_BLUE_WOOL: Internal.Block;
    static SOUL_WALL_TORCH: Internal.WallTorchBlock;
    static LAPIS_BLOCK: Internal.Block;
    static ANDESITE: Internal.Block;
    static YELLOW_BED: Internal.BedBlock;
    static END_STONE_BRICK_STAIRS: Internal.StairBlock;
    static BLAST_FURNACE: Internal.BlastFurnaceBlock;
    static SMALL_DRIPLEAF: Internal.SmallDripleafBlock;
    static KELP_PLANT: Internal.KelpPlantBlock;
    static RED_SAND: Internal.SandBlock;
    static JUNGLE_LOG: Internal.RotatedPillarBlock;
    static QUARTZ_BRICKS: Internal.Block;
    static CRIMSON_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static ZOMBIE_WALL_HEAD: Internal.WallSkullBlock;
    static LIME_TERRACOTTA: Internal.Block;
    static RAW_COPPER_BLOCK: Internal.Block;
    static CHERRY_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static ORANGE_CARPET: Internal.WoolCarpetBlock;
    static LOOM: Internal.LoomBlock;
    static GREEN_WOOL: Internal.Block;
    static BROWN_WOOL: Internal.Block;
    static LIGHT_GRAY_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static PIGLIN_WALL_HEAD: Internal.PiglinWallSkullBlock;
    static BLUE_CANDLE: Internal.CandleBlock;
    static PINK_CANDLE: Internal.CandleBlock;
    static SMOKER: Internal.SmokerBlock;
    static ANVIL: Internal.AnvilBlock;
    static BROWN_CARPET: Internal.WoolCarpetBlock;
    static FLOWER_POT: Internal.FlowerPotBlock;
    static LIGHT_BLUE_BANNER: Internal.BannerBlock;
    static POLISHED_BLACKSTONE_STAIRS: Internal.StairBlock;
    static STONECUTTER: Internal.StonecutterBlock;
    static CUT_RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static RED_CONCRETE: Internal.Block;
    static DARK_OAK_FENCE: Internal.FenceBlock;
    static GREEN_STAINED_GLASS: Internal.StainedGlassBlock;
    static BAMBOO: Internal.BambooStalkBlock;
    static DEAD_HORN_CORAL_BLOCK: Internal.Block;
    static DARK_OAK_WALL_SIGN: Internal.WallSignBlock;
    static MAGENTA_STAINED_GLASS: Internal.StainedGlassBlock;
    static DARK_OAK_SIGN: Internal.StandingSignBlock;
    static CHISELED_RED_SANDSTONE: Internal.Block;
    static CRIMSON_BUTTON: Internal.ButtonBlock;
    static PITCHER_CROP: Internal.PitcherCropBlock;
    static CHERRY_LEAVES: Internal.CherryLeavesBlock;
    static RED_STAINED_GLASS: Internal.StainedGlassBlock;
    static QUARTZ_PILLAR: Internal.RotatedPillarBlock;
    static CHISELED_POLISHED_BLACKSTONE: Internal.Block;
    static DEAD_FIRE_CORAL: Internal.BaseCoralPlantBlock;
    static PURPLE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static RED_CANDLE: Internal.CandleBlock;
    static AMETHYST_CLUSTER: Internal.AmethystClusterBlock;
    static DARK_PRISMARINE: Internal.Block;
    static MANGROVE_WALL_SIGN: Internal.WallSignBlock;
    static SCULK_VEIN: Internal.SculkVeinBlock;
    static JUNGLE_SAPLING: Internal.SaplingBlock;
    static YELLOW_CARPET: Internal.WoolCarpetBlock;
    static OBSERVER: Internal.ObserverBlock;
    static END_STONE_BRICK_WALL: Internal.WallBlock;
    static SPRUCE_LEAVES: Internal.LeavesBlock;
    static MANGROVE_BUTTON: Internal.ButtonBlock;
    static WAXED_EXPOSED_CUT_COPPER: Internal.Block;
    static STONE_BRICK_SLAB: Internal.SlabBlock;
    static BAMBOO_BUTTON: Internal.ButtonBlock;
    static STONE_BRICKS: Internal.Block;
    static SPRUCE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static NETHER_WART: Internal.NetherWartBlock;
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static RED_WALL_BANNER: Internal.WallBannerBlock;
    static OBSIDIAN: Internal.Block;
    static PURPLE_CONCRETE: Internal.Block;
    static BLACK_CONCRETE: Internal.Block;
    static WARPED_SIGN: Internal.StandingSignBlock;
    static REINFORCED_DEEPSLATE: Internal.Block;
    static DRAGON_EGG: Internal.DragonEggBlock;
    static PACKED_MUD: Internal.Block;
    static ACACIA_PLANKS: Internal.Block;
    static RED_CANDLE_CAKE: Internal.CandleCakeBlock;
    static DARK_OAK_STAIRS: Internal.StairBlock;
    static MOSSY_STONE_BRICK_STAIRS: Internal.StairBlock;
    static LIGHT_WEIGHTED_PRESSURE_PLATE: Internal.WeightedPressurePlateBlock;
    static FIRE_CORAL_FAN: Internal.CoralFanBlock;
    static QUARTZ_STAIRS: Internal.StairBlock;
    static PURPUR_STAIRS: Internal.StairBlock;
    static STONE_STAIRS: Internal.StairBlock;
    static STRIPPED_JUNGLE_LOG: Internal.RotatedPillarBlock;
    static RED_WOOL: Internal.Block;
    static FARMLAND: Internal.FarmBlock;
    static DARK_OAK_TRAPDOOR: Internal.TrapDoorBlock;
    static ORANGE_TERRACOTTA: Internal.Block;
    static DEEPSLATE_GOLD_ORE: Internal.DropExperienceBlock;
    static LIGHT_BLUE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static POLISHED_BLACKSTONE_BRICK_WALL: Internal.WallBlock;
    static BRICKS: Internal.Block;
    static WAXED_EXPOSED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static MOSSY_COBBLESTONE_STAIRS: Internal.StairBlock;
    static CAKE: Internal.CakeBlock;
    static GREEN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static JUNGLE_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static BLUE_BED: Internal.BedBlock;
    static OAK_BUTTON: Internal.ButtonBlock;
    static MANGROVE_DOOR: Internal.DoorBlock;
    static DEEPSLATE_BRICKS: Internal.Block;
    static BASALT: Internal.RotatedPillarBlock;
    static REPEATER: Internal.RepeaterBlock;
    static PURPLE_STAINED_GLASS: Internal.StainedGlassBlock;
    static AZURE_BLUET: Internal.FlowerBlock;
    static LILY_OF_THE_VALLEY: Internal.FlowerBlock;
    static STONE_BRICK_WALL: Internal.WallBlock;
    static BIRCH_SAPLING: Internal.SaplingBlock;
    static BIRCH_STAIRS: Internal.StairBlock;
    static LIGHT_BLUE_CARPET: Internal.WoolCarpetBlock;
    static BROWN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static FIRE_CORAL: Internal.CoralPlantBlock;
    static SANDSTONE_WALL: Internal.WallBlock;
    static RESPAWN_ANCHOR: Internal.RespawnAnchorBlock;
    static PRISMARINE_BRICK_SLAB: Internal.SlabBlock;
    static NETHER_BRICK_SLAB: Internal.SlabBlock;
    static NETHERRACK: Internal.NetherrackBlock;
    static CAVE_VINES: Internal.CaveVinesBlock;
    static WARPED_NYLIUM: Internal.NyliumBlock;
    static POTTED_POPPY: Internal.FlowerPotBlock;
    static POINTED_DRIPSTONE: Internal.PointedDripstoneBlock;
    static ORANGE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static LIGHT_GRAY_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static POLISHED_BLACKSTONE_BRICKS: Internal.Block;
    static GLASS: Internal.GlassBlock;
    static WARPED_PLANKS: Internal.Block;
    static WET_SPONGE: Internal.WetSpongeBlock;
    static GRASS_BLOCK: Internal.GrassBlock;
    static COAL_ORE: Internal.DropExperienceBlock;
    static PURPUR_SLAB: Internal.SlabBlock;
    static WARPED_STEM: Internal.RotatedPillarBlock;
    static DEEPSLATE_COPPER_ORE: Internal.DropExperienceBlock;
    static POLISHED_DIORITE_STAIRS: Internal.StairBlock;
    static ANCIENT_DEBRIS: Internal.Block;
    static GRAY_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static DEAD_BRAIN_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static WHITE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static END_STONE_BRICK_SLAB: Internal.SlabBlock;
    static PODZOL: Internal.SnowyDirtBlock;
    static CHERRY_BUTTON: Internal.ButtonBlock;
    static COMPARATOR: Internal.ComparatorBlock;
    static ACACIA_FENCE_GATE: Internal.FenceGateBlock;
    static CHISELED_STONE_BRICKS: Internal.Block;
    static WAXED_WEATHERED_COPPER: Internal.Block;
    static SUGAR_CANE: Internal.SugarCaneBlock;
    static DEAD_BRAIN_CORAL_BLOCK: Internal.Block;
    static NETHERITE_BLOCK: Internal.Block;
    static OAK_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static WHITE_CONCRETE: Internal.Block;
    static POTTED_AZURE_BLUET: Internal.FlowerPotBlock;
    static SANDSTONE_SLAB: Internal.SlabBlock;
    static ORANGE_STAINED_GLASS: Internal.StainedGlassBlock;
    static ORANGE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static BRAIN_CORAL_FAN: Internal.CoralFanBlock;
    static PINK_CANDLE_CAKE: Internal.CandleCakeBlock;
    static OXIDIZED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static GRAY_BED: Internal.BedBlock;
    static GLASS_PANE: Internal.IronBarsBlock;
    static GRAVEL: Internal.GravelBlock;
    static BAMBOO_MOSAIC: Internal.Block;
    static SUSPICIOUS_GRAVEL: Internal.BrushableBlock;
    static ENCHANTING_TABLE: Internal.EnchantmentTableBlock;
    static LILAC: Internal.TallFlowerBlock;
    static STRIPPED_SPRUCE_WOOD: Internal.RotatedPillarBlock;
    static MANGROVE_SIGN: Internal.StandingSignBlock;
    static RED_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static STRIPPED_JUNGLE_WOOD: Internal.RotatedPillarBlock;
    static ALLIUM: Internal.FlowerBlock;
    static MUD_BRICK_STAIRS: Internal.StairBlock;
    static DEAD_BRAIN_CORAL_FAN: Internal.BaseCoralFanBlock;
    static LIGHT_GRAY_STAINED_GLASS: Internal.StainedGlassBlock;
    static ZOMBIE_HEAD: Internal.SkullBlock;
    static WHITE_TULIP: Internal.FlowerBlock;
    static PINK_WALL_BANNER: Internal.WallBannerBlock;
    static MOSSY_COBBLESTONE_WALL: Internal.WallBlock;
    static CRACKED_DEEPSLATE_BRICKS: Internal.Block;
    static WHITE_WOOL: Internal.Block;
    static GREEN_WALL_BANNER: Internal.WallBannerBlock;
    static GRAY_CARPET: Internal.WoolCarpetBlock;
    static BLACK_BANNER: Internal.BannerBlock;
    static TUBE_CORAL: Internal.CoralPlantBlock;
    static JUNGLE_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static CUT_SANDSTONE: Internal.Block;
    static POLISHED_GRANITE: Internal.Block;
    static DARK_OAK_LOG: Internal.RotatedPillarBlock;
    static SKELETON_WALL_SKULL: Internal.WallSkullBlock;
    static TALL_GRASS: Internal.DoublePlantBlock;
    static POTTED_JUNGLE_SAPLING: Internal.FlowerPotBlock;
    static YELLOW_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static PEARLESCENT_FROGLIGHT: Internal.RotatedPillarBlock;
    static DARK_OAK_FENCE_GATE: Internal.FenceGateBlock;
    static MAGENTA_WOOL: Internal.Block;
    static PUMPKIN_STEM: Internal.StemBlock;
    static MUD: Internal.MudBlock;
    static GRINDSTONE: Internal.GrindstoneBlock;
    static LIGHT_BLUE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static BAMBOO_FENCE: Internal.FenceBlock;
    static BLUE_ICE: Internal.HalfTransparentBlock;
    static BROWN_BANNER: Internal.BannerBlock;
    static FLOWERING_AZALEA: Internal.AzaleaBlock;
    static CHERRY_PLANKS: Internal.Block;
    static PACKED_ICE: Internal.Block;
    static ACACIA_SLAB: Internal.SlabBlock;
    static GRAY_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static DARK_OAK_SLAB: Internal.SlabBlock;
    static BLUE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static ORANGE_BANNER: Internal.BannerBlock;
    static BEEHIVE: Internal.BeehiveBlock;
    static PURPLE_CANDLE: Internal.CandleBlock;
    static BLUE_WALL_BANNER: Internal.WallBannerBlock;
    static BLACK_CARPET: Internal.WoolCarpetBlock;
    static WHITE_CANDLE: Internal.CandleBlock;
    static NETHER_GOLD_ORE: Internal.DropExperienceBlock;
    static LODESTONE: Internal.Block;
    static WEEPING_VINES: Internal.WeepingVinesBlock;
    static MAGENTA_CANDLE: Internal.CandleBlock;
    static OAK_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static END_PORTAL: Internal.EndPortalBlock;
    static TINTED_GLASS: Internal.TintedGlassBlock;
    static LIME_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static SKELETON_SKULL: Internal.SkullBlock;
    static LIME_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static END_STONE: Internal.Block;
    static JUNGLE_FENCE_GATE: Internal.FenceGateBlock;
    static TWISTING_VINES: Internal.TwistingVinesBlock;
    static END_PORTAL_FRAME: Internal.EndPortalFrameBlock;
    static CRIMSON_WALL_SIGN: Internal.WallSignBlock;
    static SPRUCE_PLANKS: Internal.Block;
    static POLISHED_GRANITE_SLAB: Internal.SlabBlock;
    static YELLOW_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static SNIFFER_EGG: Internal.SnifferEggBlock;
    static MOSSY_COBBLESTONE_SLAB: Internal.SlabBlock;
    static CHERRY_FENCE_GATE: Internal.FenceGateBlock;
    static ORANGE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static LIGHT_BLUE_WALL_BANNER: Internal.WallBannerBlock;
    static ACACIA_LEAVES: Internal.LeavesBlock;
    static GRAY_CANDLE_CAKE: Internal.CandleCakeBlock;
    static GRAY_BANNER: Internal.BannerBlock;
    static BIRCH_SLAB: Internal.SlabBlock;
    static CRACKED_DEEPSLATE_TILES: Internal.Block;
    static HANGING_ROOTS: Internal.HangingRootsBlock;
    static TURTLE_EGG: Internal.TurtleEggBlock;
    static BLACKSTONE_WALL: Internal.WallBlock;
    static SMOOTH_RED_SANDSTONE: Internal.Block;
    static BAMBOO_SAPLING: Internal.BambooSaplingBlock;
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static WHITE_BED: Internal.BedBlock;
    static CANDLE_CAKE: Internal.CandleCakeBlock;
    static DETECTOR_RAIL: Internal.DetectorRailBlock;
    static COPPER_ORE: Internal.DropExperienceBlock;
    static CAULDRON: Internal.CauldronBlock;
    static LANTERN: Internal.LanternBlock;
    static GLOWSTONE: Internal.Block;
    static YELLOW_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static VOID_AIR: Internal.AirBlock;
    static PURPUR_BLOCK: Internal.Block;
    static INFESTED_STONE: Internal.InfestedBlock;
    static CHAIN: Internal.ChainBlock;
    static STRIPPED_SPRUCE_LOG: Internal.RotatedPillarBlock;
    static OAK_SIGN: Internal.StandingSignBlock;
    static OAK_DOOR: Internal.DoorBlock;
    static MAGMA_BLOCK: Internal.MagmaBlock;
    static DIORITE_STAIRS: Internal.StairBlock;
    static RED_SANDSTONE_WALL: Internal.WallBlock;
    static LAPIS_ORE: Internal.DropExperienceBlock;
    static SPRUCE_SAPLING: Internal.SaplingBlock;
    static SMOOTH_STONE: Internal.Block;
    static BUBBLE_COLUMN: Internal.BubbleColumnBlock;
    static CANDLE: Internal.CandleBlock;
    static POLISHED_DIORITE: Internal.Block;
    static BIRCH_WOOD: Internal.RotatedPillarBlock;
    static AIR: Internal.AirBlock;
    static AZALEA_LEAVES: Internal.LeavesBlock;
    static WHITE_STAINED_GLASS: Internal.StainedGlassBlock;
    static CAVE_AIR: Internal.AirBlock;
    static MOSSY_COBBLESTONE: Internal.Block;
    static OAK_FENCE: Internal.FenceBlock;
    static BAMBOO_SLAB: Internal.SlabBlock;
    static EMERALD_ORE: Internal.DropExperienceBlock;
    static CYAN_WOOL: Internal.Block;
    static BIRCH_PLANKS: Internal.Block;
    static POTTED_ORANGE_TULIP: Internal.FlowerPotBlock;
    static POTTED_WARPED_ROOTS: Internal.FlowerPotBlock;
    static SPRUCE_TRAPDOOR: Internal.TrapDoorBlock;
    static DARK_PRISMARINE_STAIRS: Internal.StairBlock;
    static SMALL_AMETHYST_BUD: Internal.AmethystClusterBlock;
    static SPRUCE_STAIRS: Internal.StairBlock;
    static WITHER_SKELETON_SKULL: Internal.WitherSkullBlock;
    static BUBBLE_CORAL_FAN: Internal.CoralFanBlock;
    static CREEPER_WALL_HEAD: Internal.WallSkullBlock;
    static STRIPPED_OAK_LOG: Internal.RotatedPillarBlock;
    static ACACIA_WOOD: Internal.RotatedPillarBlock;
    static CHAIN_COMMAND_BLOCK: Internal.CommandBlock;
    static PIGLIN_HEAD: Internal.SkullBlock;
    static MANGROVE_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static INFESTED_MOSSY_STONE_BRICKS: Internal.InfestedBlock;
    static BROWN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static BLUE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static ACACIA_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static CYAN_CANDLE: Internal.CandleBlock;
    static FLETCHING_TABLE: Internal.FletchingTableBlock;
    static TORCHFLOWER_CROP: Internal.TorchflowerCropBlock;
    static GRAY_CONCRETE: Internal.Block;
    static WARPED_STAIRS: Internal.StairBlock;
    static HORN_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static BROWN_WALL_BANNER: Internal.WallBannerBlock;
    static END_GATEWAY: Internal.EndGatewayBlock;
    static DEEPSLATE_TILE_WALL: Internal.WallBlock;
    static POTTED_ALLIUM: Internal.FlowerPotBlock;
    static COBBLESTONE: Internal.Block;
    static OAK_TRAPDOOR: Internal.TrapDoorBlock;
    static CALCITE: Internal.Block;
    static MANGROVE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static POTTED_OXEYE_DAISY: Internal.FlowerPotBlock;
    static FIRE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static OAK_LOG: Internal.RotatedPillarBlock;
    static STRIPPED_CRIMSON_HYPHAE: Internal.RotatedPillarBlock;
    static BIRCH_TRAPDOOR: Internal.TrapDoorBlock;
    static TERRACOTTA: Internal.Block;
    static JUNGLE_SLAB: Internal.SlabBlock;
    static NETHER_BRICK_WALL: Internal.WallBlock;
    static CYAN_CARPET: Internal.WoolCarpetBlock;
    static BAMBOO_TRAPDOOR: Internal.TrapDoorBlock;
    static END_ROD: Internal.EndRodBlock;
    static LIGHT_BLUE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static SMOOTH_QUARTZ: Internal.Block;
    static PRISMARINE: Internal.Block;
    static SMOOTH_QUARTZ_STAIRS: Internal.StairBlock;
    static NETHER_QUARTZ_ORE: Internal.DropExperienceBlock;
    static MUDDY_MANGROVE_ROOTS: Internal.RotatedPillarBlock;
    static LIGHT_GRAY_CANDLE: Internal.CandleBlock;
    static MANGROVE_TRAPDOOR: Internal.TrapDoorBlock;
    static DEEPSLATE_TILE_SLAB: Internal.SlabBlock;
    static ATTACHED_PUMPKIN_STEM: Internal.AttachedStemBlock;
    static CYAN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static OXIDIZED_COPPER: Internal.WeatheringCopperFullBlock;
    static POLISHED_DEEPSLATE_STAIRS: Internal.StairBlock;
    static POLISHED_BLACKSTONE_BRICK_SLAB: Internal.SlabBlock;
    static POLISHED_DEEPSLATE: Internal.Block;
    static COCOA: Internal.CocoaBlock;
    static JUNGLE_BUTTON: Internal.ButtonBlock;
    static BIRCH_FENCE_GATE: Internal.FenceGateBlock;
    static SPRUCE_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static POTTED_RED_MUSHROOM: Internal.FlowerPotBlock;
    static MAGENTA_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static JUNGLE_WOOD: Internal.RotatedPillarBlock;
    static WARPED_TRAPDOOR: Internal.TrapDoorBlock;
    static CRIMSON_TRAPDOOR: Internal.TrapDoorBlock;
    static CHEST: Internal.ChestBlock;
    static SPRUCE_WOOD: Internal.RotatedPillarBlock;
    static PINK_STAINED_GLASS: Internal.StainedGlassBlock;
    static BLACKSTONE_SLAB: Internal.SlabBlock;
    static LIME_STAINED_GLASS: Internal.StainedGlassBlock;
    static GILDED_BLACKSTONE: Internal.Block;
    static SUNFLOWER: Internal.TallFlowerBlock;
    static ORANGE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static VERDANT_FROGLIGHT: Internal.RotatedPillarBlock;
    static PETRIFIED_OAK_SLAB: Internal.SlabBlock;
    static RED_NETHER_BRICK_STAIRS: Internal.StairBlock;
    static DRIED_KELP_BLOCK: Internal.Block;
    static BONE_BLOCK: Internal.RotatedPillarBlock;
    static WHITE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static POTTED_SPRUCE_SAPLING: Internal.FlowerPotBlock;
    static DEAD_HORN_CORAL: Internal.BaseCoralPlantBlock;
    static BUBBLE_CORAL: Internal.CoralPlantBlock;
    static GREEN_CONCRETE: Internal.Block;
    static CHORUS_FLOWER: Internal.ChorusFlowerBlock;
    static GRAY_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static SMOOTH_SANDSTONE_STAIRS: Internal.StairBlock;
    static RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static YELLOW_BANNER: Internal.BannerBlock;
    static LIGHT_GRAY_TERRACOTTA: Internal.Block;
    static PINK_WOOL: Internal.Block;
    static PINK_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static CYAN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static DARK_OAK_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static POWERED_RAIL: Internal.PoweredRailBlock;
    static LIGHT_BLUE_CANDLE: Internal.CandleBlock;
    static POWDER_SNOW: Internal.PowderSnowBlock;
    static ORANGE_WALL_BANNER: Internal.WallBannerBlock;
    static PINK_BANNER: Internal.BannerBlock;
    static BLACK_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static SPRUCE_FENCE_GATE: Internal.FenceGateBlock;
    static GRAY_WALL_BANNER: Internal.WallBannerBlock;
    static WARPED_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static JIGSAW: Internal.JigsawBlock;
    static WHITE_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static SPRUCE_SLAB: Internal.SlabBlock;
    static LIGHT_GRAY_WOOL: Internal.Block;
    static PISTON: Internal.PistonBaseBlock;
    static SMOOTH_RED_SANDSTONE_STAIRS: Internal.StairBlock;
    static CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static DIRT: Internal.Block;
    static BLUE_CONCRETE: Internal.Block;
    static RED_TERRACOTTA: Internal.Block;
    static DEAD_BUBBLE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static OXIDIZED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static TALL_SEAGRASS: Internal.TallSeagrassBlock;
    static CHORUS_PLANT: Internal.ChorusPlantBlock;
    static PINK_CONCRETE: Internal.Block;
    static WHITE_TERRACOTTA: Internal.Block;
    static MOVING_PISTON: Internal.MovingPistonBlock;
    static CHERRY_FENCE: Internal.FenceBlock;
    static MANGROVE_ROOTS: Internal.MangroveRootsBlock;
    static POTTED_ACACIA_SAPLING: Internal.FlowerPotBlock;
    static MANGROVE_PLANKS: Internal.Block;
    static ACACIA_BUTTON: Internal.ButtonBlock;
    static WAXED_OXIDIZED_CUT_COPPER: Internal.Block;
    static BAMBOO_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static RED_BANNER: Internal.BannerBlock;
    static BLUE_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static BELL: Internal.BellBlock;
    static MUSHROOM_STEM: Internal.HugeMushroomBlock;
    static EXPOSED_COPPER: Internal.WeatheringCopperFullBlock;
    static CYAN_CONCRETE: Internal.Block;
    static POTTED_CRIMSON_ROOTS: Internal.FlowerPotBlock;
    static GREEN_TERRACOTTA: Internal.Block;
    static CHISELED_QUARTZ_BLOCK: Internal.Block;
    static JUNGLE_LEAVES: Internal.LeavesBlock;
    static FROGSPAWN: Internal.FrogspawnBlock;
    static SOUL_TORCH: Internal.TorchBlock;
    static BOOKSHELF: Internal.Block;
    static WAXED_EXPOSED_COPPER: Internal.Block;
    static CRIMSON_FENCE: Internal.FenceBlock;
    static DIAMOND_BLOCK: Internal.Block;
    static RED_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static CRIMSON_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static SANDSTONE_STAIRS: Internal.StairBlock;
    static MAGENTA_CARPET: Internal.WoolCarpetBlock;
    static STRIPPED_DARK_OAK_WOOD: Internal.RotatedPillarBlock;
    static DEAD_BUBBLE_CORAL_BLOCK: Internal.Block;
    static SPRUCE_WALL_SIGN: Internal.WallSignBlock;
    static BLUE_BANNER: Internal.BannerBlock;
    static STRIPPED_CHERRY_LOG: Internal.RotatedPillarBlock;
    static POLISHED_BLACKSTONE_SLAB: Internal.SlabBlock;
    static CALIBRATED_SCULK_SENSOR: Internal.CalibratedSculkSensorBlock;
    static AMETHYST_BLOCK: Internal.AmethystBlock;
    static STRUCTURE_BLOCK: Internal.StructureBlock;
    static BAMBOO_WALL_SIGN: Internal.WallSignBlock;
    static BRAIN_CORAL_BLOCK: Internal.CoralBlock;
    static BAMBOO_MOSAIC_SLAB: Internal.SlabBlock;
    static STRIPPED_DARK_OAK_LOG: Internal.RotatedPillarBlock;
    static SMOOTH_SANDSTONE: Internal.Block;
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static BLUE_WOOL: Internal.Block;
    static IRON_BARS: Internal.IronBarsBlock;
    static IRON_BLOCK: Internal.Block;
    static SUSPICIOUS_SAND: Internal.BrushableBlock;
    static HORN_CORAL_BLOCK: Internal.CoralBlock;
    static MAGENTA_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static HONEY_BLOCK: Internal.HoneyBlock;
    static END_STONE_BRICKS: Internal.Block;
    static JACK_O_LANTERN: Internal.CarvedPumpkinBlock;
    static TARGET: Internal.TargetBlock;
    static BRAIN_CORAL: Internal.CoralPlantBlock;
    static DEAD_FIRE_CORAL_FAN: Internal.BaseCoralFanBlock;
    static MOSSY_STONE_BRICK_SLAB: Internal.SlabBlock;
    static BLUE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static WITHER_SKELETON_WALL_SKULL: Internal.WitherWallSkullBlock;
    static CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static BIRCH_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static ROSE_BUSH: Internal.TallFlowerBlock;
    static YELLOW_TERRACOTTA: Internal.Block;
    static LECTERN: Internal.LecternBlock;
    static CRIMSON_FENCE_GATE: Internal.FenceGateBlock;
    static DAMAGED_ANVIL: Internal.AnvilBlock;
    static POLISHED_BLACKSTONE_BUTTON: Internal.ButtonBlock;
    static POLISHED_DIORITE_SLAB: Internal.SlabBlock;
    static HAY_BLOCK: Internal.HayBlock;
    static WARPED_HYPHAE: Internal.RotatedPillarBlock;
    static CHERRY_WALL_HANGING_SIGN: Internal.WallHangingSignBlock;
    static MANGROVE_STAIRS: Internal.StairBlock;
    static WEATHERED_CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static LIME_BANNER: Internal.BannerBlock;
    static TRIPWIRE_HOOK: Internal.TripWireHookBlock;
    static CLAY: Internal.Block;
    static SNOW: Internal.SnowLayerBlock;
    static WHEAT: Internal.CropBlock;
    static CYAN_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static WEATHERED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static BROWN_MUSHROOM: Internal.MushroomBlock;
    static SHROOMLIGHT: Internal.Block;
    static CRIMSON_DOOR: Internal.DoorBlock;
    static PRISMARINE_BRICK_STAIRS: Internal.StairBlock;
    static POPPY: Internal.FlowerBlock;
    static STRUCTURE_VOID: Internal.StructureVoidBlock;
    static ORANGE_BED: Internal.BedBlock;
    static DEEPSLATE_COAL_ORE: Internal.DropExperienceBlock;
    static PURPLE_TERRACOTTA: Internal.Block;
    static CUT_COPPER_SLAB: Internal.WeatheringCopperSlabBlock;
    static REDSTONE_BLOCK: Internal.PoweredBlock;
    static BLACK_CANDLE: Internal.CandleBlock;
    static WAXED_CUT_COPPER_STAIRS: Internal.StairBlock;
    static GREEN_BANNER: Internal.BannerBlock;
    static POTTED_AZALEA: Internal.FlowerPotBlock;
    static LIME_CONCRETE: Internal.Block;
    static BAMBOO_BLOCK: Internal.RotatedPillarBlock;
    static PURPLE_WOOL: Internal.Block;
    static SOUL_FIRE: Internal.SoulFireBlock;
    static CHISELED_NETHER_BRICKS: Internal.Block;
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: Internal.Block;
    static PINK_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static CARTOGRAPHY_TABLE: Internal.CartographyTableBlock;
    static BLACK_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static GREEN_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static CYAN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static QUARTZ_BLOCK: Internal.Block;
    static BAMBOO_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static WHITE_CANDLE_CAKE: Internal.CandleCakeBlock;
    static WAXED_WEATHERED_CUT_COPPER: Internal.Block;
    static WARPED_WALL_SIGN: Internal.WallSignBlock;
    static COMPOSTER: Internal.ComposterBlock;
    static DARK_OAK_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static ACACIA_SAPLING: Internal.SaplingBlock;
    static PITCHER_PLANT: Internal.DoublePlantBlock;
    static CHISELED_SANDSTONE: Internal.Block;
    static POTTED_PINK_TULIP: Internal.FlowerPotBlock;
    static LARGE_FERN: Internal.DoublePlantBlock;
    static TNT: Internal.TntBlock;
    static COBBLED_DEEPSLATE_STAIRS: Internal.StairBlock;
    static BRICK_STAIRS: Internal.StairBlock;
    static WARPED_SLAB: Internal.SlabBlock;
    static SMOOTH_QUARTZ_SLAB: Internal.SlabBlock;
    static LAVA_CAULDRON: Internal.LavaCauldronBlock;
    static SCULK_SHRIEKER: Internal.SculkShriekerBlock;
    static BRICK_WALL: Internal.WallBlock;
    static CHISELED_DEEPSLATE: Internal.Block;
    static AZALEA: Internal.AzaleaBlock;
    static SMOOTH_STONE_SLAB: Internal.SlabBlock;
    static JUNGLE_SIGN: Internal.StandingSignBlock;
    static LIME_WOOL: Internal.Block;
    static LIME_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static GREEN_BED: Internal.BedBlock;
    static ACTIVATOR_RAIL: Internal.PoweredRailBlock;
    static SEA_PICKLE: Internal.SeaPickleBlock;
    static PINK_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static BLUE_TERRACOTTA: Internal.Block;
    static WEATHERED_CUT_COPPER_STAIRS: Internal.WeatheringCopperStairBlock;
    static CRACKED_STONE_BRICKS: Internal.Block;
    static FURNACE: Internal.FurnaceBlock;
    static COBBLESTONE_SLAB: Internal.SlabBlock;
    static MANGROVE_FENCE_GATE: Internal.FenceGateBlock;
    static CHERRY_STAIRS: Internal.StairBlock;
    static BAMBOO_STAIRS: Internal.StairBlock;
    static LIGHT_GRAY_CARPET: Internal.WoolCarpetBlock;
    static MANGROVE_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static COBBLESTONE_WALL: Internal.WallBlock;
    static BEDROCK: Internal.Block;
    static BIRCH_LEAVES: Internal.LeavesBlock;
    static PURPLE_BED: Internal.BedBlock;
    static LIME_WALL_BANNER: Internal.WallBannerBlock;
    static RED_SANDSTONE: Internal.Block;
    static GOLD_ORE: Internal.DropExperienceBlock;
    static SCULK: Internal.SculkBlock;
    static ACACIA_SIGN: Internal.StandingSignBlock;
    static COBWEB: Internal.WebBlock;
    static CRIMSON_STEM: Internal.RotatedPillarBlock;
    static PINK_BED: Internal.BedBlock;
    static STRIPPED_ACACIA_LOG: Internal.RotatedPillarBlock;
    static BEE_NEST: Internal.BeehiveBlock;
    static LAVA: Internal.LiquidBlock;
    static POTTED_WARPED_FUNGUS: Internal.FlowerPotBlock;
    static NETHER_WART_BLOCK: Internal.Block;
    static TORCHFLOWER: Internal.FlowerBlock;
    static ATTACHED_MELON_STEM: Internal.AttachedStemBlock;
    static DEEPSLATE_EMERALD_ORE: Internal.DropExperienceBlock;
    static BROWN_CANDLE_CAKE: Internal.CandleCakeBlock;
    static POTTED_DARK_OAK_SAPLING: Internal.FlowerPotBlock;
    static POTTED_FERN: Internal.FlowerPotBlock;
    static PUMPKIN: Internal.PumpkinBlock;
    static EXPOSED_CUT_COPPER: Internal.WeatheringCopperFullBlock;
    static RED_MUSHROOM: Internal.MushroomBlock;
    static BROWN_TERRACOTTA: Internal.Block;
    static PURPLE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static ORANGE_SHULKER_BOX: Internal.ShulkerBoxBlock;
    static RAW_IRON_BLOCK: Internal.Block;
    static WALL_TORCH: Internal.WallTorchBlock;
    static CACTUS: Internal.CactusBlock;
    static FIRE: Internal.FireBlock;
    static SLIME_BLOCK: Internal.SlimeBlock;
    static CHIPPED_ANVIL: Internal.AnvilBlock;
    static QUARTZ_SLAB: Internal.SlabBlock;
    static LIGHT_BLUE_BED: Internal.BedBlock;
    static GREEN_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static JUNGLE_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static SOUL_SAND: Internal.SoulSandBlock;
    static CUT_SANDSTONE_SLAB: Internal.SlabBlock;
    static MAGENTA_CONCRETE: Internal.Block;
    static GRANITE: Internal.Block;
    static LIGHT_GRAY_STAINED_GLASS_PANE: Internal.StainedGlassPaneBlock;
    static SMOOTH_BASALT: Internal.Block;
    static DEAD_BUSH: Internal.DeadBushBlock;
    static DARK_OAK_LEAVES: Internal.LeavesBlock;
    static SOUL_CAMPFIRE: Internal.CampfireBlock;
    static MAGENTA_BANNER: Internal.BannerBlock;
    static SPRUCE_DOOR: Internal.DoorBlock;
    static CREEPER_HEAD: Internal.SkullBlock;
    static BROWN_CANDLE: Internal.CandleBlock;
    static YELLOW_WALL_BANNER: Internal.WallBannerBlock;
    static DEAD_BUBBLE_CORAL: Internal.BaseCoralPlantBlock;
    static BLUE_CARPET: Internal.WoolCarpetBlock;
    static BRICK_SLAB: Internal.SlabBlock;
    static JUNGLE_DOOR: Internal.DoorBlock;
    static LIME_CANDLE_CAKE: Internal.CandleCakeBlock;
    static ACACIA_HANGING_SIGN: Internal.CeilingHangingSignBlock;
    static MOSSY_STONE_BRICK_WALL: Internal.WallBlock;
    static TUBE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static BROWN_BED: Internal.BedBlock;
    static PURPLE_CARPET: Internal.WoolCarpetBlock;
    static LIGHT_GRAY_WALL_BANNER: Internal.WallBannerBlock;
    static BIG_DRIPLEAF_STEM: Internal.BigDripleafStemBlock;
    static LIME_CARPET: Internal.WoolCarpetBlock;
    static WARPED_FUNGUS: Internal.FungusBlock;
    static WHITE_WALL_BANNER: Internal.WallBannerBlock;
    static DARK_OAK_WOOD: Internal.RotatedPillarBlock;
    static STRIPPED_MANGROVE_WOOD: Internal.RotatedPillarBlock;
    static CRYING_OBSIDIAN: Internal.CryingObsidianBlock;
    static WAXED_WEATHERED_CUT_COPPER_SLAB: Internal.SlabBlock;
    static MAGENTA_TERRACOTTA: Internal.Block;
    static POTTED_TORCHFLOWER: Internal.FlowerPotBlock;
    static STONE_BUTTON: Internal.ButtonBlock;
    static IRON_DOOR: Internal.DoorBlock;
    static TRAPPED_CHEST: Internal.TrappedChestBlock;
    static LIGHT_GRAY_CANDLE_CAKE: Internal.CandleCakeBlock;
    static OAK_PLANKS: Internal.Block;
    static FLOWERING_AZALEA_LEAVES: Internal.LeavesBlock;
    static POTTED_FLOWERING_AZALEA: Internal.FlowerPotBlock;
    static POLISHED_ANDESITE_STAIRS: Internal.StairBlock;
    static BUBBLE_CORAL_WALL_FAN: Internal.CoralWallFanBlock;
    static ANDESITE_WALL: Internal.WallBlock;
    static YELLOW_CANDLE_CAKE: Internal.CandleCakeBlock;
    static BIRCH_SIGN: Internal.StandingSignBlock;
    static DEEPSLATE_BRICK_WALL: Internal.WallBlock;
    static SMOOTH_RED_SANDSTONE_SLAB: Internal.SlabBlock;
    static BLACKSTONE: Internal.Block;
    static LIGHT_GRAY_BED: Internal.BedBlock;
    static STRIPPED_OAK_WOOD: Internal.RotatedPillarBlock;
    static PINK_PETALS: Internal.PinkPetalsBlock;
    static DIORITE: Internal.Block;
    static SWEET_BERRY_BUSH: Internal.SweetBerryBushBlock;
    static DECORATED_POT: Internal.DecoratedPotBlock;
    static INFESTED_STONE_BRICKS: Internal.InfestedBlock;
    static POTTED_RED_TULIP: Internal.FlowerPotBlock;
    static RED_TULIP: Internal.FlowerBlock;
    static BAMBOO_PLANKS: Internal.Block;
    static BIRCH_BUTTON: Internal.ButtonBlock;
    static JUNGLE_TRAPDOOR: Internal.TrapDoorBlock;
    static GREEN_GLAZED_TERRACOTTA: Internal.GlazedTerracottaBlock;
    static BEACON: Internal.BeaconBlock;
    static DEEPSLATE_LAPIS_ORE: Internal.DropExperienceBlock;
    static OAK_STAIRS: Internal.StairBlock;
    static BIRCH_FENCE: Internal.FenceBlock;
    static SANDSTONE: Internal.Block;
    static SNOW_BLOCK: Internal.Block;
    static BLACK_BED: Internal.BedBlock;
    static BROWN_STAINED_GLASS: Internal.StainedGlassBlock;
    static POTTED_DEAD_BUSH: Internal.FlowerPotBlock;
    static STRIPPED_CHERRY_WOOD: Internal.RotatedPillarBlock;
    static GRANITE_STAIRS: Internal.StairBlock;
    static DEEPSLATE: Internal.RotatedPillarBlock;
    static DARK_OAK_BUTTON: Internal.ButtonBlock;
    static WHITE_CONCRETE_POWDER: Internal.ConcretePowderBlock;
    static DEAD_HORN_CORAL_WALL_FAN: Internal.BaseCoralWallFanBlock;
    static BAMBOO_PRESSURE_PLATE: Internal.PressurePlateBlock;
    static INFESTED_COBBLESTONE: Internal.InfestedBlock;
}
type Blocks_ = Blocks;
declare interface BlockStatePredicate extends Internal.ReplacementMatch, Internal.Predicate<Internal.BlockState> {
    fromString(s: string): this;
    asRuleTest(): Internal.RuleTest;
    ruleTestOf(o: any): Internal.RuleTest;
    getBlockIds(): Internal.Set<ResourceLocation>;
    not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
    check(targetStates: Internal.List_<Internal.OreConfiguration$TargetBlockState>): boolean;
    abstract test(arg0: Internal.BlockState_): boolean;
    getBlockStates(): Internal.Collection<Internal.BlockState>;
    getBlocks(): Internal.Collection<Internal.Block>;
    isEqual<T>(arg0: any): Internal.Predicate<T>;
    testBlock(block: Internal.Block_): boolean;
    of(o: BlockStatePredicate_): this;
    test(arg0: any): boolean;
    and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    negate(): Internal.Predicate<Internal.BlockState>;
    or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
    get blockIds(): Internal.Set<ResourceLocation>
    get blockStates(): Internal.Collection<Internal.BlockState>
    get blocks(): Internal.Collection<Internal.Block>
    (arg0: Internal.BlockState): boolean;
    readonly AIR_ID: ResourceLocation;
}
type BlockStatePredicate_ = RegExp | "-" | `#${Special.BlockTag}` | BlockStatePredicate_[] | Internal.Block_ | Internal.BlockState_ | "*" | BlockStatePredicate | {not?: BlockStatePredicate_, or?: BlockStatePredicate_};
declare const BlockStatePredicate: BlockStatePredicate;
declare class KMath {
    constructor()
    static lerp(value: number, min0: number, max0: number, min1: number, max1: number): number;
    static v3f(x: number, y: number, z: number): Vec3f;
    static block(x: number, y: number, z: number): BlockPos;
    static deg(value: number): number;
    static m4f(): Matrix4f;
    static rotateIfNecessary(current: number, target: number, max: number): number;
    static v3d(x: number, y: number, z: number): Internal.Vector3d;
    static ceil(value: number): number;
    static clamp(value: number, min: number, max: number): number;
    static v4f(x: number, y: number, z: number, w: number): Vec4f;
    static v3(x: number, y: number, z: number): Vec3d;
    static rad(value: number): number;
    static quaternion(x: number, y: number, z: number, w: number): Quaternionf;
    static wrapDegrees(d: number): number;
    static degreesDifference(current: number, target: number): number;
    static m3f(): Matrix3f;
    static approachDegrees(current: number, target: number, speed: number): number;
    static clampedLerp(value: number, min: number, max: number): number;
    static poseStack(): Internal.PoseStack;
    static floor(value: number): number;
    static approach(current: number, target: number, speed: number): number;
    static lerp(value: number, min: number, max: number): number;
    static isPowerOfTwo(value: number): boolean;
    static readonly PI: 3.141592653589793;
    static readonly RADIANS_TO_DEGREES: 57.29577951308232;
    static readonly DEGREES_TO_RADIANS: 0.017453292519943295;
    static readonly E: 2.718281828459045;
}
type KMath_ = KMath;
declare class Items {
    constructor()
    static registerItem(arg0: ResourceLocation_, arg1: Internal.Item_): Internal.Item;
    static registerBlock(arg0: Internal.Block_, ...arg1: Internal.Block_[]): Internal.Item;
    static registerBlock(arg0: Internal.Block_, arg1: Internal.Item_): Internal.Item;
    static registerItem(arg0: string, arg1: Internal.Item_): Internal.Item;
    static registerBlock(arg0: Internal.Block_): Internal.Item;
    static registerItem(arg0: Internal.ResourceKey_<Internal.Item>, arg1: Internal.Item_): Internal.Item;
    static registerBlock(arg0: Internal.BlockItem_): Internal.Item;
    static POWERED_RAIL: Internal.BlockItem;
    static GUARDIAN_SPAWN_EGG: Internal.SpawnEggItem;
    static QUARTZ: Internal.Item;
    static TUBE_CORAL: Internal.BlockItem;
    static TURTLE_EGG: Internal.BlockItem;
    static HANGING_ROOTS: Internal.BlockItem;
    static CYAN_DYE: Internal.DyeItem;
    static WAXED_WEATHERED_CUT_COPPER_SLAB: Internal.BlockItem;
    static CRACKED_DEEPSLATE_TILES: Internal.BlockItem;
    static OAK_PLANKS: Internal.BlockItem;
    static BLAZE_ROD: Internal.Item;
    static GRASS_BLOCK: Internal.BlockItem;
    static DRIED_KELP: Internal.Item;
    static TURTLE_SPAWN_EGG: Internal.SpawnEggItem;
    static GRAY_BANNER: Internal.BannerItem;
    static MAGENTA_CONCRETE: Internal.BlockItem;
    static WARPED_FUNGUS: Internal.BlockItem;
    static DEEPSLATE_BRICKS: Internal.BlockItem;
    static BEETROOT: Internal.Item;
    static LIGHT_GRAY_TERRACOTTA: Internal.BlockItem;
    static GRAY_BED: Internal.BedItem;
    static MUDDY_MANGROVE_ROOTS: Internal.BlockItem;
    static OAK_SIGN: Internal.SignItem;
    static ACACIA_LEAVES: Internal.BlockItem;
    static BIRCH_SLAB: Internal.BlockItem;
    static CHAIN: Internal.BlockItem;
    static LIGHT_GRAY_DYE: Internal.DyeItem;
    static STRIPPED_SPRUCE_LOG: Internal.BlockItem;
    static LIGHT_GRAY_CANDLE: Internal.BlockItem;
    static PURPUR_BLOCK: Internal.BlockItem;
    static NETHERITE_LEGGINGS: Internal.ArmorItem;
    static DEBUG_STICK: Internal.DebugStickItem;
    static DUNE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static MUSIC_DISC_CAT: Internal.RecordItem;
    static GOLDEN_SWORD: Internal.SwordItem;
    static VERDANT_FROGLIGHT: Internal.BlockItem;
    static WARPED_NYLIUM: Internal.BlockItem;
    static TIPPED_ARROW: Internal.TippedArrowItem;
    static MILK_BUCKET: Internal.MilkBucketItem;
    static LAPIS_ORE: Internal.BlockItem;
    static WEEPING_VINES: Internal.BlockItem;
    static BLAZE_SPAWN_EGG: Internal.SpawnEggItem;
    static TORCHFLOWER: Internal.BlockItem;
    static LODESTONE: Internal.BlockItem;
    static IRON_HELMET: Internal.ArmorItem;
    static MANGROVE_DOOR: Internal.DoubleHighBlockItem;
    static INFESTED_STONE: Internal.BlockItem;
    static OAK_LOG: Internal.BlockItem;
    static SMOOTH_QUARTZ: Internal.BlockItem;
    static BIRCH_STAIRS: Internal.BlockItem;
    static BRUSH: Internal.BrushItem;
    static END_PORTAL_FRAME: Internal.BlockItem;
    static AZURE_BLUET: Internal.BlockItem;
    static NETHER_QUARTZ_ORE: Internal.BlockItem;
    static COBBLESTONE: Internal.BlockItem;
    static DARK_OAK_HANGING_SIGN: Internal.HangingSignItem;
    static SPRUCE_HANGING_SIGN: Internal.HangingSignItem;
    static PUMPKIN: Internal.BlockItem;
    static COBWEB: Internal.BlockItem;
    static YELLOW_STAINED_GLASS_PANE: Internal.BlockItem;
    static DARK_OAK_WOOD: Internal.BlockItem;
    static BLUE_CARPET: Internal.BlockItem;
    static CARROT: Internal.ItemNameBlockItem;
    static GOLDEN_BOOTS: Internal.ArmorItem;
    static BLACKSTONE_SLAB: Internal.BlockItem;
    static SUNFLOWER: Internal.DoubleHighBlockItem;
    static COPPER_ORE: Internal.BlockItem;
    static CHEST: Internal.BlockItem;
    static DEAD_HORN_CORAL: Internal.BlockItem;
    static POLISHED_GRANITE_SLAB: Internal.BlockItem;
    static PURPLE_CANDLE: Internal.BlockItem;
    static SKELETON_SKULL: Internal.StandingAndWallBlockItem;
    static RESPAWN_ANCHOR: Internal.BlockItem;
    static BUCKET: Internal.BucketItem;
    static ZOMBIFIED_PIGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static GLASS: Internal.BlockItem;
    static BIRCH_CHEST_BOAT: Internal.BoatItem;
    static FIRE_CORAL: Internal.BlockItem;
    static LAVA_BUCKET: Internal.BucketItem;
    static ENDER_PEARL: Internal.EnderpearlItem;
    static DRIED_KELP_BLOCK: Internal.BlockItem;
    static POLISHED_BLACKSTONE_BRICKS: Internal.BlockItem;
    static WILD_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static JUNGLE_SLAB: Internal.BlockItem;
    static BOOKSHELF: Internal.BlockItem;
    static DIAMOND_LEGGINGS: Internal.ArmorItem;
    static COBBLESTONE_WALL: Internal.BlockItem;
    static TWISTING_VINES: Internal.BlockItem;
    static GRINDSTONE: Internal.BlockItem;
    static DARK_OAK_LEAVES: Internal.BlockItem;
    static PHANTOM_MEMBRANE: Internal.Item;
    static BRICK: Internal.Item;
    static ARCHER_POTTERY_SHERD: Internal.Item;
    static JUNGLE_LEAVES: Internal.BlockItem;
    static TINTED_GLASS: Internal.BlockItem;
    static OAK_TRAPDOOR: Internal.BlockItem;
    static GOLD_ORE: Internal.BlockItem;
    static FLOWERING_AZALEA: Internal.BlockItem;
    static POPPED_CHORUS_FRUIT: Internal.Item;
    static PRISMARINE_CRYSTALS: Internal.Item;
    static LAPIS_LAZULI: Internal.Item;
    static SQUID_SPAWN_EGG: Internal.SpawnEggItem;
    static TERRACOTTA: Internal.BlockItem;
    static NETHERITE_INGOT: Internal.Item;
    static DEEPSLATE_EMERALD_ORE: Internal.BlockItem;
    static CHAINMAIL_BOOTS: Internal.ArmorItem;
    static NETHERITE_CHESTPLATE: Internal.ArmorItem;
    static CHICKEN_SPAWN_EGG: Internal.SpawnEggItem;
    static BEEHIVE: Internal.BlockItem;
    static SPYGLASS: Internal.SpyglassItem;
    static NETHERITE_AXE: Internal.AxeItem;
    static ELDER_GUARDIAN_SPAWN_EGG: Internal.SpawnEggItem;
    static DARK_OAK_SLAB: Internal.BlockItem;
    static BLUE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static MULE_SPAWN_EGG: Internal.SpawnEggItem;
    static ORANGE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static DARK_OAK_BUTTON: Internal.BlockItem;
    static FIREWORK_STAR: Internal.FireworkStarItem;
    static SPIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static DARK_OAK_LOG: Internal.BlockItem;
    static SKULL_POTTERY_SHERD: Internal.Item;
    static FROG_SPAWN_EGG: Internal.SpawnEggItem;
    static DEAD_BRAIN_CORAL_BLOCK: Internal.BlockItem;
    static DIRT: Internal.BlockItem;
    static DARK_OAK_CHEST_BOAT: Internal.BoatItem;
    static WOODEN_SHOVEL: Internal.ShovelItem;
    static GLOWSTONE_DUST: Internal.Item;
    static ITEM_FRAME: Internal.ItemFrameItem;
    static MUSIC_DISC_RELIC: Internal.RecordItem;
    static SANDSTONE: Internal.BlockItem;
    static BIRCH_FENCE: Internal.BlockItem;
    static MOSSY_COBBLESTONE_WALL: Internal.BlockItem;
    static REDSTONE: Internal.ItemNameBlockItem;
    static CARROT_ON_A_STICK: Internal.Item;
    static SOUL_TORCH: Internal.StandingAndWallBlockItem;
    static LIME_CARPET: Internal.BlockItem;
    static MANGROVE_PLANKS: Internal.BlockItem;
    static SUGAR_CANE: Internal.BlockItem;
    static COMMAND_BLOCK_MINECART: Internal.MinecartItem;
    static SMOOTH_SANDSTONE_STAIRS: Internal.BlockItem;
    static CHEST_MINECART: Internal.MinecartItem;
    static DEAD_BUBBLE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static SCUTE: Internal.Item;
    static FEATHER: Internal.Item;
    static JUNGLE_TRAPDOOR: Internal.BlockItem;
    static CUT_SANDSTONE: Internal.BlockItem;
    static CHISELED_QUARTZ_BLOCK: Internal.BlockItem;
    static WHITE_TERRACOTTA: Internal.BlockItem;
    static COPPER_INGOT: Internal.Item;
    static SWEET_BERRIES: Internal.ItemNameBlockItem;
    static GREEN_TERRACOTTA: Internal.BlockItem;
    static BUBBLE_CORAL: Internal.BlockItem;
    static BELL: Internal.BlockItem;
    static WAXED_EXPOSED_COPPER: Internal.BlockItem;
    static WHITE_CONCRETE_POWDER: Internal.BlockItem;
    static PITCHER_POD: Internal.ItemNameBlockItem;
    static BLACK_DYE: Internal.DyeItem;
    static WHITE_WOOL: Internal.BlockItem;
    static DETECTOR_RAIL: Internal.BlockItem;
    static TIDE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static LIME_CONCRETE: Internal.BlockItem;
    static PIGLIN_HEAD: Internal.StandingAndWallBlockItem;
    static CHORUS_FLOWER: Internal.BlockItem;
    static WARPED_HYPHAE: Internal.BlockItem;
    static WARDEN_SPAWN_EGG: Internal.SpawnEggItem;
    static CHISELED_NETHER_BRICKS: Internal.BlockItem;
    static SNOWBALL: Internal.SnowballItem;
    static LANTERN: Internal.BlockItem;
    static CYAN_CONCRETE_POWDER: Internal.BlockItem;
    static MAP: Internal.EmptyMapItem;
    static WHITE_SHULKER_BOX: Internal.BlockItem;
    static DEEPSLATE_COPPER_ORE: Internal.BlockItem;
    static CUT_STANDSTONE_SLAB: Internal.BlockItem;
    static BLACK_CANDLE: Internal.BlockItem;
    static BLAST_FURNACE: Internal.BlockItem;
    static BIRCH_PLANKS: Internal.BlockItem;
    static QUARTZ_BRICKS: Internal.BlockItem;
    static CYAN_STAINED_GLASS_PANE: Internal.BlockItem;
    static IRON_INGOT: Internal.Item;
    static PINK_BANNER: Internal.BannerItem;
    static MAGMA_CUBE_SPAWN_EGG: Internal.SpawnEggItem;
    static WHITE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static SMOOTH_RED_SANDSTONE: Internal.BlockItem;
    static TRADER_LLAMA_SPAWN_EGG: Internal.SpawnEggItem;
    static TNT: Internal.BlockItem;
    static OAK_DOOR: Internal.DoubleHighBlockItem;
    static CHERRY_PRESSURE_PLATE: Internal.BlockItem;
    static GREEN_STAINED_GLASS_PANE: Internal.BlockItem;
    static CHERRY_FENCE: Internal.BlockItem;
    static YELLOW_BANNER: Internal.BannerItem;
    static ROTTEN_FLESH: Internal.Item;
    static RIB_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static CUT_COPPER_STAIRS: Internal.BlockItem;
    static WRITTEN_BOOK: Internal.WrittenBookItem;
    static DISC_FRAGMENT_5: Internal.DiscFragmentItem;
    static SNIFFER_EGG: Internal.BlockItem;
    static MAGENTA_DYE: Internal.DyeItem;
    static CLAY: Internal.BlockItem;
    static CHERRY_PLANKS: Internal.BlockItem;
    static MAGENTA_CONCRETE_POWDER: Internal.BlockItem;
    static CHERRY_FENCE_GATE: Internal.BlockItem;
    static BRAIN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static SPAWNER: Internal.BlockItem;
    static LIME_SHULKER_BOX: Internal.BlockItem;
    static CRIMSON_TRAPDOOR: Internal.BlockItem;
    static NETHERITE_SCRAP: Internal.Item;
    static NETHER_BRICK_SLAB: Internal.BlockItem;
    static STONE: Internal.BlockItem;
    static WITHER_SKELETON_SPAWN_EGG: Internal.SpawnEggItem;
    static AMETHYST_BLOCK: Internal.BlockItem;
    static BIRCH_SAPLING: Internal.BlockItem;
    static JUNGLE_BUTTON: Internal.BlockItem;
    static HOGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static ZOGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static LIME_DYE: Internal.DyeItem;
    static IRON_TRAPDOOR: Internal.BlockItem;
    static CHERRY_CHEST_BOAT: Internal.BoatItem;
    static MAGENTA_CANDLE: Internal.BlockItem;
    static PETRIFIED_OAK_SLAB: Internal.BlockItem;
    static PRISMARINE_SHARD: Internal.Item;
    static NETHER_GOLD_ORE: Internal.BlockItem;
    static POLISHED_BASALT: Internal.BlockItem;
    static MANGROVE_STAIRS: Internal.BlockItem;
    static ORANGE_BANNER: Internal.BannerItem;
    static CHERRY_DOOR: Internal.DoubleHighBlockItem;
    static SANDSTONE_WALL: Internal.BlockItem;
    static ORANGE_CONCRETE_POWDER: Internal.BlockItem;
    static ENDER_DRAGON_SPAWN_EGG: Internal.SpawnEggItem;
    static STRIPPED_OAK_LOG: Internal.BlockItem;
    static POLISHED_GRANITE_STAIRS: Internal.BlockItem;
    static DEEPSLATE_GOLD_ORE: Internal.BlockItem;
    static OBSERVER: Internal.BlockItem;
    static GRAY_CONCRETE_POWDER: Internal.BlockItem;
    static DIAMOND_SWORD: Internal.SwordItem;
    static FOX_SPAWN_EGG: Internal.SpawnEggItem;
    static CHERRY_STAIRS: Internal.BlockItem;
    static MAGENTA_WOOL: Internal.BlockItem;
    static CALCITE: Internal.BlockItem;
    static PUMPKIN_SEEDS: Internal.ItemNameBlockItem;
    static FERMENTED_SPIDER_EYE: Internal.Item;
    static HEART_POTTERY_SHERD: Internal.Item;
    static PURPLE_CONCRETE: Internal.BlockItem;
    static MUTTON: Internal.Item;
    static PURPLE_STAINED_GLASS: Internal.BlockItem;
    static GOLDEN_PICKAXE: Internal.PickaxeItem;
    static ZOMBIE_SPAWN_EGG: Internal.SpawnEggItem;
    static MUSIC_DISC_PIGSTEP: Internal.RecordItem;
    static REDSTONE_TORCH: Internal.StandingAndWallBlockItem;
    static LEATHER_LEGGINGS: Internal.DyeableArmorItem;
    static PIGLIN_SPAWN_EGG: Internal.SpawnEggItem;
    static RED_SHULKER_BOX: Internal.BlockItem;
    static COD: Internal.Item;
    static MUSIC_DISC_11: Internal.RecordItem;
    static AZALEA_LEAVES: Internal.BlockItem;
    static NETHER_WART: Internal.ItemNameBlockItem;
    static NAME_TAG: Internal.NameTagItem;
    static CYAN_CARPET: Internal.BlockItem;
    static BAMBOO_TRAPDOOR: Internal.BlockItem;
    static MOSSY_COBBLESTONE: Internal.BlockItem;
    static NETHER_BRICK_WALL: Internal.BlockItem;
    static JACK_O_LANTERN: Internal.BlockItem;
    static JUNGLE_SAPLING: Internal.BlockItem;
    static WARPED_SLAB: Internal.BlockItem;
    static FURNACE: Internal.BlockItem;
    static ACACIA_SLAB: Internal.BlockItem;
    static RED_CONCRETE: Internal.BlockItem;
    static YELLOW_CARPET: Internal.BlockItem;
    static POWDER_SNOW_BUCKET: Internal.SolidBucketItem;
    static BUBBLE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static WHITE_STAINED_GLASS: Internal.BlockItem;
    static BRICK_WALL: Internal.BlockItem;
    static BOOK: Internal.BookItem;
    static RED_STAINED_GLASS: Internal.BlockItem;
    static DARK_PRISMARINE_STAIRS: Internal.BlockItem;
    static LIGHT_BLUE_BANNER: Internal.BannerItem;
    static CRIMSON_BUTTON: Internal.BlockItem;
    static PURPLE_WOOL: Internal.BlockItem;
    static PURPLE_BED: Internal.BedItem;
    static EMERALD_ORE: Internal.BlockItem;
    static BLUE_TERRACOTTA: Internal.BlockItem;
    static CRACKED_STONE_BRICKS: Internal.BlockItem;
    static COD_SPAWN_EGG: Internal.SpawnEggItem;
    static DIAMOND: Internal.Item;
    static AZALEA: Internal.BlockItem;
    static JUNGLE_BOAT: Internal.BoatItem;
    static SPRUCE_TRAPDOOR: Internal.BlockItem;
    static MELON_SEEDS: Internal.ItemNameBlockItem;
    static WEATHERED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static CANDLE: Internal.BlockItem;
    static PURPLE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static PILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static MUSIC_DISC_13: Internal.RecordItem;
    static LIGHT_GRAY_CARPET: Internal.BlockItem;
    static BIRCH_WOOD: Internal.BlockItem;
    static FLOWER_POT: Internal.BlockItem;
    static ACACIA_WOOD: Internal.BlockItem;
    static WARPED_FENCE: Internal.BlockItem;
    static CHISELED_POLISHED_BLACKSTONE: Internal.BlockItem;
    static SEA_PICKLE: Internal.BlockItem;
    static LARGE_FERN: Internal.DoubleHighBlockItem;
    static AMETHYST_SHARD: Internal.Item;
    static CHICKEN: Internal.Item;
    static GRAY_CONCRETE: Internal.BlockItem;
    static ACACIA_PRESSURE_PLATE: Internal.BlockItem;
    static TOTEM_OF_UNDYING: Internal.Item;
    static STONE_BRICKS: Internal.BlockItem;
    static GREEN_BED: Internal.BedItem;
    static DROPPER: Internal.BlockItem;
    static LIME_STAINED_GLASS: Internal.BlockItem;
    static KNOWLEDGE_BOOK: Internal.KnowledgeBookItem;
    static LOOM: Internal.BlockItem;
    static LIGHT_BLUE_WOOL: Internal.BlockItem;
    static NETHERITE_BLOCK: Internal.BlockItem;
    static ORANGE_CARPET: Internal.BlockItem;
    static FISHING_ROD: Internal.FishingRodItem;
    static BROWN_DYE: Internal.DyeItem;
    static MEDIUM_AMETHYST_BUD: Internal.BlockItem;
    static ROOTED_DIRT: Internal.BlockItem;
    static SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static WARPED_STEM: Internal.BlockItem;
    static SHEAF_POTTERY_SHERD: Internal.Item;
    static RED_SAND: Internal.BlockItem;
    static END_STONE_BRICK_STAIRS: Internal.BlockItem;
    static SHEARS: Internal.ShearsItem;
    static PANDA_SPAWN_EGG: Internal.SpawnEggItem;
    static POTATO: Internal.ItemNameBlockItem;
    static LAPIS_BLOCK: Internal.BlockItem;
    static COMPOSTER: Internal.BlockItem;
    static NETHERITE_HELMET: Internal.ArmorItem;
    static TROPICAL_FISH: Internal.Item;
    static POTION: Internal.PotionItem;
    static MANGROVE_ROOTS: Internal.BlockItem;
    static JIGSAW: Internal.GameMasterBlockItem;
    static PRISMARINE_BRICK_STAIRS: Internal.BlockItem;
    static TROPICAL_FISH_BUCKET: Internal.MobBucketItem;
    static WARPED_PRESSURE_PLATE: Internal.BlockItem;
    static RED_TERRACOTTA: Internal.BlockItem;
    static BROWN_CARPET: Internal.BlockItem;
    static CRIMSON_HANGING_SIGN: Internal.HangingSignItem;
    static LIGHT_BLUE_CANDLE: Internal.BlockItem;
    static LEATHER_CHESTPLATE: Internal.DyeableArmorItem;
    static RED_BED: Internal.BedItem;
    static STONE_HOE: Internal.HoeItem;
    static JUNGLE_LOG: Internal.BlockItem;
    static GLOW_SQUID_SPAWN_EGG: Internal.SpawnEggItem;
    static EYE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static BROWN_WOOL: Internal.BlockItem;
    static PUFFERFISH_SPAWN_EGG: Internal.SpawnEggItem;
    static GLASS_PANE: Internal.BlockItem;
    static CHAINMAIL_LEGGINGS: Internal.ArmorItem;
    static GREEN_WOOL: Internal.BlockItem;
    static BREAD: Internal.Item;
    static COOKED_CHICKEN: Internal.Item;
    static BIRCH_FENCE_GATE: Internal.BlockItem;
    static MANGROVE_TRAPDOOR: Internal.BlockItem;
    static CRIMSON_SLAB: Internal.BlockItem;
    static GOLD_NUGGET: Internal.Item;
    static PHANTOM_SPAWN_EGG: Internal.SpawnEggItem;
    static QUARTZ_STAIRS: Internal.BlockItem;
    static WHITE_CONCRETE: Internal.BlockItem;
    static WAXED_WEATHERED_COPPER: Internal.BlockItem;
    static BLUE_CONCRETE_POWDER: Internal.BlockItem;
    static WHEAT_SEEDS: Internal.ItemNameBlockItem;
    static DEEPSLATE_TILES: Internal.BlockItem;
    static PORKCHOP: Internal.Item;
    static SCAFFOLDING: Internal.ScaffoldingBlockItem;
    static END_ROD: Internal.BlockItem;
    static ANDESITE: Internal.BlockItem;
    static PACKED_MUD: Internal.BlockItem;
    static STONE_BRICK_WALL: Internal.BlockItem;
    static ORANGE_WOOL: Internal.BlockItem;
    static REINFORCED_DEEPSLATE: Internal.BlockItem;
    static ACACIA_FENCE_GATE: Internal.BlockItem;
    static LIGHT_GRAY_GLAZED_TERRACOTTA: Internal.BlockItem;
    static LILY_OF_THE_VALLEY: Internal.BlockItem;
    static VILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static STONE_SHOVEL: Internal.ShovelItem;
    static PARROT_SPAWN_EGG: Internal.SpawnEggItem;
    static WHEAT: Internal.Item;
    static JUNGLE_PLANKS: Internal.BlockItem;
    static BROWN_CONCRETE_POWDER: Internal.BlockItem;
    static POLISHED_DEEPSLATE_SLAB: Internal.BlockItem;
    static DIAMOND_AXE: Internal.AxeItem;
    static WAXED_WEATHERED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static WARPED_PLANKS: Internal.BlockItem;
    static NETHERRACK: Internal.BlockItem;
    static DIAMOND_CHESTPLATE: Internal.ArmorItem;
    static GRAY_WOOL: Internal.BlockItem;
    static COPPER_BLOCK: Internal.BlockItem;
    static WEATHERED_CUT_COPPER: Internal.BlockItem;
    static PURPUR_PILLAR: Internal.BlockItem;
    static STONE_PRESSURE_PLATE: Internal.BlockItem;
    static RED_NETHER_BRICK_STAIRS: Internal.BlockItem;
    static CAKE: Internal.BlockItem;
    static COBBLED_DEEPSLATE: Internal.BlockItem;
    static MANGROVE_FENCE: Internal.BlockItem;
    static FARMLAND: Internal.BlockItem;
    static LIGHT_GRAY_CONCRETE: Internal.BlockItem;
    static NETHERITE_SHOVEL: Internal.ShovelItem;
    static PUMPKIN_PIE: Internal.Item;
    static SHULKER_SHELL: Internal.ShulkerShellItem;
    static OAK_LEAVES: Internal.BlockItem;
    static BIRCH_HANGING_SIGN: Internal.HangingSignItem;
    static RABBIT_SPAWN_EGG: Internal.SpawnEggItem;
    static LIGHT_WEIGHTED_PRESSURE_PLATE: Internal.BlockItem;
    static APPLE: Internal.Item;
    static DIAMOND_HORSE_ARMOR: Internal.HorseArmorItem;
    static POLISHED_BLACKSTONE_SLAB: Internal.BlockItem;
    static WARPED_ROOTS: Internal.BlockItem;
    static BIRCH_LOG: Internal.BlockItem;
    static ELYTRA: Internal.ElytraItem;
    static WARPED_SIGN: Internal.SignItem;
    static GREEN_CANDLE: Internal.BlockItem;
    static BIRCH_TRAPDOOR: Internal.BlockItem;
    static BEE_SPAWN_EGG: Internal.SpawnEggItem;
    static PINK_DYE: Internal.DyeItem;
    static PLAYER_HEAD: Internal.PlayerHeadItem;
    static GLOW_LICHEN: Internal.BlockItem;
    static STONE_STAIRS: Internal.BlockItem;
    static ROSE_BUSH: Internal.DoubleHighBlockItem;
    static GLOW_ITEM_FRAME: Internal.ItemFrameItem;
    static WHITE_TULIP: Internal.BlockItem;
    static JUNGLE_HANGING_SIGN: Internal.HangingSignItem;
    static OBSIDIAN: Internal.BlockItem;
    static BLADE_POTTERY_SHERD: Internal.Item;
    static BROWN_SHULKER_BOX: Internal.BlockItem;
    static EGG: Internal.EggItem;
    static WITCH_SPAWN_EGG: Internal.SpawnEggItem;
    static OXIDIZED_CUT_COPPER_SLAB: Internal.BlockItem;
    static WAXED_EXPOSED_CUT_COPPER_SLAB: Internal.BlockItem;
    static OCELOT_SPAWN_EGG: Internal.SpawnEggItem;
    static HORN_CORAL_BLOCK: Internal.BlockItem;
    static NETHER_SPROUTS: Internal.BlockItem;
    static MUD_BRICK_SLAB: Internal.BlockItem;
    static DEAD_BRAIN_CORAL: Internal.BlockItem;
    static TALL_GRASS: Internal.DoubleHighBlockItem;
    static BLACK_STAINED_GLASS: Internal.BlockItem;
    static SPIDER_EYE: Internal.Item;
    static FILLED_MAP: Internal.MapItem;
    static MUD_BRICK_STAIRS: Internal.BlockItem;
    static AXOLOTL_BUCKET: Internal.MobBucketItem;
    static ZOMBIE_HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static DARK_PRISMARINE_SLAB: Internal.BlockItem;
    static MANGROVE_SIGN: Internal.SignItem;
    static STRIPPED_JUNGLE_WOOD: Internal.BlockItem;
    static MUSHROOM_STEM: Internal.BlockItem;
    static LILAC: Internal.DoubleHighBlockItem;
    static BAMBOO_RAFT: Internal.BoatItem;
    static SUSPICIOUS_STEW: Internal.SuspiciousStewItem;
    static SUSPICIOUS_GRAVEL: Internal.BlockItem;
    static GOLDEN_LEGGINGS: Internal.ArmorItem;
    static IRON_PICKAXE: Internal.PickaxeItem;
    static WAXED_OXIDIZED_CUT_COPPER: Internal.BlockItem;
    static CRACKED_DEEPSLATE_BRICKS: Internal.BlockItem;
    static SHULKER_SPAWN_EGG: Internal.SpawnEggItem;
    static SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static LIGHT_GRAY_STAINED_GLASS: Internal.BlockItem;
    static MELON_SLICE: Internal.Item;
    static HONEYCOMB_BLOCK: Internal.BlockItem;
    static POLISHED_DIORITE_STAIRS: Internal.BlockItem;
    static PEARLESCENT_FROGLIGHT: Internal.BlockItem;
    static GOLDEN_CHESTPLATE: Internal.ArmorItem;
    static ANCIENT_DEBRIS: Internal.BlockItem;
    static HOPPER_MINECART: Internal.MinecartItem;
    static MAGMA_CREAM: Internal.Item;
    static ZOMBIE_HEAD: Internal.StandingAndWallBlockItem;
    static POLISHED_GRANITE: Internal.BlockItem;
    static PINK_CONCRETE: Internal.BlockItem;
    static HONEYCOMB: Internal.HoneycombItem;
    static NOTE_BLOCK: Internal.BlockItem;
    static RED_GLAZED_TERRACOTTA: Internal.BlockItem;
    static FURNACE_MINECART: Internal.MinecartItem;
    static DRAGON_BREATH: Internal.Item;
    static CYAN_CONCRETE: Internal.BlockItem;
    static CRIMSON_PLANKS: Internal.BlockItem;
    static CHORUS_PLANT: Internal.BlockItem;
    static WAXED_CUT_COPPER_SLAB: Internal.BlockItem;
    static YELLOW_CONCRETE_POWDER: Internal.BlockItem;
    static TURTLE_HELMET: Internal.ArmorItem;
    static DARK_OAK_FENCE_GATE: Internal.BlockItem;
    static COAL_ORE: Internal.BlockItem;
    static COAL: Internal.Item;
    static COAST_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static GRAY_CARPET: Internal.BlockItem;
    static OXIDIZED_CUT_COPPER: Internal.BlockItem;
    static LIGHT_BLUE_CONCRETE_POWDER: Internal.BlockItem;
    static DANGER_POTTERY_SHERD: Internal.Item;
    static SANDSTONE_SLAB: Internal.BlockItem;
    static GREEN_CONCRETE: Internal.BlockItem;
    static BARREL: Internal.BlockItem;
    static RED_SANDSTONE_SLAB: Internal.BlockItem;
    static WHITE_DYE: Internal.DyeItem;
    static ORANGE_DYE: Internal.DyeItem;
    static ENCHANTED_BOOK: Internal.EnchantedBookItem;
    static SOUL_SOIL: Internal.BlockItem;
    static IRON_NUGGET: Internal.Item;
    static ENDERMITE_SPAWN_EGG: Internal.SpawnEggItem;
    static NETHERITE_BOOTS: Internal.ArmorItem;
    static LEVER: Internal.BlockItem;
    static COOKED_SALMON: Internal.Item;
    static CAULDRON: Internal.Items$1;
    static ALLIUM: Internal.BlockItem;
    static JUNGLE_CHEST_BOAT: Internal.BoatItem;
    static EXPLORER_POTTERY_SHERD: Internal.Item;
    static POISONOUS_POTATO: Internal.Item;
    static FLOWER_BANNER_PATTERN: Internal.BannerPatternItem;
    static SMOOTH_STONE: Internal.BlockItem;
    static WHITE_STAINED_GLASS_PANE: Internal.BlockItem;
    static SNORT_POTTERY_SHERD: Internal.Item;
    static BROWN_MUSHROOM_BLOCK: Internal.BlockItem;
    static GHAST_SPAWN_EGG: Internal.SpawnEggItem;
    static NETHER_BRICK_STAIRS: Internal.BlockItem;
    static IRON_SHOVEL: Internal.ShovelItem;
    static AXOLOTL_SPAWN_EGG: Internal.SpawnEggItem;
    static ORANGE_STAINED_GLASS: Internal.BlockItem;
    static SEA_LANTERN: Internal.BlockItem;
    static SMOOTH_RED_SANDSTONE_STAIRS: Internal.BlockItem;
    static POLISHED_BLACKSTONE_WALL: Internal.BlockItem;
    static STONE_PICKAXE: Internal.PickaxeItem;
    static LIME_TERRACOTTA: Internal.BlockItem;
    static SHIELD: Internal.ShieldItem;
    static DIORITE_WALL: Internal.BlockItem;
    static STONE_SWORD: Internal.SwordItem;
    static GOLDEN_HOE: Internal.HoeItem;
    static BLACK_GLAZED_TERRACOTTA: Internal.BlockItem;
    static DIAMOND_ORE: Internal.BlockItem;
    static BLACK_STAINED_GLASS_PANE: Internal.BlockItem;
    static LIGHT_GRAY_CONCRETE_POWDER: Internal.BlockItem;
    static LIGHT_BLUE_DYE: Internal.DyeItem;
    static REPEATER: Internal.BlockItem;
    static SPECTRAL_ARROW: Internal.SpectralArrowItem;
    static CHERRY_SLAB: Internal.BlockItem;
    static LEAD: Internal.LeadItem;
    static WHITE_CANDLE: Internal.BlockItem;
    static CHISELED_STONE_BRICKS: Internal.BlockItem;
    static DEAD_TUBE_CORAL: Internal.BlockItem;
    static BROWN_BANNER: Internal.BannerItem;
    static WAXED_OXIDIZED_COPPER: Internal.BlockItem;
    static PINK_WOOL: Internal.BlockItem;
    static BIRCH_BOAT: Internal.BoatItem;
    static BLACK_CARPET: Internal.BlockItem;
    static SPRUCE_FENCE_GATE: Internal.BlockItem;
    static BREWING_STAND: Internal.BlockItem;
    static BIG_DRIPLEAF: Internal.Items$1;
    static CARVED_PUMPKIN: Internal.BlockItem;
    static OAK_BUTTON: Internal.BlockItem;
    static PINK_GLAZED_TERRACOTTA: Internal.BlockItem;
    static DIORITE_SLAB: Internal.BlockItem;
    static ACACIA_BOAT: Internal.BoatItem;
    static POLISHED_BLACKSTONE_BRICK_SLAB: Internal.BlockItem;
    static CHERRY_WOOD: Internal.BlockItem;
    static SMOOTH_QUARTZ_STAIRS: Internal.BlockItem;
    static END_STONE: Internal.BlockItem;
    static BLUE_BED: Internal.BedItem;
    static LIGHT: Internal.BlockItem;
    static BONE_BLOCK: Internal.BlockItem;
    static DRIPSTONE_BLOCK: Internal.BlockItem;
    static WET_SPONGE: Internal.BlockItem;
    static FLINT: Internal.Item;
    static INFESTED_CHISELED_STONE_BRICKS: Internal.BlockItem;
    static GRAY_SHULKER_BOX: Internal.BlockItem;
    static YELLOW_CANDLE: Internal.BlockItem;
    static SPRUCE_LEAVES: Internal.BlockItem;
    static MOSSY_COBBLESTONE_SLAB: Internal.BlockItem;
    static HUSK_SPAWN_EGG: Internal.SpawnEggItem;
    static PINK_STAINED_GLASS: Internal.BlockItem;
    static MAGENTA_STAINED_GLASS_PANE: Internal.BlockItem;
    static BLUE_ICE: Internal.BlockItem;
    static JUKEBOX: Internal.BlockItem;
    static FIRE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static FIRE_CHARGE: Internal.FireChargeItem;
    static COOKED_MUTTON: Internal.Item;
    static BASALT: Internal.BlockItem;
    static ACACIA_PLANKS: Internal.BlockItem;
    static PIG_SPAWN_EGG: Internal.SpawnEggItem;
    static MUSHROOM_STEW: Internal.BowlFoodItem;
    static PURPLE_STAINED_GLASS_PANE: Internal.BlockItem;
    static MANGROVE_PRESSURE_PLATE: Internal.BlockItem;
    static HOWL_POTTERY_SHERD: Internal.Item;
    static SMALL_AMETHYST_BUD: Internal.BlockItem;
    static DEAD_HORN_CORAL_BLOCK: Internal.BlockItem;
    static POLISHED_BLACKSTONE_BRICK_WALL: Internal.BlockItem;
    static WEATHERED_COPPER: Internal.BlockItem;
    static RED_WOOL: Internal.BlockItem;
    static MANGROVE_PROPAGULE: Internal.BlockItem;
    static PURPUR_STAIRS: Internal.BlockItem;
    static PAPER: Internal.Item;
    static IRON_HOE: Internal.HoeItem;
    static MAGENTA_GLAZED_TERRACOTTA: Internal.BlockItem;
    static STICKY_PISTON: Internal.BlockItem;
    static COMPASS: Internal.CompassItem;
    static RED_SANDSTONE_WALL: Internal.BlockItem;
    static DARK_PRISMARINE: Internal.BlockItem;
    static DARK_OAK_FENCE: Internal.BlockItem;
    static BAMBOO_BUTTON: Internal.BlockItem;
    static CLAY_BALL: Internal.Item;
    static CYAN_WOOL: Internal.BlockItem;
    static STONECUTTER: Internal.BlockItem;
    static MINECART: Internal.MinecartItem;
    static POLISHED_BLACKSTONE_STAIRS: Internal.BlockItem;
    static RED_CANDLE: Internal.BlockItem;
    static GREEN_STAINED_GLASS: Internal.BlockItem;
    static SHELTER_POTTERY_SHERD: Internal.Item;
    static AIR: Internal.AirItem;
    static SEAGRASS: Internal.BlockItem;
    static GLOWSTONE: Internal.BlockItem;
    static YELLOW_BED: Internal.BedItem;
    static ANVIL: Internal.BlockItem;
    static YELLOW_GLAZED_TERRACOTTA: Internal.BlockItem;
    static RAW_COPPER_BLOCK: Internal.BlockItem;
    static POLISHED_DIORITE: Internal.BlockItem;
    static DARK_OAK_SIGN: Internal.SignItem;
    static MAGENTA_STAINED_GLASS: Internal.BlockItem;
    static NETHER_BRICKS: Internal.BlockItem;
    static WITHER_SKELETON_SKULL: Internal.StandingAndWallBlockItem;
    static DONKEY_SPAWN_EGG: Internal.SpawnEggItem;
    static STONE_BRICK_STAIRS: Internal.BlockItem;
    static WARPED_DOOR: Internal.DoubleHighBlockItem;
    static WAXED_COPPER_BLOCK: Internal.BlockItem;
    static ENCHANTED_GOLDEN_APPLE: Internal.EnchantedGoldenAppleItem;
    static MANGROVE_CHEST_BOAT: Internal.BoatItem;
    static MUD: Internal.BlockItem;
    static OAK_FENCE: Internal.BlockItem;
    static GOAT_HORN: Internal.InstrumentItem;
    static HOST_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static CAVE_SPIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static QUARTZ_PILLAR: Internal.BlockItem;
    static DEAD_FIRE_CORAL: Internal.BlockItem;
    static SUGAR: Internal.Item;
    static WAXED_EXPOSED_CUT_COPPER: Internal.BlockItem;
    static BROWN_CONCRETE: Internal.BlockItem;
    static SCULK_VEIN: Internal.BlockItem;
    static FLETCHING_TABLE: Internal.BlockItem;
    static INFESTED_MOSSY_STONE_BRICKS: Internal.BlockItem;
    static WARPED_STAIRS: Internal.BlockItem;
    static SPRUCE_PRESSURE_PLATE: Internal.BlockItem;
    static BROWN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static PINK_CANDLE: Internal.BlockItem;
    static STONE_BRICK_SLAB: Internal.BlockItem;
    static PLENTY_POTTERY_SHERD: Internal.Item;
    static RED_CARPET: Internal.BlockItem;
    static CLOCK: Internal.Item;
    static GRAY_TERRACOTTA: Internal.BlockItem;
    static EMERALD: Internal.Item;
    static DEEPSLATE_DIAMOND_ORE: Internal.BlockItem;
    static BIRCH_PRESSURE_PLATE: Internal.BlockItem;
    static BIRCH_DOOR: Internal.DoubleHighBlockItem;
    static BROWN_CANDLE: Internal.BlockItem;
    static KELP: Internal.BlockItem;
    static WITHER_ROSE: Internal.BlockItem;
    static ACACIA_CHEST_BOAT: Internal.BoatItem;
    static TADPOLE_SPAWN_EGG: Internal.SpawnEggItem;
    static OAK_HANGING_SIGN: Internal.HangingSignItem;
    static SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static SPRUCE_FENCE: Internal.BlockItem;
    static ORANGE_CONCRETE: Internal.BlockItem;
    static CRAFTING_TABLE: Internal.BlockItem;
    static BAKED_POTATO: Internal.Item;
    static MANGROVE_SLAB: Internal.BlockItem;
    static CYAN_BED: Internal.BedItem;
    static CHISELED_BOOKSHELF: Internal.BlockItem;
    static NAUTILUS_SHELL: Internal.Item;
    static SHULKER_BOX: Internal.BlockItem;
    static STICK: Internal.Item;
    static HEAVY_WEIGHTED_PRESSURE_PLATE: Internal.BlockItem;
    static COARSE_DIRT: Internal.BlockItem;
    static QUARTZ_SLAB: Internal.BlockItem;
    static SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static COBBLED_DEEPSLATE_SLAB: Internal.BlockItem;
    static LIGHTNING_ROD: Internal.BlockItem;
    static ACACIA_FENCE: Internal.BlockItem;
    static POLAR_BEAR_SPAWN_EGG: Internal.SpawnEggItem;
    static ACACIA_LOG: Internal.BlockItem;
    static MOJANG_BANNER_PATTERN: Internal.BannerPatternItem;
    static DEEPSLATE_REDSTONE_ORE: Internal.BlockItem;
    static INFESTED_STONE_BRICKS: Internal.BlockItem;
    static ENCHANTING_TABLE: Internal.BlockItem;
    static POLISHED_ANDESITE_SLAB: Internal.BlockItem;
    static PURPLE_CONCRETE_POWDER: Internal.BlockItem;
    static PINK_CARPET: Internal.BlockItem;
    static BREWER_POTTERY_SHERD: Internal.Item;
    static DIORITE: Internal.BlockItem;
    static RED_CONCRETE_POWDER: Internal.BlockItem;
    static DARK_OAK_SAPLING: Internal.BlockItem;
    static GRAY_DYE: Internal.DyeItem;
    static LIGHT_GRAY_BED: Internal.BedItem;
    static BAMBOO_SIGN: Internal.SignItem;
    static IRON_ORE: Internal.BlockItem;
    static SCULK_SENSOR: Internal.BlockItem;
    static BUNDLE: Internal.BundleItem;
    static STRING: Internal.ItemNameBlockItem;
    static STRIPPED_JUNGLE_LOG: Internal.BlockItem;
    static END_CRYSTAL: Internal.EndCrystalItem;
    static LEATHER_BOOTS: Internal.DyeableArmorItem;
    static SLIME_BALL: Internal.Item;
    static ORANGE_TERRACOTTA: Internal.BlockItem;
    static DEEPSLATE_IRON_ORE: Internal.BlockItem;
    static BOW: Internal.BowItem;
    static ORANGE_CANDLE: Internal.BlockItem;
    static BLUE_ORCHID: Internal.BlockItem;
    static SPRUCE_BUTTON: Internal.BlockItem;
    static LLAMA_SPAWN_EGG: Internal.SpawnEggItem;
    static CAMPFIRE: Internal.BlockItem;
    static LIGHT_BLUE_STAINED_GLASS: Internal.BlockItem;
    static CHERRY_BUTTON: Internal.BlockItem;
    static MAGENTA_TERRACOTTA: Internal.BlockItem;
    static DARK_OAK_STAIRS: Internal.BlockItem;
    static EXPOSED_CUT_COPPER_SLAB: Internal.BlockItem;
    static BUBBLE_CORAL_BLOCK: Internal.BlockItem;
    static RED_MUSHROOM: Internal.BlockItem;
    static ACACIA_STAIRS: Internal.BlockItem;
    static BLACK_CONCRETE: Internal.BlockItem;
    static SAND: Internal.BlockItem;
    static NETHERITE_HOE: Internal.HoeItem;
    static RED_MUSHROOM_BLOCK: Internal.BlockItem;
    static MYCELIUM: Internal.BlockItem;
    static PINK_TULIP: Internal.BlockItem;
    static PINK_TERRACOTTA: Internal.BlockItem;
    static GOAT_SPAWN_EGG: Internal.SpawnEggItem;
    static INFESTED_CRACKED_STONE_BRICKS: Internal.BlockItem;
    static RABBIT: Internal.Item;
    static PRISMARINE_SLAB: Internal.BlockItem;
    static REDSTONE_LAMP: Internal.BlockItem;
    static LIGHT_BLUE_CARPET: Internal.BlockItem;
    static TUBE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static MANGROVE_WOOD: Internal.BlockItem;
    static LIME_GLAZED_TERRACOTTA: Internal.BlockItem;
    static DARK_OAK_DOOR: Internal.DoubleHighBlockItem;
    static STRIPPED_ACACIA_WOOD: Internal.BlockItem;
    static LIGHT_BLUE_SHULKER_BOX: Internal.BlockItem;
    static ARMOR_STAND: Internal.ArmorStandItem;
    static CHERRY_SAPLING: Internal.BlockItem;
    static BROWN_STAINED_GLASS_PANE: Internal.BlockItem;
    static STONE_SLAB: Internal.BlockItem;
    static CHERRY_HANGING_SIGN: Internal.HangingSignItem;
    static MANGROVE_BOAT: Internal.BoatItem;
    static PRISMARINE_WALL: Internal.BlockItem;
    static LIGHT_GRAY_BANNER: Internal.BannerItem;
    static RED_NETHER_BRICK_SLAB: Internal.BlockItem;
    static WAXED_OXIDIZED_CUT_COPPER_SLAB: Internal.BlockItem;
    static IRON_GOLEM_SPAWN_EGG: Internal.SpawnEggItem;
    static CRIMSON_NYLIUM: Internal.BlockItem;
    static FIRE_CORAL_BLOCK: Internal.BlockItem;
    static EXPERIENCE_BOTTLE: Internal.ExperienceBottleItem;
    static POLISHED_BLACKSTONE_PRESSURE_PLATE: Internal.BlockItem;
    static RED_NETHER_BRICKS: Internal.BlockItem;
    static BLACK_CONCRETE_POWDER: Internal.BlockItem;
    static SMITHING_TABLE: Internal.BlockItem;
    static DARK_OAK_TRAPDOOR: Internal.BlockItem;
    static LIGHT_BLUE_STAINED_GLASS_PANE: Internal.BlockItem;
    static ACACIA_SIGN: Internal.SignItem;
    static YELLOW_STAINED_GLASS: Internal.BlockItem;
    static VEX_SPAWN_EGG: Internal.SpawnEggItem;
    static PIGLIN_BRUTE_SPAWN_EGG: Internal.SpawnEggItem;
    static GRAY_CANDLE: Internal.BlockItem;
    static COBBLESTONE_STAIRS: Internal.BlockItem;
    static BLAZE_POWDER: Internal.Item;
    static MUSIC_DISC_MALL: Internal.RecordItem;
    static LARGE_AMETHYST_BUD: Internal.BlockItem;
    static BRICKS: Internal.BlockItem;
    static BUDDING_AMETHYST: Internal.BlockItem;
    static RABBIT_FOOT: Internal.Item;
    static BAMBOO_MOSAIC: Internal.BlockItem;
    static MOSSY_COBBLESTONE_STAIRS: Internal.BlockItem;
    static SKULL_BANNER_PATTERN: Internal.BannerPatternItem;
    static ACACIA_TRAPDOOR: Internal.BlockItem;
    static BURN_POTTERY_SHERD: Internal.Item;
    static COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static BEACON: Internal.BlockItem;
    static STRIPPED_SPRUCE_WOOD: Internal.BlockItem;
    static OAK_SAPLING: Internal.BlockItem;
    static SMOOTH_SANDSTONE_SLAB: Internal.BlockItem;
    static BIRCH_BUTTON: Internal.BlockItem;
    static STRIPPED_CRIMSON_STEM: Internal.BlockItem;
    static GLOW_INK_SAC: Internal.GlowInkSacItem;
    static CYAN_BANNER: Internal.BannerItem;
    static CAMEL_SPAWN_EGG: Internal.SpawnEggItem;
    static POLISHED_BLACKSTONE: Internal.BlockItem;
    static GRASS: Internal.BlockItem;
    static SMOOTH_RED_SANDSTONE_SLAB: Internal.BlockItem;
    static BROWN_STAINED_GLASS: Internal.BlockItem;
    static MUSIC_DISC_CHIRP: Internal.RecordItem;
    static MUSIC_DISC_FAR: Internal.RecordItem;
    static RED_SANDSTONE_STAIRS: Internal.BlockItem;
    static JUNGLE_STAIRS: Internal.BlockItem;
    static COBBLED_DEEPSLATE_WALL: Internal.BlockItem;
    static BLUE_SHULKER_BOX: Internal.BlockItem;
    static WOODEN_AXE: Internal.AxeItem;
    static SPORE_BLOSSOM: Internal.BlockItem;
    static DEAD_BRAIN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static DEEPSLATE_TILE_STAIRS: Internal.BlockItem;
    static CROSSBOW: Internal.CrossbowItem;
    static BAMBOO_PRESSURE_PLATE: Internal.BlockItem;
    static HORN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static ORANGE_TULIP: Internal.BlockItem;
    static DIAMOND_PICKAXE: Internal.PickaxeItem;
    static GREEN_CARPET: Internal.BlockItem;
    static SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static OXIDIZED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static RABBIT_HIDE: Internal.Item;
    static COOKED_COD: Internal.Item;
    static BLACK_BED: Internal.BedItem;
    static PUFFERFISH: Internal.Item;
    static ENDER_EYE: Internal.EnderEyeItem;
    static INFESTED_COBBLESTONE: Internal.BlockItem;
    static GOLD_INGOT: Internal.Item;
    static VEX_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static STRIPPED_MANGROVE_LOG: Internal.BlockItem;
    static ICE: Internal.BlockItem;
    static BAMBOO_MOSAIC_STAIRS: Internal.BlockItem;
    static BLACK_BANNER: Internal.BannerItem;
    static OAK_CHEST_BOAT: Internal.BoatItem;
    static LIME_BANNER: Internal.BannerItem;
    static PINK_SHULKER_BOX: Internal.BlockItem;
    static SMALL_DRIPLEAF: Internal.DoubleHighBlockItem;
    static LILY_PAD: Internal.PlaceOnWaterBlockItem;
    static CREEPER_BANNER_PATTERN: Internal.BannerPatternItem;
    static GLOW_BERRIES: Internal.ItemNameBlockItem;
    static HOPPER: Internal.BlockItem;
    static PUFFERFISH_BUCKET: Internal.MobBucketItem;
    static PURPLE_BANNER: Internal.BannerItem;
    static HAY_BLOCK: Internal.BlockItem;
    static HEART_OF_THE_SEA: Internal.Item;
    static WARD_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static MOSSY_STONE_BRICK_WALL: Internal.BlockItem;
    static EXPOSED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static WARPED_WART_BLOCK: Internal.BlockItem;
    static NETHERITE_SWORD: Internal.SwordItem;
    static SHEEP_SPAWN_EGG: Internal.SpawnEggItem;
    static ANGLER_POTTERY_SHERD: Internal.Item;
    static PODZOL: Internal.BlockItem;
    static DIAMOND_HOE: Internal.HoeItem;
    static GRAY_STAINED_GLASS_PANE: Internal.BlockItem;
    static YELLOW_SHULKER_BOX: Internal.BlockItem;
    static STRIPPED_WARPED_STEM: Internal.BlockItem;
    static SPRUCE_SIGN: Internal.SignItem;
    static RABBIT_STEW: Internal.BowlFoodItem;
    static DEAD_TUBE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static DECORATED_POT: Internal.BlockItem;
    static OAK_PRESSURE_PLATE: Internal.BlockItem;
    static LIGHT_GRAY_SHULKER_BOX: Internal.BlockItem;
    static CHAINMAIL_HELMET: Internal.ArmorItem;
    static CRACKED_POLISHED_BLACKSTONE_BRICKS: Internal.BlockItem;
    static ACACIA_HANGING_SIGN: Internal.HangingSignItem;
    static LIME_BED: Internal.BedItem;
    static TUFF: Internal.BlockItem;
    static GRAVEL: Internal.BlockItem;
    static BARRIER: Internal.BlockItem;
    static DRAGON_HEAD: Internal.StandingAndWallBlockItem;
    static MUSIC_DISC_MELLOHI: Internal.RecordItem;
    static IRON_DOOR: Internal.DoubleHighBlockItem;
    static BAT_SPAWN_EGG: Internal.SpawnEggItem;
    static VINDICATOR_SPAWN_EGG: Internal.SpawnEggItem;
    static SMOOTH_BASALT: Internal.BlockItem;
    static LIGHT_GRAY_STAINED_GLASS_PANE: Internal.BlockItem;
    static DEAD_HORN_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static DROWNED_SPAWN_EGG: Internal.SpawnEggItem;
    static NETHER_STAR: Internal.SimpleFoiledItem;
    static CRIMSON_PRESSURE_PLATE: Internal.BlockItem;
    static FLINT_AND_STEEL: Internal.FlintAndSteelItem;
    static MAGENTA_BED: Internal.BedItem;
    static BONE: Internal.Item;
    static BROWN_TERRACOTTA: Internal.BlockItem;
    static END_STONE_BRICK_SLAB: Internal.BlockItem;
    static CALIBRATED_SCULK_SENSOR: Internal.BlockItem;
    static COMPARATOR: Internal.BlockItem;
    static LEATHER_HORSE_ARMOR: Internal.DyeableHorseArmorItem;
    static STRIPPED_BAMBOO_BLOCK: Internal.BlockItem;
    static POLISHED_DIORITE_SLAB: Internal.BlockItem;
    static MUD_BRICK_WALL: Internal.BlockItem;
    static MOSS_BLOCK: Internal.BlockItem;
    static CRIMSON_STAIRS: Internal.BlockItem;
    static CREEPER_HEAD: Internal.StandingAndWallBlockItem;
    static JUNGLE_DOOR: Internal.DoubleHighBlockItem;
    static BLACK_TERRACOTTA: Internal.BlockItem;
    static COOKIE: Internal.Item;
    static GRANITE: Internal.BlockItem;
    static LEATHER: Internal.Item;
    static SALMON_BUCKET: Internal.MobBucketItem;
    static DANDELION: Internal.BlockItem;
    static WARPED_HANGING_SIGN: Internal.HangingSignItem;
    static PRISMARINE_BRICK_SLAB: Internal.BlockItem;
    static RED_STAINED_GLASS_PANE: Internal.BlockItem;
    static IRON_HORSE_ARMOR: Internal.HorseArmorItem;
    static IRON_SWORD: Internal.SwordItem;
    static BONE_MEAL: Internal.BoneMealItem;
    static GRAY_STAINED_GLASS: Internal.BlockItem;
    static DEAD_FIRE_CORAL_BLOCK: Internal.BlockItem;
    static POINTED_DRIPSTONE: Internal.BlockItem;
    static PURPUR_SLAB: Internal.BlockItem;
    static BIRCH_LEAVES: Internal.BlockItem;
    static ORANGE_STAINED_GLASS_PANE: Internal.BlockItem;
    static ALLAY_SPAWN_EGG: Internal.SpawnEggItem;
    static COW_SPAWN_EGG: Internal.SpawnEggItem;
    static ARMS_UP_POTTERY_SHERD: Internal.Item;
    static BLUE_WOOL: Internal.BlockItem;
    static LIGHT_BLUE_TERRACOTTA: Internal.BlockItem;
    static MUSIC_DISC_WARD: Internal.RecordItem;
    static PINK_CONCRETE_POWDER: Internal.BlockItem;
    static BLUE_STAINED_GLASS: Internal.BlockItem;
    static ANDESITE_STAIRS: Internal.BlockItem;
    static CHORUS_FRUIT: Internal.ChorusFruitItem;
    static VINE: Internal.BlockItem;
    static COAL_BLOCK: Internal.BlockItem;
    static POLISHED_DEEPSLATE_WALL: Internal.BlockItem;
    static MUSIC_DISC_OTHERSIDE: Internal.RecordItem;
    static MOSSY_STONE_BRICK_STAIRS: Internal.BlockItem;
    static SNOW_GOLEM_SPAWN_EGG: Internal.SpawnEggItem;
    static SCULK: Internal.BlockItem;
    static POLISHED_ANDESITE: Internal.BlockItem;
    static JUNGLE_SIGN: Internal.SignItem;
    static COCOA_BEANS: Internal.ItemNameBlockItem;
    static CYAN_STAINED_GLASS: Internal.BlockItem;
    static BAMBOO_FENCE_GATE: Internal.BlockItem;
    static PURPLE_DYE: Internal.DyeItem;
    static CYAN_TERRACOTTA: Internal.BlockItem;
    static BLACKSTONE_STAIRS: Internal.BlockItem;
    static GLOBE_BANNER_PATTERN: Internal.BannerPatternItem;
    static SPRUCE_LOG: Internal.BlockItem;
    static TUBE_CORAL_BLOCK: Internal.BlockItem;
    static EXPOSED_CUT_COPPER: Internal.BlockItem;
    static GREEN_SHULKER_BOX: Internal.BlockItem;
    static CONDUIT: Internal.BlockItem;
    static GLISTERING_MELON_SLICE: Internal.Item;
    static RAVAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static SKELETON_HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static BRAIN_CORAL_BLOCK: Internal.BlockItem;
    static BAMBOO: Internal.BlockItem;
    static COOKED_PORKCHOP: Internal.Item;
    static GOLDEN_SHOVEL: Internal.ShovelItem;
    static CUT_RED_SANDSTONE_SLAB: Internal.BlockItem;
    static MOSSY_STONE_BRICKS: Internal.BlockItem;
    static DIAMOND_HELMET: Internal.ArmorItem;
    static BAMBOO_DOOR: Internal.DoubleHighBlockItem;
    static POLISHED_BLACKSTONE_BRICK_STAIRS: Internal.BlockItem;
    static SMOOTH_STONE_SLAB: Internal.BlockItem;
    static IRON_LEGGINGS: Internal.ArmorItem;
    static SMOKER: Internal.BlockItem;
    static STRIPPED_BIRCH_WOOD: Internal.BlockItem;
    static SPRUCE_BOAT: Internal.BoatItem;
    static MOSS_CARPET: Internal.BlockItem;
    static FIREWORK_ROCKET: Internal.FireworkRocketItem;
    static OCHRE_FROGLIGHT: Internal.BlockItem;
    static CHISELED_DEEPSLATE: Internal.BlockItem;
    static CHERRY_LEAVES: Internal.BlockItem;
    static NETHER_BRICK_FENCE: Internal.BlockItem;
    static CHISELED_RED_SANDSTONE: Internal.BlockItem;
    static TADPOLE_BUCKET: Internal.MobBucketItem;
    static DRAGON_EGG: Internal.BlockItem;
    static PRIZE_POTTERY_SHERD: Internal.Item;
    static DARK_OAK_PLANKS: Internal.BlockItem;
    static COOKED_RABBIT: Internal.Item;
    static CHERRY_BOAT: Internal.BoatItem;
    static END_STONE_BRICK_WALL: Internal.BlockItem;
    static GREEN_DYE: Internal.DyeItem;
    static MUSIC_DISC_WAIT: Internal.RecordItem;
    static RED_NETHER_BRICK_WALL: Internal.BlockItem;
    static PITCHER_PLANT: Internal.BlockItem;
    static LIME_CONCRETE_POWDER: Internal.BlockItem;
    static PRISMARINE_STAIRS: Internal.BlockItem;
    static MANGROVE_BUTTON: Internal.BlockItem;
    static AMETHYST_CLUSTER: Internal.BlockItem;
    static CHISELED_SANDSTONE: Internal.BlockItem;
    static DEEPSLATE_COAL_ORE: Internal.BlockItem;
    static STRIPPED_MANGROVE_WOOD: Internal.BlockItem;
    static STONE_BUTTON: Internal.BlockItem;
    static RED_DYE: Internal.DyeItem;
    static SPLASH_POTION: Internal.SplashPotionItem;
    static PURPLE_TERRACOTTA: Internal.BlockItem;
    static STRIDER_SPAWN_EGG: Internal.SpawnEggItem;
    static OXEYE_DAISY: Internal.BlockItem;
    static SPRUCE_SLAB: Internal.BlockItem;
    static PINK_STAINED_GLASS_PANE: Internal.BlockItem;
    static STRIPPED_CHERRY_WOOD: Internal.BlockItem;
    static REPEATING_COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static CHERRY_SIGN: Internal.SignItem;
    static CRYING_OBSIDIAN: Internal.BlockItem;
    static RAISER_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static CREEPER_SPAWN_EGG: Internal.SpawnEggItem;
    static BAMBOO_BLOCK: Internal.BlockItem;
    static SCULK_SHRIEKER: Internal.BlockItem;
    static GOLDEN_HORSE_ARMOR: Internal.HorseArmorItem;
    static POLISHED_DEEPSLATE: Internal.BlockItem;
    static YELLOW_CONCRETE: Internal.BlockItem;
    static LIGHT_GRAY_WOOL: Internal.BlockItem;
    static PINK_PETALS: Internal.BlockItem;
    static YELLOW_DYE: Internal.DyeItem;
    static CRIMSON_DOOR: Internal.DoubleHighBlockItem;
    static PURPLE_CARPET: Internal.BlockItem;
    static WITHER_SPAWN_EGG: Internal.SpawnEggItem;
    static BEETROOT_SOUP: Internal.BowlFoodItem;
    static CRIMSON_ROOTS: Internal.BlockItem;
    static BLACKSTONE: Internal.BlockItem;
    static FLOWERING_AZALEA_LEAVES: Internal.BlockItem;
    static OAK_BOAT: Internal.BoatItem;
    static POLISHED_ANDESITE_STAIRS: Internal.BlockItem;
    static BROWN_BED: Internal.BedItem;
    static BLUE_CANDLE: Internal.BlockItem;
    static STRIPPED_CRIMSON_HYPHAE: Internal.BlockItem;
    static POLISHED_DEEPSLATE_STAIRS: Internal.BlockItem;
    static SPRUCE_WOOD: Internal.BlockItem;
    static BAMBOO_HANGING_SIGN: Internal.HangingSignItem;
    static TARGET: Internal.BlockItem;
    static SOUL_SAND: Internal.BlockItem;
    static DAYLIGHT_DETECTOR: Internal.BlockItem;
    static MOOSHROOM_SPAWN_EGG: Internal.SpawnEggItem;
    static LIGHT_BLUE_GLAZED_TERRACOTTA: Internal.BlockItem;
    static PRISMARINE_BRICKS: Internal.BlockItem;
    static DAMAGED_ANVIL: Internal.BlockItem;
    static YELLOW_TERRACOTTA: Internal.BlockItem;
    static RAW_IRON_BLOCK: Internal.BlockItem;
    static TROPICAL_FISH_SPAWN_EGG: Internal.SpawnEggItem;
    static BAMBOO_STAIRS: Internal.BlockItem;
    static INK_SAC: Internal.InkSacItem;
    static LINGERING_POTION: Internal.LingeringPotionItem;
    static BRAIN_CORAL: Internal.BlockItem;
    static SPRUCE_DOOR: Internal.DoubleHighBlockItem;
    static GILDED_BLACKSTONE: Internal.BlockItem;
    static PRISMARINE: Internal.BlockItem;
    static SOUL_CAMPFIRE: Internal.BlockItem;
    static LECTERN: Internal.BlockItem;
    static SHROOMLIGHT: Internal.BlockItem;
    static GOLD_BLOCK: Internal.BlockItem;
    static BRICK_SLAB: Internal.BlockItem;
    static MUD_BRICKS: Internal.BlockItem;
    static JUNGLE_FENCE: Internal.BlockItem;
    static SNIFFER_SPAWN_EGG: Internal.SpawnEggItem;
    static CHERRY_TRAPDOOR: Internal.BlockItem;
    static MANGROVE_LEAVES: Internal.BlockItem;
    static PAINTING: Internal.HangingEntityItem;
    static MANGROVE_HANGING_SIGN: Internal.HangingSignItem;
    static IRON_BLOCK: Internal.BlockItem;
    static ARROW: Internal.ArrowItem;
    static DEAD_BUBBLE_CORAL_BLOCK: Internal.BlockItem;
    static STRIPPED_DARK_OAK_LOG: Internal.BlockItem;
    static WHITE_CARPET: Internal.BlockItem;
    static DIAMOND_BLOCK: Internal.BlockItem;
    static CRIMSON_STEM: Internal.BlockItem;
    static SOUL_LANTERN: Internal.BlockItem;
    static BLUE_BANNER: Internal.BannerItem;
    static WRITABLE_BOOK: Internal.WritableBookItem;
    static PURPLE_SHULKER_BOX: Internal.BlockItem;
    static CUT_RED_SANDSTONE: Internal.BlockItem;
    static LIME_CANDLE: Internal.BlockItem;
    static STRAY_SPAWN_EGG: Internal.SpawnEggItem;
    static STRIPPED_BIRCH_LOG: Internal.BlockItem;
    static DEEPSLATE_TILE_WALL: Internal.BlockItem;
    static SLIME_BLOCK: Internal.BlockItem;
    static NETHER_WART_BLOCK: Internal.BlockItem;
    static DEEPSLATE_TILE_SLAB: Internal.BlockItem;
    static BAMBOO_MOSAIC_SLAB: Internal.BlockItem;
    static END_STONE_BRICKS: Internal.BlockItem;
    static SKELETON_SPAWN_EGG: Internal.SpawnEggItem;
    static CRIMSON_FENCE: Internal.BlockItem;
    static SUSPICIOUS_SAND: Internal.BlockItem;
    static CRACKED_NETHER_BRICKS: Internal.BlockItem;
    static STRUCTURE_BLOCK: Internal.GameMasterBlockItem;
    static CAT_SPAWN_EGG: Internal.SpawnEggItem;
    static IRON_BOOTS: Internal.ArmorItem;
    static STRIPPED_OAK_WOOD: Internal.BlockItem;
    static PISTON: Internal.BlockItem;
    static NETHERITE_UPGRADE_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static DEEPSLATE_BRICK_WALL: Internal.BlockItem;
    static COD_BUCKET: Internal.MobBucketItem;
    static HONEY_BOTTLE: Internal.HoneyBottleItem;
    static EXPOSED_COPPER: Internal.BlockItem;
    static MUSIC_DISC_STRAD: Internal.RecordItem;
    static GREEN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static PINK_BED: Internal.BedItem;
    static LADDER: Internal.BlockItem;
    static SCULK_CATALYST: Internal.BlockItem;
    static BLUE_CONCRETE: Internal.BlockItem;
    static BLUE_STAINED_GLASS_PANE: Internal.BlockItem;
    static SNOW_BLOCK: Internal.BlockItem;
    static BAMBOO_CHEST_RAFT: Internal.BoatItem;
    static SALMON: Internal.Item;
    static DISPENSER: Internal.BlockItem;
    static DIAMOND_BOOTS: Internal.ArmorItem;
    static OAK_STAIRS: Internal.BlockItem;
    static RED_BANNER: Internal.BannerItem;
    static IRON_AXE: Internal.AxeItem;
    static DEEPSLATE_LAPIS_ORE: Internal.BlockItem;
    static SILVERFISH_SPAWN_EGG: Internal.SpawnEggItem;
    static ENDERMAN_SPAWN_EGG: Internal.SpawnEggItem;
    static GOLDEN_AXE: Internal.AxeItem;
    static OAK_FENCE_GATE: Internal.BlockItem;
    static GRANITE_STAIRS: Internal.BlockItem;
    static CHARCOAL: Internal.Item;
    static WOODEN_PICKAXE: Internal.PickaxeItem;
    static MELON: Internal.BlockItem;
    static ECHO_SHARD: Internal.Item;
    static BAMBOO_PLANKS: Internal.BlockItem;
    static DIRT_PATH: Internal.BlockItem;
    static DEEPSLATE: Internal.BlockItem;
    static WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE: Internal.SmithingTemplateItem;
    static WHITE_BED: Internal.BedItem;
    static DIORITE_STAIRS: Internal.BlockItem;
    static MANGROVE_FENCE_GATE: Internal.BlockItem;
    static RECOVERY_COMPASS: Internal.Item;
    static SNOW: Internal.BlockItem;
    static GRAY_GLAZED_TERRACOTTA: Internal.BlockItem;
    static GHAST_TEAR: Internal.Item;
    static GOLDEN_CARROT: Internal.Item;
    static FERN: Internal.BlockItem;
    static CORNFLOWER: Internal.BlockItem;
    static CHAIN_COMMAND_BLOCK: Internal.GameMasterBlockItem;
    static ZOMBIE_VILLAGER_SPAWN_EGG: Internal.SpawnEggItem;
    static LIME_STAINED_GLASS_PANE: Internal.BlockItem;
    static JUNGLE_FENCE_GATE: Internal.BlockItem;
    static GREEN_BANNER: Internal.BannerItem;
    static TRIPWIRE_HOOK: Internal.BlockItem;
    static EVOKER_SPAWN_EGG: Internal.SpawnEggItem;
    static SALMON_SPAWN_EGG: Internal.SpawnEggItem;
    static DEEPSLATE_BRICK_SLAB: Internal.BlockItem;
    static RAW_GOLD: Internal.Item;
    static BIRCH_SIGN: Internal.SignItem;
    static FROGSPAWN: Internal.PlaceOnWaterBlockItem;
    static SADDLE: Internal.SaddleItem;
    static YELLOW_WOOL: Internal.BlockItem;
    static TRIDENT: Internal.TridentItem;
    static LIGHT_BLUE_CONCRETE: Internal.BlockItem;
    static WARPED_BUTTON: Internal.BlockItem;
    static POLISHED_BLACKSTONE_BUTTON: Internal.BlockItem;
    static SLIME_SPAWN_EGG: Internal.SpawnEggItem;
    static OAK_WOOD: Internal.BlockItem;
    static ENDER_CHEST: Internal.BlockItem;
    static REDSTONE_BLOCK: Internal.BlockItem;
    static ORANGE_BED: Internal.BedItem;
    static CUT_COPPER_SLAB: Internal.BlockItem;
    static WANDERING_TRADER_SPAWN_EGG: Internal.SpawnEggItem;
    static WAXED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static CRIMSON_FENCE_GATE: Internal.BlockItem;
    static WAXED_WEATHERED_CUT_COPPER: Internal.BlockItem;
    static WAXED_OXIDIZED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static QUARTZ_BLOCK: Internal.BlockItem;
    static BAMBOO_SLAB: Internal.BlockItem;
    static RAIL: Internal.BlockItem;
    static EMERALD_BLOCK: Internal.BlockItem;
    static CUT_COPPER: Internal.BlockItem;
    static POPPY: Internal.BlockItem;
    static ACACIA_BUTTON: Internal.BlockItem;
    static ANDESITE_WALL: Internal.BlockItem;
    static LEATHER_HELMET: Internal.DyeableArmorItem;
    static ACACIA_SAPLING: Internal.BlockItem;
    static CARTOGRAPHY_TABLE: Internal.BlockItem;
    static RED_TULIP: Internal.BlockItem;
    static TRAPPED_CHEST: Internal.BlockItem;
    static MANGROVE_LOG: Internal.BlockItem;
    static DARK_OAK_PRESSURE_PLATE: Internal.BlockItem;
    static CHERRY_LOG: Internal.BlockItem;
    static CHIPPED_ANVIL: Internal.BlockItem;
    static MAGMA_BLOCK: Internal.BlockItem;
    static GUNPOWDER: Internal.Item;
    static OXIDIZED_COPPER: Internal.BlockItem;
    static BLACK_SHULKER_BOX: Internal.BlockItem;
    static BLUE_DYE: Internal.DyeItem;
    static PACKED_ICE: Internal.BlockItem;
    static PEONY: Internal.DoubleHighBlockItem;
    static CRIMSON_FUNGUS: Internal.BlockItem;
    static JUNGLE_PRESSURE_PLATE: Internal.BlockItem;
    static JUNGLE_WOOD: Internal.BlockItem;
    static ORANGE_SHULKER_BOX: Internal.BlockItem;
    static BEETROOT_SEEDS: Internal.ItemNameBlockItem;
    static IRON_CHESTPLATE: Internal.ArmorItem;
    static GOLDEN_APPLE: Internal.Item;
    static LIGHT_BLUE_BED: Internal.BedItem;
    static WARPED_TRAPDOOR: Internal.BlockItem;
    static CACTUS: Internal.BlockItem;
    static TORCH: Internal.StandingAndWallBlockItem;
    static GLASS_BOTTLE: Internal.BottleItem;
    static MAGENTA_SHULKER_BOX: Internal.BlockItem;
    static STRUCTURE_VOID: Internal.BlockItem;
    static DEAD_TUBE_CORAL_BLOCK: Internal.BlockItem;
    static GREEN_CONCRETE_POWDER: Internal.BlockItem;
    static MUSIC_DISC_BLOCKS: Internal.RecordItem;
    static COOKED_BEEF: Internal.Item;
    static DIAMOND_SHOVEL: Internal.ShovelItem;
    static WOODEN_SWORD: Internal.SwordItem;
    static CRIMSON_SIGN: Internal.SignItem;
    static NETHER_BRICK: Internal.Item;
    static STONE_AXE: Internal.AxeItem;
    static DEAD_BUSH: Internal.BlockItem;
    static CYAN_GLAZED_TERRACOTTA: Internal.BlockItem;
    static SPRUCE_CHEST_BOAT: Internal.BoatItem;
    static DEEPSLATE_BRICK_STAIRS: Internal.BlockItem;
    static WHITE_BANNER: Internal.BannerItem;
    static GRANITE_SLAB: Internal.BlockItem;
    static MOSSY_STONE_BRICK_SLAB: Internal.BlockItem;
    static OAK_SLAB: Internal.BlockItem;
    static DEAD_BUBBLE_CORAL: Internal.BlockItem;
    static WARPED_FENCE_GATE: Internal.BlockItem;
    static MINER_POTTERY_SHERD: Internal.Item;
    static BROWN_MUSHROOM: Internal.BlockItem;
    static SPRUCE_PLANKS: Internal.BlockItem;
    static WOLF_SPAWN_EGG: Internal.SpawnEggItem;
    static MAGENTA_BANNER: Internal.BannerItem;
    static CYAN_SHULKER_BOX: Internal.BlockItem;
    static WAXED_EXPOSED_CUT_COPPER_STAIRS: Internal.BlockItem;
    static RAW_IRON: Internal.Item;
    static WEATHERED_CUT_COPPER_SLAB: Internal.BlockItem;
    static RED_SANDSTONE: Internal.BlockItem;
    static STRIPPED_DARK_OAK_WOOD: Internal.BlockItem;
    static BAMBOO_FENCE: Internal.BlockItem;
    static INFESTED_DEEPSLATE: Internal.BlockItem;
    static IRON_BARS: Internal.BlockItem;
    static SANDSTONE_STAIRS: Internal.BlockItem;
    static BEDROCK: Internal.BlockItem;
    static MOURNER_POTTERY_SHERD: Internal.Item;
    static STRIPPED_CHERRY_LOG: Internal.BlockItem;
    static TNT_MINECART: Internal.MinecartItem;
    static BEE_NEST: Internal.BlockItem;
    static ACTIVATOR_RAIL: Internal.BlockItem;
    static MUSIC_DISC_5: Internal.RecordItem;
    static DEAD_FIRE_CORAL_FAN: Internal.StandingAndWallBlockItem;
    static GOLDEN_HELMET: Internal.ArmorItem;
    static STRIPPED_WARPED_HYPHAE: Internal.BlockItem;
    static MAGENTA_CARPET: Internal.BlockItem;
    static TORCHFLOWER_SEEDS: Internal.ItemNameBlockItem;
    static HONEY_BLOCK: Internal.BlockItem;
    static STRIPPED_ACACIA_LOG: Internal.BlockItem;
    static FRIEND_POTTERY_SHERD: Internal.Item;
    static RAW_GOLD_BLOCK: Internal.BlockItem;
    static WARPED_FUNGUS_ON_A_STICK: Internal.Item;
    static SMOOTH_SANDSTONE: Internal.BlockItem;
    static SPRUCE_SAPLING: Internal.BlockItem;
    static DOLPHIN_SPAWN_EGG: Internal.SpawnEggItem;
    static NETHERITE_PICKAXE: Internal.PickaxeItem;
    static GRANITE_WALL: Internal.BlockItem;
    static BRICK_STAIRS: Internal.BlockItem;
    static LIME_WOOL: Internal.BlockItem;
    static CHAINMAIL_CHESTPLATE: Internal.ArmorItem;
    static WOODEN_HOE: Internal.HoeItem;
    static HORSE_SPAWN_EGG: Internal.SpawnEggItem;
    static WATER_BUCKET: Internal.BucketItem;
    static SMOOTH_QUARTZ_SLAB: Internal.BlockItem;
    static WAXED_CUT_COPPER: Internal.BlockItem;
    static HORN_CORAL: Internal.BlockItem;
    static BLACKSTONE_WALL: Internal.BlockItem;
    static MUSIC_DISC_STAL: Internal.RecordItem;
    static SPONGE: Internal.BlockItem;
    static PIGLIN_BANNER_PATTERN: Internal.BannerPatternItem;
    static RAW_COPPER: Internal.Item;
    static DARK_OAK_BOAT: Internal.BoatItem;
    static REDSTONE_ORE: Internal.BlockItem;
    static ANDESITE_SLAB: Internal.BlockItem;
    static BOWL: Internal.Item;
    static BLACK_WOOL: Internal.BlockItem;
    static COBBLED_DEEPSLATE_STAIRS: Internal.BlockItem;
    static BEEF: Internal.Item;
    static COBBLESTONE_SLAB: Internal.BlockItem;
    static CYAN_CANDLE: Internal.BlockItem;
    static ACACIA_DOOR: Internal.DoubleHighBlockItem;
    static SPRUCE_STAIRS: Internal.BlockItem;
    static HEARTBREAK_POTTERY_SHERD: Internal.Item;
    static CRIMSON_HYPHAE: Internal.BlockItem;
}
type Items_ = Items;
declare interface NBTIO {
    write(path: Internal.Path_, nbt: Internal.CompoundTag_): void;
    read(path: Internal.Path_): Internal.CompoundTag;
}
type NBTIO_ = NBTIO;
declare const NBTIO: NBTIO;
declare class SoundType {
    constructor(arg0: number, arg1: number, arg2: Internal.SoundEvent_, arg3: Internal.SoundEvent_, arg4: Internal.SoundEvent_, arg5: Internal.SoundEvent_, arg6: Internal.SoundEvent_)
    getVolume(): number;
    getPitch(): number;
    getHitSound(): Internal.SoundEvent;
    getStepSound(): Internal.SoundEvent;
    getBreakSound(): Internal.SoundEvent;
    getFallSound(): Internal.SoundEvent;
    getPlaceSound(): Internal.SoundEvent;
    get volume(): number
    get pitch(): number
    get hitSound(): Internal.SoundEvent
    get stepSound(): Internal.SoundEvent
    get breakSound(): Internal.SoundEvent
    get fallSound(): Internal.SoundEvent
    get placeSound(): Internal.SoundEvent
    static readonly EMPTY: SoundType;
    static readonly SAND: SoundType;
    static readonly DECORATED_POT: SoundType;
    static readonly TUFF: SoundType;
    static readonly GRAVEL: SoundType;
    static readonly SHROOMLIGHT: SoundType;
    static readonly MOSS: SoundType;
    readonly pitch: number;
    static readonly GRASS: SoundType;
    static readonly SOUL_SOIL: SoundType;
    static readonly WEEPING_VINES: SoundType;
    static readonly ANCIENT_DEBRIS: SoundType;
    static readonly SCULK_SENSOR: SoundType;
    static readonly POINTED_DRIPSTONE: SoundType;
    static readonly ROOTED_DIRT: SoundType;
    static readonly FROGSPAWN: SoundType;
    static readonly NETHER_ORE: SoundType;
    static readonly COPPER: SoundType;
    static readonly LANTERN: SoundType;
    static readonly BONE_BLOCK: SoundType;
    static readonly FROGLIGHT: SoundType;
    static readonly SNOW: SoundType;
    static readonly SCULK_VEIN: SoundType;
    static readonly CHERRY_WOOD: SoundType;
    static readonly POLISHED_DEEPSLATE: SoundType;
    static readonly NYLIUM: SoundType;
    static readonly DEEPSLATE: SoundType;
    static readonly SPORE_BLOSSOM: SoundType;
    static readonly BASALT: SoundType;
    static readonly CHERRY_WOOD_HANGING_SIGN: SoundType;
    static readonly SMALL_AMETHYST_BUD: SoundType;
    static readonly CANDLE: SoundType;
    static readonly FLOWERING_AZALEA: SoundType;
    static readonly ANVIL: SoundType;
    static readonly SCAFFOLDING: SoundType;
    static readonly DEEPSLATE_BRICKS: SoundType;
    static readonly CORAL_BLOCK: SoundType;
    static readonly BAMBOO_SAPLING: SoundType;
    static readonly LILY_PAD: SoundType;
    static readonly MOSS_CARPET: SoundType;
    static readonly LADDER: SoundType;
    static readonly LARGE_AMETHYST_BUD: SoundType;
    static readonly GLOW_LICHEN: SoundType;
    static readonly CROP: SoundType;
    static readonly PINK_PETALS: SoundType;
    static readonly AZALEA_LEAVES: SoundType;
    static readonly POWDER_SNOW: SoundType;
    static readonly METAL: SoundType;
    static readonly HONEY_BLOCK: SoundType;
    static readonly NETHER_BRICKS: SoundType;
    static readonly SUSPICIOUS_SAND: SoundType;
    static readonly GILDED_BLACKSTONE: SoundType;
    static readonly HARD_CROP: SoundType;
    static readonly SCULK_CATALYST: SoundType;
    static readonly DEEPSLATE_TILES: SoundType;
    static readonly PACKED_MUD: SoundType;
    static readonly SCULK: SoundType;
    static readonly VINE: SoundType;
    static readonly BAMBOO: SoundType;
    static readonly GLASS: SoundType;
    static readonly DRIPSTONE_BLOCK: SoundType;
    static readonly CHERRY_SAPLING: SoundType;
    static readonly CALCITE: SoundType;
    static readonly MUD_BRICKS: SoundType;
    static readonly STEM: SoundType;
    static readonly BAMBOO_WOOD: SoundType;
    static readonly SOUL_SAND: SoundType;
    static readonly MUD: SoundType;
    static readonly BIG_DRIPLEAF: SoundType;
    static readonly BAMBOO_WOOD_HANGING_SIGN: SoundType;
    static readonly TWISTING_VINES: SoundType;
    static readonly NETHERRACK: SoundType;
    static readonly AMETHYST_CLUSTER: SoundType;
    static readonly SLIME_BLOCK: SoundType;
    static readonly SCULK_SHRIEKER: SoundType;
    static readonly CHAIN: SoundType;
    static readonly WOOD: SoundType;
    static readonly AZALEA: SoundType;
    static readonly MANGROVE_ROOTS: SoundType;
    static readonly CHISELED_BOOKSHELF: SoundType;
    static readonly NETHER_GOLD_ORE: SoundType;
    static readonly CHERRY_LEAVES: SoundType;
    static readonly AMETHYST: SoundType;
    static readonly DECORATED_POT_CRACKED: SoundType;
    static readonly CAVE_VINES: SoundType;
    static readonly SUSPICIOUS_GRAVEL: SoundType;
    static readonly LODESTONE: SoundType;
    readonly volume: number;
    static readonly FUNGUS: SoundType;
    static readonly SMALL_DRIPLEAF: SoundType;
    static readonly HANGING_ROOTS: SoundType;
    static readonly SWEET_BERRY_BUSH: SoundType;
    static readonly NETHER_WOOD: SoundType;
    static readonly NETHER_WART: SoundType;
    static readonly STONE: SoundType;
    static readonly NETHER_WOOD_HANGING_SIGN: SoundType;
    static readonly HANGING_SIGN: SoundType;
    static readonly WET_GRASS: SoundType;
    static readonly NETHERITE_BLOCK: SoundType;
    static readonly MEDIUM_AMETHYST_BUD: SoundType;
    static readonly MUDDY_MANGROVE_ROOTS: SoundType;
    static readonly WOOL: SoundType;
    static readonly ROOTS: SoundType;
    static readonly WART_BLOCK: SoundType;
    static readonly NETHER_SPROUTS: SoundType;
}
type SoundType_ = SoundType;
declare class Duration implements Internal.TemporalAmount, Internal.Comparable<Duration>, Internal.Serializable {
    static parse(arg0: Internal.CharSequence_): Duration;
    minusHours(arg0: number): this;
    compareTo(arg0: any): number;
    plusMillis(arg0: number): this;
    toNanosPart(): number;
    getUnits(): Internal.List<Internal.TemporalUnit>;
    multipliedBy(arg0: number): this;
    dividedBy(arg0: number): this;
    get(arg0: Internal.TemporalUnit_): number;
    minusNanos(arg0: number): this;
    static ofSeconds(arg0: number): Duration;
    minus(arg0: Duration_): this;
    isNegative(): boolean;
    static ofMinutes(arg0: number): Duration;
    static ofNanos(arg0: number): Duration;
    toDays(): number;
    toHoursPart(): number;
    minusDays(arg0: number): this;
    toSecondsPart(): number;
    static ofMillis(arg0: number): Duration;
    plusNanos(arg0: number): this;
    minusSeconds(arg0: number): this;
    toMinutes(): number;
    plus(arg0: number, arg1: Internal.TemporalUnit_): this;
    toMillis(): number;
    toHours(): number;
    getSeconds(): number;
    static ofSeconds(arg0: number, arg1: number): Duration;
    toMinutesPart(): number;
    isZero(): boolean;
    withSeconds(arg0: number): this;
    static of(arg0: number, arg1: Internal.TemporalUnit_): Duration;
    static between(arg0: Internal.Temporal_, arg1: Internal.Temporal_): Duration;
    plusSeconds(arg0: number): this;
    plusMinutes(arg0: number): this;
    toNanos(): number;
    negated(): this;
    static ofDays(arg0: number): Duration;
    addTo(arg0: Internal.Temporal_): Internal.Temporal;
    compareTo(arg0: Duration_): number;
    minus(arg0: number, arg1: Internal.TemporalUnit_): this;
    plus(arg0: Duration_): this;
    toDaysPart(): number;
    plusDays(arg0: number): this;
    getNano(): number;
    truncatedTo(arg0: Internal.TemporalUnit_): this;
    plusHours(arg0: number): this;
    static from(arg0: Internal.TemporalAmount_): Duration;
    subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
    minusMillis(arg0: number): this;
    dividedBy(arg0: Duration_): number;
    minusMinutes(arg0: number): this;
    static ofHours(arg0: number): Duration;
    abs(): this;
    withNanos(arg0: number): this;
    toSeconds(): number;
    toMillisPart(): number;
    get units(): Internal.List<Internal.TemporalUnit>
    get negative(): boolean
    get seconds(): number
    get zero(): boolean
    get nano(): number
    static readonly ZERO: Duration;
}
type Duration_ = Duration;
declare class OutputItem implements Internal.OutputReplacement {
    getNbt(): Internal.CompoundTag;
    getCount(): number;
    transform(transformer: Internal.OutputReplacementTransformer_): Internal.OutputReplacementTransformer$Replacement;
    withRolls(rolls: Internal.IntProvider_): this;
    getChance(): number;
    static of(from: any): OutputItem;
    isEmpty(): boolean;
    withCount(count: number): this;
    weakNBT(): InputItem;
    strongNBT(): InputItem;
    replaceOutput(recipe: Internal.RecipeJS_, match: Internal.ReplacementMatch_, original: Internal.OutputReplacement_): any;
    static of(item: Internal.ItemStack_, chance: number): OutputItem;
    withChance(chance: number): this;
    withRolls(min: number, max: number): this;
    hasChance(): boolean;
    /**
     * @deprecated
    */
    ignoreNBT(): InputItem;
    get nbt(): Internal.CompoundTag
    get count(): number
    get chance(): number
    get empty(): boolean
    static readonly EMPTY: OutputItem;
    readonly item: Internal.ItemStack;
    readonly rolls: Internal.IntProvider;
    readonly chance: number;
}
type OutputItem_ = Internal.ItemStack_ | OutputItem;
declare class DamageSource {
    constructor(arg0: Internal.Holder_<Internal.DamageType>)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Vec3d_)
    constructor(arg0: Internal.Holder_<Internal.DamageType>, arg1: Internal.Entity_, arg2: Internal.Entity_, arg3: Vec3d_)
    getSourcePosition(): Vec3d;
    isIndirect(): boolean;
    scalesWithDifficulty(): boolean;
    getImmediate(): Internal.Entity;
    typeHolder(): Internal.Holder<Internal.DamageType>;
    getFoodExhaustion(): number;
    getLocalizedDeathMessage(arg0: Internal.LivingEntity_): net.minecraft.network.chat.Component;
    sourcePositionRaw(): Vec3d;
    is(arg0: Internal.ResourceKey_<Internal.DamageType>): boolean;
    is(arg0: Internal.TagKey_<Internal.DamageType>): boolean;
    isCreativePlayer(): boolean;
    type(): Internal.DamageType;
    getType(): string;
    getActual(): Internal.Entity;
    getPlayer(): Internal.Player;
    get sourcePosition(): Vec3d
    get indirect(): boolean
    get immediate(): Internal.Entity
    get foodExhaustion(): number
    get creativePlayer(): boolean
    get type(): string
    get actual(): Internal.Entity
    get player(): Internal.Player
}
type DamageSource_ = DamageSource;
declare class Platform {
    constructor()
    static getMinecraftVersion(): number;
    static getMcVersion(): string;
    static isDevelopmentEnvironment(): boolean;
    static getList(): Internal.Set<string>;
    static isClientEnvironment(): boolean;
    static isForge(): boolean;
    static isFabric(): boolean;
    static breakpoint(...args: any[]): void;
    static getModVersion(): string;
    static isGeneratingData(): boolean;
    static getMinecraftVersionString(): string;
    static getInfo(modID: string): Internal.PlatformWrapper$ModInfo;
    static getMods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>;
    static isLoaded(modId: string): boolean;
    static getName(): string;
    static setModName(modId: string, name: string): void;
    get minecraftVersion(): number
    get mcVersion(): string
    get developmentEnvironment(): boolean
    get list(): Internal.Set<string>
    get clientEnvironment(): boolean
    get forge(): boolean
    get fabric(): boolean
    get modVersion(): string
    get generatingData(): boolean
    get minecraftVersionString(): string
    get mods(): Internal.Map<string, Internal.PlatformWrapper$ModInfo>
    get name(): string
}
type Platform_ = Platform;
declare class Vec3f implements Internal.Cloneable, Internal.Vector3fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Vector3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.Vector2fc_, arg1: number)
    constructor(arg0: Internal.Vector2ic_, arg1: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3ic_)
    set(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    div(arg0: number, arg1: number, arg2: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    equals(arg0: number, arg1: number, arg2: number): boolean;
    add(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    rotateY(arg0: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    angleCos(arg0: Internal.Vector3fc_): number;
    set(arg0: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_): this;
    static length(arg0: number, arg1: number, arg2: number): number;
    set(arg0: Internal.FloatBuffer_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_): this;
    normalize(arg0: number, arg1: Vec3f_): this;
    sub(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    half(arg0: number, arg1: number, arg2: number): this;
    z(): number;
    round(): this;
    mulPositionW(arg0: Internal.Matrix4fc_, arg1: Vec3f_): number;
    mulDirection(arg0: Internal.Matrix4fc_): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    toString(arg0: Internal.NumberFormat_): string;
    add(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    lengthSquared(): number;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    get(arg0: number): number;
    mul(arg0: number, arg1: number, arg2: number): this;
    mulTranspose(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): this;
    ceil(arg0: Vec3f_): this;
    negate(): this;
    clone(): any;
    cross(arg0: Internal.Vector3fc_): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    static lengthSquared(arg0: number, arg1: number, arg2: number): number;
    add(arg0: Internal.Vector3fc_): this;
    mul(arg0: number): this;
    set(arg0: Internal.Vector3dc_): this;
    div(arg0: number, arg1: Vec3f_): this;
    ceil(): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    distanceSquared(arg0: number, arg1: number, arg2: number): number;
    dot(arg0: number, arg1: number, arg2: number): number;
    add(arg0: number, arg1: number, arg2: number): this;
    mulTransposeDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    mulTranspose(arg0: Internal.Matrix3fc_): this;
    rotateZ(arg0: number): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    distanceSquared(arg0: Internal.Vector3fc_): number;
    floor(): this;
    set(arg0: number[]): this;
    zero(): this;
    reflect(arg0: number, arg1: number, arg2: number): this;
    equals(arg0: Internal.Vector3fc_, arg1: number): boolean;
    mulProject(arg0: Internal.Matrix4fc_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mulAdd(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    max(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    sub(arg0: number, arg1: number, arg2: number): this;
    mulPosition(arg0: Internal.Matrix4x3fc_): this;
    length(): number;
    mulPositionW(arg0: Internal.Matrix4fc_): number;
    mulPosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    rotationTo(arg0: number, arg1: number, arg2: number, arg3: Quaternionf_): Quaternionf;
    mul(arg0: Internal.Matrix3x2fc_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_, arg1: Vec3f_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    setComponent(arg0: number, arg1: number): this;
    div(arg0: number): this;
    rotateZ(arg0: number, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    orthogonalize(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    div(arg0: Internal.Vector3fc_): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    set(arg0: number): this;
    absolute(arg0: Vec3f_): this;
    angleSigned(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): number;
    set(arg0: Internal.Vector3ic_): this;
    min(arg0: Internal.Vector3fc_): this;
    half(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    cross(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    normalize(arg0: number): this;
    normalize(arg0: Vec3f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: number, arg2: Vec3f_): this;
    normalize(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Vector3fc_): this;
    mulTransposePosition(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    floor(arg0: Vec3f_): this;
    isFinite(): boolean;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Vec3f_): this;
    getToAddress(arg0: number): Internal.Vector3fc;
    half(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    smoothStep(arg0: Internal.Vector3fc_, arg1: number, arg2: Vec3f_): this;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number): this;
    x(): number;
    mul(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    absolute(): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulDirection(arg0: Internal.Matrix4dc_): this;
    set(arg0: Internal.Vector2dc_, arg1: number): this;
    negate(arg0: Vec3f_): this;
    mul(arg0: number, arg1: Vec3f_): this;
    mulPosition(arg0: Internal.Matrix4fc_): this;
    hermite(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: number, arg4: Vec3f_): this;
    mulDirection(arg0: Internal.Matrix4dc_, arg1: Vec3f_): this;
    mulAdd(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Internal.Vector3d_): Internal.Vector3d;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateY(arg0: number, arg1: Vec3f_): this;
    fma(arg0: number, arg1: Internal.Vector3fc_): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    sub(arg0: Internal.Vector3fc_): this;
    distance(arg0: number, arg1: number, arg2: number): number;
    minComponent(): number;
    orthogonalize(arg0: Internal.Vector3fc_): this;
    set(arg0: Internal.Vector3fc_): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec3f_): this;
    dot(arg0: Internal.Vector3fc_): number;
    div(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    cross(arg0: number, arg1: number, arg2: number): this;
    orthogonalizeUnit(arg0: Internal.Vector3fc_): this;
    min(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    set(arg0: Internal.ByteBuffer_): this;
    rotateX(arg0: number): this;
    lerp(arg0: Internal.Vector3fc_, arg1: number): this;
    set(arg0: Internal.Vector2ic_, arg1: number): this;
    round(arg0: Vec3f_): this;
    half(arg0: Internal.Vector3fc_): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): this;
    mul(arg0: Internal.Matrix3dc_, arg1: Vec3f_): this;
    rotationTo(arg0: Internal.Vector3fc_, arg1: Quaternionf_): Quaternionf;
    mulTransposePosition(arg0: Internal.Matrix4fc_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    angle(arg0: Internal.Vector3fc_): number;
    mul(arg0: Internal.Vector3fc_, arg1: Vec3f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Vec3f_): this;
    y(): number;
    get(arg0: number, arg1: Internal.Vector3i_): Internal.Vector3i;
    set(arg0: Internal.Vector2fc_, arg1: number): this;
    angleSigned(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): number;
    fma(arg0: number, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    mulDirection(arg0: Internal.Matrix4x3fc_): this;
    distance(arg0: Internal.Vector3fc_): number;
    mulDirection(arg0: Internal.Matrix4fc_, arg1: Vec3f_): this;
    fma(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_): this;
    get(arg0: Vec3f_): this;
    rotateX(arg0: number, arg1: Vec3f_): this;
    max(arg0: Internal.Vector3fc_): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3dc_): this;
    setFromAddress(arg0: number): this;
    get finite(): boolean
    set fromAddress(arg0: number)
    z: number;
    y: number;
    x: number;
}
type Vec3f_ = Vec3f;
declare class Vec4f implements Internal.Cloneable, Internal.Vector4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: Internal.FloatBuffer_)
    constructor(arg0: Internal.Vector2fc_, arg1: number, arg2: number)
    constructor(arg0: Internal.Vector3fc_, arg1: number)
    constructor(arg0: number[])
    constructor(arg0: number)
    constructor(arg0: Internal.ByteBuffer_)
    constructor(arg0: Internal.Vector2ic_, arg1: number, arg2: number)
    constructor(arg0: number, arg1: Internal.ByteBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number)
    constructor(arg0: Internal.Vector4fc_)
    constructor(arg0: Internal.Vector3ic_, arg1: number)
    constructor(arg0: Internal.Vector4ic_)
    min(arg0: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector4ic_): this;
    div(arg0: Internal.Vector4fc_): this;
    normalize3(arg0: Vec4f_): this;
    static distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    rotateAbout(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mul(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    add(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mul(arg0: Internal.Vector4fc_): this;
    dot(arg0: number, arg1: number, arg2: number, arg3: number): number;
    setComponent(arg0: number, arg1: number): this;
    fma(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    rotateZ(arg0: number, arg1: Vec4f_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    z(): number;
    div(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    min(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    set(arg0: Internal.Vector2ic_, arg1: number, arg2: number): this;
    dot(arg0: Internal.Vector4fc_): number;
    set(arg0: number, arg1: number, arg2: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    rotateZ(arg0: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    fma(arg0: number, arg1: Internal.Vector4fc_): this;
    normalize3(): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lengthSquared(): number;
    round(arg0: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    distanceSquared(arg0: Internal.Vector4fc_): number;
    get(arg0: number): number;
    set(arg0: number[]): this;
    sub(arg0: Internal.Vector4fc_): this;
    mulAdd(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    set(arg0: Internal.Vector3ic_, arg1: number): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    clone(): any;
    mul(arg0: number, arg1: number, arg2: number, arg3: number): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    maxComponent(): number;
    set(arg0: Internal.Vector4fc_): this;
    negate(arg0: Vec4f_): this;
    getToAddress(arg0: number): Internal.Vector4fc;
    get(arg0: Internal.Vector4d_): Internal.Vector4d;
    rotateY(arg0: number, arg1: Vec4f_): this;
    set(arg0: Internal.Vector3fc_, arg1: number): this;
    add(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    ceil(arg0: Vec4f_): this;
    negate(): this;
    mulAffineTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    w(): number;
    rotate(arg0: Internal.Quaternionfc_): this;
    length(): number;
    distanceSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    normalize(arg0: number): this;
    mul(arg0: number): this;
    ceil(): this;
    smoothStep(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number): this;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Vec4f_): this;
    floor(arg0: Vec4f_): this;
    div(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    angle(arg0: Internal.Vector4fc_): number;
    floor(): this;
    sub(arg0: number, arg1: number, arg2: number, arg3: number): this;
    max(arg0: Internal.Vector4fc_): this;
    set(arg0: Internal.FloatBuffer_): this;
    angleCos(arg0: Internal.Vector4fc_): number;
    get(arg0: number, arg1: Internal.Vector4i_): Internal.Vector4i;
    hermite(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: number, arg4: Vec4f_): this;
    absolute(): this;
    mul(arg0: number, arg1: Vec4f_): this;
    distance(arg0: Internal.Vector4fc_): number;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_): this;
    normalize(): this;
    isFinite(): boolean;
    get(arg0: Vec4f_): this;
    static length(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateX(arg0: number, arg1: Vec4f_): this;
    lerp(arg0: Internal.Vector4fc_, arg1: number, arg2: Vec4f_): this;
    static distance(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): number;
    div(arg0: number): this;
    setFromAddress(arg0: number): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_): this;
    absolute(arg0: Vec4f_): this;
    x(): number;
    div(arg0: number, arg1: Vec4f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mulTranspose(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    static lengthSquared(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: Internal.ByteBuffer_): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    fma(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    zero(): this;
    mulProject(arg0: Internal.Matrix4fc_): this;
    mulAdd(arg0: number, arg1: Internal.Vector4fc_, arg2: Vec4f_): this;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    rotateX(arg0: number): this;
    minComponent(): number;
    add(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    round(): this;
    set(arg0: Internal.Vector4dc_): this;
    add(arg0: Internal.Vector4fc_): this;
    equals(arg0: Internal.Vector4fc_, arg1: number): boolean;
    sub(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    mulTranspose(arg0: Internal.Matrix4fc_): this;
    max(arg0: Internal.Vector4fc_, arg1: Vec4f_): this;
    equals(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    mulProject(arg0: Internal.Matrix4fc_, arg1: Vec3f_): Vec3f;
    rotateAxis(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): this;
    y(): number;
    rotate(arg0: Internal.Quaternionfc_, arg1: Vec4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Vec4f_): this;
    normalize(arg0: Vec4f_): this;
    set(arg0: number): this;
    rotateY(arg0: number): this;
    set(arg0: Internal.Vector2fc_, arg1: number, arg2: number): this;
    distance(arg0: number, arg1: number, arg2: number, arg3: number): number;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    set(arg0: number): this;
    mul(arg0: Internal.Matrix4fc_): this;
    normalize(arg0: number, arg1: Vec4f_): this;
    get finite(): boolean
    set fromAddress(arg0: number)
    z: number;
    y: number;
    x: number;
    w: number;
}
type Vec4f_ = Vec4f;
declare interface UUID {
    toString(id: Internal.UUID_): string;
    digits(sb: Internal.StringBuilder_, val: number, digits: number): void;
    fromString(o: any): Internal.UUID;
}
type UUID_ = UUID;
declare const UUID: UUID;
/**
 * Various Ingredient related helper methods
*/
declare interface Ingredient {
    static of(ingredient: Internal.Ingredient_, count: number): Internal.Ingredient;
    /**
     * Returns an ingredient of the input
    */
    of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Returns an ingredient of the input, with the specified count
    */
    of(ingredient: Internal.Ingredient_, count: number): InputItem;
    /**
     * Make a custom ingredient where a match must match the provided predicate function
    */
    custom(predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    /**
     * Register a custom ingredient action for use in recipes with Recipe#customIngredientAction
    */
    registerCustomIngredientAction(id: string, callback: Internal.CustomIngredientActionCallback_): void;
    /**
     * Make a custom ingredient where items must match both the parent ingredient and the custom predicate function
    */
    custom(parent: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
    static of(ingredient: Internal.Ingredient_): Internal.Ingredient;
    /**
     * Checks if the passed in object is an Ingredient.
     * Note that this does not mean it will not function as an Ingredient if passed to something that requests one.
    */
    isIngredient(o: any): boolean;
    /**
     * Make a custom ingredient where an item must match both the parent ingredient and the item's nbt must match the custom predicate function
    */
    customNBT(in_: Internal.Ingredient_, predicate: Internal.Predicate_<Internal.CompoundTag>): Internal.Ingredient;
    /**
     * An ingredient that matches everything
    */
    readonly all: Internal.WildcardIngredient;
    /**
     * A completely empty ingredient that will only match air
    */
    readonly none: Internal.Ingredient;
}
type Ingredient_ = Ingredient;
declare const Ingredient: Ingredient;
declare class JavaMath {
    static asin(arg0: number): number;
    static addExact(arg0: number, arg1: number): number;
    static expm1(arg0: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static ceil(arg0: number): number;
    static atan(arg0: number): number;
    static exp(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static ulp(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static random(): number;
    static nextUp(arg0: number): number;
    static sqrt(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static addExact(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static fma(arg0: number, arg1: number, arg2: number): number;
    static round(arg0: number): number;
    static abs(arg0: number): number;
    static hypot(arg0: number, arg1: number): number;
    static round(arg0: number): number;
    static floor(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static rint(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static log(arg0: number): number;
    static absExact(arg0: number): number;
    static signum(arg0: number): number;
    static log10(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static abs(arg0: number): number;
    static floorDiv(arg0: number, arg1: number): number;
    static signum(arg0: number): number;
    static cos(arg0: number): number;
    static tan(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static nextUp(arg0: number): number;
    static ulp(arg0: number): number;
    static sin(arg0: number): number;
    static min(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static atan2(arg0: number, arg1: number): number;
    static cosh(arg0: number): number;
    static toRadians(arg0: number): number;
    static toIntExact(arg0: number): number;
    static decrementExact(arg0: number): number;
    static incrementExact(arg0: number): number;
    static negateExact(arg0: number): number;
    static sinh(arg0: number): number;
    static max(arg0: number, arg1: number): number;
    static incrementExact(arg0: number): number;
    static toDegrees(arg0: number): number;
    static decrementExact(arg0: number): number;
    static copySign(arg0: number, arg1: number): number;
    static nextAfter(arg0: number, arg1: number): number;
    static max(arg0: number, arg1: number): number;
    static negateExact(arg0: number): number;
    static tanh(arg0: number): number;
    static nextDown(arg0: number): number;
    static floorMod(arg0: number, arg1: number): number;
    static IEEEremainder(arg0: number, arg1: number): number;
    static nextDown(arg0: number): number;
    static abs(arg0: number): number;
    static getExponent(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static multiplyFull(arg0: number, arg1: number): number;
    static multiplyHigh(arg0: number, arg1: number): number;
    static absExact(arg0: number): number;
    static pow(arg0: number, arg1: number): number;
    static multiplyExact(arg0: number, arg1: number): number;
    static getExponent(arg0: number): number;
    static scalb(arg0: number, arg1: number): number;
    static cbrt(arg0: number): number;
    static acos(arg0: number): number;
    static log1p(arg0: number): number;
    static subtractExact(arg0: number, arg1: number): number;
    static readonly PI: 3.141592653589793;
    static readonly E: 2.718281828459045;
}
type JavaMath_ = JavaMath;
declare interface NBT {
    accessTagMap(tag: Internal.CompoundTag_): Internal.Map<string, Internal.Tag>;
    read(buf: Internal.FriendlyByteBuf_): Internal.OrderedCompoundTag;
    toJson(t: Internal.Tag_): Internal.JsonElement;
    toTagCollection(c: Internal.Collection_<any>): Internal.CollectionTag<any>;
    quoteAndEscapeForJS(stringBuilder: Internal.StringBuilder_, string: string): void;
    l(v: number): Internal.Tag;
    b(v: number): Internal.Tag;
    byteArrayTag(v: number[]): Internal.Tag;
    listTag(): Internal.Tag;
    floatTag(v: number): Internal.Tag;
    byteTag(v: number): Internal.Tag;
    s(v: number): Internal.Tag;
    listTag(list: Internal.List_<any>): Internal.Tag;
    ia(v: number[]): Internal.Tag;
    d(v: number): Internal.Tag;
    longArrayTag(v: number[]): Internal.Tag;
    isTagCollection(o: any): boolean;
    longTag(v: number): Internal.Tag;
    intTag(v: number): Internal.Tag;
    compoundTag(): Internal.Tag;
    shortTag(v: number): Internal.Tag;
    stringTag(v: string): Internal.Tag;
    la(v: number[]): Internal.Tag;
    convertType(tagType: Internal.TagType_<any>): Internal.TagType<any>;
    toTagCollection(v: any): Internal.CollectionTag<any>;
    f(v: number): Internal.Tag;
    toTag(v: any): Internal.Tag;
    fromTag(t: Internal.Tag_): any;
    toTagCompound(v: any): Internal.CompoundTag;
    toTagList(list: any): Internal.ListTag;
    isTagCompound(o: any): boolean;
    doubleTag(v: number): Internal.Tag;
    intArrayTag(v: number[]): Internal.Tag;
    compoundTag(map: Internal.Map_<any, any>): Internal.Tag;
    ba(v: number[]): Internal.Tag;
    i(v: number): Internal.Tag;
    readonly VALUE_UNWRAPPER: Internal.ValueUnwrapper;
    readonly LIST_TYPE: Internal.TagType<Internal.ListTag>;
    readonly COMPOUND_TYPE: Internal.TagType<Internal.OrderedCompoundTag>;
}
type NBT_ = NBT;
declare const NBT: NBT;
declare interface FluidAmounts {
    readonly MILLIBUCKET: 1;
    readonly MB: 1;
    readonly INGOT: 90;
    readonly BOTTLE: 250;
    readonly B: 1000;
    readonly NUGGET: 10;
    readonly METAL_BLOCK: 810;
    readonly BUCKET: 1000;
}
type FluidAmounts_ = FluidAmounts;
declare const FluidAmounts: FluidAmounts;
declare class Matrix3f implements Internal.Cloneable, Internal.Matrix3fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_)
    constructor(arg0: Internal.Matrix2fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number)
    rotateLocalY(arg0: number, arg1: Matrix3f_): this;
    setColumn(arg0: number, arg1: Internal.Vector3fc_): this;
    mapnZnXY(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    mapZXnY(): this;
    mapYXnZ(arg0: Matrix3f_): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnYnXZ(arg0: Matrix3f_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapYnXnZ(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(arg0: Matrix3f_): this;
    mapXnYnZ(): this;
    mapnYnZX(): this;
    m20(arg0: number): this;
    set(arg0: Internal.Matrix4fc_): this;
    rotationZ(arg0: number): this;
    mapnYnXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZYnX(): this;
    sub(arg0: Internal.Matrix3fc_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    setColumn(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYnZnX(): this;
    getRowColumn(arg0: number, arg1: number): number;
    positiveZ(arg0: Vec3f_): Vec3f;
    mapnYZX(arg0: Matrix3f_): this;
    mapnXnZY(arg0: Matrix3f_): this;
    rotateZ(arg0: number, arg1: Matrix3f_): this;
    mapXZY(arg0: Matrix3f_): this;
    mapYZnX(): this;
    mapnZnYX(arg0: Matrix3f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    rotateLocalZ(arg0: number, arg1: Matrix3f_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mapZYX(): this;
    mapYnZnX(): this;
    mapnXnYnZ(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix3f_): this;
    scale(arg0: number): this;
    m20(): number;
    set(arg0: Internal.Matrix3fc_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapnXnYZ(): this;
    get(arg0: Matrix4f_): Matrix4f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mul(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    m21(arg0: number): this;
    rotationY(arg0: number): this;
    mapnXYnZ(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnYX(): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    cofactor(arg0: Matrix3f_): this;
    mapnYZnX(arg0: Matrix3f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    mapXnZY(arg0: Matrix3f_): this;
    setTransposed(arg0: Internal.Matrix3fc_): this;
    getScale(arg0: Vec3f_): Vec3f;
    rotateY(arg0: number, arg1: Matrix3f_): this;
    transform(arg0: Vec3f_): Vec3f;
    mapYnZX(): this;
    mapnXZY(arg0: Matrix3f_): this;
    set(arg0: Internal.Quaterniondc_): this;
    scale(arg0: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): this;
    mapZYnX(): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    setRow(arg0: number, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Quaternionfc_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    rotateLocalY(arg0: number): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    m21(): number;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    sub(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    isFinite(): boolean;
    mapZnYX(arg0: Matrix3f_): this;
    mapnYZX(): this;
    transpose(arg0: Matrix3f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    mapnXnYZ(arg0: Matrix3f_): this;
    mapnXnZnY(): this;
    m10(): number;
    mapXnZnY(): this;
    mapZXY(arg0: Matrix3f_): this;
    rotationX(arg0: number): this;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix3f_): this;
    mapYnXZ(): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    getToAddress(arg0: number): Internal.Matrix3fc;
    reflect(arg0: number, arg1: number, arg2: number): this;
    setRow(arg0: number, arg1: number, arg2: number, arg3: number): this;
    get(arg0: number, arg1: number): number;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapnZnXnY(arg0: Matrix3f_): this;
    set(arg0: Internal.FloatBuffer_): this;
    mapXZnY(arg0: Matrix3f_): this;
    rotateLocalX(arg0: number, arg1: Matrix3f_): this;
    mulLocal(arg0: Internal.Matrix3fc_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    transform(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    mapnYXnZ(arg0: Matrix3f_): this;
    transformTranspose(arg0: Vec3f_): Vec3f;
    rotateLocalZ(arg0: number): this;
    m22(): number;
    lerp(arg0: Internal.Matrix3fc_, arg1: number, arg2: Matrix3f_): this;
    mapYXnZ(): this;
    mapZnYnX(arg0: Matrix3f_): this;
    mapYXZ(arg0: Matrix3f_): this;
    reflection(arg0: number, arg1: number, arg2: number): this;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZXnY(): this;
    invert(): this;
    m11(): number;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapZnXnY(arg0: Matrix3f_): this;
    rotateXYZ(arg0: Vec3f_): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnXnZY(): this;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    negateZ(): this;
    mapnZnYnX(arg0: Matrix3f_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    mapXZY(): this;
    m00(): number;
    mapYnZX(arg0: Matrix3f_): this;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mapnZXY(): this;
    scale(arg0: number, arg1: number, arg2: number): this;
    scaling(arg0: Internal.Vector3fc_): this;
    identity(): this;
    mulLocal(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapXZnY(): this;
    reflect(arg0: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix3fc_): this;
    setFromAddress(arg0: number): this;
    mapnZnYnX(): this;
    m01(arg0: number): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    m12(): number;
    mapZnYnX(): this;
    mapnZYnX(arg0: Matrix3f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    normal(): this;
    mapZYnX(arg0: Matrix3f_): this;
    mapnXZY(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    negateY(): this;
    toString(arg0: Internal.NumberFormat_): string;
    mapnXYnZ(arg0: Matrix3f_): this;
    mapnYXnZ(): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    get(arg0: number[], arg1: number): number[];
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    mapnXnYnZ(arg0: Matrix3f_): this;
    mapZYX(arg0: Matrix3f_): this;
    m12(arg0: number): this;
    m01(): number;
    mapnYnZX(arg0: Matrix3f_): this;
    clone(): any;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    quadraticFormProduct(arg0: Internal.Vector3fc_): number;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    reflection(arg0: Internal.Quaternionfc_): this;
    mapnYnZnX(arg0: Matrix3f_): this;
    transformTranspose(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    mapnZnXnY(): this;
    m02(arg0: number): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    transform(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    mapnZnXY(arg0: Matrix3f_): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix3f_): this;
    mapnYnXZ(): this;
    mapnXZnY(): this;
    mapYZX(): this;
    mapnYXZ(): this;
    mulComponentWise(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    mapZXnY(arg0: Matrix3f_): this;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    negateX(): this;
    mapnZYX(arg0: Matrix3f_): this;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    mapYZnX(arg0: Matrix3f_): this;
    mapnZnYX(): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix3f_): this;
    mapnZXnY(arg0: Matrix3f_): this;
    mapZnXY(arg0: Matrix3f_): this;
    reflection(arg0: Internal.Vector3fc_): this;
    rotateX(arg0: number): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    mapnXZnY(arg0: Matrix3f_): this;
    mapYXZ(): this;
    setSkewSymmetric(arg0: number, arg1: number, arg2: number): this;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m02(): number;
    mapZnXnY(): this;
    negateX(arg0: Matrix3f_): this;
    mapnYZnX(): this;
    m22(arg0: number): this;
    mulComponentWise(arg0: Internal.Matrix3fc_): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    invert(arg0: Matrix3f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Matrix3f_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    mapnZYX(): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    get(arg0: Matrix3f_): this;
    rotateX(arg0: number, arg1: Matrix3f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateYXZ(arg0: Vec3f_): this;
    determinant(): number;
    transpose(): this;
    add(arg0: Internal.Matrix3fc_, arg1: Matrix3f_): this;
    m10(arg0: number): this;
    mapYnZnX(arg0: Matrix3f_): this;
    rotateY(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    lerp(arg0: Internal.Matrix3fc_, arg1: number): this;
    add(arg0: Internal.Matrix3fc_): this;
    scale(arg0: number, arg1: Matrix3f_): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapYnXZ(arg0: Matrix3f_): this;
    mapnZXY(arg0: Matrix3f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix3f_): this;
    mapZnXY(): this;
    cofactor(): this;
    mapnYnXnZ(): this;
    quadraticFormProduct(arg0: number, arg1: number, arg2: number): number;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix3f_): this;
    swap(arg0: Matrix3f_): this;
    mapXnZnY(arg0: Matrix3f_): this;
    set(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    obliqueZ(arg0: number, arg1: number): this;
    negateY(arg0: Matrix3f_): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix3f_): this;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    m00(arg0: number): this;
    mapXnYnZ(arg0: Matrix3f_): this;
    mapXnZY(): this;
    mapYZX(arg0: Matrix3f_): this;
    equals(arg0: Internal.Matrix3fc_, arg1: number): boolean;
    set(arg0: Internal.Matrix4x3fc_): this;
    set(arg0: Internal.Matrix2fc_): this;
    mapnXnZnY(arg0: Matrix3f_): this;
    rotateZ(arg0: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    positiveY(arg0: Vec3f_): Vec3f;
    mapYnXnZ(): this;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    mapZXY(): this;
    mapnYXZ(arg0: Matrix3f_): this;
    scaling(arg0: number): this;
    set(arg0: number[]): this;
    zero(): this;
    set(arg0: Internal.Quaternionfc_): this;
    m11(arg0: number): this;
    set transposed(arg0: Internal.Matrix3fc_)
    get finite(): boolean
    set fromAddress(arg0: number)
    m10: number;
    m21: number;
    m20: number;
    m01: number;
    m12: number;
    m00: number;
    m11: number;
    m22: number;
    m02: number;
}
type Matrix3f_ = Matrix3f;
declare class Matrix4f implements Internal.Cloneable, Internal.Matrix4fc, Internal.Externalizable {
    constructor()
    constructor(arg0: Internal.Matrix3fc_)
    constructor(arg0: Internal.FloatBuffer_)
    constructor(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number)
    constructor(arg0: Internal.Matrix4dc_)
    constructor(arg0: Internal.Matrix4fc_)
    constructor(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_)
    constructor(arg0: Internal.Matrix4x3fc_)
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnZYnX(): this;
    scaleXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    setLookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    get(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    get(arg0: Internal.Matrix4d_): Internal.Matrix4d;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[], arg5: Matrix4f_): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateY(arg0: number, arg1: Matrix4f_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec3f_): Vec3f;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    testSphere(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
    zero(): this;
    getUnnormalizedRotation(arg0: Quaternionf_): Quaternionf;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    m32(arg0: number): this;
    rotateAffine(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapXZnY(arg0: Matrix4f_): this;
    rotateLocalX(arg0: number, arg1: Matrix4f_): this;
    mapnZXY(arg0: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnYXnZ(arg0: Matrix4f_): this;
    mapZXnY(): this;
    obliqueZ(arg0: number, arg1: number, arg2: Matrix4f_): this;
    m31(): number;
    setTransposedFromAddress(arg0: number): this;
    mapYXnZ(arg0: Matrix4f_): this;
    transformAffine(arg0: Vec4f_): Vec4f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    get4x3Transposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    getRowColumn(arg0: number, arg1: number): number;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m20(arg0: number): this;
    reflection(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    rotationZ(arg0: number): this;
    static perspectiveOffCenterViewFromRectangle(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_, arg4: number, arg5: boolean, arg6: Matrix4f_, arg7: Matrix4f_): void;
    mapZXY(arg0: Matrix4f_): this;
    cofactor3x3(arg0: Matrix3f_): Matrix3f;
    mapnYnXnZ(arg0: Matrix4f_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    m20(): number;
    get(arg0: Matrix4f_): this;
    transform(arg0: Vec4f_): Vec4f;
    rotateX(arg0: number, arg1: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    normal(arg0: Matrix4f_): this;
    rotateYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    m10(arg0: number): this;
    mapZYnX(): this;
    m33(arg0: number): this;
    rotateLocalY(arg0: number, arg1: Matrix4f_): this;
    set(arg0: Internal.Matrix3fc_): this;
    set3x3(arg0: Internal.Matrix3fc_): this;
    translationRotateScale(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    invertAffine(arg0: Matrix4f_): this;
    unprojectRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number, arg4: Matrix4f_): this;
    normalize3x3(arg0: Matrix4f_): this;
    m32(): number;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    getScale(arg0: Vec3f_): Vec3f;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    rotation(arg0: number, arg1: Internal.Vector3fc_): this;
    setRotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapZnXnY(): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapZnYX(): this;
    invertFrustum(arg0: Matrix4f_): this;
    transformProject(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    mapYnXnZ(arg0: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    normal(arg0: Matrix3f_): Matrix3f;
    m21(arg0: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    rotationY(arg0: number): this;
    getRotation(arg0: Internal.AxisAngle4d_): Internal.AxisAngle4d;
    rotate(arg0: Internal.AxisAngle4f_, arg1: Matrix4f_): this;
    rotationTowardsXY(arg0: number, arg1: number): this;
    tile(arg0: number, arg1: number, arg2: number, arg3: number): this;
    orthoCrop(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    m21(): number;
    isFinite(): boolean;
    transformProject(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    m30(arg0: number): this;
    scaling(arg0: number, arg1: number, arg2: number): this;
    setRotationYXZ(arg0: number, arg1: number, arg2: number): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    mul(arg0: Internal.Matrix4fc_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    lookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    unprojectInvRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    m10(): number;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number): this;
    transpose3x3(arg0: Matrix4f_): this;
    mul(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number): this;
    mapnZnXnY(): this;
    setLookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m33(): number;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    mapYXZ(arg0: Matrix4f_): this;
    transpose(arg0: Matrix4f_): this;
    rotation(arg0: Internal.Quaternionfc_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    rotateAffine(arg0: Internal.Quaternionfc_): this;
    get4x3Transposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    set(arg0: Internal.Matrix4fc_): this;
    rotationX(arg0: number): this;
    transpose3x3(arg0: Matrix3f_): Matrix3f;
    translate(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    m22(): number;
    ortho2DLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYZnX(): this;
    rotateTranslation(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleLocal(arg0: number): this;
    m31(arg0: number): this;
    rotateZ(arg0: number, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.FloatBuffer_): this;
    mapZYX(arg0: Matrix4f_): this;
    mulAffineR(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    set(arg0: Internal.FloatBuffer_): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m11(): number;
    mapYnZX(arg0: Matrix4f_): this;
    unprojectInv(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mulOrthoAffine(arg0: Internal.Matrix4fc_): this;
    perspectiveInvOrigin(arg0: Vec3f_): Vec3f;
    transformTranspose(arg0: Vec4f_): Vec4f;
    mapnZnXY(): this;
    rotationTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    setTransposed(arg0: Internal.Matrix4fc_): this;
    setRotationZYX(arg0: number, arg1: number, arg2: number): this;
    assume(arg0: number): this;
    mapnYnXZ(arg0: Matrix4f_): this;
    mul0(arg0: Internal.Matrix4fc_): this;
    rotateTowardsXY(arg0: number, arg1: number, arg2: Matrix4f_): this;
    transformAab(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Vec3f_, arg3: Vec3f_): this;
    mapZnYX(arg0: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    mapnZXnY(): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    getToAddress(arg0: number): Internal.Matrix4fc;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnXZY(): this;
    mapnZYnX(arg0: Matrix4f_): this;
    scaleLocal(arg0: number, arg1: number, arg2: number): this;
    m00(): number;
    rotationYXZ(arg0: number, arg1: number, arg2: number): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    transformProject(arg0: Vec4f_): Vec4f;
    rotateLocal(arg0: Internal.Quaternionfc_): this;
    mul(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    negateZ(): this;
    m23(): number;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    lookAtPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    equals(arg0: Internal.Matrix4fc_, arg1: number): boolean;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    lookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    m13(arg0: number): this;
    m12(): number;
    mapnYnZX(arg0: Matrix4f_): this;
    invertPerspective(arg0: Matrix4f_): this;
    get3x4(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    translationRotate(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    normalizedPositiveX(arg0: Vec3f_): Vec3f;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapXZY(): this;
    mapnZXY(): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    rotateZYX(arg0: Vec3f_): this;
    rotateLocalX(arg0: number): this;
    transformDirection(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    getColumn(arg0: number, arg1: Vec3f_): Vec3f;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translationRotateScaleInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    unprojectRay(arg0: Internal.Vector2fc_, arg1: number[], arg2: Vec3f_, arg3: Vec3f_): this;
    get(arg0: number[], arg1: number): number[];
    mapXZnY(): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    reflection(arg0: number, arg1: number, arg2: number, arg3: number): this;
    m01(arg0: number): this;
    mapYXnZ(): this;
    m01(): number;
    negateY(): this;
    set(arg0: Internal.Matrix4dc_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mapnZYX(arg0: Matrix4f_): this;
    mul(arg0: Internal.Matrix3x2fc_, arg1: Matrix4f_): this;
    sub(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapYZnX(arg0: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getRow(arg0: number, arg1: Vec4f_): Vec4f;
    getColumn(arg0: number, arg1: Vec4f_): Vec4f;
    mapnYXnZ(): this;
    set(arg0: number, arg1: Internal.FloatBuffer_): this;
    translate(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnZXnY(arg0: Matrix4f_): this;
    mapZnXY(arg0: Matrix4f_): this;
    transformAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Vec3f_, arg7: Vec3f_): this;
    invertOrtho(): this;
    transpose3x3(): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateAroundAffine(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    setRowColumn(arg0: number, arg1: number, arg2: number): this;
    transformProject(arg0: Vec3f_): Vec3f;
    normalizedPositiveY(arg0: Vec3f_): Vec3f;
    sub4x3(arg0: Matrix4f_): this;
    transform(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    translationRotateInvert(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateLocalY(arg0: number): this;
    testAab(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): boolean;
    billboardCylindrical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    getRow(arg0: number, arg1: Vec3f_): Vec3f;
    m13(): number;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    mapYZX(): this;
    rotationTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnYXZ(): this;
    setFromAddress(arg0: number): this;
    setFromIntrinsic(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    m02(arg0: number): this;
    negateX(): this;
    setColumn(arg0: number, arg1: Internal.Vector4fc_): this;
    mapnYZnX(arg0: Matrix4f_): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number, arg2: Matrix4f_): this;
    transformAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    m02(): number;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    set(arg0: number, arg1: Internal.ByteBuffer_): this;
    get4x3(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    transformTranspose(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): this;
    rotateYXZ(arg0: Vec3f_): this;
    mapnYXZ(arg0: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transpose(): this;
    m11(arg0: number): this;
    set(arg0: number[]): this;
    normalizedPositiveZ(arg0: Vec3f_): Vec3f;
    setLookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    cofactor3x3(arg0: Matrix4f_): this;
    mulAffine(arg0: Internal.Matrix4fc_): this;
    readExternal(arg0: Internal.ObjectInput_): void;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    getEulerAnglesZYX(arg0: Vec3f_): Vec3f;
    rotateZYX(arg0: number, arg1: number, arg2: number): this;
    scale(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    positiveX(arg0: Vec3f_): Vec3f;
    setTranslation(arg0: number, arg1: number, arg2: number): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    scaleAroundLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    m22(arg0: number): this;
    translationRotateScaleMulAffine(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_, arg3: Matrix4f_): this;
    rotate(arg0: Internal.Quaternionfc_): this;
    mapXnZY(): this;
    originAffine(arg0: Vec3f_): Vec3f;
    mapnZYX(): this;
    fma4x3(arg0: Internal.Matrix4fc_, arg1: number): this;
    invertOrtho(arg0: Matrix4f_): this;
    mapYZX(arg0: Matrix4f_): this;
    setPerspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    set(arg0: Internal.Matrix4x3fc_): this;
    normal(): this;
    m03(): number;
    reflect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    setLookAt(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    translationRotateScaleMulAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: Matrix4f_): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    rotateYXZ(arg0: number, arg1: number, arg2: number): this;
    rotationZYX(arg0: number, arg1: number, arg2: number): this;
    mulTranslationAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    cofactor3x3(): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    scaleXY(arg0: number, arg1: number): this;
    m12(arg0: number): this;
    rotation(arg0: Internal.AxisAngle4f_): this;
    translateLocal(arg0: Internal.Vector3fc_): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    billboardSpherical(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    scaling(arg0: number): this;
    mapZnXY(): this;
    mul(arg0: Internal.Matrix3x2fc_): this;
    project(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    scale(arg0: number, arg1: number, arg2: number): this;
    scaling(arg0: Internal.Vector3fc_): this;
    positiveY(arg0: Vec3f_): Vec3f;
    mapnYZnX(): this;
    unprojectInv(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    negateX(arg0: Matrix4f_): this;
    setOrtho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    translation(arg0: Internal.Vector3fc_): this;
    m23(arg0: number): this;
    m00(arg0: number): this;
    translationRotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    mul3x3(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    setFrustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setRow(arg0: number, arg1: Internal.Vector4fc_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    getEulerAnglesXYZ(arg0: Vec3f_): Vec3f;
    trapezoidCrop(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    get4x3Transposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mulComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set(arg0: Internal.ByteBuffer_): this;
    reflect(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    translationRotate(arg0: number, arg1: number, arg2: number, arg3: Internal.Quaternionfc_): this;
    transformPosition(arg0: Internal.Vector3fc_, arg1: Vec3f_): Vec3f;
    setOrtho2DLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    unprojectInvRay(arg0: number, arg1: number, arg2: number[], arg3: Vec3f_, arg4: Vec3f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnYnX(arg0: Matrix4f_): this;
    set3x3(arg0: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    mapnXZY(arg0: Matrix4f_): this;
    mapnXnZY(arg0: Matrix4f_): this;
    setPerspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.Quaterniondc_): this;
    mapXZY(arg0: Matrix4f_): this;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number, arg16: Matrix4f_): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4fc_): this;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mulComponentWise(arg0: Internal.Matrix4fc_): this;
    mapZYX(): this;
    rotate(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    transform(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    get3x3(arg0: Internal.Matrix3d_): Internal.Matrix3d;
    mapnXnYnZ(): this;
    add(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setTransposed(arg0: Internal.ByteBuffer_): this;
    getNormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapZnYnX(arg0: Matrix4f_): this;
    swap(arg0: Matrix4f_): this;
    positiveZ(arg0: Vec3f_): Vec3f;
    transformDirection(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    negateY(arg0: Matrix4f_): this;
    invertPerspective(): this;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number): this;
    mapnYnZX(): this;
    add(arg0: Internal.Matrix4fc_): this;
    determineProperties(): this;
    mapXnZnY(): this;
    rotateXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnZY(arg0: Matrix4f_): this;
    translate(arg0: number, arg1: number, arg2: number): this;
    lerp(arg0: Internal.Matrix4fc_, arg1: number): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    mapnXYnZ(): this;
    lookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    mulLocal(arg0: Internal.Matrix4fc_): this;
    rotation(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateXYZ(arg0: Internal.Vector3fc_): this;
    rotateLocal(arg0: Internal.Quaternionfc_, arg1: Matrix4f_): this;
    shadow(arg0: Vec4f_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: Matrix4f_): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    withLookAtUp(arg0: Internal.Vector3fc_): this;
    getTransposed(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x3(arg0: Matrix3f_): Matrix3f;
    set(arg0: number[], arg1: number): this;
    mapYnZX(): this;
    mapnXnYZ(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    perspectiveLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    rotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateAffineZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    set(arg0: Internal.AxisAngle4d_): this;
    mapnXnZnY(): this;
    rotationXYZ(arg0: number, arg1: number, arg2: number): this;
    mapXnYnZ(): this;
    negateZ(arg0: Matrix4f_): this;
    rotate(arg0: Internal.AxisAngle4f_): this;
    lookAtPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    setOrtho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapZnXnY(arg0: Matrix4f_): this;
    setTransposed(arg0: number[], arg1: number): this;
    rotateAffineXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    ortho(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    setOrthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    get3x4(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    mul(arg0: Internal.Matrix4x3fc_): this;
    get4x3Transposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    get4x3(arg0: Internal.Matrix4x3f_): Internal.Matrix4x3f;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    scale(arg0: Internal.Vector3fc_): this;
    lookAlong(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_): this;
    rotateTowardsXY(arg0: number, arg1: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: Matrix4f_): this;
    setLookAtLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number): this;
    sub(arg0: Internal.Matrix4fc_): this;
    rotateLocalZ(arg0: number): this;
    scale(arg0: number): this;
    lookAt(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: Matrix4f_): this;
    transformPosition(arg0: Vec3f_): Vec3f;
    affineSpan(arg0: Vec3f_, arg1: Vec3f_, arg2: Vec3f_, arg3: Vec3f_): this;
    set(arg0: Internal.AxisAngle4f_): this;
    m03(arg0: number): this;
    perspectiveFrustumSlice(arg0: number, arg1: number, arg2: Matrix4f_): this;
    transformDirection(arg0: Vec3f_): Vec3f;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    determinant3x3(): number;
    mapnYZX(): this;
    get(arg0: number, arg1: number): number;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    get(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    get3x4(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    setPerspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    invert(): this;
    transformTranspose(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    projectedGridRange(arg0: Internal.Matrix4fc_, arg1: number, arg2: number, arg3: Matrix4f_): this;
    rotateTowards(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mulAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspectiveNear(): number;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnYZX(arg0: Matrix4f_): this;
    perspectiveOffCenterFovLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mulLocalAffine(arg0: Internal.Matrix4fc_): this;
    setFrustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapnZnXnY(arg0: Matrix4f_): this;
    perspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.Matrix4fc_, arg5: Matrix4f_): this;
    rotationAround(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    shadow(arg0: Vec4f_, arg1: Matrix4f_): this;
    set4x3(arg0: Matrix4f_): this;
    project(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec3f_): Vec3f;
    getTransposed(arg0: Internal.ByteBuffer_): Internal.ByteBuffer;
    perspectiveOrigin(arg0: Vec3f_): Vec3f;
    frustumAabb(arg0: Vec3f_, arg1: Vec3f_): this;
    get4x3(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    getNormalizedRotation(arg0: Quaternionf_): Quaternionf;
    translateLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    scaleAround(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapnXnYZ(arg0: Matrix4f_): this;
    mulLocal(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    normalize3x3(): this;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: Internal.Vector3fc_): this;
    mapXnYnZ(arg0: Matrix4f_): this;
    setTranslation(arg0: Internal.Vector3fc_): this;
    mapnXnZY(): this;
    setPerspectiveRect(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    isAffine(): boolean;
    get3x4(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    translationRotateScale(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_): this;
    get(arg0: number, arg1: Internal.ByteBuffer_): Internal.ByteBuffer;
    translation(arg0: number, arg1: number, arg2: number): this;
    arcball(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapYnXnZ(): this;
    setOrthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number): this;
    set(arg0: Internal.Vector4fc_, arg1: Internal.Vector4fc_, arg2: Internal.Vector4fc_, arg3: Internal.Vector4fc_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_): this;
    frustumPlane(arg0: number, arg1: Vec4f_): Vec4f;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformPosition(arg0: number, arg1: number, arg2: number, arg3: Vec3f_): Vec3f;
    rotateX(arg0: number): this;
    invertFrustum(): this;
    invertAffine(): this;
    rotateAffineYXZ(arg0: number, arg1: number, arg2: number): this;
    frustumCorner(arg0: number, arg1: Vec3f_): Vec3f;
    get(arg0: number[]): number[];
    shadow(arg0: Vec4f_, arg1: Internal.Matrix4fc_, arg2: Matrix4f_): this;
    mapnYnZnX(arg0: Matrix4f_): this;
    set(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: number, arg9: number, arg10: number, arg11: number, arg12: number, arg13: number, arg14: number, arg15: number): this;
    toString(arg0: Internal.NumberFormat_): string;
    mapnYnXnZ(): this;
    set4x3(arg0: Internal.Matrix4x3fc_): this;
    rotateAffine(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    identity(): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec3f_): Vec3f;
    rotate(arg0: number, arg1: number, arg2: number, arg3: number): this;
    mapZXnY(arg0: Matrix4f_): this;
    translateLocal(arg0: number, arg1: number, arg2: number): this;
    clone(): any;
    rotateXYZ(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    mul4x3ComponentWise(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    writeExternal(arg0: Internal.ObjectOutput_): void;
    invert(arg0: Matrix4f_): this;
    setPerspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    getRotation(arg0: Internal.AxisAngle4f_): Internal.AxisAngle4f;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    mapZnYnX(): this;
    frustumRayDir(arg0: number, arg1: number, arg2: Vec3f_): Vec3f;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    mapnZnYX(): this;
    translationRotateTowards(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    getTransposed(arg0: Internal.FloatBuffer_): Internal.FloatBuffer;
    sub4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    get4x3(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYnXZ(): this;
    setTransposed(arg0: number[]): this;
    mulPerspectiveAffine(arg0: Internal.Matrix4x3fc_): this;
    transformProject(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Vec4f_): Vec4f;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec3f_): Vec3f;
    translationRotateScaleInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_, arg2: number): this;
    properties(): number;
    rotateY(arg0: number): this;
    rotateTranslation(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    invertPerspectiveView(arg0: Internal.Matrix4x3fc_, arg1: Matrix4f_): this;
    frustumLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    orthoSymmetricLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean): this;
    setPerspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    add4x3(arg0: Internal.Matrix4fc_): this;
    translationRotateInvert(arg0: Internal.Vector3fc_, arg1: Internal.Quaternionfc_): this;
    mapnXZnY(): this;
    mapnYnXZ(): this;
    mulAffineR(arg0: Internal.Matrix4fc_): this;
    mapnZnXY(arg0: Matrix4f_): this;
    mulOrthoAffine(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number): this;
    transformAffine(arg0: Internal.Vector4fc_, arg1: Vec4f_): Vec4f;
    perspectiveOffCenter(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    translateLocal(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    unproject(arg0: Internal.Vector3fc_, arg1: number[], arg2: Vec4f_): Vec4f;
    mapnZnYnX(): this;
    orthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    perspectiveFar(): number;
    perspective(arg0: number, arg1: number, arg2: number, arg3: number, arg4: boolean, arg5: Matrix4f_): this;
    pick(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number[]): this;
    scaleLocal(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    normalize3x3(arg0: Matrix3f_): Matrix3f;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    mapnXnZnY(arg0: Matrix4f_): this;
    unproject(arg0: number, arg1: number, arg2: number, arg3: number[], arg4: Vec4f_): Vec4f;
    scaleLocal(arg0: number, arg1: Matrix4f_): this;
    reflect(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    set(arg0: Internal.Quaternionfc_): this;
    rotateZ(arg0: number): this;
    rotateLocalZ(arg0: number, arg1: Matrix4f_): this;
    scale(arg0: number, arg1: Matrix4f_): this;
    mapYnXZ(arg0: Matrix4f_): this;
    scale(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    ortho2D(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Matrix4f_): this;
    mapYnZnX(): this;
    orthoLH(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    arcball(arg0: number, arg1: Internal.Vector3fc_, arg2: number, arg3: number): this;
    get(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    mapYXZ(): this;
    mapXnZnY(arg0: Matrix4f_): this;
    reflection(arg0: Internal.Quaternionfc_, arg1: Internal.Vector3fc_): this;
    testPoint(arg0: number, arg1: number, arg2: number): boolean;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    determinant(): number;
    perspectiveFov(): number;
    mapZYnX(arg0: Matrix4f_): this;
    add4x3(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    setLookAtLH(arg0: Internal.Vector3fc_, arg1: Internal.Vector3fc_, arg2: Internal.Vector3fc_): this;
    mapZXY(): this;
    mapnXYnZ(arg0: Matrix4f_): this;
    withLookAtUp(arg0: number, arg1: number, arg2: number): this;
    withLookAtUp(arg0: Internal.Vector3fc_, arg1: Matrix4f_): this;
    mapnYnZnX(): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean, arg7: Matrix4f_): this;
    setOrthoSymmetric(arg0: number, arg1: number, arg2: number, arg3: number): this;
    getUnnormalizedRotation(arg0: Internal.Quaterniond_): Internal.Quaterniond;
    mapYnZnX(arg0: Matrix4f_): this;
    mapnXnYnZ(arg0: Matrix4f_): this;
    mapnZnYX(arg0: Matrix4f_): this;
    origin(arg0: Vec3f_): Vec3f;
    getTransposed(arg0: number, arg1: Internal.FloatBuffer_): Internal.FloatBuffer;
    determinantAffine(): number;
    mapnXZnY(arg0: Matrix4f_): this;
    frustum(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: boolean): this;
    rotateZYX(arg0: number, arg1: number, arg2: number, arg3: Matrix4f_): this;
    translate(arg0: Internal.Vector3fc_): this;
    m30(): number;
    rotateAroundLocal(arg0: Internal.Quaternionfc_, arg1: number, arg2: number, arg3: number): this;
    perspectiveOffCenterFov(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): this;
    rotateLocal(arg0: number, arg1: number, arg2: number, arg3: number): this;
    lookAlong(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: Matrix4f_): this;
    obliqueZ(arg0: number, arg1: number): this;
    rotate(arg0: number, arg1: Internal.Vector3fc_, arg2: Matrix4f_): this;
    getTranslation(arg0: Vec3f_): Vec3f;
    invertPerspectiveView(arg0: Internal.Matrix4fc_, arg1: Matrix4f_): this;
    set transposedFromAddress(arg0: number)
    get finite(): boolean
    set transposed(arg0: Internal.FloatBuffer_)
    set transposed(arg0: Internal.Matrix4fc_)
    set fromAddress(arg0: number)
    set transposed(arg0: Internal.ByteBuffer_)
    set translation(arg0: Internal.Vector3fc_)
    get affine(): boolean
    set transposed(arg0: number[])
}
type Matrix4f_ = Matrix4f;
/**
 * The hub for all things text components. Format text to your hearts content!
*/
declare class Component {
    constructor()
    /**
     * Returns a component of the input, colored light purple
    */
    static lightPurple(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored blue
    */
    static blue(text: any): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translatable(key: string): Internal.MutableComponent;
    /**
     * Returns a ClickEvent of the input
    */
    static clickEventOf(o: any): Internal.ClickEvent;
    /**
     * Returns a colorful representation of the input nbt. Useful for displaying NBT to the player
    */
    static prettyPrintNbt(tag: Internal.Tag_): net.minecraft.network.chat.Component;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translatable(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns an empty component
    */
    static empty(): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored white
    */
    static white(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the string, or empty if it is an empty string
    */
    static ofString(s: string): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key, with args of the objects
    */
    static translate(key: string, ...objects: any[]): Internal.MutableComponent;
    /**
     * Returns a translatable component of the input key
    */
    static translate(key: string): Internal.MutableComponent;
    /**
     * Returns a component displaying all entities matching the input selector
    */
    static selector(selector: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored yellow
    */
    static yellow(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark purple
    */
    static darkPurple(text: any): Internal.MutableComponent;
    /**
     * Checks if the passed in component, and all its children are empty
    */
    static isEmpty(component: net.minecraft.network.chat.Component_): boolean;
    /**
     * Returns a Component of the input
    */
    static of(o: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gray
    */
    static gray(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark blue
    */
    static darkBlue(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark red
    */
    static darkRed(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored gold
    */
    static gold(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored red
    */
    static red(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark green
    */
    static darkGreen(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored green
    */
    static green(text: any): Internal.MutableComponent;
    /**
     * Returns a keybinding component of the input keybinding descriptor
    */
    static keybind(keybind: string): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark aqua
    */
    static darkAqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components
    */
    static join(...texts: net.minecraft.network.chat.Component_[]): Internal.MutableComponent;
    /**
     * Returns a score component of the input objective, for the provided selector
    */
    static score(selector: string, objective: string): Internal.MutableComponent;
    /**
     * Returns a plain component of the passed in string, even if empty
    */
    static string(text: string): Internal.MutableComponent;
    /**
     * Returns a component displaying all entities matching the input selector, with a custom separator
    */
    static selector(selector: string, separator: net.minecraft.network.chat.Component_): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored aqua
    */
    static aqua(text: any): Internal.MutableComponent;
    /**
     * Joins all components in the list with the separator component
    */
    static join(separator: Internal.MutableComponent_, texts: Internal.Iterable_<net.minecraft.network.chat.Component>): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored black
    */
    static black(text: any): Internal.MutableComponent;
    /**
     * Returns a component of the input, colored dark gray
    */
    static darkGray(text: any): Internal.MutableComponent;
    /**
     * Returns a plain component of the input
    */
    static literal(text: string): Internal.MutableComponent;
}
type Component_ = Component;
/**
 * A collection of utilities
*/
declare interface Utils {
    /**
     * Capitalises the first letter of the string unless it is "a", "an", "the", "of", "on", "in", "and", "or", "but" or "for"
    */
    toTitleCase(s: string): string;
    /**
     * Returns a Stat of the passed in ResourceLocation.
     * Note that this requires the same ResourceLocation to get the same stat, so should not be used unless you want to make your own stat, and are storing an actual ResourceLocation somewhere to access it.
    */
    getStat(id: ResourceLocation_): Internal.Stat<ResourceLocation>;
    /**
     * Returns the provided snake_case_string in Title Case
    */
    snakeCaseToTitleCase(string: string): string;
    /**
     * Returns a new counting map
    */
    newCountingMap(): Internal.CountingMap;
    /**
     * Capitalises the first letter of the string. If ignoreSpecial is true, it will also capitalise articles and prepositions
    */
    toTitleCase(s: string, ignoreSpecial: boolean): string;
    /**
     * Tries to parse the first parameter as a double and returns that. The second parameter is returned if parsing fails
    */
    parseDouble(object: any, def: number): number;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    getRandom(): Internal.Random;
    /**
     * Returns a new mutable list
    */
    newList(): Internal.List<any>;
    /**
     * Returns the results of rolling the specified loot table (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_): Internal.List<Internal.ItemStack>;
    /**
     * Get a new random with the specified seed
    */
    newRandom(seed: number): Internal.Random;
    /**
     * Gets all ids from the registry with the specified id
    */
    getRegistryIds(id: ResourceLocation_): Internal.List<ResourceLocation>;
    /**
     * Gets the current system time, in milliseconds
    */
    getSystemTime(): number;
    /**
     * Get an immutable empty list
    */
    emptyList<T>(): Internal.List<T>;
    /**
     * Runs the provided supplier function in KubeJS' background thread and returns its CompletableFuture
    */
    supplyAsync(task: Internal.Supplier_<any>): Internal.CompletableFuture<any>;
    /**
     * Returns a ResourceLocation with the specified namepsace and path
    */
    id(namespace: string, path: string): ResourceLocation;
    /**
     * Returns a lazy value with the supplier function as its value factory
    */
    lazy<T>(supplier: Internal.Supplier_<T>): Internal.Lazy<T>;
    /**
     * Checks if the passed in object is an instance of WrappedJS
    */
    isWrapped(o: any): boolean;
    /**
     * Returns the creative tab associated with the id
    */
    findCreativeTab(id: ResourceLocation_): Internal.CreativeModeTab;
    /**
     * Returns the provided snake_case_string in camelCase
    */
    snakeCaseToCamelCase(string: string): string;
    /**
     * Get an immutable empty map
    */
    emptyMap<K, V>(): Internal.Map<K, V>;
    /**
     * Returns a lazy value with the supplier function as its value factory, that will expire after the specified number of milliseconds
    */
    expiringLazy<T>(supplier: Internal.Supplier_<T>, time: number): Internal.Lazy<T>;
    /**
     * Gets a SoundEvent from the id
    */
    getSound(id: ResourceLocation_): Internal.SoundEvent;
    /**
     * Gets a random object from the list using the passed in random
    */
    randomOf(random: Internal.Random_, objects: Internal.Collection_<any>): any;
    /**
     * Gets the specified registry
    */
    getRegistry(id: ResourceLocation_): Internal.RegistryInfo<any>;
    /**
     * Returns a new mutable map
    */
    newMap(): Internal.Map<any, any>;
    particleOptions(o: any): Internal.ParticleOptions;
    /**
     * Returns a copy the object if possible, or the object itself if not
    */
    copy(o: any): any;
    /**
     * Returns a regex pattern of the input with the specified flags
    */
    regex(pattern: string, flags: number): Internal.Pattern;
    /**
     * Typewraps the input string to a ResourceLocation. Format should be namespace:path
    */
    id(id: ResourceLocation_): ResourceLocation;
    /**
     * Returns a regex pattern of the input
    */
    regex(s: any): Internal.Pattern;
    /**
     * Runs the provided runnable function in KubeJS' background thread and returns its CompletableFuture
    */
    runAsync(task: Internal.Runnable_): Internal.CompletableFuture<void>;
    /**
     * Parses a block state from the input string. May throw for invalid inputs!
    */
    parseBlockState(o: any): Internal.BlockState;
    /**
     * Immediately run the passed runnable function in a try-catch block, and log the exception if it throws
    */
    queueIO(runnable: Internal.Runnable_): void;
    /**
     * Tries to parse the first parameter as an integer, and returns that. The second parameter is returned if parsing fails
    */
    parseInt(object: any, def: number): number;
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    getServer(): Internal.MinecraftServer;
    /**
     * Returns the results of rolling the specified loot table with the entity as a parameter (it does not have to be a chest loot table)
    */
    rollChestLoot(id: ResourceLocation_, entity: Internal.Entity_): Internal.List<Internal.ItemStack>;
    /**
     * Get a Random, for generating random numbers. Note this will always return the same Random instance
    */
    get random(): Internal.Random
    /**
     * Gets the current system time, in milliseconds
    */
    get systemTime(): number
    /**
     * Get the server. Null if there is no server (startup or client)
    */
    get server(): Internal.MinecraftServer
    readonly ERROR_PARTICLE: Internal.DustParticleOptions;
}
type Utils_ = Utils;
declare const Utils: Utils;
declare interface AABB {
    ofSize(vec3: Vec3d_, x: number, y: number, z: number): Internal.AABB;
    ofBlock(pos: BlockPos_): Internal.AABB;
    of(x0: number, y0: number, z0: number, x1: number, y1: number, z1: number): Internal.AABB;
    ofSize(x: number, y: number, z: number): Internal.AABB;
    ofBlocks(pos1: BlockPos_, pos2: BlockPos_): Internal.AABB;
    wrap(o: any): Internal.AABB;
    readonly CUBE: Internal.AABB;
    readonly EMPTY: Internal.AABB;
}
type AABB_ = AABB;
declare const AABB: AABB;
declare namespace Special {
    type Mod = "geckolib" | "roomopolis" | "betteroceanmonuments" | "sophisticatedcore" | "glassential" | "duckling" | "strainers" | "controlling" | "dankstorage" | "yungsapi" | "mixinextras" | "bookshelf" | "sophisticatedbackpacks" | "oceanfloor" | "additionalstructures" | "balm" | "mangomultiblock" | "melody" | "cloth_config" | "sawmill" | "supplementaries" | "konkrete" | "athena" | "chipped" | "alltheores" | "industrialforegoing" | "farmersdelight" | "taxov" | "cozy_home" | "caveopolis" | "aquatictorches" | "supermartijn642corelib" | "industrialforegoingsouls" | "curios" | "patchouli" | "suppsquared" | "opolisutilities" | "tmttd" | "simplehats" | "searchables" | "yungsextras" | "ftbultimine" | "gottschcore" | "resourcefullib" | "architectury" | "aqua_creepers" | "flib" | "lfpirates" | "smallships" | "probejs" | "yeetusexperimentus" | "sky_structures" | "rhino" | "cucumber" | "jmi" | "ftblibrary" | "ftbteams" | "ftbranks" | "watermedia" | "craftingstation" | "shrines" | "octolib" | "nec" | "itemfilters" | "jei" | "kubejs" | "igleelib" | "attributefix" | "libraryferret" | "luggage" | "obscure_api" | "thermal_extra" | "clumps" | "journeymap" | "framedcompactdrawers" | "libx" | "fusion" | "forge" | "mysticalagriculture" | "mysticalagradditions" | "matc" | "craftingtweaks" | "awesomedungeonocean" | "minecraft" | "cofh_core" | "thermal" | "thermal_integration" | "thermal_innovation" | "thermal_foundation" | "thermal_expansion" | "thermal_locomotion" | "thermal_dynamics" | "kubejs_thermal" | "systeams" | "simplebackups" | "theoneprobe" | "moonlight" | "mousetweaks" | "titanium" | "ftbquests" | "ftbxmodcompat" | "mixinsquared" | "skyblockbuilder" | "entityjs" | "thermal_cultivation" | "storagedrawers" | "fluiddrawerslegacy" | "zeta" | "wits" | "fancymenu" | "oceansdelight" | "appleskin" | "powered_flashlight" | "solcarrot" | "aquaculture" | "melongolem" | "extremesoundmuffler" | "cosmeticarmorreworked" | "craftedcore" | "walkers" | "aquamirae"
    type Ingredient = "libx:effect" | "kubejs:wildcard" | "kubejs:custom" | "kubejs:custom_predicate" | "kubejs:mod" | "kubejs:regex" | "kubejs:creative_tab" | "zeta:flag" | "farmersdelight:tool_action" | "forge:compound" | "forge:nbt" | "forge:partial_nbt" | "forge:difference" | "forge:intersection" | "minecraft:item" | "mysticalagriculture:all_hoes" | "mysticalagriculture:filled_soul_jars" | "mysticalagriculture:crop_component" | "cofh_core:with_count";
    type Advancement = "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "minecraft:recipes/redstone/acacia_button" | "minecraft:recipes/decorations/brick_wall" | "minecraft:recipes/building_blocks/stone_bricks" | "minecraft:recipes/building_blocks/polished_deepslate" | "caveopolis:recipes/misc/red_colored_stone_brick_slab" | "alltheores:recipes/misc/silver_ingot" | "caveopolis:recipes/redstone/orange_colored_wooden_plank_trapdoor" | "minecraft:husbandry/allay_deliver_item_to_player" | "minecraft:recipes/combat/leather_helmet" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab" | "alltheores:recipes/misc/lead_ingot_from_ore_blasting" | "farmersdelight:recipes/cooking/mushroom_rice" | "caveopolis:recipes/misc/lime_colored_cobblestone_brick_wall_from_lime_colored_cobblestone_bricks_stonecutting" | "oceansdelight:recipes/cooked_stuffed_cod_from_campfire_cooking" | "minecraft:recipes/pumpkin_seeds" | "minecraft:recipes/decorations/blast_furnace" | "minecraft:recipes/decorations/ladder" | "minecraft:recipes/decorations/red_nether_brick_wall" | "caveopolis:recipes/redstone/black_colored_wooden_plank_button" | "minecraft:recipes/decorations/magenta_stained_glass_pane" | "aquaculture:recipes/combat/neptunium_helmet" | "minecraft:recipes/building_blocks/stripped_mangrove_wood" | "caveopolis:recipes/misc/lime_colored_stone_brick_wall_from_lime_colored_stone_bricks_stonecutting" | "caveopolis:recipes/redstone/light_gray_colored_stone_button" | "minecraft:recipes/poppy" | "supplementaries:recipes/building_blocks/cozy_home/sign_post_crimson" | "caveopolis:recipes/building_blocks/brown_colored_wooden_plank_stairs" | "farmersdelight:recipes/food/egg_sandwich" | "caveopolis:recipes/misc/cyan_colored_wooden_plank_slab_from_cyan_colored_wooden_planks_stonecutting" | "caveopolis:recipes/decorations/pink_colored_sign" | "supplementaries:recipes/soap/map" | "caveopolis:recipes/misc/white_colored_stone_crafting_table" | "minecraft:recipes/decorations/brown_banner" | "smallships:recipes/transportation/bamboo_galley" | "caveopolis:recipes/misc/orange_colored_stone_pressure_plate_from_orange_colored_stone_stonecutting" | "farmersdelight:recipes/food/melon_juice" | "caveopolis:recipes/misc/cyan_colored_cobblestone_brick_wall" | "alltheores:recipes/misc/platinum_block" | "farmersdelight:recipes/food/grilled_salmon" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "farmersdelight:recipes/decorations/brown_canvas_sign" | "caveopolis:recipes/misc/marble_from_white_colored_stone_stonecutting" | "minecraft:recipes/tube_coral_block" | "minecraft:recipes/building_blocks/mangrove_planks" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_deepslate_lapis_ore" | "minecraft:recipes/misc/emerald" | "caveopolis:recipes/building_blocks/red_colored_stone_stairs" | "alltheores:recipes/misc/iron_dust_from_hammer_ingot_crushing" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/brick_stairs" | "minecraft:recipes/decorations/deepslate_brick_wall_from_deepslate_bricks_stonecutting" | "caveopolis:recipes/misc/white_colored_wooden_plank_fence_from_white_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/green_colored_stone_brick_slab_from_green_colored_stone_bricks_stonecutting" | "caveopolis:recipes/redstone/light_gray_colored_wooden_plank_fence_gate" | "supplementaries:recipes/decorations/sign_post_acacia" | "farmersdelight:recipes/decorations/basket" | "caveopolis:recipes/misc/green_colored_wooden_plank_pressure_plate_from_green_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/iridium_ingot_from_dust" | "caveopolis:recipes/misc/light_blue_colored_cobblestone_brick_slab_from_light_blue_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_copper_stonecutting" | "caveopolis:recipes/misc/red_colored_cobblestone_bricks_from_red_colored_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "minecraft:recipes/misc/eye_armor_trim_smithing_template_smithing_trim" | "caveopolis:recipes/decorations/light_gray_colored_hanging_sign" | "minecraft:recipes/decorations/lime_stained_glass_pane_from_glass_pane" | "minecraft:adventure/trim_with_all_exclusive_armor_patterns" | "caveopolis:recipes/misc/yellow_colored_cobblestone_brick_wall" | "minecraft:recipes/misc/copper_ingot_from_blasting_deepslate_copper_ore" | "farmersdelight:main/get_rich_soil" | "caveopolis:recipes/building_blocks/magenta_colored_wooden_planks" | "minecraft:recipes/building_blocks/smooth_quartz_slab" | "sophisticatedbackpacks:recipes/misc/advanced_feeding_upgrade" | "minecraft:recipes/building_blocks/end_stone_brick_slab" | "supplementaries:recipes/statue" | "industrialforegoing:recipes/misc/laser_lens_brown_recolor" | "minecraft:recipes/decorations/polished_deepslate_wall" | "alltheores:recipes/misc/invar_rod" | "awesomedungeonocean:ocean_the_column_temple/find_normal" | "caveopolis:recipes/misc/lime_colored_cobblestone_stairs_from_lime_colored_cobblestone_stonecutting" | "caveopolis:recipes/building_blocks/white_colored_cobblestone_bricks" | "minecraft:recipes/decorations/orange_bed" | "caveopolis:recipes/misc/purple_colored_wooden_plank_door_from_purple_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/yellow_colored_stone_brick_wall" | "caveopolis:recipes/misc/magenta_colored_wooden_plank_stairs_from_magenta_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/fletching_table" | "alltheores:recipes/misc/lead_plate" | "caveopolis:recipes/redstone/cyan_colored_wooden_plank_door" | "minecraft:recipes/food/cooked_chicken_from_campfire_cooking" | "alltheores:recipes/misc/silver_ingot_from_ore" | "minecraft:recipes/decorations/brown_bed" | "minecraft:recipes/food/cooked_mutton_from_smoking" | "minecraft:recipes/building_blocks/deepslate_bricks" | "minecraft:recipes/building_blocks/polished_diorite_stairs" | "minecraft:recipes/building_blocks/dye_brown_bed" | "caveopolis:recipes/building_blocks/gray_colored_cobblestone_bricks" | "caveopolis:recipes/misc/gray_colored_hanging_sign_from_stripped_gray_colored_log_stonecutting" | "smallships:recipes/transportation/spruce_cog" | "sophisticatedbackpacks:recipes/misc/deposit_upgrade" | "minecraft:recipes/misc/gold_ingot_from_gold_block" | "minecraft:recipes/building_blocks/light_blue_stained_glass" | "alltheores:recipes/misc/enderium_gear" | "alltheores:recipes/misc/constantan_ingot_from_dust_blasting" | "caveopolis:recipes/misc/purple_colored_cobblestone_wall_from_purple_colored_cobblestone_stonecutting" | "caveopolis:recipes/building_blocks/light_blue_colored_cobblestone_stairs" | "minecraft:recipes/bamboo" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_lapis_ore" | "alltheores:recipes/misc/raw_silver_block" | "minecraft:recipes/decorations/purple_bed" | "smallships:recipes/transportation/acacia_cog" | "farmersdelight:recipes/decorations/pink_hanging_canvas_sign" | "alltheores:recipes/misc/bronze_rod" | "minecraft:recipes/red_mushroom" | "aquaculture:recipes/combat/neptunium_leggings" | "caveopolis:recipes/misc/mixed_stone_ingot_from_blasting_raw_mixed_stone" | "minecraft:recipes/decorations/light_gray_glazed_terracotta" | "alltheores:recipes/misc/lumium_ingot_from_dust" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_vine" | "farmersdelight:recipes/cooking/rabbit_stew" | "minecraft:recipes/redstone/birch_button" | "minecraft:recipes/building_blocks/quartz_slab" | "alltheores:recipes/misc/steel_nugget_from_ingot" | "alltheores:recipes/misc/nickel_ingot_from_slate_ore_blasting" | "minecraft:recipes/building_blocks/jungle_wood" | "minecraft:recipes/combat/netherite_chestplate_smithing" | "minecraft:recipes/decorations/purple_glazed_terracotta" | "minecraft:story/deflect_arrow" | "caveopolis:recipes/misc/black_colored_stone_crafting_table" | "alltheores:recipes/misc/uranium_rod" | "farmersdelight:recipes/cooking/stuffed_pumpkin_block" | "minecraft:recipes/tools/golden_axe" | "minecraft:husbandry/leash_all_frog_variants" | "caveopolis:recipes/redstone/red_colored_stone_button" | "supplementaries:recipes/crank" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_deepslate_bricks_stonecutting" | "alltheores:recipes/misc/silver_ingot_from_raw_blasting" | "supplementaries:husbandry/turn_table" | "minecraft:recipes/decorations/orange_banner" | "alltheores:recipes/misc/enderium_ingot_from_block" | "caveopolis:recipes/misc/magenta_colored_hanging_sign_from_stripped_magenta_colored_log_stonecutting" | "minecraft:recipes/cod" | "alltheores:recipes/misc/tin_ingot_from_slate_ore" | "minecraft:recipes/decorations/oak_sign" | "caveopolis:recipes/misc/pink_colored_wooden_plank_button_from_pink_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/red_concrete_powder" | "caveopolis:recipes/misc/cyan_colored_stone_wall" | "caveopolis:recipes/building_blocks/gray_colored_stone_bricks" | "caveopolis:recipes/building_blocks/red_colored_stone_brick_stairs" | "minecraft:recipes/tools/golden_pickaxe" | "oceansdelight:recipes/oceansdelight/cabbage_wrapped_elder_guardian" | "caveopolis:recipes/decorations/light_blue_colored_hanging_sign" | "minecraft:recipes/brewing/magma_cream" | "caveopolis:recipes/misc/yellow_colored_stone_wall" | "caveopolis:recipes/building_blocks/white_colored_stone" | "storagedrawers:recipes/storagedrawers/one_stack_upgrade" | "minecraft:nether/brew_potion" | "minecraft:recipes/building_blocks/polished_deepslate_slab" | "minecraft:recipes/building_blocks/quartz_bricks" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "minecraft:recipes/decorations/purple_stained_glass_pane_from_glass_pane" | "caveopolis:recipes/redstone/brown_colored_wooden_plank_fence_gate" | "supplementaries:recipes/spring_launcher" | "caveopolis:recipes/misc/blue_colored_cobblestone_wall" | "minecraft:end/dragon_egg" | "aquaculture:recipes/aquaculture/heavy_hook" | "alltheores:recipes/misc/enderium_dust_from_alloy_blending" | "caveopolis:recipes/misc/yellow_colored_cobblestone_wall" | "supplementaries:recipes/soap_block" | "minecraft:husbandry/fishy_business" | "caveopolis:recipes/misc/light_blue_colored_cobblestone_wall_from_light_blue_colored_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/lapis_block" | "farmersdelight:recipes/food/steak_and_potatoes" | "minecraft:recipes/food/cooked_cod_from_smoking" | "caveopolis:recipes/redstone/white_colored_wooden_plank_door" | "farmersdelight:main/obtain_netherite_knife" | "farmersdelight:recipes/food/cooked_cod_slice_from_smoking" | "farmersdelight:recipes/decorations/orange_hanging_canvas_sign" | "minecraft:nether/explore_nether" | "caveopolis:recipes/misc/blue_colored_hanging_sign_from_stripped_blue_colored_log_stonecutting" | "caveopolis:recipes/misc/magenta_colored_cobblestone_slab" | "caveopolis:recipes/misc/white_colored_wooden_plank_pressure_plate_from_white_colored_wooden_planks_stonecutting" | "aquaculture:recipes/decorations/birch_fish_mount" | "minecraft:recipes/building_blocks/prismarine" | "aquaculture:recipes/combat/neptunium_sword" | "minecraft:recipes/building_blocks/polished_diorite" | "minecraft:recipes/sea_pickle" | "minecraft:recipes/misc/brown_dye" | "minecraft:recipes/building_blocks/raw_iron_block" | "awesomedungeonocean:ocean_temple_quad/find_normal" | "minecraft:recipes/building_blocks/mud_brick_slab_from_mud_bricks_stonecutting" | "alltheores:recipes/misc/peridot_from_hammer_crushing" | "farmersdelight:recipes/decorations/mangrove_cabinet" | "caveopolis:recipes/building_blocks/yellow_colored_cobblestone_brick_stairs" | "igleelib:recipes/igleelib/lavium_block" | "storagedrawers:recipes/storagedrawers/compacting_drawers" | "caveopolis:recipes/building_blocks/blue_colored_cobblestone" | "caveopolis:recipes/misc/lime_colored_hanging_sign_from_stripped_lime_colored_log_stonecutting" | "caveopolis:recipes/redstone/light_blue_colored_wooden_plank_pressure_plate" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_stonecutting" | "farmersdelight:recipes/cooking/mushroom_stew" | "caveopolis:recipes/misc/light_gray_colored_stone_brick_wall_from_light_gray_colored_stone_bricks_stonecutting" | "minecraft:recipes/decorations/blue_stained_glass_pane_from_glass_pane" | "minecraft:recipes/misc/netherite_scrap_from_blasting" | "minecraft:recipes/combat/diamond_sword" | "minecraft:recipes/decorations/cyan_stained_glass_pane" | "minecraft:recipes/misc/white_dye" | "minecraft:recipes/building_blocks/stripped_warped_hyphae" | "supplementaries:recipes/candle_holders/candle_holder_blue" | "caveopolis:recipes/redstone/purple_colored_wooden_plank_door" | "minecraft:recipes/decorations/jukebox" | "caveopolis:recipes/misc/brown_colored_cobblestone_wall" | "caveopolis:recipes/building_blocks/cyan_colored_stone" | "caveopolis:recipes/building_blocks/white_colored_cobblestone" | "minecraft:recipes/misc/silence_armor_trim_smithing_template_smithing_trim" | "caveopolis:recipes/misc/light_blue_colored_wooden_plank_slab" | "caveopolis:recipes/decorations/purple_colored_hanging_sign" | "minecraft:recipes/end_stone" | "supplementaries:recipes/netherite_trapdoor" | "alltheores:recipes/misc/constantan_block" | "alltheores:recipes/misc/constantan_rod" | "caveopolis:recipes/misc/lime_colored_stone_pressure_plate_from_lime_colored_stone_stonecutting" | "supplementaries:recipes/flags/flag_orange" | "minecraft:recipes/misc/gold_nugget" | "caveopolis:recipes/misc/gray_colored_stone_button_from_gray_colored_stone_stonecutting" | "caveopolis:recipes/misc/orange_colored_cobblestone_wall" | "minecraft:recipes/building_blocks/smooth_sandstone_slab_from_smooth_sandstone_stonecutting" | "caveopolis:recipes/misc/pink_colored_stone_slab" | "minecraft:nether/all_effects" | "minecraft:recipes/nether_wart" | "supplementaries:recipes/flags/flag_magenta" | "caveopolis:recipes/building_blocks/black_colored_wooden_planks" | "caveopolis:recipes/misc/cobblestone_brick_wall_from_cobblestone_bricks_stonecutting" | "industrialforegoing:recipes/misc/laser_lens_orange_recolor" | "minecraft:recipes/piglin_head" | "caveopolis:recipes/building_blocks/gray_colored_wooden_planks" | "caveopolis:recipes/redstone/gray_colored_wooden_plank_fence_gate" | "caveopolis:recipes/redstone/light_blue_colored_stone_button" | "minecraft:recipes/skull_pottery_sherd" | "supplementaries:recipes/checker_slab" | "minecraft:recipes/decorations/white_glazed_terracotta" | "caveopolis:recipes/redstone/green_colored_stone_button" | "minecraft:recipes/combat/iron_helmet" | "minecraft:recipes/tools/golden_shovel" | "strainers:recipes/misc/purifying_salt_mulch" | "caveopolis:recipes/misc/red_colored_stone_button_from_red_colored_stone_stonecutting" | "aquaculture:recipes/misc/neptunium_ingot_from_neptunium_block" | "caveopolis:recipes/building_blocks/blue_colored_stone_bricks" | "caveopolis:recipes/misc/light_blue_colored_wooden_plank_pressure_plate_from_light_blue_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/dye_magenta_carpet" | "caveopolis:recipes/redstone/blue_colored_wooden_plank_button" | "minecraft:recipes/combat/diamond_chestplate" | "minecraft:story/mine_stone" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "minecraft:recipes/decorations/furnace" | "caveopolis:recipes/misc/lime_colored_wooden_plank_slab_from_lime_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/purple_colored_stone_brick_wall" | "alltheores:recipes/misc/electrum_ingot" | "minecraft:recipes/food/beetroot_soup" | "farmersdelight:recipes/tools/lead_from_straw" | "aquaculture:recipes/tools/neptunium_fillet_knife" | "minecraft:recipes/building_blocks/andesite_stairs" | "minecraft:recipes/rose_bush" | "caveopolis:recipes/misc/black_colored_sign_from_black_colored_wooden_planks_stonecutting" | "minecraft:recipes/redstone/redstone_torch" | "minecraft:recipes/food/golden_apple" | "minecraft:recipes/misc/gold_ingot_from_blasting_raw_gold" | "minecraft:recipes/building_blocks/green_concrete_powder" | "supplementaries:recipes/candle_holders/candle_holder_lime" | "caveopolis:recipes/misc/cyan_colored_wooden_plank_slab" | "supplementaries:recipes/soap" | "minecraft:recipes/building_blocks/orange_stained_glass" | "farmersdelight:recipes/food/cooked_salmon_slice_from_campfire_cooking" | "aquamirae:recipes/abyssal_amethyst" | "minecraft:adventure/two_birds_one_arrow" | "minecraft:recipes/decorations/end_crystal" | "caveopolis:recipes/misc/mixed_stone_ingot_from_smelting_raw_mixed_stone" | "farmersdelight:recipes/food/melon_popsicle" | "alltheores:recipes/misc/gold_dust_from_hammer_crushing" | "farmersdelight:recipes/food/roast_chicken_block" | "caveopolis:recipes/misc/cyan_colored_wooden_plank_trapdoor_from_cyan_colored_wooden_planks_stonecutting" | "minecraft:recipes/tube_coral_fan" | "minecraft:recipes/redstone/birch_door" | "caveopolis:recipes/misc/green_colored_stone_button_from_green_colored_stone_stonecutting" | "supplementaries:recipes/lock_block" | "storagedrawers:recipes/storagedrawers/diamond_storage_upgrade" | "minecraft:recipes/decorations/snow" | "minecraft:recipes/decorations/soul_lantern" | "caveopolis:recipes/misc/brown_colored_wooden_plank_button_from_brown_colored_wooden_planks_stonecutting" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/oxidized_cut_copper_from_oxidized_copper_stonecutting" | "minecraft:recipes/decorations/cherry_fence" | "minecraft:recipes/decorations/birch_fence" | "minecraft:recipes/decorations/sandstone_wall_from_sandstone_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_refill_upgrade" | "minecraft:recipes/building_blocks/stone_brick_stairs" | "minecraft:recipes/combat/golden_boots" | "alltheores:recipes/misc/osmium_nugget_from_ingot" | "minecraft:recipes/tools/wooden_axe" | "farmersdelight:recipes/food/beef_patty_from_campfire_cooking" | "caveopolis:recipes/misc/green_colored_cobblestone_brick_slab" | "alltheores:recipes/misc/sapphire_from_block" | "caveopolis:recipes/misc/blue_colored_cobblestone_brick_stairs_from_blue_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_smelting_gold_ore" | "minecraft:recipes/building_blocks/stone_bricks_from_stone_stonecutting" | "caveopolis:recipes/misc/blue_spray_can" | "minecraft:recipes/building_blocks/chiseled_sandstone" | "framedcompactdrawers:recipes/misc/framed_slave" | "caveopolis:recipes/misc/purple_colored_wooden_plank_fence_gate_from_purple_colored_wooden_planks_stonecutting" | "caveopolis:recipes/redstone/orange_colored_wooden_plank_button" | "minecraft:recipes/building_blocks/stone_slab" | "minecraft:recipes/decorations/black_carpet" | "caveopolis:recipes/misc/white_colored_wooden_plank_slab" | "minecraft:recipes/misc/gold_nugget_from_blasting" | "minecraft:recipes/decorations/yellow_stained_glass_pane" | "farmersdelight:main/get_fd_seed" | "minecraft:recipes/building_blocks/blue_concrete_powder" | "alltheores:recipes/misc/nickel_plate" | "caveopolis:recipes/misc/orange_colored_wooden_plank_fence_from_orange_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/building_blocks/granite_slab_from_granite_stonecutting" | "caveopolis:recipes/misc/brown_colored_stone_pressure_plate_from_brown_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/crimson_planks" | "aquaculture:recipes/combat/neptunium_bow" | "alltheores:recipes/misc/uranium_plate" | "supplementaries:recipes/candle_holders/candle_holder_brown_dye" | "minecraft:recipes/building_blocks/cut_sandstone" | "minecraft:recipes/building_blocks/smooth_red_sandstone" | "minecraft:recipes/building_blocks/black_terracotta" | "caveopolis:recipes/misc/gray_colored_wooden_plank_pressure_plate_from_gray_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/blackstone_wall" | "minecraft:recipes/misc/cyan_dye_from_pitcher_plant" | "caveopolis:recipes/misc/red_colored_stone_crafting_table" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "farmersdelight:recipes/cooking/chicken_soup" | "minecraft:recipes/decorations/purple_candle" | "caveopolis:recipes/building_blocks/magenta_colored_cobblestone_bricks" | "minecraft:recipes/decorations/pink_glazed_terracotta" | "minecraft:recipes/misc/coal" | "caveopolis:recipes/misc/marble_brick_stairs_from_marble_bricks_stonecutting" | "minecraft:recipes/transportation/spruce_chest_boat" | "smallships:recipes/transportation/jungle_cog" | "sophisticatedbackpacks:recipes/misc/magnet_upgrade" | "minecraft:recipes/turtle_egg" | "caveopolis:recipes/building_blocks/stripped_white_colored_wood" | "minecraft:recipes/food/cooked_rabbit" | "caveopolis:recipes/building_blocks/light_blue_colored_stone_stairs" | "caveopolis:recipes/misc/brown_colored_stone_brick_wall" | "caveopolis:recipes/misc/red_colored_stone_slab" | "caveopolis:recipes/misc/magenta_colored_cobblestone_stairs_from_magenta_colored_cobblestone_stonecutting" | "minecraft:recipes/combat/leather_chestplate" | "caveopolis:recipes/misc/magenta_colored_sign_from_magenta_colored_wooden_planks_stonecutting" | "minecraft:recipes/lapis_lazuli" | "alltheores:recipes/misc/tin_ingot" | "caveopolis:recipes/misc/white_colored_stone_button_from_white_colored_stone_stonecutting" | "minecraft:recipes/misc/magenta_dye_from_blue_red_pink" | "minecraft:recipes/decorations/yellow_candle" | "aquaculture:recipes/misc/iron_nugget_from_smelting" | "minecraft:nether/obtain_blaze_rod" | "caveopolis:recipes/misc/gray_colored_wooden_plank_stairs_from_gray_colored_wooden_planks_stonecutting" | "storagedrawers:recipes/storagedrawers/acacia_drawers" | "supplementaries:recipes/building_blocks/cozy_home/sign_post_spruce" | "caveopolis:recipes/misc/light_gray_colored_stone_pressure_plate_from_light_gray_colored_stone_stonecutting" | "oceansdelight:recipes/food/fugu_roll" | "caveopolis:recipes/building_blocks/magenta_colored_stone_bricks" | "minecraft:adventure/shoot_arrow" | "minecraft:recipes/building_blocks/polished_blackstone_stairs" | "oceansdelight:recipes/oceansdelight/stuffed_cod" | "caveopolis:recipes/building_blocks/light_gray_colored_stone" | "farmersdelight:main/place_organic_compost" | "supplementaries:recipes/candle_holders/candle_holder_light_blue" | "farmersdelight:main/place_campfire" | "supplementaries:recipes/flax_block_uncrafting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab" | "minecraft:recipes/building_blocks/chiseled_red_sandstone" | "caveopolis:recipes/building_blocks/lime_colored_cobblestone_bricks" | "minecraft:recipes/decorations/light_gray_stained_glass_pane_from_glass_pane" | "farmersdelight:recipes/food/fried_egg_from_campfire_cooking" | "smallships:recipes/transportation/dark_oak_brigg" | "minecraft:adventure/arbalistic" | "alltheores:recipes/misc/tin_gear" | "minecraft:recipes/decorations/pink_candle" | "caveopolis:recipes/misc/orange_colored_wooden_plank_trapdoor_from_orange_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/purple_colored_cobblestone_wall" | "minecraft:recipes/building_blocks/deepslate_brick_stairs" | "minecraft:recipes/decorations/light_blue_bed" | "caveopolis:recipes/misc/pink_colored_wooden_plank_slab_from_pink_colored_wooden_planks_stonecutting" | "caveopolis:recipes/building_blocks/pink_colored_cobblestone_brick_stairs" | "minecraft:recipes/building_blocks/pink_stained_glass" | "framedcompactdrawers:recipes/misc/framed_half_four" | "minecraft:recipes/decorations/purple_stained_glass_pane" | "minecraft:recipes/building_blocks/black_stained_glass" | "minecraft:recipes/building_blocks/brick_stairs_from_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting" | "caveopolis:recipes/redstone/red_colored_wooden_plank_fence_gate" | "alltheores:recipes/misc/iridium_ingot_from_block" | "minecraft:nether/charge_respawn_anchor" | "supplementaries:recipes/candle_holders/candle_holder_gray" | "minecraft:recipes/building_blocks/bamboo_planks" | "minecraft:recipes/building_blocks/cracked_polished_blackstone_bricks" | "minecraft:recipes/building_blocks/gray_stained_glass" | "caveopolis:recipes/misc/gray_colored_cobblestone_brick_slab_from_gray_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/decorations/crafting_table" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_copper_block_stonecutting" | "minecraft:recipes/misc/map" | "minecraft:recipes/decorations/chest" | "caveopolis:recipes/redstone/green_colored_wooden_plank_pressure_plate" | "minecraft:story/shiny_gear" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab" | "minecraft:recipes/granite" | "alltheores:recipes/misc/nickel_ingot" | "aquaculture:recipes/tools/golden_fishing_rod" | "supplementaries:recipes/sugar_cube_uncrafting" | "supplementaries:recipes/decorations/sign_post_dark_oak" | "minecraft:recipes/tools/shears" | "minecraft:recipes/misc/stick" | "alltheores:recipes/misc/iron_ingot_from_dust" | "alltheores:recipes/misc/nickel_ingot_from_ore_blasting" | "minecraft:recipes/redstone/crimson_pressure_plate" | "farmersdelight:recipes/decorations/gray_canvas_sign" | "caveopolis:recipes/misc/red_colored_stone_wall_from_red_colored_stone_stonecutting" | "minecraft:recipes/redstone/polished_blackstone_button" | "caveopolis:recipes/misc/light_gray_colored_wooden_plank_crafting_table" | "caveopolis:recipes/decorations/light_gray_colored_sign" | "alltheores:recipes/misc/tin_dust_from_hammer_ingot_crushing" | "supplementaries:recipes/cage" | "caveopolis:recipes/misc/lime_colored_sign_from_lime_colored_wooden_planks_stonecutting" | "nec:recipes/decorations/birch_chest" | "minecraft:recipes/brewing/golden_carrot" | "caveopolis:recipes/building_blocks/pink_colored_wood" | "caveopolis:recipes/building_blocks/light_gray_colored_wooden_planks" | "alltheores:recipes/misc/constantan_gear" | "minecraft:recipes/diorite" | "minecraft:recipes/building_blocks/pink_terracotta" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "minecraft:adventure/summon_iron_golem" | "caveopolis:recipes/building_blocks/light_gray_colored_cobblestone" | "minecraft:recipes/transportation/jungle_chest_boat" | "caveopolis:recipes/misc/green_colored_wooden_plank_stairs_from_green_colored_wooden_planks_stonecutting" | "aquaculture:recipes/misc/gold_nugget_from_smelting" | "supplementaries:recipes/blackstone_tile_slab" | "suppsquared:recipes/decorations/item_shelf_crimson" | "minecraft:recipes/building_blocks/dye_pink_bed" | "caveopolis:recipes/misc/marble_brick_slab" | "minecraft:recipes/tools/spyglass" | "alltheores:recipes/misc/lumium_ingot_from_dust_blasting" | "minecraft:recipes/redstone/lectern" | "minecraft:recipes/building_blocks/stone_stairs_from_stone_stonecutting" | "caveopolis:recipes/redstone/black_colored_wooden_plank_fence_gate" | "awesomedungeonocean:ocean_warn_temple/find_during_storm" | "minecraft:recipes/misc/red_dye_from_rose_bush" | "minecraft:recipes/misc/magenta_dye_from_purple_and_pink" | "minecraft:recipes/salmon" | "minecraft:recipes/decorations/mossy_stone_brick_wall" | "caveopolis:recipes/misc/green_colored_stone_wall_from_green_colored_stone_stonecutting" | "smallships:recipes/transportation/birch_galley" | "sophisticatedbackpacks:recipes/misc/filter_upgrade" | "caveopolis:recipes/misc/purple_colored_wooden_plank_button_from_purple_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/light_blue_colored_stone_button_from_light_blue_colored_stone_stonecutting" | "minecraft:adventure/sleep_in_bed" | "caveopolis:recipes/building_blocks/stripped_magenta_colored_wood" | "minecraft:recipes/food/cooked_rabbit_from_campfire_cooking" | "minecraft:recipes/building_blocks/cobblestone_slab_from_cobblestone_stonecutting" | "alltheores:recipes/misc/gold_ingot_from_dust" | "aquamirae:recipes/spinefish" | "caveopolis:recipes/building_blocks/green_colored_stone" | "industrialforegoing:recipes/misc/laser_lens_black_recolor" | "caveopolis:recipes/misc/cyan_colored_stone_crafting_table" | "minecraft:recipes/building_blocks/prismarine_slab_from_prismarine_stonecutting" | "minecraft:recipes/decorations/birch_sign" | "minecraft:recipes/transportation/cherry_boat" | "storagedrawers:recipes/storagedrawers/dark_oak_drawers" | "awesomedungeonocean:ocean_warn_temple/find_normal" | "farmersdelight:recipes/food/carrot_from_crate" | "caveopolis:recipes/misc/magenta_colored_wooden_plank_fence_gate_from_magenta_colored_wooden_planks_stonecutting" | "minecraft:recipes/tools/diamond_pickaxe" | "minecraft:recipes/redstone/lightning_rod" | "caveopolis:recipes/misc/lime_colored_stone_brick_slab" | "minecraft:adventure/kill_all_mobs" | "minecraft:recipes/decorations/brown_glazed_terracotta" | "storagedrawers:recipes/storagedrawers/illumination_upgrade" | "minecraft:recipes/building_blocks/birch_wood" | "caveopolis:recipes/misc/lime_colored_cobblestone_brick_slab" | "caveopolis:recipes/misc/cyan_colored_stone_brick_wall" | "supplementaries:recipes/candle_holders/candle_holder_white_dye" | "minecraft:recipes/decorations/crimson_sign" | "alltheores:recipes/misc/zinc_gear" | "supplementaries:recipes/soap/spike" | "caveopolis:recipes/decorations/purple_colored_sign" | "minecraft:adventure/voluntary_exile" | "minecraft:recipes/decorations/granite_wall_from_granite_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "supplementaries:recipes/blackstone_lamp" | "farmersdelight:recipes/food/cabbage_from_leaves" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_blackstone_stonecutting" | "alltheores:recipes/misc/raw_zinc_block" | "caveopolis:recipes/building_blocks/brown_colored_stone_bricks" | "minecraft:recipes/building_blocks/cherry_planks" | "caveopolis:recipes/misc/brown_colored_stone_crafting_table" | "alltheores:recipes/misc/electrum_ingot_from_dust" | "minecraft:recipes/building_blocks/dye_cyan_bed" | "caveopolis:recipes/misc/black_colored_wooden_plank_door_from_black_colored_wooden_planks_stonecutting" | "supplementaries:recipes/flint_block" | "minecraft:recipes/combat/golden_chestplate" | "minecraft:recipes/building_blocks/stripped_dark_oak_wood" | "sophisticatedbackpacks:recipes/misc/feeding_upgrade" | "caveopolis:recipes/misc/light_blue_colored_wooden_plank_fence_from_light_blue_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/dye_yellow_wool" | "caveopolis:recipes/building_blocks/light_gray_colored_stone_stairs" | "caveopolis:recipes/misc/pink_colored_stone_brick_wall_from_pink_colored_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/iron_block" | "farmersdelight:recipes/food/bacon_sandwich" | "minecraft:recipes/misc/red_dye_from_poppy" | "caveopolis:recipes/building_blocks/light_blue_colored_wooden_planks" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs" | "caveopolis:recipes/misc/black_colored_cobblestone_brick_wall" | "aquamirae:adventure/obtain_fin" | "minecraft:recipes/building_blocks/clay" | "minecraft:recipes/orange_tulip" | "sophisticatedbackpacks:recipes/misc/advanced_compacting_upgrade" | "caveopolis:recipes/redstone/blue_colored_wooden_plank_fence_gate" | "caveopolis:recipes/misc/brown_colored_wooden_plank_fence_from_brown_colored_wooden_planks_stonecutting" | "caveopolis:recipes/decorations/blue_colored_hanging_sign" | "caveopolis:recipes/misc/magenta_colored_wooden_plank_fence_from_magenta_colored_wooden_planks_stonecutting" | "supplementaries:recipes/cog_block" | "supplementaries:recipes/candle_holders/candle_holder_orange_dye" | "minecraft:recipes/decorations/birch_hanging_sign" | "minecraft:recipes/transportation/mangrove_chest_boat" | "caveopolis:recipes/building_blocks/blue_colored_stone_brick_stairs" | "minecraft:recipes/decorations/deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "alltheores:recipes/misc/bronze_block" | "minecraft:recipes/decorations/gray_carpet" | "caveopolis:recipes/misc/black_spray_can" | "minecraft:recipes/decorations/deepslate_tile_wall" | "caveopolis:recipes/misc/white_colored_stone_bricks_from_white_colored_stone_stonecutting" | "minecraft:recipes/redstone/tripwire_hook" | "caveopolis:recipes/building_blocks/orange_colored_stone_bricks" | "caveopolis:recipes/misc/blue_colored_wooden_plank_trapdoor_from_blue_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/black_colored_cobblestone_bricks_from_black_colored_cobblestone_stonecutting" | "supplementaries:recipes/ash_brick_wall" | "caveopolis:recipes/misc/orange_colored_wooden_plank_slab" | "minecraft:recipes/redstone/birch_fence_gate" | "alltheores:recipes/misc/uranium_ingot" | "minecraft:recipes/redstone/stone_button" | "caveopolis:recipes/building_blocks/yellow_colored_wood" | "alltheores:recipes/misc/osmium_ingot" | "minecraft:recipes/building_blocks/packed_mud" | "caveopolis:recipes/misc/orange_colored_stone_brick_wall" | "caveopolis:recipes/building_blocks/gray_colored_cobblestone" | "farmersdelight:recipes/decorations/cooking_pot" | "caveopolis:recipes/misc/black_colored_stone_brick_stairs_from_black_colored_stone_bricks_stonecutting" | "igleelib:recipes/igleelib/blazum_ingot" | "farmersdelight:recipes/food/apple_pie_from_slices" | "alltheores:recipes/misc/raw_tin_block" | "minecraft:recipes/building_blocks/smooth_sandstone_slab" | "alltheores:recipes/misc/uranium_gear" | "minecraft:recipes/dark_oak_sapling" | "minecraft:recipes/building_blocks/blue_terracotta" | "supplementaries:recipes/stonecutting/stone_tile_stairs_from_bricks" | "minecraft:recipes/building_blocks/stone" | "smallships:recipes/transportation/oak_drakkar" | "duckling:fishing_rod" | "minecraft:recipes/decorations/green_carpet" | "minecraft:recipes/building_blocks/light_blue_terracotta" | "supplementaries:recipes/candle_holders/candle_holder_red_dye" | "caveopolis:recipes/misc/orange_colored_wooden_plank_fence_gate_from_orange_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/green_colored_cobblestone_wall_from_green_colored_cobblestone_stonecutting" | "minecraft:recipes/transportation/bamboo_raft" | "minecraft:recipes/building_blocks/cut_red_sandstone" | "sophisticatedbackpacks:recipes/misc/battery_upgrade" | "alltheores:recipes/misc/zinc_block" | "caveopolis:recipes/misc/cyan_colored_cobblestone_wall" | "supplementaries:recipes/bomb" | "supplementaries:recipes/end_stone_lamp" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab" | "solcarrot:recipes/food_book" | "minecraft:recipes/decorations/purple_carpet" | "caveopolis:recipes/misc/lime_colored_cobblestone_slab" | "caveopolis:recipes/misc/brown_colored_stone_brick_slab_from_brown_colored_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/cut_copper" | "caveopolis:recipes/misc/gray_colored_wooden_plank_fence_gate_from_gray_colored_wooden_planks_stonecutting" | "minecraft:recipes/redstone/stone_pressure_plate" | "minecraft:recipes/building_blocks/polished_blackstone_slab" | "aquaculture:recipes/misc/bonemeal_from_fish_bones" | "caveopolis:recipes/misc/gray_colored_stone_brick_slab_from_gray_colored_stone_bricks_stonecutting" | "minecraft:recipes/misc/netherite_ingot" | "supplementaries:recipes/candle_holders/candle_holder_light_gray" | "supplementaries:recipes/blackstone_tile" | "minecraft:recipes/building_blocks/dye_lime_bed" | "minecraft:recipes/azure_bluet" | "caveopolis:recipes/decorations/yellow_colored_sign" | "nec:recipes/decorations/bamboo_chest" | "caveopolis:recipes/building_blocks/blue_colored_wooden_plank_stairs" | "caveopolis:recipes/building_blocks/stripped_black_colored_wood" | "minecraft:adventure/spyglass_at_dragon" | "smallships:recipes/transportation/mangrove_brigg" | "sophisticatedbackpacks:recipes/misc/advanced_deposit_upgrade" | "minecraft:adventure/trade_at_world_height" | "awesomedungeonocean:ocean_warn_temple/find_during_rain" | "minecraft:recipes/decorations/red_sandstone_wall_from_red_sandstone_stonecutting" | "minecraft:recipes/food/cookie" | "supplementaries:recipes/stonecutting/stone_tile_slab" | "supplementaries:recipes/decorations/sign_post_crimson" | "caveopolis:recipes/building_blocks/stripped_light_gray_colored_wood" | "caveopolis:recipes/decorations/brown_colored_sign" | "minecraft:recipes/decorations/light_blue_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/acacia_stairs" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_copper_stonecutting" | "minecraft:recipes/misc/fire_charge" | "minecraft:recipes/decorations/soul_torch" | "alltheores:recipes/misc/iron_gear" | "strainers:recipes/deepslate_pebble" | "caveopolis:recipes/misc/orange_spray_can" | "minecraft:recipes/building_blocks/yellow_terracotta" | "caveopolis:recipes/misc/lime_colored_wooden_plank_stairs_from_lime_colored_wooden_planks_stonecutting" | "farmersdelight:recipes/cooking/baked_cod_stew" | "minecraft:recipes/misc/writable_book" | "farmersdelight:recipes/combat/golden_knife" | "minecraft:recipes/decorations/candle" | "suppsquared:recipes/decorations/item_shelf_mangrove" | "minecraft:recipes/dragon_breath" | "minecraft:recipes/food/bread" | "caveopolis:recipes/redstone/yellow_colored_stone_button" | "supplementaries:recipes/decorations/sign_post_bamboo" | "minecraft:nether/obtain_ancient_debris" | "caveopolis:recipes/misc/purple_colored_stone_wall" | "minecraft:recipes/misc/bone_meal_from_bone_block" | "supplementaries:recipes/building_blocks/cozy_home/sign_post_oak" | "alltheores:recipes/misc/steel_ingot" | "minecraft:recipes/decorations/magenta_candle" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_copper_stonecutting" | "minecraft:nether/create_full_beacon" | "caveopolis:recipes/building_blocks/light_gray_colored_cobblestone_bricks" | "minecraft:recipes/building_blocks/diorite" | "minecraft:recipes/building_blocks/dye_white_bed" | "caveopolis:recipes/misc/green_colored_stone_brick_slab" | "caveopolis:recipes/redstone/magenta_colored_wooden_plank_door" | "awesomedungeonocean:ocean_the_column_temple/find_during_storm" | "minecraft:recipes/decorations/spruce_hanging_sign" | "farmersdelight:recipes/building_blocks/rice_bale" | "minecraft:recipes/building_blocks/polished_granite_from_granite_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_copper_stonecutting" | "alltheores:recipes/misc/brass_plate" | "caveopolis:recipes/redstone/purple_colored_wooden_plank_pressure_plate" | "farmersdelight:recipes/decorations/magenta_canvas_sign" | "alltheores:recipes/misc/tin_rod" | "minecraft:recipes/building_blocks/birch_slab" | "caveopolis:recipes/redstone/gray_colored_stone_pressure_plate" | "minecraft:recipes/misc/raw_gold" | "caveopolis:recipes/misc/orange_colored_wooden_plank_pressure_plate_from_orange_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/white_colored_stone_slab" | "caveopolis:recipes/building_blocks/light_blue_colored_stone_bricks" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_honeycomb" | "awesomedungeonocean:ocean_the_column_temple/find_during_rain" | "minecraft:recipes/decorations/oak_hanging_sign" | "caveopolis:recipes/misc/yellow_colored_wooden_plank_button_from_yellow_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/dye_lime_carpet" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_blackstone_stonecutting" | "minecraft:recipes/horn_coral_block" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs" | "minecraft:recipes/redstone/redstone_from_smelting_redstone_ore" | "minecraft:recipes/glow_berries" | "caveopolis:recipes/misc/cyan_colored_stone_pressure_plate_from_cyan_colored_stone_stonecutting" | "caveopolis:recipes/misc/red_colored_cobblestone_stairs_from_red_colored_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/hay_block" | "minecraft:recipes/misc/leather_horse_armor" | "aquamirae:recipes/sharp_bones" | "caveopolis:recipes/misc/gray_colored_cobblestone_wall_from_gray_colored_cobblestone_stonecutting" | "caveopolis:recipes/redstone/magenta_colored_wooden_plank_fence_gate" | "caveopolis:recipes/misc/magenta_colored_stone_brick_slab" | "caveopolis:recipes/misc/yellow_colored_hanging_sign_from_stripped_yellow_colored_log_stonecutting" | "minecraft:recipes/building_blocks/granite" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_cut_sandstone_stonecutting" | "alltheores:recipes/misc/lead_dust_from_hammer_ingot_crushing" | "caveopolis:recipes/misc/blue_colored_wooden_plank_fence_from_blue_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/black_colored_wooden_plank_pressure_plate_from_black_colored_wooden_planks_stonecutting" | "caveopolis:recipes/building_blocks/light_blue_colored_stone_brick_stairs" | "minecraft:recipes/misc/emerald_from_smelting_deepslate_emerald_ore" | "caveopolis:recipes/redstone/pink_colored_wooden_plank_trapdoor" | "minecraft:recipes/transportation/oak_chest_boat" | "minecraft:recipes/redstone/target" | "alltheores:recipes/misc/lumium_nugget_from_ingot" | "farmersdelight:recipes/decorations/blue_hanging_canvas_sign" | "caveopolis:recipes/misc/white_spray_can" | "minecraft:recipes/redstone/crimson_door" | "alltheores:recipes/misc/aluminum_rod" | "supplementaries:recipes/ash_brick" | "caveopolis:recipes/building_blocks/light_gray_colored_cobblestone_stairs" | "farmersdelight:recipes/cooking/apple_cider" | "minecraft:recipes/misc/copper_ingot_from_waxed_copper_block" | "alltheores:recipes/misc/uranium_ingot_from_block" | "minecraft:recipes/jungle_sapling" | "minecraft:recipes/redstone/acacia_door" | "awesomedungeonocean:ocean_temple_quad/find_during_storm" | "caveopolis:recipes/misc/lime_colored_wooden_plank_fence_from_lime_colored_wooden_planks_stonecutting" | "caveopolis:recipes/building_blocks/gray_colored_wood" | "caveopolis:recipes/misc/red_colored_cobblestone_slab" | "minecraft:recipes/misc/tide_armor_trim_smithing_template" | "minecraft:recipes/decorations/spruce_fence" | "minecraft:recipes/tools/diamond_hoe" | "aquamirae:adventure/catch_golden_moth" | "minecraft:recipes/transportation/activator_rail" | "minecraft:recipes/building_blocks/dark_oak_stairs" | "minecraft:recipes/tools/diamond_shovel" | "minecraft:recipes/building_blocks/polished_granite_slab_from_polished_granite_stonecutting" | "chipped:recipes/carpenters_table" | "farmersdelight:recipes/cooking/squid_ink_pasta" | "caveopolis:recipes/building_blocks/blue_colored_wooden_planks" | "minecraft:husbandry/safely_harvest_honey" | "sophisticatedbackpacks:recipes/misc/netherite_backpack" | "minecraft:recipes/building_blocks/granite_slab" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_honeycomb" | "supplementaries:recipes/sign_post_warped" | "caveopolis:recipes/misc/pink_colored_stone_wall_from_pink_colored_stone_stonecutting" | "caveopolis:recipes/misc/lime_colored_wooden_plank_door_from_lime_colored_wooden_planks_stonecutting" | "minecraft:adventure/spyglass_at_ghast" | "smallships:recipes/transportation/jungle_brigg" | "minecraft:adventure/trim_with_any_armor_pattern" | "minecraft:nether/uneasy_alliance" | "caveopolis:recipes/building_blocks/magenta_colored_stone" | "farmersdelight:recipes/misc/book_from_canvas" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting" | "caveopolis:recipes/misc/magenta_colored_cobblestone_slab_from_magenta_colored_cobblestone_stonecutting" | "alltheores:recipes/misc/nickel_dust_from_hammer_ingot_crushing" | "farmersdelight:main/eat_comfort_food" | "minecraft:recipes/redstone/redstone_from_blasting_redstone_ore" | "caveopolis:recipes/misc/gray_colored_sign_from_gray_colored_wooden_planks_stonecutting" | "minecraft:recipes/flint" | "caveopolis:recipes/decorations/gray_colored_sign" | "caveopolis:recipes/redstone/orange_colored_wooden_plank_fence_gate" | "caveopolis:recipes/misc/brown_colored_stone_button_from_brown_colored_stone_stonecutting" | "farmersdelight:main/plant_all_crops" | "caveopolis:recipes/misc/cyan_colored_stone_brick_stairs_from_cyan_colored_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_diorite_stonecutting" | "alltheores:recipes/misc/iridium_ingot_from_ore_blasting" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_3" | "aquaculture:recipes/tools/neptunium_fishing_rod" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_4" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1" | "supplementaries:recipes/building_blocks/cozy_home/sign_post_mangrove" | "caveopolis:recipes/building_blocks/red_colored_cobblestone_stairs" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_2" | "minecraft:recipes/building_blocks/dye_black_carpet" | "alltheores:recipes/misc/copper_dust_from_hammer_ingot_crushing" | "caveopolis:recipes/misc/red_colored_cobblestone_wall_from_red_colored_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/waxed_copper_block_from_honeycomb" | "minecraft:recipes/building_blocks/weathered_cut_copper" | "minecraft:recipes/redstone/warped_trapdoor" | "supplementaries:recipes/wrench" | "caveopolis:recipes/building_blocks/gray_colored_cobblestone_brick_stairs" | "minecraft:recipes/building_blocks/dye_brown_wool" | "caveopolis:recipes/building_blocks/marble_brick_stairs" | "minecraft:recipes/redstone/light_weighted_pressure_plate" | "minecraft:adventure/throw_trident" | "farmersdelight:recipes/cooking/glow_berry_custard" | "caveopolis:recipes/misc/blue_colored_wooden_plank_slab_from_blue_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab" | "caveopolis:recipes/misc/black_colored_cobblestone_stairs_from_black_colored_cobblestone_stonecutting" | "alltheores:recipes/misc/bronze_ore_hammer" | "minecraft:recipes/misc/conduit" | "alltheores:recipes/misc/constantan_ingot_from_block" | "minecraft:recipes/building_blocks/prismarine_stairs_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_polished_andesite_stonecutting" | "minecraft:recipes/decorations/green_candle" | "alltheores:recipes/misc/raw_osmium_from_block" | "alltheores:recipes/misc/zinc_nugget_from_ingot" | "storagedrawers:recipes/storagedrawers/acacia_trim" | "supplementaries:recipes/fodder" | "caveopolis:recipes/decorations/brown_colored_hanging_sign" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "caveopolis:recipes/misc/magenta_colored_wooden_plank_slab_from_magenta_colored_wooden_planks_stonecutting" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade_from_smelting_upgrade" | "storagedrawers:recipes/storagedrawers/crimson_trim" | "supplementaries:recipes/decorations/sign_post_birch" | "alltheores:recipes/misc/lead_ingot_from_slate_ore" | "minecraft:recipes/burn_pottery_sherd" | "alltheores:recipes/misc/sapphire_from_hammer_crushing" | "caveopolis:recipes/redstone/pink_colored_stone_pressure_plate" | "minecraft:recipes/decorations/bamboo_fence" | "caveopolis:recipes/misc/light_gray_colored_stone_slab" | "caveopolis:recipes/misc/purple_colored_cobblestone_brick_stairs_from_purple_colored_cobblestone_bricks_stonecutting" | "farmersdelight:recipes/decorations/white_hanging_canvas_sign" | "minecraft:recipes/red_sand" | "minecraft:recipes/building_blocks/polished_granite_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_waxed_weathered_copper_stonecutting" | "minecraft:recipes/redstone/repeater" | "minecraft:recipes/tools/compass" | "farmersdelight:recipes/food/kelp_roll" | "caveopolis:recipes/misc/white_colored_wooden_plank_trapdoor_from_white_colored_wooden_planks_stonecutting" | "supplementaries:recipes/daub_cross_brace" | "minecraft:adventure/ol_betsy" | "minecraft:recipes/building_blocks/quartz_block" | "alltheores:recipes/misc/signalum_ingot_from_dust_blasting" | "minecraft:recipes/decorations/gray_candle" | "alltheores:recipes/misc/signalum_dust_from_alloy_blending" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_vine" | "alltheores:recipes/misc/silver_ingot_from_ore_blasting" | "minecraft:recipes/decorations/cyan_bed" | "supplementaries:recipes/building_blocks/cozy_home/sign_post_jungle" | "alltheores:recipes/misc/aluminum_plate" | "minecraft:recipes/redstone" | "caveopolis:recipes/redstone/blue_colored_stone_pressure_plate" | "caveopolis:recipes/misc/light_gray_colored_wooden_plank_stairs_from_light_gray_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/raw_aluminum_block" | "minecraft:nether/netherite_armor" | "minecraft:recipes/building_blocks/birch_stairs" | "minecraft:recipes/building_blocks/jungle_stairs" | "minecraft:recipes/building_blocks/purpur_pillar" | "minecraft:recipes/food/pumpkin_pie" | "minecraft:recipes/decorations/end_rod" | "minecraft:recipes/misc/host_armor_trim_smithing_template_smithing_trim" | "minecraft:husbandry/breed_an_animal" | "smallships:recipes/transportation/spruce_galley" | "caveopolis:recipes/misc/purple_colored_wooden_plank_trapdoor_from_purple_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/yellow_colored_stone_brick_slab_from_yellow_colored_stone_bricks_stonecutting" | "minecraft:recipes/combat/netherite_helmet_smithing" | "minecraft:husbandry/complete_catalogue" | "caveopolis:recipes/misc/white_colored_wooden_plank_stairs_from_white_colored_wooden_planks_stonecutting" | "minecraft:recipes/cherry_sapling" | "minecraft:recipes/decorations/gray_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/stripped_spruce_wood" | "caveopolis:recipes/redstone/yellow_colored_wooden_plank_door" | "minecraft:recipes/decorations/brown_stained_glass_pane" | "farmersdelight:recipes/decorations/lime_canvas_sign" | "farmersdelight:recipes/decorations/black_hanging_canvas_sign" | "caveopolis:recipes/redstone/pink_colored_wooden_plank_door" | "aquamirae:recipes/esca" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_honeycomb" | "caveopolis:recipes/redstone/orange_colored_wooden_plank_pressure_plate" | "minecraft:recipes/building_blocks/mossy_cobblestone_stairs" | "caveopolis:recipes/building_blocks/lime_colored_wood" | "industrialforegoing:recipes/misc/laser_lens_pink_recolor" | "alltheores:recipes/misc/sapphire_dust_from_hammer_crushing" | "caveopolis:recipes/misc/brown_colored_stone_brick_stairs_from_brown_colored_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/stripped_cherry_wood" | "minecraft:recipes/decorations/gray_glazed_terracotta" | "minecraft:recipes/misc/light_blue_dye_from_blue_orchid" | "minecraft:recipes/building_blocks/red_nether_brick_slab_from_red_nether_bricks_stonecutting" | "caveopolis:recipes/misc/gray_colored_stone_brick_wall_from_gray_colored_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs" | "minecraft:recipes/building_blocks/lime_concrete_powder" | "minecraft:recipes/misc/moss_block" | "caveopolis:recipes/misc/brown_colored_sign_from_brown_colored_wooden_planks_stonecutting" | "minecraft:recipes/archer_pottery_sherd" | "supplementaries:recipes/feather_block" | "smallships:recipes/transportation/birch_cog" | "farmersdelight:recipes/food/hamburger" | "minecraft:recipes/building_blocks/copper_block" | "supplementaries:recipes/planter_rich" | "caveopolis:recipes/building_blocks/light_blue_colored_cobblestone_bricks" | "minecraft:recipes/building_blocks/dark_prismarine_stairs_from_dark_prismarine_stonecutting" | "farmersdelight:recipes/food/rice" | "caveopolis:recipes/misc/pink_colored_cobblestone_brick_slab_from_pink_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/redstone/spruce_button" | "sophisticatedbackpacks:recipes/misc/xp_pump_upgrade" | "supplementaries:recipes/stone_tile_slab" | "caveopolis:recipes/misc/marble_stairs_from_marble_stonecutting" | "caveopolis:recipes/misc/lime_colored_stone_bricks_from_lime_colored_stone_stonecutting" | "minecraft:recipes/misc/popped_chorus_fruit" | "minecraft:nether/distract_piglin" | "caveopolis:recipes/misc/cobblestone_brick_stairs_from_cobblestone_bricks_stonecutting" | "caveopolis:recipes/misc/white_colored_stone_brick_wall_from_white_colored_stone_bricks_stonecutting" | "minecraft:recipes/misc/flower_banner_pattern" | "caveopolis:recipes/misc/black_colored_stone_button_from_black_colored_stone_stonecutting" | "caveopolis:recipes/building_blocks/magenta_colored_stone_stairs" | "supplementaries:recipes/sign_post_spruce" | "caveopolis:recipes/misc/red_colored_wooden_plank_fence_from_red_colored_wooden_planks_stonecutting" | "farmersdelight:recipes/food/apple_pie" | "caveopolis:recipes/misc/purple_colored_stone_button_from_purple_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/sandstone_stairs" | "sophisticatedbackpacks:recipes/misc/void_upgrade" | "minecraft:recipes/redstone/dark_oak_door" | "minecraft:recipes/misc/coal_from_smelting_deepslate_coal_ore" | "caveopolis:recipes/misc/blue_colored_stone_brick_wall_from_blue_colored_stone_bricks_stonecutting" | "minecraft:recipes/food/dried_kelp_from_smoking" | "minecraft:recipes/redstone/hopper" | "alltheores:recipes/misc/zinc_plate" | "alltheores:recipes/misc/lumium_ingot" | "minecraft:recipes/redstone/calibrated_sculk_sensor" | "farmersdelight:recipes/food/cooked_bacon_from_campfire_cooking" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_waxed_oxidized_copper_stonecutting" | "caveopolis:recipes/misc/cyan_colored_stone_slab" | "caveopolis:recipes/misc/green_colored_cobblestone_slab" | "caveopolis:recipes/building_blocks/brown_colored_cobblestone" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_copper_stonecutting" | "minecraft:recipes/misc/lime_dye" | "minecraft:recipes/misc/gold_ingot_from_smelting_raw_gold" | "caveopolis:recipes/misc/light_gray_colored_wooden_plank_trapdoor_from_light_gray_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/nickel_dust_from_hammer_crushing" | "alltheores:recipes/misc/ruby_dust_from_hammer_crushing" | "minecraft:recipes/building_blocks/smooth_basalt" | "alltheores:recipes/misc/silver_ingot_from_block" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template" | "minecraft:recipes/building_blocks/tinted_glass" | "minecraft:recipes/building_blocks/dye_blue_wool" | "sophisticatedbackpacks:recipes/misc/smelting_upgrade" | "minecraft:recipes/redstone/comparator" | "caveopolis:recipes/misc/blue_colored_cobblestone_brick_wall_from_blue_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/redstone/mangrove_pressure_plate" | "farmersdelight:recipes/cooking/hot_cocoa" | "minecraft:recipes/decorations/deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/red_stained_glass" | "minecraft:adventure/very_very_frightening" | "minecraft:story/lava_bucket" | "caveopolis:recipes/misc/lime_colored_wooden_plank_pressure_plate_from_lime_colored_wooden_planks_stonecutting" | "farmersdelight:recipes/food/chocolate_pie" | "supplementaries:recipes/pedestal" | "caveopolis:recipes/misc/black_colored_cobblestone_slab_from_black_colored_cobblestone_stonecutting" | "farmersdelight:recipes/food/cooked_bacon_from_smoking" | "minecraft:recipes/building_blocks/quartz_stairs" | "minecraft:recipes/misc/copper_ingot_from_blasting_raw_copper" | "minecraft:recipes/decorations/black_bed" | "minecraft:husbandry/ride_a_boat_with_a_goat" | "aquaculture:recipes/misc/brown_mushroom_from_fish" | "farmersdelight:recipes/combat/netherite_knife_smithing" | "caveopolis:recipes/misc/purple_colored_wooden_plank_slab_from_purple_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/polished_deepslate_from_cobbled_deepslate_stonecutting" | "sophisticatedbackpacks:recipes/misc/backpack" | "minecraft:recipes/food/cooked_beef_from_smoking" | "minecraft:recipes/snort_pottery_sherd" | "minecraft:recipes/decorations/pink_stained_glass_pane" | "caveopolis:recipes/redstone/green_colored_wooden_plank_fence_gate" | "farmersdelight:recipes/decorations/spruce_cabinet" | "minecraft:nether/all_potions" | "minecraft:recipes/misc/emerald_from_blasting_emerald_ore" | "minecraft:recipes/misc/diamond_from_smelting_deepslate_diamond_ore" | "alltheores:recipes/misc/signalum_plate" | "minecraft:recipes/combat/netherite_boots_smithing" | "minecraft:recipes/misc/light_blue_dye_from_blue_white_dye" | "supplementaries:adventure/way_sign" | "caveopolis:recipes/misc/mossy_string" | "caveopolis:recipes/building_blocks/stripped_brown_colored_wood" | "smallships:recipes/transportation/mangrove_drakkar" | "minecraft:recipes/building_blocks/orange_concrete_powder" | "minecraft:recipes/food/cooked_porkchop" | "minecraft:recipes/building_blocks/oak_slab" | "alltheores:recipes/misc/copper_ingot_from_dust" | "oceansdelight:recipes/cooked_elder_guardian_slice_from_smoking" | "caveopolis:recipes/misc/mixed_stone_ingot" | "caveopolis:recipes/misc/black_colored_wooden_plank_slab_from_black_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/cyan_colored_cobblestone_bricks_from_cyan_colored_cobblestone_stonecutting" | "farmersdelight:recipes/food/cooked_chicken_cuts_from_campfire_cooking" | "caveopolis:recipes/misc/gray_colored_cobblestone_slab_from_gray_colored_cobblestone_stonecutting" | "minecraft:husbandry/tame_an_animal" | "chipped:recipes/botanist_workbench" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone" | "minecraft:recipes/building_blocks/raw_copper_block" | "farmersdelight:recipes/food/roasted_mutton_chops" | "minecraft:recipes/building_blocks/granite_stairs" | "minecraft:recipes/decorations/cyan_glazed_terracotta" | "supplementaries:recipes/flute" | "caveopolis:recipes/misc/green_colored_cobblestone_bricks_from_green_colored_cobblestone_stonecutting" | "alltheores:recipes/misc/osmium_dust_from_hammer_crushing" | "minecraft:recipes/building_blocks/dye_red_bed" | "caveopolis:recipes/misc/orange_colored_hanging_sign_from_stripped_orange_colored_log_stonecutting" | "minecraft:recipes/building_blocks/dye_black_bed" | "minecraft:recipes/tools/brush" | "minecraft:recipes/decorations/cyan_candle" | "caveopolis:recipes/misc/purple_colored_wooden_plank_crafting_table" | "minecraft:recipes/building_blocks/diorite_stairs_from_diorite_stonecutting" | "industrialforegoing:recipes/misc/laser_lens_magenta_recolor" | "minecraft:recipes/small_dripleaf" | "supplementaries:recipes/candle_holders/candle_holder_orange" | "caveopolis:recipes/misc/gray_colored_cobblestone_brick_wall" | "minecraft:recipes/lilac" | "minecraft:recipes/building_blocks/stripped_acacia_wood" | "minecraft:recipes/misc/leather" | "farmersdelight:recipes/decorations/brown_hanging_canvas_sign" | "minecraft:recipes/decorations/light_gray_bed" | "farmersdelight:recipes/building_blocks/tomato_crate" | "minecraft:recipes/building_blocks/blackstone_stairs" | "alltheores:recipes/misc/raw_uranium_from_block" | "farmersdelight:recipes/misc/gold_nugget_from_smelting_knife" | "awesomedungeonocean:ocean_ruin_vanilla_temple/find_during_rain" | "farmersdelight:recipes/food/cooked_salmon_slice" | "minecraft:recipes/transportation/bamboo_chest_raft" | "minecraft:recipes/decorations/cyan_banner" | "supplementaries:recipes/candle_holders/candle_holder_purple" | "minecraft:recipes/decorations/red_banner" | "caveopolis:recipes/redstone/purple_colored_wooden_plank_fence_gate" | "minecraft:recipes/building_blocks/raw_gold_block" | "minecraft:recipes/building_blocks/dye_red_wool" | "minecraft:recipes/combat/iron_boots" | "minecraft:recipes/building_blocks/birch_planks" | "aquamirae:adventure/obtain_esca" | "caveopolis:recipes/misc/brown_colored_wooden_plank_fence_gate_from_brown_colored_wooden_planks_stonecutting" | "supplementaries:recipes/flags/flag_pink" | "caveopolis:recipes/misc/white_colored_stone_wall_from_white_colored_stone_stonecutting" | "alltheores:recipes/misc/invar_plate" | "alltheores:recipes/misc/gold_gear" | "caveopolis:recipes/misc/purple_colored_cobblestone_brick_slab" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_blackstone_stonecutting" | "minecraft:recipes/misc/gold_ingot_from_blasting_deepslate_gold_ore" | "minecraft:recipes/redstone/spruce_pressure_plate" | "minecraft:recipes/building_blocks/granite_stairs_from_granite_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_stairs_from_prismarine_stonecutting" | "caveopolis:recipes/building_blocks/cobblestone_brick_stairs" | "minecraft:recipes/misc/gold_ingot_from_blasting_gold_ore" | "caveopolis:recipes/misc/lime_colored_wooden_plank_button_from_lime_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/magenta_glazed_terracotta" | "caveopolis:recipes/redstone/brown_colored_wooden_plank_button" | "alltheores:recipes/misc/raw_uranium_block" | "supplementaries:recipes/sign_post_oak" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_polished_granite_stonecutting" | "alltheores:recipes/misc/iridium_ingot_from_raw_blasting" | "sophisticatedbackpacks:recipes/misc/refill_upgrade" | "minecraft:recipes/building_blocks/mud_brick_stairs" | "minecraft:recipes/building_blocks/dye_blue_carpet" | "caveopolis:recipes/misc/black_colored_wooden_plank_stairs_from_black_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/orange_colored_cobblestone_wall_from_orange_colored_cobblestone_stonecutting" | "alltheores:recipes/misc/silver_ingot_from_raw" | "aquamirae:adventure/consume_poseidons_breakfast" | "minecraft:recipes/building_blocks/dye_light_gray_wool" | "minecraft:recipes/decorations/magenta_banner" | "caveopolis:recipes/misc/green_colored_sign_from_green_colored_wooden_planks_stonecutting" | "minecraft:recipes/tools/stone_pickaxe" | "oceansdelight:recipes/oceansdelight/seagrass_salad" | "awesomedungeonocean:ocean_ruin_vanilla_temple/find_during_night" | "minecraft:recipes/decorations/deepslate_brick_wall" | "smallships:recipes/misc/sail" | "caveopolis:recipes/misc/light_gray_colored_cobblestone_slab_from_light_gray_colored_cobblestone_stonecutting" | "minecraft:recipes/misc/black_dye" | "caveopolis:recipes/misc/red_colored_cobblestone_brick_slab" | "minecraft:recipes/building_blocks/light_gray_stained_glass" | "minecraft:recipes/food/honey_bottle" | "minecraft:recipes/spruce_sapling" | "caveopolis:recipes/building_blocks/black_colored_stone_brick_stairs" | "minecraft:recipes/misc/light_gray_dye_from_gray_white_dye" | "minecraft:recipes/decorations/acacia_sign" | "alltheores:recipes/misc/platinum_ingot_from_ore_blasting" | "minecraft:recipes/building_blocks/brick_slab" | "minecraft:recipes/lily_pad" | "minecraft:recipes/misc/iron_ingot_from_smelting_iron_ore" | "minecraft:recipes/decorations/lantern" | "caveopolis:recipes/redstone/green_colored_wooden_plank_button" | "minecraft:recipes/decorations/cherry_sign" | "caveopolis:recipes/redstone/magenta_colored_wooden_plank_button" | "farmersdelight:recipes/food/beef_patty" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_tier_1_from_starter" | "sophisticatedbackpacks:recipes/misc/stonecutter_upgrade" | "duckling:breed_duck" | "minecraft:recipes/building_blocks/cobbled_deepslate_slab_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/orange_dye_from_red_yellow" | "industrialforegoing:recipes/misc/laser_lens_green_recolor" | "strainers:recipes/misc/mulch" | "awesomedungeonocean:ocean_quad/find_during_night" | "minecraft:adventure/fall_from_world_height" | "caveopolis:recipes/building_blocks/gray_colored_cobblestone_stairs" | "minecraft:recipes/misc/gold_ingot_from_blasting_nether_gold_ore" | "minecraft:recipes/building_blocks/dye_orange_bed" | "alltheores:recipes/misc/platinum_rod" | "minecraft:recipes/food/rabbit_stew_from_brown_mushroom" | "minecraft:recipes/building_blocks/magenta_concrete_powder" | "minecraft:recipes/decorations/blue_bed" | "caveopolis:recipes/building_blocks/red_colored_cobblestone_bricks" | "minecraft:recipes/decorations/green_bed" | "supplementaries:recipes/flax_block" | "caveopolis:recipes/misc/purple_colored_stone_wall_from_purple_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/cut_sandstone_from_sandstone_stonecutting" | "awesomedungeonocean:ocean_cage/find_during_night" | "minecraft:recipes/decorations/campfire" | "supplementaries:recipes/building_blocks/cozy_home/sign_post_birch" | "caveopolis:recipes/building_blocks/black_colored_stone_stairs" | "minecraft:recipes/decorations/lime_stained_glass_pane" | "minecraft:recipes/misc/snout_armor_trim_smithing_template" | "supplementaries:recipes/sign_post_jungle" | "minecraft:recipes/transportation/hopper_minecart" | "supplementaries:recipes/timber_frame" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_cobbled_deepslate_stonecutting" | "caveopolis:recipes/misc/orange_colored_stone_wall_from_orange_colored_stone_stonecutting" | "farmersdelight:recipes/cooking/dumplings" | "supplementaries:recipes/soap/piston" | "farmersdelight:recipes/food/sweet_berry_cheesecake_from_slices" | "aquaculture:recipes/tools/wooden_fillet_knife" | "sophisticatedbackpacks:recipes/misc/chipped/botanist_workbench_upgrade" | "minecraft:recipes/building_blocks/terracotta" | "minecraft:recipes/misc/red_dye_from_beetroot" | "storagedrawers:recipes/storagedrawers/warped_drawers" | "minecraft:recipes/brain_coral" | "supplementaries:recipes/stonecutting/checker_slab" | "alltheores:recipes/misc/iron_plate" | "farmersdelight:main/get_ham" | "alltheores:recipes/misc/silver_nugget_from_ingot" | "minecraft:recipes/redstone/jungle_trapdoor" | "minecraft:recipes/tools/wooden_hoe" | "sophisticatedbackpacks:recipes/misc/pickup_upgrade" | "farmersdelight:recipes/decorations/light_blue_canvas_sign" | "farmersdelight:recipes/decorations/orange_canvas_sign" | "minecraft:recipes/building_blocks/chiseled_sandstone_from_sandstone_stonecutting" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_polished_deepslate_stonecutting" | "caveopolis:recipes/building_blocks/purple_colored_wooden_planks" | "minecraft:recipes/decorations/granite_wall" | "caveopolis:recipes/misc/yellow_colored_cobblestone_brick_slab_from_yellow_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/carrot" | "awesomedungeonocean:ocean_cage/find_during_rain" | "supplementaries:recipes/redstone_illuminator" | "supplementaries:recipes/sign_post_crimson" | "supplementaries:recipes/ash_brick_stairs" | "supplementaries:recipes/building_blocks/cozy_home/sign_post_acacia" | "minecraft:recipes/building_blocks/orange_terracotta" | "nec:recipes/decorations/jungle_chest" | "caveopolis:recipes/misc/light_blue_colored_sign_from_light_blue_colored_wooden_planks_stonecutting" | "minecraft:recipes/misc/silence_armor_trim_smithing_template" | "farmersdelight:recipes/food/cooked_chicken_cuts" | "minecraft:recipes/food/cooked_chicken_from_smoking" | "minecraft:recipes/redstone/oak_fence_gate" | "supplementaries:recipes/candle_holders/candle_holder_red" | "minecraft:husbandry/bred_all_animals" | "caveopolis:recipes/misc/lime_colored_stone_button_from_lime_colored_stone_stonecutting" | "minecraft:recipes/tropical_fish" | "minecraft:recipes/misc/charcoal" | "alltheores:recipes/misc/silver_gear" | "minecraft:recipes/building_blocks/stone_brick_slab" | "igleelib:recipes/igleelib/modium_block" | "minecraft:recipes/redstone/cherry_pressure_plate" | "minecraft:recipes/redstone/warped_pressure_plate" | "caveopolis:recipes/misc/green_colored_stone_slab" | "minecraft:recipes/building_blocks/polished_granite_slab_from_granite_stonecutting" | "caveopolis:recipes/misc/orange_colored_wooden_plank_crafting_table" | "aquaculture:recipes/aquaculture/neptunes_bounty" | "minecraft:recipes/building_blocks/polished_andesite_from_andesite_stonecutting" | "minecraft:recipes/tools/iron_shovel" | "supplementaries:recipes/bubble_blower" | "sophisticatedbackpacks:recipes/misc/jukebox_upgrade" | "caveopolis:recipes/misc/magenta_colored_wooden_plank_slab" | "minecraft:recipes/food/cooked_salmon_from_campfire_cooking" | "alltheores:recipes/misc/osmium_dust_from_hammer_ingot_crushing" | "oceansdelight:recipes/cooked_stuffed_cod_from_smoking" | "caveopolis:recipes/misc/yellow_colored_cobblestone_slab_from_yellow_colored_cobblestone_stonecutting" | "farmersdelight:recipes/food/cooked_mutton_chops_from_campfire_cooking" | "minecraft:recipes/decorations/item_frame" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab" | "farmersdelight:recipes/decorations/gray_hanging_canvas_sign" | "minecraft:recipes/building_blocks/cut_copper_slab" | "farmersdelight:recipes/food/rice_roll_medley_block" | "minecraft:recipes/prismarine_crystals" | "caveopolis:recipes/misc/white_colored_cobblestone_slab" | "farmersdelight:recipes/food/cake_from_slices" | "caveopolis:recipes/decorations/orange_colored_sign" | "caveopolis:recipes/redstone/lime_colored_wooden_plank_trapdoor" | "caveopolis:recipes/misc/light_blue_spray_can" | "minecraft:recipes/redstone/bamboo_pressure_plate" | "alltheores:recipes/misc/raw_iridium_block" | "caveopolis:recipes/misc/orange_colored_stone_slab" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab" | "farmersdelight:recipes/cooking/pasta_with_meatballs" | "caveopolis:recipes/misc/light_blue_colored_stone_wall_from_light_blue_colored_stone_stonecutting" | "minecraft:recipes/misc/coast_armor_trim_smithing_template" | "minecraft:recipes/misc/ward_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/combat/diamond_helmet" | "caveopolis:recipes/misc/black_colored_stone_pressure_plate_from_black_colored_stone_stonecutting" | "storagedrawers:recipes/storagedrawers/concealment_key" | "aquaculture:recipes/misc/neptinium_ingot_from_blasting" | "farmersdelight:recipes/decorations/full_tatami_mat_from_halves" | "alltheores:recipes/misc/enderium_nugget_from_ingot" | "supplementaries:recipes/candle_holders/candle_holder_gray_dye" | "minecraft:adventure/walk_on_powder_snow_with_leather_boots" | "minecraft:recipes/kelp" | "caveopolis:recipes/misc/gray_colored_stone_wall_from_gray_colored_stone_stonecutting" | "supplementaries:recipes/candle_holders/candle_holder_light_gray_dye" | "caveopolis:recipes/misc/yellow_colored_cobblestone_bricks_from_black_colored_cobblestone_stonecutting" | "supplementaries:recipes/candle_holders/candle_holder_yellow_dye" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template" | "alltheores:recipes/misc/invar_nugget_from_ingot" | "alltheores:recipes/misc/peridot_dust_from_hammer_crushing" | "minecraft:recipes/building_blocks/chiseled_nether_bricks_from_nether_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_pump_upgrade" | "caveopolis:recipes/misc/blue_colored_cobblestone_slab" | "alltheores:recipes/misc/copper_dust_from_hammer_crushing" | "supplementaries:recipes/soap_block_uncrafting" | "minecraft:recipes/sponge" | "aquamirae:adventure/three_bolt_armor" | "minecraft:recipes/soul_soil" | "caveopolis:recipes/redstone/white_colored_wooden_plank_trapdoor" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_from_stone_bricks_stonecutting" | "farmersdelight:recipes/decorations/crimson_cabinet" | "storagedrawers:recipes/storagedrawers/upgrade_template" | "minecraft:recipes/basalt" | "caveopolis:recipes/building_blocks/cyan_colored_wooden_plank_stairs" | "minecraft:recipes/decorations/pink_bed" | "minecraft:recipes/wither_skeleton_skull" | "minecraft:recipes/misc/coal_from_blasting_deepslate_coal_ore" | "caveopolis:recipes/building_blocks/brown_colored_stone" | "caveopolis:recipes/building_blocks/magenta_colored_wooden_plank_stairs" | "supplementaries:recipes/slingshot" | "supplementaries:recipes/timber_brace" | "farmersdelight:recipes/decorations/hanging_canvas_sign" | "supplementaries:recipes/stonecutting/lapis_brick_stairs_from_bricks" | "minecraft:recipes/building_blocks/cyan_stained_glass" | "caveopolis:recipes/decorations/gray_colored_hanging_sign" | "minecraft:recipes/tools/netherite_axe_smithing" | "caveopolis:recipes/decorations/white_colored_sign" | "minecraft:recipes/decorations/jungle_sign" | "minecraft:recipes/building_blocks/andesite" | "minecraft:recipes/building_blocks/cut_sandstone_slab_from_sandstone_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_from_exposed_copper_stonecutting" | "alltheores:recipes/misc/platinum_nugget_from_ingot" | "caveopolis:recipes/misc/white_colored_cobblestone_brick_slab_from_white_colored_cobblestone_bricks_stonecutting" | "caveopolis:recipes/misc/lime_colored_stone_wall_from_lime_colored_stone_stonecutting" | "caveopolis:recipes/building_blocks/black_colored_cobblestone_stairs" | "caveopolis:recipes/misc/light_gray_colored_stone_brick_stairs_from_light_gray_colored_stone_bricks_stonecutting" | "alltheores:recipes/misc/platinum_ingot_from_raw_blasting" | "caveopolis:recipes/redstone/pink_colored_wooden_plank_pressure_plate" | "minecraft:recipes/building_blocks/blackstone_slab" | "caveopolis:recipes/misc/yellow_colored_stone_brick_stairs_from_yellow_colored_stone_bricks_stonecutting" | "minecraft:husbandry/feed_snifflet" | "minecraft:recipes/building_blocks/sandstone_slab_from_sandstone_stonecutting" | "caveopolis:recipes/misc/light_blue_colored_stone_brick_stairs_from_light_blue_colored_stone_bricks_stonecutting" | "minecraft:story/form_obsidian" | "caveopolis:recipes/redstone/magenta_colored_wooden_plank_trapdoor" | "minecraft:recipes/misc/netherite_ingot_from_netherite_block" | "minecraft:end/enter_end_gateway" | "alltheores:recipes/misc/nickel_block" | "caveopolis:recipes/building_blocks/brown_colored_cobblestone_stairs" | "minecraft:recipes/building_blocks/bamboo_slab" | "supplementaries:recipes/stonecutting/ash_brick_stairs_from_bricks" | "minecraft:recipes/building_blocks/polished_blackstone_slab_from_polished_blackstone_stonecutting" | "supplementaries:recipes/candy" | "aquaculture:recipes/decorations/dark_oak_fish_mount" | "alltheores:recipes/misc/platinum_ingot_from_ore" | "alltheores:recipes/misc/silver_ingot_from_slate_ore_blasting" | "caveopolis:recipes/misc/brown_colored_stone_stairs_from_brown_colored_stone_stonecutting" | "minecraft:nether/loot_bastion" | "caveopolis:recipes/misc/red_colored_wooden_plank_pressure_plate_from_red_colored_wooden_planks_stonecutting" | "minecraft:recipes/redstone/oak_door" | "minecraft:recipes/building_blocks/dye_yellow_carpet" | "storagedrawers:recipes/storagedrawers/drawer_key" | "alltheores:recipes/misc/iron_rod" | "caveopolis:recipes/misc/cyan_colored_stone_wall_from_cyan_colored_stone_stonecutting" | "caveopolis:recipes/misc/white_colored_wooden_plank_crafting_table" | "minecraft:recipes/misc/iron_ingot_from_iron_block" | "caveopolis:recipes/misc/cyan_colored_stone_brick_wall_from_cyan_colored_stone_bricks_stonecutting" | "minecraft:recipes/redstone/jungle_door" | "caveopolis:recipes/decorations/gray_colored_wooden_plank_fence" | "alltheores:recipes/misc/electrum_nugget_from_ingot" | "caveopolis:recipes/building_blocks/light_gray_colored_stone_brick_stairs" | "caveopolis:recipes/decorations/cyan_colored_sign" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_stonecutting" | "caveopolis:recipes/misc/light_blue_colored_stone_wall" | "aquamirae:adventure/terrible_armor" | "caveopolis:recipes/misc/red_colored_wooden_plank_stairs_from_red_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_blackstone_stonecutting" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade" | "caveopolis:recipes/misc/light_gray_colored_cobblestone_brick_wall" | "minecraft:recipes/netherrack" | "supplementaries:recipes/turn_table" | "awesomedungeonocean:ocean_ruin_pillager/find_during_storm" | "caveopolis:recipes/building_blocks/purple_colored_cobblestone_brick_stairs" | "minecraft:recipes/decorations/light_gray_candle" | "minecraft:recipes/building_blocks/melon" | "minecraft:recipes/brain_coral_block" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "farmersdelight:recipes/decorations/canvas_rug" | "caveopolis:recipes/misc/blue_colored_wooden_plank_slab" | "alltheores:recipes/misc/zinc_ingot_from_block" | "caveopolis:recipes/redstone/blue_colored_wooden_plank_door" | "minecraft:recipes/building_blocks/polished_andesite_slab" | "alltheores:recipes/misc/tin_ingot_from_raw" | "alltheores:recipes/misc/platinum_ore_hammer" | "minecraft:recipes/cornflower" | "caveopolis:recipes/building_blocks/white_colored_stone_stairs" | "minecraft:recipes/decorations/yellow_stained_glass_pane_from_glass_pane" | "caveopolis:recipes/misc/blue_colored_stone_bricks_from_blue_colored_stone_stonecutting" | "alltheores:recipes/misc/iridium_ingot_from_raw" | "caveopolis:recipes/misc/white_colored_stone_slab_from_white_colored_stone_stonecutting" | "farmersdelight:recipes/decorations/lime_hanging_canvas_sign" | "caveopolis:recipes/misc/blue_colored_stone_stairs_from_blue_colored_stone_stonecutting" | "minecraft:recipes/combat/golden_sword" | "caveopolis:recipes/misc/light_blue_colored_stone_brick_slab" | "minecraft:end/elytra" | "caveopolis:recipes/building_blocks/red_colored_stone" | "caveopolis:recipes/misc/gray_colored_wooden_plank_crafting_table" | "minecraft:recipes/decorations/mangrove_sign" | "minecraft:recipes/nautilus_shell" | "minecraft:recipes/tools/wooden_shovel" | "farmersdelight:recipes/decorations/birch_cabinet" | "caveopolis:recipes/misc/white_colored_stone_brick_slab" | "supplementaries:husbandry/wrench" | "minecraft:recipes/decorations/bamboo_mosaic" | "minecraft:recipes/building_blocks/purpur_stairs" | "industrialforegoing:recipes/misc/plastic" | "alltheores:recipes/misc/aluminum_ingot_from_raw_blasting" | "minecraft:recipes/redstone/redstone_lamp" | "smallships:recipes/transportation/acacia_galley" | "minecraft:recipes/building_blocks/mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "caveopolis:recipes/misc/cyan_colored_cobblestone_slab" | "caveopolis:recipes/misc/green_colored_wooden_plank_door_from_green_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/crimson_fence" | "minecraft:recipes/redstone/dispenser" | "alltheores:recipes/misc/brass_ingot" | "caveopolis:recipes/misc/white_colored_wooden_plank_button_from_white_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/purpur_pillar_from_purpur_block_stonecutting" | "caveopolis:recipes/redstone/blue_colored_wooden_plank_trapdoor" | "suppsquared:recipes/decorations/item_shelf_acacia" | "minecraft:recipes/building_blocks/cobblestone_slab" | "caveopolis:recipes/misc/blue_colored_stone_pressure_plate_from_blue_colored_stone_stonecutting" | "farmersdelight:recipes/food/beetroot_from_crate" | "minecraft:recipes/building_blocks/stripped_crimson_hyphae" | "caveopolis:recipes/redstone/light_gray_colored_wooden_plank_trapdoor" | "minecraft:recipes/building_blocks/magenta_terracotta" | "alltheores:recipes/misc/aluminum_nugget_from_ingot" | "minecraft:recipes/misc/brick" | "caveopolis:recipes/misc/black_colored_stone_wall" | "alltheores:recipes/misc/constantan_plate" | "caveopolis:recipes/misc/lime_colored_stone_brick_stairs_from_lime_colored_stone_bricks_stonecutting" | "caveopolis:recipes/misc/red_colored_stone_stairs_from_red_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/gold_block" | "caveopolis:recipes/misc/gray_spray_can" | "minecraft:recipes/building_blocks/exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "caveopolis:recipes/misc/purple_colored_cobblestone_brick_wall_from_purple_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/misc/yellow_dye_from_sunflower" | "storagedrawers:recipes/storagedrawers/oak_drawers" | "minecraft:recipes/brewing/cauldron" | "supplementaries:recipes/candle_holders/candle_holder_cyan_dye" | "caveopolis:recipes/redstone/white_colored_wooden_plank_pressure_plate" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab" | "minecraft:recipes/decorations/armor_stand" | "storagedrawers:recipes/storagedrawers/min_redstone_upgrade" | "minecraft:recipes/transportation/acacia_boat" | "minecraft:recipes/redstone/iron_trapdoor" | "alltheores:recipes/misc/enderium_ingot_from_dust" | "alltheores:recipes/misc/nickel_gear" | "minecraft:adventure/root" | "caveopolis:recipes/misc/gray_colored_wooden_plank_fence_from_gray_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/end_stone_brick_stairs" | "caveopolis:recipes/misc/orange_colored_wooden_plank_slab_from_orange_colored_wooden_planks_stonecutting" | "aquaculture:recipes/decorations/acacia_fish_mount" | "awesomedungeonocean:ocean_ruin_vanilla_temple/find_normal" | "minecraft:recipes/decorations/jungle_fence" | "minecraft:recipes/misc/tide_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/decorations/mud_brick_wall_from_mud_bricks_stonecutting" | "minecraft:recipes/building_blocks/chiseled_quartz_block_from_quartz_block_stonecutting" | "minecraft:recipes/misc/ender_eye" | "caveopolis:recipes/misc/yellow_colored_sign_from_yellow_colored_wooden_planks_stonecutting" | "minecraft:recipes/redstone/redstone_block" | "caveopolis:recipes/building_blocks/cyan_colored_wooden_planks" | "caveopolis:recipes/misc/light_gray_colored_wooden_plank_door_from_light_gray_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/blue_colored_stone_wall_from_blue_colored_stone_stonecutting" | "supplementaries:recipes/clock_block" | "caveopolis:recipes/decorations/brown_colored_wooden_plank_fence" | "caveopolis:recipes/misc/light_blue_colored_stone_crafting_table" | "minecraft:recipes/decorations/dark_oak_hanging_sign" | "caveopolis:recipes/building_blocks/cyan_colored_stone_bricks" | "minecraft:recipes/bubble_coral" | "minecraft:recipes/building_blocks/cyan_terracotta" | "minecraft:recipes/decorations/nether_brick_wall_from_nether_bricks_stonecutting" | "caveopolis:recipes/misc/lime_colored_cobblestone_bricks_from_lime_colored_cobblestone_stonecutting" | "minecraft:recipes/decorations/red_stained_glass_pane_from_glass_pane" | "alltheores:recipes/misc/aluminum_block" | "minecraft:story/follow_ender_eye" | "supplementaries:recipes/flags/flag_black" | "caveopolis:recipes/misc/marble_slab_from_marble_stonecutting" | "minecraft:recipes/building_blocks/weathered_cut_copper_from_weathered_copper_stonecutting" | "chipped:recipes/glassblower" | "caveopolis:recipes/misc/bright_shard_from_blasting_bright_stone_ore" | "caveopolis:recipes/redstone/light_gray_colored_wooden_plank_door" | "alltheores:recipes/misc/enderium_ingot_from_dust_blasting" | "caveopolis:recipes/misc/light_gray_colored_cobblestone_brick_wall_from_light_gray_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/plenty_pottery_sherd" | "minecraft:recipes/decorations/deepslate_tile_wall_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_blasting_raw_iron" | "minecraft:recipes/misc/blue_dye_from_cornflower" | "minecraft:recipes/redstone/slime_block" | "caveopolis:recipes/misc/stone_stick" | "caveopolis:recipes/misc/light_blue_colored_stone_brick_slab_from_light_blue_colored_stone_bricks_stonecutting" | "minecraft:recipes/decorations/bamboo_hanging_sign" | "minecraft:recipes/shulker_shell" | "caveopolis:recipes/misc/spray_can_remover" | "minecraft:recipes/building_blocks/acacia_wood" | "sophisticatedbackpacks:recipes/misc/pump_upgrade" | "caveopolis:recipes/building_blocks/white_colored_wooden_plank_stairs" | "minecraft:recipes/decorations/polished_blackstone_brick_wall" | "alltheores:recipes/misc/invar_gear" | "caveopolis:recipes/redstone/cyan_colored_stone_pressure_plate" | "minecraft:recipes/combat/wooden_sword" | "minecraft:recipes/decorations/gray_banner" | "minecraft:recipes/building_blocks/oak_planks" | "minecraft:recipes/decorations/light_blue_carpet" | "alltheores:recipes/misc/tin_ingot_from_block" | "minecraft:recipes/building_blocks/dye_blue_bed" | "caveopolis:recipes/misc/orange_colored_sign_from_orange_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/quartz_slab_from_stonecutting" | "aquaculture:recipes/aquaculture/diamond_hook" | "minecraft:recipes/building_blocks/black_concrete_powder" | "caveopolis:recipes/misc/pink_colored_stone_bricks_from_pink_colored_stone_stonecutting" | "farmersdelight:recipes/building_blocks/tatami_block_from_full" | "caveopolis:recipes/building_blocks/white_colored_stone_bricks" | "caveopolis:recipes/misc/pink_colored_cobblestone_wall" | "supplementaries:recipes/item_shelf" | "caveopolis:recipes/misc/pink_colored_cobblestone_brick_wall_from_pink_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/combat/crossbow" | "farmersdelight:recipes/food/shepherds_pie_block" | "minecraft:recipes/building_blocks/mud_bricks" | "minecraft:recipes/food/cooked_porkchop_from_smoking" | "supplementaries:recipes/decorations/sign_post_mangrove" | "minecraft:recipes/building_blocks/cracked_deepslate_bricks" | "caveopolis:recipes/building_blocks/white_colored_wood" | "caveopolis:recipes/misc/brown_colored_cobblestone_brick_wall_from_brown_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/building_blocks/chiseled_nether_bricks" | "minecraft:recipes/building_blocks/warped_planks" | "alltheores:recipes/misc/lead_ingot_from_raw_blasting" | "caveopolis:recipes/misc/magenta_colored_stone_wall" | "alltheores:recipes/misc/silver_dust_from_hammer_ingot_crushing" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab" | "minecraft:recipes/decorations/warped_fence" | "aquaculture:recipes/food/sushi" | "caveopolis:recipes/decorations/cyan_colored_hanging_sign" | "minecraft:recipes/decorations/black_glazed_terracotta" | "caveopolis:recipes/redstone/black_colored_wooden_plank_pressure_plate" | "minecraft:recipes/slime_ball" | "supplementaries:recipes/present" | "caveopolis:recipes/misc/yellow_colored_wooden_plank_slab" | "caveopolis:recipes/misc/gray_colored_cobblestone_wall" | "alltheores:recipes/misc/peridot_block" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs" | "farmersdelight:recipes/decorations/green_canvas_sign" | "alltheores:recipes/misc/gold_ingot_from_dust_blasting" | "farmersdelight:recipes/cooking/beetroot_soup" | "minecraft:recipes/misc/gray_dye" | "supplementaries:recipes/feather_block_uncrafting" | "caveopolis:recipes/misc/brown_colored_hanging_sign_from_stripped_brown_colored_log_stonecutting" | "minecraft:recipes/redstone/bamboo_button" | "minecraft:recipes/decorations/light_gray_carpet" | "minecraft:recipes/howl_pottery_sherd" | "minecraft:recipes/decorations/barrel" | "caveopolis:recipes/misc/mixed_stone_nugget" | "minecraft:recipes/misc/rib_armor_trim_smithing_template" | "minecraft:recipes/shelter_pottery_sherd" | "minecraft:recipes/combat/leather_boots" | "supplementaries:recipes/flags/flag_green" | "minecraft:recipes/misc/red_dye_from_tulip" | "caveopolis:recipes/misc/cyan_colored_cobblestone_slab_from_cyan_colored_cobblestone_stonecutting" | "minecraft:husbandry/axolotl_in_a_bucket" | "minecraft:recipes/decorations/cobblestone_wall_from_cobblestone_stonecutting" | "caveopolis:recipes/misc/purple_colored_stone_slab" | "caveopolis:recipes/misc/purple_colored_sign_from_purple_colored_wooden_planks_stonecutting" | "minecraft:recipes/misc/orange_dye_from_orange_tulip" | "minecraft:recipes/decorations/grindstone" | "farmersdelight:recipes/food/sweet_berry_cookie" | "sophisticatedbackpacks:recipes/misc/anvil_upgrade" | "minecraft:recipes/building_blocks/diamond_block" | "caveopolis:recipes/misc/light_blue_colored_cobblestone_stairs_from_light_blue_colored_cobblestone_stonecutting" | "caveopolis:recipes/building_blocks/purple_colored_stone_bricks" | "caveopolis:recipes/misc/pink_colored_stone_wall" | "caveopolis:recipes/misc/brown_colored_cobblestone_brick_slab" | "minecraft:recipes/decorations/yellow_carpet" | "caveopolis:recipes/misc/yellow_colored_cobblestone_brick_wall_from_yellow_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/building_blocks/stripped_oak_wood" | "caveopolis:recipes/misc/green_colored_hanging_sign_from_stripped_green_colored_log_stonecutting" | "caveopolis:recipes/misc/brown_colored_wooden_plank_stairs_from_brown_colored_wooden_planks_stonecutting" | "farmersdelight:main/craft_knife" | "caveopolis:recipes/misc/pink_colored_stone_crafting_table" | "minecraft:nether/ride_strider_in_overworld_lava" | "farmersdelight:recipes/decorations/cyan_canvas_sign" | "industrialforegoing:recipes/misc/laser_lens_white_recolor" | "caveopolis:recipes/redstone/white_colored_wooden_plank_fence_gate" | "caveopolis:recipes/building_blocks/pink_colored_stone" | "caveopolis:recipes/misc/green_colored_stone_pressure_plate_from_green_colored_stone_stonecutting" | "caveopolis:recipes/misc/brown_spray_can" | "minecraft:recipes/decorations/blue_banner" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_polished_deepslate_stonecutting" | "alltheores:recipes/misc/iridium_ingot" | "supplementaries:recipes/building_blocks/cozy_home/sign_post_dark_oak" | "caveopolis:recipes/building_blocks/red_colored_cobblestone_brick_stairs" | "caveopolis:recipes/misc/pink_colored_stone_brick_stairs_from_pink_colored_stone_bricks_stonecutting" | "alltheores:recipes/misc/signalum_gear" | "supplementaries:recipes/stonecutting/blackstone_tile_wall_from_bricks" | "caveopolis:recipes/misc/purple_colored_stone_brick_slab_from_purple_colored_stone_bricks_stonecutting" | "caveopolis:recipes/misc/purple_colored_stone_brick_stairs_from_purple_colored_stone_bricks_stonecutting" | "caveopolis:recipes/misc/blue_colored_cobblestone_brick_wall" | "minecraft:recipes/building_blocks/dark_prismarine_slab_from_dark_prismarine_stonecutting" | "minecraft:recipes/building_blocks/polished_andesite_stairs_from_andesite_stonecutting" | "minecraft:recipes/decorations/lime_banner" | "minecraft:recipes/decorations/white_bed" | "caveopolis:recipes/redstone/brown_colored_wooden_plank_pressure_plate" | "awesomedungeonocean:ocean_temple_quad/find_during_night" | "minecraft:recipes/decorations/deepslate_brick_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/misc/lapis_lazuli_from_blasting_deepslate_lapis_ore" | "minecraft:recipes/decorations/nether_brick_wall" | "minecraft:recipes/misc/ward_armor_trim_smithing_template" | "caveopolis:recipes/redstone/lime_colored_stone_button" | "minecraft:recipes/misc/copper_ingot_from_smelting_deepslate_copper_ore" | "farmersdelight:recipes/food/potato_from_crate" | "alltheores:recipes/misc/diamond_gear" | "minecraft:recipes/misc/firework_rocket_simple" | "minecraft:recipes/misc/gold_ingot_from_smelting_deepslate_gold_ore" | "minecraft:nether/summon_wither" | "supplementaries:recipes/stone_tile" | "minecraft:recipes/redstone/redstone_from_blasting_deepslate_redstone_ore" | "caveopolis:recipes/misc/lime_colored_stone_brick_wall" | "smallships:recipes/transportation/jungle_galley" | "caveopolis:recipes/building_blocks/magenta_colored_cobblestone" | "minecraft:recipes/building_blocks/red_nether_brick_slab" | "minecraft:recipes/building_blocks/cobblestone_stairs" | "aquaculture:recipes/tools/gold_fillet_knife" | "minecraft:recipes/misc/copper_ingot_from_blasting_copper_ore" | "minecraft:recipes/building_blocks/dye_green_carpet" | "caveopolis:recipes/misc/light_blue_colored_stone_slab_from_light_blue_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting" | "minecraft:recipes/ice" | "smallships:recipes/transportation/dark_oak_galley" | "caveopolis:recipes/misc/pink_colored_stone_brick_wall" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_diorite_stonecutting" | "minecraft:recipes/decorations/pink_banner" | "farmersdelight:recipes/food/pie_crust" | "farmersdelight:recipes/combat/iron_knife" | "caveopolis:recipes/building_blocks/black_colored_cobblestone_bricks" | "minecraft:recipes/building_blocks/prismarine_brick_slab" | "chipped:recipes/loom_table" | "caveopolis:recipes/decorations/blue_colored_sign" | "minecraft:recipes/building_blocks/waxed_exposed_copper_from_honeycomb" | "caveopolis:recipes/decorations/magenta_colored_sign" | "minecraft:recipes/misc/magenta_dye_from_blue_red_white_dye" | "caveopolis:recipes/misc/red_colored_stone_brick_wall" | "smallships:recipes/transportation/bamboo_brigg" | "minecraft:recipes/building_blocks/purple_concrete_powder" | "alltheores:recipes/misc/uranium_nugget_from_ingot" | "aquaculture:recipes/aquaculture/light_hook" | "minecraft:recipes/building_blocks/prismarine_slab" | "minecraft:recipes/decorations/orange_carpet" | "caveopolis:recipes/misc/black_colored_stone_brick_wall_from_black_colored_stone_bricks_stonecutting" | "duckling:pet_duck" | "alltheores:recipes/misc/uranium_ingot_from_raw_blasting" | "minecraft:adventure/read_power_of_chiseled_bookshelf" | "supplementaries:recipes/candle_holders/candle_holder_magenta" | "minecraft:recipes/redstone/cherry_door" | "minecraft:recipes/horn_coral" | "caveopolis:recipes/misc/white_colored_hanging_sign_from_stripped_white_colored_log_stonecutting" | "caveopolis:recipes/misc/white_colored_cobblestone_brick_stairs_from_white_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/building_blocks/cut_copper_stairs" | "caveopolis:recipes/misc/cyan_colored_stone_brick_slab" | "minecraft:recipes/decorations/warped_hanging_sign" | "alltheores:recipes/misc/osmium_plate" | "caveopolis:recipes/misc/black_colored_cobblestone_brick_wall_from_black_colored_cobblestone_bricks_stonecutting" | "caveopolis:recipes/misc/light_blue_colored_cobblestone_slab" | "caveopolis:recipes/building_blocks/pink_colored_stone_stairs" | "aquaculture:recipes/misc/red_mushroom_from_fish" | "supplementaries:recipes/safe" | "caveopolis:recipes/misc/green_colored_wooden_plank_fence_gate_from_green_colored_wooden_planks_stonecutting" | "farmersdelight:recipes/decorations/rope" | "caveopolis:recipes/misc/green_colored_cobblestone_brick_wall_from_green_colored_cobblestone_bricks_stonecutting" | "caveopolis:recipes/misc/magenta_colored_cobblestone_bricks_from_magenta_colored_cobblestone_stonecutting" | "caveopolis:recipes/misc/magenta_colored_stone_bricks_from_magenta_colored_stone_stonecutting" | "caveopolis:recipes/misc/cyan_colored_hanging_sign_from_stripped_cyan_colored_log_stonecutting" | "alltheores:recipes/misc/signalum_ingot" | "igleelib:recipes/igleelib/lavium_ingot" | "minecraft:recipes/combat/spectral_arrow" | "caveopolis:recipes/building_blocks/black_colored_stone_bricks" | "minecraft:recipes/decorations/white_stained_glass_pane" | "caveopolis:recipes/building_blocks/lime_colored_cobblestone_stairs" | "aquaculture:recipes/building_blocks/planks_from_driftwood" | "alltheores:recipes/misc/lead_ingot" | "caveopolis:recipes/redstone/red_colored_wooden_plank_button" | "supplementaries:recipes/sack" | "caveopolis:recipes/building_blocks/orange_colored_cobblestone" | "caveopolis:recipes/decorations/lime_colored_wooden_plank_fence" | "caveopolis:recipes/misc/brown_colored_stone_bricks_from_brown_colored_stone_stonecutting" | "minecraft:recipes/decorations/ender_chest" | "caveopolis:recipes/misc/light_gray_colored_stone_crafting_table" | "minecraft:recipes/decorations/dark_oak_sign" | "caveopolis:recipes/misc/mixed_stone_ingot_from_blasting_mixed_stone_ore" | "supplementaries:recipes/flags/flag_purple" | "caveopolis:recipes/building_blocks/purple_colored_stone_stairs" | "alltheores:recipes/misc/invar_ingot_from_dust" | "caveopolis:recipes/misc/magenta_colored_wooden_plank_crafting_table" | "minecraft:story/mine_diamond" | "minecraft:recipes/building_blocks/cut_copper_stairs_from_cut_copper_stonecutting" | "minecraft:recipes/building_blocks/polished_granite_stairs_from_granite_stonecutting" | "minecraft:recipes/building_blocks/cyan_concrete_powder" | "caveopolis:recipes/misc/lime_colored_cobblestone_brick_slab_from_lime_colored_cobblestone_bricks_stonecutting" | "supplementaries:recipes/stonecutting/stone_tile_wall_from_bricks" | "caveopolis:recipes/misc/lime_spray_can" | "caveopolis:recipes/misc/pink_colored_stone_stairs_from_pink_colored_stone_stonecutting" | "caveopolis:recipes/misc/green_colored_stone_crafting_table" | "minecraft:recipes/misc/pink_dye_from_peony" | "supplementaries:recipes/rope" | "caveopolis:recipes/building_blocks/orange_colored_wood" | "farmersdelight:recipes/food/cake_from_milk_bottle" | "igleelib:recipes/igleelib/derium_ingot" | "sophisticatedbackpacks:recipes/misc/iron_backpack_from_copper" | "alltheores:recipes/misc/raw_iridium_from_block" | "minecraft:recipes/misc/coal_from_smelting_coal_ore" | "minecraft:nether/find_fortress" | "farmersdelight:recipes/building_blocks/organic_compost_from_tree_bark" | "aquamirae:adventure/root" | "minecraft:recipes/building_blocks/polished_blackstone_bricks" | "supplementaries:recipes/stone_lamp" | "smallships:recipes/transportation/spruce_drakkar" | "caveopolis:recipes/misc/red_colored_cobblestone_wall" | "caveopolis:recipes/misc/light_blue_colored_wooden_plank_door_from_light_blue_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/red_sandstone_wall" | "farmersdelight:recipes/food/rice_from_bag" | "minecraft:recipes/misc/nether_brick" | "awesomedungeonocean:ocean_cage/find_normal" | "minecraft:recipes/tools/stone_shovel" | "alltheores:recipes/misc/osmium_ingot_from_ore_blasting" | "supplementaries:recipes/candle_holders/candle_holder_lime_dye" | "farmersdelight:recipes/food/onion" | "caveopolis:recipes/misc/lime_colored_cobblestone_wall" | "caveopolis:recipes/misc/marble_bricks" | "alltheores:recipes/misc/aluminum_ingot_from_slate_ore_blasting" | "caveopolis:recipes/misc/green_colored_cobblestone_stairs_from_green_colored_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/brown_terracotta" | "caveopolis:recipes/redstone/purple_colored_stone_button" | "minecraft:recipes/moss_block" | "alltheores:recipes/misc/invar_ingot" | "caveopolis:recipes/redstone/brown_colored_stone_button" | "minecraft:recipes/building_blocks/polished_deepslate_stairs" | "minecraft:recipes/decorations/shulker_box" | "minecraft:recipes/building_blocks/polished_basalt" | "minecraft:recipes/building_blocks/oak_wood" | "caveopolis:recipes/decorations/magenta_colored_wooden_plank_fence" | "minecraft:recipes/building_blocks/smooth_quartz_stairs" | "minecraft:recipes/misc/slime_ball" | "minecraft:recipes/misc/raiser_armor_trim_smithing_template_smithing_trim" | "caveopolis:recipes/decorations/orange_colored_wooden_plank_fence" | "caveopolis:recipes/misc/gray_colored_stone_brick_wall" | "farmersdelight:recipes/food/cooked_bacon" | "minecraft:recipes/building_blocks/dye_green_wool" | "minecraft:recipes/decorations/cherry_hanging_sign" | "minecraft:recipes/building_blocks/jungle_slab" | "minecraft:recipes/decorations/light_blue_candle" | "caveopolis:recipes/misc/brown_colored_stone_slab" | "caveopolis:recipes/misc/light_blue_colored_wooden_plank_stairs_from_light_blue_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/purple_spray_can" | "caveopolis:recipes/misc/black_colored_stone_slab_from_black_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting" | "caveopolis:recipes/misc/magenta_colored_cobblestone_brick_slab" | "minecraft:recipes/food/cooked_beef" | "minecraft:recipes/heartbreak_pottery_sherd" | "caveopolis:recipes/decorations/magenta_colored_hanging_sign" | "caveopolis:recipes/building_blocks/brown_colored_wooden_planks" | "suppsquared:recipes/decorations/item_shelf_bamboo" | "farmersdelight:recipes/food/cooked_chicken_cuts_from_smoking" | "minecraft:recipes/transportation/powered_rail" | "minecraft:recipes/decorations/red_bed" | "caveopolis:recipes/misc/yellow_colored_wooden_plank_trapdoor_from_yellow_colored_wooden_planks_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_nuggets" | "caveopolis:recipes/misc/purple_colored_wooden_plank_stairs_from_purple_colored_wooden_planks_stonecutting" | "supplementaries:recipes/flags/flag_white" | "caveopolis:recipes/misc/brown_colored_wooden_plank_crafting_table" | "minecraft:recipes/transportation/jungle_boat" | "supplementaries:recipes/hourglass" | "caveopolis:recipes/decorations/purple_colored_wooden_plank_fence" | "minecraft:recipes/redstone/heavy_weighted_pressure_plate" | "alltheores:recipes/misc/platinum_ingot_from_block" | "caveopolis:recipes/misc/black_colored_wooden_plank_crafting_table" | "minecraft:recipes/building_blocks/cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting" | "farmersdelight:main/harvest_ropelogged_tomato" | "minecraft:story/enter_the_end" | "caveopolis:recipes/redstone/orange_colored_wooden_plank_door" | "alltheores:recipes/misc/zinc_dust_from_hammer_crushing" | "minecraft:recipes/transportation/warped_fungus_on_a_stick" | "minecraft:recipes/building_blocks/stripped_jungle_wood" | "nec:recipes/decorations/crimson_chest" | "minecraft:recipes/building_blocks/stone_stairs" | "caveopolis:recipes/misc/light_gray_colored_stone_button_from_light_gray_colored_stone_stonecutting" | "caveopolis:recipes/misc/light_gray_colored_hanging_sign_from_stripped_light_gray_colored_log_stonecutting" | "minecraft:recipes/building_blocks/purpur_slab_from_purpur_block_stonecutting" | "minecraft:recipes/transportation/rail" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_deepslate_bricks_stonecutting" | "framedcompactdrawers:recipes/misc/framed_full_one" | "nec:recipes/decorations/warped_chest" | "alltheores:recipes/misc/lead_ingot_from_raw" | "storagedrawers:recipes/storagedrawers/gold_storage_upgrade" | "caveopolis:recipes/building_blocks/blue_colored_stone_stairs" | "oceansdelight:recipes/cooked_elder_guardian_slice" | "farmersdelight:recipes/decorations/full_tatami_mat" | "caveopolis:recipes/misc/purple_colored_wooden_plank_fence_from_purple_colored_wooden_planks_stonecutting" | "caveopolis:recipes/building_blocks/green_colored_wooden_plank_stairs" | "caveopolis:recipes/misc/purple_colored_stone_bricks_from_purple_colored_stone_stonecutting" | "farmersdelight:recipes/food/horse_feed" | "minecraft:recipes/building_blocks/bone_block" | "sophisticatedbackpacks:recipes/misc/advanced_restock_upgrade" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_honeycomb" | "caveopolis:recipes/building_blocks/cyan_colored_stone_brick_stairs" | "suppsquared:recipes/decorations/item_shelf_warped" | "minecraft:recipes/redstone/lever" | "farmersdelight:recipes/cooking/dog_food" | "minecraft:nether/obtain_crying_obsidian" | "minecraft:recipes/misc/magenta_dye_from_lilac" | "farmersdelight:recipes/food/fried_egg_from_smoking" | "farmersdelight:recipes/food/nether_salad" | "caveopolis:recipes/misc/brown_colored_wooden_plank_slab" | "caveopolis:recipes/building_blocks/light_blue_colored_wood" | "minecraft:recipes/misc/pink_dye_from_pink_petals" | "farmersdelight:recipes/decorations/half_tatami_mat" | "alltheores:recipes/misc/aluminum_ingot_from_block" | "caveopolis:recipes/misc/light_blue_colored_hanging_sign_from_stripped_light_blue_colored_log_stonecutting" | "minecraft:recipes/pink_tulip" | "farmersdelight:main/place_cooking_pot" | "caveopolis:recipes/misc/lime_colored_stone_stairs_from_lime_colored_stone_stonecutting" | "minecraft:husbandry/froglights" | "caveopolis:recipes/building_blocks/yellow_colored_stone" | "caveopolis:recipes/misc/black_colored_stone_bricks_from_black_colored_stone_stonecutting" | "minecraft:recipes/misc/melon_seeds" | "caveopolis:recipes/misc/white_colored_wooden_plank_fence_gate_from_white_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/magma_block" | "farmersdelight:recipes/combat/diamond_knife" | "caveopolis:recipes/misc/light_blue_colored_cobblestone_bricks_from_light_blue_colored_cobblestone_stonecutting" | "alltheores:recipes/misc/osmium_rod" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade" | "farmersdelight:recipes/misc/iron_nugget_from_blasting_knife" | "minecraft:recipes/building_blocks/smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "caveopolis:recipes/decorations/orange_colored_hanging_sign" | "caveopolis:recipes/misc/blue_colored_stone_brick_stairs_from_blue_colored_stone_bricks_stonecutting" | "caveopolis:recipes/misc/purple_colored_wooden_plank_slab" | "caveopolis:recipes/misc/lime_colored_wooden_plank_trapdoor_from_lime_colored_wooden_planks_stonecutting" | "minecraft:recipes/mycelium" | "sophisticatedbackpacks:recipes/misc/advanced_void_upgrade" | "caveopolis:recipes/misc/brown_colored_stone_slab_from_brown_colored_stone_stonecutting" | "caveopolis:recipes/misc/pink_colored_cobblestone_stairs_from_pink_colored_cobblestone_stonecutting" | "caveopolis:recipes/misc/cyan_colored_cobblestone_wall_from_cyan_colored_cobblestone_stonecutting" | "caveopolis:recipes/decorations/red_colored_wooden_plank_fence" | "alltheores:recipes/misc/aluminum_gear" | "alltheores:recipes/misc/tin_ingot_from_slate_ore_blasting" | "caveopolis:recipes/misc/white_colored_cobblestone_slab_from_white_colored_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/lime_terracotta" | "minecraft:recipes/building_blocks/smooth_quartz_slab_from_smooth_quartz_stonecutting" | "caveopolis:recipes/misc/brown_colored_stone_brick_wall_from_brown_colored_stone_bricks_stonecutting" | "caveopolis:recipes/redstone/yellow_colored_wooden_plank_trapdoor" | "minecraft:recipes/food/cake" | "minecraft:recipes/combat/iron_leggings" | "nec:recipes/decorations/mangrove_chest" | "caveopolis:recipes/redstone/black_colored_stone_pressure_plate" | "minecraft:recipes/building_blocks/light_gray_terracotta" | "caveopolis:recipes/misc/orange_colored_stone_wall" | "minecraft:recipes/decorations/gray_bed" | "minecraft:recipes/mangrove_propagule" | "minecraft:recipes/misc/emerald_from_smelting_emerald_ore" | "minecraft:recipes/building_blocks/coarse_dirt" | "farmersdelight:recipes/food/smoked_ham" | "farmersdelight:recipes/food/milk_bottle" | "oceansdelight:recipes/baked_tentacle_on_a_stick" | "farmersdelight:recipes/food/bread_from_smelting" | "awesomedungeonocean:ocean_warn_temple/find_during_night" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_cut_copper_stonecutting" | "caveopolis:recipes/misc/orange_colored_wooden_plank_button_from_orange_colored_wooden_planks_stonecutting" | "supplementaries:recipes/blackstone_tile_stairs" | "minecraft:recipes/building_blocks/light_gray_concrete_powder" | "aquaculture:recipes/aquaculture/worm_farm" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "alltheores:recipes/misc/iridium_nugget_from_ingot" | "minecraft:recipes/peony" | "aquaculture:recipes/aquaculture/tackle_box" | "minecraft:recipes/combat/leather_leggings" | "minecraft:recipes/building_blocks/pink_concrete_powder" | "caveopolis:recipes/misc/cyan_colored_stone_brick_slab_from_cyan_colored_stone_bricks_stonecutting" | "supplementaries:story/unenchanter" | "minecraft:recipes/building_blocks/sandstone_slab" | "minecraft:recipes/cactus" | "supplementaries:recipes/timber_cross_brace" | "farmersdelight:recipes/building_blocks/straw_bale" | "alltheores:recipes/misc/signalum_ingot_from_dust" | "smallships:recipes/transportation/oak_brigg" | "minecraft:recipes/redstone/crimson_button" | "caveopolis:recipes/misc/cobblestone_bricks_from_cobblestone_stonecutting" | "caveopolis:recipes/building_blocks/cyan_colored_cobblestone_stairs" | "framedcompactdrawers:recipes/misc/framed_trim" | "caveopolis:recipes/misc/pink_colored_wooden_plank_trapdoor_from_pink_colored_wooden_planks_stonecutting" | "minecraft:story/obtain_armor" | "alltheores:recipes/misc/bronze_plate" | "caveopolis:recipes/building_blocks/orange_colored_stone_brick_stairs" | "minecraft:recipes/combat/diamond_leggings" | "minecraft:recipes/decorations/gray_stained_glass_pane" | "alltheores:recipes/misc/copper_plate" | "minecraft:recipes/food/dried_kelp_from_smelting" | "smallships:recipes/transportation/bamboo_cog" | "caveopolis:recipes/misc/pink_colored_wooden_plank_crafting_table" | "caveopolis:recipes/misc/marble_wall_from_marble_stonecutting" | "caveopolis:recipes/redstone/cyan_colored_wooden_plank_trapdoor" | "farmersdelight:recipes/cooking/fish_stew" | "alltheores:recipes/misc/diamond_rod" | "aquaculture:recipes/tools/iron_fishing_rod" | "alltheores:recipes/misc/iridium_ingot_from_slate_ore_blasting" | "caveopolis:recipes/misc/white_colored_stone_brick_stairs_from_white_colored_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/cherry_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "caveopolis:recipes/misc/purple_colored_cobblestone_bricks_from_purple_colored_cobblestone_stonecutting" | "sophisticatedbackpacks:recipes/misc/everlasting_upgrade" | "minecraft:end/kill_dragon" | "minecraft:recipes/building_blocks/polished_blackstone_brick_stairs" | "caveopolis:recipes/misc/pink_colored_stone_brick_slab_from_pink_colored_stone_bricks_stonecutting" | "caveopolis:recipes/building_blocks/stripped_pink_colored_wood" | "alltheores:recipes/misc/invar_ingot_from_dust_blasting" | "awesomedungeonocean:ocean_quad/find_normal" | "minecraft:recipes/decorations/orange_candle" | "caveopolis:recipes/redstone/cyan_colored_wooden_plank_fence_gate" | "minecraft:recipes/decorations/stone_brick_wall" | "farmersdelight:main/place_skillet" | "minecraft:recipes/redstone/dark_oak_fence_gate" | "caveopolis:recipes/building_blocks/purple_colored_cobblestone" | "minecraft:recipes/building_blocks/waxed_weathered_copper_from_honeycomb" | "minecraft:recipes/misc/iron_nugget_from_smelting" | "minecraft:recipes/decorations/prismarine_wall_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/dye_light_gray_bed" | "caveopolis:recipes/misc/gray_colored_stone_crafting_table" | "alltheores:recipes/misc/silver_block" | "framedcompactdrawers:recipes/misc/framed_half_one" | "opolisutilities:recipes/copper_nugget" | "minecraft:recipes/misc/copper_ingot_from_smelting_copper_ore" | "farmersdelight:recipes/misc/milk_bucket_from_bottles" | "minecraft:recipes/misc/blue_dye" | "caveopolis:recipes/misc/red_colored_wooden_plank_crafting_table" | "caveopolis:recipes/misc/lime_colored_cobblestone_slab_from_lime_colored_cobblestone_stonecutting" | "minecraft:recipes/food/baked_potato_from_campfire_cooking" | "supplementaries:recipes/sign_post_dark_oak" | "caveopolis:recipes/misc/black_colored_hanging_sign_from_stripped_black_colored_log_stonecutting" | "caveopolis:recipes/misc/cyan_colored_wooden_plank_fence_from_cyan_colored_wooden_planks_stonecutting" | "minecraft:recipes/misc/cyan_dye" | "caveopolis:recipes/misc/light_gray_colored_stone_wall_from_light_gray_colored_stone_stonecutting" | "minecraft:husbandry/make_a_sign_glow" | "minecraft:recipes/building_blocks/dye_lime_wool" | "minecraft:recipes/redstone/acacia_pressure_plate" | "caveopolis:recipes/misc/pink_colored_sign_from_pink_colored_wooden_planks_stonecutting" | "minecraft:nether/create_beacon" | "minecraft:recipes/building_blocks/crimson_slab" | "alltheores:recipes/misc/raw_aluminum_from_block" | "minecraft:recipes/torchflower_seeds" | "alltheores:recipes/misc/steel_ingot_from_block" | "supplementaries:recipes/boat_jar" | "minecraft:recipes/building_blocks/crimson_stairs" | "alltheores:recipes/misc/aluminum_dust_from_hammer_ingot_crushing" | "caveopolis:recipes/misc/blue_colored_stone_slab" | "minecraft:recipes/building_blocks/green_stained_glass" | "caveopolis:recipes/misc/white_colored_cobblestone_wall" | "alltheores:recipes/misc/uranium_ingot_from_ore" | "minecraft:recipes/building_blocks/bamboo_mosaic_slab" | "minecraft:recipes/decorations/yellow_glazed_terracotta" | "caveopolis:recipes/misc/gray_colored_cobblestone_brick_stairs_from_gray_colored_cobblestone_bricks_stonecutting" | "caveopolis:recipes/redstone/magenta_colored_stone_button" | "caveopolis:recipes/misc/white_colored_wooden_plank_slab_from_white_colored_wooden_planks_stonecutting" | "caveopolis:recipes/building_blocks/lime_colored_cobblestone" | "minecraft:recipes/building_blocks/bookshelf" | "alltheores:recipes/misc/platinum_ingot" | "sophisticatedbackpacks:recipes/misc/auto_smelting_upgrade" | "caveopolis:recipes/building_blocks/stripped_purple_colored_wood" | "alltheores:recipes/misc/nickel_ingot_from_ore" | "caveopolis:recipes/building_blocks/green_colored_wooden_planks" | "minecraft:recipes/amethyst_shard" | "alltheores:recipes/misc/tin_block" | "minecraft:story/iron_tools" | "caveopolis:recipes/building_blocks/gray_colored_stone" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_blackstone_stonecutting" | "minecraft:recipes/combat/iron_chestplate" | "caveopolis:recipes/redstone/light_blue_colored_stone_pressure_plate" | "minecraft:recipes/redstone/dark_oak_trapdoor" | "minecraft:recipes/redstone/oak_trapdoor" | "caveopolis:recipes/misc/yellow_colored_wooden_plank_fence_gate_from_yellow_colored_wooden_planks_stonecutting" | "caveopolis:recipes/redstone/brown_colored_wooden_plank_door" | "alltheores:recipes/misc/osmium_gear" | "caveopolis:recipes/misc/pink_colored_stone_button_from_pink_colored_stone_stonecutting" | "nec:recipes/decorations/dark_oak_chest" | "sophisticatedbackpacks:recipes/misc/chipped/mason_table_upgrade" | "alltheores:recipes/misc/aluminum_ingot_from_ore_blasting" | "caveopolis:recipes/misc/pink_colored_wooden_plank_stairs_from_pink_colored_wooden_planks_stonecutting" | "caveopolis:recipes/redstone/yellow_colored_wooden_plank_pressure_plate" | "smallships:recipes/combat/cannon" | "alltheores:recipes/misc/lumium_gear" | "caveopolis:recipes/misc/marble_brick_wall_from_marble_bricks_stonecutting" | "supplementaries:recipes/stone_tile_wall" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/misc/book" | "minecraft:recipes/building_blocks/purpur_slab" | "minecraft:recipes/powder_snow_bucket" | "caveopolis:recipes/misc/green_colored_cobblestone_brick_slab_from_green_colored_cobblestone_bricks_stonecutting" | "caveopolis:recipes/misc/light_gray_colored_cobblestone_brick_slab" | "caveopolis:recipes/misc/gray_colored_cobblestone_stairs_from_gray_colored_cobblestone_stonecutting" | "minecraft:recipes/combat/stone_sword" | "caveopolis:recipes/building_blocks/light_gray_colored_wood" | "farmersdelight:recipes/decorations/blue_canvas_sign" | "minecraft:recipes/obsidian" | "caveopolis:recipes/building_blocks/pink_colored_wooden_planks" | "minecraft:recipes/decorations/cobblestone_wall" | "caveopolis:recipes/misc/blue_colored_sign_from_blue_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/zinc_ingot_from_ore_blasting" | "minecraft:recipes/misc/dune_armor_trim_smithing_template_smithing_trim" | "caveopolis:recipes/redstone/green_colored_wooden_plank_trapdoor" | "caveopolis:recipes/misc/light_gray_colored_cobblestone_brick_slab_from_light_gray_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/building_blocks/brown_stained_glass" | "caveopolis:recipes/misc/pink_colored_cobblestone_brick_stairs_from_pink_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/decorations/brown_carpet" | "minecraft:recipes/tube_coral" | "minecraft:recipes/decorations/red_stained_glass_pane" | "minecraft:recipes/food/dried_kelp_from_campfire_cooking" | "minecraft:recipes/combat/netherite_sword_smithing" | "caveopolis:recipes/misc/light_gray_colored_stone_wall" | "industrialforegoing:recipes/misc/laser_lens_light_gray_recolor" | "caveopolis:recipes/misc/green_colored_stone_brick_wall" | "caveopolis:recipes/misc/blue_colored_wooden_plank_door_from_blue_colored_wooden_planks_stonecutting" | "suppsquared:recipes/decorations/thermal/item_shelf_rubberwood" | "caveopolis:recipes/misc/light_gray_colored_cobblestone_bricks_from_light_gray_colored_cobblestone_stonecutting" | "caveopolis:recipes/misc/pink_colored_stone_brick_slab" | "minecraft:recipes/mourner_pottery_sherd" | "minecraft:recipes/misc/diamond" | "minecraft:recipes/misc/gold_nugget_from_smelting" | "caveopolis:recipes/misc/red_colored_wooden_plank_slab_from_red_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/copper_nugget_from_ingot" | "caveopolis:recipes/misc/magenta_colored_stone_brick_slab_from_magenta_colored_stone_bricks_stonecutting" | "minecraft:recipes/food/cooked_chicken" | "caveopolis:recipes/building_blocks/orange_colored_cobblestone_stairs" | "minecraft:recipes/crying_obsidian" | "minecraft:recipes/misc/netherite_upgrade_smithing_template" | "caveopolis:recipes/misc/gray_colored_wooden_plank_slab" | "minecraft:recipes/tools/stone_axe" | "supplementaries:recipes/decorations/sign_post_cherry" | "caveopolis:recipes/misc/light_gray_colored_wooden_plank_fence_from_light_gray_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/enderium_block" | "caveopolis:recipes/misc/light_blue_colored_stone_brick_wall_from_light_blue_colored_stone_bricks_stonecutting" | "alltheores:recipes/misc/electrum_block" | "minecraft:recipes/decorations/blue_candle" | "farmersdelight:recipes/food/wheat_dough_from_eggs" | "caveopolis:recipes/misc/light_gray_colored_cobblestone_brick_stairs_from_light_gray_colored_cobblestone_bricks_stonecutting" | "aquaculture:recipes/aquaculture/note_hook" | "minecraft:nether/ride_strider" | "caveopolis:recipes/misc/gray_colored_wooden_plank_button_from_gray_colored_wooden_planks_stonecutting" | "duckling:holiday_fruit_cake" | "caveopolis:recipes/building_blocks/green_colored_cobblestone_bricks" | "chipped:recipes/tinkering_table" | "caveopolis:recipes/misc/light_gray_colored_wooden_plank_pressure_plate_from_light_gray_colored_wooden_planks_stonecutting" | "supplementaries:recipes/flags/flag_brown" | "alltheores:recipes/misc/lead_ingot_from_slate_ore_blasting" | "caveopolis:recipes/misc/light_blue_colored_stone_slab" | "sophisticatedbackpacks:recipes/misc/chipped/carpenters_table_upgrade" | "storagedrawers:recipes/storagedrawers/jungle_drawers" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_honeycomb" | "minecraft:recipes/misc/iron_nugget" | "supplementaries:recipes/flags/flag_gray" | "minecraft:recipes/building_blocks/brown_concrete_powder" | "minecraft:end/levitate" | "minecraft:recipes/building_blocks/blue_stained_glass" | "aquaculture:recipes/food/cooked_fish_fillet_from_campfire" | "caveopolis:recipes/building_blocks/yellow_colored_cobblestone" | "caveopolis:recipes/building_blocks/orange_colored_stone" | "caveopolis:recipes/building_blocks/yellow_colored_cobblestone_bricks" | "minecraft:recipes/building_blocks/cracked_stone_bricks" | "caveopolis:recipes/building_blocks/white_colored_wooden_planks" | "farmersdelight:recipes/decorations/cyan_hanging_canvas_sign" | "farmersdelight:recipes/combat/flint_knife" | "farmersdelight:main/plant_rice" | "minecraft:recipes/birch_sapling" | "minecraft:recipes/building_blocks/cut_copper_slab_from_cut_copper_stonecutting" | "minecraft:recipes/misc/iron_ingot_from_blasting_iron_ore" | "alltheores:recipes/misc/steel_block" | "minecraft:recipes/misc/bucket" | "minecraft:adventure/bullseye" | "minecraft:recipes/building_blocks/diorite_slab" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_bricks_stonecutting" | "farmersdelight:recipes/decorations/black_canvas_sign" | "aquaculture:recipes/tools/diamond_fillet_knife" | "caveopolis:recipes/misc/magenta_colored_cobblestone_brick_stairs_from_magenta_colored_cobblestone_bricks_stonecutting" | "caveopolis:recipes/misc/orange_colored_cobblestone_brick_wall_from_orange_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/decorations/orange_stained_glass_pane" | "supplementaries:recipes/flower_box" | "caveopolis:recipes/misc/light_blue_colored_stone_stairs_from_light_blue_colored_stone_stonecutting" | "caveopolis:recipes/misc/cobblestone_brick_slab_from_cobblestone_bricks_stonecutting" | "caveopolis:recipes/misc/orange_colored_cobblestone_brick_slab" | "alltheores:recipes/misc/iridium_dust_from_hammer_crushing" | "caveopolis:recipes/redstone/purple_colored_wooden_plank_button" | "minecraft:recipes/building_blocks/light_blue_concrete_powder" | "minecraft:recipes/building_blocks/glass" | "caveopolis:recipes/misc/light_blue_colored_wooden_plank_trapdoor_from_light_blue_colored_wooden_planks_stonecutting" | "minecraft:recipes/combat/bow" | "caveopolis:recipes/misc/magenta_spray_can" | "minecraft:recipes/building_blocks/acacia_slab" | "minecraft:recipes/building_blocks/smooth_sandstone" | "minecraft:recipes/leather" | "minecraft:recipes/building_blocks/oxidized_cut_copper" | "farmersdelight:recipes/building_blocks/tatami" | "alltheores:recipes/misc/brass_ingot_from_dust_blasting" | "caveopolis:recipes/misc/red_colored_cobblestone_brick_slab_from_red_colored_cobblestone_bricks_stonecutting" | "farmersdelight:recipes/decorations/safety_net" | "minecraft:recipes/transportation/minecart" | "caveopolis:recipes/misc/pink_colored_cobblestone_slab" | "minecraft:recipes/decorations/orange_glazed_terracotta" | "farmersdelight:recipes/food/cooked_salmon_slice_from_smoking" | "supplementaries:recipes/ash_brick_slab" | "caveopolis:recipes/misc/blue_colored_wooden_plank_crafting_table" | "supplementaries:recipes/faucet" | "minecraft:recipes/decorations/green_stained_glass_pane" | "minecraft:recipes/tools/iron_hoe" | "minecraft:recipes/building_blocks/deepslate_tile_stairs_from_polished_deepslate_stonecutting" | "aquamirae:adventure/find_ice_maze" | "caveopolis:recipes/building_blocks/stripped_gray_colored_wood" | "farmersdelight:recipes/misc/iron_nugget_from_smelting_knife" | "minecraft:recipes/creeper_head" | "caveopolis:recipes/misc/magenta_colored_cobblestone_wall_from_magenta_colored_cobblestone_stonecutting" | "minecraft:recipes/misc/bowl" | "farmersdelight:recipes/decorations/magenta_hanging_canvas_sign" | "opolisutilities:recipes/mini_charcoal" | "minecraft:recipes/building_blocks/dye_orange_carpet" | "farmersdelight:recipes/food/cooked_mutton_chops" | "farmersdelight:recipes/food/honey_cookie" | "minecraft:recipes/tools/clock" | "minecraft:story/enter_the_nether" | "minecraft:recipes/decorations/red_glazed_terracotta" | "minecraft:adventure/whos_the_pillager_now" | "minecraft:recipes/food/baked_potato" | "caveopolis:recipes/misc/magenta_colored_stone_slab_from_magenta_colored_stone_stonecutting" | "supplementaries:recipes/blackstone_tile_wall" | "minecraft:recipes/decorations/green_banner" | "caveopolis:recipes/redstone/light_gray_colored_wooden_plank_button" | "minecraft:recipes/misc/gold_ingot_from_nuggets" | "caveopolis:recipes/building_blocks/green_colored_stone_bricks" | "caveopolis:recipes/redstone/red_colored_wooden_plank_trapdoor" | "strainers:recipes/stone_pebble" | "minecraft:recipes/misc/pink_dye_from_pink_tulip" | "minecraft:recipes/building_blocks/mangrove_stairs" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade" | "caveopolis:recipes/misc/magenta_colored_stone_brick_stairs_from_magenta_colored_stone_bricks_stonecutting" | "alltheores:recipes/misc/copper_rod" | "caveopolis:recipes/decorations/yellow_colored_wooden_plank_fence" | "minecraft:recipes/decorations/spruce_sign" | "alltheores:recipes/misc/lead_dust_from_hammer_crushing" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template" | "sophisticatedbackpacks:recipes/misc/diamond_backpack" | "caveopolis:recipes/misc/lime_colored_wooden_plank_crafting_table" | "supplementaries:recipes/candle_holders/candle_holder_pink" | "minecraft:recipes/building_blocks/bricks" | "caveopolis:recipes/misc/white_colored_cobblestone_brick_slab" | "minecraft:recipes/combat/netherite_leggings_smithing" | "farmersdelight:recipes/cooking/noodle_soup" | "caveopolis:recipes/misc/black_colored_cobblestone_slab" | "minecraft:recipes/decorations/painting" | "minecraft:recipes/building_blocks/waxed_cut_copper" | "alltheores:recipes/misc/raw_tin_from_block" | "farmersdelight:main/hit_raider_with_rotten_tomato" | "minecraft:recipes/building_blocks/red_terracotta" | "minecraft:recipes/podzol" | "caveopolis:recipes/decorations/cyan_colored_wooden_plank_fence" | "minecraft:recipes/combat/arrow" | "aquaculture:recipes/aquaculture/gold_hook" | "minecraft:recipes/heart_of_the_sea" | "sophisticatedbackpacks:recipes/misc/chipped/alchemy_bench_upgrade" | "caveopolis:recipes/building_blocks/blue_colored_cobblestone_brick_stairs" | "minecraft:recipes/iron_nugget" | "caveopolis:recipes/redstone/red_colored_wooden_plank_pressure_plate" | "supplementaries:recipes/candle_holders/candle_holder_magenta_dye" | "awesomedungeonocean:ocean_the_column_temple/find_during_night" | "farmersdelight:recipes/decorations/dark_oak_cabinet" | "alltheores:recipes/misc/platinum_gear" | "minecraft:recipes/building_blocks/polished_deepslate_stairs_from_polished_deepslate_stonecutting" | "minecraft:recipes/misc/vex_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/andesite" | "alltheores:recipes/misc/ruby_block" | "minecraft:recipes/misc/green_wool" | "minecraft:recipes/combat/golden_helmet" | "minecraft:recipes/redstone/acacia_trapdoor" | "aquamirae:adventure/consume_sea_stew" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_from_waxed_exposed_copper_stonecutting" | "supplementaries:recipes/gold_trapdoor" | "minecraft:recipes/building_blocks/brick_slab_from_bricks_stonecutting" | "caveopolis:recipes/misc/green_colored_cobblestone_slab_from_green_colored_cobblestone_stonecutting" | "minecraft:recipes/food/cooked_salmon" | "minecraft:recipes/building_blocks/cherry_stairs" | "aquamirae:recipes/remnants_saber" | "supplementaries:recipes/globe_sepia" | "caveopolis:recipes/building_blocks/magenta_colored_wood" | "caveopolis:recipes/misc/light_gray_colored_stone_bricks_from_light_gray_colored_stone_stonecutting" | "caveopolis:recipes/misc/gray_colored_cobblestone_brick_slab" | "caveopolis:recipes/misc/black_colored_stone_brick_slab" | "aquaculture:recipes/decorations/oak_fish_mount" | "caveopolis:recipes/misc/black_colored_cobblestone_brick_slab" | "caveopolis:recipes/misc/green_colored_wooden_plank_trapdoor_from_green_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/signalum_rod" | "alltheores:recipes/misc/signalum_ingot_from_block" | "minecraft:recipes/decorations/composter" | "minecraft:recipes/red_tulip" | "caveopolis:recipes/building_blocks/stripped_blue_colored_wood" | "minecraft:recipes/building_blocks/red_nether_brick_stairs_from_red_nether_bricks_stonecutting" | "caveopolis:recipes/misc/yellow_colored_stone_brick_wall_from_yellow_colored_stone_bricks_stonecutting" | "caveopolis:recipes/building_blocks/pink_colored_stone_bricks" | "caveopolis:recipes/redstone/white_colored_wooden_plank_button" | "alltheores:recipes/misc/raw_platinum_block" | "minecraft:recipes/sweet_berries" | "aquamirae:adventure/obtain_frozen_key" | "minecraft:recipes/building_blocks/end_stone_bricks" | "caveopolis:recipes/misc/light_gray_colored_stone_brick_slab_from_light_gray_colored_stone_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/stack_upgrade_starter_tier" | "caveopolis:recipes/misc/orange_colored_stone_brick_slab" | "caveopolis:recipes/misc/pink_colored_stone_slab_from_pink_colored_stone_stonecutting" | "minecraft:recipes/decorations/glow_item_frame" | "minecraft:husbandry/silk_touch_nest" | "minecraft:recipes/building_blocks/dark_prismarine_stairs" | "minecraft:recipes/building_blocks/dye_cyan_wool" | "minecraft:recipes/decorations/andesite_wall_from_andesite_stonecutting" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_honeycomb" | "minecraft:recipes/building_blocks/nether_brick_stairs" | "supplementaries:recipes/doormat_2" | "sophisticatedbackpacks:recipes/misc/chipped/glassblower_upgrade" | "caveopolis:recipes/misc/cyan_colored_stone_button_from_cyan_colored_stone_stonecutting" | "alltheores:recipes/misc/iridium_gear" | "farmersdelight:recipes/cooking/vegetable_noodles" | "alltheores:recipes/misc/bronze_ingot_from_dust_blasting" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab" | "caveopolis:recipes/building_blocks/cyan_colored_stone_stairs" | "alltheores:recipes/misc/electrum_dust_from_alloy_blending" | "minecraft:story/smelt_iron" | "minecraft:recipes/misc/orange_dye_from_torchflower" | "minecraft:recipes/wheat_seeds" | "supplementaries:recipes/sign_post_birch" | "supplementaries:recipes/candle_holders/candle_holder_white" | "caveopolis:recipes/misc/lime_colored_wooden_plank_slab" | "caveopolis:recipes/redstone/light_gray_colored_wooden_plank_pressure_plate" | "caveopolis:recipes/building_blocks/stripped_red_colored_wood" | "suppsquared:recipes/decorations/item_shelf_birch" | "minecraft:recipes/tools/fishing_rod" | "minecraft:recipes/decorations/smoker" | "alltheores:recipes/misc/steel_rod" | "caveopolis:recipes/misc/magenta_colored_wooden_plank_door_from_magenta_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/invar_ingot_from_block" | "minecraft:recipes/building_blocks/chiseled_deepslate_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/chiseled_stone_bricks" | "minecraft:recipes/building_blocks/nether_brick_slab" | "supplementaries:recipes/bed_from_feather_block" | "caveopolis:recipes/decorations/black_colored_wooden_plank_fence" | "minecraft:recipes/misc/pumpkin_seeds" | "caveopolis:recipes/misc/orange_colored_cobblestone_bricks_from_orange_colored_cobblestone_stonecutting" | "caveopolis:recipes/misc/brown_colored_cobblestone_slab_from_brown_colored_cobblestone_stonecutting" | "alltheores:recipes/misc/zinc_rod" | "farmersdelight:recipes/decorations/jungle_cabinet" | "minecraft:recipes/decorations/mud_brick_wall" | "aquamirae:recipes/elodea" | "minecraft:recipes/building_blocks/red_sandstone" | "minecraft:husbandry/tadpole_in_a_bucket" | "caveopolis:recipes/misc/magenta_colored_stone_crafting_table" | "minecraft:recipes/redstone/dark_oak_button" | "supplementaries:recipes/checker" | "caveopolis:recipes/redstone/purple_colored_stone_pressure_plate" | "minecraft:husbandry/wax_off" | "caveopolis:recipes/redstone/green_colored_wooden_plank_door" | "farmersdelight:recipes/food/rice_panicle" | "minecraft:recipes/decorations/beehive" | "minecraft:recipes/misc/rib_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/tools/netherite_hoe_smithing" | "supplementaries:recipes/decorations/sign_post_warped" | "minecraft:recipes/decorations/lime_candle" | "minecraft:recipes/building_blocks/emerald_block" | "caveopolis:recipes/misc/gray_colored_cobblestone_bricks_from_gray_colored_cobblestone_stonecutting" | "aquamirae:adventure/obtain_anglers_fang" | "minecraft:recipes/food/cooked_rabbit_from_smoking" | "caveopolis:recipes/misc/yellow_colored_cobblestone_brick_stairs_from_yellow_colored_cobblestone_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/chipped/tinkering_table_upgrade" | "farmersdelight:recipes/misc/paper_from_tree_bark" | "farmersdelight:recipes/cooking/cabbage_rolls" | "caveopolis:recipes/building_blocks/green_colored_cobblestone" | "alltheores:recipes/misc/aluminum_ingot_from_ore" | "minecraft:recipes/building_blocks/nether_wart_block" | "caveopolis:recipes/misc/white_colored_sign_from_white_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/yellow_colored_wooden_plank_slab_from_yellow_colored_wooden_planks_stonecutting" | "minecraft:recipes/redstone/trapped_chest" | "minecraft:recipes/building_blocks/dye_pink_wool" | "caveopolis:recipes/misc/green_colored_cobblestone_brick_stairs_from_green_colored_cobblestone_bricks_stonecutting" | "alltheores:recipes/misc/zinc_dust_from_hammer_ingot_crushing" | "minecraft:recipes/decorations/cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade_from_basic" | "supplementaries:recipes/bamboo_spikes" | "duckling:agent_d" | "caveopolis:recipes/misc/green_colored_stone_brick_stairs_from_green_colored_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/stripped_birch_wood" | "caveopolis:recipes/misc/brown_colored_cobblestone_brick_stairs_from_brown_colored_cobblestone_bricks_stonecutting" | "alltheores:recipes/misc/silver_rod" | "caveopolis:recipes/redstone/brown_colored_stone_pressure_plate" | "minecraft:recipes/suspicious_gravel" | "minecraft:recipes/building_blocks/sponge" | "minecraft:recipes/building_blocks/smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "minecraft:recipes/building_blocks/prismarine_brick_stairs" | "oceansdelight:recipes/cooked_guardian_tail_from_smoking" | "minecraft:recipes/decorations/prismarine_wall" | "caveopolis:recipes/misc/purple_colored_cobblestone_slab_from_purple_colored_cobblestone_stonecutting" | "storagedrawers:recipes/storagedrawers/birch_trim" | "aquaculture:recipes/decorations/spruce_fish_mount" | "minecraft:recipes/bubble_coral_fan" | "caveopolis:recipes/misc/blue_colored_cobblestone_brick_slab_from_blue_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/redstone/warped_fence_gate" | "minecraft:recipes/transportation/acacia_chest_boat" | "caveopolis:recipes/misc/lime_colored_stone_brick_slab_from_lime_colored_stone_bricks_stonecutting" | "minecraft:recipes/decorations/white_candle" | "farmersdelight:recipes/food/salmon_roll" | "caveopolis:recipes/misc/orange_colored_cobblestone_slab" | "minecraft:recipes/combat/turtle_helmet" | "minecraft:recipes/building_blocks/mud_brick_stairs_from_mud_bricks_stonecutting" | "farmersdelight:main/place_feast" | "minecraft:recipes/building_blocks/oak_stairs" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_andesite_stonecutting" | "alltheores:recipes/misc/steel_ingot_from_dust" | "aquaculture:recipes/tools/iron_fillet_knife" | "storagedrawers:recipes/storagedrawers/void_upgrade" | "minecraft:end/dragon_breath" | "storagedrawers:recipes/storagedrawers/warped_trim" | "caveopolis:recipes/misc/pink_colored_cobblestone_brick_wall" | "minecraft:recipes/building_blocks/white_concrete_powder" | "farmersdelight:recipes/food/wheat_dough_from_water" | "caveopolis:recipes/redstone/light_gray_colored_stone_pressure_plate" | "caveopolis:recipes/building_blocks/brown_colored_wood" | "alltheores:recipes/misc/signalum_nugget_from_ingot" | "caveopolis:recipes/misc/light_blue_colored_cobblestone_brick_wall" | "minecraft:recipes/misc/music_disc_5" | "minecraft:recipes/misc/netherite_scrap" | "minecraft:story/enchant_item" | "alltheores:recipes/misc/copper_ingot_from_block" | "caveopolis:recipes/misc/light_gray_colored_cobblestone_wall_from_light_gray_colored_cobblestone_stonecutting" | "caveopolis:recipes/misc/yellow_colored_wooden_plank_fence_from_yellow_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/lime_stained_glass" | "minecraft:recipes/sugar_cane" | "caveopolis:recipes/misc/green_colored_stone_brick_wall_from_green_colored_stone_bricks_stonecutting" | "caveopolis:recipes/misc/cyan_colored_cobblestone_stairs_from_cyan_colored_cobblestone_stonecutting" | "alltheores:recipes/misc/aluminum_dust_from_hammer_crushing" | "caveopolis:recipes/redstone/lime_colored_wooden_plank_fence_gate" | "caveopolis:recipes/redstone/gray_colored_stone_button" | "minecraft:recipes/building_blocks/quartz_pillar_from_quartz_block_stonecutting" | "minecraft:recipes/redstone/cherry_trapdoor" | "chipped:recipes/alchemy_bench" | "minecraft:recipes/decorations/chain" | "caveopolis:recipes/misc/pink_colored_wooden_plank_fence_gate_from_pink_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/yellow_bed" | "minecraft:recipes/decorations/oak_fence" | "storagedrawers:recipes/storagedrawers/jungle_trim" | "alltheores:recipes/misc/nickel_ingot_from_slate_ore" | "minecraft:recipes/redstone/cherry_button" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs" | "minecraft:recipes/misc/coal_from_blasting_coal_ore" | "minecraft:recipes/redstone/mangrove_door" | "minecraft:recipes/redstone/redstone_from_smelting_deepslate_redstone_ore" | "minecraft:recipes/food/cooked_porkchop_from_campfire_cooking" | "alltheores:recipes/misc/bronze_ingot" | "caveopolis:recipes/redstone/gray_colored_wooden_plank_trapdoor" | "caveopolis:recipes/misc/white_colored_cobblestone_bricks_from_white_colored_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/chiseled_bookshelf" | "farmersdelight:recipes/cooking/pumpkin_soup" | "alltheores:recipes/misc/uranium_block" | "alltheores:recipes/misc/osmium_ingot_from_ore" | "supplementaries:recipes/decorations/sign_post_jungle" | "caveopolis:recipes/misc/yellow_colored_stone_wall_from_yellow_colored_stone_stonecutting" | "caveopolis:recipes/misc/pink_colored_stone_pressure_plate_from_pink_colored_stone_stonecutting" | "minecraft:recipes/decorations/light_blue_stained_glass_pane" | "alltheores:recipes/misc/gold_dust_from_hammer_ingot_crushing" | "minecraft:adventure/spyglass_at_parrot" | "minecraft:recipes/building_blocks/nether_brick_stairs_from_nether_bricks_stonecutting" | "alltheores:recipes/misc/osmium_ingot_from_raw_blasting" | "smallships:recipes/transportation/oak_cog" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs" | "minecraft:recipes/building_blocks/spruce_wood" | "minecraft:recipes/misc/yellow_dye_from_dandelion" | "igleelib:recipes/igleelib/modium_ingot" | "alltheores:recipes/misc/platinum_dust_from_hammer_crushing" | "supplementaries:recipes/sconce" | "storagedrawers:recipes/storagedrawers/fill_level_upgrade" | "minecraft:recipes/decorations/end_stone_brick_wall" | "alltheores:recipes/misc/invar_dust_from_alloy_blending" | "storagedrawers:recipes/storagedrawers/max_redstone_upgrade" | "aquamirae:recipes/anglers_fang" | "caveopolis:recipes/building_blocks/green_colored_cobblestone_brick_stairs" | "minecraft:recipes/decorations/mangrove_hanging_sign" | "minecraft:recipes/building_blocks/deepslate_bricks_from_polished_deepslate_stonecutting" | "alltheores:recipes/misc/osmium_block" | "minecraft:recipes/decorations/black_banner" | "caveopolis:recipes/misc/light_gray_colored_wooden_plank_slab" | "minecraft:recipes/misc/black_dye_from_wither_rose" | "storagedrawers:recipes/storagedrawers/birch_drawers" | "minecraft:recipes/misc/bone_meal" | "igleelib:recipes/igleelib/blazum_block" | "minecraft:recipes/allium" | "minecraft:recipes/building_blocks/prismarine_brick_slab_from_prismarine_stonecutting" | "minecraft:recipes/building_blocks/sandstone_stairs_from_sandstone_stonecutting" | "minecraft:adventure/totem_of_undying" | "minecraft:recipes/decorations/cobbled_deepslate_wall" | "minecraft:recipes/building_blocks/prismarine_bricks" | "caveopolis:recipes/misc/white_colored_wooden_plank_door_from_white_colored_wooden_planks_stonecutting" | "nec:recipes/decorations/spruce_chest" | "alltheores:recipes/misc/raw_zinc_from_block" | "farmersdelight:recipes/food/chocolate_pie_from_slices" | "minecraft:recipes/decorations/polished_deepslate_wall_from_cobbled_deepslate_stonecutting" | "caveopolis:recipes/misc/light_blue_colored_wooden_plank_crafting_table" | "farmersdelight:recipes/decorations/green_hanging_canvas_sign" | "caveopolis:recipes/redstone/light_blue_colored_wooden_plank_trapdoor" | "minecraft:recipes/decorations/diorite_wall" | "caveopolis:recipes/misc/marble_wall" | "caveopolis:recipes/misc/purple_colored_cobblestone_brick_slab_from_purple_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/decorations/stonecutter" | "farmersdelight:recipes/food/barbecue_stick" | "caveopolis:recipes/misc/black_colored_cobblestone_wall_from_black_colored_cobblestone_stonecutting" | "sophisticatedbackpacks:recipes/misc/compacting_upgrade" | "alltheores:recipes/misc/iridium_ingot_from_ore" | "minecraft:recipes/decorations/light_blue_banner" | "caveopolis:recipes/misc/yellow_colored_wooden_plank_door_from_yellow_colored_wooden_planks_stonecutting" | "industrialforegoing:recipes/misc/laser_lens_light_blue_recolor" | "minecraft:recipes/decorations/smithing_table" | "caveopolis:recipes/building_blocks/marble_stairs" | "framedcompactdrawers:recipes/misc/framed_drawer_controller" | "caveopolis:recipes/misc/blue_colored_stone_brick_slab" | "minecraft:recipes/building_blocks/cut_sandstone_slab" | "minecraft:recipes/misc/sugar_from_honey_bottle" | "minecraft:recipes/building_blocks/dye_red_carpet" | "minecraft:husbandry/allay_deliver_cake_to_note_block" | "smallships:recipes/transportation/oak_galley" | "supplementaries:recipes/speaker_block" | "caveopolis:recipes/building_blocks/lime_colored_stone_brick_stairs" | "caveopolis:recipes/building_blocks/red_colored_wood" | "aquaculture:recipes/aquaculture/double_hook" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "minecraft:recipes/decorations/orange_stained_glass_pane_from_glass_pane" | "minecraft:recipes/transportation/tnt_minecart" | "caveopolis:recipes/building_blocks/stripped_orange_colored_wood" | "minecraft:recipes/pointed_dripstone" | "supplementaries:recipes/bellows" | "minecraft:recipes/seagrass" | "aquaculture:recipes/food/turtle_soup" | "caveopolis:recipes/misc/cyan_colored_cobblestone_brick_stairs_from_cyan_colored_cobblestone_bricks_stonecutting" | "supplementaries:recipes/decorations/sign_post_spruce" | "caveopolis:recipes/building_blocks/brown_colored_stone_stairs" | "minecraft:recipes/heart_pottery_sherd" | "caveopolis:recipes/redstone/white_colored_stone_button" | "minecraft:recipes/building_blocks/oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "oceansdelight:recipes/cooked_guardian_tail" | "caveopolis:recipes/misc/lime_colored_stone_wall" | "storagedrawers:recipes/storagedrawers/controller" | "minecraft:recipes/building_blocks/dye_green_bed" | "supplementaries:recipes/candle_holders/candle_holder_pink_dye" | "caveopolis:recipes/decorations/lime_colored_hanging_sign" | "caveopolis:recipes/building_blocks/red_colored_wooden_planks" | "minecraft:recipes/decorations/brown_candle" | "minecraft:recipes/building_blocks/quartz_pillar" | "minecraft:husbandry/wax_on" | "minecraft:recipes/building_blocks/purple_terracotta" | "alltheores:recipes/misc/steel_dust_from_alloy_blending" | "supplementaries:recipes/flags/flag_light_blue" | "minecraft:recipes/sunflower" | "minecraft:adventure/play_jukebox_in_meadows" | "caveopolis:recipes/misc/red_colored_wooden_plank_button_from_red_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/constantan_ingot" | "caveopolis:recipes/decorations/green_colored_hanging_sign" | "minecraft:recipes/misc/green_dye" | "minecraft:recipes/decorations/magenta_bed" | "minecraft:recipes/redstone/honey_block" | "minecraft:recipes/building_blocks/dark_prismarine" | "aquamirae:recipes/pirate_pouch" | "minecraft:adventure/hero_of_the_village" | "alltheores:recipes/misc/uranium_dust_from_hammer_ingot_crushing" | "minecraft:recipes/redstone/redstone" | "caveopolis:recipes/decorations/light_blue_colored_wooden_plank_fence" | "minecraft:recipes/building_blocks/smooth_stone" | "alltheores:recipes/misc/copper_gear" | "minecraft:recipes/misc/coast_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/dye_pink_carpet" | "caveopolis:recipes/misc/cyan_colored_wooden_plank_pressure_plate_from_cyan_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/green_colored_wooden_plank_slab_from_green_colored_wooden_planks_stonecutting" | "storagedrawers:recipes/storagedrawers/crimson_drawers" | "alltheores:recipes/misc/invar_ore_hammer" | "caveopolis:recipes/redstone/brown_colored_wooden_plank_trapdoor" | "minecraft:recipes/building_blocks/packed_ice" | "minecraft:recipes/transportation/spruce_boat" | "caveopolis:recipes/misc/brown_colored_stone_wall" | "minecraft:recipes/blade_pottery_sherd" | "supplementaries:recipes/pancake_fd" | "minecraft:recipes/building_blocks/quartz_stairs_from_quartz_block_stonecutting" | "minecraft:recipes/oak_sapling" | "minecraft:recipes/building_blocks/deepslate_tiles" | "caveopolis:recipes/misc/light_gray_colored_stone_brick_wall" | "caveopolis:recipes/misc/light_blue_colored_stone_brick_wall" | "caveopolis:recipes/misc/orange_colored_cobblestone_brick_stairs_from_orange_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/building_blocks/warped_hyphae" | "minecraft:recipes/redstone/jungle_button" | "smallships:recipes/transportation/acacia_brigg" | "farmersdelight:recipes/misc/canvas" | "minecraft:recipes/redstone/note_block" | "caveopolis:recipes/decorations/white_colored_wooden_plank_fence" | "caveopolis:recipes/misc/black_colored_wooden_plank_trapdoor_from_black_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/green_stained_glass_pane_from_glass_pane" | "caveopolis:recipes/building_blocks/magenta_colored_cobblestone_stairs" | "minecraft:recipes/decorations/crimson_hanging_sign" | "awesomedungeonocean:ocean_cage/find_during_storm" | "minecraft:recipes/decorations/lime_bed" | "industrialforegoing:recipes/misc/laser_lens_purple_recolor" | "farmersdelight:recipes/decorations/light_gray_canvas_sign" | "caveopolis:recipes/misc/light_gray_colored_stone_slab_from_light_gray_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/smooth_stone_slab" | "farmersdelight:recipes/food/cooked_mutton_chops_from_smoking" | "caveopolis:recipes/misc/black_colored_stone_slab" | "caveopolis:recipes/redstone/cyan_colored_wooden_plank_button" | "caveopolis:recipes/misc/light_blue_colored_cobblestone_slab_from_light_blue_colored_cobblestone_stonecutting" | "caveopolis:recipes/misc/red_colored_sign_from_red_colored_wooden_planks_stonecutting" | "caveopolis:recipes/redstone/black_colored_wooden_plank_door" | "minecraft:recipes/misc/beacon" | "sophisticatedbackpacks:recipes/misc/advanced_magnet_upgrade" | "minecraft:recipes/building_blocks/red_nether_bricks" | "caveopolis:recipes/redstone/white_colored_stone_pressure_plate" | "minecraft:recipes/decorations/cyan_carpet" | "minecraft:husbandry/root" | "caveopolis:recipes/building_blocks/gray_colored_stone_stairs" | "minecraft:recipes/transportation/birch_boat" | "minecraft:recipes/building_blocks/cut_copper_from_copper_block_stonecutting" | "caveopolis:recipes/building_blocks/white_colored_cobblestone_brick_stairs" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "caveopolis:recipes/misc/bright_shard_from_smelting_deepslate_bright_stone_ore" | "caveopolis:recipes/building_blocks/cyan_colored_cobblestone_brick_stairs" | "supplementaries:recipes/blackboard" | "farmersdelight:recipes/food/cod_roll" | "minecraft:recipes/redstone/crimson_trapdoor" | "minecraft:recipes/building_blocks/cherry_wood" | "minecraft:recipes/decorations/green_glazed_terracotta" | "supplementaries:recipes/building_blocks/cozy_home/sign_post_warped" | "minecraft:recipes/decorations/bamboo_sign" | "caveopolis:recipes/decorations/pink_colored_hanging_sign" | "alltheores:recipes/misc/lumium_plate" | "caveopolis:recipes/redstone/lime_colored_stone_pressure_plate" | "minecraft:recipes/building_blocks/blue_ice" | "minecraft:adventure/trade" | "minecraft:recipes/building_blocks/deepslate" | "industrialforegoing:recipes/misc/laser_lens_red_recolor" | "minecraft:recipes/decorations/white_carpet" | "alltheores:recipes/misc/uranium_ingot_from_ore_blasting" | "minecraft:recipes/transportation/cherry_chest_boat" | "caveopolis:recipes/misc/cobblestone_brick_slab" | "minecraft:recipes/building_blocks/red_sandstone_slab" | "minecraft:recipes/building_blocks/dark_prismarine_slab" | "minecraft:recipes/decorations/pink_stained_glass_pane_from_glass_pane" | "minecraft:recipes/building_blocks/jack_o_lantern" | "minecraft:recipes/transportation/birch_chest_boat" | "minecraft:recipes/decorations/glass_pane" | "alltheores:recipes/misc/sapphire_block" | "minecraft:recipes/decorations/purple_banner" | "minecraft:recipes/building_blocks/magenta_stained_glass" | "industrialforegoing:recipes/misc/dryrubber" | "farmersdelight:recipes/decorations/skillet" | "caveopolis:recipes/misc/pink_colored_wooden_plank_pressure_plate_from_pink_colored_wooden_planks_stonecutting" | "aquaculture:recipes/aquaculture/fishing_line" | "minecraft:recipes/transportation/oak_boat" | "suppsquared:recipes/decorations/item_shelf_cherry" | "minecraft:recipes/brewer_pottery_sherd" | "supplementaries:recipes/stonecutting/blackstone_tile_slab" | "minecraft:recipes/arms_up_pottery_sherd" | "caveopolis:recipes/decorations/green_colored_sign" | "minecraft:recipes/building_blocks/bamboo_mosaic_stairs" | "minecraft:recipes/building_blocks/smooth_stone_slab_from_smooth_stone_stonecutting" | "caveopolis:recipes/misc/black_colored_stone_wall_from_black_colored_stone_stonecutting" | "alltheores:recipes/misc/zinc_ingot_from_slate_ore_blasting" | "minecraft:recipes/decorations/deepslate_tile_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "minecraft:recipes/misc/paper" | "aquaculture:recipes/misc/tin_can_to_iron_nugget_from_blasting" | "caveopolis:recipes/misc/magenta_colored_stone_slab" | "caveopolis:recipes/misc/pink_spray_can" | "minecraft:recipes/soul_sand" | "alltheores:recipes/misc/zinc_ingot" | "minecraft:recipes/redstone/warped_button" | "minecraft:recipes/ancient_debris" | "minecraft:husbandry/kill_axolotl_target" | "minecraft:recipes/decorations/stone_brick_wall_from_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/red_nether_brick_stairs" | "caveopolis:recipes/misc/orange_colored_wooden_plank_stairs_from_orange_colored_wooden_planks_stonecutting" | "caveopolis:recipes/building_blocks/yellow_colored_wooden_planks" | "caveopolis:recipes/misc/light_blue_colored_cobblestone_wall" | "caveopolis:recipes/misc/white_colored_cobblestone_stairs_from_white_colored_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/warped_stairs" | "minecraft:recipes/building_blocks/white_stained_glass" | "farmersdelight:recipes/food/bread_from_smoking" | "supplementaries:recipes/flint_block_uncrafting" | "minecraft:recipes/decorations/blue_glazed_terracotta" | "farmersdelight:recipes/cooking/cooked_rice" | "minecraft:recipes/building_blocks/mossy_cobblestone_from_moss_block" | "minecraft:recipes/building_blocks/andesite_slab_from_andesite_stonecutting" | "minecraft:recipes/redstone/acacia_fence_gate" | "minecraft:recipes/building_blocks/coal_block" | "storagedrawers:recipes/storagedrawers/spruce_drawers" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs_from_honeycomb" | "caveopolis:recipes/misc/bright_shard_from_blasting_deepslate_bright_stone_ore" | "minecraft:recipes/building_blocks/spruce_slab" | "minecraft:recipes/decorations/polished_blackstone_wall_from_blackstone_stonecutting" | "supplementaries:recipes/soap/blackboard" | "alltheores:recipes/misc/lead_ingot_from_block" | "caveopolis:recipes/misc/blue_colored_wooden_plank_fence_gate_from_blue_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/zinc_ingot_from_ore" | "minecraft:recipes/tools/lead" | "minecraft:recipes/decorations/warped_sign" | "farmersdelight:recipes/cooking/fried_rice" | "caveopolis:recipes/building_blocks/stripped_cyan_colored_wood" | "alltheores:recipes/misc/lead_nugget_from_ingot" | "minecraft:recipes/angler_pottery_sherd" | "minecraft:recipes/decorations/white_stained_glass_pane_from_glass_pane" | "supplementaries:recipes/candle_holders/candle_holder_green_dye" | "alltheores:recipes/misc/iridium_ingot_from_dust_blasting" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "caveopolis:recipes/building_blocks/brown_colored_cobblestone_bricks" | "minecraft:recipes/emerald" | "sophisticatedbackpacks:recipes/misc/advanced_filter_upgrade" | "minecraft:recipes/redstone/bamboo_door" | "minecraft:recipes/decorations/lodestone" | "alltheores:recipes/misc/iridium_plate" | "minecraft:recipes/misc/shaper_armor_trim_smithing_template_smithing_trim" | "caveopolis:recipes/building_blocks/light_gray_colored_cobblestone_brick_stairs" | "caveopolis:recipes/misc/white_colored_stone_pressure_plate_from_white_colored_stone_stonecutting" | "alltheores:recipes/misc/electrum_rod" | "caveopolis:recipes/misc/orange_colored_stone_slab_from_orange_colored_stone_stonecutting" | "caveopolis:recipes/misc/light_gray_colored_cobblestone_wall" | "caveopolis:recipes/misc/orange_colored_cobblestone_stairs_from_orange_colored_cobblestone_stonecutting" | "supplementaries:recipes/candle_holders/candle_holder_brown" | "supplementaries:recipes/goblet" | "alltheores:recipes/misc/uranium_ingot_from_slate_ore_blasting" | "caveopolis:recipes/misc/blue_colored_cobblestone_wall_from_blue_colored_cobblestone_stonecutting" | "minecraft:recipes/redstone/oak_button" | "caveopolis:recipes/misc/blue_colored_cobblestone_brick_slab" | "supplementaries:recipes/lapis_brick_slab" | "minecraft:adventure/honey_block_slide" | "caveopolis:recipes/misc/marble_bricks_from_marble_stonecutting" | "minecraft:recipes/redstone/dark_oak_pressure_plate" | "caveopolis:recipes/redstone/gray_colored_wooden_plank_door" | "minecraft:recipes/building_blocks/smooth_quartz_stairs_from_smooth_quartz_stonecutting" | "supplementaries:husbandry/sus_stew" | "minecraft:recipes/misc/vex_armor_trim_smithing_template" | "caveopolis:recipes/misc/gray_colored_stone_slab" | "caveopolis:recipes/misc/yellow_colored_stone_crafting_table" | "caveopolis:recipes/misc/white_colored_stone_brick_wall" | "minecraft:recipes/misc/iron_ingot_from_smelting_deepslate_iron_ore" | "caveopolis:recipes/redstone/black_colored_stone_button" | "minecraft:recipes/decorations/nether_brick_fence" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_blackstone_stonecutting" | "caveopolis:recipes/building_blocks/purple_colored_wooden_plank_stairs" | "caveopolis:recipes/misc/green_colored_wooden_plank_crafting_table" | "minecraft:recipes/misc/magenta_dye_from_allium" | "minecraft:recipes/misc/wayfinder_armor_trim_smithing_template_smithing_trim" | "caveopolis:recipes/building_blocks/yellow_colored_stone_stairs" | "minecraft:recipes/decorations/decorated_pot_simple" | "minecraft:recipes/building_blocks/cracked_deepslate_tiles" | "caveopolis:recipes/misc/purple_colored_stone_stairs_from_purple_colored_stone_stonecutting" | "smallships:recipes/transportation/mangrove_galley" | "sophisticatedbackpacks:recipes/misc/inception_upgrade" | "caveopolis:recipes/building_blocks/black_colored_wooden_plank_stairs" | "minecraft:recipes/building_blocks/exposed_cut_copper" | "minecraft:recipes/building_blocks/weathered_cut_copper_slab" | "minecraft:recipes/decorations/stone_brick_walls_from_stone_stonecutting" | "caveopolis:recipes/misc/gray_colored_wooden_plank_door_from_gray_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/bright_shard_from_smelting_bright_stone_ore" | "aquaculture:recipes/aquaculture/iron_hook" | "alltheores:recipes/misc/zinc_ingot_from_raw_blasting" | "minecraft:recipes/redstone/daylight_detector" | "minecraft:recipes/misc/diamond_from_blasting_deepslate_diamond_ore" | "awesomedungeonocean:root" | "minecraft:recipes/building_blocks/dye_purple_bed" | "minecraft:recipes/redstone/jungle_fence_gate" | "minecraft:recipes/dragon_head" | "caveopolis:recipes/misc/purple_colored_stone_pressure_plate_from_purple_colored_stone_stonecutting" | "caveopolis:recipes/building_blocks/stripped_green_colored_wood" | "caveopolis:recipes/misc/brown_colored_wooden_plank_door_from_brown_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/dye_light_gray_carpet" | "caveopolis:recipes/building_blocks/green_colored_stone_stairs" | "minecraft:recipes/redstone/warped_door" | "alltheores:recipes/misc/lumium_rod" | "sophisticatedbackpacks:recipes/misc/blasting_upgrade" | "supplementaries:recipes/sign_post_acacia" | "caveopolis:recipes/building_blocks/orange_colored_wooden_plank_stairs" | "minecraft:recipes/decorations/dark_oak_fence" | "minecraft:recipes/combat/diamond_boots" | "smallships:recipes/transportation/dark_oak_cog" | "caveopolis:recipes/misc/orange_colored_stone_brick_stairs_from_orange_colored_stone_bricks_stonecutting" | "caveopolis:recipes/misc/lime_colored_cobblestone_brick_stairs_from_lime_colored_cobblestone_bricks_stonecutting" | "alltheores:recipes/misc/lumium_ingot_from_block" | "caveopolis:recipes/misc/red_colored_wooden_plank_trapdoor_from_red_colored_wooden_planks_stonecutting" | "farmersdelight:recipes/decorations/warped_cabinet" | "minecraft:recipes/pufferfish" | "smallships:recipes/transportation/birch_drakkar" | "caveopolis:recipes/misc/magenta_colored_cobblestone_brick_wall" | "caveopolis:recipes/misc/purple_colored_stone_brick_slab" | "alltheores:recipes/misc/uranium_ingot_from_slate_ore" | "caveopolis:recipes/building_blocks/brown_colored_stone_brick_stairs" | "minecraft:recipes/combat/iron_sword" | "minecraft:recipes/redstone/observer" | "caveopolis:recipes/misc/red_colored_stone_wall" | "minecraft:recipes/misc/light_gray_dye_from_white_tulip" | "minecraft:recipes/tools/iron_pickaxe" | "caveopolis:recipes/building_blocks/red_colored_cobblestone" | "aquamirae:recipes/oxygelium" | "caveopolis:recipes/misc/purple_colored_cobblestone_stairs_from_purple_colored_cobblestone_stonecutting" | "caveopolis:recipes/misc/orange_colored_cobblestone_brick_wall" | "minecraft:recipes/building_blocks/polished_granite_stairs" | "oceansdelight:recipes/oceansdelight/tentacle_on_a_stick" | "minecraft:recipes/building_blocks/dark_oak_slab" | "alltheores:recipes/misc/steel_ingot_from_dust_blasting" | "minecraft:recipes/transportation/mangrove_boat" | "supplementaries:recipes/daub_brace" | "minecraft:recipes/decorations/torch" | "caveopolis:recipes/misc/green_spray_can" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "supplementaries:recipes/flags/flag_blue" | "caveopolis:recipes/misc/black_colored_wooden_plank_slab" | "supplementaries:recipes/iron_gate" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_stonecutting" | "caveopolis:recipes/misc/yellow_colored_cobblestone_slab" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "caveopolis:recipes/redstone/yellow_colored_stone_pressure_plate" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_honeycomb" | "caveopolis:recipes/misc/orange_colored_stone_brick_slab_from_orange_colored_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/dark_oak_planks" | "minecraft:recipes/transportation/detector_rail" | "alltheores:recipes/misc/enderium_plate" | "framedcompactdrawers:recipes/misc/framed_full_four" | "minecraft:recipes/lily_of_the_valley" | "minecraft:recipes/combat/shield" | "minecraft:recipes/building_blocks/red_sandstone_stairs" | "aquamirae:recipes/oxygen_tank" | "aquaculture:recipes/aquaculture/nether_star_hook" | "alltheores:recipes/misc/silver_ingot_from_slate_ore" | "alltheores:recipes/misc/platinum_ingot_from_slate_ore" | "alltheores:recipes/misc/ruby_from_block" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_polished_deepslate_stonecutting" | "aquaculture:recipes/tools/neptunium_hoe" | "alltheores:recipes/misc/tin_dust_from_hammer_crushing" | "caveopolis:recipes/building_blocks/yellow_colored_stone_brick_stairs" | "minecraft:recipes/misc/dune_armor_trim_smithing_template" | "minecraft:recipes/decorations/magenta_carpet" | "minecraft:recipes/misc/creeper_banner_pattern" | "alltheores:recipes/misc/lumium_block" | "caveopolis:recipes/misc/yellow_colored_stone_stairs_from_yellow_colored_stone_stonecutting" | "caveopolis:recipes/building_blocks/light_blue_colored_wooden_plank_stairs" | "alltheores:recipes/misc/raw_silver_from_block" | "minecraft:recipes/building_blocks/andesite_stairs_from_andesite_stonecutting" | "caveopolis:recipes/building_blocks/green_colored_stone_brick_stairs" | "minecraft:recipes/decorations/iron_bars" | "alltheores:recipes/misc/nickel_ingot_from_raw_blasting" | "caveopolis:recipes/misc/stone_torch" | "caveopolis:recipes/misc/pink_colored_wooden_plank_fence_from_pink_colored_wooden_planks_stonecutting" | "minecraft:recipes/misc/copper_ingot" | "alltheores:recipes/misc/nickel_ingot_from_raw" | "minecraft:recipes/building_blocks/dye_purple_wool" | "minecraft:recipes/transportation/chest_minecart" | "minecraft:recipes/building_blocks/spruce_planks" | "aquaculture:recipes/misc/jellyfish_to_slimeball" | "minecraft:recipes/building_blocks/netherite_block" | "minecraft:recipes/building_blocks/polished_diorite_slab" | "minecraft:recipes/decorations/red_carpet" | "caveopolis:recipes/misc/brown_colored_cobblestone_slab" | "minecraft:recipes/misc/wild_armor_trim_smithing_template" | "awesomedungeonocean:ocean_quad/find_during_rain" | "alltheores:recipes/misc/lead_ingot_from_ore" | "supplementaries:recipes/candle_holders/candle_holder_black" | "alltheores:recipes/misc/osmium_ingot_from_slate_ore" | "caveopolis:recipes/misc/red_colored_wooden_plank_fence_gate_from_red_colored_wooden_planks_stonecutting" | "minecraft:recipes/transportation/dark_oak_chest_boat" | "caveopolis:recipes/redstone/purple_colored_wooden_plank_trapdoor" | "caveopolis:recipes/misc/orange_colored_stone_brick_wall_from_orange_colored_stone_bricks_stonecutting" | "caveopolis:recipes/building_blocks/black_colored_cobblestone" | "minecraft:recipes/building_blocks/stone_brick_stairs_from_stone_stonecutting" | "minecraft:recipes/horn_coral_fan" | "minecraft:recipes/oxeye_daisy" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "minecraft:recipes/building_blocks/mud_brick_slab" | "caveopolis:recipes/redstone/light_blue_colored_wooden_plank_door" | "minecraft:adventure/lightning_rod_with_villager_no_fire" | "minecraft:recipes/misc/host_armor_trim_smithing_template" | "caveopolis:recipes/decorations/red_colored_hanging_sign" | "aquamirae:recipes/wisteria_niveis" | "sophisticatedbackpacks:recipes/misc/advanced_tool_swapper_upgrade" | "caveopolis:recipes/misc/green_colored_wooden_plank_fence_from_green_colored_wooden_planks_stonecutting" | "suppsquared:recipes/decorations/item_shelf_jungle" | "caveopolis:recipes/misc/brown_colored_cobblestone_wall_from_brown_colored_cobblestone_stonecutting" | "minecraft:recipes/brewing/glistering_melon_slice" | "minecraft:recipes/misc/light_gray_dye_from_azure_bluet" | "caveopolis:recipes/building_blocks/light_blue_colored_cobblestone_brick_stairs" | "minecraft:recipes/building_blocks/cracked_nether_bricks" | "minecraft:recipes/building_blocks/polished_deepslate_slab_from_cobbled_deepslate_stonecutting" | "storagedrawers:recipes/storagedrawers/redstone_upgrade" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "alltheores:recipes/misc/steel_plate" | "caveopolis:recipes/decorations/black_colored_sign" | "caveopolis:recipes/misc/light_blue_colored_cobblestone_brick_stairs_from_light_blue_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/misc/wild_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/smooth_quartz" | "caveopolis:recipes/decorations/yellow_colored_hanging_sign" | "farmersdelight:recipes/decorations/cherry_cabinet" | "aquamirae:recipes/fin" | "caveopolis:recipes/misc/red_colored_hanging_sign_from_stripped_red_colored_log_stonecutting" | "storagedrawers:recipes/storagedrawers/spruce_trim" | "alltheores:recipes/misc/uranium_ingot_from_raw" | "aquaculture:recipes/tools/neptunium_shovel" | "caveopolis:recipes/misc/orange_colored_stone_crafting_table" | "minecraft:recipes/decorations/blue_stained_glass_pane" | "caveopolis:recipes/redstone/cyan_colored_wooden_plank_pressure_plate" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab_from_waxed_exposed_copper_stonecutting" | "supplementaries:recipes/notice_board" | "minecraft:adventure/craft_decorated_pot_using_only_sherds" | "caveopolis:recipes/misc/purple_colored_stone_crafting_table" | "minecraft:recipes/decorations/polished_deepslate_wall_from_polished_deepslate_stonecutting" | "minecraft:recipes/food/cooked_salmon_from_smoking" | "caveopolis:recipes/building_blocks/orange_colored_cobblestone_brick_stairs" | "minecraft:recipes/tools/netherite_shovel_smithing" | "supplementaries:recipes/lapis_brick_wall" | "minecraft:recipes/brewing/glass_bottle" | "supplementaries:recipes/crystal_display" | "aquaculture:recipes/aquaculture/redstone_hook" | "minecraft:recipes/decorations/acacia_hanging_sign" | "minecraft:recipes/building_blocks/dye_gray_carpet" | "caveopolis:recipes/misc/red_colored_stone_bricks_from_red_colored_stone_stonecutting" | "aquamirae:adventure/obtain_rune_of_the_storm" | "alltheores:recipes/misc/tin_ingot_from_raw_blasting" | "caveopolis:recipes/misc/pink_colored_cobblestone_slab_from_pink_colored_cobblestone_stonecutting" | "industrialforegoing:recipes/misc/laser_lens_gray_recolor" | "caveopolis:recipes/redstone/magenta_colored_wooden_plank_pressure_plate" | "caveopolis:recipes/building_blocks/yellow_colored_cobblestone_stairs" | "caveopolis:recipes/misc/brown_colored_stone_brick_slab" | "minecraft:recipes/decorations/red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "supplementaries:recipes/daub_frame" | "caveopolis:recipes/building_blocks/red_colored_wooden_plank_stairs" | "minecraft:recipes/misc/lime_dye_from_smelting" | "alltheores:recipes/misc/tin_plate" | "minecraft:recipes/building_blocks/blackstone_slab_from_blackstone_stonecutting" | "caveopolis:recipes/misc/yellow_colored_stone_brick_slab" | "minecraft:recipes/redstone/cherry_fence_gate" | "aquamirae:recipes/sea_stew" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_stairs" | "minecraft:recipes/building_blocks/chiseled_red_sandstone_from_red_sandstone_stonecutting" | "supplementaries:recipes/lapis_brick_stairs" | "caveopolis:recipes/misc/gray_colored_stone_brick_stairs_from_gray_colored_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/jungle_planks" | "farmersdelight:recipes/decorations/stove" | "caveopolis:recipes/misc/light_gray_colored_wooden_plank_fence_gate_from_light_gray_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/chiseled_quartz_block" | "caveopolis:recipes/misc/black_colored_wooden_plank_button_from_black_colored_wooden_planks_stonecutting" | "minecraft:recipes/redstone/bamboo_trapdoor" | "supplementaries:recipes/key" | "caveopolis:recipes/misc/purple_colored_cobblestone_slab" | "caveopolis:recipes/misc/gray_colored_wooden_plank_slab_from_gray_colored_wooden_planks_stonecutting" | "farmersdelight:recipes/decorations/oak_cabinet" | "farmersdelight:recipes/food/cooked_cod_slice" | "minecraft:recipes/calcite" | "caveopolis:recipes/building_blocks/light_gray_colored_wooden_plank_stairs" | "farmersdelight:main/get_mushroom_colony" | "caveopolis:recipes/misc/pink_colored_wooden_plank_door_from_pink_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/gray_colored_stone_brick_slab" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "caveopolis:recipes/misc/magenta_colored_wooden_plank_pressure_plate_from_magenta_colored_wooden_planks_stonecutting" | "caveopolis:recipes/building_blocks/black_colored_stone" | "minecraft:recipes/building_blocks/dye_light_blue_wool" | "minecraft:recipes/danger_pottery_sherd" | "caveopolis:recipes/misc/yellow_colored_stone_button_from_yellow_colored_stone_stonecutting" | "minecraft:recipes/redstone/sticky_piston" | "caveopolis:recipes/redstone/cyan_colored_stone_button" | "alltheores:recipes/misc/steel_gear" | "supplementaries:recipes/altimeter" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab" | "sophisticatedbackpacks:recipes/misc/smoking_upgrade_from_smelting_upgrade" | "smallships:recipes/transportation/dark_oak_drakkar" | "alltheores:recipes/misc/brass_dust_from_alloy_blending" | "minecraft:recipes/acacia_sapling" | "caveopolis:recipes/building_blocks/purple_colored_stone" | "alltheores:recipes/misc/bronze_nugget_from_ingot" | "igleelib:recipes/igleelib/derium_block" | "minecraft:recipes/brewing/fermented_spider_eye" | "minecraft:recipes/misc/iron_ingot_from_smelting_raw_iron" | "caveopolis:recipes/misc/cyan_colored_wooden_plank_door_from_cyan_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/deepslate_brick_slab_from_cobbled_deepslate_stonecutting" | "supplementaries:nether/goblet" | "caveopolis:recipes/building_blocks/cyan_colored_cobblestone_bricks" | "caveopolis:recipes/building_blocks/red_colored_stone_bricks" | "minecraft:recipes/misc/purple_dye" | "alltheores:recipes/misc/constantan_dust_from_alloy_blending" | "supplementaries:recipes/dispenser_minecart" | "supplementaries:recipes/sconce_lever" | "aquaculture:recipes/misc/gold_nugget_from_blasting" | "minecraft:recipes/building_blocks/waxed_cut_copper_from_waxed_copper_block_stonecutting" | "caveopolis:recipes/misc/blue_colored_stone_slab_from_blue_colored_stone_stonecutting" | "caveopolis:recipes/redstone/pink_colored_wooden_plank_fence_gate" | "alltheores:recipes/misc/raw_lead_from_block" | "minecraft:adventure/kill_mob_near_sculk_catalyst" | "minecraft:recipes/building_blocks/dried_kelp_block" | "minecraft:recipes/building_blocks/end_stone_brick_slab_from_end_stone_brick_stonecutting" | "minecraft:recipes/building_blocks/quartz_bricks_from_quartz_block_stonecutting" | "alltheores:recipes/misc/iron_dust_from_hammer_crushing" | "aquamirae:recipes/ship_graveyard_echo" | "minecraft:recipes/building_blocks/waxed_oxidized_copper_from_honeycomb" | "caveopolis:recipes/misc/blue_colored_stone_button_from_blue_colored_stone_stonecutting" | "farmersdelight:recipes/food/beef_patty_from_smoking" | "caveopolis:recipes/misc/blue_colored_cobblestone_stairs_from_blue_colored_cobblestone_stonecutting" | "farmersdelight:recipes/cooking/beef_stew" | "farmersdelight:recipes/food/cabbage" | "aquaculture:recipes/aquaculture/bobber" | "caveopolis:recipes/misc/red_colored_cobblestone_brick_wall_from_red_colored_cobblestone_bricks_stonecutting" | "caveopolis:recipes/redstone/light_blue_colored_wooden_plank_fence_gate" | "caveopolis:recipes/misc/cyan_colored_sign_from_cyan_colored_wooden_planks_stonecutting" | "caveopolis:recipes/redstone/gray_colored_wooden_plank_pressure_plate" | "minecraft:recipes/decorations/mangrove_fence" | "minecraft:recipes/building_blocks/dye_white_carpet" | "minecraft:recipes/building_blocks/white_terracotta" | "minecraft:recipes/food/cooked_mutton" | "caveopolis:recipes/misc/cyan_colored_cobblestone_brick_slab" | "minecraft:recipes/misc/white_dye_from_lily_of_the_valley" | "supplementaries:recipes/candle_holders/candle_holder_green" | "minecraft:recipes/building_blocks/deepslate_tile_stairs" | "minecraft:recipes/building_blocks/polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "minecraft:recipes/brown_mushroom" | "caveopolis:recipes/misc/black_colored_stone_brick_wall" | "caveopolis:recipes/misc/marble_slab" | "framedcompactdrawers:recipes/misc/framed_compact_drawer" | "alltheores:recipes/misc/platinum_ingot_from_slate_ore_blasting" | "minecraft:recipes/snowball" | "minecraft:recipes/building_blocks/dye_light_blue_bed" | "minecraft:recipes/decorations/lime_carpet" | "smallships:recipes/transportation/jungle_drakkar" | "alltheores:recipes/misc/osmium_ingot_from_slate_ore_blasting" | "alltheores:recipes/misc/constantan_nugget_from_ingot" | "minecraft:adventure/sniper_duel" | "farmersdelight:recipes/decorations/canvas_sign" | "minecraft:recipes/building_blocks/polished_andesite_stairs" | "minecraft:recipes/transportation/furnace_minecart" | "minecraft:recipes/building_blocks/stone_brick_slab_from_stone_bricks_stonecutting" | "minecraft:nether/root" | "minecraft:recipes/misc/spire_armor_trim_smithing_template" | "caveopolis:recipes/misc/cyan_colored_cobblestone_brick_wall_from_cyan_colored_cobblestone_bricks_stonecutting" | "alltheores:recipes/misc/platinum_plate" | "minecraft:recipes/sheaf_pottery_sherd" | "minecraft:recipes/building_blocks/stone_slab_from_stone_stonecutting" | "farmersdelight:recipes/misc/canvas_from_canvas_rug" | "caveopolis:recipes/misc/yellow_colored_cobblestone_wall_from_yellow_colored_cobblestone_stonecutting" | "caveopolis:recipes/building_blocks/cyan_colored_wood" | "oceansdelight:recipes/food/elder_guardian_roll" | "minecraft:recipes/bubble_coral_block" | "minecraft:recipes/tools/flint_and_steel" | "minecraft:recipes/building_blocks/dye_purple_carpet" | "caveopolis:recipes/misc/gray_colored_wooden_plank_trapdoor_from_gray_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/nether_bricks" | "minecraft:recipes/beetroot_seeds" | "caveopolis:recipes/misc/mixed_stone_ingot_from_smelting_deepslate_mixed_stone_ore" | "minecraft:recipes/decorations/end_stone_brick_wall_from_end_stone_brick_stonecutting" | "caveopolis:recipes/misc/pink_colored_hanging_sign_from_stripped_pink_colored_log_stonecutting" | "minecraft:recipes/misc/sugar_from_sugar_cane" | "caveopolis:recipes/misc/light_blue_colored_stone_bricks_from_light_blue_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/dye_magenta_bed" | "caveopolis:recipes/building_blocks/pink_colored_stone_brick_stairs" | "minecraft:recipes/decorations/respawn_anchor" | "alltheores:recipes/misc/raw_osmium_block" | "aquaculture:recipes/misc/gold_nugget_from_gold_fish" | "minecraft:recipes/decorations/white_banner" | "alltheores:recipes/misc/lumium_dust_from_alloy_blending" | "minecraft:recipes/saddle" | "supplementaries:recipes/deepslate_lamp" | "aquaculture:recipes/food/cooked_fish_fillet_from_smoking" | "alltheores:recipes/misc/copper_ore_hammer" | "minecraft:recipes/decorations/mossy_cobblestone_wall" | "minecraft:nether/get_wither_skull" | "caveopolis:recipes/misc/green_colored_cobblestone_brick_wall" | "minecraft:recipes/building_blocks/dye_magenta_wool" | "alltheores:recipes/misc/peridot_from_block" | "minecraft:recipes/decorations/diorite_wall_from_diorite_stonecutting" | "farmersdelight:recipes/misc/straw" | "caveopolis:recipes/misc/black_colored_cobblestone_wall" | "caveopolis:recipes/building_blocks/lime_colored_stone_bricks" | "alltheores:recipes/misc/bronze_ingot_from_dust" | "smallships:recipes/transportation/birch_brigg" | "minecraft:recipes/dandelion" | "minecraft:recipes/tools/wooden_pickaxe" | "minecraft:recipes/building_blocks/cobbled_deepslate_stairs" | "minecraft:recipes/building_blocks/mossy_stone_brick_stairs" | "caveopolis:recipes/building_blocks/pink_colored_cobblestone_stairs" | "caveopolis:recipes/redstone/yellow_colored_wooden_plank_button" | "caveopolis:recipes/misc/pink_colored_cobblestone_wall_from_pink_colored_cobblestone_stonecutting" | "caveopolis:recipes/building_blocks/brown_colored_cobblestone_brick_stairs" | "industrialforegoing:recipes/misc/laser_lens_yellow_recolor" | "minecraft:recipes/building_blocks/dark_oak_wood" | "aquaculture:recipes/tools/diamond_fishing_rod" | "caveopolis:recipes/misc/white_colored_cobblestone_brick_wall" | "minecraft:recipes/building_blocks/chiseled_polished_blackstone_from_polished_blackstone_stonecutting" | "caveopolis:recipes/building_blocks/yellow_colored_stone_bricks" | "minecraft:recipes/building_blocks/polished_blackstone" | "minecraft:recipes/misc/diamond_from_smelting_diamond_ore" | "alltheores:recipes/misc/nickel_ingot_from_block" | "caveopolis:recipes/redstone/pink_colored_wooden_plank_button" | "farmersdelight:main/root" | "farmersdelight:recipes/food/mixed_salad" | "minecraft:recipes/food/baked_potato_from_smoking" | "alltheores:recipes/misc/tin_ingot_from_ore" | "supplementaries:recipes/stonecutting/lapis_brick_slab_from_bricks" | "caveopolis:recipes/building_blocks/lime_colored_stone" | "minecraft:recipes/building_blocks/smooth_sandstone_stairs" | "smallships:recipes/transportation/acacia_drakkar" | "minecraft:recipes/decorations/black_stained_glass_pane_from_glass_pane" | "alltheores:recipes/misc/bronze_dust_from_alloy_blending" | "suppsquared:recipes/decorations/item_shelf_spruce" | "minecraft:recipes/decorations/red_candle" | "minecraft:recipes/misc/lapis_lazuli" | "caveopolis:recipes/misc/purple_colored_stone_brick_wall_from_purple_colored_stone_bricks_stonecutting" | "supplementaries:recipes/flags/flag_cyan" | "caveopolis:recipes/misc/red_colored_cobblestone_brick_stairs_from_red_colored_cobblestone_bricks_stonecutting" | "minecraft:story/upgrade_tools" | "farmersdelight:recipes/building_blocks/packed_mud_from_straw" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_stairs_from_waxed_exposed_cut_copper_stonecutting" | "minecraft:recipes/sniffer_egg" | "farmersdelight:recipes/decorations/painting_from_canvas" | "caveopolis:recipes/misc/green_colored_stone_bricks_from_green_colored_stone_stonecutting" | "supplementaries:recipes/stone_tile_stairs" | "caveopolis:recipes/misc/gray_colored_stone_pressure_plate_from_gray_colored_stone_stonecutting" | "minecraft:recipes/misc/eye_armor_trim_smithing_template" | "caveopolis:recipes/misc/blue_colored_cobblestone_slab_from_blue_colored_cobblestone_stonecutting" | "alltheores:recipes/misc/brass_rod" | "caveopolis:recipes/misc/red_colored_cobblestone_slab_from_red_colored_cobblestone_stonecutting" | "farmersdelight:main/master_chef" | "minecraft:recipes/misc/sentry_armor_trim_smithing_template_smithing_trim" | "caveopolis:recipes/misc/mixed_stone_ingot_from_smelting_mixed_stone_ore" | "farmersdelight:main/use_cutting_board" | "caveopolis:recipes/misc/brown_colored_cobblestone_brick_slab_from_brown_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/building_blocks/waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "farmersdelight:recipes/cooking/bone_broth" | "minecraft:husbandry/tactical_fishing" | "caveopolis:recipes/misc/white_colored_cobblestone_brick_wall_from_white_colored_cobblestone_bricks_stonecutting" | "caveopolis:recipes/misc/red_colored_stone_brick_stairs_from_red_colored_stone_bricks_stonecutting" | "minecraft:adventure/salvage_sherd" | "caveopolis:recipes/misc/gray_colored_cobblestone_slab" | "caveopolis:recipes/misc/black_colored_cobblestone_brick_stairs_from_black_colored_cobblestone_bricks_stonecutting" | "aquaculture:recipes/food/cooked_fish_fillet" | "caveopolis:recipes/decorations/pink_colored_wooden_plank_fence" | "caveopolis:recipes/misc/magenta_colored_cobblestone_brick_wall_from_magenta_colored_cobblestone_bricks_stonecutting" | "supplementaries:recipes/sign_post_bamboo" | "minecraft:story/cure_zombie_villager" | "caveopolis:recipes/building_blocks/white_colored_cobblestone_stairs" | "storagedrawers:recipes/storagedrawers/quantify_key" | "farmersdelight:recipes/misc/gold_nugget_from_blasting_knife" | "oceansdelight:recipes/cooked_stuffed_cod" | "alltheores:recipes/misc/ruby_from_hammer_crushing" | "alltheores:recipes/misc/lead_gear" | "caveopolis:recipes/misc/pink_colored_cobblestone_brick_slab" | "minecraft:recipes/redstone/mangrove_trapdoor" | "minecraft:recipes/tools/recovery_compass" | "alltheores:recipes/misc/uranium_dust_from_hammer_crushing" | "caveopolis:recipes/misc/red_colored_stone_slab_from_red_colored_stone_stonecutting" | "sophisticatedbackpacks:recipes/misc/upgrade_base" | "caveopolis:recipes/misc/brown_colored_cobblestone_brick_wall" | "minecraft:recipes/redstone/oak_pressure_plate" | "caveopolis:recipes/building_blocks/gray_colored_stone_brick_stairs" | "aquaculture:recipes/tools/neptunium_pickaxe" | "supplementaries:recipes/sugar_cube" | "farmersdelight:recipes/decorations/bamboo_cabinet" | "supplementaries:husbandry/soap" | "minecraft:recipes/building_blocks/polished_blackstone_stairs_from_polished_blackstone_stonecutting" | "storagedrawers:recipes/storagedrawers/dark_oak_trim" | "caveopolis:recipes/misc/white_colored_stone_brick_slab_from_white_colored_stone_bricks_stonecutting" | "minecraft:recipes/redstone/dropper" | "minecraft:recipes/echo_shard" | "supplementaries:recipes/candle_holders/candle_holder_light_blue_dye" | "minecraft:end/find_end_city" | "caveopolis:recipes/misc/cyan_colored_cobblestone_brick_slab_from_cyan_colored_cobblestone_bricks_stonecutting" | "minecraft:recipes/redstone/mangrove_fence_gate" | "minecraft:recipes/potato" | "caveopolis:recipes/redstone/magenta_colored_stone_pressure_plate" | "caveopolis:recipes/misc/orange_colored_stone_bricks_from_orange_colored_stone_stonecutting" | "alltheores:recipes/misc/tin_ingot_from_ore_blasting" | "caveopolis:recipes/building_blocks/purple_colored_stone_brick_stairs" | "minecraft:recipes/building_blocks/dye_light_blue_carpet" | "minecraft:recipes/building_blocks/polished_andesite" | "caveopolis:recipes/redstone/orange_colored_stone_button" | "alltheores:recipes/misc/brass_ingot_from_dust" | "minecraft:recipes/decorations/lime_glazed_terracotta" | "oceansdelight:recipes/cooked_elder_guardian_slice_from_campfire_cooking" | "minecraft:recipes/building_blocks/purpur_block" | "caveopolis:recipes/misc/light_blue_colored_wooden_plank_button_from_light_blue_colored_wooden_planks_stonecutting" | "supplementaries:recipes/flags/flag_yellow" | "caveopolis:recipes/misc/marble_brick_slab_from_marble_bricks_stonecutting" | "caveopolis:recipes/decorations/red_colored_sign" | "storagedrawers:recipes/storagedrawers/oak_trim" | "supplementaries:recipes/sign_post_mangrove" | "alltheores:recipes/misc/lead_rod" | "minecraft:recipes/gold_nugget" | "caveopolis:recipes/misc/blue_colored_stone_wall" | "smallships:recipes/transportation/cherry_galley" | "supplementaries:recipes/candle_holders/candle_holder" | "caveopolis:recipes/misc/red_colored_wooden_plank_slab" | "alltheores:recipes/misc/electrum_ingot_from_block" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "minecraft:recipes/transportation/carrot_on_a_stick" | "caveopolis:recipes/building_blocks/blue_colored_cobblestone_bricks" | "caveopolis:recipes/misc/green_colored_wooden_plank_slab" | "farmersdelight:recipes/misc/pumpkin_seeds_from_slice" | "awesomedungeonocean:ocean_temple_quad/find_during_rain" | "caveopolis:recipes/redstone/lime_colored_wooden_plank_button" | "minecraft:recipes/building_blocks/polished_granite" | "framedcompactdrawers:recipes/misc/framed_full_two" | "farmersdelight:main/use_skillet" | "minecraft:recipes/redstone/birch_trapdoor" | "alltheores:recipes/misc/bronze_ingot_from_block" | "farmersdelight:main/eat_nourishing_food" | "caveopolis:recipes/misc/stone_crafting_table" | "caveopolis:recipes/redstone/blue_colored_wooden_plank_pressure_plate" | "storagedrawers:recipes/storagedrawers/emerald_storage_upgrade" | "minecraft:recipes/redstone/spruce_trapdoor" | "supplementaries:recipes/slice_map" | "minecraft:recipes/building_blocks/muddy_mangrove_roots" | "minecraft:recipes/building_blocks/red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:recipes/misc/quartz" | "storagedrawers:recipes/storagedrawers/obsidian_storage_upgrade" | "minecraft:end/respawn_dragon" | "oceansdelight:recipes/baked_tentacle_on_a_stick_from_smoking" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "minecraft:recipes/decorations/soul_campfire" | "sophisticatedbackpacks:recipes/misc/copper_backpack" | "caveopolis:recipes/misc/yellow_colored_stone_slab" | "caveopolis:recipes/misc/magenta_colored_wooden_plank_trapdoor_from_magenta_colored_wooden_planks_stonecutting" | "farmersdelight:recipes/decorations/yellow_hanging_canvas_sign" | "caveopolis:recipes/misc/orange_colored_stone_stairs_from_orange_colored_stone_stonecutting" | "caveopolis:recipes/misc/cyan_colored_wooden_plank_fence_gate_from_cyan_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/warped_slab" | "nec:recipes/decorations/acacia_chest" | "minecraft:recipes/food/cooked_mutton_from_campfire_cooking" | "caveopolis:recipes/building_blocks/orange_colored_stone_stairs" | "alltheores:recipes/misc/electrum_plate" | "farmersdelight:recipes/decorations/light_gray_hanging_canvas_sign" | "alltheores:recipes/misc/brass_block" | "caveopolis:recipes/misc/cyan_colored_stone_bricks_from_cyan_colored_stone_stonecutting" | "farmersdelight:main/harvest_straw" | "caveopolis:recipes/building_blocks/light_blue_colored_stone" | "minecraft:recipes/diamond" | "caveopolis:recipes/misc/white_colored_cobblestone_wall_from_white_colored_cobblestone_stonecutting" | "minecraft:recipes/redstone/spruce_door" | "caveopolis:recipes/misc/pink_colored_cobblestone_bricks_from_pink_colored_cobblestone_stonecutting" | "supplementaries:recipes/netherite_door" | "caveopolis:recipes/misc/red_spray_can" | "supplementaries:recipes/building_blocks/cozy_home/sign_post_cherry" | "caveopolis:recipes/misc/lime_colored_cobblestone_wall_from_lime_colored_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/crimson_hyphae" | "minecraft:recipes/building_blocks/dye_orange_wool" | "minecraft:recipes/building_blocks/yellow_concrete_powder" | "minecraft:recipes/redstone/spruce_fence_gate" | "farmersdelight:recipes/decorations/scaffolding_from_canvas" | "farmersdelight:recipes/cooking/pasta_with_mutton_chop" | "industrialforegoing:recipes/misc/laser_lens_lime_recolor" | "farmersdelight:recipes/decorations/purple_canvas_sign" | "minecraft:recipes/building_blocks/purple_stained_glass" | "minecraft:recipes/building_blocks/chiseled_stone_bricks_stone_from_stonecutting" | "minecraft:recipes/friend_pottery_sherd" | "aquaculture:recipes/combat/neptunium_chestplate" | "farmersdelight:recipes/decorations/white_canvas_sign" | "caveopolis:recipes/decorations/light_blue_colored_sign" | "caveopolis:recipes/misc/blue_colored_stone_brick_slab_from_blue_colored_stone_bricks_stonecutting" | "caveopolis:recipes/misc/light_gray_colored_wooden_plank_button_from_light_gray_colored_wooden_planks_stonecutting" | "farmersdelight:recipes/decorations/acacia_cabinet" | "supplementaries:recipes/flags/flag_light_gray" | "minecraft:recipes/decorations/blue_carpet" | "minecraft:recipes/misc/snout_armor_trim_smithing_template_smithing_trim" | "minecraft:recipes/building_blocks/dye_white_wool" | "alltheores:recipes/misc/osmium_ingot_from_raw" | "minecraft:recipes/decorations/light_blue_glazed_terracotta" | "farmersdelight:recipes/decorations/pink_canvas_sign" | "caveopolis:recipes/redstone/lime_colored_wooden_plank_pressure_plate" | "awesomedungeonocean:ocean_ruin_pillager/find_normal" | "caveopolis:recipes/misc/light_gray_colored_sign_from_light_gray_colored_wooden_planks_stonecutting" | "farmersdelight:recipes/decorations/rope_from_safety_net" | "minecraft:recipes/building_blocks/prismarine_stairs" | "supplementaries:recipes/ash_bricks" | "minecraft:recipes/building_blocks/polished_blackstone_from_blackstone_stonecutting" | "minecraft:recipes/explorer_pottery_sherd" | "alltheores:recipes/misc/zinc_ingot_from_slate_ore" | "minecraft:recipes/building_blocks/deepslate_tiles_from_polished_deepslate_stonecutting" | "caveopolis:recipes/misc/light_blue_colored_stone_pressure_plate_from_light_blue_colored_stone_stonecutting" | "caveopolis:recipes/misc/lime_colored_stone_slab" | "alltheores:recipes/misc/platinum_ingot_from_raw" | "supplementaries:recipes/candle_holders/candle_holder_purple_dye" | "minecraft:recipes/decorations/polished_blackstone_wall_from_polished_blackstone_stonecutting" | "farmersdelight:recipes/decorations/yellow_canvas_sign" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_slab_from_honeycomb" | "minecraft:recipes/building_blocks/deepslate_tiles_from_deepslate_bricks_stonecutting" | "caveopolis:recipes/misc/cyan_colored_stone_stairs_from_cyan_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/dripstone_block" | "minecraft:recipes/building_blocks/mangrove_wood" | "caveopolis:recipes/building_blocks/light_gray_colored_stone_bricks" | "minecraft:recipes/brain_coral_fan" | "minecraft:adventure/avoid_vibration" | "minecraft:recipes/misc/gold_ingot_from_smelting_nether_gold_ore" | "caveopolis:recipes/decorations/green_colored_wooden_plank_fence" | "alltheores:recipes/misc/copper_ingot_from_dust_blasting" | "farmersdelight:recipes/decorations/red_canvas_sign" | "framedcompactdrawers:recipes/misc/framed_half_two" | "minecraft:recipes/prismarine_shard" | "caveopolis:recipes/decorations/lime_colored_sign" | "caveopolis:recipes/misc/gray_colored_stone_bricks_from_gray_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/yellow_stained_glass" | "minecraft:recipes/misc/spire_armor_trim_smithing_template_smithing_trim" | "supplementaries:recipes/stonecutting/ash_brick_wall_from_bricks" | "minecraft:recipes/decorations/acacia_fence" | "minecraft:recipes/fire_coral_fan" | "minecraft:recipes/misc/iron_ingot_from_blasting_deepslate_iron_ore" | "minecraft:recipes/building_blocks/dye_brown_carpet" | "caveopolis:recipes/decorations/light_gray_colored_wooden_plank_fence" | "farmersdelight:recipes/decorations/red_hanging_canvas_sign" | "minecraft:recipes/redstone/mangrove_button" | "minecraft:nether/return_to_sender" | "farmersdelight:recipes/cooking/tomato_sauce" | "minecraft:recipes/suspicious_sand" | "minecraft:recipes/building_blocks/sandstone" | "alltheores:recipes/misc/iridium_ingot_from_slate_ore" | "caveopolis:recipes/misc/cobblestone_brick_wall" | "farmersdelight:recipes/cooking/ratatouille" | "caveopolis:recipes/misc/orange_colored_wooden_plank_door_from_orange_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/brass_gear" | "farmersdelight:recipes/misc/tomato_seeds" | "minecraft:recipes/building_blocks/polished_basalt_from_basalt_stonecutting" | "minecraft:recipes/building_blocks/white_wool_from_string" | "alltheores:recipes/misc/electrum_ingot_from_dust_blasting" | "caveopolis:recipes/building_blocks/light_blue_colored_cobblestone" | "caveopolis:recipes/misc/gray_colored_stone_stairs_from_gray_colored_stone_stonecutting" | "minecraft:recipes/decorations/yellow_banner" | "minecraft:recipes/blackstone" | "minecraft:recipes/decorations/brown_stained_glass_pane_from_glass_pane" | "minecraft:husbandry/obtain_sniffer_egg" | "smallships:recipes/transportation/cherry_brigg" | "smallships:recipes/transportation/spruce_brigg" | "supplementaries:recipes/candle_holders/candle_holder_blue_dye" | "minecraft:recipes/building_blocks/deepslate_brick_slab" | "minecraft:recipes/building_blocks/polished_diorite_stairs_from_polished_diorite_stonecutting" | "caveopolis:recipes/building_blocks/magenta_colored_cobblestone_brick_stairs" | "minecraft:recipes/decorations/brick_wall_from_bricks_stonecutting" | "minecraft:recipes/building_blocks/exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "awesomedungeonocean:ocean_ruin_pillager/find_during_night" | "alltheores:recipes/misc/aluminum_ingot_from_slate_ore" | "alltheores:recipes/misc/diamond_dust_from_hammer_crushing" | "minecraft:recipes/redstone/polished_blackstone_pressure_plate" | "farmersdelight:recipes/building_blocks/organic_compost_from_rotten_flesh" | "caveopolis:recipes/misc/magenta_colored_cobblestone_brick_slab_from_magenta_colored_cobblestone_bricks_stonecutting" | "caveopolis:recipes/misc/light_blue_colored_cobblestone_brick_wall_from_light_blue_colored_cobblestone_bricks_stonecutting" | "storagedrawers:recipes/storagedrawers/iron_storage_upgrade" | "farmersdelight:recipes/building_blocks/rice_bag" | "minecraft:recipes/food/cooked_cod_from_campfire_cooking" | "alltheores:recipes/misc/nickel_nugget_from_ingot" | "alltheores:recipes/misc/electrum_gear" | "caveopolis:recipes/misc/black_colored_wooden_plank_fence_from_black_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/magenta_stained_glass_pane_from_glass_pane" | "minecraft:recipes/misc/pink_dye_from_red_white_dye" | "caveopolis:recipes/misc/yellow_colored_wooden_plank_stairs_from_yellow_colored_wooden_planks_stonecutting" | "minecraft:recipes/brewing/blaze_powder" | "minecraft:recipes/redstone/jungle_pressure_plate" | "minecraft:end/root" | "alltheores:recipes/misc/aluminum_ingot_from_raw" | "aquamirae:adventure/abyssal_armor" | "awesomedungeonocean:ocean_ruin_vanilla_temple/find_during_storm" | "alltheores:recipes/misc/aluminum_ingot" | "sophisticatedbackpacks:recipes/misc/chipped/loom_table_upgrade" | "minecraft:recipes/misc/diamond_from_blasting_diamond_ore" | "minecraft:recipes/building_blocks/polished_blackstone_brick_slab_from_polished_blackstone_stonecutting" | "minecraft:recipes/decorations/moss_carpet" | "aquamirae:adventure/obtain_shell_horn" | "minecraft:recipes/building_blocks/polished_diorite_slab_from_polished_diorite_stonecutting" | "farmersdelight:recipes/food/stuffed_potato" | "supplementaries:recipes/stonecutting/blackstone_tile_stairs_from_bricks" | "minecraft:recipes/decorations/cyan_stained_glass_pane_from_glass_pane" | "minecraft:recipes/bucket" | "minecraft:recipes/decorations/blackstone_wall_from_blackstone_stonecutting" | "farmersdelight:recipes/food/fruit_salad" | "farmersdelight:recipes/decorations/light_blue_hanging_canvas_sign" | "caveopolis:recipes/misc/blue_colored_wooden_plank_button_from_blue_colored_wooden_planks_stonecutting" | "minecraft:recipes/redstone/crimson_fence_gate" | "aquaculture:recipes/combat/neptunium_boots" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper" | "minecraft:recipes/building_blocks/amethyst_block" | "alltheores:recipes/misc/invar_block" | "caveopolis:recipes/redstone/gray_colored_wooden_plank_button" | "supplementaries:recipes/candle_holders/candle_holder_cyan" | "minecraft:husbandry/obtain_netherite_hoe" | "minecraft:recipes/building_blocks/gray_concrete_powder" | "minecraft:recipes/decorations/light_gray_banner" | "supplementaries:recipes/flags/flag_red" | "strainers:recipes/misc/eroding_salt_mulch" | "caveopolis:recipes/misc/purple_colored_hanging_sign_from_stripped_purple_colored_log_stonecutting" | "minecraft:recipes/tools/iron_axe" | "minecraft:recipes/building_blocks/glowstone" | "minecraft:recipes/building_blocks/sea_lantern" | "alltheores:recipes/misc/diamond_plate" | "caveopolis:recipes/misc/light_blue_colored_cobblestone_brick_slab" | "caveopolis:recipes/misc/green_colored_stone_wall" | "caveopolis:recipes/misc/red_colored_stone_pressure_plate_from_red_colored_stone_stonecutting" | "supplementaries:recipes/sign_post_cherry" | "caveopolis:recipes/building_blocks/purple_colored_cobblestone_stairs" | "minecraft:recipes/white_tulip" | "caveopolis:recipes/misc/brown_colored_wooden_plank_trapdoor_from_brown_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/cartography_table" | "suppsquared:recipes/decorations/item_shelf_dark_oak" | "alltheores:recipes/misc/raw_lead_block" | "aquamirae:adventure/obtain_dagger_of_greed" | "minecraft:recipes/building_blocks/deepslate_tile_slab" | "minecraft:recipes/building_blocks/polished_diorite_from_diorite_stonecutting" | "farmersdelight:recipes/food/tomato" | "minecraft:recipes/building_blocks/chiseled_deepslate" | "minecraft:recipes/blue_orchid" | "minecraft:recipes/building_blocks/nether_brick_slab_from_nether_bricks_stonecutting" | "minecraft:recipes/misc/iron_nugget_from_blasting" | "sophisticatedbackpacks:recipes/misc/restock_upgrade" | "farmersdelight:recipes/food/mutton_wrap" | "minecraft:adventure/kill_a_mob" | "industrialforegoing:recipes/misc/laser_lens_blue_recolor" | "caveopolis:recipes/misc/brown_colored_cobblestone_stairs_from_brown_colored_cobblestone_stonecutting" | "sophisticatedbackpacks:recipes/misc/gold_backpack" | "caveopolis:recipes/building_blocks/yellow_colored_wooden_plank_stairs" | "caveopolis:recipes/misc/light_gray_colored_stone_stairs_from_light_gray_colored_stone_stonecutting" | "minecraft:husbandry/plant_any_sniffer_seed" | "oceansdelight:recipes/baked_tentacle_on_a_stick_from_campfire_cooking" | "alltheores:recipes/misc/zinc_ingot_from_raw" | "supplementaries:recipes/strings" | "caveopolis:recipes/misc/magenta_colored_stone_wall_from_magenta_colored_stone_stonecutting" | "caveopolis:recipes/misc/cyan_colored_wooden_plank_button_from_cyan_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/deepslate_bricks_from_cobbled_deepslate_stonecutting" | "minecraft:adventure/adventuring_time" | "farmersdelight:recipes/food/cooked_cod_slice_from_campfire_cooking" | "caveopolis:recipes/redstone/lime_colored_wooden_plank_door" | "minecraft:recipes/building_blocks/dye_cyan_carpet" | "caveopolis:recipes/misc/blue_colored_wooden_plank_stairs_from_blue_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/purple_colored_wooden_plank_pressure_plate_from_purple_colored_wooden_planks_stonecutting" | "alltheores:recipes/misc/silver_plate" | "supplementaries:recipes/jar" | "minecraft:recipes/clay_ball" | "caveopolis:recipes/misc/pink_colored_wooden_plank_slab" | "caveopolis:recipes/redstone/red_colored_stone_pressure_plate" | "oceansdelight:recipes/cooked_guardian_tail_from_campfire_cooking" | "caveopolis:recipes/misc/red_colored_stone_brick_slab_from_red_colored_stone_bricks_stonecutting" | "minecraft:husbandry/plant_seed" | "minecraft:nether/find_bastion" | "caveopolis:recipes/misc/green_colored_wooden_plank_button_from_green_colored_wooden_planks_stonecutting" | "minecraft:recipes/fire_coral_block" | "alltheores:recipes/misc/iron_ingot_from_dust_blasting" | "minecraft:recipes/building_blocks/polished_andesite_slab_from_polished_andesite_stonecutting" | "caveopolis:recipes/misc/cyan_colored_wooden_plank_crafting_table" | "supplementaries:recipes/stonecutting/lapis_brick_wall_from_bricks" | "minecraft:recipes/decorations/flower_pot" | "minecraft:recipes/misc/raw_iron" | "caveopolis:recipes/misc/red_colored_stone_brick_wall_from_red_colored_stone_bricks_stonecutting" | "sophisticatedbackpacks:recipes/misc/tool_swapper_upgrade" | "minecraft:recipes/building_blocks/deepslate_tile_slab_from_deepslate_bricks_stonecutting" | "caveopolis:recipes/misc/orange_colored_cobblestone_brick_slab_from_orange_colored_cobblestone_bricks_stonecutting" | "alltheores:recipes/misc/bronze_gear" | "minecraft:recipes/misc/stick_from_bamboo_item" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper" | "alltheores:recipes/misc/enderium_rod" | "minecraft:recipes/redstone/bamboo_fence_gate" | "minecraft:recipes/decorations/sandstone_wall" | "caveopolis:recipes/misc/yellow_colored_stone_pressure_plate_from_yellow_colored_stone_stonecutting" | "caveopolis:recipes/building_blocks/green_colored_wood" | "farmersdelight:recipes/food/chicken_sandwich" | "supplementaries:recipes/pulley" | "caveopolis:recipes/misc/lime_colored_wooden_plank_fence_gate_from_lime_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/andesite_wall" | "caveopolis:recipes/redstone/orange_colored_stone_pressure_plate" | "minecraft:recipes/building_blocks/andesite_slab" | "caveopolis:recipes/misc/gray_colored_stone_wall" | "minecraft:recipes/misc/light_gray_dye_from_oxeye_daisy" | "caveopolis:recipes/misc/magenta_colored_stone_button_from_magenta_colored_stone_stonecutting" | "caveopolis:recipes/misc/light_blue_colored_wooden_plank_slab_from_light_blue_colored_wooden_planks_stonecutting" | "minecraft:recipes/misc/light_gray_dye_from_black_white_dye" | "caveopolis:recipes/redstone/blue_colored_stone_button" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "caveopolis:recipes/building_blocks/purple_colored_cobblestone_bricks" | "caveopolis:recipes/redstone/light_blue_colored_wooden_plank_button" | "minecraft:recipes/building_blocks/cobblestone_stairs_from_cobblestone_stonecutting" | "caveopolis:recipes/misc/yellow_spray_can" | "sophisticatedbackpacks:recipes/misc/auto_smoking_upgrade_from_auto_smelting_upgrade" | "supplementaries:recipes/sconce_soul" | "supplementaries:recipes/stonecutting/stone_tile" | "minecraft:recipes/misc/wheat" | "minecraft:recipes/food/rabbit_stew_from_red_mushroom" | "minecraft:recipes/redstone/birch_pressure_plate" | "minecraft:recipes/building_blocks/purpur_stairs_from_purpur_block_stonecutting" | "aquamirae:recipes/three_bolt_helmet" | "minecraft:recipes/tools/golden_hoe" | "minecraft:recipes/building_blocks/cut_red_sandstone_from_red_sandstone_stonecutting" | "caveopolis:recipes/building_blocks/lime_colored_cobblestone_brick_stairs" | "minecraft:recipes/building_blocks/diorite_slab_from_diorite_stonecutting" | "caveopolis:recipes/misc/cyan_colored_wooden_plank_stairs_from_cyan_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/pink_carpet" | "farmersdelight:recipes/decorations/purple_hanging_canvas_sign" | "caveopolis:recipes/redstone/green_colored_stone_pressure_plate" | "caveopolis:recipes/misc/light_gray_colored_cobblestone_stairs_from_light_gray_colored_cobblestone_stonecutting" | "farmersdelight:recipes/decorations/cutting_board" | "caveopolis:recipes/misc/yellow_colored_stone_slab_from_yellow_colored_stone_stonecutting" | "caveopolis:recipes/building_blocks/lime_colored_wooden_planks" | "caveopolis:recipes/redstone/black_colored_wooden_plank_trapdoor" | "minecraft:recipes/building_blocks/cut_copper_slab_from_copper_block_stonecutting" | "minecraft:recipes/food/mushroom_stew" | "alltheores:recipes/misc/raw_platinum_from_block" | "caveopolis:recipes/building_blocks/blue_colored_stone" | "caveopolis:recipes/misc/mixed_stone_ingot_from_blasting_deepslate_mixed_stone_ore" | "minecraft:recipes/building_blocks/waxed_exposed_cut_copper_slab" | "caveopolis:recipes/misc/magenta_colored_stone_stairs_from_magenta_colored_stone_stonecutting" | "igleelib:recipes/igleelib/ultimerite_ingot_upgrade" | "minecraft:husbandry/balanced_diet" | "minecraft:recipes/building_blocks/gray_terracotta" | "aquamirae:recipes/astral_dust" | "aquaculture:recipes/misc/neptunium_ingot_from_nuggets" | "farmersdelight:recipes/building_blocks/cabbage_crate" | "minecraft:recipes/food/cooked_cod" | "caveopolis:recipes/misc/yellow_colored_cobblestone_stairs_from_yellow_colored_cobblestone_stonecutting" | "minecraft:recipes/tools/netherite_pickaxe_smithing" | "supplementaries:recipes/gold_door" | "minecraft:nether/fast_travel" | "caveopolis:recipes/misc/red_colored_cobblestone_brick_wall" | "minecraft:recipes/building_blocks/bamboo_stairs" | "minecraft:recipes/building_blocks/dye_yellow_bed" | "farmersdelight:recipes/food/bacon_and_eggs" | "alltheores:recipes/misc/iridium_rod" | "minecraft:recipes/prize_pottery_sherd" | "caveopolis:recipes/building_blocks/stripped_yellow_colored_wood" | "sophisticatedbackpacks:recipes/misc/auto_blasting_upgrade_from_auto_smelting_upgrade" | "minecraft:recipes/building_blocks/bamboo_block" | "supplementaries:recipes/daub" | "minecraft:recipes/building_blocks/deepslate_tiles_from_cobbled_deepslate_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_wool" | "alltheores:recipes/misc/netherite_dust_from_hammer_crushing" | "caveopolis:recipes/misc/brown_colored_wooden_plank_pressure_plate_from_brown_colored_wooden_planks_stonecutting" | "minecraft:recipes/zombie_head" | "caveopolis:recipes/misc/green_colored_stone_slab_from_green_colored_stone_stonecutting" | "minecraft:recipes/quartz" | "nec:recipes/decorations/cherry_chest" | "minecraft:recipes/decorations/mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "storagedrawers:recipes/storagedrawers/controller_slave" | "minecraft:recipes/redstone/tnt" | "minecraft:recipes/decorations/black_stained_glass_pane" | "caveopolis:recipes/misc/brown_colored_stone_wall_from_brown_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_slab_from_waxed_oxidized_copper_stonecutting" | "caveopolis:recipes/misc/light_gray_colored_cobblestone_slab" | "caveopolis:recipes/misc/magenta_colored_stone_brick_wall_from_magenta_colored_stone_bricks_stonecutting" | "minecraft:recipes/building_blocks/dye_gray_bed" | "farmersdelight:recipes/building_blocks/pumpkin_from_slices" | "awesomedungeonocean:ocean_quad/find_during_storm" | "supplementaries:recipes/lapis_bricks" | "minecraft:recipes/tuff" | "caveopolis:recipes/misc/black_colored_stone_brick_slab_from_black_colored_stone_bricks_stonecutting" | "caveopolis:recipes/building_blocks/black_colored_cobblestone_brick_stairs" | "caveopolis:recipes/misc/cyan_colored_stone_slab_from_cyan_colored_stone_stonecutting" | "caveopolis:recipes/building_blocks/magenta_colored_stone_brick_stairs" | "minecraft:recipes/decorations/enchanting_table" | "caveopolis:recipes/building_blocks/lime_colored_wooden_plank_stairs" | "caveopolis:recipes/misc/blue_colored_stone_crafting_table" | "caveopolis:recipes/building_blocks/blue_colored_wood" | "aquaculture:recipes/tools/stone_fillet_knife" | "caveopolis:recipes/misc/black_colored_stone_stairs_from_black_colored_stone_stonecutting" | "alltheores:recipes/misc/tin_nugget_from_ingot" | "minecraft:recipes/building_blocks/weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "alltheores:recipes/misc/platinum_dust_from_hammer_ingot_crushing" | "caveopolis:recipes/misc/yellow_colored_stone_bricks_from_yellow_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "chipped:recipes/mason_table" | "minecraft:recipes/tools/stone_hoe" | "minecraft:recipes/food/dried_kelp" | "caveopolis:recipes/building_blocks/pink_colored_cobblestone" | "aquaculture:recipes/misc/iron_nugget_from_blasting" | "strainers:recipes/misc/summoning_block" | "minecraft:nether/use_lodestone" | "caveopolis:recipes/misc/yellow_colored_wooden_plank_crafting_table" | "caveopolis:recipes/building_blocks/white_colored_stone_brick_stairs" | "caveopolis:recipes/misc/yellow_colored_cobblestone_brick_slab" | "minecraft:recipes/decorations/jungle_hanging_sign" | "caveopolis:recipes/misc/green_colored_cobblestone_wall" | "caveopolis:recipes/redstone/red_colored_wooden_plank_door" | "minecraft:recipes/building_blocks/spruce_stairs" | "sophisticatedbackpacks:recipes/misc/tank_upgrade" | "minecraft:recipes/building_blocks/mangrove_slab" | "sophisticatedbackpacks:recipes/misc/crafting_upgrade" | "alltheores:recipes/misc/enderium_ingot" | "caveopolis:recipes/misc/white_colored_stone_stairs_from_white_colored_stone_stonecutting" | "caveopolis:recipes/decorations/blue_colored_wooden_plank_fence" | "caveopolis:recipes/misc/glowstone_spray_can" | "caveopolis:recipes/building_blocks/blue_colored_cobblestone_stairs" | "caveopolis:recipes/misc/marble_brick_wall" | "caveopolis:recipes/misc/brown_colored_wooden_plank_slab_from_brown_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/red_sandstone_stairs_from_red_sandstone_stonecutting" | "caveopolis:recipes/decorations/white_colored_hanging_sign" | "minecraft:recipes/fire_coral" | "caveopolis:recipes/building_blocks/orange_colored_cobblestone_bricks" | "alltheores:recipes/misc/gold_plate" | "minecraft:recipes/decorations/anvil" | "minecraft:recipes/decorations/black_candle" | "caveopolis:recipes/misc/marble" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper_from_honeycomb" | "caveopolis:recipes/misc/gray_colored_cobblestone_brick_wall_from_gray_colored_cobblestone_bricks_stonecutting" | "caveopolis:recipes/redstone/yellow_colored_wooden_plank_fence_gate" | "minecraft:recipes/big_dripleaf" | "caveopolis:recipes/misc/magenta_colored_stone_pressure_plate_from_magenta_colored_stone_stonecutting" | "minecraft:recipes/decorations/mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting" | "caveopolis:recipes/misc/blue_colored_wooden_plank_pressure_plate_from_blue_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/magenta_colored_stone_brick_wall" | "caveopolis:recipes/building_blocks/green_colored_cobblestone_stairs" | "supplementaries:adventure/globe" | "caveopolis:recipes/misc/light_gray_spray_can" | "caveopolis:recipes/misc/green_colored_stone_stairs_from_green_colored_stone_stonecutting" | "farmersdelight:recipes/building_blocks/onion_crate" | "caveopolis:recipes/misc/gray_colored_stone_slab_from_gray_colored_stone_stonecutting" | "minecraft:recipes/decorations/loom" | "minecraft:recipes/building_blocks/deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "minecraft:recipes/tools/diamond_axe" | "alltheores:recipes/misc/raw_nickel_block" | "minecraft:recipes/building_blocks/end_stone_bricks_from_end_stone_stonecutting" | "minecraft:recipes/building_blocks/end_stone_brick_stairs_from_end_stone_stonecutting" | "minecraft:recipes/misc/emerald_from_blasting_deepslate_emerald_ore" | "caveopolis:recipes/misc/lime_colored_cobblestone_brick_wall" | "minecraft:recipes/sand" | "minecraft:recipes/decorations/scaffolding" | "farmersdelight:recipes/cooking/vegetable_soup" | "caveopolis:recipes/misc/blue_colored_stone_brick_wall" | "alltheores:recipes/misc/silver_dust_from_hammer_crushing" | "alltheores:recipes/misc/gold_rod" | "caveopolis:recipes/redstone/pink_colored_stone_button" | "minecraft:recipes/mud" | "caveopolis:recipes/building_blocks/stripped_lime_colored_wood" | "caveopolis:recipes/misc/purple_colored_stone_slab_from_purple_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/waxed_weathered_cut_copper" | "smallships:recipes/transportation/mangrove_cog" | "caveopolis:recipes/building_blocks/stripped_light_blue_colored_wood" | "caveopolis:recipes/building_blocks/pink_colored_cobblestone_bricks" | "minecraft:recipes/building_blocks/diorite_stairs" | "minecraft:recipes/building_blocks/green_terracotta" | "caveopolis:recipes/decorations/black_colored_hanging_sign" | "minecraft:recipes/misc/raw_copper" | "caveopolis:recipes/misc/magenta_colored_wooden_plank_button_from_magenta_colored_wooden_planks_stonecutting" | "caveopolis:recipes/misc/red_colored_wooden_plank_door_from_red_colored_wooden_planks_stonecutting" | "minecraft:recipes/building_blocks/mossy_stone_bricks_from_moss_block" | "minecraft:recipes/misc/skull_banner_pattern" | "aquaculture:recipes/misc/tin_can_to_iron_nugget" | "industrialforegoing:recipes/misc/laser_lens_cyan_recolor" | "minecraft:story/root" | "supplementaries:recipes/candle_holders/candle_holder_yellow" | "caveopolis:recipes/building_blocks/purple_colored_wood" | "caveopolis:recipes/misc/lime_colored_stone_slab_from_lime_colored_stone_stonecutting" | "minecraft:recipes/building_blocks/dye_black_wool" | "caveopolis:recipes/misc/black_colored_wooden_plank_fence_gate_from_black_colored_wooden_planks_stonecutting" | "awesomedungeonocean:ocean_ruin_pillager/find_during_rain" | "minecraft:recipes/miner_pottery_sherd" | "minecraft:recipes/brewing/brewing_stand" | "minecraft:recipes/root" | "farmersdelight:recipes/food/sweet_berry_cheesecake" | "supplementaries:recipes/stonecutting/blackstone_tile" | "minecraft:recipes/misc/quartz_from_blasting" | "minecraft:recipes/building_blocks/acacia_planks" | "caveopolis:recipes/misc/lime_colored_stone_crafting_table" | "alltheores:recipes/misc/lead_block" | "caveopolis:recipes/misc/magenta_colored_cobblestone_wall" | "smallships:recipes/transportation/cherry_cog" | "alltheores:recipes/misc/signalum_block" | "supplementaries:recipes/soap/globe" | "aquaculture:recipes/tools/neptunium_axe" | "caveopolis:recipes/misc/orange_colored_stone_button_from_orange_colored_stone_stonecutting" | "minecraft:recipes/redstone/iron_door" | "minecraft:recipes/building_blocks/waxed_oxidized_cut_copper_from_honeycomb" | "farmersdelight:recipes/food/honey_glazed_ham_block" | "caveopolis:recipes/building_blocks/lime_colored_stone_stairs" | "minecraft:recipes/misc/copper_ingot_from_smelting_raw_copper" | "caveopolis:recipes/misc/light_gray_colored_wooden_plank_slab_from_light_gray_colored_wooden_planks_stonecutting" | "supplementaries:recipes/stonecutting/ash_brick_slab_from_bricks" | "minecraft:recipes/building_blocks/snow_block" | "minecraft:recipes/gravel" | "alltheores:recipes/misc/nickel_rod" | "caveopolis:recipes/building_blocks/orange_colored_wooden_planks" | "minecraft:recipes/building_blocks/blackstone_stairs_from_blackstone_stonecutting" | "supplementaries:recipes/decorations/thermal/sign_post_rubberwood" | "caveopolis:recipes/building_blocks/gray_colored_wooden_plank_stairs" | "minecraft:recipes/melon_seeds" | "alltheores:recipes/misc/iridium_block" | "supplementaries:recipes/candle_holders/candle_holder_black_dye" | "caveopolis:recipes/misc/black_colored_cobblestone_brick_slab_from_black_colored_cobblestone_bricks_stonecutting" | "caveopolis:recipes/misc/yellow_colored_wooden_plank_pressure_plate_from_yellow_colored_wooden_planks_stonecutting" | "minecraft:recipes/decorations/polished_blackstone_wall" | "caveopolis:recipes/building_blocks/pink_colored_wooden_plank_stairs" | "minecraft:recipes/transportation/dark_oak_boat" | "minecraft:recipes/decorations/honeycomb_block" | "supplementaries:recipes/flags/flag_lime" | "caveopolis:recipes/misc/blue_colored_cobblestone_bricks_from_blue_colored_cobblestone_stonecutting" | "minecraft:recipes/building_blocks/waxed_cut_copper_stairs" | "caveopolis:recipes/building_blocks/black_colored_wood" | "caveopolis:recipes/misc/orange_colored_cobblestone_slab_from_orange_colored_cobblestone_stonecutting" | "caveopolis:recipes/misc/brown_colored_cobblestone_bricks_from_brown_colored_cobblestone_stonecutting" | "aquaculture:recipes/decorations/jungle_fish_mount" | "minecraft:recipes/misc/mojang_banner_pattern" | "minecraft:recipes/combat/golden_leggings" | "minecraft:recipes/redstone/piston" | "minecraft:recipes/misc/lapis_lazuli_from_smelting_lapis_ore" | "alltheores:recipes/misc/brass_nugget_from_ingot" | "alltheores:recipes/misc/raw_nickel_from_block" | "alltheores:recipes/misc/constantan_ingot_from_dust" | "caveopolis:recipes/misc/purple_colored_cobblestone_brick_wall" | "sophisticatedbackpacks:recipes/misc/advanced_pickup_upgrade" | "caveopolis:recipes/misc/cyan_spray_can" | "minecraft:recipes/food/cooked_beef_from_campfire_cooking" | "sophisticatedbackpacks:recipes/misc/iron_backpack" | "farmersdelight:recipes/food/fried_egg" | "minecraft:recipes/decorations/polished_blackstone_brick_wall_from_polished_blackstone_stonecutting" | "caveopolis:recipes/building_blocks/cyan_colored_cobblestone" | "alltheores:recipes/misc/osmium_ingot_from_block" | "minecraft:recipes/skeleton_skull" | "caveopolis:recipes/misc/white_colored_stone_wall" | "caveopolis:recipes/misc/light_gray_colored_stone_brick_slab" | "minecraft:recipes/decorations/light_gray_stained_glass_pane" | "alltheores:recipes/misc/iron_ore_hammer" | "caveopolis:recipes/misc/light_blue_colored_wooden_plank_fence_gate_from_light_blue_colored_wooden_planks_stonecutting";
    type RecipeId = "caveopolis:pink_colored_wood" | "strainers:blade_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "opolisutilities:bundled_flesh" | "farmersdelight:cutting/brown_mushroom_colony" | "thermal:machines/pulverizer/pulverizer_nickel_ingot_to_dust" | "mysticalagriculture:seed/crafting/tin" | "caveopolis:gray_colored_cobblestone_stairs_from_gray_colored_cobblestone_stonecutting" | "suppsquared:item_shelf_jungle" | "supplementaries:ash_brick_slab" | "framedcompactdrawers:framed_drawer_controller" | "strainers:plenty_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "opolisutilities:diamond_horse_armor" | "caveopolis:magenta_colored_cobblestone_bricks_from_magenta_colored_cobblestone_stonecutting" | "strainers:meshes/iron" | "industrialforegoing:fluid_extractor/oak" | "caveopolis:sprayer/colored_cobblestone/gray_colored_stone" | "caveopolis:orange_colored_wooden_plank_pressure_plate_from_orange_colored_wooden_planks_stonecutting" | "mysticalagriculture:essence/minecraft/milk_bucket" | "caveopolis:red_colored_cobblestone_brick_stairs_from_red_colored_cobblestone_bricks_stonecutting" | "minecraft:stonecutter" | "caveopolis:purple_colored_cobblestone_bricks_from_purple_colored_cobblestone_stonecutting" | "strainers:upgrades/sturdy/sturdy_everything_upgrade" | "minecraft:bone_block" | "alltheores:gold_dust_from_hammer_crushing" | "strainers:deepslate_pebble_from_straining_dirt_in_minecraft_lava" | "caveopolis:red_colored_stone_stairs_from_red_colored_stone_stonecutting" | "mysticalagriculture:souls/rabbit_hide" | "caveopolis:purple_colored_wooden_plank_fence_from_purple_colored_wooden_planks_stonecutting" | "thermal:compat/tconstruct/chiller_tconstruct_bronze_ingot" | "thermal:compat/tconstruct/press_tconstruct_slimesteel_nugget_unpacking" | "minecraft:melon" | "caveopolis:gray_colored_stone_pressure_plate" | "caveopolis:purple_colored_wooden_plank_stairs" | "mysticalagriculture:seed/reprocessor/rock_crystal" | "minecraft:deepslate_brick_stairs_from_cobbled_deepslate_stonecutting" | "thermal:smelting/sulfur_from_blasting" | "alltheores:raw_osmium_block" | "caveopolis:pink_colored_cobblestone" | "caveopolis:sprayer/glass_block/yellow" | "minecraft:gold_nugget_from_blasting" | "farmersdelight:cutting/bamboo_trapdoor" | "thermal:rubber_from_vine" | "systeams:boilers/frost" | "thermal:lumium_powered_rail" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/green_colored_stone_brick_stairs" | "thermal:machines/press/unpacking/press_sandstone_unpacking" | "thermal:compat/biomesoplenty/insolator_bop_blue_hydrangea_flower" | "thermal:compat/mysticalagriculture/insolator_mysticalag_menril_seeds" | "sophisticatedbackpacks:void_upgrade" | "thermal:fuels/lapidary/lapidary_lapis" | "thermal:machines/crucible/crucible_glowstone_dust" | "strainers:netherrack_from_straining_stone_in_minecraft_lava" | "minecraft:cobblestone_wall" | "farmersdelight:cutting/ink_sac" | "minecraft:lime_stained_glass_pane" | "alltheores:mek_processing/zinc/crystal/from_slurry" | "supplementaries:sconce_nether_brass" | "alltheores:electrum_nugget_from_ingot" | "caveopolis:sprayer/colored_wooden_planks/pink" | "mysticalagradditions:supremium_paxel" | "caveopolis:sprayer/colored_hanging_signs/black" | "minecraft:raw_copper" | "caveopolis:yellow_colored_stone_bricks_from_yellow_colored_stone_stonecutting" | "strainers:slime_ball_from_straining_green_dye_in_strainers_purified_water_fluid" | "caveopolis:sprayer/colored_hanging_signs/magenta" | "smallships:bamboo_cog" | "farmersdelight:cutting/acacia_sign" | "opolisutilities:resource_generator_2/speed_blocks/brass" | "thermal:machines/smelter/smelter_netherite_plate_to_ingot" | "caveopolis:stripped_cyan_colored_wood" | "alltheores:brass_plate" | "thermal:earth_charge/prismarine_shard_from_prismarine_bricks" | "thermal:machines/centrifuge/centrifuge_yellow_rockwool" | "farmersdelight:cooked_chicken_cuts_from_smoking" | "thermal:machines/press/press_spinach_packing" | "thermal:compat/tconstruct/sawmill_tconstruct_skyroot_logs" | "mysticalagriculture:enchanter/unbreaking" | "thermal_extra:machine/press/twinite_gear" | "caveopolis:sprayer/wool/orange_wool" | "thermal:black_concrete_powder_with_slag" | "supplementaries:trapped_present" | "thermal:machines/pulverizer/pulverizer_raw_lead" | "farmersdelight:sweet_berry_cheesecake" | "minecraft:map_extending" | "minecraft:spruce_sign" | "thermal:machines/furnace/furnace_rotten_flesh_to_leather" | "thermal:machines/pulverizer/pulverizer_lead_plate_to_dust" | "mysticalagriculture:soulstone_cobble_stairs" | "caveopolis:sprayer/colored_cobblestone_wall/yellow_colored_stone_wall" | "caveopolis:sprayer/remove_color/stone_brick_stairs" | "minecraft:cut_copper_slab_from_copper_block_stonecutting" | "aquamirae:abyssal_amethyst" | "sophisticatedbackpacks:advanced_refill_upgrade" | "thermal:machines/press/packing3x3/press_tin_nugget_packing" | "minecraft:glow_item_frame" | "mysticalagriculture:essence/minecraft/bubble_coral_fan" | "caveopolis:sprayer/colored_wooden_planks/brown" | "minecraft:chiseled_nether_bricks" | "mysticalagriculture:essence/minecraft/music_disc_mall" | "lfpirates:sailor_red_tier_2_boots_recipe_1" | "thermal:machines/centrifuge/centrifuge_oil_red_sand" | "thermal:smelting/lead_ingot_from_deepslate_ore_smelting" | "thermal:compat/mysticalagriculture/insolator_mysticalag_dye_seeds" | "minecraft:copper_block" | "mysticalagriculture:essence/astralsorcery/starmetal_ingot" | "thermal:machines/insolator/insolator_tube_coral" | "mysticalagriculture:essence/minecraft/beef" | "cozy_home:table_stump_cherry_recipe" | "mysticalagriculture:augment/luck_ii" | "supplementaries:crank" | "minecraft:green_stained_glass" | "aquaculture:iron_nugget_from_smelting" | "mysticalagriculture:stonecutting/soulstone_bricks_from_soulstone" | "alltheores:iron_plate" | "thermal:machines/pulverizer/pulverizer_lapis" | "minecraft:sandstone_slab_from_sandstone_stonecutting" | "mysticalagriculture:augment/haste_i" | "systeams:boilers/upgrades/disenchantment_upgrade" | "farmersdelight:integration/create/milling/wild_beetroots" | "supplementaries:netherite_trapdoor" | "thermal:compat/dyenamics/bottler_dyenamics_maroon_concrete" | "cozy_home:bamboo_mirror_stand_recipe" | "industrialforegoing:laser_lens_light_gray_recolor" | "thermal:compat/mysticalagriculture/insolator_mysticalag_lead_seeds" | "thermal:compat/mysticalagriculture/insolator_mysticalag_prismarine_seeds" | "caveopolis:sprayer/colored_cobblestone_brick_slab/orange" | "caveopolis:sprayer/wool/yellow_wool" | "caveopolis:sprayer/beds/lime" | "mysticalagriculture:essence/minecraft/music_disc_stal" | "mysticalagriculture:augment/speed_i" | "oceansdelight:cutting/guardian" | "matc:insanium_essence" | "thermal:rubberwood_chest_boat" | "strainers:horn_coral_from_straining_barrier_in_minecraft_water" | "caveopolis:brown_colored_cobblestone_wall" | "caveopolis:black_colored_wooden_plank_trapdoor_from_black_colored_wooden_planks_stonecutting" | "thermal:devices/tree_extractor/tree_extractor_cherry" | "thermal_extra:machine/pulverizer/shellite_dust" | "mysticalagriculture:augment/absorption_i" | "thermal:compat/tconstruct/chiller_tconstruct_steel_ingot" | "thermal:diving_fabric" | "caveopolis:sprayer/colored_stone_brick_wall/black_colored_stone_brick_wall" | "opolisutilities:fragment_from_smelting_deepslate_ender_ore" | "minecraft:cut_sandstone_slab" | "industrialforegoing:laser_lens_cyan_recolor" | "thermal:machines/smelter/smelter_nickel_dust" | "supplementaries:candle_holders/candle_holder_white_dye" | "minecraft:cherry_door" | "alltheores:mek_processing/silver/clump/from_raw_block" | "mysticalagradditions:tconstruct/casting/supremium/nugget_sand_cast" | "nec:caveop_blue_colored_wooden_chest" | "tmttd:cooking/hearty_stew" | "caveopolis:pink_colored_stone_slab_from_pink_colored_stone_stonecutting" | "tmttd:machines/press/rice_bale_press" | "minecraft:acacia_door" | "minecraft:mangrove_wood" | "caveopolis:light_gray_colored_stone_wall" | "caveopolis:sprayer/colored_stone_brick_slab/blue_colored_stone_brick_slab" | "suppsquared:gold_plaque" | "thermal:machines/centrifuge/centrifuge_azure_bluet" | "cozy_home:counter_warped_storage_recipe" | "thermal:compat/tconstruct/press_tconstruct_rose_gold_nugget_unpacking" | "minecraft:cyan_concrete_powder" | "minecraft:mojang_banner_pattern" | "mysticalagriculture:seed/crafting/brass" | "minecraft:dye_pink_wool" | "minecraft:fire_charge" | "minecraft:golden_hoe" | "caveopolis:pink_colored_stone_brick_slab" | "caveopolis:sprayer/colored_signs/black" | "mysticalagriculture:augment/strength_ii" | "aquaculture:gold_nugget_from_smelting" | "caveopolis:white_colored_wooden_plank_door_from_white_colored_wooden_planks_stonecutting" | "minecraft:dye_green_bed" | "thermal:compat/mysticalagriculture/insolator_mysticalag_constantan_seeds" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/cyan" | "farmersdelight:rice_roll_medley_block" | "mysticalagriculture:seed/crafting/manasteel" | "thermal:machines/smelter/smelter_emerald_ore" | "thermal:machines/pulverizer/pulverizer_silver_ore" | "alltheores:constantan_rod" | "minecraft:stone_button" | "cozy_home:acacia_chair_recipe" | "mysticalagriculture:seed/infusion/chicken" | "strainers:summoning_block/creeper" | "mysticalagriculture:souls/egg" | "caveopolis:purple_colored_cobblestone_bricks" | "caveopolis:purple_colored_wooden_plank_trapdoor" | "caveopolis:brown_colored_cobblestone_stairs" | "thermal:machines/crystallizer/crystallizer_quartz" | "minecraft:sandstone" | "thermal_extra:machine/press/shellite_coin" | "thermal:prismarine_detector_rail" | "alltheores:smelting_dust/zinc_ingot" | "thermal_extra:augments/machine_efficiency_augment_4" | "thermal_extra:augments/machine_efficiency_augment_3" | "strainers:mourner_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "strainers:summoning_block/magma_slime" | "thermal_extra:augments/machine_efficiency_augment_2" | "thermal_extra:augments/machine_efficiency_augment_1" | "caveopolis:sprayer/colored_cobblestone_slab/magenta_colored_stone_slab" | "minecraft:purpur_block" | "farmersdelight:cutting/smoked_ham" | "industrialforegoing:laser_drill_ore/ores/yellorite" | "thermal:machines/insolator/insolator_spinach" | "opolisutilities:resource_generator_2" | "caveopolis:black_colored_stone_pressure_plate" | "minecraft:polished_blackstone_slab" | "opolisutilities:leafy_string" | "mysticalagriculture:essence/minecraft/obsidian" | "farmersdelight:blue_canvas_sign" | "thermal:machines/press/unpacking/press_emerald_unpacking" | "thermal:devices/tree_extractor/tree_extractor_jungle" | "caveopolis:sprayer/colored_signs/green" | "cozy_home:telescope_recipe" | "thermal:machines/pulverizer/pulverizer_silver_plate_to_dust" | "alltheores:tools_materials/zinc/zinc_from_nugget" | "thermal:machines/pulverizer/pulverizer_sulfur" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/brown_colored_stone_brick_stairs" | "minecraft:gray_concrete_powder" | "thermal:compat/mysticalagriculture/insolator_mysticalag_rubber_seeds" | "farmersdelight:cyan_hanging_canvas_sign" | "caveopolis:sprayer/colored_wooden_plank_door/blue" | "thermal:blue_concrete_powder_with_slag" | "mysticalagriculture:essence/pneumaticcraft/compressed_iron_ingot" | "alltheores:mek_processing/platinum/dust/from_raw_ore" | "cozy_home:desk_birch_recipe" | "aquaculture:neptunium_ingot_from_blasting" | "thermal:machines/press/packing3x3/press_raw_iron_packing" | "minecraft:redstone_from_blasting_redstone_ore" | "caveopolis:sprayer/colored_stone_brick_wall/blue_colored_stone_brick_wall" | "cozy_home:crimson_plank_recipe" | "caveopolis:mixed_stone_nugget" | "lfpirates:skull_2_recipe_1" | "caveopolis:purple_colored_cobblestone_brick_stairs" | "minecraft:lime_candle" | "mysticalagriculture:essence/create/veridium" | "caveopolis:green_colored_cobblestone_stairs" | "minecraft:red_dye_from_beetroot" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_cut_copper_stonecutting" | "caveopolis:red_colored_wooden_plank_stairs_from_red_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/glass_pane/purple" | "caveopolis:light_blue_colored_cobblestone_brick_slab" | "storagedrawers:one_stack_upgrade" | "thermal:compat/mysticalagriculture/insolator_mysticalag_squid_seeds" | "alltheores:nickel_dust_from_hammer_crushing" | "caveopolis:sprayer/stripped_colored_wood/purple" | "thermal:compat/tconstruct/tree_extractor_tconstruct_blood_slime" | "mysticalagriculture:souls/zombie_head" | "alltheores:zinc_ingot_from_slate_ore" | "caveopolis:yellow_colored_stone_crafting_table" | "thermal:machines/centrifuge/centrifuge_experience_bottle" | "thermal:machines/press/unpacking/press_melon_unpacking" | "caveopolis:sprayer/colored_stone_slab/cyan_colored_stone_slab" | "caveopolis:stripped_magenta_colored_wood" | "mysticalagriculture:seed/reprocessor/elementium" | "supplementaries:candle_holders/candle_holder_red_dye" | "caveopolis:magenta_colored_cobblestone_stairs" | "mysticalagriculture:seed/infusion/ghast" | "alltheores:lead_block" | "caveopolis:sprayer/colored_stone_buttons/light_blue" | "thermal:augments/dynamo_throttle_augment" | "minecraft:birch_stairs" | "minecraft:exposed_cut_copper_slab_from_exposed_cut_copper_stonecutting" | "strainers:red_mushroom_from_straining_mycelium_in_minecraft_water" | "caveopolis:white_colored_stone_brick_slab" | "thermal:storage/barley_block" | "mysticalagriculture:awakened_supremium_block_awakening" | "thermal_extra:machine/pulverizer/soul_sand_dust" | "strainers:summoning_block/chicken" | "caveopolis:sprayer/glass_pane/black" | "opolisutilities:block_breaker" | "alltheores:iron_gear" | "minecraft:cyan_glazed_terracotta" | "thermal:parts/nickel_gear" | "thermal:machines/press/press_tea_unpacking" | "thermal:machines/pulverizer/pulverizer_quartz" | "minecraft:stone_sword" | "thermal:machines/crystallizer/crystallizer_sulfur" | "industrialforegoing:dissolution_chamber/efficiency_addon_2" | "industrialforegoing:dissolution_chamber/efficiency_addon_1" | "thermal:machines/centrifuge/centrifuge_honey_bottle" | "farmersdelight:milk_bottle" | "caveopolis:lime_colored_stone_brick_stairs" | "thermal:machines/centrifuge/centrifuge_peony" | "farmersdelight:cutting/mangrove_trapdoor" | "minecraft:iron_ingot_from_iron_block" | "caveopolis:sprayer/banners/blue" | "thermal:machines/bottler/bottler_magenta_concrete" | "thermal:machines/press/unpacking/press_netherite_unpacking" | "aquamirae:maze_rose" | "caveopolis:white_colored_wooden_plank_fence" | "caveopolis:brown_colored_cobblestone_bricks_from_brown_colored_cobblestone_stonecutting" | "caveopolis:sprayer/colored_signs/red" | "industrialforegoing:stonework_generate/andesite" | "alltheores:mek_processing/aluminum/clump/from_raw_ore" | "cozy_home:grandfather_clock_dark_oak_recipe" | "strainers:bamboo_from_straining_barrier_in_strainers_eroding_water_fluid" | "mysticalagriculture:seed/reprocessor/uraninite" | "minecraft:orange_stained_glass_pane_from_glass_pane" | "lfpirates:pirate_tier_1_body_recipe_1" | "caveopolis:pink_colored_stone_button_from_pink_colored_stone_stonecutting" | "caveopolis:sprayer/remove_color/signs" | "mysticalagriculture:seed/infusion/rabbit" | "thermal:compat/tconstruct/press_tconstruct_blood_slime_2x2_unpacking" | "thermal:machines/smelter/smelter_copper_ore" | "caveopolis:gray_colored_wood" | "storagedrawers:oak_half_drawers_1" | "caveopolis:sprayer/colored_stone/light_gray_colored_stone" | "caveopolis:sprayer/remove_color/colored_cobblestone_wall" | "suppsquared:metal_cross_brace" | "mysticalagriculture:harvester" | "smallships:acacia_brigg" | "caveopolis:sprayer/colored_wooden_planks/purple" | "minecraft:banner_duplicate" | "caveopolis:magenta_colored_cobblestone_wall_from_magenta_colored_cobblestone_stonecutting" | "thermal:compat/mysticalagriculture/insolator_mysticalag_elementium_seeds" | "minecraft:granite_stairs_from_granite_stonecutting" | "mysticalagriculture:stonecutting/soulstone_bricks_stairs_from_soulstone_bricks" | "caveopolis:light_blue_colored_stone_stairs_from_light_blue_colored_stone_stonecutting" | "storagedrawers:oak_half_drawers_2" | "cozy_home:crimson_mirror_stand_recipe" | "storagedrawers:oak_half_drawers_4" | "mysticalagriculture:essence/appliedenergistics2/engineering_press" | "mysticalagradditions:nether_star_crux" | "thermal:compat/tconstruct/press_tconstruct_ender_slime_3x3_unpacking" | "thermal:compat/mysticalagriculture/insolator_mysticalag_pig_seeds" | "minecraft:iron_ingot_from_nuggets" | "minecraft:golden_pickaxe" | "minecraft:chiseled_bookshelf" | "mysticalagriculture:augment/step_assist" | "caveopolis:black_colored_stone_slab" | "thermal:stonecutting/chiseled_rich_slag_from_stonecutting" | "minecraft:ladder" | "caveopolis:sprayer/colored_leaves/brown" | "mysticalagriculture:essence/minecraft/honey_bottle" | "alltheores:electrum_gear" | "minecraft:redstone_torch" | "supplementaries:rope_arrow_add" | "thermal_extra:machine/pulverizer/soul_infused_dust" | "caveopolis:sprayer/colored_wooden_plank_fence/purple" | "thermal:machines/press/press_lead_ingot_to_coin" | "suppsquared:item_shelf_dark_oak" | "caveopolis:orange_colored_hanging_sign" | "farmersdelight:pumpkin_from_slices" | "thermal:machines/smelter/smelter_redstone_ore" | "strainers:plenty_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "alltheores:aluminum_ingot" | "mysticalagriculture:awakened_supremium_block" | "caveopolis:blue_colored_wooden_plank_stairs_from_blue_colored_wooden_planks_stonecutting" | "thermal:compat/tconstruct/press_tconstruct_rose_gold_nugget_packing" | "mysticalagriculture:essence/botania/manasteel_ingot" | "mysticalagriculture:seed/crafting/rubber" | "thermal:compat/create/bottler_create_gunpowder" | "minecraft:gray_bed" | "caveopolis:purple_colored_stone_brick_wall" | "lfpirates:sailor_gray_tier_2_body_recipe_1" | "farmersdelight:basket" | "storagedrawers:crimson_full_drawers_4" | "minecraft:white_terracotta" | "thermal:machines/pulverizer/pulverizer_copper_ore" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/red_colored_stone_bricks_brick_stairs" | "storagedrawers:crimson_full_drawers_2" | "minecraft:diamond_from_blasting_deepslate_diamond_ore" | "storagedrawers:quantify_key" | "storagedrawers:crimson_full_drawers_1" | "minecraft:armor_stand" | "caveopolis:blue_colored_wood" | "thermal_extra:machine/dynamo/compression/refined_sunflower_oil" | "thermal:machines/bottler/bottler_black_concrete" | "minecraft:pink_stained_glass_pane" | "caveopolis:light_gray_colored_wooden_plank_fence_from_light_gray_colored_wooden_planks_stonecutting" | "minecraft:blue_dye_from_cornflower" | "minecraft:stripped_cherry_wood" | "sophisticatedbackpacks:chipped/alchemy_bench_upgrade" | "mysticalagriculture:essence/minecraft/oak_sapling" | "mysticalagriculture:essence/common/aluminum_ingot" | "minecraft:quartz_slab_from_stonecutting" | "minecraft:brown_banner" | "farmersdelight:tomato_crate" | "minecraft:warped_hyphae" | "thermal:compat/create/press_create_zinc_unpacking" | "thermal:storage/nickel_nugget_from_ingot" | "mysticalagriculture:seed/reprocessor/tin" | "caveopolis:cyan_colored_wooden_plank_button_from_cyan_colored_wooden_planks_stonecutting" | "strainers:brewer_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "supplementaries:checker_slab" | "opolisutilities:catalogue/selling/caveopolis/spray_can_remover" | "thermal:machines/press/press_eggplant_packing" | "strainers:angler_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "mysticalagriculture:essence/botania/white_mystical_flower" | "caveopolis:sprayer/stripped_colored_logs/black" | "caveopolis:sprayer/stripped_colored_wood/light_blue" | "mysticalagriculture:essence/minecraft/music_disc_13" | "strainers:upgrade_stats/specialized_output_upgrade" | "aquamirae:abyssal_heaume" | "mysticalagriculture:essence/minecraft/music_disc_11" | "industrialforegoing:laser_drill_ore/ores/fluorite" | "mysticalagriculture:seed/infusion/diamond" | "caveopolis:black_colored_wooden_plank_fence" | "mysticalagriculture:seed/crafting/coal" | "strainers:spruce_sapling_from_straining_barrier_in_minecraft_air" | "minecraft:green_bed" | "thermal:smelting/cooked_corn_from_campfire_cooking" | "strainers:potato_from_straining_mulch_in_minecraft_water" | "mysticalagradditions:insanium_ingot" | "cozy_home:lamp_white_recipe" | "strainers:summoning_block/pig" | "thermal_extra:storage/soul_infused_ingot_from_block" | "caveopolis:sprayer/colored_leaves/purple" | "industrialforegoing:block_breaker" | "minecraft:red_sandstone_slab_from_red_sandstone_stonecutting" | "mysticalagriculture:essence/minecraft/gunpowder" | "caveopolis:pink_colored_wooden_plank_fence_gate_from_pink_colored_wooden_planks_stonecutting" | "caveopolis:brown_colored_stone_stairs_from_brown_colored_stone_stonecutting" | "caveopolis:pink_colored_cobblestone_brick_wall" | "thermal:compat/biomesoplenty/insolator_bop_glowshroom_mushroom" | "mysticalagriculture:essence/botania/orange_mystical_flower" | "thermal:machines/press/unpacking/press_rubber_unpacking" | "farmersdelight:painting_from_canvas" | "caveopolis:sprayer/colored_stone/brown_colored_stone" | "caveopolis:sprayer/colored_wooden_plank_slab/yellow" | "oceansdelight:seagrass_salad" | "thermal:compat/biomesoplenty/tree_extractor_bop_mahogany" | "lfpirates:craftsman_boots_recipe_1" | "mysticalagriculture:essence/botania/purple_mystical_flower" | "caveopolis:sprayer/colored_stone_slab/green_colored_stone_slab" | "strainers:upgrades/reinforced/reinforced_duration_upgrade" | "thermal:compat/immersiveengineering/smelter_ie_uranium_ore" | "minecraft:prismarine_brick_slab_from_prismarine_stonecutting" | "thermal:storage/lumium_block" | "thermal_extra:storage/twinite_ingot_from_block" | "strainers:turtle_egg_from_straining_egg_in_strainers_purified_water_fluid" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_cut_copper_stonecutting" | "caveopolis:sprayer/colored_wooden_plank_door/lime" | "minecraft:gray_banner" | "alltheores:mek_processing/aluminum/crystal/from_slurry" | "minecraft:warped_stairs" | "smallships:oak_brigg" | "caveopolis:sprayer/beds/orange" | "industrialforegoing:simple_black_hole_tank" | "alltheores:enderium_ingot_from_block" | "caveopolis:blue_colored_cobblestone_slab_from_blue_colored_cobblestone_stonecutting" | "caveopolis:white_colored_stone_pressure_plate" | "alltheores:tools_materials/uranium/uranium_from_nugget" | "caveopolis:green_colored_wooden_plank_stairs" | "minecraft:smooth_sandstone_slab" | "strainers:upgrade_stats/sturdy_mesh_upgrade" | "caveopolis:light_gray_colored_wooden_plank_stairs_from_light_gray_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/colored_cobblestone/brown_colored_stone" | "strainers:upgrade_stats/specialized_mesh_upgrade" | "caveopolis:magenta_colored_stone_slab_from_magenta_colored_stone_stonecutting" | "thermal:parts/quartz_gear" | "minecraft:rail" | "mysticalagriculture:stonecutting/soulstone_bricks_slabs_from_soulstone_bricks" | "industrialforegoing:animal_baby_separator" | "caveopolis:sprayer/colored_stone_buttons/cyan" | "minecraft:diamond_sword" | "thermal:machines/crystallizer/crystallizer_emerald" | "alltheores:tools_materials/nickel/nickel_from_block" | "farmersdelight:cutting/oak_trapdoor" | "thermal:machines/press/press_strawberry_packing" | "thermal:compat/mysticalagriculture/insolator_mysticalag_electrum_seeds" | "alltheores:tools_materials/tin/tin_from_nugget" | "mysticalagriculture:seed/reprocessor/graphite" | "farmersdelight:cooking/dumplings" | "thermal:spring_salad" | "caveopolis:sprayer/colored_cobblestone_brick_slab/brown" | "thermal_extra:machine/pulverizer/amethyst_dust" | "caveopolis:purple_colored_wood" | "opolisutilities:gold_horse_armor" | "caveopolis:sprayer/colored_stone_buttons/brown" | "mysticalagradditions:essence/neutronium_nugget" | "industrialforegoing:laser_drill_ore/lapis" | "mysticalagriculture:seed/reprocessor/grains_of_infinity" | "caveopolis:sprayer/beds/blue" | "thermal:machines/smelter/smelter_silver_ore" | "industrialforegoing:conveyor_insertion_upgrade" | "caveopolis:purple_colored_stone_slab" | "caveopolis:black_colored_stone_bricks_from_black_colored_stone_stonecutting" | "cozy_home:spruce_wall_clock_recipe" | "thermal:machines/centrifuge/centrifuge_slime_mushroom_spores" | "alltheores:netherite_dust_from_hammer_crushing" | "minecraft:polished_blackstone_from_blackstone_stonecutting" | "thermal_extra:storage/soul_infused_block" | "mysticalagradditions:tconstruct/casting/prudentium/ingot_sand_cast" | "thermal:fuels/numismatic/numismatic_enderium_coin" | "libraryferret:smelting/diamond_coins_jtl" | "thermal:compat/immersiveengineering/pulverizer_ie_aluminum_ingot_to_dust" | "cozy_home:drawer_acacia_recipe" | "thermal:machines/press/unpacking/press_iron_unpacking" | "minecraft:polished_blackstone_brick_stairs_from_polished_blackstone_bricks_stonecutting" | "mysticalagriculture:seed/reprocessor/nature" | "farmersdelight:book_from_canvas" | "mysticalagriculture:augment/poison_resistance" | "thermal:fuels/stirling/stirling_coal_coke_block" | "alltheores:tin_ingot" | "minecraft:crimson_planks" | "minecraft:smooth_red_sandstone" | "thermal:machines/pulverizer/pulverizer_steel_ingot_to_dust" | "mysticalagriculture:seed/crafting/energetic_alloy" | "caveopolis:sprayer/glass_block/white" | "mysticalagriculture:supremium_ingot_block" | "caveopolis:sprayer/colored_hanging_signs/red" | "caveopolis:cyan_colored_stone_button_from_cyan_colored_stone_stonecutting" | "mysticalagriculture:essence/minecraft/dark_oak_log" | "alltheores:tools_materials/zinc/zinc_from_block" | "alltheores:mek_processing/aluminum/ore/nether_from_raw" | "alltheores:mek_processing/zinc/clump/from_ore" | "thermal:machines/press/packing3x3/press_copper_nugget_packing" | "caveopolis:light_gray_colored_wooden_plank_slab" | "sophisticatedbackpacks:advanced_pickup_upgrade" | "caveopolis:lime_colored_hanging_sign" | "thermal:machines/press/press_netherite_ingot_to_gear" | "thermal:compat/tconstruct/press_tconstruct_queens_slime_unpacking" | "thermal:machines/press/packing3x3/press_raw_silver_packing" | "caveopolis:yellow_colored_wooden_plank_slab" | "thermal:fuels/gourmand/gourmand_tomato_block" | "systeams:boilers/numismatic" | "suppsquared:item_shelf_cherry" | "minecraft:mangrove_planks" | "caveopolis:sprayer/colored_signs/purple" | "caveopolis:sprayer/banners/light_blue" | "thermal:compat/create/bottler_create_chocolate_glazed_berries" | "mysticalagradditions:essence/dragon_egg_chunk" | "minecraft:iron_nugget_from_blasting" | "mysticalagriculture:essence/minecraft/rabbit" | "thermal:machines/refinery/refinery_crude_oil" | "caveopolis:sprayer/colored_stone_wall/red_colored_stone_wall" | "thermal:machines/press/unpacking/press_potato_unpacking" | "thermal:compat/tconstruct/press_tconstruct_sky_slime_3x3_packing" | "thermal:devices/potion_diffuser/potion_diffuser_boost_redstone_dust" | "thermal:filter_attachment_2" | "thermal:machines/press/unpacking/press_raw_silver_unpacking" | "caveopolis:blue_spray_can" | "opolisutilities:catalogue/selling/caveopolis/light_gray_spray_can" | "caveopolis:orange_colored_stone_brick_slab_from_orange_colored_stone_bricks_stonecutting" | "caveopolis:sprayer/colored_stone_crafting_table/white" | "farmersdelight:integration/immersiveengineering/cloche/onion" | "thermal:parts/lapis_gear" | "supplementaries:inspirations/blackboard_clear" | "cozy_home:counter_mangrove_sink_recipe" | "strainers:danger_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "thermal:machines/insolator/insolator_spruce_sapling" | "thermal:fuels/gourmand/gourmand_eggplant_block" | "minecraft:green_stained_glass_pane" | "lfpirates:corsair_tier_3_helmet_recipe_1" | "minecraft:magenta_dye_from_blue_red_pink" | "farmersdelight:red_hanging_canvas_sign" | "alltheores:smelting_dust/uranium_ingot" | "minecraft:black_concrete_powder" | "mysticalagriculture:seed/reprocessor/cow" | "caveopolis:sprayer/colored_hanging_signs/light_gray" | "minecraft:lime_carpet" | "minecraft:sugar_from_sugar_cane" | "cozy_home:lamp_magenta_recipe" | "thermal:augments/machine_efficiency_augment" | "mysticalagradditions:prudentium_coal" | "caveopolis:sprayer/colored_hanging_signs/yellow" | "caveopolis:red_colored_wooden_plank_fence_gate" | "alltheores:uranium_block" | "minecraft:cooked_beef_from_campfire_cooking" | "minecraft:quartz_pillar" | "farmersdelight:cutting/leather_leggings" | "thermal:fuels/magmatic/magmatic_lava" | "sophisticatedbackpacks:jukebox_upgrade" | "alltheores:constantan_nugget_from_ingot" | "tmttd:cooking/jelly" | "minecraft:dye_red_wool" | "caveopolis:sprayer/colored_cobblestone_stairs/orange_colored_stone_stairs" | "caveopolis:sprayer/colored_cobblestone_wall/lime_colored_stone_wall" | "minecraft:waxed_cut_copper_from_honeycomb" | "mysticalagriculture:essence/minecraft/heart_of_the_sea" | "thermal:compat/tconstruct/press_tconstruct_cobalt_unpacking" | "caveopolis:sprayer/refill/pink" | "aquaculture:stone_fillet_knife" | "caveopolis:cyan_colored_cobblestone_brick_slab_from_cyan_colored_cobblestone_bricks_stonecutting" | "thermal:machines/smelter/smelter_raw_silver" | "aquamirae:three_bolt_suit" | "thermal:machines/centrifuge/centrifuge_oil_sand" | "thermal:machines/smelter/smelter_glass_enderium" | "mysticalagriculture:gear/inferium_shears" | "thermal:compat/tconstruct/tree_extractor_tconstruct_earth_slime" | "minecraft:blue_dye" | "minecraft:polished_diorite_slab_from_polished_diorite_stonecutting" | "thermal:smelting/bronze_ingot_from_dust_blasting" | "farmersdelight:organic_compost_from_rotten_flesh" | "thermal:machines/press/packing3x3/press_invar_nugget_packing" | "minecraft:muddy_mangrove_roots" | "mysticalagriculture:essence/minecraft/gray_dye" | "thermal:machines/smelter/smelter_invar_armor" | "smallships:birch_galley" | "suppsquared:candle_holders/gold_candle_holder_white" | "thermal:fluid_duct_windowed_4" | "mysticalagriculture:essence/tconstruct/slimesteel_ingot" | "thermal:machines/press/packing3x3/press_beetroot_packing" | "thermal:machines/press/unpacking/press_beetroot_unpacking" | "caveopolis:green_colored_stone_brick_slab" | "cozy_home:desk_cherry_recipe" | "minecraft:light_gray_banner" | "caveopolis:gray_colored_cobblestone_brick_wall" | "farmersdelight:cutting/mangrove_sign" | "minecraft:wooden_axe" | "caveopolis:marble_bricks_from_marble_stonecutting" | "mysticalagriculture:soulstone_bricks_wall" | "caveopolis:light_blue_colored_wooden_plank_slab_from_light_blue_colored_wooden_planks_stonecutting" | "mysticalagriculture:stonecutting/soulstone_bricks_wall_from_soulstone_bricks" | "mysticalagriculture:essence/minecraft/light_blue_dye" | "opolisutilities:resource_generator/mods/caveopolis/brown_colored_stone" | "thermal:machines/smelter/smelter_cured_rubber" | "thermal_extra:parts/shellite_gear" | "mysticalagriculture:enchanter/blast_protection" | "caveopolis:magenta_colored_wooden_plank_stairs" | "supplementaries:daub_brace" | "minecraft:trapped_chest" | "industrialforegoing:conveyor_blinking_upgrade" | "caveopolis:sprayer/colored_stone_brick_wall/pink_colored_stone_brick_wall" | "thermal:machines/smelter/smelter_bronze_plate_to_ingot" | "minecraft:stone_stairs_from_stone_stonecutting" | "caveopolis:purple_colored_wooden_plank_door" | "alltheores:tin_ingot_from_raw_blasting" | "mysticalagriculture:essence/mekanism/refined_obsidian_ingot" | "thermal:machines/press/packing3x3/press_lumium_packing" | "caveopolis:sprayer/colored_wooden_plank_fence/red" | "industrialforegoing:laser_drill_ore/emerald" | "thermal:compat/dyenamics/bottler_dyenamics_mint_concrete" | "minecraft:dried_kelp" | "industrialforegoing:enchantment_sorter" | "caveopolis:red_colored_cobblestone_brick_slab" | "caveopolis:stripped_gray_colored_wood" | "minecraft:polished_andesite_stairs_from_andesite_stonecutting" | "minecraft:iron_bars" | "mysticalagriculture:gear/awakened_supremium_hoe" | "thermal:compat/create/centrifuge_create_crushed_raw_copper" | "alltheores:enderium_ingot" | "mysticalagriculture:seed/reprocessor/mithril" | "caveopolis:sprayer/colored_cobblestone_brick_slab/pink" | "caveopolis:sprayer/colored_wooden_plank_door/black" | "industrialforegoing:laser_drill_ore/raw_materials/cinnabar" | "supplementaries:flags/flag_magenta" | "caveopolis:sprayer/colored_wood/orange" | "mysticalagriculture:essence/minecraft/charcoal" | "minecraft:diamond_axe" | "mysticalagriculture:essence/minecraft/green_dye" | "caveopolis:sprayer/colored_wooden_plank_stairs/gray" | "thermal:compat/dyenamics/bottler_dyenamics_fluorescent_concrete" | "supplementaries:candle_holders/candle_holder_red" | "thermal:parts/invar_gear" | "thermal:machines/insolator/insolator_brain_coral" | "strainers:upgrades/everlasting/everlasting_everything_upgrade" | "cozy_home:jungle_bench_recipe" | "alltheores:tools_materials/nickel/nickel_from_nugget" | "lfpirates:sailor_red_tier_3_boots_recipe_1" | "mysticalagriculture:seed/infusion/copper" | "minecraft:dark_oak_pressure_plate" | "minecraft:dye_blue_wool" | "thermal:machines/pulverizer/pulverizer_enderium_ingot_to_dust" | "alltheores:mek_processing/nickel/ore/from_dust" | "strainers:summoning_block/rabbit" | "mysticalagriculture:awakened_supremium_upgrade" | "thermal:storage/bronze_ingot_from_nuggets" | "alltheores:raw_lead_from_block" | "mysticalagradditions:tertium_paxel" | "minecraft:waxed_cut_copper" | "mysticalagriculture:guide_book" | "thermal:machines/pulverizer/pulverizer_electrum_plate_to_dust" | "minecraft:chiseled_polished_blackstone" | "thermal:compat/quark/press_quark_nether_wart_packing" | "thermal:frost_melon_seeds" | "cozy_home:lamp_black_recipe" | "mysticalagriculture:gear/supremium_boots" | "thermal:machines/pulverizer/pulverizer_catalyst_flint" | "thermal:compat/biomesoplenty/sawmill_bop_umbran_logs" | "industrialforegoing:mycelial_explosive" | "lfpirates:sailor_nordic_tier_2_leggins_recipe_1" | "alltheores:smelting_dust/aluminum_ingot" | "lfpirates:sailor_red_tier_2_leggins_recipe_1" | "lfpirates:sailor_blue_tier_2_body_recipe_1" | "minecraft:mud_brick_wall_from_mud_bricks_stonecutting" | "mysticalagriculture:seed/crafting/end_steel" | "minecraft:food_serving" | "mysticalagriculture:seed/infusion/blazing_crystal" | "lfpirates:sailor_red_tier_3_helmet_recipe_1" | "minecraft:red_banner" | "caveopolis:sprayer/colored_leaves/light_gray" | "thermal:compat/mysticalagriculture/insolator_mysticalag_manasteel_seeds" | "thermal:storage/rosin_block" | "caveopolis:magenta_colored_wooden_plank_fence_gate" | "thermal:machines/pulverizer/pulverizer_blitz_rod" | "caveopolis:white_colored_stone_brick_wall_from_white_colored_stone_bricks_stonecutting" | "thermal:slime_tnt" | "matc:tertium_essence" | "caveopolis:sprayer/colored_stone_brick_slab/pink_colored_stone_brick_slab" | "storagedrawers:controller_slave" | "caveopolis:sprayer/wool/purple_wool" | "thermal:machines/press/press_lumium_nugget_to_coin" | "farmersdelight:cutting/cherry_trapdoor" | "alltheores:mek_processing/silver/slurry/from_raw_ore" | "mysticalagriculture:souls/ender_pearl" | "thermal:lumium_detector_rail" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/pink" | "thermal:compat/farmersdelight/insolator_farmersdelight_rice" | "farmersdelight:cutting/apple_pie" | "industrialforegoing:enchantment_applicator" | "minecraft:black_carpet" | "glassential:glass_ghostly" | "caveopolis:sprayer/sprayer_block" | "caveopolis:sprayer/colored_cobblestone_slab/light_blue_colored_stone_slab" | "caveopolis:black_colored_wood" | "thermal:storage/beetroot_from_block" | "minecraft:dye_magenta_wool" | "alltheores:brass_rod" | "minecraft:deepslate_tile_stairs_from_deepslate_tiles_stonecutting" | "thermal:machines/pulverizer/pulverizer_diamond_tools" | "thermal:compat/mekanism/press_mek_osmium_nugget_packing" | "caveopolis:sprayer/concrete/blue" | "caveopolis:white_colored_stone_brick_stairs_from_white_colored_stone_bricks_stonecutting" | "mysticalagriculture:gear/supremium_shovel" | "minecraft:waxed_oxidized_cut_copper_slab_from_honeycomb" | "farmersdelight:bacon_and_eggs" | "thermal:lumium_crossover_rail" | "caveopolis:lime_colored_wooden_plank_slab_from_lime_colored_wooden_planks_stonecutting" | "caveopolis:purple_colored_stone_bricks" | "industrialforegoing:fluid_extractor" | "supplementaries:lapis_brick_wall" | "thermal:earth_charge/emerald_dust_from_emerald" | "alltheores:mek_processing/silver/ingot/from_dust_blasting" | "caveopolis:sprayer/colored_wooden_plank_stairs/magenta" | "industrialforegoing:item_transporter_type" | "opolisutilities:resource_generator_2/speed_blocks/steel" | "caveopolis:sprayer/glass_pane/green" | "opolisutilities:resource_generator_2/speed_blocks/silver" | "thermal:devices/tree_extractor/tree_extractor_boost_phytogro" | "mysticalagradditions:prudentium_apple" | "minecraft:torch" | "minecraft:polished_granite_stairs" | "caveopolis:black_colored_wooden_planks" | "industrialforegoing:dissolution_chamber/range_addon11" | "caveopolis:orange_colored_stone_stairs_from_orange_colored_stone_stonecutting" | "mysticalagriculture:essence/redstone_arsenal/flux_ingot" | "industrialforegoing:dissolution_chamber/range_addon10" | "mysticalagradditions:tconstruct/casting/prudentium/ingot_gold_cast" | "thermal:machines/bottler/bottler_brown_concrete" | "thermal:earth_charge_3" | "supplementaries:stone_tile_slab" | "strainers:bubble_coral_from_straining_barrier_in_minecraft_water" | "alltheores:iridium_plate" | "alltheores:mek_processing/iridium/ore/from_raw" | "industrialforegoing:mycelial_crimed" | "farmersdelight:cutting/acacia_hanging_sign" | "mysticalagriculture:seed/reprocessor/marble" | "mysticalagriculture:essence/minecraft/cobblestone" | "cozy_home:grandfather_clock_crimson_recipe" | "thermal:smelting/cinnabar_from_smelting" | "caveopolis:sprayer/colored_wooden_plank_stairs/light_gray" | "thermal:machines/smelter/smelter_lumium_plate_to_ingot" | "caveopolis:blue_colored_stone_brick_slab" | "thermal:potion_cake" | "thermal:machines/insolator/insolator_slime_mushroom" | "caveopolis:black_colored_stone_stairs" | "mysticalagriculture:prudentium_ingot_recraft" | "caveopolis:light_gray_colored_wood" | "smallships:spruce_brigg" | "thermal:compat/farmersdelight/insolator_farmersdelight_onion" | "cozy_home:counter_oak_recipe" | "caveopolis:sprayer/colored_wooden_plank_door/light_gray" | "minecraft:sandstone_wall" | "minecraft:cut_copper_slab" | "lfpirates:sailor_red_tier_1_boots_recipe_1" | "caveopolis:cyan_colored_cobblestone_stairs" | "thermal:compat/immersiveengineering/compression_ie_biodiesel" | "thermal:smelting/lumium_ingot_from_dust_smelting" | "mysticalagriculture:gear/prudentium_axe" | "caveopolis:sprayer/colored_cobblestone_wall/purple_colored_stone_wall" | "mysticalagriculture:essence/enderio/end_steel_ingot" | "thermal_extra:machine/press/soul_infused_plate" | "minecraft:cherry_slab" | "caveopolis:sprayer/colored_stone_buttons/magenta" | "lfpirates:sailor_nordic_tier_3_helmet_recipe_1" | "thermal:machines/smelter/smelter_iron_dust" | "alltheores:electrum_rod" | "mysticalagriculture:hostile_soulium_dagger" | "supplementaries:jar" | "aquaculture:acacia_fish_mount" | "minecraft:stripped_acacia_wood" | "caveopolis:cyan_colored_cobblestone_stairs_from_cyan_colored_cobblestone_stonecutting" | "cozy_home:grandfather_clock_bamboo_recipe" | "strainers:summoning_block/zombie" | "thermal:compat/create/bottler_create_sweet_roll" | "strainers:granite_from_straining_barrier_in_strainers_purified_water_fluid" | "alltheores:raw_silver_block" | "mysticalagriculture:augment/mining_aoe_iv" | "industrialforegoing:fluid_sieving_machine" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/brown" | "farmersdelight:cutting/mangrove_log" | "caveopolis:purple_colored_stone_button_from_purple_colored_stone_stonecutting" | "supplementaries:lock_block" | "lfpirates:sailor_red_tier_2_body_recipe_1" | "caveopolis:brown_colored_stone_pressure_plate" | "minecraft:orange_bed" | "alltheores:tools_materials/silver/silver_from_nugget" | "cozy_home:mangrove_chair_recipe" | "mysticalagriculture:seed/infusion/fluix" | "caveopolis:sprayer/remove_color/wooden_plank_slabs" | "opolisutilities:resource_generator_2/speed_blocks/electrum" | "mysticalagriculture:augment/mining_aoe_ii" | "cozy_home:desk_oak_recipe" | "thermal:smelting/rose_gold_ingot_from_dust_blasting" | "mysticalagriculture:supremium_farmland_till" | "thermal_extra:storage/soul_infused_ingot_from_nuggets" | "caveopolis:pink_colored_cobblestone_wall_from_pink_colored_cobblestone_stonecutting" | "lfpirates:sailor_gray_tier_3_leggins_recipe_1" | "thermal:augments/potion_duration_augment" | "minecraft:red_stained_glass_pane" | "alltheores:electrum_plate" | "mysticalagriculture:seed/crafting/enderman" | "minecraft:brick_wall" | "caveopolis:lime_colored_wooden_plank_button_from_lime_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/terracotta/brown" | "caveopolis:sprayer/colored_wooden_plank_door/green" | "thermal:machines/pulverizer/pulverizer_ender_pearl" | "mysticalagradditions:tconstruct/casting/soulium/ingot_gold_cast" | "mysticalagriculture:essence/minecraft/wheat" | "thermal:machines/pulverizer/pulverizer_raw_silver" | "thermal:compat/biomesoplenty/tree_extractor_bop_yellow_autumn" | "thermal:compat/immersiveengineering/press_ie_raw_uranium_unpacking" | "thermal:compat/create/pulverizer_create_diorite_recycle" | "tmttd:machines/press/cabbage_crate_press" | "mysticalagriculture:essence/minecraft/cobbled_deepslate" | "thermal:storage/bamboo_from_block" | "strainers:skeleton_skull_from_straining_bone_block_in_strainers_eroding_water_fluid" | "mysticalagradditions:tconstruct/tools/casting/inferium" | "minecraft:dark_oak_planks" | "aquaculture:neptunium_hoe" | "aquamirae:bone_meal_from_remnants_saber" | "minecraft:granite_wall" | "industrialforegoing:laser_drill_ore/raw_materials/copper" | "mysticalagriculture:seed/reprocessor/terrasteel" | "thermal:smelting/tin_ingot_from_ore_smelting" | "opolisutilities:catalogue/selling/caveopolis/black_spray_can" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/cyan" | "industrialforegoing:conveyor" | "mysticalagriculture:essence/minecraft/ink_sac" | "caveopolis:sprayer/stripped_colored_logs/green" | "thermal:augments/machine_null_augment" | "mysticalagriculture:essence/minecraft/blue_dye" | "minecraft:exposed_cut_copper_from_exposed_copper_stonecutting" | "thermal:device_soil_infuser" | "mysticalagriculture:tertium_essence" | "minecraft:mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/light_blue" | "cozy_home:counter_acacia_storage_recipe" | "minecraft:diamond_helmet" | "thermal:augments/upgrade_augment_3" | "minecraft:warped_fence" | "strainers:powder_snow_bucket_from_straining_water_bucket_in_minecraft_blue_ice" | "thermal:augments/upgrade_augment_1" | "thermal:augments/upgrade_augment_2" | "nec:caveop_green_colored_wooden_chest" | "minecraft:dark_oak_fence_gate" | "igleelib:derium_ingot" | "farmersdelight:cutting/oak_door" | "mysticalagriculture:essence/minecraft/light_gray_dye" | "thermal:rubberwood_trapdoor" | "mysticalagriculture:soulstone_slab" | "strainers:upgrades/sturdy/sturdy_output_upgrade" | "minecraft:compass" | "caveopolis:sprayer/remove_color/wooden_plank_fences" | "aquamirae:cyan_dye_from_elodea" | "caveopolis:magenta_colored_wooden_plank_stairs_from_magenta_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/stripped_colored_wood/blue" | "minecraft:loom" | "thermal:machines/press/unpacking/press_redstone_unpacking" | "farmersdelight:cutting/cake" | "supplementaries:sign_post_spruce" | "caveopolis:magenta_colored_stone_button_from_magenta_colored_stone_stonecutting" | "caveopolis:light_blue_colored_stone" | "caveopolis:sprayer/colored_cobblestone_brick_wall/gray_colored_stone_brick_wall" | "mysticalagriculture:gear/prudentium_bow" | "thermal:smelting/cooked_corn_from_smelting" | "thermal:machines/chiller/chiller_glowstone_to_glowstone_block" | "thermal:compat/tconstruct/press_tconstruct_sky_slime_2x2_unpacking" | "strainers:poppy_from_straining_grass_in_strainers_purified_water_fluid" | "caveopolis:blue_colored_wooden_plank_stairs" | "mysticalagriculture:gear/tertium_scythe" | "sophisticatedbackpacks:smoking_upgrade_from_smelting_upgrade" | "mysticalagriculture:tertium_furnace" | "thermal:machines/press/press_tin_ingot_to_coin" | "simplehats:hatbag_festive" | "mysticalagriculture:augment/mining_aoe_iii" | "tmttd:cooking/xp_stew" | "caveopolis:sprayer/colored_cobblestone/red_colored_stone" | "mysticalagradditions:gaia_spirit_crux" | "caveopolis:gray_colored_stone_brick_slab_from_gray_colored_stone_bricks_stonecutting" | "caveopolis:purple_colored_cobblestone_brick_slab" | "industrialforegoing:common_black_hole_tank" | "thermal:storage/enderium_block" | "thermal:compat/mysticalagriculture/insolator_mysticalag_dirt_seeds" | "sophisticatedbackpacks:everlasting_upgrade" | "supplementaries:flax_block" | "thermal:machines/press/press_invar_ingot_to_coin" | "thermal:machines/press/packing2x2/press_bricks_packing" | "farmersdelight:cutting/sweet_berry_cheesecake" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/magenta" | "minecraft:gray_stained_glass_pane" | "caveopolis:green_colored_hanging_sign_from_stripped_green_colored_log_stonecutting" | "suppsquared:candle_holders/gold_candle_holder_pink" | "thermal:compat/mysticalagriculture/insolator_mysticalag_emerald_seeds" | "supplementaries:flags/flag_from_banner" | "opolisutilities:catalogue/selling/caveopolis/white_spray_can" | "thermal:machines/smelter/smelter_lead_plate_to_ingot" | "thermal:machines/centrifuge/centrifuge_magenta_rockwool" | "mysticalagriculture:seed/infusion/stone" | "storagedrawers:crimson_half_drawers_4" | "minecraft:polished_blackstone" | "storagedrawers:crimson_half_drawers_1" | "mysticalagriculture:essence/minecraft/cherry_sapling" | "storagedrawers:crimson_half_drawers_2" | "cozy_home:dark_oak_bench_recipe" | "caveopolis:blue_colored_stone_stairs_from_blue_colored_stone_stonecutting" | "minecraft:bamboo_mosaic_slab" | "caveopolis:sprayer/remove_color/wooden_planks" | "strainers:red_sand_from_straining_granite_in_strainers_eroding_water_fluid" | "caveopolis:sprayer/colored_stone_slab/orange_colored_stone_slab" | "thermal:machines/pulverizer/pulverizer_catalyst_basalz_powder" | "oceansdelight:cooked_guardian_tail" | "minecraft:spire_armor_trim_smithing_template" | "caveopolis:sprayer/terracotta/pink" | "minecraft:stone_axe" | "tmttd:cooking/t_tomato_sauce" | "thermal:cheese_wedge_from_wheel" | "thermal:rockwool/purple_rockwool_from_dye" | "minecraft:dye_purple_carpet" | "mysticalagriculture:essence/minecraft/porkchop" | "thermal:stripped_rubberwood_wood" | "thermal:machines/insolator/insolator_beetroot" | "thermal:compat/redstone_arsenal/pulverizer_rsa_flux_ingot_to_dust" | "supplementaries:soap_block" | "opolisutilities:resource_generator_2/speed_blocks/aluminum" | "cozy_home:cherry_chair_recipe" | "mysticalagriculture:gear/imperium_leggings" | "minecraft:light_blue_stained_glass" | "thermal:machines/press/press_rose_gold_ingot_to_coin" | "alltheores:osmium_ingot" | "caveopolis:black_colored_wooden_plank_button" | "minecraft:deepslate_brick_slab" | "theoneprobe:diamond_helmet_probe" | "thermal:fire_charge/signalum_glass_2" | "dankstorage:dock" | "minecraft:polished_blackstone_brick_stairs_from_blackstone_stonecutting" | "industrialforegoing:fluid_collector" | "alltheores:mek_processing/aluminum/dust/from_ingot" | "thermal:machines/bottler/bottler_green_concrete" | "mysticalagriculture:seed/infusion/zombie" | "caveopolis:red_colored_cobblestone_slab" | "thermal:machines/sawmill/sawmill_mangrove_logs" | "caveopolis:orange_colored_stone_crafting_table" | "mysticalagriculture:seed/crafting/pulsating_alloy" | "lfpirates:skull_1_recipe_1" | "mysticalagriculture:tertium_upgrade" | "farmersdelight:cutting/spruce_hanging_sign" | "thermal:redstone_tnt_minecart" | "caveopolis:sprayer/colored_wooden_plank_slab/blue" | "sophisticatedbackpacks:compacting_upgrade" | "thermal:fuels/lapidary/lapidary_diamond" | "farmersdelight:kelp_roll" | "mysticalagriculture:soulium_ingot_block" | "mysticalagriculture:souls/porkchop" | "mysticalagriculture:seed/infusion/cyanite" | "thermal:storage/invar_nugget_from_ingot" | "minecraft:iron_axe" | "thermal:compat/tconstruct/press_tconstruct_amethyst_bronze_packing" | "mysticalagriculture:seed/crafting/elementium" | "mysticalagriculture:seed/crafting/knightmetal" | "supplementaries:crystal_display" | "caveopolis:magenta_colored_cobblestone_wall" | "minecraft:jukebox" | "thermal:aquachow_4" | "caveopolis:green_colored_wooden_plank_slab_from_green_colored_wooden_planks_stonecutting" | "caveopolis:yellow_colored_cobblestone_wall" | "caveopolis:yellow_colored_wooden_plank_fence_gate" | "mysticalagriculture:essence/minecraft/birch_log" | "lfpirates:sailor_nordic_tier_2_body_recipe_1" | "farmersdelight:carrot_from_crate" | "thermal:rockwool/white_rockwool_from_smelting" | "mysticalagriculture:gear/tertium_fishing_rod" | "thermal:redstone_servo" | "minecraft:acacia_sign" | "thermal:prismarine_crossover_rail" | "minecraft:chest_minecart" | "sawmill:sawmill" | "caveopolis:light_gray_colored_wooden_plank_button_from_light_gray_colored_wooden_planks_stonecutting" | "thermal:smelting/steel_ingot_from_dust_smelting" | "mysticalagriculture:seed/infusion/mithril" | "cozy_home:sofa_pink_recipe" | "caveopolis:brown_colored_wooden_plank_stairs_from_brown_colored_wooden_planks_stonecutting" | "thermal:compat/mysticalagriculture/insolator_mysticalag_apatite_seeds" | "suppsquared:candle_holders/gold_candle_holder_black" | "thermal:machines/press/unpacking/press_snow_unpacking" | "thermal:compat/immersiveengineering/press_ie_hemp_to_plantoil" | "minecraft:decorated_pot" | "caveopolis:sprayer/candles/gray" | "minecraft:magenta_terracotta" | "minecraft:baked_potato_from_campfire_cooking" | "caveopolis:yellow_colored_wooden_plank_door" | "lfpirates:hook_recipe_1" | "mysticalagriculture:seed/reprocessor/enderman" | "mysticalagradditions:tconstruct/casting/supremium/nugget_gold_cast" | "caveopolis:marble_wall_from_marble_stonecutting" | "mysticalagriculture:essence/common/constantan_ingot" | "strainers:dark_oak_sapling_from_straining_barrier_in_minecraft_air" | "caveopolis:sprayer/colored_signs/light_blue" | "minecraft:deepslate_bricks_from_polished_deepslate_stonecutting" | "alltheores:gold_ingot_from_dust" | "thermal:machines/insolator/insolator_fire_coral" | "opolisutilities:redstone_clock" | "matc:crystals/inferium" | "mysticalagriculture:enchanter/riptide" | "thermal:machines/pulverizer/pulverizer_glowstone_block" | "minecraft:tide_armor_trim_smithing_template" | "caveopolis:glowstone_spray_can" | "thermal:compat/mysticalagriculture/insolator_mysticalag_inferium_seeds" | "thermal:cyan_concrete_powder_with_slag" | "caveopolis:sprayer/colored_stone_crafting_table/orange" | "smallships:cherry_drakkar" | "caveopolis:sprayer/colored_wooden_plank_door/white" | "mysticalagriculture:seed/reprocessor/awakened_draconium" | "cozy_home:crimson_wall_clock_recipe" | "caveopolis:sprayer/colored_cobblestone_stairs/black_colored_stone_stairs" | "minecraft:cobblestone_stairs_from_cobblestone_stonecutting" | "thermal:ice_grenade_4" | "minecraft:crimson_door" | "opolisutilities:resource_generator/resource_generator" | "alltheores:mek_processing/iridium/clump/from_ore" | "smallships:bamboo_drakkar" | "industrialforegoing:infinity_charger" | "opolisutilities:resource_generator_2/speed_blocks/netherite" | "nec:warped_chest" | "suppsquared:copper_plaque" | "minecraft:end_stone_bricks" | "strainers:upgrades/everlasting/everlasting_input_upgrade" | "caveopolis:sprayer/colored_signs/pink" | "caveopolis:sprayer/colored_wooden_plank_slab/lime" | "minecraft:red_stained_glass_pane_from_glass_pane" | "minecraft:waxed_cut_copper_stairs_from_waxed_copper_block_stonecutting" | "caveopolis:white_colored_stone_button" | "supplementaries:candle_holders/candle_holder_yellow" | "minecraft:black_candle" | "farmersdelight:cutting/nether_bricks" | "thermal:machines/centrifuge/centrifuge_blue_orchid" | "mysticalagriculture:seed/crafting/glowstone" | "thermal:fuels/numismatic/numismatic_bronze_coin" | "mysticalagriculture:imperium_growth_accelerator" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/brown" | "caveopolis:orange_colored_stone_brick_stairs" | "caveopolis:sprayer/concrete/lime" | "cozy_home:crimson_mirror_recipe" | "farmersdelight:cutting/cherry_sign" | "mysticalagradditions:imperium_coal" | "mysticalagriculture:seed/crafting/air" | "caveopolis:cyan_colored_wooden_plank_trapdoor" | "storagedrawers:gold_storage_upgrade" | "minecraft:dye_brown_wool" | "mysticalagriculture:soulstone_cobble_slab" | "caveopolis:light_blue_colored_wooden_planks" | "caveopolis:sprayer/refill/light_blue" | "alltheores:mek_processing/aluminum/slurry/dirty/from_raw_block" | "caveopolis:sprayer/colored_stone_brick_stairs/pink_colored_stone_brick_stairs" | "thermal:compat/tconstruct/press_tconstruct_amethyst_bronze_unpacking" | "mysticalagriculture:seed/crafting/hepatizon" | "caveopolis:sprayer/colored_logs/black" | "mysticalagriculture:essence/minecraft/honeycomb" | "caveopolis:sprayer/colored_signs/white" | "minecraft:polished_diorite_stairs_from_polished_diorite_stonecutting" | "thermal:compat/create/centrifuge_create_crushed_raw_zinc" | "mysticalagriculture:essence/common/tungsten_ingot" | "farmersdelight:cutting/crimson_stem" | "sophisticatedbackpacks:advanced_restock_upgrade" | "thermal:augments/rf_coil_storage_augment" | "thermal:machines/insolator/insolator_sunflower" | "opolisutilities:fluid_generator/lava" | "supplementaries:candle_holders/candle_holder_brown_dye" | "caveopolis:orange_colored_wooden_plank_button_from_orange_colored_wooden_planks_stonecutting" | "thermal:compat/tconstruct/chiller_tconstruct_invar_ingot" | "alltheores:bronze_ingot" | "minecraft:warped_sign" | "mysticalagriculture:soulstone_cracked_bricks" | "caveopolis:sprayer/remove_color/colored_stone_buton" | "thermal:compat/mysticalagriculture/insolator_mysticalag_zinc_seeds" | "mysticalagriculture:essence/minecraft/jungle_sapling" | "alltheores:mek_processing/nickel/crystal/from_slurry" | "thermal:compat/mysticalagriculture/insolator_mysticalag_chrome_seeds" | "thermal:machines/sawmill/sawmill_frost_melon" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/light_gray" | "thermal:stuffed_pepper" | "alltheores:mek_processing/silver/shard/from_raw_block" | "caveopolis:pink_colored_hanging_sign_from_stripped_pink_colored_log_stonecutting" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/red" | "minecraft:bamboo_sign" | "suppsquared:candle_holders/gold_candle_holder_red" | "thermal:ice_tnt" | "mysticalagriculture:seed/crafting/marble" | "minecraft:host_armor_trim_smithing_template_smithing_trim" | "thermal:machines/press/unpacking/press_niter_unpacking" | "lfpirates:sailor_gray_tier_1_leggins_recipe_1" | "cozy_home:counter_oak_storage_recipe" | "industrialforegoing:dissolution_chamber/range_addon5" | "caveopolis:cyan_colored_cobblestone_brick_slab" | "industrialforegoing:dissolution_chamber/range_addon4" | "industrialforegoing:dissolution_chamber/range_addon3" | "cozy_home:birch_mirror_stand_recipe" | "industrialforegoing:dissolution_chamber/range_addon2" | "sophisticatedbackpacks:netherite_backpack" | "minecraft:orange_terracotta" | "industrialforegoing:dissolution_chamber/range_addon9" | "industrialforegoing:dissolution_chamber/range_addon8" | "supplementaries:lapis_brick_stairs" | "suppsquared:candle_holders/gold_candle_holder_green" | "industrialforegoing:dissolution_chamber/range_addon7" | "caveopolis:sprayer/colored_cobblestone_slab/green_colored_stone_slab" | "industrialforegoing:dissolution_chamber/range_addon6" | "caveopolis:sprayer/colored_logs/green" | "farmersdelight:integration/create/milling/wild_tomatoes" | "caveopolis:sprayer/colored_cobblestone_wall/pink_colored_stone_wall" | "thermal:fluid_cell_frame" | "industrialforegoing:dissolution_chamber/range_addon1" | "mysticalagriculture:seed/crafting/flux_infused_ingot" | "industrialforegoing:dissolution_chamber/range_addon0" | "thermal:compat/tconstruct_ie/chiller_tconstruct_ie_aluminum_rod" | "aquaculture:gold_fillet_knife" | "mysticalagradditions:essence/dragon_head" | "thermal:compat/mysticalagriculture/insolator_mysticalag_niotic_crystal_seeds" | "mysticalagriculture:mystical_flower_agglomeratio" | "minecraft:paper" | "alltheores:silver_ingot_from_ore_blasting" | "minecraft:lime_glazed_terracotta" | "thermal:compat/tconstruct/chiller_tconstruct_netherite_ingot" | "caveopolis:sprayer/stripped_colored_logs/white" | "mysticalagriculture:seed/reprocessor/ruby" | "alltheores:tools_materials/lead/lead_from_ingot" | "nec:caveop_gray_colored_wooden_chest" | "strainers:summoning_block/blaze" | "minecraft:cherry_fence_gate" | "caveopolis:pink_colored_cobblestone_bricks" | "caveopolis:sprayer/stripped_colored_wood/lime" | "supplementaries:candle_holders/candle_holder_gray_dye" | "strainers:summoning_block/witch_glowstone" | "thermal:machines/pulverizer/pulverizer_apatite" | "thermal:machines/press/packing3x3/press_prismarine_bricks_packing" | "sophisticatedbackpacks:advanced_magnet_upgrade" | "caveopolis:cyan_colored_wooden_plank_fence_gate_from_cyan_colored_wooden_planks_stonecutting" | "thermal:compat/mysticalagriculture/insolator_mysticalag_redstone_seeds" | "minecraft:dark_oak_button" | "thermal:fuels/numismatic/numismatic_electrum_coin" | "caveopolis:sprayer/colored_stone_stairs/black_colored_stone_stairs" | "thermal:machines/press/unpacking/press_lead_unpacking" | "alltheores:silver_block" | "strainers:ancient_debris_from_straining_netherrack_in_minecraft_water" | "caveopolis:light_gray_colored_cobblestone_brick_slab_from_light_gray_colored_cobblestone_bricks_stonecutting" | "thermal:machines/press/packing2x2/press_magma_packing" | "mysticalagriculture:witherproof_glass" | "thermal:smelting/slag_from_smelting" | "thermal:storage/onion_block" | "industrialforegoing:latex_processing_unit" | "thermal:fuels/gourmand/gourmand_cake" | "tmttd:machines/press/sugar_bag_press" | "thermal_extra:machine/press/dragonsteel_plate" | "caveopolis:green_colored_cobblestone_stairs_from_green_colored_cobblestone_stonecutting" | "alltheores:steel_ingot" | "thermal:compat/create/smelter_create_crushed_raw_silver" | "cozy_home:table_stump_crimson_recipe" | "mysticalagriculture:souls/bone" | "caveopolis:sprayer/colored_logs/purple" | "thermal:compat/mysticalagriculture/insolator_mysticalag_fluorite_seeds" | "thermal:compat/tconstruct/press_tconstruct_sky_slime_2x2_packing" | "thermal:compat/create/pulverizer_create_tuff" | "caveopolis:sprayer/colored_leaves/white" | "cozy_home:birch_plank_recipe" | "caveopolis:orange_colored_cobblestone" | "thermal:machines/pulverizer/pulverizer_gilded_blackstone" | "minecraft:cracked_deepslate_tiles" | "thermal:compat/mysticalagriculture/insolator_mysticalag_refined_obsidian_seeds" | "mysticalagriculture:infusion_pedestal" | "cozy_home:quartz_mirror_stand_recipe" | "suppsquared:metal_brace" | "minecraft:cooked_rabbit" | "supplementaries:ash_bricks" | "alltheores:copper_ingot_from_dust_blasting" | "alltheores:tools_materials/osmium/osmium_from_block" | "caveopolis:purple_colored_cobblestone_brick_stairs_from_purple_colored_cobblestone_bricks_stonecutting" | "mysticalagriculture:imperium_ingot_uncraft" | "minecraft:magenta_banner" | "alltheores:lead_rod" | "mysticalagradditions:insanium_ingot_uncraft" | "minecraft:mangrove_fence_gate" | "supplementaries:notice_board" | "thermal:compat/create/smelter_create_alloy_chromatic_compound" | "aquaculture:dark_oak_fish_mount" | "lfpirates:sailor_nordic_tier_3_boots_recipe_1" | "caveopolis:sprayer/colored_stone_bricks/purple_colored_stone_bricks" | "mysticalagriculture:stonecutting/soulstone_bricks_wall_from_soulstone" | "industrialforegoing:fluid_extractor/default" | "alltheores:platinum_dust_from_hammer_ingot_crushing" | "alltheores:mek_processing/silver/dust/from_dirty_dust" | "minecraft:iron_block" | "alltheores:mek_processing/zinc/slurry/dirty/from_raw_block" | "tmttd:machines/press/cabbage_press" | "minecraft:dark_oak_door" | "thermal:compat/mekanism/press_mek_refined_obsidian_unpacking" | "opolisutilities:copper_nuggets" | "thermal:machines/insolator/insolator_green_bean" | "glassential:glass_trapdoor" | "opolisutilities:resource_generator/mods/caveopolis/light_gray_colored_stone" | "mysticalagriculture:imperium_gemstone_block_uncraft" | "storagedrawers:concealment_key" | "mysticalagradditions:tconstruct/melting/imperium/ingot" | "minecraft:flower_pot" | "strainers:sweet_berries_from_straining_mulch_in_minecraft_water" | "mysticalagriculture:augment/pathing_aoe_iii" | "strainers:allium_from_straining_grass_in_strainers_purified_water_fluid" | "thermal:compat/mysticalagriculture/insolator_mysticalag_quartz_enriched_iron_seeds" | "alltheores:platinum_plate" | "cozy_home:sofa_gray_recipe" | "caveopolis:green_colored_wooden_plank_slab" | "alltheores:mek_processing/silver/shard/from_raw_ore" | "caveopolis:cobblestone_brick_slab_from_cobblestone_bricks_stonecutting" | "minecraft:polished_blackstone_bricks_from_blackstone_stonecutting" | "thermal:smelting/iron_ingot_from_dust_blasting" | "caveopolis:light_blue_colored_stone_pressure_plate" | "mysticalagriculture:augment/attack_aoe_i" | "caveopolis:sprayer/colored_wooden_plank_stairs/orange" | "thermal:storage/lumium_nugget_from_ingot" | "caveopolis:sprayer/shulker_box/light_gray" | "strainers:upgrades/sturdy/sturdy_duration_upgrade" | "mysticalagriculture:seed/crafting/platinum" | "caveopolis:orange_colored_wooden_plank_fence_gate_from_orange_colored_wooden_planks_stonecutting" | "supplementaries:flax_block_uncrafting" | "caveopolis:green_colored_stone_pressure_plate_from_green_colored_stone_stonecutting" | "systeams:boilers/upgrades/gourmand_upgrade" | "farmersdelight:red_canvas_sign" | "strainers:soul_soil_from_straining_dirt_in_minecraft_lava" | "thermal:brown_concrete_powder_with_slag" | "systeams:boilers/upgrades/disenchantment_downgrade" | "minecraft:pink_glazed_terracotta" | "caveopolis:red_colored_stone_button" | "thermal:compat/tconstruct/press_tconstruct_queens_slime_nugget_unpacking" | "caveopolis:gray_colored_stone_bricks" | "farmersdelight:golden_knife" | "caveopolis:lime_colored_wooden_plank_crafting_table" | "minecraft:orange_stained_glass" | "caveopolis:sprayer/colored_logs/pink" | "minecraft:exposed_cut_copper_slab" | "thermal:machines/sawmill/sawmill_warped_stems" | "farmersdelight:cutting/cabbage" | "opolisutilities:resource_generator/stone" | "minecraft:copper_ingot_from_blasting_deepslate_copper_ore" | "cozy_home:lamp_orange_recipe" | "mysticalagriculture:essence/minecraft/string" | "supplementaries:cozy_home/sign_post_spruce" | "farmersdelight:integration/immersiveengineering/crusher/wild_carrots" | "thermal:machines/smelter/smelter_glass_obsidian" | "strainers:eroding_salt_mulch" | "opolisutilities:fragment_from_smelting_ender_ore" | "caveopolis:white_colored_stone_wall" | "thermal:ice_charge/ice_from_water_bucket" | "mysticalagriculture:seed/crafting/mithril" | "minecraft:golden_boots" | "minecraft:pink_dye_from_red_white_dye" | "thermal:compat/redstone_arsenal/smelter_rsa_alloy_flux" | "thermal:machines/smelter/smelter_silver_dust" | "minecraft:netherite_shovel_smithing" | "alltheores:mek_processing/iridium/shard/from_crystal" | "smallships:mangrove_drakkar" | "mysticalagriculture:imperium_farmland_till" | "strainers:sheaf_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "alltheores:silver_ingot" | "mysticalagriculture:gear/prudentium_leggings" | "itemfilters:not" | "supplementaries:flags/flag_cyan" | "caveopolis:sprayer/colored_wood/pink" | "caveopolis:black_colored_hanging_sign_from_stripped_black_colored_log_stonecutting" | "minecraft:polished_granite_slab" | "thermal:augments/machine_output_augment" | "thermal:machines/centrifuge/centrifuge_electrum_dust" | "strainers:mangrove_propagule_from_straining_barrier_in_minecraft_air" | "industrialforegoing:mob_slaughter_factory" | "farmersdelight:cutting/jungle_door" | "mysticalagriculture:seed/crafting/water" | "minecraft:emerald" | "mysticalagriculture:seed/crafting/coral" | "thermal_extra:machine/press/dragonsteel_coin" | "caveopolis:sprayer/colored_stone/magenta_colored_stone" | "caveopolis:sprayer/colored_stone_pressure_plate/yellow" | "thermal:compat/mysticalagriculture/insolator_mysticalag_turtle_seeds" | "thermal:machines/smelter/smelter_catalyst_calcite" | "mysticalagriculture:gear/awakened_supremium_boots" | "farmersdelight:cutting/oxeye_daisy" | "minecraft:cherry_planks" | "supplementaries:clock_block" | "mysticalagriculture:tertium_farmland_till" | "mysticalagriculture:seed/reprocessor/sheep" | "alltheores:mek_processing/nickel/ingot/from_dust_blasting" | "alltheores:copper_plate" | "thermal:machines/press/packing2x2/press_honeycomb_packing" | "minecraft:nether_brick_wall_from_nether_bricks_stonecutting" | "minecraft:oxidized_cut_copper_slab_from_oxidized_cut_copper_stonecutting" | "caveopolis:sprayer/colored_wooden_planks/light_gray" | "mysticalagradditions:imperium_apple" | "minecraft:oak_stairs" | "minecraft:silence_armor_trim_smithing_template" | "minecraft:smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting" | "nec:birch_chest" | "thermal:compat/immersiveengineering/insolator_ie_hemp" | "minecraft:polished_blackstone_brick_stairs" | "mysticalagriculture:gear/imperium_shears" | "caveopolis:light_gray_colored_stone_stairs" | "caveopolis:light_blue_colored_cobblestone_wall_from_light_blue_colored_cobblestone_stonecutting" | "thermal_extra:machine/dynamo/frost/blizz_powder" | "farmersdelight:cutting/bamboo_hanging_sign" | "thermal:compat/mysticalagriculture/insolator_mysticalag_fluix_seeds" | "mysticalagriculture:tertium_block" | "strainers:upgrade_stats/everlasting_input_upgrade" | "thermal:compat/create/bottler_create_honeyed_apple" | "minecraft:glass" | "caveopolis:sprayer/beds/white" | "caveopolis:red_colored_cobblestone_stairs" | "caveopolis:gray_colored_wooden_planks" | "caveopolis:sprayer/colored_stone_brick_wall/red_colored_stone_bricks_brick_wall" | "thermal:smelting/lead_ingot_from_ore_smelting" | "mysticalagriculture:seed/reprocessor/pig_iron" | "thermal:ice_charge_3" | "mysticalagriculture:seed/infusion/aluminum" | "mysticalagriculture:augment/absorption_iv" | "suppsquared:candle_holders/gold_candle_holder_magenta" | "strainers:arms_up_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "alltheores:tin_dust_from_hammer_crushing" | "mysticalagriculture:essence/minecraft/potato" | "alltheores:mek_processing/aluminum/clump/from_raw_block" | "thermal:storage/charcoal_from_block" | "minecraft:light_blue_concrete_powder" | "caveopolis:sprayer/colored_wooden_planks/gray" | "thermal:machines/press/packing/press_rose_gold_nugget_packing" | "opolisutilities:drying_table" | "minecraft:granite_stairs" | "thermal:machines/crucible/crucible_snowball_to_water" | "mysticalagriculture:souls/rabbit" | "oceansdelight:cooking/braised_sea_pickle" | "caveopolis:light_blue_colored_cobblestone_stairs" | "suppsquared:item_shelf_warped" | "farmersdelight:cutting/cherry_door" | "mysticalagriculture:augment/absorption_ii" | "strainers:cornflower_from_straining_grass_in_strainers_purified_water_fluid" | "caveopolis:sprayer/colored_logs/white" | "framedcompactdrawers:framed_trim" | "cozy_home:spruce_mirror_recipe" | "strainers:peony_from_straining_tall_grass_in_strainers_purified_water_fluid" | "thermal:compat/quark/press_quark_nether_wart_unpacking" | "caveopolis:white_colored_stone_bricks_from_white_colored_stone_stonecutting" | "thermal:machines/centrifuge/centrifuge_invar_dust" | "mysticalagriculture:essence/minecraft/deepslate" | "strainers:flint_from_straining_gravel_in_minecraft_water" | "cozy_home:chimney_cobblestone_recipe" | "thermal:rockwool/gray_rockwool_from_dye" | "farmersdelight:integration/create/milling/wild_rice" | "thermal:machine_smelter" | "opolisutilities:ender_pearl_fragments_from_ender_pearl" | "cozy_home:quartz_mirror_recipe" | "minecraft:prismarine_bricks" | "industrialforegoing:plant_gatherer" | "minecraft:stone_bricks" | "caveopolis:purple_colored_wooden_plank_pressure_plate" | "thermal:smelting/cooked_mushroom_from_smelting" | "thermal:machines/bottler/bottler_gray_concrete" | "caveopolis:sprayer/wool/white_wool" | "thermal:machines/press/press_strawberry_jar" | "mysticalagriculture:essence/minecraft/dark_oak_sapling" | "simplehats:hatbag_easter" | "minecraft:dye_orange_wool" | "alltheores:enderium_gear" | "caveopolis:cyan_colored_stone_stairs_from_cyan_colored_stone_stonecutting" | "systeams:boilers/upgrades/numismatic_upgrade" | "caveopolis:black_colored_wooden_plank_trapdoor" | "thermal:smelting/niter_from_blasting" | "industrialforegoing:conveyor_dropping_upgrade" | "caveopolis:sprayer/colored_cobblestone_bricks/red_colored_stone_bricks_bricks" | "thermal:rockwool/orange_rockwool_from_dye" | "mysticalagriculture:prosperity_gemstone" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/gray" | "opolisutilities:resource_generator/tuff" | "mysticalagriculture:seed/infusion/knightmetal" | "minecraft:cyan_stained_glass" | "mysticalagriculture:seed/infusion/amethyst" | "mysticalagriculture:upgrade_base" | "thermal:compat/biomesoplenty/tree_extractor_bop_origin" | "minecraft:acacia_fence" | "thermal:fuels/gourmand/gourmand_frost_melon" | "thermal:machines/press/packing/press_steel_packing" | "caveopolis:black_colored_wooden_plank_door_from_black_colored_wooden_planks_stonecutting" | "caveopolis:white_colored_wooden_plank_door" | "minecraft:cyan_banner" | "minecraft:glistering_melon_slice" | "thermal_extra:machine/dynamo/frost/snow_block" | "thermal:machines/chiller/chiller_ender_to_ender_pearl" | "alltheores:mek_processing/platinum/ore/from_dust" | "minecraft:warped_door" | "caveopolis:lime_colored_stone" | "thermal:compat/mysticalagriculture/insolator_mysticalag_bronze_seeds" | "farmersdelight:cooking/pumpkin_soup" | "thermal:fuels/gourmand/gourmand_apple_block" | "thermal:parts/emerald_gear" | "minecraft:acacia_fence_gate" | "thermal:machines/smelter/smelter_electrum_dust" | "thermal:machines/press/unpacking/press_rich_slag_unpacking" | "thermal:machines/press/press_tomato_unpacking" | "thermal:pbj_sandwich_2" | "caveopolis:black_colored_stone_brick_wall" | "minecraft:dye_yellow_wool" | "thermal:machines/centrifuge/centrifuge_red_tulip" | "minecraft:magenta_carpet" | "caveopolis:sprayer/colored_stone_pressure_plate/cyan" | "mysticalagradditions:tconstruct/tools/materials/inferium/ingot" | "caveopolis:light_blue_colored_wooden_plank_fence" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/light_blue" | "thermal:machines/press/unpacking/press_bamboo_unpacking" | "caveopolis:pink_colored_wooden_plank_door" | "caveopolis:sprayer/colored_wooden_plank_door/yellow" | "thermal:machines/smelter/smelter_gold_dust" | "thermal:machines/insolator/insolator_bamboo" | "supplementaries:candle_holders/candle_holder_black_dye" | "caveopolis:yellow_colored_stone_slab" | "theoneprobe:probegoggles" | "farmersdelight:cutting/spruce_sign" | "thermal:machines/smelter/smelter_alloy_constantan" | "farmersdelight:tatami_block_from_full" | "farmersdelight:chocolate_pie_from_slices" | "thermal:compat/quark/sawmill_quark_azalea_logs" | "farmersdelight:cooking/vegetable_noodles" | "mysticalagriculture:essence/minecraft/magma_cream" | "thermal:machines/press/unpacking/press_quartz_unpacking" | "caveopolis:sprayer/colored_cobblestone_slab/red_colored_stone_slab" | "thermal:armor/diving_helmet" | "industrialforegoing:wither_builder" | "minecraft:lectern" | "caveopolis:sprayer/colored_wooden_plank_fence/cyan" | "thermal:machines/insolator/insolator_oxeye_daisy" | "opolisutilities:resource_generator/mods/caveopolis/orange_colored_stone" | "opolisutilities:fragment_from_blasting_ender_ore" | "caveopolis:red_colored_wooden_plank_fence" | "caveopolis:sprayer/colored_leaves/pink" | "minecraft:magenta_dye_from_allium" | "minecraft:smooth_stone_slab" | "thermal:fuels/gourmand/gourmand_chocolate_cake" | "supplementaries:inspirations/flag_dye" | "thermal:machines/press/press_nickel_nugget_to_coin" | "chipped:benches/carpenters_table" | "caveopolis:magenta_colored_wooden_plank_button_from_magenta_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/stripped_colored_logs/light_blue" | "minecraft:dye_lime_wool" | "thermal:storage/eggplant_block" | "mysticalagriculture:essence/minecraft/yellow_concrete" | "minecraft:mossy_cobblestone_from_vine" | "aquaculture:heavy_hook" | "mysticalagriculture:seed/crafting/slimesteel" | "caveopolis:sprayer/colored_cobblestone_bricks/magenta_colored_stone_bricks" | "thermal:machines/press/press_peanut_jar" | "mysticalagriculture:seed/crafting/turtle" | "alltheores:silver_ingot_from_slate_ore_blasting" | "caveopolis:orange_colored_sign" | "alltheores:osmium_ingot_from_ore" | "thermal:compat/immersiveengineering/press_ie_aluminum_ingot_to_plate" | "thermal:smelting/signalum_ingot_from_dust_smelting" | "caveopolis:sprayer/remove_color/colored_cobblestone_brick_wall" | "mysticalagriculture:master_infusion_crystal" | "libraryferret:smelting/iron_coins_jtl" | "thermal:machines/insolator/insolator_red_tulip" | "industrialforegoing:dye_mixer" | "thermal:ice_charge/obsidian_from_lava_bucket" | "caveopolis:sprayer/colored_cobblestone/magenta_colored_stone" | "farmersdelight:cutting/acacia_door" | "caveopolis:sprayer/colored_cobblestone_brick_wall/purple_colored_stone_brick_wall" | "thermal:compat/mysticalagriculture/insolator_mysticalag_brass_seeds" | "mysticalagriculture:gear/tertium_hoe" | "mysticalagriculture:seed/infusion/chrome" | "caveopolis:sprayer/colored_cobblestone/blue_colored_stone" | "farmersdelight:nether_salad" | "aquaculture:turtle_soup" | "thermal:compat/tconstruct/smelter_tconstruct_raw_cobalt" | "minecraft:polished_blackstone_slab_from_blackstone_stonecutting" | "caveopolis:sprayer/candles/light_gray" | "thermal:smelting/silver_ingot_from_raw_smelting" | "thermal:fuels/gourmand/gourmand_peanut_block" | "alltheores:mek_processing/platinum/crystal/from_slurry" | "mysticalagriculture:seed/reprocessor/slimesteel" | "thermal:machines/press/press_steel_ingot_to_plate" | "minecraft:jungle_chest_boat" | "thermal:tools/wrench" | "minecraft:dark_prismarine_slab_from_dark_prismarine_stonecutting" | "strainers:meshes/diamond" | "aquaculture:fishing_line" | "alltheores:zinc_rod" | "strainers:heart_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "caveopolis:marble" | "caveopolis:sprayer/shulker_box/purple" | "mysticalagriculture:blank_skull" | "thermal:machines/insolator/insolator_catalyst_bone_meal" | "mysticalagriculture:supremium_gemstone_block" | "farmersdelight:canvas_from_canvas_rug" | "thermal:storage/coffee_block" | "thermal:storage/cured_rubber_from_block" | "thermal:compat/tconstruct/chiller_tconstruct_manyullyn_ingot" | "cozy_home:tabl_stump_oak_recipe" | "farmersdelight:cooked_bacon_from_smoking" | "lfpirates:merchant_2_leggins_recipe_1" | "aquaculture:neptunium_nugget" | "minecraft:end_stone_brick_slab" | "caveopolis:sprayer/colored_stone_pressure_plate/magenta" | "mysticalagriculture:water_agglomeratio" | "caveopolis:mixed_stone_ingot_from_smelting_deepslate_mixed_stone_ore" | "mysticalagradditions:tconstruct/melting/tertium/ingot" | "thermal:storage/lumium_ingot_from_block" | "minecraft:pink_concrete_powder" | "farmersdelight:green_canvas_sign" | "supplementaries:blackboard" | "mysticalagriculture:prudentium_upgrade" | "farmersdelight:light_gray_hanging_canvas_sign" | "mysticalagriculture:augment/night_vision" | "minecraft:diamond_shovel" | "minecraft:andesite_wall" | "thermal:compat/create/centrifuge_create_crushed_raw_gold" | "mysticalagriculture:essence/minecraft/crimson_nylium" | "strainers:horn_coral_fan_from_straining_barrier_in_minecraft_water" | "mysticalagriculture:seed/reprocessor/amethyst" | "caveopolis:sprayer/colored_cobblestone_slab/light_gray_colored_stone_slab" | "thermal:smelting/cooked_eggplant_from_campfire_cooking" | "thermal:rubberwood_stairs" | "opolisutilities:crook" | "minecraft:raiser_armor_trim_smithing_template_smithing_trim" | "farmersdelight:cutting/acacia_trapdoor" | "alltheores:mek_processing/zinc/ingot/from_dust_blasting" | "caveopolis:sprayer/colored_stone/lime_colored_stone" | "caveopolis:brown_colored_sign" | "alltheores:enderium_rod" | "minecraft:minecart" | "cozy_home:drawer_birch_recipe" | "thermal_extra:machine/press/sunflower_oil_from_sunflower" | "mysticalagriculture:seed/infusion/netherite" | "thermal:compat/redstone_arsenal/bottler_rsa_flux_gem" | "thermal:fuels/gourmand/gourmand_corn_block" | "caveopolis:yellow_colored_wooden_plank_button" | "thermal:machines/pulverizer/pulverizer_blizz_rod" | "caveopolis:sprayer/colored_stone/red_colored_stone" | "caveopolis:sprayer/remove_color/colored_stone_crafting_table" | "alltheores:diamond_plate" | "strainers:pink_tulip_from_straining_grass_in_strainers_purified_water_fluid" | "farmersdelight:cooked_bacon_from_campfire_cooking" | "thermal:compat/create/pulverizer_create_tuff_recycle" | "farmersdelight:cooking/mushroom_rice" | "minecraft:golden_shovel" | "thermal:rubberwood_hanging_sign" | "thermal:storage/cured_rubber_block" | "oceansdelight:cooked_stuffed_cod_from_smoking" | "thermal:machines/press/packing3x3/press_raw_lead_packing" | "cozy_home:oak_chair_recipe" | "caveopolis:sprayer/refill/gray" | "minecraft:brick_wall_from_bricks_stonecutting" | "supplementaries:planter" | "thermal:smelting/apatite_from_smelting" | "cozy_home:desk_spruce_recipe" | "minecraft:brown_glazed_terracotta" | "caveopolis:cyan_colored_cobblestone_brick_wall_from_cyan_colored_cobblestone_bricks_stonecutting" | "thermal:smelting/tin_ingot_from_dust_smelting" | "mysticalagriculture:seed/reprocessor/earth" | "thermal:compat/mekanism/press_mek_salt_unpacking" | "mysticalagriculture:essence/common/mithril_ingot" | "thermal:machines/insolator/insolator_eggplant" | "mysticalagriculture:seed/reprocessor/end" | "thermal:machines/press/unpacking/press_lumium_unpacking" | "thermal:machines/refinery/refinery_heavy_oil" | "minecraft:warped_trapdoor" | "mysticalagriculture:essence/appliedenergistics2/fluix" | "caveopolis:lime_colored_cobblestone_bricks" | "caveopolis:lime_colored_wooden_plank_trapdoor_from_lime_colored_wooden_planks_stonecutting" | "thermal:slime_grenade_4" | "thermal:augments/fluid_filter_augment" | "suppsquared:candle_holders/gold_candle_holder_light_gray" | "minecraft:diamond_chestplate" | "thermal:storage/niter_from_block" | "thermal:storage/constantan_block" | "thermal:smelting/nickel_ingot_from_deepslate_ore_smelting" | "caveopolis:sprayer/wool/cyan_wool" | "opolisutilities:resource_generator_2/speed_blocks/diamond" | "opolisutilities:resource_generator_2/speed_blocks/conductive_iron" | "cozy_home:counter_warped_sink_recipe" | "thermal:armor/beekeeper_boots" | "minecraft:birch_sign" | "thermal:machines/press/press_flax_packing" | "thermal:compat/mekanism/press_mek_raw_uranium_unpacking" | "mysticalagriculture:essence/minecraft/black_dye" | "supplementaries:hourglass" | "caveopolis:sprayer/glass_pane/white" | "thermal:electrum_dust_2" | "alltheores:raw_nickel_block" | "thermal_extra:machine/smelter/twinite_ingot_from_dust" | "mysticalagriculture:essence/minecraft/warped_stem" | "mysticalagriculture:gear/supremium_sword" | "caveopolis:gray_colored_wooden_plank_slab_from_gray_colored_wooden_planks_stonecutting" | "minecraft:orange_dye_from_red_yellow" | "mysticalagriculture:souls/cod" | "supplementaries:checker" | "mysticalagriculture:soulium_spawner/blaze" | "thermal:machines/press/press_signalum_ingot_to_plate" | "caveopolis:orange_colored_cobblestone_wall_from_orange_colored_cobblestone_stonecutting" | "cozy_home:bamboo_wall_clock_recipe" | "farmersdelight:cooked_cod_slice" | "mysticalagradditions:tconstruct/tools/melting/tertium" | "thermal:machines/press/packing2x2/press_quartz_packing" | "thermal:storage/tar_from_block" | "thermal:fuels/compression/compression_creosote" | "caveopolis:brown_colored_wooden_plank_fence_from_brown_colored_wooden_planks_stonecutting" | "chipped:benches/mason_table" | "caveopolis:sprayer/colored_stone_brick_stairs/blue_colored_stone_brick_stairs" | "minecraft:light_gray_dye_from_azure_bluet" | "thermal:compat/create_ie/smelter_create_ie_crushed_raw_aluminum" | "simplehats:hatscraps_rare" | "farmersdelight:integration/create/milling/rice_panicle" | "storagedrawers:warped_trim" | "thermal:machines/press/unpacking/press_invar_nugget_unpacking" | "strainers:creeper_head_from_straining_skeleton_skull_in_minecraft_water" | "caveopolis:sprayer/colored_cobblestone_brick_slab/gray" | "minecraft:magenta_candle" | "industrialforegoing:mycelial_meatallurgic" | "farmersdelight:integration/immersiveengineering/crusher/wild_cabbages" | "thermal:compat/tconstruct/press_tconstruct_earth_slime_2x2_packing" | "thermal:compat/create/smelter_create_crushed_raw_zinc" | "mysticalagriculture:seed/infusion/basalt" | "alltheores:aluminum_ingot_from_slate_ore" | "mysticalagriculture:seed/infusion/dye" | "thermal:compat/immersiveengineering/smelter_ie_aluminum_dust" | "caveopolis:light_blue_colored_stone_wall_from_light_blue_colored_stone_stonecutting" | "mysticalagradditions:tconstruct/tools/materials/imperium/nugget" | "thermal:smelting/iron_ingot_from_dust_smelting" | "minecraft:tnt_minecart" | "minecraft:acacia_planks" | "caveopolis:orange_colored_wooden_plank_slab" | "strainers:meshes/emerald" | "mysticalagradditions:supremium_coal" | "sophisticatedbackpacks:advanced_tool_swapper_upgrade" | "strainers:kelp_from_straining_barrier_in_strainers_eroding_water_fluid" | "thermal:machines/smelter/smelter_alloy_invar" | "minecraft:cherry_button" | "industrialforegoing:laser_drill_ore/raw_materials/yellorium" | "caveopolis:sprayer/concrete/orange" | "caveopolis:cyan_colored_wooden_planks" | "thermal:storage/electrum_nugget_from_ingot" | "cozy_home:drawer_quartz_recipe" | "caveopolis:sprayer/candles/red" | "strainers:rose_bush_from_straining_tall_grass_in_strainers_purified_water_fluid" | "mysticalagradditions:tconstruct/melting/inferium/block" | "minecraft:brown_terracotta" | "farmersdelight:cutting_board" | "minecraft:note_block" | "industrialforegoing:laser_drill" | "mysticalagriculture:seed/infusion/nether" | "strainers:upgrade_stats/specialized_speed_upgrade" | "industrialforegoing:mycelial_halitosis" | "industrialforegoing:laser_drill_ore/raw_materials/yellorite" | "nec:caveop_brown_colored_wooden_chest" | "thermal:cheese_wheel" | "systeams:boilers/pneumatic" | "caveopolis:yellow_colored_stone_brick_wall_from_yellow_colored_stone_bricks_stonecutting" | "mysticalagriculture:seed/infusion/basalz" | "mysticalagriculture:seed/infusion/pig_iron" | "caveopolis:light_gray_colored_wooden_planks" | "opolisutilities:resource_generator_2/speed_blocks/coal" | "supplementaries:feather_block_uncrafting" | "strainers:summoning_block/sheep" | "strainers:mud_from_straining_dirt_in_strainers_purified_water_fluid" | "minecraft:weathered_cut_copper_slab_from_weathered_copper_stonecutting" | "minecraft:end_crystal" | "suppsquared:iron_plaque" | "lfpirates:sailor_gray_tier_3_helmet_recipe_1" | "thermal:storage/rice_block" | "mysticalagriculture:seed/reprocessor/blazing_crystal" | "mysticalagradditions:dragon_egg" | "minecraft:shulker_box" | "nec:caveop_purple_colored_wooden_chest" | "thermal:machines/press/packing/press_steel_nugget_packing" | "caveopolis:cyan_colored_stone_wall" | "mysticalagriculture:enchanter/quick_charge" | "thermal:machines/insolator/insolator_frost_melon" | "caveopolis:light_blue_colored_wooden_plank_pressure_plate" | "thermal:compat/biomesoplenty/sawmill_bop_dead_logs" | "minecraft:white_carpet" | "minecraft:mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting" | "mysticalagriculture:enchanter/bane_of_arthropods" | "thermal:fuels/numismatic/numismatic_netherite_coin" | "caveopolis:white_colored_cobblestone_brick_wall" | "alltheores:mek_processing/iridium/clump/from_raw_block" | "thermal:compat/mekanism/press_mek_refined_glowstone_nugget_packing" | "cozy_home:lamp_light_gray_recipe" | "caveopolis:light_blue_colored_cobblestone_wall" | "lfpirates:sailor_blue_tier_3_body_recipe_1" | "thermal:storage/rose_gold_ingot_from_nuggets" | "thermal:lightning_grenade_4" | "caveopolis:light_gray_colored_stone" | "minecraft:cracked_stone_bricks" | "caveopolis:yellow_colored_cobblestone_stairs" | "thermal:machines/insolator/insolator_rice" | "caveopolis:red_colored_cobblestone_slab_from_red_colored_cobblestone_stonecutting" | "mysticalagriculture:seed/reprocessor/rubber" | "mysticalagriculture:seed/reprocessor/turtle" | "caveopolis:sprayer/beds/black" | "thermal:machines/press/press_onion_unpacking" | "lfpirates:merchant_3_body_recipe_1" | "thermal:machines/insolator/insolator_fire_coral_fan" | "thermal:machines/smelter/smelter_alloy_rose_gold" | "minecraft:ender_chest" | "minecraft:magenta_stained_glass" | "thermal:machines/centrifuge/centrifuge_wither_rose" | "minecraft:iron_trapdoor" | "minecraft:brown_candle" | "thermal:compat/tconstruct/smelter_alloy_tconstruct_queens_slime_ingot" | "caveopolis:sprayer/colored_wooden_planks/yellow" | "caveopolis:sprayer/colored_stone_crafting_table/green" | "alltheores:gold_dust_from_hammer_ingot_crushing" | "caveopolis:sprayer/colored_cobblestone_bricks/orange_colored_stone_bricks" | "thermal:compat/create/smelter_create_alloy_andesite_alloy" | "caveopolis:lime_colored_cobblestone_bricks_from_lime_colored_cobblestone_stonecutting" | "strainers:mulch" | "caveopolis:cyan_colored_wooden_plank_crafting_table" | "aquaculture:jellyfish_to_slimeball" | "caveopolis:sprayer/colored_cobblestone_wall/light_blue_colored_stone_wall" | "strainers:tuff_from_straining_dirt_in_strainers_eroding_water_fluid" | "caveopolis:white_colored_wooden_plank_slab" | "dankstorage:2_to_3" | "thermal:machines/bottler/bottler_pink_concrete" | "minecraft:acacia_pressure_plate" | "farmersdelight:integration/create/mixing/tomato_sauce_from_mixing" | "thermal:signalum_dust_4" | "mysticalagriculture:supremium_essence" | "thermal:compat/quark/press_quark_nether_wart_sack_packing" | "mysticalagriculture:imperium_essence_uncraft" | "oceansdelight:cooked_elder_guardian_slice" | "lfpirates:sailor_red_tier_3_body_recipe_1" | "minecraft:deepslate_brick_stairs_from_deepslate_bricks_stonecutting" | "caveopolis:green_colored_stone_bricks_from_green_colored_stone_stonecutting" | "thermal:compat/tconstruct/chiller_tconstruct_electrum_ingot" | "farmersdelight:cake_from_slices" | "caveopolis:yellow_colored_stone_brick_slab" | "caveopolis:sprayer/remove_color/wooden_plank_stairs" | "mysticalagriculture:seed/infusion/lead" | "caveopolis:magenta_colored_cobblestone_brick_wall" | "minecraft:firework_rocket" | "thermal:machines/insolator/insolator_nether_wart" | "minecraft:polished_andesite_slab_from_polished_andesite_stonecutting" | "mysticalagriculture:seed/reprocessor/dye" | "caveopolis:stripped_blue_colored_wood" | "mysticalagriculture:seed/reprocessor/saltpeter" | "thermal:machines/centrifuge/centrifuge_pink_tulip" | "mysticalagriculture:essence/minecraft/red_concrete" | "thermal:machines/crystallizer/crystallizer_amethyst_cluster" | "industrialforegoing:potion_brewer" | "thermal:armor/hazmat_leggings" | "supplementaries:integration/lapis_bricks_fd" | "caveopolis:light_gray_colored_cobblestone_brick_wall_from_light_gray_colored_cobblestone_bricks_stonecutting" | "minecraft:light_gray_dye_from_gray_white_dye" | "mysticalagriculture:gear/prudentium_scythe" | "duckling:pumpkin_pie" | "mysticalagriculture:enchanter/fire_aspect" | "strainers:upgrades/improved/improved_duration_upgrade" | "thermal:storage/rubber_from_block" | "mysticalagriculture:seed/crafting/obsidian" | "sophisticatedbackpacks:advanced_filter_upgrade" | "caveopolis:gray_colored_wooden_plank_pressure_plate_from_gray_colored_wooden_planks_stonecutting" | "minecraft:stripped_birch_wood" | "mysticalagriculture:essence/minecraft/brain_coral_block" | "thermal:compat/mysticalagriculture/insolator_mysticalag_manyullyn_seeds" | "thermal:machines/press/press_barley_packing" | "farmersdelight:roasted_mutton_chops" | "caveopolis:gray_colored_stone_brick_stairs" | "caveopolis:purple_colored_wooden_plank_button_from_purple_colored_wooden_planks_stonecutting" | "strainers:arms_up_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "mysticalagriculture:seed/reprocessor/redstone" | "mysticalagriculture:essence/minecraft/nautilus_shell" | "alltheores:iridium_ingot_from_slate_ore" | "minecraft:lime_banner" | "aquaculture:tackle_box" | "caveopolis:gray_colored_cobblestone_bricks" | "mysticalagriculture:seed/infusion/signalum" | "itemfilters:mod" | "minecraft:deepslate_brick_wall_from_cobbled_deepslate_stonecutting" | "lfpirates:gunpowder_recipe_1" | "caveopolis:lime_colored_wooden_plank_fence" | "thermal:compat/redstone_arsenal/smelter_rsa_flux_dust" | "caveopolis:sprayer/stripped_colored_wood/yellow" | "minecraft:cut_copper_from_copper_block_stonecutting" | "thermal:smelting/enderium_ingot_from_dust_smelting" | "caveopolis:sprayer/colored_wooden_plank_stairs/cyan" | "caveopolis:white_colored_cobblestone_bricks_from_white_colored_cobblestone_stonecutting" | "alltheores:lumium_ingot_from_dust" | "opolisutilities:charcoal" | "minecraft:polished_andesite_stairs_from_polished_andesite_stonecutting" | "industrialforegoing:laser_drill_fluid/ether_gas" | "thermal:machines/press/press_bronze_ingot_to_gear" | "farmersdelight:cabbage_crate" | "caveopolis:black_colored_cobblestone_brick_stairs_from_black_colored_cobblestone_bricks_stonecutting" | "caveopolis:white_colored_wooden_plank_slab_from_white_colored_wooden_planks_stonecutting" | "mysticalagradditions:awakened_draconium_crux" | "thermal:machines/insolator/insolator_poppy" | "mysticalagriculture:essence/minecraft/apple" | "mysticalagriculture:gear/inferium_bow" | "caveopolis:green_colored_stone_crafting_table" | "alltheores:mek_processing/aluminum/shard/from_ore" | "thermal:storage/tea_block" | "caveopolis:cobblestone_brick_stairs" | "cozy_home:sofa_cyan_recipe" | "farmersdelight:half_tatami_mat" | "caveopolis:sprayer/colored_wood/red" | "thermal:machines/press/press_flax_unpacking" | "caveopolis:light_gray_colored_wooden_plank_crafting_table" | "mysticalagriculture:tinkering_table" | "industrialforegoing:laser_drill_ore/raw_materials/platinum" | "strainers:upgrade_stats/improved_everything_upgrade" | "thermal:stuffed_pumpkin" | "caveopolis:pink_colored_cobblestone_brick_slab_from_pink_colored_cobblestone_bricks_stonecutting" | "thermal:machines/press/press_signalum_ingot_to_coin" | "thermal:machines/centrifuge/centrifuge_orange_wool" | "strainers:angler_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "caveopolis:sprayer/concrete/brown" | "caveopolis:green_colored_wooden_plank_door" | "mysticalagriculture:seed/infusion/peridot" | "caveopolis:magenta_colored_sign_from_magenta_colored_wooden_planks_stonecutting" | "minecraft:crimson_sign" | "thermal:storage/sugar_cane_from_block" | "tmttd:cooking/peanut_butter" | "supplementaries:cozy_home/sign_post_birch" | "caveopolis:pink_colored_wooden_plank_button_from_pink_colored_wooden_planks_stonecutting" | "caveopolis:brown_colored_stone_brick_wall_from_brown_colored_stone_bricks_stonecutting" | "thermal:machines/press/unpacking/press_raw_nickel_unpacking" | "mysticalagriculture:augment/jump_boost_i" | "thermal:machines/insolator/insolator_moss_carpet" | "minecraft:stone_brick_slab" | "mysticalagriculture:essence/common/tin_ingot" | "mysticalagriculture:seed/infusion/redstone" | "caveopolis:brown_colored_stone_brick_slab" | "thermal:storage/tar_block" | "thermal:compat/mysticalagriculture/insolator_mysticalag_signalum_seeds" | "minecraft:polished_blackstone_pressure_plate" | "alltheores:constantan_gear" | "industrialforegoing:fluid_extractor/spruce" | "aquatictorches:aquatic_torch" | "aquamirae:abyssal_tiara" | "alltheores:diamond_rod" | "minecraft:stone_slab_from_stone_stonecutting" | "thermal:machines/press/press_nickel_ingot_to_coin" | "suppsquared:candle_holders/gold_candle_holder_gray" | "farmersdelight:cooking/cabbage_rolls" | "caveopolis:orange_colored_cobblestone_brick_wall" | "minecraft:gray_glazed_terracotta" | "thermal:machines/press/press_rose_gold_nugget_to_coin" | "mysticalagriculture:end_agglomeratio" | "mysticalagriculture:imperium_upgrade" | "thermal:machines/insolator/insolator_cocoa_beans" | "thermal:machines/press/unpacking/press_wheat_unpacking" | "thermal:invar_dust_3" | "minecraft:gold_ingot_from_nuggets" | "caveopolis:light_gray_colored_wooden_plank_pressure_plate" | "thermal:compat/biomesoplenty/insolator_bop_jacaranda_sapling" | "caveopolis:cyan_colored_cobblestone_brick_stairs_from_cyan_colored_cobblestone_bricks_stonecutting" | "alltheores:mek_processing/iridium/shard/from_raw_ore" | "mysticalagriculture:seed/infusion/gaia_spirit" | "thermal:smelting/nickel_ingot_from_dust_smelting" | "thermal:machines/press/press_dandelion_to_latex" | "minecraft:netherite_leggings_smithing" | "farmersdelight:mutton_wrap" | "duckling:cake" | "thermal:compat/biomesoplenty/insolator_bop_hellbark_sapling" | "thermal:compat/mysticalagriculture/insolator_mysticalag_ghast_seeds" | "mysticalagriculture:machine_frame" | "matc:crystals/prudentium" | "caveopolis:pink_colored_wooden_plank_slab" | "thermal:fuels/numismatic/numismatic_lead_coin" | "mysticalagradditions:insanium_coal_block" | "mysticalagriculture:imperium_gemstone_block" | "industrialforegoing:dissolution_chamber/speed_addon_1" | "industrialforegoing:dissolution_chamber/speed_addon_2" | "minecraft:stone_brick_stairs_from_stone_stonecutting" | "mysticalagriculture:stonecutting/soulstone_stairs_from_soulstone" | "cozy_home:counter_crimson_recipe" | "caveopolis:gray_colored_wooden_plank_fence" | "minecraft:honey_bottle" | "mysticalagriculture:awakening_pedestal" | "thermal:florb_8" | "caveopolis:purple_colored_stone" | "caveopolis:sprayer/colored_stone_crafting_table/black" | "alltheores:nickel_ingot_from_raw" | "supplementaries:candle_holders/candle_holder_light_blue" | "caveopolis:sprayer/colored_stone_brick_wall/light_gray_colored_stone_brick_wall" | "supplementaries:goblet" | "mysticalagriculture:essence/minecraft/brown_concrete" | "minecraft:raw_copper_block" | "minecraft:polished_diorite_from_diorite_stonecutting" | "alltheores:zinc_ingot_from_ore_blasting" | "caveopolis:cyan_colored_sign_from_cyan_colored_wooden_planks_stonecutting" | "caveopolis:blue_colored_stone_slab" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/gray" | "alltheores:nickel_ingot" | "strainers:dragon_breath_from_straining_glass_bottle_in_minecraft_dragon_head" | "strainers:grass_block" | "thermal:machines/pulverizer/pulverizer_raw_tin" | "minecraft:lapis_lazuli" | "aquaculture:redstone_hook" | "mysticalagriculture:essence/appliedenergistics2/certus_quartz_dust" | "caveopolis:sprayer/colored_hanging_signs/white" | "mysticalagriculture:prosperity_ingot" | "mysticalagriculture:seed/reprocessor/constantan" | "thermal:machines/press/unpacking/press_signalum_unpacking" | "caveopolis:pink_colored_wooden_plank_stairs_from_pink_colored_wooden_planks_stonecutting" | "supplementaries:sign_post_birch" | "alltheores:iron_dust_from_hammer_crushing" | "thermal:machines/press/unpacking/press_lumium_nugget_unpacking" | "minecraft:quartz_block" | "alltheores:iridium_ingot_from_dust_blasting" | "strainers:redstone_from_straining_granite_in_minecraft_water" | "farmersdelight:safety_net" | "caveopolis:purple_colored_stone_button" | "mysticalagriculture:souls/chicken" | "caveopolis:blue_colored_stone_bricks" | "cozy_home:counter_jungle_recipe" | "thermal:storage/constantan_ingot_from_block" | "industrialforegoing:laser_lens_purple_recolor" | "strainers:upgrade_stats/improved_input_upgrade" | "alltheores:iridium_ingot_from_slate_ore_blasting" | "mysticalagriculture:seed/infusion/ironwood" | "mysticalagriculture:seed/reprocessor/soulium" | "industrialforegoing:conveyor_extraction_upgrade" | "mysticalagriculture:souls/wither_skeleton_skull" | "mysticalagriculture:enchanter/smite" | "caveopolis:sprayer/colored_saplings/yellow" | "thermal:machines/pulverizer/pulverizer_signalum_ingot_to_dust" | "caveopolis:sprayer/colored_stone_brick_wall/orange_colored_stone_brick_wall" | "caveopolis:white_colored_stone_bricks" | "alltheores:mek_processing/platinum/slurry/dirty" | "caveopolis:stripped_white_colored_wood" | "caveopolis:sprayer/colored_cobblestone_brick_slab/magenta" | "caveopolis:sprayer/candles/pink" | "thermal:compat/tconstruct/chiller_tconstruct_rose_gold_ingot_alt" | "thermal:machines/smelter/smelter_lead_armor" | "mysticalagriculture:gear/supremium_helmet" | "thermal:machines/press/press_tin_ingot_to_plate" | "strainers:archer_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "mysticalagriculture:enchanter/looting" | "opolisutilities:resource_generator/andesite" | "thermal:machines/press/packing3x3/press_cinnabar_packing" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/gray" | "strainers:summoning_block/cave_spider" | "minecraft:coast_armor_trim_smithing_template" | "minecraft:dune_armor_trim_smithing_template" | "farmersdelight:cutting/orange_tulip" | "alltheores:diamond_dust_from_hammer_crushing" | "caveopolis:blue_colored_cobblestone_wall" | "mysticalagriculture:gear/supremium_sickle" | "thermal_extra:compat/advgenerators/creosote" | "farmersdelight:cutting/mangrove_door" | "mysticalagriculture:gear/inferium_fishing_rod" | "strainers:dandelion_from_straining_grass_in_strainers_purified_water_fluid" | "minecraft:polished_blackstone_stairs_from_blackstone_stonecutting" | "thermal:dynamo_stirling" | "caveopolis:sprayer/colored_stone_brick_stairs/light_gray_colored_stone_brick_stairs" | "alltheores:iridium_gear" | "opolisutilities:catalogue/selling/caveopolis/orange_spray_can" | "mysticalagriculture:seed/infusion/vibrant_alloy" | "mysticalagradditions:prudentium_coal_block_uncraft" | "caveopolis:sprayer/refill/purple" | "mysticalagriculture:gear/inferium_axe" | "mysticalagriculture:seed/reprocessor/aluminum" | "thermal:machines/centrifuge/centrifuge_yellow_wool" | "alltheores:nickel_ingot_from_raw_blasting" | "opolisutilities:soaking_table/mud" | "strainers:meshes/netherite" | "caveopolis:sprayer/banners/lime" | "caveopolis:sprayer/colored_stone_bricks/light_gray_colored_stone_bricks" | "strainers:bubble_coral_block_from_straining_bubble_coral_in_strainers_purified_water_fluid" | "minecraft:deepslate_tile_wall" | "supplementaries:candy" | "caveopolis:light_blue_colored_cobblestone_bricks_from_light_blue_colored_cobblestone_stonecutting" | "minecraft:polished_deepslate_stairs" | "mysticalagriculture:seed/reprocessor/lead" | "minecraft:waxed_exposed_cut_copper_slab_from_honeycomb" | "supplementaries:botany_flax" | "supplementaries:rope_2" | "mysticalagriculture:augment/wither_resistance" | "caveopolis:lime_colored_sign_from_lime_colored_wooden_planks_stonecutting" | "mysticalagradditions:tconstruct/tools/melting/soulium" | "alltheores:bronze_nugget_from_ingot" | "thermal:machines/press/packing2x2/press_red_sandstone_packing" | "mysticalagriculture:soulium_ingot_block_uncraft" | "mysticalagriculture:seed/crafting/experience" | "minecraft:white_candle" | "industrialforegoing:crusher/sand_silicon" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_bricks_stonecutting" | "thermal:machines/press/packing3x3/press_invar_packing" | "caveopolis:magenta_colored_stone_brick_slab" | "cozy_home:spruce_chair_recipe" | "minecraft:cobbled_deepslate_wall_from_cobbled_deepslate_stonecutting" | "mysticalagriculture:seed/infusion/end" | "thermal:machines/press/packing2x2/press_string_packing" | "industrialforegoing:fluid_placer" | "thermal:compat/quark/press_quark_golden_apple_packing" | "minecraft:golden_carrot" | "farmersdelight:cutting/stone" | "caveopolis:lime_colored_wooden_plank_fence_from_lime_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/beds/green" | "thermal:compat/create/press_create_zinc_nugget_unpacking" | "minecraft:prismarine_wall" | "caveopolis:sprayer/colored_stone/cyan_colored_stone" | "opolisutilities:name_tag" | "mysticalagriculture:seed/reprocessor/ironwood" | "mysticalagriculture:prudentium_ingot" | "thermal:compat/mysticalagriculture/insolator_mysticalag_pig_iron_seeds" | "mysticalagriculture:witherproof_block" | "caveopolis:sprayer/colored_stone_stairs/brown_colored_stone_stairs" | "caveopolis:black_colored_cobblestone_brick_wall" | "alltheores:invar_rod" | "mysticalagradditions:tconstruct/casting/inferium/nugget_sand_cast" | "cozy_home:quartz_wall_clock_recipe" | "thermal_extra:storage/dragonsteel_block" | "farmersdelight:cooking/beetroot_soup" | "thermal:fuels/numismatic/numismatic_copper_coin" | "minecraft:magma_cream" | "thermal:compat/tconstruct/sawmill_tconstruct_greenheart_logs" | "mysticalagradditions:tconstruct/casting/inferium/ingot_sand_cast" | "farmersdelight:cutting/bamboo_block" | "caveopolis:orange_colored_wooden_plank_pressure_plate" | "thermal:fuels/gourmand/gourmand_beetroot_block" | "supplementaries:key" | "minecraft:blackstone_wall" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/orange" | "mysticalagradditions:tconstruct/melting/supremium/block" | "thermal_extra:machine/press/twinite_plate" | "caveopolis:sprayer/remove_color/stripped_woods" | "thermal:rubberwood_boat" | "thermal:machines/press/press_amaranth_unpacking" | "caveopolis:red_colored_wooden_plank_stairs" | "thermal_extra:augments/rf_coil_augment_5" | "thermal:fuels/gourmand/gourmand_dried_kelp_block" | "thermal_extra:augments/rf_coil_augment_4" | "mysticalagriculture:essence/minecraft/leather" | "thermal_extra:augments/rf_coil_augment_1" | "minecraft:dried_kelp_from_smelting" | "thermal:machines/press/packing3x3/press_iron_nugget_packing" | "cozy_home:warped_plank_recipe" | "thermal_extra:augments/rf_coil_augment_3" | "thermal_extra:augments/rf_coil_augment_2" | "minecraft:cherry_sign" | "caveopolis:sprayer/banners/green" | "mysticalagriculture:tertium_ingot_uncraft" | "caveopolis:sprayer/glass_block/light_blue" | "industrialforegoing:fluid_laser_base" | "thermal:compat/biomesoplenty/sawmill_bop_magic_logs" | "caveopolis:cyan_colored_cobblestone_brick_stairs" | "farmersdelight:onion_crate" | "caveopolis:light_gray_colored_wooden_plank_door" | "thermal:compat/redstone_arsenal/press_rsa_flux_metal_packing" | "thermal:machines/centrifuge/centrifuge_honeycomb" | "supplementaries:sugar_cube" | "igleelib:blazum_ingot" | "caveopolis:purple_colored_wooden_plank_pressure_plate_from_purple_colored_wooden_planks_stonecutting" | "suppsquared:daub_frame_stairs" | "thermal:fire_grenade_4" | "farmersdelight:cutting/saddle" | "minecraft:dye_blue_carpet" | "thermal:machines/smelter/smelter_tin_tools" | "farmersdelight:cutting/cherry_hanging_sign" | "mysticalagriculture:seed/crafting/soulium" | "minecraft:exposed_cut_copper_stairs" | "mysticalagriculture:gear/tertium_chestplate" | "caveopolis:sprayer/colored_cobblestone_bricks/lime_colored_stone_bricks" | "mysticalagradditions:tconstruct/tools/casting/supremium" | "mysticalagriculture:seed/crafting/pig" | "minecraft:jungle_boat" | "lfpirates:corsair_tier_3_leggins_recipe_1" | "caveopolis:sprayer/colored_signs/magenta" | "thermal:augments/machine_cycle_augment" | "supplementaries:candle_holders/candle_holder_pink" | "thermal:machines/press/press_lumium_ingot_to_coin" | "thermal:machines/pulverizer/pulverizer_netherite_plate_to_dust" | "caveopolis:sprayer/colored_cobblestone_brick_slab/white" | "minecraft:stripped_mangrove_wood" | "thermal:compat/dyenamics/bottler_dyenamics_persimmon_concrete" | "caveopolis:sprayer/colored_stone_crafting_table/blue" | "sophisticatedbackpacks:advanced_feeding_upgrade" | "thermal:machines/pulverizer/pulverizer_emerald" | "minecraft:light_weighted_pressure_plate" | "alltheores:platinum_ingot_from_ore" | "mysticalagriculture:seed/infusion/iridium" | "thermal_extra:smelting/shellite_ingot_from_dust_smelting" | "mysticalagriculture:gear/awakened_supremium_scythe" | "minecraft:dye_green_wool" | "supplementaries:stonecutting/stone_tile_slab" | "caveopolis:black_colored_wooden_plank_slab_from_black_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/glazed_terracotta/pink" | "mysticalagriculture:seed/infusion/osmium" | "smallships:jungle_galley" | "sophisticatedbackpacks:diamond_backpack" | "thermal:machines/centrifuge/centrifuge_glowstone_mushroom_spores" | "alltheores:mek_processing/platinum/ingot/from_dust_blasting" | "minecraft:black_stained_glass_pane_from_glass_pane" | "minecraft:pink_banner" | "thermal:machines/press/packing3x3/press_constantan_nugget_packing" | "alltheores:mek_processing/zinc/shard/from_ore" | "mysticalagradditions:tconstruct/tools/materials/tertium/nugget" | "strainers:meshes/string" | "minecraft:bamboo_button" | "mysticalagradditions:tconstruct/tools/melting/inferium" | "minecraft:copper_ingot_from_waxed_copper_block" | "thermal:augments/machine_speed_augment" | "opolisutilities:resource_generator/mods/caveopolis/magenta_colored_stone" | "minecraft:cherry_trapdoor" | "caveopolis:light_gray_colored_stone_pressure_plate_from_light_gray_colored_stone_stonecutting" | "thermal_extra:sticky_ball_to_paper" | "mysticalagriculture:seed/infusion/prismarine" | "supplementaries:doormat_2" | "thermal:armor/hazmat_helmet" | "mysticalagriculture:enchanter/thorns" | "caveopolis:orange_colored_wooden_plank_door" | "mysticalagriculture:augment/strength_i" | "chipped:benches/alchemy_bench" | "minecraft:acacia_trapdoor" | "mysticalagriculture:prudentium_block_combine" | "caveopolis:blue_colored_stone_brick_wall_from_blue_colored_stone_bricks_stonecutting" | "thermal_extra:machine/press/shellite_plate" | "minecraft:cut_copper_slab_from_cut_copper_stonecutting" | "thermal:storage/beetroot_block" | "alltheores:invar_nugget_from_ingot" | "thermal:parts/enderium_gear" | "mysticalagriculture:soulium_block" | "thermal:machines/press/unpacking/press_raw_lead_unpacking" | "thermal:machines/pulverizer/pulverizer_bone" | "caveopolis:white_colored_cobblestone_brick_wall_from_white_colored_cobblestone_bricks_stonecutting" | "alltheores:mek_processing/nickel/clump/from_raw_block" | "caveopolis:yellow_colored_wooden_plank_slab_from_yellow_colored_wooden_planks_stonecutting" | "thermal:compat/tconstruct/press_tconstruct_amethyst_bronze_nugget_packing" | "minecraft:cracked_nether_bricks" | "caveopolis:sprayer/colored_hanging_signs/pink" | "caveopolis:lime_colored_stone_bricks_from_lime_colored_stone_stonecutting" | "cozy_home:quartz_chair_recipe" | "opolisutilities:resource_generator_2/speed_blocks/compressed_iron" | "farmersdelight:cutting/bamboo_sign" | "alltheores:mek_processing/zinc/dust/from_ore" | "mysticalagriculture:seed/reprocessor/diamond" | "mysticalagriculture:essence/minecraft/horn_coral" | "minecraft:purpur_pillar_from_purpur_block_stonecutting" | "supplementaries:slingshot" | "caveopolis:sprayer/glass_block/brown" | "caveopolis:cyan_colored_wood" | "thermal:compat/mysticalagriculture/insolator_mysticalag_slimesteel_seeds" | "thermal:dynamo_lapidary" | "thermal:machines/press/packing2x2/press_prismarine_packing" | "thermal:storage/apple_block" | "thermal:machines/press/press_constantan_nugget_to_coin" | "caveopolis:blue_colored_stone_crafting_table" | "alltheores:raw_osmium_from_block" | "minecraft:copper_ingot_from_smelting_copper_ore" | "caveopolis:green_colored_wooden_plank_door_from_green_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/colored_stone_crafting_table/lime" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/orange" | "mysticalagriculture:essence/minecraft/black_concrete" | "caveopolis:sprayer/colored_hanging_signs/green" | "caveopolis:sprayer/terracotta/yellow" | "aquaculture:neptunium_ingot_from_nuggets" | "mysticalagriculture:essence/minecraft/cherry_log" | "thermal:machines/press/press_radish_unpacking" | "caveopolis:light_gray_colored_stone_slab_from_light_gray_colored_stone_stonecutting" | "thermal:saw_blade" | "minecraft:iron_pickaxe" | "thermal:compat/dyenamics/bottler_dyenamics_peach_concrete" | "cozy_home:quartz_bench_recipe" | "minecraft:spruce_button" | "mysticalagriculture:souls/slime_ball" | "caveopolis:sprayer/banners/black" | "thermal:machines/press/press_onion_packing" | "caveopolis:brown_colored_cobblestone_brick_slab_from_brown_colored_cobblestone_bricks_stonecutting" | "caveopolis:orange_colored_cobblestone_bricks_from_orange_colored_cobblestone_stonecutting" | "mysticalagriculture:essence/minecraft/blaze_rod" | "minecraft:deepslate_tiles" | "alltheores:mek_processing/nickel/dust/from_ore" | "mysticalagriculture:seed/infusion/slime" | "caveopolis:pink_colored_stone_stairs" | "oceansdelight:cutting/pufferfish" | "minecraft:polished_diorite_stairs" | "minecraft:nether_brick_stairs_from_nether_bricks_stonecutting" | "mysticalagriculture:essence/common/iridium_ingot" | "thermal:machines/crystallizer/crystallizer_lapis" | "minecraft:dark_oak_slab" | "mysticalagriculture:seed/reprocessor/signalum" | "caveopolis:blue_colored_cobblestone_brick_stairs_from_blue_colored_cobblestone_bricks_stonecutting" | "caveopolis:orange_colored_wooden_plank_crafting_table" | "thermal:tools/xp_crystal" | "thermal:smelting/cinnabar_from_blasting" | "thermal:machines/press/unpacking/press_cured_rubber_unpacking" | "caveopolis:red_colored_hanging_sign" | "sophisticatedbackpacks:inception_upgrade" | "mysticalagradditions:dragon_egg_crux" | "caveopolis:sprayer/colored_cobblestone_stairs/lime_colored_stone_stairs" | "minecraft:lime_stained_glass" | "mysticalagriculture:essence/common/zinc_ingot" | "mysticalagriculture:seed/infusion/turtle" | "cozy_home:counter_birch_sink_recipe" | "thermal:earth_tnt_minecart" | "minecraft:stone_brick_walls_from_stone_stonecutting" | "mysticalagradditions:tconstruct/tools/materials/supremium/ingot" | "caveopolis:lime_colored_hanging_sign_from_stripped_lime_colored_log_stonecutting" | "caveopolis:green_colored_sign" | "industrialforegoing:mycelial_magma" | "alltheores:thermal_pulverize/pulverizer_platinum_ingot_to_dust" | "caveopolis:sprayer/colored_cobblestone_stairs/brown_colored_stone_stairs" | "strainers:meshes/echo" | "alltheores:lead_ingot_from_block" | "alltheores:enderium_ingot_from_dust" | "mysticalagriculture:supremium_ingot_recraft" | "mysticalagriculture:essence/minecraft/snow_block" | "minecraft:yellow_dye_from_dandelion" | "caveopolis:orange_colored_stone_pressure_plate_from_orange_colored_stone_stonecutting" | "mysticalagriculture:seed/crafting/soularium" | "mysticalagriculture:soulstone_bricks" | "thermal:earth_charge/cinnabar_dust_from_cinnabar" | "minecraft:sentry_armor_trim_smithing_template_smithing_trim" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/light_gray" | "farmersdelight:cutting/spruce_trapdoor" | "strainers:summoning_block/salmon" | "nec:rubberwood_chest" | "aquamirae:terrible_sword" | "caveopolis:brown_colored_stone_wall_from_brown_colored_stone_stonecutting" | "mysticalagriculture:inferium_upgrade" | "mysticalagriculture:seed/crafting/sky_stone" | "suppsquared:candle_holders/gold_candle_holder_lime" | "minecraft:eye_armor_trim_smithing_template" | "strainers:upgrades/reinforced/reinforced_output_upgrade" | "thermal:machines/insolator/insolator_dandelion" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/green" | "farmersdelight:cutting/warped_door" | "aquamirae:treasure_pouch" | "strainers:summoning_block/turtle" | "thermal:smelting/lead_ingot_from_dust_blasting" | "storagedrawers:jungle_full_drawers_1" | "thermal:dynamo_gourmand" | "caveopolis:magenta_colored_stone_pressure_plate" | "thermal:storage/tomato_from_block" | "caveopolis:light_gray_colored_stone_bricks" | "storagedrawers:upgrade_template" | "thermal:compat/mysticalagriculture/insolator_mysticalag_chicken_seeds" | "mysticalagriculture:seed/reprocessor/basalt" | "thermal:compat/mysticalagriculture/insolator_mysticalag_skeleton_seeds" | "minecraft:polished_blackstone_brick_slab_from_blackstone_stonecutting" | "minecraft:polished_blackstone_brick_wall_from_polished_blackstone_stonecutting" | "systeams:boilers/upgrades/stirling_downgrade" | "thermal:compat/mysticalagriculture/insolator_mysticalag_diamond_seeds" | "mysticalagriculture:essence/minecraft/diamond" | "caveopolis:sprayer/colored_logs/gray" | "mysticalagriculture:seed/reprocessor/basalz" | "caveopolis:orange_colored_stone_pressure_plate" | "minecraft:mangrove_button" | "mysticalagriculture:essence/minecraft/purpur_block" | "caveopolis:sprayer/colored_stone_bricks/brown_colored_stone_bricks" | "caveopolis:sprayer/colored_cobblestone_brick_slab/light_gray" | "caveopolis:lime_colored_stone_wall" | "minecraft:yellow_bed" | "minecraft:nether_brick_slab_from_nether_bricks_stonecutting" | "supplementaries:flags/flag_brown" | "caveopolis:sprayer/colored_wood/magenta" | "minecraft:waxed_cut_copper_slab_from_waxed_cut_copper_stonecutting" | "mysticalagriculture:soulium_ingot_uncraft" | "minecraft:cooked_salmon_from_smoking" | "aquamirae:bone_meal_from_sharp_bones" | "minecraft:bamboo_mosaic" | "thermal:machines/press/packing3x3/press_constantan_packing" | "thermal:machines/sawmill/sawmill_crimson_stems" | "suppsquared:daub_frame_slab" | "caveopolis:sprayer/colored_cobblestone_wall/green_colored_stone_wall" | "caveopolis:sprayer/glass_pane/brown" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/red" | "strainers:upgrade_stats/reinforced_duration_upgrade" | "farmersdelight:cutting/jungle_trapdoor" | "mysticalagriculture:seed/crafting/nether" | "minecraft:purple_candle" | "caveopolis:brown_colored_cobblestone" | "thermal:parts/signalum_gear" | "lfpirates:sailor_blue_tier_2_leggins_recipe_1" | "alltheores:mek_processing/iridium/shard/from_raw_block" | "minecraft:mossy_stone_brick_slab" | "mysticalagriculture:seed/crafting/blazing_crystal" | "mysticalagriculture:gear/prudentium_fishing_rod" | "thermal:storage/coffee_from_block" | "suppsquared:candle_holders/gold_candle_holder_blue" | "minecraft:polished_blackstone_wall_from_polished_blackstone_stonecutting" | "strainers:suspicious_sand_from_straining_suspicious_stew_in_minecraft_sand" | "strainers:azure_bluet_from_straining_grass_in_strainers_purified_water_fluid" | "mysticalagradditions:tconstruct/melting/prudentium/nugget" | "caveopolis:cyan_colored_sign" | "cozy_home:warped_mirror_stand_recipe" | "thermal:machines/insolator/insolator_kelp" | "alltheores:mek_processing/iridium/slurry/clean" | "sophisticatedbackpacks:crafting_upgrade" | "opolisutilities:fluid_generator/water" | "libraryferret:smelting/netherite_coins_jtl" | "cozy_home:acacia_miror_recipe" | "matc:crystals/master_infusion_crystal" | "aquaculture:birch_fish_mount" | "caveopolis:purple_colored_hanging_sign" | "caveopolis:sprayer/shulker_box/cyan" | "thermal:turbo_servo_attachment_2" | "minecraft:cobblestone_stairs" | "supplementaries:candle_holders/candle_holder_orange" | "caveopolis:sprayer/banners/purple" | "thermal:machines/smelter/smelter_diamond_ore" | "cozy_home:counter_birch_storage_recipe" | "thermal:machines/bottler/bottler_mossy_cobblestone" | "opolisutilities:resource_generator_2/blocks/stone" | "caveopolis:sprayer/colored_leaves/red" | "nec:mangrove_chest" | "mysticalagriculture:soulium_spawner/sheep" | "thermal:storage/silver_nugget_from_ingot" | "thermal:device_nullifier" | "industrialforegoing:dryrubber" | "farmersdelight:cutting/warped_hyphae" | "mysticalagriculture:seed/reprocessor/dragon_egg" | "alltheores:iridium_block" | "mysticalagriculture:seed/crafting/lead" | "thermal_extra:augments/fluid_tank_augment_5" | "caveopolis:sprayer/colored_stone_pressure_plate/light_gray" | "caveopolis:sprayer/terracotta/purple" | "thermal_extra:augments/fluid_tank_augment_3" | "thermal_extra:augments/fluid_tank_augment_4" | "mysticalagriculture:essence/minecraft/ender_pearl" | "thermal_extra:augments/fluid_tank_augment_1" | "thermal_extra:augments/fluid_tank_augment_2" | "caveopolis:white_colored_stone_brick_slab_from_white_colored_stone_bricks_stonecutting" | "minecraft:polished_basalt" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/pink" | "mysticalagriculture:seed/infusion/dragon_egg" | "thermal:compat/mysticalagriculture/insolator_mysticalag_ironwood_seeds" | "thermal:machines/press/packing3x3/press_blue_ice_packing" | "thermal:machines/centrifuge/centrifuge_blue_rockwool" | "minecraft:sentry_armor_trim_smithing_template" | "minecraft:polished_andesite_slab" | "alltheores:mek_processing/zinc/shard/from_crystal" | "thermal:compat/biomesoplenty/insolator_bop_flowering_oak_sapling" | "caveopolis:pink_colored_cobblestone_brick_stairs_from_pink_colored_cobblestone_bricks_stonecutting" | "smallships:acacia_cog" | "industrialforegoing:marine_fisher" | "caveopolis:green_colored_cobblestone_wall" | "caveopolis:sprayer/colored_stone/purple_colored_stone" | "strainers:sunflower_from_straining_tall_grass_in_strainers_purified_water_fluid" | "thermal:red_concrete_powder_with_slag" | "caveopolis:sprayer/beds/light_blue" | "opolisutilities:resource_generator_2/blocks/dripstone_block" | "strainers:summoning_block/wither_skeleton" | "alltheores:uranium_ingot" | "mysticalagriculture:gear/prudentium_watering_can" | "thermal:machines/pulverizer/pulverizer_raw_nickel" | "alltheores:mek_processing/platinum/shard/from_raw_block" | "caveopolis:black_colored_stone_brick_stairs_from_black_colored_stone_bricks_stonecutting" | "thermal:fuels/numismatic/numismatic_nickel_coin" | "mysticalagriculture:soulium_ingot_recraft" | "minecraft:yellow_candle" | "mysticalagriculture:soulium_block_uncraft" | "caveopolis:sprayer/colored_wooden_plank_fence/white" | "opolisutilities:resource_generator/mods/caveopolis/blue_colored_stone" | "caveopolis:sprayer/colored_hanging_signs/cyan" | "thermal:machines/press/packing3x3/press_melon_packing" | "mysticalagriculture:seed/infusion/cobalt" | "thermal:storage/enderium_nugget_from_ingot" | "strainers:prismarine_crystals_from_straining_barrier_in_strainers_purified_water_fluid" | "caveopolis:sprayer/colored_stone_crafting_table/yellow" | "alltheores:mek_processing/nickel/dust/from_ingot" | "strainers:miner_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "mysticalagriculture:essence/refinedstorage/quartz_enriched_iron_ingot" | "minecraft:repeater" | "aquamirae:abyssal_brigantine" | "minecraft:red_concrete_powder" | "strainers:upgrade_stats/improved_output_upgrade" | "caveopolis:sprayer/glazed_terracotta/orange" | "mysticalagriculture:seed/crafting/quartz_enriched_iron" | "smallships:spruce_cog" | "caveopolis:sprayer/colored_leaves/gray" | "caveopolis:white_colored_cobblestone_stairs" | "mysticalagriculture:seed/crafting/slime" | "minecraft:iron_leggings" | "alltheores:mek_processing/zinc/dust/from_dirty_dust" | "thermal_extra:augments/upgrade_augment" | "thermal:machines/insolator/insolator_cherry_sapling" | "thermal:machines/pulverizer/pulverizer_nickel_ore" | "thermal:storage/carrot_block" | "alltheores:uranium_dust_from_hammer_ingot_crushing" | "cozy_home:sofa_purple_recipe" | "caveopolis:sprayer/colored_stone_brick_stairs/white_colored_stone_brick_stairs" | "minecraft:book_cloning" | "mysticalagriculture:seed/infusion/starmetal" | "thermal:phyto_tnt" | "alltheores:mek_processing/iridium/clump/from_shard" | "caveopolis:sprayer/shulker_box/green" | "thermal:machines/press/press_electrum_nugget_to_coin" | "mysticalagriculture:essence/twilightforest/knightmetal_ingot" | "thermal:machines/press/packing3x3/press_dried_kelp_packing" | "thermal:orange_concrete_powder_with_slag" | "opolisutilities:wooden_shears" | "thermal:machines/insolator/insolator_oak_sapling" | "minecraft:mushroom_stew" | "farmersdelight:cooked_mutton_chops_from_smoking" | "strainers:upgrade_stats/reinforced_everything_upgrade" | "thermal:machines/press/unpacking/press_coal_unpacking" | "mysticalagriculture:supremium_ingot_uncraft" | "caveopolis:green_colored_cobblestone_brick_slab_from_green_colored_cobblestone_bricks_stonecutting" | "caveopolis:green_colored_stone_brick_wall_from_green_colored_stone_bricks_stonecutting" | "mysticalagriculture:seed/crafting/refined_glowstone" | "mysticalagriculture:seed/reprocessor/aquamarine" | "thermal:compat/create/press_create_raw_zinc_unpacking" | "lfpirates:sailor_blue_tier_2_boots_recipe_1" | "minecraft:dye_white_carpet" | "mysticalagriculture:gear/tertium_boots" | "thermal:machines/smelter/smelter_alloy_electrum" | "alltheores:iridium_ingot_from_block" | "caveopolis:sprayer/colored_stone/black_colored_stone" | "caveopolis:sprayer/colored_stone_wall/green_colored_stone_wall" | "mysticalagriculture:gear/supremium_pickaxe" | "thermal:machines/insolator/insolator_potato" | "thermal:storage/raw_nickel_from_block" | "mysticalagradditions:tconstruct/melting/inferium/nugget" | "minecraft:jungle_door" | "minecraft:prismarine_brick_slab" | "farmersdelight:full_tatami_mat" | "minecraft:nether_bricks" | "caveopolis:sprayer/colored_wooden_plank_stairs/red" | "minecraft:iron_chestplate" | "caveopolis:sprayer/colored_stone_buttons/green" | "minecraft:lapis_lazuli_from_blasting_deepslate_lapis_ore" | "thermal:smelting/cured_rubber_from_smelting" | "mysticalagriculture:seed/reprocessor/blaze" | "mysticalagriculture:essence/enderio/pulsating_alloy_ingot" | "farmersdelight:rope" | "smallships:dark_oak_cog" | "supplementaries:sign_post_dark_oak" | "minecraft:vex_armor_trim_smithing_template" | "lfpirates:sailor_nordic_tier_1_boots_recipe_1" | "caveopolis:gray_colored_stone_stairs" | "thermal_extra:machine/dynamo/numismatic/shellite_coin" | "alltheores:mek_processing/zinc/clump/from_raw_ore" | "mysticalagriculture:prosperity_shard_smelted" | "mysticalagradditions:tconstruct/tools/materials/prudentium/block" | "minecraft:polished_andesite_from_andesite_stonecutting" | "storagedrawers:jungle_full_drawers_4" | "caveopolis:gray_colored_wooden_plank_stairs" | "smallships:jungle_drakkar" | "lfpirates:sailor_gray_tier_2_boots_recipe_1" | "storagedrawers:jungle_full_drawers_2" | "thermal:press_packing_2x2_die" | "minecraft:crimson_stairs" | "caveopolis:lime_colored_stone_pressure_plate" | "alltheores:mek_processing/zinc/dust/from_raw_block" | "minecraft:mud_brick_slab_from_mud_bricks_stonecutting" | "cozy_home:desk_dark_oak_recipe" | "thermal:compat/tconstruct/smelter_alloy_tconstruct_pigiron_ingot" | "lfpirates:sailor_red_tier_2_helmet_recipe_1" | "cozy_home:desk_acacia_recipe" | "thermal:compat/immersiveengineering/press_ie_steel_ingot_to_plate" | "thermal:machines/centrifuge/centrifuge_poppy" | "caveopolis:orange_colored_stone_button" | "caveopolis:orange_colored_cobblestone_slab" | "minecraft:stone_brick_stairs" | "caveopolis:white_colored_wooden_plank_trapdoor_from_white_colored_wooden_planks_stonecutting" | "thermal:machines/centrifuge/centrifuge_pink_wool" | "mysticalagriculture:seed/reprocessor/inferium" | "thermal:smelting/silver_ingot_from_deepslate_ore_blasting" | "caveopolis:sprayer/colored_wooden_plank_slab/orange" | "mysticalagriculture:inferium_block_uncraft" | "caveopolis:gray_colored_wooden_plank_slab" | "alltheores:uranium_dust_from_hammer_crushing" | "industrialforegoing:laser_drill_ore/ores/niter" | "minecraft:polished_blackstone_wall_from_blackstone_stonecutting" | "minecraft:smooth_stone_slab_from_smooth_stone_stonecutting" | "caveopolis:pink_colored_stone_brick_slab_from_pink_colored_stone_bricks_stonecutting" | "cozy_home:andesite_brick_to_block_recipe" | "cozy_home:counter_jungle_storage_recipe" | "mysticalagriculture:soulium_spawner/chicken" | "thermal:storage/bell_pepper_from_block" | "minecraft:clock" | "industrialforegoing:mycelial_culinary" | "mysticalagriculture:seed/crafting/grains_of_infinity" | "caveopolis:light_gray_colored_cobblestone_brick_wall" | "caveopolis:sprayer/colored_stone_pressure_plate/green" | "caveopolis:yellow_colored_stone_stairs_from_yellow_colored_stone_stonecutting" | "caveopolis:white_colored_wooden_plank_button" | "thermal:machines/press/packing3x3/press_gold_packing" | "caveopolis:black_colored_cobblestone_bricks_from_black_colored_cobblestone_stonecutting" | "mysticalagriculture:essence/enderio/copper_alloy_ingot" | "mysticalagradditions:tconstruct/casting/inferium/block" | "thermal:armor/beekeeper_leggings" | "minecraft:blue_ice" | "duckling:holiday_fruit_cake" | "thermal:machines/press/unpacking/press_raw_copper_unpacking" | "thermal:machines/smelter/smelter_niter_ore" | "aquaculture:bonemeal_from_fish_bones" | "minecraft:diamond_leggings" | "mysticalagriculture:seed/infusion/fiery_ingot" | "thermal:smelting/slime_ball_from_spores_smelting" | "opolisutilities:iron_horse_armor" | "minecraft:purple_stained_glass" | "alltheores:iron_ingot_from_dust_blasting" | "minecraft:cut_copper_stairs" | "farmersdelight:integration/immersiveengineering/fermenter/tomato" | "caveopolis:yellow_colored_cobblestone_brick_slab" | "alltheores:tin_rod" | "caveopolis:red_colored_stone_brick_slab_from_red_colored_stone_bricks_stonecutting" | "thermal:machines/press/press_coffee_unpacking" | "minecraft:polished_andesite_slab_from_andesite_stonecutting" | "minecraft:dye_black_bed" | "thermal:machines/smelter/smelter_ancient_debris" | "thermal:storage/tin_ingot_from_block" | "mysticalagriculture:seed/reprocessor/creeper" | "mysticalagriculture:seed/infusion/nether_quartz" | "minecraft:mossy_stone_bricks_from_moss_block" | "minecraft:orange_banner" | "caveopolis:sprayer/beds/pink" | "thermal_extra:augments/machine_catalyst_augment_1" | "farmersdelight:cutting/birch_trapdoor" | "thermal_extra:augments/machine_catalyst_augment_2" | "minecraft:dark_oak_sign" | "thermal_extra:augments/machine_catalyst_augment_3" | "thermal:compat/tconstruct/press_tconstruct_pig_iron_unpacking" | "supplementaries:feather_block" | "farmersdelight:iron_nugget_from_smelting_knife" | "thermal:machines/crystallizer/crystallizer_diamond" | "minecraft:oak_hanging_sign" | "mysticalagriculture:seed/reprocessor/fiery_ingot" | "caveopolis:sprayer/shulker_box/white" | "mysticalagriculture:essence/minecraft/pufferfish" | "alltheores:mek_processing/aluminum/dust/from_raw_ore" | "minecraft:brick_slab_from_bricks_stonecutting" | "caveopolis:light_gray_colored_cobblestone_slab" | "supplementaries:pancake_fd" | "minecraft:polished_blackstone_button" | "strainers:brain_coral_block_from_straining_brain_coral_in_strainers_purified_water_fluid" | "cozy_home:table_stump_spruce_recipe" | "thermal:smelting/lumium_ingot_from_dust_blasting" | "caveopolis:brown_colored_wooden_planks" | "mysticalagriculture:souls/blizz_rod" | "caveopolis:sprayer/colored_wooden_planks/green" | "caveopolis:gray_colored_wooden_plank_fence_from_gray_colored_wooden_planks_stonecutting" | "farmersdelight:cutting/quartz_block" | "mysticalagriculture:souls/scute" | "caveopolis:sprayer/banners/white" | "mysticalagriculture:soulium_spawner/wither_skeleton" | "thermal:machines/smelter/smelter_catalyst_blaze_powder" | "thermal:compat/mysticalagriculture/insolator_mysticalag_gold_seeds" | "caveopolis:magenta_colored_sign" | "mysticalagriculture:soulstone_bricks_slab" | "minecraft:lime_stained_glass_pane_from_glass_pane" | "systeams:boilers/upgrades/stirling_upgrade" | "minecraft:magenta_glazed_terracotta" | "farmersdelight:cutting/leather_chestplate" | "industrialforegoing:laser_drill_ore/ores/sulfur" | "thermal:compat/mekanism/crystallizer_mek_fluorite" | "caveopolis:black_colored_sign_from_black_colored_wooden_planks_stonecutting" | "framedcompactdrawers:framed_full_two" | "farmersdelight:bacon_sandwich" | "oceansdelight:baked_tentacle_on_a_stick_from_campfire_cooking" | "mysticalagriculture:seed/crafting/amethyst_bronze" | "minecraft:wooden_shovel" | "caveopolis:white_colored_stone_brick_stairs" | "caveopolis:sprayer/stripped_colored_wood/red" | "industrialforegoing:laser_drill_ore/raw_materials/tetrahedrite" | "oceansdelight:cooked_stuffed_cod_from_campfire_cooking" | "thermal:compat/create/bottler_create_redstone" | "smallships:jungle_cog" | "luggage:luggage" | "mysticalagriculture:seed/crafting/silver" | "minecraft:bamboo_trapdoor" | "opolisutilities:catalogue/selling/caveopolis/brown_spray_can" | "thermal:machines/centrifuge/centrifuge_light_blue_rockwool" | "caveopolis:purple_colored_cobblestone_brick_slab_from_purple_colored_cobblestone_bricks_stonecutting" | "farmersdelight:lead_from_straw" | "caveopolis:sprayer/colored_cobblestone_slab/brown_colored_stone_slab" | "thermal:glowstone_grenade_4" | "minecraft:waxed_copper_block_from_honeycomb" | "smallships:mangrove_galley" | "mysticalagriculture:souls/blaze_rod" | "mysticalagriculture:gear/supremium_leggings" | "thermal:machines/press/unpacking/press_carrot_unpacking" | "supplementaries:blackstone_tile_slab" | "thermal:storage/steel_block" | "minecraft:warped_fungus_on_a_stick" | "caveopolis:sprayer/colored_cobblestone_bricks/light_blue_colored_stone_bricks" | "melongolem:glisteringmelonblock" | "ftbquests:book" | "supplementaries:flags/flag_yellow" | "mysticalagriculture:witherproof_bricks" | "caveopolis:sprayer/colored_wooden_plank_fence/light_gray" | "minecraft:gold_ingot_from_smelting_raw_gold" | "caveopolis:orange_colored_stone_wall" | "alltheores:invar_ingot_from_dust_blasting" | "minecraft:spruce_hanging_sign" | "mysticalagriculture:essence/thermal/signalum_ingot" | "caveopolis:red_colored_wooden_plank_slab_from_red_colored_wooden_planks_stonecutting" | "chipped:loom_table" | "farmersdelight:cyan_canvas_sign" | "minecraft:cooked_cod_from_smoking" | "caveopolis:sprayer/colored_cobblestone_brick_slab/cyan" | "nec:dark_oak_chest" | "mysticalagriculture:essence/minecraft/amethyst" | "thermal:compat/redstone_arsenal/press_rsa_flux_metal_unpacking" | "thermal:storage/apple_from_block" | "strainers:summoning_block/slime" | "cozy_home:oak_bench_recipe" | "farmersdelight:gold_nugget_from_blasting_knife" | "mysticalagriculture:tertium_gemstone_block_uncraft" | "alltheores:uranium_gear" | "caveopolis:sprayer/colored_stone_buttons/black" | "industrialforegoing:dissolution_chamber/laser_lens1" | "mysticalagriculture:essence/minecraft/music_disc_cat" | "industrialforegoing:dissolution_chamber/laser_lens0" | "industrialforegoing:dissolution_chamber/laser_lens3" | "industrialforegoing:dissolution_chamber/laser_lens2" | "industrialforegoing:dissolution_chamber/laser_lens5" | "industrialforegoing:dissolution_chamber/laser_lens4" | "caveopolis:sprayer/glazed_terracotta/green" | "sophisticatedbackpacks:anvil_upgrade" | "industrialforegoing:dissolution_chamber/laser_lens7" | "industrialforegoing:dissolution_chamber/laser_lens6" | "mysticalagriculture:essence/gems/sapphire" | "thermal_extra:machine/press/twinite_nugget_to_coin" | "industrialforegoing:dissolution_chamber/laser_lens9" | "industrialforegoing:dissolution_chamber/laser_lens8" | "minecraft:moss_block" | "thermal:compat/mysticalagriculture/insolator_mysticalag_energized_steel_seeds" | "cozy_home:counter_jungle_sink_recipe" | "farmersdelight:cutting/mangrove_wood" | "caveopolis:cyan_colored_stone_brick_slab_from_cyan_colored_stone_bricks_stonecutting" | "industrialforegoing:pitiful_generator" | "thermal:machines/press/packing3x3/press_slime_packing" | "alltheores:lead_gear" | "caveopolis:red_colored_wooden_plank_crafting_table" | "mysticalagriculture:enchanter/fire_protection" | "thermal:machines/pulverizer/pulverizer_invar_plate_to_dust" | "mysticalagriculture:essence/minecraft/magenta_dye" | "caveopolis:lime_colored_cobblestone_wall_from_lime_colored_cobblestone_stonecutting" | "mysticalagriculture:seed/infusion/saltpeter" | "mysticalagriculture:seed/crafting/fluix" | "industrialforegoing:sewer" | "minecraft:copper_ingot" | "mysticalagradditions:tconstruct/casting/inferium/ingot_gold_cast" | "minecraft:waxed_weathered_cut_copper_slab" | "thermal:smelting/cooked_mushroom_from_campfire_cooking" | "minecraft:string" | "minecraft:white_dye_from_lily_of_the_valley" | "alltheores:aluminum_ingot_from_slate_ore_blasting" | "minecraft:pink_dye_from_pink_petals" | "mysticalagriculture:essence/common/bronze_ingot" | "minecraft:end_stone_brick_wall" | "mysticalagriculture:essence/minecraft/crimson_fungus" | "thermal:compat/tconstruct/sawmill_tconstruct_bloodshroom_logs" | "thermal:machines/insolator/insolator_glowstone_mushroom" | "mysticalagriculture:essence/minecraft/salmon" | "caveopolis:magenta_colored_cobblestone" | "caveopolis:light_gray_colored_stone_brick_wall_from_light_gray_colored_stone_bricks_stonecutting" | "mysticalagriculture:seed/reprocessor/platinum" | "mysticalagriculture:essence/minecraft/packed_ice" | "alltheores:lumium_dust_from_alloy_blending" | "supplementaries:candle_holders/candle_holder_purple_dye" | "thermal:fuels/numismatic/numismatic_tin_coin" | "mysticalagriculture:seed/reprocessor/lumium" | "thermal:machines/insolator/insolator_corn" | "mysticalagriculture:seed/crafting/deepslate" | "caveopolis:sprayer/colored_wooden_planks/black" | "alltheores:brass_gear" | "mysticalagriculture:essence/minecraft/nether_bricks" | "strainers:explorer_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "caveopolis:sprayer/colored_saplings/cyan" | "simplehats:hatbag_common" | "caveopolis:black_colored_stone_brick_slab" | "alltheores:brass_nugget_from_ingot" | "caveopolis:colored_caves_portal" | "minecraft:waxed_oxidized_cut_copper_stairs_from_honeycomb" | "libraryferret:blasting/diamond_coins_jtl" | "minecraft:netherite_chestplate_smithing" | "mysticalagriculture:seed/crafting/steeleaf" | "mysticalagradditions:tconstruct/casting/imperium/nugget_gold_cast" | "thermal_extra:augments/machine_output_augment_3" | "caveopolis:black_colored_stone_brick_stairs" | "thermal:compat/mysticalagriculture/insolator_mysticalag_silver_seeds" | "minecraft:oak_sign" | "thermal:machines/refinery/refinery_sap" | "caveopolis:pink_colored_wooden_plank_trapdoor" | "caveopolis:yellow_colored_cobblestone_bricks_from_black_colored_cobblestone_stonecutting" | "lfpirates:craftsman_leggins_recipe_1" | "thermal_extra:augments/machine_output_augment_1" | "systeams:boilers/upgrades/magmatic_upgrade" | "thermal_extra:augments/machine_output_augment_2" | "caveopolis:sprayer/colored_cobblestone_brick_slab/yellow" | "mysticalagriculture:essence/minecraft/blue_concrete" | "opolisutilities:soaking_table/water_bottle" | "thermal:flux_capacitor" | "caveopolis:gray_colored_wooden_plank_stairs_from_gray_colored_wooden_planks_stonecutting" | "thermal:machines/insolator/insolator_brown_mushroom" | "strainers:blade_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "caveopolis:gray_colored_wooden_plank_fence_gate_from_gray_colored_wooden_planks_stonecutting" | "mysticalagriculture:awakened_supremium_gemstone" | "thermal:machine_press" | "mysticalagriculture:souls/ghast_tear" | "thermal:smelting/sulfur_from_smelting" | "minecraft:red_sandstone_stairs_from_red_sandstone_stonecutting" | "mysticalagriculture:seed/reprocessor/pig" | "farmersdelight:cutting/wild_beetroots" | "caveopolis:lime_colored_cobblestone_brick_stairs_from_lime_colored_cobblestone_bricks_stonecutting" | "minecraft:smooth_sandstone_slab_from_smooth_sandstone_stonecutting" | "industrialforegoing:dissolution_chamber/advanced_machine_frame" | "mysticalagriculture:infusion_altar" | "mysticalagriculture:mystical_fertilizer" | "mysticalagriculture:seed/reprocessor/glowstone" | "industrialforegoing:supreme_black_hole_tank" | "minecraft:diamond_from_smelting_diamond_ore" | "opolisutilities:floating_block_item" | "caveopolis:black_colored_stone_pressure_plate_from_black_colored_stone_stonecutting" | "thermal:compat/create/pulverizer_create_veridium" | "industrialforegoingsouls:soul_laser_base" | "thermal:augments/area_radius_augment" | "thermal:compat/mysticalagriculture/insolator_mysticalag_amethyst_bronze_seeds" | "mysticalagriculture:soul_extractor" | "minecraft:shield_decoration" | "minecraft:deepslate_tile_wall_from_cobbled_deepslate_stonecutting" | "caveopolis:sprayer/colored_stone_wall/magenta_colored_stone_wall" | "thermal:mycelium_crafting" | "caveopolis:sprayer/colored_signs/brown" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/light_gray_colored_stone_brick_stairs" | "thermal:lightning_charge/witch_from_villager" | "strainers:sponge_from_straining_yellow_wool_in_strainers_purified_water_fluid" | "farmersdelight:cooking/hot_cocoa" | "mysticalagriculture:seed/reprocessor/sulfur" | "thermal:ender_tnt_minecart" | "thermal_extra:compat/advgenerators/sunflower_oil" | "minecraft:birch_planks" | "minecraft:polished_deepslate_slab_from_cobbled_deepslate_stonecutting" | "mysticalagriculture:seed/crafting/graphite" | "mysticalagriculture:enchanter/soul_speed" | "mysticalagriculture:essence/minecraft/blackstone" | "caveopolis:marble_brick_stairs" | "caveopolis:sprayer/glazed_terracotta/black" | "minecraft:light_gray_stained_glass_pane" | "caveopolis:sprayer/colored_logs/light_blue" | "caveopolis:light_blue_spray_can" | "mysticalagriculture:seed/infusion/emerald" | "alltheores:mek_processing/nickel/shard/from_raw_block" | "systeams:boilers/lapidary" | "mysticalagriculture:gear/inferium_crossbow" | "thermal:compat/mekanism/press_mek_osmium_nugget_unpacking" | "alltheores:invar_gear" | "aquamirae:poisoned_blade" | "alltheores:steel_ingot_from_dust" | "thermal:basalz_powder" | "mysticalagriculture:seed/crafting/nether_quartz" | "mysticalagriculture:souls/mutton" | "caveopolis:blue_colored_cobblestone_bricks" | "minecraft:dye_magenta_carpet" | "duckling:cooked_duck_from_smoking" | "caveopolis:sprayer/colored_stone_brick_stairs/lime_colored_stone_brick_stairs" | "thermal:compat/mysticalagriculture/insolator_mysticalag_honey_seeds" | "sophisticatedbackpacks:xp_pump_upgrade" | "alltheores:mek_processing/iridium/dust/from_dirty_dust" | "caveopolis:sprayer/stripped_colored_logs/brown" | "mysticalagradditions:tconstruct/casting/soulium/nugget_sand_cast" | "minecraft:weathered_cut_copper_stairs_from_weathered_cut_copper_stonecutting" | "thermal:machines/press/packing3x3/press_enderium_packing" | "caveopolis:sprayer/colored_cobblestone_wall/cyan_colored_stone_wall" | "farmersdelight:cooking/noodle_soup" | "thermal:phytogro_8" | "minecraft:waxed_weathered_cut_copper_stairs_from_waxed_weathered_copper_stonecutting" | "thermal:phytogro_2" | "alltheores:tin_ingot_from_block" | "thermal:phytogro_4" | "sophisticatedbackpacks:tank_upgrade" | "caveopolis:sprayer/refill/yellow" | "caveopolis:cyan_colored_stone_stairs" | "minecraft:brown_bed" | "caveopolis:orange_colored_cobblestone_brick_slab_from_orange_colored_cobblestone_bricks_stonecutting" | "lfpirates:sailor_gray_tier_1_boots_recipe_1" | "thermal:device_composter" | "alltheores:sapphire_dust_from_hammer_crushing" | "thermal:devices/fisher/fisher_boost_deep_aquachow" | "thermal:lumium_activator_rail" | "alltheores:iridium_dust_from_hammer_crushing" | "opolisutilities:resource_generator_2/speed_blocks/bronze" | "strainers:cobblestone" | "mysticalagriculture:essence/minecraft/lapis_lazuli" | "mysticalagriculture:seed/infusion/energetic_alloy" | "strainers:snowball_from_straining_water_bucket_in_minecraft_ice" | "caveopolis:sprayer/terracotta/magenta" | "caveopolis:sprayer/colored_cobblestone_wall/magenta_colored_stone_wall" | "caveopolis:cyan_colored_wooden_plank_door_from_cyan_colored_wooden_planks_stonecutting" | "caveopolis:blue_colored_stone_button" | "thermal:compat/quark/insolator_quark_lavender_blossom_sapling" | "thermal:compat/mysticalagriculture/insolator_mysticalag_basalz_seeds" | "mysticalagradditions:tconstruct/melting/prudentium/ingot" | "thermal:machines/press/unpacking/press_gold_nugget_unpacking" | "lfpirates:sailor_nordic_tier_2_boots_recipe_1" | "thermal:machines/pulverizer/pulverizer_electrum_ingot_to_dust" | "thermal:machines/insolator/insolator_flowering_azalea_bush" | "industrialforegoing:laser_drill_ore/redstone" | "caveopolis:orange_colored_stone" | "mysticalagriculture:seed/reprocessor/niotic_crystal" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/white" | "minecraft:jack_o_lantern" | "thermal:compat/immersiveengineering/press_ie_uranium_unpacking" | "opolisutilities:drying_table/sponge" | "industrialforegoing:mob_detector" | "minecraft:tripwire_hook" | "mysticalagriculture:augment/luck_i" | "minecraft:cut_sandstone_from_sandstone_stonecutting" | "thermal:compat/tconstruct/smelter_alloy_tconstruct_manyullyn_ingot" | "alltheores:brass_ingot_from_dust_blasting" | "supplementaries:flags/flag_lime" | "strainers:lapis_lazuli_from_straining_andesite_in_minecraft_water" | "igleelib:lavium_block" | "caveopolis:white_colored_stone_crafting_table" | "caveopolis:orange_colored_stone_brick_wall_from_orange_colored_stone_bricks_stonecutting" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/light_blue" | "caveopolis:sprayer/remove_color/stone_brick_slabs" | "farmersdelight:cutting/tag_dough" | "opolisutilities:resource_generator/mods/caveopolis/lime_colored_stone" | "mysticalagriculture:essence/common/invar_ingot" | "thermal:storage/rich_slag_from_block" | "systeams:boilers/upgrades/gourmand_downgrade" | "mysticalagriculture:essence/minecraft/tube_coral" | "thermal_extra:storage/dragonsteel_ingot_from_nuggets" | "mysticalagriculture:essence/tconstruct/hepatizon_ingot" | "thermal:machines/press/packing3x3/press_charcoal_packing" | "mysticalagriculture:tertium_gemstone" | "mysticalagriculture:essence/minecraft/music_disc_ward" | "thermal:storage/netherite_nugget_from_ingot" | "thermal:machines/press/packing3x3/press_coal_coke_packing" | "thermal:machines/smelter/smelter_gold_armor" | "mysticalagriculture:seed/reprocessor/manasteel" | "caveopolis:sprayer/colored_stone_bricks/light_blue_colored_stone_bricks" | "mysticalagriculture:seed/infusion/copper_alloy" | "mysticalagriculture:seed/infusion/uraninite" | "cozy_home:counter_dark_oak_recipe" | "lfpirates:merchant_3_boots_recipe_1" | "thermal:compat/mysticalagriculture/insolator_mysticalag_graphite_seeds" | "caveopolis:sprayer/colored_stone_stairs/light_gray_colored_stone_stairs" | "mysticalagriculture:seed/crafting/energized_steel" | "thermal:fuels/gourmand/gourmand_spinach_block" | "caveopolis:light_gray_colored_stone_pressure_plate" | "minecraft:waxed_weathered_cut_copper_from_honeycomb" | "sophisticatedbackpacks:auto_smelting_upgrade" | "oceansdelight:food/elder_guardian_roll" | "mysticalagriculture:gear/inferium_watering_can" | "caveopolis:yellow_colored_stone_brick_stairs_from_yellow_colored_stone_bricks_stonecutting" | "thermal:compat/mekanism/pulverizer_mek_osmium_ore" | "mysticalagriculture:essence/minecraft/netherite_ingot" | "alltheores:mek_processing/nickel/clump/from_shard" | "lfpirates:sailor_gray_tier_3_boots_recipe_1" | "thermal:machines/smelter/smelter_constantan_dust" | "caveopolis:red_colored_stone_bricks_from_red_colored_stone_stonecutting" | "caveopolis:sprayer/colored_stone_brick_wall/white_colored_stone_brick_wall" | "storagedrawers:spruce_trim" | "mysticalagriculture:essence/appliedenergistics2/logic_press" | "minecraft:turtle_helmet" | "mysticalagriculture:stonecutting/soulstone_cobble_stairs_from_soulstone_cobble" | "thermal:storage/radish_from_block" | "farmersdelight:cutting/mutton" | "caveopolis:sprayer/stripped_colored_logs/orange" | "caveopolis:sprayer/colored_cobblestone_bricks/white_colored_stone_bricks" | "caveopolis:purple_colored_stone_brick_slab" | "caveopolis:sprayer/colored_stone_brick_slab/gray_colored_stone_brick_slab" | "caveopolis:sprayer/concrete/light_blue" | "opolisutilities:copper_ingot_from_nuggets" | "thermal:machines/press/unpacking/press_tin_unpacking" | "mysticalagriculture:essence/minecraft/gravel" | "thermal:machines/press/packing2x2/press_rubber_packing" | "thermal:fire_charge/obsidian_glass_2" | "thermal:machines/centrifuge/centrifuge_magenta_wool" | "caveopolis:sprayer/colored_cobblestone_brick_wall/yellow_colored_stone_brick_wall" | "chipped:benches/loom_table" | "mysticalagriculture:seed/infusion/nether_star" | "alltheores:mek_processing/nickel/dust/from_dirty_dust" | "alltheores:iron_ingot_from_dust" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/purple" | "minecraft:waxed_oxidized_cut_copper_slab" | "alltheores:mek_processing/aluminum/ore/from_dust" | "mysticalagriculture:essence/appliedenergistics2/certus_quartz" | "matc:prudentium_essence" | "caveopolis:light_blue_colored_stone_brick_stairs_from_light_blue_colored_stone_bricks_stonecutting" | "supplementaries:stonecutting/checker_slab" | "mysticalagriculture:enchanter/depth_strider" | "minecraft:dropper" | "farmersdelight:onion" | "supplementaries:soap/dirty_shard" | "alltheores:bronze_gear" | "alltheores:mek_processing/zinc/shard/from_raw_block" | "smallships:birch_drakkar" | "thermal:machines/bottler/bottler_red_concrete" | "tmttd:cutting/cheese_wedge" | "farmersdelight:cooking/stuffed_pumpkin_block" | "minecraft:lime_dye_from_smelting" | "thermal:compat/create/smelter_create_zinc_ore" | "mysticalagriculture:essence/minecraft/mud" | "thermal:machines/insolator/insolator_radish" | "suppsquared:candle_holders/gold_candle_holder_yellow" | "lfpirates:sailor_blue_tier_1_boots_recipe_1" | "minecraft:weathered_cut_copper_stairs" | "strainers:snort_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "thermal:machines/smelter/smelter_invar_plate_to_ingot" | "alltheores:iridium_nugget_from_ingot" | "caveopolis:lime_colored_wood" | "thermal:storage/raw_silver_from_block" | "farmersdelight:cutting/spruce_door" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/cyan_colored_stone_brick_stairs" | "caveopolis:sprayer/colored_signs/cyan" | "caveopolis:cyan_colored_cobblestone_wall" | "mysticalagriculture:prosperity_gemstone_block_uncraft" | "thermal:storage/carrot_from_block" | "strainers:stone_pebble_from_straining_dirt_in_minecraft_water" | "alltheores:tin_nugget_from_ingot" | "thermal:rockwool/light_blue_rockwool_from_dye" | "caveopolis:light_gray_colored_hanging_sign_from_stripped_light_gray_colored_log_stonecutting" | "thermal:parts/lead_gear" | "thermal:compat/mysticalagriculture/insolator_mysticalag_starmetal_seeds" | "strainers:nether_wart_from_straining_netherrack_in_strainers_eroding_water_fluid" | "farmersdelight:cooking/mushroom_stew" | "minecraft:pink_bed" | "minecraft:shield" | "caveopolis:sprayer/colored_cobblestone_wall/light_gray_colored_stone_wall" | "minecraft:blackstone_slab" | "minecraft:dye_light_blue_carpet" | "caveopolis:blue_colored_wooden_plank_fence_gate" | "minecraft:waxed_exposed_cut_copper_slab_from_waxed_exposed_copper_stonecutting" | "thermal:compat/create/smelter_create_alloy_brass" | "opolisutilities:block_placer" | "caveopolis:orange_colored_stone_button_from_orange_colored_stone_stonecutting" | "minecraft:cooked_rabbit_from_smoking" | "mysticalagriculture:essence/gems/ruby" | "framedcompactdrawers:framed_compact_drawer" | "cozy_home:drawer_jungle_recipe" | "minecraft:quartz_bricks" | "aquamirae:abyssal_leggings" | "minecraft:map_cloning" | "industrialforegoing:stasis_chamber" | "caveopolis:lime_colored_stone_pressure_plate_from_lime_colored_stone_stonecutting" | "thermal:machines/press/packing/press_rose_gold_packing" | "caveopolis:red_colored_cobblestone_brick_slab_from_red_colored_cobblestone_bricks_stonecutting" | "minecraft:red_sandstone_wall" | "storagedrawers:jungle_half_drawers_1" | "storagedrawers:jungle_half_drawers_4" | "thermal:drill_head" | "mysticalagriculture:seed_reprocessor" | "storagedrawers:jungle_half_drawers_2" | "supplementaries:candle_holders/candle_holder_blue_dye" | "strainers:summoning_block" | "minecraft:acacia_stairs" | "farmersdelight:cutting/bamboo_door" | "industrialforegoing:fluid_extractor/jungle" | "minecraft:iron_nugget_from_smelting" | "minecraft:raw_gold_block" | "mysticalagriculture:supremium_farmland" | "minecraft:birch_door" | "thermal:phytosoil" | "mysticalagriculture:soulium_spawner/rabbit" | "caveopolis:sprayer/colored_cobblestone_stairs/white_colored_stone_stairs" | "thermal:machines/press/press_frost_melon_packing" | "thermal:compat/quark/sawmill_quark_blossom_logs" | "thermal:machines/press/press_coffee_packing" | "mysticalagradditions:tconstruct/tools/materials/inferium/nugget" | "thermal:compat/create/smelter_create_crushed_raw_nickel" | "farmersdelight:white_hanging_canvas_sign" | "mysticalagriculture:essence/minecraft/music_disc_wait" | "alltheores:peridot_dust_from_hammer_crushing" | "caveopolis:red_colored_wooden_plank_button_from_red_colored_wooden_planks_stonecutting" | "caveopolis:blue_colored_stone" | "alltheores:enderium_block" | "cozy_home:spruce_fireplace_recipe" | "itemfilters:xor" | "minecraft:chiseled_polished_blackstone_from_polished_blackstone_stonecutting" | "tmttd:cooking/hearty_stew_2" | "thermal:machines/smelter/smelter_gold_ore" | "mysticalagradditions:tconstruct/casting/tertium/block" | "smallships:birch_cog" | "mysticalagriculture:augment/luck_iii" | "sophisticatedbackpacks:pickup_upgrade" | "caveopolis:sprayer/colored_stone_slab/yellow_colored_stone_slab" | "thermal:storage/steel_nugget_from_ingot" | "thermal:machines/press/press_nickel_ingot_to_plate" | "minecraft:birch_fence_gate" | "cozy_home:lamp_light_blue_recipe" | "minecraft:bone_meal" | "mysticalagriculture:essence/powah/niotic_crystal" | "mysticalagriculture:augment/health_boost_iii" | "minecraft:gold_ingot_from_blasting_nether_gold_ore" | "thermal:storage/hops_from_block" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/magenta" | "libraryferret:crafting_shaped/fake_emerald_block" | "suppsquared:copper_lantern_2" | "alltheores:nickel_dust_from_hammer_ingot_crushing" | "caveopolis:sprayer/terracotta/cyan" | "sophisticatedbackpacks:auto_smoking_upgrade" | "strainers:diorite_from_straining_barrier_in_strainers_purified_water_fluid" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/white_colored_stone_brick_stairs" | "caveopolis:sprayer/colored_wooden_plank_slab/pink" | "caveopolis:cyan_colored_cobblestone_wall_from_cyan_colored_cobblestone_stonecutting" | "glassential:glass_dark_ethereal_from_reverse" | "thermal:press_packing_3x3_die" | "mysticalagriculture:seed/reprocessor/steel" | "minecraft:mud_brick_wall" | "thermal:ice_tnt_minecart" | "caveopolis:pink_colored_wooden_plank_trapdoor_from_pink_colored_wooden_planks_stonecutting" | "strainers:meshes/gold" | "mysticalagradditions:tconstruct/casting/supremium/ingot_sand_cast" | "minecraft:prismarine_wall_from_prismarine_stonecutting" | "alltheores:mek_processing/iridium/dust/from_ingot" | "caveopolis:sprayer/colored_stone_brick_wall/gray_colored_stone_brick_wall" | "farmersdelight:integration/create/milling/wild_cabbages" | "thermal:compat/create/centrifuge_create_crushed_raw_lead" | "alltheores:tools_materials/nickel/nickel_from_ingot" | "caveopolis:sprayer/concrete/pink" | "minecraft:redstone_block" | "thermal:storage/silver_ingot_from_block" | "supplementaries:flags/flag_blue" | "caveopolis:sprayer/colored_cobblestone_slab/white_colored_stone_slab" | "minecraft:honeycomb_block" | "thermal:fuels/gourmand/gourmand_potato_block" | "mysticalagriculture:essence/minecraft/basalt" | "caveopolis:magenta_colored_stone_stairs_from_magenta_colored_stone_stonecutting" | "caveopolis:yellow_colored_wood" | "caveopolis:sprayer/colored_wooden_plank_slab/white" | "mysticalagradditions:nitro_crystal_crux" | "lfpirates:pirate_tier_1_leggins_recipe_1" | "caveopolis:cyan_colored_wooden_plank_button" | "lfpirates:sailor_blue_tier_3_boots_recipe_1" | "alltheores:aluminum_ingot_from_raw_blasting" | "thermal:machines/press/unpacking/press_sugar_cane_unpacking" | "opolisutilities:resource_generator_2/speed_blocks/iron" | "minecraft:andesite_stairs_from_andesite_stonecutting" | "farmersdelight:cake_from_milk_bottle" | "thermal:energy_cell" | "industrialforegoing:plastic" | "caveopolis:sprayer/colored_stone_bricks/yellow_colored_stone_bricks" | "thermal:compat/tconstruct/press_tconstruct_pig_iron_nugget_packing" | "thermal:storage/raw_lead_from_block" | "minecraft:dye_pink_bed" | "alltheores:mek_processing/aluminum/shard/from_raw_block" | "thermal_extra:augments/potion_duration_augment_1" | "caveopolis:orange_colored_stone_bricks" | "caveopolis:sprayer/colored_cobblestone_bricks/purple_colored_stone_bricks" | "caveopolis:black_colored_stone_slab_from_black_colored_stone_stonecutting" | "farmersdelight:wheat_dough_from_water" | "mysticalagriculture:essence/astralsorcery/aquamarine" | "thermal:lumium_rail" | "minecraft:waxed_weathered_cut_copper_slab_from_waxed_weathered_cut_copper_stonecutting" | "industrialforegoing:laser_lens_blue_recolor" | "mysticalagriculture:seed/infusion/ruby" | "caveopolis:lime_colored_stone_brick_slab_from_lime_colored_stone_bricks_stonecutting" | "cozy_home:drawer_cherry_recipe" | "caveopolis:sprayer/refill/white" | "thermal_extra:augments/potion_duration_augment_5" | "thermal_extra:augments/potion_duration_augment_4" | "thermal_extra:augments/potion_duration_augment_3" | "thermal_extra:augments/potion_duration_augment_2" | "thermal:machines/press/press_copper_ingot_to_gear" | "alltheores:platinum_ingot" | "framedcompactdrawers:framed_full_four" | "industrialforegoing:dissolution_chamber" | "mysticalagriculture:enchanter/mending" | "thermal:machines/insolator/insolator_horn_coral" | "alltheores:steel_ingot_from_dust_blasting" | "thermal:fire_tnt" | "thermal:machines/centrifuge/centrifuge_redstone_mushroom_spores" | "minecraft:dye_cyan_carpet" | "mysticalagriculture:seed/infusion/tin" | "alltheores:mek_processing/silver/shard/from_crystal" | "thermal:machines/sawmill/sawmill_acacia_logs" | "mysticalagriculture:gear/tertium_crossbow" | "alltheores:platinum_ore_hammer" | "caveopolis:sprayer/glass_pane/yellow" | "mysticalagriculture:stonecutting/soulstone_chiseled_bricks_from_soulstone_bricks" | "aquamirae:abyssal_boots" | "strainers:burn_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "caveopolis:pink_colored_stone_wall" | "minecraft:oxidized_cut_copper_stairs" | "caveopolis:lime_colored_cobblestone_brick_wall" | "minecraft:mangrove_trapdoor" | "cozy_home:spruce_m_irror_stand_recipe" | "thermal:storage/bronze_ingot_from_block" | "minecraft:diamond_boots" | "mysticalagradditions:insanium_ingot_block" | "caveopolis:sprayer/glass_block/purple" | "sophisticatedbackpacks:stack_upgrade_tier_4" | "minecraft:mangrove_hanging_sign" | "thermal:machines/insolator/insolator_birch_sapling" | "minecraft:stick" | "thermal:explosive_grenade_4" | "caveopolis:sprayer/colored_stone_brick_slab/brown_colored_stone_brick_slab" | "thermal:machines/crucible/crucible_redstone_dust" | "thermal:smelting/nickel_ingot_from_ore_smelting" | "farmersdelight:cooking/glow_berry_custard" | "mysticalagriculture:augment/attack_aoe_iii" | "minecraft:emerald_from_blasting_emerald_ore" | "alltheores:platinum_nugget_from_ingot" | "thermal:gray_concrete_powder_with_slag" | "caveopolis:light_gray_colored_stone_slab" | "minecraft:polished_blackstone_brick_wall" | "thermal:machines/chiller/chiller_redstone_to_redstone_block" | "thermal:machines/press/press_netherite_ingot_to_coin" | "thermal:compat/tconstruct/chiller_tconstruct_queens_slime_ingot" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/cyan" | "thermal:storage/steel_ingot_from_nuggets" | "cozy_home:table_dark_oak_recipe" | "caveopolis:orange_colored_hanging_sign_from_stripped_orange_colored_log_stonecutting" | "caveopolis:brown_colored_stone" | "systeams:steam_dynamo/steam_energy" | "minecraft:dried_kelp_from_campfire_cooking" | "mysticalagriculture:enchanter/knockback" | "thermal:machines/smelter/smelter_raw_gold" | "alltheores:uranium_nugget_from_ingot" | "thermal:machines/insolator/insolator_twisting_vines" | "thermal:compat/create/press_create_raw_zinc_packing" | "caveopolis:sprayer/colored_stone_crafting_table/light_blue" | "alltheores:nickel_ingot_from_slate_ore" | "caveopolis:sprayer/colored_wooden_plank_fence/lime" | "caveopolis:sprayer/colored_cobblestone_stairs/gray_colored_stone_stairs" | "thermal:compat/tconstruct/insolator_tconstruct_blood_slime_sapling" | "strainers:small_dripleaf_from_straining_barrier_in_strainers_eroding_water_fluid" | "caveopolis:sprayer/colored_wooden_planks/red" | "minecraft:waxed_oxidized_cut_copper_stairs_from_waxed_oxidized_copper_stonecutting" | "alltheores:steel_rod" | "sophisticatedbackpacks:stack_upgrade_tier_2" | "sophisticatedbackpacks:stack_upgrade_tier_3" | "farmersdelight:cutting/chocolate_pie" | "caveopolis:sprayer/colored_cobblestone_brick_wall/pink_colored_stone_brick_wall" | "alltheores:mek_processing/silver/dirty_dust/from_clump" | "sophisticatedbackpacks:stack_upgrade_tier_1" | "thermal:blizz_powder" | "opolisutilities:resource_generator_2/speed_blocks/blutonium" | "mysticalagriculture:essence/thermal/lumium_ingot" | "cozy_home:counter_spruce_recipe" | "farmersdelight:green_hanging_canvas_sign" | "alltheores:mek_processing/nickel/slurry/dirty/from_raw_block" | "mysticalagriculture:seed/reprocessor/copper" | "thermal:machines/pulverizer/pulverizer_diamond_ore" | "mysticalagriculture:essence/create/ochrum" | "farmersdelight:horse_feed" | "caveopolis:sprayer/colored_stone_bricks/magenta_colored_stone_bricks" | "cozy_home:mangrove_bench_recipe" | "thermal:compat/biomesoplenty/insolator_bop_pink_cherry_sapling" | "caveopolis:brown_colored_cobblestone_bricks" | "thermal:rubberwood_pressure_plate" | "caveopolis:sprayer/refill/green" | "caveopolis:green_colored_wooden_plank_button_from_green_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/glazed_terracotta/white" | "thermal:storage/tomato_block" | "thermal:compat/biomesoplenty/insolator_bop_palm_sapling" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/black" | "minecraft:brown_stained_glass_pane" | "caveopolis:lime_colored_wooden_plank_fence_gate" | "minecraft:black_terracotta" | "mysticalagriculture:essence/integrateddynamics/menril_berries" | "alltheores:platinum_ingot_from_raw" | "alltheores:raw_tin_block" | "farmersdelight:cutting/pink_tulip" | "strainers:blue_orchid_from_straining_grass_in_strainers_purified_water_fluid" | "industrialforegoing:laser_lens_green_recolor" | "caveopolis:sprayer/colored_cobblestone/cyan_colored_stone" | "industrialforegoing:dissolution_chamber/mechanical_dirt" | "minecraft:white_bed" | "thermal:compat/tconstruct/press_tconstruct_manyullyn_unpacking" | "mysticalagriculture:essence/create/crimsite" | "minecraft:spruce_slab" | "supplementaries:bubble_blower_charge" | "caveopolis:light_blue_colored_wooden_plank_door" | "alltheores:tin_ingot_from_slate_ore_blasting" | "mysticalagriculture:essence/minecraft/white_wool" | "caveopolis:sprayer/colored_stone_wall/orange_colored_stone_wall" | "minecraft:cobblestone_slab_from_cobblestone_stonecutting" | "minecraft:mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting" | "mysticalagriculture:seed/crafting/spider" | "minecraft:yellow_carpet" | "thermal_extra:shellite_dust" | "lfpirates:merchant_1_helmet_recipe_1" | "caveopolis:sprayer/colored_stone/pink_colored_stone" | "lfpirates:poison_bone_cutlass_recipe_1" | "minecraft:pumpkin_pie" | "thermal:machines/press/press_silver_ingot_to_gear" | "mysticalagriculture:seed/crafting/pig_iron" | "mysticalagriculture:augment/absorption_iii" | "thermal:compat/immersiveengineering/press_ie_uranium_packing" | "thermal:earth_tnt" | "thermal:machines/bottler/bottler_blue_concrete" | "caveopolis:light_blue_colored_cobblestone" | "minecraft:deepslate_brick_slab_from_deepslate_bricks_stonecutting" | "thermal:fuels/numismatic/numismatic_lumium_coin" | "caveopolis:mixed_stone_ingot_from_blasting_deepslate_mixed_stone_ore" | "supplementaries:soap/piston" | "minecraft:polished_granite" | "mysticalagriculture:seed/infusion/cow" | "thermal:machines/bottler/bottler_experience_bottle" | "thermal:machines/smelter/smelter_raw_nickel" | "sophisticatedbackpacks:chipped/tinkering_table_upgrade" | "thermal:machines/sawmill/sawmill_birch_logs" | "alltheores:mek_processing/nickel/dust/from_raw_block" | "minecraft:soul_campfire" | "caveopolis:brown_colored_hanging_sign" | "mysticalagriculture:seed/reprocessor/chrome" | "mysticalagriculture:supremium_furnace" | "alltheores:platinum_ingot_from_ore_blasting" | "supplementaries:candle_holders/candle_holder_light_gray_dye" | "minecraft:gold_ingot_from_smelting_nether_gold_ore" | "thermal:machines/insolator/insolator_weeping_vines" | "matc:supremium_essence" | "alltheores:zinc_plate" | "farmersdelight:cutting/acacia_wood" | "caveopolis:white_colored_wooden_plank_button_from_white_colored_wooden_planks_stonecutting" | "mysticalagriculture:enchanter/luck_of_the_sea" | "industrialforegoing:block_placer" | "cozy_home:counter_dark_oak_storage_recipe" | "mysticalagriculture:seed/infusion/wither_skeleton" | "farmersdelight:cooking/beef_stew" | "mysticalagriculture:essence/minecraft/clay_ball" | "thermal_extra:machine/press/twinite_coin" | "thermal:compat/biomesoplenty/tree_extractor_bop_maple" | "cozy_home:dark_oak_chair_recipe" | "supplementaries:slice_map" | "mysticalagriculture:enchanter/flame" | "thermal:machines/press/unpacking/press_signalum_nugget_unpacking" | "industrialforegoing:dissolution_chamber/laser_lens15" | "smallships:cannon_ball" | "industrialforegoing:dissolution_chamber/laser_lens13" | "industrialforegoing:dissolution_chamber/laser_lens14" | "industrialforegoing:dissolution_chamber/laser_lens11" | "mysticalagriculture:enchanter/infinity" | "industrialforegoing:dissolution_chamber/laser_lens12" | "caveopolis:sprayer/colored_cobblestone_wall/red_colored_stone_wall" | "alltheores:aluminum_dust_from_hammer_ingot_crushing" | "caveopolis:cyan_colored_cobblestone_bricks_from_cyan_colored_cobblestone_stonecutting" | "industrialforegoing:dissolution_chamber/laser_lens10" | "caveopolis:orange_colored_wooden_plank_fence" | "thermal:machines/press/packing3x3/press_potato_packing" | "alltheores:invar_plate" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/pink" | "thermal:compat/quark/press_quark_stick_unpacking" | "thermal:compat/biomesoplenty/sawmill_bop_fir_logs" | "minecraft:crimson_fence_gate" | "caveopolis:green_colored_wooden_plank_fence_gate" | "caveopolis:sprayer/candles/magenta" | "thermal:flux_magnet" | "alltheores:steel_gear" | "caveopolis:pink_colored_stone_stairs_from_pink_colored_stone_stonecutting" | "caveopolis:marble_brick_wall_from_marble_bricks_stonecutting" | "caveopolis:sprayer/colored_stone_brick_slab/magenta_colored_stone_brick_slab" | "strainers:summoning_block/glow_squid" | "mysticalagriculture:imperium_farmland" | "alltheores:osmium_nugget_from_ingot" | "caveopolis:green_colored_cobblestone_brick_stairs_from_green_colored_cobblestone_bricks_stonecutting" | "supplementaries:cozy_home/sign_post_dark_oak" | "thermal:servo_attachment_2" | "minecraft:lapis_lazuli_from_blasting_lapis_ore" | "caveopolis:blue_colored_wooden_plank_pressure_plate" | "thermal:compat/create/pulverizer_create_raw_zinc" | "minecraft:rib_armor_trim_smithing_template" | "thermal:compat/tconstruct_ie/chiller_tconstruct_ie_steel_rod" | "caveopolis:gray_colored_stone_brick_wall_from_gray_colored_stone_bricks_stonecutting" | "dankstorage:6_to_7" | "minecraft:cooked_chicken_from_campfire_cooking" | "caveopolis:magenta_colored_wooden_plank_trapdoor" | "lfpirates:iron_cutlass_recipe_1" | "mysticalagriculture:gear/inferium_sword" | "thermal:machines/sawmill/sawmill_melon" | "caveopolis:yellow_colored_stone_brick_slab_from_yellow_colored_stone_bricks_stonecutting" | "caveopolis:sprayer/colored_stone_buttons/white" | "caveopolis:brown_colored_wooden_plank_trapdoor_from_brown_colored_wooden_planks_stonecutting" | "glassential:dark_ethereal_reverse_door" | "minecraft:quartz_pillar_from_quartz_block_stonecutting" | "mysticalagriculture:seed/crafting/end" | "thermal:smelting/silver_ingot_from_raw_blasting" | "aquaculture:neptunium_leggings" | "itemfilters:or" | "mysticalagriculture:seed/reprocessor/draconium" | "industrialforegoing:animal_rancher" | "caveopolis:sprayer/colored_cobblestone_stairs/light_gray_colored_stone_stairs" | "cozy_home:acacia_wall_clock_recipe" | "thermal:fluid_reservoir" | "strainers:iron_nugget_from_straining_gravel_in_minecraft_water" | "minecraft:deepslate_tiles_from_cobbled_deepslate_stonecutting" | "farmersdelight:cutting/dandelion" | "caveopolis:white_colored_stone_brick_wall" | "minecraft:mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting" | "minecraft:observer" | "thermal:fuels/numismatic/numismatic_silver_coin" | "caveopolis:lime_colored_stone_brick_slab" | "minecraft:polished_deepslate_wall" | "minecraft:cooked_cod_from_campfire_cooking" | "caveopolis:light_blue_colored_sign" | "caveopolis:brown_colored_hanging_sign_from_stripped_brown_colored_log_stonecutting" | "itemfilters:id_regex" | "thermal:fuels/compression/compression_tree_oil" | "thermal:flux_drill" | "thermal:peanut_butter" | "caveopolis:red_colored_stone_wall_from_red_colored_stone_stonecutting" | "thermal:devices/tree_extractor/tree_extractor_birch" | "minecraft:dye_purple_bed" | "thermal_extra:twinite_glass" | "mysticalagriculture:prudentium_furnace" | "thermal:compat/immersiveengineering/compression_ip_diesel" | "thermal_extra:storage/twinite_nugget_from_ingot" | "minecraft:stripped_jungle_wood" | "thermal:machines/smelter/smelter_nickel_ore" | "minecraft:pink_dye_from_peony" | "caveopolis:sprayer/colored_cobblestone/purple_colored_stone" | "thermal:compat/mysticalagriculture/insolator_mysticalag_lapis_lazuli_seeds" | "mysticalagriculture:seed/infusion/sulfur" | "sophisticatedbackpacks:chipped/botanist_workbench_upgrade" | "supplementaries:speaker_block" | "minecraft:chiseled_red_sandstone_from_red_sandstone_stonecutting" | "thermal:compat/mysticalagriculture/insolator_mysticalag_refined_glowstone_seeds" | "thermal:storage/spinach_from_block" | "mysticalagriculture:seed/crafting/enderium" | "opolisutilities:soaking_table/soaked_paper" | "caveopolis:brown_colored_stone_brick_slab_from_brown_colored_stone_bricks_stonecutting" | "thermal:machines/press/packing3x3/press_lead_nugget_packing" | "thermal_extra:dragonsteel_dust" | "mysticalagriculture:essence/minecraft/stone" | "caveopolis:green_colored_cobblestone_brick_stairs" | "thermal:machines/press/packing3x3/press_apple_packing" | "alltheores:smelting_dust/lead_ingot" | "mysticalagriculture:essence/common/niter" | "alltheores:invar_ore_hammer" | "minecraft:chiseled_deepslate" | "caveopolis:sprayer/colored_stone_buttons/purple" | "mysticalagriculture:essence/minecraft/diorite" | "smallships:dark_oak_drakkar" | "supplementaries:bellows" | "thermal:machines/centrifuge/centrifuge_red_wool" | "minecraft:soul_torch" | "thermal:rubberwood_button" | "mysticalagriculture:seed/crafting/certus_quartz" | "mysticalagriculture:essence/minecraft/mutton" | "mysticalagriculture:souls/skeleton_skull" | "caveopolis:sprayer/colored_wooden_plank_stairs/purple" | "caveopolis:green_colored_cobblestone_brick_wall" | "cozy_home:counter_oak_sink_recipe" | "farmersdelight:rope_from_safety_net" | "alltheores:silver_dust_from_hammer_ingot_crushing" | "thermal:storage/corn_block" | "minecraft:warped_fence_gate" | "caveopolis:brown_colored_cobblestone_brick_wall" | "mysticalagriculture:seed/infusion/hepatizon" | "thermal:compat/mysticalagriculture/insolator_mysticalag_netherite_seeds" | "mysticalagriculture:enchanter/aqua_affinity" | "caveopolis:brown_colored_stone_button_from_brown_colored_stone_stonecutting" | "caveopolis:sprayer/colored_stone_slab/purple_colored_stone_slab" | "minecraft:weathered_cut_copper_from_weathered_copper_stonecutting" | "caveopolis:sprayer/colored_wooden_plank_button/lime" | "minecraft:gray_dye" | "thermal:machines/smelter/smelter_invar_dust" | "farmersdelight:cooked_mutton_chops_from_campfire_cooking" | "mysticalagriculture:gear/supremium_crossbow" | "thermal:compat/tconstruct/insolator_tconstruct_earth_slime_sapling" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/purple_colored_stone_brick_stairs" | "thermal:machines/centrifuge/centrifuge_cyan_wool" | "minecraft:coal_block" | "farmersdelight:orange_canvas_sign" | "cozy_home:counter_birch_recipe" | "minecraft:slime_ball" | "thermal:chocolate_cake" | "caveopolis:light_blue_colored_wooden_plank_fence_from_light_blue_colored_wooden_planks_stonecutting" | "alltheores:tools_materials/osmium/osmium_from_ingot" | "thermal:compat/biomesoplenty/insolator_bop_magic_sapling" | "thermal:machines/pulverizer/pulverizer_emerald_ore" | "caveopolis:brown_colored_wooden_plank_door" | "thermal:compat/biomesoplenty/insolator_bop_wildflower_flower" | "mysticalagriculture:seed/reprocessor/refined_obsidian" | "caveopolis:sprayer/colored_hanging_signs/gray" | "farmersdelight:cutting/dark_oak_wood" | "mysticalagriculture:prudentium_ingot_block_uncraft" | "thermal:compat/mysticalagriculture/insolator_mysticalag_rose_gold_seeds" | "thermal:compat/tconstruct/press_tconstruct_pig_iron_nugget_unpacking" | "industrialforegoing:laser_drill_ore/raw_materials/aluminum" | "thermal:machines/insolator/insolator_rose_bush" | "thermal:compat/redstone_arsenal/press_rsa_flux_gem_unpacking" | "minecraft:emerald_block" | "caveopolis:sprayer/colored_leaves/cyan" | "opolisutilities:catalogue/selling/caveopolis/blue_spray_can" | "caveopolis:sprayer/stripped_colored_logs/cyan" | "strainers:skull_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "strainers:brain_coral_from_straining_barrier_in_minecraft_water" | "farmersdelight:cooking/cooked_rice" | "minecraft:end_stone_brick_slab_from_end_stone_brick_stonecutting" | "alltheores:invar_ingot_from_block" | "minecraft:iron_sword" | "alltheores:constantan_ingot_from_block" | "caveopolis:black_colored_stone_wall" | "thermal:machines/pulverizer/pulverizer_nickel_plate_to_dust" | "mysticalagriculture:tertium_ingot" | "thermal:compat/biomesoplenty/insolator_bop_redwood_sapling" | "mysticalagriculture:seed/reprocessor/iron" | "thermal:machines/centrifuge/centrifuge_lime_rockwool" | "caveopolis:sprayer/colored_saplings/brown" | "thermal:compat/create/centrifuge_create_crushed_raw_nickel" | "mysticalagriculture:seed/reprocessor/flux_infused_ingot" | "strainers:summoning_block/parrot" | "opolisutilities:resource_generator/mods/caveopolis/cyan_colored_stone" | "minecraft:chiseled_sandstone_from_sandstone_stonecutting" | "caveopolis:mixed_stone_ingot_from_blasting_raw_mixed_stone" | "caveopolis:sprayer/colored_wooden_plank_door/light_blue" | "caveopolis:lime_colored_stone_wall_from_lime_colored_stone_stonecutting" | "thermal:compat/quark/press_quark_cocoa_beans_packing" | "mysticalagriculture:seed/reprocessor/nether_star" | "caveopolis:sprayer/banners/brown" | "farmersdelight:cutting/leather_helmet" | "caveopolis:purple_colored_wooden_plank_slab" | "minecraft:smooth_red_sandstone_slab" | "minecraft:cut_copper_stairs_from_cut_copper_stonecutting" | "thermal:machines/crystallizer/crystallizer_apatite" | "supplementaries:redstone_illuminator" | "minecraft:bamboo_pressure_plate" | "mysticalagriculture:enchanter/fortune" | "minecraft:birch_trapdoor" | "thermal:compat/biomesoplenty/tree_extractor_bop_orange_autumn" | "cozy_home:counter_quartz_sink_recipe" | "minecraft:prismarine_brick_stairs_from_prismarine_stonecutting" | "minecraft:deepslate_brick_wall_from_deepslate_bricks_stonecutting" | "mysticalagradditions:tconstruct/melting/inferium/ingot" | "mysticalagriculture:essence/minecraft/kelp" | "supplementaries:candle_holders/candle_holder_green_dye" | "thermal:machines/smelter/smelter_rose_gold_tools" | "oceansdelight:cooking/guardian_soup" | "caveopolis:light_blue_colored_stone_wall" | "supplementaries:planter_rich" | "strainers:copper_nugget_from_straining_gravel_in_minecraft_water" | "caveopolis:green_colored_wooden_plank_crafting_table" | "caveopolis:sprayer/colored_cobblestone_wall/white_colored_stone_wall" | "lfpirates:corsair_tier_2_boots_recipe_1" | "minecraft:conduit" | "cozy_home:table_crimson_recipe" | "minecraft:sticky_piston" | "caveopolis:sprayer/refill/brown" | "minecraft:blue_glazed_terracotta" | "thermal:parts/steel_gear" | "thermal:prismarine_powered_rail" | "thermal:compat/mysticalagriculture/insolator_mysticalag_ice_seeds" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/yellow" | "thermal:augments/machine_catalyst_augment" | "thermal:storage/corn_from_block" | "caveopolis:yellow_colored_stone_slab_from_yellow_colored_stone_stonecutting" | "minecraft:exposed_cut_copper_slab_from_exposed_copper_stonecutting" | "thermal:machines/pulverizer/pulverizer_blaze_rod" | "thermal:compat/create/press_create_zinc_nugget_packing" | "thermal:compat/tconstruct/smelter_alloy_tconstruct_hepatizon_ingot" | "caveopolis:sprayer/colored_wood/lime" | "thermal:earth_charge/quartz_from_quartz_block" | "caveopolis:sprayer/colored_logs/cyan" | "nec:caveop_lime_colored_wooden_chest" | "strainers:upgrades/improved/improved_mesh_upgrade" | "thermal:machines/smelter/smelter_coal_ore" | "caveopolis:sprayer/concrete/yellow" | "supplementaries:stonecutting/lapis_brick_stairs_from_bricks" | "caveopolis:blue_colored_stone_button_from_blue_colored_stone_stonecutting" | "smallships:spruce_galley" | "caveopolis:lime_colored_stone_brick_stairs_from_lime_colored_stone_bricks_stonecutting" | "minecraft:stripped_oak_wood" | "mysticalagradditions:tconstruct/casting/tertium/nugget_sand_cast" | "thermal:machines/press/unpacking/press_enderium_nugget_unpacking" | "caveopolis:red_colored_stone_slab_from_red_colored_stone_stonecutting" | "supplementaries:sign_post_bamboo" | "farmersdelight:beef_patty_from_smoking" | "suppsquared:candle_holders/gold_candle_holder_spectacle" | "caveopolis:light_blue_colored_cobblestone_brick_slab_from_light_blue_colored_cobblestone_bricks_stonecutting" | "minecraft:comparator" | "sophisticatedbackpacks:stack_upgrade_starter_tier" | "caveopolis:sprayer/glazed_terracotta/light_gray" | "thermal:machines/bottler/bottler_cyan_concrete" | "caveopolis:sprayer/colored_stone_stairs/gray_colored_stone_stairs" | "caveopolis:sprayer/colored_cobblestone_brick_wall/cyan_colored_stone_brick_wall" | "industrialforegoing:iron_gear" | "aquamirae:bone_meal_from_anglers_fang" | "thermal:compat/tconstruct/press_tconstruct_slimesteel_unpacking" | "ftbquests:loot_crate_opener" | "opolisutilities:resource_generator_2/speed_blocks/gold" | "caveopolis:sprayer/colored_cobblestone_brick_wall/white_colored_stone_brick_wall" | "strainers:meshes/leafy" | "cozy_home:lamp_lime_recipe" | "minecraft:granite_wall_from_granite_stonecutting" | "supplementaries:timber_frame" | "thermal:machines/press/unpacking/press_prismarine_unpacking" | "thermal:compat/create/bottler_create_glowstone" | "minecraft:cut_red_sandstone" | "mysticalagriculture:gear/prudentium_sword" | "mysticalagriculture:seed/infusion/uranium" | "framedcompactdrawers:framed_slave" | "mysticalagriculture:tertium_block_uncraft" | "minecraft:andesite_slab_from_andesite_stonecutting" | "mysticalagriculture:essence/minecraft/experience_droplet" | "caveopolis:light_gray_colored_wooden_plank_button" | "thermal:machines/smelter/smelter_alloy_signalum" | "caveopolis:sprayer/colored_wood/blue" | "farmersdelight:canvas_sign" | "thermal:storage/signalum_block" | "alltheores:osmium_ingot_from_slate_ore_blasting" | "mysticalagriculture:gear/inferium_helmet" | "thermal:smelting/invar_ingot_from_dust_smelting" | "industrialforegoing:laser_lens_lime_recolor" | "mysticalagriculture:gear/tertium_pickaxe" | "mysticalagriculture:augment/pathing_aoe_i" | "caveopolis:light_blue_colored_wooden_plank_trapdoor" | "minecraft:deepslate_brick_stairs_from_polished_deepslate_stonecutting" | "minecraft:bamboo_door" | "thermal:compat/mysticalagriculture/insolator_mysticalag_spider_seeds" | "caveopolis:green_colored_hanging_sign" | "thermal:compat/biomesoplenty/insolator_bop_yellow_autumn_sapling" | "caveopolis:sprayer/colored_hanging_signs/light_blue" | "glassential:glass_door" | "thermal:compat/mysticalagriculture/insolator_mysticalag_amethyst_seeds" | "farmersdelight:integration/create/milling/wild_onions" | "farmersdelight:oak_cabinet" | "opolisutilities:upgrades/test3" | "opolisutilities:upgrades/test2" | "farmersdelight:integration/immersiveengineering/crusher/wild_rice" | "minecraft:white_wool_from_string" | "minecraft:cobblestone_wall_from_cobblestone_stonecutting" | "minecraft:white_stained_glass_pane" | "thermal:compat/mysticalagriculture/insolator_mysticalag_spirited_crystal_seeds" | "thermal:compat/create/pulverizer_create_veridium_recycle" | "thermal:compat/tconstruct/smelter_alloy_tconstruct_amethyst_bronze_ingot" | "caveopolis:sprayer/colored_stone_bricks/black_colored_stone_bricks" | "mysticalagriculture:seed/crafting/nitro_crystal" | "thermal:compat/quark/press_quark_bonded_rabbit_hide_packing" | "caveopolis:purple_colored_cobblestone" | "minecraft:yellow_dye_from_sunflower" | "mysticalagriculture:essence/appliedenergistics2/fluix_dust" | "thermal:machines/crucible/crucible_magma_block_to_lava" | "thermal:compat/immersiveengineering/pulverizer_ie_aluminum_ore" | "mysticalagriculture:souls/feather" | "caveopolis:sprayer/colored_wooden_plank_button/orange" | "thermal:compat/tconstruct/smelter_alloy_tconstruct_rose_gold_ingot" | "minecraft:oak_slab" | "thermal:compat/tconstruct/press_tconstruct_queens_slime_nugget_packing" | "mysticalagriculture:awakened_supremium_ingot_uncraft" | "supplementaries:spiky_bomb_2" | "mysticalagradditions:insanium_coal_block_uncraft" | "cozy_home:grandfather_clock_spruce_recipe" | "mysticalagriculture:essence/minecraft/quartz" | "mysticalagriculture:essence/tconstruct/pig_iron_ingot" | "caveopolis:black_colored_stone" | "caveopolis:light_gray_colored_cobblestone_stairs_from_light_gray_colored_cobblestone_stonecutting" | "thermal:machines/press/unpacking/press_steel_unpacking" | "caveopolis:sprayer/colored_wooden_plank_slab/brown" | "caveopolis:white_colored_sign_from_white_colored_wooden_planks_stonecutting" | "minecraft:mangrove_sign" | "farmersdelight:cutting/wild_carrots" | "caveopolis:sprayer/colored_stone_brick_wall/light_blue_colored_stone_brick_wall" | "caveopolis:sprayer/colored_stone_crafting_table/pink" | "mysticalagriculture:essence/minecraft/beetroot" | "caveopolis:cyan_colored_stone_slab_from_cyan_colored_stone_stonecutting" | "mysticalagriculture:seed/crafting/refined_obsidian" | "supplementaries:flags/flag_white" | "supplementaries:blackstone_tile_stairs" | "caveopolis:sprayer/colored_stone_pressure_plate/purple" | "mysticalagradditions:tconstruct/melting/tertium/block" | "minecraft:dye_brown_carpet" | "minecraft:glass_pane" | "alltheores:lead_ingot_from_slate_ore_blasting" | "industrialforegoing:enchantment_factory" | "mysticalagriculture:prudentium_essence" | "caveopolis:cyan_colored_stone_brick_slab" | "farmersdelight:netherite_knife_smithing" | "caveopolis:sprayer/colored_wooden_plank_fence/black" | "minecraft:clay" | "mysticalagriculture:imperium_ingot_block" | "mysticalagriculture:seed/crafting/dye" | "mysticalagriculture:imperium_block" | "mysticalagriculture:gear/supremium_watering_can" | "farmersdelight:rice_panicle" | "strainers:mycelium_from_straining_grass_block_in_strainers_purified_water_fluid" | "strainers:archer_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "industrialforegoing:laser_drill_ore/raw_materials/ardite" | "industrialforegoing:mycelial_pink" | "mysticalagradditions:inferium_apple" | "thermal:machines/smelter/smelter_electrum_armor" | "farmersdelight:tatami" | "oceansdelight:cooking/squid_rings" | "alltheores:diamond_gear" | "caveopolis:light_blue_colored_stone_bricks_from_light_blue_colored_stone_stonecutting" | "caveopolis:green_colored_cobblestone_bricks" | "minecraft:oxidized_cut_copper_stairs_from_oxidized_cut_copper_stonecutting" | "thermal:cyan_dye_from_apatite" | "caveopolis:sprayer/colored_cobblestone_brick_wall/green_colored_stone_brick_wall" | "alltheores:lumium_plate" | "strainers:sand_from_straining_stone_in_strainers_eroding_water_fluid" | "aquaculture:diamond_fillet_knife" | "caveopolis:sprayer/colored_stone_slab/white_colored_stone_slab" | "tmttd:machines/press/egg_crate_press" | "suppsquared:candle_holders/gold_candle_holder_orange" | "mysticalagriculture:seed/crafting/compressed_iron" | "strainers:upgrade_stats/reinforced_mesh_upgrade" | "caveopolis:red_colored_sign_from_red_colored_wooden_planks_stonecutting" | "mysticalagriculture:seed/infusion/honey" | "thermal:compat/mysticalagriculture/insolator_mysticalag_blazing_crystal_seeds" | "thermal:machines/press/unpacking/press_raw_tin_unpacking" | "thermal:compat/mysticalagriculture/insolator_mysticalag_coal_seeds" | "minecraft:leather_boots" | "alltheores:raw_platinum_block" | "alltheores:mek_processing/platinum/dust/from_raw_block" | "farmersdelight:cutting/crimson_door" | "caveopolis:cyan_colored_stone_crafting_table" | "thermal:machines/press/packing3x3/press_signalum_nugget_packing" | "mysticalagriculture:seed/infusion/bronze" | "mysticalagriculture:essence/common/chrome_ingot" | "thermal:machines/press/press_green_bean_packing" | "mysticalagriculture:essence/minecraft/andesite" | "caveopolis:yellow_colored_stone_stairs" | "thermal:compat/mekanism/press_mek_refined_obsidian_nugget_packing" | "mysticalagriculture:seed/reprocessor/steeleaf" | "caveopolis:white_colored_wooden_plank_pressure_plate" | "supplementaries:thermal/sign_post_rubberwood" | "caveopolis:sprayer/remove_color/wooden_plank_trapdoors" | "nec:caveop_white_colored_wooden_chest" | "mysticalagriculture:essence/minecraft/cyan_concrete" | "thermal:compat/immersiveengineering/smelter_ie_uranium_dust" | "smallships:dark_oak_galley" | "caveopolis:red_colored_stone_stairs" | "caveopolis:light_blue_colored_cobblestone_slab" | "mysticalagriculture:seed/reprocessor/tungsten" | "caveopolis:yellow_colored_wooden_plank_door_from_yellow_colored_wooden_planks_stonecutting" | "thermal:storage/spinach_block" | "caveopolis:sprayer/colored_saplings/gray" | "thermal:compat/quark/insolator_quark_pink_blossom_sapling" | "cozy_home:cherry_wall_clock_recipe" | "suppsquared:copper_lantern" | "caveopolis:magenta_colored_cobblestone_brick_stairs_from_magenta_colored_cobblestone_bricks_stonecutting" | "minecraft:baked_potato_from_smoking" | "supplementaries:candle_holders/candle_holder_soul" | "alltheores:enderium_ingot_from_dust_blasting" | "thermal:machines/pulverizer/pulverizer_raw_iron" | "oceansdelight:cooking/honey_fried_kelp" | "minecraft:dye_black_carpet" | "thermal:fuels/numismatic/numismatic_gold_coin" | "cozy_home:birch_bench_recipe" | "mysticalagriculture:essence/minecraft/glowstone_dust" | "minecraft:polished_blackstone_brick_wall_from_blackstone_stonecutting" | "farmersdelight:cutting/red_mushroom_colony" | "mysticalagriculture:seed/reprocessor/dark_steel" | "alltheores:iron_rod" | "caveopolis:marble_brick_stairs_from_marble_bricks_stonecutting" | "mysticalagriculture:seed/infusion/manasteel" | "mysticalagriculture:soulium_dust_smelted" | "thermal:machines/press/unpacking/press_tar_unpacking" | "caveopolis:purple_colored_stone_brick_wall_from_purple_colored_stone_bricks_stonecutting" | "farmersdelight:cutting/acacia_log" | "caveopolis:sprayer/colored_stone_wall/light_gray_colored_stone_wall" | "minecraft:magma_block" | "tmttd:cooking/t_stuffed_pumpkin_2" | "caveopolis:red_colored_hanging_sign_from_stripped_red_colored_log_stonecutting" | "caveopolis:blue_colored_hanging_sign_from_stripped_blue_colored_log_stonecutting" | "cozy_home:lamp_green_recipe" | "caveopolis:orange_colored_stone_brick_wall" | "thermal:tinker_bench" | "caveopolis:sprayer/colored_stone_slab/magenta_colored_stone_slab" | "minecraft:brush" | "lfpirates:sailor_gray_tier_2_helmet_recipe_1" | "farmersdelight:fried_egg_from_smoking" | "suppsquared:candle_holders/gold_candle_holder_soul" | "minecraft:deepslate_tile_slab_from_deepslate_tiles_stonecutting" | "caveopolis:sprayer/colored_stone_bricks/blue_colored_stone_bricks" | "thermal:earth_charge/niter_dust_from_niter" | "caveopolis:sprayer/concrete/gray" | "mysticalagriculture:enchanter/soul_siphoner" | "supplementaries:cozy_home/sign_post_cherry" | "mysticalagriculture:seed/infusion/marble" | "chipped:alchemy_bench" | "minecraft:end_stone_bricks_from_end_stone_stonecutting" | "thermal:machines/smelter/smelter_raw_iron" | "caveopolis:lime_colored_wooden_plank_button" | "mysticalagriculture:seed/crafting/awakened_draconium" | "supplementaries:ash_brick" | "caveopolis:pink_colored_stone_brick_stairs_from_pink_colored_stone_bricks_stonecutting" | "mysticalagriculture:gear/prudentium_sickle" | "caveopolis:sprayer/remove_color/cobblestone_brick_slabs" | "thermal:machines/press/press_peanut_packing" | "opolisutilities:resource_generator_2/speed_blocks/osmium" | "thermal:compat/mysticalagriculture/insolator_mysticalag_rabbit_seeds" | "caveopolis:sprayer/colored_stone_brick_wall/green_colored_stone_brick_wall" | "thermal:machines/press/packing3x3/press_sugar_cane_packing" | "oceansdelight:cooked_guardian_tail_from_smoking" | "caveopolis:magenta_colored_stone_bricks" | "thermal:compat/mysticalagriculture/insolator_mysticalag_nickel_seeds" | "chipped:benches/botanist_workbench" | "caveopolis:sprayer/colored_stone_wall/white_colored_stone_wall" | "farmersdelight:cooking/bone_broth" | "alltheores:bronze_ingot_from_dust_blasting" | "cozy_home:acacia_plank_recipe" | "minecraft:waxed_exposed_cut_copper_slab" | "thermal:compat/biomesoplenty/insolator_bop_wilted_lilly_flower" | "minecraft:dark_oak_fence" | "alltheores:zinc_dust_from_hammer_ingot_crushing" | "thermal:rich_slag_bricks" | "caveopolis:sprayer/colored_wooden_plank_door/brown" | "caveopolis:brown_colored_cobblestone_brick_stairs" | "mysticalagriculture:inferium_gemstone" | "caveopolis:light_blue_colored_stone_stairs" | "caveopolis:sprayer/colored_stone_bricks/green_colored_stone_bricks" | "thermal:machines/press/unpacking/press_sulfur_unpacking" | "thermal:compat/create/smelter_create_crushed_raw_tin" | "farmersdelight:cutting/melon" | "thermal:earth_charge/prismarine_shard_from_prismarine" | "caveopolis:sprayer/colored_cobblestone_wall/gray_colored_stone_wall" | "minecraft:waxed_oxidized_cut_copper_slab_from_waxed_oxidized_copper_stonecutting" | "supplementaries:soap/spike" | "thermal:compat/tconstruct/press_tconstruct_ichor_slime_3x3_unpacking" | "libraryferret:blasting/iron_coins_jtl" | "caveopolis:lime_colored_wooden_plank_fence_gate_from_lime_colored_wooden_planks_stonecutting" | "thermal:machines/sawmill/sawmill_rubberwood_logs" | "caveopolis:sprayer/glass_block/lime" | "minecraft:blaze_powder" | "minecraft:chain" | "thermal:parts/constantan_gear" | "alltheores:peridot_block" | "thermal:storage/bamboo_block" | "caveopolis:brown_colored_cobblestone_wall_from_brown_colored_cobblestone_stonecutting" | "alltheores:uranium_ingot_from_slate_ore_blasting" | "industrialforegoing:mycelial_potion" | "minecraft:oak_fence" | "alltheores:peridot_from_hammer_crushing" | "mysticalagriculture:seed/reprocessor/hop_graphite" | "storagedrawers:compacting_drawers_3" | "caveopolis:sprayer/stripped_colored_logs/magenta" | "caveopolis:sprayer/colored_wooden_plank_fence/green" | "mysticalagriculture:seed/crafting/ruby" | "mysticalagriculture:seed/reprocessor/experience" | "mysticalagriculture:seed/infusion/amethyst_bronze" | "mysticalagriculture:soulium_gemstone" | "cozy_home:table_warped_recipe" | "caveopolis:blue_colored_cobblestone_brick_stairs" | "cozy_home:drawer_spruce_recipe" | "mysticalagriculture:awakened_supremium_ingot_recraft" | "cozy_home:lamp_blue_recipe" | "thermal:compat/create/centrifuge_create_crushed_raw_silver" | "thermal:compat/tconstruct/chiller_tconstruct_constantan_ingot" | "mysticalagriculture:enchanter/frost_walker" | "supplementaries:dispenser_minecart" | "mysticalagriculture:essence/botania/lime_mystical_flower" | "strainers:horn_coral_block_from_straining_horn_coral_in_strainers_purified_water_fluid" | "minecraft:deepslate" | "caveopolis:lime_colored_wooden_plank_door_from_lime_colored_wooden_planks_stonecutting" | "glassential:light_door" | "aquaculture:neptunium_pickaxe" | "thermal:rockwool/blue_rockwool_from_dye" | "thermal:storage/sadiroot_from_block" | "caveopolis:orange_colored_wooden_plank_door_from_orange_colored_wooden_planks_stonecutting" | "aquamirae:cooked_spinefish" | "alltheores:silver_ingot_from_ore" | "caveopolis:magenta_colored_stone_wall" | "ftbquests:task_screen_configurator" | "mysticalagriculture:seed/infusion/apatite" | "thermal:gunpowder_mushroom_spores" | "caveopolis:sprayer/colored_cobblestone/black_colored_stone" | "minecraft:calibrated_sculk_sensor" | "strainers:friend_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "smallships:oak_cog" | "mysticalagriculture:seed/infusion/invar" | "caveopolis:sprayer/colored_stone_brick_stairs/light_blue_colored_stone_brick_stairs" | "cozy_home:lamp_red_recipe" | "caveopolis:red_colored_stone" | "caveopolis:blue_colored_hanging_sign" | "industrialforegoing:dissolution_chamber/pink_slime_ball" | "farmersdelight:skillet" | "thermal_extra:parts/dragonsteel_gear" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/cyan" | "thermal:machines/insolator/insolator_lily_pad" | "minecraft:prismarine_slab_from_prismarine_stonecutting" | "caveopolis:lime_colored_stone_slab_from_lime_colored_stone_stonecutting" | "industrialforegoing:material_stonework_factory" | "caveopolis:sprayer/colored_stone_wall/gray_colored_stone_wall" | "minecraft:deepslate_tile_wall_from_deepslate_bricks_stonecutting" | "thermal:earth_charge/lapis_dust_from_lapis" | "thermal:machines/press/press_bell_pepper_packing" | "caveopolis:sprayer/colored_stone_stairs/pink_colored_stone_stairs" | "minecraft:green_terracotta" | "caveopolis:purple_colored_wooden_planks" | "minecraft:white_stained_glass" | "strainers:tall_grass" | "alltheores:tools_materials/silver/silver_from_block" | "industrialforegoing:laser_lens_black_recolor" | "caveopolis:marble_from_white_colored_stone_stonecutting" | "mysticalagriculture:seed/crafting/stone" | "thermal:smelting/constantan_ingot_from_dust_blasting" | "caveopolis:sprayer/colored_cobblestone_stairs/cyan_colored_stone_stairs" | "thermal:machines/press/press_lead_ingot_to_plate" | "minecraft:purpur_stairs" | "industrialforegoing:stonework_generate/obsidian" | "opolisutilities:resource_generator/mods/caveopolis/gray_colored_stone" | "thermal:machines/press/press_steel_nugget_to_coin" | "supplementaries:gold_door" | "caveopolis:cyan_colored_stone_slab" | "caveopolis:pink_colored_cobblestone_bricks_from_pink_colored_cobblestone_stonecutting" | "caveopolis:sprayer/colored_wooden_plank_button/blue" | "mysticalagriculture:seed/reprocessor/air" | "itemfilters:always_true_from_others" | "thermal:compat/quark/press_quark_nether_wart_sack_unpacking" | "mysticalagriculture:seed/infusion/yellorium" | "thermal:machines/pulverizer/pulverizer_signalum_plate_to_dust" | "caveopolis:sprayer/colored_stone_brick_stairs/orange_colored_stone_brick_stairs" | "thermal_extra:soul_infused_glass" | "minecraft:ward_armor_trim_smithing_template" | "caveopolis:purple_colored_stone_crafting_table" | "thermal:machines/press/press_rice_unpacking" | "caveopolis:sprayer/colored_saplings/purple" | "industrialforegoing:conveyor_detection_upgrade" | "lfpirates:corsair_tier_1_leggins_recipe_1" | "mysticalagriculture:augment/flight" | "mysticalagriculture:stonecutting/soulstone_bricks_stairs_from_soulstone" | "sophisticatedbackpacks:auto_blasting_upgrade" | "mysticalagriculture:essence/minecraft/redstone" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/orange" | "supplementaries:altimeter" | "supplementaries:end_stone_lamp" | "caveopolis:green_colored_stone_button" | "alltheores:mek_processing/nickel/shard/from_ore" | "caveopolis:stripped_black_colored_wood" | "thermal:compat/mysticalagriculture/insolator_mysticalag_stone_seeds" | "minecraft:quartz_from_blasting" | "caveopolis:red_colored_cobblestone_wall" | "cozy_home:birch_chair_recipe" | "caveopolis:yellow_colored_cobblestone_brick_slab_from_yellow_colored_cobblestone_bricks_stonecutting" | "thermal:compat/tconstruct/press_tconstruct_hepatizon_nugget_unpacking" | "opolisutilities:catalogue/selling/basic_loot_box" | "strainers:heartbreak_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "thermal_extra:smelting/soul_infused_ingot_from_dust_smelting" | "caveopolis:black_colored_cobblestone_stairs_from_black_colored_cobblestone_stonecutting" | "minecraft:purpur_slab" | "farmersdelight:light_gray_canvas_sign" | "mysticalagriculture:seed/crafting/aluminum" | "supplementaries:candle_holders/candle_holder_blue" | "minecraft:chiseled_polished_blackstone_from_blackstone_stonecutting" | "thermal:fuels/gourmand/gourmand_radish_block" | "mysticalagriculture:souls/wool" | "storagedrawers:birch_trim" | "mysticalagriculture:essence/minecraft/spider_eye" | "alltheores:mek_processing/zinc/shard/from_raw_ore" | "caveopolis:magenta_colored_wooden_plank_door" | "supplementaries:candle_holders/candle_holder_orange_dye" | "mysticalagriculture:gear/prudentium_shovel" | "thermal:redstone_tnt" | "minecraft:gold_nugget" | "thermal:redstone_mushroom_spores" | "industrialforegoing:mycelial_disenchantment" | "cozy_home:counter_acacia_sink_recipe" | "caveopolis:magenta_colored_stone_button" | "thermal:compat/mysticalagriculture/insolator_mysticalag_queens_slime_seeds" | "caveopolis:sprayer/shulker_box/brown" | "lfpirates:corsair_tier_3_boots_recipe_1" | "caveopolis:sprayer/colored_cobblestone/orange_colored_stone" | "minecraft:waxed_oxidized_cut_copper" | "industrialforegoing:laser_drill_ore/coal" | "sophisticatedbackpacks:stack_upgrade_tier_1_from_starter" | "mysticalagradditions:essence/nether_star_shard" | "mysticalagriculture:souls/salmon" | "thermal:machines/press/press_sadiroot_unpacking" | "caveopolis:sprayer/colored_wooden_plank_door/orange" | "thermal:dynamo_numismatic" | "minecraft:blast_furnace" | "strainers:big_dripleaf_from_straining_barrier_in_strainers_eroding_water_fluid" | "minecraft:polished_andesite_stairs" | "mysticalagradditions:tconstruct/casting/tertium/ingot_sand_cast" | "farmersdelight:cutting/crimson_sign" | "thermal:fire_charge/lumium_ingot_4" | "minecraft:light_blue_stained_glass_pane_from_glass_pane" | "minecraft:magenta_dye_from_lilac" | "thermal:compat/mysticalagriculture/insolator_mysticalag_limestone_seeds" | "minecraft:dye_red_bed" | "caveopolis:orange_colored_wooden_plank_button" | "mysticalagriculture:seed/reprocessor/rose_gold" | "strainers:clay_ball_from_straining_dirt_in_minecraft_water" | "farmersdelight:canvas_rug" | "thermal:smelting/signalum_ingot_from_dust_blasting" | "supplementaries:candle_holders/candle_holder_white" | "minecraft:blue_stained_glass_pane_from_glass_pane" | "mysticalagriculture:essence/botania/black_mystical_flower" | "alltheores:tools_materials/uranium/uranium_from_block" | "caveopolis:black_colored_wooden_plank_button_from_black_colored_wooden_planks_stonecutting" | "caveopolis:brown_colored_wooden_plank_slab" | "minecraft:red_sandstone_wall_from_red_sandstone_stonecutting" | "thermal:augments/item_filter_augment" | "caveopolis:sprayer/terracotta/light_blue" | "oceansdelight:cutting/tentacles" | "industrialforegoing:mycelial_rocket" | "thermal:machines/press/packing2x2/press_sandstone_packing" | "thermal:machines/smelter/smelter_tin_dust" | "minecraft:fletching_table" | "mysticalagriculture:seed/crafting/rock_crystal" | "caveopolis:sprayer/colored_wooden_plank_slab/light_blue" | "thermal:lightning_tnt" | "minecraft:dye_lime_bed" | "caveopolis:sprayer/stripped_colored_wood/light_gray" | "minecraft:waxed_exposed_cut_copper_stairs_from_waxed_exposed_copper_stonecutting" | "cozy_home:sofa_magenta_recipe" | "opolisutilities:advanced_home_stone" | "farmersdelight:acacia_cabinet" | "thermal:machines/insolator/insolator_peony" | "thermal:machines/press/unpacking/press_diamond_unpacking" | "supplementaries:candle_holders/candle_holder_lime" | "minecraft:mossy_cobblestone_wall" | "thermal_extra:storage/dragonsteel_nugget_from_ingot" | "caveopolis:stripped_purple_colored_wood" | "minecraft:spyglass" | "mysticalagriculture:souls/tropical_fish" | "caveopolis:sprayer/glass_block/blue" | "thermal:machines/smelter/smelter_catalyst_rich_slag" | "caveopolis:sprayer/colored_stone_pressure_plate/black" | "mysticalagriculture:seed/infusion/blizz" | "minecraft:pink_stained_glass" | "caveopolis:white_colored_cobblestone_brick_slab_from_white_colored_cobblestone_bricks_stonecutting" | "smallships:cherry_galley" | "alltheores:enderium_nugget_from_ingot" | "minecraft:oak_chest_boat" | "minecraft:end_stone_brick_wall_from_end_stone_brick_stonecutting" | "caveopolis:green_colored_wooden_plank_fence_gate_from_green_colored_wooden_planks_stonecutting" | "thermal:compat/quark/press_quark_bonded_leather_packing" | "strainers:dirt" | "mysticalagriculture:seed/infusion/quartz_enriched_iron" | "strainers:echo_shard_from_straining_sculk_in_minecraft_water" | "industrialforegoing:laser_drill_ore/raw_materials/gold" | "caveopolis:sprayer/colored_stone_brick_stairs/gray_colored_stone_brick_stairs" | "cozy_home:table_bamboo_recipe" | "thermal:machines/press/press_copper_ingot_to_plate" | "thermal:compat/mysticalagriculture/insolator_mysticalag_platinum_seeds" | "mysticalagriculture:soulium_gemstone_block_uncraft" | "thermal:compat/biomesoplenty/insolator_bop_pink_hibiscus_flower" | "minecraft:yellow_stained_glass_pane" | "caveopolis:sprayer/candles/purple" | "nec:caveop_light_gray_colored_wooden_chest" | "mysticalagriculture:essence/minecraft/rabbit_foot" | "industrialforegoing:dissolution_chamber/infinity_trident" | "minecraft:diorite_slab_from_diorite_stonecutting" | "strainers:gravel_from_straining_andesite_in_strainers_eroding_water_fluid" | "thermal:machine_frame" | "mysticalagriculture:seed/crafting/squid" | "caveopolis:green_colored_cobblestone_brick_wall_from_green_colored_cobblestone_bricks_stonecutting" | "minecraft:raiser_armor_trim_smithing_template" | "thermal:machines/press/press_iron_nugget_to_coin" | "farmersdelight:white_canvas_sign" | "minecraft:bamboo_mosaic_stairs" | "caveopolis:magenta_spray_can" | "aquamirae:cooked_spinefish_from_campfire" | "caveopolis:sprayer/colored_cobblestone_bricks/yellow_colored_stone_bricks" | "systeams:boilers/upgrades/lapidary_upgrade" | "alltheores:nickel_block" | "caveopolis:magenta_colored_cobblestone_stairs_from_magenta_colored_cobblestone_stonecutting" | "thermal:augments/rf_coil_augment" | "minecraft:oxidized_cut_copper_from_oxidized_copper_stonecutting" | "mysticalagriculture:essence/botania/red_mystical_flower" | "minecraft:bread" | "caveopolis:light_blue_colored_stone_brick_wall_from_light_blue_colored_stone_bricks_stonecutting" | "mysticalagriculture:seed/infusion/hop_graphite" | "alltheores:silver_rod" | "strainers:carrot_from_straining_mulch_in_minecraft_water" | "minecraft:lever" | "alltheores:osmium_plate" | "caveopolis:brown_colored_wooden_plank_button" | "thermal:machines/pyrolyzer/pyrolyzer_coal" | "caveopolis:cyan_colored_wooden_plank_pressure_plate_from_cyan_colored_wooden_planks_stonecutting" | "thermal:machines/smelter/smelter_steel_armor" | "caveopolis:sprayer/colored_wooden_plank_button/light_blue" | "minecraft:end_stone_brick_wall_from_end_stone_stonecutting" | "caveopolis:white_colored_cobblestone_slab" | "caveopolis:lime_colored_stone_button_from_lime_colored_stone_stonecutting" | "supplementaries:hat_stand" | "mysticalagriculture:seed/infusion/squid" | "thermal:devices/rock_gen/rock_gen_blackstone" | "thermal:machines/smelter/smelter_copper_armor" | "thermal:redstone_grenade_4" | "caveopolis:sprayer/wool/light_blue_wool" | "minecraft:bamboo_slab" | "mysticalagriculture:seed/reprocessor/menril" | "minecraft:dark_oak_chest_boat" | "systeams:boilers/upgrades/magmatic_downgrade" | "caveopolis:light_gray_colored_wooden_plank_door_from_light_gray_colored_wooden_planks_stonecutting" | "minecraft:black_banner" | "thermal:machine_insolator" | "supplementaries:sign_post_crimson" | "minecraft:iron_shovel" | "caveopolis:sprayer/glazed_terracotta/magenta" | "mysticalagriculture:essence/draconicevolution/draconium_ingot" | "mysticalagradditions:tconstruct/casting/soulium/ingot_sand_cast" | "caveopolis:light_blue_colored_wooden_plank_trapdoor_from_light_blue_colored_wooden_planks_stonecutting" | "caveopolis:lime_colored_cobblestone_brick_wall_from_lime_colored_cobblestone_bricks_stonecutting" | "smallships:mangrove_brigg" | "mysticalagriculture:supremium_gemstone" | "thermal:machines/press/packing2x2/press_slag_packing" | "cozy_home:cherry_mirror_recipe" | "thermal:compat/create/chiller_create_chocolate_bar" | "minecraft:birch_hanging_sign" | "alltheores:mek_processing/aluminum/ingot/from_dust_blasting" | "farmersdelight:cutting/jungle_log" | "caveopolis:cyan_colored_wooden_plank_slab_from_cyan_colored_wooden_planks_stonecutting" | "alltheores:osmium_dust_from_hammer_ingot_crushing" | "caveopolis:light_gray_colored_wooden_plank_trapdoor" | "thermal:machine_crucible" | "thermal:machines/press/press_invar_ingot_to_plate" | "strainers:prize_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "caveopolis:light_blue_colored_wooden_plank_slab" | "libraryferret:smelting/emerald_coins_jtl" | "mysticalagriculture:augment/no_fall_damage" | "supplementaries:rope_arrow_create" | "caveopolis:sprayer/glass_block/green" | "caveopolis:sprayer/terracotta/gray" | "lfpirates:corsair_tier_1_helmet_recipe_1" | "minecraft:cooked_chicken" | "glassential:ethereal_reverse_door" | "thermal:smelting/tin_ingot_from_deepslate_ore_smelting" | "thermal:compat/tconstruct/press_tconstruct_rose_gold_packing" | "thermal:machines/centrifuge/centrifuge_blue_wool" | "caveopolis:red_colored_stone_pressure_plate" | "caveopolis:lime_colored_cobblestone" | "caveopolis:cyan_colored_cobblestone_brick_wall" | "minecraft:oak_door" | "thermal:compat/tconstruct/press_tconstruct_manyullyn_nugget_packing" | "caveopolis:light_gray_colored_wooden_plank_fence_gate" | "cozy_home:dark_oak_wall_clock_recipe" | "caveopolis:sprayer/beds/brown" | "opolisutilities:resource_generator_2/speed_blocks/vibrant_alloy" | "lfpirates:corsair_tier_1_boots_recipe_1" | "thermal:machines/press/press_iron_ingot_to_coin" | "mysticalagriculture:seed/crafting/aquamarine" | "thermal:machines/press/press_constantan_ingot_to_gear" | "caveopolis:yellow_colored_cobblestone_brick_stairs" | "thermal:potion_infuser" | "thermal:machines/press/unpacking/press_nether_wart_unpacking" | "thermal:storage/rice_from_block" | "alltheores:raw_aluminum_from_block" | "minecraft:polished_diorite_stairs_from_diorite_stonecutting" | "strainers:upgrades/reinforced/reinforced_mesh_upgrade" | "farmersdelight:beetroot_from_crate" | "minecraft:spruce_door" | "sophisticatedbackpacks:smelting_upgrade" | "tmttd:machines/press/cocoabeans_press" | "caveopolis:gray_colored_cobblestone_brick_slab" | "caveopolis:sprayer/colored_stone_slab/lime_colored_stone_slab" | "farmersdelight:cooked_salmon_slice_from_smoking" | "mysticalagriculture:essence/minecraft/arrow" | "caveopolis:sprayer/colored_wooden_plank_door/red" | "thermal:machines/insolator/insolator_pumpkin" | "caveopolis:sprayer/colored_stone_slab/brown_colored_stone_slab" | "caveopolis:blue_colored_stone_brick_slab_from_blue_colored_stone_bricks_stonecutting" | "caveopolis:sprayer/colored_cobblestone/pink_colored_stone" | "mysticalagriculture:seed/reprocessor/iridium" | "supplementaries:soap/blackboard" | "cozy_home:grandfather_clock_cherry_recipe" | "mysticalagriculture:soul_jar_empty" | "farmersdelight:straw" | "strainers:brain_coral_fan_from_straining_barrier_in_minecraft_water" | "minecraft:dark_prismarine" | "thermal:compat/mysticalagriculture/insolator_mysticalag_enderman_seeds" | "thermal:machines/pulverizer/pulverizer_coal_ore" | "minecraft:leather_horse_armor" | "caveopolis:sprayer/glazed_terracotta/lime" | "thermal_extra:machine/smelter/dragonsteel_ingot_from_dust" | "supplementaries:candle_holders/candle_holder" | "minecraft:candle" | "mysticalagriculture:essence/minecraft/nether_wart" | "caveopolis:brown_colored_wooden_plank_button_from_brown_colored_wooden_planks_stonecutting" | "glassential:redstone_door" | "strainers:piglin_head_from_straining_skeleton_skull_in_strainers_purified_water_fluid" | "thermal:machines/press/unpacking/press_clay_unpacking" | "minecraft:waxed_oxidized_cut_copper_slab_from_waxed_oxidized_cut_copper_stonecutting" | "thermal:compat/quark/press_quark_chorus_fruit_unpacking" | "thermal:energy_duct_4" | "farmersdelight:integration/immersiveengineering/crusher/wild_tomatoes" | "thermal:compat/quark/press_quark_chorus_fruit_packing" | "mysticalagriculture:tertium_farmland" | "alltheores:mek_processing/iridium/crystal/from_slurry" | "mysticalagriculture:gear/supremium_hoe" | "mysticalagriculture:seed/reprocessor/redstone_alloy" | "minecraft:deepslate_tile_slab_from_cobbled_deepslate_stonecutting" | "alltheores:mek_processing/platinum/clump/from_raw_block" | "caveopolis:red_colored_stone_button_from_red_colored_stone_stonecutting" | "farmersdelight:cutting/cornflower" | "mysticalagriculture:seed/infusion/creeper" | "mysticalagriculture:gear/supremium_shears" | "supplementaries:wrench" | "alltheores:mek_processing/zinc/slurry/dirty" | "thermal_extra:machine/press/dragonsteel_gear" | "thermal:storage/strawberry_block" | "farmersdelight:cutting/deepslate" | "caveopolis:cyan_colored_wooden_plank_stairs_from_cyan_colored_wooden_planks_stonecutting" | "thermal:machines/smelter/smelter_bronze_armor" | "tmttd:machines/press/rice_press" | "thermal:storage/gunpowder_block" | "thermal:machines/press/packing3x3/press_raw_copper_packing" | "caveopolis:light_gray_colored_cobblestone_brick_stairs_from_light_gray_colored_cobblestone_bricks_stonecutting" | "minecraft:jungle_slab" | "mysticalagriculture:seed/reprocessor/obsidian" | "thermal:storage/raw_tin_block" | "opolisutilities:upgrade_base" | "supplementaries:sconce" | "thermal:compat/mysticalagriculture/insolator_mysticalag_uraninite_seeds" | "thermal:machines/pulverizer/pulverizer_tin_ore" | "farmersdelight:cutting/birch_wood" | "oceansdelight:cabbage_wrapped_elder_guardian" | "minecraft:skull_banner_pattern" | "industrialforegoing:laser_drill_ore/glowstone" | "farmersdelight:shepherds_pie_block" | "strainers:calcite_from_straining_diorite_in_strainers_purified_water_fluid" | "aquaculture:gold_hook" | "caveopolis:sprayer/glass_block/black" | "farmersdelight:cutting/warped_sign" | "caveopolis:sprayer/remove_color/wooden_plank_pressure_plates" | "mysticalagriculture:essence/minecraft/coal" | "caveopolis:sprayer/glazed_terracotta/blue" | "minecraft:granite" | "minecraft:melon_seeds" | "thermal:machines/press/press_eggplant_unpacking" | "industrialforegoing:stonework_generate/diorite" | "mysticalagriculture:seed/crafting/inferium" | "mysticalagriculture:seed/crafting/iridium" | "minecraft:black_dye_from_wither_rose" | "thermal:compat/mekanism/press_mek_fluorite_unpacking" | "thermal:compat/create/smelter_create_crushed_raw_lead" | "mysticalagriculture:essence/minecraft/red_sand" | "alltheores:uranium_ingot_from_raw_blasting" | "thermal:compat/tconstruct/press_tconstruct_hepatizon_unpacking" | "caveopolis:sprayer/colored_stone_slab/pink_colored_stone_slab" | "framedcompactdrawers:framed_half_four" | "caveopolis:sprayer/colored_wooden_planks/white" | "thermal:machines/smelter/smelter_nickel_plate_to_ingot" | "caveopolis:sprayer/colored_signs/gray" | "mysticalagriculture:essence/enderio/soularium_ingot" | "mysticalagriculture:gear/awakened_supremium_sword" | "thermal:compat/immersiveengineering/smelter_ie_raw_uranium" | "caveopolis:purple_colored_hanging_sign_from_stripped_purple_colored_log_stonecutting" | "thermal:machines/pulverizer/pulverizer_niter_ore" | "thermal:device_rock_gen" | "caveopolis:sprayer/colored_stone_pressure_plate/white" | "simplehats:hatscraps" | "mysticalagriculture:seed/infusion/soulium" | "caveopolis:brown_colored_wooden_plank_slab_from_brown_colored_wooden_planks_stonecutting" | "farmersdelight:cutting/kelp_roll" | "caveopolis:light_gray_colored_cobblestone_bricks" | "mysticalagriculture:gear/prudentium_chestplate" | "supplementaries:iron_gate" | "minecraft:dye_yellow_carpet" | "mysticalagriculture:gear/awakened_supremium_shovel" | "minecraft:dye_white_wool" | "mysticalagriculture:seed/crafting/manyullyn" | "caveopolis:black_colored_wooden_plank_crafting_table" | "thermal:machines/pulverizer/pulverizer_bronze_ingot_to_dust" | "thermal:smelting/apatite_from_blasting" | "thermal:machines/press/press_corn_packing" | "caveopolis:pink_colored_wooden_plank_stairs" | "strainers:upgrade_stats/reinforced_input_upgrade" | "thermal:lime_concrete_powder_with_slag" | "mysticalagriculture:seed/crafting/peridot" | "mysticalagriculture:seed/infusion/dirt" | "igleelib:modium_ingot_from_block" | "thermal:machines/centrifuge/centrifuge_pink_rockwool" | "minecraft:packed_ice" | "caveopolis:pink_colored_cobblestone_wall" | "alltheores:signalum_plate" | "caveopolis:sprayer/colored_hanging_signs/purple" | "caveopolis:sprayer/colored_stone_stairs/cyan_colored_stone_stairs" | "minecraft:deepslate_tile_slab_from_deepslate_bricks_stonecutting" | "cozy_home:oak_fireplace_recipe" | "strainers:summoning_block/polar_bear" | "cozy_home:jungle_plank_recipe" | "alltheores:mek_processing/aluminum/dust/from_dirty_dust" | "alltheores:constantan_plate" | "thermal_extra:machine/press/soul_infused_nugget_to_coin" | "thermal:storage/onion_from_block" | "minecraft:cobbled_deepslate_wall" | "minecraft:purpur_slab_from_purpur_block_stonecutting" | "thermal:machines/smelter/smelter_tin_plate_to_ingot" | "supplementaries:timber_cross_brace" | "thermal:stonecutting/chiseled_slag_from_stonecutting" | "caveopolis:gray_colored_sign_from_gray_colored_wooden_planks_stonecutting" | "thermal:augments/dynamo_output_augment" | "supplementaries:candle_holders/candle_holder_black" | "thermal:machines/bottler/bottler_orange_concrete" | "minecraft:smooth_stone" | "caveopolis:lime_colored_wooden_plank_pressure_plate_from_lime_colored_wooden_planks_stonecutting" | "mysticalagradditions:tconstruct/tools/materials/supremium/block" | "thermal:compat/tconstruct/press_tconstruct_ichor_slime_2x2_unpacking" | "thermal:machines/press/press_hops_unpacking" | "minecraft:purple_carpet" | "mysticalagradditions:tconstruct/tools/materials/prudentium/nugget" | "mysticalagriculture:gear/tertium_helmet" | "caveopolis:light_gray_colored_stone_stairs_from_light_gray_colored_stone_stonecutting" | "caveopolis:sprayer/colored_saplings/red" | "strainers:amethyst_shard_from_straining_diorite_in_minecraft_water" | "caveopolis:lime_colored_stone_stairs" | "minecraft:polished_granite_slab_from_granite_stonecutting" | "mysticalagriculture:seed/infusion/dark_steel" | "mysticalagriculture:seed/infusion/zinc" | "caveopolis:marble_stairs" | "thermal:compat/tconstruct/chiller_tconstruct_tin_ingot" | "alltheores:lead_plate" | "minecraft:ender_eye" | "caveopolis:sprayer/remove_color/beds" | "caveopolis:brown_colored_stone_button" | "supplementaries:blackstone_lamp" | "thermal:compat/biomesoplenty/tree_extractor_bop_hellbark" | "mysticalagriculture:seed/crafting/ghast" | "farmersdelight:apple_pie_from_slices" | "mysticalagriculture:prosperity_block" | "minecraft:birch_slab" | "mysticalagriculture:seed/infusion/air" | "opolisutilities:resource_generator_2/speed_blocks/nether_star" | "caveopolis:sprayer/glass_pane/lime" | "sophisticatedbackpacks:battery_upgrade" | "mysticalagriculture:seed/reprocessor/peridot" | "minecraft:waxed_cut_copper_stairs" | "thermal_extra:augments/rf_coil_xfer_augment_1" | "minecraft:quartz_bricks_from_quartz_block_stonecutting" | "thermal:storage/flax_from_block" | "thermal_extra:augments/rf_coil_xfer_augment_3" | "thermal_extra:augments/rf_coil_xfer_augment_2" | "mysticalagriculture:essence/minecraft/music_disc_blocks" | "thermal_extra:augments/rf_coil_xfer_augment_5" | "thermal_extra:augments/rf_coil_xfer_augment_4" | "alltheores:mek_processing/nickel/clump/from_ore" | "caveopolis:sprayer/colored_cobblestone_stairs/pink_colored_stone_stairs" | "minecraft:pink_stained_glass_pane_from_glass_pane" | "thermal:storage/lumium_ingot_from_nuggets" | "opolisutilities:resource_generator_2/speed_blocks/desh" | "mysticalagriculture:essence/minecraft/grass_block" | "strainers:sea_pickle_from_straining_barrier_in_strainers_eroding_water_fluid" | "caveopolis:gray_colored_cobblestone_brick_slab_from_gray_colored_cobblestone_bricks_stonecutting" | "mysticalagriculture:seed/infusion/blitz" | "theoneprobe:probe" | "igleelib:blazum_block" | "minecraft:stone_hoe" | "caveopolis:mixed_stone_ingot_from_blasting_mixed_stone_ore" | "igleelib:modium_block" | "thermal:smelting/niter_from_smelting" | "mysticalagriculture:enchanter" | "alltheores:gold_ingot_from_dust_blasting" | "thermal:machines/insolator/insolator_dark_oak_sapling" | "caveopolis:sprayer/colored_wood/light_gray" | "thermal:rubberwood_fence_gate" | "thermal:compat/mysticalagriculture/insolator_mysticalag_hepatizon_seeds" | "minecraft:exposed_cut_copper_stairs_from_exposed_cut_copper_stonecutting" | "sophisticatedbackpacks:smoking_upgrade" | "cozy_home:grandfather_clock_birch_recipe" | "thermal:machines/bottler/bottler_yellow_concrete" | "minecraft:cooked_mutton_from_campfire_cooking" | "thermal_extra:parts/twinite_gear" | "alltheores:mek_processing/silver/slurry/clean" | "minecraft:dye_black_wool" | "caveopolis:brown_colored_wooden_plank_crafting_table" | "thermal:compat/quark/insolator_quark_red_blossom_sapling" | "thermal:compat/mysticalagriculture/insolator_mysticalag_glowstone_seeds" | "minecraft:cooked_beef" | "thermal:machines/pulverizer/pulverizer_constantan_plate_to_dust" | "industrialforegoing:stonework_generate/netherrack" | "industrialforegoing:laser_drill_ore/raw_materials/uranium" | "supplementaries:present_dye" | "minecraft:oxidized_cut_copper" | "thermal:machines/press/press_tomato_packing" | "industrialforegoing:fluid_transporter_type" | "mysticalagriculture:seed/crafting/cow" | "mysticalagriculture:essence/minecraft/purple_concrete" | "mysticalagradditions:tertium_coal_block_uncraft" | "mysticalagriculture:seed/reprocessor/brass" | "mysticalagriculture:seed/infusion/experience" | "thermal:machines/insolator/insolator_vine" | "thermal:machines/press/press_gold_ingot_to_coin" | "minecraft:gold_nugget_from_smelting" | "minecraft:chiseled_quartz_block_from_quartz_block_stonecutting" | "caveopolis:magenta_colored_wooden_plank_pressure_plate_from_magenta_colored_wooden_planks_stonecutting" | "mysticalagriculture:soulium_ingot" | "thermal:compat/mysticalagriculture/insolator_mysticalag_titanium_seeds" | "industrialforegoing:laser_drill_ore/ores/peridot" | "strainers:summoning_block/mooshroom" | "thermal:machines/insolator/insolator_sea_pickle" | "opolisutilities:resource_generator/mods/caveopolis/light_blue_colored_stone" | "aquaculture:neptunium_boots" | "caveopolis:lime_colored_wooden_plank_trapdoor" | "mysticalagriculture:essence/powah/uraninite" | "thermal:machines/press/press_constantan_ingot_to_plate" | "caveopolis:light_gray_colored_stone_brick_wall" | "industrialforegoing:animal_feeder" | "mysticalagriculture:essence/minecraft/brown_dye" | "caveopolis:sprayer/glass_pane/blue" | "caveopolis:sprayer/refill/glowstone" | "mysticalagriculture:supremium_essence_uncraft" | "thermal:dynamo_magmatic" | "minecraft:mangrove_pressure_plate" | "strainers:oak_sapling_from_straining_barrier_in_minecraft_air" | "caveopolis:sprayer/colored_stone_crafting_table/brown" | "thermal:device_collector" | "industrialforegoing:pity_black_hole_unit" | "cozy_home:counter_quartz_storage_recipe" | "tmttd:machines/press/straw_bale_press" | "thermal:devices/potion_diffuser/potion_diffuser_boost_glowstone_dust" | "mysticalagriculture:seed/reprocessor/coal" | "thermal:storage/enderium_ingot_from_nuggets" | "caveopolis:black_colored_hanging_sign" | "farmersdelight:pink_canvas_sign" | "mysticalagriculture:seed/infusion/limestone" | "thermal:smelting/lead_ingot_from_raw_blasting" | "minecraft:weathered_cut_copper_slab_from_weathered_cut_copper_stonecutting" | "caveopolis:pink_colored_stone_pressure_plate" | "chipped:benches/glassblower" | "mysticalagriculture:awakening_altar" | "mysticalagriculture:augment/attack_aoe_ii" | "thermal:machines/smelter/smelter_invar_tools" | "industrialforegoing:mob_imprisonment_tool" | "alltheores:osmium_ingot_from_ore_blasting" | "thermal:compat/create/pulverizer_create_netherrack" | "mysticalagriculture:essence/thermal/blitz_rod" | "caveopolis:sprayer/remove_color/colored_stone_pressure_plates" | "caveopolis:orange_colored_cobblestone_brick_stairs_from_orange_colored_cobblestone_bricks_stonecutting" | "cozy_home:oak_mirror_recipe" | "strainers:obsidian_from_straining_lava_bucket_in_minecraft_water" | "mysticalagriculture:augment/slowness_resistance" | "caveopolis:pink_spray_can" | "thermal:machines/press/packing3x3/press_niter_packing" | "industrialforegoing:stonework_generate/cobblestone" | "caveopolis:lime_colored_cobblestone_wall" | "caveopolis:sprayer/colored_stone_brick_slab/yellow_colored_stone_brick_slab" | "thermal:fire_charge/enderium_ingot_2" | "farmersdelight:cooked_mutton_chops" | "mysticalagriculture:seed/crafting/wither_skeleton" | "mysticalagriculture:earth_agglomeratio" | "caveopolis:sprayer/colored_cobblestone/light_gray_colored_stone" | "supplementaries:stone_tile_wall" | "minecraft:shulker_box_coloring" | "supplementaries:blackstone_tile" | "lfpirates:sailor_blue_tier_3_helmet_recipe_1" | "mysticalagriculture:essence/minecraft/red_dye" | "thermal:machines/press/unpacking/press_electrum_nugget_unpacking" | "mysticalagradditions:tconstruct/tools/materials/soulium/nugget" | "minecraft:deepslate_tile_stairs_from_polished_deepslate_stonecutting" | "industrialforegoing:dissolution_chamber/infinity_backpack" | "caveopolis:magenta_colored_wooden_plank_door_from_magenta_colored_wooden_planks_stonecutting" | "mysticalagradditions:tconstruct/casting/imperium/block" | "minecraft:enchanting_table" | "caveopolis:sprayer/colored_stone_brick_slab/green_colored_stone_brick_slab" | "minecraft:white_glazed_terracotta" | "alltheores:iridium_ingot" | "minecraft:lead" | "farmersdelight:roast_chicken_block" | "thermal:rubberwood_slab" | "thermal:machines/smelter/smelter_catalyst_cinnabar" | "opolisutilities:resource_generator_2/speed_blocks/yellorium" | "mysticalagriculture:seed/reprocessor/electrum" | "caveopolis:sprayer/colored_stone_buttons/red" | "mysticalagradditions:imperium_paxel" | "caveopolis:pink_colored_wooden_plank_crafting_table" | "caveopolis:brown_colored_wooden_plank_trapdoor" | "strainers:summoning_block/panda" | "caveopolis:sprayer/shulker_box/yellow" | "thermal:compat/tconstruct/press_tconstruct_blood_slime_3x3_unpacking" | "thermal_extra:machine/pulverizer/dragonsteel_dust" | "strainers:ice_from_straining_water_bucket_in_minecraft_water" | "farmersdelight:cooked_chicken_cuts" | "minecraft:stripped_spruce_wood" | "minecraft:acacia_wood" | "mysticalagriculture:soul_jar" | "caveopolis:sprayer/colored_cobblestone_bricks/blue_colored_stone_bricks" | "opolisutilities:resource_generator_2/speed_blocks/cyanite" | "thermal:compat/biomesoplenty/insolator_bop_dead_sapling" | "sophisticatedbackpacks:chipped/mason_table_upgrade" | "thermal:compat/dyenamics/bottler_dyenamics_cherenkov_concrete" | "thermal:compat/biomesoplenty/tree_extractor_bop_white_cherry" | "mysticalagriculture:tertium_growth_accelerator" | "matc:crystals/imperium" | "caveopolis:sprayer/stripped_colored_wood/gray" | "farmersdelight:cutting/beef" | "caveopolis:magenta_colored_stone_brick_wall" | "mysticalagriculture:prosperity_ingot_block_uncraft" | "caveopolis:light_blue_colored_cobblestone_bricks" | "caveopolis:sprayer/remove_color/stone" | "mysticalagriculture:gear/imperium_shovel" | "caveopolis:yellow_colored_wooden_plank_crafting_table" | "thermal:compat/tconstruct/chiller_tconstruct_copper_ingot" | "caveopolis:brown_colored_stone_bricks_from_brown_colored_stone_stonecutting" | "thermal:machines/press/press_signalum_ingot_to_gear" | "alltheores:electrum_ingot" | "farmersdelight:integration/immersiveengineering/cloche/tomato" | "caveopolis:blue_colored_wooden_plank_trapdoor_from_blue_colored_wooden_planks_stonecutting" | "farmersdelight:bread_from_smoking" | "caveopolis:cyan_colored_wooden_plank_fence_from_cyan_colored_wooden_planks_stonecutting" | "thermal:machines/press/unpacking/press_rose_gold_nugget_unpacking" | "mysticalagriculture:essence/twilightforest/fiery_ingot" | "thermal:machines/pulverizer/pulverizer_granite" | "caveopolis:sprayer/colored_wooden_planks/magenta" | "caveopolis:sprayer/terracotta/red" | "aquaculture:red_mushroom_from_red_shrooma" | "thermal:machines/press/press_iron_ingot_to_plate" | "caveopolis:white_colored_wooden_plank_fence_gate" | "caveopolis:sprayer/wool/magenta_wool" | "caveopolis:sprayer/glass_pane/pink" | "thermal:machine_chiller" | "mysticalagriculture:essence/astralsorcery/rock_crystal" | "caveopolis:sprayer/remove_color/cobblestone_brick_stairs" | "alltheores:lead_ingot_from_raw" | "lfpirates:sailor_nordic_tier_1_helmet_recipe_1" | "caveopolis:sprayer/colored_cobblestone_brick_wall/magenta_colored_stone_brick_wall" | "caveopolis:sprayer/wool/blue_wool" | "thermal:smelting/silver_ingot_from_dust_blasting" | "caveopolis:white_colored_cobblestone_slab_from_white_colored_cobblestone_stonecutting" | "caveopolis:green_colored_stone_brick_stairs_from_green_colored_stone_bricks_stonecutting" | "alltheores:mek_processing/iridium/dust/from_ore" | "mysticalagriculture:essence/mekanism/refined_glowstone_ingot" | "caveopolis:white_colored_wooden_plank_pressure_plate_from_white_colored_wooden_planks_stonecutting" | "mysticalagriculture:essence/twilightforest/steeleaf_ingot" | "thermal:machines/pulverizer/pulverizer_diamond" | "supplementaries:soap/clear" | "mysticalagriculture:seed/infusion/energized_steel" | "supplementaries:spiky_bomb" | "minecraft:waxed_cut_copper_slab" | "thermal:compat/mekanism/press_mek_refined_glowstone_packing" | "caveopolis:blue_colored_wooden_plank_button" | "mysticalagriculture:seed/infusion/rock_crystal" | "caveopolis:red_colored_wooden_plank_door_from_red_colored_wooden_planks_stonecutting" | "alltheores:iridium_ingot_from_raw" | "storagedrawers:jungle_trim" | "strainers:upgrades/improved/improved_input_upgrade" | "strainers:summoning_block/squid" | "cozy_home:chimney_netherbrick_recipe" | "mysticalagriculture:seed/reprocessor/vibrant_alloy" | "supplementaries:candle_holders/candle_holder_green" | "caveopolis:black_colored_wooden_plank_door" | "alltheores:lumium_ingot" | "caveopolis:brown_colored_stone_brick_stairs" | "thermal_extra:machine/press/dragonsteel_nugget_to_coin" | "mysticalagriculture:essence/common/electrum_ingot" | "smallships:acacia_drakkar" | "minecraft:cyan_dye_from_pitcher_plant" | "thermal:rubberwood_door" | "minecraft:leather_helmet" | "caveopolis:sprayer/colored_stone_buttons/lime" | "minecraft:light_blue_bed" | "thermal:machines/press/packing3x3/press_raw_tin_packing" | "caveopolis:white_colored_wooden_plank_crafting_table" | "caveopolis:black_colored_stone_wall_from_black_colored_stone_stonecutting" | "caveopolis:sprayer/glazed_terracotta/brown" | "opolisutilities:catalogue/selling/caveopolis/pink_spray_can" | "minecraft:nether_brick_stairs" | "caveopolis:gray_colored_stone_brick_wall" | "supplementaries:bubble_blower" | "caveopolis:purple_colored_stone_bricks_from_purple_colored_stone_stonecutting" | "caveopolis:blue_colored_wooden_plank_door" | "minecraft:recovery_compass" | "dankstorage:6" | "dankstorage:5" | "minecraft:magenta_bed" | "minecraft:oxidized_cut_copper_stairs_from_oxidized_copper_stonecutting" | "dankstorage:7" | "dankstorage:2" | "dankstorage:1" | "strainers:gold_nugget_from_straining_gravel_in_minecraft_water" | "minecraft:magenta_dye_from_blue_red_white_dye" | "dankstorage:4" | "mysticalagriculture:essence/minecraft/podzol" | "thermal:machines/centrifuge/centrifuge_muddy_mangrove_roots" | "dankstorage:3" | "minecraft:cherry_fence" | "thermal:slime_tnt_minecart" | "caveopolis:cyan_colored_wooden_plank_slab" | "alltheores:aluminum_ingot_from_raw" | "supplementaries:candle_holders/candle_holder_spectacle" | "industrialforegoing:ore_laser_base" | "alltheores:zinc_ingot_from_raw" | "mysticalagriculture:supremium_ingot_block_uncraft" | "caveopolis:purple_colored_cobblestone_wall" | "mysticalagriculture:seed/reprocessor/water" | "minecraft:pink_terracotta" | "opolisutilities:coal" | "mysticalagriculture:enchanter/swift_sneak" | "minecraft:spire_armor_trim_smithing_template_smithing_trim" | "opolisutilities:soaking_table/wet_sponge" | "caveopolis:orange_colored_sign_from_orange_colored_wooden_planks_stonecutting" | "industrialforegoing:laser_lens_white_recolor" | "thermal:machines/insolator/insolator_amaranth" | "caveopolis:sprayer/glass_block/light_gray" | "caveopolis:green_colored_stone_brick_stairs" | "caveopolis:black_colored_stone_stairs_from_black_colored_stone_stonecutting" | "thermal:machines/smelter/smelter_silver_tools" | "sophisticatedbackpacks:advanced_pump_upgrade" | "caveopolis:magenta_colored_wooden_plank_slab" | "industrialforegoing:fermentation_station" | "caveopolis:sprayer/glass_pane/orange" | "mysticalagradditions:tconstruct/tools/materials/prudentium/ingot" | "thermal:machines/smelter/smelter_copper_plate_to_ingot" | "caveopolis:sprayer/remove_color/cobblestone_stairs" | "minecraft:prismarine_stairs" | "caveopolis:sprayer/candles/lime" | "titanium:test_serializer/saplings_to_sticks" | "mysticalagriculture:stonecutting/soulstone_cobble_slabs_from_soulstone_cobble" | "mysticalagriculture:seed/crafting/fluorite" | "mysticalagradditions:insanium_essence" | "thermal:storage/sugar_cane_block" | "minecraft:white_dye" | "thermal:machine_pyrolyzer" | "thermal:machines/press/unpacking/press_raw_gold_unpacking" | "mysticalagriculture:seed/reprocessor/flux_infused_gem" | "caveopolis:sprayer/colored_stone_buttons/blue" | "thermal:machines/smelter/smelter_constantan_armor" | "caveopolis:yellow_colored_wooden_plank_pressure_plate_from_yellow_colored_wooden_planks_stonecutting" | "caveopolis:light_gray_colored_wooden_plank_fence_gate_from_light_gray_colored_wooden_planks_stonecutting" | "alltheores:platinum_dust_from_hammer_crushing" | "caveopolis:sprayer/colored_wood/green" | "farmersdelight:organic_compost_from_tree_bark" | "caveopolis:sprayer/candles/blue" | "thermal:fuels/stirling/stirling_blaze_powder" | "aquaculture:note_hook" | "minecraft:wild_armor_trim_smithing_template_smithing_trim" | "alltheores:zinc_ingot_from_slate_ore_blasting" | "mysticalagriculture:essence/minecraft/slime_ball" | "caveopolis:pink_colored_cobblestone_slab" | "thermal_extra:smelting/soul_infused_ingot_from_dust_blasting" | "thermal:armor/diving_chestplate" | "minecraft:brown_stained_glass" | "minecraft:tinted_glass" | "alltheores:aluminum_nugget_from_ingot" | "thermal:compat/create/smelter_create_crushed_raw_copper" | "thermal:compat/quark/press_quark_golden_apple_unpacking" | "thermal:storage/sadiroot_block" | "caveopolis:light_blue_colored_hanging_sign_from_stripped_light_blue_colored_log_stonecutting" | "cozy_home:sofa_red_recipe" | "thermal:machines/press/packing3x3/press_nether_wart_packing" | "caveopolis:sprayer/colored_stone_crafting_table/red" | "storagedrawers:max_redstone_upgrade" | "minecraft:lodestone" | "mysticalagriculture:seed/reprocessor/amethyst_bronze" | "thermal:storage/invar_ingot_from_nuggets" | "mysticalagriculture:essence/minecraft/mangrove_log" | "caveopolis:sprayer/stripped_colored_wood/orange" | "minecraft:cut_copper_stairs_from_copper_block_stonecutting" | "mysticalagradditions:insanium_farmland" | "mysticalagriculture:essence/minecraft/tube_coral_fan" | "strainers:blackstone_from_straining_deepslate_in_minecraft_lava" | "farmersdelight:potato_from_crate" | "strainers:summoning_block/witch_redstone" | "caveopolis:sprayer/beds/purple" | "minecraft:stone_stairs" | "alltheores:mek_processing/aluminum/dust/from_ore" | "caveopolis:red_colored_wood" | "thermal:compat/biomesoplenty/insolator_bop_mahogany_sapling" | "minecraft:dried_kelp_block" | "mysticalagriculture:essence/common/silicon" | "thermal:machines/insolator/insolator_pink_tulip" | "minecraft:quartz" | "mysticalagriculture:seed/crafting/nickel" | "thermal:machines/bottler/bottler_white_concrete" | "storagedrawers:acacia_half_drawers_1" | "storagedrawers:acacia_half_drawers_2" | "minecraft:nether_brick_wall" | "storagedrawers:acacia_half_drawers_4" | "thermal:machines/centrifuge/centrifuge_green_wool" | "thermal_extra:smelting/twinite_ingot_from_dust_blasting" | "caveopolis:green_colored_wooden_plank_trapdoor_from_green_colored_wooden_planks_stonecutting" | "suppsquared:candle_holders/gold_candle_holder_light_blue" | "mysticalagriculture:essence/minecraft/soul_sand" | "thermal:compat/biomesoplenty/tree_extractor_bop_willow" | "thermal:compat/immersiveengineering/press_ie_raw_aluminum_packing" | "mysticalagriculture:tertium_block_combine" | "caveopolis:sprayer/colored_stone_brick_stairs/green_colored_stone_brick_stairs" | "thermal:compat/tconstruct/chiller_tconstruct_knightslime_ingot" | "alltheores:silver_ingot_from_raw_blasting" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/white" | "farmersdelight:beef_patty_from_campfire_cooking" | "mysticalagriculture:gear/imperium_sword" | "mysticalagriculture:essence/minecraft/chorus_fruit" | "thermal:compat/mysticalagriculture/insolator_mysticalag_aluminum_seeds" | "supplementaries:candle_holders/candle_holder_magenta_dye" | "mysticalagriculture:essence/minecraft/emerald" | "supplementaries:daub_cross_brace" | "thermal:compat/mekanism/press_mek_uranium_unpacking" | "caveopolis:sprayer/beds/red" | "caveopolis:sprayer/refill/light_gray" | "thermal:machines/pulverizer/pulverizer_raw_gold" | "sophisticatedbackpacks:upgrade_base" | "caveopolis:blue_colored_cobblestone_brick_slab_from_blue_colored_cobblestone_bricks_stonecutting" | "caveopolis:blue_colored_sign_from_blue_colored_wooden_planks_stonecutting" | "thermal:machine_bottler" | "cozy_home:mangrove_plank_recipe" | "thermal:compat/mysticalagriculture/insolator_mysticalag_tungsten_seeds" | "mysticalagriculture:gear/imperium_pickaxe" | "caveopolis:sprayer/colored_saplings/pink" | "thermal:green_bean_pie" | "strainers:sniffer_egg_from_straining_suspicious_gravel_in_minecraft_water" | "strainers:fire_coral_block_from_straining_fire_coral_in_strainers_purified_water_fluid" | "minecraft:orange_dye_from_orange_tulip" | "strainers:podzol_from_straining_grass_block_in_minecraft_water" | "thermal:compat/tconstruct/press_tconstruct_cobalt_nugget_unpacking" | "mysticalagriculture:imperium_gemstone" | "opolisutilities:catalogue/selling/caveopolis/purple_spray_can" | "caveopolis:pink_colored_sign_from_pink_colored_wooden_planks_stonecutting" | "mysticalagriculture:soul_dust_smelted" | "minecraft:blue_carpet" | "thermal:compat/biomesoplenty/insolator_bop_rose_flower" | "thermal:compat/create_ie/smelter_create_ie_crushed_raw_uranium" | "thermal:devices/tree_extractor/tree_extractor_dark_oak" | "oceansdelight:tentacle_on_a_stick" | "cozy_home:table_acacia_recipe" | "caveopolis:cyan_colored_stone_brick_stairs_from_cyan_colored_stone_bricks_stonecutting" | "caveopolis:white_colored_stone_slab_from_white_colored_stone_stonecutting" | "alltheores:silver_gear" | "farmersdelight:barbecue_stick" | "mysticalagriculture:seed/infusion/silicon" | "mysticalagradditions:inferium_paxel" | "mysticalagriculture:gear/awakened_supremium_helmet" | "mysticalagradditions:imperium_coal_block" | "mysticalagriculture:soulium_spawner/cow" | "farmersdelight:stuffed_potato" | "caveopolis:pink_colored_stone_bricks_from_pink_colored_stone_stonecutting" | "mysticalagriculture:seed/reprocessor/bronze" | "thermal:machines/press/press_copper_nugget_to_coin" | "thermal:compat/mysticalagriculture/insolator_mysticalag_coral_seeds" | "systeams:boilers/upgrades/numismatic_downgrade" | "farmersdelight:cooking/rabbit_stew" | "caveopolis:pink_colored_cobblestone_stairs_from_pink_colored_cobblestone_stonecutting" | "mysticalagradditions:tconstruct/tools/materials/soulium/ingot" | "minecraft:cooked_chicken_from_smoking" | "thermal:compat/tconstruct/press_tconstruct_ichor_slime_3x3_packing" | "minecraft:cut_red_sandstone_from_red_sandstone_stonecutting" | "minecraft:waxed_weathered_cut_copper_slab_from_waxed_weathered_copper_stonecutting" | "caveopolis:cobblestone_brick_wall" | "mysticalagriculture:essence/minecraft/mangrove_propagule" | "caveopolis:pink_colored_wooden_plank_fence_gate" | "mysticalagriculture:seed/reprocessor/starmetal" | "caveopolis:sprayer/colored_stone_brick_slab/purple_colored_stone_brick_slab" | "minecraft:dripstone_block" | "minecraft:mangrove_chest_boat" | "caveopolis:light_blue_colored_cobblestone_brick_stairs_from_light_blue_colored_cobblestone_bricks_stonecutting" | "minecraft:iron_hoe" | "minecraft:jungle_hanging_sign" | "mysticalagriculture:seed/infusion/elementium" | "alltheores:platinum_block" | "caveopolis:marble_bricks" | "cozy_home:spruce_plank_recipe" | "alltheores:smelting_dust/tin_ingot" | "thermal:storage/bitumen_block" | "alltheores:iridium_ingot_from_dust" | "caveopolis:sprayer/banners/yellow" | "cozy_home:cherry_mirror_stand_recipe" | "caveopolis:sprayer/colored_stone_brick_slab/light_gray_colored_stone_brick_slab" | "minecraft:jungle_trapdoor" | "industrialforegoing:laser_lens_light_blue_recolor" | "thermal:compat/tconstruct/smelter_alloy_tconstruct_slimesteel_ingot" | "opolisutilities:fragment_from_blasting_deepslate_ender_ore" | "systeams:boilers/stirling" | "caveopolis:purple_colored_wooden_plank_trapdoor_from_purple_colored_wooden_planks_stonecutting" | "nec:caveop_orange_colored_wooden_chest" | "caveopolis:pink_colored_stone_button" | "industrialforegoing:bioreactor" | "caveopolis:sprayer/concrete/cyan" | "storagedrawers:void_upgrade" | "mysticalagriculture:seed/crafting/emerald" | "cozy_home:table_stump_birch_recipe" | "sophisticatedbackpacks:filter_upgrade" | "caveopolis:sprayer/refill/orange" | "thermal:machines/press/press_sadiroot_packing" | "caveopolis:light_blue_colored_wooden_plank_fence_gate" | "caveopolis:light_gray_colored_stone_bricks_from_light_gray_colored_stone_stonecutting" | "mysticalagriculture:seed/crafting/zinc" | "thermal:compat/immersiveengineering/pulverizer_ie_uranium_ore" | "thermal:fuels/gourmand/gourmand_green_bean_block" | "mysticalagriculture:seed/infusion/draconium" | "strainers:upgrades/improved/improved_output_upgrade" | "aquaculture:neptunium_sword" | "minecraft:polished_blackstone_slab_from_polished_blackstone_stonecutting" | "opolisutilities:resource_generator/mods/caveopolis/white_colored_stone" | "thermal:parts/lumium_gear" | "caveopolis:sprayer/shulker_box/magenta" | "opolisutilities:green_wool" | "alltheores:nickel_ingot_from_ore_blasting" | "mysticalagradditions:tconstruct/melting/tertium/nugget" | "minecraft:target" | "mysticalagriculture:essence/minecraft/lime_dye" | "alltheores:tin_ingot_from_ore" | "mysticalagriculture:gear/tertium_sword" | "minecraft:orange_carpet" | "mysticalagriculture:seed/infusion/menril" | "caveopolis:orange_spray_can" | "opolisutilities:resource_generator_2/speed_blocks/uranium" | "cozy_home:counter_cherry_recipe" | "cozy_home:counter_mangrove_storage_recipe" | "industrialforegoing:resourceful_furnace" | "strainers:end_stone_from_straining_netherrack_in_strainers_purified_water_fluid" | "suppsquared:item_shelf_oak" | "igleelib:derium_ingot_from_block" | "lfpirates:sailor_red_tier_1_helmet_recipe_1" | "thermal:storage/hops_block" | "supplementaries:soap/dirty_glass_pane" | "caveopolis:orange_colored_wooden_plank_stairs_from_orange_colored_wooden_planks_stonecutting" | "thermal:machines/pulverizer/pulverizer_tin_ingot_to_dust" | "mysticalagriculture:stonecutting/soulstone_cobble_wall_from_soulstone_cobble" | "storagedrawers:birch_half_drawers_4" | "storagedrawers:birch_half_drawers_2" | "storagedrawers:birch_half_drawers_1" | "tmttd:machines/press/straw_press" | "minecraft:mangrove_slab" | "lfpirates:bone_cutlass_recipe_1" | "farmersdelight:cutting/leather_boots" | "opolisutilities:fishing_rod" | "thermal:compat/tconstruct/press_tconstruct_queens_slime_packing" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/magenta" | "caveopolis:gray_colored_stone" | "caveopolis:sprayer/colored_wooden_plank_slab/red" | "mysticalagriculture:souls/leather" | "alltheores:platinum_gear" | "strainers:pufferfish_from_straining_fishing_rod_in_minecraft_water" | "thermal:armor/diving_leggings" | "supplementaries:bomb" | "caveopolis:sprayer/colored_stone_crafting_table/purple" | "caveopolis:light_blue_colored_stone_slab" | "thermal:machines/press/press_electrum_ingot_to_coin" | "mysticalagriculture:inferium_farmland_till" | "mysticalagriculture:enchanter/loyalty" | "mysticalagriculture:essence/minecraft/mycelium" | "caveopolis:white_colored_cobblestone_brick_slab" | "alltheores:mek_processing/aluminum/shard/from_crystal" | "mysticalagriculture:seed/crafting/dirt" | "minecraft:chiseled_stone_bricks_stone_from_stonecutting" | "mysticalagriculture:soulium_spawner/spider" | "mysticalagriculture:essence/redstone_arsenal/flux_gem" | "mysticalagriculture:seed/infusion/blaze" | "alltheores:mek_processing/iridium/ingot/from_dust_blasting" | "minecraft:netherite_sword_smithing" | "mysticalagriculture:essence/botania/elementium_ingot" | "farmersdelight:rice_bale" | "caveopolis:blue_colored_wooden_plank_fence_gate_from_blue_colored_wooden_planks_stonecutting" | "caveopolis:lime_colored_stone_brick_wall_from_lime_colored_stone_bricks_stonecutting" | "thermal:machines/centrifuge/centrifuge_orange_rockwool" | "mysticalagradditions:insanium_essence_uncraft" | "mysticalagradditions:tconstruct/melting/soulium/block" | "dankstorage:4_to_5" | "thermal:machines/press/press_silver_ingot_to_plate" | "mysticalagriculture:souls/beef" | "thermal:machines/press/packing3x3/press_bronze_nugget_packing" | "lfpirates:pirate_tier_3_body_recipe_1" | "caveopolis:sprayer/shulker_box/pink" | "caveopolis:sprayer/colored_saplings/white" | "thermal:fluid_minecart" | "caveopolis:pink_colored_stone" | "minecraft:magenta_concrete_powder" | "industrialforegoing:mob_duplicator" | "minecraft:red_dye_from_poppy" | "mysticalagriculture:augment/health_boost_ii" | "thermal:storage/gunpowder_from_block" | "thermal:storage/rose_gold_block" | "industrialforegoing:laser_drill_ore/raw_materials/silver" | "supplementaries:sign_post_cherry" | "minecraft:light_blue_candle" | "thermal_extra:machine/press/shellite_nugget_to_coin" | "mysticalagriculture:augment/health_boost_iv" | "mysticalagriculture:awakened_supremium_gemstone_block" | "minecraft:iron_ingot_from_blasting_deepslate_iron_ore" | "suppsquared:item_shelf_birch" | "thermal:potion_quiver" | "caveopolis:gray_colored_wooden_plank_button_from_gray_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/shulker_box/light_blue" | "caveopolis:sprayer/colored_stone_crafting_table/gray" | "minecraft:deepslate_tile_wall_from_deepslate_tiles_stonecutting" | "minecraft:mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting" | "cozy_home:counter_dark_oak_sink_recipe" | "aquamirae:terrible_boots" | "thermal_extra:machine/smelter/twinite_ingot" | "caveopolis:marble_slab_from_marble_stonecutting" | "thermal:rockwool/red_rockwool_from_dye" | "caveopolis:sprayer/colored_wood/white" | "farmersdelight:light_blue_hanging_canvas_sign" | "opolisutilities:resource_generator_2/speed_blocks/tin" | "minecraft:stone_bricks_from_stone_stonecutting" | "caveopolis:light_gray_colored_wooden_plank_fence" | "thermal:machines/pulverizer/pulverizer_red_sandstone_slab" | "mysticalagriculture:enchanter/punch" | "industrialforegoing:laser_lens_orange_recolor" | "opolisutilities:resource_generator_2/speed_blocks/enderium" | "sophisticatedbackpacks:magnet_upgrade" | "dankstorage:1_to_2" | "supplementaries:flags/flag_light_blue" | "thermal:machines/pulverizer/pulverizer_niter" | "thermal:compat/quark/press_quark_stick_packing" | "mysticalagriculture:seed/infusion/compressed_iron" | "mysticalagriculture:seed/reprocessor/limestone" | "minecraft:yellow_banner" | "opolisutilities:resource_generator_2/blocks/tuff" | "mysticalagriculture:essence/minecraft/wither_skeleton_skull" | "thermal:machines/insolator/insolator_bell_pepper" | "thermal:machines/press/press_copper_ingot_to_coin" | "minecraft:purpur_stairs_from_purpur_block_stonecutting" | "minecraft:soul_lantern" | "mysticalagriculture:seed/reprocessor/wither_skeleton" | "alltheores:smelting_dust/osmium_ingot" | "caveopolis:white_colored_stone_stairs" | "thermal:compat/tconstruct/chiller_tconstruct_amethyst_bronze_ingot" | "thermal:storage/sawdust_block" | "caveopolis:sprayer/banners/cyan" | "minecraft:crimson_trapdoor" | "cozy_home:oak_plank_recipe" | "industrialforegoing:conveyor_splitting_upgrade" | "caveopolis:sprayer/colored_stone_brick_stairs/brown_colored_stone_brick_stairs" | "mysticalagriculture:essence/botania/pink_mystical_flower" | "supplementaries:sign_post_oak" | "minecraft:dye_gray_bed" | "minecraft:firework_star_fade" | "farmersdelight:cooked_salmon_slice_from_campfire_cooking" | "caveopolis:magenta_colored_wooden_plank_pressure_plate" | "minecraft:dye_light_gray_bed" | "mysticalagriculture:prudentium_block_uncraft" | "minecraft:bamboo_stairs" | "mysticalagriculture:essence/minecraft/warped_nylium" | "minecraft:smooth_basalt" | "mysticalagriculture:gear/imperium_helmet" | "minecraft:blue_concrete_powder" | "minecraft:blue_stained_glass" | "lfpirates:tenneleather_recipe_1" | "minecraft:iron_ingot_from_smelting_deepslate_iron_ore" | "thermal:machines/press/unpacking/press_copper_nugget_unpacking" | "caveopolis:magenta_colored_stone_brick_stairs" | "thermal:compat/tconstruct/press_tconstruct_slimesteel_packing" | "caveopolis:orange_colored_wood" | "minecraft:chiseled_deepslate_from_cobbled_deepslate_stonecutting" | "mysticalagriculture:gear/inferium_boots" | "storagedrawers:obsidian_storage_upgrade" | "caveopolis:white_colored_sign" | "caveopolis:sprayer/colored_stone_brick_wall/yellow_colored_stone_brick_wall" | "strainers:shelter_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "opolisutilities:resource_generator/mods/caveopolis/pink_colored_stone" | "alltheores:osmium_ingot_from_block" | "farmersdelight:packed_mud_from_straw" | "thermal:watering_can" | "minecraft:blue_candle" | "thermal:smelting/cooked_eggplant_from_smoking" | "thermal:machines/insolator/insolator_melon" | "caveopolis:orange_colored_cobblestone_brick_stairs" | "thermal:machines/press/unpacking/press_rose_gold_unpacking" | "caveopolis:white_colored_cobblestone_brick_stairs_from_white_colored_cobblestone_bricks_stonecutting" | "minecraft:flower_banner_pattern" | "caveopolis:orange_colored_wooden_plank_fence_from_orange_colored_wooden_planks_stonecutting" | "thermal:smelting/lead_ingot_from_dust_smelting" | "thermal:machines/press/unpacking/press_dried_kelp_unpacking" | "mysticalagriculture:essence/tconstruct/rose_gold_ingot" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/yellow" | "caveopolis:green_colored_cobblestone_slab_from_green_colored_cobblestone_stonecutting" | "mysticalagriculture:seed/infusion/gold" | "thermal:machines/centrifuge/centrifuge_lily_of_the_valley" | "minecraft:polished_blackstone_brick_slab_from_polished_blackstone_bricks_stonecutting" | "cozy_home:birch_mirror_recipe" | "thermal:machines/press/press_enderium_ingot_to_gear" | "caveopolis:sprayer/remove_color/colored_stone_brick_wall" | "minecraft:gold_ingot_from_blasting_raw_gold" | "mysticalagriculture:seed/infusion/flux_infused_gem" | "opolisutilities:resource_generator/cobblestone" | "mysticalagriculture:stonecutting/soulstone_bricks_slabs_from_soulstone" | "thermal:machines/insolator/insolator_flax" | "minecraft:cut_red_sandstone_slab_from_red_sandstone_stonecutting" | "minecraft:gold_ingot_from_blasting_gold_ore" | "mysticalagriculture:essence/minecraft/brain_coral_fan" | "caveopolis:yellow_colored_stone_wall" | "thermal:machines/insolator/insolator_glow_lichen" | "thermal:machines/press/packing2x2/press_rich_slag_packing" | "caveopolis:brown_colored_cobblestone_brick_slab" | "caveopolis:sprayer/remove_color/cobblestone_slabs" | "opolisutilities:resource_generator_2/speed_blocks/invar" | "caveopolis:red_spray_can" | "opolisutilities:resource_generator/mods/caveopolis/green_colored_stone" | "supplementaries:cozy_home/sign_post_warped" | "supplementaries:sign_post_warped" | "minecraft:purple_banner" | "thermal:storage/electrum_block" | "cozy_home:lamp_purple_recipe" | "farmersdelight:straw_bale" | "thermal:compat/immersiveengineering/press_ie_raw_uranium_packing" | "caveopolis:cobblestone_brick_stairs_from_cobblestone_bricks_stonecutting" | "caveopolis:green_spray_can" | "caveopolis:light_gray_colored_cobblestone_bricks_from_light_gray_colored_cobblestone_stonecutting" | "industrialforegoing:conveyor_bouncing_upgrade" | "caveopolis:magenta_colored_wooden_planks" | "alltheores:raw_platinum_from_block" | "minecraft:wooden_hoe" | "mysticalagriculture:imperium_block_combine" | "strainers:soul_sand_from_straining_barrier_in_minecraft_lava" | "itemfilters:always_true" | "thermal:machines/press/packing3x3/press_emerald_packing" | "caveopolis:brown_colored_stone_brick_wall" | "farmersdelight:gray_hanging_canvas_sign" | "opolisutilities:resource_generator/mods/caveopolis/purple_colored_stone" | "caveopolis:brown_colored_wood" | "aquamirae:sea_stew" | "thermal:machines/smelter/smelter_apatite_ore" | "mysticalagriculture:essence/extremereactors2/yellorium_ingot" | "mysticalagriculture:seed/crafting/tungsten" | "lfpirates:sailor_red_tier_1_leggins_recipe_1" | "aquaculture:fish_fillet" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/light_gray" | "aquaculture:worm_farm" | "cozy_home:lamp_yellow_recipe" | "minecraft:waxed_oxidized_cut_copper_stairs" | "mysticalagriculture:gear/awakened_supremium_sickle" | "caveopolis:black_colored_cobblestone" | "farmersdelight:cutting/leather_horse_armor" | "industrialforegoing:sludge_refiner" | "mysticalagriculture:seed/reprocessor/refined_glowstone" | "thermal:armor/hazmat_chestplate" | "thermal_extra:machine/smelter/shellite_ingot_from_dust" | "opolisutilities:resource_generator/diorite" | "minecraft:blackstone_stairs_from_blackstone_stonecutting" | "nec:jungle_chest" | "aquaculture:neptunium_chestplate" | "caveopolis:black_colored_cobblestone_wall_from_black_colored_cobblestone_stonecutting" | "minecraft:piston" | "mysticalagriculture:soulium_spawner/squid" | "mysticalagriculture:seed/reprocessor/skeleton" | "caveopolis:sprayer/colored_wooden_plank_slab/cyan" | "mysticalagriculture:prudentium_farmland" | "industrialforegoing:mycelial_netherstar" | "minecraft:white_banner" | "minecraft:smooth_quartz" | "thermal:machines/press/press_lumium_ingot_to_gear" | "thermal:compat/mysticalagriculture/insolator_mysticalag_nature_seeds" | "alltheores:mek_processing/platinum/clump/from_ore" | "minecraft:cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting" | "opolisutilities:resource_generator/dripstone" | "thermal_extra:storage/shellite_ingot_from_block" | "caveopolis:cyan_colored_stone_brick_stairs" | "supplementaries:sign_post_jungle" | "thermal:machines/smelter/smelter_iron_plate_to_ingot" | "caveopolis:green_colored_stone_brick_slab_from_green_colored_stone_bricks_stonecutting" | "thermal:storage/sulfur_block" | "opolisutilities:catalogue/selling/caveopolis/yellow_spray_can" | "thermal:carrot_cake" | "opolisutilities:resource_generator_2/speed_blocks/fence" | "caveopolis:blue_colored_cobblestone" | "farmersdelight:fried_egg_from_campfire_cooking" | "alltheores:signalum_ingot" | "farmersdelight:cutting/oak_log" | "thermal:machines/sawmill/sawmill_jungle_logs" | "itemfilters:block" | "storagedrawers:oak_trim" | "caveopolis:stripped_yellow_colored_wood" | "mysticalagradditions:tconstruct/melting/prudentium/block" | "strainers:strainers/caveopolis/mixed_stone_nugget" | "caveopolis:sprayer/colored_wooden_plank_button/black" | "thermal:smelting/electrum_ingot_from_dust_smelting" | "minecraft:diorite_stairs_from_diorite_stonecutting" | "mysticalagriculture:essence/minecraft/pink_concrete" | "thermal:machines/insolator/insolator_barley" | "thermal:parts/iron_gear" | "mysticalagriculture:enchanter/impaling" | "cozy_home:table_stump_mangrove_recipe" | "thermal:smelting/invar_ingot_from_dust_blasting" | "thermal:storage/rosin_from_block" | "lfpirates:merchant_3_helmet_recipe_1" | "minecraft:green_glazed_terracotta" | "strainers:leather_from_straining_fishing_rod_in_minecraft_water" | "thermal:fuels/stirling/stirling_coal_block" | "caveopolis:sprayer/colored_cobblestone_slab/black_colored_stone_slab" | "supplementaries:blackstone_tile_wall" | "caveopolis:cyan_colored_hanging_sign_from_stripped_cyan_colored_log_stonecutting" | "mysticalagriculture:seed/crafting/blizz" | "thermal:rubberwood_planks" | "caveopolis:purple_colored_cobblestone_slab_from_purple_colored_cobblestone_stonecutting" | "caveopolis:red_colored_cobblestone_wall_from_red_colored_cobblestone_stonecutting" | "caveopolis:sprayer/colored_stone_brick_stairs/red_colored_stone_bricks_brick_stairs" | "thermal:chiller_ball_cast" | "thermal:compat/mysticalagriculture/insolator_mysticalag_sapphire_seeds" | "lfpirates:sailor_gray_tier_3_boody_recipe_1" | "strainers:heart_of_the_sea_from_straining_fishing_rod_in_minecraft_water" | "opolisutilities:drying_table/jerky" | "alltheores:ruby_block" | "alltheores:tools_materials/aluminum/aluminum_from_ingot" | "caveopolis:sprayer/colored_stone_pressure_plate/brown" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/gray" | "caveopolis:light_gray_colored_hanging_sign" | "mysticalagriculture:gear/tertium_leggings" | "farmersdelight:stove" | "caveopolis:sprayer/candles/light_blue" | "caveopolis:brown_colored_cobblestone_slab_from_brown_colored_cobblestone_stonecutting" | "caveopolis:gray_colored_wooden_plank_fence_gate" | "mysticalagriculture:enchanter/multishot" | "thermal:machines/insolator/insolator_moss_block" | "alltheores:mek_processing/zinc/dirty_dust/from_clump" | "thermal:machines/press/press_steel_ingot_to_coin" | "caveopolis:sprayer/candles/white" | "farmersdelight:carrot_crate" | "caveopolis:red_colored_wooden_plank_pressure_plate" | "thermal:smelting/silver_ingot_from_deepslate_ore_smelting" | "minecraft:tipped_arrow" | "minecraft:rib_armor_trim_smithing_template_smithing_trim" | "minecraft:light_blue_carpet" | "caveopolis:pink_colored_stone_brick_wall_from_pink_colored_stone_bricks_stonecutting" | "mysticalagradditions:tconstruct/melting/supremium/nugget" | "mysticalagriculture:seed/crafting/blitz" | "mysticalagradditions:imperium_coal_block_uncraft" | "caveopolis:sprayer/colored_stone_pressure_plate/blue" | "strainers:explorer_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "igleelib:ultimerite_ingot" | "thermal_extra:soul_infused_dust" | "minecraft:gold_ingot_from_smelting_deepslate_gold_ore" | "thermal:machines/insolator/insolator_strawberry" | "thermal:smelting/nickel_ingot_from_raw_blasting" | "thermal:compat/biomesoplenty/insolator_bop_glowflower_flower" | "thermal:machines/chiller/chiller_water_to_snowball" | "thermal:machines/pulverizer/pulverizer_raw_copper" | "caveopolis:sprayer/glass_pane/light_gray" | "thermal:fuels/gourmand/gourmand_carrot_block" | "thermal:parts/rose_gold_gear" | "minecraft:deepslate_tile_slab" | "caveopolis:black_colored_cobblestone_brick_wall_from_black_colored_cobblestone_bricks_stonecutting" | "caveopolis:light_gray_colored_cobblestone_wall_from_light_gray_colored_cobblestone_stonecutting" | "thermal_extra:machine/dynamo/frost/ice_charge" | "opolisutilities:resource_generator_2/speed_blocks/glowstone" | "mysticalagriculture:seed/reprocessor/mystical_flower" | "caveopolis:cyan_colored_stone_brick_wall_from_cyan_colored_stone_bricks_stonecutting" | "mysticalagriculture:enchanter/sharpness" | "thermal:machines/bottler/bottler_mud" | "thermal:storage/lead_block" | "thermal:augments/potion_amplifier_augment" | "industrialforegoing:laser_drill_ore/ores/arcane" | "thermal:device_xp_condenser" | "thermal:smelting/copper_ingot_from_dust_smelting" | "smallships:cherry_cog" | "supplementaries:stonecutting/blackstone_tile_slab" | "caveopolis:light_blue_colored_cobblestone_brick_stairs" | "caveopolis:gray_colored_hanging_sign" | "thermal:compat/mysticalagriculture/insolator_mysticalag_cobalt_seeds" | "alltheores:mek_processing/silver/dust/from_raw_block" | "minecraft:warped_button" | "cozy_home:sofa_white_recipe" | "thermal:compat/create/pulverizer_create_ochrum_recycle" | "thermal:machines/press/unpacking/press_netherite_nugget_unpacking" | "industrialforegoing:laser_drill_ore/ores/bitumen" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/yellow_colored_stone_brick_stairs" | "industrialforegoing:laser_lens_magenta_recolor" | "thermal:compat/biomesoplenty/tree_extractor_bop_rainbow_birch" | "thermal:machines/press/press_bell_pepper_unpacking" | "mysticalagriculture:essence/minecraft/light_gray_concrete" | "caveopolis:yellow_colored_stone_brick_wall" | "thermal:compat/mekanism/press_mek_uranium_packing" | "alltheores:bronze_dust_from_alloy_blending" | "lfpirates:pirate_tier_2_helmet_recipe_1" | "farmersdelight:cutting/dark_oak_door" | "mysticalagriculture:soulium_dagger" | "strainers:fire_coral_from_straining_barrier_in_minecraft_water" | "minecraft:armor_dye" | "thermal:machines/insolator/insolator_sadiroot" | "mysticalagriculture:gear/prudentium_pickaxe" | "storagedrawers:drawer_key" | "mysticalagriculture:gear/awakened_supremium_watering_can" | "caveopolis:green_colored_stone_slab" | "farmersdelight:cutting/mangrove_hanging_sign" | "minecraft:map" | "thermal:machines/press/press_electrum_ingot_to_plate" | "thermal:machines/centrifuge/centrifuge_syrup_bottle" | "minecraft:detector_rail" | "caveopolis:sprayer/colored_cobblestone_slab/pink_colored_stone_slab" | "caveopolis:sprayer/colored_stone_pressure_plate/lime" | "simplehats:hatbag_rare" | "opolisutilities:mini_charcoal" | "caveopolis:sprayer/beds/gray" | "alltheores:copper_nugget_from_ingot" | "supplementaries:daub_frame" | "alltheores:tools_materials/lead/lead_from_nugget" | "cozy_home:sofa_orange_recipe" | "mysticalagriculture:seed/infusion/end_steel" | "mysticalagriculture:soulstone_smelted" | "caveopolis:yellow_colored_cobblestone" | "caveopolis:black_colored_stone_button" | "caveopolis:orange_colored_stone_wall_from_orange_colored_stone_stonecutting" | "thermal:machines/centrifuge/centrifuge_oxeye_daisy" | "thermal:tools/satchel" | "minecraft:crafting_table" | "mysticalagriculture:seed/infusion/wood" | "industrialforegoingsouls:soul_surge" | "thermal_extra:machine/pulverizer/twinite_dust" | "caveopolis:pink_colored_wooden_plank_fence" | "minecraft:green_stained_glass_pane_from_glass_pane" | "thermal:storage/apatite_from_block" | "caveopolis:sprayer/colored_stone_brick_slab/white_colored_stone_brick_slab" | "opolisutilities:resource_generator_2/blocks/cobblestone" | "thermal:devices/tree_extractor/tree_extractor_spruce" | "thermal:machines/bottler/bottler_light_gray_concrete" | "cozy_home:table_birch_recipe" | "caveopolis:sprayer/glazed_terracotta/yellow" | "supplementaries:item_lore" | "smallships:cannon" | "mysticalagriculture:seed/infusion/refined_glowstone" | "minecraft:anvil" | "caveopolis:green_colored_cobblestone" | "igleelib:lavium_ingot" | "caveopolis:sprayer/colored_stone_brick_slab/orange_colored_stone_brick_slab" | "caveopolis:sprayer/colored_stone/green_colored_stone" | "glassential:light_trapdoor" | "caveopolis:black_colored_cobblestone_brick_slab" | "industrialforegoing:black_hole_controller" | "mysticalagriculture:gear/inferium_hoe" | "caveopolis:gray_colored_wooden_plank_crafting_table" | "caveopolis:sprayer/colored_stone/blue_colored_stone" | "caveopolis:yellow_colored_cobblestone_stairs_from_yellow_colored_cobblestone_stonecutting" | "suppsquared:daub_stairs" | "mysticalagriculture:honey_agglomeratio" | "cozy_home:sofa_green_recipe" | "thermal:compat/biomesoplenty/tree_extractor_bop_flowering_oak" | "industrialforegoing:laser_lens_red_recolor" | "industrialforegoing:plant_fertilizer" | "farmersdelight:magenta_hanging_canvas_sign" | "caveopolis:sprayer/colored_cobblestone_wall/brown_colored_stone_wall" | "mysticalagriculture:seed/crafting/titanium" | "caveopolis:gray_colored_stone_pressure_plate_from_gray_colored_stone_stonecutting" | "cozy_home:grandfather_clock_oak_recipe" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/pink_colored_stone_brick_stairs" | "smallships:bamboo_galley" | "mysticalagriculture:inferium_gemstone_block" | "minecraft:black_glazed_terracotta" | "thermal:machines/press/press_spinach_unpacking" | "caveopolis:sprayer/remove_color/wooden_plank_buttons" | "alltheores:uranium_ingot_from_raw" | "libraryferret:crafting_shaped/fake_diamond_block" | "cozy_home:warped_wall_clock_recipe" | "caveopolis:sprayer/banners/light_gray" | "caveopolis:white_colored_cobblestone_brick_stairs" | "cozy_home:sofa_quartz_recipe" | "minecraft:carrot_on_a_stick" | "caveopolis:sprayer/wool/pink_wool" | "cozy_home:birch_wall_clock_recipe" | "cozy_home:counter_crimson_sink_recipe" | "caveopolis:light_blue_colored_cobblestone_slab_from_light_blue_colored_cobblestone_stonecutting" | "thermal:machines/pulverizer/pulverizer_invar_ingot_to_dust" | "thermal:machines/press/packing3x3/press_sawdust_packing" | "thermal:machines/smelter/smelter_copper_dust" | "caveopolis:orange_colored_cobblestone_slab_from_orange_colored_cobblestone_stonecutting" | "alltheores:steel_ingot_from_block" | "caveopolis:blue_colored_cobblestone_slab" | "itemfilters:tag" | "mysticalagriculture:gear/imperium_sickle" | "supplementaries:cage" | "mysticalagriculture:seed/infusion/terrasteel" | "mysticalagriculture:seed/reprocessor/manyullyn" | "strainers:upgrade_stats/everlasting_output_upgrade" | "minecraft:waxed_exposed_cut_copper_stairs_from_waxed_exposed_cut_copper_stonecutting" | "thermal:compat/biomesoplenty/insolator_bop_goldenrod_flower" | "thermal:compat/mysticalagriculture/insolator_mysticalag_creeper_seeds" | "thermal:machines/press/unpacking/press_packed_ice_unpacking" | "oceansdelight:cooked_guardian_tail_from_campfire_cooking" | "lfpirates:fisherman_boots_recipe_1" | "thermal:machines/centrifuge/centrifuge_gray_wool" | "thermal_extra:storage/shellite_nugget_from_ingot" | "farmersdelight:integration/silentgear/cutting/netherwood" | "minecraft:raw_iron_block" | "thermal:machines/crucible/crucible_netherrack_to_lava" | "minecraft:oak_button" | "mysticalagriculture:gear/tertium_watering_can" | "minecraft:dark_oak_hanging_sign" | "storagedrawers:acacia_full_drawers_2" | "storagedrawers:acacia_full_drawers_1" | "mysticalagradditions:nether_star" | "mysticalagriculture:seed/infusion/constantan" | "storagedrawers:acacia_full_drawers_4" | "caveopolis:brown_colored_stone_brick_stairs_from_brown_colored_stone_bricks_stonecutting" | "minecraft:polished_deepslate_wall_from_cobbled_deepslate_stonecutting" | "strainers:meshes/flint" | "oceansdelight:cooked_elder_guardian_slice_from_smoking" | "mysticalagriculture:seed/crafting/flux_infused_gem" | "farmersdelight:milk_bucket_from_bottles" | "aquamirae:divider" | "thermal:machines/pulverizer/pulverizer_netherite_ingot_to_dust" | "aquaculture:bobber" | "alltheores:constantan_ingot_from_dust" | "farmersdelight:cutting/jungle_wood" | "mysticalagriculture:essence/gems/apatite" | "minecraft:waxed_exposed_cut_copper" | "caveopolis:brown_colored_stone_bricks" | "caveopolis:sprayer/stripped_colored_wood/black" | "caveopolis:pink_colored_stone_pressure_plate_from_pink_colored_stone_stonecutting" | "farmersdelight:cutting/cooked_chicken" | "cozy_home:dark_oak_mirror_stand_recipe" | "thermal:machines/press/unpacking/press_bronze_unpacking" | "thermal:machines/press/unpacking/press_tin_nugget_unpacking" | "opolisutilities:resource_generator_2/speed_blocks/copper" | "caveopolis:cyan_colored_stone_wall_from_cyan_colored_stone_stonecutting" | "minecraft:item_frame" | "caveopolis:purple_colored_stone_slab_from_purple_colored_stone_stonecutting" | "minecraft:iron_ingot_from_smelting_iron_ore" | "thermal:compat/dyenamics/bottler_dyenamics_lavender_concrete" | "strainers:snort_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "minecraft:polished_granite_stairs_from_polished_granite_stonecutting" | "mysticalagriculture:gear/imperium_hoe" | "caveopolis:sprayer/colored_cobblestone_bricks/gray_colored_stone_bricks" | "mysticalagriculture:seed/infusion/grains_of_infinity" | "caveopolis:blue_colored_wooden_plank_pressure_plate_from_blue_colored_wooden_planks_stonecutting" | "farmersdelight:egg_sandwich" | "smallships:bamboo_brigg" | "thermal:compat/tconstruct_ie/chiller_tconstruct_ie_aluminum_ingot" | "caveopolis:gray_colored_cobblestone_brick_wall_from_gray_colored_cobblestone_bricks_stonecutting" | "thermal:rubber_3" | "oceansdelight:baked_tentacle_on_a_stick_from_smoking" | "minecraft:pink_dye_from_pink_tulip" | "minecraft:arrow" | "thermal:machines/press/packing3x3/press_netherite_packing" | "storagedrawers:warped_full_drawers_4" | "lfpirates:craftsman_body_recipe_1" | "thermal:machines/insolator/insolator_onion" | "supplementaries:flags/flag_pink" | "caveopolis:sprayer/stripped_colored_wood/green" | "storagedrawers:warped_full_drawers_2" | "thermal:smelting/silver_ingot_from_ore_smelting" | "storagedrawers:warped_full_drawers_1" | "thermal:machines/pulverizer/pulverizer_gold_ore" | "alltheores:brass_dust_from_alloy_blending" | "storagedrawers:dark_oak_full_drawers_4" | "industrialforegoing:fluid_extractor/birch" | "caveopolis:gray_colored_stone_stairs_from_gray_colored_stone_stonecutting" | "storagedrawers:dark_oak_full_drawers_1" | "storagedrawers:dark_oak_full_drawers_2" | "caveopolis:magenta_colored_wooden_plank_button" | "farmersdelight:purple_canvas_sign" | "caveopolis:yellow_colored_stone_button_from_yellow_colored_stone_stonecutting" | "opolisutilities:resource_generator_2/blocks/calcite" | "minecraft:red_sandstone_stairs" | "thermal:compat/quark/press_quark_bonded_leather_unpacking" | "thermal:machines/centrifuge/centrifuge_magma_cream" | "mysticalagriculture:seed/crafting/honey" | "farmersdelight:brown_hanging_canvas_sign" | "caveopolis:sprayer/colored_wood/black" | "thermal:compat/immersiveengineering/press_ie_raw_aluminum_unpacking" | "minecraft:green_wool" | "thermal:compat/tconstruct/press_tconstruct_earth_slime_2x2_unpacking" | "thermal:machines/press/packing3x3/press_bronze_packing" | "supplementaries:flags/flag_green" | "alltheores:nickel_plate" | "thermal:beekeeper_fabric" | "simplehats:hatvariants" | "strainers:bucket_from_straining_lava_bucket_in_minecraft_water" | "mysticalagriculture:soulium_spawner/guardian" | "thermal:machines/bottler/bottler_mossy_stone_bricks" | "mysticalagriculture:enchanter/lure" | "thermal:chiller_ingot_cast" | "caveopolis:cyan_colored_cobblestone_bricks" | "mysticalagriculture:seed/reprocessor/deepslate" | "thermal:fuels/lapidary/lapidary_ruby" | "opolisutilities:resource_generator_2/speed_blocks/sapphire" | "strainers:shelter_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "minecraft:jungle_button" | "thermal:prismarine_rail" | "caveopolis:lime_colored_cobblestone_brick_stairs" | "cozy_home:drawer_dark_oak_recipe" | "mysticalagradditions:tconstruct/tools/materials/tertium/ingot" | "framedcompactdrawers:framed_full_one" | "thermal:machines/smelter/smelter_steel_tools" | "caveopolis:marble_wall" | "strainers:upgrades/sturdy/sturdy_mesh_upgrade" | "mysticalagriculture:seed/crafting/hop_graphite" | "caveopolis:lime_spray_can" | "caveopolis:sprayer/colored_logs/red" | "aquaculture:neptunium_fishing_rod" | "thermal:light_gray_concrete_powder_with_slag" | "caveopolis:lime_colored_cobblestone_stairs" | "caveopolis:sprayer/stripped_colored_wood/white" | "minecraft:waxed_oxidized_copper_from_honeycomb" | "strainers:fire_coral_fan_from_straining_barrier_in_minecraft_water" | "aquamirae:green_dye_from_wisteria" | "minecraft:spruce_trapdoor" | "lfpirates:corsair_tier_2_leggins_recipe_1" | "mysticalagriculture:augment/mining_aoe_i" | "caveopolis:sprayer/colored_stone/orange_colored_stone" | "mysticalagriculture:seed/reprocessor/emerald" | "minecraft:respawn_anchor" | "caveopolis:sprayer/colored_cobblestone/light_blue_colored_stone" | "caveopolis:sprayer/colored_stone_slab/red_colored_stone_slab" | "thermal:compat/create/bottler_create_blaze_cake" | "caveopolis:sprayer/terracotta/light_gray" | "mysticalagriculture:essence/minecraft/tropical_fish" | "thermal:machines/press/packing3x3/press_lead_packing" | "thermal:storage/raw_lead_block" | "cozy_home:warped_chair_recipe" | "caveopolis:magenta_colored_wooden_plank_fence_from_magenta_colored_wooden_planks_stonecutting" | "alltheores:platinum_ingot_from_slate_ore_blasting" | "mysticalagriculture:seed/crafting/bronze" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/lime" | "caveopolis:magenta_colored_wooden_plank_fence_gate_from_magenta_colored_wooden_planks_stonecutting" | "thermal:compat/mysticalagriculture/insolator_mysticalag_hop_graphite_seeds" | "thermal:machines/insolator/insolator_jungle_sapling" | "mysticalagriculture:supremium_block_combine" | "alltheores:signalum_dust_from_alloy_blending" | "thermal:machines/press/packing3x3/press_nickel_packing" | "thermal:green_concrete_powder_with_slag" | "minecraft:dark_prismarine_stairs" | "mysticalagriculture:seed/infusion/spirited_crystal" | "opolisutilities:catalogue/selling/caveopolis/light_blue_spray_can" | "thermal:augments/xp_storage_augment" | "caveopolis:green_colored_stone_stairs_from_green_colored_stone_stonecutting" | "industrialforegoingsouls:soul_network_pipe" | "alltheores:iridium_ingot_from_ore_blasting" | "minecraft:polished_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "caveopolis:sprayer/candles/brown" | "minecraft:snow_block" | "mysticalagriculture:essence/minecraft/white_concrete" | "mysticalagriculture:awakened_supremium_ingot_block" | "supplementaries:treasure_map_recipe" | "minecraft:composter" | "minecraft:sandstone_stairs" | "mysticalagriculture:seed/crafting/invar" | "alltheores:raw_nickel_from_block" | "thermal_extra:augments/rf_coil_storage_augment_3" | "strainers:moss_block_from_straining_mossy_cobblestone_in_strainers_purified_water_fluid" | "thermal_extra:augments/rf_coil_storage_augment_2" | "thermal_extra:augments/rf_coil_storage_augment_1" | "minecraft:coarse_dirt" | "alltheores:signalum_rod" | "caveopolis:pink_colored_wooden_plank_fence_from_pink_colored_wooden_planks_stonecutting" | "thermal:compat/tconstruct/insolator_tconstruct_sky_slime_sapling" | "alltheores:raw_aluminum_block" | "opolisutilities:resource_generator/mods/caveopolis/red_colored_stone" | "farmersdelight:cutting/dark_oak_trapdoor" | "thermal_extra:augments/rf_coil_storage_augment_5" | "thermal_extra:augments/rf_coil_storage_augment_4" | "mysticalagriculture:essence/appliedenergistics2/calculation_press" | "minecraft:prismarine_slab" | "mysticalagriculture:gear/supremium_fishing_rod" | "minecraft:fermented_spider_eye" | "mysticalagriculture:seed/infusion/glowstone" | "minecraft:light_gray_glazed_terracotta" | "lfpirates:pirate_tier_3_leggins_recipe_1" | "mysticalagriculture:augment/health_boost_v" | "caveopolis:lime_colored_wooden_plank_door" | "caveopolis:white_colored_wooden_planks" | "caveopolis:sprayer/colored_stone_brick_wall/magenta_colored_stone_brick_wall" | "mysticalagriculture:blank_record" | "mysticalagriculture:enchanter/mystical_enlightenment" | "mysticalagriculture:augment/health_boost_i" | "supplementaries:flags/flag_black" | "minecraft:gold_ingot_from_gold_block" | "mysticalagriculture:essence/minecraft/gray_concrete" | "caveopolis:blue_colored_cobblestone_brick_wall" | "minecraft:cobbled_deepslate_slab" | "thermal:machines/press/packing3x3/press_apatite_packing" | "thermal:storage/potato_block" | "minecraft:iron_door" | "minecraft:purple_stained_glass_pane" | "strainers:shulker_shell_from_straining_purpur_block_in_strainers_purified_water_fluid" | "strainers:bucket_from_straining_water_bucket_in_minecraft_water" | "caveopolis:magenta_colored_stone_wall_from_magenta_colored_stone_stonecutting" | "caveopolis:sprayer/remove_color/colored_stone_wall" | "caveopolis:blue_colored_stone_wall" | "farmersdelight:cooking/pasta_with_mutton_chop" | "mysticalagriculture:seed/infusion/pig" | "glassential:glass_dark_ethereal" | "cozy_home:oak_wall_clock_recipe" | "minecraft:chiseled_quartz_block" | "thermal:smelting/netherite_ingot_from_dust_blasting" | "industrialforegoing:laser_drill_ore/raw_materials/pyrite" | "mysticalagriculture:seed/reprocessor/fire" | "cofh_core:securable" | "cozy_home:drawer_crimson_recipe" | "thermal:machines/press/press_amaranth_packing" | "caveopolis:sprayer/colored_wooden_plank_button/green" | "alltheores:tools_materials/platinum/platinum_from_ingot" | "mysticalagriculture:essence/common/brass_ingot" | "cozy_home:counter_spruce_sink_recipe" | "industrialforegoing:dissolution_chamber/infinity_saw" | "caveopolis:gray_spray_can" | "thermal:devices/tree_extractor/tree_extractor_boost_compost" | "caveopolis:sprayer/colored_wooden_plank_door/gray" | "alltheores:lead_nugget_from_ingot" | "thermal:machines/press/unpacking/press_nickel_unpacking" | "mysticalagriculture:seed/reprocessor/coral" | "alltheores:mek_processing/aluminum/slurry/dirty" | "lfpirates:merchant_1_boots_recipe_1" | "caveopolis:sprayer/colored_cobblestone_brick_wall/lime_colored_stone_brick_wall" | "mysticalagriculture:enchanter/channeling" | "mysticalagriculture:inferium_gemstone_block_uncraft" | "mysticalagriculture:seed/reprocessor/nether_quartz" | "caveopolis:purple_colored_stone_pressure_plate_from_purple_colored_stone_stonecutting" | "mysticalagriculture:seed/reprocessor/fish" | "thermal:compat/biomesoplenty/insolator_bop_burning_blossom_flower" | "thermal:machines/press/press_enderium_nugget_to_coin" | "caveopolis:cyan_spray_can" | "thermal:machines/press/unpacking/press_constantan_nugget_unpacking" | "thermal:storage/signalum_ingot_from_block" | "thermal:slag_bricks" | "caveopolis:sprayer/concrete/purple" | "alltheores:mek_processing/iridium/dirty_dust/from_clump" | "minecraft:smooth_quartz_stairs" | "alltheores:lead_ingot_from_ore_blasting" | "thermal:spice_cake" | "systeams:boiler_pipe" | "opolisutilities:resource_generator_2/speed_blocks/calorite" | "thermal_extra:machine/dynamo/frost/blue_ice" | "caveopolis:sprayer/remove_color/stone_slabs" | "thermal:storage/bronze_nugget_from_ingot" | "aquamirae:stick_from_oxygelium" | "lfpirates:merchant_1_body_recipe_1" | "caveopolis:green_colored_cobblestone_slab" | "strainers:oxeye_daisy_from_straining_grass_in_strainers_purified_water_fluid" | "mysticalagriculture:seed/infusion/earth" | "mysticalagriculture:essence/minecraft/oak_log" | "minecraft:lime_dye" | "thermal:storage/slag_from_block" | "farmersdelight:cabbage_from_leaves" | "industrialforegoing:laser_drill_ore/ores/ruby" | "minecraft:oak_planks" | "thermal:press_unpacking_die" | "strainers:sculk_catalyst" | "industrialforegoing:diamond_gear" | "minecraft:orange_candle" | "supplementaries:flags/flag_purple" | "industrialforegoing:simple_black_hole_unit" | "thermal:compat/biomesoplenty/insolator_bop_umbran_sapling" | "mysticalagriculture:essence/minecraft/horn_coral_fan" | "caveopolis:gray_colored_wooden_plank_trapdoor" | "caveopolis:orange_colored_wooden_plank_slab_from_orange_colored_wooden_planks_stonecutting" | "thermal_extra:compat/advgenerators/crystallized_sunflower_oil" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/brown" | "minecraft:mangrove_door" | "caveopolis:cyan_colored_stone_bricks_from_cyan_colored_stone_stonecutting" | "alltheores:mek_processing/silver/dust/from_raw_ore" | "caveopolis:orange_colored_wooden_plank_trapdoor_from_orange_colored_wooden_planks_stonecutting" | "caveopolis:brown_colored_wooden_plank_door_from_brown_colored_wooden_planks_stonecutting" | "thermal:compat/mekanism/press_mek_refined_obsidian_packing" | "caveopolis:red_colored_wooden_plank_trapdoor_from_red_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/wool/green_wool" | "mysticalagriculture:essence/minecraft/poisonous_potato" | "thermal:machines/smelter/smelter_sapphire_ore" | "minecraft:stone_brick_wall" | "thermal:storage/constantan_nugget_from_ingot" | "caveopolis:stripped_brown_colored_wood" | "cozy_home:dark_oak_mirror_recipe" | "mysticalagriculture:stonecutting/soulstone_smooth_slabs_from_soulstone_smooth" | "thermal_extra:machine/dynamo/compression/sunflower_oil" | "thermal:smelting/enderium_ingot_from_dust_blasting" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/magenta" | "minecraft:repair_item" | "mysticalagriculture:seed/crafting/mystical_flower" | "mysticalagriculture:prudentium_essence_uncraft" | "aquaculture:neptunium_helmet" | "minecraft:light_blue_dye_from_blue_white_dye" | "thermal:machines/press/packing3x3/press_enderium_nugget_packing" | "thermal:constantan_dust_2" | "minecraft:cyan_dye" | "caveopolis:light_blue_colored_stone_slab_from_light_blue_colored_stone_stonecutting" | "thermal:fire_charge/electrum_ingot_2" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/blue" | "thermal:machines/smelter/smelter_alloy_bronze" | "alltheores:mek_processing/iridium/clump/from_raw_ore" | "thermal:smelting/glowstone_dust_from_spores_smelting" | "opolisutilities:mini_coal" | "caveopolis:sprayer/stripped_colored_logs/gray" | "farmersdelight:bamboo_cabinet" | "minecraft:gold_block" | "minecraft:spruce_boat" | "thermal:smelting/gold_ingot_from_dust_smelting" | "minecraft:cherry_wood" | "thermal:slime_mushroom_spores" | "caveopolis:red_colored_stone_brick_slab" | "caveopolis:brown_colored_cobblestone_stairs_from_brown_colored_cobblestone_stonecutting" | "thermal_extra:machine/dynamo/frost/ice" | "mysticalagriculture:souls/ink_sac" | "caveopolis:sprayer/colored_cobblestone_slab/purple_colored_stone_slab" | "suppsquared:item_shelf_spruce" | "mysticalagriculture:seed/infusion/nature" | "caveopolis:green_colored_stone_bricks" | "thermal:compat/biomesoplenty/insolator_bop_rainbow_birch_sapling" | "minecraft:copper_ingot_from_blasting_raw_copper" | "opolisutilities:resource_generator_2/speed_blocks/end_steel" | "minecraft:cut_red_sandstone_slab" | "caveopolis:light_blue_colored_wooden_plank_button" | "caveopolis:sprayer/colored_stone_wall/yellow_colored_stone_wall" | "farmersdelight:salmon_roll" | "thermal:machines/insolator/insolator_chorus_flower" | "glassential:ethereal_door" | "thermal:compat/biomesoplenty/sawmill_bop_mahogany_logs" | "thermal:compat/redstone_arsenal/press_rsa_flux_gem_packing" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/blue" | "caveopolis:purple_colored_cobblestone_stairs" | "caveopolis:green_colored_wooden_planks" | "thermal:machines/centrifuge/centrifuge_light_gray_wool" | "minecraft:emerald_from_smelting_deepslate_emerald_ore" | "caveopolis:yellow_colored_stone_button" | "mysticalagradditions:tertium_apple" | "thermal:machines/press/packing2x2/press_snow_packing" | "cozy_home:bamboo_bench_recipe" | "cozy_home:lamp_brown_recipe" | "mysticalagriculture:essence/minecraft/vine" | "mysticalagradditions:essence/nitro_crystal" | "caveopolis:light_blue_colored_stone_brick_slab_from_light_blue_colored_stone_bricks_stonecutting" | "thermal:machines/press/packing3x3/press_silver_nugget_packing" | "thermal:machines/press/unpacking/press_apatite_unpacking" | "strainers:red_tulip_from_straining_grass_in_strainers_purified_water_fluid" | "alltheores:nickel_nugget_from_ingot" | "industrialforegoing:manual" | "supplementaries:sconce_lever" | "cozy_home:drawer_oak_recipe" | "thermal:machines/insolator/insolator_blue_orchid" | "minecraft:raw_iron" | "thermal_extra:machine/dynamo/frost/packed_ice" | "minecraft:iron_nugget" | "strainers:tube_coral_block_from_straining_tube_coral_in_strainers_purified_water_fluid" | "caveopolis:pink_colored_cobblestone_brick_slab" | "supplementaries:deepslate_lamp" | "thermal:compat/mysticalagriculture/insolator_mysticalag_steel_seeds" | "farmersdelight:cutting/gravel" | "mysticalagriculture:soulium_gemstone_block" | "minecraft:waxed_oxidized_cut_copper_from_honeycomb" | "caveopolis:sprayer/remove_color/leaves" | "caveopolis:white_colored_wooden_plank_stairs_from_white_colored_wooden_planks_stonecutting" | "caveopolis:cyan_colored_wooden_plank_trapdoor_from_cyan_colored_wooden_planks_stonecutting" | "thermal:compat/mysticalagriculture/insolator_mysticalag_knightmetal_seeds" | "minecraft:nether_wart_block" | "mysticalagriculture:soulium_spawner/enderman" | "minecraft:bamboo_fence_gate" | "thermal:earth_charge/ender_pearl_dust_from_ender_pearl" | "farmersdelight:cooking/baked_cod_stew" | "caveopolis:black_colored_cobblestone_slab_from_black_colored_cobblestone_stonecutting" | "caveopolis:magenta_colored_cobblestone_bricks" | "thermal:machines/centrifuge/centrifuge_cyan_rockwool" | "simplehats:hatdisplay" | "caveopolis:sprayer/colored_logs/orange" | "mysticalagriculture:gear/prudentium_boots" | "industrialforegoing:laser_drill_ore/raw_materials/iron" | "sophisticatedbackpacks:advanced_magnet_upgrade_from_basic" | "farmersdelight:cherry_cabinet" | "industrialforegoing:advanced_black_hole_tank" | "caveopolis:magenta_colored_stone" | "itemfilters:always_false" | "thermal:compat/dyenamics/bottler_dyenamics_aquamarine_concrete" | "caveopolis:magenta_colored_cobblestone_slab" | "alltheores:platinum_ingot_from_slate_ore" | "mysticalagriculture:seed/reprocessor/spirited_crystal" | "mysticalagriculture:seed/crafting/copper_alloy" | "mysticalagriculture:essence/common/silver_ingot" | "caveopolis:sprayer/colored_stone_brick_slab/red_colored_stone_bricks_brick_slab" | "thermal:machines/press/unpacking/press_magma_unpacking" | "farmersdelight:melon_popsicle" | "industrialforegoing:mob_crusher" | "farmersdelight:spruce_cabinet" | "industrialforegoing:dissolution_chamber/processing_addon_1" | "industrialforegoing:dissolution_chamber/processing_addon_2" | "minecraft:dye_light_gray_wool" | "thermal:machines/press/press_bronze_ingot_to_plate" | "thermal:storage/bitumen_from_block" | "alltheores:mek_processing/zinc/slurry/clean" | "minecraft:writable_book" | "thermal:compat/mysticalagriculture/insolator_mysticalag_slime_seeds" | "caveopolis:sprayer/colored_wooden_plank_button/yellow" | "thermal:storage/invar_ingot_from_block" | "thermal:compat/create/smelter_create_raw_zinc" | "supplementaries:candle_holders/candle_holder_yellow_dye" | "thermal:machines/smelter/smelter_cinnabar_ore" | "minecraft:golden_apple" | "mysticalagriculture:seed/reprocessor/rabbit" | "minecraft:diamond_pickaxe" | "thermal:machines/smelter/smelter_tin_ore" | "minecraft:light_gray_dye_from_oxeye_daisy" | "lfpirates:merchant_2_boots_recipe_1" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/lime" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/magenta_colored_stone_brick_stairs" | "caveopolis:red_colored_wooden_plank_button" | "strainers:tube_coral_fan_from_straining_barrier_in_minecraft_water" | "thermal:item_buffer" | "farmersdelight:steak_and_potatoes" | "caveopolis:pink_colored_stone_bricks" | "thermal:fuels/lapidary/lapidary_amethyst" | "thermal:machines/smelter/smelter_raw_copper" | "thermal:compat/biomesoplenty/insolator_bop_white_cherry_sapling" | "alltheores:tools_materials/silver/silver_from_ingot" | "supplementaries:flute" | "thermal:machines/crystallizer/crystallizer_niter" | "supplementaries:stonecutting/ash_brick_stairs_from_bricks" | "caveopolis:sprayer/colored_wooden_plank_slab/black" | "thermal:compat/mysticalagriculture/insolator_mysticalag_fire_seeds" | "strainers:sugar_cane_from_straining_barrier_in_strainers_eroding_water_fluid" | "aquaculture:wooden_fillet_knife" | "thermal:machines/pulverizer/pulverizer_constantan_ingot_to_dust" | "minecraft:polished_blackstone_wall" | "thermal:machines/smelter/smelter_iron_ore" | "farmersdelight:cooking/squid_ink_pasta" | "thermal:machines/press/packing3x3/press_nickel_nugget_packing" | "caveopolis:black_colored_cobblestone_wall" | "minecraft:redstone_from_smelting_redstone_ore" | "mysticalagriculture:augment/tilling_aoe_i" | "thermal:machines/press/packing3x3/press_bitumen_packing" | "farmersdelight:cutting/warped_trapdoor" | "minecraft:suspicious_stew" | "alltheores:gold_plate" | "caveopolis:sprayer/candles/green" | "opolisutilities:catalogue/selling/caveopolis/red_spray_can" | "caveopolis:lime_colored_cobblestone_brick_slab" | "farmersdelight:cutting/oak_wood" | "suppsquared:brass_lantern" | "mysticalagriculture:seed/infusion/titanium" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/red" | "thermal:phyto_tnt_minecart" | "caveopolis:sprayer/colored_wooden_plank_fence/light_blue" | "mysticalagriculture:tertium_ingot_block" | "thermal:machines/centrifuge/centrifuge_constantan_dust" | "mysticalagriculture:seed/reprocessor/zombie" | "caveopolis:sprayer/colored_cobblestone/lime_colored_stone" | "supplementaries:statue" | "minecraft:dye_green_carpet" | "farmersdelight:cutting/spruce_log" | "mysticalagriculture:prismarine_agglomeratio" | "thermal:glowstone_tnt_minecart" | "mysticalagradditions:wither_skeleton_skull" | "thermal:bronze_dust_4" | "thermal:compat/tconstruct/chiller_tconstruct_pigiron_ingot" | "caveopolis:yellow_colored_cobblestone_wall_from_yellow_colored_cobblestone_stonecutting" | "caveopolis:yellow_colored_stone_wall_from_yellow_colored_stone_stonecutting" | "systeams:steam_dynamo" | "thermal:machines/press/unpacking/press_slime_unpacking" | "caveopolis:sprayer/refill/black" | "minecraft:wooden_pickaxe" | "mysticalagriculture:enchanter/piercing" | "mysticalagriculture:essence/minecraft/acacia_log" | "thermal:machines/crucible/crucible_cobblestone_to_lava" | "thermal:machines/press/packing3x3/press_sulfur_packing" | "alltheores:peridot_from_block" | "caveopolis:magenta_colored_stone_bricks_from_magenta_colored_stone_stonecutting" | "suppsquared:metal_frame" | "caveopolis:brown_colored_stone_crafting_table" | "industrialforegoing:laser_drill_ore/raw_materials/tin" | "thermal:machines/bottler/bottler_lime_concrete" | "caveopolis:cyan_colored_stone_pressure_plate_from_cyan_colored_stone_stonecutting" | "caveopolis:sprayer/stripped_colored_wood/pink" | "thermal:compat/mysticalagriculture/insolator_mysticalag_mithril_seeds" | "mysticalagriculture:seed/crafting/cobalt" | "supplementaries:pancake" | "thermal:fuels/gourmand/gourmand_bell_pepper_block" | "alltheores:bronze_plate" | "minecraft:stick_from_bamboo_item" | "caveopolis:sprayer/colored_wooden_plank_fence/blue" | "alltheores:iridium_ingot_from_ore" | "caveopolis:sprayer/colored_stone_slab/light_gray_colored_stone_slab" | "minecraft:diamond_from_blasting_diamond_ore" | "mysticalagriculture:essence/minecraft/music_disc_strad" | "mysticalagriculture:awakened_supremium_gemstone_block_uncraft" | "caveopolis:sprayer/colored_cobblestone_brick_wall/red_colored_stone_bricks_brick_wall" | "aquaculture:tin_can_to_iron_nugget" | "thermal:machines/press/unpacking/press_silver_unpacking" | "alltheores:enderium_plate" | "alltheores:mek_processing/zinc/clump/from_raw_block" | "mysticalagriculture:essence/minecraft/crimson_stem" | "alltheores:invar_block" | "thermal:machines/press/press_invar_ingot_to_gear" | "industrialforegoing:mycelial_slimey" | "caveopolis:purple_colored_stone_brick_stairs_from_purple_colored_stone_bricks_stonecutting" | "caveopolis:magenta_colored_hanging_sign" | "caveopolis:sprayer/colored_stone_brick_slab/cyan_colored_stone_brick_slab" | "cozy_home:counter_cherry_sink_recipe" | "minecraft:end_stone_brick_stairs" | "minecraft:stripped_crimson_hyphae" | "minecraft:cyan_carpet" | "caveopolis:sprayer/colored_wooden_plank_fence/brown" | "thermal:machines/centrifuge/centrifuge_light_blue_wool" | "minecraft:polished_deepslate_stairs_from_polished_deepslate_stonecutting" | "alltheores:raw_iridium_block" | "mysticalagriculture:seed/infusion/sheep" | "alltheores:platinum_ingot_from_block" | "thermal:machines/smelter/smelter_constantan_plate_to_ingot" | "supplementaries:cozy_home/sign_post_crimson" | "thermal:machines/press/press_strawberry_unpacking" | "alltheores:zinc_ingot_from_ore" | "minecraft:smooth_sandstone_stairs_from_smooth_sandstone_stonecutting" | "lfpirates:deckhand_boots_recipe_1" | "minecraft:cyan_terracotta" | "mysticalagriculture:essence/minecraft/bone" | "mysticalagriculture:seed/crafting/osmium" | "thermal:devices/rock_gen/rock_gen_cobblestone" | "minecraft:mangrove_fence" | "minecraft:polished_deepslate_from_cobbled_deepslate_stonecutting" | "mysticalagradditions:tconstruct/tools/materials/imperium/block" | "supplementaries:stool_from_feather_block" | "thermal:smelting/nickel_ingot_from_deepslate_ore_blasting" | "caveopolis:sprayer/glazed_terracotta/red" | "mysticalagriculture:seed/reprocessor/fluorite" | "minecraft:light_gray_bed" | "thermal_extra:machine/brewer/crystallized_sunflower_oil" | "caveopolis:red_colored_cobblestone_brick_wall_from_red_colored_cobblestone_bricks_stonecutting" | "caveopolis:brown_colored_stone_wall" | "opolisutilities:home_stone" | "caveopolis:blue_colored_stone_bricks_from_blue_colored_stone_stonecutting" | "caveopolis:sprayer/colored_cobblestone_wall/black_colored_stone_wall" | "thermal:machine_sawmill" | "alltheores:mek_processing/zinc/slurry/from_raw_ore" | "minecraft:black_stained_glass_pane" | "luggage:ender_luggage" | "thermal:compat/mysticalagriculture/insolator_mysticalag_copper_seeds" | "alltheores:constantan_block" | "mysticalagriculture:essence/enderio/conductive_alloy_ingot" | "mysticalagriculture:seed/crafting/redstone_alloy" | "caveopolis:sprayer/candles/yellow" | "thermal_extra:smelting/dragonsteel_ingot_from_dust_smelting" | "melongolem:melonstick" | "caveopolis:sprayer/colored_cobblestone_slab/lime_colored_stone_slab" | "minecraft:spruce_chest_boat" | "lfpirates:merchant_2_helmet_recipe_1" | "caveopolis:purple_colored_cobblestone_stairs_from_purple_colored_cobblestone_stonecutting" | "industrialforegoing:laser_drill_ore/raw_materials/iridium" | "caveopolis:sprayer/colored_leaves/magenta" | "mysticalagriculture:seed/infusion/refined_obsidian" | "strainers:upgrades/reinforced/reinforced_everything_upgrade" | "suppsquared:item_shelf_mangrove" | "minecraft:golden_axe" | "thermal:compat/mysticalagriculture/insolator_mysticalag_steeleaf_seeds" | "storagedrawers:dark_oak_trim" | "thermal:fuels/lapidary/lapidary_sapphire" | "caveopolis:light_gray_colored_stone_button" | "caveopolis:sprayer/colored_cobblestone_stairs/magenta_colored_stone_stairs" | "farmersdelight:sweet_berry_cheesecake_from_slices" | "thermal:storage/silver_ingot_from_nuggets" | "opolisutilities:resource_generator/granite" | "mysticalagriculture:seed/crafting/zombie" | "caveopolis:sprayer/colored_wooden_plank_stairs/lime" | "caveopolis:gray_colored_cobblestone_slab" | "mysticalagriculture:augment/haste_ii" | "strainers:pumpkin_seeds_from_straining_mulch_in_minecraft_water" | "thermal:compat/mysticalagriculture/insolator_mysticalag_iridium_seeds" | "alltheores:tin_ingot_from_ore_blasting" | "mysticalagriculture:essence/botania/yellow_mystical_flower" | "thermal:storage/lead_ingot_from_nuggets" | "thermal:underwater_minecart" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/light_blue" | "mysticalagriculture:soulstone_cobble_wall" | "supplementaries:ash_brick_stairs" | "thermal:machine_brewer" | "mysticalagriculture:seed/crafting/conductive_alloy" | "minecraft:snow" | "caveopolis:purple_colored_stone_wall_from_purple_colored_stone_stonecutting" | "systeams:boilers/upgrades/lapidary_downgrade" | "cozy_home:sofa_light_blue_recipe" | "mysticalagriculture:inferium_farmland" | "caveopolis:sprayer/shulker_box/gray" | "thermal:earth_charge/sulfur_dust_from_sulfur" | "mysticalagradditions:insanium_ingot_recraft" | "thermal:machines/insolator/insolator_white_tulip" | "thermal_extra:compat/advgenerators/refined_sunflower_oil" | "thermal:machines/smelter/smelter_alloy_steel" | "caveopolis:sprayer/colored_stone_brick_slab/light_blue_colored_stone_brick_slab" | "caveopolis:yellow_colored_stone" | "caveopolis:light_gray_colored_wooden_plank_slab_from_light_gray_colored_wooden_planks_stonecutting" | "minecraft:blackstone_wall_from_blackstone_stonecutting" | "mysticalagriculture:augment/pathing_aoe_iv" | "farmersdelight:cutting/azure_bluet" | "thermal:devices/fisher/fisher_boost_junk_net" | "alltheores:bronze_rod" | "thermal:machines/press/packing2x2/press_nether_bricks_packing" | "mysticalagriculture:gear/inferium_chestplate" | "mysticalagriculture:augment/pathing_aoe_ii" | "farmersdelight:integration/create/milling/wild_carrots" | "industrialforegoing:washing_factory" | "sophisticatedcore:upgrade_clear" | "alltheores:aluminum_gear" | "minecraft:emerald_from_smelting_emerald_ore" | "mysticalagriculture:essence/minecraft/sugar_cane" | "mysticalagriculture:essence/minecraft/pumpkin" | "caveopolis:light_blue_colored_cobblestone_stairs_from_light_blue_colored_cobblestone_stonecutting" | "caveopolis:sprayer/colored_stone_crafting_table/cyan" | "alltheores:brass_block" | "opolisutilities:resource_generator_2/speed_blocks/amethyst" | "caveopolis:sprayer/colored_wooden_plank_stairs/blue" | "industrialforegoing:dissolution_chamber/supreme_machine_frame" | "mysticalagriculture:seed/crafting/ice" | "farmersdelight:integration/immersiveengineering/crusher/rice_panicle" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/yellow" | "caveopolis:cyan_colored_wooden_plank_pressure_plate" | "caveopolis:light_gray_colored_stone_crafting_table" | "suppsquared:daub_slab" | "aquamirae:terrible_helmet" | "farmersdelight:mixed_salad" | "thermal:rubberwood_sign" | "farmersdelight:cutting/chicken" | "mysticalagriculture:seed/infusion/awakened_draconium" | "thermal:storage/silver_block" | "farmersdelight:cutting/cooked_cod" | "mysticalagradditions:neutronium_crux" | "strainers:upgrades/everlasting/everlasting_duration_upgrade" | "caveopolis:stripped_orange_colored_wood" | "minecraft:white_concrete_powder" | "supplementaries:ash_soot" | "minecraft:yellow_terracotta" | "thermal:compat/tconstruct/press_tconstruct_amethyst_bronze_nugget_unpacking" | "alltheores:osmium_ingot_from_slate_ore" | "caveopolis:orange_colored_wooden_plank_trapdoor" | "mysticalagriculture:seed/crafting/rabbit" | "sophisticatedbackpacks:blasting_upgrade" | "minecraft:cherry_boat" | "caveopolis:sprayer/remove_color/stripped_logs" | "minecraft:chiseled_nether_bricks_from_nether_bricks_stonecutting" | "aquaculture:cooked_fish_fillet_from_campfire" | "mysticalagriculture:seed/crafting/skeleton" | "alltheores:mek_processing/silver/clump/from_raw_ore" | "thermal:machines/press/press_lead_nugget_to_coin" | "mysticalagriculture:seed/reprocessor/nitro_crystal" | "suppsquared:item_shelf_crimson" | "caveopolis:magenta_colored_cobblestone_brick_wall_from_magenta_colored_cobblestone_bricks_stonecutting" | "opolisutilities:resource_generator_2/speed_blocks/ostrum" | "cozy_home:grandfather_clock_quartz_recipe" | "thermal:machines/press/packing3x3/press_raw_gold_packing" | "tmttd:machines/press/glowberry_crate_press" | "caveopolis:green_colored_cobblestone_bricks_from_green_colored_cobblestone_stonecutting" | "thermal:machines/smelter/smelter_gravel" | "alltheores:lumium_ingot_from_block" | "minecraft:barrel" | "thermal:machines/press/unpacking/press_invar_unpacking" | "supplementaries:boat_jar" | "thermal:machines/pulverizer/pulverizer_iron_ore" | "mysticalagriculture:seed/crafting/spirited_crystal" | "strainers:jungle_sapling_from_straining_barrier_in_minecraft_air" | "thermal:compat/immersiveengineering/press_ie_uranium_nugget_packing" | "farmersdelight:cutting/wild_onions" | "aquaculture:golden_fishing_rod" | "nec:caveop_cyan_colored_wooden_chest" | "thermal:smelting/tin_ingot_from_ore_blasting" | "thermal:compat/mekanism/press_mek_raw_osmium_unpacking" | "caveopolis:brown_spray_can" | "thermal:rockwool/cyan_rockwool_from_dye" | "minecraft:deepslate_brick_slab_from_polished_deepslate_stonecutting" | "thermal:storage/tin_block" | "caveopolis:brown_colored_wooden_plank_fence_gate" | "thermal:compat/biomesoplenty/insolator_bop_lavender_flower" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/blue_colored_stone_brick_stairs" | "caveopolis:blue_colored_sign" | "thermal:machines/centrifuge/centrifuge_allium" | "chipped:benches/mechanist_workbench" | "thermal:compat/mekanism/press_mek_refined_glowstone_unpacking" | "thermal:storage/raw_silver_block" | "mysticalagriculture:soulium_seed_base" | "caveopolis:sprayer/colored_wooden_plank_button/pink" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/purple" | "mysticalagriculture:inferium_block" | "minecraft:smithing_table" | "minecraft:dye_gray_carpet" | "minecraft:deepslate_tile_slab_from_polished_deepslate_stonecutting" | "mysticalagriculture:seed/reprocessor/slime" | "thermal:storage/tin_nugget_from_ingot" | "mysticalagriculture:gear/awakened_supremium_crossbow" | "mysticalagriculture:essence/minecraft/spruce_sapling" | "thermal_extra:augments/dynamo_output_augment_4" | "minecraft:shaper_armor_trim_smithing_template" | "thermal_extra:augments/dynamo_output_augment_3" | "thermal_extra:augments/dynamo_output_augment_2" | "thermal_extra:augments/dynamo_output_augment_1" | "supplementaries:lapis_bricks" | "minecraft:cauldron" | "mysticalagriculture:seed/reprocessor/fluix" | "caveopolis:sprayer/colored_stone_bricks/red_colored_stone_bricks_bricks" | "caveopolis:green_colored_cobblestone_wall_from_green_colored_cobblestone_stonecutting" | "opolisutilities:resource_generator_2/speed_blocks/emerald" | "minecraft:waxed_weathered_cut_copper_slab_from_honeycomb" | "caveopolis:red_colored_wooden_plank_slab" | "thermal:storage/enderium_ingot_from_block" | "alltheores:brass_ingot_from_dust" | "thermal:machines/press/unpacking/press_amethyst_unpacking" | "thermal:machines/pulverizer/pulverizer_red_sandstone" | "cozy_home:table_mangrove_recipe" | "minecraft:cobblestone_slab" | "sophisticatedbackpacks:refill_upgrade" | "supplementaries:faucet" | "minecraft:gold_ingot_from_smelting_gold_ore" | "caveopolis:sprayer/colored_stone_slab/black_colored_stone_slab" | "supplementaries:candle_holders/candle_holder_lime_dye" | "minecraft:popped_chorus_fruit" | "caveopolis:sprayer/colored_stone_pressure_plate/light_blue" | "caveopolis:sprayer/colored_stone_wall/brown_colored_stone_wall" | "mysticalagriculture:seed/reprocessor/conductive_alloy" | "caveopolis:mixed_stone_ingot_from_smelting_raw_mixed_stone" | "minecraft:shaper_armor_trim_smithing_template_smithing_trim" | "thermal:smelting/gunpowder_from_spores_smelting" | "mysticalagriculture:essence/minecraft/pink_dye" | "mysticalagriculture:essence/chisel/limestone" | "thermal:compat/tconstruct/press_tconstruct_ichor_slime_2x2_packing" | "minecraft:chest" | "minecraft:gray_stained_glass" | "supplementaries:pulley" | "aquaculture:light_hook" | "alltheores:mek_processing/iridium/ore/nether_from_raw" | "nec:caveop_magenta_colored_wooden_chest" | "caveopolis:sprayer/colored_wooden_plank_stairs/light_blue" | "theoneprobe:gold_helmet_probe" | "minecraft:creeper_banner_pattern" | "caveopolis:sprayer/beds/magenta" | "alltheores:silver_ingot_from_block" | "minecraft:red_bed" | "caveopolis:sprayer/beds/light_gray" | "mysticalagriculture:essence/minecraft/warped_fungus" | "mysticalagriculture:seed/infusion/fluorite" | "strainers:pointed_dripstone_from_straining_stone_in_minecraft_water" | "mysticalagriculture:essence/minecraft/ice" | "minecraft:dye_gray_wool" | "minecraft:deepslate_bricks_from_cobbled_deepslate_stonecutting" | "mysticalagriculture:gear/inferium_scythe" | "thermal:machines/insolator/insolator_sugar_cane" | "thermal:machines/insolator/insolator_brain_coral_fan" | "mysticalagriculture:augment/nausea_resistance" | "alltheores:silver_ingot_from_slate_ore" | "mysticalagriculture:stonecutting/soulstone_chiseled_bricks_from_soulstone" | "thermal:compat/quark/press_quark_bonded_rabbit_hide_unpacking" | "mysticalagriculture:essence/enderio/redstone_alloy_ingot" | "thermal:rockwool/brown_rockwool_from_dye" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/lime" | "mysticalagradditions:tconstruct/casting/inferium/nugget_gold_cast" | "thermal:storage/bronze_block" | "farmersdelight:cooked_cod_slice_from_campfire_cooking" | "minecraft:end_stone_brick_slab_from_end_stone_stonecutting" | "industrialforegoing:water_condensator" | "mysticalagriculture:essence/extremereactors2/cyanite_ingot" | "thermal:machines/pulverizer/pulverizer_silver_ingot_to_dust" | "caveopolis:pink_colored_wooden_planks" | "thermal:machines/insolator/insolator_glow_berries" | "thermal:lumium_dust_4" | "opolisutilities:resource_generator/deepslate" | "thermal:jelly" | "caveopolis:magenta_colored_cobblestone_brick_stairs" | "minecraft:iron_boots" | "mysticalagriculture:essence/botania/magenta_mystical_flower" | "thermal:compat/biomesoplenty/tree_extractor_bop_redwood" | "mysticalagradditions:tconstruct/casting/imperium/ingot_gold_cast" | "smallships:dark_oak_brigg" | "oceansdelight:cutting/elder_guardian_slab" | "minecraft:golden_chestplate" | "thermal:machines/pulverizer/pulverizer_bronze_plate_to_dust" | "mysticalagradditions:supremium_apple" | "caveopolis:sprayer/colored_stone_brick_wall/brown_colored_stone_brick_wall" | "sophisticatedbackpacks:chipped/carpenters_table_upgrade" | "thermal:compat/mysticalagriculture/insolator_mysticalag_invar_seeds" | "minecraft:copper_ingot_from_smelting_raw_copper" | "caveopolis:yellow_colored_stone_brick_stairs" | "farmersdelight:integration/create/filling/chocolate_pie" | "thermal:parts/electrum_gear" | "mysticalagradditions:nether_prosperity_shard_smelted" | "minecraft:netherite_ingot" | "farmersdelight:warped_cabinet" | "strainers:purifying_salt_mulch" | "lfpirates:merchant_2_body_recipe_1" | "mysticalagriculture:seed/reprocessor/osmium" | "mysticalagriculture:awakened_supremium_block_uncraft" | "mysticalagriculture:essence/minecraft/jungle_log" | "strainers:summoning_block/ghast" | "caveopolis:sprayer/remove_color/shulker_box" | "mysticalagriculture:tertium_ingot_recraft" | "lfpirates:deckhand_body_recipe_1" | "duckling:cooked_duck_from_campfire_cooking" | "thermal:compat/mysticalagriculture/insolator_mysticalag_sheep_seeds" | "opolisutilities:fluid_generator" | "thermal:machines/press/packing3x3/press_netherite_nugget_packing" | "thermal:devices/tree_extractor/tree_extractor_boost_bone_meal" | "alltheores:aluminum_rod" | "minecraft:light_blue_terracotta" | "cozy_home:table_stump_jungle_recipe" | "minecraft:spruce_stairs" | "thermal:compat/mysticalagriculture/insolator_mysticalag_wither_skeleton_seeds" | "sophisticatedbackpacks:auto_blasting_upgrade_from_auto_smelting_upgrade" | "thermal:machines/centrifuge/centrifuge_black_rockwool" | "minecraft:jungle_sign" | "minecraft:cyan_candle" | "mysticalagriculture:imperium_ingot" | "lfpirates:craftsman_helmet_recipe_1" | "alltheores:enderium_dust_from_alloy_blending" | "alltheores:mek_processing/platinum/shard/from_raw_ore" | "minecraft:light_gray_dye_from_white_tulip" | "caveopolis:red_colored_stone_brick_stairs" | "opolisutilities:sticks" | "mysticalagradditions:tconstruct/casting/soulium/block" | "thermal:machines/press/packing3x3/press_lumium_nugget_packing" | "caveopolis:sprayer/colored_stone_wall/black_colored_stone_wall" | "thermal:device_fisher" | "mysticalagriculture:seed/crafting/wood" | "lfpirates:sailor_gray_tier_1_helmet_recipe_1" | "mysticalagradditions:prudentium_coal_block" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/blue" | "thermal:fuels/stirling/stirling_coal_coke" | "lfpirates:pirate_tier_3_helmet_recipe_1" | "sophisticatedbackpacks:deposit_upgrade" | "minecraft:light_gray_dye_from_black_white_dye" | "caveopolis:pink_colored_cobblestone_brick_stairs" | "caveopolis:sprayer/colored_stone_wall/lime_colored_stone_wall" | "thermal:devices/rock_gen/rock_gen_stone" | "sophisticatedbackpacks:blasting_upgrade_from_smelting_upgrade" | "minecraft:slime_block" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/purple" | "caveopolis:light_blue_colored_wooden_plank_crafting_table" | "caveopolis:cyan_colored_stone" | "thermal_extra:machine/crystallizer/dragonsteel_infused_fluid_tank_augment" | "thermal:storage/rubber_block" | "minecraft:cooked_rabbit_from_campfire_cooking" | "thermal:storage/coal_coke_block" | "cozy_home:warped_mirror_recipe" | "thermal:podzol_crafting" | "cozy_home:table_jungle_recipe" | "minecraft:mud_bricks" | "thermal:compat/dyenamics/bottler_dyenamics_bubblegum_concrete" | "cozy_home:desk_jungle_recipe" | "minecraft:netherite_upgrade_smithing_template" | "alltheores:uranium_ingot_from_block" | "caveopolis:sprayer/banners/gray" | "alltheores:aluminum_ingot_from_ore" | "thermal:prismarine_activator_rail" | "lfpirates:fisherman_body_recipe_1" | "tmttd:machines/press/cocoabeans_bag_press" | "thermal:machines/insolator/insolator_azure_bluet" | "minecraft:mud_brick_stairs_from_mud_bricks_stonecutting" | "thermal_extra:storage/dragonsteel_ingot_from_block" | "mysticalagriculture:augment/slow_falling" | "lfpirates:deckhand_leggins_recipe_1" | "mysticalagradditions:insanium_farmland_till" | "mysticalagriculture:seed/reprocessor/hepatizon" | "caveopolis:sprayer/colored_stone_wall/cyan_colored_stone_wall" | "caveopolis:gray_colored_cobblestone_bricks_from_gray_colored_cobblestone_stonecutting" | "caveopolis:sprayer/colored_wooden_plank_slab/green" | "caveopolis:lime_colored_wooden_plank_slab" | "mysticalagriculture:gear/awakened_supremium_pickaxe" | "thermal:devices/tree_extractor/tree_extractor_rubberwood" | "caveopolis:sprayer/colored_wooden_plank_door/magenta" | "minecraft:light_gray_carpet" | "caveopolis:gray_colored_stone_slab" | "minecraft:magenta_stained_glass_pane_from_glass_pane" | "minecraft:smooth_sandstone" | "mysticalagradditions:tconstruct/melting/soulium/nugget" | "mysticalagriculture:seed/reprocessor/stone" | "strainers:basalt_from_straining_deepslate_in_minecraft_lava" | "caveopolis:sprayer/colored_cobblestone_brick_slab/red" | "alltheores:copper_rod" | "thermal:machines/insolator/insolator_redstone_mushroom" | "strainers:suspicious_gravel_from_straining_suspicious_stew_in_minecraft_gravel" | "aquaculture:cooked_fish_fillet_from_smoking" | "caveopolis:sprayer/colored_stone_stairs/lime_colored_stone_stairs" | "aquamirae:whisper_of_the_abyss" | "minecraft:diorite_wall" | "caveopolis:green_colored_stone_button_from_green_colored_stone_stonecutting" | "minecraft:spruce_planks" | "farmersdelight:cutting/dark_oak_hanging_sign" | "caveopolis:cyan_colored_wooden_plank_door" | "caveopolis:gray_colored_cobblestone_stairs" | "aquaculture:cooked_fish_fillet" | "strainers:bubble_coral_fan_from_straining_barrier_in_minecraft_water" | "thermal:machines/press/unpacking/press_rosin_unpacking" | "minecraft:polished_blackstone_bricks" | "caveopolis:black_colored_stone_bricks" | "minecraft:mossy_cobblestone_from_moss_block" | "caveopolis:magenta_colored_stone_brick_slab_from_magenta_colored_stone_bricks_stonecutting" | "thermal:machines/press/packing2x2/press_amethyst_packing" | "caveopolis:sprayer/colored_stone_stairs/magenta_colored_stone_stairs" | "thermal:machines/pulverizer/pulverizer_iron_ingot_to_dust" | "supplementaries:rope" | "minecraft:lantern" | "caveopolis:sprayer/refill/lime" | "minecraft:waxed_cut_copper_slab_from_waxed_copper_block_stonecutting" | "thermal:compat/create/press_create_brass_nugget_packing" | "thermal:compat/mysticalagriculture/insolator_mysticalag_draconium_seeds" | "mysticalagriculture:essence/minecraft/white_dye" | "caveopolis:black_colored_wooden_plank_stairs" | "mysticalagriculture:essence/appliedenergistics2/silicon_press" | "mysticalagriculture:supremium_ingot" | "caveopolis:lime_colored_stone_crafting_table" | "minecraft:deepslate_brick_wall" | "thermal:machines/press/unpacking/press_electrum_unpacking" | "cozy_home:counter_mangrove_recipe" | "thermal:compat/mekanism/pulverizer_mek_fluorite" | "caveopolis:sprayer/remove_color/logs" | "alltheores:silver_ingot_from_raw" | "caveopolis:black_spray_can" | "opolisutilities:resource_generator_2/blocks/basalt" | "thermal:machines/pulverizer/pulverizer_copper_ingot_to_dust" | "mysticalagradditions:tconstruct/casting/prudentium/nugget_gold_cast" | "alltheores:iridium_rod" | "thermal:machines/insolator/insolator_lily_of_the_valley" | "minecraft:lime_bed" | "caveopolis:black_colored_wooden_plank_pressure_plate_from_black_colored_wooden_planks_stonecutting" | "farmersdelight:rice_from_bag" | "caveopolis:sprayer/colored_saplings/light_gray" | "industrialforegoing:biofuel_generator" | "supplementaries:soap_block_uncrafting" | "thermal:storage/nickel_ingot_from_block" | "titanium:test_serializer/dirt_to_used" | "thermal:compat/biomesoplenty/sawmill_bop_jacaranda_logs" | "glassential:glass_redstone" | "thermal:earth_charge/apatite_dust_from_apatite" | "caveopolis:light_gray_colored_stone_wall_from_light_gray_colored_stone_stonecutting" | "thermal:machines/crucible/crucible_honey_block_to_honey" | "lfpirates:merchant_1_leggins_recipe_1" | "mysticalagradditions:tconstruct/tools/casting/imperium" | "thermal:machines/insolator/insolator_sweet_berries" | "mysticalagriculture:seed/reprocessor/copper_alloy" | "thermal_extra:augments/potion_amplifier_augment_5" | "caveopolis:red_colored_stone_wall" | "thermal_extra:augments/potion_amplifier_augment_3" | "thermal_extra:augments/potion_amplifier_augment_4" | "farmersdelight:flint_knife" | "minecraft:cherry_chest_boat" | "mysticalagriculture:augment/haste_iii" | "alltheores:mek_processing/nickel/slurry/clean" | "thermal:purple_concrete_powder_with_slag" | "thermal_extra:augments/potion_amplifier_augment_1" | "thermal:machines/press/press_radish_packing" | "thermal_extra:augments/potion_amplifier_augment_2" | "smallships:cherry_brigg" | "mysticalagriculture:essence/enderio/energetic_alloy_ingot" | "mysticalagriculture:essence/minecraft/tube_coral_block" | "caveopolis:sprayer/colored_stone_crafting_table/light_gray" | "caveopolis:sprayer/wool/red_wool" | "thermal:tools/rf_potato" | "thermal:parts/copper_gear" | "alltheores:mek_processing/silver/slurry/dirty" | "strainers:emerald_from_straining_deepslate_in_minecraft_water" | "strainers:howl_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "caveopolis:purple_colored_cobblestone_brick_wall" | "alltheores:steel_nugget_from_ingot" | "mysticalagriculture:soulium_spawner/bee" | "caveopolis:sprayer/colored_wood/purple" | "suppsquared:item_shelf_acacia" | "alltheores:aluminum_plate" | "minecraft:magenta_dye_from_purple_and_pink" | "aquaculture:gold_nugget_from_blasting" | "opolisutilities:resource_generator_2/speed_blocks/beacon" | "thermal:fire_charge/constantan_ingot_2" | "minecraft:purpur_pillar" | "caveopolis:sprayer/colored_saplings/magenta" | "caveopolis:sprayer/colored_wooden_plank_slab/gray" | "thermal:compat/mekanism/press_mek_refined_glowstone_nugget_unpacking" | "alltheores:uranium_ingot_from_ore" | "caveopolis:black_colored_stone_crafting_table" | "mysticalagriculture:stonecutting/soulstone_slabs_from_soulstone" | "minecraft:redstone_lamp" | "mysticalagriculture:augment/jump_boost_iii" | "supplementaries:candle_holders/candle_holder_cyan_dye" | "minecraft:end_rod" | "thermal:machines/insolator/insolator_tomato" | "aquaculture:neptunium_ingot_from_neptunium_block" | "caveopolis:yellow_colored_wooden_plank_stairs" | "minecraft:iron_ingot_from_blasting_iron_ore" | "thermal:tools/detonator" | "caveopolis:sprayer/colored_stone_stairs/orange_colored_stone_stairs" | "strainers:meshes/bamboo" | "farmersdelight:cutting/cod" | "mysticalagriculture:essence/minecraft/orange_concrete" | "lfpirates:sailor_gray_tier_2_leggins_recipe_1" | "caveopolis:sprayer/colored_signs/orange" | "caveopolis:light_gray_colored_cobblestone_brick_slab" | "caveopolis:orange_colored_cobblestone_stairs" | "thermal:storage/peanut_from_block" | "mysticalagriculture:essence/chisel/marble" | "alltheores:constantan_ingot_from_dust_blasting" | "thermal:machines/press/press_gold_ingot_to_plate" | "thermal:compat/mysticalagriculture/insolator_mysticalag_blitz_seeds" | "farmersdelight:cutting/dark_oak_log" | "strainers:acacia_sapling_from_straining_barrier_in_minecraft_air" | "thermal:machines/sawmill/sawmill_cherry_logs" | "caveopolis:sprayer/stripped_colored_logs/purple" | "caveopolis:purple_colored_stone_stairs" | "minecraft:acacia_boat" | "caveopolis:sprayer/shulker_box/red" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/pink" | "caveopolis:blue_colored_stone_pressure_plate" | "cozy_home:spruce_bench_recipe" | "alltheores:aluminum_ingot_from_block" | "caveopolis:black_colored_sign" | "mysticalagriculture:experience_bottle" | "cozy_home:jungle_mirror_stand_recipe" | "industrialforegoing:laser_drill_ore/ores/draconium" | "farmersdelight:magenta_canvas_sign" | "minecraft:dye_blue_bed" | "caveopolis:sprayer/colored_cobblestone_slab/gray_colored_stone_slab" | "aquamirae:cooked_spinefish_from_smoking" | "mysticalagriculture:gear/awakened_supremium_axe" | "alltheores:mek_processing/iridium/slurry/dirty_from_raw" | "thermal:machines/press/press_tin_ingot_to_gear" | "thermal_extra:augments/dynamo_fuel_augment_4" | "mysticalagradditions:tconstruct/tools/melting/prudentium" | "thermal_extra:augments/dynamo_fuel_augment_3" | "mysticalagriculture:essence/minecraft/yellow_dye" | "mysticalagriculture:seed/infusion/enderium" | "mysticalagriculture:essence/mekanism/osmium_ingot" | "thermal_extra:augments/dynamo_fuel_augment_2" | "thermal_extra:augments/dynamo_fuel_augment_1" | "strainers:brewer_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "thermal:machines/smelter/smelter_lumium_dust" | "caveopolis:sprayer/colored_signs/light_gray" | "suppsquared:thermal/item_shelf_rubberwood" | "mysticalagriculture:essence/common/saltpeter" | "mysticalagriculture:essence/powah/spirited_crystal" | "thermal:machines/smelter/smelter_nickel_tools" | "minecraft:painting" | "caveopolis:sprayer/colored_stone_brick_stairs/magenta_colored_stone_brick_stairs" | "caveopolis:sprayer/refill/blue" | "supplementaries:dispenser_minecart_quark" | "thermal:smelting/bronze_ingot_from_dust_smelting" | "farmersdelight:cutting/wild_potatoes" | "alltheores:tools_materials/uranium/uranium_from_ingot" | "caveopolis:sprayer/remove_color/wool" | "thermal:machines/press/packing3x3/press_tar_packing" | "thermal:machines/pulverizer/pulverizer_diamond_armor" | "minecraft:dark_oak_wood" | "mysticalagriculture:enchanter/efficiency" | "caveopolis:purple_colored_stone_stairs_from_purple_colored_stone_stonecutting" | "farmersdelight:cutting/birch_hanging_sign" | "thermal:deep_aquachow_4" | "oceansdelight:baked_tentacle_on_a_stick" | "thermal:storage/cinnabar_block" | "caveopolis:sprayer/remove_color/wooden_plank_fence_gates" | "caveopolis:sprayer/remove_color/wood" | "caveopolis:orange_colored_cobblestone_stairs_from_orange_colored_cobblestone_stonecutting" | "minecraft:stone_brick_slab_from_stone_stonecutting" | "farmersdelight:integration/create/milling/wild_potatoes" | "mysticalagriculture:seed/reprocessor/gold" | "nec:bamboo_chest" | "thermal:lightning_charge_3" | "mysticalagriculture:seed/reprocessor/soularium" | "supplementaries:cozy_home/sign_post_acacia" | "strainers:summoning_block/horse" | "thermal:compat/quark/press_quark_sweet_berry_packing" | "thermal:fuels/numismatic_rose_gold_coin" | "caveopolis:gray_colored_wooden_plank_door" | "minecraft:oak_trapdoor" | "thermal:machines/bottler/bottler_purple_concrete" | "aquamirae:three_bolt_boots" | "industrialforegoing:straw" | "supplementaries:sugar_cube_uncrafting" | "alltheores:osmium_gear" | "supplementaries:candle_holders/candle_holder_brown" | "opolisutilities:saddle" | "caveopolis:green_colored_stone_pressure_plate" | "minecraft:waxed_cut_copper_slab_from_honeycomb" | "opolisutilities:resource_generator_2/speed_blocks/zinc" | "caveopolis:lime_colored_stone_stairs_from_lime_colored_stone_stonecutting" | "minecraft:birch_button" | "cozy_home:table_stump_dark_oak_recipe" | "caveopolis:black_colored_stone_button_from_black_colored_stone_stonecutting" | "farmersdelight:grilled_salmon" | "caveopolis:sprayer/colored_stone_wall/purple_colored_stone_wall" | "alltheores:tin_plate" | "mysticalagriculture:seed/reprocessor/sapphire" | "caveopolis:white_spray_can" | "caveopolis:sprayer/concrete/magenta" | "caveopolis:brown_colored_wooden_plank_pressure_plate_from_brown_colored_wooden_planks_stonecutting" | "thermal:compat/mysticalagriculture/insolator_mysticalag_fiery_ingot_seeds" | "mysticalagriculture:essence/minecraft/cyan_dye" | "systeams:boilers/upgrades/compression_downgrade" | "thermal:compat/tconstruct/press_tconstruct_manyullyn_packing" | "minecraft:weathered_cut_copper_stairs_from_weathered_copper_stonecutting" | "caveopolis:sprayer/colored_cobblestone_brick_wall/brown_colored_stone_brick_wall" | "caveopolis:sprayer/shulker_box/black" | "minecraft:cyan_bed" | "thermal:machines/smelter/smelter_steel_dust" | "caveopolis:magenta_colored_wooden_plank_slab_from_magenta_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/colored_leaves/orange" | "industrialforegoing:world_transporter_type" | "caveopolis:green_colored_stone_brick_wall" | "thermal:compat/immersiveengineering/pulverizer_ie_uranium_ingot_to_dust" | "thermal:machines/centrifuge/centrifuge_brown_rockwool" | "mysticalagriculture:prosperity_gemstone_block" | "caveopolis:yellow_colored_cobblestone_bricks" | "thermal:slot_seal" | "alltheores:platinum_ingot_from_raw_blasting" | "thermal:compat/biomesoplenty/insolator_bop_pink_daffodil_flower" | "farmersdelight:integration/immersiveengineering/squeezer/cabbage_seeds" | "supplementaries:candle_holders/candle_holder_pink_dye" | "mysticalagriculture:essence/minecraft/tuff" | "alltheores:raw_silver_from_block" | "alltheores:lumium_rod" | "farmersdelight:chocolate_pie" | "caveopolis:sprayer/stripped_colored_logs/light_gray" | "caveopolis:sprayer/glass_block/pink" | "igleelib:blazum_ingot_from_block" | "thermal:machines/press/unpacking/press_cinnabar_unpacking" | "caveopolis:pink_colored_stone_wall_from_pink_colored_stone_stonecutting" | "mysticalagriculture:seed/reprocessor/cobalt" | "mysticalagriculture:seed/crafting/creeper" | "strainers:cod_from_straining_fishing_rod_in_minecraft_water" | "thermal_extra:machine/smelter/soul_infused_ingot_from_dust" | "minecraft:orange_stained_glass_pane" | "igleelib:lavium_ingot_from_block" | "minecraft:brick" | "strainers:burn_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "caveopolis:magenta_colored_stone_slab" | "strainers:meshes/amethyst" | "thermal:machines/smelter/smelter_signalum_plate_to_ingot" | "mysticalagriculture:diamond_sickle" | "minecraft:music_disc_5" | "nec:caveop_red_colored_wooden_chest" | "caveopolis:light_blue_colored_sign_from_light_blue_colored_wooden_planks_stonecutting" | "thermal:machines/press/packing3x3/press_wheat_packing" | "opolisutilities:resource_generator_2/speed_blocks/quartz" | "thermal:compat/mysticalagriculture/insolator_mysticalag_end_seeds" | "thermal:machines/smelter/smelter_iron_armor" | "minecraft:coal" | "caveopolis:sprayer/colored_cobblestone_stairs/green_colored_stone_stairs" | "thermal:compat/mekanism/press_mek_uranium_nugget_packing" | "thermal:storage/bell_pepper_block" | "supplementaries:wind_vane" | "thermal:compat/mysticalagriculture/insolator_mysticalag_ruby_seeds" | "thermal:machines/insolator/insolator_red_mushroom" | "thermal:compat/create/press_create_brass_unpacking" | "caveopolis:black_colored_wooden_plank_slab" | "thermal:energy_minecart" | "minecraft:gold_ingot_from_blasting_deepslate_gold_ore" | "caveopolis:cyan_colored_stone_bricks" | "mysticalagriculture:essence/common/steel_ingot" | "supplementaries:stone_tile_stairs" | "industrialforegoing:laser_drill_ore/raw_materials/nickel" | "caveopolis:pink_colored_cobblestone_slab_from_pink_colored_cobblestone_stonecutting" | "thermal:machines/insolator/insolator_acacia_sapling" | "thermal:machines/pulverizer/pulverizer_gravel" | "caveopolis:purple_colored_wooden_plank_button" | "mysticalagriculture:seed/infusion/pulsating_alloy" | "thermal:machines/crucible/crucible_obsidian_to_lava" | "caveopolis:sprayer/shulker_box/orange" | "supplementaries:sack" | "thermal:compat/mysticalagriculture/insolator_mysticalag_iron_seeds" | "lfpirates:sailor_nordic_tier_3_leggins_recipe_1" | "caveopolis:sprayer/colored_saplings/green" | "alltheores:electrum_ingot_from_dust_blasting" | "libraryferret:blasting/gold_coins_jtl" | "simplehats:hatbag_halloween" | "minecraft:smoker" | "thermal:compat/mysticalagriculture/insolator_mysticalag_terrasteel_seeds" | "caveopolis:green_colored_stone_wall_from_green_colored_stone_stonecutting" | "caveopolis:red_colored_cobblestone_bricks" | "industrialforegoing:dissolution_chamber/xp_bottles" | "thermal:compat/quark/insolator_quark_flowering_azalea_bush" | "mysticalagriculture:mystical_fertilizer_better" | "cozy_home:sofa_black_recipe" | "sophisticatedbackpacks:iron_backpack" | "opolisutilities:resource_generator_2/speed_blocks/energetic_alloy" | "caveopolis:sprayer/stripped_colored_logs/pink" | "mysticalagriculture:seed/crafting/dark_steel" | "thermal:compat/biomesoplenty/insolator_bop_origin_sapling" | "caveopolis:black_colored_stone_brick_slab_from_black_colored_stone_bricks_stonecutting" | "mysticalagriculture:essence/botania/gray_mystical_flower" | "alltheores:tools_materials/osmium/osmium_from_nugget" | "minecraft:brown_dye" | "caveopolis:sprayer/colored_logs/light_gray" | "caveopolis:sprayer/colored_stone_buttons/yellow" | "alltheores:mek_processing/platinum/shard/from_crystal" | "minecraft:waxed_exposed_cut_copper_stairs_from_honeycomb" | "thermal:fire_charge/bronze_ingot_4" | "alltheores:silver_plate" | "minecraft:brick_slab" | "thermal:compat/mekanism/press_mek_raw_uranium_packing" | "farmersdelight:cutting/clay" | "mysticalagriculture:essence/minecraft/rotten_flesh" | "alltheores:zinc_ingot" | "thermal:jar_4" | "caveopolis:sprayer/remove_color/stone_stairs" | "thermal:machines/pulverizer/pulverizer_cobblestone" | "alltheores:mek_processing/aluminum/ore/from_raw" | "alltheores:mek_processing/iridium/dust/from_raw_block" | "cozy_home:drawer_mangrove_recipe" | "minecraft:bricks" | "minecraft:red_sandstone_slab" | "strainers:wither_skeleton_skull_from_straining_skeleton_skull_in_minecraft_lava" | "thermal:machines/pulverizer/pulverizer_sandstone" | "caveopolis:purple_colored_stone_brick_slab_from_purple_colored_stone_bricks_stonecutting" | "alltheores:copper_ingot_from_block" | "thermal:device_hive_extractor" | "minecraft:yellow_glazed_terracotta" | "caveopolis:light_gray_colored_sign" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/black" | "opolisutilities:guide_book" | "glassential:ghostly_trapdoor" | "mysticalagradditions:tconstruct/tools/casting/prudentium" | "sophisticatedbackpacks:auto_smoking_upgrade_from_auto_smelting_upgrade" | "strainers:friend_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "minecraft:exposed_cut_copper" | "mysticalagriculture:seed/crafting/uranium" | "industrialforegoing:dissolution_chamber/simple_machine_frame" | "caveopolis:light_blue_colored_hanging_sign" | "farmersdelight:cutting/cherry_wood" | "minecraft:dark_oak_stairs" | "minecraft:jungle_pressure_plate" | "caveopolis:sprayer/colored_stone_slab/blue_colored_stone_slab" | "farmersdelight:honey_glazed_ham_block" | "minecraft:host_armor_trim_smithing_template" | "strainers:sheaf_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "alltheores:mek_processing/platinum/shard/from_ore" | "minecraft:smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting" | "thermal:flux_saw" | "strainers:summoning_block/fox" | "farmersdelight:orange_hanging_canvas_sign" | "industrialforegoing:mycelial_furnace" | "thermal:smelting/constantan_ingot_from_dust_smelting" | "mysticalagriculture:seed/infusion/rubber" | "mysticalagriculture:soulium_spawner/ghast" | "minecraft:blue_banner" | "mysticalagriculture:seed/infusion/certus_quartz" | "caveopolis:gray_colored_stone_crafting_table" | "alltheores:mek_processing/platinum/slurry/dirty/from_raw_block" | "mysticalagriculture:seed/reprocessor/yellorium" | "caveopolis:light_blue_colored_stone_brick_stairs" | "caveopolis:sprayer/colored_cobblestone_slab/orange_colored_stone_slab" | "cozy_home:grandfather_clock_jungle_recipe" | "thermal:crossover_rail" | "thermal:compat/tconstruct/tree_extractor_tconstruct_ender_slime" | "glassential:glass_light" | "minecraft:glowstone" | "alltheores:gold_rod" | "farmersdelight:integration/immersiveengineering/squeezer/tomato_seeds" | "minecraft:vex_armor_trim_smithing_template_smithing_trim" | "thermal:smelting/tin_ingot_from_raw_smelting" | "tmttd:machines/press/egg_press" | "minecraft:red_nether_brick_wall" | "caveopolis:sprayer/colored_leaves/light_blue" | "minecraft:chiseled_red_sandstone" | "mysticalagriculture:seed/crafting/neutronium" | "farmersdelight:fried_egg" | "caveopolis:black_colored_cobblestone_bricks" | "thermal:machines/sawmill/sawmill_oak_logs" | "thermal:compat/quark/press_quark_sweet_berry_unpacking" | "mysticalagriculture:essence/thermal/enderium_ingot" | "caveopolis:blue_colored_stone_stairs" | "mysticalagriculture:essence/minecraft/music_disc_far" | "thermal:compat/create/pulverizer_create_crimsite_recycle" | "theoneprobe:probenote" | "strainers:diamond_from_straining_deepslate_in_minecraft_water" | "opolisutilities:resource_generator_2/speed_blocks/nickel" | "cozy_home:andesite_brick_recipe" | "minecraft:light_gray_candle" | "thermal:machines/centrifuge/centrifuge_dandelion" | "thermal:storage/electrum_ingot_from_block" | "minecraft:cobbled_deepslate_stairs_from_cobbled_deepslate_stonecutting" | "mysticalagriculture:seed/reprocessor/uranium" | "thermal:compat/mysticalagriculture/insolator_mysticalag_cow_seeds" | "caveopolis:light_blue_colored_wooden_plank_button_from_light_blue_colored_wooden_planks_stonecutting" | "caveopolis:brown_colored_cobblestone_slab" | "thermal:storage/rose_gold_ingot_from_block" | "aquamirae:remnants_saber" | "mysticalagriculture:seed/crafting/rose_gold" | "mysticalagriculture:gear/tertium_shears" | "minecraft:dye_lime_carpet" | "alltheores:mek_processing/aluminum/clump/from_ore" | "farmersdelight:cooking/tomato_sauce" | "farmersdelight:fruit_salad" | "supplementaries:soap/map" | "mysticalagriculture:essence/minecraft/creeper_head" | "caveopolis:yellow_colored_wooden_plank_fence_gate_from_yellow_colored_wooden_planks_stonecutting" | "thermal:machines/crucible/crucible_stone_to_lava" | "thermal:storage/cinnabar_from_block" | "alltheores:tools_materials/tin/tin_from_ingot" | "minecraft:deepslate_tile_stairs_from_cobbled_deepslate_stonecutting" | "mysticalagriculture:imperium_ingot_recraft" | "thermal:machines/press/packing2x2/press_cured_rubber_packing" | "thermal:compat/mysticalagriculture/insolator_mysticalag_nether_seeds" | "minecraft:sea_lantern" | "cozy_home:bamboo_plank_recipe" | "mysticalagriculture:seed/crafting/electrum" | "caveopolis:white_colored_cobblestone_stairs_from_white_colored_cobblestone_stonecutting" | "farmersdelight:cutting/oak_hanging_sign" | "mysticalagriculture:seed/infusion/rose_gold" | "thermal:machines/smelter/smelter_rose_gold_dust" | "thermal:compat/tconstruct/chiller_tconstruct_cobalt_ingot" | "thermal:machines/press/press_invar_nugget_to_coin" | "caveopolis:yellow_colored_cobblestone_brick_stairs_from_yellow_colored_cobblestone_bricks_stonecutting" | "aquaculture:gold_nugget_from_gold_fish" | "minecraft:diamond_hoe" | "alltheores:mek_processing/silver/dust/from_ingot" | "farmersdelight:tomato_seeds" | "farmersdelight:cutting/dark_oak_sign" | "minecraft:dye_cyan_wool" | "mysticalagriculture:seed/infusion/sapphire" | "mysticalagriculture:seed/reprocessor/gaia_spirit" | "thermal:storage/amaranth_block" | "mysticalagriculture:seed/infusion/mystical_flower" | "alltheores:signalum_ingot_from_dust" | "farmersdelight:cutting/allium" | "caveopolis:sprayer/colored_wooden_planks/light_blue" | "thermal:machines/press/unpacking/press_nickel_nugget_unpacking" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/green" | "thermal:machines/pulverizer/pulverizer_andesite" | "mysticalagriculture:seed/reprocessor/sky_stone" | "minecraft:weathered_cut_copper" | "thermal:rockwool/lime_rockwool_from_dye" | "mysticalagriculture:prosperity_block_uncraft" | "thermal:machines/centrifuge/centrifuge_flax" | "thermal:machines/press/packing3x3/press_tin_packing" | "minecraft:end_stone_brick_stairs_from_end_stone_brick_stonecutting" | "caveopolis:marble_brick_slab" | "matc:crystals/master_infusion_crystal_superium" | "minecraft:dye_pink_carpet" | "caveopolis:sprayer/colored_stone/gray_colored_stone" | "mysticalagriculture:seed/infusion/lumium" | "minecraft:leather" | "cozy_home:desk_crimson_recipe" | "mysticalagriculture:gear/inferium_leggings" | "theoneprobe:iron_helmet_probe" | "thermal_extra:augments/av_item_filter_augment" | "minecraft:waxed_cut_copper_stairs_from_honeycomb" | "thermal:machines/press/packing3x3/press_iron_packing" | "supplementaries:blackboard_duplicate" | "minecraft:dye_brown_bed" | "sophisticatedbackpacks:gold_backpack" | "caveopolis:light_blue_colored_stone_brick_wall" | "caveopolis:sprayer/colored_saplings/black" | "minecraft:stone_brick_wall_from_stone_bricks_stonecutting" | "caveopolis:light_blue_colored_stone_pressure_plate_from_light_blue_colored_stone_stonecutting" | "caveopolis:gray_colored_cobblestone_wall_from_gray_colored_cobblestone_stonecutting" | "minecraft:furnace" | "caveopolis:sprayer/colored_stone_stairs/green_colored_stone_stairs" | "thermal:enderium_dust_2" | "industrialforegoing:laser_drill_ore/raw_materials/bauxite" | "opolisutilities:resource_generator/mods/caveopolis/black_colored_stone" | "thermal:compat/tconstruct/smelter_tconstruct_cobalt_ore" | "chipped:botanist_workbench" | "supplementaries:cozy_home/sign_post_mangrove" | "supplementaries:sack_2" | "caveopolis:sprayer/colored_cobblestone_stairs/yellow_colored_stone_stairs" | "minecraft:dark_prismarine_stairs_from_dark_prismarine_stonecutting" | "caveopolis:yellow_colored_cobblestone_slab" | "farmersdelight:cooking/fish_stew" | "caveopolis:sprayer/colored_wooden_planks/blue" | "minecraft:activator_rail" | "caveopolis:yellow_colored_wooden_planks" | "caveopolis:blue_colored_stone_brick_wall" | "mysticalagriculture:essence/botania/light_blue_mystical_flower" | "thermal:smelting/copper_ingot_from_dust_blasting" | "mysticalagriculture:gear/prudentium_hoe" | "minecraft:crimson_pressure_plate" | "thermal:machines/centrifuge/centrifuge_orange_tulip" | "caveopolis:light_gray_colored_stone_button_from_light_gray_colored_stone_stonecutting" | "cozy_home:counter_acacia_recipe" | "mysticalagradditions:tconstruct/tools/casting/tertium" | "caveopolis:sprayer/colored_wooden_plank_door/cyan" | "cozy_home:cherry_plank_recipe" | "supplementaries:spring_launcher" | "thermal:compat/tconstruct/press_tconstruct_hepatizon_packing" | "caveopolis:yellow_colored_hanging_sign" | "thermal:rockwool/pink_rockwool_from_dye" | "minecraft:cherry_stairs" | "mysticalagriculture:essence/powah/energized_steel" | "minecraft:red_sandstone" | "supplementaries:safe" | "caveopolis:blue_colored_wooden_plank_door_from_blue_colored_wooden_planks_stonecutting" | "strainers:howl_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "farmersdelight:cutting/warped_hanging_sign" | "igleelib:modium_ingot" | "thermal:compat/immersiveengineering/smelter_ie_raw_aluminum" | "caveopolis:sprayer/colored_wooden_plank_button/red" | "mysticalagriculture:essence/minecraft/bamboo" | "lfpirates:sailor_gray_tier_1_body_recipe_1" | "caveopolis:sprayer/colored_stone_buttons/light_gray" | "thermal:devices/rock_gen/rock_gen_cobbled_deepslate" | "caveopolis:sprayer/colored_cobblestone_brick_slab/purple" | "mysticalagriculture:seed/reprocessor/nether" | "industrialforegoing:mycelial_ender" | "thermal_extra:machine/press/soul_infused_coin" | "caveopolis:magenta_colored_cobblestone_slab_from_magenta_colored_cobblestone_stonecutting" | "minecraft:waxed_cut_copper_stairs_from_waxed_cut_copper_stonecutting" | "mysticalagriculture:inferium_ingot_block" | "minecraft:bamboo_fence" | "minecraft:red_glazed_terracotta" | "thermal:machines/centrifuge/centrifuge_gunpowder_mushroom_spores" | "supplementaries:quiver_fd" | "minecraft:birch_boat" | "caveopolis:sprayer/colored_stone_slab/light_blue_colored_stone_slab" | "industrialforegoing:hydroponic_bed" | "supplementaries:stonecutting/stone_tile_wall_from_bricks" | "framedcompactdrawers:framed_half_one" | "caveopolis:orange_colored_stone_slab_from_orange_colored_stone_stonecutting" | "thermal:compat/biomesoplenty/sawmill_bop_cherry_logs" | "systeams:boilers/upgrades/compression_upgrade" | "caveopolis:sprayer/colored_stone_wall/pink_colored_stone_wall" | "minecraft:packed_mud" | "caveopolis:purple_colored_wooden_plank_slab_from_purple_colored_wooden_planks_stonecutting" | "thermal:fire_tnt_minecart" | "minecraft:netherite_helmet_smithing" | "strainers:seagrass_from_straining_barrier_in_strainers_eroding_water_fluid" | "thermal:compat/mysticalagriculture/insolator_mysticalag_wood_seeds" | "supplementaries:soap/dirty_glass" | "mysticalagriculture:nature_agglomeratio" | "caveopolis:sprayer/colored_wooden_planks/lime" | "alltheores:steel_plate" | "mysticalagriculture:essence/minecraft/feather" | "thermal_extra:machine/dynamo/numismatic/soul_infused_coin" | "caveopolis:red_colored_wooden_plank_fence_from_red_colored_wooden_planks_stonecutting" | "mysticalagriculture:prudentium_growth_accelerator" | "mysticalagradditions:inferium_coal" | "caveopolis:brown_colored_stone_slab" | "mysticalagriculture:seed/reprocessor/zinc" | "mysticalagriculture:inferium_seeds" | "caveopolis:sprayer/remove_color/terracotta" | "caveopolis:black_colored_wooden_plank_pressure_plate" | "minecraft:gray_candle" | "thermal:compat/biomesoplenty/insolator_bop_willow_sapling" | "caveopolis:magenta_colored_wooden_plank_fence" | "caveopolis:marble_slab" | "caveopolis:sprayer/banners/orange" | "minecraft:stripped_dark_oak_wood" | "opolisutilities:resource_generator_2/speed_blocks/pulsating_alloy" | "thermal:compat/tconstruct/press_tconstruct_ender_slime_2x2_packing" | "alltheores:lumium_block" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/black_colored_stone_brick_stairs" | "thermal:storage/electrum_ingot_from_nuggets" | "caveopolis:sprayer/colored_wooden_plank_fence/yellow" | "mysticalagriculture:souls/gunpowder" | "caveopolis:sprayer/terracotta/lime" | "mysticalagriculture:seed/crafting/silicon" | "caveopolis:sprayer/colored_saplings/lime" | "opolisutilities:catalogue/selling/caveopolis/magenta_spray_can" | "caveopolis:yellow_spray_can" | "caveopolis:orange_colored_stone_brick_slab" | "caveopolis:white_colored_wooden_plank_stairs" | "minecraft:birch_fence" | "strainers:upgrades/everlasting/everlasting_mesh_upgrade" | "farmersdelight:cooking_pot" | "minecraft:red_nether_brick_slab" | "thermal_extra:shellite_glass" | "mysticalagriculture:seed/crafting/chicken" | "minecraft:cooked_salmon_from_campfire_cooking" | "caveopolis:sprayer/colored_wooden_plank_door/pink" | "tmttd:machines/press/sweetberry_crate_press" | "caveopolis:sprayer/glazed_terracotta/gray" | "thermal:compat/create/pulverizer_create_asurine" | "caveopolis:sprayer/colored_stone_bricks/lime_colored_stone_bricks" | "thermal:machines/pulverizer/pulverizer_gold_ingot_to_dust" | "mysticalagriculture:seed/reprocessor/silver" | "supplementaries:flint_block" | "caveopolis:sprayer/colored_signs/blue" | "strainers:summoning_block/spider" | "mysticalagriculture:essence/common/titanium_ingot" | "minecraft:cut_sandstone_slab_from_cut_sandstone_stonecutting" | "thermal_extra:parts/soul_infused_gear" | "minecraft:sugar_from_honey_bottle" | "cozy_home:chimney_brick_recipe" | "thermal:machines/press/press_gold_nugget_to_coin" | "mysticalagriculture:essence/minecraft/skeleton_skull" | "minecraft:spruce_fence_gate" | "thermal:machines/centrifuge/centrifuge_purple_wool" | "minecraft:leather_chestplate" | "alltheores:steel_dust_from_alloy_blending" | "caveopolis:sprayer/colored_stone_brick_wall/lime_colored_stone_brick_wall" | "supplementaries:sign_post_acacia" | "thermal:machines/smelter/smelter_rose_gold_armor" | "minecraft:beehive" | "thermal:compat/mysticalagriculture/insolator_mysticalag_silicon_seeds" | "mysticalagradditions:end_prosperity_shard_smelted" | "minecraft:white_stained_glass_pane_from_glass_pane" | "mysticalagriculture:enchanter/feather_falling" | "mysticalagriculture:seed/crafting/ironwood" | "supplementaries:candle_holders/candle_holder_purple" | "thermal:compat/biomesoplenty/tree_extractor_bop_pink_cherry" | "alltheores:mek_processing/nickel/dust/from_raw_ore" | "caveopolis:sprayer/refill/cyan" | "thermal:smelting/cracked_slag_bricks_from_smelting" | "minecraft:birch_wood" | "caveopolis:lime_colored_cobblestone_stairs_from_lime_colored_cobblestone_stonecutting" | "mysticalagradditions:tconstruct/tools/materials/supremium/nugget" | "alltheores:electrum_block" | "mysticalagriculture:seed/reprocessor/dirt" | "thermal:compat/create_ie/centrifuge_create_ie_crushed_raw_aluminum" | "storagedrawers:illumination_upgrade" | "caveopolis:light_gray_colored_cobblestone_slab_from_light_gray_colored_cobblestone_stonecutting" | "mysticalagriculture:prudentium_ingot_block" | "minecraft:scaffolding" | "alltheores:sapphire_from_hammer_crushing" | "minecraft:acacia_button" | "minecraft:polished_granite_from_granite_stonecutting" | "thermal:machines/crucible/crucible_redstone_block" | "mysticalagriculture:gear/imperium_bow" | "mysticalagradditions:tconstruct/casting/imperium/ingot_sand_cast" | "alltheores:osmium_ingot_from_raw" | "thermal:storage/copper_ingot_from_nuggets" | "aquamirae:three_bolt_leggings" | "caveopolis:sprayer/glass_pane/magenta" | "strainers:upgrade_stats/improved_mesh_upgrade" | "minecraft:lapis_lazuli_from_smelting_deepslate_lapis_ore" | "thermal:machines/insolator/insolator_horn_coral_fan" | "mysticalagriculture:essence/tconstruct/manyullyn_ingot" | "caveopolis:bright_shard_from_smelting_deepslate_bright_stone_ore" | "sophisticatedbackpacks:copper_backpack" | "caveopolis:sprayer/colored_saplings/blue" | "caveopolis:sprayer/terracotta/blue" | "minecraft:andesite_slab" | "minecraft:bamboo_chest_raft" | "thermal:machines/sawmill/sawmill_spruce_logs" | "minecraft:honey_block" | "minecraft:bamboo_planks" | "simplehats:hatbag_uncommon" | "mysticalagradditions:end_inferium_smelted" | "industrialforegoing:dissolution_chamber/infinity_hammer" | "thermal:machines/pyrolyzer/pyrolyzer_bitumen" | "farmersdelight:melon_juice" | "strainers:upgrade_stats/reinforced_output_upgrade" | "thermal_extra:machine/dynamo/numismatic/twinite_coin" | "minecraft:stone_brick_stairs_from_stone_bricks_stonecutting" | "cozy_home:grandfather_clock_acacia_recipe" | "alltheores:lead_ingot" | "caveopolis:sprayer/remove_color/glass" | "thermal:machines/smelter/smelter_ruby_ore" | "thermal:fire_charge/enderium_glass_2" | "thermal:compat/mysticalagriculture/insolator_mysticalag_earth_seeds" | "mysticalagriculture:gear/tertium_bow" | "alltheores:mek_processing/nickel/shard/from_raw_ore" | "thermal:compat/tconstruct/press_tconstruct_blood_slime_3x3_packing" | "minecraft:coal_from_blasting_coal_ore" | "caveopolis:gray_colored_cobblestone_brick_stairs_from_gray_colored_cobblestone_bricks_stonecutting" | "thermal:tomato_sauce" | "lfpirates:fisherman_leggins_recipe_1" | "alltheores:thermal_pulverize/pulverizer_zinc_ingot_to_dust" | "cozy_home:dark_oak_plank_recipe" | "caveopolis:sprayer/banners/pink" | "caveopolis:sprayer/colored_wooden_plank_slab/magenta" | "caveopolis:orange_colored_stone_bricks_from_orange_colored_stone_stonecutting" | "caveopolis:bright_shard_from_blasting_deepslate_bright_stone_ore" | "thermal:compat/mekanism/press_mek_salt_packing" | "mysticalagriculture:seed/crafting/sheep" | "thermal:junk_net" | "mysticalagriculture:souls/rabbit_foot" | "thermal:storage/netherite_ingot_from_nuggets" | "alltheores:signalum_nugget_from_ingot" | "supplementaries:gold_gate" | "opolisutilities:item_repairer" | "farmersdelight:cutting/red_tulip" | "industrialforegoing:enchantment_extractor" | "suppsquared:sack_dye" | "farmersdelight:cutting/spruce_wood" | "caveopolis:sprayer/colored_hanging_signs/brown" | "caveopolis:sprayer/beds/yellow" | "caveopolis:sprayer/colored_wooden_plank_slab/purple" | "thermal:storage/coal_coke_from_block" | "systeams:boilers/compression" | "mysticalagriculture:seed/reprocessor/lapis_lazuli" | "farmersdelight:cutting/crimson_hyphae" | "supplementaries:cozy_home/sign_post_oak" | "solcarrot:food_book" | "minecraft:warped_hanging_sign" | "alltheores:osmium_ingot_from_raw_blasting" | "mysticalagriculture:nether_agglomeratio" | "caveopolis:purple_colored_wooden_plank_crafting_table" | "cozy_home:chandelier_golden_recipe" | "minecraft:cracked_deepslate_bricks" | "caveopolis:sprayer/remove_color/banners" | "minecraft:orange_dye_from_torchflower" | "mysticalagriculture:seed/crafting/lumium" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/green" | "mysticalagradditions:insanium_gemstone" | "industrialforegoing:laser_drill_fluid/lava" | "thermal:storage/tea_from_block" | "thermal:machines/press/packing3x3/press_copper_packing" | "alltheores:mek_processing/platinum/dirty_dust/from_clump" | "lfpirates:sailor_blue_tier_2_helmet_recipe_1" | "aquaculture:double_hook" | "mysticalagriculture:enchanter/protection" | "farmersdelight:cooking/pasta_with_meatballs" | "chipped:tinkering_table" | "mysticalagriculture:seed/reprocessor/apatite" | "caveopolis:stone_crafting_table" | "mysticalagriculture:seed/infusion/water" | "minecraft:jungle_fence_gate" | "strainers:torchflower_seeds_from_straining_mulch_in_minecraft_water" | "caveopolis:stripped_green_colored_wood" | "matc:crystals/supremium" | "thermal:phyto_grenade_4" | "alltheores:tin_block" | "mysticalagriculture:imperium_furnace" | "alltheores:tools_materials/lead/lead_from_block" | "strainers:nautilus_shell_from_straining_fishing_rod_in_minecraft_water" | "caveopolis:sprayer/remove_color/glass_pane" | "thermal:storage/radish_block" | "industrialforegoing:laser_drill_ore/raw_materials/sheldonite" | "alltheores:sapphire_from_block" | "thermal:machines/insolator/insolator_orange_tulip" | "smallships:jungle_brigg" | "craftingstation:crafting_station" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/red" | "thermal:machines/insolator/insolator_catalyst_phytogro" | "caveopolis:green_colored_wooden_plank_trapdoor" | "farmersdelight:light_blue_canvas_sign" | "thermal:machines/press/packing3x3/press_electrum_nugget_packing" | "caveopolis:sprayer/colored_hanging_signs/orange" | "minecraft:polished_basalt_from_basalt_stonecutting" | "thermal:smelting/silver_ingot_from_ore_blasting" | "caveopolis:yellow_colored_stone_bricks" | "mysticalagriculture:seed/infusion/lapis_lazuli" | "alltheores:smelting_dust/platinum_ingot" | "thermal:rf_coil" | "thermal:compat/mekanism/smelter_mek_osmium_ore" | "caveopolis:sprayer/colored_cobblestone_brick_slab/green" | "thermal:smelting/electrum_ingot_from_dust_blasting" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/white" | "smallships:mangrove_cog" | "minecraft:polished_granite_slab_from_polished_granite_stonecutting" | "mysticalagriculture:essence/minecraft/magenta_concrete" | "mysticalagriculture:gear/imperium_scythe" | "cozy_home:sofa_yellow_recipe" | "caveopolis:sprayer/stripped_colored_wood/magenta" | "minecraft:warped_planks" | "caveopolis:bright_shard_from_blasting_bright_stone_ore" | "minecraft:red_nether_brick_wall_from_red_nether_bricks_stonecutting" | "matc:imperium_essence" | "smallships:acacia_galley" | "mysticalagradditions:awakened_supremium_paxel" | "opolisutilities:opolis_wrench" | "thermal:compat/immersiveengineering/press_ie_aluminum_nugget_packing" | "minecraft:red_candle" | "thermal:earth_charge/quartz_dust_from_quartz" | "caveopolis:light_gray_colored_cobblestone_stairs" | "nec:spruce_chest" | "alltheores:tools_materials/zinc/zinc_from_ingot" | "mysticalagriculture:seed/infusion/aquamarine" | "thermal:compat/biomesoplenty/insolator_bop_toadstool_mushroom" | "thermal:machines/smelter/smelter_raw_lead" | "sophisticatedbackpacks:chipped/glassblower_upgrade" | "minecraft:brown_carpet" | "thermal:machines/press/packing3x3/press_redstone_packing" | "caveopolis:sprayer/terracotta/orange" | "caveopolis:marble_brick_slab_from_marble_bricks_stonecutting" | "caveopolis:red_colored_stone_bricks" | "thermal:storage/sawdust_from_block" | "minecraft:crimson_fence" | "minecraft:oxidized_cut_copper_slab" | "mysticalagriculture:essence/minecraft/granite" | "glassential:redstone_trapdoor" | "cozy_home:counter_spruce_storage_recipe" | "thermal:machines/chiller/chiller_water_to_ice" | "caveopolis:sprayer/glazed_terracotta/purple" | "alltheores:platinum_rod" | "mysticalagriculture:soulium_spawner/pig" | "caveopolis:sprayer/colored_stone_wall/blue_colored_stone_wall" | "minecraft:light_gray_stained_glass" | "sophisticatedbackpacks:backpack_dye" | "thermal:compat/tconstruct_ie/chiller_tconstruct_ie_iron_rod" | "strainers:birch_sapling_from_straining_barrier_in_minecraft_air" | "caveopolis:sprayer/concrete/white" | "mysticalagriculture:essence/minecraft/iron_ingot" | "alltheores:zinc_ingot_from_block" | "minecraft:decorated_pot_simple" | "thermal_extra:machine/dynamo/frost/powder_snow_bucket" | "thermal:storage/green_bean_from_block" | "strainers:upgrade_stats/beacon" | "thermal:compat/farmersdelight/insolator_farmersdelight_tomato" | "caveopolis:white_colored_stone" | "caveopolis:sprayer/colored_stone_buttons/pink" | "caveopolis:black_colored_cobblestone_stairs" | "minecraft:oak_pressure_plate" | "thermal:compat/tconstruct/chiller_tconstruct_nickel_ingot" | "thermal:lightning_tnt_minecart" | "opolisutilities:catalogue/selling/caveopolis/lime_spray_can" | "thermal:glowstone_tnt" | "minecraft:diorite" | "supplementaries:present" | "thermal:machine_furnace" | "thermal_extra:crafting/dynamo_frost" | "mysticalagriculture:imperium_ingot_block_uncraft" | "thermal:machines/insolator/insolator_azalea_bush" | "minecraft:snout_armor_trim_smithing_template_smithing_trim" | "farmersdelight:cutting/bricks" | "thermal:fuels/lapidary/lapidary_emerald" | "caveopolis:sprayer/colored_signs/lime" | "mysticalagradditions:tconstruct/melting/soulium/ingot" | "minecraft:crimson_button" | "caveopolis:sprayer/wool/gray_wool" | "mysticalagriculture:diamond_scythe" | "caveopolis:magenta_colored_stone_brick_wall_from_magenta_colored_stone_bricks_stonecutting" | "thermal:machines/press/unpacking/press_sawdust_unpacking" | "thermal:compat/redstone_arsenal/press_rsa_flux_ingot_to_gear" | "minecraft:jungle_planks" | "minecraft:netherite_axe_smithing" | "caveopolis:gray_colored_wooden_plank_button" | "caveopolis:cyan_colored_wooden_plank_stairs" | "thermal:smelting/netherite_ingot_from_dust_smelting" | "caveopolis:sprayer/colored_cobblestone_bricks/light_gray_colored_stone_bricks" | "opolisutilities:catalogue/selling/caveopolis/gray_spray_can" | "mysticalagriculture:seed/crafting/gold" | "thermal:machines/press/press_tea_packing" | "libraryferret:blasting/netherite_coins_jtl" | "thermal:rockwool/green_rockwool_from_dye" | "strainers:upgrade_stats/sturdy_duration_upgrade" | "aquaculture:iron_fillet_knife" | "thermal:machines/insolator/insolator_peanut" | "thermal:machines/press/press_peanut_unpacking" | "minecraft:polished_deepslate_slab_from_polished_deepslate_stonecutting" | "caveopolis:sprayer/colored_cobblestone_brick_slab/black" | "strainers:skull_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "mysticalagriculture:essence/minecraft/ender_eye" | "industrialforegoing:laser_drill_ore/ores/cinnabar" | "supplementaries:soap/tipped_arrow" | "minecraft:red_nether_bricks" | "caveopolis:pink_colored_stone_brick_stairs" | "mysticalagriculture:souls/arrow" | "lfpirates:sailor_nordic_tier_3_body_recipe_1" | "caveopolis:sprayer/glass_block/orange" | "minecraft:warped_slab" | "minecraft:mangrove_stairs" | "minecraft:prismarine" | "suppsquared:candle_holders/gold_candle_holder" | "caveopolis:sprayer/colored_stone_slab/gray_colored_stone_slab" | "caveopolis:sprayer/glass_pane/cyan" | "thermal:augments/fluid_tank_augment" | "minecraft:chiseled_sandstone" | "thermal:compat/mekanism/press_mek_raw_osmium_packing" | "caveopolis:gray_colored_cobblestone_slab_from_gray_colored_cobblestone_stonecutting" | "minecraft:bamboo_raft" | "nec:caveop_pink_colored_wooden_chest" | "lfpirates:sailor_blue_tier_3_leggins_recipe_1" | "thermal:machines/press/packing3x3/press_carrot_packing" | "thermal:augments/dynamo_fuel_augment" | "caveopolis:sprayer/colored_cobblestone/yellow_colored_stone" | "mysticalagriculture:seed/reprocessor/knightmetal" | "thermal:chiller_rod_cast" | "cozy_home:counter_crimson_storage_recipe" | "mysticalagriculture:gear/imperium_boots" | "caveopolis:stripped_lime_colored_wood" | "minecraft:moss_carpet" | "mysticalagriculture:seed/infusion/spider" | "thermal:devices/tree_extractor/tree_extractor_acacia" | "mysticalagriculture:seed/crafting/sulfur" | "minecraft:mossy_cobblestone_slab" | "storagedrawers:crimson_trim" | "thermal_extra:storage/shellite_block" | "strainers:tropical_fish_from_straining_fishing_rod_in_minecraft_water" | "thermal:machines/press/press_gold_ingot_to_gear" | "minecraft:polished_diorite_slab_from_diorite_stonecutting" | "minecraft:cake" | "thermal:machines/press/press_nickel_ingot_to_gear" | "thermal:machines/press/packing3x3/press_bamboo_packing" | "thermal:compat/mysticalagriculture/insolator_mysticalag_rock_crystal_seeds" | "opolisutilities:drying_table/bundled_flesh" | "alltheores:mek_processing/platinum/clump/from_raw_ore" | "mysticalagriculture:seed/crafting/yellorium" | "minecraft:granite_slab" | "minecraft:mud_brick_stairs" | "thermal:dynamo_compression" | "supplementaries:cog_block" | "mysticalagriculture:seed/reprocessor/enderium" | "thermal:ender_grenade_4" | "supplementaries:lapis_brick_slab" | "strainers:prismarine_shard_from_straining_barrier_in_strainers_purified_water_fluid" | "thermal:ender_tnt" | "caveopolis:purple_colored_wooden_plank_fence_gate_from_purple_colored_wooden_planks_stonecutting" | "alltheores:thermal_pulverize/pulverizer_osmium_ingot_to_dust" | "chipped:glassblower" | "minecraft:lime_concrete_powder" | "minecraft:leather_leggings" | "minecraft:sandstone_wall_from_sandstone_stonecutting" | "mysticalagriculture:seed/reprocessor/pulsating_alloy" | "alltheores:mek_processing/silver/clump/from_ore" | "minecraft:polished_blackstone_bricks_from_polished_blackstone_stonecutting" | "thermal:machines/press/press_iron_ingot_to_gear" | "mysticalagradditions:insanium_gemstone_block_uncraft" | "systeams:boilers/upgrades/pneumatic_upgrade" | "mysticalagriculture:essence/minecraft/light_blue_concrete" | "thermal:fuels/gourmand/gourmand_spice_cake" | "mysticalagriculture:souls/basalz_rod" | "minecraft:cherry_pressure_plate" | "minecraft:redstone_from_blasting_deepslate_redstone_ore" | "alltheores:tools_materials/aluminum/aluminum_from_nugget" | "mysticalagriculture:essence/minecraft/calcite" | "minecraft:netherite_scrap_from_blasting" | "strainers:heart_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "caveopolis:purple_colored_stone_pressure_plate" | "industrialforegoing:laser_drill_ore/ores/sodalite" | "thermal:machines/pulverizer/pulverizer_lapis_ore" | "thermal:machines/smelter/smelter_catalyst_sand" | "caveopolis:black_colored_wooden_plank_fence_gate_from_black_colored_wooden_planks_stonecutting" | "farmersdelight:cutting/crimson_trapdoor" | "caveopolis:sprayer/colored_wooden_planks/cyan" | "mysticalagradditions:tconstruct/tools/casting/soulium" | "minecraft:book" | "thermal:compat/biomesoplenty/sawmill_bop_redwood_logs" | "mysticalagriculture:essence/enderio/vibrant_alloy_ingot" | "mysticalagriculture:gear/prudentium_crossbow" | "caveopolis:white_colored_stone_slab" | "caveopolis:orange_colored_wooden_plank_stairs" | "mysticalagriculture:awakened_supremium_ingot_block_uncraft" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/lime_colored_stone_brick_stairs" | "caveopolis:sprayer/concrete/light_gray" | "mysticalagriculture:seed/infusion/inferium" | "strainers:summoning_block/cod" | "caveopolis:brown_colored_wooden_plank_fence" | "farmersdelight:cutting/cooked_salmon" | "mysticalagriculture:gear/imperium_watering_can" | "mysticalagriculture:prudentium_farmland_till" | "mysticalagriculture:tertium_ingot_block_uncraft" | "caveopolis:blue_colored_cobblestone_brick_wall_from_blue_colored_cobblestone_bricks_stonecutting" | "opolisutilities:ender_scrambler" | "strainers:summoning_block/cow" | "alltheores:ruby_from_block" | "caveopolis:sprayer/colored_stone_brick_stairs/black_colored_stone_brick_stairs" | "thermal:machines/press/press_netherite_ingot_to_plate" | "opolisutilities:catalogue_book" | "caveopolis:green_colored_stone_wall" | "sophisticatedbackpacks:advanced_deposit_upgrade" | "thermal:machines/smelter/smelter_catalyst_cinnabar_dust" | "minecraft:polished_blackstone_brick_stairs_from_polished_blackstone_stonecutting" | "minecraft:red_nether_brick_stairs_from_red_nether_bricks_stonecutting" | "alltheores:tin_gear" | "thermal:compat/mysticalagriculture/insolator_mysticalag_basalt_seeds" | "tmttd:cooking/stuffed_pepper" | "lfpirates:corsair_tier_2_helmet_recipe_1" | "thermal:augments/rs_control_augment" | "mysticalagriculture:seed/crafting/diamond" | "mysticalagriculture:gear/imperium_fishing_rod" | "minecraft:redstone_from_smelting_deepslate_redstone_ore" | "mysticalagriculture:gear/supremium_axe" | "thermal:fuels/lapidary/lapidary_prismarine" | "mysticalagradditions:insanium_apple" | "caveopolis:blue_colored_wooden_plank_button_from_blue_colored_wooden_planks_stonecutting" | "caveopolis:pink_colored_wooden_plank_door_from_pink_colored_wooden_planks_stonecutting" | "minecraft:sandstone_slab" | "caveopolis:mixed_stone_ingot_from_smelting_mixed_stone_ore" | "lfpirates:sailor_nordic_tier_1_body_recipe_1" | "storagedrawers:acacia_trim" | "caveopolis:green_colored_cobblestone_brick_slab" | "thermal:machines/pulverizer/pulverizer_lumium_plate_to_dust" | "thermal:storage/signalum_ingot_from_nuggets" | "mysticalagriculture:supremium_block_uncraft" | "thermal:smelting/lead_ingot_from_raw_smelting" | "caveopolis:green_colored_stone_stairs" | "caveopolis:light_blue_colored_wooden_plank_stairs_from_light_blue_colored_wooden_planks_stonecutting" | "libraryferret:crafting_shaped/fake_gold_block" | "minecraft:wild_armor_trim_smithing_template" | "minecraft:cracked_polished_blackstone_bricks" | "minecraft:deepslate_brick_slab_from_cobbled_deepslate_stonecutting" | "matc:crystals/tertium" | "farmersdelight:cutting/jungle_sign" | "thermal:fluid_cell" | "mysticalagriculture:essence/minecraft/ghast_tear" | "minecraft:snout_armor_trim_smithing_template" | "caveopolis:cyan_colored_wooden_plank_fence" | "thermal:light_blue_concrete_powder_with_slag" | "caveopolis:pink_colored_cobblestone_stairs" | "thermal:compat/mysticalagriculture/insolator_mysticalag_air_seeds" | "mysticalagriculture:seed/infusion/coral" | "mysticalagriculture:gear/awakened_supremium_chestplate" | "strainers:summoning_block/enderman" | "thermal:machines/centrifuge/centrifuge_white_tulip" | "minecraft:pink_candle" | "caveopolis:cyan_colored_cobblestone" | "minecraft:red_terracotta" | "suppsquared:item_shelf_bamboo" | "thermal:compat/immersiveengineering/press_ie_uranium_nugget_unpacking" | "caveopolis:light_gray_colored_stone_brick_stairs" | "mysticalagriculture:essence/enderio/grains_of_infinity" | "thermal:compat/tconstruct/tree_extractor_tconstruct_sky_slime" | "thermal:armor/beekeeper_helmet" | "mysticalagriculture:seed/reprocessor/prismarine" | "mysticalagriculture:augment/mining_fatigue_resistance" | "minecraft:ward_armor_trim_smithing_template_smithing_trim" | "minecraft:deepslate_tile_stairs" | "caveopolis:sprayer/glass_block/red" | "titanium:test_serializer/dirt_to_diamod" | "caveopolis:lime_colored_stone_button" | "farmersdelight:mangrove_cabinet" | "thermal:compat/tconstruct/bottler_tconstruct_lavawood" | "minecraft:oxidized_cut_copper_slab_from_oxidized_copper_stonecutting" | "thermal:fire_charge/signalum_ingot_4" | "alltheores:copper_ore_hammer" | "minecraft:eye_armor_trim_smithing_template_smithing_trim" | "minecraft:polished_diorite_slab" | "mysticalagriculture:essence/minecraft/netherrack" | "caveopolis:sprayer/colored_cobblestone_bricks/brown_colored_stone_bricks" | "mysticalagriculture:essence/minecraft/sand" | "minecraft:waxed_exposed_cut_copper_slab_from_waxed_exposed_cut_copper_stonecutting" | "mysticalagriculture:farmland_till" | "nec:acacia_chest" | "mysticalagriculture:inferium_ingot_uncraft" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/white" | "mysticalagradditions:tconstruct/casting/tertium/nugget_gold_cast" | "strainers:summoning_block/villager" | "caveopolis:black_colored_cobblestone_slab" | "minecraft:netherite_hoe_smithing" | "thermal:storage/lead_nugget_from_ingot" | "farmersdelight:diamond_knife" | "minecraft:prismarine_stairs_from_prismarine_stonecutting" | "caveopolis:sprayer/colored_wooden_plank_fence/gray" | "minecraft:quartz_stairs_from_quartz_block_stonecutting" | "thermal:smelting/tin_ingot_from_raw_blasting" | "caveopolis:black_colored_stone_brick_wall_from_black_colored_stone_bricks_stonecutting" | "alltheores:bronze_ingot_from_dust" | "thermal:machines/press/press_lumium_ingot_to_plate" | "caveopolis:sprayer/shulker_box/lime" | "caveopolis:black_colored_cobblestone_brick_slab_from_black_colored_cobblestone_bricks_stonecutting" | "caveopolis:sprayer/remove_color/stone_bricks" | "minecraft:wayfinder_armor_trim_smithing_template_smithing_trim" | "minecraft:diamond_from_smelting_deepslate_diamond_ore" | "farmersdelight:yellow_hanging_canvas_sign" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/green" | "minecraft:birch_pressure_plate" | "tmttd:machines/press/glowberry_press" | "thermal:machines/press/press_barley_unpacking" | "caveopolis:gray_colored_stone_brick_stairs_from_gray_colored_stone_bricks_stonecutting" | "libraryferret:smelting/gold_coins_jtl" | "caveopolis:sprayer/colored_wood/gray" | "caveopolis:yellow_colored_wooden_plank_fence" | "caveopolis:sprayer/concrete/green" | "minecraft:emerald_from_blasting_deepslate_emerald_ore" | "mysticalagriculture:seed/reprocessor/blizz" | "minecraft:black_bed" | "thermal:machines/smelter/smelter_electrum_tools" | "caveopolis:sprayer/colored_stone_bricks/white_colored_stone_bricks" | "mysticalagriculture:essence/minecraft/red_mushroom" | "strainers:miner_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "thermal:compat/create/smelter_create_crushed_raw_iron" | "farmersdelight:cooked_bacon" | "storagedrawers:redstone_upgrade" | "thermal:compat/create/bottler_create_builders_tea" | "thermal:machines/press/press_rose_gold_ingot_to_gear" | "alltheores:mek_processing/platinum/dust/from_ore" | "mysticalagriculture:gear/tertium_axe" | "mysticalagriculture:seed/crafting/apatite" | "caveopolis:cobblestone_bricks_from_cobblestone_stonecutting" | "thermal:machines/press/unpacking/press_red_sandstone_unpacking" | "framedcompactdrawers:framed_half_two" | "caveopolis:sprayer/colored_stone/light_blue_colored_stone" | "minecraft:bowl" | "mysticalagriculture:seed/reprocessor/cyanite" | "thermal:fuels/disenchantment/disenchantment_experience_bottle" | "mysticalagriculture:prosperity_ingot_block" | "alltheores:mek_processing/aluminum/clump/from_shard" | "alltheores:mek_processing/platinum/dust/from_ingot" | "mysticalagriculture:essence/minecraft/rabbit_hide" | "caveopolis:sprayer/colored_wooden_plank_button/magenta" | "minecraft:purple_concrete_powder" | "thermal:compat/biomesoplenty/tree_extractor_bop_jacaranda" | "opolisutilities:resource_generator_2/speed_blocks/redstone_alloy" | "caveopolis:white_colored_wooden_plank_fence_from_white_colored_wooden_planks_stonecutting" | "minecraft:spectral_arrow" | "alltheores:copper_dust_from_hammer_ingot_crushing" | "minecraft:red_carpet" | "caveopolis:white_colored_wooden_plank_fence_gate_from_white_colored_wooden_planks_stonecutting" | "caveopolis:blue_colored_stone_wall_from_blue_colored_stone_stonecutting" | "thermal:machines/press/packing2x2/press_clay_packing" | "caveopolis:gray_colored_stone_button_from_gray_colored_stone_stonecutting" | "mysticalagradditions:insanium_block" | "caveopolis:sprayer/colored_cobblestone_brick_wall/orange_colored_stone_brick_wall" | "supplementaries:candle_holders/candle_holder_light_gray" | "thermal:machines/press/packing3x3/press_electrum_packing" | "thermal:storage/slag_block" | "mysticalagriculture:essence/minecraft/chicken" | "aquamirae:terrible_leggings" | "minecraft:dye_magenta_bed" | "thermal:compat/mysticalagriculture/insolator_mysticalag_saltpeter_seeds" | "alltheores:raw_tin_from_block" | "mysticalagriculture:gear/awakened_supremium_bow" | "mysticalagradditions:insanium_ingot_block_uncraft" | "industrialforegoing:laser_drill_ore/ancient_debris" | "industrialforegoing:laser_drill_ore/raw_materials/galena" | "minecraft:bamboo_block" | "alltheores:lead_dust_from_hammer_crushing" | "caveopolis:cyan_colored_stone_brick_wall" | "farmersdelight:cooking/dog_food" | "mysticalagriculture:essence/minecraft/music_disc_pigstep" | "caveopolis:white_colored_stone_button_from_white_colored_stone_stonecutting" | "caveopolis:sprayer/shulker_box/blue" | "minecraft:dye_orange_bed" | "thermal:machines/press/unpacking/press_lapis_unpacking" | "thermal:machines/smelter/smelter_lead_dust" | "strainers:andesite_from_straining_barrier_in_strainers_purified_water_fluid" | "mysticalagriculture:essence/minecraft/carrot" | "thermal:compat/mysticalagriculture/insolator_mysticalag_fish_seeds" | "farmersdelight:cutting/wild_tomatoes" | "thermal:machines/press/unpacking/press_slag_unpacking" | "thermal:rockwool/yellow_rockwool_from_dye" | "sophisticatedbackpacks:iron_backpack_from_copper" | "minecraft:waxed_weathered_cut_copper_from_waxed_weathered_copper_stonecutting" | "opolisutilities:resource_generator_2/speed_blocks/redstone" | "mysticalagriculture:seed/reprocessor/certus_quartz" | "mysticalagriculture:essence/minecraft/end_stone" | "alltheores:raw_lead_block" | "mysticalagriculture:supremium_block" | "glassential:glass_dark_ethereal_reverse" | "strainers:summoning_block/skeleton" | "thermal:machine_centrifuge" | "minecraft:smooth_red_sandstone_stairs" | "mysticalagriculture:seed/crafting/dragon_egg" | "caveopolis:purple_colored_sign" | "thermal:devices/rock_gen/rock_gen_basalt" | "supplementaries:inspirations/flag_clear" | "mysticalagriculture:inferium_ingot_recraft" | "minecraft:stone_pickaxe" | "minecraft:light_blue_glazed_terracotta" | "minecraft:dispenser" | "mysticalagriculture:seed/infusion/tungsten" | "minecraft:cyan_stained_glass_pane" | "minecraft:daylight_detector" | "lfpirates:deckhand_helmet_recipe_1" | "minecraft:purple_glazed_terracotta" | "strainers:salmon_from_straining_fishing_rod_in_minecraft_water" | "strainers:upgrade_stats/specialized_input_upgrade" | "thermal_extra:augments/area_radius_augment_4" | "farmersdelight:cutting/salmon" | "thermal_extra:augments/area_radius_augment_2" | "cozy_home:cherry_bench_recipe" | "thermal:compat/mekanism/press_mek_uranium_nugget_unpacking" | "thermal_extra:augments/area_radius_augment_3" | "caveopolis:orange_colored_cobblestone_brick_wall_from_orange_colored_cobblestone_bricks_stonecutting" | "thermal_extra:augments/area_radius_augment_1" | "farmersdelight:cooking/ratatouille" | "mysticalagriculture:seed/crafting/nether_star" | "caveopolis:blue_colored_wooden_plank_slab_from_blue_colored_wooden_planks_stonecutting" | "aquaculture:planks_from_driftwood" | "mysticalagriculture:seed/infusion/nitro_crystal" | "alltheores:mek_processing/iridium/dust/from_raw_ore" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/black" | "caveopolis:blue_colored_wooden_plank_crafting_table" | "farmersdelight:hanging_canvas_sign" | "thermal:machines/press/packing3x3/press_coal_packing" | "thermal_extra:machine/dynamo/numismatic/dragonsteel_coin" | "alltheores:nickel_ingot_from_block" | "minecraft:hopper" | "mysticalagriculture:seed/crafting/cyanite" | "alltheores:zinc_nugget_from_ingot" | "minecraft:raw_gold" | "mysticalagriculture:essence/immersiveengineering/hop_graphite_ingot" | "caveopolis:sprayer/colored_logs/magenta" | "thermal:lightning_charge/zombified_piglin_from_pig" | "minecraft:green_banner" | "caveopolis:brown_colored_wooden_plank_fence_gate_from_brown_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/terracotta/black" | "thermal:compat/tconstruct/press_tconstruct_ender_slime_2x2_unpacking" | "thermal:machines/pulverizer/pulverizer_copper_plate_to_dust" | "industrialforegoing:laser_lens_brown_recolor" | "farmersdelight:paper_from_tree_bark" | "mysticalagriculture:seed/infusion/flux_infused_ingot" | "farmersdelight:cutting/lily_of_the_valley" | "mysticalagriculture:seed/reprocessor/silicon" | "minecraft:cooked_cod" | "minecraft:iron_helmet" | "caveopolis:pink_colored_hanging_sign" | "thermal:machines/smelter/smelter_iron_tools" | "thermal:machines/pulverizer/pulverizer_rose_gold_ingot_to_dust" | "minecraft:cartography_table" | "mysticalagriculture:seed/crafting/gaia_spirit" | "minecraft:polished_diorite" | "thermal:machines/press/press_signalum_nugget_to_coin" | "mysticalagriculture:seed/crafting/netherite" | "caveopolis:magenta_colored_wooden_plank_trapdoor_from_magenta_colored_wooden_planks_stonecutting" | "alltheores:mek_processing/silver/crystal/from_slurry" | "mysticalagradditions:tconstruct/casting/prudentium/nugget_sand_cast" | "cozy_home:warped_bench_recipe" | "caveopolis:sprayer/colored_stone_stairs/yellow_colored_stone_stairs" | "minecraft:cooked_porkchop_from_smoking" | "mysticalagriculture:augment/strength_iii" | "opolisutilities:resource_generator_2/speed_blocks/dark_steel" | "thermal:parts/bronze_gear" | "mysticalagriculture:inferium_furnace" | "caveopolis:light_gray_colored_cobblestone" | "caveopolis:sprayer/colored_cobblestone_slab/blue_colored_stone_slab" | "opolisutilities:resource_generator_2/speed_blocks/signalum" | "aquamirae:oxygen_tank" | "caveopolis:sprayer/colored_wood/brown" | "systeams:boilers/disenchantment" | "caveopolis:black_colored_wooden_plank_stairs_from_black_colored_wooden_planks_stonecutting" | "thermal:machines/smelter/smelter_nickel_armor" | "storagedrawers:diamond_storage_upgrade" | "cozy_home:mangrove_wall_clock_recipe" | "caveopolis:purple_spray_can" | "thermal:compat/mysticalagriculture/insolator_mysticalag_tinkers_bronze_seeds" | "mysticalagriculture:essence/minecraft/egg" | "systeams:boilers/gourmand" | "mysticalagradditions:tconstruct/casting/supremium/block" | "farmersdelight:gray_canvas_sign" | "alltheores:tin_ingot_from_slate_ore" | "thermal:fuels/gourmand/gourmand_strawberry_block" | "alltheores:iron_ore_hammer" | "libraryferret:blasting/emerald_coins_jtl" | "caveopolis:white_colored_cobblestone_wall" | "caveopolis:gray_colored_wooden_plank_trapdoor_from_gray_colored_wooden_planks_stonecutting" | "minecraft:light_blue_banner" | "industrialforegoing:laser_drill_ore/raw_materials/tungsten" | "caveopolis:sprayer/colored_leaves/green" | "caveopolis:sprayer/colored_wooden_plank_stairs/brown" | "mysticalagriculture:seed/reprocessor/chicken" | "thermal:storage/sulfur_from_block" | "thermal:smelting/cooked_corn_from_smoking" | "glassential:glass_dark_ethereal_from_ethereal" | "caveopolis:sprayer/stripped_colored_wood/brown" | "minecraft:heavy_weighted_pressure_plate" | "minecraft:stone_shovel" | "thermal_extra:machine/press/soul_infused_gear" | "libraryferret:crafting_shaped/fake_netherite_block" | "thermal:smelting/lead_ingot_from_deepslate_ore_blasting" | "minecraft:deepslate_tiles_from_polished_deepslate_stonecutting" | "thermal:machines/insolator/insolator_catalyst_compost" | "opolisutilities:resource_generator/calcite" | "industrialforegoing:spores_recreator" | "lfpirates:sailor_blue_tier_1_body_recipe_1" | "minecraft:polished_blackstone_stairs" | "minecraft:netherite_pickaxe_smithing" | "smallships:spruce_drakkar" | "minecraft:deepslate_brick_stairs" | "mysticalagriculture:essence/common/rubber" | "opolisutilities:resource_generator_2/speed_blocks/ruby" | "farmersdelight:cooking/fried_rice" | "systeams:boilers/magmatic" | "thermal:parts/diamond_gear" | "caveopolis:cyan_colored_stone_pressure_plate" | "thermal:compat/mysticalagriculture/insolator_mysticalag_aquamarine_seeds" | "alltheores:mek_processing/iridium/ore/deepslate_from_raw" | "mysticalagriculture:seed/reprocessor/energetic_alloy" | "alltheores:mek_processing/iridium/ore/from_dust" | "supplementaries:stonecutting/ash_brick_wall_from_bricks" | "farmersdelight:honey_cookie" | "minecraft:golden_helmet" | "mysticalagriculture:gear/awakened_supremium_leggings" | "minecraft:light_blue_dye_from_blue_orchid" | "thermal:machine_refinery" | "minecraft:mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting" | "thermal:compat/mysticalagriculture/insolator_mysticalag_uranium_seeds" | "thermal:compat/farmersdelight/bottler_farmersdelight_milk_bottle" | "mysticalagriculture:essence/botania/green_mystical_flower" | "minecraft:polished_deepslate" | "thermal:fire_charge/lumium_glass_2" | "farmersdelight:cutting/birch_log" | "mysticalagriculture:gear/prudentium_helmet" | "caveopolis:gray_colored_cobblestone" | "opolisutilities:upgrades/test" | "mysticalagriculture:augment/blindness_resistance" | "supplementaries:integration/sconce_haunting" | "sophisticatedbackpacks:advanced_void_upgrade" | "alltheores:mek_processing/nickel/clump/from_raw_ore" | "thermal:machines/smelter/smelter_glass_signalum" | "thermal:compat/mysticalagriculture/insolator_mysticalag_lumium_seeds" | "caveopolis:sprayer/colored_cobblestone_brick_wall/light_gray_colored_stone_brick_wall" | "thermal:fuels/lapidary/lapidary_quartz" | "fluiddrawerslegacy:fluiddrawer" | "farmersdelight:black_hanging_canvas_sign" | "thermal:machines/smelter/smelter_signalum_dust" | "farmersdelight:cutting/warped_stem" | "thermal:machines/pulverizer/pulverizer_quartz_ore" | "alltheores:mek_processing/iridium/slurry/dirty/from_raw_block" | "caveopolis:orange_colored_stone_stairs" | "alltheores:mek_processing/silver/ore/from_dust" | "thermal_extra:machine/smelter/dragonsteel_ingot" | "caveopolis:gray_colored_wooden_plank_door_from_gray_colored_wooden_planks_stonecutting" | "minecraft:cooked_porkchop_from_campfire_cooking" | "minecraft:cyan_stained_glass_pane_from_glass_pane" | "mysticalagriculture:seed/reprocessor/squid" | "thermal:smelting/redstone_from_spores_smelting" | "thermal:compat/biomesoplenty/insolator_bop_fir_sapling" | "storagedrawers:fill_level_upgrade" | "industrialforegoing:advanced_black_hole_unit" | "supplementaries:stonecutting/blackstone_tile" | "minecraft:dye_red_carpet" | "aquaculture:iron_fishing_rod" | "caveopolis:lime_colored_cobblestone_slab" | "thermal:machines/press/unpacking/press_charcoal_unpacking" | "mysticalagradditions:essence/awakened_draconium_nugget" | "caveopolis:magenta_colored_wooden_plank_crafting_table" | "caveopolis:sprayer/colored_wooden_plank_button/brown" | "thermal:storage/peanut_block" | "mysticalagriculture:essence/minecraft/soul_soil" | "caveopolis:brown_colored_wooden_plank_stairs" | "alltheores:nickel_rod" | "mysticalagriculture:soulium_spawner/creeper" | "mysticalagriculture:essence/minecraft/bubble_coral" | "alltheores:mek_processing/aluminum/dust/from_raw_block" | "thermal:machines/smelter/smelter_tin_armor" | "lfpirates:sailor_red_tier_1_body_recipe_1" | "aquamirae:terrible_chestplate" | "strainers:saddle_from_straining_fishing_rod_in_minecraft_water" | "farmersdelight:jungle_cabinet" | "ftbquests:screen_5" | "ftbquests:screen_7" | "ftbquests:screen_1" | "strainers:summoning_block/shulker" | "thermal:compat/tconstruct/chiller_tconstruct_slimesteel_ingot" | "ftbquests:screen_3" | "alltheores:bronze_block" | "thermal:fuels/numismatic/numismatic_constantan_coin" | "aquaculture:iron_nugget_from_blasting" | "caveopolis:sprayer/remove_color/cobblestone" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/orange" | "supplementaries:candle_holders/candle_holder_light_blue_dye" | "thermal:machines/bottler/bottler_water_bottle" | "minecraft:smooth_quartz_stairs_from_smooth_quartz_stonecutting" | "smallships:oak_drakkar" | "cozy_home:bamboo_chair_recipe" | "thermal:storage/apatite_block" | "thermal:compat/mekanism/press_mek_osmium_packing" | "caveopolis:sprayer/colored_leaves/black" | "farmersdelight:iron_nugget_from_blasting_knife" | "mysticalagriculture:seed/infusion/slimesteel" | "mysticalagriculture:seed/crafting/copper" | "minecraft:wooden_sword" | "mysticalagriculture:seed/infusion/fish" | "mysticalagriculture:essence/minecraft/horn_coral_block" | "thermal:machines/press/unpacking/press_wool_unpacking" | "cozy_home:sofa_brown_recipe" | "supplementaries:flint_block_uncrafting" | "suppsquared:candle_holders/gold_candle_holder_cyan" | "strainers:meshes/copper" | "mysticalagriculture:seed/crafting/queens_slime" | "caveopolis:sprayer/colored_cobblestone_wall/blue_colored_stone_wall" | "alltheores:mek_processing/zinc/clump/from_shard" | "farmersdelight:blue_hanging_canvas_sign" | "strainers:upgrade_stats/everlasting_duration_upgrade" | "thermal:device_water_gen" | "thermal:machines/press/packing3x3/press_packed_ice_packing" | "minecraft:smooth_quartz_slab" | "thermal:machines/pulverizer/pulverizer_lumium_ingot_to_dust" | "thermal:machines/press/unpacking/press_coal_coke_unpacking" | "industrialforegoing:gold_gear" | "alltheores:mek_processing/zinc/ore/from_dust" | "alltheores:tools_materials/platinum/platinum_from_block" | "mysticalagriculture:gear/supremium_scythe" | "mysticalagriculture:awakened_supremium_ingot" | "thermal:machines/smelter/smelter_alloy_lumium" | "cozy_home:crimson_bench_recipe" | "farmersdelight:cutting/poppy" | "mysticalagriculture:augment/speed_iii" | "minecraft:lapis_lazuli_from_smelting_lapis_ore" | "alltheores:signalum_ingot_from_block" | "caveopolis:sprayer/colored_cobblestone_brick_slab/blue" | "caveopolis:sprayer/colored_logs/brown" | "alltheores:osmium_block" | "cozy_home:drawer_warped_recipe" | "nec:caveop_light_blue_colored_wooden_chest" | "caveopolis:sprayer/colored_stone_brick_stairs/cyan_colored_stone_brick_stairs" | "alltheores:invar_ingot_from_dust" | "thermal:machines/refinery/refinery_resin" | "minecraft:purple_stained_glass_pane_from_glass_pane" | "thermal:storage/eggplant_from_block" | "thermal:compat/mysticalagriculture/insolator_mysticalag_cyanite_seeds" | "opolisutilities:sapling_grower" | "minecraft:cookie" | "aquaculture:spruce_fish_mount" | "minecraft:lightning_rod" | "mysticalagriculture:tertium_essence_uncraft" | "minecraft:brown_stained_glass_pane_from_glass_pane" | "minecraft:orange_concrete_powder" | "thermal:machines/centrifuge/centrifuge_brown_wool" | "alltheores:mek_processing/aluminum/slurry/clean" | "mysticalagriculture:seed/infusion/fire" | "minecraft:shears" | "cozy_home:table_stump_acacia_recipe" | "caveopolis:green_colored_sign_from_green_colored_wooden_planks_stonecutting" | "thermal:storage/potato_from_block" | "thermal:compat/mysticalagriculture/insolator_mysticalag_marble_seeds" | "caveopolis:black_colored_wooden_plank_fence_from_black_colored_wooden_planks_stonecutting" | "suppsquared:candle_holders/gold_candle_holder_brown" | "thermal:energy_cell_frame" | "caveopolis:orange_colored_cobblestone_bricks" | "thermal:xp_stew" | "mysticalagriculture:enchanter/respiration" | "minecraft:yellow_stained_glass_pane_from_glass_pane" | "thermal:machines/press/press_rice_packing" | "caveopolis:sprayer/concrete/red" | "industrialforegoing:meat_feeder" | "caveopolis:green_colored_wooden_plank_fence" | "alltheores:signalum_ingot_from_dust_blasting" | "caveopolis:sprayer/colored_wooden_plank_button/gray" | "strainers:upgrade_stats/everlasting_mesh_upgrade" | "thermal_extra:storage/soul_infused_nugget_from_ingot" | "thermal:machines/smelter/smelter_enderium_dust" | "thermal:compat/biomesoplenty/sawmill_bop_hellbark_logs" | "minecraft:stone_brick_slab_from_stone_bricks_stonecutting" | "storagedrawers:spruce_full_drawers_2" | "storagedrawers:spruce_full_drawers_1" | "storagedrawers:spruce_full_drawers_4" | "strainers:upgrades/everlasting/everlasting_output_upgrade" | "caveopolis:sprayer/colored_stone_bricks/gray_colored_stone_bricks" | "alltheores:copper_dust_from_hammer_crushing" | "caveopolis:light_gray_colored_stone_brick_slab" | "caveopolis:light_blue_colored_stone_crafting_table" | "mysticalagriculture:soulium_spawner/zombie" | "supplementaries:stonecutting/ash_brick_slab_from_bricks" | "caveopolis:purple_colored_wooden_plank_stairs_from_purple_colored_wooden_planks_stonecutting" | "thermal:machines/press/unpacking/press_bronze_nugget_unpacking" | "thermal:parts/tin_gear" | "cozy_home:bamboo_mirror_recipe" | "thermal:machines/press/unpacking/press_bitumen_unpacking" | "tmttd:cooking/t_stuffed_pumpkin" | "cozy_home:table_oak_recipe" | "alltheores:osmium_dust_from_hammer_crushing" | "caveopolis:gray_colored_stone_bricks_from_gray_colored_stone_stonecutting" | "thermal:machines/press/unpacking/press_silver_nugget_unpacking" | "farmersdelight:sweet_berry_cookie" | "thermal:machines/centrifuge/centrifuge_sunflower" | "mysticalagriculture:essence/minecraft/lily_pad" | "thermal:machines/press/press_tomato_jar" | "caveopolis:pink_colored_cobblestone_brick_wall_from_pink_colored_cobblestone_bricks_stonecutting" | "caveopolis:sprayer/colored_cobblestone_brick_wall/blue_colored_stone_brick_wall" | "caveopolis:sprayer/wool/light_gray_wool" | "mysticalagriculture:seed/crafting/basalt" | "supplementaries:stonecutting/blackstone_tile_wall_from_bricks" | "strainers:cherry_sapling_from_straining_barrier_in_minecraft_air" | "mysticalagriculture:seed/crafting/basalz" | "thermal:machines/chiller/chiller_lava_to_obsidian" | "thermal:compat/immersiveengineering/press_ie_aluminum_packing" | "alltheores:mek_processing/aluminum/slurry/dirty_from_raw" | "alltheores:silver_dust_from_hammer_crushing" | "mysticalagriculture:augment/tilling_aoe_iii" | "supplementaries:candle_holders/candle_holder_gray" | "caveopolis:lime_colored_wooden_plank_stairs_from_lime_colored_wooden_planks_stonecutting" | "minecraft:oak_fence_gate" | "farmersdelight:beetroot_crate" | "supplementaries:turn_table" | "alltheores:iron_dust_from_hammer_ingot_crushing" | "mysticalagriculture:essence/minecraft/zombie_head" | "thermal:machines/insolator/insolator_tube_coral_fan" | "thermal_extra:machine/press/shellite_gear" | "itemfilters:max_count" | "thermal:smelting/lead_ingot_from_ore_blasting" | "thermal_extra:machine/dynamo/frost/blizz_cube" | "industrialforegoingsouls:laser_drill_ore/echo_shard" | "caveopolis:sprayer/colored_cobblestone_brick_slab/lime" | "thermal:smelting/tin_ingot_from_deepslate_ore_blasting" | "caveopolis:purple_colored_cobblestone_slab" | "mysticalagradditions:insanium_coal" | "alltheores:smelting_dust/nickel_ingot" | "minecraft:coast_armor_trim_smithing_template_smithing_trim" | "minecraft:sandstone_stairs_from_sandstone_stonecutting" | "thermal:machines/smelter/smelter_bronze_tools" | "minecraft:gray_carpet" | "mysticalagriculture:inferium_essence_smelted" | "mysticalagriculture:essence/minecraft/flint" | "thermal:machines/smelter/smelter_lapis_ore" | "thermal:compat/quark/insolator_quark_azalea_bush" | "aquaculture:oak_fish_mount" | "mysticalagriculture:essence/integrateddynamics/menril_log" | "mysticalagriculture:essence/mekanism/fluorite" | "minecraft:crimson_hanging_sign" | "caveopolis:sprayer/colored_wooden_plank_fence_gate/black" | "mysticalagradditions:tconstruct/tools/materials/tertium/block" | "thermal_extra:storage/twinite_block" | "thermal:tools/redprint" | "mysticalagradditions:tconstruct/tools/melting/imperium" | "mysticalagriculture:passive_soulium_dagger" | "cozy_home:sofa_lime_recipe" | "alltheores:nickel_ingot_from_ore" | "minecraft:red_nether_brick_stairs" | "opolisutilities:resource_generator_2/speed_blocks/graphite" | "caveopolis:green_colored_wooden_plank_pressure_plate" | "farmersdelight:pink_hanging_canvas_sign" | "minecraft:brewing_stand" | "mysticalagriculture:essence/minecraft/brain_coral" | "mysticalagriculture:soulium_spawner/slime" | "alltheores:aluminum_block" | "caveopolis:sprayer/colored_cobblestone_brick_slab/light_blue" | "thermal:machines/pulverizer/pulverizer_cinnabar" | "sophisticatedbackpacks:chipped/loom_table_upgrade" | "strainers:heartbreak_pottery_sherd_from_straining_suspicious_gravel_in_minecraft_water" | "supplementaries:bamboo_spikes" | "caveopolis:cobblestone_brick_slab" | "thermal:machines/press/unpacking/press_iron_nugget_unpacking" | "farmersdelight:yellow_canvas_sign" | "thermal:machines/pulverizer/pulverizer_tin_plate_to_dust" | "caveopolis:sprayer/colored_saplings/light_blue" | "thermal:compat/mysticalagriculture/insolator_mysticalag_blizz_seeds" | "thermal:compat/tconstruct/chiller_tconstruct_gold_ingot" | "mysticalagriculture:seed/reprocessor/end_steel" | "thermal:machines/press/press_enderium_ingot_to_coin" | "mysticalagriculture:seed/reprocessor/wood" | "thermal:machines/centrifuge/centrifuge_purple_rockwool" | "caveopolis:blue_colored_cobblestone_stairs" | "minecraft:diamond_block" | "industrialforegoing:laser_lens_pink_recolor" | "minecraft:deepslate_tile_stairs_from_deepslate_bricks_stonecutting" | "lfpirates:pirate_tier_2_boots_recipe_1" | "caveopolis:cyan_colored_wooden_plank_fence_gate" | "industrialforegoing:laser_drill_ore/ores/sapphire" | "alltheores:mek_processing/platinum/dust/from_dirty_dust" | "minecraft:diorite_slab" | "farmersdelight:lime_canvas_sign" | "mysticalagriculture:essence/minecraft/dripstone" | "minecraft:yellow_stained_glass" | "thermal:storage/rose_gold_nugget_from_ingot" | "thermal:compat/mysticalagriculture/insolator_mysticalag_tin_seeds" | "thermal:fuels/stirling/stirling_coal" | "mysticalagriculture:essence/botania/terrasteel_ingot" | "caveopolis:gray_colored_stone_wall_from_gray_colored_stone_stonecutting" | "cozy_home:oak_mirror_stand_recipe" | "mysticalagradditions:essence/gaia_spirit" | "thermal:machines/smelter/smelter_lead_tools" | "caveopolis:orange_colored_cobblestone_brick_slab" | "cozy_home:jungle_chair_recipe" | "alltheores:mek_processing/zinc/dust/from_raw_ore" | "minecraft:pumpkin_seeds" | "mysticalagriculture:seed/reprocessor/compressed_iron" | "mysticalagriculture:seed/reprocessor/ghast" | "caveopolis:sprayer/wool/black_wool" | "alltheores:uranium_ingot_from_slate_ore" | "caveopolis:purple_colored_cobblestone_wall_from_purple_colored_cobblestone_stonecutting" | "sophisticatedbackpacks:restock_upgrade" | "caveopolis:sprayer/colored_stone_pressure_plate/red" | "thermal:machines/press/press_constantan_ingot_to_coin" | "caveopolis:sprayer/colored_wooden_plank_slab/light_gray" | "minecraft:cooked_mutton" | "farmersdelight:wheat_dough_from_eggs" | "thermal:compat/immersiveengineering/smelter_ie_aluminum_ore" | "mysticalagradditions:tertium_coal_block" | "minecraft:bookshelf" | "mysticalagriculture:seed/crafting/chrome" | "minecraft:lapis_block" | "caveopolis:sprayer/glass_block/gray" | "farmersdelight:pumpkin_seeds_from_slice" | "supplementaries:flower_box" | "strainers:white_tulip_from_straining_grass_in_strainers_purified_water_fluid" | "farmersdelight:cutting/birch_sign" | "mysticalagradditions:insanium_block_combine" | "lfpirates:pirate_tier_1_boots_recipe_1" | "dankstorage:3_to_4" | "thermal:machines/smelter/smelter_alloy_netherite" | "cozy_home:jungle_wall_clock_recipe" | "minecraft:light_gray_terracotta" | "mysticalagriculture:essence/common/platinum_ingot" | "opolisutilities:catalogue/selling/caveopolis/cyan_spray_can" | "caveopolis:cyan_colored_stone_button" | "lfpirates:pirate_tier_1_helmet_recipe_1" | "lfpirates:pirate_tier_2_body_recipe_1" | "caveopolis:sprayer/colored_wooden_plank_button/light_gray" | "mysticalagriculture:essence/minecraft/melon" | "minecraft:oak_boat" | "thermal:fuels/gourmand/gourmand_onion_block" | "cozy_home:mangrove_mirror_recipe" | "caveopolis:gray_colored_stone_brick_slab" | "thermal:machines/pyrolyzer/pyrolyzer_logs" | "minecraft:red_dye_from_rose_bush" | "alltheores:zinc_ingot_from_raw_blasting" | "alltheores:tools_materials/platinum/platinum_from_nugget" | "caveopolis:light_blue_colored_wooden_plank_fence_gate_from_light_blue_colored_wooden_planks_stonecutting" | "cozy_home:counter_quartz_recipe" | "glassential:glass_dark_ethereal_reverse_from_ethereal_reverse" | "caveopolis:green_colored_wood" | "strainers:lily_of_the_valley_from_straining_grass_in_strainers_purified_water_fluid" | "mysticalagriculture:enchanter/sweeping" | "caveopolis:sprayer/glazed_terracotta/light_blue" | "mysticalagriculture:augment/tilling_aoe_iv" | "igleelib:derium_block" | "minecraft:jungle_fence" | "mysticalagriculture:dye_agglomeratio" | "thermal:storage/rich_slag_block" | "caveopolis:white_colored_hanging_sign_from_stripped_white_colored_log_stonecutting" | "industrialforegoing:crusher/gravel_sand" | "opolisutilities:drying_table/paper" | "minecraft:glass_bottle" | "minecraft:iron_ingot_from_smelting_raw_iron" | "thermal:dirt_crafting" | "mysticalagriculture:seed/reprocessor/netherite" | "mysticalagriculture:augment/tilling_aoe_ii" | "thermal:machines/press/unpacking/press_apple_unpacking" | "thermal:compat/biomesoplenty/insolator_bop_orange_autumn_sapling" | "mysticalagriculture:essence/tconstruct/queens_slime_ingot" | "caveopolis:sprayer/terracotta/green" | "industrialforegoing:supreme_black_hole_unit" | "caveopolis:red_colored_wooden_planks" | "caveopolis:light_blue_colored_cobblestone_brick_wall" | "minecraft:stripped_warped_hyphae" | "thermal:machines/bottler/bottler_syrup_bottle" | "storagedrawers:emerald_storage_upgrade" | "mysticalagriculture:seed/infusion/iron" | "mysticalagriculture:essence/minecraft/orange_dye" | "minecraft:cherry_hanging_sign" | "thermal:device_tree_extractor" | "caveopolis:light_blue_colored_stone_button_from_light_blue_colored_stone_stonecutting" | "thermal:pink_concrete_powder_with_slag" | "caveopolis:light_blue_colored_stone_button" | "thermal:machines/insolator/insolator_wither_rose" | "alltheores:tools_materials/aluminum/aluminum_from_block" | "caveopolis:sprayer/remove_color/wooden_plank_doors" | "mysticalagriculture:seed/infusion/silver" | "thermal:smelting/cooked_mushroom_from_smoking" | "strainers:mini_charcoal_from_straining_gravel_in_minecraft_water" | "thermal:smelting/silver_ingot_from_dust_smelting" | "thermal:compat/tconstruct/press_tconstruct_hepatizon_nugget_packing" | "thermal:machines/insolator/insolator_carrot" | "caveopolis:white_colored_stone_stairs_from_white_colored_stone_stonecutting" | "caveopolis:red_colored_stone_brick_wall_from_red_colored_stone_bricks_stonecutting" | "strainers:danger_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "thermal:machines/press/packing3x3/press_lapis_packing" | "mysticalagriculture:gear/awakened_supremium_shears" | "mysticalagriculture:gear/prudentium_shears" | "industrialforegoing:mycelial_death" | "mysticalagriculture:souls/string" | "caveopolis:red_colored_wooden_plank_fence_gate_from_red_colored_wooden_planks_stonecutting" | "thermal:fire_charge/invar_ingot_3" | "mysticalagriculture:augment/weakness_resistance" | "minecraft:bamboo_hanging_sign" | "cozy_home:desk_mangrove_recipe" | "caveopolis:sprayer/colored_stone_pressure_plate/pink" | "aquamirae:poisoned_chakra" | "minecraft:waxed_exposed_cut_copper_from_waxed_exposed_copper_stonecutting" | "thermal:machines/press/press_bronze_ingot_to_coin" | "mysticalagriculture:gear/supremium_bow" | "mysticalagriculture:gear/tertium_shovel" | "thermal:smelting/polished_slag_from_smelting" | "strainers:upgrade_stats/improved_duration_upgrade" | "caveopolis:sprayer/candles/black" | "thermal:compat/tconstruct/press_tconstruct_ender_slime_3x3_packing" | "minecraft:deepslate_tile_wall_from_polished_deepslate_stonecutting" | "thermal:machines/centrifuge/centrifuge_cornflower" | "minecraft:purple_dye" | "alltheores:silver_nugget_from_ingot" | "minecraft:quartz_slab" | "caveopolis:stone_torch" | "thermal:machines/insolator/insolator_wheat" | "farmersdelight:cabbage" | "thermal_extra:smelting/twinite_ingot_from_dust_smelting" | "caveopolis:sprayer/remove_color/colored_wooden_plank_crafting_table" | "caveopolis:stripped_light_gray_colored_wood" | "thermal_extra:machine/dynamo/compression/crystallized_sunflower_oil" | "caveopolis:red_colored_wooden_plank_door" | "caveopolis:lime_colored_cobblestone_slab_from_lime_colored_cobblestone_stonecutting" | "farmersdelight:iron_knife" | "caveopolis:sprayer/remove_color/cobblestone_bricks" | "mysticalagriculture:seed/reprocessor/spider" | "mysticalagriculture:watering_can" | "lfpirates:pirate_tier_3_boots_recipe_1" | "farmersdelight:bread_from_smelting" | "caveopolis:orange_colored_wooden_planks" | "farmersdelight:cutting/blue_orchid" | "caveopolis:sprayer/colored_stone_stairs/red_colored_stone_stairs" | "caveopolis:sprayer/colored_stone_stairs/white_colored_stone_stairs" | "thermal:machines/press/packing3x3/press_gold_nugget_packing" | "thermal:compat/immersiveengineering/press_ie_uranium_ingot_to_plate" | "industrialforegoing:fluid_extractor/acacia" | "caveopolis:purple_colored_wooden_plank_fence" | "supplementaries:integration/ash_bricks_fd" | "alltheores:uranium_ingot_from_ore_blasting" | "opolisutilities:super_home_stone" | "alltheores:signalum_block" | "oceansdelight:stuffed_cod" | "thermal:machine_pulverizer" | "caveopolis:blue_colored_stone_brick_stairs_from_blue_colored_stone_bricks_stonecutting" | "caveopolis:lime_colored_wooden_plank_pressure_plate" | "caveopolis:sprayer/colored_cobblestone_stairs/purple_colored_stone_stairs" | "minecraft:cut_sandstone_slab_from_sandstone_stonecutting" | "thermal:compat/refinedstorage/smelter_refinedstorage_alloy_quartz_enriched_iron" | "thermal:machines/smelter/smelter_copper_tools" | "minecraft:polished_blackstone_stairs_from_polished_blackstone_stonecutting" | "lfpirates:sailor_nordic_tier_2_helmet_recipe_1" | "caveopolis:sprayer/colored_stone_brick_slab/lime_colored_stone_brick_slab" | "thermal:white_concrete_powder_with_slag" | "farmersdelight:rice_bag" | "minecraft:bucket" | "mysticalagriculture:seed/crafting/uraninite" | "supplementaries:soap/globe_sepia" | "farmersdelight:cutting/crimson_hanging_sign" | "minecraft:silence_armor_trim_smithing_template_smithing_trim" | "farmersdelight:chicken_sandwich" | "minecraft:coal_from_blasting_deepslate_coal_ore" | "thermal:compat/biomesoplenty/tree_extractor_bop_umbran" | "minecraft:polished_andesite" | "thermal:rubberwood_fence" | "caveopolis:sprayer/colored_wood/yellow" | "thermal:machines/smelter/smelter_gold_plate_to_ingot" | "thermal:machines/insolator/insolator_bubble_coral_fan" | "alltheores:lead_ingot_from_slate_ore" | "mysticalagradditions:tconstruct/casting/soulium/nugget_gold_cast" | "alltheores:thermal_pulverize/pulverizer_zinc_ore" | "thermal:compat/quark/insolator_quark_orange_blossom_sapling" | "mysticalagriculture:souls/creeper_head" | "mysticalagriculture:souls/blitz_rod" | "minecraft:charcoal" | "thermal:tools/lock" | "minecraft:diorite_wall_from_diorite_stonecutting" | "minecraft:polished_blackstone_brick_slab" | "strainers:upgrades/sturdy/sturdy_input_upgrade" | "minecraft:rabbit_stew_from_brown_mushroom" | "alltheores:mek_processing/silver/dust/from_ore" | "thermal:compat/create/centrifuge_create_crushed_raw_tin" | "industrialforegoing:dissolution_chamber/infinity_drill" | "mysticalagriculture:essence/common/sulfur" | "mysticalagriculture:seed/reprocessor/invar" | "itemfilters:damage" | "supplementaries:fodder" | "mysticalagriculture:seed/infusion/ice" | "sophisticatedbackpacks:stonecutter_upgrade" | "thermal:compat/biomesoplenty/tree_extractor_bop_palm" | "thermal:machines/insolator/insolator_bubble_coral" | "caveopolis:sprayer/colored_stone_brick_stairs/purple_colored_stone_brick_stairs" | "thermal:compat/biomesoplenty/tree_extractor_bop_fir" | "farmersdelight:cooked_salmon_slice" | "thermal:machines/smelter/smelter_raw_tin" | "mysticalagriculture:tertium_gemstone_block" | "caveopolis:sprayer/remove_color/concrete" | "lfpirates:corsair_tier_2_body_recipe_1" | "cozy_home:table_spruce_recipe" | "thermal:compat/immersiveengineering/press_ie_aluminum_unpacking" | "minecraft:warped_pressure_plate" | "alltheores:steel_block" | "mysticalagriculture:seed/crafting/limestone" | "farmersdelight:birch_cabinet" | "thermal:machines/smelter/smelter_constantan_tools" | "mysticalagradditions:tconstruct/melting/imperium/block" | "caveopolis:sprayer/colored_stone_buttons/orange" | "opolisutilities:leather_horse_armor" | "thermal_extra:storage/twinite_ingot_from_nuggets" | "lfpirates:corsair_tier_3_body_recipe_1" | "thermal:storage/lead_ingot_from_block" | "caveopolis:white_colored_cobblestone_bricks" | "mysticalagriculture:essence/astralsorcery/marble" | "caveopolis:lime_colored_cobblestone_brick_slab_from_lime_colored_cobblestone_bricks_stonecutting" | "thermal:storage/raw_tin_from_block" | "farmersdelight:brown_canvas_sign" | "thermal:machines/smelter/smelter_silver_armor" | "mysticalagriculture:essence/minecraft/purple_dye" | "cozy_home:sofa_blue_recipe" | "minecraft:cooked_porkchop" | "sophisticatedbackpacks:advanced_compacting_upgrade" | "thermal:smelting/tin_ingot_from_dust_blasting" | "caveopolis:brown_colored_stone_pressure_plate_from_brown_colored_stone_stonecutting" | "supplementaries:stonecutting/blackstone_tile_stairs_from_bricks" | "caveopolis:sprayer/colored_wooden_plank_fence/pink" | "mysticalagriculture:inferium_growth_accelerator" | "storagedrawers:iron_storage_upgrade" | "caveopolis:light_gray_colored_cobblestone_wall" | "supplementaries:sconce_ender" | "mysticalagriculture:augment/hunger_resistance" | "thermal:machines/press/packing3x3/press_diamond_packing" | "minecraft:oak_wood" | "caveopolis:pink_colored_wooden_plank_button" | "mysticalagriculture:seed/reprocessor/honey" | "thermal:storage/niter_block" | "industrialforegoing:dissolution_chamber/pink_slime_ingot" | "strainers:lilac_from_straining_tall_grass_in_strainers_purified_water_fluid" | "caveopolis:green_colored_stone_slab_from_green_colored_stone_stonecutting" | "thermal:machines/smelter/smelter_glass_lumium" | "minecraft:magenta_stained_glass_pane" | "mysticalagriculture:essence/minecraft/fire_coral_block" | "thermal:machines/pulverizer/pulverizer_lead_ore" | "thermal:fuels/numismatic_steel_coin" | "thermal_extra:twinite_dust" | "farmersdelight:cutting/wild_rice" | "industrialforegoing:crusher/cobble_gravel" | "mysticalagriculture:seed/crafting/terrasteel" | "mysticalagriculture:seed/infusion/nickel" | "mysticalagriculture:prosperity_seed_base" | "farmersdelight:canvas" | "minecraft:chiseled_stone_bricks_from_stone_bricks_stonecutting" | "aquamirae:poseidons_breakfast" | "thermal:compat/mysticalagriculture/insolator_mysticalag_sulfur_seeds" | "minecraft:spruce_wood" | "minecraft:spruce_fence" | "mysticalagradditions:tconstruct/tools/materials/inferium/block" | "cozy_home:acacia_mirror_stand_recipe" | "aquaculture:sushi" | "caveopolis:red_colored_stone_brick_stairs_from_red_colored_stone_bricks_stonecutting" | "minecraft:dark_prismarine_slab" | "caveopolis:marble_brick_wall" | "caveopolis:purple_colored_sign_from_purple_colored_wooden_planks_stonecutting" | "mysticalagriculture:augment/fire_resistance" | "mysticalagriculture:soulium_spawner" | "caveopolis:sprayer/banners/magenta" | "caveopolis:sprayer/colored_stone/white_colored_stone" | "minecraft:green_dye" | "minecraft:dried_kelp_from_smoking" | "minecraft:waxed_exposed_cut_copper_stairs" | "thermal:storage/charcoal_block" | "thermal:machines/pulverizer/pulverizer_diorite" | "opolisutilities:drying_table/cracked_stone_bricks" | "storagedrawers:min_redstone_upgrade" | "cozy_home:desk_quartz_recipe" | "thermal:tools/guidebook" | "thermal:gunpowder_4" | "minecraft:weathered_cut_copper_slab" | "caveopolis:sprayer/banners/red" | "mysticalagriculture:infusion_crystal" | "suppsquared:crimson_lantern" | "alltheores:signalum_gear" | "minecraft:waxed_weathered_copper_from_honeycomb" | "thermal_extra:machine/smelter/shellite_ingot" | "strainers:wheat_seeds_from_straining_mulch_in_minecraft_water" | "thermal:compat/biomesoplenty/insolator_bop_orange_cosmos_flower" | "thermal:compat/mysticalagriculture/insolator_mysticalag_deepslate_seeds" | "itemfilters:custom" | "mysticalagriculture:essence/botania/cyan_mystical_flower" | "farmersdelight:integration/immersiveengineering/crusher/wild_potatoes" | "thermal:machines/smelter/smelter_lead_ore" | "thermal:press_coin_die" | "caveopolis:stripped_red_colored_wood" | "thermal:machine_crystallizer" | "mysticalagriculture:essence/minecraft/prismarine_shard" | "minecraft:andesite_wall_from_andesite_stonecutting" | "mysticalagriculture:gear/inferium_shovel" | "thermal:devices/tree_extractor/tree_extractor_oak" | "mysticalagriculture:essence/minecraft/spruce_log" | "supplementaries:sconce_glow" | "thermal:fuels/numismatic/numismatic_invar_coin" | "thermal:machines/press/unpacking/press_lead_nugget_unpacking" | "thermal:machines/refinery/refinery_light_oil" | "mysticalagriculture:essence/minecraft/bubble_coral_block" | "caveopolis:purple_colored_stone_brick_stairs" | "mysticalagriculture:seed/reprocessor/energized_steel" | "thermal:compat/biomesoplenty/insolator_bop_violet_flower" | "alltheores:constantan_ingot" | "minecraft:redstone" | "mysticalagradditions:insanium_gemstone_block" | "thermal:machines/press/press_enderium_ingot_to_plate" | "cozy_home:lamp_pink_recipe" | "caveopolis:blue_colored_cobblestone_stairs_from_blue_colored_cobblestone_stonecutting" | "minecraft:powered_rail" | "thermal:compat/biomesoplenty/tree_extractor_bop_magic" | "caveopolis:sprayer/colored_wooden_plank_button/white" | "thermal:compat/tconstruct/press_tconstruct_pig_iron_packing" | "minecraft:firework_star" | "minecraft:green_concrete_powder" | "thermal:machines/centrifuge/centrifuge_lime_wool" | "thermal:machines/press/unpacking/press_blue_ice_unpacking" | "mysticalagriculture:seed/crafting/constantan" | "supplementaries:flags/flag_red" | "minecraft:dye_white_bed" | "opolisutilities:catalogue" | "thermal:energy_limiter_attachment_2" | "aquamirae:fin_cutter" | "mysticalagriculture:soulium_spawner/skeleton" | "alltheores:mek_processing/zinc/dust/from_ingot" | "strainers:upgrade_stats/sturdy_everything_upgrade" | "minecraft:blue_terracotta" | "mysticalagriculture:awakened_supremium_furnace" | "supplementaries:stone_lamp" | "caveopolis:brown_colored_cobblestone_brick_wall_from_brown_colored_cobblestone_bricks_stonecutting" | "thermal:compat/tconstruct/chiller_tconstruct_iron_ingot" | "minecraft:yellow_concrete_powder" | "minecraft:gray_terracotta" | "caveopolis:light_blue_colored_stone_brick_slab" | "thermal:machines/smelter/smelter_sulfur_ore" | "caveopolis:blue_colored_stone_brick_stairs" | "alltheores:electrum_ingot_from_block" | "caveopolis:pink_colored_sign" | "storagedrawers:spruce_half_drawers_1" | "storagedrawers:spruce_half_drawers_2" | "minecraft:netherite_boots_smithing" | "caveopolis:light_gray_colored_wooden_plank_trapdoor_from_light_gray_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/terracotta/white" | "caveopolis:yellow_colored_hanging_sign_from_stripped_yellow_colored_log_stonecutting" | "mysticalagriculture:seed/infusion/queens_slime" | "thermal:parts/gold_gear" | "cozy_home:sofa_light_gray_recipe" | "minecraft:fishing_rod" | "minecraft:cooked_beef_from_smoking" | "caveopolis:purple_colored_stone_wall" | "minecraft:terracotta" | "mysticalagriculture:soulstone_stairs" | "caveopolis:light_blue_colored_wooden_plank_pressure_plate_from_light_blue_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/colored_wooden_plank_button/purple" | "thermal:machines/press/packing3x3/press_gunpowder_packing" | "farmersdelight:cutting/rice_panicle" | "alltheores:invar_ingot" | "thermal:machines/insolator/insolator_gunpowder_mushroom" | "caveopolis:sprayer/refill/red" | "supplementaries:candle_holders/candle_holder_cyan" | "caveopolis:sprayer/glass_pane/gray" | "minecraft:wayfinder_armor_trim_smithing_template" | "minecraft:dye_light_blue_bed" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/brown" | "mysticalagriculture:seed/crafting/saltpeter" | "caveopolis:cyan_colored_cobblestone_slab_from_cyan_colored_cobblestone_stonecutting" | "thermal:earth_charge/diamond_dust_from_diamond" | "thermal:machines/crucible/crucible_snow_block_to_water" | "caveopolis:sprayer/colored_wood/light_blue" | "thermal:blitz_powder" | "mysticalagriculture:seed/reprocessor/titanium" | "supplementaries:sign_post_mangrove" | "dankstorage:5_to_6" | "thermal:augments/side_config_augment" | "lfpirates:sailor_nordic_tier_1_leggins_recipe_1" | "farmersdelight:cutting/pumpkin" | "cozy_home:chimney_stonebrick_recipe" | "mysticalagriculture:essence/minecraft/gold_ingot" | "minecraft:red_dye_from_tulip" | "strainers:glow_berries_from_straining_mulch_in_minecraft_water" | "lfpirates:sailor_red_tier_3_leggins_recipe_1" | "minecraft:beacon" | "strainers:brown_mushroom_from_straining_mycelium_in_minecraft_water" | "thermal:machines/press/unpacking/press_gunpowder_unpacking" | "caveopolis:sprayer/glazed_terracotta/cyan" | "minecraft:tnt" | "minecraft:mossy_stone_bricks_from_vine" | "aquaculture:nether_star_hook" | "minecraft:dye_yellow_bed" | "minecraft:flint_and_steel" | "thermal:storage/raw_nickel_block" | "thermal:machines/press/packing3x3/press_silver_packing" | "mysticalagriculture:essence/twilightforest/ironwood_ingot" | "thermal:smelting/cooked_eggplant_from_smelting" | "mysticalagriculture:essence/common/lead_ingot" | "thermal:machines/pulverizer/pulverizer_logs" | "mysticalagriculture:soul_glass" | "minecraft:black_dye" | "mysticalagriculture:seed/crafting/redstone" | "caveopolis:blue_colored_wooden_planks" | "aquaculture:tin_can_to_iron_nugget_from_blasting" | "thermal:machines/press/press_silver_nugget_to_coin" | "mysticalagradditions:tconstruct/casting/prudentium/block" | "mysticalagriculture:essence/create/limestone" | "mysticalagriculture:essence/minecraft/lime_concrete" | "caveopolis:light_gray_colored_wooden_plank_stairs" | "thermal:nuke_tnt_minecart" | "chipped:carpenters_table" | "minecraft:dune_armor_trim_smithing_template_smithing_trim" | "mysticalagriculture:seed/infusion/enderman" | "farmersdelight:integration/create/mixing/pie_crust_from_mixing" | "alltheores:invar_dust_from_alloy_blending" | "caveopolis:sprayer/colored_stone/yellow_colored_stone" | "thermal:machines/centrifuge/centrifuge_black_wool" | "mysticalagriculture:seed/infusion/redstone_alloy" | "thermal_extra:machine/refinery/crystallized_sunflower_oil_to_refined_sunflower_oil" | "mysticalagriculture:seed/infusion/soularium" | "caveopolis:sprayer/colored_cobblestone_bricks/green_colored_stone_bricks" | "thermal:compat/mekanism/press_mek_refined_obsidian_nugget_unpacking" | "nec:caveop_yellow_colored_wooden_chest" | "thermal:compat/mysticalagriculture/insolator_mysticalag_zombie_seeds" | "caveopolis:gray_colored_wooden_plank_pressure_plate" | "thermal:machines/centrifuge/centrifuge_light_gray_rockwool" | "caveopolis:sprayer/stripped_colored_logs/yellow" | "minecraft:dye_light_blue_wool" | "thermal:storage/strawberry_from_block" | "mysticalagriculture:essence/appliedenergistics2/sky_stone" | "minecraft:light_blue_stained_glass_pane" | "minecraft:brown_concrete_powder" | "caveopolis:yellow_colored_wooden_plank_fence_from_yellow_colored_wooden_planks_stonecutting" | "mysticalagriculture:essence/powah/blazing_crystal" | "strainers:prize_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "nec:cherry_chest" | "supplementaries:globe_sepia" | "farmersdelight:rice" | "minecraft:crimson_hyphae" | "minecraft:coal_from_smelting_coal_ore" | "mysticalagriculture:essence/integrateddynamics/menril_sapling" | "caveopolis:green_colored_wooden_plank_fence_from_green_colored_wooden_planks_stonecutting" | "supplementaries:integration/tipped_spikes_washing" | "caveopolis:spray_can_remover" | "thermal:machines/pulverizer/pulverizer_sandstone_slab" | "thermal:machines/pulverizer/pulverizer_apatite_ore" | "caveopolis:sprayer/colored_cobblestone_brick_wall/light_blue_colored_stone_brick_wall" | "thermal:machines/press/unpacking/press_gold_unpacking" | "caveopolis:stripped_pink_colored_wood" | "mysticalagriculture:seed/crafting/niotic_crystal" | "mysticalagradditions:tertium_coal" | "supplementaries:item_shelf" | "supplementaries:stone_tile" | "strainers:dragon_head_from_straining_skeleton_skull_in_minecraft_dragon_egg" | "mysticalagriculture:seed/infusion/niotic_crystal" | "alltheores:mek_processing/nickel/slurry/dirty" | "mysticalagriculture:essence/common/graphite_ingot" | "opolisutilities:resource_generator_2/speed_blocks/peridot" | "minecraft:grindstone" | "aquamirae:luminescent_lamp" | "farmersdelight:crimson_cabinet" | "strainers:orange_tulip_from_straining_grass_in_strainers_purified_water_fluid" | "mysticalagriculture:essence/create/asurine" | "farmersdelight:cutting/cooked_mutton" | "thermal:compat/tconstruct/chiller_tconstruct_rose_gold_ingot" | "minecraft:granite_slab_from_granite_stonecutting" | "thermal:machines/centrifuge/centrifuge_bronze_dust" | "alltheores:iridium_ingot_from_raw_blasting" | "supplementaries:timber_brace" | "thermal:compat/mysticalagriculture/insolator_mysticalag_mystical_flower_seeds" | "strainers:upgrades/improved/improved_everything_upgrade" | "strainers:beetroot_seeds_from_straining_mulch_in_minecraft_water" | "alltheores:thermal_pulverize/pulverizer_platinum_ore" | "minecraft:golden_sword" | "thermal:machines/press/unpacking/press_nether_bricks_unpacking" | "mysticalagriculture:inferium_ingot_block_uncraft" | "industrialforegoing:sewage_composter" | "mysticalagriculture:essence/gems/peridot" | "caveopolis:yellow_colored_cobblestone_slab_from_yellow_colored_cobblestone_stonecutting" | "caveopolis:magenta_colored_cobblestone_brick_slab_from_magenta_colored_cobblestone_bricks_stonecutting" | "supplementaries:bed_from_feather_block" | "caveopolis:sprayer/colored_wooden_plank_stairs/green" | "minecraft:furnace_minecart" | "strainers:strainer" | "caveopolis:sprayer/colored_wood/cyan" | "cozy_home:desk_warped_recipe" | "farmersdelight:scaffolding_from_canvas" | "alltheores:brass_ingot" | "mysticalagriculture:seed/crafting/iron" | "minecraft:waxed_weathered_cut_copper" | "thermal:compat/mekanism/press_mek_fluorite_packing" | "caveopolis:blue_colored_wooden_plank_fence" | "caveopolis:red_colored_sign" | "caveopolis:white_colored_wood" | "thermal:devices/rock_gen/rock_gen_deepslate" | "caveopolis:gray_colored_stone_slab_from_gray_colored_stone_stonecutting" | "caveopolis:light_gray_colored_stone_brick_slab_from_light_gray_colored_stone_bricks_stonecutting" | "thermal:machines/centrifuge/centrifuge_lilac" | "storagedrawers:warped_half_drawers_4" | "caveopolis:gray_colored_stone_wall" | "caveopolis:sprayer/colored_wooden_plank_stairs/yellow" | "alltheores:smelting_dust/silver_ingot" | "storagedrawers:warped_half_drawers_1" | "minecraft:netherite_ingot_from_netherite_block" | "storagedrawers:warped_half_drawers_2" | "thermal:frost_melon" | "caveopolis:magenta_colored_stone_pressure_plate_from_magenta_colored_stone_stonecutting" | "storagedrawers:dark_oak_half_drawers_1" | "storagedrawers:dark_oak_half_drawers_2" | "storagedrawers:dark_oak_half_drawers_4" | "caveopolis:yellow_colored_wooden_plank_trapdoor" | "mysticalagriculture:prudentium_block" | "thermal:machines/press/press_corn_unpacking" | "caveopolis:sprayer/refill/magenta" | "mysticalagradditions:prudentium_paxel" | "mysticalagriculture:seed/crafting/blaze" | "alltheores:uranium_plate" | "thermal:machines/bottler/bottler_honey_bottle" | "caveopolis:yellow_colored_wooden_plank_pressure_plate" | "mysticalagriculture:soulstone_smooth_smelted" | "nec:crimson_chest" | "caveopolis:blue_colored_wooden_plank_fence_from_blue_colored_wooden_planks_stonecutting" | "mysticalagriculture:enchanter/projectile_protection" | "thermal:machines/press/press_hops_packing" | "storagedrawers:oak_full_drawers_1" | "minecraft:red_nether_brick_slab_from_red_nether_bricks_stonecutting" | "storagedrawers:oak_full_drawers_4" | "storagedrawers:oak_full_drawers_2" | "thermal:sushi_maki_8" | "mysticalagriculture:gear/supremium_chestplate" | "mysticalagriculture:essence/minecraft/brown_mushroom" | "alltheores:lumium_gear" | "caveopolis:orange_colored_stone_brick_stairs_from_orange_colored_stone_bricks_stonecutting" | "industrialforegoing:laser_drill_ore/raw_materials/osmium" | "industrialforegoing:laser_lens_yellow_recolor" | "minecraft:chiseled_stone_bricks" | "mysticalagriculture:enchanter/power" | "strainers:lily_pad_from_straining_barrier_in_strainers_eroding_water_fluid" | "supplementaries:cozy_home/sign_post_jungle" | "tmttd:machines/press/sweetberry_press" | "supplementaries:strings" | "minecraft:polished_granite_stairs_from_granite_stonecutting" | "supplementaries:ash_brick_wall" | "minecraft:spruce_pressure_plate" | "minecraft:purple_terracotta" | "thermal_extra:smelting/shellite_ingot_from_dust_blasting" | "strainers:zombie_head_from_straining_skeleton_skull_in_strainers_eroding_water_fluid" | "industrialforegoing:dissolution_chamber/mycelial_reactor" | "mysticalagriculture:essence_vessel" | "caveopolis:brown_colored_sign_from_brown_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/colored_stone_buttons/gray" | "storagedrawers:spruce_half_drawers_4" | "minecraft:deepslate_tiles_from_deepslate_bricks_stonecutting" | "aquamirae:sea_casserole" | "caveopolis:red_colored_stone_pressure_plate_from_red_colored_stone_stonecutting" | "mysticalagradditions:supremium_coal_block_uncraft" | "thermal:compat/mekanism/press_mek_osmium_unpacking" | "minecraft:hay_block" | "thermal:compat/immersiveengineering/compression_ip_gasoline" | "mysticalagriculture:air_agglomeratio" | "alltheores:ruby_from_hammer_crushing" | "thermal:compat/immersiveengineering/press_ie_aluminum_nugget_unpacking" | "thermal:rockwool/light_gray_rockwool_from_dye" | "cozy_home:crimson_chair_recipe" | "cozy_home:mangrove_mirror_stand_recipe" | "alltheores:mek_processing/aluminum/dirty_dust/from_clump" | "cozy_home:counter_cherry_storage_recipe" | "caveopolis:red_colored_stone_crafting_table" | "mysticalagriculture:essence/minecraft/green_concrete" | "thermal:machines/sawmill/sawmill_dark_oak_logs" | "thermal:compat/quark/press_quark_cocoa_beans_unpacking" | "simplehats:hatbag_summer" | "thermal_extra:smelting/dragonsteel_ingot_from_dust_blasting" | "caveopolis:sprayer/wool/lime_wool" | "mysticalagradditions:insanium_block_uncraft" | "thermal:machines/press/packing3x3/press_rosin_packing" | "alltheores:lead_dust_from_hammer_ingot_crushing" | "thermal:machines/press/unpacking/press_bricks_unpacking" | "minecraft:smooth_quartz_slab_from_smooth_quartz_stonecutting" | "thermal:machines/smelter/smelter_silver_plate_to_ingot" | "aquaculture:jungle_fish_mount" | "mysticalagriculture:essence/common/uranium_ingot" | "thermal:storage/steel_ingot_from_block" | "alltheores:mek_processing/platinum/slurry/dirty_from_raw" | "alltheores:mek_processing/nickel/slurry/dirty_from_raw" | "caveopolis:white_colored_cobblestone" | "supplementaries:bamboo_spikes_tipped" | "cozy_home:jungle_mirror_recipe" | "thermal:magenta_concrete_powder_with_slag" | "mysticalagriculture:essence/enderio/dark_steel_ingot" | "mysticalagriculture:experience_capsule" | "alltheores:zinc_gear" | "tmttd:machines/press/sugar_press" | "lfpirates:merchant_3_leggins_recipe_1" | "caveopolis:sprayer/colored_stone_stairs/purple_colored_stone_stairs" | "thermal:augments/rf_coil_xfer_augment" | "caveopolis:red_colored_stone_slab" | "mysticalagriculture:seed/crafting/nature" | "minecraft:cut_copper" | "thermal:machines/crucible/crucible_ice_to_water" | "mysticalagriculture:augment/water_breathing" | "caveopolis:gray_colored_sign" | "supplementaries:flags/flag_orange" | "strainers:meshes/quartz" | "caveopolis:orange_colored_cobblestone_wall" | "caveopolis:magenta_colored_cobblestone_brick_slab" | "opolisutilities:catalogue/selling/caveopolis/glowstone_spray_can" | "mysticalagriculture:seed/infusion/deepslate" | "caveopolis:white_colored_wooden_plank_trapdoor" | "farmersdelight:cutting/birch_door" | "caveopolis:sprayer/colored_stone_bricks/pink_colored_stone_bricks" | "thermal:machines/crucible/crucible_glowstone_block" | "mysticalagriculture:seed/infusion/brass" | "caveopolis:sprayer/remove_color/hanging_signs" | "thermal:smelting/nickel_ingot_from_ore_blasting" | "caveopolis:stone_stick" | "aquaculture:iron_hook" | "aquaculture:diamond_fishing_rod" | "thermal:machines/smelter/smelter_quartz_ore" | "minecraft:smooth_sandstone_stairs" | "caveopolis:sprayer/stripped_colored_wood/cyan" | "minecraft:copper_ingot_from_blasting_copper_ore" | "aquaculture:diamond_hook" | "oceansdelight:cooked_stuffed_cod" | "framedcompactdrawers:frame_two" | "mysticalagradditions:tconstruct/melting/imperium/nugget" | "opolisutilities:drying_table/dead_bush" | "mysticalagriculture:supremium_upgrade" | "caveopolis:green_colored_wooden_plank_stairs_from_green_colored_wooden_planks_stonecutting" | "alltheores:osmium_rod" | "caveopolis:sprayer/colored_leaves/blue" | "thermal:machines/pulverizer/pulverizer_iron_plate_to_dust" | "minecraft:rabbit_stew_from_red_mushroom" | "minecraft:prismarine_brick_stairs" | "mysticalagriculture:souls/coal" | "thermal:compat/mysticalagriculture/insolator_mysticalag_certus_quartz_seeds" | "opolisutilities:resource_generator_2/speed_blocks/soularium" | "thermal:machines/insolator/insolator_lilac" | "supplementaries:sconce_soul" | "mysticalagriculture:seed/reprocessor/queens_slime" | "thermal:machines/pulverizer/pulverizer_lead_ingot_to_dust" | "farmersdelight:cutting/white_tulip" | "strainers:mourner_pottery_sherd_from_straining_suspicious_sand_in_minecraft_water" | "opolisutilities:catalogue/selling/caveopolis/green_spray_can" | "farmersdelight:potato_crate" | "thermal:machines/press/unpacking/press_prismarine_brick_unpacking" | "minecraft:exposed_cut_copper_stairs_from_exposed_copper_stonecutting" | "caveopolis:sprayer/colored_cobblestone_bricks/black_colored_stone_bricks" | "thermal:compat/biomesoplenty/sawmill_bop_palm_logs" | "caveopolis:bright_shard_from_smelting_bright_stone_ore" | "thermal:machines/pulverizer/pulverizer_gold_plate_to_dust" | "mysticalagradditions:tconstruct/casting/tertium/ingot_gold_cast" | "caveopolis:sprayer/colored_wooden_plank_stairs/pink" | "mysticalagriculture:enchanter/silk_touch" | "alltheores:mek_processing/iridium/shard/from_ore" | "thermal:compat/create/insolator_catalyst_create_tree_fertilizer" | "alltheores:lumium_ingot_from_dust_blasting" | "minecraft:netherite_block" | "caveopolis:orange_colored_stone_slab" | "alltheores:uranium_rod" | "strainers:upgrade_stats/sturdy_input_upgrade" | "mysticalagradditions:tconstruct/tools/melting/supremium" | "caveopolis:light_blue_colored_wooden_plank_door_from_light_blue_colored_wooden_planks_stonecutting" | "alltheores:aluminum_ingot_from_ore_blasting" | "alltheores:mek_processing/platinum/slurry/clean" | "caveopolis:yellow_colored_wooden_plank_trapdoor_from_yellow_colored_wooden_planks_stonecutting" | "caveopolis:magenta_colored_wood" | "sophisticatedbackpacks:backpack" | "thermal:machines/press/unpacking/press_steel_nugget_unpacking" | "mysticalagriculture:seed/crafting/draconium" | "mysticalagriculture:seed/infusion/obsidian" | "caveopolis:sprayer/colored_stone_brick_slab/black_colored_stone_brick_slab" | "thermal_extra:dragonsteel_glass" | "mysticalagriculture:seed/infusion/sky_stone" | "farmersdelight:cod_roll" | "cozy_home:lamp_cyan_recipe" | "alltheores:tin_ingot_from_raw" | "sophisticatedbackpacks:pump_upgrade" | "caveopolis:yellow_colored_cobblestone_brick_wall" | "duckling:cooked_duck" | "nec:caveop_black_colored_wooden_chest" | "minecraft:crossbow" | "glassential:ghostly_door" | "aquaculture:neptunium_fillet_knife" | "thermal:machines/press/unpacking/press_honeycomb_unpacking" | "alltheores:mek_processing/aluminum/ore/deepslate_from_raw" | "caveopolis:yellow_colored_sign_from_yellow_colored_wooden_planks_stonecutting" | "caveopolis:red_colored_cobblestone_bricks_from_red_colored_cobblestone_stonecutting" | "cozy_home:table_stump_warped_recipe" | "lfpirates:corsair_tier_1_body_recipe_1" | "strainers:melon_seeds_from_straining_mulch_in_minecraft_water" | "mysticalagriculture:seed/reprocessor/neutronium" | "minecraft:diamond" | "minecraft:crimson_slab" | "caveopolis:brown_colored_cobblestone_brick_stairs_from_brown_colored_cobblestone_bricks_stonecutting" | "thermal:smelting/nickel_ingot_from_dust_blasting" | "alltheores:constantan_dust_from_alloy_blending" | "mysticalagriculture:seed/infusion/conductive_alloy" | "thermal:compat/biomesoplenty/sawmill_bop_willow_logs" | "alltheores:mek_processing/silver/slurry/dirty/from_raw_block" | "thermal:machines/insolator/insolator_allium" | "caveopolis:magenta_colored_hanging_sign_from_stripped_magenta_colored_log_stonecutting" | "industrialforegoing:common_black_hole_unit" | "thermal:smelting/cracked_rich_slag_bricks_from_smelting" | "thermal_extra:machine/dynamo/frost/snowball" | "thermal:compat/mysticalagriculture/insolator_mysticalag_nether_quartz_seeds" | "opolisutilities:resource_generator_2/speed_blocks/obsidian" | "mysticalagriculture:seed/crafting/fire" | "caveopolis:sprayer/colored_leaves/lime" | "alltheores:aluminum_dust_from_hammer_crushing" | "systeams:boilers/upgrades/pneumatic_downgrade" | "thermal:compat/mysticalagriculture/insolator_mysticalag_blaze_seeds" | "mysticalagriculture:essence/tconstruct/cobalt_ingot" | "supplementaries:sconce_green" | "thermal:machines/press/press_bronze_nugget_to_coin" | "supplementaries:soap" | "caveopolis:sprayer/colored_cobblestone_bricks/cyan_colored_stone_bricks" | "mysticalagriculture:seed/crafting/fish" | "industrialforegoing:pity_black_hole_tank" | "minecraft:waxed_oxidized_cut_copper_from_waxed_oxidized_copper_stonecutting" | "caveopolis:red_colored_wooden_plank_trapdoor" | "opolisutilities:resource_generator_2/speed_blocks/lapis" | "minecraft:mossy_cobblestone_stairs" | "thermal:parts/silver_gear" | "itemfilters:and" | "caveopolis:lime_colored_stone_slab" | "thermal:machines/press/unpacking/press_constantan_unpacking" | "thermal_extra:machine/smelter/soul_infused_ingot" | "caveopolis:sprayer/colored_wooden_plank_stairs/black" | "caveopolis:blue_colored_wooden_plank_slab" | "minecraft:acacia_hanging_sign" | "caveopolis:light_blue_colored_wooden_plank_stairs" | "thermal:compat/create/press_create_brass_packing" | "caveopolis:purple_colored_wooden_plank_door_from_purple_colored_wooden_planks_stonecutting" | "thermal:compat/tconstruct/press_tconstruct_blood_slime_2x2_packing" | "industrialforegoing:dissolution_chamber/infinity_nuke" | "mysticalagriculture:prosperity_ingot_uncraft" | "minecraft:blue_bed" | "mysticalagradditions:tconstruct/casting/supremium/ingot_gold_cast" | "caveopolis:yellow_colored_cobblestone_brick_wall_from_yellow_colored_cobblestone_bricks_stonecutting" | "alltheores:copper_ingot_from_dust" | "mysticalagriculture:supremium_growth_accelerator" | "thermal:armor/hazmat_boots" | "thermal:machines/press/press_silver_ingot_to_coin" | "alltheores:electrum_dust_from_alloy_blending" | "minecraft:sponge" | "minecraft:quartz_stairs" | "thermal:machines/press/packing3x3/press_raw_nickel_packing" | "farmersdelight:full_tatami_mat_from_halves" | "minecraft:red_stained_glass" | "caveopolis:sprayer/stripped_colored_logs/red" | "aquaculture:neptunium_bow" | "mysticalagriculture:essence/botania/blue_mystical_flower" | "minecraft:light_gray_stained_glass_pane_from_glass_pane" | "mysticalagriculture:prudentium_gemstone" | "mysticalagriculture:wand" | "minecraft:green_carpet" | "alltheores:mek_processing/silver/shard/from_ore" | "minecraft:waxed_exposed_cut_copper_from_honeycomb" | "strainers:upgrade_stats/sturdy_output_upgrade" | "farmersdelight:beef_patty" | "mysticalagriculture:seed/infusion/steeleaf" | "caveopolis:white_colored_stone_wall_from_white_colored_stone_stonecutting" | "caveopolis:sprayer/concrete/black" | "farmersdelight:integration/immersiveengineering/cloche/rice" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/gray_colored_stone_brick_stairs" | "caveopolis:light_gray_colored_wooden_plank_pressure_plate_from_light_gray_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/candles/cyan" | "caveopolis:yellow_colored_wooden_plank_stairs_from_yellow_colored_wooden_planks_stonecutting" | "mysticalagriculture:essence/mysticalagriculture/soulium_dust" | "mysticalagriculture:prudentium_ingot_uncraft" | "caveopolis:sprayer/stripped_colored_logs/lime" | "industrialforegoing:mycelial_frosty" | "sophisticatedbackpacks:tool_swapper_upgrade" | "thermal:machines/press/unpacking/press_copper_unpacking" | "mysticalagriculture:seed/crafting/lapis_lazuli" | "minecraft:beetroot_soup" | "caveopolis:sprayer/colored_wooden_plank_pressure_plate/purple" | "alltheores:copper_gear" | "thermal:armor/diving_boots" | "storagedrawers:controller" | "mysticalagriculture:essence/minecraft/cactus" | "minecraft:lime_terracotta" | "thermal:compat/quark/insolator_quark_yellow_blossom_sapling" | "caveopolis:white_colored_cobblestone_wall_from_white_colored_cobblestone_stonecutting" | "thermal:storage/invar_block" | "minecraft:blackstone_slab_from_blackstone_stonecutting" | "minecraft:jungle_wood" | "minecraft:gray_stained_glass_pane_from_glass_pane" | "caveopolis:sprayer/colored_cobblestone/white_colored_stone" | "thermal:compat/create/pulverizer_create_zinc_ore" | "thermal:machines/centrifuge/centrifuge_red_rockwool" | "aquaculture:neptunium_shovel" | "minecraft:stone_slab" | "aquamirae:luminescent_bubble" | "lfpirates:sailor_blue_tier_1_helmet_recipe_1" | "mysticalagriculture:essence/minecraft/cocoa_beans" | "oceansdelight:cooked_elder_guardian_slice_from_campfire_cooking" | "powered_flashlight:flashlight" | "minecraft:acacia_slab" | "minecraft:brick_stairs_from_bricks_stonecutting" | "minecraft:jungle_stairs" | "cozy_home:acacia_bench_recipe" | "thermal:machines/insolator/insolator_mangrove_propagule" | "thermal:compat/create/press_create_brass_nugget_unpacking" | "mysticalagriculture:seed/crafting/steel" | "thermal:compat/tconstruct/press_tconstruct_rose_gold_unpacking" | "thermal:machines/pulverizer/pulverizer_enderium_plate_to_dust" | "thermal:glowstone_mushroom_spores" | "mysticalagriculture:seed/crafting/earth" | "caveopolis:marble_stairs_from_marble_stonecutting" | "thermal:smelting/gold_ingot_from_dust_blasting" | "farmersdelight:tomato" | "thermal:storage/amaranth_from_block" | "opolisutilities:resource_generator_2/speed_blocks/lumium" | "farmersdelight:dark_oak_cabinet" | "thermal:machines/press/unpacking/press_enderium_unpacking" | "caveopolis:brown_colored_stone_stairs" | "thermal:compat/create/pulverizer_create_ochrum" | "thermal:machines/press/press_vine_to_latex" | "caveopolis:sprayer/wool/brown_wool" | "industrialforegoing:laser_drill_ore/diamond" | "thermal:fluid_duct_4" | "caveopolis:sprayer/colored_saplings/orange" | "strainers:upgrades/reinforced/reinforced_input_upgrade" | "thermal:compat/tconstruct/chiller_tconstruct_lead_ingot" | "minecraft:cobbled_deepslate_stairs" | "minecraft:baked_potato" | "industrialforegoing:machine_frame_pity" | "thermal:machines/press/unpacking/press_raw_iron_unpacking" | "minecraft:cooked_salmon" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/orange_colored_stone_brick_stairs" | "caveopolis:mixed_stone_ingot" | "opolisutilities:resource_generator/mods/caveopolis/yellow_colored_stone" | "caveopolis:cyan_colored_cobblestone_slab" | "thermal:machines/insolator/insolator_cornflower" | "caveopolis:pink_colored_wooden_plank_pressure_plate" | "mysticalagriculture:seed/reprocessor/ice" | "mysticalagriculture:essence/common/nickel_ingot" | "mysticalagriculture:gear/inferium_pickaxe" | "cozy_home:tent_recipe" | "opolisutilities:resource_generator_2/speed_blocks/stone" | "mysticalagriculture:seed/reprocessor/blitz" | "minecraft:golden_leggings" | "opolisutilities:ender_pearl_from_ender_pearl_fragments" | "supplementaries:stonecutting/lapis_brick_wall_from_bricks" | "thermal:compat/tconstruct/press_tconstruct_sky_slime_3x3_unpacking" | "caveopolis:sprayer/colored_wooden_plank_door/purple" | "thermal:earth_grenade_4" | "thermal:compat/tconstruct/chiller_tconstruct_silver_ingot" | "thermal:machines/smelter/smelter_gold_tools" | "thermal:rockwool/black_rockwool_from_dye" | "thermal:compat/create/pulverizer_create_crimsite" | "strainers:crying_obsidian_from_straining_obsidian_in_strainers_eroding_water_fluid" | "mysticalagriculture:seed/infusion/steel" | "farmersdelight:hamburger" | "cozy_home:grandfather_clock_warped_recipe" | "minecraft:stone_pressure_plate" | "caveopolis:sprayer/colored_stone_stairs/blue_colored_stone_stairs" | "strainers:cobbled_deepslate" | "opolisutilities:log_sheet" | "caveopolis:gray_colored_cobblestone_brick_stairs" | "mysticalagriculture:essence/botania/brown_mystical_flower" | "caveopolis:green_colored_wooden_plank_button" | "caveopolis:blue_colored_wooden_plank_trapdoor" | "minecraft:tide_armor_trim_smithing_template_smithing_trim" | "caveopolis:brown_colored_wooden_plank_pressure_plate" | "caveopolis:green_colored_stone" | "smallships:birch_brigg" | "thermal:dynamo_disenchantment" | "mysticalagriculture:seed/crafting/sapphire" | "farmersdelight:integration/immersiveengineering/metalpress/pumpkin" | "caveopolis:blue_colored_stone_slab_from_blue_colored_stone_stonecutting" | "caveopolis:sprayer/colored_stone_brick_stairs/yellow_colored_stone_brick_stairs" | "simplehats:hatspecial" | "caveopolis:light_blue_colored_wood" | "caveopolis:yellow_colored_sign" | "thermal:compat/tconstruct/press_tconstruct_manyullyn_nugget_unpacking" | "thermal:compat/tconstruct/chiller_tconstruct_hepatizon_ingot" | "smallships:oak_galley" | "thermal:rubber_from_dandelion" | "mysticalagriculture:souls/rotten_flesh" | "farmersdelight:integration/immersiveengineering/cloche/cabbage" | "minecraft:bone_meal_from_bone_block" | "minecraft:mangrove_boat" | "supplementaries:flags/flag_light_gray" | "lfpirates:sailor_blue_tier_1_leggins_recipe_1" | "thermal:smelting/steel_ingot_from_dust_blasting" | "caveopolis:yellow_colored_stone_pressure_plate_from_yellow_colored_stone_stonecutting" | "strainers:upgrade_stats/everlasting_everything_upgrade" | "thermal:parts/netherite_gear" | "aquaculture:neptunes_bounty" | "craftingstation:crafting_station_slab" | "mysticalagriculture:essence/thermal/blizz_rod" | "thermal:storage/constantan_ingot_from_nuggets" | "minecraft:cobbled_deepslate_slab_from_cobbled_deepslate_stonecutting" | "farmersdelight:cooking/vegetable_soup" | "mysticalagriculture:gear/tertium_sickle" | "caveopolis:stripped_light_blue_colored_wood" | "thermal:machines/centrifuge/centrifuge_gray_rockwool" | "caveopolis:sprayer/colored_wooden_plank_button/cyan" | "mysticalagriculture:seed/crafting/starmetal" | "mysticalagriculture:essence/minecraft/water_bucket" | "minecraft:dark_oak_trapdoor" | "mysticalagriculture:gear/awakened_supremium_fishing_rod" | "alltheores:gold_gear" | "mysticalagriculture:essence/minecraft/fire_coral_fan" | "thermal:machines/press/press_green_bean_unpacking" | "caveopolis:lime_colored_wooden_planks" | "caveopolis:red_colored_cobblestone" | "caveopolis:sprayer/colored_cobblestone_stairs/light_blue_colored_stone_stairs" | "mysticalagriculture:gear/imperium_axe" | "thermal:charge_bench" | "opolisutilities:resource_generator_2/speed_blocks/constantan" | "supplementaries:antique_book" | "caveopolis:lime_colored_stone_brick_wall" | "minecraft:polished_deepslate_slab" | "minecraft:acacia_chest_boat" | "caveopolis:red_colored_stone_brick_wall" | "mysticalagriculture:seed/infusion/electrum" | "alltheores:raw_uranium_block" | "thermal:compat/mysticalagriculture/insolator_mysticalag_water_seeds" | "minecraft:orange_glazed_terracotta" | "minecraft:pink_carpet" | "thermal:rockwool/white_rockwool_from_blasting" | "caveopolis:yellow_colored_wooden_plank_button_from_yellow_colored_wooden_planks_stonecutting" | "mysticalagriculture:seed/reprocessor/quartz_enriched_iron" | "minecraft:deepslate_bricks" | "thermal:hearty_stew" | "alltheores:raw_zinc_block" | "minecraft:waxed_exposed_copper_from_honeycomb" | "supplementaries:gold_trapdoor" | "minecraft:waxed_weathered_cut_copper_stairs" | "minecraft:mossy_stone_brick_stairs" | "thermal:rubberwood_wood" | "thermal:machines/smelter/smelter_bronze_dust" | "thermal:storage/green_bean_block" | "minecraft:amethyst_block" | "mysticalagriculture:supremium_gemstone_block_uncraft" | "caveopolis:sprayer/colored_stone_brick_wall/purple_colored_stone_brick_wall" | "thermal:compat/tconstruct/press_tconstruct_slimesteel_nugget_packing" | "farmersdelight:integration/immersiveengineering/crusher/wild_beetroots" | "minecraft:nether_brick" | "caveopolis:blue_colored_cobblestone_brick_slab" | "mysticalagriculture:essence/botania/light_gray_mystical_flower" | "mysticalagriculture:seed/infusion/skeleton" | "caveopolis:cobblestone_brick_wall_from_cobblestone_bricks_stonecutting" | "industrialforegoing:laser_lens_gray_recolor" | "cozy_home:counter_warped_recipe" | "mysticalagriculture:gear/imperium_crossbow" | "caveopolis:sprayer/colored_stone_bricks/orange_colored_stone_bricks" | "mysticalagriculture:essence/minecraft/prismarine_crystals" | "alltheores:raw_uranium_from_block" | "thermal:storage/barley_from_block" | "thermal:compat/mysticalagriculture/insolator_mysticalag_osmium_seeds" | "alltheores:mek_processing/nickel/shard/from_crystal" | "caveopolis:red_colored_cobblestone_stairs_from_red_colored_cobblestone_stonecutting" | "caveopolis:sprayer/colored_cobblestone_slab/cyan_colored_stone_slab" | "mysticalagriculture:inferium_ingot" | "industrialforegoing:plant_sower" | "mysticalagriculture:prosperity_ingot_recraft" | "thermal:storage/nickel_block" | "caveopolis:gray_colored_hanging_sign_from_stripped_gray_colored_log_stonecutting" | "minecraft:purple_bed" | "suppsquared:heavy_key" | "thermal:compat/mysticalagriculture/insolator_mysticalag_sky_stone_seeds" | "caveopolis:lime_colored_stone_bricks" | "caveopolis:orange_colored_wooden_plank_fence_gate" | "systeams:boilers/upgrades/frost_upgrade" | "alltheores:mek_processing/silver/clump/from_shard" | "mysticalagriculture:seed/crafting/amethyst" | "caveopolis:sprayer/stripped_colored_logs/blue" | "thermal:machines/pulverizer/pulverizer_basalz_rod" | "alltheores:raw_zinc_from_block" | "supplementaries:netherite_door" | "caveopolis:lime_colored_sign" | "alltheores:lead_ingot_from_raw_blasting" | "farmersdelight:cutting/cherry_log" | "minecraft:polished_blackstone_brick_slab_from_polished_blackstone_stonecutting" | "minecraft:wheat" | "caveopolis:red_colored_cobblestone_brick_wall" | "caveopolis:light_blue_colored_cobblestone_brick_wall_from_light_blue_colored_cobblestone_bricks_stonecutting" | "industrialforegoing:laser_drill_ore/raw_materials/lead" | "supplementaries:candle_holders/candle_holder_magenta" | "suppsquared:candle_holders/gold_candle_holder_purple" | "caveopolis:sprayer/colored_cobblestone_slab/yellow_colored_stone_slab" | "farmersdelight:cutting/wild_cabbages" | "mysticalagriculture:souls/pufferfish" | "mysticalagradditions:supremium_coal_block" | "mysticalagriculture:augment/speed_ii" | "minecraft:bow" | "caveopolis:sprayer/beds/cyan" | "caveopolis:light_gray_colored_sign_from_light_gray_colored_wooden_planks_stonecutting" | "aquaculture:brown_mushroom_from_fish" | "thermal:compat/tconstruct/chiller_tconstruct_molten_debris" | "mysticalagriculture:seed/infusion/manyullyn" | "farmersdelight:cutting/amethyst_block" | "minecraft:andesite_stairs" | "farmersdelight:gold_nugget_from_smelting_knife" | "opolisutilities:chests" | "thermal:machines/smelter/smelter_enderium_plate_to_ingot" | "alltheores:lumium_nugget_from_ingot" | "caveopolis:sprayer/colored_stone_wall/light_blue_colored_stone_wall" | "caveopolis:yellow_colored_stone_pressure_plate" | "supplementaries:stonecutting/stone_tile_stairs_from_bricks" | "farmersdelight:cutting/ham" | "thermal:device_potion_diffuser" | "thermal:smelting/nickel_ingot_from_raw_smelting" | "cozy_home:lamp_gray_recipe" | "mysticalagriculture:soulstone_bricks_stairs" | "minecraft:dark_oak_boat" | "caveopolis:sprayer/colored_hanging_signs/blue" | "caveopolis:light_blue_colored_stone_bricks" | "thermal:compat/mysticalagriculture/insolator_mysticalag_obsidian_seeds" | "caveopolis:gray_colored_stone_button" | "thermal:hazmat_fabric" | "caveopolis:magenta_colored_stone_stairs" | "mysticalagriculture:essence/minecraft/copper_ingot" | "minecraft:copper_ingot_from_smelting_deepslate_copper_ore" | "thermal:machines/crystallizer/crystallizer_cinnabar" | "minecraft:mossy_stone_brick_wall" | "mysticalagriculture:essence/minecraft/cod" | "mysticalagradditions:inferium_coal_block" | "thermal:compat/create/pulverizer_create_asurine_recycle" | "sophisticatedbackpacks:feeding_upgrade" | "farmersdelight:smoked_ham" | "industrialforegoing:fluid_extractor/dark_oak" | "mysticalagriculture:prudentium_gemstone_block_uncraft" | "minecraft:firework_rocket_simple" | "caveopolis:sprayer/colored_cobblestone_bricks/pink_colored_stone_bricks" | "caveopolis:pink_colored_stone_crafting_table" | "mysticalagriculture:essence/minecraft/dirt" | "thermal:compat/quark/insolator_quark_blue_blossom_sapling" | "mysticalagradditions:inferium_coal_block_uncraft" | "opolisutilities:resource_generator_2/speed_blocks/lead" | "caveopolis:sprayer/colored_stone_stairs/light_blue_colored_stone_stairs" | "thermal:storage/signalum_nugget_from_ingot" | "mysticalagriculture:essence/minecraft/birch_sapling" | "caveopolis:pink_colored_wooden_plank_slab_from_pink_colored_wooden_planks_stonecutting" | "caveopolis:red_colored_wooden_plank_pressure_plate_from_red_colored_wooden_planks_stonecutting" | "glassential:glass_ethereal_from_reverse" | "caveopolis:sprayer/remove_color/candles" | "thermal:yellow_concrete_powder_with_slag" | "mysticalagriculture:seed/infusion/coal" | "caveopolis:white_colored_hanging_sign" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/light_gray" | "aquaculture:neptunium_block" | "minecraft:andesite" | "mysticalagriculture:essence/thermal/basalz_rod" | "caveopolis:sprayer/colored_signs/yellow" | "alltheores:bronze_ingot_from_block" | "thermal:compat/create/press_create_zinc_packing" | "thermal_extra:augments/machine_speed_augment_4" | "thermal:devices/fisher/fisher_boost_aquachow" | "supplementaries:pedestal" | "thermal_extra:augments/machine_speed_augment_3" | "mysticalagriculture:seed/crafting/prismarine" | "thermal:machines/smelter/smelter_alloy_enderium" | "caveopolis:sprayer/colored_logs/blue" | "mysticalagradditions:tconstruct/tools/materials/imperium/ingot" | "industrialforegoing:stonework_generate/granite" | "storagedrawers:add_upgrade" | "caveopolis:light_gray_colored_cobblestone_brick_stairs" | "thermal:storage/tin_ingot_from_nuggets" | "industrialforegoing:dissolution_chamber/infinity_launcher" | "strainers:quartz_from_straining_soul_sand_in_minecraft_lava" | "caveopolis:sprayer/colored_cobblestone_stairs/red_colored_stone_stairs" | "thermal_extra:augments/machine_speed_augment_2" | "thermal_extra:augments/machine_speed_augment_1" | "caveopolis:gray_colored_cobblestone_wall" | "mysticalagriculture:seed/infusion/graphite" | "alltheores:ruby_dust_from_hammer_crushing" | "alltheores:sapphire_block" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/blue" | "thermal:compat/tconstruct/press_tconstruct_cobalt_packing" | "farmersdelight:cooking/apple_cider" | "minecraft:dye_light_gray_carpet" | "farmersdelight:integration/create/mixing/cabbage_slice_from_mixing" | "industrialforegoing:laser_drill_ore/raw_materials/cobalt" | "thermal_extra:storage/shellite_ingot_from_nuggets" | "strainers:sniffer_egg_from_straining_suspicious_sand_in_minecraft_water" | "thermal:compat/tconstruct/magmatic_tconstruct_blazing_blood" | "caveopolis:brown_colored_stone_slab_from_brown_colored_stone_stonecutting" | "mysticalagriculture:imperium_essence" | "mysticalagriculture:essence/minecraft/music_disc_chirp" | "caveopolis:sprayer/colored_wooden_plank_stairs/white" | "minecraft:stone" | "minecraft:blackstone_stairs" | "minecraft:dye_orange_carpet" | "libraryferret:crafting_shaped/fake_iron_block" | "caveopolis:black_colored_wooden_plank_fence_gate" | "smallships:sail" | "caveopolis:sprayer/glass_pane/light_blue" | "alltheores:bronze_ore_hammer" | "mysticalagriculture:seed/infusion/platinum" | "alltheores:electrum_ingot_from_dust" | "thermal:compat/create_ie/centrifuge_create_ie_crushed_raw_uranium" | "caveopolis:purple_colored_wooden_plank_fence_gate" | "minecraft:dye_cyan_bed" | "lfpirates:pirate_tier_2_leggins_recipe_1" | "caveopolis:sprayer/colored_hanging_signs/lime" | "caveopolis:sprayer/colored_stone_brick_wall/cyan_colored_stone_brick_wall" | "mysticalagriculture:seed/crafting/fiery_ingot" | "mysticalagriculture:seed/crafting/menril" | "caveopolis:blue_colored_cobblestone_wall_from_blue_colored_cobblestone_stonecutting" | "glassential:dark_ethereal_door" | "mysticalagradditions:tconstruct/tools/materials/soulium/block" | "glassential:glass_ethereal" | "thermal:machine_crafter" | "minecraft:nether_brick_fence" | "farmersdelight:cutting/wither_rose" | "farmersdelight:cutting/porkchop" | "thermal:machines/insolator/insolator_cactus" | "caveopolis:white_colored_stone_pressure_plate_from_white_colored_stone_stonecutting" | "caveopolis:sprayer/colored_cobblestone_brick_stairs/light_blue_colored_stone_brick_stairs" | "caveopolis:sprayer/colored_stone_pressure_plate/gray" | "strainers:tube_coral_from_straining_barrier_in_minecraft_water" | "thermal:machines/pulverizer/pulverizer_redstone_ore" | "minecraft:iron_ingot_from_blasting_raw_iron" | "caveopolis:sprayer/glass_pane/red" | "mysticalagriculture:soulium_spawner/turtle" | "mysticalagriculture:gear/imperium_chestplate" | "minecraft:birch_chest_boat" | "thermal:machines/centrifuge/centrifuge_rose_bush" | "alltheores:mek_processing/iridium/slurry/dirty" | "caveopolis:sprayer/colored_logs/lime" | "simplehats:hatscraps_uncommon" | "minecraft:polished_deepslate_wall_from_polished_deepslate_stonecutting" | "caveopolis:sprayer/colored_logs/yellow" | "thermal:machines/press/press_tin_nugget_to_coin" | "caveopolis:sprayer/colored_wooden_plank_crafting_table/lime" | "thermal:machines/centrifuge/centrifuge_green_rockwool" | "thermal:machines/press/press_rose_gold_ingot_to_plate" | "caveopolis:sprayer/colored_wooden_planks/orange" | "mysticalagriculture:essence/minecraft/music_disc_mellohi" | "strainers:cactus_from_straining_barrier_in_strainers_eroding_water_fluid" | "caveopolis:sprayer/colored_wooden_plank_fence/orange" | "minecraft:green_candle" | "aquaculture:neptunium_axe" | "caveopolis:light_gray_spray_can" | "thermal:machines/pulverizer/pulverizer_cinnabar_ore" | "mysticalagriculture:souls/spider_eye" | "minecraft:waxed_weathered_cut_copper_stairs_from_honeycomb" | "mysticalagriculture:essence/tconstruct/amethyst_bronze_ingot" | "caveopolis:pink_colored_wooden_plank_pressure_plate_from_pink_colored_wooden_planks_stonecutting" | "mysticalagriculture:essence/minecraft/acacia_sapling" | "alltheores:mek_processing/platinum/clump/from_shard" | "caveopolis:sprayer/colored_cobblestone_brick_wall/black_colored_stone_brick_wall" | "minecraft:coal_from_smelting_deepslate_coal_ore" | "mysticalagriculture:essence/minecraft/scute" | "mysticalagriculture:seed/reprocessor/nickel" | "alltheores:mek_processing/nickel/dirty_dust/from_clump" | "caveopolis:lime_colored_wooden_plank_stairs" | "supplementaries:stonecutting/stone_tile" | "supplementaries:relayer" | "mysticalagriculture:essence/minecraft/lava_bucket" | "mysticalagriculture:seed/crafting/signalum" | "mysticalagriculture:soulium_spawner/fish" | "farmersdelight:lime_hanging_canvas_sign" | "mysticalagriculture:prudentium_gemstone_block" | "thermal:fuels/compression/compression_refined_fuel" | "caveopolis:magenta_colored_stone_brick_stairs_from_magenta_colored_stone_bricks_stonecutting" | "minecraft:mud_brick_slab" | "caveopolis:blue_colored_stone_pressure_plate_from_blue_colored_stone_stonecutting" | "thermal:compat/tconstruct/press_tconstruct_cobalt_nugget_packing" | "caveopolis:sprayer/colored_stone_bricks/cyan_colored_stone_bricks" | "minecraft:cooked_mutton_from_smoking" | "minecraft:hopper_minecart" | "minecraft:blue_stained_glass_pane" | "supplementaries:flags/flag_gray" | "caveopolis:red_colored_cobblestone_brick_stairs" | "caveopolis:sprayer/remove_color/saplings" | "thermal:compat/mysticalagriculture/insolator_mysticalag_compressed_iron_seeds" | "caveopolis:sprayer/colored_stone_crafting_table/magenta" | "caveopolis:light_gray_colored_stone_brick_stairs_from_light_gray_colored_stone_bricks_stonecutting" | "caveopolis:blue_colored_cobblestone_bricks_from_blue_colored_cobblestone_stonecutting" | "farmersdelight:integration/immersiveengineering/crusher/wild_onions" | "farmersdelight:pie_crust" | "cozy_home:table_cherry_recipe" | "thermal:compat/create/smelter_create_crushed_raw_gold" | "thermal:smelting/rose_gold_ingot_from_dust_smelting" | "mysticalagriculture:augment/absorption_v" | "thermal:machines/press/press_lead_ingot_to_gear" | "alltheores:mek_processing/aluminum/shard/from_raw_ore" | "thermal:fuels/numismatic/numismatic_iron_coin" | "thermal:machines/press/press_frost_melon_unpacking" | "thermal:compat/mysticalagriculture/insolator_mysticalag_experience_seeds" | "thermal:machines/pulverizer/pulverizer_sulfur_ore" | "glassential:glass_ethereal_reverse" | "thermal:compat/create/centrifuge_create_crushed_raw_iron" | "farmersdelight:cooked_chicken_cuts_from_campfire_cooking" | "farmersdelight:cutting/jungle_hanging_sign" | "lfpirates:fisherman_helmet_recipe_1" | "thermal:rockwool/magenta_rockwool_from_dye" | "thermal:compat/mysticalagriculture/insolator_mysticalag_enderium_seeds" | "minecraft:light_gray_concrete_powder" | "farmersdelight:apple_pie" | "caveopolis:purple_colored_cobblestone_brick_wall_from_purple_colored_cobblestone_bricks_stonecutting" | "thermal:storage/nickel_ingot_from_nuggets" | "farmersdelight:black_canvas_sign" | "thermal:storage/flax_block" | "caveopolis:pink_colored_stone_brick_wall" | "caveopolis:sprayer/colored_cobblestone_wall/orange_colored_stone_wall" | "thermal:compat/tconstruct/insolator_tconstruct_ender_slime_sapling" | "minecraft:diorite_stairs" | "caveopolis:green_colored_wooden_plank_pressure_plate_from_green_colored_wooden_planks_stonecutting" | "caveopolis:sprayer/colored_cobblestone/green_colored_stone" | "oceansdelight:food/fugu_roll" | "mysticalagriculture:soulstone_smooth_slab" | "caveopolis:sprayer/colored_leaves/yellow" | "caveopolis:black_colored_cobblestone_brick_stairs" | "alltheores:lead_ingot_from_ore" | "thermal:machines/crucible/crucible_ender_pearl" | "caveopolis:sprayer/candles/orange" | "industrialforegoing:laser_drill_ore/quartz" | "farmersdelight:purple_hanging_canvas_sign" | "caveopolis:sprayer/colored_cobblestone_stairs/blue_colored_stone_stairs" | "caveopolis:sprayer/glass_block/cyan" | "mysticalagriculture:augment/jump_boost_ii" | "minecraft:deepslate_brick_wall_from_polished_deepslate_stonecutting" | "mysticalagriculture:fire_agglomeratio" | "thermal:machines/press/press_electrum_ingot_to_gear" | "thermal:machines/pulverizer/pulverizer_quartz_block" | "minecraft:end_stone_brick_stairs_from_end_stone_stonecutting" | "mysticalagradditions:nether_inferium_smelted" | "thermal:compat/mekanism/pulverizer_mek_fluorite_ore" | "thermal:machines/press/press_steel_ingot_to_gear" | "mysticalagradditions:tconstruct/melting/supremium/ingot" | "mysticalagriculture:gear/inferium_sickle" | "farmersdelight:cooked_cod_slice_from_smoking" | "caveopolis:magenta_colored_stone_crafting_table" | "alltheores:zinc_block" | "caveopolis:sprayer/colored_stone_pressure_plate/orange" | "caveopolis:sprayer/colored_wooden_plank_trapdoor/yellow" | "industrialforegoing:laser_drill_fluid/oil" | "mysticalagriculture:seed/infusion/neutronium" | "thermal:machines/chiller/chiller_honey_to_honey_block" | "thermal:armor/beekeeper_chestplate" | "supplementaries:daub" | "minecraft:netherite_scrap" | "alltheores:zinc_dust_from_hammer_crushing" | "minecraft:cut_sandstone" | "mysticalagriculture:essence/minecraft/fire_coral" | "alltheores:tin_dust_from_hammer_ingot_crushing" | "thermal:smelting/polished_rich_slag_from_smelting" | "storagedrawers:birch_full_drawers_1" | "thermal:machines/bottler/bottler_light_blue_concrete" | "storagedrawers:birch_full_drawers_2" | "storagedrawers:birch_full_drawers_4" | "thermal:storage/copper_nugget_from_ingot" | "strainers:summoning_block/bee" | "chipped:mason_table" | "minecraft:nether_brick_slab" | "framedcompactdrawers:frame_three" | "caveopolis:sprayer/glass_block/magenta" | "caveopolis:cyan_colored_hanging_sign" | "alltheores:raw_iridium_from_block" | "alltheores:nickel_gear" | "alltheores:nickel_ingot_from_slate_ore_blasting" | "thermal:compat/farmersdelight/insolator_farmersdelight_cabbage" | "cozy_home:grandfather_clock_mangrove_recipe" | "minecraft:campfire" | "thermal:fuels/numismatic/numismatic_signalum_coin" | "caveopolis:pink_colored_stone_slab" | "alltheores:tools_materials/tin/tin_from_block" | "farmersdelight:cutting/oak_sign" | "minecraft:brick_stairs" | "caveopolis:mossy_string" | "thermal:machines/smelter/smelter_electrum_plate_to_ingot" | "farmersdelight:cooking/chicken_soup" | "caveopolis:sprayer/colored_wooden_plank_fence/magenta" | "mysticalagriculture:essence/chisel/basalt" | "thermal:compat/mysticalagriculture/insolator_mysticalag_yellorium_seeds" | "mysticalagriculture:imperium_block_uncraft" | "mysticalagriculture:coral_agglomeratio" | "thermal:machines/press/packing3x3/press_signalum_packing" | "mysticalagriculture:seed/crafting/vibrant_alloy" | "supplementaries:stonecutting/lapis_brick_slab_from_bricks" | "thermal:press_gear_die" | "minecraft:waxed_cut_copper_from_waxed_copper_block_stonecutting" | "mysticalagriculture:unattuned_augment" | "minecraft:black_stained_glass" | "minecraft:dye_purple_wool";
    type LangKey = "block.chipped.engraved_amethyst_block" | "config.jade.plugin_storagedrawers.display.status" | "block.chipped.pegged_birch_planks" | "block.chipped.warning_blue_concrete" | "multiplayer.disconnect.flying" | "block.chipped.fancy_lime_stained_glass" | "item.minecraft.potion.effect.weakness" | "item.mysticalagriculture.awakened_supremium_leggings" | "item.farmersdelight.rotten_tomato" | "gui.supplementaries.speaker_block.action_bar_message" | "config.supplementaries.pedestal.spin.description" | "block.chipped.cobbled_redstone_block" | "block.chipped.waved_light_gray_glazed_terracotta" | "obscure_api.penetration" | "config.supplementaries.way_sign.enabled.description" | "block.chipped.unamused_prismarine" | "options.onlyShowSecureChat.tooltip" | "item.aquaculture.box_turtle" | "fancymenu.helper.editor.items.visibilityrequirements.is_number" | "block.suppsquared.sack_black" | "painting.cozy_home.light_beyond.author" | "gamerule.disableElytraMovementCheck" | "advancements.nether.create_full_beacon.description" | "ftbquests.file.defaults.quest_disable_jei" | "item.thermal.electrum_ingot" | "ftbquests.reward.ftbquests.advancement.criterion" | "ftbultimine.server_settings.merge_tags.tooltip" | "subtitles.entity.iron_golem.hurt" | "block.thermal.dynamo_lapidary.keyword" | "block.chipped.smooth_oak_planks" | "block.chipped.glad_dark_prismarine" | "item.minecraft.bowl" | "item.ftbquests.book.tooltip" | "item.minecraft.bone_meal" | "block.chipped.distorted_cherry_trapdoor" | "ftbquests.quest.visibility.hide_text_until_complete" | "fluid_type.thermal_extra.blizz" | "block.chipped.polished_emerald_block" | "block.chipped.raster_brown_stained_glass_pane" | "block.chipped.waved_white_glazed_terracotta" | "item.simplehats.headbolts" | "farmersdelight.advancement.place_feast.desc" | "multiplayer.status.no_connection" | "fancymenu.elements.widgets.generic.navigatable" | "block.cozy_home.mangrove_storage_counter" | "ftbquests.quest.visibility.hide" | "block.chipped.smooth_stone_mini_tiles" | "block.chipped.vertical_stiped_blue_stained_glass_pane" | "block.chipped.smooth_mud_bricks" | "item.strainers.echo_mesh" | "block.furniture_mod.counter_oak_sink" | "block.minecraft.banner.stripe_bottom.light_blue" | "fancymenu.overlay.menu_bar.help.discord.tooltip" | "block.chipped.bulbed_warped_fungus" | "skyblockbuilder.command.error.no_player_added" | "fancymenu.element.anchor_point.top_right" | "block.chipped.smoothed_double_inlayed_lodestone" | "block.minecraft.potted_white_tulip" | "chat.cannotSend" | "mco.download.title" | "block.chipped.spider_red_sandstone_carving" | "jm.webmap.google_domain.tooltip" | "tooltip.titanium.facing_handler.death.input_0" | "block.cozy_home.crimson_plank" | "block.chipped.cut_blank_quartz_block" | "block.chipped.layed_redstone_block_bricks" | "stat.minecraft.damage_dealt" | "createWorld.customize.presets.list" | "gui.sophisticatedcore.settings.item_display.tooltip_open_detail" | "title.32bit.deprecation.realms.check" | "ftbquests.task.ftbquests.buildcraft_mj.value" | "item.sophisticatedbackpacks.auto_blasting_upgrade" | "tag.item.chipped.purple_glazed_terracotta" | "item.pirates.sailor_red_tier_1_chestplate" | "block.mysticalagriculture.inferium_furnace" | "mco.backup.entry.gameMode" | "block.minecraft.oak_planks" | "fluid_type.thermal_extra.blitz" | "block.caveopolis.purple_colored_stone_crafting_table" | "conveyor.upgrade.industrialforegoing.tooltip.insert_all" | "fancymenu.helper.editor.items.features.advanced_positioning.desc" | "tutorial.socialInteractions.title" | "item.sophisticatedbackpacks.xp_pump_upgrade.tooltip" | "item.industrialforegoing.tinydryrubber" | "block.minecraft.purple_shulker_box" | "commands.item.source.not_a_container" | "datapackFailure.safeMode" | "block.minecraft.light_blue_bed" | "fancymenu.elements.slider.v2.type.range.set_max.desc" | "leaves_type.chipped.golden_apple_birch" | "commands.ftbquests.command.delete_empty_reward_tables.text" | "block.caveopolis.orange_colored_wooden_plank_trapdoor" | "advancements.adventure.honey_block_slide.title" | "block.chipped.rusted_light_gray_concrete" | "ftbquests.null" | "leaves_type.caveopolis.white_colored" | "gui.chatReport.report_sent_msg" | "block.chipped.stop_orange_concrete" | "biome.minecraft.warped_forest" | "ftbquests.task.ftbquests.npc_dialog.id" | "block.chipped.stop_light_blue_concrete" | "item.sophisticatedbackpacks.chipped.botanist_workbench_upgrade.tooltip" | "item.minecraft.book" | "block.chipped.engraved_packed_ice" | "jm.common.automap_dialog_text" | "block.caveopolis.marble_brick_slab" | "block.chipped.ornate_magenta_stained_glass_pane" | "block.minecraft.black_shulker_box" | "block.chipped.cut_blank_prismarine" | "subtitles.block.amethyst_block.chime" | "block.supplementaries.redstone_illuminator" | "block.chipped.thick_inlayed_end_stone" | "jm.webmap.pets_menu_item_text" | "fancymenu.menu_background.choose" | "aquaculture.loot.open" | "fancymenu.overlay.debug.screen_active_element_count" | "tag.item.chipped.red_glazed_terracotta" | "itemGroup.industrialforegoing_transport" | "block.thermal.gray_rockwool" | "block.chipped.purple_terracotta_pillar" | "block.chipped.cobbled_amethyst_block" | "item.aquaculture.worm" | "key.journeymap.fullscreen_waypoints" | "item.minecraft.bamboo_chest_raft" | "block.caveopolis.green_colored_cobblestone_wall" | "block.caveopolis.pink_colored_stone_brick_slab" | "block.chipped.engraved_redstone_block" | "subtitles.entity.slime.hurt" | "block.chipped.small_light_gray_terracotta_tiles" | "ftbquests.chapter.image" | "block.minecraft.bamboo_slab" | "gamerule.reducedDebugInfo.description" | "block.chipped.inscribed_lapis_block" | "block.minecraft.brown_wool" | "subtitles.entity.ghast.ambient" | "item.alltheores.tin_plate" | "arguments.function.tag.unknown" | "subtitles.entity.ravager.stunned" | "block.chipped.engraved_andesite" | "tag.item.chipped.tuff" | "block.chipped.tall_soul_lantern" | "fancymenu.fancymenu.editor.dynamicvariabletextfield.variables.guiheight.desc" | "subtitles.entity.bee.loop" | "block.chipped.edged_mossy_cobblestone_bricks" | "block.furniture_mod.drawer_acacia_right" | "item.minecraft.bone" | "block.chipped.cubed_red_wool" | "fancymenu.editor.action.screens.build_screen.edit_value.desc.normal" | "block.chipped.smooth_white_redstone_lamp" | "effect.cofh_core.amplification" | "argument.angle.incomplete" | "block.industrialforegoing.protein_generator" | "fancymenu.helper.editor.items.visibilityrequirements.language" | "fml.messages.version.restriction.any" | "gui.chatReport.read_info" | "block.chipped.heart_mud" | "block.chipped.screen_jungle_door" | "block.mysticalagriculture.prosperity_ore" | "text.industrialforegoing.button.stone.grind" | "multiplayer.status.version.narration" | "mco.configure.world.buttons.switchminigame" | "ftbultimine.server_settings.ultimine_cooldown" | "block.chipped.smoothed_double_inlayed_ice" | "subtitles.entity.guardian.attack" | "ftbquests.file.defaults" | "block.chipped.vertical_disordered_mud_bricks_bricks" | "block.caveopolis.stripped_magenta_colored_wood" | "block.caveopolis.gray_colored_cobblestone_brick_wall" | "block.chipped.engraved_magma_block" | "block.chipped.slanted_mangrove_planks" | "block.chipped.trodden_end_stone" | "block.chipped.knitted_white_wool" | "config.supplementaries.bottle_xp.enabled.description" | "subtitles.entity.generic.death" | "block.minecraft.banner.square_bottom_left.gray" | "commands.scoreboard.objectives.display.set" | "pack.source.builtin" | "commands.perf.reportFailed" | "block.minecraft.cyan_stained_glass" | "augmentType.mysticalagriculture.weapon" | "commands.place.structure.success" | "fancymenu.helper.visibilityrequirement.gamemode.is_survival.desc" | "block.chipped.shack_acacia_door" | "item.geckolib.jack_in_the_box.opening" | "fancymenu.editor.loading_requirement.elements.loading_requirements.desc" | "item.mysticalagradditions.imperium_coal" | "gui.sophisticatedcore.settings.message.load_template" | "block.aquamirae.painting_aurora" | "block.chipped.shack_cherry_door" | "block.chipped.unamused_purpur_block" | "block.chipped.reinforced_sea_lantern" | "item.sophisticatedbackpacks.advanced_magnet_upgrade.tooltip" | "block.chipped.smooth_ringed_mud_bricks" | "block.chipped.smooth_end_stone_column" | "fancymenu.helper.placeholder.elementposy.desc" | "block.chipped.shifted_mangrove_planks" | "block.minecraft.banner.creeper.red" | "block.chipped.windowed_jungle_door" | "item.storagedrawers.upgrade_template" | "item.thermal.silver_dust" | "block.chipped.desert_sand" | "item.thermal.rf_coil" | "container.hopper" | "item.aquaculture.capitaine_bucket" | "fancymenu.editor.render_custom_behind_vanilla" | "ftbquests.gui.collect_rewards" | "block.minecraft.white_bed" | "block.chipped.basket_woven_acacia_planks" | "createWorld.customize.custom.presets.title" | "item.theoneprobe.diamond_helmet_probe" | "subtitles.entity.pillager.ambient" | "block.cozy_home.sofa_light_blue" | "crop.mysticalagriculture.blizz" | "block.chipped.tiled_shroomlight_pillar" | "book.mysticalagriculture.entry.nausea_resistance_augment" | "block.chipped.decorated_cyan_terracotta" | "item.minecraft.tropical_fish" | "mco.download.percent" | "fancymenu.placeholders.screen_identifier" | "options.telemetry.state.minimal" | "fancymenu.fancymenu.editor.dynamicvariabletextfield.variables.guiwidth.desc" | "jm.common.map_style_plantshadows" | "subtitles.entity.villager.work_toolsmith" | "block.chipped.plated_iron_block" | "item.minecraft.tipped_arrow.effect.harming" | "block.chipped.trodden_purpur_block" | "block.chipped.circular_light_gray_stained_glass_pane" | "block.chipped.rune_packed_mud" | "pack.thermal.description" | "block.minecraft.cartography_table" | "block.chipped.mosaic_white_concrete" | "block.chipped.blank_red_nether_bricks_carving" | "fancymenu.resources.source_type.web.desc" | "jm.theme.labelsource.moonphase.waxing_crescent" | "jei.chat.error.no.cheat.permission.enabled" | "block.thermal.charge_bench.desc" | "block.chipped.tripped_gray_carpet" | "block.ftbquests.screen.task_index" | "jm.colorpalette.resource_packs" | "commands.enchant.success.multiple" | "block.chipped.runic_carved_magma_block" | "subtitles.entity.llama.spit" | "block.chipped.gray_terracotta_bricks" | "block.chipped.angry_mossy_cobblestone" | "block.chipped.classic_windowed_bamboo_trapdoor" | "jm.common.grid_editor" | "block.chipped.stringed_light_blue_wool" | "block.mysticalagriculture.soulstone_bricks_stairs" | "block.chipped.iron_bars_top" | "crop.mysticalagriculture.experience" | "block.minecraft.mangrove_hanging_sign" | "jm.colorpalette.mods" | "entity.minecraft.villager.butcher" | "icon.damage" | "block.chipped.brick_bond_bamboo_planks" | "block.minecraft.banner.half_horizontal_bottom.light_gray" | "fancymenu.customization.items.text.v2.desc" | "skyblockbuilder.command.denied.teleport_home" | "block.chipped.leafy_mangrove_trapdoor" | "gamerule.doMobSpawning.description" | "fancymenu.editor.elements.vanilla_widget.generic" | "block.minecraft.skeleton_skull" | "gui.chatReport.more_comments" | "subtitles.block.shulker_box.close" | "text.industrialforegoing.book.enchantment_refiner" | "item.luggage.luggage" | "item.supplementaries.flax_seeds" | "block.cozy_home.crimson_chair" | "info.cofh.chance" | "gui.stats" | "block.supplementaries.candle_holder_pink" | "effect.aquamirae.armor_decrease.description" | "tooltip.mysticalagriculture.tier" | "block.thermal.rubberwood_log" | "block.chipped.lily_warped_roots" | "crop.mysticalagriculture.blitz" | "block.chipped.waved_brown_glazed_terracotta" | "mco.upload.done" | "item.smallships.birch_galley" | "item.thermal.beekeeper_boots.keyword" | "block.caveopolis.yellow_colored_stone_brick_wall" | "gui.libraryferret.props.name.k_e_y_-_p_r_o_p_s" | "item.smallships.jungle_cog" | "block.caveopolis.black_colored_cobblestone_brick_slab" | "block.minecraft.bricks" | "block.minecraft.diorite_slab" | "block.chipped.shifted_bamboo_planks" | "block.chipped.cobbled_sandstone" | "item.alltheores.invar_nugget" | "text.industrialforegoing.display.producing" | "block.supplementaries.crank" | "ftbquests.quest.appearance.shape" | "item.pirates.craftsman_boots" | "block.minecraft.melon_stem" | "block.chipped.meshed_bamboo_trapdoor" | "block.chipped.curly_diorite_pillar" | "multiplayer.status.unknown" | "item.simplehats.beaniespooky" | "item.minecraft.iron_pickaxe" | "fancymenu.elements.multiselect.loading_requirements.warning.override" | "forge.experimentalsettings.tooltip" | "config.jei.valid" | "block.chipped.vertical_botanical_oak_bookshelf" | "block.chipped.windowed_bamboo_trapdoor" | "block.chipped.smooth_inlayed_nether_bricks" | "mco.configure.world.spawnMonsters" | "item.mysticalagriculture.awakened_supremium_scythe" | "disconnect.loginFailedInfo" | "block.chipped.triangular_white_terracotta" | "multiplayer.requiredTexturePrompt.disconnect" | "subtitles.entity.shulker_bullet.hurt" | "block.chipped.smoothed_double_inlayed_smooth_stone" | "item.industrialforegoing.raw_ore_meat_bucket" | "block.chipped.cross_haired_purple_wool" | "gui.sophisticatedcore.upgrades.magnet" | "item.thermal.enderium_nugget" | "fancymenu.editor.custombutton.config.actiontype.join_last_world" | "block.caveopolis.light_gray_colored_wooden_plank_pressure_plate" | "block.chipped.small_netherrack_bricks" | "sleep.skipping_night" | "fancymenu.overlay.menu_bar.variables" | "block.chipped.embossed_waxed_copper_block" | "container.enchant.lapis.many" | "subtitles.entity.parrot.imitate.witch" | "block.chipped.hard_packed_mud" | "jm.webmap.day_button_title" | "skyblockbuilder.command.success.delete_multiple_teams" | "options.chat.height.unfocused" | "subtitles.entity.stray.ambient" | "block.chipped.engraved_waxed_copper_block" | "block.minecraft.bed.not_safe" | "crop.mysticalagriculture.mystical_flower" | "block.minecraft.banner.straight_cross.light_blue" | "block.chipped.lodestone_scales" | "commands.place.template.failed" | "block.chipped.shroomy_nether_sprouts" | "fml.modmismatchscreen.additional" | "text.industrialforegoing.north" | "advancements.end.find_end_city.description" | "commands.drop.success.multiple" | "block.chipped.ornate_ice_pillar" | "block.chipped.paneled_warped_door" | "item.minecraft.iron_axe" | "block.thermal.corn_block" | "mco.selectServer.openserver" | "tag.item.chipped.green_terracotta" | "commands.team.option.collisionRule.unchanged" | "item.smallships.birch_war_galley" | "options.vsync" | "advancements.aquamirae.consume_poseidons_breakfast.descr" | "block.chipped.tiny_layered_blackstone_bricks" | "block.chipped.rough_raw_copper_block" | "block.minecraft.mangrove_fence_gate" | "skyblockbuilder.command.success.rename_team" | "fancymenu.helper.editor.items.visibilityrequirements.is_button_active.desc" | "structure_block.show_air" | "item.thermal.coffee" | "block.thermal.dynamo_gourmand.keyword" | "chat.type.text.narrate" | "block.chipped.square_brown_stained_glass_pane" | "block.stoneopolis.rainbow_bricks" | "block.chipped.wickered_red_carpet" | "text.cloth-config.quit_config" | "fancymenu.helper.editor.layoutoptions.universal_layout.options.remove_blacklist" | "translation.test.complex" | "ftbquests.task.ftbquests.botania_mana.text" | "gui.sophisticatedbackpacks.upgrades.refill.scroll.tooltip" | "commands.setidletimeout.success" | "class.aquamirae.sea_wolf" | "item.thermal.glowstone_mushroom" | "ftbultimine.server_settings.require_tool.tooltip" | "title.multiplayer.disabled.banned.temporary" | "item.simplehats.hatbag_common" | "block.chipped.knitted_light_gray_wool" | "block.chipped.hexagonical_blue_terracotta" | "tag.item.chipped.iron_bars" | "tag.item.chipped.andesite" | "item.alltheores.dirty_iron_dust" | "subtitles.entity.villager.yes" | "crop.mysticalagriculture.soularium" | "block.chipped.etched_nether_bricks_bricks" | "gui.multiLineEditBox.character_limit" | "tooltip.titanium.facing_handler.enchanted_books" | "advancements.adventure.totem_of_undying.description" | "fancymenu.editor.anchor_overlay.charging_time.slider_label" | "block.chipped.mushroom_barrel" | "block.supplementaries.lead_lantern" | "block.furniture_mod.counter_spruce_sink_water_1" | "block.furniture_mod.counter_spruce_sink_water_3" | "block.furniture_mod.counter_spruce_sink_water_2" | "block.chipped.checkered_smooth_stone_tiles" | "block.chipped.curly_coal_block_pillar" | "event.minecraft.raid.victory" | "block.ftbquests.loot_crate_opener.rightclick" | "key.keyboard.keypad.equal" | "subtitles.block.pressure_plate.click" | "fancymenu.editor.action.screens.remove_action" | "argument.uuid.invalid" | "fancymenu.helper.editor.items.playerentity.parrot.desc" | "block.chipped.woved_cyan_carpet" | "item.minecraft.blaze_spawn_egg" | "block.chipped.tiled_brown_stained_glass_pane" | "block.chipped.decorated_cyan_glazed_terracotta" | "block.minecraft.warped_slab" | "gui.sophisticatedcore.settings.buttons.save_template.controls" | "block.chipped.small_lapis_block_bricks" | "block.mysticalagriculture.soulium_spawner" | "item.opolisutilities.log_sheet" | "ftbquests.ui.old_scroll_wheel.tooltip" | "commands.drop.no_loot_table" | "gui.sophisticatedbackpacks.settings.buttons.context_backpack" | "block.chipped.screen_oak_door" | "block.chipped.vertical_cut_red_nether_bricks" | "slider.btn.volume" | "fluid_type.industrialforegoing.biofuel" | "mco.configure.world.spawnAnimals" | "item.alltheores.copper_clump" | "block.minecraft.magma_block" | "block.chipped.tiny_packed_mud_bricks" | "block.chipped.bulbed_red_mushroom" | "commands.forge.gen.complete" | "fml.modloading.missinglicense" | "tutorial.find_tree.title" | "subtitles.entity.mule.death" | "commands.ride.already_riding" | "text.dankstorage.change_pickup_mode" | "fancymenu.elements.text.v2.source_mode.resource" | "book.mysticalagriculture.category.souls.description" | "config.supplementaries.bad_luck_tweaks.cat_unluck.description" | "text.industrialforegoing.extra_range" | "skyblockbuilder.command.info.visit_status" | "block.minecraft.sponge" | "block.chipped.bundled_light_gray_carpet" | "options.online.title" | "block.industrialforegoing.mob_slaughter_factory" | "block.minecraft.light_gray_candle" | "block.chipped.massive_cobblestone_bricks" | "block.chipped.cracked_dirt_bricks" | "forge.configgui.logCascadingWorldGeneration" | "block.caveopolis.pink_colored_wooden_planks" | "options.sounds" | "item.thermal.ice_tnt_minecart" | "block.thermal.silver_block" | "block.chipped.vertical_disordered_mossy_stone_bricks_bricks" | "fluid.mysticalagradditions.molten_supremium" | "block.chipped.blackstone_pointed_dripstone" | "tooltip.titanium.facing_handler.input_green" | "text.dankstorage.formatcontaineditems" | "subtitles.entity.evoker.prepare_summon" | "block.minecraft.banner.stripe_downright.light_blue" | "item.thermal.explosive_grenade" | "info.thermal.redprint.data.RSControl" | "libx.config.gui.resource_list.type_deny_list" | "mco.template.title.minigame" | "fancymenu.guicomponents.set" | "block.chipped.prismarine_pillar" | "block.chipped.creeper_nether_bricks_carving" | "item.thermal.dynamo_fuel_augment.keyword" | "augment.mysticalagriculture.tilling_aoe_iv" | "jm.common.fullscreen_drag_scale" | "block.minecraft.banner.cross.purple" | "block.systeams.compression_boiler.keyword" | "gui.hours" | "augment.mysticalagriculture.tilling_aoe_ii" | "block.chipped.hewn_birch_planks" | "item.minecraft.carrot" | "fancymenu.editor.anchor_overlay.overlay_color_border" | "painting.minecraft.wasteland.title" | "block.chipped.tiny_layered_amethyst_block_slabs" | "block.cozy_home.cherry_drawer" | "block.chipped.flat_redstone_block_tiles" | "block.chipped.tiny_layered_smooth_stone_bricks" | "jm.server.allow_view_server_prop" | "block.aquamirae.painting_anglerfish_desc" | "block.chipped.andesite_gravel" | "block.chipped.offset_blackstone_bricks" | "block.furniture_mod.counter_warped_storage" | "block.caveopolis.lime_colored_stone_brick_wall" | "block.mysticalagriculture.soulstone_cobble_stairs" | "commands.locate.structure.not_found" | "config.supplementaries.tweaks.crossbows_colors.description" | "block.chipped.large_mud_bricks_sigil" | "block.chipped.spiraled_dirt" | "fancymenu.overlay.menu_bar.customization.settings.play_menu_music" | "stat.minecraft.open_chest" | "icon.attack_speed.medium" | "block.minecraft.quartz_stairs" | "commands.advancement.grant.many.to.one.success" | "block.chipped.shifted_birch_planks" | "commands.team.option.name.success" | "item.minecraft.oak_boat" | "key.mount_jump" | "fancymenu.background.image.type.web.fallback" | "fancymenu.editor.shortcuts.cut" | "block.caveopolis.magenta_colored_wooden_plank_trapdoor" | "block.chipped.pillar_cobblestone_bricks" | "block.minecraft.white_shulker_box" | "ftbteams.api_override" | "attribute.obscure_api.healingPower" | "block.furniture_mod.spruce_chair_tucked" | "block.chipped.arched_pink_stained_glass_pillar" | "gui.sophisticatedcore.upgrades.buttons.void_anything_disabled" | "item.alltheores.diamond_plate" | "block.chipped.seared_warped_wart_block" | "block.minecraft.melon" | "block.chipped.blank_tuff_carving" | "fancymenu.helper.editor.edit_menu_title.reset.invalid_title" | "config.supplementaries.tweaks.clock_right_click.description" | "block.chipped.edged_raw_iron_block_bricks" | "item.simplehats.holyhead" | "block.chipped.etched_magma_block_bricks" | "block.suppsquared.metal_frame" | "block.chipped.eroded_sandstone" | "block.furniture_mod.lamp_purple" | "block.chipped.boarded_birch_door" | "item.farmersdelight.salmon_roll" | "options.chat.scale" | "subtitles.entity.warden.listening_angry" | "ftbquests.reward.ftbquests.item.only_one.tooltip" | "aquaculture.quartz_hook.tooltip.title" | "tag.item.chipped.mangrove_door" | "block.chipped.angry_crying_obsidian" | "block.chipped.rectangle_cyan_wool" | "commands.experience.query.levels" | "info.systeams.air_per_tick_unit" | "fancymenu.editor.actions.execute_terminal_command.edit.desc.line2" | "fancymenu.editor.actions.execute_terminal_command.edit.desc.line1" | "fancymenu.editor.actions.execute_terminal_command.edit.desc.line3" | "gui.sophisticatedcore.upgrades.chipped_botanist_workbench" | "block.cozy_home.mangrove_table" | "block.caveopolis.purple_colored_leaves" | "jei.category.mysticalagriculture.soulium_spawner" | "block.chipped.hived_sea_lantern" | "item.alltheores.aluminum_ingot" | "block.chipped.lodestone_pillar" | "item.minecraft.firework_star.fade_to" | "block.chipped.magenta_flower_spruce_leaves" | "block.cozy_home.blue_lamp" | "item.minecraft.music_disc_cat" | "block.chipped.cracked_crying_obsidian_bricks" | "block.chipped.cross_haired_purple_carpet" | "block.minecraft.oak_wood" | "block.chipped.hexagonical_terracotta" | "block.minecraft.powered_rail" | "leaves_type.caveopolis.orange_colored" | "argument.dimension.invalid" | "block.chipped.runic_carved_gilded_blackstone" | "item.smallships.spruce_cog" | "slurry.alltheores.clean_uranium" | "block.chipped.cross_haired_blue_carpet" | "commands.team.option.prefix.success" | "block.thermal.tinker_bench" | "block.caveopolis.red_colored_wooden_plank_fence_gate" | "fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.choose_16" | "block.alltheores.other_redstone_ore" | "block.chipped.creeper_magenta_concrete" | "block.chipped.tuff_bricks" | "config.supplementaries.general.test2.description" | "block.minecraft.green_shulker_box" | "entity.minecraft.wither_skeleton" | "block.chipped.brick_bordered_red_nether_bricks" | "block.chipped.orange_spruce_leaves" | "block.chipped.iron_barred_oak_trapdoor" | "commands.reload.failure" | "set.aquamirae.dead_sea_chestplate" | "item.alltheores.constantan_rod" | "fancymenu.helper.editor.items.buttons.buttonbackground.set" | "item.minecraft.dark_oak_chest_boat" | "block.minecraft.petrified_oak_slab" | "block.furniture_mod.fireplace_oak" | "fancymenu.customization.items.text.set_source.web.desc" | "block.chipped.sandstone_pillar" | "block.chipped.rounded_end_stone_bricks" | "block.chipped.calcite_pointed_dripstone" | "block.chipped.nether_jack_o_lantern" | "advancements.adventure.arbalistic.description" | "perk.aquamirae.rune_of_the_storm" | "block.chipped.sad_obsidian" | "block.minecraft.banner.half_vertical.pink" | "block.caveopolis.blue_colored_wooden_plank_fence_gate" | "block.minecraft.zombie_head" | "block.minecraft.warped_roots" | "block.chipped.vertical_cut_dark_prismarine" | "fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.choose_32" | "telemetry.property.client_modded.title" | "jm.common.radar_hide_sneaking" | "entity.aquaculture.atlantic_herring" | "block.chipped.overlapping_smooth_stone_tiles" | "block.minecraft.piglin_head" | "item.duckling.duck_spawn_egg" | "info.systeams.steam_prod" | "block.chipped.glass_jungle_door" | "ftbquests.gui.change_progress.complete" | "item.minecraft.music_disc_relic.desc" | "block.chipped.simple_raw_copper_block_pillar" | "item.farmersdelight.shepherds_pie" | "ftbquests.task.ftbquests.fluid.fluid" | "block.chipped.tiled_tuff" | "block.thermal.gunpowder_block" | "block.chipped.creeper_black_concrete" | "block.minecraft.sand" | "item.alltheores.electrum_plate" | "block.chipped.ornate_blue_stained_glass" | "block.chipped.eroded_calcite" | "block.minecraft.smooth_quartz_stairs" | "commands.data.get.invalid" | "block.chipped.ancient_oak_bookshelf" | "block.supplementaries.rope" | "subtitles.block.end_portal_frame.fill" | "subtitles.entity.puffer_fish.flop" | "fancymenu.editor.action.screens.manage_screen.info.value.none" | "block.chipped.cracked_flat_raw_copper_block_tiles" | "item.thermal_extra.twinite_nugget" | "advancements.husbandry.safely_harvest_honey.title" | "block.chipped.ancient_diamond_block" | "block.chipped.stringed_purple_carpet" | "block.chipped.stacked_waxed_copper_block" | "item.caveopolis.debris_fragment" | "block.alltheores.iridium_ore" | "item.smallships.spruce_brigg" | "stat.minecraft.damage_absorbed" | "fancymenu.element.general.appearance_delay.no_delay" | "item.minecraft.tipped_arrow.effect.slowness" | "subtitles.entity.dolphin.jump" | "libx.config.gui.resource_list.entry_mode_deny" | "block.caveopolis.orange_colored_stone_crafting_table" | "item.mysticalagradditions.supremium_paxel" | "multiplayer.status.player_count.narration" | "block.minecraft.banner.triangles_bottom.yellow" | "block.chipped.wide_lantern" | "text.cloth-config.disabled_tooltip" | "block.chipped.simple_ancient_debris_pillar" | "block.caveopolis.brown_colored_log" | "item.minecraft.music_disc_otherside.desc" | "block.chipped.large_diamond_yellow_stained_glass" | "gui.sophisticatedcore.upgrades.buttons.store_levels" | "tooltip.titanium.redstone.once" | "block.chipped.smooth_ringed_dark_prismarine" | "item.lfpirates.sailor_nordic_tier_2_helmet" | "block.thermal.machine_press.keyword" | "jei.tooltip.error.recipe.transfer.inventory.full" | "selectWorld.incompatible_series" | "soundCategory.voice" | "attribute.name.generic.knockback_resistance" | "createWorld.customize.custom.lowerLimitScale" | "block.chipped.blank_granite_carving" | "block.chipped.whirlwind_bamboo_planks" | "block.chipped.bundled_yellow_wool" | "block.chipped.windmill_light_blue_wool" | "block.chipped.boxed_dark_oak_planks" | "biome.minecraft.old_growth_spruce_taiga" | "item.farmersdelight.sweet_berry_cheesecake_slice" | "block.chipped.reinforced_lime_concrete" | "block.minecraft.light_gray_concrete_powder" | "block.chipped.cross_laced_birch_planks" | "item.piracimc.pirat_tier_i_chestplate" | "item.sophisticatedbackpacks.jukebox_upgrade.tooltip" | "block.opolisutilities.redstone_clock" | "config.supplementaries.sack.sack_penalty.description" | "block.minecraft.red_sandstone_wall" | "item.minecraft.diamond_axe" | "fancymenu.element.anchor_point.vanilla" | "jm.common.renderdistance_cave_max" | "item.thermal.glowstone_grenade" | "block.caveopolis.lime_colored_sapling" | "ftbteamsconfig.ftbteams" | "block.chipped.tiny_layered_purpur_block_slabs" | "commands.scoreboard.players.list.success" | "book.byAuthor" | "block.chipped.trodden_magma_block" | "block.chipped.triangular_blue_terracotta" | "block.chipped.unamused_magma_block" | "subtitles.entity.parrot.imitate.illusioner" | "commands.sophisticatedbackpacks.list.cloth_color" | "block.chipped.pointless_bamboo_trapdoor" | "block.chipped.tiled_raw_gold_block_column" | "fluid_type.industrialforegoing.protein" | "subtitle.supplementaries.globe.spin" | "block.chipped.tripped_black_wool" | "forge.configgui.clumpingThreshold" | "block.chipped.planked_mangrove_log" | "item.minecraft.diamond_pickaxe" | "config.supplementaries.dispenser_tweaks.shoot_ender_pearls.description" | "entity.minecraft.sheep" | "subtitles.entity.player.hurt_drown" | "block.chipped.fancy_yellow_stained_glass_pane" | "block.minecraft.light_gray_carpet" | "block.chipped.carved_dark_prismarine" | "subtitles.entity.item.pickup" | "biome.minecraft.snowy_plains" | "block.chipped.arched_leaded_glass_pane_pillar" | "block.thermal.chiseled_rich_slag" | "item.supplementaries.cozy_home.sign_post_cherry" | "block.systeams.numismatic_boiler.keyword" | "fml.menu.accessdenied.title" | "fancymenu.editor.loading_requirement.screens.build_screen.edit_value.desc.normal" | "item.simplehats.flies" | "item.farmersdelight.sweet_berry_cookie" | "tag.item.chipped.cyan_glazed_terracotta" | "key.jei.closeRecipeGui" | "block.chipped.carved_lapis_block" | "block.chipped.crimson_barrel" | "crop.mysticalagriculture.netherite" | "commands.whitelist.reloaded" | "block.minecraft.mud_bricks" | "block.chipped.raster_gray_stained_glass_pane" | "subtitles.entity.axolotl.attack" | "item.minecraft.splash_potion.effect.potion_of_tenacity" | "block.thermal.bitumen_block" | "block.chipped.weathered_calcite" | "createWorld.customize.custom.stretchY" | "block.chipped.tiny_brick_bordered_purpur_block" | "subtitles.entity.bat.ambient" | "commands.tag.add.success.multiple" | "jm.common.renderdistance_surface_min.tooltip" | "item.simplehats.pighead" | "book.mysticalagriculture.category.tinkering.description" | "selectWorld.edit.export_worldgen_settings.failure" | "block.chipped.tripped_pink_carpet" | "commands.recipe.give.success.single" | "fancymenu.customization.items.text.auto_line_wrapping" | "subtitles.block.generic.footsteps" | "item.mysticalagriculture.soul_dust" | "block.chipped.carved_mud_bricks" | "item.thermal.tomato_seeds" | "block.chipped.light_gray_concrete_bricks" | "commands.title.show.actionbar.multiple" | "block.chipped.ornate_deepslate_pillar" | "block.minecraft.netherite_block" | "item.minecraft.tipped_arrow.effect.thick" | "block.thermal.pink_rockwool" | "ftbquests.gui.key_reference.editor" | "item.thermal.fluid_tank_augment.keyword" | "ftbultimine.shape.small_tunnel" | "item.thermal.flux_drill.desc" | "block.chipped.cut_smooth_stone_column" | "jm.common.renderdistance_cave_min" | "item.thermal.fluid_filter_augment.keyword" | "block.minecraft.oak_hanging_sign" | "block.chipped.checkered_lapis_block_tiles" | "block.chipped.starry_red_terracotta" | "block.chipped.small_cyan_terracotta_tiles" | "fancymenu.editor.custombutton.config.actiontype.deletefile" | "block.chipped.runic_carved_raw_iron_block" | "gui.removed" | "item.aquamirae.tortured_soul_spawn_egg" | "options.graphics.warning.accept" | "subtitles.block.chorus_flower.grow" | "block.caveopolis.lime_colored_cobblestone_stairs" | "jm.minimap.info3_label.button" | "message.solcarrot.hearts.singular" | "block.chipped.circular_blue_stained_glass" | "painting.minecraft.creebet.title" | "block.chipped.cracked_flat_dirt_tiles" | "container.chestDouble" | "ftbquests.gui.no_dependants" | "block.alltheores.steel_block" | "block.chipped.crossed_blue_terracotta" | "block.chipped.layered_pink_terracotta" | "block.chipped.tiled_end_stone" | "block.caveopolis.lime_colored_cobblestone_brick_stairs" | "block.cozy_home.quartz_bench" | "block.chipped.screen_birch_door" | "item.minecraft.splash_potion.effect.weakness" | "block.chipped.arched_brown_stained_glass_pane_pillar" | "item.industrialforegoing.laser_lens_inverted" | "item.minecraft.ghast_tear" | "effect.obscure_api.rush.description" | "ftbquests.quest.appearance.min_width" | "block.chipped.stacked_mud_bricks_bricks" | "commands.worldborder.set.failed.big" | "gui.sophisticatedcore.settings.buttons.keep_tab_open.on" | "block.thermal.fire_tnt.desc" | "block.chipped.knitted_cyan_carpet" | "block.thermal.sulfur_block" | "block.chipped.crated_spruce_planks" | "block.chipped.minimized_black_glazed_terracotta" | "block.chipped.crafted_light_gray_wool" | "block.minecraft.lime_banner" | "jei.tooltip.bookmarks.usage.key" | "jm.fullscreen.hotkeys_east" | "message.supplementaries.safe.bound" | "block.thermal.frost_melon" | "block.chipped.wickered_purple_carpet" | "block.chipped.diamond_mangrove_planks" | "block.furniture_mod.fireplace_oak_middle_bottom" | "ftbquests.task.ftbquests.advancement.criterion" | "block.chipped.flat_raw_copper_block_tiles" | "block.industrialforegoing.sewage_composter" | "crop.mysticalagriculture.honey" | "block.mysticalagradditions.end_inferium_ore" | "pack.thermal_integration.description" | "item.simplehats.hatscraps_halloween" | "fancymenu.elements.audio.play_mode.shuffle" | "tag.item.chipped.brown_stained_glass" | "block.chipped.ornate_mossy_cobblestone_pillar" | "block.chipped.ribbled_gray_wool" | "block.chipped.polished_crying_obsidian" | "jm.common.renderstats_debug_surface_simple" | "jm.server.edit.chkbox.enable.tooltip" | "advancements.aquamirae.root.descr" | "block.chipped.smooth_inlayed_obsidian" | "mco.create.world.reset.title" | "block.thermal.lumium_rail" | "block.chipped.sad_prismarine" | "block.chipped.suspicious_jack_o_lantern" | "stat_type.minecraft.killed" | "item.ftbquests.lootcrate.missing" | "block.chipped.spiral_mud_bricks" | "block.minecraft.banner.diagonal_right.gray" | "arguments.nbtpath.too_large" | "block.ftbquests.chest" | "commands.curios.replace.success" | "leaves_type.minecraft.flowering_azalea" | "block.chipped.small_blue_stained_glass" | "block.caveopolis.magenta_colored_stone_stairs" | "block.chipped.vined_spruce_trapdoor" | "skyblockbuilder.screen.open_folder.error" | "block.caveopolis.green_colored_stone_wall" | "instrument.minecraft.admire_goat_horn" | "key.walkers" | "block.cozy_home.sofa_pink" | "slurry.alltheores.clean_silver" | "subtitles.entity.chicken.ambient" | "gui.sophisticatedbackpacks.upgrades.buttons.do_not_swap_weapon.detail" | "item.farmersdelight.cooked_cod_slice" | "commands.forceload.added.none" | "config.supplementaries.quiver.use_without_slow.description" | "item.minecraft.smithing_template.armor_trim.applies_to" | "block.chipped.ornate_white_redstone_lamp" | "key.saveToolbarActivator" | "fancymenu.ui.text_editor.paste" | "item.pirates.sailor_blue_tier_1_boots" | "ftbquests.task.ftbquests.stat" | "block.chipped.golden_barred_warped_trapdoor" | "tag.item.chipped.crimson_door" | "leaves_type.chipped.golden_jungle" | "block.minecraft.banner.square_bottom_left.pink" | "block.minecraft.warped_trapdoor" | "block.chipped.bordered_dirt" | "message.supplementaries.rope_arrow_tooltip" | "painting.cozy_home.light_beyond.title" | "block.chipped.brown_terracotta_tiles" | "wood_type.cozy_home.dark_oak" | "ftbquests.reward.ftbquests.command" | "block.thermal.hops_block" | "item.alltheores.lumium_gear" | "block.caveopolis.light_gray_colored_stone_crafting_table" | "death.attack.fall" | "fancymenu.editor.widgets" | "item.thermal.emerald_coin" | "block.chipped.gilded_blackstone_scales" | "block.chipped.cracked_disordered_coal_block_bricks" | "item.caveopolis.mixed_stone_fragment" | "block.minecraft.dragon_wall_head" | "patchouli.gui.lexicon.relations" | "fancymenu.customization.items.text.horizontal_scroll_grabber_texture.hover" | "effect.cofh_core.explosion_resistance" | "config.supplementaries.map_tweaks.min_search_radius.description" | "block.thermal.deepslate_lead_ore" | "block.chipped.cubed_light_blue_carpet" | "block.chipped.tiny_basalt_bricks" | "block.chipped.thick_inlayed_amethyst_block" | "text.industrialforegoing.book.biofuel_generator" | "block.chipped.sliding_spruce_door" | "ftbultimine.shape.mining_tunnel" | "block.chipped.rusted_cyan_concrete" | "subtitles.item.scroll.use" | "tooltip.titanium.facing_handler.tank" | "block.chipped.hazard_purple_concrete" | "jm.server.allow_in_game_beacons" | "tooltips.spray_can.shift.held" | "fml.modmismatchscreen.missingmods.client" | "block.chipped.packed_ice_mini_tiles" | "block.chipped.checkered_mangrove_trapdoor" | "block.chipped.orange_glazed_terracotta_tiles" | "block.chipped.rough_dirt" | "block.chipped.overgrown_warped_roots" | "block.chipped.swampy_hay_block" | "commands.execute.conditional.pass_count" | "item.alltheores.osmium_shard" | "block.alltheores.sapphire_ore" | "ftbquests.reward.exclude_from_claim_all" | "commands.cofh.invuln.remove.single" | "advancements.nether.find_fortress.description" | "block.chipped.stop_gray_concrete" | "block.chipped.brick_bordered_borderless_bricks" | "enchantment.supplementaries.stasis" | "block.nec.caveop_red_colored_wooden_chest" | "aquaculture.double_obsidian_hook.tooltip.title" | "block.chipped.decorated_red_glazed_terracotta" | "item.minecraft.birch_boat" | "ftbquests.task.click_to_submit_all" | "item.simplehats.dragonskull" | "subtitles.block.amethyst_block.resonate" | "block.igleelib.lavium_block" | "jm.server.edit.chkbox.world.id" | "item.minecraft.wooden_sword" | "jigsaw_block.generate" | "block.chipped.purple_concrete_tiles" | "gui.socialInteractions.search_empty" | "block.chipped.prismal_diorite_remnants" | "command.solcarrot.foodlist.size.desc.foods_eaten.plural" | "painting.minecraft.pigscene.author" | "commands.effect.give.success.multiple" | "entity.aquaculture.perch" | "block.chipped.hardened_soul_sand" | "block.cozy_home.lime_lamp" | "block.minecraft.black_concrete" | "ftbquests.chapter.image.hover" | "text.industrialforegoing.tooltip.infinitydrill.legendary" | "itemGroup.strainers" | "selectServer.title" | "fancymenu.element.anchor_point" | "block.chipped.cracked_flat_red_sandstone_tiles" | "block.chipped.cyan_terracotta_tiles" | "block.chipped.inscribed_purpur_block" | "block.thermal.ender_tnt.keyword" | "block.chipped.cornered_orange_carpet" | "block.chipped.tiny_layered_andesite_slabs" | "block.chipped.natural_cherry_planks" | "jm.common.automap_region_start" | "fancymenu.elements.element.stay_on_screen" | "icon.attack_speed.very_slow" | "item.mysticalagriculture.diamond_scythe" | "commands.bossbar.set.players.success.none" | "subtitles.powered_flashlight.item.flashlight.toggleoff" | "message.supplementaries.hourglass" | "block.chipped.layed_coal_block_bricks" | "skyblockbuilder.command.denied.add_players_to_team" | "tag.item.chipped.black_terracotta" | "block.chipped.small_smooth_stone_bricks" | "item.unbreakable" | "block.minecraft.tinted_glass" | "fancymenu.editor.custombutton.config.actiontype.opengui" | "jm.common.map_style_caveshowsurface.tooltip" | "block.chipped.fine_mud_pillar" | "block.chipped.loded_quartz_block" | "item.thermal.copper_gear" | "block.chipped.smooth_ringed_lapis_block" | "text.dankstorage.shift" | "block.chipped.chiseled_stripped_mangrove_log" | "demo.help.jump" | "parsing.double.expected" | "block.chipped.checkered_granite_tiles" | "block.chipped.stringed_light_blue_carpet" | "jm.waypoint.help_import_rei_title" | "commands.gamemode.success.self" | "block.chipped.light_gray_terracotta_tile" | "mco.configure.world.slot.tooltip.minigame" | "menu.sendFeedback" | "fancymenu.editor.anchor_overlay.invert_colors.desc" | "gui.abuseReport.reason.non_consensual_intimate_imagery.description" | "text.industrialforegoing.book.wither_builder" | "block.chipped.rusted_orange_concrete" | "block.chipped.ornate_white_stained_glass_pane" | "block.chipped.light_scaled_brown_mushroom_block" | "item.thermal_extra.soul_infused_gear" | "block.nec.caveop_cyan_colored_wooden_chest" | "block.minecraft.orange_glazed_terracotta" | "block.thermal.nickel_block" | "commands.worldborder.set.failed.far" | "fancymenu.overlay.menu_bar.tools.dirt_message_screen.desc" | "block.caveopolis.brown_colored_wooden_plank_trapdoor" | "item.storagedrawers.fill_level_upgrade" | "block.caveopolis.lime_colored_hanging_sign" | "biome.minecraft.plains" | "tip.inv_button" | "block.chipped.thick_inlayed_shroomlight" | "item.minecraft.honey_bottle" | "fancymenu.customization.items.input_field" | "gui.entity_tooltip.type" | "gui.sophisticatedcore.upgrades.advanced_feeding.tooltip" | "item.lfpirates.corsair_tier_1_boots" | "fancymenu.editor.dynamicvariabletextfield.variables.loadedmods.desc" | "text.dankstorage.sort_button" | "fancymenu.placeholders.min_number.desc" | "block.caveopolis.orange_colored_wood" | "block.chipped.stop_pink_concrete" | "fancymenu.background.animation.configure" | "enchantment.minecraft.bane_of_arthropods.desc" | "item.thermal.machine_null_augment.keyword" | "fancymenu.helper.editor.items.visibilityrequirements.multiplayer" | "item.storagedrawers.quantify_key" | "item.strainers.copper_mesh" | "block.thermal.device_fisher.keyword" | "jm.waypoint.temp_waypoint_remove_distance" | "material.mysticalagradditions.soulium" | "block.minecraft.bed.occupied" | "structure_block.hover.load" | "config.sawmill.general.allow_non_blocks.description" | "block.thermal.phyto_tnt.desc" | "farmersdelight.tooltip.cooking_pot.many_servings" | "block.chipped.prismal_stone_remnants" | "subtitles.block.bubble_column.whirlpool_inside" | "config.jei.search.tooltipSearchMode.comment" | "block.minecraft.banner.rhombus.cyan" | "block.cozy_home.large_mangrove_stump" | "gamerule.category.updates" | "block.chipped.double_herringbone_bamboo_planks" | "fancymenu.placeholders.fps" | "block.minecraft.yellow_stained_glass_pane" | "ftbquests.raymatcher.entity_id" | "attribute.modifier.equals.2" | "attribute.modifier.equals.1" | "attribute.modifier.equals.0" | "block.industrialforegoing.mycelial_netherstar" | "ftbquests.gui.clear_reward_all" | "block.chipped.heavy_crimson_trapdoor" | "fancymenu.editor.items.splash.bounce.on" | "block.chipped.elemental_pearlescent_froglight" | "block.chipped.stacked_diorite_bricks" | "argument.range.empty" | "block.chipped.stringed_white_wool" | "block.chipped.inlayed_stone" | "block.chipped.minimized_green_glazed_terracotta" | "block.chipped.i_sign_stripped_warped_stem" | "jm.colorpalette.biome_colors" | "config.supplementaries.quiver.render_mode.description" | "item.lfpirates.sailor_red_tier_1_boots" | "fancymenu.background.animation.configure.restart_on_load.on" | "message.supplementaries.compass" | "generator.single_biome_floating_islands" | "createWorld.customize.presets.share" | "item.pirates.fisherman_helmet" | "fancymenu.editor.custombutton.config.actiontype.join_last_world.desc" | "block.chipped.double_mud_bricks_bricks" | "gui.libraryferret.props.key_value" | "jm.common.map_style_button" | "item.minecraft.shield.yellow" | "commands.ftbquests.command.error.no_file" | "item.thermal.chiller_ingot_cast.keyword" | "block.chipped.hexagonical_light_blue_glazed_terracotta" | "block.minecraft.stripped_birch_wood" | "item.minecraft.firework_star.flicker" | "fancymenu.customization.items.slider.editor.set_label_prefix" | "block.thermal.cinnabar_ore" | "block.chipped.duh_obsidian" | "info.thermal.augment.type.Filter" | "subtitles.item.shears.shear" | "block.chipped.circular_brown_stained_glass_pane" | "structure_block.hover.save" | "block.chipped.stop_red_concrete" | "block.furniture_mod.jungle_chair_tucked" | "fml.menu.multiplayer.truncated" | "item.thermal.rf_coil_xfer_augment.keyword" | "block.chipped.crimson_torch" | "block.chipped.offset_bricks_bricks" | "block.chipped.scattered_cobweb" | "block.chipped.cracked_disordered_borderless_bricks_bricks" | "block.minecraft.jukebox" | "block.chipped.obsidian_bricks" | "subtitle.supplementaries.clock_tick" | "block.minecraft.lime_concrete_powder" | "block.chipped.paved_blue_glazed_terracotta" | "telemetry.property.platform.title" | "jm.advanced.loglevel.tooltip" | "tag.item.chipped.black_carpet" | "config.supplementaries.slingshot.block_outline_color.description" | "ftbteams.name_too_short" | "block.minecraft.banner.stripe_right.black" | "disconnect.kicked" | "item.simplehats.azumanga_hat" | "block.minecraft.banner.skull.green" | "info.thermal.device_soil_infuser.0" | "info.thermal.device_soil_infuser.1" | "block.supplementaries.flag_red" | "block.chipped.bricky_birch_planks" | "info.thermal.device_soil_infuser.2" | "block.chipped.waved_gray_glazed_terracotta" | "item.thermal_extra.twinite_plate" | "block.chipped.massive_coal_block_bricks" | "item.sophisticatedbackpacks.advanced_refill_upgrade" | "tooltips.strainers.tier_6_mesh" | "block.chipped.warted_jungle_trapdoor" | "fancymenu.helper.editor.items.copyid" | "config.supplementaries.map_tweaks.quill_vanilla_maps.description" | "book.mysticalagriculture.category.advances.description" | "demo.help.later" | "tooltip.industrialforegoing.bl.stack_unit" | "block.minecraft.exposed_copper" | "pack.thermal_expansion.description" | "crop.mysticalagriculture.pig_iron" | "block.chipped.triangular_red_terracotta" | "compliance.playtime.message" | "block.chipped.slanted_bamboo_planks" | "item.mysticalagriculture.imperium_fishing_rod" | "block.mysticalagriculture.soulstone_smooth" | "item.thermal.potion_infuser" | "jm.common.deletemap_title" | "effect.farmersdelight.nourishment" | "block.minecraft.dead_horn_coral_fan" | "mco.configure.world.subscription.days" | "block.minecraft.iron_trapdoor" | "block.chipped.polished_netherite_block" | "block.chipped.cross_laced_acacia_planks" | "config.craftingtweaks.title" | "arguments.item.overstacked" | "death.attack.fallingBlock" | "block.minecraft.banner.flower.magenta" | "libx.config.gui.resource_list.entry_type" | "block.chipped.red_terracotta_pillar" | "tag.item.chipped.mangrove_trapdoor" | "item.minecraft.firework_star" | "block.chipped.inlayed_ice" | "block.caveopolis.purple_colored_sapling" | "createWorld.customize.custom.mainNoiseScaleX" | "createWorld.customize.custom.mainNoiseScaleY" | "createWorld.customize.custom.mainNoiseScaleZ" | "gui.libraryferret.props.title_value" | "block.chipped.tiny_layered_snow_block_bricks" | "book.mysticalagriculture.entry.essence_vessel.page.1" | "block.farmersdelight.pink_canvas_sign" | "block.minecraft.banner.half_vertical.orange" | "block.chipped.tiny_brick_bordered_granite" | "commands.data.modify.invalid_index" | "block.minecraft.banner.square_bottom_left.black" | "block.minecraft.spruce_wall_hanging_sign" | "block.chipped.trodden_red_sandstone" | "block.minecraft.cornflower" | "block.chipped.scaled_green_wool" | "block.minecraft.bamboo_fence" | "debug.inspect.client.block" | "mco.activity.noactivity" | "jm.waypoint.new_title" | "entity.minecraft.villager.weaponsmith" | "item.simplehats.dorkglassesandteeth" | "menu.paused" | "item.thermal_extra.shellite_nugget" | "block.cozy_home.warped_sink_counter" | "item.thermal.glowstone_tnt_minecart" | "block.chipped.snow_block_pillar_top" | "item.systeams.boiler_pipe.desc" | "block.chipped.grid_black_concrete" | "commands.trigger.failed.unprimed" | "block.chipped.smooth_ringed_mossy_cobblestone" | "block.furniture_mod.counter_dark_oak_sink_water_1" | "block.chipped.spider_deepslate_carving" | "options.language" | "block.chipped.inscribed_green_terracotta" | "fancymenu.customization.items.text.markdown.code_block.multi.color" | "block.chipped.engraved_dripstone_block" | "block.chipped.stacked_basalt_bricks" | "block.chipped.unamused_ancient_debris" | "fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.player" | "block.chipped.watching_lodestone" | "block.furniture_mod.counter_dark_oak_sink_water_3" | "block.furniture_mod.counter_dark_oak_sink_water_2" | "block.caveopolis.cobblestone_brick_wall" | "gui.supplementaries.amendments.message" | "gui.download" | "item.storagedrawers.min_redstone_upgrade.desc" | "obscure_api.tooltip.expand" | "block.supplementaries.ash_bricks" | "item.simplehats.hatbag_uncommon" | "block.minecraft.infested_stone_bricks" | "jm.server.edit.option.none" | "item.oceansdelight.fugu_slice" | "book.mysticalagriculture.entry.essence_furnaces" | "block.chipped.diamond_oak_planks" | "subtitle.supplementaries.music.pancake" | "block.minecraft.magenta_wool" | "tag.item.chipped.crimson_trapdoor" | "container.sawmill.sawmill" | "subtitles.entity.goat.hurt" | "block.chipped.barred_bamboo_trapdoor" | "fancymenu.custom_guis.build.identifier.invalid" | "item.thermal.side_config_augment.desc" | "entity.aquaculture.bayad" | "fml.menu.mods.info.trust" | "block.chipped.creeper_sandstone_carving" | "itemGroup.roomopolis" | "jm.minimap.mob_display" | "createWorld.customize.custom.depthNoiseScaleExponent" | "block.chipped.sanded_raw_copper_block" | "block.caveopolis.magenta_colored_cobblestone_brick_slab" | "block.chipped.curly_amethyst_block_pillar" | "item.geckolib.mutant_zombie_spawn_egg" | "item.aquaculture.minnow" | "block.minecraft.waxed_cut_copper" | "fluid_type.thermal.biocrude" | "jm.options.multiplayer.button_label" | "painting.minecraft.alban.title" | "block.caveopolis.light_blue_colored_stone_brick_slab" | "fancymenu.editor.custombutton.config.actiontype.runcmd" | "mco.upload.failed" | "jm.server.see_underground_players" | "options.framerateLimit" | "block.chipped.acacia_planks_mosaic" | "trim_material.minecraft.amethyst" | "narrator.button.difficulty_lock.unlocked" | "item.sophisticatedbackpacks.everlasting_upgrade.tooltip" | "block.chipped.tiled_lapis_block_column" | "commands.datapack.list.available.none" | "info.thermal.redprint.data.Xfer" | "block.chipped.green_paper_lantern" | "block.chipped.inscribed_yellow_terracotta" | "jm.minimap.mob_display_scale.tooltip" | "block.minecraft.brown_concrete" | "tag.item.chipped.oak_door" | "block.minecraft.potted_bamboo" | "fancymenu.helper.editor.items.visibilityrequirements.realtimeminute" | "block.chipped.curly_mossy_cobblestone_pillar" | "tooltip.mysticalagriculture.invalid_biome" | "block.cozy_home.mangrove_grandfather_clock" | "block.chipped.tiled_dark_prismarine" | "config.supplementaries.jar.drink_from_jar.description" | "block.chipped.loded_nether_bricks" | "block.caveopolis.white_colored_stone_stairs" | "patchouli.gui.lexicon.not_anchored" | "block.chipped.eroded_packed_ice" | "container.dankstorage.dank_4" | "item.minecraft.shelter_pottery_sherd" | "container.dankstorage.dank_3" | "resourcePack.server.name" | "container.dankstorage.dank_6" | "container.dankstorage.dank_5" | "block.chipped.angry_cobblestone" | "container.dankstorage.dank_7" | "libx.config.gui.component.underlined" | "container.dankstorage.dank_2" | "container.dankstorage.dank_1" | "block.chipped.woven_white_stained_glass_pane" | "entity.minecraft.warden" | "mco.selectServer.mapOnlySupportedForVersion" | "block.chipped.flat_lapis_block_tiles" | "block.minecraft.deepslate_tiles" | "block.chipped.vertical_disordered_deepslate_bricks" | "text.industrialforegoing.plant.sugar_cane" | "leaves_type.chipped.golden_dark_oak" | "block.chipped.bordered_bricks" | "fluid_type.thermal_extra.icy_water" | "biome.minecraft.snowy_slopes" | "item.supplementaries.slingshot" | "selectWorld.import_worldgen_settings" | "block.chipped.spiraled_lodestone" | "mco.terms.title" | "block.chipped.blocky_purple_carpet" | "block.chipped.glass_dark_oak_door" | "slurry.alltheores.dirty_platinum" | "info.thermal.xp_crystal.use.sneak" | "item.alltheores.nickel_dust" | "fancymenu.editor.loading_requirement.screens.manage_screen.requirements_and_groups" | "item.minecraft.heartbreak_pottery_shard" | "block.alltheores.copper_ore" | "item.lfpirates.sailor_red_tier_1_leggings" | "block.chipped.etched_redstone_block_bricks" | "block.chipped.unamused_granite" | "block.chipped.woven_light_gray_stained_glass_pane" | "config.sawmill.general.limit_planks_input_to_one.description" | "item.farmersdelight.fruit_salad" | "key.curios.open.desc" | "block.chipped.clay_bricks" | "block.chipped.hexagonical_yellow_glazed_terracotta" | "subtitles.block.beehive.exit" | "block.ftbquests.screen.fullscreen" | "block.chipped.crimson_roots_bud" | "subtitles.block.chest.open" | "block.nec.crimson_chest" | "block.caveopolis.stripped_white_colored_wood" | "info.thermal.charge_bench.0" | "info.thermal.charge_bench.1" | "text.industrialforegoing.book.mob_slaughter_factory" | "options.credits_and_attribution" | "block.chipped.cracked_flat_snow_block_tiles" | "block.chipped.dark_broken_lily_pad" | "block.chipped.simple_bricks_pillar" | "block.chipped.slanted_crimson_planks" | "block.chipped.creeper_lime_concrete" | "block.chipped.barky_red_wool" | "block.chipped.stacked_blue_concrete" | "block.minecraft.banner.circle.light_blue" | "item.minecraft.bundle" | "block.alltheores.lead_ore" | "fancymenu.helper.placeholder.elementposx" | "fancymenu.helper.placeholder.elementposy" | "info.thermal.charge_bench.2" | "tag.item.chipped.dripstone_block" | "fancymenu.editor.loading_requirement.category.world" | "block.minecraft.magenta_glazed_terracotta" | "subtitles.entity.puffer_fish.hurt" | "farmersdelight.advancement.hit_raider_with_rotten_tomato.desc" | "block.cozy_home.quartz_mirror_stand" | "block.chipped.hexagonical_red_glazed_terracotta" | "dankstorage.mode.none" | "block.minecraft.moving_piston" | "material.mysticalagradditions.tertium" | "tooltip.craftingtweaks.rotate" | "ftbquests.raymatcher.block_entity_id" | "block.chipped.prismarine_scales" | "block.caveopolis.cyan_colored_stone_wall" | "__comment" | "block.minecraft.smooth_sandstone_stairs" | "block.chipped.tiled_bordered_red_sandstone" | "block.chipped.fine_purpur_block_pillar" | "gui.libraryferret.config_welcome" | "jm.theme.labelsource.moonphase.waning_gibbous" | "block.caveopolis.gray_colored_sign" | "stat.minecraft.open_barrel" | "debug.creative_spectator.error" | "mco.brokenworld.nonowner.title" | "item.supplementaries.dispenser_minecart" | "block.furniture_mod.counter_jungle_sink_water_1" | "block.chipped.polished_mud" | "tooltip.titanium.facing_handler.inputsecond" | "block.furniture_mod.counter_jungle_sink_water_2" | "block.chipped.sad_borderless_bricks" | "block.furniture_mod.counter_jungle_sink_water_3" | "block.minecraft.banner.half_vertical.gray" | "gui.socialInteractions.search_hint" | "block.chipped.unamused_amethyst_block" | "biome.minecraft.basalt_deltas" | "book.mysticalagriculture.entry.witherproof_blocks.page.1" | "block.chipped.tiny_brick_bordered_bricks" | "block.chipped.edge_cut_warped_stem" | "item.aquaculture.brown_trout" | "block.chipped.beach_mangrove_door" | "block.ftbquests.screen.input_only" | "tooltip.titanium.facing_handler.explosive.input_0" | "block.minecraft.pink_glazed_terracotta" | "subtitles.entity.hoglin.retreat" | "block.chipped.rough_nether_bricks" | "hover_effects.ender_scrambler.range" | "block.chipped.tiny_layered_blue_ice_bricks" | "fancymenu.elements.text.v2.interactable" | "block.alltheores.nether_lead_ore" | "book.mysticalagriculture.entry.weakness_resistance_augment" | "gui.sophisticatedbackpacks.upgrades.deposit" | "block.chipped.overlapping_tuff_tiles" | "block.chipped.scaled_red_carpet" | "tag.item.chipped.acacia_log" | "augment.mysticalagriculture.wither_resistance.description" | "fancymenu.editor.close_audio.desc" | "book.mysticalagriculture.entry.witherproof_blocks" | "item.storagedrawers.one_stack_upgrade" | "fluid.supplementaries.sap" | "item.minecraft.potion.effect.slowness" | "block.minecraft.mossy_stone_brick_slab" | "block.chipped.sandstone_mini_tiles" | "biome.minecraft.stony_peaks" | "tag.item.chipped.mossy_cobblestone" | "block.chipped.prismarine_mini_tiles" | "subtitles.entity.slime.death" | "title.crafting_station" | "subtitles.entity.firework_rocket.blast" | "block.chipped.rounded_amethyst_block_bricks" | "tooltip.industrialforegoing.mob_crusher.consume" | "block.chipped.barred_mangrove_door" | "tag.item.chipped.purple_carpet" | "block.industrialforegoing.lava_fabricator" | "mco.selectServer.expired" | "block.chipped.grid_light_gray_concrete" | "block.chipped.chiseled_gray_terracotta" | "block.minecraft.enchanting_table" | "jei.category.mysticalagriculture.enchanter" | "narrator.button.language" | "item.supplementaries.cozy_home.sign_post_warped" | "itemfilters.help_text.nbt" | "block.chipped.cornered_oak_planks" | "painting.minecraft.plant.title" | "block.chipped.cobbled_tuff" | "item.thermal.lapis_plate" | "subtitles.entity.villager.death" | "fancymenu.helper.editor.items.visibilityrequirements.is_button_active" | "block.chipped.inlayed_magma_block" | "item.aquamirae.abyssal_leggings" | "stat.minecraft.interact_with_smithing_table" | "block.chipped.ornate_coal_block_pillar" | "item.aquaculture.pollock_bucket" | "item.lfpirates.corsair_tier_3_boots" | "jm.common.renderdelay.tooltip" | "key.mouse" | "block.minecraft.banner.triangles_bottom.blue" | "fancymenu.helper.placeholder.calc" | "block.chipped.wickered_green_wool" | "block.minecraft.banner.border.pink" | "mco.configure.world.restore.question.line2" | "mco.configure.world.restore.question.line1" | "disconnect.genericReason" | "block.chipped.tiled_black_wool" | "block.minecraft.bamboo_mosaic_stairs" | "biome.minecraft.flower_forest" | "block.supplementaries.bamboo_spikes" | "block.chipped.crossed_yellow_terracotta" | "block.chipped.creeper_magma_block_carving" | "item.thermal.ruby_dust" | "menu.playdemo" | "block.chipped.patched_brown_carpet" | "block.minecraft.stone_pressure_plate" | "block.furniture_mod.drawer_warped_left" | "item.aquaculture.wooden_fillet_knife" | "block.chipped.distorted_acacia_trapdoor" | "fancymenu.resources.pre_loading.desc" | "block.chipped.circle_oak_glass_pane" | "item.minecraft.splash_potion.effect.clarity" | "crop.mysticalagradditions.awakened_draconium" | "argument.entity.options.distance.negative" | "block.chipped.tiled_ancient_debris_column" | "subtitles.entity.skeleton_horse.death" | "commands.ftbquests.change_consumable.text" | "block.mysticalagriculture.imperium_furnace" | "item.thermal.beekeeper_helmet" | "jm.server.edit.chkbox.world.id.tooltip" | "ftbquests.reward.ftbquests.npc_mail" | "block.minecraft.spruce_wall_sign" | "block.chipped.bundled_cherry_log" | "block.chipped.overlapping_mud_bricks_tiles" | "block.minecraft.banner.gradient_up.red" | "subtitles.entity.zombie_horse.hurt" | "text.industrialforegoing.display.burning" | "ftbteams.message.promoted" | "item.minecraft.splash_potion.effect.slowness" | "block.chipped.small_black_stained_glass_pane" | "item.lfpirates.pirate_tier_2_leggings" | "gui.sophisticatedcore.upgrades.feeding.tooltip" | "item.minecraft.music_disc_mall.desc" | "item.minecraft.shield.blue" | "death.attack.player" | "mco.worldSlot.minigame" | "tooltip.titanium.facing_handler.inputfirst" | "block.chipped.tiny_layered_andesite_bricks" | "ability.aquamirae.poisoned_chakra" | "block.minecraft.andesite_wall" | "block.chipped.wise_stripped_mangrove_log" | "leaves_type.chipped.magenta_flower_birch" | "info.cofh.single_block" | "block.chipped.classic_windowed_oak_trapdoor" | "block.chipped.smooth_inlayed_magma_block" | "book.mysticalagriculture.entry.elemental_essences" | "block.chipped.curly_borderless_bricks_pillar" | "block.thermal.eggplant_block" | "block.chipped.wickered_pink_wool" | "advancements.story.follow_ender_eye.description" | "block.minecraft.birch_trapdoor" | "fancymenu.layout.manage.layouts.sort_by" | "gamerule.logAdminCommands" | "book.mystical