/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.impl.client;

import net.darkhax.bookshelf.api.util.RenderHelper;
import net.darkhax.tipsmod.api.TipsAPI;
import net.darkhax.tipsmod.api.resources.ITip;
import net.darkhax.tipsmod.impl.Constants;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class TipRenderHandler {
    private static long initTime = System.currentTimeMillis();
    private static ITip tip;

    private static void setTip(ITip newTip) {
        tip = newTip;
        initTime = System.currentTimeMillis();
    }

    public static void drawTip(GuiGraphics graphics, Screen parentScreen) {
        if (tip == null) {
            TipRenderHandler.setTip(TipsAPI.getRandomTip());
        }
        if (TipsAPI.canRenderOnScreen(parentScreen)) {
            int currentCycleTime;
            long currentTime = System.currentTimeMillis();
            if (currentTime - initTime > (long)(currentCycleTime = tip.getCycleTime())) {
                TipRenderHandler.setTip(TipsAPI.getRandomTip());
                if (tip != null) {
                    Constants.LOG.debug("Displaying tip {} on screen {}.", (Object)tip.getId(), (Object)parentScreen.getClass().getSimpleName());
                }
            }
            if (tip != null) {
                int textWidth = Mth.m_14143_((float)((float)parentScreen.f_96543_ * 0.35f));
                int height = parentScreen.f_96544_ - 10;
                height -= RenderHelper.renderLinesReversed((GuiGraphics)graphics, (int)10, (int)height, (FormattedText)tip.getText(), (int)textWidth);
                RenderHelper.renderLinesReversed((GuiGraphics)graphics, (int)10, (int)(height -= 3), (FormattedText)tip.getTitle(), (int)textWidth);
            }
        }
    }
}

