/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.world.gen.structure;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mod.gottsch.forge.gottschcore.GottschCore;
import mod.gottsch.forge.gottschcore.spatial.Coords;
import mod.gottsch.forge.gottschcore.spatial.ICoords;
import mod.gottsch.forge.gottschcore.world.gen.structure.BlockInfoContext;
import mod.gottsch.forge.gottschcore.world.gen.structure.DecayBlockInfo;
import mod.gottsch.forge.gottschcore.world.gen.structure.IDecayProcessor;
import mod.gottsch.forge.gottschcore.world.gen.structure.PlacementSettings;
import mod.gottsch.forge.gottschcore.world.gen.structure.StructureProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class GottschTemplate
extends StructureTemplate {
    private final List<Palette> palettes = Lists.newArrayList();
    private final List<EntityInfo> entities = Lists.newArrayList();
    private BlockPos size = BlockPos.f_121853_;
    private String author = "?";
    private final Multimap<Block, BlockInfoContext> tagBlockMap = ArrayListMultimap.create();
    public static final List<String> deferredBlocks = Lists.newArrayList();

    public BlockPos getSize() {
        return this.size;
    }

    public BlockPos getSize(Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> new BlockPos(this.size.m_123343_(), this.size.m_123342_(), this.size.m_123341_());
            default -> this.size;
        };
    }

    public void m_74612_(String authorIn) {
        this.author = authorIn;
    }

    public String m_74627_() {
        return this.author;
    }

    private static void addToLists(BlockInfo blockInfo, List<BlockInfo> blockInfos, List<BlockInfo> p_237149_2_, List<BlockInfo> p_237149_3_) {
        if (blockInfo.nbt != null) {
            p_237149_2_.add(blockInfo);
        } else if (!blockInfo.state.m_60734_().m_49967_() && blockInfo.state.m_60838_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_)) {
            blockInfos.add(blockInfo);
        } else {
            p_237149_3_.add(blockInfo);
        }
    }

    private static List<BlockInfo> m_74614_(List<BlockInfo> p_237151_0_, List<BlockInfo> p_237151_1_, List<BlockInfo> p_237151_2_) {
        Comparator<BlockInfo> comparator = Comparator.comparingInt(p_237154_0_ -> p_237154_0_.pos.m_123342_()).thenComparingInt(p_237153_0_ -> p_237153_0_.pos.m_123341_()).thenComparingInt(p_237148_0_ -> p_237148_0_.pos.m_123343_());
        p_237151_0_.sort(comparator);
        p_237151_2_.sort(comparator);
        p_237151_1_.sort(comparator);
        ArrayList list = Lists.newArrayList();
        list.addAll(p_237151_0_);
        list.addAll(p_237151_2_);
        list.addAll(p_237151_1_);
        return list;
    }

    public List<BlockInfo> filterBlocks(BlockPos pos, PlacementSettings placement, Block block) {
        return this.filterBlocks(pos, placement, block, true);
    }

    public List<BlockInfo> filterBlocks(BlockPos pos, PlacementSettings placement, Block block, boolean rotate) {
        ArrayList list = Lists.newArrayList();
        BoundingBox mutableboundingbox = placement.getBoundingBox();
        if (this.palettes.isEmpty()) {
            return Collections.emptyList();
        }
        for (BlockInfo GottschTemplateNew$blockinfo : placement.getRandomPalette(this.palettes, pos).blocks(block)) {
            BlockPos blockpos;
            BlockPos blockPos = blockpos = rotate ? GottschTemplate.calculateRelativePosition(placement, GottschTemplateNew$blockinfo.pos).m_121955_((Vec3i)pos) : GottschTemplateNew$blockinfo.pos;
            if (mutableboundingbox != null && !mutableboundingbox.m_71051_((Vec3i)blockpos)) continue;
            list.add(new BlockInfo(blockpos, GottschTemplateNew$blockinfo.state.m_60717_(placement.getRotation()), GottschTemplateNew$blockinfo.nbt));
        }
        return list;
    }

    public static BlockPos calculateRelativePosition(PlacementSettings placement, BlockPos p_186266_1_) {
        return GottschTemplate.m_74593_((BlockPos)p_186266_1_, (Mirror)placement.getMirror(), (Rotation)placement.getRotation(), (BlockPos)placement.getRotationPivot());
    }

    public static Vec3 transformedVec3d(PlacementSettings placementIn, Vec3 pos) {
        return GottschTemplate.m_74578_((Vec3)pos, (Mirror)placementIn.getMirror(), (Rotation)placementIn.getRotation(), (BlockPos)placementIn.getRotationPivot());
    }

    public boolean placeInWorld(ServerLevelAccessor world, BlockPos pos, BlockPos pos2, PlacementSettings placement, Block NULL_BLOCK, Map<BlockState, BlockState> replacementBlocks, RandomSource random, int flags) {
        if (this.palettes.isEmpty()) {
            return false;
        }
        List<BlockInfo> blockInfoList = placement.getRandomPalette(this.palettes, pos).blocks();
        if (!(blockInfoList.isEmpty() && (placement.isIgnoreEntities() || this.entities.isEmpty()) || this.size.m_123341_() < 1 || this.size.m_123342_() < 1 || this.size.m_123343_() < 1)) {
            BoundingBox boundingBox = placement.getBoundingBox();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(placement.shouldKeepLiquids() ? blockInfoList.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)blockInfoList.size());
            int i = Integer.MAX_VALUE;
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MIN_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            ArrayList<BlockInfoContext> blockInfoContexts = new ArrayList<BlockInfoContext>();
            for (BlockInfo blockInfo : GottschTemplate.processBlockInfos((LevelAccessor)world, pos, pos2, placement, blockInfoList)) {
                BlockEntity tileentity1;
                BlockPos blockPos = blockInfo.pos;
                Block processedBlock = blockInfo.state.m_60734_();
                if (this.tagBlockMap.containsKey((Object)processedBlock)) {
                    processedBlock = NULL_BLOCK;
                }
                if (boundingBox != null && !boundingBox.m_71051_((Vec3i)pos) || processedBlock == NULL_BLOCK) continue;
                FluidState fluidstate = placement.shouldKeepLiquids() ? world.m_6425_(blockPos) : null;
                BlockState processedBlockState = blockInfo.state.m_60715_(placement.getMirror()).m_60717_(placement.getRotation());
                if (replacementBlocks != null && replacementBlocks.containsKey(processedBlockState)) {
                    processedBlockState = replacementBlocks.get(processedBlockState);
                }
                if (blockInfo.nbt != null) {
                    BlockEntity tileentity = world.m_7702_(blockPos);
                    Clearable.m_18908_((Object)tileentity);
                    world.m_7731_(blockPos, Blocks.f_50375_.m_49966_(), 20);
                }
                BlockInfoContext blockInfoContext = new BlockInfoContext(blockInfo, new Coords(pos), processedBlockState);
                if (deferredBlocks.contains(processedBlockState.m_60734_().getClass().getSimpleName())) {
                    blockInfoContexts.add(blockInfoContext);
                }
                if (!world.m_7731_(blockPos, processedBlockState, flags)) continue;
                i = Math.min(i, blockPos.m_123341_());
                j = Math.min(j, blockPos.m_123342_());
                k = Math.min(k, blockPos.m_123343_());
                l = Math.max(l, blockPos.m_123341_());
                i1 = Math.max(i1, blockPos.m_123342_());
                j1 = Math.max(j1, blockPos.m_123343_());
                list2.add(Pair.of((Object)blockPos, (Object)blockInfo.nbt));
                if (blockInfo.nbt != null && (tileentity1 = world.m_7702_(blockPos)) != null) {
                    blockInfo.nbt.m_128405_("x", blockPos.m_123341_());
                    blockInfo.nbt.m_128405_("y", blockPos.m_123342_());
                    blockInfo.nbt.m_128405_("z", blockPos.m_123343_());
                    if (tileentity1 instanceof RandomizableContainerBlockEntity) {
                        blockInfo.nbt.m_128356_("LootTableSeed", random.m_188505_());
                    }
                    tileentity1.m_142466_(blockInfo.nbt);
                }
                if (fluidstate == null || !(processedBlockState.m_60734_() instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)processedBlockState.m_60734_()).m_7361_((LevelAccessor)world, blockPos, processedBlockState, fluidstate);
                if (fluidstate.m_76170_()) continue;
                list1.add(blockPos);
            }
            boolean flag = true;
            Direction[] adirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate2;
                    Block block;
                    BlockPos blockpos2;
                    BlockPos blockpos3 = blockpos2 = (BlockPos)iterator.next();
                    FluidState fluidstate2 = world.m_6425_(blockpos2);
                    for (int k1 = 0; k1 < adirection.length && !fluidstate2.m_76170_(); ++k1) {
                        BlockPos blockpos1 = blockpos3.m_121945_(adirection[k1]);
                        FluidState fluidstate1 = world.m_6425_(blockpos1);
                        if (!(fluidstate1.m_76155_((BlockGetter)world, blockpos1) > fluidstate2.m_76155_((BlockGetter)world, blockpos3)) && (!fluidstate1.m_76170_() || fluidstate2.m_76170_())) continue;
                        fluidstate2 = fluidstate1;
                        blockpos3 = blockpos1;
                    }
                    if (!fluidstate2.m_76170_() || !((block = (blockstate2 = world.m_8055_(blockpos2)).m_60734_()) instanceof LiquidBlockContainer)) continue;
                    ((LiquidBlockContainer)block).m_7361_((LevelAccessor)world, blockpos2, blockstate2, fluidstate2);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i <= l) {
                if (!placement.getKnownShape()) {
                    BitSetDiscreteVoxelShape voxelshapepart = new BitSetDiscreteVoxelShape(l - i + 1, i1 - j + 1, j1 - k + 1);
                    int l1 = i;
                    int i2 = j;
                    int j2 = k;
                    for (Pair pair1 : list2) {
                        BlockPos blockpos5 = (BlockPos)pair1.getFirst();
                        voxelshapepart.m_142703_(blockpos5.m_123341_() - l1, blockpos5.m_123342_() - i2, blockpos5.m_123343_() - j2);
                    }
                    GottschTemplate.m_74510_((LevelAccessor)world, (int)flags, (DiscreteVoxelShape)voxelshapepart, (int)l1, (int)i2, (int)j2);
                }
                for (Pair pair : list2) {
                    BlockEntity tileentity2;
                    BlockPos blockpos4 = (BlockPos)pair.getFirst();
                    if (!placement.getKnownShape()) {
                        BlockState blockstate3;
                        BlockState blockstate1 = world.m_8055_(blockpos4);
                        if (blockstate1 != (blockstate3 = Block.m_49931_((BlockState)blockstate1, (LevelAccessor)world, (BlockPos)blockpos4))) {
                            world.m_7731_(blockpos4, blockstate3, flags & 0xFFFFFFFE | 0x10);
                        }
                        world.m_6289_(blockpos4, blockstate3.m_60734_());
                    }
                    if (pair.getSecond() == null || (tileentity2 = world.m_7702_(blockpos4)) == null) continue;
                    tileentity2.m_6596_();
                }
            }
            if (!placement.isIgnoreEntities()) {
                this.addEntitiesToWorld(world, pos, placement);
            }
            return true;
        }
        return false;
    }

    public boolean placeInWorld(ServerLevel world, BlockPos blockPos, BlockPos pos2, PlacementSettings placement, IDecayProcessor decayProcessor, Block NULL_BLOCK, Map<BlockState, BlockState> replacementBlocks, Random random, int flags) {
        if (this.palettes.isEmpty()) {
            return false;
        }
        List<BlockInfo> blockInfoList = placement.getRandomPalette(this.palettes, blockPos).blocks();
        if (!(blockInfoList.isEmpty() && (placement.isIgnoreEntities() || this.entities.isEmpty()) || this.size.m_123341_() < 1 || this.size.m_123342_() < 1 || this.size.m_123343_() < 1)) {
            BoundingBox boundingBox = placement.getBoundingBox();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(placement.shouldKeepLiquids() ? blockInfoList.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)blockInfoList.size());
            int i = Integer.MAX_VALUE;
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MIN_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            ArrayList blockInfoContexts = new ArrayList();
            for (BlockInfo blockInfo : GottschTemplate.processBlockInfos((LevelAccessor)world, blockPos, pos2, placement, blockInfoList)) {
                BlockPos blockpos = blockInfo.pos;
                Block processedBlock = blockInfo.state.m_60734_();
                if (this.tagBlockMap.containsKey((Object)processedBlock)) {
                    processedBlock = NULL_BLOCK;
                }
                if (boundingBox != null && !boundingBox.m_71051_((Vec3i)blockPos) || processedBlock == NULL_BLOCK) continue;
                BlockState processedBlockState = blockInfo.state.m_60715_(placement.getMirror()).m_60717_(placement.getRotation());
                if (replacementBlocks != null && replacementBlocks.containsKey(processedBlockState)) {
                    processedBlockState = replacementBlocks.get(processedBlockState);
                }
                decayProcessor.add(new Coords(blockPos), blockInfo, processedBlockState);
            }
            Coords transformedSize = new Coords(this.getSize(placement.getRotation()));
            GottschCore.LOGGER.debug("transformed size -> {}", (Object)transformedSize.toShortString());
            List<DecayBlockInfo> decayBlockInfoList = decayProcessor.process((Level)world, new Random(), transformedSize, NULL_BLOCK);
            GottschCore.LOGGER.debug("decayBlockInfoList.size={}", (Object)decayBlockInfoList.size());
            for (DecayBlockInfo decay : decayBlockInfoList) {
                BlockEntity tileentity1;
                FluidState fluidstate;
                if (decay.getState().m_60734_() == NULL_BLOCK) continue;
                BlockInfo processed = decay.getBlockInfo();
                BlockPos decayPos = decay.getCoords().toPos();
                if (processed.nbt != null) {
                    BlockEntity tileentity = world.m_7702_(decayPos);
                    Clearable.m_18908_((Object)tileentity);
                    world.m_7731_(decayPos, Blocks.f_50375_.m_49966_(), 20);
                }
                FluidState fluidState = fluidstate = placement.shouldKeepLiquids() ? world.m_6425_(decayPos) : null;
                if (!world.m_7731_(decayPos, decay.getState(), flags)) continue;
                i = Math.min(i, decayPos.m_123341_());
                j = Math.min(j, decayPos.m_123342_());
                k = Math.min(k, decayPos.m_123343_());
                l = Math.max(l, decayPos.m_123341_());
                i1 = Math.max(i1, decayPos.m_123342_());
                j1 = Math.max(j1, decayPos.m_123343_());
                list2.add(Pair.of((Object)decayPos, (Object)processed.nbt));
                if (processed.nbt != null && (tileentity1 = world.m_7702_(decayPos)) != null) {
                    processed.nbt.m_128405_("x", decayPos.m_123341_());
                    processed.nbt.m_128405_("y", decayPos.m_123342_());
                    processed.nbt.m_128405_("z", decayPos.m_123343_());
                    if (tileentity1 instanceof RandomizableContainerBlockEntity) {
                        processed.nbt.m_128356_("LootTableSeed", random.nextLong());
                    }
                    tileentity1.m_142466_(processed.nbt);
                }
                if (fluidstate == null || !(decay.getState().m_60734_() instanceof LiquidBlockContainer)) continue;
                ((LiquidBlockContainer)decay.getState().m_60734_()).m_7361_((LevelAccessor)world, decayPos, decay.getState(), fluidstate);
                if (fluidstate.m_76170_()) continue;
                list1.add(decayPos);
            }
            boolean flag = true;
            Direction[] adirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate2;
                    Block block;
                    BlockPos blockpos2;
                    BlockPos blockpos3 = blockpos2 = (BlockPos)iterator.next();
                    FluidState fluidstate2 = world.m_6425_(blockpos2);
                    for (int k1 = 0; k1 < adirection.length && !fluidstate2.m_76170_(); ++k1) {
                        BlockPos blockpos1 = blockpos3.m_121945_(adirection[k1]);
                        FluidState fluidstate1 = world.m_6425_(blockpos1);
                        if (!(fluidstate1.m_76155_((BlockGetter)world, blockpos1) > fluidstate2.m_76155_((BlockGetter)world, blockpos3)) && (!fluidstate1.m_76170_() || fluidstate2.m_76170_())) continue;
                        fluidstate2 = fluidstate1;
                        blockpos3 = blockpos1;
                    }
                    if (!fluidstate2.m_76170_() || !((block = (blockstate2 = world.m_8055_(blockpos2)).m_60734_()) instanceof LiquidBlockContainer)) continue;
                    ((LiquidBlockContainer)block).m_7361_((LevelAccessor)world, blockpos2, blockstate2, fluidstate2);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i <= l) {
                if (!placement.getKnownShape()) {
                    BitSetDiscreteVoxelShape voxelshapepart = new BitSetDiscreteVoxelShape(l - i + 1, i1 - j + 1, j1 - k + 1);
                    int l1 = i;
                    int i2 = j;
                    int j2 = k;
                    for (Pair pair1 : list2) {
                        BlockPos blockpos5 = (BlockPos)pair1.getFirst();
                        voxelshapepart.m_142703_(blockpos5.m_123341_() - l1, blockpos5.m_123342_() - i2, blockpos5.m_123343_() - j2);
                    }
                    GottschTemplate.m_74510_((LevelAccessor)world, (int)flags, (DiscreteVoxelShape)voxelshapepart, (int)l1, (int)i2, (int)j2);
                }
                for (Pair pair : list2) {
                    BlockEntity tileentity2;
                    BlockPos blockpos4 = (BlockPos)pair.getFirst();
                    if (!placement.getKnownShape()) {
                        BlockState blockstate3;
                        BlockState blockstate1 = world.m_8055_(blockpos4);
                        if (blockstate1 != (blockstate3 = Block.m_49931_((BlockState)blockstate1, (LevelAccessor)world, (BlockPos)blockpos4))) {
                            world.m_7731_(blockpos4, blockstate3, flags & 0xFFFFFFFE | 0x10);
                        }
                        world.m_6289_(blockpos4, blockstate3.m_60734_());
                    }
                    if (pair.getSecond() == null || (tileentity2 = world.m_7702_(blockpos4)) == null) continue;
                    tileentity2.m_6596_();
                }
            }
            if (!placement.isIgnoreEntities()) {
                this.addEntitiesToWorld((ServerLevelAccessor)world, blockPos, placement);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static List<StructureTemplate.StructureBlockInfo> processBlockInfos(LevelAccessor p_74518_, BlockPos p_74519_, BlockPos p_74520_, StructurePlaceSettings p_74521_, List<StructureTemplate.StructureBlockInfo> p_74522_) {
        return GottschTemplate.processBlockInfos(p_74518_, p_74519_, p_74520_, p_74521_, p_74522_);
    }

    public static List<BlockInfo> processBlockInfos(LevelAccessor world, BlockPos pos, BlockPos pos2, PlacementSettings placement, List<BlockInfo> blockInfos) {
        ArrayList list = Lists.newArrayList();
        for (BlockInfo GottschTemplateNew$blockinfo : blockInfos) {
            BlockPos blockpos = GottschTemplate.calculateRelativePosition(placement, GottschTemplateNew$blockinfo.pos).m_121955_((Vec3i)pos);
            BlockInfo GottschTemplateNew$blockinfo1 = new BlockInfo(blockpos, GottschTemplateNew$blockinfo.state, GottschTemplateNew$blockinfo.nbt != null ? GottschTemplateNew$blockinfo.nbt.m_6426_() : null);
            Iterator<StructureProcessor> iterator = placement.getProcessors().iterator();
            while (GottschTemplateNew$blockinfo1 != null && iterator.hasNext()) {
                GottschTemplateNew$blockinfo1 = iterator.next().process(world, pos, GottschTemplateNew$blockinfo, GottschTemplateNew$blockinfo1, placement);
            }
            if (GottschTemplateNew$blockinfo1 == null) continue;
            list.add(GottschTemplateNew$blockinfo1);
        }
        return list;
    }

    public static List<EntityInfo> processEntityInfos(@Nullable GottschTemplate GottschTemplate2, LevelAccessor p_215387_0_, BlockPos p_215387_1_, PlacementSettings p_215387_2_, List<EntityInfo> p_215387_3_) {
        ArrayList list = Lists.newArrayList();
        for (EntityInfo entityInfo : p_215387_3_) {
            StructureProcessor proc;
            Vec3 pos = GottschTemplate.transformedVec3d(p_215387_2_, entityInfo.pos).m_82549_(Vec3.m_82528_((Vec3i)p_215387_1_));
            BlockPos blockpos = GottschTemplate.calculateRelativePosition(p_215387_2_, entityInfo.blockPos).m_121955_((Vec3i)p_215387_1_);
            EntityInfo info = new EntityInfo(pos, blockpos, entityInfo.nbt);
            Iterator<StructureProcessor> iterator = p_215387_2_.getProcessors().iterator();
            while (iterator.hasNext() && (info = (proc = iterator.next()).processEntity(p_215387_0_, p_215387_1_, entityInfo, info, p_215387_2_, GottschTemplate2)) != null) {
            }
            if (info == null) continue;
            list.add(info);
        }
        return list;
    }

    private void addEntitiesToWorld(ServerLevelAccessor p_237143_1_, BlockPos p_237143_2_, PlacementSettings placementIn) {
        for (EntityInfo GottschTemplateNew$entityinfo : GottschTemplate.processEntityInfos(this, (LevelAccessor)p_237143_1_, p_237143_2_, placementIn, this.entities)) {
            BlockPos blockpos = GottschTemplate.m_74593_((BlockPos)GottschTemplateNew$entityinfo.blockPos, (Mirror)placementIn.getMirror(), (Rotation)placementIn.getRotation(), (BlockPos)placementIn.getRotationPivot()).m_121955_((Vec3i)p_237143_2_);
            blockpos = GottschTemplateNew$entityinfo.blockPos;
            if (placementIn.getBoundingBox() != null && !placementIn.getBoundingBox().m_71051_((Vec3i)blockpos)) continue;
            CompoundTag CompoundTag2 = GottschTemplateNew$entityinfo.nbt.m_6426_();
            Vec3 vector3d1 = GottschTemplateNew$entityinfo.pos;
            Vec3i vec3i = new Vec3i(Mth.m_14107_((double)vector3d1.f_82479_), Mth.m_14107_((double)vector3d1.f_82480_), Mth.m_14107_((double)vector3d1.f_82481_));
            ListTag ListTag2 = new ListTag();
            ListTag2.add((Object)DoubleTag.m_128500_((double)vector3d1.f_82479_));
            ListTag2.add((Object)DoubleTag.m_128500_((double)vector3d1.f_82480_));
            ListTag2.add((Object)DoubleTag.m_128500_((double)vector3d1.f_82481_));
            CompoundTag2.m_128365_("Pos", (Tag)ListTag2);
            CompoundTag2.m_128473_("UUID");
            GottschTemplate.m_74543_(p_237143_1_, CompoundTag2).ifPresent(p_242927_6_ -> {
                float f = p_242927_6_.m_6961_(placementIn.getMirror());
                p_242927_6_.m_7678_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, f += p_242927_6_.m_146908_() - p_242927_6_.m_7890_(placementIn.getRotation()), p_242927_6_.m_146909_());
                if (placementIn.shouldFinalizeEntities() && p_242927_6_ instanceof Mob) {
                    ((Mob)p_242927_6_).m_6518_(p_237143_1_, p_237143_1_.m_6436_(new BlockPos(vec3i)), MobSpawnType.STRUCTURE, (SpawnGroupData)null, CompoundTag2);
                }
                p_237143_1_.m_47205_(p_242927_6_);
            });
        }
    }

    private static Optional<Entity> m_74543_(ServerLevelAccessor p_215382_0_, CompoundTag p_215382_1_) {
        try {
            return EntityType.m_20642_((CompoundTag)p_215382_1_, (Level)p_215382_0_.m_6018_());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public void m_246595_(HolderGetter<Block> getter, CompoundTag tag) {
        this.load(getter, tag, new ArrayList<Block>(), new HashMap<BlockState, BlockState>());
    }

    public void load(HolderGetter<Block> getter, CompoundTag tag, List<Block> markerBlocks, Map<BlockState, BlockState> replacementBlocks) {
        this.palettes.clear();
        this.entities.clear();
        ListTag ListTag2 = tag.m_128437_("size", 3);
        this.size = new BlockPos(ListTag2.m_128763_(0), ListTag2.m_128763_(1), ListTag2.m_128763_(2));
        ListTag blocksNBT = tag.m_128437_("blocks", 10);
        if (tag.m_128425_("palettes", 9)) {
            ListTag palettesNBT2 = tag.m_128437_("palettes", 9);
            for (int i = 0; i < palettesNBT2.size(); ++i) {
                this.loadPalette(getter, palettesNBT2.m_128744_(i), blocksNBT, markerBlocks, replacementBlocks);
            }
        } else {
            this.loadPalette(getter, tag.m_128437_("palette", 10), blocksNBT, markerBlocks, replacementBlocks);
        }
        ListTag ListTag5 = tag.m_128437_("entities", 10);
        for (int j = 0; j < ListTag5.size(); ++j) {
            CompoundTag CompoundTag2 = ListTag5.m_128728_(j);
            ListTag ListTag3 = CompoundTag2.m_128437_("pos", 6);
            Vec3 vector3d = new Vec3(ListTag3.m_128772_(0), ListTag3.m_128772_(1), ListTag3.m_128772_(2));
            ListTag ListTag4 = CompoundTag2.m_128437_("blockPos", 3);
            BlockPos blockpos = new BlockPos(ListTag4.m_128763_(0), ListTag4.m_128763_(1), ListTag4.m_128763_(2));
            if (!CompoundTag2.m_128441_("nbt")) continue;
            CompoundTag CompoundTag1 = CompoundTag2.m_128469_("nbt");
            this.entities.add(new EntityInfo(vector3d, blockpos, CompoundTag1));
        }
    }

    private void loadPalette(HolderGetter<Block> getter, ListTag palettes, ListTag blocks, List<Block> markerBlocks, Map<BlockState, BlockState> replacementBlocks) {
        SimplePalette GottschTemplateNew$basicpalette = new SimplePalette();
        for (int i = 0; i < palettes.size(); ++i) {
            GottschTemplateNew$basicpalette.addMapping(NbtUtils.m_247651_(getter, (CompoundTag)palettes.m_128728_(i)), i);
        }
        ArrayList list2 = Lists.newArrayList();
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (int j = 0; j < blocks.size(); ++j) {
            CompoundTag CompoundTag2 = blocks.m_128728_(j);
            ListTag ListTag2 = CompoundTag2.m_128437_("pos", 3);
            BlockPos blockPos = new BlockPos(ListTag2.m_128763_(0), ListTag2.m_128763_(1), ListTag2.m_128763_(2));
            BlockState blockState = GottschTemplateNew$basicpalette.stateFor(CompoundTag2.m_128451_("state"));
            CompoundTag CompoundTag1 = CompoundTag2.m_128441_("nbt") ? CompoundTag2.m_128469_("nbt") : null;
            BlockInfo GottschTemplateNew$blockinfo = new BlockInfo(blockPos, blockState, CompoundTag1);
            GottschTemplate.addToLists(GottschTemplateNew$blockinfo, list2, list, list1);
            Block block = blockState.m_60734_();
            if (block == Blocks.f_50016_ || !markerBlocks.contains(block)) continue;
            this.tagBlockMap.put((Object)block, (Object)new BlockInfoContext(GottschTemplateNew$blockinfo, new Coords(blockPos), blockState));
        }
        List<BlockInfo> list3 = GottschTemplate.m_74614_(list2, list, list1);
        this.palettes.add(new Palette(list3));
    }

    public static ICoords transform(PlacementSettings placement, ICoords coords) {
        return new Coords(GottschTemplate.m_74593_((BlockPos)coords.toPos(), (Mirror)placement.getMirror(), (Rotation)placement.getRotation(), (BlockPos)placement.getRotationPivot()));
    }

    public ICoords findCoords(Random random, Block findBlock) {
        ICoords coords = null;
        List contextList = (List)this.getTagBlockMap().get((Object)findBlock);
        List list = contextList.stream().map(c -> c.getCoords()).collect(Collectors.toList());
        if (list.isEmpty()) {
            return new Coords(0, 0, 0);
        }
        coords = list.size() == 1 ? (ICoords)list.get(0) : (ICoords)list.get(random.nextInt(list.size()));
        return coords;
    }

    public ICoords findCoords(RandomSource random, Block findBlock) {
        ICoords coords = null;
        List contextList = (List)this.getTagBlockMap().get((Object)findBlock);
        List list = contextList.stream().map(c -> c.getCoords()).collect(Collectors.toList());
        if (list.isEmpty()) {
            return new Coords(0, 0, 0);
        }
        coords = list.size() == 1 ? (ICoords)list.get(0) : (ICoords)list.get(random.m_188503_(list.size()));
        return coords;
    }

    public Multimap<Block, BlockInfoContext> getTagBlockMap() {
        return this.tagBlockMap;
    }

    static {
        deferredBlocks.add(DoorBlock.class.getSimpleName());
        deferredBlocks.add(TorchBlock.class.getSimpleName());
        deferredBlocks.add(LeverBlock.class.getSimpleName());
    }

    public static class BlockInfo {
        public final BlockPos pos;
        public final BlockState state;
        public final CompoundTag nbt;

        public BlockInfo(BlockPos pos, BlockState state, @Nullable CompoundTag nbt) {
            this.pos = pos;
            this.state = state;
            this.nbt = nbt;
        }

        public String toString() {
            return String.format("<StructureBlockInfo | %s | %s | %s>", this.pos, this.state, this.nbt);
        }
    }

    public static final class Palette {
        private final List<BlockInfo> blocks;
        private final Map<Block, List<BlockInfo>> cache = Maps.newHashMap();

        private Palette(List<BlockInfo> blockInfos) {
            this.blocks = blockInfos;
        }

        public List<BlockInfo> blocks() {
            return this.blocks;
        }

        public List<BlockInfo> blocks(Block block) {
            return this.cache.computeIfAbsent(block, p_237160_1_ -> this.blocks.stream().filter(predicate -> predicate.state.m_60713_(p_237160_1_)).collect(Collectors.toList()));
        }
    }

    public static class EntityInfo {
        public final Vec3 pos;
        public final BlockPos blockPos;
        public final CompoundTag nbt;

        public EntityInfo(Vec3 vec3d, BlockPos blockPos, CompoundTag nbt) {
            this.pos = vec3d;
            this.blockPos = blockPos;
            this.nbt = nbt;
        }
    }

    static class SimplePalette
    implements Iterable<BlockState> {
        public static final BlockState DEFAULT_BLOCK_STATE = Blocks.f_50016_.m_49966_();
        private final IdMapper<BlockState> ids = new IdMapper(16);
        private int lastId;

        private SimplePalette() {
        }

        public int idFor(BlockState p_189954_1_) {
            int i = this.ids.m_7447_((Object)p_189954_1_);
            if (i == -1) {
                i = this.lastId++;
                this.ids.m_122664_((Object)p_189954_1_, i);
            }
            return i;
        }

        @Nullable
        public BlockState stateFor(int p_189955_1_) {
            BlockState blockstate = (BlockState)this.ids.m_7942_(p_189955_1_);
            return blockstate == null ? DEFAULT_BLOCK_STATE : blockstate;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(BlockState p_189956_1_, int p_189956_2_) {
            this.ids.m_122664_((Object)p_189956_1_, p_189956_2_);
        }
    }
}

