/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.world;

import mod.gottsch.forge.gottschcore.block.BlockContext;
import mod.gottsch.forge.gottschcore.spatial.Coords;
import mod.gottsch.forge.gottschcore.spatial.ICoords;
import mod.gottsch.forge.gottschcore.world.IWorldGenContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class WorldInfo {
    public static final int MAX_HEIGHT = 319;
    public static final int MIN_HEIGHT = -63;
    public static final int BOTTOM_HEIGHT = -64;
    public static final int INVALID_SURFACE_POS = -255;
    public static final int CHUNK_RADIUS = 8;
    public static final int CHUNK_SIZE = 16;
    public static final ResourceLocation OVERWORLD = new ResourceLocation("overworld");
    public static final ResourceLocation THE_NETHER = new ResourceLocation("the_nether");
    public static final ResourceLocation THE_END = new ResourceLocation("the_end");

    public static boolean isServerDistribution() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static boolean isServerSide(Level level) {
        return !WorldInfo.isClientSide(level);
    }

    public static boolean isClientDistribution() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static boolean isClientSide(Level level) {
        return level.m_5776_();
    }

    public static ResourceLocation getDimension(Level level) {
        return level.m_46472_().m_135782_();
    }

    public static boolean isCurrentDimension(Level level, ResourceLocation dimension) {
        return WorldInfo.getDimension(level).equals((Object)dimension);
    }

    public static boolean isSurfaceWorld(Level level) {
        return WorldInfo.isCurrentDimension(level, OVERWORLD);
    }

    public static boolean isSurfaceWorld(Level level, BlockPos pos) {
        Holder biome = level.m_204166_(pos);
        return !biome.m_203656_(BiomeTags.f_207612_) && !biome.m_203656_(BiomeTags.f_215818_);
    }

    public static boolean isTheNether(Level world) {
        return WorldInfo.isCurrentDimension(world, THE_NETHER);
    }

    public static boolean isTheEnd(Level world) {
        return WorldInfo.isCurrentDimension(world, THE_END);
    }

    public static void setBlock(ServerLevelAccessor level, ICoords coords, BlockState state) {
        level.m_7731_(coords.toPos(), state, 3);
    }

    public static int getHeight(Level level) {
        return level.m_141928_();
    }

    public static int getHeight(ServerLevel level, ChunkGenerator generator, Heightmap.Types heightmapType, ICoords coords) {
        return WorldInfo.getHeight(level, generator, heightmapType, coords.toPos());
    }

    public static int getHeight(ServerLevelAccessor level, ChunkGenerator generator, Heightmap.Types heightmapType, ICoords coords) {
        return WorldInfo.getHeight(level, generator, heightmapType, coords.toPos());
    }

    private static int getHeight(ServerLevel level, ChunkGenerator generator, Heightmap.Types heightmapType, BlockPos pos) {
        int occupiedHeight = generator.m_223235_(pos.m_123341_(), pos.m_123343_(), heightmapType, (LevelHeightAccessor)level, level.m_7726_().m_214994_());
        return occupiedHeight;
    }

    private static int getHeight(ServerLevelAccessor level, ChunkGenerator generator, Heightmap.Types heightmapType, BlockPos pos) {
        int occupiedHeight = generator.m_223235_(pos.m_123341_(), pos.m_123343_(), heightmapType, (LevelHeightAccessor)level, level.m_6018_().m_7726_().m_214994_());
        return occupiedHeight;
    }

    public static boolean isHeightValid(ICoords coords) {
        return WorldInfo.isHeightValid(coords.toPos());
    }

    private static boolean isHeightValid(BlockPos blockPos) {
        return blockPos.m_123342_() >= -63 && blockPos.m_123342_() <= 319;
    }

    public static boolean isHeightValid(Level level, ICoords coords) {
        return WorldInfo.isHeightValid(level, coords.toPos());
    }

    private static boolean isHeightValid(Level level, BlockPos blockPos) {
        return blockPos.m_123342_() >= -63 && blockPos.m_123342_() <= level.m_141928_();
    }

    public static ICoords getDryLandSurfaceCoords(ServerLevelAccessor level, ChunkGenerator generator, ICoords coords) {
        int occupiedHeight = WorldInfo.getHeight(level, generator, Heightmap.Types.WORLD_SURFACE_WG, coords);
        ICoords spawnCoords = coords.withY(occupiedHeight + 1);
        NoiseColumn columnOfBlocks = generator.m_214184_(coords.getX(), coords.getZ(), (LevelHeightAccessor)level, level.m_6018_().m_7726_().m_214994_());
        BlockState topBlock = columnOfBlocks.m_183556_(occupiedHeight);
        if (!topBlock.m_60819_().m_76178_()) {
            return Coords.EMPTY;
        }
        return spawnCoords;
    }

    public static ICoords getDryLandSurfaceCoords(ServerLevelAccessor level, ChunkGenerator generator, Heightmap.Types heightMapType, ICoords coords) {
        int occupiedHeight = WorldInfo.getHeight(level, generator, heightMapType, coords);
        ICoords spawnCoords = coords.withY(occupiedHeight + 1);
        NoiseColumn columnOfBlocks = generator.m_214184_(coords.getX(), coords.getZ(), (LevelHeightAccessor)level, level.m_6018_().m_7726_().m_214994_());
        BlockState topBlock = columnOfBlocks.m_183556_(occupiedHeight);
        if (!topBlock.m_60819_().m_76178_()) {
            return Coords.EMPTY;
        }
        return spawnCoords;
    }

    @Deprecated
    public static ICoords getDryLandSurfaceCoordsWG(IWorldGenContext context, ICoords coords) {
        return WorldInfo.getDryLandSurfaceCoords(context.level(), context.chunkGenerator(), Heightmap.Types.WORLD_SURFACE_WG, coords);
    }

    public static ICoords getSurfaceCoords(ServerLevelAccessor level, ChunkGenerator generator, ICoords coords) {
        int occupiedHeight = WorldInfo.getHeight(level, generator, Heightmap.Types.WORLD_SURFACE_WG, coords);
        ICoords spawnCoords = coords.withY(occupiedHeight + 1);
        NoiseColumn columnOfBlocks = generator.m_214184_(coords.getX(), coords.getZ(), (LevelHeightAccessor)level, level.m_6018_().m_7726_().m_214994_());
        BlockState topBlock = columnOfBlocks.m_183556_(occupiedHeight);
        return spawnCoords;
    }

    public static ICoords getSubterraneanSurfaceCoords(ServerLevelAccessor world, ICoords coords) {
        boolean isSurfaceBlock = false;
        ICoords newCoords = coords;
        while (!isSurfaceBlock) {
            BlockContext blockContext = new BlockContext((CommonLevelAccessor)world, newCoords.down(1));
            if (!WorldInfo.isHeightValid(blockContext.getCoords())) {
                return Coords.EMPTY;
            }
            if (blockContext.isFluid() || blockContext.getState().m_60734_().m_284356_() == MapColor.f_283828_) {
                return Coords.EMPTY;
            }
            if (blockContext.isAir() || blockContext.isReplaceable() || blockContext.isLeaves() || blockContext.getState().m_60734_().m_284356_() == MapColor.f_283825_ || blockContext.isBurning()) {
                newCoords = newCoords.down(1);
                continue;
            }
            isSurfaceBlock = true;
        }
        return newCoords;
    }

    public static ICoords getAnyLandSurfaceCoords(ServerLevelAccessor level, ChunkGenerator generator, ICoords coords) {
        boolean isSurfaceBlock = false;
        int occupiedHeight = WorldInfo.getHeight(level, generator, Heightmap.Types.WORLD_SURFACE_WG, coords);
        NoiseColumn columnOfBlocks = generator.m_214184_(coords.getX(), coords.getZ(), (LevelHeightAccessor)level, level.m_6018_().m_7726_().m_214994_());
        BlockState noiseBlock = columnOfBlocks.m_183556_(occupiedHeight);
        int index = 0;
        while (!isSurfaceBlock) {
            noiseBlock = columnOfBlocks.m_183556_(occupiedHeight -= index);
            BlockContext blockContext = new BlockContext(coords.withY(occupiedHeight), noiseBlock);
            if (!WorldInfo.isHeightValid(blockContext.getCoords())) {
                return Coords.EMPTY;
            }
            if (blockContext.isAir() || blockContext.isReplaceable() || blockContext.isFluid() || blockContext.isBurning()) {
                ++index;
                continue;
            }
            isSurfaceBlock = true;
        }
        return coords.withY(occupiedHeight + 1);
    }

    public static ICoords getOceanFloorSurfaceCoords(ServerLevelAccessor level, ChunkGenerator generator, ICoords coords) {
        int occupiedHeight = WorldInfo.getHeight(level, generator, Heightmap.Types.OCEAN_FLOOR_WG, coords);
        ICoords spawnCoords = coords.withY(occupiedHeight + 1);
        NoiseColumn columnOfBlocks = generator.m_214184_(coords.getX(), coords.getZ(), (LevelHeightAccessor)level, level.m_6018_().m_7726_().m_214994_());
        BlockState topBlock = columnOfBlocks.m_183556_(occupiedHeight);
        if (!topBlock.m_60819_().m_76178_()) {
            return Coords.EMPTY;
        }
        return spawnCoords;
    }

    public static boolean isValidAboveGroundBase(ServerLevelAccessor world, ICoords coords, int width, int depth, double groundPercentRequired, double airPercentRequired) {
        return WorldInfo.isSolidBase(world, coords, width, depth, groundPercentRequired) && WorldInfo.isAirBase(world, coords.up(1), width, depth, airPercentRequired);
    }

    public static boolean isValidAboveGroundBase(ServerLevelAccessor level, ICoords coords, int width, int depth, double groundPercentRequired, double airPercentRequired1, double airPercentRequired2) {
        return WorldInfo.isSolidBase(level, coords, width, depth, groundPercentRequired) && WorldInfo.isAirBase(level, coords.up(1), width, depth, airPercentRequired1) && WorldInfo.isAirBase(level, coords.up(2), width, depth, airPercentRequired2);
    }

    public static boolean isSolidBase(ServerLevelAccessor level, ICoords coords, int width, int depth, double percentRequired) {
        double percent = WorldInfo.getSolidBasePercent(level, coords.down(1), width, depth);
        return !(percent < percentRequired);
    }

    public static double getSolidBasePercent(ServerLevelAccessor level, ICoords coords, int width, int depth) {
        int platformSize = 0;
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                BlockContext blockContext = new BlockContext((CommonLevelAccessor)level, coords.add(x, 0, z));
                if (!blockContext.hasState() || !blockContext.isSolid() || blockContext.isReplaceable()) continue;
                ++platformSize;
            }
        }
        double base = depth * width;
        double percent = (double)platformSize / base * 100.0;
        return percent;
    }

    public static double getAirBasePercent(ServerLevelAccessor level, ICoords coords, int width, int depth) {
        double percent = 0.0;
        int airBlocks = 0;
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                BlockContext blockContext = new BlockContext((CommonLevelAccessor)level, coords.add(x, 0, z));
                if ((!blockContext.hasState() || !blockContext.isAir()) && !blockContext.isReplaceable()) continue;
                ++airBlocks;
            }
        }
        double base = depth * width;
        percent = (double)airBlocks / base * 100.0;
        return percent;
    }

    public static boolean isAirBase(ServerLevelAccessor level, ICoords coords, int width, int depth, double percentRequired) {
        double percent = WorldInfo.getAirBasePercent(level, coords.down(1), width, depth);
        return !(percent < percentRequired);
    }

    public static boolean isLiquidBase(ServerLevelAccessor level, ICoords coords, int width, int depth, double percentRequired) {
        double percent = WorldInfo.getFluidBasePercent(level, coords.down(1), width, depth);
        return !(percent < percentRequired);
    }

    public static double getFluidBasePercent(ServerLevelAccessor level, ICoords coords, int width, int depth) {
        double percent = 0.0;
        int liquidBlocks = 0;
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                BlockContext blockContext = new BlockContext((CommonLevelAccessor)level, coords.add(x, 0, z));
                if (!blockContext.hasState() || !blockContext.isFluid()) continue;
                ++liquidBlocks;
            }
        }
        double base = depth * width;
        percent = (double)liquidBlocks / base * 100.0;
        return percent;
    }

    public static ICoords getClosestPlayerCoords(Level level, ICoords sourceCoords) {
        Player player = level.m_45924_((double)sourceCoords.getX(), (double)sourceCoords.getY(), (double)sourceCoords.getZ(), 64.0, false);
        Coords playerCoords = new Coords(player.m_20183_());
        return playerCoords;
    }

    public static enum SURFACE {
        LAND,
        WATER,
        LAVA,
        OTHER,
        INVALID;

    }
}

