/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.spatial;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mod.gottsch.forge.gottschcore.spatial.Rotate;
import net.minecraft.core.Direction;

public enum Heading {
    UP(Direction.UP),
    DOWN(Direction.DOWN),
    NORTH(Direction.NORTH),
    SOUTH(Direction.SOUTH),
    WEST(Direction.WEST),
    EAST(Direction.EAST);

    private static final Map<Direction, Heading> mapByDirection;
    private Direction direction;

    private Heading(Direction direction) {
        this.direction = direction;
    }

    public Direction toDirection() {
        return this.direction;
    }

    public Heading byDirection(Direction direction) {
        return mapByDirection.get(direction);
    }

    public int getIndex() {
        return this.direction.m_122411_();
    }

    public static Heading getByIndex(int index) {
        return mapByDirection.get(Direction.m_122376_((int)(index % Heading.values().length)));
    }

    public Heading rotateY(Rotate r) {
        return switch (r) {
            case Rotate.NO_ROTATE -> this;
            case Rotate.ROTATE_90 -> {
                switch (this) {
                    case NORTH: {
                        yield EAST;
                    }
                    case EAST: {
                        yield SOUTH;
                    }
                    case SOUTH: {
                        yield WEST;
                    }
                    case WEST: {
                        yield NORTH;
                    }
                }
                yield this;
            }
            case Rotate.ROTATE_180 -> {
                switch (this) {
                    case NORTH: {
                        yield SOUTH;
                    }
                    case EAST: {
                        yield WEST;
                    }
                    case SOUTH: {
                        yield NORTH;
                    }
                    case WEST: {
                        yield EAST;
                    }
                }
                yield this;
            }
            case Rotate.ROTATE_270 -> {
                switch (this) {
                    case NORTH: {
                        yield WEST;
                    }
                    case EAST: {
                        yield NORTH;
                    }
                    case SOUTH: {
                        yield EAST;
                    }
                    case WEST: {
                        yield SOUTH;
                    }
                }
                yield this;
            }
            default -> this;
        };
    }

    public Rotate getRotation(Heading toHeading) {
        switch (toHeading) {
            case NORTH: {
                switch (this) {
                    case NORTH: {
                        return Rotate.NO_ROTATE;
                    }
                    case EAST: {
                        return Rotate.ROTATE_270;
                    }
                    case SOUTH: {
                        return Rotate.ROTATE_180;
                    }
                    case WEST: {
                        return Rotate.ROTATE_90;
                    }
                }
                return Rotate.NO_ROTATE;
            }
            case EAST: {
                switch (this) {
                    case NORTH: {
                        return Rotate.ROTATE_90;
                    }
                    case EAST: {
                        return Rotate.NO_ROTATE;
                    }
                    case SOUTH: {
                        return Rotate.ROTATE_270;
                    }
                    case WEST: {
                        return Rotate.ROTATE_180;
                    }
                }
                return Rotate.NO_ROTATE;
            }
            case SOUTH: {
                switch (this) {
                    case NORTH: {
                        return Rotate.ROTATE_180;
                    }
                    case EAST: {
                        return Rotate.ROTATE_90;
                    }
                    case SOUTH: {
                        return Rotate.NO_ROTATE;
                    }
                    case WEST: {
                        return Rotate.ROTATE_270;
                    }
                }
                return Rotate.NO_ROTATE;
            }
            case WEST: {
                switch (this) {
                    case NORTH: {
                        return Rotate.ROTATE_270;
                    }
                    case EAST: {
                        return Rotate.ROTATE_180;
                    }
                    case SOUTH: {
                        return Rotate.ROTATE_90;
                    }
                    case WEST: {
                        return Rotate.NO_ROTATE;
                    }
                }
                return Rotate.NO_ROTATE;
            }
        }
        return Rotate.NO_ROTATE;
    }

    public static Heading fromDirection(Direction direction) {
        switch (direction) {
            case NORTH: {
                return NORTH;
            }
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
        }
        return NORTH;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static List<String> getNames() {
        List<String> names = EnumSet.allOf(Heading.class).stream().map(x -> x.name()).collect(Collectors.toList());
        return names;
    }

    static {
        mapByDirection = new HashMap<Direction, Heading>();
        for (Heading x : EnumSet.allOf(Heading.class)) {
            mapByDirection.put(x.getDirection(), x);
        }
    }
}

