/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.spatial;

import java.util.Objects;
import mod.gottsch.forge.gottschcore.spatial.Coords;
import mod.gottsch.forge.gottschcore.spatial.ICoords;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.AABB;

public class Box {
    public static final Box EMPTY = new Box(new Coords(0, -255, 0), new Coords(0, -255, 0));
    private static final String MIN_COORDS = "min";
    private static final String MAX_COORDS = "max";
    private ICoords minCoords;
    private ICoords maxCoords;

    public Box(ICoords c1, ICoords c2) {
        int minX = Math.min(c1.getX(), c2.getX());
        int minY = Math.min(c1.getY(), c2.getY());
        int minZ = Math.min(c1.getZ(), c2.getZ());
        int maxX = Math.max(c1.getX(), c2.getX());
        int maxY = Math.max(c1.getY(), c2.getY());
        int maxZ = Math.max(c1.getZ(), c2.getZ());
        this.setMinCoords(new Coords(minX, minY, minZ));
        this.setMaxCoords(new Coords(maxX, maxY, maxZ));
    }

    public Box(ICoords c) {
        this.setMinCoords(new Coords(c));
        this.setMaxCoords(c.add(1, 1, 1));
    }

    public Box(AABB aabb) {
        this.setMinCoords(new Coords((int)aabb.f_82288_, (int)aabb.f_82289_, (int)aabb.f_82290_));
        this.setMaxCoords(new Coords((int)aabb.f_82291_, (int)aabb.f_82292_, (int)aabb.f_82293_));
    }

    public ICoords getSize() {
        return this.getMaxCoords().delta(this.getMinCoords());
    }

    public void save(CompoundTag nbt) {
        CompoundTag coordsNbt1 = new CompoundTag();
        CompoundTag coordsNbt2 = new CompoundTag();
        this.getMinCoords().save(coordsNbt1);
        this.getMaxCoords().save(coordsNbt2);
        nbt.m_128365_(MIN_COORDS, (Tag)coordsNbt1);
        nbt.m_128365_(MAX_COORDS, (Tag)coordsNbt2);
    }

    public static Box load(CompoundTag nbt) {
        if (!nbt.m_128441_(MIN_COORDS)) {
            return EMPTY;
        }
        ICoords c1 = Coords.EMPTY.load(nbt.m_128469_(MIN_COORDS));
        if (!nbt.m_128441_(MAX_COORDS)) {
            return EMPTY;
        }
        ICoords c2 = Coords.EMPTY.load(nbt.m_128469_(MAX_COORDS));
        Box box = new Box(c1, c2);
        return box;
    }

    public ICoords getMinCoords() {
        return this.minCoords;
    }

    public void setMinCoords(ICoords minCoords) {
        this.minCoords = minCoords;
    }

    public ICoords getMaxCoords() {
        return this.maxCoords;
    }

    public void setMaxCoords(ICoords maxCoords) {
        this.maxCoords = maxCoords;
    }

    public String toString() {
        return "Box [minCoords=" + this.minCoords.toShortString() + ", maxCoords=" + this.maxCoords.toShortString() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.maxCoords, this.minCoords);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Box other = (Box)obj;
        return Objects.equals(this.maxCoords, other.maxCoords) && Objects.equals(this.minCoords, other.minCoords);
    }
}

