/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.random;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class WeightedCollection<W extends Number, T> {
    private final NavigableMap<Double, T> map = new TreeMap<Double, T>();
    private Random random;
    private double total = 0.0;

    public WeightedCollection() {
        this.setRandom(new Random());
    }

    public WeightedCollection(Random random) {
        this.setRandom(random);
    }

    public WeightedCollection<W, T> add(W weight, T item) {
        if (((Number)weight).doubleValue() > 0.0) {
            this.total += ((Number)weight).doubleValue();
            this.map.put(this.total, item);
        }
        return this;
    }

    public T next() {
        if (this.map.isEmpty() || this.total < 1.0) {
            return null;
        }
        double value = this.getRandom().nextDouble(this.total);
        return this.map.ceilingEntry(value).getValue();
    }

    public void clear() {
        this.map.clear();
        this.setTotal(0);
    }

    public int size() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    private void setTotal(int total) {
        this.total = total;
    }

    public Map<Double, T> getMap() {
        return this.map;
    }
}

