/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.random;

import java.util.Random;
import net.minecraft.util.RandomSource;

public final class RandomHelper {
    private static final int INT_MAX_PROB = 100;
    private static final double DOUBLE_MAX_PROB = 100.0;

    public static int randomInt(int min, int max) {
        Random random = new Random();
        return RandomHelper.randomInt(random, min, max);
    }

    public static int randomInt(Random random, int min, int max) {
        if (min < 0) {
            min = 0;
        }
        if (max <= 0) {
            return 0;
        }
        if (min == max) {
            return min;
        }
        if (min > max) {
            return random.nextInt(min) + 1;
        }
        return random.nextInt(max - min + 1) + min;
    }

    public static int randomInt(RandomSource random, int min, int max) {
        if (min < 0) {
            min = 0;
        }
        if (max <= 0) {
            return 0;
        }
        if (min == max) {
            return min;
        }
        if (min > max) {
            return random.m_188503_(min) + 1;
        }
        return random.m_188503_(max - min + 1) + min;
    }

    public static double randomDouble(double min, double max) {
        Random random = new Random();
        return RandomHelper.randomDouble(random, min, max);
    }

    public static double randomDouble(Random random, double min, double max) {
        if (min < 0.0) {
            min = 0.0;
        }
        if (max <= 0.0) {
            return 0.0;
        }
        if (min == max) {
            return min;
        }
        if (min > max) {
            return random.nextDouble() * min;
        }
        return random.nextDouble() * (max - min) + min;
    }

    public static boolean checkProbability(Random random, int probability) {
        Random r = null;
        Random random2 = r = random == null ? new Random() : random;
        return r.nextInt(100) < probability;
    }

    public static boolean checkProbability(RandomSource random, int probability) {
        return random.m_188503_(100) < probability;
    }

    public static boolean checkProbability(Random random, double probability) {
        Random r = null;
        Random random2 = r = random == null ? new Random() : random;
        return r.nextDouble() * 100.0 < probability;
    }

    public static boolean checkProbability(RandomSource random, double probability) {
        return random.m_188500_() * 100.0 < probability;
    }
}

