/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.config;

import java.nio.file.Paths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public interface IConfig {
    public static final String LOGGING_CATEGORY = "logging";
    public static final String CATEGORY_DIV = "##############################";
    public static final String DEFAULT_LOGGER_FOLDER = "logs";
    public static final String DEFAULT_LOGGER_LEVEL = "info";
    public static final String DEFAULT_LOGGER_SIZE = "1000K";

    default public void addRollingFileAppender(String modid) {
        String appenderName = modid + "Appender";
        Object logsFolder = this.getLogsFolder();
        if (!((String)logsFolder).endsWith("/")) {
            logsFolder = (String)logsFolder + "/";
        }
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = ctx.getConfiguration();
        SizeBasedTriggeringPolicy policy = SizeBasedTriggeringPolicy.createPolicy((String)this.getLogSize());
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d [%t] %p %c | %F:%L | %m%n").withAlwaysWriteExceptions(true).build();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFileName(Paths.get((String)logsFolder, modid + ".log").toString()).withFilePattern(Paths.get((String)logsFolder, modid + "-%d{yyyy-MM-dd-HH_mm_ss}.log").toString()).withAppend(true).setName(appenderName)).withBufferedIo(true)).withImmediateFlush(true)).withPolicy((TriggeringPolicy)policy).setLayout((Layout)layout)).setIgnoreExceptions(true)).withAdvertise(false).setConfiguration(configuration)).build();
        appender.start();
        configuration.addAppender((Appender)appender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)"File", null, null);
        AppenderRef[] refs = new AppenderRef[]{ref};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.toLevel((String)this.getLoggingLevel(), (Level)Level.INFO), (String)modid, (String)"true", (AppenderRef[])refs, null, (Configuration)configuration, null);
        loggerConfig.addAppender((Appender)appender, null, null);
        configuration.addLogger(modid, loggerConfig);
        ctx.updateLoggers();
    }

    default public String getLogsFolder() {
        return DEFAULT_LOGGER_FOLDER;
    }

    default public String getLogSize() {
        return DEFAULT_LOGGER_SIZE;
    }

    default public String getLoggingLevel() {
        return DEFAULT_LOGGER_SIZE;
    }
}

