/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.bst;

import mod.gottsch.forge.gottschcore.GottschCore;
import mod.gottsch.forge.gottschcore.bst.IInterval;

public class Interval<D>
implements IInterval<D> {
    public static final Interval<?> EMPTY = new Interval<Object>(null, null, null);
    private Integer start;
    private Integer end;
    private Integer min;
    private Integer max;
    private IInterval<D> left;
    private IInterval<D> right;
    private D data;

    public Interval() {
        this.start = EMPTY.getStart();
        this.end = EMPTY.getEnd();
    }

    public Interval(Integer start, Integer end) {
        this.start = start;
        this.end = end;
        this.min = start < end ? start : end;
        this.max = start > end ? start : end;
    }

    public Interval(Integer start, Integer end, D data) {
        this(start, end);
        this.data = data;
    }

    @Override
    public int compareTo(IInterval<D> interval) {
        if (this.getStart() < interval.getStart()) {
            return -1;
        }
        if (this.getStart() == interval.getStart()) {
            if (this.getEnd() == interval.getEnd()) {
                return 0;
            }
            GottschCore.LOGGER.debug("this.end -> {}, interval.end -> {}", (Object)this.getEnd(), (Object)interval.getEnd());
            return this.getEnd() < interval.getEnd() ? -1 : 1;
        }
        GottschCore.LOGGER.debug("this.end -> {}, interval.end -> {}", (Object)this.getEnd(), (Object)interval.getEnd());
        return 1;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public Integer getMin() {
        return this.min;
    }

    @Override
    public void setMin(Integer min) {
        this.min = min;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    public void setMax(Integer max) {
        this.max = max;
    }

    @Override
    public IInterval<D> getLeft() {
        return this.left;
    }

    @Override
    public void setLeft(IInterval<D> left) {
        this.left = left;
    }

    @Override
    public IInterval<D> getRight() {
        return this.right;
    }

    @Override
    public void setRight(IInterval<D> right) {
        this.right = right;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.start == null ? other.start != null : !this.start.equals(other.start)) {
            return false;
        }
        return !(this.end == null ? other.end != null : !this.end.equals(other.end));
    }

    @Override
    public D getData() {
        return this.data;
    }

    @Override
    public void setData(D data) {
        this.data = data;
    }

    public String toString() {
        return "Interval [start=" + this.start + ", end=" + this.end + ", min=" + this.min + ", max=" + this.max + ", left=" + this.left + ", right=" + this.right + ", data=" + this.data + "]";
    }
}

