/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.bst;

import java.util.function.Supplier;
import mod.gottsch.forge.gottschcore.bst.CoordsInterval;
import mod.gottsch.forge.gottschcore.bst.CoordsIntervalTree;
import mod.gottsch.forge.gottschcore.spatial.Coords;
import mod.gottsch.forge.gottschcore.spatial.ICoords;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class CoordsIntervalTreeNBTSerializer<D extends INBTSerializable<Tag>> {
    private static final String START_KEY = "coords1";
    private static final String END_KEY = "coords2";
    private static final String LEFT_KEY = "left";
    private static final String RIGHT_KEY = "right";
    private static final String MIN_KEY = "min";
    private static final String MAX_KEY = "max";
    private static final String DATA_KEY = "data";
    private Supplier<D> dataSupplier;

    public CoordsIntervalTreeNBTSerializer(Supplier<D> dataSupplier) {
        this.dataSupplier = dataSupplier;
    }

    public void save(CoordsIntervalTree<D> tree, CompoundTag tag, String tagName) {
        if (tree.getRoot() == null) {
            return;
        }
        CompoundTag rootNbt = new CompoundTag();
        this.save((CoordsInterval)tree.getRoot(), rootNbt);
        tag.m_128365_(tagName, (Tag)rootNbt);
    }

    private void save(CoordsInterval<D> interval, CompoundTag tag) {
        CompoundTag coordsNbt1 = new CompoundTag();
        CompoundTag coordsNbt2 = new CompoundTag();
        interval.getCoords1().save(coordsNbt1);
        interval.getCoords2().save(coordsNbt2);
        tag.m_128365_(START_KEY, (Tag)coordsNbt1);
        tag.m_128365_(END_KEY, (Tag)coordsNbt2);
        tag.m_128405_(MIN_KEY, interval.getMin().intValue());
        tag.m_128405_(MAX_KEY, interval.getMax().intValue());
        if (interval.getData() != null) {
            Tag dataNbt = ((INBTSerializable)interval.getData()).serializeNBT();
            tag.m_128365_(DATA_KEY, dataNbt);
        }
        if (interval.getLeft() != null) {
            CompoundTag left = new CompoundTag();
            this.save((CoordsInterval)interval.getLeft(), left);
            tag.m_128365_(LEFT_KEY, (Tag)left);
        }
        if (interval.getRight() != null) {
            CompoundTag right = new CompoundTag();
            this.save((CoordsInterval)interval.getRight(), right);
            tag.m_128365_(RIGHT_KEY, (Tag)right);
        }
    }

    public synchronized CoordsIntervalTree<D> load(CompoundTag tag, String tagName) {
        CoordsIntervalTree<D> tree = new CoordsIntervalTree<D>();
        CompoundTag rootNbt = tag.m_128469_(tagName);
        CoordsInterval<D> root = this.load(rootNbt);
        if (root != null && !root.isEmpty()) {
            tree.setRoot(root);
        }
        return tree;
    }

    private synchronized CoordsInterval<D> load(CompoundTag tag) {
        CoordsInterval<D> left;
        CoordsInterval<Object> interval = new CoordsInterval<Object>();
        ICoords c1 = CoordsInterval.EMPTY.getCoords1();
        ICoords c2 = CoordsInterval.EMPTY.getCoords2();
        if (tag.m_128441_(START_KEY)) {
            c1 = Coords.EMPTY.load(tag.m_128469_(START_KEY));
        }
        if (tag.m_128441_(END_KEY)) {
            c2 = Coords.EMPTY.load(tag.m_128469_(END_KEY));
        }
        interval.setCoords1(c1);
        interval.setCoords2(c2);
        if (tag.m_128441_(MIN_KEY)) {
            interval.setMin(tag.m_128451_(MIN_KEY));
        }
        if (tag.m_128441_(MAX_KEY)) {
            interval.setMax(tag.m_128451_(MAX_KEY));
        }
        if (tag.m_128441_(DATA_KEY) && this.dataSupplier != null) {
            INBTSerializable data = (INBTSerializable)this.getDataSupplier().get();
            data.deserializeNBT((Tag)tag);
            interval.setData(data);
        }
        if (tag.m_128441_(LEFT_KEY) && !(left = this.load((CompoundTag)tag.m_128423_(LEFT_KEY))).isEmpty()) {
            interval.setLeft(left);
        }
        if (tag.m_128441_(RIGHT_KEY)) {
            CoordsInterval<D> right = this.load((CompoundTag)tag.m_128423_(RIGHT_KEY));
            if (!right.isEmpty()) {
                interval.setLeft(right);
            } else {
                interval.setRight(right);
            }
        }
        return interval;
    }

    public Supplier<D> getDataSupplier() {
        return this.dataSupplier;
    }
}

