/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.bst;

import java.util.ArrayList;
import java.util.List;
import mod.gottsch.forge.gottschcore.GottschCore;
import mod.gottsch.forge.gottschcore.bst.CoordsInterval;
import mod.gottsch.forge.gottschcore.bst.IInterval;
import mod.gottsch.forge.gottschcore.bst.IIntervalTree;

public class CoordsIntervalTree<D>
implements IIntervalTree<D> {
    private IInterval<D> root;

    @Override
    public void clear() {
        this.setRoot(null);
    }

    @Override
    public synchronized IInterval<D> insert(IInterval<D> interval) {
        this.root = this.insert(this.root, interval);
        return this.root;
    }

    private IInterval<D> insert(IInterval<D> interval, IInterval<D> newInterval) {
        if (interval == null) {
            interval = newInterval;
            return interval;
        }
        if (interval.getMax() == null || newInterval.getEnd() > interval.getMax()) {
            interval.setMax(newInterval.getEnd());
        }
        if (interval.getMin() == null || newInterval.getStart() < interval.getMin()) {
            interval.setMin(newInterval.getStart());
        }
        if (interval.compareTo(newInterval) <= 0) {
            if (interval.getRight() == null) {
                interval.setRight(newInterval);
            } else {
                this.insert(interval.getRight(), newInterval);
            }
        } else if (interval.getLeft() == null) {
            interval.setLeft(newInterval);
        } else {
            this.insert(interval.getLeft(), newInterval);
        }
        return interval;
    }

    @Override
    public synchronized IInterval<D> delete(IInterval<D> target) {
        this.root = this.delete(this.root, target);
        return this.root;
    }

    private IInterval<D> delete(IInterval<D> interval, IInterval<D> target) {
        GottschCore.LOGGER.debug("delete interval -> {}, target -> {}", interval, target);
        if (interval == null) {
            return interval;
        }
        if (interval.compareTo(target) < 0) {
            interval.setRight(this.delete(interval.getRight(), target));
        } else if (interval.compareTo(target) > 0) {
            interval.setLeft(this.delete(interval.getLeft(), target));
        } else {
            if (interval.getLeft() == null && interval.getRight() == null) {
                return null;
            }
            if (interval.getLeft() == null) {
                return interval.getRight();
            }
            if (interval.getRight() == null) {
                return interval.getLeft();
            }
            this.insert(interval.getLeft(), interval.getRight());
            return interval.getLeft();
        }
        return interval;
    }

    public List<IInterval<D>> getOverlapping(IInterval<D> interval, IInterval<D> testInterval) {
        return this.getOverlapping(interval, testInterval, true, true);
    }

    @Override
    public synchronized List<IInterval<D>> getOverlapping(IInterval<D> interval, IInterval<D> testInterval, boolean findFast, boolean includeBorder) {
        ArrayList<IInterval<D>> results = new ArrayList<IInterval<D>>();
        if (includeBorder) {
            this.checkOverlap(interval, testInterval, results, findFast);
        } else {
            this.checkOverlapNoBorder(interval, testInterval, results, findFast);
        }
        return results;
    }

    private boolean checkOverlap(IInterval<D> interval, IInterval<D> testInterval, List<IInterval<D>> results, boolean findFast) {
        return this.checkOverlap((CoordsInterval)interval, (CoordsInterval)testInterval, results, findFast);
    }

    private boolean checkOverlap(CoordsInterval<D> interval, CoordsInterval<D> testInterval, List<IInterval<D>> results, boolean findFast) {
        if (interval == null) {
            return false;
        }
        if (testInterval.getStart() > interval.getMax() || testInterval.getEnd() < interval.getMin()) {
            return false;
        }
        if (interval.getStart() <= testInterval.getEnd() && interval.getEnd() >= testInterval.getStart() && interval.getStartZ() <= testInterval.getEndZ() && interval.getEndZ() >= testInterval.getStartZ() && interval.getStartY() <= testInterval.getEndY() && interval.getEndY() >= testInterval.getStartY()) {
            results.add(interval);
            if (findFast) {
                return true;
            }
        }
        if (interval.getLeft() != null && interval.getLeft().getMax() >= testInterval.getStart() && this.checkOverlap(interval.getLeft(), testInterval, results, findFast) && findFast) {
            return true;
        }
        return this.checkOverlap(interval.getRight(), testInterval, results, findFast) && findFast;
    }

    private boolean checkOverlapNoBorder(IInterval<D> interval, IInterval<D> testInterval, List<IInterval<D>> results, boolean findFast) {
        return this.checkOverlapNoBorder((CoordsInterval)interval, (CoordsInterval)testInterval, results, findFast);
    }

    private boolean checkOverlapNoBorder(CoordsInterval<D> interval, CoordsInterval<D> testInterval, List<IInterval<D>> results, boolean findFast) {
        if (interval == null) {
            return false;
        }
        if (testInterval.getStart() > interval.getMax() || testInterval.getEnd() < interval.getMin()) {
            return false;
        }
        if (interval.getStart() < testInterval.getEnd() && interval.getEnd() > testInterval.getStart() && interval.getStartZ() < testInterval.getEndZ() && interval.getEndZ() > testInterval.getStartZ() && interval.getStartY() < testInterval.getEndY() && interval.getEndY() > testInterval.getStartY()) {
            results.add(interval);
            if (findFast) {
                return true;
            }
        }
        if (interval.getLeft() != null && interval.getLeft().getMax() > testInterval.getStart() && this.checkOverlapNoBorder(interval.getLeft(), testInterval, results, findFast) && findFast) {
            return true;
        }
        return this.checkOverlapNoBorder(interval.getRight(), testInterval, results, findFast) && findFast;
    }

    public synchronized IInterval<D> getRoot() {
        return this.root;
    }

    public synchronized void setRoot(IInterval<D> root) {
        this.root = root;
    }
}

