/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.bst;

import mod.gottsch.forge.gottschcore.bst.IInterval;
import mod.gottsch.forge.gottschcore.spatial.Coords;
import mod.gottsch.forge.gottschcore.spatial.ICoords;

public class CoordsInterval<D>
implements IInterval<D> {
    public static final CoordsInterval<?> EMPTY = new CoordsInterval<Object>(new Coords(0, -999, 0), new Coords(0, -999, 0), null);
    private ICoords coords1;
    private ICoords coords2;
    private Integer min;
    private Integer max;
    private IInterval<D> left;
    private IInterval<D> right;
    private D data;

    public CoordsInterval() {
    }

    public CoordsInterval(ICoords coords1, ICoords coords2) {
        this.coords1 = coords1;
        this.coords2 = coords2;
        this.min = coords1.getX() < coords2.getX() ? coords1.getX() : coords2.getX();
        this.max = coords2.getX() > coords2.getX() ? coords1.getX() : coords2.getX();
    }

    public CoordsInterval(ICoords coords1, ICoords coords2, D data) {
        this.coords1 = coords1;
        this.coords2 = coords2;
        this.min = coords1.getX() < coords2.getX() ? coords1.getX() : coords2.getX();
        this.max = coords2.getX() > coords2.getX() ? coords1.getX() : coords2.getX();
        this.data = data;
    }

    public CoordsInterval(CoordsInterval<D> interval) {
        this.coords1 = interval.coords1;
        this.coords2 = interval.coords2;
        this.min = interval.min;
        this.max = interval.max;
        this.data = interval.data;
        this.right = interval.right;
        this.left = interval.left;
    }

    @Override
    public int compareTo(IInterval<D> intervalIn) {
        CoordsInterval interval = (CoordsInterval)intervalIn;
        if (this.getStart() < interval.getStart()) {
            return -1;
        }
        if (this.getStart() == interval.getStart()) {
            if (this.getEnd() == interval.getEnd()) {
                if (this.getStartZ() < interval.getStartZ()) {
                    return -1;
                }
                if (this.getStartZ() == interval.getStartZ()) {
                    if (this.getEndZ() == interval.getEndZ()) {
                        if (this.getStartY() < interval.getStartY()) {
                            return -1;
                        }
                        if (this.getStartY() == interval.getStartY()) {
                            if (this.getEndY() == interval.getEndY()) {
                                return 0;
                            }
                            return this.getEndY() < interval.getEndY() ? -1 : 1;
                        }
                        return 1;
                    }
                    return this.getEndZ() < interval.getEndZ() ? -1 : 1;
                }
                return 1;
            }
            return this.getEnd() < interval.getEnd() ? -1 : 1;
        }
        return 1;
    }

    public boolean isEmpty() {
        return this.coords1.equals(EMPTY.getCoords1()) || this.coords2.equals(EMPTY.getCoords2());
    }

    @Override
    public int getStart() {
        return this.coords1.getX();
    }

    @Override
    public int getEnd() {
        return this.coords2.getX();
    }

    @Override
    public Integer getMin() {
        return this.min;
    }

    @Override
    public void setMin(Integer min) {
        this.min = min;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    public void setMax(Integer max) {
        this.max = max;
    }

    @Override
    public IInterval<D> getLeft() {
        return this.left;
    }

    @Override
    public void setLeft(IInterval<D> left) {
        this.left = left;
    }

    @Override
    public IInterval<D> getRight() {
        return this.right;
    }

    @Override
    public void setRight(IInterval<D> right) {
        this.right = right;
    }

    public int getStartZ() {
        return this.coords1.getZ();
    }

    public int getEndZ() {
        return this.coords2.getZ();
    }

    public int getStartY() {
        return this.coords1.getY();
    }

    public int getEndY() {
        return this.coords2.getY();
    }

    public ICoords getCoords1() {
        return this.coords1;
    }

    public void setCoords1(ICoords coords1) {
        this.coords1 = coords1;
    }

    public ICoords getCoords2() {
        return this.coords2;
    }

    public void setCoords2(ICoords coords2) {
        this.coords2 = coords2;
    }

    @Override
    public D getData() {
        return this.data;
    }

    @Override
    public void setData(D data) {
        this.data = data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.coords1 == null ? 0 : this.coords1.hashCode());
        result = 31 * result + (this.coords2 == null ? 0 : this.coords2.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoordsInterval other = (CoordsInterval)obj;
        if (this.coords1 == null ? other.coords1 != null : !this.coords1.equals(other.coords1)) {
            return false;
        }
        return !(this.coords2 == null ? other.coords2 != null : !this.coords2.equals(other.coords2));
    }

    public String toString() {
        return "CoordsInterval [coords1=" + this.coords1 + ", coords2=" + this.coords2 + ", min=" + this.min + ", max=" + this.max + ", left=" + this.left + ", right=" + this.right + ", data=" + this.data + "]";
    }
}

