/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.block.entity;

import java.util.Optional;
import mod.gottsch.forge.gottschcore.GottschCore;
import mod.gottsch.forge.gottschcore.block.entity.AbstractProximityBlockEntity;
import mod.gottsch.forge.gottschcore.random.RandomHelper;
import mod.gottsch.forge.gottschcore.size.DoubleRange;
import mod.gottsch.forge.gottschcore.spatial.Coords;
import mod.gottsch.forge.gottschcore.spatial.ICoords;
import mod.gottsch.forge.gottschcore.world.WorldInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.DungeonHooks;
import org.apache.commons.lang3.StringUtils;

public class ProximitySpawnerBlockEntity
extends AbstractProximityBlockEntity {
    private static final String MOB_NAME = "mobName";
    private static final String MIN_MOBS = "mobNumMin";
    private static final String MAX_MOBS = "mobNumMax";
    private ResourceLocation mobName;
    private DoubleRange mobNum;

    public ProximitySpawnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ProximitySpawnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, double proximity) {
        super(type, pos, state, proximity);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        try {
            if (tag.m_128425_(MOB_NAME, 8)) {
                this.mobName = new ResourceLocation(tag.m_128461_(MOB_NAME));
            } else {
                EntityType entityType = DungeonHooks.getRandomDungeonMob((RandomSource)this.f_58857_.f_46441_);
                this.mobName = EntityType.m_20613_((EntityType)entityType);
            }
            if (this.getMobName() == null || StringUtils.isBlank((CharSequence)this.getMobName().toString())) {
                this.defaultMobSpawnerSettings();
                return;
            }
            int min = 1;
            int max = 1;
            if (tag.m_128441_(MIN_MOBS)) {
                min = tag.m_128451_(MIN_MOBS);
            }
            if (tag.m_128441_(MAX_MOBS)) {
                max = tag.m_128451_(MAX_MOBS);
            }
            this.mobNum = new DoubleRange(min, max);
        }
        catch (Exception e) {
            GottschCore.LOGGER.error("error reading ProximitySpanwerBlockEntity properties from tag:", (Throwable)e);
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.getMobName() == null || StringUtils.isBlank((CharSequence)this.getMobName().toString())) {
            this.defaultMobSpawnerSettings();
        }
        tag.m_128359_(MOB_NAME, this.getMobName().toString());
        tag.m_128405_(MIN_MOBS, this.getMobNum().getMinInt());
        tag.m_128405_(MAX_MOBS, this.getMobNum().getMaxInt());
    }

    private void defaultMobSpawnerSettings() {
        this.setMobName(new ResourceLocation("minecraft", "zombie"));
        this.setMobNum(new DoubleRange(1.0, 1.0));
        this.setProximity(5.0);
    }

    public void tickServer() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        boolean isTriggered = false;
        double proximitySq = this.getProximity() * this.getProximity();
        if (proximitySq < 1.0) {
            proximitySq = 1.0;
        }
        for (Player player : this.m_58904_().m_6907_()) {
            double distanceSq = player.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_());
            if (!isTriggered && !this.isDead() && distanceSq < proximitySq) {
                GottschCore.LOGGER.debug("proximity @ -> {} was met.", (Object)new Coords(this.m_58899_()).toShortString());
                isTriggered = true;
                GottschCore.LOGGER.debug("proximity pos -> {}", (Object)this.m_58899_());
                this.execute(this.f_58857_, this.f_58857_.m_213780_(), new Coords(this.m_58899_()), new Coords(player.m_20183_()));
            }
            if (!this.isDead()) continue;
            break;
        }
    }

    @Override
    public void execute(Level world, RandomSource random, ICoords blockCoords, ICoords playerCoords) {
        if (world.m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)world;
        Optional entityType = EntityType.m_20632_((String)this.getMobName().toString());
        if (!entityType.isPresent()) {
            GottschCore.LOGGER.debug("unable to get entityType -> {}", (Object)this.getMobName());
            this.selfDestruct();
            return;
        }
        GottschCore.LOGGER.debug("got entityType -> {}", (Object)this.getMobName());
        int count = 0;
        int numberOfMobs = RandomHelper.randomInt(random, this.getMobNum().getMinInt(), this.getMobNum().getMaxInt());
        for (int x = 0; x < numberOfMobs; ++x) {
            for (int i = 0; i < 20; ++i) {
                int spawnX = blockCoords.getX() + Mth.m_216271_((RandomSource)level.m_213780_(), (int)1, (int)2) * Mth.m_216271_((RandomSource)level.m_213780_(), (int)-1, (int)1);
                int spawnY = blockCoords.getY() + Mth.m_216271_((RandomSource)level.m_213780_(), (int)1, (int)2) * Mth.m_216271_((RandomSource)level.m_213780_(), (int)-1, (int)1);
                int spawnZ = blockCoords.getZ() + Mth.m_216271_((RandomSource)level.m_213780_(), (int)1, (int)2) * Mth.m_216271_((RandomSource)level.m_213780_(), (int)-1, (int)1);
                Coords spawnCoords = new Coords(spawnX, spawnY, spawnZ);
                boolean isSpawned = false;
                if (WorldInfo.isClientSide((Level)level)) continue;
                SpawnPlacements.Type placement = SpawnPlacements.m_21752_((EntityType)((EntityType)entityType.get()));
                if (NaturalSpawner.m_47051_((SpawnPlacements.Type)placement, (LevelReader)level, (BlockPos)spawnCoords.toPos(), (EntityType)((EntityType)entityType.get()))) {
                    Entity mob = ((EntityType)entityType.get()).m_20615_((Level)level);
                    mob.m_6034_((double)spawnX, (double)spawnY, (double)spawnZ);
                    level.m_47205_(mob);
                    isSpawned = true;
                }
                if (!isSpawned) continue;
                for (int p = 0; p < 20; ++p) {
                    double xSpeed = random.m_188583_() * 0.02;
                    double ySpeed = random.m_188583_() * 0.02;
                    double zSpeed = random.m_188583_() * 0.02;
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)spawnCoords.getX() + 0.5, (double)spawnCoords.getY(), (double)spawnCoords.getZ() + 0.5, 1, xSpeed, ySpeed, zSpeed, (double)0.15f);
                }
                if (++count >= numberOfMobs) break;
            }
            if (count >= numberOfMobs) break;
        }
        this.selfDestruct();
    }

    private void selfDestruct() {
        GottschCore.LOGGER.debug("self-destructing @ {}", (Object)this.m_58899_());
        this.setDead(true);
        this.m_58904_().m_7731_(this.m_58899_(), Blocks.f_50016_.m_49966_(), 3);
        this.m_58904_().m_46747_(this.m_58899_());
    }

    public ResourceLocation getMobName() {
        return this.mobName;
    }

    public void setMobName(ResourceLocation mobName) {
        this.mobName = mobName;
    }

    public DoubleRange getMobNum() {
        return this.mobNum;
    }

    public void setMobNum(DoubleRange mobNum) {
        this.mobNum = mobNum;
    }
}

