/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.block;

import mod.gottsch.forge.gottschcore.spatial.Coords;
import mod.gottsch.forge.gottschcore.spatial.ICoords;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class BlockContext {
    private final ICoords coords;
    private final BlockState state;

    public BlockContext(CommonLevelAccessor level, ICoords coords) {
        this.coords = coords;
        this.state = level.m_8055_(coords.toPos());
    }

    public BlockContext(CommonLevelAccessor level, BlockPos pos) {
        this(level, new Coords(pos));
    }

    public BlockContext(ICoords coords, BlockState state) {
        this.coords = coords;
        this.state = state;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public Block toBlock() {
        if (this.state != null) {
            return this.state.m_60734_();
        }
        return null;
    }

    public static Block toBlock(Level level, ICoords coords) {
        BlockState blockState = level.m_8055_(coords.toPos());
        if (blockState != null) {
            return blockState.m_60734_();
        }
        return null;
    }

    public boolean equalsBlock(Block block) {
        return this.state.m_60734_() == block;
    }

    public boolean isAir() {
        return this.state.m_60795_();
    }

    public boolean isReplaceable() {
        return this.state.m_247087_();
    }

    public boolean isSolid() {
        return this.state.m_280296_();
    }

    public boolean isFluid() {
        return !this.state.m_60819_().m_76178_();
    }

    public boolean isBurning() {
        return this.state.isBurning((BlockGetter)null, this.coords.toPos());
    }

    public boolean isLeaves() {
        return this.state.m_60734_().m_284356_() == MapColor.f_283915_ && this.state.m_278200_() && this.state.m_60811_() == PushReaction.DESTROY;
    }

    public ICoords getCoords() {
        return this.coords;
    }

    public BlockState getState() {
        return this.state;
    }
}

