/*
 * Decompiled with CFR 0.152.
 */
package mod.gottsch.forge.gottschcore.biome;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeHelper {
    public static Result isBiomeAllowed(Biome biome, List<? extends String> whiteList, List<? extends String> blackList) {
        return BiomeHelper.isBiomeAllowed(ForgeRegistries.BIOMES.getKey((Object)biome), whiteList, blackList);
    }

    public static Result isBiomeAllowed(ResourceLocation biome, List<? extends String> whiteList, List<? extends String> blackList) {
        if (whiteList != null && whiteList.size() > 0) {
            for (String string : whiteList) {
                if (!string.equals(biome.toString())) continue;
                return Result.WHITE_LISTED;
            }
            return Result.BLACK_LISTED;
        }
        if (blackList != null && blackList.size() > 0) {
            for (String string : blackList) {
                if (!string.equals(biome.toString())) continue;
                return Result.BLACK_LISTED;
            }
        }
        return Result.OK;
    }

    public static enum Result {
        OK,
        WHITE_LISTED,
        BLACK_LISTED;

    }
}

