/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.igleelib.common.client.ghostblock;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fr.iglee42.igleelib.api.utils.ModelDataUtils;
import fr.iglee42.igleelib.common.baseutils.ClientEvents;
import fr.iglee42.igleelib.common.blocks.GhostBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.model.data.ModelData;

public class GhostBlockModel
implements BakedModel {
    private static final Supplier<BlockRenderDispatcher> DISPATCHER = () -> Minecraft.m_91087_().m_91289_();
    private final BakedModel model;
    private Integer quadsNumber = null;

    public GhostBlockModel(BakedModel model) {
        this.model = model;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource random, ModelData extraData, RenderType renderType) {
        Optional<BlockState> data = ModelDataUtils.getData(extraData, GhostBlock.PS_BLOCKSTATE);
        if (!data.isPresent()) {
            return Collections.emptyList();
        }
        BlockState mirrorState = data.get();
        Optional<FluidState> dataFluid = ModelDataUtils.getData(extraData, GhostBlock.PS_FLUIDSTATE);
        FluidState fluidState = dataFluid.get();
        Supplier<List<BakedQuad>> quads = () -> this.render(fluidState, mirrorState, state, DISPATCHER.get().m_110910_(state), side, random, extraData, renderType);
        if (renderType == RenderType.m_110466_()) {
            return this.getOverlay(this.gatherAllQuads(quads));
        }
        return quads.get();
    }

    private List<BakedQuad> getOverlay(List<BakedQuad> allQuads) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(allQuads);
        this.quadsNumber = Math.toIntExact(allQuads.stream().filter(b -> !b.m_173410_().equals(ClientEvents.ghostOverlaySprite)).count());
        if (quads.size() < this.quadsNumber * 2) {
            for (BakedQuad quad : allQuads) {
                quads.add(this.generateOverlayQuad(quad));
            }
        }
        return quads;
    }

    protected List<BakedQuad> render(FluidState fluidState, @Nonnull BlockState mirrorState, @Nonnull BlockState baseState, @Nonnull BakedModel model, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(model.getQuads(mirrorState, side, rand, extraData, renderType));
        return quads;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState p_235039_, @Nullable Direction p_235040_, RandomSource p_235041_) {
        return this.model.m_213637_(p_235039_, p_235040_, p_235041_);
    }

    public boolean m_7541_() {
        return this.model.m_7541_();
    }

    public boolean useAmbientOcclusion(BlockState state) {
        return this.model.useAmbientOcclusion(state);
    }

    public boolean m_7539_() {
        return this.model.m_7539_();
    }

    public boolean m_7547_() {
        return this.model.m_7547_();
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.model.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.model.m_7343_();
    }

    public BakedQuad generateOverlayQuad(BakedQuad quad) {
        TextureAtlasSprite overlaySprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(ClientEvents.GHOST_OVERLAY_LOCATION);
        int[] data = Arrays.copyOf(quad.m_111303_(), quad.m_111303_().length);
        for (int i = 0; i < 4; ++i) {
            float ui;
            int j = DefaultVertexFormat.f_85811_.m_86017_() * i;
            float x = Float.intBitsToFloat(data[j]) + 0.001f * (float)quad.m_111306_().m_122429_();
            float y = Float.intBitsToFloat(data[j + 1]) + 0.001f * (float)quad.m_111306_().m_122430_();
            float z = Float.intBitsToFloat(data[j + 2]) + 0.001f * (float)quad.m_111306_().m_122431_();
            data[j] = Float.floatToRawIntBits(x);
            data[j + 1] = Float.floatToRawIntBits(y);
            data[j + 2] = Float.floatToRawIntBits(z);
            float vi = switch (quad.m_111306_().m_122434_()) {
                case Direction.Axis.X -> {
                    ui = z;
                    yield 1.0f - y;
                }
                default -> {
                    ui = x;
                    yield z;
                }
                case Direction.Axis.Z -> {
                    ui = x;
                    yield 1.0f - y;
                }
            };
            data[j + 4] = Float.floatToRawIntBits(overlaySprite.m_118367_((double)(ui * 16.0f)));
            data[j + 5] = Float.floatToRawIntBits(overlaySprite.m_118393_((double)(vi * 16.0f)));
            data[j + 6] = 0xF000F0;
        }
        return new BakedQuad(data, -1, quad.m_111306_(), overlaySprite, quad.m_111307_());
    }

    protected List<BakedQuad> gatherAllQuads(Supplier<List<BakedQuad>> superQuads) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>((Collection)superQuads.get());
        return quads;
    }
}

