/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.igleelib.common.blocks.entity;

import fr.iglee42.igleelib.api.utils.ModsUtils;
import fr.iglee42.igleelib.common.blocks.GhostBlock;
import fr.iglee42.igleelib.common.init.ModBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class GhostBlockEntity
extends BlockEntity {
    private BlockState stockedBlock = Blocks.f_50752_.m_49966_();
    private BlockState previousStockedBlock = Blocks.f_50752_.m_49966_();
    private int dispearTime = -1;

    public GhostBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.GHOST_BLOCK.get(), p_155229_, p_155230_);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("stockedBlock", (Tag)NbtUtils.m_129202_((BlockState)this.stockedBlock));
        tag.m_128405_("dispearTime", this.dispearTime);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (this.f_58857_ != null) {
            this.stockedBlock = NbtUtils.m_247651_((HolderGetter)this.f_58857_.m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("stockedBlock"));
        }
        this.dispearTime = tag.m_128451_("dispearTime");
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.f_58857_ != null) {
            this.stockedBlock = NbtUtils.m_247651_((HolderGetter)this.f_58857_.m_246945_(Registries.f_256747_), (CompoundTag)pkt.m_131708_().m_128469_("stockedBlock"));
        }
        this.dispearTime = pkt.m_131708_().m_128451_("dispearTime");
    }

    @NotNull
    public ModelData getModelData() {
        if (this.f_58859_) {
            super.getModelData();
        }
        ModelData.Builder builder = ModelData.builder().with(GhostBlock.PS_BLOCKSTATE, (Object)this.stockedBlock).with(GhostBlock.PS_FLUIDSTATE, (Object)this.stockedBlock.m_60819_());
        return builder.build();
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_ && this.previousStockedBlock != this.stockedBlock) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            ModsUtils.placeGhostBlock((ServerLevel)level, pos, this.stockedBlock, this.dispearTime);
        }
        if (this.dispearTime > 0) {
            --this.dispearTime;
        }
        if (this.dispearTime == 0) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    public BlockState getStockedBlock() {
        return this.stockedBlock;
    }

    public void setStockedBlock(BlockState stockedBlock) {
        this.stockedBlock = stockedBlock;
    }

    public void setDispearTime(int time) {
        this.dispearTime = time;
    }
}

