/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.igleelib.api.utils;

import com.google.gson.JsonObject;
import fr.iglee42.igleelib.api.utils.DefaultParameter;
import fr.iglee42.igleelib.api.utils.ModsUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonHelper {
    public static boolean getBoolean(JsonObject json, String name) {
        return json.get(name).getAsBoolean();
    }

    public static String getString(JsonObject json, String name) {
        return json.get(name).getAsString();
    }

    public static int getInt(JsonObject json, String name) {
        return json.get(name).getAsInt();
    }

    public static Item getItem(JsonObject json, String name) {
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(it[0], it[1]));
    }

    public static Block getBlock(JsonObject json, String name) {
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(it[0], it[1]));
    }

    public static EntityType<?> getEntityType(JsonObject json, String name) {
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(it[0], it[1]));
    }

    public static Enchantment getEnchantment(JsonObject json, String name) {
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(it[0], it[1]));
    }

    public static boolean getBooleanOrDefault(JsonObject json, String name, boolean def) {
        if (!json.has(name)) {
            return def;
        }
        return json.get(name).getAsBoolean();
    }

    public static String getStringOrDefault(JsonObject json, String name, String def) {
        if (!json.has(name)) {
            return def;
        }
        return json.get(name).getAsString();
    }

    public static int getIntOrDefault(JsonObject json, String name, int def) {
        if (!json.has(name)) {
            return def;
        }
        return json.get(name).getAsInt();
    }

    public static Item getItemOrDefault(JsonObject json, String name, Item def) {
        if (!json.has(name)) {
            return def;
        }
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(it[0], it[1]));
    }

    public static Block getBlockOrDefault(JsonObject json, String name, Block def) {
        if (!json.has(name)) {
            return def;
        }
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(it[0], it[1]));
    }

    public static EntityType<?> getEntityTypeOrDefault(JsonObject json, String name, EntityType<?> def) {
        if (!json.has(name)) {
            return def;
        }
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(it[0], it[1]));
    }

    public static Enchantment getEnchantmentOrDefault(JsonObject json, String name, Enchantment def) {
        if (!json.has(name)) {
            return def;
        }
        String[] it = ModsUtils.split(JsonHelper.getString(json, name), ":");
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(it[0], it[1]));
    }

    public static <O extends Record> O createRecordFromJson(Class<O> recordClass, JsonObject json) {
        try {
            ArrayList<Object> args = new ArrayList<Object>();
            ArrayList classes = new ArrayList();
            for (RecordComponent components : recordClass.getRecordComponents()) {
                if (Integer.class.equals(components.getType()) || Integer.TYPE.equals(components.getType())) {
                    if (components.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getIntOrDefault(json, components.getName(), components.getAnnotation(DefaultParameter.class).intValue()));
                    } else {
                        args.add(JsonHelper.getInt(json, components.getName()));
                    }
                    classes.add(components.getType());
                    continue;
                }
                if (String.class.equals(components.getType())) {
                    if (components.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getStringOrDefault(json, components.getName(), components.getAnnotation(DefaultParameter.class).stringValue()));
                    } else {
                        args.add(JsonHelper.getString(json, components.getName()));
                    }
                    classes.add(components.getType());
                    continue;
                }
                if (Boolean.class.equals(components.getType()) || Boolean.TYPE.equals(components.getType())) {
                    if (components.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getBooleanOrDefault(json, components.getName(), components.getAnnotation(DefaultParameter.class).booleanValue()));
                    } else {
                        args.add(JsonHelper.getBoolean(json, components.getName()));
                    }
                    classes.add(components.getType());
                    continue;
                }
                if (Item.class.equals(components.getType())) {
                    if (components.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getItemOrDefault(json, components.getName(), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(components.getAnnotation(DefaultParameter.class).itemValue()))));
                    } else {
                        args.add(JsonHelper.getItem(json, components.getName()));
                    }
                    classes.add(components.getType());
                    continue;
                }
                if (Block.class.equals(components.getType())) {
                    if (components.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getBlockOrDefault(json, components.getName(), (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(components.getAnnotation(DefaultParameter.class).blockValue()))));
                    } else {
                        args.add(JsonHelper.getBlock(json, components.getName()));
                    }
                    classes.add(components.getType());
                    continue;
                }
                if (EntityType.class.equals(components.getType())) {
                    if (components.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getEntityTypeOrDefault(json, components.getName(), (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(components.getAnnotation(DefaultParameter.class).entityTypeValue()))));
                    } else {
                        args.add(JsonHelper.getEntityType(json, components.getName()));
                    }
                    classes.add(components.getType());
                    continue;
                }
                if (Enchantment.class.equals(components.getType())) {
                    if (components.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(JsonHelper.getEnchantmentOrDefault(json, components.getName(), (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(components.getAnnotation(DefaultParameter.class).enchantmentValue()))));
                    } else {
                        args.add(JsonHelper.getEnchantment(json, components.getName()));
                    }
                    classes.add(components.getType());
                    continue;
                }
                if (ResourceLocation.class.equals(components.getType())) {
                    if (components.isAnnotationPresent(DefaultParameter.class)) {
                        args.add(ResourceLocation.m_135820_((String)JsonHelper.getStringOrDefault(json, components.getName(), components.getAnnotation(DefaultParameter.class).stringValue())));
                    } else {
                        args.add(ResourceLocation.m_135820_((String)JsonHelper.getString(json, components.getName())));
                    }
                    classes.add(components.getType());
                    continue;
                }
                throw new IllegalArgumentException("The parameter type is not supported !");
            }
            return (O)((Record)recordClass.getConstructor(classes.toArray(new Class[0])).newInstance(args.toArray(new Object[0])));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

