/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.caveopolis.util;

import com.benbenlaw.caveopolis.Caveopolis;
import com.benbenlaw.caveopolis.block.ModBlocks;
import com.benbenlaw.caveopolis.block.custom.ColoredCavesPortalBlock;
import com.benbenlaw.caveopolis.block.entity.ColoredCavesPortalBlockEntity;
import com.benbenlaw.caveopolis.util.ModTags;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ColoredCavesTeleporter
implements ITeleporter {
    public static BlockPos thisPos = BlockPos.f_121853_;
    public static boolean insideDimension = true;

    public ColoredCavesTeleporter(BlockPos pos, boolean insideDim) {
        thisPos = pos;
        insideDimension = insideDim;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destinationWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        entity = repositionEntity.apply(false);
        if (!(entity instanceof ServerPlayer)) {
            return entity;
        }
        ServerPlayer player = (ServerPlayer)entity;
        LevelChunk chunk = (LevelChunk)destinationWorld.m_46865_(thisPos);
        Vec3 spawnPos = this.findPortalInChunk(chunk);
        if (spawnPos == null) {
            player.m_213846_((Component)Component.m_237113_((String)"No Previous portal discovered in chunk"));
            ResourceKey coloredCavesDim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("caveopolis", "colored_caves"));
            spawnPos = destinationWorld.m_46472_().equals((Object)coloredCavesDim) ? this.placeTeleporterColoredCaves(destinationWorld, chunk) : this.placeTeleporterOverworld(destinationWorld, chunk);
        }
        if (spawnPos == null) {
            return entity;
        }
        player.m_6021_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        return entity;
    }

    private Vec3 placeTeleporterColoredCaves(ServerLevel level, LevelChunk chunk) {
        int z;
        int x;
        int y;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int min = level.m_141937_();
        int max = level.m_151558_();
        for (y = min; y < max - 1; ++y) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    pos.m_122178_(x, y, z);
                    if (!chunk.m_8055_((BlockPos)pos).m_60795_() || !chunk.m_8055_(pos.m_6630_(1)).m_60795_() || !chunk.m_8055_(pos.m_6630_(2)).m_60795_()) continue;
                    BlockPos absolutePos = chunk.m_7697_().m_45615_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    level.m_46597_(absolutePos, ((Block)ModBlocks.COLORED_CAVES_PORTAL.get()).m_49966_());
                    return new Vec3((double)absolutePos.m_123341_() + 0.5, (double)(absolutePos.m_123342_() + 1), (double)absolutePos.m_123343_() + 0.5);
                }
            }
        }
        for (y = min; y < max - 1; ++y) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    BlockPos absolutePos;
                    pos.m_122178_(x, y, z);
                    if (!this.isAirOrStone(chunk, (BlockPos)pos) || !this.isAirOrStone(chunk, pos.m_6630_(1)) || !this.isAirOrStone(chunk, pos.m_6630_(2)) || !this.isReplaceable((Level)level, (absolutePos = chunk.m_7697_().m_45615_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())).m_6630_(3)) || !this.isReplaceable((Level)level, absolutePos.m_6630_(1).m_121945_(Direction.NORTH)) || !this.isReplaceable((Level)level, absolutePos.m_6630_(1).m_121945_(Direction.NORTH)) || !this.isReplaceable((Level)level, absolutePos.m_6630_(1).m_121945_(Direction.SOUTH)) || !this.isReplaceable((Level)level, absolutePos.m_6630_(1).m_121945_(Direction.EAST)) || !this.isReplaceable((Level)level, absolutePos.m_6630_(1).m_121945_(Direction.WEST)) || !this.isReplaceable((Level)level, absolutePos.m_6630_(2).m_121945_(Direction.NORTH)) || !this.isReplaceable((Level)level, absolutePos.m_6630_(2).m_121945_(Direction.SOUTH)) || !this.isReplaceable((Level)level, absolutePos.m_6630_(2).m_121945_(Direction.EAST)) || !this.isReplaceable((Level)level, absolutePos.m_6630_(2).m_121945_(Direction.WEST))) continue;
                    level.m_46597_(absolutePos, ((Block)ModBlocks.COLORED_CAVES_PORTAL.get()).m_49966_());
                    level.m_46597_(absolutePos.m_6630_(1), Blocks.f_50016_.m_49966_());
                    level.m_46597_(absolutePos.m_6630_(2), Blocks.f_50016_.m_49966_());
                    level.m_46597_(absolutePos.m_6630_(3), Blocks.f_50069_.m_49966_());
                    level.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.NORTH), Blocks.f_50069_.m_49966_());
                    level.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.SOUTH), Blocks.f_50069_.m_49966_());
                    level.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.EAST), Blocks.f_50069_.m_49966_());
                    level.m_46597_(absolutePos.m_6630_(1).m_121945_(Direction.WEST), Blocks.f_50069_.m_49966_());
                    level.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.NORTH), Blocks.f_50069_.m_49966_());
                    level.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.SOUTH), Blocks.f_50069_.m_49966_());
                    level.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.EAST), Blocks.f_50069_.m_49966_());
                    level.m_46597_(absolutePos.m_6630_(2).m_121945_(Direction.WEST), Blocks.f_50069_.m_49966_());
                    return new Vec3((double)absolutePos.m_123341_() + 0.5, (double)(absolutePos.m_123342_() + 1), (double)absolutePos.m_123343_() + 0.5);
                }
            }
        }
        return null;
    }

    private boolean isAirOrStone(LevelChunk chunk, BlockPos pos) {
        BlockState state = chunk.m_8055_(pos);
        return state.m_60713_(Blocks.f_50069_) || state.m_60795_() || state.m_204336_(ModTags.Blocks.COLORED_STONE);
    }

    private boolean isReplaceable(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60734_().equals(Blocks.f_50069_) || state.m_60734_().equals(Blocks.f_50122_) || state.m_60734_().equals(Blocks.f_50334_) || state.m_60734_().equals(Blocks.f_50228_) || state.m_60734_().equals(Blocks.f_50493_) || state.m_60734_().equals(Blocks.f_49994_) || state.m_60734_().equals(Blocks.f_49991_) || state.m_60734_().m_49966_().m_204336_(ModTags.Blocks.COLORED_STONE) || state.m_60795_();
    }

    private @Nullable Vec3 findPortalInChunk(LevelChunk chunk) {
        for (Map.Entry entry : chunk.m_62954_().entrySet()) {
            BlockState blockState;
            BlockPos pos = (BlockPos)entry.getKey();
            BlockEntity blockEntity = (BlockEntity)entry.getValue();
            if (!(blockEntity instanceof ColoredCavesPortalBlockEntity) || !((blockState = chunk.m_8055_(pos)).m_60734_() instanceof ColoredCavesPortalBlock)) continue;
            Vec3 portalPosition = ColoredCavesTeleporter.getTeleporterSpawnPos(chunk.m_62953_(), pos);
            Caveopolis.LOGGER.info("Found ColoredCavesPortalBlock at {} with position {}", (Object)pos, (Object)portalPosition);
            return portalPosition;
        }
        return null;
    }

    private static Vec3 getTeleporterSpawnPos(Level level, BlockPos pos) {
        BlockPos dismountPos = ColoredCavesTeleporter.findSuitableDismountLocation(level, pos);
        if (dismountPos != null) {
            return new Vec3((double)dismountPos.m_123341_() + 0.5, (double)(dismountPos.m_123342_() + 1), (double)dismountPos.m_123343_() + 0.5);
        }
        return null;
    }

    private static BlockPos findSuitableDismountLocation(Level level, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        if (level.m_46859_(abovePos)) {
            return abovePos;
        }
        return null;
    }

    private Vec3 placeTeleporterOverworld(ServerLevel world, LevelChunk chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = world.m_151558_(); y >= world.m_141937_(); --y) {
                    pos.m_122178_(x, y, z);
                    if (!chunk.m_8055_((BlockPos)pos).m_60795_() || !chunk.m_8055_(pos.m_6630_(1)).m_60795_() || !chunk.m_8055_(pos.m_6630_(2)).m_60795_() || chunk.m_8055_(pos.m_7495_()).m_60795_()) continue;
                    BlockPos absolutePos = chunk.m_7697_().m_45615_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    world.m_46597_(absolutePos, ((Block)ModBlocks.COLORED_CAVES_PORTAL.get()).m_49966_());
                    return new Vec3((double)absolutePos.m_123341_() + 0.5, (double)(absolutePos.m_123342_() + 1), (double)absolutePos.m_123343_() + 0.5);
                }
            }
        }
        return null;
    }
}

