/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.caveopolis.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class SprayerRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public SprayerRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        return ((Ingredient)this.recipeItems.get(0)).test(pContainer.m_8020_(0)) && ((Ingredient)this.recipeItems.get(1)).test(pContainer.m_8020_(1));
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer pContainer, @NotNull RegistryAccess p_267165_) {
        return this.output;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess p_267052_) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<SprayerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("caveopolis", "sprayer");

        public SprayerRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)2, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new SprayerRecipe(pRecipeId, output, (NonNullList<Ingredient>)inputs);
        }

        public @Nullable SprayerRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack output = buf.m_130267_();
            return new SprayerRecipe(id, output, (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(FriendlyByteBuf buf, SprayerRecipe recipe) {
            buf.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.writeItemStack(recipe.output, false);
        }
    }

    public static class Type
    implements RecipeType<SprayerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "sprayer";

        private Type() {
        }
    }
}

