/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.caveopolis.data.custom;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SprayerRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Item result;
    private final Ingredient ingredient;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @javax.annotation.Nullable
    private String group;
    private final RecipeSerializer<? extends AbstractCookingRecipe> serializer;

    private SprayerRecipeBuilder(RecipeCategory category, ItemLike result, Ingredient ingredient, RecipeSerializer<? extends AbstractCookingRecipe> serializer) {
        this.category = category;
        this.result = result.m_5456_();
        this.ingredient = ingredient;
        this.serializer = serializer;
    }

    public static SprayerRecipeBuilder sprayerRecipe(Ingredient ingredient, RecipeCategory category, ItemLike result, RecipeSerializer<? extends AbstractCookingRecipe> serializer) {
        return new SprayerRecipeBuilder(category, result, ingredient, serializer);
    }

    public RecipeBuilder m_126132_(String p_176496_, CriterionTriggerInstance p_176497_) {
        this.advancement.m_138386_(p_176496_, p_176497_);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String p_176495_) {
        this.group = p_176495_;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    private void ensureValid(ResourceLocation p_126266_) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126266_);
        }
    }

    public void m_126140_(Consumer<FinishedRecipe> p_126263_, ResourceLocation p_126264_) {
        this.ensureValid(p_126264_);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_126264_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_126264_)).m_138360_(RequirementsStrategy.f_15979_);
        p_126263_.accept(new Result(p_126264_, this.group == null ? "" : this.group, this.ingredient, this.result, this.advancement, p_126264_.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.serializer));
    }

    static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Item result;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<? extends AbstractCookingRecipe> serializer;

        public Result(ResourceLocation id, String group, Ingredient ingredient, Item result, Advancement.Builder p_249151_, ResourceLocation advancementId, RecipeSerializer<? extends AbstractCookingRecipe> serializer) {
            this.id = id;
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.advancement = p_249151_;
            this.advancementId = advancementId;
            this.serializer = serializer;
        }

        public void m_7917_(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            jsonObject.add("ingredient", this.ingredient.m_43942_());
            jsonObject.addProperty("result", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @javax.annotation.Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @javax.annotation.Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

