/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.caveopolis.block.entity;

import com.benbenlaw.caveopolis.block.entity.ModBlockEntities;
import com.benbenlaw.caveopolis.networking.ModMessages;
import com.benbenlaw.caveopolis.networking.packets.PacketSyncItemStackToClient;
import com.benbenlaw.caveopolis.recipe.SprayerRecipe;
import com.benbenlaw.caveopolis.screen.SprayerMenu;
import com.benbenlaw.caveopolis.util.ModTags;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import com.benbenlaw.opolisutilities.util.inventory.WrappedHandler;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SprayerBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            SprayerBlockEntity.this.m_6596_();
            assert (SprayerBlockEntity.this.f_58857_ != null);
            if (!SprayerBlockEntity.this.f_58857_.m_5776_()) {
                ModMessages.sendToClients(new PacketSyncItemStackToClient(this, SprayerBlockEntity.this.f_58858_));
            }
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> i == 2, (i, s) -> false)), Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 1, (index, stack) -> {
        if (index == 0 && this.itemHandler.isItemValid(0, stack)) {
            return stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.SPRAY_CANS.equals(arg_0));
        }
        if (index == 1 && this.itemHandler.isItemValid(1, stack)) {
            return !stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.SPRAY_CANS.equals(arg_0));
        }
        return false;
    })), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 1, (index, stack) -> {
        if (index == 0 && this.itemHandler.isItemValid(0, stack)) {
            return stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.SPRAY_CANS.equals(arg_0));
        }
        if (index == 1 && this.itemHandler.isItemValid(1, stack)) {
            return !stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.SPRAY_CANS.equals(arg_0));
        }
        return false;
    })), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 1, (index, stack) -> {
        if (index == 0 && this.itemHandler.isItemValid(0, stack)) {
            return stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.SPRAY_CANS.equals(arg_0));
        }
        if (index == 1 && this.itemHandler.isItemValid(1, stack)) {
            return !stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.SPRAY_CANS.equals(arg_0));
        }
        return false;
    })), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 1, (index, stack) -> {
        if (index == 0 && this.itemHandler.isItemValid(0, stack)) {
            return stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.SPRAY_CANS.equals(arg_0));
        }
        if (index == 1 && this.itemHandler.isItemValid(1, stack)) {
            return !stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.SPRAY_CANS.equals(arg_0));
        }
        return false;
    })), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, index -> index == 1, (index, stack) -> {
        if (index == 0 && this.itemHandler.isItemValid(0, stack)) {
            return stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.SPRAY_CANS.equals(arg_0));
        }
        if (index == 1 && this.itemHandler.isItemValid(1, stack)) {
            return !stack.m_204131_().anyMatch(arg_0 -> ModTags.Items.SPRAY_CANS.equals(arg_0));
        }
        return false;
    })));
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> SprayerBlockEntity.this.progress;
                case 1 -> SprayerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    SprayerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    SprayerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 10;

    public void setHandler(ItemStackHandler handler) {
        this.copyHandlerContents(handler);
    }

    private void copyHandlerContents(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public SprayerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SPRAYER.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Sprayer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new SprayerMenu(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.directionWrappedHandlerMap.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        for (Direction dir : Direction.values()) {
            if (!this.directionWrappedHandlerMap.containsKey(dir)) continue;
            this.directionWrappedHandlerMap.get(dir).invalidate();
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("sprayer.progress", this.progress);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("sprayer.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void tick() {
        Level pLevel = this.f_58857_;
        BlockPos pPos = this.f_58858_;
        BlockState state = this.m_58900_();
        SprayerBlockEntity pEntity = this;
        if (this.hasRecipe(pEntity)) {
            ++pEntity.progress;
            SprayerBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)pPos, (BlockState)state);
            if (pEntity.progress >= pEntity.maxProgress) {
                this.craftItem(pEntity);
            }
        } else {
            pEntity.resetProgress();
            SprayerBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)pPos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem(SprayerBlockEntity pEntity) {
        Level level = pEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(pEntity.itemHandler.getSlots());
        for (int i = 0; i < pEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, pEntity.itemHandler.getStackInSlot(i));
        }
        Optional sprayerRecipe = level.m_7465_().m_44015_((RecipeType)SprayerRecipe.Type.INSTANCE, (Container)inventory, level);
        if (sprayerRecipe.isPresent()) {
            pEntity.itemHandler.extractItem(1, 1, false);
            assert (Minecraft.m_91087_().f_91073_ != null);
            pEntity.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)((SprayerRecipe)sprayerRecipe.get()).m_8043_(Objects.requireNonNull(this.m_58904_()).m_9598_()).m_41720_(), pEntity.itemHandler.getStackInSlot(2).m_41613_() + 1));
            if (pEntity.itemHandler.getStackInSlot(0).m_220157_(1, RandomSource.m_216327_(), null)) {
                pEntity.itemHandler.extractItem(0, 1, false);
            }
            pEntity.resetProgress();
        }
    }

    private boolean hasRecipe(SprayerBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        assert (level != null);
        Optional sprayerRecipe = level.m_7465_().m_44015_((RecipeType)SprayerRecipe.Type.INSTANCE, (Container)inventory, level);
        return sprayerRecipe.filter(sprayerRecipeCheck -> {
            if (!(this.hasMakingItem(entity, (SprayerRecipe)sprayerRecipe.get()) && this.hasSprayCan(entity, (SprayerRecipe)sprayerRecipe.get()) && this.canInsertAmountIntoOutputSlot(inventory))) {
                return false;
            }
            assert (Minecraft.m_91087_().f_91073_ != null);
            return this.canInsertItemIntoOutputSlot(inventory, sprayerRecipeCheck.m_8043_(Objects.requireNonNull(this.m_58904_()).m_9598_()));
        }).isPresent();
    }

    private boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack stack) {
        return inventory.m_8020_(2).m_41720_() == stack.m_41720_() || inventory.m_8020_(2).m_41619_();
    }

    private boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.m_8020_(2).m_41741_() > inventory.m_8020_(2).m_41613_();
    }

    private boolean hasSprayCan(SprayerBlockEntity entity, SprayerRecipe recipe) {
        return ((Ingredient)recipe.m_7527_().get(0)).test(entity.itemHandler.getStackInSlot(0));
    }

    private boolean hasMakingItem(SprayerBlockEntity entity, SprayerRecipe recipe) {
        return ((Ingredient)recipe.m_7527_().get(1)).test(entity.itemHandler.getStackInSlot(1));
    }
}

