/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.caveopolis.block.custom.brightblock;

import com.benbenlaw.caveopolis.block.custom.brightblock.Brightable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrightStairBlock
extends StairBlock
implements Brightable {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    public BrightStairBlock(BlockState p_56862_, BlockBehaviour.Properties p_56863_) {
        super(p_56862_, p_56863_);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_55484_) {
        p_55484_.m_61104_(new Property[]{LIT, FACING, HALF, SHAPE, WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_56872_) {
        Direction direction = p_56872_.m_43719_();
        BlockPos blockpos = p_56872_.m_8083_();
        FluidState fluidstate = p_56872_.m_43725_().m_6425_(blockpos);
        BlockState blockstate = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)p_56872_.m_8125_())).m_61124_(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && p_56872_.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? Half.BOTTOM : Half.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return (BlockState)((BlockState)blockstate.m_61124_(SHAPE, (Comparable)BrightStairBlock.getStairsShape(blockstate, (BlockGetter)p_56872_.m_43725_(), blockpos))).m_61124_((Property)LIT, (Comparable)Boolean.FALSE);
    }

    private static StairsShape getStairsShape(BlockState p_56977_, BlockGetter p_56978_, BlockPos p_56979_) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)p_56977_.m_61143_((Property)FACING);
        BlockState blockstate = p_56978_.m_8055_(p_56979_.m_121945_(direction));
        if (BrightStairBlock.m_56980_((BlockState)blockstate) && p_56977_.m_61143_(HALF) == blockstate.m_61143_(HALF) && (direction1 = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != ((Direction)p_56977_.m_61143_((Property)FACING)).m_122434_() && BrightStairBlock.canTakeShape(p_56977_, p_56978_, p_56979_, direction1.m_122424_())) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = p_56978_.m_8055_(p_56979_.m_121945_(direction.m_122424_()));
        if (BrightStairBlock.m_56980_((BlockState)blockstate1) && p_56977_.m_61143_(HALF) == blockstate1.m_61143_(HALF) && (direction2 = (Direction)blockstate1.m_61143_((Property)FACING)).m_122434_() != ((Direction)p_56977_.m_61143_((Property)FACING)).m_122434_() && BrightStairBlock.canTakeShape(p_56977_, p_56978_, p_56979_, direction2)) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(BlockState p_56971_, BlockGetter p_56972_, BlockPos p_56973_, Direction p_56974_) {
        BlockState blockstate = p_56972_.m_8055_(p_56973_.m_121945_(p_56974_));
        return !BrightStairBlock.m_56980_((BlockState)blockstate) || blockstate.m_61143_((Property)FACING) != p_56971_.m_61143_((Property)FACING) || blockstate.m_61143_(HALF) != p_56971_.m_61143_(HALF);
    }

    public VoxelShape m_5940_(BlockState p_56956_, BlockGetter p_56957_, BlockPos p_56958_, CollisionContext p_56959_) {
        return (p_56956_.m_61143_(HALF) == Half.TOP ? f_56855_ : f_56856_)[SHAPE_BY_STATE[this.getShapeIndex(p_56956_)]];
    }

    private int getShapeIndex(BlockState p_56983_) {
        return ((StairsShape)p_56983_.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)p_56983_.m_61143_((Property)FACING)).m_122416_();
    }

    @NotNull
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }
}

