/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.crafttweaker.handlers;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStackMutable;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.integration.crafttweaker.handlers.RecipeHandlerUtils;

@IRecipeHandler.For(value=CookingPotRecipe.class)
public final class CookingPotRecipeHandler
implements IRecipeHandler<CookingPotRecipe> {
    public String dumpToCommandString(IRecipeManager manager, CookingPotRecipe recipe) {
        Object[] objectArray = new Object[7];
        objectArray[0] = manager.getCommandString();
        objectArray[1] = StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_());
        objectArray[2] = IItemStack.of((ItemStack)((ItemStack)AccessibleElementsProvider.get().registryAccess(recipe::m_8043_))).getCommandString();
        objectArray[3] = recipe.m_7527_().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]"));
        objectArray[4] = new MCItemStackMutable(recipe.getOutputContainer()).getCommandString();
        objectArray[5] = Float.valueOf(recipe.getExperience());
        objectArray[6] = recipe.getCookTime();
        return String.format("%s.addRecipe(%s, %s, %s, %s, %s, %s);", objectArray);
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super CookingPotRecipe> manager, CookingPotRecipe firstRecipe, U secondRecipe) {
        return firstRecipe.equals(secondRecipe);
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super CookingPotRecipe> manager, CookingPotRecipe recipe) {
        IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Output.ITEMS, (Object)IItemStack.of((ItemStack)((ItemStack)AccessibleElementsProvider.get().registryAccess(recipe::m_8043_)))).with(BuiltinRecipeComponents.Input.INGREDIENTS, recipe.m_7527_().stream().map(IIngredient::fromIngredient).toList()).with(BuiltinRecipeComponents.Processing.TIME, (Object)recipe.getCookTime()).with(BuiltinRecipeComponents.Metadata.GROUP, (Object)recipe.m_6076_()).with(RecipeHandlerUtils.CONTAINER_COMPONENT, (Object)new MCItemStackMutable(recipe.getOutputContainer())).with(BuiltinRecipeComponents.Output.EXPERIENCE, (Object)Float.valueOf(recipe.getExperience())).build();
        if (recipe.getRecipeBookTab() != null) {
            decomposedRecipe.set(RecipeHandlerUtils.COOKING_TAB_COMPONENT, (Object)recipe.getRecipeBookTab().name());
        }
        return Optional.of(decomposedRecipe);
    }

    public Optional<CookingPotRecipe> recompose(IRecipeManager<? super CookingPotRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        IItemStack output = (IItemStack)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        List ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        NonNullList inputList = NonNullList.m_122779_();
        for (IIngredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            inputList.add((Object)ingredient.asVanillaIngredient());
        }
        int time = (Integer)recipe.getOrThrowSingle(BuiltinRecipeComponents.Processing.TIME);
        String group = (String)recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP);
        IItemStack container = (IItemStack)recipe.getOrThrowSingle(RecipeHandlerUtils.CONTAINER_COMPONENT);
        float exp = ((Float)recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.EXPERIENCE)).floatValue();
        List cookingRecipeBookTabList = recipe.get(RecipeHandlerUtils.COOKING_TAB_COMPONENT);
        CookingPotRecipeBookTab cookTab = cookingRecipeBookTabList == null ? null : CookingPotRecipeBookTab.valueOf((String)cookingRecipeBookTabList.get(0));
        return Optional.of(new CookingPotRecipe(name, group, cookTab, (NonNullList<Ingredient>)inputList, output.getInternal(), container.getInternal(), exp, time));
    }
}

