/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.network;

import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SPipeBubblesStatePacket {
    public final BlockPos pos;
    public final boolean hasPipeBubbles;

    public SPipeBubblesStatePacket(BlockPos pos, Boolean hasPipeBubbles) {
        this.pos = pos;
        this.hasPipeBubbles = hasPipeBubbles;
    }

    public SPipeBubblesStatePacket(FriendlyByteBuf buffer) {
        this(buffer.m_130135_(), buffer.readBoolean());
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.pos != null) {
            buffer.m_130064_(this.pos);
            buffer.writeBoolean(this.hasPipeBubbles);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            Level world = player.m_9236_();
            BlockEntity blockEntity = world.m_7702_(this.pos);
            if (blockEntity instanceof WarpPipeBlockEntity) {
                this.changeState(player, (WarpPipeBlockEntity)blockEntity);
                ((WarpPipeBlockEntity)blockEntity).sendData();
                blockEntity.m_6596_();
            }
        });
    }

    public void changeState(ServerPlayer player, WarpPipeBlockEntity pipeBlockEntity) {
        Level world = pipeBlockEntity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = pipeBlockEntity.m_58899_();
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof WarpPipeBlock)) {
            return;
        }
        pipeBlockEntity.togglePipeBubbles(player);
    }

    public static SPipeBubblesStatePacket pipeBubblesOn(BlockPos pos, Boolean hasPipeBubbles) {
        SPipeBubblesStatePacket packet = new SPipeBubblesStatePacket(pos, hasPipeBubbles);
        hasPipeBubbles = false;
        return packet;
    }

    public static SPipeBubblesStatePacket pipeBubblesOff(BlockPos pos, Boolean hasPipeBubbles) {
        SPipeBubblesStatePacket packet = new SPipeBubblesStatePacket(pos, hasPipeBubbles);
        hasPipeBubbles = true;
        return packet;
    }
}

