/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.network;

import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class SPipeBubblesSliderPacket {
    public final BlockPos pos;
    public final int bubblesDistance;

    public SPipeBubblesSliderPacket(BlockPos pos, int bubblesDistance) {
        this.pos = pos;
        this.bubblesDistance = bubblesDistance;
    }

    public SPipeBubblesSliderPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130135_(), buffer.readInt());
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.pos != null) {
            buffer.m_130064_(this.pos);
            buffer.writeInt(this.bubblesDistance);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            Level world = player.m_9236_();
            BlockEntity blockEntity = world.m_7702_(this.pos);
            if (blockEntity instanceof WarpPipeBlockEntity) {
                WarpPipeBlockEntity pipeBlockEntity = (WarpPipeBlockEntity)blockEntity;
                this.changeDistance(player, (WarpPipeBlockEntity)blockEntity);
                pipeBlockEntity.sendData();
            }
        });
    }

    public void changeDistance(ServerPlayer player, WarpPipeBlockEntity pipeBlockEntity) {
        Level world = pipeBlockEntity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = pipeBlockEntity.m_58899_();
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof WarpPipeBlock)) {
            return;
        }
        pipeBlockEntity.bubblesDistance(player, this.bubblesDistance);
    }
}

